/*
 * Decompiled with CFR 0.152.
 */
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Queue;
import processing.core.PApplet;
import processing.core.PGraphics;
import processing.core.PImage;

public class wfc01
extends PApplet {
    PImage pattern;
    int[][] inputGrid;
    int[][] outputGrid;
    ArrayList<Tile> tiles = new ArrayList();
    int tileWidth = 3;
    int tileHeight = 3;
    int[][] explosionRange;
    boolean complete = false;

    public void setup() {
        this.pattern = this.loadImage("pattern.png");
        this.pattern.loadPixels();
        this.analyzePattern();
        this.initializeOutputGrid();
        this.frameRate(100.0f);
    }

    public void analyzePattern() {
        int inputGridWidth = wfc01.ceil((float)this.pattern.width);
        int inputGridHeight = wfc01.ceil((float)this.pattern.height);
        this.inputGrid = new int[inputGridWidth][inputGridHeight];
        PGraphics doubledPattern = this.createGraphics(this.pattern.width + this.tileWidth, this.pattern.height + this.tileHeight);
        doubledPattern.beginDraw();
        doubledPattern.image(this.pattern, 0.0f, 0.0f);
        doubledPattern.image(this.pattern, 0.0f, (float)this.pattern.height);
        doubledPattern.image(this.pattern, (float)this.pattern.width, 0.0f);
        doubledPattern.image(this.pattern, (float)this.pattern.width, (float)this.pattern.height);
        doubledPattern.endDraw();
        int x = 0;
        while (x < this.pattern.width) {
            int y = 0;
            while (y < this.pattern.height) {
                PImage thisTile = doubledPattern.get(x, y, this.tileWidth, this.tileHeight);
                boolean found = false;
                int i = 0;
                while (i < this.tiles.size()) {
                    if (this.tiles.get(i).imageEquals(thisTile)) {
                        this.inputGrid[x][y] = i;
                        found = true;
                        break;
                    }
                    ++i;
                }
                if (!found) {
                    Tile newTile = new Tile(thisTile);
                    newTile.index = this.tiles.size();
                    newTile.frequency = 1;
                    this.tiles.add(newTile);
                    this.inputGrid[x][y] = newTile.index;
                } else {
                    ++this.tiles.get((int)this.inputGrid[x][y]).frequency;
                }
                ++y;
            }
            ++x;
        }
        for (Tile tile : this.tiles) {
            tile.adjacencies = new ArrayList[4];
            tile.frequencies = new ArrayList[4];
            int i = 0;
            while (i < 4) {
                tile.adjacencies[i] = new ArrayList();
                tile.frequencies[i] = new ArrayList();
                ++i;
            }
        }
        x = 0;
        while (x < inputGridWidth) {
            int y = 0;
            while (y < inputGridHeight) {
                int tileIndex = this.inputGrid[x][y];
                this.updateAdjacencyWithFrequency(x, y - this.tileHeight, tileIndex, 0);
                this.updateAdjacencyWithFrequency(x + this.tileWidth, y, tileIndex, 1);
                this.updateAdjacencyWithFrequency(x, y + this.tileHeight, tileIndex, 2);
                this.updateAdjacencyWithFrequency(x - this.tileWidth, y, tileIndex, 3);
                ++y;
            }
            ++x;
        }
        for (Tile tile : this.tiles) {
            int i = 0;
            while (i < 4) {
                HashSet<Integer> unique = new HashSet<Integer>(tile.adjacencies[i]);
                tile.adjacencies[i].clear();
                tile.adjacencies[i].addAll(unique);
                while (tile.frequencies[i].size() < tile.adjacencies[i].size()) {
                    tile.frequencies[i].add(0);
                }
                ++i;
            }
        }
        this.printAdjacencyRules();
    }

    public void updateAdjacencyWithFrequency(int x, int y, int tileIndex, int direction) {
        int neighborIndex;
        if (x >= 0 && x < this.inputGrid.length && y >= 0 && y < this.inputGrid[0].length && (neighborIndex = this.inputGrid[x][y]) != -1) {
            ArrayList<Integer> adjacencyList = this.tiles.get((int)tileIndex).adjacencies[direction];
            ArrayList<Integer> frequencyList = this.tiles.get((int)tileIndex).frequencies[direction];
            int indexInAdjacency = adjacencyList.indexOf(neighborIndex);
            if (indexInAdjacency == -1) {
                adjacencyList.add(neighborIndex);
                frequencyList.add(1);
            } else {
                frequencyList.set(indexInAdjacency, frequencyList.get(indexInAdjacency) + 1);
            }
        }
    }

    public void printAdjacencyRules() {
        for (Tile t : this.tiles) {
            wfc01.println((String)("Tile Index: " + t.index));
            wfc01.println((String)("  Frequency: " + t.frequency));
            wfc01.println((String)("  Up:        " + t.adjacencies[0] + " / " + t.frequencies[0]));
            wfc01.println((String)("  Right:     " + t.adjacencies[1] + " / " + t.frequencies[1]));
            wfc01.println((String)("  Down:      " + t.adjacencies[2] + " / " + t.frequencies[2]));
            wfc01.println((String)("  Left:      " + t.adjacencies[3] + " / " + t.frequencies[3]));
            wfc01.println();
        }
    }

    public void initializeOutputGrid() {
        this.outputGrid = new int[wfc01.ceil((float)(this.width / this.tileWidth))][wfc01.ceil((float)(this.height / this.tileHeight))];
        this.explosionRange = new int[wfc01.ceil((float)(this.width / this.tileWidth))][wfc01.ceil((float)(this.height / this.tileHeight))];
        int x = 0;
        while (x < this.outputGrid.length) {
            int y = 0;
            while (y < this.outputGrid[x].length) {
                this.outputGrid[x][y] = -1;
                this.explosionRange[x][y] = 2;
                ++y;
            }
            ++x;
        }
    }

    public int[] findCellWithLeastEntropy() {
        float minEntropy = Float.MAX_VALUE;
        ArrayList<int[]> possibilities = new ArrayList<int[]>();
        int x = 0;
        while (x < this.outputGrid.length) {
            int y = 0;
            while (y < this.outputGrid[x].length) {
                if (this.outputGrid[x][y] == -1) {
                    ArrayList<PossibleTileWeighted> possibleTiles = this.getPossibleTiles(x, y);
                    float entropy = 0.0f;
                    Iterator<PossibleTileWeighted> iterator = possibleTiles.iterator();
                    while (iterator.hasNext()) {
                        iterator.next();
                        entropy += 1.0f;
                    }
                    if (entropy < minEntropy) {
                        minEntropy = entropy;
                        possibilities.clear();
                        possibilities.add(new int[]{x, y});
                    } else if (entropy == minEntropy) {
                        minEntropy = entropy;
                        possibilities.add(new int[]{x, y});
                    }
                }
                ++y;
            }
            ++x;
        }
        if (possibilities.size() == 0) {
            return new int[]{-1, -1};
        }
        return (int[])possibilities.get(wfc01.floor((float)this.random(possibilities.size())));
    }

    public void collapseWaveFunction() {
        if (this.complete) {
            return;
        }
        int[] cellIndex = this.findCellWithLeastEntropy();
        if (cellIndex[0] == -1) {
            this.save("lastResult.png");
            this.complete = true;
            return;
        }
        int x = cellIndex[0];
        int y = cellIndex[1];
        int selectedTile = this.selectTileBasedOnConstraints(x, y);
        if (selectedTile != -1) {
            this.outputGrid[x][y] = selectedTile;
        } else {
            this.explode(x, y);
        }
        this.propagateConstraints(x, y);
    }

    public ArrayList<PossibleTileWeighted> getPossibleTiles(int x, int y) {
        HashSet<Integer> possibleTiles = new HashSet<Integer>();
        int i = 0;
        while (i < this.tiles.size()) {
            possibleTiles.add(i);
            ++i;
        }
        if (x > 0 && this.outputGrid[x - 1][y] != -1 && this.outputGrid[x - 1][y] != -2) {
            possibleTiles.retainAll(this.tiles.get((int)this.outputGrid[x - 1][y]).adjacencies[1]);
        }
        if (y > 0 && this.outputGrid[x][y - 1] != -1 && this.outputGrid[x][y - 1] != -2) {
            possibleTiles.retainAll(this.tiles.get((int)this.outputGrid[x][y - 1]).adjacencies[2]);
        }
        if (x < this.outputGrid.length - 1 && this.outputGrid[x + 1][y] != -1 && this.outputGrid[x + 1][y] != -2) {
            possibleTiles.retainAll(this.tiles.get((int)this.outputGrid[x + 1][y]).adjacencies[3]);
        }
        if (y < this.outputGrid[0].length - 1 && this.outputGrid[x][y + 1] != -1 && this.outputGrid[x][y + 1] != -2) {
            possibleTiles.retainAll(this.tiles.get((int)this.outputGrid[x][y + 1]).adjacencies[0]);
        }
        Tile[] neighbors = this.neighbors(x, y);
        ArrayList<PossibleTileWeighted> possibleTilesWeighted = new ArrayList<PossibleTileWeighted>();
        Iterator iterator = possibleTiles.iterator();
        while (iterator.hasNext()) {
            int i2 = (Integer)iterator.next();
            int frequency = 0;
            int dir = 0;
            while (dir < 4) {
                int indexOfI;
                if (neighbors[dir] != null && (indexOfI = neighbors[dir].adjacencies[(dir + 2) % 4].indexOf(i2)) != -1) {
                    frequency += neighbors[dir].frequencies[(dir + 2) % 4].get(indexOfI).intValue();
                    neighbors[dir].frequencies[(dir + 2) % 4].get(indexOfI).intValue();
                }
                ++dir;
            }
            possibleTilesWeighted.add(new PossibleTileWeighted(i2, frequency));
        }
        return possibleTilesWeighted;
    }

    public Tile[] neighbors(int x, int y) {
        Tile[] neighbors = new Tile[]{y > 0 && this.outputGrid[x][y - 1] >= 0 ? this.tiles.get(this.outputGrid[x][y - 1]) : null, x < this.outputGrid.length - 1 && this.outputGrid[x + 1][y] >= 0 ? this.tiles.get(this.outputGrid[x + 1][y]) : null, y < this.outputGrid[0].length - 1 && this.outputGrid[x][y + 1] >= 0 ? this.tiles.get(this.outputGrid[x][y + 1]) : null, x > 0 && this.outputGrid[x - 1][y] >= 0 ? this.tiles.get(this.outputGrid[x - 1][y]) : null};
        return neighbors;
    }

    public ArrayList<Integer> PossibleTileIndexes(ArrayList<PossibleTileWeighted> possibleTilesWeighted) {
        ArrayList<Integer> possibleTileIndexes = new ArrayList<Integer>();
        for (PossibleTileWeighted p : possibleTilesWeighted) {
            possibleTileIndexes.add(p.index);
        }
        return possibleTileIndexes;
    }

    public void propagateConstraints(int collapsedX, int collapsedY) {
        LinkedList<int[]> queue = new LinkedList<int[]>();
        queue.add(new int[]{collapsedX, collapsedY});
        while (!queue.isEmpty()) {
            int[] cell = (int[])queue.remove();
            int x = cell[0];
            int y = cell[1];
            this.updateNeighbor(x - 1, y, queue);
            this.updateNeighbor(x + 1, y, queue);
            this.updateNeighbor(x, y - 1, queue);
            this.updateNeighbor(x, y + 1, queue);
        }
    }

    public void updateNeighbor(int x, int y, Queue<int[]> queue) {
        if (x >= 0 && x < this.outputGrid.length && y >= 0 && y < this.outputGrid[0].length && this.outputGrid[x][y] == -1) {
            ArrayList<Integer> possibleTilesBeforeUpdate = this.PossibleTileIndexes(this.getPossibleTiles(x, y));
            int selectedTile = this.selectTileBasedOnConstraints(x, y);
            if (selectedTile != -1 && !possibleTilesBeforeUpdate.contains(selectedTile)) {
                if (selectedTile != -2) {
                    this.outputGrid[x][y] = selectedTile;
                } else {
                    this.explode(x, y);
                }
                queue.add(new int[]{x, y});
            }
        }
    }

    public int selectTileBasedOnConstraintsOnlyGloballyWeighted(int x, int y) {
        ArrayList<Integer> possibleTiles = this.PossibleTileIndexes(this.getPossibleTiles(x, y));
        if (possibleTiles.isEmpty()) {
            return -2;
        }
        ArrayList<Integer> weightedPossibleTiles = new ArrayList<Integer>();
        for (int tileIndex : possibleTiles) {
            int frequency = this.tiles.get((int)tileIndex).frequency;
            int i = 0;
            while (i < frequency) {
                weightedPossibleTiles.add(tileIndex);
                ++i;
            }
        }
        if (weightedPossibleTiles.isEmpty()) {
            return -2;
        }
        int selectedIndex = wfc01.floor((float)this.random(weightedPossibleTiles.size()));
        return (Integer)weightedPossibleTiles.get(selectedIndex);
    }

    public int selectTileBasedOnConstraints(int x, int y) {
        ArrayList<PossibleTileWeighted> possibleTiles = this.getPossibleTiles(x, y);
        if (possibleTiles.isEmpty()) {
            return -2;
        }
        ArrayList<Integer> weightedPossibleTiles = new ArrayList<Integer>();
        for (PossibleTileWeighted tile : possibleTiles) {
            int i = 0;
            while (i < tile.frequency + 1) {
                weightedPossibleTiles.add(tile.index);
                ++i;
            }
        }
        if (weightedPossibleTiles.isEmpty()) {
            return -2;
        }
        int selectedIndex = wfc01.floor((float)this.random(weightedPossibleTiles.size()));
        return (Integer)weightedPossibleTiles.get(selectedIndex);
    }

    public boolean isGenerationComplete() {
        int x = 0;
        while (x < this.outputGrid.length) {
            int y = 0;
            while (y < this.outputGrid[x].length) {
                if (this.outputGrid[x][y] == -1) {
                    return false;
                }
                ++y;
            }
            ++x;
        }
        return true;
    }

    public void explode(int x, int y) {
        int x2 = -this.explosionRange[x][y];
        while (x2 < this.explosionRange[x][y]) {
            int y2 = -this.explosionRange[x][y];
            while (y2 < this.explosionRange[x][y]) {
                this.outputGrid[(x + x2 + this.outputGrid.length) % this.outputGrid.length][(y + y2 + this.outputGrid[x].length) % this.outputGrid[x].length] = -1;
                ++y2;
            }
            ++x2;
        }
        int[] nArray = this.explosionRange[x];
        int n = y;
        nArray[n] = nArray[n] + 1;
    }

    public void draw() {
        this.collapseWaveFunction();
        this.background(255);
        int x = 0;
        while (x < this.outputGrid.length) {
            int y = 0;
            while (y < this.outputGrid[x].length) {
                this.drawTile(x, y);
                ++y;
            }
            ++x;
        }
    }

    public void keyPressed() {
        if (this.keyCode == 9) {
            this.save("result.png");
        }
    }

    public void drawTile(int gridX, int gridY) {
        int tileIndex = this.outputGrid[gridX][gridY];
        if (tileIndex != -1) {
            if (tileIndex == -2) {
                this.fill(200.0f, 0.0f, 0.0f);
                this.noStroke();
                this.rect(gridX * this.tileWidth, gridY * this.tileHeight, this.tileWidth, this.tileHeight);
            } else {
                PImage tileImage = this.tiles.get((int)tileIndex).im;
                this.image(tileImage, gridX * this.tileWidth, gridY * this.tileHeight, this.tileWidth, this.tileHeight);
            }
        }
    }

    public void settings() {
        this.size(256, 256);
    }

    public static void main(String[] passedArgs) {
        String[] appletArgs = new String[]{"wfc01"};
        if (passedArgs != null) {
            PApplet.main((String[])wfc01.concat((String[])appletArgs, (String[])passedArgs));
        } else {
            PApplet.main((String[])appletArgs);
        }
    }

    class PossibleTileWeighted {
        int index;
        int frequency;

        PossibleTileWeighted(int index, int frequency) {
            this.index = index;
            this.frequency = frequency;
        }
    }

    class Tile {
        PImage im;
        int frequency;
        int index;
        ArrayList<Integer>[] adjacencies;
        ArrayList<Integer>[] frequencies;

        Tile(PImage im) {
            this.im = im;
        }

        public boolean imageEquals(PImage im2) {
            if (im2.width != this.im.width || im2.height != this.im.height) {
                return false;
            }
            int x = 0;
            while (x < im2.width) {
                int y = 0;
                while (y < im2.height) {
                    int c1 = this.im.get(x, y);
                    int c2 = im2.get(x, y);
                    if (wfc01.this.red(c1) != wfc01.this.red(c2)) {
                        return false;
                    }
                    if (wfc01.this.green(c1) != wfc01.this.green(c2)) {
                        return false;
                    }
                    if (wfc01.this.blue(c1) != wfc01.this.blue(c2)) {
                        return false;
                    }
                    ++y;
                }
                ++x;
            }
            return true;
        }
    }
}

