
import javax.swing.*;
import java.awt.FileDialog; 
import javax.swing.JOptionPane;

PImage backPicture = new PImage();

ArrayList halos = new ArrayList();

InputBox inputBox= new InputBox();
MarkerBox markerBox= new MarkerBox();

int consideredHalo = 0;

int fRate = 20;

boolean inputMarker = false;

Marker marker = new Marker();

void setup() {
  size(800,600);
  smooth();
  colorMode(HSB);
  frameRate(fRate);
  marker = new Marker();
}

void draw() {
  if (halos.size()==0) halos.add(new Halo());
  background(0);
  image(backPicture,0,0);
  for (int i=0;i<halos.size();i++) {
    ((Halo)halos.get(i)).display();
  }
  marker.display();
  markerBox.display();
  inputBox.display();
}

void exportAnim(String name) {
  int totalAnimFrames = 0;
  for (int h=0;h<halos.size();h++) {
    int thisFrame = ceil((float)((Halo)halos.get(h)).outMs/1000*fRate);
    if (thisFrame > totalAnimFrames) totalAnimFrames = thisFrame;
  }
  totalAnimFrames+=fRate*20;
  for (int f=0;f<totalAnimFrames;f++) {
    background(0);
    for (int h=0;h<halos.size();h++) {
      ((Halo)halos.get(h)).displayForFrame(f);
    }
    String fileName = f + ".png";
    while (fileName.length()<5) fileName ="0" + fileName;
    save("./frames/" + name + fileName);
  }
}

void exportDataFile() {
  ArrayList toExport = new ArrayList();
  for (int i=0;i<halos.size();i++) {
    String[] thisExport = ((Halo)halos.get(i)).getExportData();
    for (int j=0;j<thisExport.length;j++) {    
      toExport.add(thisExport[j]);
    }
  }
  String[] result = new String[toExport.size()];
  for (int i=0;i<toExport.size();i++) {
    result[i]=((String)toExport.get(i));
  }
  if (animURL.equals("")) {
    FileDialog fileDialog = new FileDialog(frame, "save", FileDialog.LOAD);
    fileDialog.setVisible(true);
    if (fileDialog.getDirectory()!=null) {
      animURL=fileDialog.getDirectory() + fileDialog.getFile();
    } 
    else {
      animURL=dataPath("export.ani");
    }
  }
  saveStrings(animURL,result);
}

String animURL="";

void loadAnim(String URL) {
  String[] fileContent;
  animURL=URL;
  fileContent=loadStrings(animURL);  
  for (int i=0;i<fileContent.length;i++) {
    if (fileContent[i++].equals("<Halo>")) {
      Halo thisHalo = new Halo();
      thisHalo.fadeInLength=Integer.parseInt(valueOnlyOf(fileContent[i++]));
      thisHalo.fadeOutLength=Integer.parseInt(valueOnlyOf(fileContent[i++]));
      thisHalo.inMs=Integer.parseInt(valueOnlyOf(fileContent[i++]));
      thisHalo.outMs=Integer.parseInt(valueOnlyOf(fileContent[i++]));
      thisHalo.blur=Integer.parseInt(valueOnlyOf(fileContent[i++]));
      thisHalo.col=Integer.parseInt(valueOnlyOf(fileContent[i++]));
      thisHalo.movingType=Integer.parseInt(valueOnlyOf(fileContent[i++]));
      if (fileContent[i++].equals("<Points>")) {
        while(!fileContent[i].equals("</Points>")) thisHalo.points.add(new PVector(Float.parseFloat(valueOnlyOf(fileContent[i++])),Float.parseFloat(valueOnlyOf(fileContent[i++]))));
      }
      i++;
      if (fileContent[i].equals("</Halo>")) halos.add(thisHalo);
    }
  }
}

String valueOnlyOf(String theLine) {
  int i = theLine.length()-1;
  while (theLine.charAt(i)!='=' && i>0) i--;
  return theLine.substring(i+1);
}

