
class InputBox {
  String[] answer = new String[7];
  int currentSelection=0;

  InputBox() {
    for (int i=0;i<answer.length;i++) {
      answer[i]="0";
    }
  }

  void display() {
    noFill();
    stroke(0x50,0x30,0xD0);    
    for (int i=0;i<answer.length;i++) {
      rect(10+i*60,10,50,10);
      image(HardCodedFont.picFor(answer[i]),11+i*60,11);
    }
    stroke(0xA0,0x30,0xD0);
    rect(9+currentSelection*60,9,52,12);
  }

  void addDigit(int d) {
    if (answer[currentSelection].equals("0")) answer[currentSelection]="";
    answer[currentSelection]+=d;
  }

  void removeLastDigit() {
    if (answer[currentSelection].length() > 1) answer[currentSelection] = answer[currentSelection].substring(0,answer[currentSelection].length()-1);
    else answer[currentSelection] = "0";
  }

  void resetDigits() {
    answer[currentSelection]="0";
  }

  void setMouseSelection(int x) {
    currentSelection=floor(((float)x-10)/60);
  }

  void updateValues() {
    answer[0] = ""+((Halo)halos.get(consideredHalo)).fadeInLength;
    answer[1] = ""+((Halo)halos.get(consideredHalo)).fadeOutLength;
    answer[2] = ""+((Halo)halos.get(consideredHalo)).inMs;
    answer[3] = ""+((Halo)halos.get(consideredHalo)).outMs;
    answer[4] = ""+((Halo)halos.get(consideredHalo)).blur;
    answer[5] = ""+((Halo)halos.get(consideredHalo)).col;
    answer[6] = ""+((Halo)halos.get(consideredHalo)).movingType;
  }
}

class MarkerBox {
  String answer="";
  int x=0;

  MarkerBox() {
  }

  void display() {
    if (inputMarker) {
      noFill();
      stroke(0x00,0xFF,0xFF);
      rect(x+10,25,50,10);
      image(HardCodedFont.picFor(answer),x+11,26);
      stroke(0x00,0xFF,0xFF);
      line(x,0,x,height);
    }
  }

  void addDigit(int d) {
    if (answer.equals("0")) answer="";
    answer+=d;
  }

  void resetDigits() {
    answer="0";
  }
}

