
import ddf.minim.*;
import ddf.minim.ugens.*;

import java.util.Arrays;

Minim minim;
AudioPlayer[] chordsPlayer;
AudioOutput out;
Oscil triangleOsc;

float posXSmooth = 0;
float prevPosX = 0;
float speed = 0;
float smoothSpeed = 0;
float stabilisation = 0;
float smoothStabilisation = 0;
float target = 250;
float rederivatedX = 0;
float correctedXSmooth = 0;
float correctedXSmoothWithoutDerivative = 0;
float previousCorrectedXSmooth = 0;
float derivative = 0;
float finalXSmooth = 0;
ArrayList<Float> targets;
float targetsMin = 40;
float targetsMax = 90;
float frequencyMouseX;
float oscAmp = 0;
float simpleSnap = 0;

ArrayList<Integer>[] chords = new ArrayList[4];

int currentChord = -1;

void setup() {
  size(1500, 200);
  frameRate(60);
  targets = new ArrayList<Float>();
  minim = new Minim(this);
  out = minim.getLineOut(Minim.STEREO, 256);
  chordsPlayer = new AudioPlayer[4];
  chordsPlayer[0] = minim.loadFile(dataPath("chord01.wav"));
  chordsPlayer[1] = minim.loadFile(dataPath("chord02.wav"));
  chordsPlayer[2] = minim.loadFile(dataPath("chord03.wav"));
  chordsPlayer[3] = minim.loadFile(dataPath("chord04.wav"));
  chords[0] = new ArrayList<Integer>(Arrays.asList(0, 2, 4, 5, 7, 9, 11));
  chords[1] = new ArrayList<Integer>(Arrays.asList(0, 2, 3, 5, 7, 8, 10));
  chords[2] = new ArrayList<Integer>(Arrays.asList(0, 2, 3, 5, 7, 8, 10));
  chords[3] = new ArrayList<Integer>(Arrays.asList(0, 2, 3, 5, 7, 9, 10));

  float[] waveTable = new float[2048];
  for (int i = 0; i < waveTable.length; i++) {
    float phase = (float)i / waveTable.length;
    waveTable[i] = 1 - 4 * Math.abs(phase - 0.5f);
  }
  Wavetable triangleWave = new Wavetable(waveTable);

  // Create an oscillator with the triangle wavetable
  triangleOsc = new Oscil(440, 0.5f, triangleWave);
  triangleOsc.patch(out);
}

void draw() {
  if (floor((float)frameCount/200)%chordsPlayer.length != currentChord) {
    currentChord = floor((float)frameCount/200)%chordsPlayer.length;
    chordsPlayer[currentChord].rewind();
    chordsPlayer[currentChord].play();
    targets.clear();
    for (int i=0; i<128; i++) {
      if (i>40 && i<90) {
        if (chords[currentChord].contains(i%12)) {
          targets.add((float)(i-targetsMin)*width/(targetsMax-targetsMin));
        }
      }
    }
  }
  posXSmooth = lerp(posXSmooth, mouseX, 0.5);
  derivative = mouseX-prevPosX;
  speed = abs(derivative);
  smoothSpeed = lerp(smoothSpeed, speed, 0.5);
  stabilisation = min(1.0/max(0.0001, smoothSpeed*2.0), 1.0);
  stabilisation = map(stabilisation, 0, 1, 0, 0.2);
  smoothStabilisation = lerp(smoothStabilisation, stabilisation, 0.2);
  target = -1;
  for (int i=0; i<targets.size(); i++) {
    if (target==-1 || abs(targets.get(i)-posXSmooth)<abs(target-posXSmooth)) {
      target = targets.get(i);
    }
  }
  rederivatedX = target + derivative;
  correctedXSmooth += derivative;
  correctedXSmooth = lerp(correctedXSmooth, target, stabilisation);
  correctedXSmoothWithoutDerivative = lerp(correctedXSmoothWithoutDerivative, target, stabilisation);
  finalXSmooth = lerp(previousCorrectedXSmooth, correctedXSmooth, 0.3);
  if (mouseX!=prevPosX) simpleSnap = lerp(simpleSnap,mouseX,0.5);
  simpleSnap = lerp(simpleSnap,target,0.3);
  if (!mousePressed) finalXSmooth = target;
  prevPosX = mouseX;
  previousCorrectedXSmooth = correctedXSmooth;
  triangleOsc.setFrequency(midiNoteToFrequency(map(correctedXSmooth, 0, width, targetsMin, targetsMax)));
  triangleOsc.setAmplitude(oscAmp);
  if (mousePressed) {
    oscAmp = lerp(oscAmp, 0.1, 0.8);
    triangleOsc.setPhase(0);
  }
  else oscAmp = lerp(oscAmp, 0.0, 0.4);
  // draw
  background(0xFF);
  rect(250+derivative, height-10, 8, 8);
  rect(speed, height-20, 8, 8);
  rect(smoothSpeed, height-30, 8, 8);
  rect(stabilisation*250, height-40, 8, 8);
  rect(smoothStabilisation*250, height-50, 8, 8);
  for (int i=0; i<targets.size(); i++) rect(targets.get(i), height-60, 8, 8);
  rect(mouseX, height-70, 8, 8);
  rect(posXSmooth, height-80, 8, 8);
  rect(target, height-90, 8, 8);
  rect(rederivatedX, height-100, 8, 8);
  rect(correctedXSmoothWithoutDerivative, height-110, 8, 8);
  rect(correctedXSmooth, height-120, 8, 8);
  rect(simpleSnap, height-130, 8, 8);
  rect(finalXSmooth, height-140, 8, 8);
}

float midiNoteToFrequency(float midiNote) {
  return (float) (Math.pow(2, (midiNote - 69) / 12.0) * 440.0);
}

float frequencyToMidi(float frequency) {
  return (float) (69 + 12 * Math.log(frequency / 440.0) / Math.log(2));
}

void stop() {
  for (AudioPlayer player : chordsPlayer) {
    if (player != null) {
      player.close();
    }
  }
  triangleOsc.unpatch(out);
  out.close();
  minim.stop();
  super.stop();
}
