/*
 * Decompiled with CFR 0.152.
 */
import drop.DropEvent;
import drop.SDrop;
import java.io.File;
import java.util.ArrayList;
import java.util.HashSet;
import processing.core.PApplet;
import processing.core.PGraphics;
import processing.core.PImage;
import processing.core.PVector;
import processing.event.MouseEvent;

public class paintFromPics
extends PApplet {
    boolean painting = false;
    float brushRadius = 20.0f;
    float sourceZoom = 1.0f;
    float brushOpacity = 1.0f;
    PicDropper picDropper = new PicDropper();
    PGraphics finalPic;
    ArrayList<String> picsUrls = new ArrayList();
    int currentPicIndex = 0;
    String statusMessage = "Drag and drop a folder with pics onto the window.";
    boolean hasPicsLoaded = false;
    SDrop dropHandler;

    public void setup() {
        this.finalPic = this.createGraphics(this.width, this.height);
        this.finalPic.beginDraw();
        this.finalPic.background(255);
        this.finalPic.endDraw();
        this.background(255);
        this.dropHandler = new SDrop((PApplet)this);
    }

    public void draw() {
        this.background(255);
        this.picDropper.update();
        if (this.painting && this.picDropper.im != null) {
            this.paintFromPic();
        }
        this.image((PImage)this.finalPic, 0.0f, 0.0f);
        this.drawBrushOverlay();
        this.drawUi();
    }

    public void paintFromPic() {
        int r = PApplet.parseInt((float)this.brushRadius);
        int r2 = r * r;
        float zoom = paintFromPics.max((float)0.1f, (float)this.sourceZoom);
        int alphaMix = PApplet.parseInt((float)(this.brushOpacity * 255.0f));
        if (alphaMix <= 0) {
            return;
        }
        boolean opaqueBrush = alphaMix >= 255;
        this.finalPic.beginDraw();
        this.finalPic.loadPixels();
        this.picDropper.im.loadPixels();
        int dx = -r;
        while (dx <= r) {
            int dy = -r;
            while (dy <= r) {
                if (dx * dx + dy * dy <= r2) {
                    int sx = PApplet.parseInt((float)(this.picDropper.pos.x + (float)dx / zoom));
                    int sy = PApplet.parseInt((float)(this.picDropper.pos.y + (float)dy / zoom));
                    int dxWin = this.mouseX + dx;
                    int dyWin = this.mouseY + dy;
                    if (sx >= 0 && sx < this.picDropper.im.width && sy >= 0 && sy < this.picDropper.im.height && dxWin >= 0 && dxWin < this.finalPic.width && dyWin >= 0 && dyWin < this.finalPic.height) {
                        int dstIdx = dyWin * this.finalPic.width + dxWin;
                        int srcCol = this.picDropper.im.pixels[sy * this.picDropper.im.width + sx];
                        if (opaqueBrush) {
                            this.finalPic.pixels[dstIdx] = srcCol;
                        } else {
                            int dstCol = this.finalPic.pixels[dstIdx];
                            int sr = srcCol >> 16 & 0xFF;
                            int sg = srcCol >> 8 & 0xFF;
                            int sb = srcCol & 0xFF;
                            int dr = dstCol >> 16 & 0xFF;
                            int dg = dstCol >> 8 & 0xFF;
                            int db = dstCol & 0xFF;
                            dr += (sr - dr) * alphaMix >> 8;
                            dg += (sg - dg) * alphaMix >> 8;
                            db += (sb - db) * alphaMix >> 8;
                            this.finalPic.pixels[dstIdx] = 0xFF000000 | dr << 16 | dg << 8 | db;
                        }
                    }
                }
                ++dy;
            }
            ++dx;
        }
        this.finalPic.updatePixels();
        this.finalPic.endDraw();
    }

    public void drawBrushOverlay() {
        int alphaMix = PApplet.parseInt((float)(this.brushOpacity * 120.0f));
        if (this.picDropper.im != null && alphaMix > 0) {
            int r = PApplet.parseInt((float)this.brushRadius);
            int r2 = r * r;
            float zoom = paintFromPics.max((float)0.1f, (float)this.sourceZoom);
            this.loadPixels();
            this.picDropper.im.loadPixels();
            int winW = this.width;
            int winH = this.height;
            int srcW = this.picDropper.im.width;
            int srcH = this.picDropper.im.height;
            int dx = -r;
            while (dx <= r) {
                int px = this.mouseX + dx;
                if (px >= 0 && px < winW) {
                    int dx2 = dx * dx;
                    int dy = -r;
                    while (dy <= r) {
                        int py;
                        if (dx2 + dy * dy <= r2 && (py = this.mouseY + dy) >= 0 && py < winH) {
                            int sx = PApplet.parseInt((float)(this.picDropper.pos.x + (float)dx / zoom));
                            int sy = PApplet.parseInt((float)(this.picDropper.pos.y + (float)dy / zoom));
                            if (sx >= 0 && sx < srcW && sy >= 0 && sy < srcH) {
                                int dstIdx = py * winW + px;
                                int srcIdx = sy * srcW + sx;
                                int dst = this.pixels[dstIdx];
                                int src = this.picDropper.im.pixels[srcIdx];
                                int sr = src >> 16 & 0xFF;
                                int sg = src >> 8 & 0xFF;
                                int sb = src & 0xFF;
                                int dr = dst >> 16 & 0xFF;
                                int dg = dst >> 8 & 0xFF;
                                int db = dst & 0xFF;
                                dr += (sr - dr) * alphaMix >> 8;
                                dg += (sg - dg) * alphaMix >> 8;
                                db += (sb - db) * alphaMix >> 8;
                                this.pixels[dstIdx] = 0xFF000000 | dr << 16 | dg << 8 | db;
                            }
                        }
                        ++dy;
                    }
                }
                ++dx;
            }
            this.updatePixels();
        }
        this.noFill();
        this.stroke(0, 100.0f);
        this.strokeWeight(1.0f);
        this.ellipse(this.mouseX, this.mouseY, this.brushRadius * 2.0f, this.brushRadius * 2.0f);
    }

    public void drawUi() {
        this.fill(0, 180.0f);
        this.noStroke();
        this.rect(10.0f, 10.0f, 180.0f, 150.0f);
        this.fill(255);
        this.textSize(12.0f);
        this.textAlign(37, 101);
        String info = "Brush: " + paintFromPics.nf((float)this.brushRadius, (int)0, (int)1) + " px\n";
        info = String.valueOf(info) + "Zoom: " + paintFromPics.nf((float)this.sourceZoom, (int)0, (int)2) + "x\n";
        info = String.valueOf(info) + "Opacity: " + paintFromPics.nf((float)(this.brushOpacity * 100.0f), (int)0, (int)0) + "%\n";
        info = String.valueOf(info) + "Images: " + this.picsUrls.size() + "\n";
        info = String.valueOf(info) + "left click: paint\n";
        info = String.valueOf(info) + "right click: change pic\n";
        info = String.valueOf(info) + "mouse wheel: brush size\n";
        info = String.valueOf(info) + "+/-: brush zoom\n";
        info = String.valueOf(info) + "o/p: brush transparency\n";
        info = String.valueOf(info) + "tab: save\n";
        this.text(info, 16.0f, 16.0f);
        if (!this.hasPicsLoaded) {
            this.fill(0, 200.0f);
            this.rect(this.width / 2 - 210, this.height / 2 - 50, 420.0f, 100.0f);
            this.fill(255);
            this.textAlign(3, 3);
            this.text("Drag and drop a folder with pictures onto this window", this.width / 2, this.height / 2);
        }
        this.fill(0, 200.0f);
        this.textAlign(37, 102);
        this.text(this.statusMessage, 16.0f, this.height - 16);
    }

    public void dragAndDropPic(String folderPath) {
        this.loadPicsFromFolder(new File(folderPath));
    }

    public void loadPicsFromFolder(File folder) {
        if (folder == null) {
            return;
        }
        this.picsUrls.clear();
        HashSet<String> unique = new HashSet<String>();
        if (!folder.exists() || !folder.isDirectory()) {
            paintFromPics.println((String)("Not a valid folder: " + folder.getAbsolutePath()));
            this.statusMessage = "Not a valid folder: " + folder.getAbsolutePath();
            this.hasPicsLoaded = false;
            return;
        }
        this.collectImages(folder, unique);
        this.picsUrls.addAll(unique);
        if (this.picsUrls.size() > 0) {
            this.currentPicIndex = 0;
            this.loadCurrentPic();
            this.hasPicsLoaded = true;
            this.statusMessage = "Loaded " + this.picsUrls.size() + " images from " + folder.getAbsolutePath();
        } else {
            paintFromPics.println((String)("No image files found in folder: " + folder.getAbsolutePath()));
            this.statusMessage = "No image files found in " + folder.getAbsolutePath();
            this.hasPicsLoaded = false;
        }
    }

    public void collectImages(File target, HashSet<String> unique) {
        if (target == null) {
            return;
        }
        if (target.isDirectory()) {
            File[] files = target.listFiles();
            if (files == null) {
                return;
            }
            File[] fileArray = files;
            int n = files.length;
            int n2 = 0;
            while (n2 < n) {
                File f = fileArray[n2];
                this.collectImages(f, unique);
                ++n2;
            }
        } else {
            String name = target.getName().toLowerCase();
            if (name.endsWith(".png") || name.endsWith(".jpg") || name.endsWith(".jpeg") || name.endsWith(".gif")) {
                unique.add(target.getAbsolutePath());
            }
        }
    }

    public void loadCurrentPic() {
        if (this.picsUrls.size() == 0) {
            return;
        }
        this.currentPicIndex = (this.currentPicIndex % this.picsUrls.size() + this.picsUrls.size()) % this.picsUrls.size();
        String path = this.picsUrls.get(this.currentPicIndex);
        paintFromPics.println((String)("Loading image: " + path));
        PImage img = this.loadImage(path);
        if (img != null) {
            this.picDropper.setImage(img);
            this.clampBrushToImage();
            this.picDropper.clampToBounds();
        } else {
            paintFromPics.println((String)("Could not load image: " + path));
            this.statusMessage = "Could not load image: " + path;
        }
    }

    public void mousePressed() {
        if (this.mouseButton == 39 && this.picsUrls.size() > 0) {
            this.currentPicIndex = (this.currentPicIndex + 1) % this.picsUrls.size();
            this.loadCurrentPic();
        }
        if (this.mouseButton == 37) {
            this.painting = true;
        }
    }

    public void mouseReleased() {
        if (this.mouseButton == 37) {
            this.painting = false;
        }
    }

    public void keyPressed() {
        if (this.key == '+' || this.key == '=') {
            this.sourceZoom = paintFromPics.min((float)(this.sourceZoom + 0.1f), (float)10.0f);
            this.clampBrushToImage();
            this.picDropper.clampToBounds();
        }
        if (this.key == '-' || this.key == '_') {
            this.sourceZoom = paintFromPics.max((float)(this.sourceZoom - 0.1f), (float)0.1f);
            this.clampBrushToImage();
            this.picDropper.clampToBounds();
        }
        if (this.key == 'o' || this.key == 'O') {
            this.brushOpacity = paintFromPics.max((float)0.0f, (float)(this.brushOpacity - 0.05f));
        }
        if (this.key == 'p' || this.key == 'P') {
            this.brushOpacity = paintFromPics.min((float)1.0f, (float)(this.brushOpacity + 0.05f));
        }
        if (this.key == '\t') {
            String filename = "export_" + paintFromPics.year() + paintFromPics.nf((int)paintFromPics.month(), (int)2) + paintFromPics.nf((int)paintFromPics.day(), (int)2) + "_" + paintFromPics.nf((int)paintFromPics.hour(), (int)2) + paintFromPics.nf((int)paintFromPics.minute(), (int)2) + paintFromPics.nf((int)paintFromPics.second(), (int)2) + ".png";
            String path = this.sketchPath(filename);
            this.finalPic.save(path);
            this.statusMessage = "Exported to " + filename;
            paintFromPics.println((String)(String.valueOf(this.statusMessage) + " (" + path + ")"));
        }
        paintFromPics.println((String)("brush radius : " + this.brushRadius + " | zoom : " + this.sourceZoom + " | opacity : " + paintFromPics.nf((float)(this.brushOpacity * 100.0f), (int)0, (int)0) + "%"));
    }

    public void mouseWheel(MouseEvent event) {
        float delta = event.getCount();
        this.brushRadius = paintFromPics.max((float)1.0f, (float)(this.brushRadius - delta * 2.0f));
        this.clampBrushToImage();
    }

    public void dropEvent(DropEvent theDropEvent) {
        File file = theDropEvent.file();
        if (file == null) {
            return;
        }
        File folder = file.isDirectory() ? file : file.getParentFile();
        this.loadPicsFromFolder(folder);
    }

    public float samplingMargin() {
        if (this.picDropper.im == null) {
            return 0.0f;
        }
        float zoom = paintFromPics.max((float)0.1f, (float)this.sourceZoom);
        float margin = this.brushRadius / zoom;
        float maxMargin = paintFromPics.min((float)((float)(this.picDropper.im.width - 1) / 2.0f), (float)((float)(this.picDropper.im.height - 1) / 2.0f));
        return paintFromPics.constrain((float)margin, (float)0.0f, (float)maxMargin);
    }

    public float getMaxBrushRadius() {
        if (this.picDropper.im == null) {
            return 500.0f;
        }
        float minDim = paintFromPics.min((int)this.picDropper.im.width, (int)this.picDropper.im.height);
        return paintFromPics.max((float)1.0f, (float)(minDim * this.sourceZoom * 0.5f));
    }

    public void clampBrushToImage() {
        this.brushRadius = paintFromPics.constrain((float)this.brushRadius, (float)1.0f, (float)this.getMaxBrushRadius());
    }

    public void settings() {
        this.size(1000, 1000);
    }

    public static void main(String[] passedArgs) {
        String[] appletArgs = new String[]{"paintFromPics"};
        if (passedArgs != null) {
            PApplet.main((String[])paintFromPics.concat((String[])appletArgs, (String[])passedArgs));
        } else {
            PApplet.main((String[])appletArgs);
        }
    }

    class PicDropper {
        PImage im;
        PVector pos;
        PVector direction;

        PicDropper() {
            this.pos = new PVector((float)(paintFromPics.this.width / 2), (float)(paintFromPics.this.height / 2));
            this.direction = PVector.random2D();
        }

        public void setImage(PImage img) {
            this.im = img;
            if (this.im != null) {
                this.pos = new PVector((float)(this.im.width / 2), (float)(this.im.height / 2));
                this.direction = PVector.random2D();
                this.direction.mult(2.0f);
                this.clampToBounds();
            }
        }

        public void update() {
            if (this.im == null) {
                return;
            }
            this.direction.x += paintFromPics.this.random(-0.3f, 0.3f);
            this.direction.y += paintFromPics.this.random(-0.3f, 0.3f);
            this.direction.limit(3.0f);
            this.pos.add(this.direction);
            this.clampToBounds();
        }

        public void clampToBounds() {
            float margin;
            if (this.im == null) {
                return;
            }
            float minX = margin = paintFromPics.this.samplingMargin();
            float maxX = (float)(this.im.width - 1) - margin;
            float minY = margin;
            float maxY = (float)(this.im.height - 1) - margin;
            if (this.pos.x < minX) {
                this.pos.x = minX;
                this.direction.x = paintFromPics.abs((float)this.direction.x);
            }
            if (this.pos.x > maxX) {
                this.pos.x = maxX;
                this.direction.x = -paintFromPics.abs((float)this.direction.x);
            }
            if (this.pos.y < minY) {
                this.pos.y = minY;
                this.direction.y = paintFromPics.abs((float)this.direction.y);
            }
            if (this.pos.y > maxY) {
                this.pos.y = maxY;
                this.direction.y = -paintFromPics.abs((float)this.direction.y);
            }
        }
    }
}

