PImage img, result;

void setup() {
  size(400, 400);
  String[] imgurls = getAllFilesFrom(sketchPath("./in"));
  int nbE=0;
  for (String url : imgurls) {
    img = loadImage(url);
    println(url);
    img.filter(GRAY);  // Convertit en niveaux de gris

    result = createImage(img.width, img.height, ALPHA);
    img.loadPixels();
    result.loadPixels();

    for (int i = 0; i < result.pixels.length; i++) {
      result.pixels[i] = color(255);
    }

    int s = 15;  // demi-taille du voisinage local
    for (int y = s; y < img.height - s; y++) {
      println(y +" / "+ img.height);
      for (int x = s; x < img.width - s; x++) {
        float sum = 0;
        for (int dy = -s; dy <= s; dy++) {
          for (int dx = -s; dx <= s; dx++) {
            sum += brightness(img.pixels[(x+dx) + (y+dy) * img.width]);
          }
        }
        float avg = sum / sq(2*s+1);
        float b = brightness(img.pixels[x + y * img.width]);
        result.pixels[x + y * result.width] = (b > avg - 10) ? color(255) : color(0);
      }
    }
    result.updatePixels();
    result.save("result_"+nf(nbE++, 5)+".png");
  }
  exit();
}
