/*
 * Decompiled with CFR 0.152.
 */
import drop.DropEvent;
import drop.SDrop;
import java.io.File;
import java.util.ArrayList;
import javax.sound.midi.MetaMessage;
import javax.sound.midi.MidiEvent;
import javax.sound.midi.MidiMessage;
import javax.sound.midi.MidiSystem;
import javax.sound.midi.Sequence;
import javax.sound.midi.ShortMessage;
import javax.sound.midi.Track;
import processing.core.PApplet;

public class splitMidi
extends PApplet {
    SDrop drop;
    ArrayList<Note> notes = new ArrayList();
    ArrayList<Note> processedNotes = new ArrayList();
    Sequence sequence;

    public void setup() {
        this.drop = new SDrop((PApplet)this);
    }

    public void draw() {
        this.background(0);
        this.text("drop midi file", 50.0f, 50.0f);
        this.text("output will appear in the data folder", 50.0f, 100.0f);
    }

    public void dropEvent(DropEvent theDropEvent) {
        if (theDropEvent.isFile()) {
            this.processMidiFile(new File(theDropEvent.filePath()));
            int maxTick = 0;
            for (Note note : this.notes) {
                maxTick = splitMidi.max((int)maxTick, (int)(note.stopTick + 1));
            }
            int layer = 0;
            while (this.notes.size() > 0) {
                int endOfPreviousNote = -1;
                int currentTick = 0;
                while (currentTick < maxTick) {
                    Note highestNote = this.findHighestNoteAtTick(currentTick, endOfPreviousNote);
                    if (highestNote != null) {
                        highestNote.layer = layer;
                        endOfPreviousNote = currentTick = highestNote.stopTick - 1;
                        this.processedNotes.add(highestNote);
                        this.notes.remove(highestNote);
                    }
                    ++currentTick;
                }
                ++layer;
            }
            for (Note note : this.processedNotes) {
                splitMidi.println((String)(String.valueOf(note.note) + " " + note.velocity + " " + note.channel + " " + note.startTick + " " + note.stopTick + " " + note.layer));
            }
            this.saveAsMidi(this.processedNotes, this.sequence);
            this.exit();
        }
    }

    public void saveAsMidi(ArrayList<Note> notes, Sequence originalSequence) {
        try {
            int ppq = originalSequence.getResolution();
            int maxLayer = 0;
            for (Note note : notes) {
                maxLayer = splitMidi.max((int)maxLayer, (int)note.layer);
            }
            int layer = 0;
            while (layer <= maxLayer) {
                Sequence sequence = new Sequence(0.0f, ppq);
                Track track = sequence.createTrack();
                Track originalTrack = originalSequence.getTracks()[0];
                int i = 0;
                while (i < originalTrack.size()) {
                    MetaMessage metaMsg;
                    MidiEvent event = originalTrack.get(i);
                    MidiMessage message = event.getMessage();
                    if (message instanceof MetaMessage && (metaMsg = (MetaMessage)message).getType() == 81) {
                        track.add(new MidiEvent(metaMsg, event.getTick()));
                    }
                    ++i;
                }
                for (Note note : notes) {
                    if (note.layer != layer) continue;
                    ShortMessage noteOnMessage = new ShortMessage();
                    noteOnMessage.setMessage(144, note.channel, note.note, note.velocity);
                    MidiEvent noteOnEvent = new MidiEvent(noteOnMessage, note.startTick);
                    track.add(noteOnEvent);
                    ShortMessage noteOffMessage = new ShortMessage();
                    noteOffMessage.setMessage(128, note.channel, note.note, 0);
                    MidiEvent noteOffEvent = new MidiEvent(noteOffMessage, note.stopTick);
                    track.add(noteOffEvent);
                }
                File outputFile = new File(this.dataPath("output_layer_" + layer + ".mid"));
                MidiSystem.write(sequence, 1, outputFile);
                splitMidi.println((String)("Layer " + layer + " saved as: " + outputFile.getAbsolutePath()));
                ++layer;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public Note findHighestNoteAtTick(int currentTick, int previousNoteTick) {
        Note highestNote = null;
        for (Note note : this.notes) {
            if (note.startTick > currentTick || note.stopTick <= currentTick || note.startTick < previousNoteTick || highestNote != null && note.note <= highestNote.note) continue;
            highestNote = note;
        }
        return highestNote;
    }

    public void processMidiFile(File midiFile) {
        try {
            this.sequence = MidiSystem.getSequence(midiFile);
            Track[] trackArray = this.sequence.getTracks();
            int n = trackArray.length;
            int n2 = 0;
            while (n2 < n) {
                Track track = trackArray[n2];
                this.processTrack(track);
                ++n2;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void processTrack(Track track) {
        int i = 0;
        while (i < track.size()) {
            MidiEvent event = track.get(i);
            MidiMessage message = event.getMessage();
            if (message instanceof ShortMessage) {
                int note;
                ShortMessage sm = (ShortMessage)message;
                long tick = event.getTick();
                if (sm.getCommand() == 144) {
                    note = sm.getData1();
                    int velocity = sm.getData2();
                    if (velocity > 0) {
                        this.notes.add(new Note(note, velocity, sm.getChannel(), tick, -1L));
                    } else {
                        this.closeNote(note, tick);
                    }
                } else if (sm.getCommand() == 128) {
                    note = sm.getData1();
                    this.closeNote(note, event.getTick());
                }
            }
            ++i;
        }
    }

    public void closeNote(int noteValue, long stopTick) {
        for (Note note : this.notes) {
            if (note.note != noteValue || note.stopTick != -1) continue;
            note.stopTick = (int)stopTick;
            break;
        }
    }

    public void settings() {
        this.size(500, 500);
    }

    public static void main(String[] passedArgs) {
        String[] appletArgs = new String[]{"splitMidi"};
        if (passedArgs != null) {
            PApplet.main((String[])splitMidi.concat((String[])appletArgs, (String[])passedArgs));
        } else {
            PApplet.main((String[])appletArgs);
        }
    }

    class Note {
        int note;
        int velocity;
        int channel;
        int startTick;
        int stopTick;
        int layer = -1;

        Note(int note, int velocity, int channel, long startTick, long stopTick) {
            this.note = note;
            this.velocity = velocity;
            this.channel = channel;
            this.startTick = (int)startTick;
            this.stopTick = (int)stopTick;
        }
    }
}

