/* autogenerated by Processing revision 1293 on 2026-01-12 */
import processing.core.*;
import processing.data.*;
import processing.event.*;
import processing.opengl.*;

import processing.event.MouseEvent;
import java.util.HashSet;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Collections;
import java.io.File;
import java.util.HashMap;
import java.util.HashSet;
import java.util.ArrayDeque;
import java.util.PriorityQueue;
import java.util.Comparator;
import java.util.Collections;
import java.util.Arrays;
import java.util.Map;
import java.util.*;
import java.lang.reflect.*;
import processing.core.PConstants;
import processing.core.PFont;
import java.util.HashMap;

import java.util.HashMap;
import java.util.ArrayList;
import java.io.File;
import java.io.BufferedReader;
import java.io.PrintWriter;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.IOException;

public class Main extends PApplet {









Viewport viewport;
MapModel mapModel;

// Current editing mode
Tool currentTool = Tool.EDIT_SITES;

// Panning state
boolean isPanning = false;
int lastMouseX;
int lastMouseY;

// Site dragging state
Site draggingSite = null;
boolean isDraggingSite = false;

int selectedPathIndex = -1;
PVector pendingPathStart = null;
float structureSize = 0.02f; // world units
float structureAngleOffsetRad = 0.0f;
float lastStructureSnapAngle = 0.0f;
StructureSnapMode structureSnapMode = StructureSnapMode.NEXT_TO_PATH;
StructureShape structureShape = StructureShape.RECTANGLE;
float structureAspectRatio = 1.0f; // width/height for rectangle shape
float structureHue01 = 0.0f;
float structureSat01 = 0.0f;
float structureAlpha01 = 1.0f;
float structureStrokePx = 1.4f;
float zonesListScroll = 0;
float pathsListScroll = 0;
float structuresListScroll = 0;
float labelsListScroll = 0;

boolean useDefaultStructureNames = false;
boolean useDefaultPathNames = false;

boolean structSectionGenOpen = true;
boolean structSectionSnapOpen = true;
boolean structSectionAttrOpen = true;

// Rendering configuration
RenderSettings renderSettings = new RenderSettings();
RenderPreset[] renderPresets = buildDefaultRenderPresets();
boolean renderSectionBaseOpen = false;
boolean renderSectionBiomesOpen = false;
boolean renderSectionShadingOpen = false;
boolean renderSectionCoastlinesOpen = false;
boolean renderSectionElevationOpen = false;
boolean renderSectionPathsOpen = false;
boolean renderSectionZonesOpen = false;
boolean renderSectionStructuresOpen = false;
boolean renderSectionLabelsOpen = false;
boolean renderSectionGeneralOpen = false;

boolean snapWaterEnabled = true;
boolean snapBiomesEnabled = false;
boolean snapUnderwaterBiomesEnabled = false;
boolean snapZonesEnabled = true;
boolean snapPathsEnabled = true;
boolean snapStructuresEnabled = true;
boolean snapElevationEnabled = false;
int snapElevationDivisions = 8;

// UI layout
final int TOP_BAR_HEIGHT = 30;
final int TOP_BAR_EXTRA_PAD = 4;
final int TOP_BAR_TOTAL = TOP_BAR_HEIGHT + TOP_BAR_EXTRA_PAD;
final int TOOL_BAR_HEIGHT = 26;
final int PANEL_X = 0;
final int PANEL_W = 320;
final int PANEL_PADDING = 10;
final int PANEL_ROW_GAP = 8;
final int PANEL_SECTION_GAP = 12;
final int PANEL_SLIDER_H = 16;
final int PANEL_LABEL_H = 14;
final int PANEL_BUTTON_H = 22;
final int PANEL_CHECK_SIZE = 16;
final int PANEL_TITLE_H = 18;
final int RIGHT_PANEL_W = 260;
final int SCROLLBAR_W = 14;
final int SCROLLBAR_THUMB_MIN = 24;
final int SCROLL_STEP_PX = 24;
final float FLATTEST_BIAS_MIN = 0.0f;
final float FLATTEST_BIAS_MAX = 1000.0f;
final String[] LABEL_FONT_OPTIONS = { "SansSerif", "Serif", "Monospaced", "Arial", "Georgia" };

public float sliderNorm(IntRect r, int mx) {
  if (r == null) return 0;
  int padding = max(4, r.h / 2);
  float startX = r.x + padding;
  float endX = r.x + r.w - padding;
  if (endX <= startX) return 0;
  return constrain((mx - startX) / (endX - startX), 0, 1);
}

// Cells (site seeds) generation config
PlacementMode[] placementModes = {
  PlacementMode.GRID,
  PlacementMode.POISSON,
  PlacementMode.HEX
};
int placementModeIndex = 1; // 0=GRID, 1=POISSON, 2=HEX
final int MAX_SITE_COUNT = 50000;
final int DEFAULT_SITE_COUNT = 10000;
int siteTargetCount = DEFAULT_SITE_COUNT; // slider maps 0..MAX_SITE_COUNT
float siteFuzz = 0.0f;       // 0..1
boolean keepPropertiesOnGenerate = false;

// Zones (biomes) painting
int activeBiomeIndex = 1;                 // 0 = "None", 1..N = types
int activeZoneIndex = 1;                  // 0 = "None", 1..N = zones
ZonePaintMode currentZonePaintMode = ZonePaintMode.ZONE_PAINT;
ZonePaintMode currentBiomePaintMode = ZonePaintMode.ZONE_PAINT;
int activePathTypeIndex = 0;
int pathRouteModeIndex = 1; // 0=ENDS,1=PATHFIND
float zoneBrushRadius = 0.04f;
float seaLevel = -0.2f;
float elevationBrushRadius = 0.08f;
float elevationBrushStrength = 0.05f; // per stroke
boolean elevationBrushRaise = true;
float elevationNoiseScale = 8.0f;
float defaultElevation = 0.05f;

// Render toggles
float renderLightAzimuthDeg = 220.0f;   // 0..360, 0 = +X (east)
float renderLightAltitudeDeg = 45.0f;   // 0..90, 90 = overhead
boolean useNewElevationShading = false;
float flattestSlopeBias = FLATTEST_BIAS_MIN; // slope penalty in PATHFIND mode (min..max, 0 = shortest)
boolean pathAvoidWater = false;
boolean pathTaperRivers = false;
boolean pathEraserMode = false;
float pathEraserRadius = 0.04f;
int PATH_MAX_EXPANSIONS = 4000; // tweakable pathfinding budget per query (per-direction if bidirectional)
boolean PATH_BIDIRECTIONAL = true; // grow paths from both ends
int ELEV_STEPS_PATHS = 6;
boolean siteDirtyDuringDrag = false;
float renderPaddingPct = 0.01f; // fraction of min(screenW, screenH) cropped from all sides
float exportScale = 1.0f; // multiplier for PNG export resolution (relative to DEFAULT_VIEW_ZOOM)
// Nominal initial viewport zoom (matches Viewport constructor); used as label scale reference.
final float DEFAULT_VIEW_ZOOM = 600.0f;
boolean fullGenRunning = false;
int fullGenStep = 0;
boolean fullGenPrimed = false;
Tool prevTool = Tool.EDIT_SITES;
// Render prep staging is currently disabled; flags kept for compatibility.
boolean renderPrepRunning = false;
boolean renderPrepDone = false;
boolean renderPrepPrimed = false;
String lastExportStatus = "";
boolean renderContoursDirty = true;
boolean renderForceDirtyAll = false;
boolean renderingForExport = false;
PGraphics exportPreview = null;
boolean exportPreviewDirty = true;
float[] exportPreviewRect = new float[4]; // x, y, w, h in world units
public void markRenderDirty() {
  renderContoursDirty = true;
  renderPrepDone = false;
  renderForceDirtyAll = true;
  exportPreviewDirty = true;
  if (mapModel != null && mapModel.renderer != null) {
    mapModel.renderer.invalidateCoastCache();
    mapModel.renderer.invalidateBiomeCache();
    mapModel.renderer.invalidateBiomeOutlineLayer();
    mapModel.renderer.invalidateZoneCache();
    mapModel.renderer.invalidateLightCache();
    mapModel.renderer.invalidateCellBorderLayer();
    mapModel.renderer.invalidateElevationLineLayer();
    mapModel.renderer.invalidateWaterDetailLayer();
  }
}

// Trigger a render rebuild without forcing contour/grid recomputation
public void markRenderVisualChange() {
  renderPrepDone = false;
  exportPreviewDirty = true;
}

public void markExportPreviewDirty() {
  exportPreviewDirty = true;
}

public void syncLegacyWaterContourAlpha(RenderSettings target) {
  if (target == null) return;
  target.waterContourAlpha01 = target.waterCoastAlpha01;
}

public float labelSizeDefault() {
  return labelSizeDefaultVal;
}

public void setLabelSizeDefault(float v) {
  labelSizeDefaultVal = constrain(v, 4, 72);
}

// Zone renaming state
int editingBiomeNameIndex = -1;
String biomeNameDraft = "";
int editingZoneNameIndex = -1;
String zoneNameDraft = "";
boolean editingZoneComment = false;
String zoneCommentDraft = "";

// Biome generation settings
String[] biomeGenerateModes = {
  "Propagation",
  "Reset",
  "Fill gaps",
  "Replace gaps",
  "Fill under",
  "Fill above",
  "Extend",
  "Shrink",
  "Spots",
  "Vary",
  "Slice spot",
  "Full"
};
int biomeGenerateModeIndex = 0;
float biomeGenerateValue01 = 0.75f;

// Label editing state
int editingLabelIndex = -1;
int selectedLabelIndex = -1;
String labelDraft = "label";
LabelTarget labelTargetMode = LabelTarget.FREE;
float labelSizeDefaultVal = 12;
int editingLabelCommentIndex = -1;
String labelCommentDraft = "";

// Path type editing state
int editingPathTypeNameIndex = -1;
String pathTypeNameDraft = "";

// Path name editing state
int editingPathNameIndex = -1;
String pathNameDraft = "";
int editingPathCommentIndex = -1;
String pathCommentDraft = "";

// Structure selection state
HashSet<Integer> selectedStructureIndices = new HashSet<Integer>();
int primaryStructureIndex = -1;
boolean editingStructureName = false;
int editingStructureNameIndex = -1;
String structureNameDraft = "";
boolean editingStructureComment = false;
String structureCommentDraft = "";
int structGenTownCount = 3;
float structGenBuildingDensity = 0.5f; // 0..1

class StructureSelectionInfo {
  boolean hasSelection = false;
  boolean nameMixed = false;
  boolean sizeMixed = false;
  boolean angleMixed = false;
  boolean ratioMixed = false;
  boolean shapeMixed = false;
  boolean alignmentMixed = false;
  boolean hueMixed = false;
  boolean satMixed = false;
  boolean alphaMixed = false;
  boolean strokeMixed = false;
  boolean commentMixed = false;

  String sharedName = "";
  String sharedComment = "";
  float sharedSize = 0.02f;
  float sharedAngleRad = 0.0f;
  float sharedRatio = 1.0f;
  StructureShape sharedShape = StructureShape.RECTANGLE;
  StructureSnapMode sharedAlignment = StructureSnapMode.NEXT_TO_PATH;
  float sharedHue = 0.0f;
  float sharedSat = 0.0f;
  float sharedAlpha = 1.0f;
  float sharedStroke = 1.4f;
}

public StructureSelectionInfo gatherStructureSelectionInfo() {
  StructureSelectionInfo info = new StructureSelectionInfo();
  info.sharedName = structureNameDraft;
  info.sharedComment = structureCommentDraft;
  info.sharedSize = structureSize;
  info.sharedAngleRad = structureAngleOffsetRad;
  info.sharedRatio = structureAspectRatio;
  info.sharedShape = structureShape;
  info.sharedAlignment = structureSnapMode;
  info.sharedHue = structureHue01;
  info.sharedSat = structureSat01;
  info.sharedAlpha = structureAlpha01;
  info.sharedStroke = structureStrokePx;

  if (mapModel == null || mapModel.structures == null || selectedStructureIndices == null || selectedStructureIndices.isEmpty()) {
    return info;
  }

  ArrayList<Integer> invalid = new ArrayList<Integer>();
  boolean first = true;
  for (int idx : selectedStructureIndices) {
    if (idx < 0 || idx >= mapModel.structures.size()) {
      invalid.add(idx);
      continue;
    }
    Structure s = mapModel.structures.get(idx);
    if (s == null) {
      invalid.add(idx);
      continue;
    }
    if (first) {
      info.sharedName = (s.name != null) ? s.name : "";
      info.sharedComment = (s.comment != null) ? s.comment : "";
      info.sharedSize = s.size;
      info.sharedAngleRad = s.angle;
      info.sharedRatio = s.aspect;
      info.sharedShape = s.shape;
      info.sharedAlignment = s.alignment;
      info.sharedHue = s.hue01;
      info.sharedSat = s.sat01;
      info.sharedAlpha = s.alpha01;
      info.sharedStroke = s.strokeWeightPx;
      first = false;
      continue;
    }
    if (!info.nameMixed) {
      String nm = (s.name != null) ? s.name : "";
      info.nameMixed = !nm.equals(info.sharedName);
    }
    if (!info.commentMixed) {
      String cm = (s.comment != null) ? s.comment : "";
      info.commentMixed = !cm.equals(info.sharedComment);
    }
    if (!info.sizeMixed && abs(info.sharedSize - s.size) > 1e-6f) info.sizeMixed = true;
      if (!info.angleMixed && abs(info.sharedAngleRad - s.angle) > 1e-6f) info.angleMixed = true;
    if (!info.ratioMixed && abs(info.sharedRatio - s.aspect) > 1e-6f) info.ratioMixed = true;
    if (!info.shapeMixed && info.sharedShape != s.shape) info.shapeMixed = true;
    if (!info.alignmentMixed && info.sharedAlignment != s.alignment) info.alignmentMixed = true;
    if (!info.hueMixed && abs(info.sharedHue - s.hue01) > 1e-6f) info.hueMixed = true;
    if (!info.satMixed && abs(info.sharedSat - s.sat01) > 1e-6f) info.satMixed = true;
    if (!info.alphaMixed && abs(info.sharedAlpha - s.alpha01) > 1e-6f) info.alphaMixed = true;
    if (!info.strokeMixed && abs(info.sharedStroke - s.strokeWeightPx) > 1e-6f) info.strokeMixed = true;
  }

  for (int idx : invalid) {
    selectedStructureIndices.remove(idx);
  }

  if (first) return info;
  info.hasSelection = true;

  // Keep UI draft values in sync when there's a clear consensus.
  if (!info.nameMixed) structureNameDraft = info.sharedName;
  if (!info.commentMixed) structureCommentDraft = info.sharedComment;
  if (!info.sizeMixed) structureSize = info.sharedSize;
  if (!info.angleMixed) structureAngleOffsetRad = info.sharedAngleRad;
  if (!info.ratioMixed) structureAspectRatio = info.sharedRatio;
  if (!info.shapeMixed) structureShape = info.sharedShape;
  if (!info.alignmentMixed) structureSnapMode = info.sharedAlignment;
  if (!info.hueMixed) structureHue01 = info.sharedHue;
  if (!info.satMixed) structureSat01 = info.sharedSat;
  if (!info.alphaMixed) structureAlpha01 = info.sharedAlpha;
  if (!info.strokeMixed) structureStrokePx = info.sharedStroke;
  return info;
}

public boolean isStructureSelected(int idx) {
  return selectedStructureIndices != null && selectedStructureIndices.contains(idx);
}

public void clearStructureSelection() {
  if (selectedStructureIndices != null) selectedStructureIndices.clear();
  primaryStructureIndex = -1;
  editingStructureName = false;
  editingStructureNameIndex = -1;
  editingStructureComment = false;
}

public void toggleStructureSelection(int idx) {
  if (selectedStructureIndices == null) selectedStructureIndices = new HashSet<Integer>();
  if (selectedStructureIndices.contains(idx)) {
    selectedStructureIndices.remove(idx);
    if (primaryStructureIndex == idx) {
      primaryStructureIndex = selectedStructureIndices.isEmpty() ? -1 : selectedStructureIndices.iterator().next();
    }
  } else {
    selectedStructureIndices.add(idx);
    primaryStructureIndex = idx;
  }
  if (selectedStructureIndices.isEmpty()) {
    editingStructureName = false;
    editingStructureNameIndex = -1;
  }
}

public void selectStructureExclusive(int idx) {
  clearStructureSelection();
  if (selectedStructureIndices == null) selectedStructureIndices = new HashSet<Integer>();
  if (idx >= 0) {
    selectedStructureIndices.add(idx);
    primaryStructureIndex = idx;
  }
}

public void shiftStructureSelectionAfterRemoval(int removedIdx) {
  if (selectedStructureIndices == null || selectedStructureIndices.isEmpty()) return;
  HashSet<Integer> updated = new HashSet<Integer>();
  for (int idx : selectedStructureIndices) {
    if (idx == removedIdx) continue;
    int adjusted = (idx > removedIdx) ? idx - 1 : idx;
    if (adjusted >= 0) updated.add(adjusted);
  }
  selectedStructureIndices = updated;
  if (!selectedStructureIndices.contains(primaryStructureIndex)) {
    primaryStructureIndex = selectedStructureIndices.isEmpty() ? -1 : selectedStructureIndices.iterator().next();
  }
  if (selectedStructureIndices.isEmpty()) {
    editingStructureName = false;
    editingStructureNameIndex = -1;
  }
}

// Loading indicator
boolean isLoading = false;
float loadingPhase = 0;
int loadingHoldFrames = 0;
float loadingPct = 0;
String uiNotice = "";
int uiNoticeFrames = 0;
final int NOTICE_DURATION_FRAMES = 150;
String loadingDetail = "";
// Unified progress indicator (top bar uses this)
boolean progressActive = false;   // whether to show a bar
float progressPct = 0.0f;         // 0..1
String progressDetail = "";       // message next to bar
String progressStatusMsg = "";    // status text (shown even if bar hidden)

public void setProgressStatus(String msg) {
  if (msg == null) msg = "";
  if (!msg.equals(progressStatusMsg)) progressStatusMsg = msg;
}

// Slider drag state
final int SLIDER_NONE = 0;
final int SLIDER_SITES_DENSITY = 1;
final int SLIDER_SITES_FUZZ = 2;
final int SLIDER_SITES_MODE = 3;
final int SLIDER_BIOME_HUE = 4;
final int SLIDER_BIOME_BRUSH = 5;
final int SLIDER_ELEV_SEA = 6;
final int SLIDER_ELEV_RADIUS = 7;
final int SLIDER_ELEV_STRENGTH = 8;
final int SLIDER_ELEV_NOISE = 9;
final int SLIDER_PATH_TYPE_HUE = 10;
final int SLIDER_PATH_TYPE_SAT = 11;
final int SLIDER_PATH_TYPE_BRI = 12;
final int SLIDER_PATH_TYPE_WEIGHT = 13;
final int SLIDER_FLATTEST_BIAS = 14;
final int SLIDER_RENDER_LIGHT_AZIMUTH = 15;
final int SLIDER_RENDER_LIGHT_ALTITUDE = 16;
final int SLIDER_STRUCT_SIZE = 17;
final int SLIDER_ZONES_HUE = 18;
final int SLIDER_ZONES_BRUSH = 19;
final int SLIDER_STRUCT_ANGLE = 20;
final int SLIDER_PATH_TYPE_MIN_WEIGHT = 21;
final int SLIDER_STRUCT_RATIO = 22;
final int SLIDER_ZONES_ROW_HUE = 23;
final int SLIDER_STRUCT_SELECTED_SIZE = 24;
final int SLIDER_STRUCT_SELECTED_ANGLE = 25;
final int SLIDER_STRUCT_SELECTED_HUE = 26;
final int SLIDER_STRUCT_SELECTED_ALPHA = 27;
final int SLIDER_STRUCT_SELECTED_SAT = 28;
final int SLIDER_STRUCT_SELECTED_STROKE = 29;
final int SLIDER_RENDER_PADDING = 30;
final int SLIDER_RENDER_LAND_H = 32;
final int SLIDER_RENDER_LAND_S = 33;
final int SLIDER_RENDER_LAND_B = 34;
final int SLIDER_RENDER_WATER_H = 35;
final int SLIDER_RENDER_WATER_S = 36;
final int SLIDER_RENDER_WATER_B = 37;
final int SLIDER_RENDER_CELL_BORDER_ALPHA = 38;
final int SLIDER_RENDER_BIOME_FILL_ALPHA = 39;
final int SLIDER_RENDER_BIOME_SAT = 40;
final int SLIDER_RENDER_BIOME_OUTLINE_SIZE = 41;
final int SLIDER_RENDER_BIOME_OUTLINE_ALPHA = 42;
final int SLIDER_RENDER_WATER_DEPTH_ALPHA = 43;
final int SLIDER_RENDER_LIGHT_ALPHA = 44;
final int SLIDER_RENDER_WATER_CONTOUR_SIZE = 45;
final int SLIDER_RENDER_WATER_RIPPLE_COUNT = 46;
final int SLIDER_RENDER_WATER_RIPPLE_DIST = 47;
final int SLIDER_RENDER_WATER_CONTOUR_H = 48;
final int SLIDER_RENDER_WATER_CONTOUR_S = 49;
final int SLIDER_RENDER_WATER_CONTOUR_B = 50;
final int SLIDER_RENDER_WATER_CONTOUR_ALPHA = 51;
final int SLIDER_RENDER_WATER_RIPPLE_ALPHA_START = 52;
final int SLIDER_RENDER_WATER_RIPPLE_ALPHA_END = 53;
final int SLIDER_RENDER_ELEV_LINES_COUNT = 54;
final int SLIDER_RENDER_ELEV_LINES_ALPHA = 55;
final int SLIDER_RENDER_PATH_SAT = 56;
final int SLIDER_RENDER_ZONE_ALPHA = 57;
final int SLIDER_RENDER_ZONE_SIZE = 58;
final int SLIDER_RENDER_ZONE_SAT = 59;
final int SLIDER_RENDER_LABEL_OUTLINE_ALPHA = 60;
final int SLIDER_RENDER_BIOME_BRI = 62;
final int SLIDER_RENDER_ZONE_BRI = 63;
final int SLIDER_RENDER_PRESET_SELECT = 64;
final int SLIDER_RENDER_PATH_BRI = 90;
final int SLIDER_RENDER_LABEL_OUTLINE_SIZE = 91;
final int SLIDER_RENDER_LABEL_SIZE_ARBITRARY = 92;
final int SLIDER_RENDER_LABEL_SIZE_ZONES = 93;
final int SLIDER_RENDER_LABEL_SIZE_PATHS = 94;
final int SLIDER_RENDER_LABEL_SIZE_STRUCTS = 95;
final int SLIDER_RENDER_LABEL_FONT = 96;
final int SLIDER_BIOME_GEN_MODE = 65;
final int SLIDER_BIOME_GEN_VALUE = 66;
final int SLIDER_RENDER_BIOME_UNDERWATER_ALPHA = 67;
final int SLIDER_RENDER_STRUCT_SHADOW_ALPHA = 68;
final int SLIDER_BIOME_SAT = 69;
final int SLIDER_BIOME_BRI = 70;
final int SLIDER_RENDER_BACKGROUND_NOISE = 71;
final int SLIDER_RENDER_WATER_HATCH_ANGLE = 72;
final int SLIDER_RENDER_WATER_HATCH_LENGTH = 73;
final int SLIDER_RENDER_WATER_HATCH_SPACING = 74;
final int SLIDER_RENDER_WATER_HATCH_ALPHA = 75;
final int SLIDER_RENDER_LIGHT_DITHER = 76;
final int SLIDER_BIOME_PATTERN = 97;
final int SLIDER_PATH_ROUTE_MODE = 98;
final int SLIDER_STRUCT_GEN_TOWN = 99;
final int SLIDER_STRUCT_GEN_BUILDING = 100;
final int SLIDER_STRUCT_SNAP_DIV = 101;
final int SLIDER_STRUCT_SHAPE = 102;
final int SLIDER_STRUCT_ALIGNMENT = 103;
final int SLIDER_RENDER_CELL_BORDER_SIZE = 104;
final int SLIDER_RENDER_ELEV_LINES_SIZE = 105;
final int SLIDER_RENDER_WATER_COAST_SIZE = 106;
int activeSlider = SLIDER_NONE;


public void applyRenderPreset(int idx) {
  if (renderPresets == null || renderPresets.length == 0) return;
  int clamped = constrain(idx, 0, renderPresets.length - 1);
  RenderPreset p = renderPresets[clamped];
  if (p == null || p.values == null) return;
  renderSettings.applyFrom(p.values);
  renderSettings.activePresetIndex = clamped;
  syncLegacyWaterContourAlpha(renderSettings);
  // Keep legacy padding in sync until full migration
  renderPaddingPct = renderSettings.exportPaddingPct;
  markRenderDirty();
}

public void applyBiomeGeneration() {
  if (mapModel == null || mapModel.cells == null) return;
  int mode = constrain(biomeGenerateModeIndex, 0, biomeGenerateModes.length - 1);
  int targetBiome = constrain(activeBiomeIndex, 0, mapModel.biomeTypes.size() - 1);
  float val01 = constrain(biomeGenerateValue01, 0, 1);
  float threshold = lerp(-1.0f, 1.0f, val01);

  switch (mode) {
    case 0: // propagation
      mapModel.resetAllBiomesToNone();
      if (mapModel.cells != null && !mapModel.cells.isEmpty()) {
        int cellCount = mapModel.cells.size();
        int minSeeds = max(1, round(cellCount / 200.0f));
        int maxSeeds = max(1, round(cellCount / 10.0f));
        int seedCount = (int)constrain(round(lerp(minSeeds, maxSeeds, val01)), 1, cellCount);
        mapModel.generateZonesFromSeeds(seedCount);
      }
      break;
    case 1: // reset
      mapModel.setAllBiomesTo(targetBiome);
      break;
    case 2: // fill gaps
      mapModel.fillGapsFromExistingBiomes();
      break;
    case 3: // replace gaps
      if (mapModel.cells != null && !mapModel.cells.isEmpty()) {
        int gapCount = 0;
        for (Cell c : mapModel.cells) {
          if (c != null && c.biomeId == 0) gapCount++;
        }
        if (gapCount > 0) {
          int minSeeds = max(1, round(gapCount / 200.0f));
          int maxSeeds = max(1, round(gapCount / 10.0f));
          int seedCount = (int)constrain(round(lerp(minSeeds, maxSeeds, val01)), 1, gapCount);
          mapModel.fillGapsWithNewBiomesByCount(seedCount);
        }
      }
      break;
    case 4: // fill under
      mapModel.fillUnderThreshold(targetBiome, threshold);
      break;
    case 5: // fill above
      mapModel.fillAboveThreshold(targetBiome, threshold);
      break;
    case 6: // extend
      {
        int steps = max(1, round(lerp(1, 30, val01)));
        for (int i = 0; i < steps; i++) mapModel.extendBiomeOnce(targetBiome);
      }
      break;
    case 7: // shrink
      {
        int steps = max(1, round(lerp(1, 30, val01)));
        for (int i = 0; i < steps; i++) mapModel.shrinkBiomeOnce(targetBiome);
      }
      break;
    case 8: // spots
      if (mapModel.cells != null && !mapModel.cells.isEmpty()) {
        int n = mapModel.cells.size();
        int maxSpots = max(1, min(30, round(n / 200.0f)));
        int spotCount = (int)constrain(round(lerp(1, maxSpots, val01)), 1, maxSpots);
        mapModel.placeBiomeSpots(targetBiome, spotCount, 0.6f);
      }
      break;
    case 9: // vary
      {
        int steps = max(1, round(lerp(1, 20, val01)));
        for (int i = 0; i < steps; i++) mapModel.varyBiomesOnce();
      }
      break;
    case 10: // slice spot
      mapModel.placeSliceSpot(targetBiome, val01, threshold);
      break;
    case 11: // full pipeline
    default:
      int forestIdx = ensureBiomeType("Forest");
      int wetIdx = ensureBiomeType("Wet");
      int sandIdx = ensureBiomeType("Sand");
      int rockIdx = ensureBiomeType("Rock");
      int snowIdx = ensureBiomeType("Snow");
      int magmaIdx = ensureBiomeType("Magma");
      int grassIdx = ensureBiomeType("Grassland");
      boolean hasNoneCell = false;
      int cellCount = mapModel.cells.size();
      for (int i = 0; i < cellCount && !hasNoneCell ; i++) if (mapModel.cells.get(i) != null) hasNoneCell = true;
      if (hasNoneCell) mapModel.resetAllBiomesToNone();
      mapModel.fillGapsWithNewBiomes(150);
      if (magmaIdx >= 0) for (int i = 0; i < 8; i++) mapModel.shrinkBiomeOnce(magmaIdx);
      if (wetIdx >= 0) for (int i = 0; i < 8; i++) mapModel.shrinkBiomeOnce(wetIdx);
      if (forestIdx >= 0) for (int i = 0; i < 5; i++) mapModel.placeBiomeSpots(forestIdx, 0.5f);
      if (forestIdx >= 0) mapModel.placeSliceSpot(forestIdx, 0.8f, 0.24f);
      if (rockIdx >= 0) mapModel.placeSliceSpot(rockIdx, 0.8f, 0.36f);
      if (snowIdx >= 0) mapModel.fillAboveThreshold(snowIdx, 0.48f);
      if (magmaIdx >= 0) mapModel.fillAboveThreshold(magmaIdx, 0.6f);
      if (grassIdx >= 0) mapModel.extendBiomeOnce(grassIdx);
      if (forestIdx >= 0) mapModel.shrinkBiomeOnce(forestIdx);
      if (wetIdx >= 0) mapModel.fillUnderThreshold(wetIdx, seaLevel);
      if (sandIdx >= 0) for (int i = 0; i < 7; i++) mapModel.placeSliceSpot(sandIdx, 0.8f, seaLevel);
      mapModel.varyBiomesOnce();
      break;
  }
  mapModel.renderer.invalidateBiomeOutlineCache();
  mapModel.snapDirty = true;
}

// Full auto-pipeline starting from existing cells
public void startFullGenerateFromCells() {
  if (mapModel == null) return;
  if (fullGenRunning) return;
  fullGenRunning = true;
  fullGenStep = 0;
  fullGenPrimed = false;
  loadingPct = 0.0f;
  startLoading();
}

public void resetAllMapData() {
  startLoading();
  try {
    mapModel = new MapModel();
    loadBiomePatternList();
    initBiomeTypes();
    initZones();
    initPathTypes();

    // Reset selections / drafts
    selectedPathIndex = -1;
    pendingPathStart = null;
    clearStructureSelection();
    selectedLabelIndex = -1;
    editingLabelIndex = -1;
    editingLabelCommentIndex = -1;
    labelDraft = "label";
    labelCommentDraft = "";
    editingPathNameIndex = -1;
    editingPathCommentIndex = -1;
    editingPathTypeNameIndex = -1;
    activeBiomeIndex = 1;
    activeZoneIndex = 1;
    zonesListScroll = pathsListScroll = structuresListScroll = labelsListScroll = 0;
    mapModel.snapDirty = true;
    markRenderDirty();
  } finally {
    stopLoading();
    progressActive = false;
    progressDetail = "";
    progressPct = 0;
  }
}

// Request staged render prep (used when entering heavy modes or after invalidation)
public void requestRenderPrep() {
  if (mapModel == null || mapModel.renderer == null) return;
  mapModel.renderer.resetRenderPrep(renderForceDirtyAll);
  renderForceDirtyAll = false;
  renderPrepRunning = false;
  renderPrepDone = true;
  renderPrepPrimed = false;
  exportPreviewDirty = true;
}

public void triggerRenderPrerequisites() {
  if (mapModel == null || renderSettings == null) return;
  if (renderSettings.waterRippleCount > 0 &&
      renderSettings.waterRippleDistancePx > 1e-4f &&
      (renderSettings.waterRippleAlphaStart01 > 1e-4f || renderSettings.waterRippleAlphaEnd01 > 1e-4f)) {
    int cols = max(80, min(200, (int)(sqrt(max(1, mapModel.cells.size())))));
    int rows = cols;
    mapModel.getCoastDistanceGrid(cols, rows, seaLevel);
  }
  if (renderSettings.elevationLinesCount > 0 && renderSettings.elevationLinesAlpha01 > 1e-4f) {
    mapModel.getElevationGridForRender(90, 90, seaLevel);
  }
}

public void triggerRenderPrerequisitesIfDirty() {
  if (mapModel == null || renderSettings == null) return;
  if (!renderContoursDirty) return;
  if (mapModel.isContourJobRunning()) return;
  renderContoursDirty = false;
  triggerRenderPrerequisites();
  // Kick off staged render prep when already in heavy modes.
  if (currentTool == Tool.EDIT_RENDER || currentTool == Tool.EDIT_LABELS) {
    requestRenderPrep();
  }
}

public int ensureBiomeType(String name) {
  if (mapModel == null || mapModel.biomeTypes == null || name == null) return -1;
  for (int i = 0; i < mapModel.biomeTypes.size(); i++) {
    ZoneType zt = mapModel.biomeTypes.get(i);
    if (zt != null && zt.name != null && zt.name.equalsIgnoreCase(name)) {
      return i;
    }
  }
  int col = color(200);
  for (ZonePreset zp : ZONE_PRESETS) {
    if (zp != null && zp.name != null && zp.name.equalsIgnoreCase(name)) {
      col = zp.col;
      break;
    }
  }
  ZoneType z = new ZoneType(name, col);
  z.patternIndex = mapModel.defaultPatternIndexForBiome(mapModel.biomeTypes.size());
  mapModel.biomeTypes.add(z);
  return mapModel.biomeTypes.size() - 1;
}

public float sliderFromElevation(float elev) {
  return constrain(map(elev, -1.0f, 1.0f, 0, 1), 0, 1);
}

public int hsb01ToColor(float h, float s, float b) {
  colorMode(HSB, 1.0f);
  int c = color(constrain(h, 0, 1), constrain(s, 0, 1), constrain(b, 0, 1));
  colorMode(RGB, 255);
  return c;
}

public void settings() {
  size(1300, 800, P2D);
}

public void setup() {
  surface.setTitle("map designing tool");
  viewport = new Viewport();
  mapModel = new MapModel();
  applyRenderPreset(0);
  loadBiomePatternList();
  initBiomeTypes();
  initZones();
  initPathTypes();
  // Prime label font cache early to avoid first render/label stutter.
  if (mapModel != null && mapModel.renderer != null) {
    mapModel.renderer.warmLabelFonts(this, renderSettings);
  }
  mapModel.generateSites(currentPlacementMode(), siteTargetCount);
  mapModel.ensureVoronoiComputed();
  seedDefaultZones();
  initTooltipTexts();
}

public void initBiomeTypes() {
  mapModel.biomeTypes.clear();
  ZoneType none = new ZoneType("None",  color(235));
  none.patternIndex = mapModel.defaultPatternIndexForBiome(mapModel.biomeTypes.size());
  mapModel.biomeTypes.add(none);

  // Seed with the first few presets for quick access; more can be added via "+".
  int initialCount = 5;
  for (int i = 0; i < initialCount && i < ZONE_PRESETS.length; i++) {
    ZonePreset zp = ZONE_PRESETS[i];
    ZoneType z = new ZoneType(zp.name, zp.col);
    z.patternIndex = mapModel.defaultPatternIndexForBiome(mapModel.biomeTypes.size());
    mapModel.biomeTypes.add(z);
  }
  mapModel.syncBiomePatternAssignments();
}

public void initZones() {
  mapModel.zones.clear();
  activeZoneIndex = -1;
}

public void initPathTypes() {
  mapModel.pathTypes.clear();
  int initialCount = min(4, PATH_TYPE_PRESETS.length);
  for (int i = 0; i < initialCount; i++) {
    PathType pt = mapModel.makePathTypeFromPreset(i);
    if (pt != null) {
      mapModel.pathTypes.add(pt);
    }
  }
  if (mapModel.pathTypes.isEmpty()) {
    mapModel.pathTypes.add(new PathType("Path", color(80), 2.0f, 1.0f, PathRouteMode.PATHFIND, 0.0f, true, false));
  }
  activePathTypeIndex = 0;
  syncActivePathTypeGlobals();
}

public void syncActivePathTypeGlobals() {
  if (mapModel == null || mapModel.pathTypes == null || mapModel.pathTypes.isEmpty()) return;
  activePathTypeIndex = constrain(activePathTypeIndex, 0, mapModel.pathTypes.size() - 1);
  PathType pt = mapModel.pathTypes.get(activePathTypeIndex);
  if (pt == null) return;
  pathRouteModeIndex = (pt.routeMode == PathRouteMode.ENDS) ? 0 : 1;
  flattestSlopeBias = pt.slopeBias;
  pathAvoidWater = pt.avoidWater;
}

public void drawExportPaddingOverlay() {
  if (mapModel == null) return;
  float worldW = mapModel.maxX - mapModel.minX;
  float worldH = mapModel.maxY - mapModel.minY;
  float padX = max(0, renderPaddingPct) * worldW;
  float padY = max(0, renderPaddingPct) * worldH;
  float innerWX = mapModel.minX + padX;
  float innerWY = mapModel.minY + padY;
  float innerWW = max(0, worldW - padX * 2);
  float innerWH = max(0, worldH - padY * 2);
  if (innerWW <= 0 || innerWH <= 0) return;

  PVector tl = viewport.worldToScreen(innerWX, innerWY);
  PVector br = viewport.worldToScreen(innerWX + innerWW, innerWY + innerWH);
  float innerX = min(tl.x, br.x);
  float innerY = min(tl.y, br.y);
  float innerW = abs(br.x - tl.x);
  float innerH = abs(br.y - tl.y);
  noStroke();
  fill(80, 80, 80, 70);
  rect(0, 0, width, innerY); // top
  rect(0, innerY, innerX, innerH); // left
  rect(innerX + innerW, innerY, width - (innerX + innerW), innerH); // right
  rect(0, innerY + innerH, width, height - (innerY + innerH)); // bottom

  noFill();
  stroke(40, 40, 40, 180);
  strokeWeight(1);
  rect(innerX, innerY, innerW, innerH);
}

public void draw() {
  background(245);
  loadingDetail = "";
  if (currentTool != prevTool) {
    if (currentTool == Tool.EDIT_EXPORT) exportPreviewDirty = true;
    prevTool = currentTool;
  }

  // Drive incremental Voronoi rebuilds; loading state follows the job
  if (fullGenRunning) {
    if (!isLoading) startLoading();
    stepFullGenerateFromCells();
    // Safety: if full gen steps exceeded, clear flags.
    if (fullGenStep > 5) {
      fullGenRunning = false;
      stopLoading();
      loadingDetail = "";
      loadingPct = 1.0f;
    }
  }
  mapModel.ensureVoronoiComputed();
  mapModel.stepContourJobs(6);
  boolean buildingVoronoi = mapModel.isVoronoiBuilding();
  boolean buildingContours = mapModel.isContourJobRunning();
  boolean building = buildingVoronoi || buildingContours;
  float pctVoronoi = mapModel.getVoronoiProgress();
  float pctContours = mapModel.getContourJobProgress();
  float combinedPct = buildingContours ? min(pctVoronoi, pctContours) : pctVoronoi;
  if (!fullGenRunning) {
    if (building) {
      if (buildingVoronoi) {
        setProgressStatus("Generating cells...");
      } else if (buildingContours) {
        setProgressStatus("Generating contours...");
      }
      if (!isLoading) startLoading();
      loadingPct = combinedPct;
    } else {
      if (isLoading) {
        stopLoading();
      }
      setProgressStatus("");
      if (uiNotice != null && uiNotice.equals("Generation in progress...")) {
        uiNotice = "";
        uiNoticeFrames = 0;
      }
      loadingPct = 1.0f;
    }
  } else {
    // If full gen is running and all jobs plus steps are done, clear loading.
    if (!building && fullGenStep > 5) {
      fullGenRunning = false;
      stopLoading();
      loadingPct = 1.0f;
      loadingDetail = "";
      setProgressStatus("");
      progressActive = false;
      progressPct = 0;
      if (uiNotice != null && uiNotice.equals("Generation in progress...")) {
        uiNotice = "";
        uiNoticeFrames = 0;
      }
    }
  }
  // When generation is running, show its status in the top bar.
  if (fullGenRunning) {
    setProgressStatus((loadingDetail != null && loadingDetail.length() > 0)
      ? loadingDetail
      : "Generation in progress...");
  }

  boolean renderView = (currentTool == Tool.EDIT_RENDER || currentTool == Tool.EDIT_EXPORT);
  // Run one render-prep stage per frame when needed (before world draw so UI can update).
  if (renderView && mapModel != null && mapModel.renderer != null) {
    if (mapModel.renderer.isRenderWorkNeeded()) {
      renderPrepRunning = true;
      progressActive = true;
      progressPct = max(progressPct, mapModel.renderer.renderPrepProgress());
      progressDetail = "Rendering " + mapModel.renderer.getRenderPrepStageLabel();
      if (!fullGenRunning) setProgressStatus("Rendering...");
      boolean donePrep = mapModel.renderer.stepRenderPrep(this, renderSettings, seaLevel);
      progressPct = max(progressPct, mapModel.renderer.renderPrepProgress());
      if (donePrep || !mapModel.renderer.isRenderWorkNeeded()) {
        renderPrepRunning = false;
        progressActive = false;
        progressDetail = "";
        progressPct = 1;
        if (!fullGenRunning) setProgressStatus("");
      }
    } else {
      renderPrepRunning = false;
      progressActive = false;
      progressDetail = "";
      progressPct = 1;
      if (!fullGenRunning) setProgressStatus("");
    }
  } else {
    renderPrepRunning = false;
  }

  // ----- World rendering -----
  pushMatrix();
  viewport.applyTransform(this.g);

  boolean skipWorld = false;
  if (renderPrepRunning && (currentTool == Tool.EDIT_RENDER || currentTool == Tool.EDIT_LABELS || currentTool == Tool.EDIT_EXPORT)) {
    // While prep is running, skip world to keep UI responsive; cached view will show once ready.
    skipWorld = true;
  }

  if (renderView && !skipWorld) {
    triggerRenderPrerequisitesIfDirty();
    if (mapModel != null && mapModel.renderer != null) {
      if (mapModel.renderer.isRenderWorkNeeded()) {
        renderPrepRunning = true;
        progressActive = true;
        progressPct = max(progressPct, mapModel.renderer.renderPrepProgress());
        progressDetail = "Rendering " + mapModel.renderer.getRenderPrepStageLabel();
        if (!fullGenRunning) setProgressStatus("Rendering...");
        boolean donePrep = mapModel.renderer.stepRenderPrep(this, renderSettings, seaLevel);
        progressPct = max(progressPct, mapModel.renderer.renderPrepProgress());
        if (donePrep || !mapModel.renderer.isRenderWorkNeeded()) {
          renderPrepRunning = false;
          progressActive = false;
          progressDetail = "";
          progressPct = 1;
          if (!fullGenRunning) setProgressStatus("");
        }
      } else {
        renderPrepRunning = false;
        progressActive = false;
        progressDetail = "";
        progressPct = 0;
        if (!fullGenRunning) setProgressStatus("");
      }
    }
    if (currentTool == Tool.EDIT_EXPORT) {
      drawExportPreviewView();
    } else {
      drawRenderView(this);
    }
  } else if (!skipWorld) {
    boolean allowLabels = (renderSettings != null) ? renderSettings.showLabelsArbitrary : true;
    switch (currentTool) {
      case EDIT_SITES: {
        mapModel.drawCells(this, true);
        mapModel.drawPaths(this, color(60, 60, 200), false, true);
        mapModel.drawStructures(this);
        if (allowLabels) mapModel.drawLabels(this);
        mapModel.drawSites(this);
        break;
      }
      case EDIT_ELEVATION: {
        mapModel.drawCellsRender(this, false, true);
        mapModel.drawElevationOverlay(this, seaLevel, false, true, true, false, 128);
        mapModel.drawPaths(this, color(120), false, true);
        mapModel.drawStructures(this);
        if (allowLabels) mapModel.drawLabels(this);
        drawElevationBrushPreview();
        break;
      }
      case EDIT_BIOMES: {
        mapModel.drawCells(this, true);
        mapModel.drawPaths(this, color(60, 60, 200), false, true);
        mapModel.drawStructures(this);
        if (allowLabels) mapModel.drawLabels(this);
        if (currentBiomePaintMode == ZonePaintMode.ZONE_PAINT) drawZoneBrushPreview();
        break;
      }
      case EDIT_ZONES: {
        mapModel.drawCellsRender(this, false, true);
        mapModel.drawElevationOverlay(this, seaLevel, false, true, true, false, ELEV_STEPS_PATHS);
        mapModel.drawZoneOutlines(this);
        mapModel.drawPaths(this, color(60, 60, 200), false, true);
        mapModel.drawStructures(this);
        if (allowLabels) mapModel.drawLabels(this);
        if (currentZonePaintMode == ZonePaintMode.ZONE_PAINT) drawZoneBrushPreview();
        break;
      }
      case EDIT_PATHS: {
        mapModel.drawCellsRender(this, false, true);
        mapModel.drawElevationOverlay(this, seaLevel, false, true, true, false, ELEV_STEPS_PATHS);
        mapModel.drawPaths(this, color(60, 60, 200), true, true);
        mapModel.drawStructures(this);
        if (allowLabels) mapModel.drawLabels(this);
        drawPathSnappingPoints();
        if (pathEraserMode) drawPathEraserPreview();

        // Path preview
        if (pendingPathStart != null) {
          PVector worldPos = viewport.screenToWorld(mouseX, mouseY);
          worldPos.x = constrain(worldPos.x, mapModel.minX, mapModel.maxX);
          worldPos.y = constrain(worldPos.y, mapModel.minY, mapModel.maxY);
          PVector snapped = findNearestSnappingPoint(worldPos.x, worldPos.y, Float.MAX_VALUE);
          PVector target = (snapped != null) ? snapped : pendingPathStart;

          ArrayList<PVector> route = null;
          PathRouteMode mode = currentPathRouteMode();
          if (mode == PathRouteMode.ENDS) {
            route = new ArrayList<PVector>();
            route.add(pendingPathStart);
            route.add(target);
          } else if (mode == PathRouteMode.PATHFIND) {
            if (snapped != null) {
              route = mapModel.findSnapPathFlattest(pendingPathStart, target);
            }
          }
          if (route == null || route.size() < 2) {
            route = new ArrayList<PVector>();
            route.add(pendingPathStart);
            route.add(target);
          }

          PathType pt = null;
          if (selectedPathIndex >= 0 && selectedPathIndex < mapModel.paths.size()) {
            Path p = mapModel.paths.get(selectedPathIndex);
            pt = mapModel.getPathType(p.typeId);
          } else {
            pt = mapModel.getPathType(activePathTypeIndex);
          }
          int col = (pt != null) ? pt.col : color(30, 30, 160);
          float w = (pt != null) ? pt.weightPx : 2.0f;

          Path tmp = new Path();
          tmp.routes.add(route);
          tmp.drawPreview(this, route, col, w);

          // Start/end markers
          pushStyle();
          noStroke();
          fill(255, 180, 0, 200);
          float sr = 5.0f / viewport.zoom;
          ellipse(pendingPathStart.x, pendingPathStart.y, sr, sr);
          if (!route.isEmpty()) {
            PVector end = route.get(route.size() - 1);
            float tr = 4.0f / viewport.zoom;
            fill(80, 120, 240, 160);
            ellipse(end.x, end.y, tr, tr);
          }
          popStyle();
        }
        break;
      }
      case EDIT_STRUCTURES: {
        mapModel.drawCellsRender(this, false, true);
        mapModel.drawElevationOverlay(this, seaLevel, false, true, true, false, ELEV_STEPS_PATHS);
        mapModel.drawPaths(this, color(60, 60, 200), false, true);
        mapModel.drawStructureSnapGuides(this);
        mapModel.drawStructures(this);
        if (allowLabels) mapModel.drawLabels(this);
        drawStructurePreview();
        break;
      }
      case EDIT_LABELS: {
        mapModel.drawCellsRender(this, false, true);
        mapModel.drawElevationOverlay(this, seaLevel, false, true, true, false, ELEV_STEPS_PATHS);
        mapModel.drawPaths(this, color(60, 60, 200), false, true);
        mapModel.drawStructures(this);
        if (allowLabels) {
          RenderSettings rs = new RenderSettings();
          rs.showLabelsZones = true;
          rs.showLabelsPaths = true;
          rs.showLabelsStructures = true;
          rs.showLabelsArbitrary = true;
          rs.labelOutlineAlpha01 = 1.0f;
          rs.labelOutlineSizePx = 2.0f;
          mapModel.drawZoneLabelsRender(this, rs);
          mapModel.drawPathLabelsRender(this, rs);
          mapModel.drawStructureLabelsRender(this, rs);
          mapModel.drawLabelsRender(this, rs);
        }
        break;
      }
      default: {
        mapModel.drawCells(this, true);
        mapModel.drawPaths(this, color(60, 60, 200), false, true);
        mapModel.drawStructures(this);
        if (allowLabels) mapModel.drawLabels(this);
        mapModel.drawDebugWorldBounds(this);
        break;
      }
    }
  }

  popMatrix();

  // Screen-space border for render/export view
  if (renderView) {
    pushStyle();
    noFill();
    stroke(0);
    strokeWeight(2);
    rect(1, 1, width - 2, height - 2);
    popStyle();
  }

  // Ensure UI drawing uses normal coordinate modes (world rendering can change rectMode)
  rectMode(CORNER);
  ellipseMode(CENTER);

  resetUiTooltips();

  if (renderView) {
    drawExportPaddingOverlay();
  }

  // ----- UI overlay -----
  drawTopBar();
  drawToolButtons();
  if (currentTool == Tool.EDIT_SITES) {
    drawSitesPanel();
  } else if (currentTool == Tool.EDIT_ELEVATION) {
    drawElevationPanel();
  } else if (currentTool == Tool.EDIT_BIOMES) {
    drawBiomesPanel();
  } else if (currentTool == Tool.EDIT_ZONES) {
    drawZonesPanel();
    drawZonesListPanel();
  } else if (currentTool == Tool.EDIT_STRUCTURES) {
    drawStructuresPanelUI();
    drawStructuresListPanel();
  } else if (currentTool == Tool.EDIT_PATHS) {
    drawPathsPanel();
    drawPathsListPanel();
  } else if (currentTool == Tool.EDIT_LABELS) {
    drawLabelsPanel();
    drawLabelsListPanel();
  } else if (currentTool == Tool.EDIT_RENDER) {
    drawRenderPanel();
  } else if (currentTool == Tool.EDIT_EXPORT) {
    drawExportPanel();
  }

  refreshUiTooltip(mouseX, mouseY);
  drawUiTooltipPanel();
}

public void drawRenderView(PApplet app) {
  mapModel.drawRenderAdvanced(app, renderSettings, seaLevel);

  // Zone outlines (stroke-only, no fill)
  if (renderSettings.zoneStrokeAlpha01 > 1e-4f) {
    mapModel.drawZoneOutlinesRender(app, renderSettings);
  }

  // Coastlines overlay (optional above zones)
  if (renderSettings.waterCoastAboveZones && renderSettings.waterCoastAlpha01 > 1e-4f) {
    if (mapModel.renderer != null && mapModel.renderer.getCoastLayer() != null) {
      pushStyle();
      pushMatrix();
      resetMatrix();
      tint(255, constrain(renderSettings.waterCoastAlpha01, 0, 1) * 255);
      image(mapModel.renderer.getCoastLayer(), 0, 0);
      popMatrix();
      popStyle();
    } else if (mapModel.renderer != null) {
      mapModel.renderer.ensureCoastLayer(app, renderSettings, seaLevel);
    }
  }

  // Paths
  if (renderSettings.showPaths) {
    mapModel.drawPathsRender(app, renderSettings);
  }

  // Structures
  if (renderSettings.showStructures) {
    mapModel.drawStructuresRender(app, renderSettings);
  }

  // Labels (export: render into a dedicated layer to avoid P2D text issues)
  if (renderingForExport && mapModel != null && mapModel.renderer != null) {
    PGraphics labels = mapModel.renderer.buildLabelLayer(this, renderSettings);
    if (labels != null) {
      pushMatrix();
      resetMatrix();
      image(labels, 0, 0);
      popMatrix();
    }
  } else {
    if (renderSettings.showLabelsZones) mapModel.drawZoneLabelsRender(app, renderSettings);
    if (renderSettings.showLabelsPaths) mapModel.drawPathLabelsRender(app, renderSettings);
    if (renderSettings.showLabelsStructures) mapModel.drawStructureLabelsRender(app, renderSettings);
    if (renderSettings.showLabelsArbitrary) mapModel.drawLabelsRender(app, renderSettings);
  }
}

// Export logic moved to ExportLogic.pde (exportPng/exportSvg/exportMapJson)

public ArrayList<PVector> structureOutline(Structure s) {
  ArrayList<PVector> pts = new ArrayList<PVector>();
  if (s == null) return pts;
  float r = s.size;
  float asp = max(0.1f, s.aspect);
  float cosA = cos(s.angle);
  float sinA = sin(s.angle);

  Runnable addRectangle = new Runnable() {
    public void run() {
      float w = r;
      float h = r / asp;
      float[][] corners = {
        {-w * 0.5f, -h * 0.5f},
        { w * 0.5f, -h * 0.5f},
        { w * 0.5f,  h * 0.5f},
        {-w * 0.5f,  h * 0.5f}
      };
      for (float[] c : corners) {
        float rx = c[0] * cosA - c[1] * sinA;
        float ry = c[0] * sinA + c[1] * cosA;
        pts.add(new PVector(s.x + rx, s.y + ry));
      }
    }
  };

  switch (s.shape) {
    case RECTANGLE: {
      addRectangle.run();
      break;
    }
    case CIRCLE: {
      int segments = 24;
      float rx = r * 0.5f;
      float ry = (r / asp) * 0.5f;
      for (int i = 0; i < segments; i++) {
        float a = TWO_PI * i / (float)segments;
        float cx = cos(a) * rx;
        float cy = sin(a) * ry;
        float rxp = cx * cosA - cy * sinA;
        float ryp = cx * sinA + cy * cosA;
        pts.add(new PVector(s.x + rxp, s.y + ryp));
      }
      break;
    }
    case TRIANGLE: {
      float h = (r / asp) * 0.866f;
      float[][] corners = {
        {-r * 0.5f, h * 0.333f},
        { r * 0.5f, h * 0.333f},
        { 0.0f,     -h * 0.666f}
      };
      for (float[] c : corners) {
        float rx = c[0] * cosA - c[1] * sinA;
        float ry = c[0] * sinA + c[1] * cosA;
        pts.add(new PVector(s.x + rx, s.y + ry));
      }
      break;
    }
    case HEXAGON: {
      float rad = r * 0.5f;
      for (int i = 0; i < 6; i++) {
        float a = radians(60 * i);
        float cx = cos(a) * rad;
        float cy = sin(a) * rad / asp;
        float rx = cx * cosA - cy * sinA;
        float ry = cx * sinA + cy * cosA;
        pts.add(new PVector(s.x + rx, s.y + ry));
      }
      break;
    }
    default: {
      addRectangle.run();
      break;
    }
  }
  return pts;
}

public float elevationAtPoint(float x, float y) {
  if (mapModel == null) return 0;
  return mapModel.sampleElevationAt(x, y, seaLevel);
}

public JSONArray ringFromVertices(ArrayList<PVector> verts) {
  return ringFromVertices(verts, false);
}

public JSONArray ringFromVertices(ArrayList<PVector> verts, boolean includeZ) {
  JSONArray ring = new JSONArray();
  if (verts == null || verts.size() < 3) return ring;
  for (PVector v : verts) {
    JSONArray p = new JSONArray();
    p.append(v.x);
    p.append(v.y);
    if (includeZ) p.append(elevationAtPoint(v.x, v.y));
    ring.append(p);
  }
  PVector first = verts.get(0);
  PVector last = verts.get(verts.size() - 1);
  if (abs(first.x - last.x) > 1e-6f || abs(first.y - last.y) > 1e-6f) {
    JSONArray p = new JSONArray();
    p.append(first.x);
    p.append(first.y);
    if (includeZ) p.append(elevationAtPoint(first.x, first.y));
    ring.append(p);
  }
  return ring;
}

public boolean samePoint(PVector a, PVector b) {
  if (mapModel == null) return false;
  return mapModel.keyFor(a.x, a.y).equals(mapModel.keyFor(b.x, b.y));
}

public ArrayList<ArrayList<PVector>> mergedPolygonsFromCells(ArrayList<Integer> cellIdxs) {
  ArrayList<ArrayList<PVector>> rings = new ArrayList<ArrayList<PVector>>();
  if (mapModel == null || mapModel.cells == null || cellIdxs == null) return rings;
  class Edge { PVector a; PVector b; Edge(PVector a, PVector b){ this.a = a; this.b = b; } }
  HashMap<String, Edge> boundary = new HashMap<String, Edge>();
  for (int ci : cellIdxs) {
    if (ci < 0 || ci >= mapModel.cells.size()) continue;
    Cell c = mapModel.cells.get(ci);
    if (c == null || c.vertices == null || c.vertices.size() < 2) continue;
    int vn = c.vertices.size();
    for (int i = 0; i < vn; i++) {
      PVector a = c.vertices.get(i);
      PVector b = c.vertices.get((i + 1) % vn);
      String ka = mapModel.keyFor(a.x, a.y);
      String kb = mapModel.keyFor(b.x, b.y);
      String key = (ka.compareTo(kb) <= 0) ? (ka + "|" + kb) : (kb + "|" + ka);
      if (boundary.containsKey(key)) {
        boundary.remove(key); // shared edge, not part of boundary
      } else {
        boundary.put(key, new Edge(a, b));
      }
    }
  }
  ArrayList<Edge> edges = new ArrayList<Edge>(boundary.values());
  boolean[] used = new boolean[edges.size()];
  for (int ei = 0; ei < edges.size(); ei++) {
    if (used[ei]) continue;
    Edge e = edges.get(ei);
    ArrayList<PVector> ring = new ArrayList<PVector>();
    ring.add(e.a);
    ring.add(e.b);
    used[ei] = true;
    PVector start = e.a;
    PVector cur = e.b;
    boolean closed = false;
    while (!closed) {
      int nextIdx = -1;
      boolean reverse = false;
      for (int j = 0; j < edges.size(); j++) {
        if (used[j]) continue;
        Edge cand = edges.get(j);
        if (samePoint(cand.a, cur)) { nextIdx = j; reverse = false; break; }
        if (samePoint(cand.b, cur)) { nextIdx = j; reverse = true; break; }
      }
      if (nextIdx == -1) break;
      Edge ne = edges.get(nextIdx);
      used[nextIdx] = true;
      PVector nxt = reverse ? ne.a : ne.b;
      if (reverse) {
        // ensure orientation follows current -> next
        PVector tmp = ne.a; ne.a = ne.b; ne.b = tmp;
      }
      if (samePoint(nxt, start)) {
        closed = true;
      }
      ring.add(nxt);
      cur = nxt;
      if (ring.size() > 100000) break; // safety
    }
    if (ring.size() >= 4) {
      rings.add(ring);
    }
  }
  return rings;
}

public float[] elevationStatsForCells(ArrayList<Integer> cellIdxs) {
  if (cellIdxs == null || mapModel == null || mapModel.cells == null) return null;
  float minV = Float.MAX_VALUE, maxV = -Float.MAX_VALUE, sum = 0;
  int count = 0;
  for (int ci : cellIdxs) {
    if (ci < 0 || ci >= mapModel.cells.size()) continue;
    Cell c = mapModel.cells.get(ci);
    if (c == null) continue;
    float ev = c.elevation;
    minV = min(minV, ev);
    maxV = max(maxV, ev);
    sum += ev;
    count++;
  }
  if (count == 0) return null;
  return new float[]{minV, maxV, sum / count};
}

public float[] elevationStatsForPoints(ArrayList<PVector> pts) {
  if (pts == null || mapModel == null) return null;
  float minV = Float.MAX_VALUE, maxV = -Float.MAX_VALUE, sum = 0;
  int count = 0;
  for (PVector p : pts) {
    if (p == null) continue;
    float ev = elevationAtPoint(p.x, p.y);
    minV = min(minV, ev);
    maxV = max(maxV, ev);
    sum += ev;
    count++;
  }
  if (count == 0) return null;
  return new float[]{minV, maxV, sum / count};
}

public String exportGeoJson() {
  try {
    JSONObject root = new JSONObject();
    root.setString("type", "FeatureCollection");
    JSONArray features = new JSONArray();

    // Zones as merged MultiPolygons
    if (mapModel != null && mapModel.zones != null && mapModel.cells != null) {
      for (int zi = 0; zi < mapModel.zones.size(); zi++) {
        MapModel.MapZone z = mapModel.zones.get(zi);
        if (z == null || z.cells == null || z.cells.isEmpty()) continue;
        ArrayList<ArrayList<PVector>> rings = mergedPolygonsFromCells(z.cells);
        if (rings == null || rings.isEmpty()) continue;
        JSONArray polys = new JSONArray();
        for (ArrayList<PVector> r : rings) {
          JSONArray ring = ringFromVertices(r, true);
          if (ring.size() == 0) continue;
          JSONArray poly = new JSONArray();
          poly.append(ring);
          polys.append(poly);
        }
        if (polys.size() == 0) continue;
        float[] stats = elevationStatsForCells(z.cells);
        JSONObject geom = new JSONObject();
        geom.setString("type", "MultiPolygon");
        geom.setJSONArray("coordinates", polys);

        JSONObject props = new JSONObject();
        props.setString("category", "zone");
        props.setInt("zoneIndex", zi);
        props.setString("name", z.name != null ? z.name : "");
        props.setString("comment", z.comment != null ? z.comment : "");
        if (stats != null) {
          props.setFloat("elevMin", stats[0]);
          props.setFloat("elevMax", stats[1]);
          props.setFloat("elevMean", stats[2]);
        }

        JSONObject feat = new JSONObject();
        feat.setString("type", "Feature");
        feat.setJSONObject("geometry", geom);
        feat.setJSONObject("properties", props);
        features.append(feat);
      }
    }

    // Biomes as merged MultiPolygons
    if (mapModel != null && mapModel.cells != null && mapModel.biomeTypes != null && !mapModel.biomeTypes.isEmpty()) {
      int biomeCount = mapModel.biomeTypes.size();
      for (int bid = 1; bid < biomeCount; bid++) { // skip None=0
        ArrayList<Integer> cellIdxs = new ArrayList<Integer>();
        for (int ci = 0; ci < mapModel.cells.size(); ci++) {
          Cell c = mapModel.cells.get(ci);
          if (c != null && c.biomeId == bid) cellIdxs.add(ci);
        }
        if (cellIdxs.isEmpty()) continue;
        ArrayList<ArrayList<PVector>> rings = mergedPolygonsFromCells(cellIdxs);
        if (rings == null || rings.isEmpty()) continue;
        JSONArray polys = new JSONArray();
        for (ArrayList<PVector> r : rings) {
          JSONArray ring = ringFromVertices(r, true);
          if (ring.size() == 0) continue;
          JSONArray poly = new JSONArray();
          poly.append(ring);
          polys.append(poly);
        }
        if (polys.size() == 0) continue;
        float[] stats = elevationStatsForCells(cellIdxs);
        JSONObject geom = new JSONObject();
        geom.setString("type", "MultiPolygon");
        geom.setJSONArray("coordinates", polys);

        JSONObject props = new JSONObject();
        props.setString("category", "biome");
        props.setInt("biomeIndex", bid);
        ZoneType zt = mapModel.biomeTypes.get(bid);
        props.setString("name", (zt != null && zt.name != null) ? zt.name : "");
        props.setString("comment", "");
        if (stats != null) {
          props.setFloat("elevMin", stats[0]);
          props.setFloat("elevMax", stats[1]);
          props.setFloat("elevMean", stats[2]);
        }

        JSONObject feat = new JSONObject();
        feat.setString("type", "Feature");
        feat.setJSONObject("geometry", geom);
        feat.setJSONObject("properties", props);
        features.append(feat);
      }
    }

    // Paths
    if (mapModel != null && mapModel.paths != null) {
      for (int pi = 0; pi < mapModel.paths.size(); pi++) {
        Path p = mapModel.paths.get(pi);
        if (p == null || p.routes == null) continue;
        for (int ri = 0; ri < p.routes.size(); ri++) {
          ArrayList<PVector> seg = p.routes.get(ri);
          if (seg == null || seg.size() < 2) continue;
          JSONArray coords = new JSONArray();
          for (PVector v : seg) {
            if (v == null) continue;
            JSONArray pt = new JSONArray();
            pt.append(v.x);
            pt.append(v.y);
            pt.append(elevationAtPoint(v.x, v.y));
            coords.append(pt);
          }
          JSONObject geom = new JSONObject();
          geom.setString("type", "LineString");
          geom.setJSONArray("coordinates", coords);

          JSONObject props = new JSONObject();
          props.setString("category", "path");
          props.setInt("pathIndex", pi);
          props.setInt("routeIndex", ri);
          props.setInt("pathTypeId", p.typeId);
          props.setString("name", p.name != null ? p.name : "");
          props.setString("comment", p.comment != null ? p.comment : "");
          float[] stats = elevationStatsForPoints(seg);
          if (stats != null) {
            props.setFloat("elevMin", stats[0]);
            props.setFloat("elevMax", stats[1]);
            props.setFloat("elevMean", stats[2]);
          }

          JSONObject feat = new JSONObject();
          feat.setString("type", "Feature");
          feat.setJSONObject("geometry", geom);
          feat.setJSONObject("properties", props);
          features.append(feat);
        }
      }
    }

    // Structures
    if (mapModel != null && mapModel.structures != null) {
      for (int si = 0; si < mapModel.structures.size(); si++) {
        Structure s = mapModel.structures.get(si);
        if (s == null) continue;
        ArrayList<PVector> outline = structureOutline(s);
        JSONArray ring = ringFromVertices(outline, true);
        JSONObject geom = new JSONObject();
        if (ring.size() >= 4) { // closed polygon with >=3 distinct points
          JSONArray poly = new JSONArray();
          poly.append(ring);
          geom.setString("type", "Polygon");
          geom.setJSONArray("coordinates", poly);
        } else {
          JSONArray pt = new JSONArray();
          pt.append(s.x);
          pt.append(s.y);
          geom.setString("type", "Point");
          geom.setJSONArray("coordinates", pt);
        }

        JSONObject props = new JSONObject();
        props.setString("category", "structure");
        props.setInt("structureIndex", si);
        props.setInt("typeId", s.typeId);
        props.setString("name", s.name != null ? s.name : "");
        props.setString("comment", s.comment != null ? s.comment : "");
        props.setString("shape", s.shape != null ? s.shape.name() : "RECTANGLE");
        props.setFloat("size", s.size);
        props.setFloat("aspect", s.aspect);
        props.setFloat("angleRad", s.angle);
        props.setFloat("elev", elevationAtPoint(s.x, s.y));

        JSONObject feat = new JSONObject();
        feat.setString("type", "Feature");
        feat.setJSONObject("geometry", geom);
        feat.setJSONObject("properties", props);
        features.append(feat);
      }
    }

    // Labels
    if (mapModel != null && mapModel.labels != null) {
      for (int li = 0; li < mapModel.labels.size(); li++) {
        MapLabel lbl = mapModel.labels.get(li);
        if (lbl == null || lbl.text == null) continue;
        JSONArray pt = new JSONArray();
        pt.append(lbl.x);
        pt.append(lbl.y);
        pt.append(elevationAtPoint(lbl.x, lbl.y));
        JSONObject geom = new JSONObject();
        geom.setString("type", "Point");
        geom.setJSONArray("coordinates", pt);

        JSONObject props = new JSONObject();
        props.setString("category", "label");
        props.setInt("labelIndex", li);
        props.setString("text", lbl.text);
        props.setString("comment", lbl.comment != null ? lbl.comment : "");
        props.setString("target", lbl.target != null ? lbl.target.name() : "FREE");
        props.setFloat("size", lbl.size);
        props.setFloat("elev", elevationAtPoint(lbl.x, lbl.y));

        JSONObject feat = new JSONObject();
        feat.setString("type", "Feature");
        feat.setJSONObject("geometry", geom);
        feat.setJSONObject("properties", props);
        features.append(feat);
      }
    }

    root.setJSONArray("features", features);

    File dir = new File(sketchPath("exports"));
    if (!dir.exists()) dir.mkdirs();
    String ts = nf(year(), 4, 0) + nf(month(), 2, 0) + nf(day(), 2, 0) + "_" +
                nf(hour(), 2, 0) + nf(minute(), 2, 0) + nf(second(), 2, 0);
    File target = new File(dir, "map_" + ts + ".geojson");
    File latest = new File(dir, "map_latest.geojson");
    saveJSONObject(root, target.getAbsolutePath());
    saveJSONObject(root, latest.getAbsolutePath());
    return target.getAbsolutePath();
  } catch (Exception e) {
    e.printStackTrace();
    return "Failed: " + e.getMessage();
  }
}

public String importMapJson() {
  try {
    File latest = new File(sketchPath("exports"), "map_latest.json");
    if (!latest.exists()) return "Failed: exports/map_latest.json not found";
    JSONObject root = loadJSONObject(latest.getAbsolutePath());
    if (root == null) return "Failed: invalid JSON";

    if (root.hasKey("types")) {
      JSONObject types = root.getJSONObject("types");
      mapModel.pathTypes = deserializePathTypes(types.getJSONArray("pathTypes"));
      mapModel.biomeTypes = deserializeZoneTypes(types.getJSONArray("biomeTypes"));
      mapModel.syncBiomePatternAssignments();
    }

    if (root.hasKey("sites")) mapModel.sites = deserializeSites(root.getJSONArray("sites"));
    if (root.hasKey("cells")) mapModel.cells = deserializeCells(root.getJSONArray("cells"));
    if (root.hasKey("zones")) mapModel.zones = deserializeZones(root.getJSONArray("zones"));
    if (root.hasKey("paths")) mapModel.paths = deserializePaths(root.getJSONArray("paths"));
    if (root.hasKey("structures")) mapModel.structures = deserializeStructures(root.getJSONArray("structures"));
    if (root.hasKey("labels")) mapModel.labels = deserializeLabels(root.getJSONArray("labels"));
    mapModel.cellNeighbors = new ArrayList<ArrayList<Integer>>();
    mapModel.snapNodes = new HashMap<String, PVector>();
    mapModel.snapAdj = new HashMap<String, ArrayList<String>>();

    if (root.hasKey("settings")) {
      JSONObject settings = root.getJSONObject("settings");
      if (settings.hasKey("render")) applyRenderSettingsFromJson(settings.getJSONObject("render"), renderSettings);
    }

    if (root.hasKey("view")) {
      JSONObject view = root.getJSONObject("view");
      viewport.centerX = view.getFloat("centerX", viewport.centerX);
      viewport.centerY = view.getFloat("centerY", viewport.centerY);
      viewport.zoom = view.getFloat("zoom", viewport.zoom);
    }

    recomputeWorldBoundsFromData();
    mapModel.snapDirty = true;
    mapModel.voronoiDirty = false;
    selectedPathIndex = -1;
    return latest.getAbsolutePath();
  } catch (Exception e) {
    e.printStackTrace();
    return "Failed: " + e.getMessage();
  }
}

public JSONObject serializeRenderSettings(RenderSettings s) {
  JSONObject r = new JSONObject();
  r.setFloat("landHue01", s.landHue01);
  r.setFloat("landSat01", s.landSat01);
  r.setFloat("landBri01", s.landBri01);
  r.setFloat("waterHue01", s.waterHue01);
  r.setFloat("waterSat01", s.waterSat01);
  r.setFloat("waterBri01", s.waterBri01);
  r.setFloat("cellBorderAlpha01", s.cellBorderAlpha01);
  r.setFloat("cellBorderSizePx", s.cellBorderSizePx);
  r.setBoolean("cellBorderScaleWithZoom", s.cellBorderScaleWithZoom);
  r.setFloat("cellBorderRefZoom", s.cellBorderRefZoom);
  r.setFloat("backgroundNoiseAlpha01", s.backgroundNoiseAlpha01);

  JSONObject biomes = new JSONObject();
  biomes.setFloat("fillAlpha01", s.biomeFillAlpha01);
  biomes.setFloat("satScale01", s.biomeSatScale01);
  biomes.setFloat("briScale01", s.biomeBriScale01);
  String fillType = "color";
  if (s.biomeFillType == RenderFillType.RENDER_FILL_PATTERN) fillType = "pattern";
  else if (s.biomeFillType == RenderFillType.RENDER_FILL_PATTERN_BG) fillType = "pattern_bg";
  biomes.setString("fillType", fillType);
  biomes.setString("patternName", s.biomePatternName);
  biomes.setFloat("outlineSizePx", s.biomeOutlineSizePx);
  biomes.setFloat("outlineAlpha01", s.biomeOutlineAlpha01);
  biomes.setBoolean("outlineScaleWithZoom", s.biomeOutlineScaleWithZoom);
  biomes.setFloat("outlineRefZoom", s.biomeOutlineRefZoom);
  biomes.setFloat("underwaterAlpha01", s.biomeUnderwaterAlpha01);
  r.setJSONObject("biomes", biomes);

  JSONObject shading = new JSONObject();
  shading.setFloat("waterDepthAlpha01", s.waterDepthAlpha01);
  shading.setFloat("elevationLightAlpha01", s.elevationLightAlpha01);
  shading.setFloat("elevationLightAzimuthDeg", s.elevationLightAzimuthDeg);
  shading.setFloat("elevationLightAltitudeDeg", s.elevationLightAltitudeDeg);
  shading.setFloat("elevationLightDitherPx", s.elevationLightDitherPx);
   shading.setBoolean("elevationLightDitherScaleWithZoom", s.elevationLightDitherScaleWithZoom);
   shading.setFloat("elevationLightDitherRefZoom", s.elevationLightDitherRefZoom);
  r.setJSONObject("shading", shading);

  JSONObject contours = new JSONObject();
  contours.setFloat("waterContourSizePx", s.waterContourSizePx);
  contours.setInt("waterRippleCount", s.waterRippleCount);
  contours.setFloat("waterRippleDistancePx", s.waterRippleDistancePx);
  contours.setFloat("waterContourHue01", s.waterContourHue01);
  contours.setFloat("waterContourSat01", s.waterContourSat01);
  contours.setFloat("waterContourBri01", s.waterContourBri01);
  contours.setFloat("waterContourAlpha01", s.waterCoastAlpha01);
  contours.setFloat("waterCoastAlpha01", s.waterCoastAlpha01);
  contours.setFloat("waterCoastSizePx", s.waterCoastSizePx);
  contours.setBoolean("waterCoastScaleWithZoom", s.waterCoastScaleWithZoom);
  contours.setBoolean("waterContourScaleWithZoom", s.waterContourScaleWithZoom);
  contours.setFloat("waterContourRefZoom", s.waterContourRefZoom);
  contours.setFloat("waterRippleAlphaStart01", s.waterRippleAlphaStart01);
  contours.setFloat("waterRippleAlphaEnd01", s.waterRippleAlphaEnd01);
  contours.setFloat("waterHatchAngleDeg", s.waterHatchAngleDeg);
  contours.setFloat("waterHatchLengthPx", s.waterHatchLengthPx);
  contours.setFloat("waterHatchSpacingPx", s.waterHatchSpacingPx);
  contours.setFloat("waterHatchAlpha01", s.waterHatchAlpha01);
  contours.setInt("elevationLinesCount", s.elevationLinesCount);
  contours.setString("elevationLinesStyle", s.elevationLinesStyle.name());
  contours.setFloat("elevationLinesAlpha01", s.elevationLinesAlpha01);
  contours.setFloat("elevationLinesSizePx", s.elevationLinesSizePx);
  contours.setBoolean("elevationLinesScaleWithZoom", s.elevationLinesScaleWithZoom);
  contours.setFloat("elevationLinesRefZoom", s.elevationLinesRefZoom);
  r.setJSONObject("contours", contours);

  JSONObject paths = new JSONObject();
  paths.setFloat("pathSatScale01", s.pathSatScale01);
  paths.setFloat("pathBriScale01", s.pathBriScale01);
  paths.setBoolean("showPaths", s.showPaths);
  paths.setBoolean("pathScaleWithZoom", s.pathScaleWithZoom);
  paths.setFloat("pathScaleRefZoom", s.pathScaleRefZoom);
  r.setJSONObject("paths", paths);

  JSONObject zones = new JSONObject();
  zones.setFloat("zoneStrokeAlpha01", s.zoneStrokeAlpha01);
  zones.setFloat("zoneStrokeSizePx", s.zoneStrokeSizePx);
  zones.setFloat("zoneStrokeSatScale01", s.zoneStrokeSatScale01);
  zones.setFloat("zoneStrokeBriScale01", s.zoneStrokeBriScale01);
  zones.setBoolean("zoneStrokeScaleWithZoom", s.zoneStrokeScaleWithZoom);
  zones.setFloat("zoneStrokeRefZoom", s.zoneStrokeRefZoom);
  r.setJSONObject("zones", zones);

  JSONObject structures = new JSONObject();
  structures.setBoolean("showStructures", s.showStructures);
  structures.setBoolean("mergeStructures", s.mergeStructures);
  structures.setFloat("structureSatScale01", s.structureSatScale01);
  structures.setFloat("structureAlphaScale01", s.structureAlphaScale01);
  structures.setFloat("structureShadowAlpha01", s.structureShadowAlpha01);
  structures.setBoolean("structureStrokeScaleWithZoom", s.structureStrokeScaleWithZoom);
  structures.setFloat("structureStrokeRefZoom", s.structureStrokeRefZoom);
  r.setJSONObject("structures", structures);

  JSONObject labels = new JSONObject();
  labels.setBoolean("showLabelsArbitrary", s.showLabelsArbitrary);
  labels.setBoolean("showLabelsZones", s.showLabelsZones);
  labels.setBoolean("showLabelsPaths", s.showLabelsPaths);
  labels.setBoolean("showLabelsStructures", s.showLabelsStructures);
  labels.setFloat("labelOutlineAlpha01", s.labelOutlineAlpha01);
  labels.setFloat("labelOutlineSizePx", s.labelOutlineSizePx);
  labels.setFloat("labelSizeArbPx", s.labelSizeArbPx);
  labels.setFloat("labelSizeZonePx", s.labelSizeZonePx);
  labels.setFloat("labelSizePathPx", s.labelSizePathPx);
  labels.setFloat("labelSizeStructPx", s.labelSizeStructPx);
  labels.setBoolean("labelOutlineScaleWithZoom", s.labelOutlineScaleWithZoom);
  labels.setInt("labelFontIndex", s.labelFontIndex);
  r.setJSONObject("labels", labels);

  JSONObject general = new JSONObject();
  general.setFloat("exportPaddingPct", s.exportPaddingPct);
  general.setBoolean("antialiasing", s.antialiasing);
  general.setInt("activePresetIndex", s.activePresetIndex);
  r.setJSONObject("general", general);

  return r;
}

public void applyRenderSettingsFromJson(JSONObject r, RenderSettings target) {
  if (r == null || target == null) return;
  target.landHue01 = r.getFloat("landHue01", target.landHue01);
  target.landSat01 = r.getFloat("landSat01", target.landSat01);
  target.landBri01 = r.getFloat("landBri01", target.landBri01);
  target.waterHue01 = r.getFloat("waterHue01", target.waterHue01);
  target.waterSat01 = r.getFloat("waterSat01", target.waterSat01);
  target.waterBri01 = r.getFloat("waterBri01", target.waterBri01);
  target.cellBorderAlpha01 = r.getFloat("cellBorderAlpha01", target.cellBorderAlpha01);
  target.cellBorderSizePx = r.getFloat("cellBorderSizePx", target.cellBorderSizePx);
  target.cellBorderScaleWithZoom = r.getBoolean("cellBorderScaleWithZoom", target.cellBorderScaleWithZoom);
  target.cellBorderRefZoom = r.getFloat("cellBorderRefZoom", target.cellBorderRefZoom);
  target.backgroundNoiseAlpha01 = r.getFloat("backgroundNoiseAlpha01", target.backgroundNoiseAlpha01);

  if (r.hasKey("biomes")) {
    JSONObject b = r.getJSONObject("biomes");
    target.biomeFillAlpha01 = b.getFloat("fillAlpha01", target.biomeFillAlpha01);
    target.biomeSatScale01 = b.getFloat("satScale01", target.biomeSatScale01);
    target.biomeBriScale01 = b.getFloat("briScale01", target.biomeBriScale01);
    String ft = b.getString("fillType", "color");
    if ("pattern".equals(ft)) target.biomeFillType = RenderFillType.RENDER_FILL_PATTERN;
    else if ("pattern_bg".equals(ft)) target.biomeFillType = RenderFillType.RENDER_FILL_PATTERN_BG;
    else target.biomeFillType = RenderFillType.RENDER_FILL_COLOR;
    target.biomePatternName = b.getString("patternName", target.biomePatternName);
    target.biomeOutlineSizePx = b.getFloat("outlineSizePx", target.biomeOutlineSizePx);
    target.biomeOutlineAlpha01 = b.getFloat("outlineAlpha01", target.biomeOutlineAlpha01);
    target.biomeOutlineScaleWithZoom = b.getBoolean("outlineScaleWithZoom", target.biomeOutlineScaleWithZoom);
    target.biomeOutlineRefZoom = b.getFloat("outlineRefZoom", target.biomeOutlineRefZoom);
    target.biomeUnderwaterAlpha01 = b.getFloat("underwaterAlpha01", target.biomeUnderwaterAlpha01);
  }

  if (r.hasKey("shading")) {
    JSONObject b = r.getJSONObject("shading");
    target.waterDepthAlpha01 = b.getFloat("waterDepthAlpha01", target.waterDepthAlpha01);
    target.elevationLightAlpha01 = b.getFloat("elevationLightAlpha01", target.elevationLightAlpha01);
    target.elevationLightAzimuthDeg = b.getFloat("elevationLightAzimuthDeg", target.elevationLightAzimuthDeg);
    target.elevationLightAltitudeDeg = b.getFloat("elevationLightAltitudeDeg", target.elevationLightAltitudeDeg);
    target.elevationLightDitherPx = b.getFloat("elevationLightDitherPx", target.elevationLightDitherPx);
    target.elevationLightDitherScaleWithZoom = b.getBoolean("elevationLightDitherScaleWithZoom", target.elevationLightDitherScaleWithZoom);
    target.elevationLightDitherRefZoom = b.getFloat("elevationLightDitherRefZoom", target.elevationLightDitherRefZoom);
  }

  if (r.hasKey("contours")) {
    JSONObject b = r.getJSONObject("contours");
    target.waterContourSizePx = b.getFloat("waterContourSizePx", target.waterContourSizePx);
    target.waterRippleCount = b.getInt("waterRippleCount", target.waterRippleCount);
    target.waterRippleDistancePx = b.getFloat("waterRippleDistancePx", target.waterRippleDistancePx);
    target.waterContourHue01 = b.getFloat("waterContourHue01", target.waterContourHue01);
    target.waterContourSat01 = b.getFloat("waterContourSat01", target.waterContourSat01);
    target.waterContourBri01 = b.getFloat("waterContourBri01", target.waterContourBri01);
    target.waterContourAlpha01 = b.getFloat("waterContourAlpha01", target.waterContourAlpha01);
    target.waterCoastAlpha01 = b.getFloat("waterCoastAlpha01", target.waterContourAlpha01);
    target.waterCoastSizePx = b.getFloat("waterCoastSizePx", target.waterCoastSizePx);
    target.waterCoastScaleWithZoom = b.getBoolean("waterCoastScaleWithZoom", target.waterCoastScaleWithZoom);
    target.waterContourScaleWithZoom = b.getBoolean("waterContourScaleWithZoom", target.waterContourScaleWithZoom);
    target.waterContourRefZoom = b.getFloat("waterContourRefZoom", target.waterContourRefZoom);
    target.waterRippleAlphaStart01 = b.getFloat("waterRippleAlphaStart01", target.waterContourAlpha01);
    target.waterRippleAlphaEnd01 = b.getFloat("waterRippleAlphaEnd01", target.waterRippleAlphaStart01);
    target.waterHatchAngleDeg = b.getFloat("waterHatchAngleDeg", target.waterHatchAngleDeg);
    target.waterHatchLengthPx = b.getFloat("waterHatchLengthPx", target.waterHatchLengthPx);
    target.waterHatchSpacingPx = b.getFloat("waterHatchSpacingPx", target.waterHatchSpacingPx);
    target.waterHatchAlpha01 = b.getFloat("waterHatchAlpha01", target.waterHatchAlpha01);
    syncLegacyWaterContourAlpha(target); // keep legacy field in sync
    target.elevationLinesCount = b.getInt("elevationLinesCount", target.elevationLinesCount);
    String style = b.getString("elevationLinesStyle", target.elevationLinesStyle.name());
    target.elevationLinesStyle = "ELEV_LINES_BASIC".equals(style) ? ElevationLinesStyle.ELEV_LINES_BASIC : target.elevationLinesStyle;
    target.elevationLinesAlpha01 = b.getFloat("elevationLinesAlpha01", target.elevationLinesAlpha01);
    target.elevationLinesSizePx = b.getFloat("elevationLinesSizePx", target.elevationLinesSizePx);
    target.elevationLinesScaleWithZoom = b.getBoolean("elevationLinesScaleWithZoom", target.elevationLinesScaleWithZoom);
    target.elevationLinesRefZoom = b.getFloat("elevationLinesRefZoom", target.elevationLinesRefZoom);
  }

  if (r.hasKey("paths")) {
    JSONObject b = r.getJSONObject("paths");
    target.pathSatScale01 = b.getFloat("pathSatScale01", target.pathSatScale01);
    target.pathBriScale01 = b.getFloat("pathBriScale01", target.pathBriScale01);
    target.showPaths = b.getBoolean("showPaths", target.showPaths);
    target.pathScaleWithZoom = b.getBoolean("pathScaleWithZoom", target.pathScaleWithZoom);
    target.pathScaleRefZoom = b.getFloat("pathScaleRefZoom", target.pathScaleRefZoom);
  }

  if (r.hasKey("zones")) {
    JSONObject b = r.getJSONObject("zones");
    target.zoneStrokeAlpha01 = b.getFloat("zoneStrokeAlpha01", target.zoneStrokeAlpha01);
    target.zoneStrokeSizePx = b.getFloat("zoneStrokeSizePx", target.zoneStrokeSizePx);
    target.zoneStrokeSatScale01 = b.getFloat("zoneStrokeSatScale01", target.zoneStrokeSatScale01);
    target.zoneStrokeBriScale01 = b.getFloat("zoneStrokeBriScale01", target.zoneStrokeBriScale01);
    target.zoneStrokeScaleWithZoom = b.getBoolean("zoneStrokeScaleWithZoom", target.zoneStrokeScaleWithZoom);
    target.zoneStrokeRefZoom = b.getFloat("zoneStrokeRefZoom", target.zoneStrokeRefZoom);
  }

  if (r.hasKey("structures")) {
    JSONObject b = r.getJSONObject("structures");
    target.showStructures = b.getBoolean("showStructures", target.showStructures);
    target.mergeStructures = b.getBoolean("mergeStructures", target.mergeStructures);
    target.structureSatScale01 = b.getFloat("structureSatScale01", target.structureSatScale01);
    target.structureAlphaScale01 = b.getFloat("structureAlphaScale01", target.structureAlphaScale01);
    target.structureShadowAlpha01 = b.getFloat("structureShadowAlpha01", target.structureShadowAlpha01);
    target.structureStrokeScaleWithZoom = b.getBoolean("structureStrokeScaleWithZoom", target.structureStrokeScaleWithZoom);
    target.structureStrokeRefZoom = b.getFloat("structureStrokeRefZoom", target.structureStrokeRefZoom);
  }

  if (r.hasKey("labels")) {
    JSONObject b = r.getJSONObject("labels");
    target.showLabelsArbitrary = b.getBoolean("showLabelsArbitrary", target.showLabelsArbitrary);
    target.showLabelsZones = b.getBoolean("showLabelsZones", target.showLabelsZones);
    target.showLabelsPaths = b.getBoolean("showLabelsPaths", target.showLabelsPaths);
    target.showLabelsStructures = b.getBoolean("showLabelsStructures", target.showLabelsStructures);
    target.labelOutlineAlpha01 = b.getFloat("labelOutlineAlpha01", target.labelOutlineAlpha01);
    target.labelOutlineSizePx = b.getFloat("labelOutlineSizePx", target.labelOutlineSizePx);
    target.labelSizeArbPx = b.getFloat("labelSizeArbPx", target.labelSizeArbPx);
    target.labelSizeZonePx = b.getFloat("labelSizeZonePx", target.labelSizeZonePx);
    target.labelSizePathPx = b.getFloat("labelSizePathPx", target.labelSizePathPx);
    target.labelSizeStructPx = b.getFloat("labelSizeStructPx", target.labelSizeStructPx);
    target.labelOutlineScaleWithZoom = b.getBoolean("labelOutlineScaleWithZoom", target.labelOutlineScaleWithZoom);
    target.labelFontIndex = b.getInt("labelFontIndex", target.labelFontIndex);
    if (LABEL_FONT_OPTIONS != null && LABEL_FONT_OPTIONS.length > 0) {
      target.labelFontIndex = constrain(target.labelFontIndex, 0, LABEL_FONT_OPTIONS.length - 1);
    } else {
      target.labelFontIndex = 0;
    }
  }

  if (r.hasKey("general")) {
    JSONObject b = r.getJSONObject("general");
    target.exportPaddingPct = b.getFloat("exportPaddingPct", target.exportPaddingPct);
    target.antialiasing = b.getBoolean("antialiasing", target.antialiasing);
    target.activePresetIndex = b.getInt("activePresetIndex", target.activePresetIndex);
    renderPaddingPct = target.exportPaddingPct;
  }
}

public JSONArray serializePathTypes(ArrayList<PathType> list) {
  JSONArray arr = new JSONArray();
  if (list == null) return arr;
  for (int i = 0; i < list.size(); i++) {
    PathType t = list.get(i);
    if (t == null) continue;
    JSONObject o = new JSONObject();
    o.setInt("id", i);
    o.setString("name", t.name);
    o.setInt("col", t.col);
    o.setFloat("hue01", t.hue01);
    o.setFloat("sat01", t.sat01);
    o.setFloat("bri01", t.bri01);
    o.setFloat("weightPx", t.weightPx);
    o.setFloat("minWeightPx", t.minWeightPx);
    o.setString("routeMode", t.routeMode.name());
    o.setFloat("slopeBias", t.slopeBias);
    o.setBoolean("avoidWater", t.avoidWater);
    o.setBoolean("taperOn", t.taperOn);
    arr.append(o);
  }
  return arr;
}

public JSONArray serializeZoneTypes(ArrayList<ZoneType> list) {
  JSONArray arr = new JSONArray();
  if (list == null) return arr;
  for (int i = 0; i < list.size(); i++) {
    ZoneType z = list.get(i);
    if (z == null) continue;
    JSONObject o = new JSONObject();
    o.setInt("id", i);
    o.setString("name", z.name);
    o.setInt("col", z.col);
    o.setFloat("hue01", z.hue01);
    o.setFloat("sat01", z.sat01);
    o.setFloat("bri01", z.bri01);
    o.setInt("patternIndex", z.patternIndex);
    arr.append(o);
  }
  return arr;
}

public JSONArray serializeSites(ArrayList<Site> list) {
  JSONArray arr = new JSONArray();
  if (list == null) return arr;
  for (int i = 0; i < list.size(); i++) {
    Site s = list.get(i);
    if (s == null) continue;
    JSONObject o = new JSONObject();
    o.setInt("id", i);
    o.setFloat("x", s.x);
    o.setFloat("y", s.y);
    o.setBoolean("selected", s.selected);
    arr.append(o);
  }
  return arr;
}

public JSONArray serializeCells(ArrayList<Cell> list) {
  JSONArray arr = new JSONArray();
  if (list == null) return arr;
  for (int i = 0; i < list.size(); i++) {
    Cell c = list.get(i);
    if (c == null) continue;
    JSONObject o = new JSONObject();
    o.setInt("id", i);
    o.setInt("siteIndex", c.siteIndex);
    o.setInt("biomeId", c.biomeId);
    o.setFloat("elevation", c.elevation);
    JSONArray verts = new JSONArray();
    if (c.vertices != null) {
      for (PVector v : c.vertices) {
        JSONObject pv = new JSONObject();
        pv.setFloat("x", v.x);
        pv.setFloat("y", v.y);
        verts.append(pv);
      }
    }
    o.setJSONArray("vertices", verts);
    arr.append(o);
  }
  return arr;
}

public JSONArray serializeZones(ArrayList<MapModel.MapZone> list) {
  JSONArray arr = new JSONArray();
  if (list == null) return arr;
  for (int i = 0; i < list.size(); i++) {
    MapModel.MapZone z = list.get(i);
    if (z == null) continue;
    JSONObject o = new JSONObject();
    o.setInt("id", i);
    o.setString("name", z.name);
    o.setString("comment", (z.comment != null) ? z.comment : "");
    o.setInt("col", z.col);
    o.setFloat("hue01", z.hue01);
    o.setFloat("sat01", z.sat01);
    o.setFloat("bri01", z.bri01);
    JSONArray cellsArr = new JSONArray();
    if (z.cells != null) {
      for (Integer ci : z.cells) cellsArr.append(ci);
    }
    o.setJSONArray("cells", cellsArr);
    arr.append(o);
  }
  return arr;
}

public JSONArray serializePaths(ArrayList<Path> list) {
  JSONArray arr = new JSONArray();
  if (list == null) return arr;
  for (int i = 0; i < list.size(); i++) {
    Path p = list.get(i);
    if (p == null) continue;
    JSONObject o = new JSONObject();
    o.setInt("id", i);
    o.setInt("typeId", p.typeId);
    o.setString("name", p.name);
    o.setString("comment", (p.comment != null) ? p.comment : "");
    JSONArray routes = new JSONArray();
    if (p.routes != null) {
      for (ArrayList<PVector> seg : p.routes) {
        JSONArray pts = new JSONArray();
        if (seg != null) {
          for (PVector v : seg) {
            JSONObject pv = new JSONObject();
            pv.setFloat("x", v.x);
            pv.setFloat("y", v.y);
            pts.append(pv);
          }
        }
        routes.append(pts);
      }
    }
    o.setJSONArray("routes", routes);
    arr.append(o);
  }
  return arr;
}

public JSONArray serializeStructures(ArrayList<Structure> list) {
  JSONArray arr = new JSONArray();
  if (list == null) return arr;
  for (int i = 0; i < list.size(); i++) {
    Structure s = list.get(i);
    if (s == null) continue;
    JSONObject o = new JSONObject();
    o.setInt("id", i);
    o.setInt("typeId", s.typeId);
    o.setString("name", s.name);
    o.setString("comment", (s.comment != null) ? s.comment : "");
    o.setFloat("x", s.x);
    o.setFloat("y", s.y);
    o.setFloat("angle", s.angle);
    o.setFloat("size", s.size);
    o.setString("shape", s.shape.name());
    o.setString("alignment", s.alignment.name());
    o.setFloat("aspect", s.aspect);
    o.setFloat("hue01", s.hue01);
    o.setFloat("sat01", s.sat01);
    o.setFloat("bri01", s.bri01);
    o.setFloat("alpha01", s.alpha01);
    o.setFloat("strokeWeightPx", s.strokeWeightPx);
    o.setInt("fillCol", s.fillCol);
    if (s.snapBinding != null) {
      o.setString("snapTargetType", s.snapBinding.type.name());
      o.setInt("snapPathIndex", s.snapBinding.pathIndex);
      o.setInt("snapRouteIndex", s.snapBinding.routeIndex);
      o.setInt("snapSegmentIndex", s.snapBinding.segmentIndex);
      o.setInt("snapStructureIndex", s.snapBinding.structureIndex);
      o.setInt("snapCellA", s.snapBinding.cellA);
      o.setInt("snapCellB", s.snapBinding.cellB);
      o.setFloat("snapAngleRad", s.snapBinding.snapAngleRad);
      if (s.snapBinding.snapPoint != null) {
        o.setFloat("snapPointX", s.snapBinding.snapPoint.x);
        o.setFloat("snapPointY", s.snapBinding.snapPoint.y);
      }
      if (s.snapBinding.segA != null) {
        o.setFloat("snapSegAx", s.snapBinding.segA.x);
        o.setFloat("snapSegAy", s.snapBinding.segA.y);
      }
      if (s.snapBinding.segB != null) {
        o.setFloat("snapSegBx", s.snapBinding.segB.x);
        o.setFloat("snapSegBy", s.snapBinding.segB.y);
      }
    }
    arr.append(o);
  }
  return arr;
}

public JSONArray serializeLabels(ArrayList<MapLabel> list) {
  JSONArray arr = new JSONArray();
  if (list == null) return arr;
  for (int i = 0; i < list.size(); i++) {
    MapLabel l = list.get(i);
    if (l == null) continue;
    JSONObject o = new JSONObject();
    o.setInt("id", i);
    o.setFloat("x", l.x);
    o.setFloat("y", l.y);
    o.setString("text", (l.text != null) ? l.text : "");
    o.setString("target", l.target.name());
    o.setFloat("size", l.size);
    o.setString("comment", (l.comment != null) ? l.comment : "");
    arr.append(o);
  }
  return arr;
}

public ArrayList<PathType> deserializePathTypes(JSONArray arr) {
  ArrayList<PathType> list = new ArrayList<PathType>();
  if (arr == null) return list;
  for (int i = 0; i < arr.size(); i++) {
    JSONObject o = arr.getJSONObject(i);
    if (o == null) continue;
    String name = o.getString("name", "Path");
    int col = o.getInt("col", color(80));
    float weight = o.getFloat("weightPx", 2.0f);
    float minWeight = o.getFloat("minWeightPx", weight * 0.6f);
    String mode = o.getString("routeMode", PathRouteMode.PATHFIND.name());
    PathRouteMode rm = mode.equals(PathRouteMode.ENDS.name()) ? PathRouteMode.ENDS : PathRouteMode.PATHFIND;
    float slope = o.getFloat("slopeBias", 0.0f);
    boolean avoidWater = o.getBoolean("avoidWater", true);
    boolean taper = o.getBoolean("taperOn", false);
    PathType pt = new PathType(name, col, weight, minWeight, rm, slope, avoidWater, taper);
    list.add(pt);
  }
  return list;
}

public ArrayList<ZoneType> deserializeZoneTypes(JSONArray arr) {
  ArrayList<ZoneType> list = new ArrayList<ZoneType>();
  if (arr == null) return list;
  for (int i = 0; i < arr.size(); i++) {
    JSONObject o = arr.getJSONObject(i);
    if (o == null) continue;
    String name = o.getString("name", "Zone");
    int col = o.getInt("col", color(200));
    ZoneType z = new ZoneType(name, col);
    z.hue01 = o.getFloat("hue01", z.hue01);
    z.sat01 = o.getFloat("sat01", z.sat01);
    z.bri01 = o.getFloat("bri01", z.bri01);
    z.updateColorFromHSB();
    int defPat = (mapModel != null) ? mapModel.defaultPatternIndexForBiome(i) : 0;
    z.patternIndex = o.getInt("patternIndex", defPat);
    list.add(z);
  }
  return list;
}

public void loadBiomePatternList() {
  ArrayList<String> names = new ArrayList<String>();
  HashSet<String> seen = new HashSet<String>();
  String[] roots = { dataPath("patterns"), sketchPath("patterns") };
  for (String root : roots) {
    try {
      if (root == null) continue;
      File dir = new File(root);
      if (!dir.exists() || !dir.isDirectory()) continue;
      File[] files = dir.listFiles();
      if (files == null) continue;
      for (File f : files) {
        if (f == null || !f.isFile() || f.isHidden()) continue;
        String name = f.getName();
        if (name == null) continue;
        String low = name.toLowerCase();
        if (!low.endsWith(".png")) continue;
        if (seen.contains(name)) continue;
        seen.add(name);
        names.add(name);
      }
    } catch (Exception e) {
      e.printStackTrace();
    }
  }
  Collections.sort(names);
  if (!names.isEmpty()) {
    if (renderSettings != null) {
      String curPat = renderSettings.biomePatternName;
      boolean keep = (curPat != null && names.contains(curPat));
      if (!keep) renderSettings.biomePatternName = names.get(0);
    }
  } else {
    println("No biome patterns found under data/sketch patterns directories.");
  }
  if (mapModel != null) mapModel.setBiomePatternFiles(names);
}

public ArrayList<Site> deserializeSites(JSONArray arr) {
  ArrayList<Site> list = new ArrayList<Site>();
  if (arr == null) return list;
  for (int i = 0; i < arr.size(); i++) {
    JSONObject o = arr.getJSONObject(i);
    if (o == null) continue;
    float x = o.getFloat("x", 0);
    float y = o.getFloat("y", 0);
    Site s = new Site(x, y);
    s.selected = o.getBoolean("selected", false);
    list.add(s);
  }
  return list;
}

public ArrayList<Cell> deserializeCells(JSONArray arr) {
  ArrayList<Cell> list = new ArrayList<Cell>();
  if (arr == null) return list;
  for (int i = 0; i < arr.size(); i++) {
    JSONObject o = arr.getJSONObject(i);
    if (o == null) continue;
    int siteIdx = o.getInt("siteIndex", -1);
    int biomeId = o.getInt("biomeId", 0);
    JSONArray vertsArr = o.getJSONArray("vertices");
    ArrayList<PVector> verts = new ArrayList<PVector>();
    if (vertsArr != null) {
      for (int vi = 0; vi < vertsArr.size(); vi++) {
        JSONObject pv = vertsArr.getJSONObject(vi);
        if (pv == null) continue;
        verts.add(new PVector(pv.getFloat("x", 0), pv.getFloat("y", 0)));
      }
    }
    Cell c = new Cell(siteIdx, verts, biomeId);
    c.elevation = o.getFloat("elevation", 0.0f);
    list.add(c);
  }
  return list;
}

public ArrayList<MapModel.MapZone> deserializeZones(JSONArray arr) {
  ArrayList<MapModel.MapZone> list = new ArrayList<MapModel.MapZone>();
  if (arr == null) return list;
  for (int i = 0; i < arr.size(); i++) {
    JSONObject o = arr.getJSONObject(i);
    if (o == null) continue;
    String name = o.getString("name", "Zone");
    int col = o.getInt("col", color(200));
    MapModel.MapZone z = mapModel.new MapZone(name, col);
    z.hue01 = o.getFloat("hue01", z.hue01);
    z.sat01 = o.getFloat("sat01", z.sat01);
    z.bri01 = o.getFloat("bri01", z.bri01);
    z.col = hsb01ToARGB(z.hue01, z.sat01, z.bri01, 1.0f);
    z.cells.clear();
    JSONArray cellsArr = o.getJSONArray("cells");
    if (cellsArr != null) {
      for (int ci = 0; ci < cellsArr.size(); ci++) {
        z.cells.add(cellsArr.getInt(ci));
      }
    }
    list.add(z);
  }
  return list;
}

public ArrayList<Path> deserializePaths(JSONArray arr) {
  ArrayList<Path> list = new ArrayList<Path>();
  if (arr == null) return list;
  for (int i = 0; i < arr.size(); i++) {
    JSONObject o = arr.getJSONObject(i);
    if (o == null) continue;
    Path p = new Path();
    p.typeId = o.getInt("typeId", 0);
    p.name = o.getString("name", "Path");
    p.comment = o.getString("comment", "");
    JSONArray routesArr = o.getJSONArray("routes");
    if (routesArr != null) {
      for (int ri = 0; ri < routesArr.size(); ri++) {
        JSONArray ptsArr = routesArr.getJSONArray(ri);
        ArrayList<PVector> seg = new ArrayList<PVector>();
        if (ptsArr != null) {
          for (int pi = 0; pi < ptsArr.size(); pi++) {
            JSONObject pv = ptsArr.getJSONObject(pi);
            if (pv == null) continue;
            seg.add(new PVector(pv.getFloat("x", 0), pv.getFloat("y", 0)));
          }
        }
        p.routes.add(seg);
      }
    }
    list.add(p);
  }
  return list;
}

public ArrayList<Structure> deserializeStructures(JSONArray arr) {
  ArrayList<Structure> list = new ArrayList<Structure>();
  if (arr == null) return list;
  for (int i = 0; i < arr.size(); i++) {
    JSONObject o = arr.getJSONObject(i);
    if (o == null) continue;
    float x = o.getFloat("x", 0);
    float y = o.getFloat("y", 0);
    Structure s = new Structure(x, y);
    s.typeId = o.getInt("typeId", 0);
    s.name = o.getString("name", "");
    s.comment = o.getString("comment", "");
    s.angle = o.getFloat("angle", 0);
    s.size = o.getFloat("size", s.size);
    try {
      String sh = o.getString("shape", s.shape.name());
      if ("SQUARE".equals(sh)) sh = StructureShape.RECTANGLE.name();
      s.shape = StructureShape.valueOf(sh);
    } catch (Exception e) {}
    try { s.alignment = StructureSnapMode.valueOf(o.getString("alignment", s.alignment.name())); } catch (Exception e) {}
    s.aspect = o.getFloat("aspect", s.aspect);
    s.hue01 = o.getFloat("hue01", s.hue01);
    s.sat01 = o.getFloat("sat01", s.sat01);
    s.bri01 = o.getFloat("bri01", s.bri01);
    s.alpha01 = o.getFloat("alpha01", s.alpha01);
    s.strokeWeightPx = o.getFloat("strokeWeightPx", s.strokeWeightPx);
    s.fillCol = o.getInt("fillCol", s.fillCol);
    s.updateFillColor();
    if (s.snapBinding == null) s.snapBinding = new StructureSnapBinding();
    s.snapBinding.clear();
    try { s.snapBinding.type = StructureSnapTargetType.valueOf(o.getString("snapTargetType", s.snapBinding.type.name())); } catch (Exception e) {}
    s.snapBinding.pathIndex = o.getInt("snapPathIndex", s.snapBinding.pathIndex);
    s.snapBinding.routeIndex = o.getInt("snapRouteIndex", s.snapBinding.routeIndex);
    s.snapBinding.segmentIndex = o.getInt("snapSegmentIndex", s.snapBinding.segmentIndex);
    s.snapBinding.structureIndex = o.getInt("snapStructureIndex", s.snapBinding.structureIndex);
    s.snapBinding.cellA = o.getInt("snapCellA", s.snapBinding.cellA);
    s.snapBinding.cellB = o.getInt("snapCellB", s.snapBinding.cellB);
    s.snapBinding.snapAngleRad = o.getFloat("snapAngleRad", s.snapBinding.snapAngleRad);
    if (o.hasKey("snapPointX") && o.hasKey("snapPointY")) {
      s.snapBinding.snapPoint = new PVector(o.getFloat("snapPointX", 0), o.getFloat("snapPointY", 0));
    }
    if (o.hasKey("snapSegAx") && o.hasKey("snapSegAy")) {
      s.snapBinding.segA = new PVector(o.getFloat("snapSegAx", 0), o.getFloat("snapSegAy", 0));
    }
    if (o.hasKey("snapSegBx") && o.hasKey("snapSegBy")) {
      s.snapBinding.segB = new PVector(o.getFloat("snapSegBx", 0), o.getFloat("snapSegBy", 0));
    }
    list.add(s);
  }
  return list;
}

public ArrayList<MapLabel> deserializeLabels(JSONArray arr) {
  ArrayList<MapLabel> list = new ArrayList<MapLabel>();
  if (arr == null) return list;
  for (int i = 0; i < arr.size(); i++) {
    JSONObject o = arr.getJSONObject(i);
    if (o == null) continue;
    float x = o.getFloat("x", 0);
    float y = o.getFloat("y", 0);
    String text = o.getString("text", "");
    String targetStr = o.getString("target", LabelTarget.FREE.name());
    LabelTarget target = LabelTarget.FREE;
    try { target = LabelTarget.valueOf(targetStr); } catch (Exception e) {}
    MapLabel l = new MapLabel(x, y, text, target);
    l.size = o.getFloat("size", l.size);
    l.comment = o.getString("comment", "");
    list.add(l);
  }
  return list;
}

public void recomputeWorldBoundsFromData() {
  float minXLocal = Float.MAX_VALUE;
  float minYLocal = Float.MAX_VALUE;
  float maxXLocal = -Float.MAX_VALUE;
  float maxYLocal = -Float.MAX_VALUE;

  if (mapModel.cells != null) {
    for (Cell c : mapModel.cells) {
      if (c == null || c.vertices == null) continue;
      for (PVector v : c.vertices) {
        if (v == null) continue;
        minXLocal = min(minXLocal, v.x);
        minYLocal = min(minYLocal, v.y);
        maxXLocal = max(maxXLocal, v.x);
        maxYLocal = max(maxYLocal, v.y);
      }
    }
  }
  if (mapModel.sites != null) {
    for (Site s : mapModel.sites) {
      if (s == null) continue;
      minXLocal = min(minXLocal, s.x);
      minYLocal = min(minYLocal, s.y);
      maxXLocal = max(maxXLocal, s.x);
      maxYLocal = max(maxYLocal, s.y);
    }
  }

  if (minXLocal == Float.MAX_VALUE || maxXLocal == -Float.MAX_VALUE) {
    mapModel.minX = 0;
    mapModel.maxX = 1;
    mapModel.minY = 0;
    mapModel.maxY = 1;
  } else {
    mapModel.minX = minXLocal;
    mapModel.maxX = maxXLocal;
    mapModel.minY = minYLocal;
    mapModel.maxY = maxYLocal;
  }
}

public void drawPathSnappingPoints() {
  if (pathEraserMode) return;
  ArrayList<PVector> snaps = mapModel.getSnapPoints();
  if (snaps == null || snaps.isEmpty()) return;

  float nearestScreenSq = Float.MAX_VALUE;
  PVector nearest = null;
  float px = mouseX;
  float py = mouseY;

  // Find nearest to mouse in screen space
  for (PVector p : snaps) {
    PVector s = viewport.worldToScreen(p.x, p.y);
    float dx = s.x - px;
    float dy = s.y - py;
    float d2 = dx * dx + dy * dy;
    if (d2 < nearestScreenSq) {
      nearestScreenSq = d2;
      nearest = p;
    }
  }

  float baseR = 2.0f / viewport.zoom;

  pushStyle();
  noStroke();
  fill(30, 30, 30, 90);
  for (PVector p : snaps) {
    ellipse(p.x, p.y, baseR, baseR);
  }

  if (nearest != null) {
    float hr = 5.0f / viewport.zoom;
    stroke(0);
    strokeWeight(1.0f / viewport.zoom);
    fill(255, 255, 0, 180);
    ellipse(nearest.x, nearest.y, hr, hr);
  }
  popStyle();
}

public PVector findNearestSnappingPoint(float wx, float wy, float maxScreenDist) {
  ArrayList<PVector> snaps = mapModel.getSnapPoints();
  if (snaps.isEmpty()) return null;

  float bestSq = maxScreenDist * maxScreenDist;
  PVector best = null;
  PVector cursorScreen = viewport.worldToScreen(wx, wy);

  for (PVector p : snaps) {
    PVector s = viewport.worldToScreen(p.x, p.y);
    float dx = s.x - cursorScreen.x;
    float dy = s.y - cursorScreen.y;
    float d2 = dx * dx + dy * dy;
    if (d2 < bestSq) {
      bestSq = d2;
      best = p;
    }
  }
  return best;
}

public void seedDefaultZones() {
  if (mapModel.cells == null || mapModel.cells.isEmpty()) return;
  for (Cell c : mapModel.cells) {
    c.biomeId = 0;
    c.elevation = defaultElevation;
  }
}

public void startLoading() {
  isLoading = true;
  loadingPhase = 0;
  loadingHoldFrames = 0;
  loadingPct = 0;
}

public void stopLoading() {
  isLoading = false;
  loadingHoldFrames = 0;
  loadingPct = 1.0f;
}

public void showNotice(String msg) {
  uiNotice = msg;
  uiNoticeFrames = NOTICE_DURATION_FRAMES;
}

public void drawZoneBrushPreview() {
  IntRect panel = getActivePanelRect();
  if (panel != null && panel.contains(mouseX, mouseY)) return;
  if (mouseY < TOP_BAR_TOTAL + TOOL_BAR_HEIGHT) return;
  PVector w = viewport.screenToWorld(mouseX, mouseY);
  pushStyle();
  noFill();
  stroke(40, 120);
  strokeWeight(1.0f / viewport.zoom);
  float r = zoneBrushRadius;
  ellipse(w.x, w.y, r * 2, r * 2);
  popStyle();
}

public void drawPathEraserPreview() {
  IntRect panel = getActivePanelRect();
  if (panel != null && panel.contains(mouseX, mouseY)) return;
  if (mouseY < TOP_BAR_TOTAL + TOOL_BAR_HEIGHT) return;
  PVector w = viewport.screenToWorld(mouseX, mouseY);
  pushStyle();
  noFill();
  stroke(200, 40, 40, 160);
  strokeWeight(1.0f / viewport.zoom);
  ellipse(w.x, w.y, pathEraserRadius * 2, pathEraserRadius * 2);
  popStyle();
}

public void drawElevationBrushPreview() {
  IntRect panel = getActivePanelRect();
  if (panel != null && panel.contains(mouseX, mouseY)) return;
  PVector w = viewport.screenToWorld(mouseX, mouseY);
  pushStyle();
  noFill();
  stroke(40, 120);
  strokeWeight(1.0f / viewport.zoom);
  float r = elevationBrushRadius;
  ellipse(w.x, w.y, r * 2, r * 2);
  popStyle();
}

public void drawStructurePreview() {
  int uiBottom = TOP_BAR_TOTAL + TOOL_BAR_HEIGHT;
  if (mouseY < uiBottom) return;
  if (selectedStructureIndices != null && !selectedStructureIndices.isEmpty()) return;
  PVector w = viewport.screenToWorld(mouseX, mouseY);
  Structure tmp = mapModel.computeSnappedStructure(w.x, w.y, structureSize);
  if (tmp == null) return;
  pushStyle();
  stroke(80, 140);
  strokeWeight(1.0f / viewport.zoom);
  fill(200, 200, 180, 120);
  tmp.draw(this);
  popStyle();
}
public void stepFullGenerateFromCells() {
  if (!fullGenRunning || mapModel == null) return;
  String stageLabel = "";
  switch (fullGenStep) {
    case 0: stageLabel = "Full gen: elevation + plateaus"; break;
    case 1: stageLabel = "Full gen: biomes"; break;
    case 2: stageLabel = "Full gen: zones"; break;
    case 3: stageLabel = "Full gen: paths"; break;
    case 4: stageLabel = "Full gen: structures"; break;
    case 5: stageLabel = "Full gen: labels"; break;
    default: stageLabel = ""; break;
  }
  if (!fullGenPrimed) {
    loadingDetail = stageLabel;
    fullGenPrimed = true;
    return;
  }
  switch (fullGenStep) {
    case 0: {
      loadingDetail = stageLabel;
      loadingPct = 0.05f;
      noiseSeed((int)random(Integer.MAX_VALUE));
      mapModel.generateElevationNoise(elevationNoiseScale, 1.0f, seaLevel);
      for (int i = 0; i < 15; i++) {
        mapModel.makePlateaus(seaLevel);
      }
      loadingPct = 0.20f;
      fullGenPrimed = false;
      fullGenStep++;
      break;
    }
    case 1: {
      loadingDetail = stageLabel;
      biomeGenerateModeIndex = max(0, biomeGenerateModes.length - 1);
      applyBiomeGeneration();
      loadingPct = 0.35f;
      fullGenPrimed = false;
      fullGenStep++;
      break;
    }
    case 2: {
      loadingDetail = stageLabel;
      int targetZones = (mapModel.zones == null || mapModel.zones.isEmpty()) ? 5 : mapModel.zones.size();
      mapModel.regenerateRandomZones(targetZones);
      activeZoneIndex = -1;
      editingZoneNameIndex = -1;
      editingZoneComment = false;
      mapModel.removeUnderwaterCellsFromZone(-1, seaLevel);
      loadingPct = 0.45f;
      fullGenPrimed = false;
      fullGenStep++;
      break;
    }
    case 3: {
      loadingDetail = stageLabel;
      selectedPathIndex = -1;
      pendingPathStart = null;
      mapModel.generatePathsAuto(seaLevel);
      loadingPct = 0.70f;
      fullGenPrimed = false;
      fullGenStep++;
      break;
    }
    case 4: {
      loadingDetail = stageLabel;
      mapModel.generateStructuresAuto(structGenTownCount, structGenBuildingDensity, seaLevel);
      clearStructureSelection();
      loadingPct = 0.85f;
      fullGenPrimed = false;
      fullGenStep++;
      break;
    }
    case 5: {
      loadingDetail = stageLabel;
      mapModel.generateArbitraryLabels(seaLevel);
      selectedLabelIndex = -1;
      editingLabelIndex = -1;
      editingLabelCommentIndex = -1;
      loadingPct = 1.0f;
      markRenderDirty();
      fullGenPrimed = false;
      fullGenStep++;
      break;
    }
    default: {
      fullGenRunning = false;
      stopLoading();
      loadingDetail = "";
      loadingPct = 1.0f;
      fullGenPrimed = false;
      break;
    }
  }
}

// Compute inner world rect for export based on padding; returns {x, y, w, h}
public float[] exportInnerRect() {
  float worldW = mapModel.maxX - mapModel.minX;
  float worldH = mapModel.maxY - mapModel.minY;
  float safePad = constrain(renderPaddingPct, 0, 0.49f); // avoid collapsing to zero
  float padX = max(0, safePad) * worldW;
  float padY = max(0, safePad) * worldH;
  float innerWX = mapModel.minX + padX;
  float innerWY = mapModel.minY + padY;
  float innerWW = worldW - padX * 2;
  float innerWH = worldH - padY * 2;
  return new float[]{ innerWX, innerWY, innerWW, innerWH };
}

public float[] exportSquareRect() {
  float worldW = mapModel.maxX - mapModel.minX;
  float worldH = mapModel.maxY - mapModel.minY;
  float side = max(worldW, worldH);
  float cx = (mapModel.minX + mapModel.maxX) * 0.5f;
  float cy = (mapModel.minY + mapModel.maxY) * 0.5f;
  return new float[]{ cx - side * 0.5f, cy - side * 0.5f, side, side };
}
public boolean ensureExportPreview() {
  if (mapModel == null || mapModel.renderer == null) return false;
  if (!exportPreviewDirty && exportPreview != null) return true;
  float[] rect = exportSquareRect();
  float innerWX = rect[0], innerWY = rect[1], innerWW = rect[2], innerWH = rect[3];
  if (innerWW <= 1e-6f || innerWH <= 1e-6f) return false;

  float pixelsPerWorld = max(0.1f, exportScale) * DEFAULT_VIEW_ZOOM;
  int pxSide = max(1, round(innerWW * pixelsPerWorld));
  pxSide = constrain(pxSide, 1, 16384);
  boolean needsAlloc = exportPreview == null || exportPreview.width != pxSide || exportPreview.height != pxSide;
  if (needsAlloc) {
    PGraphics g = null;
    try { g = createGraphics(pxSide, pxSide, P2D); } catch (Exception ignored) {}
    if (g == null) {
      try { g = createGraphics(pxSide, pxSide, JAVA2D); } catch (Exception ignored) {}
    }
    if (g == null) return false;
    exportPreview = g;
  }

  float prevCenterX = viewport.centerX;
  float prevCenterY = viewport.centerY;
  float prevZoom = viewport.zoom;

  // Center on square map and set zoom from export resolution.
  viewport.zoom = pixelsPerWorld;
  viewport.centerX = innerWX + innerWW * 0.5f;
  viewport.centerY = innerWY + innerWH * 0.5f;

  triggerRenderPrerequisites();

  renderingForExport = true;
  progressActive = true;
  progressDetail = "Export render";
  setProgressStatus("Exporting...");
  try {
    exportPreview.beginDraw();
    exportPreview.background(245);
    PGraphics prev = this.g;
    this.g = exportPreview;
    pushMatrix();
    viewport.applyTransform(exportPreview, exportPreview.width, exportPreview.height);
    drawRenderView(this);
    popMatrix();
    this.g = prev;
    exportPreview.endDraw();
    progressPct = 0.65f;

    // If contour jobs were triggered during the first pass, finish them and redraw
    if (mapModel.isContourJobRunning()) {
      int safety = 0;
      while (mapModel.isContourJobRunning() && safety < 80) {
        mapModel.stepContourJobs(16);
        safety++;
      }
      exportPreview.beginDraw();
      exportPreview.background(245);
      PGraphics prev2 = this.g;
      this.g = exportPreview;
      pushMatrix();
      viewport.applyTransform(exportPreview, exportPreview.width, exportPreview.height);
      drawRenderView(this);
      popMatrix();
      this.g = prev2;
      exportPreview.endDraw();
      progressPct = 0.9f;
    }
  } finally {
    // Restore viewport
    viewport.centerX = prevCenterX;
    viewport.centerY = prevCenterY;
    viewport.zoom = prevZoom;
    renderingForExport = false;
    progressActive = false;
    progressDetail = "";
    setProgressStatus("Export done");
    progressPct = 1.0f;
  }

  exportPreviewRect = rect;
  exportPreviewDirty = false;
  return true;
}

public void drawExportPreviewView() {
  if (!ensureExportPreview()) {
    drawRenderView(this); // fallback
    return;
  }
  float wx = exportPreviewRect[0];
  float wy = exportPreviewRect[1];
  float ww = exportPreviewRect[2];
  float wh = exportPreviewRect[3];
  PVector tl = viewport.worldToScreen(wx, wy);
  PVector br = viewport.worldToScreen(wx + ww, wy + wh);
  float sx = min(tl.x, br.x);
  float sy = min(tl.y, br.y);
  float sw = abs(br.x - tl.x);
  float sh = abs(br.y - tl.y);
  pushStyle();
  pushMatrix();
  resetMatrix();
  imageMode(CORNER);
  image(exportPreview, sx, sy, sw, sh);
  popMatrix();
  popStyle();
}
// Keep exportScale tied to zoom (continuous). Call after any zoom change.
public void syncExportScaleToZoom() {
  exportScale = max(0.1f, viewport.zoom / DEFAULT_VIEW_ZOOM);
}
class Cell {
  int siteIndex;
  ArrayList<PVector> vertices;
  int biomeId;  // index in mapModel.biomeTypes
  float elevation = 0.0f;

  Cell(int siteIndex, ArrayList<PVector> vertices, int biomeId) {
    this.siteIndex = siteIndex;
    this.vertices = vertices;
    this.biomeId = biomeId;
  }

  public void draw(PApplet app, boolean showBorders) {
    if (vertices == null || vertices.size() < 3) return;

    app.pushStyle();

    int col = color(230); // default light grey
    if (mapModel != null && mapModel.biomeTypes != null &&
        biomeId >= 0 && biomeId < mapModel.biomeTypes.size()) {
      ZoneType zt = mapModel.biomeTypes.get(biomeId);
      col = zt.col;
    }

    app.fill(col);
    if (showBorders) {
      app.stroke(180);
      app.strokeWeight(1.0f / viewport.zoom);
    } else {
      app.noStroke();
    }

    app.beginShape();
    for (int i = 0; i < vertices.size(); i++) {
      PVector v = vertices.get(i);
      app.vertex(v.x, v.y);
    }
    app.endShape(CLOSE);

    app.popStyle();
  }
}

static class ElevationRenderer {
  public static void drawOverlay(MapModel model, PApplet app, float seaLevel, boolean showElevationContours,
                          boolean drawWater, boolean drawElevation, boolean showWaterContours,
                          boolean useLighting, float lightAzimuthDeg, float lightAltitudeDeg, int quantSteps) {
    if (model == null || model.cells == null) return;
    app.pushStyle();
    app.noStroke();

    PVector lightDir = null;
    if (useLighting) {
      float az = radians(lightAzimuthDeg);
      float alt = radians(lightAltitudeDeg);
      lightDir = new PVector(cos(alt) * cos(az), cos(alt) * sin(az), sin(alt));
      lightDir.normalize();
    }

    int cellCount = model.cells.size();
    for (int ci = 0; ci < cellCount; ci++) {
      Cell c = model.cells.get(ci);
      if (c.vertices == null || c.vertices.size() < 3) continue;
      float h = c.elevation;
      PVector slope = null;
      PVector cen = model.cellCentroid(c);
      float light = 1.0f;
      if (useLighting && lightDir != null) {
        slope = estimateCellSlope(model, ci);
        light = lightFromSlope(slope, lightDir);
      }
      if (drawElevation) {
        float shade = constrain((h + 0.5f), 0, 1); // center on 0
        float litShade = constrain(shade * light, 0, 1);
        float baseShade = litShade;
        if (quantSteps > 1) {
          float levels = quantSteps - 1;
          baseShade = round(baseShade * levels) / levels;
        }
        app.beginShape();
        for (PVector v : c.vertices) {
          float directional = 0;
          if (slope != null) {
            float hDelta = slope.x * (v.x - cen.x) + slope.y * (v.y - cen.y);
            directional = constrain(hDelta * 1.2f, -0.14f, 0.14f);
          }
          float grain = (app.noise(v.x * 18.0f, v.y * 18.0f) - 0.5f) * 0.06f;
          float vShade = constrain(baseShade + directional + grain, 0, 1);
          int col = app.color(vShade * 255);
          app.fill(col, 150);
          app.vertex(v.x, v.y);
        }
        app.endShape(CLOSE);
      }

      if (drawWater && h < seaLevel) {
        float depth = seaLevel - h;
        float depthNorm = constrain(depth / 1.0f, 0, 1);
        float shade = drawElevation ? lerp(0.25f, 0.65f, 1.0f - depthNorm) : 0.55f;
        if (quantSteps > 1) {
          float levels = quantSteps - 1;
          shade = round(shade * levels) / levels;
        }
        float baseR = 30;
        float baseG = 70;
        float baseB = 120;
        int water;
        water = app.color(baseR * shade, baseG * shade, baseB * shade, 255);
        app.fill(water);
        app.beginShape();
        for (PVector v : c.vertices) app.vertex(v.x, v.y);
        app.endShape(CLOSE);
      }
    }

    if (showElevationContours || showWaterContours) {
      int cols = 90;
      int rows = 90;
      MapModel.ContourGrid grid = model.sampleElevationGrid(cols, rows, seaLevel);
      float minElev = grid.min;
      float maxElev = grid.max;

      if (showElevationContours) {
        float range = max(1e-4f, maxElev - seaLevel);
        float step = max(0.02f, range / 10.0f);
        float start = ceil(seaLevel / step) * step;
        int strokeCol = app.color(50, 50, 50, 180);
        model.drawContourSet(app, grid, start, maxElev, step, strokeCol);
      }

      if (showWaterContours && drawWater) {
        float minWater = minElev;
        if (minWater < seaLevel - 1e-4f) {
          float depthRange = seaLevel - minWater;
          float step = max(0.02f, depthRange / 5.0f);
          float start = seaLevel - step;
          int strokeCol = app.color(30, 70, 140, 170);
          model.drawContourSet(app, grid, start, minWater, -step, strokeCol);
        }
      }
    }
    app.popStyle();
  }

  private static PVector estimateCellSlope(MapModel model, int idx) {
    PVector slope = new PVector(0, 0);
    if (model == null || idx < 0 || idx >= model.cells.size()) return slope;
    ArrayList<Integer> nbs = (idx < model.cellNeighbors.size()) ? model.cellNeighbors.get(idx) : null;
    if (nbs == null || nbs.isEmpty()) return slope;

    Cell c = model.cells.get(idx);
    PVector cen = model.cellCentroid(c);

    for (int nbIdx : nbs) {
      if (nbIdx < 0 || nbIdx >= model.cells.size()) continue;
      Cell nb = model.cells.get(nbIdx);
      PVector ncen = model.cellCentroid(nb);
      float dx = ncen.x - cen.x;
      float dy = ncen.y - cen.y;
      float dist = sqrt(dx * dx + dy * dy);
      if (dist < 1e-6f) continue;
      float dh = nb.elevation - c.elevation;
      float w = 1.0f / dist;
      slope.x += dh * (dx / dist) * w;
      slope.y += dh * (dy / dist) * w;
    }
    return slope;
  }

  private static float lightFromSlope(PVector slope, PVector lightDir) {
    if (lightDir == null) return 1.0f;
    PVector normal = new PVector(-slope.x, -slope.y, 1.0f);
    if (normal.magSq() < 1e-8f) normal.set(0, 0, 1);
    else normal.normalize();

    float d = max(0, normal.x * lightDir.x + normal.y * lightDir.y + normal.z * lightDir.z);
    float ambient = 0.35f;
    return constrain(ambient + (1.0f - ambient) * d, 0, 1);
  }

  public static float computeLightForCell(MapModel model, int idx, PVector lightDir) {
    PVector slope = estimateCellSlope(model, idx);
    return lightFromSlope(slope, lightDir);
  }
}
// ----- Export scaffold -----

class ExportLayout {
  IntRect panel;
  int titleY;
  int bodyY;
  IntRect pngBtn;
  IntRect svgBtn;
  IntRect geoJsonBtn;
  int exportScaleLabelY;
  IntRect setResolutionBtn;
  IntRect mapExportBtn;
  IntRect mapImportBtn;
  int mapSectionY;
  int statusY;
}

public ExportLayout buildExportLayout() {
  ExportLayout l = new ExportLayout();
  l.panel = new IntRect(PANEL_X, panelTop(), PANEL_W, 0);
  int curY = l.panel.y + PANEL_PADDING;
  l.titleY = curY;
  curY += PANEL_TITLE_H + PANEL_SECTION_GAP;
  l.pngBtn = new IntRect(l.panel.x + PANEL_PADDING, curY, 140, PANEL_BUTTON_H);
  l.svgBtn = new IntRect(l.pngBtn.x + l.pngBtn.w + PANEL_ROW_GAP, curY, 140, PANEL_BUTTON_H);
  curY += PANEL_BUTTON_H + PANEL_ROW_GAP;

  l.geoJsonBtn = new IntRect(l.panel.x + PANEL_PADDING, curY, 140, PANEL_BUTTON_H);
  curY += PANEL_BUTTON_H + PANEL_ROW_GAP;

  l.exportScaleLabelY = curY;
  curY += PANEL_LABEL_H + PANEL_ROW_GAP;

  l.setResolutionBtn = new IntRect(l.panel.x + PANEL_PADDING, curY, 220, PANEL_BUTTON_H);
  curY += PANEL_BUTTON_H + PANEL_SECTION_GAP;
  l.bodyY = curY;
  curY += PANEL_LABEL_H * 2 + PANEL_SECTION_GAP;

  l.mapSectionY = curY;
  curY += PANEL_LABEL_H + PANEL_ROW_GAP;
  l.mapExportBtn = new IntRect(l.panel.x + PANEL_PADDING, curY, 120, PANEL_BUTTON_H);
  l.mapImportBtn = new IntRect(l.mapExportBtn.x + l.mapExportBtn.w + PANEL_ROW_GAP, curY, 120, PANEL_BUTTON_H);
  curY += PANEL_BUTTON_H + PANEL_SECTION_GAP;

  l.statusY = curY;
  curY += PANEL_LABEL_H + PANEL_SECTION_GAP;
  l.panel.h = curY - l.panel.y;
  return l;
}

public void drawExportPanel() {
  ExportLayout layout = buildExportLayout();
  drawPanelBackground(layout.panel);

  int labelX = layout.panel.x + PANEL_PADDING;
  fill(0);
  textAlign(LEFT, TOP);
  text("Export", labelX, layout.titleY);

  // Buttons
  drawBevelButton(layout.pngBtn.x, layout.pngBtn.y, layout.pngBtn.w, layout.pngBtn.h, false);
  fill(10);
  textAlign(CENTER, CENTER);
  text("Export PNG", layout.pngBtn.x + layout.pngBtn.w / 2, layout.pngBtn.y + layout.pngBtn.h / 2);
  registerUiTooltip(layout.pngBtn, tooltipFor("export_png"));

  drawBevelButton(layout.svgBtn.x, layout.svgBtn.y, layout.svgBtn.w, layout.svgBtn.h, false);
  fill(10);
  textAlign(CENTER, CENTER);
  text("Export SVG", layout.svgBtn.x + layout.svgBtn.w / 2, layout.svgBtn.y + layout.svgBtn.h / 2);
  registerUiTooltip(layout.svgBtn, tooltipFor("export_svg"));

  drawBevelButton(layout.geoJsonBtn.x, layout.geoJsonBtn.y, layout.geoJsonBtn.w, layout.geoJsonBtn.h, false);
  fill(10);
  textAlign(CENTER, CENTER);
  text("Export GeoJSON", layout.geoJsonBtn.x + layout.geoJsonBtn.w / 2, layout.geoJsonBtn.y + layout.geoJsonBtn.h / 2);
  registerUiTooltip(layout.geoJsonBtn, tooltipFor("export_geojson"));

  // Resolution control
  drawBevelButton(layout.setResolutionBtn.x, layout.setResolutionBtn.y, layout.setResolutionBtn.w, layout.setResolutionBtn.h, false);
  fill(10);
  textAlign(CENTER, CENTER);
  text("Set resolution from zoom", layout.setResolutionBtn.x + layout.setResolutionBtn.w / 2, layout.setResolutionBtn.y + layout.setResolutionBtn.h / 2);
  registerUiTooltip(layout.setResolutionBtn, tooltipFor("export_scale"));
  fill(0);
  textAlign(LEFT, TOP);
  text("Current export scale: x" + nf(exportScale, 1, 2), labelX, layout.exportScaleLabelY);

  fill(60);
  textAlign(LEFT, TOP);
  text("Uses Rendering tab toggles (biomes, zones, paths, etc.)\nand current viewport + padding.", labelX, layout.bodyY);

  fill(0);
  textAlign(LEFT, TOP);
  text("Map data (JSON)", labelX, layout.mapSectionY);
  drawBevelButton(layout.mapExportBtn.x, layout.mapExportBtn.y, layout.mapExportBtn.w, layout.mapExportBtn.h, false);
  drawBevelButton(layout.mapImportBtn.x, layout.mapImportBtn.y, layout.mapImportBtn.w, layout.mapImportBtn.h, false);
  fill(10);
  textAlign(CENTER, CENTER);
  text("Export map", layout.mapExportBtn.x + layout.mapExportBtn.w / 2, layout.mapExportBtn.y + layout.mapExportBtn.h / 2);
  text("Import map", layout.mapImportBtn.x + layout.mapImportBtn.w / 2, layout.mapImportBtn.y + layout.mapImportBtn.h / 2);
  registerUiTooltip(layout.mapExportBtn, tooltipFor("export_map_json"));
  registerUiTooltip(layout.mapImportBtn, tooltipFor("import_map_json"));

  fill(30);
  textAlign(LEFT, TOP);
  String status = (lastExportStatus != null && lastExportStatus.length() > 0)
    ? "Last export: " + lastExportStatus
    : "No export yet.";
  text(status, labelX, layout.statusY);
}
// Export/render output helpers split from Main.pde to keep the file size manageable.

public String exportPng() {
  long tExportStart = millis();
  if (!ensureExportPreview()) return "Export failed: preview unavailable";
  if (exportPreview == null) return "Export failed: no buffer";
  String dir = "exports";
  java.io.File folder = new java.io.File(dir);
  folder.mkdirs();
  String ts = nf(year(), 4, 0) + nf(month(), 2, 0) + nf(day(), 2, 0) + "_" +
              nf(hour(), 2, 0) + nf(minute(), 2, 0) + nf(second(), 2, 0);
  String path = dir + java.io.File.separator + "map_" + ts + ".png";
  exportPreview.save(path);
  long tExportEnd = millis();
  println("Export timing ms: total=" + (tExportEnd - tExportStart));
  return path;
}

public String exportSvg() {
  // Compute inner world rect from render padding
  float worldW = mapModel.maxX - mapModel.minX;
  float worldH = mapModel.maxY - mapModel.minY;
  if (worldW <= 0 || worldH <= 0) return "Failed: invalid world bounds";

  float safePad = constrain(renderPaddingPct, 0, 0.49f);
  float padX = max(0, safePad) * worldW;
  float padY = max(0, safePad) * worldH;
  float innerWX = mapModel.minX + padX;
  float innerWY = mapModel.minY + padY;
  float innerWW = worldW - padX * 2;
  float innerWH = worldH - padY * 2;
  if (innerWW <= 1e-6f || innerWH <= 1e-6f) return "Failed: export padding too large";

  float innerAspect = innerWW / innerWH;
  float safeScale = max(0.1f, exportScale);
  int pxH = max(1, round(max(1, height) * safeScale));
  int pxW = max(1, round(pxH * innerAspect));
  if (pxW <= 0 || pxH <= 0) return "Failed: export size collapsed";

  // Helpers
  float scaleX = pxW / innerWW;
  float scaleY = pxH / innerWH;
  java.text.DecimalFormat df = new java.text.DecimalFormat("0.###");
  java.util.function.Function<Float, String> fmt = (Float v) -> df.format(v);
  java.util.function.Function<String, String> esc = (String v) -> {
    if (v == null) return "";
    return v.replace("&", "&amp;").replace("<", "&lt;").replace("\"", "&quot;");
  };
  java.util.function.Function<Integer, String> toHex = (Integer rgb) -> {
    int r = (rgb >> 16) & 0xFF;
    int g = (rgb >> 8) & 0xFF;
    int b = rgb & 0xFF;
    return String.format("#%02X%02X%02X", r, g, b);
  };
  java.util.function.Function<PVector, PVector> worldToSvg = (PVector w) -> {
    return new PVector((w.x - innerWX) * scaleX, (w.y - innerWY) * scaleY);
  };
  float[] hsbScratch = new float[3];

  RenderSettings s = renderSettings;
  int landRgb = hsb01ToARGB(s.landHue01, s.landSat01, s.landBri01, 1.0f);
  int waterRgb = hsb01ToARGB(s.waterHue01, s.waterSat01, s.waterBri01, 1.0f);
  String landHex = toHex.apply(landRgb);
  String waterHex = toHex.apply(waterRgb);

  StringBuilder sb = new StringBuilder();
  sb.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n");
  sb.append("<svg xmlns=\"http://www.w3.org/2000/svg\" width=\"").append(pxW)
    .append("\" height=\"").append(pxH).append("\" viewBox=\"0 0 ")
    .append(pxW).append(" ").append(pxH).append("\">\n");
  sb.append("  <style>text{font-family:sans-serif;fill:#000;} .water{fill:")
    .append(waterHex).append(";}</style>\n");

  // Background layer
  sb.append("  <g id=\"background\">\n");
  sb.append("    <rect width=\"").append(pxW).append("\" height=\"").append(pxH)
    .append("\" fill=\"").append(landHex).append("\" />\n");
  sb.append("  </g>\n");

  // Water fill (no stroke)
  sb.append("  <g id=\"water\">\n");
  if (mapModel.cells != null) {
    for (int ci = 0; ci < mapModel.cells.size(); ci++) {
      Cell c = mapModel.cells.get(ci);
      if (c == null || c.vertices == null || c.vertices.size() < 3) continue;
      if (c.elevation >= seaLevel) continue;
      StringBuilder path = new StringBuilder();
      for (int i = 0; i < c.vertices.size(); i++) {
        PVector v = worldToSvg.apply(c.vertices.get(i));
        path.append((i == 0) ? "M " : " L ");
        path.append(fmt.apply(v.x)).append(" ").append(fmt.apply(v.y));
      }
      path.append(" Z");
      sb.append("    <path d=\"").append(path.toString()).append("\" fill=\"").append(waterHex)
        .append("\" stroke=\"none\" class=\"water\" data-cell-id=\"").append(ci).append("\"/>\n");
    }
  }
  sb.append("  </g>\n");

  // Biome fills (no stroke)
  sb.append("  <g id=\"biomes\">\n");
  boolean drawBiomes = mapModel.cells != null && mapModel.biomeTypes != null && mapModel.biomeTypes.size() > 0 &&
                       (s.biomeFillAlpha01 > 1e-4f || s.biomeUnderwaterAlpha01 > 1e-4f);
  if (drawBiomes) {
    for (int ci = 0; ci < mapModel.cells.size(); ci++) {
      Cell c = mapModel.cells.get(ci);
      if (c == null || c.vertices == null || c.vertices.size() < 3) continue;
      boolean isWater = c.elevation < seaLevel;
      float alpha = isWater ? s.biomeUnderwaterAlpha01 : s.biomeFillAlpha01;
      if (alpha <= 1e-4f) continue;
      if (c.biomeId < 0 || c.biomeId >= mapModel.biomeTypes.size()) continue;
      ZoneType zt = mapModel.biomeTypes.get(c.biomeId);
      if (zt == null) continue;
      rgbToHSB01(zt.col, hsbScratch);
      hsbScratch[1] = constrain(hsbScratch[1] * s.biomeSatScale01, 0, 1);
      hsbScratch[2] = constrain(hsbScratch[2] * s.biomeBriScale01, 0, 1);
      int rgb = hsb01ToARGB(hsbScratch[0], hsbScratch[1], hsbScratch[2], 1.0f);
      String fill = toHex.apply(rgb);
      StringBuilder path = new StringBuilder();
      for (int i = 0; i < c.vertices.size(); i++) {
        PVector v = worldToSvg.apply(c.vertices.get(i));
        path.append((i == 0) ? "M " : " L ");
        path.append(fmt.apply(v.x)).append(" ").append(fmt.apply(v.y));
      }
      path.append(" Z");
      sb.append("    <path d=\"").append(path.toString()).append("\" fill=\"").append(fill)
        .append("\" fill-opacity=\"").append(fmt.apply(alpha)).append("\" stroke=\"none\" class=\"biome biome-")
        .append(c.biomeId).append("\" data-biome-id=\"").append(c.biomeId).append("\" data-cell-id=\"")
        .append(ci).append("\"/>\n");
    }
  }
  sb.append("  </g>\n");

  // Borders layer (world bounds box)
  sb.append("  <g id=\"borders\">\n");
  sb.append("    <rect x=\"0\" y=\"0\" width=\"").append(pxW).append("\" height=\"").append(pxH)
    .append("\" fill=\"none\" stroke=\"#000\" stroke-width=\"1\"/>\n");
  sb.append("  </g>\n");

  // Zones (stroke-only along zone boundaries) when enabled
  sb.append("  <g id=\"zones\">\n");
  if (s.zoneStrokeAlpha01 > 1e-4f && mapModel.zones != null && mapModel.cells != null) {
    for (int zi = 0; zi < mapModel.zones.size(); zi++) {
      MapModel.MapZone z = mapModel.zones.get(zi);
      if (z == null || z.cells == null) continue;
      rgbToHSB01(z.col, hsbScratch);
      hsbScratch[1] = constrain(hsbScratch[1] * s.zoneStrokeSatScale01, 0, 1);
      hsbScratch[2] = constrain(hsbScratch[2] * s.zoneStrokeBriScale01, 0, 1);
      String stroke = toHex.apply(hsb01ToARGB(hsbScratch[0], hsbScratch[1], hsbScratch[2], 1.0f));
      for (int ci : z.cells) {
        if (ci < 0 || ci >= mapModel.cells.size()) continue;
        Cell c = mapModel.cells.get(ci);
        if (c == null || c.vertices == null || c.vertices.size() < 3) continue;
        StringBuilder path = new StringBuilder();
        for (int i = 0; i < c.vertices.size(); i++) {
          PVector v = worldToSvg.apply(c.vertices.get(i));
          path.append((i == 0) ? "M " : " L ");
          path.append(fmt.apply(v.x)).append(" ").append(fmt.apply(v.y));
        }
        path.append(" Z");
        sb.append("    <path d=\"").append(path.toString()).append("\" fill=\"none\" stroke=\"").append(stroke)
          .append("\" stroke-width=\"1\" stroke-linejoin=\"round\" stroke-linecap=\"round\" stroke-opacity=\"")
          .append(fmt.apply(s.zoneStrokeAlpha01)).append("\" class=\"zone zone-").append(zi)
          .append("\" data-zone-id=\"").append(zi).append("\" data-comment=\"").append(esc.apply(z.comment != null ? z.comment : "")).append("\"/>\n");
      }
    }
  }
  sb.append("  </g>\n");

  // Coastline stroke (immediate coast)
  sb.append("  <g id=\"coast\">\n");
  ArrayList<PVector[]> coastSegs = mapModel.collectCoastSegments(seaLevel);
  for (PVector[] seg : coastSegs) {
    if (seg == null || seg.length != 2) continue;
    PVector a = worldToSvg.apply(seg[0]);
    PVector b = worldToSvg.apply(seg[1]);
    sb.append("    <line x1=\"").append(fmt.apply(a.x)).append("\" y1=\"").append(fmt.apply(a.y))
      .append("\" x2=\"").append(fmt.apply(b.x)).append("\" y2=\"").append(fmt.apply(b.y))
      .append("\" stroke=\"").append(waterHex).append("\" stroke-width=\"1\" stroke-linecap=\"round\" class=\"coast\"/>\n");
  }
  sb.append("  </g>\n");

  // Paths layer
  sb.append("  <g id=\"paths\">\n");
  if (s.showPaths && mapModel.paths != null) {
    for (int pi = 0; pi < mapModel.paths.size(); pi++) {
      Path p = mapModel.paths.get(pi);
      if (p == null || p.routes == null || p.routes.isEmpty()) continue;
      int typeCount = (mapModel.pathTypes != null) ? mapModel.pathTypes.size() : 0;
      int typeId = constrain(p.typeId, 0, max(0, typeCount - 1));
      int col = (mapModel.pathTypes != null && typeId >= 0 && typeId < typeCount)
        ? mapModel.pathTypes.get(typeId).col : color(80);
      float wPx = (mapModel.pathTypes != null && typeId >= 0 && typeId < typeCount)
        ? mapModel.pathTypes.get(typeId).weightPx : 2.0f;
      String stroke = toHex.apply(col);
      String name = (p.name != null && p.name.length() > 0) ? p.name : "Path";
      for (int ri = 0; ri < p.routes.size(); ri++) {
        ArrayList<PVector> route = p.routes.get(ri);
        if (route == null || route.size() < 2) continue;
        StringBuilder pts = new StringBuilder();
        for (PVector v : route) {
          PVector spt = worldToSvg.apply(v);
          if (pts.length() > 0) pts.append(" ");
          pts.append(fmt.apply(spt.x)).append(",").append(fmt.apply(spt.y));
        }
        sb.append("    <polyline points=\"").append(pts.toString()).append("\" fill=\"none\" stroke=\"")
          .append(stroke).append("\" stroke-width=\"").append(fmt.apply(wPx))
          .append("\" stroke-linecap=\"round\" stroke-linejoin=\"round\" class=\"path type-")
          .append(typeId).append("\" data-type-id=\"").append(typeId)
          .append("\" data-path-id=\"").append(pi).append("\" data-name=\"")
          .append(esc.apply(name)).append("\" data-comment=\"").append(esc.apply(p.comment != null ? p.comment : ""))
          .append("\"/>\n");
      }
    }
  }
  sb.append("  </g>\n");

  // Structures layer
  sb.append("  <g id=\"structures\">\n");
  if (s.showStructures && mapModel.structures != null) {
    for (int si = 0; si < mapModel.structures.size(); si++) {
      Structure st = mapModel.structures.get(si);
      if (st == null) continue;
      PVector sp = worldToSvg.apply(new PVector(st.x, st.y));
      float sizePx = st.size * scaleX;
      float strokePx = st.strokeWeightPx;
      int rgb = st.fillCol;
      String fill = toHex.apply(rgb);
      String name = (st.name != null && st.name.length() > 0) ? st.name : "Structure";
      float angleDeg = degrees(st.angle);
      sb.append("    <g transform=\"translate(").append(fmt.apply(sp.x)).append(",").append(fmt.apply(sp.y))
        .append(") rotate(").append(fmt.apply(angleDeg)).append(")\" class=\"structure type-")
        .append(st.typeId).append("\" data-type-id=\"").append(st.typeId)
        .append("\" data-structure-id=\"").append(si).append("\" data-name=\"").append(esc.apply(name))
        .append("\" data-comment=\"").append(esc.apply(st.comment != null ? st.comment : "")).append("\">");
      switch (st.shape) {
        case RECTANGLE: {
          float w = sizePx;
          float h = (st.aspect != 0) ? (sizePx / max(0.1f, st.aspect)) : sizePx;
          sb.append("<rect x=\"").append(fmt.apply(-w * 0.5f)).append("\" y=\"").append(fmt.apply(-h * 0.5f))
            .append("\" width=\"").append(fmt.apply(w)).append("\" height=\"").append(fmt.apply(h))
            .append("\" fill=\"").append(fill).append("\" fill-opacity=\"").append(fmt.apply(st.alpha01))
            .append("\" stroke=\"#000\" stroke-width=\"").append(fmt.apply(strokePx)).append("\"/>");
          break;
        }
        case CIRCLE: {
          sb.append("<circle cx=\"0\" cy=\"0\" r=\"").append(fmt.apply(sizePx * 0.5f))
            .append("\" fill=\"").append(fill).append("\" fill-opacity=\"").append(fmt.apply(st.alpha01))
            .append("\" stroke=\"#000\" stroke-width=\"").append(fmt.apply(strokePx)).append("\"/>");
          break;
        }
        case TRIANGLE: {
          float r = sizePx;
          float h = r * 0.866f;
          sb.append("<polygon points=\"")
            .append(fmt.apply(-r * 0.5f)).append(",").append(fmt.apply(h * 0.333f)).append(" ")
            .append(fmt.apply(r * 0.5f)).append(",").append(fmt.apply(h * 0.333f)).append(" ")
            .append(fmt.apply(0f)).append(",").append(fmt.apply(-h * 0.666f))
            .append("\" fill=\"").append(fill).append("\" fill-opacity=\"").append(fmt.apply(st.alpha01))
            .append("\" stroke=\"#000\" stroke-width=\"").append(fmt.apply(strokePx)).append("\"/>");
          break;
        }
        case HEXAGON: {
          float rad = sizePx * 0.5f;
          StringBuilder pts = new StringBuilder();
          for (int v = 0; v < 6; v++) {
            float a = radians(60 * v);
            float vx = cos(a) * rad;
            float vy = sin(a) * rad;
            if (pts.length() > 0) pts.append(" ");
            pts.append(fmt.apply(vx)).append(",").append(fmt.apply(vy));
          }
          sb.append("<polygon points=\"").append(pts.toString()).append("\" fill=\"").append(fill)
            .append("\" fill-opacity=\"").append(fmt.apply(st.alpha01))
            .append("\" stroke=\"#000\" stroke-width=\"").append(fmt.apply(strokePx)).append("\"/>");
          break;
        }
        default: {
          float w = sizePx;
          float h = sizePx;
          sb.append("<rect x=\"").append(fmt.apply(-w * 0.5f)).append("\" y=\"").append(fmt.apply(-h * 0.5f))
            .append("\" width=\"").append(fmt.apply(w)).append("\" height=\"").append(fmt.apply(h))
            .append("\" fill=\"").append(fill).append("\" fill-opacity=\"").append(fmt.apply(st.alpha01))
            .append("\" stroke=\"#000\" stroke-width=\"").append(fmt.apply(strokePx)).append("\"/>");
          break;
        }
      }
      sb.append("</g>\n");
    }
  }
  sb.append("  </g>\n");

  // Labels layer
  sb.append("  <g id=\"labels\">\n");
  float baseLabelSize = (renderSettings != null && renderSettings.labelSizeZonePx > 0) ? renderSettings.labelSizeZonePx : labelSizeDefault();
  float pathLabelSize = (renderSettings != null && renderSettings.labelSizePathPx > 0) ? renderSettings.labelSizePathPx : baseLabelSize;
  float structLabelSize = (renderSettings != null && renderSettings.labelSizeStructPx > 0) ? renderSettings.labelSizeStructPx : baseLabelSize;
  float arbLabelSize = (renderSettings != null && renderSettings.labelSizeArbPx > 0) ? renderSettings.labelSizeArbPx : labelSizeDefault();
  if (s.showLabelsZones && mapModel.zones != null) {
    for (MapModel.MapZone z : mapModel.zones) {
      if (z == null || z.cells == null || z.cells.isEmpty()) continue;
      float cx = 0, cy = 0; int count = 0;
      for (int ci : z.cells) {
        if (ci < 0 || ci >= mapModel.cells.size()) continue;
        Cell c = mapModel.cells.get(ci);
        if (c == null || c.vertices == null || c.vertices.size() < 3) continue;
        PVector cen = mapModel.cellCentroid(c);
        cx += cen.x; cy += cen.y; count++;
      }
      if (count <= 0) continue;
      cx /= count; cy /= count;
      PVector sp = worldToSvg.apply(new PVector(cx, cy));
      String name = (z.name != null && z.name.length() > 0) ? z.name : "Zone";
      sb.append("    <text x=\"").append(fmt.apply(sp.x)).append("\" y=\"").append(fmt.apply(sp.y))
        .append("\" text-anchor=\"middle\" dominant-baseline=\"middle\" font-size=\"")
        .append(fmt.apply(baseLabelSize)).append("\" class=\"label zone\" data-name=\"")
        .append(esc.apply(name)).append("\" data-comment=\"").append(esc.apply(z.comment != null ? z.comment : ""))
        .append("\">").append(esc.apply(name)).append("</text>\n");
    }
  }
  if (s.showLabelsPaths && mapModel.paths != null) {
    for (int pi = 0; pi < mapModel.paths.size(); pi++) {
      Path p = mapModel.paths.get(pi);
      if (p == null || p.routes == null || p.routes.isEmpty()) continue;
      String txt = (p.name != null && p.name.length() > 0) ? p.name : "Path";
      PVector bestA = null, bestB = null;
      float bestLenSq = -1;
      for (ArrayList<PVector> route : p.routes) {
        if (route == null || route.size() < 2) continue;
        for (int i = 0; i < route.size() - 1; i++) {
          PVector a = route.get(i);
          PVector b = route.get(i + 1);
          float dx = b.x - a.x;
          float dy = b.y - a.y;
          float lenSq = dx * dx + dy * dy;
          if (lenSq > bestLenSq) {
            bestLenSq = lenSq;
            bestA = a;
            bestB = b;
          }
        }
      }
      if (bestA == null || bestB == null || bestLenSq <= 1e-8f) continue;
      float angle = degrees(atan2(bestB.y - bestA.y, bestB.x - bestA.x));
      if (angle > 90 || angle < -90) angle += 180;
      float mx = (bestA.x + bestB.x) * 0.5f;
      float my = (bestA.y + bestB.y) * 0.5f;
      PVector sp = worldToSvg.apply(new PVector(mx, my));
      sb.append("    <text x=\"").append(fmt.apply(sp.x)).append("\" y=\"").append(fmt.apply(sp.y))
        .append("\" text-anchor=\"middle\" dominant-baseline=\"middle\" font-size=\"")
        .append(fmt.apply(pathLabelSize)).append("\" transform=\"rotate(").append(fmt.apply(angle))
        .append(" ").append(fmt.apply(sp.x)).append(" ").append(fmt.apply(sp.y))
        .append(")\" class=\"label path\" data-path-id=\"").append(pi).append("\" data-name=\"")
        .append(esc.apply(txt)).append("\" data-comment=\"").append(esc.apply(p.comment != null ? p.comment : ""))
        .append("\">").append(esc.apply(txt)).append("</text>\n");
    }
  }
  if (s.showLabelsStructures && mapModel.structures != null) {
    for (int si = 0; si < mapModel.structures.size(); si++) {
      Structure st = mapModel.structures.get(si);
      if (st == null) continue;
      String txt = (st.name != null && st.name.length() > 0) ? st.name : "Structure";
      PVector sp = worldToSvg.apply(new PVector(st.x, st.y));
      sb.append("    <text x=\"").append(fmt.apply(sp.x)).append("\" y=\"").append(fmt.apply(sp.y))
        .append("\" text-anchor=\"middle\" dominant-baseline=\"middle\" font-size=\"")
        .append(fmt.apply(structLabelSize)).append("\" class=\"label structure\" data-structure-id=\"")
        .append(si).append("\" data-name=\"").append(esc.apply(txt)).append("\" data-comment=\"")
        .append(esc.apply(st.comment != null ? st.comment : "")).append("\">")
        .append(esc.apply(txt)).append("</text>\n");
    }
  }
  if (s.showLabelsArbitrary && mapModel.labels != null) {
    for (int li = 0; li < mapModel.labels.size(); li++) {
      MapLabel l = mapModel.labels.get(li);
      if (l == null || l.text == null || l.text.length() == 0) continue;
      PVector sp = worldToSvg.apply(new PVector(l.x, l.y));
      sb.append("    <text x=\"").append(fmt.apply(sp.x)).append("\" y=\"").append(fmt.apply(sp.y))
        .append("\" text-anchor=\"middle\" dominant-baseline=\"middle\" font-size=\"")
        .append(fmt.apply(arbLabelSize)).append("\" class=\"label arbitrary\" data-label-id=\"")
        .append(li).append("\" data-comment=\"").append(esc.apply(l.comment != null ? l.comment : ""))
        .append("\">").append(esc.apply(l.text)).append("</text>\n");
    }
  }
  sb.append("  </g>\n");

  // Legend layer (simple text lists)
  sb.append("  <g id=\"legend\">\n");
  float legendX = 12;
  float legendY = 18;
  sb.append("    <text x=\"").append(fmt.apply(legendX)).append("\" y=\"").append(fmt.apply(legendY))
    .append("\" font-size=\"12\" text-anchor=\"start\" dominant-baseline=\"hanging\">Legend</text>\n");
  legendY += 16;
  if (mapModel.pathTypes != null) {
    for (int i = 0; i < mapModel.pathTypes.size(); i++) {
      PathType pt = mapModel.pathTypes.get(i);
      if (pt == null) continue;
      sb.append("    <text x=\"").append(fmt.apply(legendX)).append("\" y=\"").append(fmt.apply(legendY))
        .append("\" font-size=\"11\" text-anchor=\"start\" dominant-baseline=\"hanging\" class=\"legend-path type-")
        .append(i).append("\" data-type-id=\"").append(i).append("\">Path type ").append(i).append(": ")
        .append(esc.apply(pt.name != null ? pt.name : "")).append("</text>\n");
      legendY += 14;
    }
  }
  if (mapModel.structures != null && !mapModel.structures.isEmpty()) {
    sb.append("    <text x=\"").append(fmt.apply(legendX)).append("\" y=\"").append(fmt.apply(legendY))
      .append("\" font-size=\"12\" text-anchor=\"start\" dominant-baseline=\"hanging\">Structures</text>\n");
    legendY += 14;
    for (int i = 0; i < mapModel.structures.size(); i++) {
      Structure st = mapModel.structures.get(i);
      if (st == null) continue;
      sb.append("    <text x=\"").append(fmt.apply(legendX)).append("\" y=\"").append(fmt.apply(legendY))
        .append("\" font-size=\"11\" text-anchor=\"start\" dominant-baseline=\"hanging\" class=\"legend-structure type-")
        .append(st.typeId).append("\" data-type-id=\"").append(st.typeId).append("\" data-structure-id=\"")
        .append(i).append("\">").append(esc.apply(st.name != null ? st.name : "Structure")).append("</text>\n");
      legendY += 14;
    }
  }
  sb.append("  </g>\n");

  sb.append("</svg>\n");

  String dir = "exports";
  java.io.File folder = new java.io.File(dir);
  folder.mkdirs();
  String ts = nf(year(), 4, 0) + nf(month(), 2, 0) + nf(day(), 2, 0) + "_" +
              nf(hour(), 2, 0) + nf(minute(), 2, 0) + nf(second(), 2, 0);
  String path = dir + java.io.File.separator + "map_" + ts + ".svg";
  PrintWriter writer = createWriter(path);
  writer.print(sb.toString());
  writer.flush();
  writer.close();
  return path;
}

public String exportMapJson() {
  try {
    JSONObject root = new JSONObject();

    JSONObject meta = new JSONObject();
    meta.setInt("schemaVersion", 1);
    meta.setString("savedAt", new java.text.SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'").format(new java.util.Date()));
    root.setJSONObject("meta", meta);

    JSONObject view = new JSONObject();
    view.setFloat("centerX", viewport.centerX);
    view.setFloat("centerY", viewport.centerY);
    view.setFloat("zoom", viewport.zoom);
    root.setJSONObject("view", view);

    JSONObject settings = new JSONObject();
    settings.setJSONObject("render", serializeRenderSettings(renderSettings));
    root.setJSONObject("settings", settings);

    JSONObject types = new JSONObject();
    types.setJSONArray("pathTypes", serializePathTypes(mapModel.pathTypes));
    types.setJSONArray("biomeTypes", serializeZoneTypes(mapModel.biomeTypes));
    root.setJSONObject("types", types);

    root.setJSONArray("sites", serializeSites(mapModel.sites));
    root.setJSONArray("cells", serializeCells(mapModel.cells));
    root.setJSONArray("zones", serializeZones(mapModel.zones));
    root.setJSONArray("paths", serializePaths(mapModel.paths));
    root.setJSONArray("structures", serializeStructures(mapModel.structures));
    root.setJSONArray("labels", serializeLabels(mapModel.labels));

    File dir = new File(sketchPath("exports"));
    if (!dir.exists()) dir.mkdirs();
    String ts = nf(year(), 4, 0) + nf(month(), 2, 0) + nf(day(), 2, 0) + "_" +
                nf(hour(), 2, 0) + nf(minute(), 2, 0) + nf(second(), 2, 0);
    File target = new File(dir, "map_" + ts + ".json");
    File latest = new File(dir, "map_latest.json");
    saveJSONObject(root, target.getAbsolutePath());
    saveJSONObject(root, latest.getAbsolutePath());
    return target.getAbsolutePath();
  } catch (Exception e) {
    e.printStackTrace();
    return "Failed: " + e.getMessage();
  }
}
public void handlePathsMousePressed(float wx, float wy) {
  if (mapModel.paths.isEmpty()) {
    Path np = new Path();
    np.typeId = activePathTypeIndex;
    np.name = mapModel.defaultPathNameForType(np.typeId);
    mapModel.paths.add(np);
    selectedPathIndex = 0;
  }
  wx = constrain(wx, mapModel.minX, mapModel.maxX);
  wy = constrain(wy, mapModel.minY, mapModel.maxY);

  // Always snap to the nearest available point; skip if none
  PVector snapped = findNearestSnappingPoint(wx, wy, Float.MAX_VALUE);
  if (snapped == null) return;
  PVector target = snapped;

  if (pendingPathStart == null) {
    pendingPathStart = target;
    return;
  }

  // Ignore zero-length
  if (dist(pendingPathStart.x, pendingPathStart.y, target.x, target.y) < 1e-6f) {
    pendingPathStart = null;
    return;
  }

  Path targetPath = (selectedPathIndex >= 0 && selectedPathIndex < mapModel.paths.size())
                    ? mapModel.paths.get(selectedPathIndex)
                    : null;
  ArrayList<PVector> route = new ArrayList<PVector>();
  if (pendingPathStart != null) {
    PathRouteMode mode = currentPathRouteMode();
    if (mode == PathRouteMode.ENDS) {
      route.add(pendingPathStart.copy());
      route.add(target.copy());
    } else if (mode == PathRouteMode.PATHFIND) {
      ArrayList<PVector> rp = mapModel.findSnapPathFlattest(pendingPathStart, target);
      if (rp != null && rp.size() > 1) route = rp;
    }
    if (route.isEmpty()) {
      route = new ArrayList<PVector>();
      route.add(pendingPathStart.copy());
      route.add(target.copy());
    }
  }

  if (targetPath == null) {
    Path np = new Path();
    np.typeId = activePathTypeIndex;
    np.name = mapModel.defaultPathNameForType(np.typeId);
    mapModel.paths.add(np);
    selectedPathIndex = mapModel.paths.size() - 1;
    targetPath = np;
  }

  if (targetPath.routes.isEmpty()) {
    targetPath.typeId = activePathTypeIndex;
  }
  mapModel.appendRouteToPath(targetPath, route);
  pendingPathStart = null;
}

public void mouseDragged() {
  if (isPanning) {
    int dx = mouseX - lastMouseX;
    int dy = mouseY - lastMouseY;
    viewport.panScreen(dx, dy);
    lastMouseX = mouseX;
    lastMouseY = mouseY;
    return;
  }

   // If a slider is active, keep updating that slider only
  if (mouseButton == LEFT && activeSlider != SLIDER_NONE) {
    updateActiveSlider(mouseX, mouseY);
    return;
  }

  // Dragging sliders in Sites panel
  if (mouseButton == LEFT && currentTool == Tool.EDIT_SITES && isInSitesPanel(mouseX, mouseY)) {
    SitesLayout layout = buildSitesLayout();
    if (layout.densitySlider.contains(mouseX, mouseY)) {
      float t = (mouseX - layout.densitySlider.x) / (float)layout.densitySlider.w;
      int newCount = round(t * MAX_SITE_COUNT);
      siteTargetCount = constrain(newCount, 0, MAX_SITE_COUNT);
      return;
    }

    if (layout.fuzzSlider.contains(mouseX, mouseY)) {
      float t = (mouseX - layout.fuzzSlider.x) / (float)layout.fuzzSlider.w;
      t = constrain(t, 0, 1);
      siteFuzz = t * 0.3f;
      return;
    }

    if (layout.modeSlider.contains(mouseX, mouseY)) {
      int modeCount = placementModes.length;
      if (modeCount < 1) modeCount = 1;
      float t = (mouseX - layout.modeSlider.x) / (float)layout.modeSlider.w;
      t = constrain(t, 0, 1);
      int idx = round(t * (modeCount - 1));
      placementModeIndex = constrain(idx, 0, placementModes.length - 1);
      return;
    }

    return;
  }

  // Elevation: sliders dragging
  if (mouseButton == LEFT && currentTool == Tool.EDIT_ELEVATION && isInElevationPanel(mouseX, mouseY)) {
    ElevationLayout layout = buildElevationLayout();
    if (layout.seaSlider.contains(mouseX, mouseY)) {
      float t = sliderNorm(layout.seaSlider, mouseX);
      seaLevel = t * 1.0f - 0.5f;
      return;
    }
    if (layout.radiusSlider.contains(mouseX, mouseY)) {
      float t = sliderNorm(layout.radiusSlider, mouseX);
      elevationBrushRadius = constrain(0.01f + t * (0.2f - 0.01f), 0.01f, 0.2f);
      return;
    }
    if (layout.strengthSlider.contains(mouseX, mouseY)) {
      float t = sliderNorm(layout.strengthSlider, mouseX);
      elevationBrushStrength = constrain(0.005f + t * (0.2f - 0.005f), 0.005f, 0.2f);
      return;
    }
    if (layout.noiseSlider.contains(mouseX, mouseY)) {
      float t = sliderNorm(layout.noiseSlider, mouseX);
      elevationNoiseScale = constrain(1.0f + t * (12.0f - 1.0f), 1.0f, 12.0f);
      return;
    }
  }

  // Zones: slider dragging (only for hue + paint while dragging)
  if (mouseButton == LEFT && currentTool == Tool.EDIT_BIOMES && isInBiomesPanel(mouseX, mouseY)) {
    BiomesLayout layout = buildBiomesLayout();
    int n = (mapModel.biomeTypes == null) ? 0 : mapModel.biomeTypes.size();

    if (n > 0 && activeBiomeIndex >= 0 && activeBiomeIndex < n) {
      if (layout.hueSlider.contains(mouseX, mouseY)) {
        float t = (mouseX - layout.hueSlider.x) / (float)layout.hueSlider.w;
        t = constrain(t, 0, 1);
        ZoneType active = mapModel.biomeTypes.get(activeBiomeIndex);
        active.hue01 = t;
        active.updateColorFromHSB();
        activeSlider = SLIDER_BIOME_HUE;
        return;
      }
      if (layout.satSlider != null && layout.satSlider.contains(mouseX, mouseY)) {
        float t = (mouseX - layout.satSlider.x) / (float)layout.satSlider.w;
        t = constrain(t, 0, 1);
        ZoneType active = mapModel.biomeTypes.get(activeBiomeIndex);
        active.sat01 = t;
        active.updateColorFromHSB();
        activeSlider = SLIDER_BIOME_SAT;
        return;
      }
      if (layout.briSlider != null && layout.briSlider.contains(mouseX, mouseY)) {
        float t = (mouseX - layout.briSlider.x) / (float)layout.briSlider.w;
        t = constrain(t, 0, 1);
        ZoneType active = mapModel.biomeTypes.get(activeBiomeIndex);
        active.bri01 = t;
        active.updateColorFromHSB();
        activeSlider = SLIDER_BIOME_BRI;
        return;
      }
    }

    if (layout.brushSlider.contains(mouseX, mouseY)) {
      float t = sliderNorm(layout.brushSlider, mouseX);
      zoneBrushRadius = constrain(0.01f + t * (0.15f - 0.01f), 0.01f, 0.15f);
      activeSlider = SLIDER_BIOME_BRUSH;
      return;
    }
  }

  // Zones: paint while dragging (only for Paint mode, outside UI)
  if (mouseButton == LEFT && currentTool == Tool.EDIT_BIOMES) {
    IntRect panel = getActivePanelRect();
    boolean inPanel = (panel != null && panel.contains(mouseX, mouseY));
    if (!inPanel) {
      PVector w = viewport.screenToWorld(mouseX, mouseY);
      if (currentBiomePaintMode == ZonePaintMode.ZONE_PAINT) {
        paintBiomeBrush(w.x, w.y);
      }
    }
    return;
  }

  // Zones: slider dragging
  if (mouseButton == LEFT && currentTool == Tool.EDIT_ZONES && isInZonesPanel(mouseX, mouseY)) {
    ZonesLayout layout = buildZonesLayout();
    if (layout.brushSlider.contains(mouseX, mouseY)) {
      float t = sliderNorm(layout.brushSlider, mouseX);
      zoneBrushRadius = constrain(0.01f + t * (0.15f - 0.01f), 0.01f, 0.15f);
      activeSlider = SLIDER_ZONES_BRUSH;
      return;
    }
  }

  // Zones: paint while dragging
  if (mouseButton == LEFT && currentTool == Tool.EDIT_ZONES) {
    IntRect panel = getActivePanelRect();
    boolean inPanel = (panel != null && panel.contains(mouseX, mouseY));
    if (!inPanel) {
      PVector w = viewport.screenToWorld(mouseX, mouseY);
      if (currentZonePaintMode == ZonePaintMode.ZONE_PAINT) {
        paintZoneBrush(w.x, w.y);
      }
    }
    return;
  }

  // Paths: erase while dragging
  if (mouseButton == LEFT && currentTool == Tool.EDIT_PATHS && pathEraserMode) {
    IntRect panel = getActivePanelRect();
    boolean inPanel = (panel != null && panel.contains(mouseX, mouseY));
    if (!inPanel && !isInPathsListPanel(mouseX, mouseY)) {
      PVector w = viewport.screenToWorld(mouseX, mouseY);
      mapModel.erasePathSegments(w.x, w.y, pathEraserRadius);
    }
    return;
  }

  // Ignore world if dragging in UI
  if (isInActivePanel(mouseX, mouseY)) return;

  if (mouseButton == LEFT && currentTool == Tool.EDIT_SITES && isDraggingSite && draggingSite != null) {
    PVector worldPos = viewport.screenToWorld(mouseX, mouseY);
    draggingSite.x = constrain(worldPos.x, mapModel.minX, mapModel.maxX);
    draggingSite.y = constrain(worldPos.y, mapModel.minY, mapModel.maxY);
    siteDirtyDuringDrag = true;
  } else if (mouseButton == LEFT && currentTool == Tool.EDIT_ELEVATION) {
    PVector w = viewport.screenToWorld(mouseX, mouseY);
    float dir = elevationBrushRaise ? 1 : -1;
    mapModel.applyElevationBrush(w.x, w.y, elevationBrushRadius, elevationBrushStrength * dir, seaLevel);
    markRenderDirty();
  }
}

public void mouseReleased() {
  isPanning = false;
  if (mouseButton == LEFT) {
    runPendingButtonAction(mouseX, mouseY);
    isDraggingSite = false;
    draggingSite = null;
    if (siteDirtyDuringDrag) {
      mapModel.markVoronoiDirty();
      markRenderDirty();
      siteDirtyDuringDrag = false;
    }
    activeSlider = SLIDER_NONE;
  }
}

public void updateActiveSlider(int mx, int my) {
  if (my < -99999) return; // retain parameter to avoid unused warning
  switch (activeSlider) {
    case SLIDER_SITES_DENSITY: {
      SitesLayout l = buildSitesLayout();
      float t = sliderNorm(l.densitySlider, mx);
      int newCount = round(t * MAX_SITE_COUNT);
      siteTargetCount = constrain(newCount, 0, MAX_SITE_COUNT);
      break;
    }
    case SLIDER_SITES_FUZZ: {
      SitesLayout l = buildSitesLayout();
      float t = sliderNorm(l.fuzzSlider, mx);
      t = constrain(t, 0, 1);
      siteFuzz = t * 0.3f;
      break;
    }
    case SLIDER_SITES_MODE: {
      SitesLayout l = buildSitesLayout();
      int modeCount = placementModes.length;
      float t = sliderNorm(l.modeSlider, mx);
      t = constrain(t, 0, 1);
      int idx = round(t * max(1, modeCount - 1));
      placementModeIndex = constrain(idx, 0, placementModes.length - 1);
      break;
    }
    case SLIDER_BIOME_HUE: {
      BiomesLayout l = buildBiomesLayout();
      float t = sliderNorm(l.hueSlider, mx);
      t = constrain(t, 0, 1);
      if (mapModel.biomeTypes != null && activeBiomeIndex >= 0 && activeBiomeIndex < mapModel.biomeTypes.size()) {
        ZoneType active = mapModel.biomeTypes.get(activeBiomeIndex);
        active.hue01 = t;
        active.updateColorFromHSB();
      }
      break;
    }
    case SLIDER_BIOME_SAT: {
      BiomesLayout l = buildBiomesLayout();
      float t = sliderNorm(l.satSlider, mx);
      t = constrain(t, 0, 1);
      if (mapModel.biomeTypes != null && activeBiomeIndex >= 0 && activeBiomeIndex < mapModel.biomeTypes.size()) {
        ZoneType active = mapModel.biomeTypes.get(activeBiomeIndex);
        active.sat01 = t;
        active.updateColorFromHSB();
      }
      break;
    }
    case SLIDER_BIOME_BRI: {
      BiomesLayout l = buildBiomesLayout();
      float t = sliderNorm(l.briSlider, mx);
      t = constrain(t, 0, 1);
      if (mapModel.biomeTypes != null && activeBiomeIndex >= 0 && activeBiomeIndex < mapModel.biomeTypes.size()) {
        ZoneType active = mapModel.biomeTypes.get(activeBiomeIndex);
        active.bri01 = t;
        active.updateColorFromHSB();
      }
      break;
    }
    case SLIDER_BIOME_BRUSH: {
      BiomesLayout l = buildBiomesLayout();
      float t = sliderNorm(l.brushSlider, mx);
      t = constrain(t, 0, 1);
      zoneBrushRadius = constrain(0.01f + t * (0.15f - 0.01f), 0.01f, 0.15f);
      break;
    }
    case SLIDER_BIOME_GEN_MODE: {
      BiomesLayout l = buildBiomesLayout();
      int modeCount = biomeGenerateModes.length;
      float t = sliderNorm(l.genModeSelector, mx);
      t = constrain(t, 0, 1);
      int idx = round(t * max(1, modeCount - 1));
      biomeGenerateModeIndex = constrain(idx, 0, modeCount - 1);
      break;
    }
    case SLIDER_BIOME_GEN_VALUE: {
      BiomesLayout l = buildBiomesLayout();
      float t = sliderNorm(l.genValueSlider, mx);
      t = constrain(t, 0, 1);
      biomeGenerateValue01 = t;
      break;
    }
    case SLIDER_BIOME_PATTERN: {
      BiomesLayout l = buildBiomesLayout();
      if (mapModel.biomeTypes != null && activeBiomeIndex >= 0 && activeBiomeIndex < mapModel.biomeTypes.size()) {
        int patCount = max(1, mapModel.biomePatternCount);
        float t = sliderNorm(l.patternSlider, mx);
        int idx = (patCount > 1) ? round(t * (patCount - 1)) : 0;
        idx = constrain(idx, 0, patCount - 1);
        mapModel.biomeTypes.get(activeBiomeIndex).patternIndex = idx;
      }
      break;
    }
    case SLIDER_ELEV_SEA: {
      ElevationLayout l = buildElevationLayout();
      float t = sliderNorm(l.seaSlider, mx);
      t = constrain(t, 0, 1);
      float newSea = lerp(-1.2f, 1.2f, t);
      if (abs(newSea - seaLevel) > 1e-6f) {
        seaLevel = newSea;
        markRenderDirty();
      }
      break;
    }
    case SLIDER_ELEV_RADIUS: {
      ElevationLayout l = buildElevationLayout();
      float t = sliderNorm(l.radiusSlider, mx);
      t = constrain(t, 0, 1);
      elevationBrushRadius = constrain(0.01f + t * (0.2f - 0.01f), 0.01f, 0.2f);
      break;
    }
    case SLIDER_ELEV_STRENGTH: {
      ElevationLayout l = buildElevationLayout();
      float t = sliderNorm(l.strengthSlider, mx);
      t = constrain(t, 0, 1);
      elevationBrushStrength = constrain(0.005f + t * (0.2f - 0.005f), 0.005f, 0.2f);
      break;
    }
    case SLIDER_ELEV_NOISE: {
      ElevationLayout l = buildElevationLayout();
      float t = sliderNorm(l.noiseSlider, mx);
      t = constrain(t, 0, 1);
      elevationNoiseScale = constrain(1.0f + t * (12.0f - 1.0f), 1.0f, 12.0f);
      break;
    }
    case SLIDER_PATH_TYPE_HUE: {
      PathsLayout l = buildPathsLayout();
      float t = sliderNorm(l.typeHueSlider, mx);
      t = constrain(t, 0, 1);
      if (activePathTypeIndex >= 0 && activePathTypeIndex < mapModel.pathTypes.size()) {
        PathType pt = mapModel.pathTypes.get(activePathTypeIndex);
        pt.hue01 = t;
        pt.updateColorFromHSB();
      }
      break;
    }
    case SLIDER_PATH_TYPE_SAT: {
      PathsLayout l = buildPathsLayout();
      float t = sliderNorm(l.typeSatSlider, mx);
      t = constrain(t, 0, 1);
      if (activePathTypeIndex >= 0 && activePathTypeIndex < mapModel.pathTypes.size()) {
        PathType pt = mapModel.pathTypes.get(activePathTypeIndex);
        pt.sat01 = t;
        pt.updateColorFromHSB();
      }
      break;
    }
    case SLIDER_PATH_TYPE_BRI: {
      PathsLayout l = buildPathsLayout();
      float t = sliderNorm(l.typeBriSlider, mx);
      t = constrain(t, 0, 1);
      if (activePathTypeIndex >= 0 && activePathTypeIndex < mapModel.pathTypes.size()) {
        PathType pt = mapModel.pathTypes.get(activePathTypeIndex);
        pt.bri01 = t;
        pt.updateColorFromHSB();
      }
      break;
    }
    case SLIDER_PATH_TYPE_WEIGHT: {
      PathsLayout l = buildPathsLayout();
      float t = sliderNorm(l.typeWeightSlider, mx);
      t = constrain(t, 0, 1);
      if (activePathTypeIndex >= 0 && activePathTypeIndex < mapModel.pathTypes.size()) {
        PathType pt = mapModel.pathTypes.get(activePathTypeIndex);
        pt.weightPx = constrain(0.5f + t * (8.0f - 0.5f), 0.5f, 8.0f);
      }
      break;
    }
    case SLIDER_PATH_TYPE_MIN_WEIGHT: {
      PathsLayout l = buildPathsLayout();
      float t = sliderNorm(l.typeMinWeightSlider, mx);
      t = constrain(t, 0, 1);
      if (activePathTypeIndex >= 0 && activePathTypeIndex < mapModel.pathTypes.size()) {
        PathType pt = mapModel.pathTypes.get(activePathTypeIndex);
        float minW = constrain(0.5f + t * (pt.weightPx - 0.5f), 0.5f, pt.weightPx);
        pt.minWeightPx = minW;
      }
      break;
    }
    case SLIDER_PATH_ROUTE_MODE: {
      PathsLayout l = buildPathsLayout();
      String[] modes = { "Ends", "Pathfind" };
      int modeCount = modes.length;
      float t = sliderNorm(l.routeSlider, mx);
      int idx = round(t * max(1, modeCount - 1));
      pathRouteModeIndex = constrain(idx, 0, modeCount - 1);
      if (activePathTypeIndex >= 0 && activePathTypeIndex < mapModel.pathTypes.size()) {
        PathType pt = mapModel.pathTypes.get(activePathTypeIndex);
        pt.routeMode = PathRouteMode.values()[pathRouteModeIndex];
      }
      break;
    }
    case SLIDER_ZONES_HUE: {
      // Deprecated: zone hue is edited via list panel per-row slider
      break;
    }
    case SLIDER_ZONES_BRUSH: {
      ZonesLayout l = buildZonesLayout();
      float t = sliderNorm(l.brushSlider, mx);
      zoneBrushRadius = constrain(0.01f + t * (0.15f - 0.01f), 0.01f, 0.15f);
      break;
    }
    case SLIDER_ZONES_ROW_HUE: {
      ZonesListLayout l = buildZonesListLayout();
      populateZonesRows(l);
      if (activeZoneIndex >= 0 && activeZoneIndex < l.rows.size()) {
        ZoneRowLayout row = l.rows.get(activeZoneIndex);
        float t = sliderNorm(row.hueSlider, mx);
        MapModel.MapZone az = mapModel.zones.get(activeZoneIndex);
        az.hue01 = t;
        az.updateColorFromHSB();
      }
      break;
    }
    case SLIDER_FLATTEST_BIAS: {
      PathsLayout l = buildPathsLayout();
      float t = sliderNorm(l.flattestSlider, mx);
      t = constrain(t, 0, 1);
      flattestSlopeBias = constrain(FLATTEST_BIAS_MIN + t * (FLATTEST_BIAS_MAX - FLATTEST_BIAS_MIN),
                                    FLATTEST_BIAS_MIN, FLATTEST_BIAS_MAX);
      break;
    }
    case SLIDER_STRUCT_SIZE:
    case SLIDER_STRUCT_SELECTED_SIZE: {
      StructuresLayout l = buildStructuresLayout();
      float t = sliderNorm(l.sizeSlider, mx);
      t = constrain(t, 0, 1);
      float newSize = constrain(0.01f + t * (0.2f - 0.01f), 0.01f, 0.2f);
      structureSize = newSize;
      if (selectedStructureIndices != null && !selectedStructureIndices.isEmpty()) {
        for (int idx : selectedStructureIndices) {
          if (idx < 0 || idx >= mapModel.structures.size()) continue;
          mapModel.structures.get(idx).size = newSize;
        }
      }
      break;
    }
    case SLIDER_STRUCT_ANGLE:
    case SLIDER_STRUCT_SELECTED_ANGLE: {
      StructuresLayout l = buildStructuresLayout();
      float t = sliderNorm(l.angleSlider, mx);
      t = constrain(t, 0, 1);
      float angDeg = -180.0f + t * 360.0f;
      float angRad = radians(angDeg);
      structureAngleOffsetRad = angRad;
      if (selectedStructureIndices != null && !selectedStructureIndices.isEmpty()) {
        for (int idx : selectedStructureIndices) {
          if (idx < 0 || idx >= mapModel.structures.size()) continue;
          mapModel.structures.get(idx).angle = angRad;
        }
      }
      break;
    }
    case SLIDER_STRUCT_RATIO: {
      StructuresLayout l = buildStructuresLayout();
      float t = sliderNorm(l.ratioSlider, mx);
      float newRatio = constrain(0.3f + t * (3.0f - 0.3f), 0.3f, 3.0f);
      structureAspectRatio = newRatio;
      if (selectedStructureIndices != null && !selectedStructureIndices.isEmpty()) {
        for (int idx : selectedStructureIndices) {
          if (idx < 0 || idx >= mapModel.structures.size()) continue;
          mapModel.structures.get(idx).aspect = newRatio;
        }
      }
      break;
    }
    case SLIDER_STRUCT_GEN_TOWN: {
      StructuresLayout l = buildStructuresLayout();
      float t = sliderNorm(l.genTownSlider, mx);
      structGenTownCount = constrain(round(t * 8), 0, 8);
      break;
    }
    case SLIDER_STRUCT_GEN_BUILDING: {
      StructuresLayout l = buildStructuresLayout();
      float t = sliderNorm(l.genBuildingSlider, mx);
      structGenBuildingDensity = constrain(t, 0, 1);
      break;
    }
    case SLIDER_STRUCT_SNAP_DIV: {
      StructuresLayout l = buildStructuresLayout();
      int divMin = 2;
      int divMax = 24;
      float t = sliderNorm(l.snapElevationSlider, mx);
      snapElevationDivisions = round(lerp(divMin, divMax, t));
      break;
    }
    case SLIDER_STRUCT_SHAPE: {
      StructuresLayout l = buildStructuresLayout();
      StructureShape[] shapes = StructureShape.values();
      float t = sliderNorm(l.shapeSelector, mx);
      int idx = round(t * max(0, shapes.length - 1));
      idx = constrain(idx, 0, shapes.length - 1);
      structureShape = shapes[idx];
      if (selectedStructureIndices != null && !selectedStructureIndices.isEmpty()) {
        for (int si : selectedStructureIndices) {
          if (si < 0 || si >= mapModel.structures.size()) continue;
          mapModel.structures.get(si).shape = structureShape;
        }
      }
      break;
    }
    case SLIDER_STRUCT_ALIGNMENT: {
      StructuresLayout l = buildStructuresLayout();
      StructureSnapMode[] snaps = StructureSnapMode.values();
      float t = sliderNorm(l.alignmentSelector, mx);
      int idx = round(t * max(0, snaps.length - 1));
      idx = constrain(idx, 0, snaps.length - 1);
      structureSnapMode = snaps[idx];
      if (selectedStructureIndices != null && !selectedStructureIndices.isEmpty()) {
        for (int si : selectedStructureIndices) {
          if (si < 0 || si >= mapModel.structures.size()) continue;
          mapModel.structures.get(si).alignment = structureSnapMode;
        }
      }
      break;
    }
    case SLIDER_STRUCT_SELECTED_HUE: {
      StructuresLayout l = buildStructuresLayout();
      float t = sliderNorm(l.hueSlider, mx);
      structureHue01 = t;
      if (selectedStructureIndices != null && !selectedStructureIndices.isEmpty()) {
        for (int idx : selectedStructureIndices) {
          if (idx < 0 || idx >= mapModel.structures.size()) continue;
          mapModel.structures.get(idx).setHue(t);
        }
      }
      break;
    }
    case SLIDER_STRUCT_SELECTED_ALPHA: {
      StructuresLayout l = buildStructuresLayout();
      float t = sliderNorm(l.alphaSlider, mx);
      structureAlpha01 = t;
      if (selectedStructureIndices != null && !selectedStructureIndices.isEmpty()) {
        for (int idx : selectedStructureIndices) {
          if (idx < 0 || idx >= mapModel.structures.size()) continue;
          mapModel.structures.get(idx).setAlpha(t);
        }
      }
      break;
    }
    case SLIDER_STRUCT_SELECTED_SAT: {
      StructuresLayout l = buildStructuresLayout();
      float t = sliderNorm(l.satSlider, mx);
      structureSat01 = t;
      if (selectedStructureIndices != null && !selectedStructureIndices.isEmpty()) {
        for (int idx : selectedStructureIndices) {
          if (idx < 0 || idx >= mapModel.structures.size()) continue;
          mapModel.structures.get(idx).setSaturation(t);
        }
      }
      break;
    }
    case SLIDER_STRUCT_SELECTED_STROKE: {
      StructuresLayout l = buildStructuresLayout();
      float t = sliderNorm(l.strokeSlider, mx);
      float w = constrain(0.5f + t * (4.0f - 0.5f), 0.5f, 4.0f);
      structureStrokePx = w;
      if (selectedStructureIndices != null && !selectedStructureIndices.isEmpty()) {
        for (int idx : selectedStructureIndices) {
          if (idx < 0 || idx >= mapModel.structures.size()) continue;
          mapModel.structures.get(idx).strokeWeightPx = w;
        }
      }
      break;
    }
    case SLIDER_RENDER_LAND_H: {
      RenderLayout l = buildRenderLayout();
      renderSettings.landHue01 = sliderNorm(l.landHSB[0], mx);
      break;
    }
    case SLIDER_RENDER_LAND_S: {
      RenderLayout l = buildRenderLayout();
      renderSettings.landSat01 = sliderNorm(l.landHSB[1], mx);
      break;
    }
    case SLIDER_RENDER_LAND_B: {
      RenderLayout l = buildRenderLayout();
      renderSettings.landBri01 = sliderNorm(l.landHSB[2], mx);
      break;
    }
    case SLIDER_RENDER_WATER_H: {
      RenderLayout l = buildRenderLayout();
      renderSettings.waterHue01 = sliderNorm(l.waterHSB[0], mx);
      break;
    }
    case SLIDER_RENDER_WATER_S: {
      RenderLayout l = buildRenderLayout();
      renderSettings.waterSat01 = sliderNorm(l.waterHSB[1], mx);
      break;
    }
    case SLIDER_RENDER_WATER_B: {
      RenderLayout l = buildRenderLayout();
      renderSettings.waterBri01 = sliderNorm(l.waterHSB[2], mx);
      break;
    }
    case SLIDER_RENDER_CELL_BORDER_ALPHA: {
      RenderLayout l = buildRenderLayout();
      float t = sliderNorm(l.cellBordersAlphaSlider, mx);
      renderSettings.cellBorderAlpha01 = t;
      break;
    }
    case SLIDER_RENDER_BIOME_FILL_ALPHA: {
      RenderLayout l = buildRenderLayout();
      float t = sliderNorm(l.biomeFillAlphaSlider, mx);
      renderSettings.biomeFillAlpha01 = t;
      break;
    }
    case SLIDER_RENDER_BIOME_SAT: {
      RenderLayout l = buildRenderLayout();
      float t = sliderNorm(l.biomeSatSlider, mx);
      renderSettings.biomeSatScale01 = t;
      break;
    }
    case SLIDER_RENDER_BIOME_BRI: {
      RenderLayout l = buildRenderLayout();
      float t = sliderNorm(l.biomeBriSlider, mx);
      renderSettings.biomeBriScale01 = t;
      break;
    }
    case SLIDER_RENDER_BIOME_OUTLINE_SIZE: {
      RenderLayout l = buildRenderLayout();
      float t = sliderNorm(l.biomeOutlineSizeSlider, mx);
      renderSettings.biomeOutlineSizePx = constrain(t * 5.0f, 0, 5.0f);
      break;
    }
    case SLIDER_RENDER_BIOME_OUTLINE_ALPHA: {
      RenderLayout l = buildRenderLayout();
      float t = sliderNorm(l.biomeOutlineAlphaSlider, mx);
      renderSettings.biomeOutlineAlpha01 = t;
      break;
    }
    case SLIDER_RENDER_BIOME_UNDERWATER_ALPHA: {
      RenderLayout l = buildRenderLayout();
      float t = sliderNorm(l.biomeUnderwaterAlphaSlider, mx);
      renderSettings.biomeUnderwaterAlpha01 = t;
      break;
    }
    case SLIDER_RENDER_WATER_DEPTH_ALPHA: {
      RenderLayout l = buildRenderLayout();
      float t = sliderNorm(l.waterDepthAlphaSlider, mx);
      renderSettings.waterDepthAlpha01 = t;
      break;
    }
    case SLIDER_RENDER_LIGHT_ALPHA: {
      RenderLayout l = buildRenderLayout();
      float t = sliderNorm(l.lightAlphaSlider, mx);
      renderSettings.elevationLightAlpha01 = t;
      if (mapModel != null && mapModel.renderer != null) mapModel.renderer.invalidateLightCache();
      markRenderVisualChange();
      break;
    }
    case SLIDER_RENDER_LIGHT_AZIMUTH: {
      RenderLayout l = buildRenderLayout();
      float t = sliderNorm(l.lightAzimuthSlider, mx);
      renderSettings.elevationLightAzimuthDeg = constrain(t * 360.0f, 0, 360);
      if (mapModel != null && mapModel.renderer != null) mapModel.renderer.invalidateLightCache();
      markRenderVisualChange();
      break;
    }
    case SLIDER_RENDER_LIGHT_ALTITUDE: {
      RenderLayout l = buildRenderLayout();
      float t = sliderNorm(l.lightAltitudeSlider, mx);
      renderSettings.elevationLightAltitudeDeg = constrain(5.0f + t * (80.0f - 5.0f), 5.0f, 80.0f);
      if (mapModel != null && mapModel.renderer != null) mapModel.renderer.invalidateLightCache();
      markRenderVisualChange();
      break;
    }
    case SLIDER_RENDER_WATER_CONTOUR_SIZE: {
      RenderLayout l = buildRenderLayout();
      float t = sliderNorm(l.waterContourSizeSlider, mx);
      renderSettings.waterContourSizePx = constrain(t * 5.0f, 0, 5.0f);
      if (mapModel != null && mapModel.renderer != null) mapModel.renderer.invalidateCoastCache();
      markRenderVisualChange();
      break;
    }
    case SLIDER_RENDER_WATER_COAST_SIZE: {
      RenderLayout l = buildRenderLayout();
      float t = sliderNorm(l.waterCoastSizeSlider, mx);
      renderSettings.waterCoastSizePx = constrain(t * 5.0f, 0, 5.0f);
      if (mapModel != null && mapModel.renderer != null) mapModel.renderer.invalidateCoastCache();
      markRenderVisualChange();
      break;
    }
    case SLIDER_RENDER_WATER_RIPPLE_COUNT: {
      RenderLayout l = buildRenderLayout();
      float t = sliderNorm(l.waterRippleCountSlider, mx);
      renderSettings.waterRippleCount = constrain(round(t * 5.0f), 0, 5);
      if (mapModel != null && mapModel.renderer != null) mapModel.renderer.invalidateCoastCache();
      markRenderVisualChange();
      break;
    }
    case SLIDER_RENDER_WATER_RIPPLE_DIST: {
      RenderLayout l = buildRenderLayout();
      float t = sliderNorm(l.waterRippleDistanceSlider, mx);
      renderSettings.waterRippleDistancePx = constrain(t * 40.0f, 0.0f, 40.0f);
      if (mapModel != null && mapModel.renderer != null) mapModel.renderer.invalidateCoastCache();
      markRenderVisualChange();
      break;
    }
    case SLIDER_RENDER_WATER_CONTOUR_H: {
      RenderLayout l = buildRenderLayout();
      renderSettings.waterContourHue01 = sliderNorm(l.waterContourHSB[0], mx);
      if (mapModel != null && mapModel.renderer != null) mapModel.renderer.invalidateCoastCache();
      markRenderVisualChange();
      break;
    }
    case SLIDER_RENDER_WATER_CONTOUR_S: {
      RenderLayout l = buildRenderLayout();
      renderSettings.waterContourSat01 = sliderNorm(l.waterContourHSB[1], mx);
      if (mapModel != null && mapModel.renderer != null) mapModel.renderer.invalidateCoastCache();
      markRenderVisualChange();
      break;
    }
    case SLIDER_RENDER_WATER_CONTOUR_B: {
      RenderLayout l = buildRenderLayout();
      renderSettings.waterContourBri01 = sliderNorm(l.waterContourHSB[2], mx);
      if (mapModel != null && mapModel.renderer != null) mapModel.renderer.invalidateCoastCache();
      markRenderVisualChange();
      break;
    }
    case SLIDER_RENDER_WATER_CONTOUR_ALPHA: {
      RenderLayout l = buildRenderLayout();
      float t = sliderNorm(l.waterContourCoastAlphaSlider, mx);
      renderSettings.waterCoastAlpha01 = t;
      syncLegacyWaterContourAlpha(renderSettings);
      if (mapModel != null && mapModel.renderer != null) mapModel.renderer.invalidateCoastCache();
      markRenderVisualChange();
      break;
    }
    case SLIDER_RENDER_WATER_HATCH_ANGLE: {
      RenderLayout l = buildRenderLayout();
      float t = sliderNorm(l.waterHatchAngleSlider, mx);
      renderSettings.waterHatchAngleDeg = constrain(-90.0f + t * 180.0f, -90.0f, 90.0f);
      if (mapModel != null && mapModel.renderer != null) mapModel.renderer.invalidateCoastCache();
      markRenderVisualChange();
      break;
    }
    case SLIDER_RENDER_WATER_HATCH_LENGTH: {
      RenderLayout l = buildRenderLayout();
      float t = sliderNorm(l.waterHatchLengthSlider, mx);
      renderSettings.waterHatchLengthPx = constrain(t * 400.0f, 0, 400.0f);
      if (mapModel != null && mapModel.renderer != null) mapModel.renderer.invalidateCoastCache();
      markRenderVisualChange();
      break;
    }
    case SLIDER_RENDER_WATER_HATCH_SPACING: {
      RenderLayout l = buildRenderLayout();
      float t = sliderNorm(l.waterHatchSpacingSlider, mx);
      renderSettings.waterHatchSpacingPx = constrain(t * 120.0f, 0, 120.0f);
      if (mapModel != null && mapModel.renderer != null) mapModel.renderer.invalidateCoastCache();
      markRenderVisualChange();
      break;
    }
    case SLIDER_RENDER_WATER_HATCH_ALPHA: {
      RenderLayout l = buildRenderLayout();
      float t = sliderNorm(l.waterHatchAlphaSlider, mx);
      renderSettings.waterHatchAlpha01 = t;
      if (mapModel != null && mapModel.renderer != null) mapModel.renderer.invalidateCoastCache();
      markRenderVisualChange();
      break;
    }
    case SLIDER_RENDER_WATER_RIPPLE_ALPHA_START: {
      RenderLayout l = buildRenderLayout();
      float t = sliderNorm(l.waterRippleAlphaStartSlider, mx);
      renderSettings.waterRippleAlphaStart01 = t;
      if (mapModel != null && mapModel.renderer != null) mapModel.renderer.invalidateCoastCache();
      markRenderVisualChange();
      break;
    }
    case SLIDER_RENDER_WATER_RIPPLE_ALPHA_END: {
      RenderLayout l = buildRenderLayout();
      float t = sliderNorm(l.waterRippleAlphaEndSlider, mx);
      renderSettings.waterRippleAlphaEnd01 = t;
      if (mapModel != null && mapModel.renderer != null) mapModel.renderer.invalidateCoastCache();
      markRenderVisualChange();
      break;
    }
    case SLIDER_RENDER_CELL_BORDER_SIZE: {
      RenderLayout l = buildRenderLayout();
      float t = sliderNorm(l.cellBordersSizeSlider, mx);
      renderSettings.cellBorderSizePx = constrain(t * 5.0f, 0, 5.0f);
      markRenderVisualChange();
      break;
    }
    case SLIDER_RENDER_ELEV_LINES_COUNT: {
      RenderLayout l = buildRenderLayout();
      float t = sliderNorm(l.elevationLinesCountSlider, mx);
      renderSettings.elevationLinesCount = constrain(round(t * 24.0f), 0, 24);
      markRenderVisualChange();
      break;
    }
    case SLIDER_RENDER_ELEV_LINES_ALPHA: {
      RenderLayout l = buildRenderLayout();
      float t = sliderNorm(l.elevationLinesAlphaSlider, mx);
      renderSettings.elevationLinesAlpha01 = t;
      markRenderVisualChange();
      break;
    }
    case SLIDER_RENDER_ELEV_LINES_SIZE: {
      RenderLayout l = buildRenderLayout();
      float t = sliderNorm(l.elevationLinesSizeSlider, mx);
      renderSettings.elevationLinesSizePx = constrain(t * 5.0f, 0, 5.0f);
      markRenderVisualChange();
      break;
    }
    case SLIDER_RENDER_PATH_SAT: {
      RenderLayout l = buildRenderLayout();
      float t = sliderNorm(l.pathSatSlider, mx);
      renderSettings.pathSatScale01 = t;
      break;
    }
    case SLIDER_RENDER_PATH_BRI: {
      RenderLayout l = buildRenderLayout();
      float t = sliderNorm(l.pathBriSlider, mx);
      renderSettings.pathBriScale01 = t;
      break;
    }
    case SLIDER_RENDER_ZONE_ALPHA: {
      RenderLayout l = buildRenderLayout();
      float t = sliderNorm(l.zoneAlphaSlider, mx);
      renderSettings.zoneStrokeAlpha01 = t;
      if (mapModel != null && mapModel.renderer != null) mapModel.renderer.invalidateZoneCache();
      markRenderVisualChange();
      break;
    }
    case SLIDER_RENDER_ZONE_SIZE: {
      RenderLayout l = buildRenderLayout();
      float t = sliderNorm(l.zoneSizeSlider, mx);
      renderSettings.zoneStrokeSizePx = constrain(t * 5.0f, 0, 5.0f);
      if (mapModel != null && mapModel.renderer != null) mapModel.renderer.invalidateZoneCache();
      markRenderVisualChange();
      break;
    }
    case SLIDER_RENDER_ZONE_SAT: {
      RenderLayout l = buildRenderLayout();
      float t = sliderNorm(l.zoneSatSlider, mx);
      renderSettings.zoneStrokeSatScale01 = t;
      if (mapModel != null && mapModel.renderer != null) mapModel.renderer.invalidateZoneCache();
      markRenderVisualChange();
      break;
    }
    case SLIDER_RENDER_ZONE_BRI: {
      RenderLayout l = buildRenderLayout();
      float t = sliderNorm(l.zoneBriSlider, mx);
      renderSettings.zoneStrokeBriScale01 = t;
      if (mapModel != null && mapModel.renderer != null) mapModel.renderer.invalidateZoneCache();
      markRenderVisualChange();
      break;
    }
    case SLIDER_RENDER_LIGHT_DITHER: {
      RenderLayout l = buildRenderLayout();
      float t = sliderNorm(l.lightDitherSlider, mx);
      renderSettings.elevationLightDitherPx = constrain(t * 10.0f, 0, 10.0f);
      if (mapModel != null && mapModel.renderer != null) mapModel.renderer.invalidateLightCache();
      markRenderVisualChange();
      break;
    }
    case SLIDER_RENDER_LABEL_OUTLINE_ALPHA: {
      RenderLayout l = buildRenderLayout();
      float t = sliderNorm(l.labelsOutlineAlphaSlider, mx);
      renderSettings.labelOutlineAlpha01 = t;
      break;
    }
    case SLIDER_RENDER_LABEL_OUTLINE_SIZE: {
      RenderLayout l = buildRenderLayout();
      float t = sliderNorm(l.labelsOutlineSizeSlider, mx);
      renderSettings.labelOutlineSizePx = round(constrain(t * 16.0f, 0, 16.0f));
      break;
    }
    case SLIDER_RENDER_LABEL_SIZE_ARBITRARY: {
      RenderLayout l = buildRenderLayout();
      float t = sliderNorm(l.labelsArbSizeSlider, mx);
      renderSettings.labelSizeArbPx = round(constrain(8 + t * (40 - 8), 4, 80));
      break;
    }
    case SLIDER_RENDER_LABEL_SIZE_ZONES: {
      RenderLayout l = buildRenderLayout();
      float t = sliderNorm(l.labelsZoneSizeSlider, mx);
      renderSettings.labelSizeZonePx = round(constrain(8 + t * (40 - 8), 4, 80));
      break;
    }
    case SLIDER_RENDER_LABEL_SIZE_PATHS: {
      RenderLayout l = buildRenderLayout();
      float t = sliderNorm(l.labelsPathSizeSlider, mx);
      renderSettings.labelSizePathPx = round(constrain(8 + t * (40 - 8), 4, 80));
      break;
    }
    case SLIDER_RENDER_LABEL_SIZE_STRUCTS: {
      RenderLayout l = buildRenderLayout();
      float t = sliderNorm(l.labelsStructSizeSlider, mx);
      renderSettings.labelSizeStructPx = round(constrain(8 + t * (40 - 8), 4, 80));
      break;
    }
    case SLIDER_RENDER_LABEL_FONT: {
      RenderLayout l = buildRenderLayout();
      int options = (LABEL_FONT_OPTIONS != null) ? LABEL_FONT_OPTIONS.length : 0;
      if (options < 1) break;
      float t = sliderNorm(l.labelsFontSelector, mx);
      int idx = constrain(round(t * max(1, options - 1)), 0, options - 1);
      renderSettings.labelFontIndex = idx;
      break;
    }
    case SLIDER_RENDER_BACKGROUND_NOISE: {
      RenderLayout l = buildRenderLayout();
      float t = sliderNorm(l.backgroundNoiseSlider, mx);
      renderSettings.backgroundNoiseAlpha01 = t;
      break;
    }
    case SLIDER_RENDER_STRUCT_SHADOW_ALPHA: {
      RenderLayout l = buildRenderLayout();
      float t = sliderNorm(l.structuresShadowAlphaSlider, mx);
      renderSettings.structureShadowAlpha01 = t;
      break;
    }
    case SLIDER_RENDER_PADDING: {
      RenderLayout l = buildRenderLayout();
      float t = sliderNorm(l.exportPaddingSlider, mx);
      t = constrain(t, 0, 1);
      renderSettings.exportPaddingPct = constrain(t * 0.10f, 0, 0.10f);
      renderPaddingPct = renderSettings.exportPaddingPct;
      break;
    }
    case SLIDER_RENDER_PRESET_SELECT: {
      RenderLayout l = buildRenderLayout();
      if (renderPresets != null && renderPresets.length > 0) {
        int n = max(1, renderPresets.length - 1);
        float t = sliderNorm(l.presetSelector, mx);
        int idx = constrain(round(t * n), 0, renderPresets.length - 1);
        renderSettings.activePresetIndex = idx;
      }
      break;
    }
    default:
      break;
  }
}

public boolean scrollListIfHovered(float wheelCount) {
  int deltaPx = round(wheelCount * SCROLL_STEP_PX);
  if (deltaPx == 0) return false;

  if (currentTool == Tool.EDIT_ZONES && isInZonesListPanel(mouseX, mouseY)) {
    ZonesListLayout l = buildZonesListLayout();
    int startY = l.newBtn.y + l.newBtn.h + PANEL_SECTION_GAP;
    int viewH = max(0, (l.panel.y + l.panel.h - PANEL_SECTION_GAP) - startY);
    int rowH = 28;
    int rowGap = 6;
    int total = (mapModel != null && mapModel.zones != null) ? mapModel.zones.size() : 0;
    int contentH = (total > 0) ? total * (rowH + rowGap) - rowGap : 0;
    if (contentH > viewH && viewH > 0) {
      zonesListScroll = clampScroll(zonesListScroll + deltaPx, contentH, viewH);
      return true;
    }
  }

  if (currentTool == Tool.EDIT_PATHS && isInPathsListPanel(mouseX, mouseY)) {
    PathsListLayout l = buildPathsListLayout();
    int startY = l.newBtn.y + l.newBtn.h + PANEL_SECTION_GAP;
    int viewH = max(0, (l.panel.y + l.panel.h - PANEL_SECTION_GAP) - startY);
    int textH = ceil(textAscent() + textDescent());
    int nameH = max(PANEL_LABEL_H + 6, textH + 8);
    int typeH = max(PANEL_LABEL_H + 2, textH + 6);
    int statsH = max(PANEL_LABEL_H, textH);
    int rowGap = 10;
    int rowTotal = nameH + 6 + typeH + 4 + statsH + rowGap;
    int total = (mapModel != null && mapModel.paths != null) ? mapModel.paths.size() : 0;
    int contentH = (total > 0) ? total * rowTotal : 0;
    if (contentH > viewH && viewH > 0) {
      pathsListScroll = clampScroll(pathsListScroll + deltaPx, contentH, viewH);
      return true;
    }
  }

  if (currentTool == Tool.EDIT_STRUCTURES && isInStructuresListPanel(mouseX, mouseY)) {
    StructuresListLayout l = buildStructuresListLayout();
    int startY = layoutStructureDetails(l);
    int viewH = max(0, (l.panel.y + l.panel.h - PANEL_SECTION_GAP) - startY);
    int rowH = 24;
    int rowGap = 6;
    int total = (mapModel != null && mapModel.structures != null) ? mapModel.structures.size() : 0;
    int contentH = (total > 0) ? total * (rowH + rowGap) - rowGap : 0;
    if (contentH > viewH && viewH > 0) {
      structuresListScroll = clampScroll(structuresListScroll + deltaPx, contentH, viewH);
      return true;
    }
  }

  if (currentTool == Tool.EDIT_LABELS && isInLabelsListPanel(mouseX, mouseY)) {
    LabelsListLayout l = buildLabelsListLayout();
    int startY = l.deselectBtn.y + l.deselectBtn.h + PANEL_SECTION_GAP + 6;
    int viewH = max(0, (l.panel.y + l.panel.h - PANEL_SECTION_GAP) - startY);
    int rowH = 24;
    int rowGap = 6;
    int total = (mapModel != null && mapModel.labels != null) ? mapModel.labels.size() : 0;
    int contentH = (total > 0) ? total * (rowH + rowGap) - rowGap : 0;
    if (contentH > viewH && viewH > 0) {
      labelsListScroll = clampScroll(labelsListScroll + deltaPx, contentH, viewH);
      return true;
    }
  }

  return false;
}

public void mouseWheel(MouseEvent event) {
  float count = event.getCount();
  if (scrollListIfHovered(count)) return;
  float factor = pow(1.1f, -count);
  viewport.zoomAt(factor, mouseX, mouseY);
}

public void keyPressed() {
  // Inline text editing for zones
  if (editingBiomeNameIndex >= 0) {
    if (key == ENTER || key == RETURN) {
      if (editingBiomeNameIndex < mapModel.biomeTypes.size()) {
        mapModel.biomeTypes.get(editingBiomeNameIndex).name = biomeNameDraft;
      }
      editingBiomeNameIndex = -1;
      return;
    } else if (key == BACKSPACE || key == DELETE) {
      if (biomeNameDraft.length() > 0) biomeNameDraft = biomeNameDraft.substring(0, biomeNameDraft.length() - 1);
      return;
    } else if (key >= 32) {
      biomeNameDraft += key;
      return;
    }
  }

  // Inline text editing for zones
  if (editingZoneNameIndex >= 0) {
    if (key == ENTER || key == RETURN) {
      if (editingZoneNameIndex < mapModel.zones.size()) {
        mapModel.zones.get(editingZoneNameIndex).name = zoneNameDraft;
      }
      editingZoneNameIndex = -1;
      return;
    } else if (key == BACKSPACE || key == DELETE) {
      if (zoneNameDraft.length() > 0) zoneNameDraft = zoneNameDraft.substring(0, zoneNameDraft.length() - 1);
      return;
    } else if (key >= 32) {
      zoneNameDraft += key;
      return;
    }
  }

  // Inline text editing for zone comment (single-line)
  if (editingZoneComment) {
    if (key == ENTER || key == RETURN) {
      if (activeZoneIndex >= 0 && activeZoneIndex < mapModel.zones.size()) {
        mapModel.zones.get(activeZoneIndex).comment = zoneCommentDraft;
      }
      editingZoneComment = false;
      return;
    } else if (key == BACKSPACE || key == DELETE) {
      if (zoneCommentDraft.length() > 0) zoneCommentDraft = zoneCommentDraft.substring(0, zoneCommentDraft.length() - 1);
      if (activeZoneIndex >= 0 && activeZoneIndex < mapModel.zones.size()) {
        mapModel.zones.get(activeZoneIndex).comment = zoneCommentDraft;
      }
      return;
    } else if (key >= 32) {
      zoneCommentDraft += key;
      if (activeZoneIndex >= 0 && activeZoneIndex < mapModel.zones.size()) {
        mapModel.zones.get(activeZoneIndex).comment = zoneCommentDraft;
      }
      return;
    }
  }

  // Inline text editing for labels
  if (editingLabelIndex >= 0) {
    if (key == ENTER || key == RETURN) {
      if (editingLabelIndex < mapModel.labels.size()) {
        mapModel.labels.get(editingLabelIndex).text = labelDraft;
      }
      editingLabelIndex = -1;
      return;
    } else if (key == BACKSPACE || key == DELETE) {
      if (labelDraft.length() > 0) labelDraft = labelDraft.substring(0, labelDraft.length() - 1);
      if (editingLabelIndex < mapModel.labels.size()) mapModel.labels.get(editingLabelIndex).text = labelDraft;
      return;
    } else if (key >= 32) {
      labelDraft += key;
      if (editingLabelIndex < mapModel.labels.size()) mapModel.labels.get(editingLabelIndex).text = labelDraft;
      return;
    }
  }

  // Inline text editing for label comment (single-line)
  if (editingLabelCommentIndex >= 0) {
    if (key == ENTER || key == RETURN) {
      if (editingLabelCommentIndex < mapModel.labels.size()) {
        mapModel.labels.get(editingLabelCommentIndex).comment = labelCommentDraft;
      }
      editingLabelCommentIndex = -1;
      return;
    } else if (key == BACKSPACE || key == DELETE) {
      if (labelCommentDraft.length() > 0) labelCommentDraft = labelCommentDraft.substring(0, labelCommentDraft.length() - 1);
      if (editingLabelCommentIndex < mapModel.labels.size() && editingLabelCommentIndex >= 0) {
        mapModel.labels.get(editingLabelCommentIndex).comment = labelCommentDraft;
      }
      return;
    } else if (key >= 32) {
      labelCommentDraft += key;
      if (editingLabelCommentIndex < mapModel.labels.size() && editingLabelCommentIndex >= 0) {
        mapModel.labels.get(editingLabelCommentIndex).comment = labelCommentDraft;
      }
      return;
    }
  }

  // Inline text editing for structures (name)
  if (editingStructureName) {
    if (key == ENTER || key == RETURN) {
      if (selectedStructureIndices != null && !selectedStructureIndices.isEmpty()) {
        for (int idx : selectedStructureIndices) {
          if (idx < 0 || idx >= mapModel.structures.size()) continue;
          mapModel.structures.get(idx).name = structureNameDraft;
        }
      }
      editingStructureName = false;
      editingStructureNameIndex = -1;
      return;
    } else if (key == BACKSPACE || key == DELETE) {
      if (structureNameDraft.length() > 0) structureNameDraft = structureNameDraft.substring(0, structureNameDraft.length() - 1);
      if (selectedStructureIndices != null && !selectedStructureIndices.isEmpty()) {
        for (int idx : selectedStructureIndices) {
          if (idx < 0 || idx >= mapModel.structures.size()) continue;
          mapModel.structures.get(idx).name = structureNameDraft;
        }
      }
      return;
    } else if (key >= 32) {
      structureNameDraft += key;
      if (selectedStructureIndices != null && !selectedStructureIndices.isEmpty()) {
        for (int idx : selectedStructureIndices) {
          if (idx < 0 || idx >= mapModel.structures.size()) continue;
          mapModel.structures.get(idx).name = structureNameDraft;
        }
      }
      return;
    }
  }

  // Inline text editing for structures (comment, single-line)
  if (editingStructureComment) {
    if (key == ENTER || key == RETURN) {
      if (selectedStructureIndices != null && !selectedStructureIndices.isEmpty()) {
        for (int idx : selectedStructureIndices) {
          if (idx < 0 || idx >= mapModel.structures.size()) continue;
          mapModel.structures.get(idx).comment = structureCommentDraft;
        }
      }
      editingStructureComment = false;
      return;
    } else if (key == BACKSPACE || key == DELETE) {
      if (structureCommentDraft.length() > 0) structureCommentDraft = structureCommentDraft.substring(0, structureCommentDraft.length() - 1);
      if (selectedStructureIndices != null && !selectedStructureIndices.isEmpty()) {
        for (int idx : selectedStructureIndices) {
          if (idx < 0 || idx >= mapModel.structures.size()) continue;
          mapModel.structures.get(idx).comment = structureCommentDraft;
        }
      }
      return;
    } else if (key >= 32) {
      structureCommentDraft += key;
      if (selectedStructureIndices != null && !selectedStructureIndices.isEmpty()) {
        for (int idx : selectedStructureIndices) {
          if (idx < 0 || idx >= mapModel.structures.size()) continue;
          mapModel.structures.get(idx).comment = structureCommentDraft;
        }
      }
      return;
    }
  }

  // Inline text editing for structures (type)
  // Structures: sliders dragging
  if (mouseButton == LEFT && currentTool == Tool.EDIT_STRUCTURES && isInStructuresPanel(mouseX, mouseY)) {
    StructuresLayout layout = buildStructuresLayout();
    if (layout.sizeSlider.contains(mouseX, mouseY)) {
      float t = sliderNorm(layout.sizeSlider, mouseX);
      structureSize = constrain(0.01f + t * (0.2f - 0.01f), 0.01f, 0.2f);
      return;
    }
  }

  // Inline text editing for path types
  if (editingPathTypeNameIndex >= 0) {
    if (key == ENTER || key == RETURN) {
      if (editingPathTypeNameIndex < mapModel.pathTypes.size()) {
        mapModel.pathTypes.get(editingPathTypeNameIndex).name = pathTypeNameDraft;
      }
      editingPathTypeNameIndex = -1;
      return;
    } else if (key == BACKSPACE || key == DELETE) {
      if (pathTypeNameDraft.length() > 0) pathTypeNameDraft = pathTypeNameDraft.substring(0, pathTypeNameDraft.length() - 1);
      return;
    } else if (key >= 32) {
      pathTypeNameDraft += key;
      return;
    }
  }

  // Inline text editing for path names
  if (editingPathNameIndex >= 0) {
    if (key == ENTER || key == RETURN) {
      if (editingPathNameIndex < mapModel.paths.size()) {
        mapModel.paths.get(editingPathNameIndex).name = pathNameDraft;
      }
      editingPathNameIndex = -1;
      return;
    } else if (key == BACKSPACE || key == DELETE) {
      if (pathNameDraft.length() > 0) pathNameDraft = pathNameDraft.substring(0, pathNameDraft.length() - 1);
      return;
    } else if (key >= 32) {
      pathNameDraft += key;
      return;
    }
  }
  // Inline text editing for path comment (single-line)
  if (editingPathCommentIndex >= 0) {
    if (key == ENTER || key == RETURN) {
      if (editingPathCommentIndex < mapModel.paths.size()) {
        mapModel.paths.get(editingPathCommentIndex).comment = pathCommentDraft;
      }
      editingPathCommentIndex = -1;
      return;
    } else if (key == BACKSPACE || key == DELETE) {
      if (pathCommentDraft.length() > 0) pathCommentDraft = pathCommentDraft.substring(0, pathCommentDraft.length() - 1);
      if (editingPathCommentIndex < mapModel.paths.size() && editingPathCommentIndex >= 0) {
        mapModel.paths.get(editingPathCommentIndex).comment = pathCommentDraft;
      }
      return;
    } else if (key >= 32) {
      pathCommentDraft += key;
      if (editingPathCommentIndex < mapModel.paths.size() && editingPathCommentIndex >= 0) {
        mapModel.paths.get(editingPathCommentIndex).comment = pathCommentDraft;
      }
      return;
    }
  }
  // Delete selected sites or last path point
  if (key == DELETE || key == BACKSPACE) {
    if (currentTool == Tool.EDIT_SITES) {
      mapModel.deleteSelectedSites();
      return;
    }
    if (currentTool == Tool.EDIT_PATHS && pendingPathStart != null) {
      pendingPathStart = null;
      return;
    }
  }

  // Clear all paths with 'c' or 'C' in Paths mode
  if (currentTool == Tool.EDIT_PATHS &&
      (key == 'c' || key == 'C')) {
    mapModel.clearAllPaths();
    selectedPathIndex = -1;
    pendingPathStart = null;
    return;
  }
}
// ---------- Input helpers ----------

public boolean isInSitesPanel(int mx, int my) {
  if (currentTool != Tool.EDIT_SITES) return false;
  SitesLayout layout = buildSitesLayout();
  return layout.panel.contains(mx, my);
}

public boolean isInBiomesPanel(int mx, int my) {
  if (currentTool != Tool.EDIT_BIOMES) return false;
  BiomesLayout layout = buildBiomesLayout();
  return layout.panel.contains(mx, my);
}

public boolean isInZonesPanel(int mx, int my) {
  if (currentTool != Tool.EDIT_ZONES) return false;
  ZonesLayout layout = buildZonesLayout();
  return layout.panel.contains(mx, my);
}

public boolean isInZonesListPanel(int mx, int my) {
  if (currentTool != Tool.EDIT_ZONES) return false;
  ZonesListLayout layout = buildZonesListLayout();
  return layout.panel.contains(mx, my);
}

public boolean isInElevationPanel(int mx, int my) {
  if (currentTool != Tool.EDIT_ELEVATION) return false;
  ElevationLayout layout = buildElevationLayout();
  return layout.panel.contains(mx, my);
}

public boolean isInPathsPanel(int mx, int my) {
  if (currentTool != Tool.EDIT_PATHS) return false;
  PathsLayout layout = buildPathsLayout();
  return layout.panel.contains(mx, my);
}

public boolean isInPathsListPanel(int mx, int my) {
  if (currentTool != Tool.EDIT_PATHS) return false;
  PathsListLayout layout = buildPathsListLayout();
  return layout.panel.contains(mx, my);
}

public boolean isInStructuresPanel(int mx, int my) {
  if (currentTool != Tool.EDIT_STRUCTURES) return false;
  StructuresLayout layout = buildStructuresLayout();
  return layout.panel.contains(mx, my);
}

public boolean isInStructuresListPanel(int mx, int my) {
  if (currentTool != Tool.EDIT_STRUCTURES) return false;
  StructuresListLayout layout = buildStructuresListLayout();
  return layout.panel.contains(mx, my);
}

public boolean isInLabelsPanel(int mx, int my) {
  if (currentTool != Tool.EDIT_LABELS) return false;
  LabelsLayout layout = buildLabelsLayout();
  return layout.panel.contains(mx, my);
}

public boolean isInLabelsListPanel(int mx, int my) {
  if (currentTool != Tool.EDIT_LABELS) return false;
  LabelsListLayout layout = buildLabelsListLayout();
  return layout.panel.contains(mx, my);
}

public boolean isInRenderPanel(int mx, int my) {
  if (currentTool != Tool.EDIT_RENDER) return false;
  RenderLayout layout = buildRenderLayout();
  return layout.panel.contains(mx, my);
}

public boolean isInExportPanel(int mx, int my) {
  if (currentTool != Tool.EDIT_EXPORT) return false;
  ExportLayout layout = buildExportLayout();
  return layout.panel.contains(mx, my);
}

public boolean isInActivePanel(int mx, int my) {
  IntRect panel = getActivePanelRect();
  return (panel != null && panel.contains(mx, my));
}

public boolean handleToolButtonClick(int my) {
  int barY = TOP_BAR_TOTAL;
  int barH = TOOL_BAR_HEIGHT;

  if (mapModel.isVoronoiBuilding()) {
    showNotice("Please wait for generation to finish...");
    return true;
  }

  if (my < barY || my > barY + barH) {
    return false;
  }

  int margin = 10;
  int buttonW = 90;

  String[] labels = { "Cells", "Elevation", "Biomes", "Zones", "Paths", "Structures", "Labels", "Rendering", "Export" };
  Tool[] tools = {
    Tool.EDIT_SITES,
    Tool.EDIT_ELEVATION,
    Tool.EDIT_BIOMES,
    Tool.EDIT_ZONES,
    Tool.EDIT_PATHS,
    Tool.EDIT_STRUCTURES,
    Tool.EDIT_LABELS,
    Tool.EDIT_RENDER,
    Tool.EDIT_EXPORT
  };

  for (int i = 0; i < labels.length; i++) {
    final int idx = i;
    int x = margin + i * (buttonW + 5);
    int y = barY + 2;
    IntRect rect = new IntRect(x, y, buttonW, barH - 4);
    if (queueButtonAction(rect, new Runnable() { public void run() {
      selectedPathIndex = -1;
      pendingPathStart = null;
      clearStructureSelection();
      currentTool = tools[idx];
    }})) return true;
  }
  return false;
}

// ----- Sites panel click -----
public boolean handleSitesPanelClick(int mx, int my) {
  if (!isInSitesPanel(mx, my)) return false;
  SitesLayout layout = buildSitesLayout();

  // Density slider
  if (layout.densitySlider.contains(mx, my)) {
    float t = (mx - layout.densitySlider.x) / (float)layout.densitySlider.w;
    int newCount = round(t * MAX_SITE_COUNT);
    siteTargetCount = constrain(newCount, 0, MAX_SITE_COUNT);
    activeSlider = SLIDER_SITES_DENSITY;
    return true;
  }

  // Fuzz slider (0..1 mapped to 0..0.3)
  if (layout.fuzzSlider.contains(mx, my)) {
    float t = (mx - layout.fuzzSlider.x) / (float)layout.fuzzSlider.w;
    t = constrain(t, 0, 1);
    siteFuzz = t * 0.3f;
    activeSlider = SLIDER_SITES_FUZZ;
    return true;
  }

  // Mode slider
  if (layout.modeSlider.contains(mx, my)) {
    int modeCount = placementModes.length;
    if (modeCount < 1) modeCount = 1;
    float t = (mx - layout.modeSlider.x) / (float)layout.modeSlider.w;
    t = constrain(t, 0, 1);
    int idx = round(t * (modeCount - 1));
    placementModeIndex = constrain(idx, 0, placementModes.length - 1);
    activeSlider = SLIDER_SITES_MODE;
    return true;
  }

  // Reset all button
  if (queueButtonAction(layout.resetBtn, new Runnable() { public void run() {
    resetAllMapData();
  }})) return true;

  // Generate button
  if (queueButtonAction(layout.generateBtn, new Runnable() { public void run() {
    mapModel.generateSites(currentPlacementMode(), siteTargetCount, keepPropertiesOnGenerate);
  }})) return true;

  // Full auto pipeline
  if (queueButtonAction(layout.fullGenerateBtn, new Runnable() { public void run() {
    startFullGenerateFromCells();
  }})) return true;

  // Keep properties toggle
  if (layout.keepCheckbox.contains(mx, my)) {
    keepPropertiesOnGenerate = !keepPropertiesOnGenerate;
    return true;
  }

  return false;
}

// ----- Zones panel click (tool + biome selection + add/remove + hue) -----

public boolean handleBiomesPanelClick(int mx, int my) {
  if (!isInBiomesPanel(mx, my)) return false;
  if (mapModel == null || mapModel.biomeTypes == null) return false;

  BiomesLayout layout = buildBiomesLayout();

  // Paint button
  if (queueButtonAction(layout.paintBtn, new Runnable() { public void run() {
    currentBiomePaintMode = ZonePaintMode.ZONE_PAINT;
  }})) return true;

  // Fill button
  if (queueButtonAction(layout.fillBtn, new Runnable() { public void run() {
    currentBiomePaintMode = ZonePaintMode.ZONE_FILL;
  }})) return true;

  // Generation selector + apply
  if (layout.genModeSelector.contains(mx, my)) {
    int modeCount = biomeGenerateModes.length;
    int maxIdx = max(1, modeCount - 1);
    float t = sliderNorm(layout.genModeSelector, mx);
    int idx = constrain(round(t * maxIdx), 0, modeCount - 1);
    biomeGenerateModeIndex = idx;
    activeSlider = SLIDER_BIOME_GEN_MODE;
    return true;
  }
  if (queueButtonAction(layout.genApplyBtn, new Runnable() { public void run() {
    applyBiomeGeneration();
  }})) return true;

  if (queueButtonAction(layout.genValueWaterBtn, new Runnable() { public void run() {
    float clampedSea = constrain(seaLevel, -1.0f, 1.0f);
    biomeGenerateValue01 = map(clampedSea, -1.0f, 1.0f, 0.0f, 1.0f);
    activeSlider = SLIDER_BIOME_GEN_VALUE;
  }})) return true;

  int nTypes = mapModel.biomeTypes.size();

  // "+" button
  if (queueButtonAction(layout.addBtn, new Runnable() { public void run() {
    mapModel.addBiomeType();
    activeBiomeIndex = mapModel.biomeTypes.size() - 1;
  }})) return true;

  // "-" button
  boolean canRemove = (nTypes > 1 && activeBiomeIndex > 0);
  if (canRemove && queueButtonAction(layout.removeBtn, new Runnable() { public void run() {
    int removeIndex = activeBiomeIndex;
    mapModel.removeBiomeType(removeIndex);

    // Fix activeBiomeIndex after removal
    int newCount = mapModel.biomeTypes.size();
    if (newCount == 0) {
      activeBiomeIndex = 0;
    } else {
      activeBiomeIndex = min(removeIndex - 1, newCount - 1);
      if (activeBiomeIndex < 0) activeBiomeIndex = 0;
    }
  }})) return true;

  // Palette swatches
  int n = mapModel.biomeTypes.size();
  if (n == 0) return false;

  for (int i = 0; i < n; i++) {
    IntRect sw = layout.swatches.get(i);
    if (sw.contains(mx, my)) {
      activeBiomeIndex = i;
      return true;
    }
  }

  // Name field for selected biome
  if (layout.nameField.contains(mx, my) && activeBiomeIndex >= 0 && activeBiomeIndex < n) {
    editingBiomeNameIndex = activeBiomeIndex;
    biomeNameDraft = mapModel.biomeTypes.get(activeBiomeIndex).name;
    return true;
  }

  // Hue slider
  if (activeBiomeIndex >= 0 && activeBiomeIndex < n) {
    if (layout.hueSlider.contains(mx, my)) {

      float t = (mx - layout.hueSlider.x) / (float)layout.hueSlider.w;
      t = constrain(t, 0, 1);

      ZoneType active = mapModel.biomeTypes.get(activeBiomeIndex);
      active.hue01 = t;
      active.updateColorFromHSB();
      activeSlider = SLIDER_BIOME_HUE;

      return true;
    }
  }

  // Pattern selector
  if (activeBiomeIndex >= 0 && activeBiomeIndex < n && layout.patternSlider.contains(mx, my)) {
    int patCount = max(1, mapModel.biomePatternCount);
    float t = sliderNorm(layout.patternSlider, mx);
    int idx = (patCount > 1) ? round(t * (patCount - 1)) : 0;
    idx = constrain(idx, 0, patCount - 1);
    ZoneType active = mapModel.biomeTypes.get(activeBiomeIndex);
    active.patternIndex = idx;
    activeSlider = SLIDER_BIOME_PATTERN;
    return true;
  }

  // Brush radius slider
  if (layout.brushSlider.contains(mx, my)) {
    float t = sliderNorm(layout.brushSlider, mx);
    zoneBrushRadius = constrain(0.01f + t * (0.15f - 0.01f), 0.01f, 0.15f);
    activeSlider = SLIDER_BIOME_BRUSH;
    return true;
  }

  if (layout.genValueSlider.contains(mx, my)) {
    float t = sliderNorm(layout.genValueSlider, mx);
    biomeGenerateValue01 = t;
    activeSlider = SLIDER_BIOME_GEN_VALUE;
    return true;
  }

  return false;
}

// ----- Zones panel click -----
public boolean handleZonesPanelClick(int mx, int my) {
  if (!isInZonesPanel(mx, my)) return false;
  if (mapModel == null || mapModel.zones == null) return false;

  ZonesLayout layout = buildZonesLayout();

  if (layout.brushSlider.contains(mx, my)) {
    float t = sliderNorm(layout.brushSlider, mx);
    zoneBrushRadius = constrain(0.01f + t * (0.15f - 0.01f), 0.01f, 0.15f);
    activeSlider = SLIDER_ZONES_BRUSH;
    return true;
  }

  if (queueButtonAction(layout.excludeWaterBtn, new Runnable() { public void run() {
    if (activeZoneIndex >= 0) {
      mapModel.removeUnderwaterCellsFromZone(activeZoneIndex, seaLevel);
    } else {
      mapModel.removeUnderwaterCellsFromZone(-1, seaLevel);
    }
  }})) return true;

  if (queueButtonAction(layout.exclusiveBtn, new Runnable() { public void run() {
    mapModel.enforceZoneExclusivity(activeZoneIndex);
  }})) return true;

  if (queueButtonAction(layout.fourColorBtn, new Runnable() { public void run() {
    mapModel.recolorZonesWithFourColors();
  }})) return true;

  if (queueButtonAction(layout.resetBtn, new Runnable() { public void run() {
    mapModel.resetAllZonesToNone();
    activeZoneIndex = -1;
    editingZoneNameIndex = -1;
    editingZoneComment = false;
  }})) return true;

  if (queueButtonAction(layout.regenerateBtn, new Runnable() { public void run() {
    int target = mapModel.zones.isEmpty() ? 5 : mapModel.zones.size();
    mapModel.regenerateRandomZones(target);
    activeZoneIndex = -1;
    editingZoneNameIndex = -1;
    editingZoneComment = false;
  }})) return true;

  if (layout.commentField.contains(mx, my)) {
    if (activeZoneIndex >= 0 && activeZoneIndex < mapModel.zones.size()) {
      MapModel.MapZone z = mapModel.zones.get(activeZoneIndex);
      zoneCommentDraft = (z != null && z.comment != null) ? z.comment : "";
      editingZoneComment = true;
    } else {
      zoneCommentDraft = "";
      editingZoneComment = false;
    }
    return true;
  } else {
    editingZoneComment = false;
  }

  return false;
}

public boolean handleZonesListPanelClick(int mx, int my) {
  if (!isInZonesListPanel(mx, my)) return false;
  ZonesListLayout layout = buildZonesListLayout();
  populateZonesRows(layout);

  if (queueButtonAction(layout.deselectBtn, new Runnable() { public void run() {
    activeZoneIndex = -1;
    editingZoneNameIndex = -1;
    editingZoneComment = false;
  }})) return true;

  if (queueButtonAction(layout.newBtn, new Runnable() { public void run() {
    mapModel.addZone();
    activeZoneIndex = mapModel.zones.size() - 1;
  }})) return true;

  for (int i = 0; i < layout.rows.size(); i++) {
    ZoneRowLayout row = layout.rows.get(i);
    if (row.index < 0 || row.index >= mapModel.zones.size()) continue;
    MapModel.MapZone az = mapModel.zones.get(row.index);

    if (queueButtonAction(row.selectRect, new Runnable() { public void run() {
      activeZoneIndex = row.index;
      editingZoneNameIndex = -1;
      editingZoneComment = false;
    }})) return true;

    if (queueButtonAction(row.nameRect, new Runnable() { public void run() {
      activeZoneIndex = row.index;
      editingZoneNameIndex = row.index;
      zoneNameDraft = az.name;
      editingZoneComment = false;
    }})) return true;

    if (row.hueSlider.contains(mx, my)) {
      activeZoneIndex = row.index;
      float t = sliderNorm(row.hueSlider, mx);
      az.hue01 = t;
      az.updateColorFromHSB();
      activeSlider = SLIDER_ZONES_ROW_HUE;
      return true;
    }
  }
  return false;
}

// ---------- Painting helpers ----------

public void paintBiomeAt(float wx, float wy) {
  Cell c = mapModel.findCellContaining(wx, wy);
  if (c != null) {
    c.biomeId = activeBiomeIndex;
  }
}

public void fillBiomeAt(float wx, float wy) {
  Cell c = mapModel.findCellContaining(wx, wy);
  if (c != null) {
    mapModel.floodFillBiomeFromCell(c, activeBiomeIndex);
    mapModel.renderer.invalidateBiomeOutlineCache();
  }
}

public void paintBiomeBrush(float wx, float wy) {
  if (mapModel.cells == null) return;
  float r2 = zoneBrushRadius * zoneBrushRadius;
  for (Cell c : mapModel.cells) {
    PVector cen = mapModel.cellCentroid(c);
    float dx = cen.x - wx;
    float dy = cen.y - wy;
    float d2 = dx * dx + dy * dy;
    if (d2 <= r2) {
      c.biomeId = activeBiomeIndex;
    }
  }
  mapModel.renderer.invalidateBiomeOutlineCache();
}

public void paintZoneAt(float wx, float wy) {
  if (mapModel.zones == null || activeZoneIndex < 0 || activeZoneIndex >= mapModel.zones.size()) return;
  Cell c = mapModel.findCellContaining(wx, wy);
  if (c != null) {
    int idx = mapModel.indexOfCell(c);
    mapModel.addCellToZone(idx, activeZoneIndex);
  }
}

public void fillZoneAt(float wx, float wy) {
  if (mapModel.zones == null) return;
  Cell c = mapModel.findCellContaining(wx, wy);
  if (c == null) return;
  if (activeZoneIndex < 0 || activeZoneIndex >= mapModel.zones.size()) {
    mapModel.removeCellFromAllZones(mapModel.indexOfCell(c));
  } else {
    mapModel.floodFillZone(c, activeZoneIndex);
  }
}

public void paintZoneBrush(float wx, float wy) {
  if (mapModel.zones == null || mapModel.cells == null) return;
  boolean erasing = (activeZoneIndex < 0 || activeZoneIndex >= mapModel.zones.size());
  float r2 = zoneBrushRadius * zoneBrushRadius;
  for (int ci = 0; ci < mapModel.cells.size(); ci++) {
    Cell c = mapModel.cells.get(ci);
    PVector cen = mapModel.cellCentroid(c);
    float dx = cen.x - wx;
    float dy = cen.y - wy;
    float d2 = dx * dx + dy * dy;
    if (d2 <= r2) {
      if (erasing) {
        mapModel.removeCellFromAllZones(ci);
      } else {
        mapModel.addCellToZone(ci, activeZoneIndex);
      }
    }
  }
}

public boolean handleSnapSettingsClick(int mx, int my) {
  SnapSettingsLayout layout = buildSnapSettingsLayout();
  if (!layout.panel.contains(mx, my)) return false;

  // Checkboxes
  for (int i = 0; i < layout.checks.size(); i++) {
    IntRect b = layout.checks.get(i);
    if (b.contains(mx, my)) {
      switch (i) {
        case 0: snapWaterEnabled = !snapWaterEnabled; break;
        case 1: snapBiomesEnabled = !snapBiomesEnabled; break;
        case 2: snapUnderwaterBiomesEnabled = !snapUnderwaterBiomesEnabled; break;
        case 3: snapZonesEnabled = !snapZonesEnabled; break;
        case 4: snapPathsEnabled = !snapPathsEnabled; break;
        case 5: snapStructuresEnabled = !snapStructuresEnabled; break;
        case 6: snapElevationEnabled = !snapElevationEnabled; break;
      }
      return true;
    }
  }

  // Elevation divisions slider
  if (layout.elevationSlider.contains(mx, my)) {
    int divMin = 2;
    int divMax = 24;
    float t = sliderNorm(layout.elevationSlider, mx);
    snapElevationDivisions = round(lerp(divMin, divMax, t));
    return true;
  }

  return false;
}

// ---------- Mouse & keyboard callbacks ----------

public void mousePressed() {
  if (mouseButton == LEFT) {
    pendingButtonAction = null;
    pressedButtonRect = null;
  }
  // Block interactions while generation is running; show notice
  if ((mapModel.isVoronoiBuilding() || fullGenRunning) && mouseButton == LEFT) {
    showNotice("Generation in progress...");
    return;
  }

  // Tool buttons
  if (mouseButton == LEFT) {
    if (handleToolButtonClick(mouseY)) return;
  }

  // Sites panel
  if (mouseButton == LEFT && currentTool == Tool.EDIT_SITES) {
    if (handleSitesPanelClick(mouseX, mouseY)) return;
  }

  // Biomes panel
  if (mouseButton == LEFT && currentTool == Tool.EDIT_BIOMES) {
    if (handleBiomesPanelClick(mouseX, mouseY)) return;
  }

  // Zones panel
  if (mouseButton == LEFT && currentTool == Tool.EDIT_ZONES) {
    if (handleZonesPanelClick(mouseX, mouseY)) return;
    if (handleZonesListPanelClick(mouseX, mouseY)) return;
    if (isInZonesListPanel(mouseX, mouseY)) return;
  }

  // Elevation panel
  if (mouseButton == LEFT && currentTool == Tool.EDIT_ELEVATION) {
    if (handleElevationPanelClick(mouseX, mouseY)) return;
  }

  // Paths panel
  if (mouseButton == LEFT && currentTool == Tool.EDIT_PATHS) {
    if (handlePathsPanelClick(mouseX, mouseY)) return;
    if (handlePathsListPanelClick(mouseX, mouseY)) return;
    if (isInPathsListPanel(mouseX, mouseY)) return;
  }

  // Structures panel
  if (mouseButton == LEFT && currentTool == Tool.EDIT_STRUCTURES) {
    if (handleStructuresPanelClick(mouseX, mouseY)) return;
    if (handleStructuresListPanelClick(mouseX, mouseY)) return;
    if (isInStructuresListPanel(mouseX, mouseY)) return;
  }

  // Labels panel
  if (mouseButton == LEFT && currentTool == Tool.EDIT_LABELS) {
    if (handleLabelsPanelClick(mouseX, mouseY)) return;
    if (handleLabelsListPanelClick(mouseX, mouseY)) return;
    if (isInLabelsListPanel(mouseX, mouseY)) return;
  }

  // Render panel
  if (mouseButton == LEFT && currentTool == Tool.EDIT_RENDER) {
    if (handleRenderPanelClick(mouseX, mouseY)) return;
  }

  // Export panel
  if (mouseButton == LEFT && currentTool == Tool.EDIT_EXPORT) {
    if (handleExportPanelClick(mouseX, mouseY)) return;
  }

  // Ignore world interaction if inside any top UI area
  if (mouseY < TOP_BAR_TOTAL + TOOL_BAR_HEIGHT) return;
  if (isInActivePanel(mouseX, mouseY)) return;
  if (currentTool == Tool.EDIT_ZONES && isInZonesListPanel(mouseX, mouseY)) return;
  if (currentTool == Tool.EDIT_PATHS && isInPathsListPanel(mouseX, mouseY)) return;
  if (currentTool == Tool.EDIT_STRUCTURES && isInStructuresListPanel(mouseX, mouseY)) return;
  if (currentTool == Tool.EDIT_LABELS && isInLabelsListPanel(mouseX, mouseY)) return;

  // Panning with right button (all modes)
  if (mouseButton == RIGHT) {
    isPanning = true;
    lastMouseX = mouseX;
    lastMouseY = mouseY;
    return;
  }

  // Left button: mode-specific actions
  if (mouseButton == LEFT) {
    PVector worldPos = viewport.screenToWorld(mouseX, mouseY);

    if (currentTool == Tool.EDIT_SITES) {
      handleSitesMousePressed(worldPos.x, worldPos.y);
    } else if (currentTool == Tool.EDIT_BIOMES) {
      if (currentBiomePaintMode == ZonePaintMode.ZONE_PAINT) {
        paintBiomeBrush(worldPos.x, worldPos.y);
      } else {
        fillBiomeAt(worldPos.x, worldPos.y);
      }
    } else if (currentTool == Tool.EDIT_ZONES) {
      if (currentZonePaintMode == ZonePaintMode.ZONE_PAINT) {
        paintZoneBrush(worldPos.x, worldPos.y);
      } else {
        fillZoneAt(worldPos.x, worldPos.y);
      }
    } else if (currentTool == Tool.EDIT_ELEVATION) {
      float dir = elevationBrushRaise ? 1 : -1;
      mapModel.applyElevationBrush(worldPos.x, worldPos.y, elevationBrushRadius, elevationBrushStrength * dir, seaLevel);
      markRenderDirty();
      markExportPreviewDirty();
    } else if (currentTool == Tool.EDIT_PATHS) {
      if (pathEraserMode) {
        mapModel.erasePathSegments(worldPos.x, worldPos.y, pathEraserRadius);
      } else {
        handlePathsMousePressed(worldPos.x, worldPos.y);
      }
    } else if (currentTool == Tool.EDIT_STRUCTURES) {
      if (selectedStructureIndices != null && !selectedStructureIndices.isEmpty()) {
        float cx = 0;
        float cy = 0;
        int count = 0;
        for (int idx : selectedStructureIndices) {
          if (idx < 0 || idx >= mapModel.structures.size()) continue;
          Structure s = mapModel.structures.get(idx);
          cx += s.x;
          cy += s.y;
          count++;
        }
        if (count > 0) {
          cx /= count;
          cy /= count;
          float dx = worldPos.x - cx;
          float dy = worldPos.y - cy;
          for (int idx : selectedStructureIndices) {
            if (idx < 0 || idx >= mapModel.structures.size()) continue;
            Structure s = mapModel.structures.get(idx);
            s.x += dx;
            s.y += dy;
            if (s.snapBinding != null) s.snapBinding.clear();
          }
        }
      } else {
        Structure s = mapModel.computeSnappedStructure(worldPos.x, worldPos.y, structureSize);
        mapModel.structures.add(s);
        clearStructureSelection();
        editingStructureName = false;
        editingStructureNameIndex = -1;
      }
    } else if (currentTool == Tool.EDIT_LABELS) {
      String baseText = "label";
      if (selectedLabelIndex >= 0 && selectedLabelIndex < mapModel.labels.size()) {
        MapLabel sel = mapModel.labels.get(selectedLabelIndex);
        if (sel != null && sel.text != null && sel.text.length() > 0) baseText = sel.text;
      }
      MapLabel lbl = new MapLabel(worldPos.x, worldPos.y, baseText, labelTargetMode);
      lbl.size = labelSizeDefault();
      mapModel.labels.add(lbl);
      selectedLabelIndex = mapModel.labels.size() - 1;
      editingLabelIndex = selectedLabelIndex;
      labelDraft = lbl.text;
    }
  }
}

public void handleSitesMousePressed(float wx, float wy) {
  wx = constrain(wx, mapModel.minX, mapModel.maxX);
  wy = constrain(wy, mapModel.minY, mapModel.maxY);
  float maxDistWorld = 10.0f / viewport.zoom; // ~10 px tolerance
  Site s = mapModel.findSiteNear(wx, wy, maxDistWorld);

  if (s != null) {
    mapModel.clearSiteSelection();
    mapModel.selectSite(s);
    draggingSite = s;
    isDraggingSite = true;
  } else {
    Site ns = mapModel.addSite(wx, wy);
    mapModel.clearSiteSelection();
    mapModel.selectSite(ns);
    draggingSite = ns;
    isDraggingSite = true;
  }
}

public boolean handlePathsPanelClick(int mx, int my) {
  if (!isInPathsPanel(mx, my)) return false;
  PathsLayout layout = buildPathsLayout();

  // Add path type
  if (layout.routeSlider.contains(mx, my)) {
    String[] modes = { "Ends", "Pathfind" };
    int modeCount = modes.length;
    float t = sliderNorm(layout.routeSlider, mx);
    int idx = round(t * (modeCount - 1));
    pathRouteModeIndex = constrain(idx, 0, modeCount - 1);
    if (activePathTypeIndex >= 0 && activePathTypeIndex < mapModel.pathTypes.size()) {
      PathType pt = mapModel.pathTypes.get(activePathTypeIndex);
      pt.routeMode = PathRouteMode.values()[pathRouteModeIndex];
    }
    activeSlider = SLIDER_PATH_ROUTE_MODE;
    return true;
  }

  if (layout.flattestSlider.contains(mx, my)) {
    float t = sliderNorm(layout.flattestSlider, mx);
    flattestSlopeBias = constrain(FLATTEST_BIAS_MIN + t * (FLATTEST_BIAS_MAX - FLATTEST_BIAS_MIN),
                                  FLATTEST_BIAS_MIN, FLATTEST_BIAS_MAX);
    if (activePathTypeIndex >= 0 && activePathTypeIndex < mapModel.pathTypes.size()) {
      PathType pt = mapModel.pathTypes.get(activePathTypeIndex);
      pt.slopeBias = flattestSlopeBias;
    }
    activeSlider = SLIDER_FLATTEST_BIAS;
    return true;
  }

  if (layout.avoidWaterCheck.contains(mx, my)) {
    pathAvoidWater = !pathAvoidWater;
    if (activePathTypeIndex >= 0 && activePathTypeIndex < mapModel.pathTypes.size()) {
      PathType pt = mapModel.pathTypes.get(activePathTypeIndex);
      pt.avoidWater = pathAvoidWater;
    }
    return true;
  }

  if (queueButtonAction(layout.eraserBtn, new Runnable() { public void run() {
    pathEraserMode = !pathEraserMode;
    pendingPathStart = null;
  }})) return true;
  // Comment field
  if (layout.commentField.contains(mx, my)) {
    if (selectedPathIndex >= 0 && selectedPathIndex < mapModel.paths.size()) {
      Path p = mapModel.paths.get(selectedPathIndex);
      pathCommentDraft = (p != null && p.comment != null) ? p.comment : "";
      editingPathCommentIndex = selectedPathIndex;
    } else {
      pathCommentDraft = "";
      editingPathCommentIndex = -1;
    }
    return true;
  } else {
    editingPathCommentIndex = -1;
  }
  if (queueButtonAction(layout.generateBtn, new Runnable() { public void run() {
    startLoading();
    loadingPct = 0;
    try {
      mapModel.generatePathsAuto(seaLevel);
      loadingPct = 1.0f;
    } finally {
      stopLoading();
    }
    markRenderDirty();
  }})) return true;
  if (layout.taperCheck.contains(mx, my)) {
    if (activePathTypeIndex >= 0 && activePathTypeIndex < mapModel.pathTypes.size()) {
      PathType pt = mapModel.pathTypes.get(activePathTypeIndex);
      pt.taperOn = !pt.taperOn;
    }
    return true;
  }

  // Add path type
  if (queueButtonAction(layout.typeAddBtn, new Runnable() { public void run() {
    int n = mapModel.pathTypes.size();
    int presetIdx = min(n, PATH_TYPE_PRESETS.length - 1); // after last preset, keep using the last one
    PathType pt = mapModel.makePathTypeFromPreset(presetIdx);
    if (pt != null) {
      mapModel.addPathType(pt);
      activePathTypeIndex = mapModel.pathTypes.size() - 1;
      syncActivePathTypeGlobals();
      selectedPathIndex = -1;
      pendingPathStart = null;
      editingPathNameIndex = -1;
    }
  }})) return true;

  // Remove path type
  boolean canRemove = mapModel.pathTypes.size() > 1 && activePathTypeIndex > 0;
  if (canRemove && queueButtonAction(layout.typeRemoveBtn, new Runnable() { public void run() {
    mapModel.removePathType(activePathTypeIndex);
    activePathTypeIndex = min(activePathTypeIndex, mapModel.pathTypes.size() - 1);
    if (activePathTypeIndex < 0) activePathTypeIndex = 0;
    editingPathTypeNameIndex = -1;
    syncActivePathTypeGlobals();
    selectedPathIndex = -1;
    pendingPathStart = null;
    editingPathNameIndex = -1;
  }})) return true;

  int nTypes = mapModel.pathTypes.size();

  // Swatches and names
  for (int i = 0; i < nTypes; i++) {
    IntRect sw = layout.typeSwatches.get(i);
    if (sw.contains(mx, my)) {
      activePathTypeIndex = i;
      syncActivePathTypeGlobals();
      selectedPathIndex = -1;
      pendingPathStart = null;
      editingPathNameIndex = -1;
      return true;
    }
  }

  if (layout.nameField.contains(mx, my) && activePathTypeIndex >= 0 && activePathTypeIndex < nTypes) {
    editingPathTypeNameIndex = activePathTypeIndex;
    pathTypeNameDraft = mapModel.pathTypes.get(activePathTypeIndex).name;
    return true;
  }

  // Hue slider
  if (activePathTypeIndex >= 0 && activePathTypeIndex < nTypes) {
    if (layout.typeHueSlider.contains(mx, my)) {
      float t = (mx - layout.typeHueSlider.x) / (float)layout.typeHueSlider.w;
      t = constrain(t, 0, 1);
      PathType pt = mapModel.pathTypes.get(activePathTypeIndex);
      pt.hue01 = t;
      pt.updateColorFromHSB();
      activeSlider = SLIDER_PATH_TYPE_HUE;
      return true;
    }
    if (layout.typeSatSlider.contains(mx, my)) {
      float t = sliderNorm(layout.typeSatSlider, mx);
      PathType pt = mapModel.pathTypes.get(activePathTypeIndex);
      pt.sat01 = t;
      pt.updateColorFromHSB();
      activeSlider = SLIDER_PATH_TYPE_SAT;
      return true;
    }
    if (layout.typeBriSlider.contains(mx, my)) {
      float t = sliderNorm(layout.typeBriSlider, mx);
      PathType pt = mapModel.pathTypes.get(activePathTypeIndex);
      pt.bri01 = t;
      pt.updateColorFromHSB();
      activeSlider = SLIDER_PATH_TYPE_BRI;
      return true;
    }
    if (layout.typeWeightSlider.contains(mx, my)) {
      float t = sliderNorm(layout.typeWeightSlider, mx);
      PathType pt = mapModel.pathTypes.get(activePathTypeIndex);
      pt.weightPx = constrain(0.5f + t * (8.0f - 0.5f), 0.5f, 8.0f);
      activeSlider = SLIDER_PATH_TYPE_WEIGHT;
      return true;
    }
    if (layout.typeMinWeightSlider.contains(mx, my)) {
      float t = sliderNorm(layout.typeMinWeightSlider, mx);
      PathType pt = mapModel.pathTypes.get(activePathTypeIndex);
      pt.minWeightPx = constrain(0.5f + t * (pt.weightPx - 0.5f), 0.5f, pt.weightPx);
      activeSlider = SLIDER_PATH_TYPE_MIN_WEIGHT;
      return true;
    }
    if (layout.taperCheck.contains(mx, my)) {
      PathType pt = mapModel.pathTypes.get(activePathTypeIndex);
      pt.taperOn = !pt.taperOn;
      return true;
    }
  }

  return false;
}

public boolean handleLabelsPanelClick(int mx, int my) {
  if (!isInLabelsPanel(mx, my)) return false;
  LabelsLayout layout = buildLabelsLayout();
  if (queueButtonAction(layout.genButton, new Runnable() { public void run() {
    if (mapModel != null) {
      mapModel.generateArbitraryLabels(seaLevel);
    }
  }})) return true;
  if (layout.commentField.contains(mx, my)) {
    if (selectedLabelIndex >= 0 && selectedLabelIndex < mapModel.labels.size()) {
      MapLabel l = mapModel.labels.get(selectedLabelIndex);
      labelCommentDraft = (l != null && l.comment != null) ? l.comment : "";
      editingLabelCommentIndex = selectedLabelIndex;
    } else {
      labelCommentDraft = "";
      editingLabelCommentIndex = -1;
    }
    return true;
  } else {
    editingLabelCommentIndex = -1;
  }
  return false;
}

public boolean handleLabelsListPanelClick(int mx, int my) {
  if (!isInLabelsListPanel(mx, my)) return false;
  LabelsListLayout layout = buildLabelsListLayout();
  populateLabelsListRows(layout);

  if (queueButtonAction(layout.deselectBtn, new Runnable() { public void run() {
    selectedLabelIndex = -1;
    editingLabelIndex = -1;
    editingLabelCommentIndex = -1;
    labelDraft = "label";
  }})) return true;

  for (int i = 0; i < layout.rows.size(); i++) {
    LabelRowLayout row = layout.rows.get(i);
    if (row.index < 0 || row.index >= mapModel.labels.size()) continue;
    MapLabel lbl = mapModel.labels.get(row.index);
  if (queueButtonAction(row.selectRect, new Runnable() { public void run() {
    selectedLabelIndex = row.index;
    editingLabelIndex = -1;
    editingLabelCommentIndex = -1;
    labelDraft = lbl.text;
  }})) return true;
  if (queueButtonAction(row.nameRect, new Runnable() { public void run() {
    selectedLabelIndex = row.index;
    editingLabelIndex = row.index;
    editingLabelCommentIndex = -1;
    labelDraft = lbl.text;
  }})) return true;
    if (queueButtonAction(row.delRect, new Runnable() { public void run() {
      mapModel.labels.remove(row.index);
      if (selectedLabelIndex == row.index) selectedLabelIndex = -1;
      if (editingLabelIndex == row.index) editingLabelIndex = -1;
      labelDraft = "label";
    }})) return true;
  }
  return false;
}

public LabelTarget nextLabelTarget(LabelTarget lt) {
  switch (lt) {
    case FREE: return LabelTarget.BIOME;
    case BIOME: return LabelTarget.ZONE;
    case ZONE: return LabelTarget.STRUCTURE;
    default: return LabelTarget.FREE;
  }
}

public boolean handlePathsListPanelClick(int mx, int my) {
  if (!isInPathsListPanel(mx, my)) return false;
  PathsListLayout layout = buildPathsListLayout();
  populatePathsListRows(layout);

  if (queueButtonAction(layout.deselectBtn, new Runnable() { public void run() {
    selectedPathIndex = -1;
    pendingPathStart = null;
    editingPathNameIndex = -1;
  }})) return true;

  // New path button
  if (queueButtonAction(layout.newBtn, new Runnable() { public void run() {
    Path np = new Path();
    np.typeId = activePathTypeIndex;
    np.name = mapModel.defaultPathNameForType(np.typeId);
    mapModel.paths.add(np);
    selectedPathIndex = mapModel.paths.size() - 1;
    activePathTypeIndex = (np.typeId >= 0 && np.typeId < mapModel.pathTypes.size()) ? np.typeId : activePathTypeIndex;
    syncActivePathTypeGlobals();
    editingPathNameIndex = selectedPathIndex;
    pathNameDraft = np.name;
    pendingPathStart = null;
  }})) return true;

  for (int i = 0; i < layout.rows.size(); i++) {
    PathRowLayout row = layout.rows.get(i);
    if (row.index < 0 || row.index >= mapModel.paths.size()) continue;
    Path p = mapModel.paths.get(row.index);
    if (p == null) continue;

    if (queueButtonAction(row.selectRect, new Runnable() { public void run() {
      selectedPathIndex = row.index;
      if (p.typeId >= 0 && p.typeId < mapModel.pathTypes.size()) {
        activePathTypeIndex = p.typeId;
        syncActivePathTypeGlobals();
      }
      editingPathNameIndex = -1;
      editingPathCommentIndex = -1;
      pendingPathStart = null;
    }})) return true;
    if (queueButtonAction(row.nameRect, new Runnable() { public void run() {
      selectedPathIndex = row.index;
      if (p.typeId >= 0 && p.typeId < mapModel.pathTypes.size()) {
        activePathTypeIndex = p.typeId;
        syncActivePathTypeGlobals();
      }
      editingPathNameIndex = row.index;
      pathNameDraft = (p.name != null) ? p.name : "";
      editingPathCommentIndex = -1;
    }})) return true;
    if (queueButtonAction(row.delRect, new Runnable() { public void run() {
      mapModel.paths.remove(row.index);
      if (selectedPathIndex == row.index) {
        selectedPathIndex = -1;
        pendingPathStart = null;
      } else if (selectedPathIndex > row.index) {
        selectedPathIndex -= 1;
      }
      if (editingPathNameIndex == row.index) editingPathNameIndex = -1;
    }})) return true;
    if (queueButtonAction(row.typeRect, new Runnable() { public void run() {
      if (!mapModel.pathTypes.isEmpty()) {
        p.typeId = (p.typeId + 1) % mapModel.pathTypes.size();
        activePathTypeIndex = p.typeId;
        syncActivePathTypeGlobals();
      }
    }})) return true;
  }

  return false;
}

public boolean handleStructuresPanelClick(int mx, int my) {
  if (!isInStructuresPanel(mx, my)) return false;
  StructuresLayout layout = buildStructuresLayout();
  StructureSelectionInfo info = gatherStructureSelectionInfo();
  boolean hasSelection = info.hasSelection;

  // Section toggles
  if (queueButtonAction(layout.headerGen, new Runnable() { public void run() { structSectionGenOpen = !structSectionGenOpen; }})) return true;
  if (queueButtonAction(layout.headerSnap, new Runnable() { public void run() { structSectionSnapOpen = !structSectionSnapOpen; }})) return true;
  if (queueButtonAction(layout.headerAttr, new Runnable() { public void run() { structSectionAttrOpen = !structSectionAttrOpen; }})) return true;

  // Generate controls
  if (structSectionGenOpen) {
    if (layout.genTownSlider.contains(mx, my)) {
      float t = sliderNorm(layout.genTownSlider, mx);
      structGenTownCount = constrain(round(t * 8), 0, 8);
      activeSlider = SLIDER_STRUCT_GEN_TOWN;
      return true;
    }
    if (layout.genBuildingSlider.contains(mx, my)) {
      float t = sliderNorm(layout.genBuildingSlider, mx);
      structGenBuildingDensity = constrain(t, 0, 1);
      activeSlider = SLIDER_STRUCT_GEN_BUILDING;
      return true;
    }
    if (queueButtonAction(layout.genButton, new Runnable() { public void run() {
      mapModel.generateStructuresAuto(structGenTownCount, structGenBuildingDensity, seaLevel);
      clearStructureSelection();
    }})) return true;
  }

  // Snap guides
  if (structSectionSnapOpen) {
    for (int i = 0; i < layout.snapChecks.size(); i++) {
      IntRect b = layout.snapChecks.get(i);
      if (!b.contains(mx, my)) continue;
      switch (i) {
        case 0: snapWaterEnabled = !snapWaterEnabled; break;
        case 1: snapBiomesEnabled = !snapBiomesEnabled; break;
        case 2: snapUnderwaterBiomesEnabled = !snapUnderwaterBiomesEnabled; break;
        case 3: snapZonesEnabled = !snapZonesEnabled; break;
        case 4: snapPathsEnabled = !snapPathsEnabled; break;
        case 5: snapStructuresEnabled = !snapStructuresEnabled; break;
        case 6: snapElevationEnabled = !snapElevationEnabled; break;
      }
      return true;
    }

    if (layout.snapElevationSlider != null && layout.snapElevationSlider.contains(mx, my)) {
      int divMin = 2;
      int divMax = 24;
      float t = sliderNorm(layout.snapElevationSlider, mx);
      snapElevationDivisions = round(lerp(divMin, divMax, t));
      activeSlider = SLIDER_STRUCT_SNAP_DIV;
      return true;
    }
  }

  if (!structSectionAttrOpen) return false;

  if (!layout.nameField.contains(mx, my)) {
    editingStructureName = false;
    editingStructureNameIndex = -1;
  }

  if (layout.nameField.contains(mx, my)) {
    editingStructureName = true;
    editingStructureNameIndex = -1;
    if (hasSelection && !info.nameMixed) structureNameDraft = info.sharedName;
    else if (hasSelection && info.nameMixed) structureNameDraft = "";
    return true;
  }
  if (layout.commentField.contains(mx, my)) {
    editingStructureComment = true;
    if (hasSelection && !info.commentMixed) structureCommentDraft = info.sharedComment;
    else structureCommentDraft = "";
    return true;
  } else {
    editingStructureComment = false;
  }

  if (layout.sizeSlider.contains(mx, my)) {
    float t = sliderNorm(layout.sizeSlider, mx);
    float newSize = constrain(0.01f + t * (0.2f - 0.01f), 0.01f, 0.2f);
    structureSize = newSize;
    if (hasSelection) {
      for (int idx : selectedStructureIndices) {
        if (idx < 0 || idx >= mapModel.structures.size()) continue;
        mapModel.structures.get(idx).size = newSize;
      }
      activeSlider = SLIDER_STRUCT_SELECTED_SIZE;
    } else {
      activeSlider = SLIDER_STRUCT_SIZE;
    }
    return true;
  }
  if (layout.angleSlider.contains(mx, my)) {
    float t = sliderNorm(layout.angleSlider, mx);
    float angDeg = -180.0f + t * 360.0f;
    float angRad = radians(angDeg);
    structureAngleOffsetRad = angRad;
    if (hasSelection) {
      for (int idx : selectedStructureIndices) {
        if (idx < 0 || idx >= mapModel.structures.size()) continue;
        mapModel.structures.get(idx).angle = angRad;
      }
      activeSlider = SLIDER_STRUCT_SELECTED_ANGLE;
    } else {
      activeSlider = SLIDER_STRUCT_ANGLE;
    }
    return true;
  }
  if (layout.ratioSlider.contains(mx, my)) {
    float t = sliderNorm(layout.ratioSlider, mx);
    float newRatio = constrain(0.3f + t * (3.0f - 0.3f), 0.3f, 3.0f);
    structureAspectRatio = newRatio;
    if (hasSelection) {
      for (int idx : selectedStructureIndices) {
        if (idx < 0 || idx >= mapModel.structures.size()) continue;
        mapModel.structures.get(idx).aspect = newRatio;
      }
      activeSlider = SLIDER_STRUCT_RATIO;
    } else {
      activeSlider = SLIDER_STRUCT_RATIO;
    }
    return true;
  }
  if (layout.shapeSelector.contains(mx, my)) {
    StructureShape[] shapes = StructureShape.values();
    float t = sliderNorm(layout.shapeSelector, mx);
    int idx = round(t * max(0, shapes.length - 1));
    idx = constrain(idx, 0, shapes.length - 1);
    structureShape = shapes[idx];
    if (hasSelection) {
      for (int si : selectedStructureIndices) {
        if (si < 0 || si >= mapModel.structures.size()) continue;
        mapModel.structures.get(si).shape = structureShape;
      }
    }
    activeSlider = SLIDER_STRUCT_SHAPE;
    return true;
  }
  if (layout.alignmentSelector.contains(mx, my)) {
    StructureSnapMode[] snaps = StructureSnapMode.values();
    float t = sliderNorm(layout.alignmentSelector, mx);
    int idx = round(t * max(0, snaps.length - 1));
    idx = constrain(idx, 0, snaps.length - 1);
    structureSnapMode = snaps[idx];
    if (hasSelection) {
      for (int si : selectedStructureIndices) {
        if (si < 0 || si >= mapModel.structures.size()) continue;
        mapModel.structures.get(si).alignment = structureSnapMode;
      }
    }
    activeSlider = SLIDER_STRUCT_ALIGNMENT;
    return true;
  }
  if (layout.hueSlider.contains(mx, my)) {
    float t = sliderNorm(layout.hueSlider, mx);
    structureHue01 = t;
    if (hasSelection) {
      for (int idx : selectedStructureIndices) {
        if (idx < 0 || idx >= mapModel.structures.size()) continue;
        mapModel.structures.get(idx).setHue(t);
      }
      activeSlider = SLIDER_STRUCT_SELECTED_HUE;
    } else {
      activeSlider = SLIDER_STRUCT_SELECTED_HUE;
    }
    return true;
  }
  if (layout.satSlider.contains(mx, my)) {
    float t = sliderNorm(layout.satSlider, mx);
    structureSat01 = t;
    if (hasSelection) {
      for (int idx : selectedStructureIndices) {
        if (idx < 0 || idx >= mapModel.structures.size()) continue;
        mapModel.structures.get(idx).setSaturation(t);
      }
      activeSlider = SLIDER_STRUCT_SELECTED_SAT;
    } else {
      activeSlider = SLIDER_STRUCT_SELECTED_SAT;
    }
    return true;
  }
  if (layout.alphaSlider.contains(mx, my)) {
    float t = sliderNorm(layout.alphaSlider, mx);
    structureAlpha01 = t;
    if (hasSelection) {
      for (int idx : selectedStructureIndices) {
        if (idx < 0 || idx >= mapModel.structures.size()) continue;
        mapModel.structures.get(idx).setAlpha(t);
      }
      activeSlider = SLIDER_STRUCT_SELECTED_ALPHA;
    } else {
      activeSlider = SLIDER_STRUCT_SELECTED_ALPHA;
    }
    return true;
  }
  if (layout.strokeSlider.contains(mx, my)) {
    float t = sliderNorm(layout.strokeSlider, mx);
    float w = constrain(0.5f + t * (4.0f - 0.5f), 0.5f, 4.0f);
    structureStrokePx = w;
    if (hasSelection) {
      for (int idx : selectedStructureIndices) {
        if (idx < 0 || idx >= mapModel.structures.size()) continue;
        mapModel.structures.get(idx).strokeWeightPx = w;
      }
      activeSlider = SLIDER_STRUCT_SELECTED_STROKE;
    } else {
      activeSlider = SLIDER_STRUCT_SELECTED_STROKE;
    }
    return true;
  }
  return false;
}

public boolean handleStructuresListPanelClick(int mx, int my) {
  if (!isInStructuresListPanel(mx, my)) return false;
  StructuresListLayout layout = buildStructuresListLayout();
  int listStartY = layoutStructureDetails(layout);
  populateStructuresListRows(layout, listStartY);

  if (queueButtonAction(layout.deselectBtn, new Runnable() { public void run() {
    clearStructureSelection();
  }})) return true;

  for (int i = 0; i < layout.rows.size(); i++) {
    StructureRowLayout row = layout.rows.get(i);
    if (row.index < 0 || row.index >= mapModel.structures.size()) continue;
    if (queueButtonAction(row.selectRect, new Runnable() { public void run() {
      toggleStructureSelection(row.index);
      editingStructureName = false;
      editingStructureNameIndex = -1;
    }})) return true;
    if (queueButtonAction(row.nameRect, new Runnable() { public void run() {
      selectStructureExclusive(row.index);
      editingStructureName = true;
      editingStructureNameIndex = row.index;
      Structure target = mapModel.structures.get(row.index);
      structureNameDraft = (target != null && target.name != null) ? target.name : "";
    }})) return true;
    if (queueButtonAction(row.delRect, new Runnable() { public void run() {
      mapModel.structures.remove(row.index);
      shiftStructureSelectionAfterRemoval(row.index);
      if (editingStructureNameIndex == row.index) editingStructureNameIndex = -1;
      else if (editingStructureNameIndex > row.index) editingStructureNameIndex -= 1;
      if (selectedStructureIndices.isEmpty()) editingStructureName = false;
    }})) return true;
  }
  return false;
}

public boolean handleRenderPanelClick(int mx, int my) {
  if (!isInRenderPanel(mx, my)) return false;
  RenderLayout layout = buildRenderLayout();
  // Section toggles
  if (queueButtonAction(layout.headerBase, new Runnable() { public void run() { renderSectionBaseOpen = !renderSectionBaseOpen; }})) return true;
  if (queueButtonAction(layout.headerBiomes, new Runnable() { public void run() { renderSectionBiomesOpen = !renderSectionBiomesOpen; }})) return true;
  if (queueButtonAction(layout.headerShading, new Runnable() { public void run() { renderSectionShadingOpen = !renderSectionShadingOpen; }})) return true;
  if (queueButtonAction(layout.headerCoastlines, new Runnable() { public void run() { renderSectionCoastlinesOpen = !renderSectionCoastlinesOpen; }})) return true;
  if (queueButtonAction(layout.headerElevation, new Runnable() { public void run() { renderSectionElevationOpen = !renderSectionElevationOpen; }})) return true;
  if (queueButtonAction(layout.headerPaths, new Runnable() { public void run() { renderSectionPathsOpen = !renderSectionPathsOpen; }})) return true;
  if (queueButtonAction(layout.headerZones, new Runnable() { public void run() { renderSectionZonesOpen = !renderSectionZonesOpen; }})) return true;
  if (queueButtonAction(layout.headerStructures, new Runnable() { public void run() { renderSectionStructuresOpen = !renderSectionStructuresOpen; }})) return true;
  if (queueButtonAction(layout.headerLabels, new Runnable() { public void run() { renderSectionLabelsOpen = !renderSectionLabelsOpen; }})) return true;
  if (queueButtonAction(layout.headerGeneral, new Runnable() { public void run() { renderSectionGeneralOpen = !renderSectionGeneralOpen; }})) return true;

  // Base
  if (renderSectionBaseOpen) {
    if (layout.landHSB[0].contains(mx, my)) { renderSettings.landHue01 = sliderNorm(layout.landHSB[0], mx); activeSlider = SLIDER_RENDER_LAND_H; return true; }
    if (layout.landHSB[1].contains(mx, my)) { renderSettings.landSat01 = sliderNorm(layout.landHSB[1], mx); activeSlider = SLIDER_RENDER_LAND_S; return true; }
    if (layout.landHSB[2].contains(mx, my)) { renderSettings.landBri01 = sliderNorm(layout.landHSB[2], mx); activeSlider = SLIDER_RENDER_LAND_B; return true; }
    if (layout.waterHSB[0].contains(mx, my)) { renderSettings.waterHue01 = sliderNorm(layout.waterHSB[0], mx); activeSlider = SLIDER_RENDER_WATER_H; return true; }
    if (layout.waterHSB[1].contains(mx, my)) { renderSettings.waterSat01 = sliderNorm(layout.waterHSB[1], mx); activeSlider = SLIDER_RENDER_WATER_S; return true; }
    if (layout.waterHSB[2].contains(mx, my)) { renderSettings.waterBri01 = sliderNorm(layout.waterHSB[2], mx); activeSlider = SLIDER_RENDER_WATER_B; return true; }
    if (layout.cellBordersAlphaSlider.contains(mx, my)) {
      float t = sliderNorm(layout.cellBordersAlphaSlider, mx);
      renderSettings.cellBorderAlpha01 = t;
      activeSlider = SLIDER_RENDER_CELL_BORDER_ALPHA;
      return true;
    }
    if (layout.cellBordersSizeSlider != null && layout.cellBordersSizeSlider.contains(mx, my)) {
      float t = sliderNorm(layout.cellBordersSizeSlider, mx);
      renderSettings.cellBorderSizePx = constrain(t * 5.0f, 0, 5);
      activeSlider = SLIDER_RENDER_CELL_BORDER_SIZE;
      markRenderVisualChange();
      return true;
    }
    if (layout.cellBordersScaleCheckbox != null && layout.cellBordersScaleCheckbox.contains(mx, my)) {
      renderSettings.cellBorderScaleWithZoom = !renderSettings.cellBorderScaleWithZoom;
      if (renderSettings.cellBorderScaleWithZoom) renderSettings.cellBorderRefZoom = DEFAULT_VIEW_ZOOM;
      markRenderVisualChange();
      markExportPreviewDirty();
      return true;
    }
    if (layout.backgroundNoiseSlider.contains(mx, my)) {
      float t = sliderNorm(layout.backgroundNoiseSlider, mx);
      renderSettings.backgroundNoiseAlpha01 = t;
      activeSlider = SLIDER_RENDER_BACKGROUND_NOISE;
      return true;
    }
  }

  // Biomes
  if (renderSectionBiomesOpen) {
    if (layout.biomeFillAlphaSlider.contains(mx, my)) {
      float t = sliderNorm(layout.biomeFillAlphaSlider, mx);
      renderSettings.biomeFillAlpha01 = t;
      activeSlider = SLIDER_RENDER_BIOME_FILL_ALPHA;
      return true;
    }
    if (layout.biomeSatSlider.contains(mx, my)) {
      float t = sliderNorm(layout.biomeSatSlider, mx);
      renderSettings.biomeSatScale01 = t;
      activeSlider = SLIDER_RENDER_BIOME_SAT;
      if (mapModel != null && mapModel.renderer != null) mapModel.renderer.invalidateBiomeCache();
      markRenderVisualChange();
      return true;
    }
    if (layout.biomeBriSlider != null && layout.biomeBriSlider.contains(mx, my)) {
      float t = sliderNorm(layout.biomeBriSlider, mx);
      renderSettings.biomeBriScale01 = t;
      activeSlider = SLIDER_RENDER_BIOME_BRI;
      if (mapModel != null && mapModel.renderer != null) mapModel.renderer.invalidateBiomeCache();
      markRenderVisualChange();
      return true;
    }
    for (int i = 0; i < layout.biomeFillTypeButtons.size(); i++) {
      IntRect b = layout.biomeFillTypeButtons.get(i);
      if (b.contains(mx, my)) {
        if (i == 0) renderSettings.biomeFillType = RenderFillType.RENDER_FILL_COLOR;
        else if (i == 1) renderSettings.biomeFillType = RenderFillType.RENDER_FILL_PATTERN;
        else renderSettings.biomeFillType = RenderFillType.RENDER_FILL_PATTERN_BG;
        if (mapModel != null && mapModel.renderer != null) mapModel.renderer.invalidateBiomeCache();
        markRenderVisualChange();
        return true;
      }
    }
    if (layout.biomeOutlineSizeSlider.contains(mx, my)) {
      float t = sliderNorm(layout.biomeOutlineSizeSlider, mx);
      renderSettings.biomeOutlineSizePx = constrain(t * 5.0f, 0, 5.0f);
      activeSlider = SLIDER_RENDER_BIOME_OUTLINE_SIZE;
      if (mapModel != null && mapModel.renderer != null) mapModel.renderer.invalidateBiomeCache();
      markRenderVisualChange();
      return true;
    }
    if (layout.biomeOutlineAlphaSlider.contains(mx, my)) {
      float t = sliderNorm(layout.biomeOutlineAlphaSlider, mx);
      renderSettings.biomeOutlineAlpha01 = t;
      activeSlider = SLIDER_RENDER_BIOME_OUTLINE_ALPHA;
      return true;
    }
    if (layout.biomeOutlineScaleCheckbox != null && layout.biomeOutlineScaleCheckbox.contains(mx, my)) {
      renderSettings.biomeOutlineScaleWithZoom = !renderSettings.biomeOutlineScaleWithZoom;
      if (renderSettings.biomeOutlineScaleWithZoom) renderSettings.biomeOutlineRefZoom = DEFAULT_VIEW_ZOOM;
      if (mapModel != null && mapModel.renderer != null) mapModel.renderer.invalidateBiomeCache();
      markRenderVisualChange();
      markExportPreviewDirty();
      return true;
    }
    if (layout.biomeUnderwaterAlphaSlider != null && layout.biomeUnderwaterAlphaSlider.contains(mx, my)) {
      float t = sliderNorm(layout.biomeUnderwaterAlphaSlider, mx);
      renderSettings.biomeUnderwaterAlpha01 = t;
      activeSlider = SLIDER_RENDER_BIOME_UNDERWATER_ALPHA;
      return true;
    }
  }

  // Shading
  if (renderSectionShadingOpen) {
    if (layout.waterDepthAlphaSlider.contains(mx, my)) {
      float t = sliderNorm(layout.waterDepthAlphaSlider, mx);
      renderSettings.waterDepthAlpha01 = t;
      activeSlider = SLIDER_RENDER_WATER_DEPTH_ALPHA;
      return true;
    }
    if (layout.lightAlphaSlider.contains(mx, my)) {
      float t = sliderNorm(layout.lightAlphaSlider, mx);
      renderSettings.elevationLightAlpha01 = t;
      activeSlider = SLIDER_RENDER_LIGHT_ALPHA;
      if (mapModel != null && mapModel.renderer != null) mapModel.renderer.invalidateLightCache();
      markRenderVisualChange();
      return true;
    }
    if (layout.lightAzimuthSlider.contains(mx, my)) {
      float t = sliderNorm(layout.lightAzimuthSlider, mx);
      renderSettings.elevationLightAzimuthDeg = constrain(t * 360.0f, 0, 360.0f);
      activeSlider = SLIDER_RENDER_LIGHT_AZIMUTH;
      if (mapModel != null && mapModel.renderer != null) mapModel.renderer.invalidateLightCache();
      markRenderVisualChange();
      return true;
    }
    if (layout.lightAltitudeSlider.contains(mx, my)) {
      float t = sliderNorm(layout.lightAltitudeSlider, mx);
      renderSettings.elevationLightAltitudeDeg = constrain(5.0f + t * (80.0f - 5.0f), 5.0f, 80.0f);
      activeSlider = SLIDER_RENDER_LIGHT_ALTITUDE;
      if (mapModel != null && mapModel.renderer != null) mapModel.renderer.invalidateLightCache();
      markRenderVisualChange();
      return true;
    }
    if (layout.lightDitherSlider != null && layout.lightDitherSlider.contains(mx, my)) {
      float t = sliderNorm(layout.lightDitherSlider, mx);
      renderSettings.elevationLightDitherPx = constrain(t * 10.0f, 0, 10.0f);
      activeSlider = SLIDER_RENDER_LIGHT_DITHER;
      if (mapModel != null && mapModel.renderer != null) mapModel.renderer.invalidateLightCache();
      markRenderVisualChange();
      return true;
    }
    if (layout.lightDitherScaleCheckbox != null && layout.lightDitherScaleCheckbox.contains(mx, my)) {
      renderSettings.elevationLightDitherScaleWithZoom = !renderSettings.elevationLightDitherScaleWithZoom;
      if (renderSettings.elevationLightDitherScaleWithZoom) renderSettings.elevationLightDitherRefZoom = DEFAULT_VIEW_ZOOM;
      if (mapModel != null && mapModel.renderer != null) mapModel.renderer.invalidateLightCache();
      markRenderVisualChange();
      markExportPreviewDirty();
      return true;
    }
  }

  // Coastlines
  if (renderSectionCoastlinesOpen) {
    if (layout.waterCoastSizeSlider != null && layout.waterCoastSizeSlider.contains(mx, my)) {
      float t = sliderNorm(layout.waterCoastSizeSlider, mx);
      renderSettings.waterCoastSizePx = constrain(t * 5.0f, 0, 5.0f);
      activeSlider = SLIDER_RENDER_WATER_COAST_SIZE;
      if (mapModel != null && mapModel.renderer != null) mapModel.renderer.invalidateCoastCache();
      markRenderVisualChange();
      return true;
    }
    if (layout.waterCoastScaleCheckbox != null && layout.waterCoastScaleCheckbox.contains(mx, my)) {
      renderSettings.waterCoastScaleWithZoom = !renderSettings.waterCoastScaleWithZoom;
      if (renderSettings.waterCoastScaleWithZoom) renderSettings.waterContourRefZoom = DEFAULT_VIEW_ZOOM;
      markRenderVisualChange();
      if (mapModel != null && mapModel.renderer != null) mapModel.renderer.invalidateCoastCache();
      markExportPreviewDirty();
      return true;
    }
    if (layout.waterCoastAboveZonesCheckbox != null && layout.waterCoastAboveZonesCheckbox.contains(mx, my)) {
      renderSettings.waterCoastAboveZones = !renderSettings.waterCoastAboveZones;
      markRenderVisualChange();
      if (mapModel != null && mapModel.renderer != null) mapModel.renderer.invalidateCoastCache();
      markExportPreviewDirty();
      return true;
    }
    if (layout.waterContourCoastAlphaSlider.contains(mx, my)) {
      float t = sliderNorm(layout.waterContourCoastAlphaSlider, mx);
      renderSettings.waterCoastAlpha01 = t;
      syncLegacyWaterContourAlpha(renderSettings);
      activeSlider = SLIDER_RENDER_WATER_CONTOUR_ALPHA;
      if (mapModel != null && mapModel.renderer != null) mapModel.renderer.invalidateCoastCache();
      markRenderVisualChange();
      return true;
    }
    if (layout.waterContourSizeSlider.contains(mx, my)) {
      float t = sliderNorm(layout.waterContourSizeSlider, mx);
      renderSettings.waterContourSizePx = constrain(t * 5.0f, 0, 5.0f);
      activeSlider = SLIDER_RENDER_WATER_CONTOUR_SIZE;
      if (mapModel != null && mapModel.renderer != null) mapModel.renderer.invalidateCoastCache();
      markRenderVisualChange();
      return true;
    }
    if (layout.waterContourScaleCheckbox != null && layout.waterContourScaleCheckbox.contains(mx, my)) {
      renderSettings.waterContourScaleWithZoom = !renderSettings.waterContourScaleWithZoom;
      if (renderSettings.waterContourScaleWithZoom) renderSettings.waterContourRefZoom = DEFAULT_VIEW_ZOOM;
      if (mapModel != null && mapModel.renderer != null) mapModel.renderer.invalidateCoastCache();
      markRenderVisualChange();
      markExportPreviewDirty();
      return true;
    }
    if (layout.waterContourHSB[0].contains(mx, my)) { renderSettings.waterContourHue01 = sliderNorm(layout.waterContourHSB[0], mx); activeSlider = SLIDER_RENDER_WATER_CONTOUR_H; if (mapModel != null && mapModel.renderer != null) mapModel.renderer.invalidateCoastCache(); markRenderVisualChange(); return true; }
    if (layout.waterContourHSB[1].contains(mx, my)) { renderSettings.waterContourSat01 = sliderNorm(layout.waterContourHSB[1], mx); activeSlider = SLIDER_RENDER_WATER_CONTOUR_S; if (mapModel != null && mapModel.renderer != null) mapModel.renderer.invalidateCoastCache(); markRenderVisualChange(); return true; }
    if (layout.waterContourHSB[2].contains(mx, my)) { renderSettings.waterContourBri01 = sliderNorm(layout.waterContourHSB[2], mx); activeSlider = SLIDER_RENDER_WATER_CONTOUR_B; if (mapModel != null && mapModel.renderer != null) mapModel.renderer.invalidateCoastCache(); markRenderVisualChange(); return true; }
    if (layout.waterRippleCountSlider.contains(mx, my)) {
      float t = sliderNorm(layout.waterRippleCountSlider, mx);
      renderSettings.waterRippleCount = constrain(round(t * 5.0f), 0, 5);
      activeSlider = SLIDER_RENDER_WATER_RIPPLE_COUNT;
      if (mapModel != null && mapModel.renderer != null) mapModel.renderer.invalidateCoastCache();
      markRenderVisualChange();
      return true;
    }
    if (layout.waterRippleDistanceSlider.contains(mx, my)) {
      float t = sliderNorm(layout.waterRippleDistanceSlider, mx);
      renderSettings.waterRippleDistancePx = constrain(t * 40.0f, 0.0f, 40.0f);
      activeSlider = SLIDER_RENDER_WATER_RIPPLE_DIST;
      if (mapModel != null && mapModel.renderer != null) mapModel.renderer.invalidateCoastCache();
      markRenderVisualChange();
      return true;
    }
    if (layout.waterRippleAlphaStartSlider.contains(mx, my)) {
      float t = sliderNorm(layout.waterRippleAlphaStartSlider, mx);
      renderSettings.waterRippleAlphaStart01 = t;
      activeSlider = SLIDER_RENDER_WATER_RIPPLE_ALPHA_START;
      if (mapModel != null && mapModel.renderer != null) mapModel.renderer.invalidateCoastCache();
      markRenderVisualChange();
      return true;
    }
    if (layout.waterRippleAlphaEndSlider.contains(mx, my)) {
      float t = sliderNorm(layout.waterRippleAlphaEndSlider, mx);
      renderSettings.waterRippleAlphaEnd01 = t;
      activeSlider = SLIDER_RENDER_WATER_RIPPLE_ALPHA_END;
      if (mapModel != null && mapModel.renderer != null) mapModel.renderer.invalidateCoastCache();
      markRenderVisualChange();
      return true;
    }
    if (layout.waterHatchAngleSlider.contains(mx, my)) {
      float t = sliderNorm(layout.waterHatchAngleSlider, mx);
      renderSettings.waterHatchAngleDeg = constrain(-90.0f + t * 180.0f, -90.0f, 90.0f);
      activeSlider = SLIDER_RENDER_WATER_HATCH_ANGLE;
      if (mapModel != null && mapModel.renderer != null) mapModel.renderer.invalidateCoastCache();
      markRenderVisualChange();
      return true;
    }
    if (layout.waterHatchLengthSlider.contains(mx, my)) {
      float t = sliderNorm(layout.waterHatchLengthSlider, mx);
      renderSettings.waterHatchLengthPx = constrain(t * 400.0f, 0, 400);
      activeSlider = SLIDER_RENDER_WATER_HATCH_LENGTH;
      if (mapModel != null && mapModel.renderer != null) mapModel.renderer.invalidateCoastCache();
      markRenderVisualChange();
      return true;
    }
    if (layout.waterHatchSpacingSlider.contains(mx, my)) {
      float t = sliderNorm(layout.waterHatchSpacingSlider, mx);
      renderSettings.waterHatchSpacingPx = constrain(t * 120.0f, 0, 120.0f);
      activeSlider = SLIDER_RENDER_WATER_HATCH_SPACING;
      if (mapModel != null && mapModel.renderer != null) mapModel.renderer.invalidateCoastCache();
      markRenderVisualChange();
      return true;
    }
    if (layout.waterHatchAlphaSlider.contains(mx, my)) {
      float t = sliderNorm(layout.waterHatchAlphaSlider, mx);
      renderSettings.waterHatchAlpha01 = t;
      activeSlider = SLIDER_RENDER_WATER_HATCH_ALPHA;
      if (mapModel != null && mapModel.renderer != null) mapModel.renderer.invalidateCoastCache();
      markRenderVisualChange();
      return true;
    }
  }

  // Elevation
  if (renderSectionElevationOpen) {
    if (layout.elevationLinesCountSlider.contains(mx, my)) {
      float t = sliderNorm(layout.elevationLinesCountSlider, mx);
      renderSettings.elevationLinesCount = constrain(round(t * 24.0f), 0, 24);
      activeSlider = SLIDER_RENDER_ELEV_LINES_COUNT;
      markRenderVisualChange();
      return true;
    }
    if (layout.elevationLinesAlphaSlider.contains(mx, my)) {
      float t = sliderNorm(layout.elevationLinesAlphaSlider, mx);
      renderSettings.elevationLinesAlpha01 = t;
      activeSlider = SLIDER_RENDER_ELEV_LINES_ALPHA;
      return true;
    }
    if (layout.elevationLinesSizeSlider != null && layout.elevationLinesSizeSlider.contains(mx, my)) {
      float t = sliderNorm(layout.elevationLinesSizeSlider, mx);
      renderSettings.elevationLinesSizePx = constrain(t * 5.0f, 0, 5.0f);
      activeSlider = SLIDER_RENDER_ELEV_LINES_SIZE;
      markRenderVisualChange();
      return true;
    }
    if (layout.elevationLinesScaleCheckbox != null && layout.elevationLinesScaleCheckbox.contains(mx, my)) {
      renderSettings.elevationLinesScaleWithZoom = !renderSettings.elevationLinesScaleWithZoom;
      if (renderSettings.elevationLinesScaleWithZoom) renderSettings.elevationLinesRefZoom = DEFAULT_VIEW_ZOOM;
      markRenderVisualChange();
      markExportPreviewDirty();
      return true;
    }
  }

  // Paths
  if (renderSectionPathsOpen) {
    if (layout.pathsShowCheckbox.contains(mx, my)) {
      renderSettings.showPaths = !renderSettings.showPaths;
      return true;
    }
    if (layout.pathsScaleWithZoomCheckbox != null && layout.pathsScaleWithZoomCheckbox.contains(mx, my)) {
      renderSettings.pathScaleWithZoom = !renderSettings.pathScaleWithZoom;
      if (renderSettings.pathScaleWithZoom) {
        renderSettings.pathScaleRefZoom = DEFAULT_VIEW_ZOOM;
      }
      markRenderVisualChange();
      markExportPreviewDirty();
      return true;
    }
    if (layout.pathSatSlider.contains(mx, my)) {
      float t = sliderNorm(layout.pathSatSlider, mx);
      renderSettings.pathSatScale01 = t;
      activeSlider = SLIDER_RENDER_PATH_SAT;
      return true;
    }
    if (layout.pathBriSlider.contains(mx, my)) {
      float t = sliderNorm(layout.pathBriSlider, mx);
      renderSettings.pathBriScale01 = t;
      activeSlider = SLIDER_RENDER_PATH_BRI;
      return true;
    }
  }

  // Zones
  if (renderSectionZonesOpen) {
    if (layout.zoneAlphaSlider.contains(mx, my)) {
      float t = sliderNorm(layout.zoneAlphaSlider, mx);
      renderSettings.zoneStrokeAlpha01 = t;
      activeSlider = SLIDER_RENDER_ZONE_ALPHA;
      if (mapModel != null && mapModel.renderer != null) mapModel.renderer.invalidateZoneCache();
      markRenderVisualChange();
      return true;
    }
    if (layout.zoneSizeSlider != null && layout.zoneSizeSlider.contains(mx, my)) {
      float t = sliderNorm(layout.zoneSizeSlider, mx);
      renderSettings.zoneStrokeSizePx = constrain(t * 5.0f, 0, 5.0f);
      activeSlider = SLIDER_RENDER_ZONE_SIZE;
      if (mapModel != null && mapModel.renderer != null) mapModel.renderer.invalidateZoneCache();
      markRenderVisualChange();
      return true;
    }
    if (layout.zoneScaleWithZoomCheckbox != null && layout.zoneScaleWithZoomCheckbox.contains(mx, my)) {
      renderSettings.zoneStrokeScaleWithZoom = !renderSettings.zoneStrokeScaleWithZoom;
      if (renderSettings.zoneStrokeScaleWithZoom) renderSettings.zoneStrokeRefZoom = DEFAULT_VIEW_ZOOM;
      if (mapModel != null && mapModel.renderer != null) mapModel.renderer.invalidateZoneCache();
      markRenderVisualChange();
      markExportPreviewDirty();
      return true;
    }
    if (layout.zoneSatSlider.contains(mx, my)) {
      float t = sliderNorm(layout.zoneSatSlider, mx);
      renderSettings.zoneStrokeSatScale01 = t;
      activeSlider = SLIDER_RENDER_ZONE_SAT;
      if (mapModel != null && mapModel.renderer != null) mapModel.renderer.invalidateZoneCache();
      markRenderVisualChange();
      return true;
    }
    if (layout.zoneBriSlider.contains(mx, my)) {
      float t = sliderNorm(layout.zoneBriSlider, mx);
      renderSettings.zoneStrokeBriScale01 = t;
      activeSlider = SLIDER_RENDER_ZONE_BRI;
      if (mapModel != null && mapModel.renderer != null) mapModel.renderer.invalidateZoneCache();
      markRenderVisualChange();
      return true;
    }
  }

  // Structures
  if (renderSectionStructuresOpen) {
    if (layout.structuresShowCheckbox.contains(mx, my)) {
      renderSettings.showStructures = !renderSettings.showStructures;
      return true;
    }
    if (layout.structuresMergeCheckbox.contains(mx, my)) {
      renderSettings.mergeStructures = !renderSettings.mergeStructures;
      return true;
    }
    if (layout.structuresScaleWithZoomCheckbox != null && layout.structuresScaleWithZoomCheckbox.contains(mx, my)) {
      renderSettings.structureStrokeScaleWithZoom = !renderSettings.structureStrokeScaleWithZoom;
      if (renderSettings.structureStrokeScaleWithZoom) renderSettings.structureStrokeRefZoom = DEFAULT_VIEW_ZOOM;
      markRenderVisualChange();
      markExportPreviewDirty();
      return true;
    }
    if (layout.structuresShadowAlphaSlider.contains(mx, my)) {
      float t = sliderNorm(layout.structuresShadowAlphaSlider, mx);
      renderSettings.structureShadowAlpha01 = t;
      activeSlider = SLIDER_RENDER_STRUCT_SHADOW_ALPHA;
      return true;
    }
  }

  // Labels
  if (renderSectionLabelsOpen) {
    if (layout.labelsArbitraryCheckbox.contains(mx, my)) {
      renderSettings.showLabelsArbitrary = !renderSettings.showLabelsArbitrary;
      return true;
    }
    if (layout.labelsArbSizeSlider.contains(mx, my)) {
      float t = sliderNorm(layout.labelsArbSizeSlider, mx);
      renderSettings.labelSizeArbPx = round(constrain(8 + t * (40 - 8), 4, 80));
      activeSlider = SLIDER_RENDER_LABEL_SIZE_ARBITRARY;
      return true;
    }
    if (layout.labelsZonesCheckbox.contains(mx, my)) {
      renderSettings.showLabelsZones = !renderSettings.showLabelsZones;
      return true;
    }
    if (layout.labelsZoneSizeSlider.contains(mx, my)) {
      float t = sliderNorm(layout.labelsZoneSizeSlider, mx);
      renderSettings.labelSizeZonePx = round(constrain(8 + t * (40 - 8), 4, 80));
      activeSlider = SLIDER_RENDER_LABEL_SIZE_ZONES;
      return true;
    }
    if (layout.labelsPathsCheckbox.contains(mx, my)) {
      renderSettings.showLabelsPaths = !renderSettings.showLabelsPaths;
      return true;
    }
    if (layout.labelsPathSizeSlider.contains(mx, my)) {
      float t = sliderNorm(layout.labelsPathSizeSlider, mx);
      renderSettings.labelSizePathPx = round(constrain(8 + t * (40 - 8), 4, 80));
      activeSlider = SLIDER_RENDER_LABEL_SIZE_PATHS;
      return true;
    }
    if (layout.labelsStructuresCheckbox.contains(mx, my)) {
      renderSettings.showLabelsStructures = !renderSettings.showLabelsStructures;
      return true;
    }
    if (layout.labelsScaleWithZoomCheckbox != null && layout.labelsScaleWithZoomCheckbox.contains(mx, my)) {
      renderSettings.labelScaleWithZoom = !renderSettings.labelScaleWithZoom;
      if (renderSettings.labelScaleWithZoom) {
        renderSettings.labelScaleRefZoom = DEFAULT_VIEW_ZOOM;
      }
      markExportPreviewDirty();
      return true;
    }
    if (layout.labelsOutlineScaleWithZoomCheckbox != null && layout.labelsOutlineScaleWithZoomCheckbox.contains(mx, my)) {
      renderSettings.labelOutlineScaleWithZoom = !renderSettings.labelOutlineScaleWithZoom;
      markExportPreviewDirty();
      return true;
    }
    if (layout.labelsScaleWithZoomCheckbox != null &&
        mx >= layout.labelsScaleWithZoomCheckbox.x + layout.labelsScaleWithZoomCheckbox.w + PANEL_ROW_GAP &&
        mx <= layout.labelsScaleWithZoomCheckbox.x + layout.labelsScaleWithZoomCheckbox.w + PANEL_ROW_GAP + 80 &&
        my >= layout.labelsScaleWithZoomCheckbox.y &&
        my <= layout.labelsScaleWithZoomCheckbox.y + PANEL_LABEL_H) {
      // Quick toggle for ref zoom: click label to set to current zoom, click again to reset.
      if (renderSettings.labelScaleRefZoom != 1.0f) renderSettings.labelScaleRefZoom = 1.0f;
      else renderSettings.labelScaleRefZoom = max(0.1f, viewport.zoom);
      markExportPreviewDirty();
      return true;
    }
    if (layout.labelsStructSizeSlider.contains(mx, my)) {
      float t = sliderNorm(layout.labelsStructSizeSlider, mx);
      renderSettings.labelSizeStructPx = round(constrain(8 + t * (40 - 8), 4, 80));
      activeSlider = SLIDER_RENDER_LABEL_SIZE_STRUCTS;
      return true;
    }
    if (layout.labelsOutlineAlphaSlider.contains(mx, my)) {
      float t = sliderNorm(layout.labelsOutlineAlphaSlider, mx);
      renderSettings.labelOutlineAlpha01 = t;
      activeSlider = SLIDER_RENDER_LABEL_OUTLINE_ALPHA;
      return true;
    }
    if (layout.labelsOutlineSizeSlider.contains(mx, my)) {
      float t = sliderNorm(layout.labelsOutlineSizeSlider, mx);
      renderSettings.labelOutlineSizePx = round(constrain(t * 16.0f, 0, 16.0f));
      activeSlider = SLIDER_RENDER_LABEL_OUTLINE_SIZE;
      return true;
    }
    if (layout.labelsFontSelector != null && layout.labelsFontSelector.contains(mx, my) && LABEL_FONT_OPTIONS != null && LABEL_FONT_OPTIONS.length > 0) {
      int n = max(1, LABEL_FONT_OPTIONS.length - 1);
      float t = sliderNorm(layout.labelsFontSelector, mx);
      int idx = constrain(round(t * n), 0, LABEL_FONT_OPTIONS.length - 1);
      renderSettings.labelFontIndex = idx;
      activeSlider = SLIDER_RENDER_LABEL_FONT;
      if (mapModel != null && mapModel.renderer != null) mapModel.renderer.fontPrepNeeded = true;
      return true;
    }
  }

  // General
  if (renderSectionGeneralOpen) {
    if (layout.exportPaddingSlider.contains(mx, my)) {
      float t = sliderNorm(layout.exportPaddingSlider, mx);
      renderSettings.exportPaddingPct = constrain(t * 0.10f, 0, 0.10f);
      renderPaddingPct = renderSettings.exportPaddingPct;
      activeSlider = SLIDER_RENDER_PADDING;
      markExportPreviewDirty();
      return true;
    }
    if (layout.antialiasCheckbox.contains(mx, my)) {
      renderSettings.antialiasing = !renderSettings.antialiasing;
      if (mapModel != null && mapModel.renderer != null) {
        mapModel.renderer.invalidateCoastCache();
        mapModel.renderer.invalidateBiomeCache();
        mapModel.renderer.invalidateZoneCache();
        mapModel.renderer.invalidateLightCache();
      }
      markRenderDirty();
      return true;
    }
    if (layout.presetSelector.contains(mx, my) && renderPresets != null && renderPresets.length > 0) {
      int n = max(1, renderPresets.length - 1);
      float t = sliderNorm(layout.presetSelector, mx);
      int idx = constrain(round(t * n), 0, renderPresets.length - 1);
      renderSettings.activePresetIndex = idx;
      activeSlider = SLIDER_RENDER_PRESET_SELECT;
      return true;
    }
    if (queueButtonAction(layout.presetApplyBtn, new Runnable() { public void run() {
      applyRenderPreset(renderSettings.activePresetIndex);
    }})) return true;
  }
  return false;
}

public boolean handleExportPanelClick(int mx, int my) {
  if (!isInExportPanel(mx, my)) return false;
  ExportLayout layout = buildExportLayout();
  if (queueButtonAction(layout.pngBtn, new Runnable() { public void run() {
    String path = exportPng();
    if (path != null && path.length() > 0 && !path.startsWith("Failed")) {
      lastExportStatus = path;
      showNotice("Saved PNG: " + path);
    } else {
      lastExportStatus = (path != null) ? path : "Export failed";
      showNotice("Export failed");
    }
  }})) return true;
  if (queueButtonAction(layout.svgBtn, new Runnable() { public void run() {
    String path = exportSvg();
    if (path != null && path.length() > 0 && !path.startsWith("Failed")) {
      lastExportStatus = path;
      showNotice("Saved SVG: " + path);
    } else {
      lastExportStatus = (path != null) ? path : "Export failed";
      showNotice("Export failed");
    }
  }})) return true;
  if (queueButtonAction(layout.geoJsonBtn, new Runnable() { public void run() {
    String path = exportGeoJson();
    if (path != null && path.length() > 0 && !path.startsWith("Failed")) {
      lastExportStatus = path;
      showNotice("Saved GeoJSON: " + path);
    } else {
      lastExportStatus = (path != null) ? path : "Export failed";
      showNotice("Export failed");
    }
  }})) return true;
  if (layout.setResolutionBtn != null && queueButtonAction(layout.setResolutionBtn, new Runnable() { public void run() {
    exportScale = max(0.1f, viewport.zoom / DEFAULT_VIEW_ZOOM);
    markExportPreviewDirty();
  }})) return true;
  if (queueButtonAction(layout.mapExportBtn, new Runnable() { public void run() {
    String path = exportMapJson();
    if (path != null && path.length() > 0 && !path.startsWith("Failed")) {
      lastExportStatus = path;
      showNotice("Saved map JSON: " + path);
    } else {
      lastExportStatus = (path != null) ? path : "Export failed";
      showNotice("Export failed");
    }
  }})) return true;
  if (queueButtonAction(layout.mapImportBtn, new Runnable() { public void run() {
    String res = importMapJson();
    if (res != null && res.startsWith("Failed")) {
      lastExportStatus = res;
      showNotice("Import failed");
    } else {
      lastExportStatus = (res != null) ? res : "Imported";
      showNotice("Map imported");
    }
  }})) return true;
  return false;
}

// ----- Elevation panel click -----

public boolean handleElevationPanelClick(int mx, int my) {
  if (!isInElevationPanel(mx, my)) return false;
  ElevationLayout layout = buildElevationLayout();

  // Sea level
  if (layout.seaSlider.contains(mx, my)) {
    float t = sliderNorm(layout.seaSlider, mx);
    float newSea = lerp(-1.2f, 1.2f, t);
    if (abs(newSea - seaLevel) > 1e-6f) {
      seaLevel = newSea;
      markRenderDirty();
    }
    activeSlider = SLIDER_ELEV_SEA;
    return true;
  }

  // Brush radius
  if (layout.radiusSlider.contains(mx, my)) {
    float t = sliderNorm(layout.radiusSlider, mx);
    elevationBrushRadius = constrain(0.01f + t * (0.2f - 0.01f), 0.01f, 0.2f);
    activeSlider = SLIDER_ELEV_RADIUS;
    return true;
  }

  // Brush strength
  if (layout.strengthSlider.contains(mx, my)) {
    float t = sliderNorm(layout.strengthSlider, mx);
    elevationBrushStrength = constrain(0.005f + t * (0.2f - 0.005f), 0.005f, 0.2f);
    activeSlider = SLIDER_ELEV_STRENGTH;
    return true;
  }

  // Raise / Lower buttons
  if (queueButtonAction(layout.raiseBtn, new Runnable() { public void run() {
    elevationBrushRaise = true;
  }})) return true;
  if (queueButtonAction(layout.lowerBtn, new Runnable() { public void run() {
    elevationBrushRaise = false;
  }})) return true;

  // Noise scale slider
  if (layout.noiseSlider.contains(mx, my)) {
    float t = sliderNorm(layout.noiseSlider, mx);
    elevationNoiseScale = constrain(1.0f + t * (12.0f - 1.0f), 1.0f, 12.0f);
    activeSlider = SLIDER_ELEV_NOISE;
    return true;
  }

  // Generate button
  if (queueButtonAction(layout.perlinBtn, new Runnable() { public void run() {
    noiseSeed((int)random(Integer.MAX_VALUE));
    mapModel.generateElevationNoise(elevationNoiseScale, 1.0f, seaLevel);
  }})) return true;

  // Vary button
  if (queueButtonAction(layout.varyBtn, new Runnable() { public void run() {
    noiseSeed((int)random(Integer.MAX_VALUE));
    mapModel.addElevationVariation(elevationNoiseScale, 0.2f, seaLevel);
  }})) return true;

  // Plateaux button
  if (queueButtonAction(layout.plateauBtn, new Runnable() { public void run() {
    mapModel.makePlateaus(seaLevel);
  }})) return true;

  return false;
}










// Shared contour job types (must be top-level for Processing)
enum ContourJobType {
  COAST_DISTANCE,
  ELEVATION_SAMPLE
}

class MapModel {
  // Zone style constants
  final float ZONE_BASE_SAT = 0.78f;
  final float ZONE_BASE_BRI = 0.9f;
  // World bounds in world coordinates
  float minX = 0.0f;
  float minY = 0.0f;
  float maxX = 1.0f;
  float maxY = 1.0f;

  ArrayList<Site> sites = new ArrayList<Site>();
  ArrayList<Cell> cells = new ArrayList<Cell>();
  // Coast contour cache
  ContourGrid cachedCoastGrid = null;
  CoastSpatialIndex cachedCoastIndex = null;
  float cachedCoastSeaLevel = Float.MAX_VALUE;
  int cachedCoastCols = 0;
  int cachedCoastRows = 0;
  int cachedCoastCellCount = -1;
  boolean coastCacheValid = false;
  ContourGrid cachedElevationGrid = null;
  float cachedElevationSeaLevel = Float.MAX_VALUE;
  int cachedElevationCols = 0;
  int cachedElevationRows = 0;
  int cachedElevationCellCount = -1;
  boolean elevationCacheValid = false;

  ContourJob coastJob = null;
  ContourJob elevationJob = null;

  // Paths (roads, rivers, etc.)
  ArrayList<Path> paths = new ArrayList<Path>();
  ArrayList<PathType> pathTypes = new ArrayList<PathType>();

  // Biomes / zone types
  ArrayList<ZoneType> biomeTypes = new ArrayList<ZoneType>();
  ArrayList<MapZone> zones = new ArrayList<MapZone>();
  ArrayList<String> biomePatternFiles = new ArrayList<String>();
  int biomePatternCount = 1;

  // Cell adjacency (rebuilt when Voronoi is recomputed)
  ArrayList<ArrayList<Integer>> cellNeighbors = new ArrayList<ArrayList<Integer>>();

  ArrayList<Structure> structures = new ArrayList<Structure>();
  ArrayList<MapLabel> labels = new ArrayList<MapLabel>();

  // Lightweight instrumentation for UI display
  float lastPathfindMs = 0;
  int lastPathfindExpanded = 0;
  int lastPathfindLength = 0;
  boolean lastPathfindHit = false;
  float lastSnapBuildMs = 0;
  int lastSnapNodeCount = 0;
  int lastSnapEdgeCount = 0;

  boolean voronoiDirty = true;
  boolean snapDirty = true;
  ArrayList<Cell> preservedCells = null;
  VoronoiJob voronoiJob = null;
  float voronoiProgress = 0.0f;
  final int VORONOI_BATCH = 120; // sites per frame chunk

  HashMap<String, PVector> snapNodes = new HashMap<String, PVector>();
  HashMap<String, ArrayList<String>> snapAdj = new HashMap<String, ArrayList<String>>();

  MapRenderer renderer;

  MapModel() {
    // biomeTypes will be filled from Main.initBiomeTypes()
    renderer = new MapRenderer(this);
  }

  class MapZone {
    String name;
    int col;
    float hue01 = 0.0f;
    float sat01 = 0.5f;
    float bri01 = 0.9f;
    String comment = "";
    ArrayList<Integer> cells = new ArrayList<Integer>(); // indices into cells array

    MapZone(String name, int col) {
      this.name = name;
      float[] hsb = rgbToHSB(col);
      float[] sb = zoneBaseSatBri();
      hue01 = hsb[0];
      sat01 = sb[0];
      bri01 = sb[1];
      this.col = hsb01ToARGB(hue01, sat01, bri01, 1.0f);
    }

    public void updateColorFromHSB() {
      col = hsb01ToARGB(hue01, ZONE_BASE_SAT, ZONE_BASE_BRI, 1.0f);
      sat01 = ZONE_BASE_SAT;
      bri01 = ZONE_BASE_BRI;
  }
}

  public HashMap<String, Float> computeTaperWeightsForType(int typeId, float baseWeight, float minWeight) {
    HashMap<String, Float> weights = new HashMap<String, Float>();
    if (paths == null || paths.isEmpty()) return weights;
    PathType t = getPathType(typeId);
    if (t == null || !t.taperOn) return weights;
    ensureCellNeighborsComputed();

    // Build segment list and adjacency keyed by shared vertices
    class SegNode {
      int pIdx;
      int rIdx;
      int sIdx;
      PVector a;
      PVector b;
    }
    ArrayList<SegNode> segs = new ArrayList<SegNode>();
    HashMap<String, ArrayList<SegNode>> adj = new HashMap<String, ArrayList<SegNode>>();
    HashSet<String> waterVerts = new HashSet<String>();

    for (int pi = 0; pi < paths.size(); pi++) {
      Path p = paths.get(pi);
      if (p == null || p.typeId != typeId || p.routes == null) continue;
      for (int ri = 0; ri < p.routes.size(); ri++) {
        ArrayList<PVector> route = p.routes.get(ri);
        if (route == null || route.size() < 2) continue;
        for (int si = 0; si < route.size() - 1; si++) {
          PVector a = route.get(si);
          PVector b = route.get(si + 1);
          SegNode sn = new SegNode();
          sn.pIdx = pi;
          sn.rIdx = ri;
          sn.sIdx = si;
          sn.a = a;
          sn.b = b;
          segs.add(sn);

          String ka = keyFor(a.x, a.y);
          String kb = keyFor(b.x, b.y);
          if (pointTouchesWater(a.x, a.y, seaLevel)) waterVerts.add(ka);
          if (pointTouchesWater(b.x, b.y, seaLevel)) waterVerts.add(kb);
          adj.computeIfAbsent(ka, k -> new ArrayList<SegNode>()).add(sn);
          adj.computeIfAbsent(kb, k -> new ArrayList<SegNode>()).add(sn);
        }
      }
    }

    // BFS outward from any segment touching water
    HashMap<SegNode, Integer> closeness = new HashMap<SegNode, Integer>();
    ArrayDeque<SegNode> dq = new ArrayDeque<SegNode>();
    for (SegNode sn : segs) {
      String ka = keyFor(sn.a.x, sn.a.y);
      String kb = keyFor(sn.b.x, sn.b.y);
      if (waterVerts.contains(ka) || waterVerts.contains(kb)) {
        closeness.put(sn, 0);
        dq.add(sn);
      }
    }
    while (!dq.isEmpty()) {
      SegNode cur = dq.removeFirst();
      int baseC = closeness.get(cur);
      String[] keys = { keyFor(cur.a.x, cur.a.y), keyFor(cur.b.x, cur.b.y) };
      for (String k : keys) {
        ArrayList<SegNode> list = adj.get(k);
        if (list == null) continue;
        for (SegNode nb : list) {
          if (nb == cur) continue;
          int nc = baseC + 1;
          Integer prev = closeness.get(nb);
          if (prev == null || nc < prev) {
            closeness.put(nb, nc);
            dq.addLast(nb);
          }
        }
      }
    }

    float longestWaterChain = 0.0f;
    for (Integer c : closeness.values()) {
      longestWaterChain = max(longestWaterChain, c);
    }

    // Assign weights based on closeness (0 = touches water)
    for (SegNode sn : segs) {
      int c = closeness.containsKey(sn) ? closeness.get(sn) : 100;
      float tNorm = constrain(c / longestWaterChain, 0, 1);
      float w = lerp(baseWeight, minWeight, tNorm);
      String ek = sn.pIdx + ":" + sn.rIdx + ":" + sn.sIdx;
      weights.put(ek, w);
    }
    return weights;
  }

  public float[] rgbToHSB(int c) {
    // Convenience wrapper; both HSB helpers live in Types.pde and use 0..1 ranges.
    float[] hsb = new float[3];
    rgbToHSB01(c, hsb);
    return hsb;
  }

  public float[] zoneBaseSatBri() {
    float[] sb = new float[2];
    sb[0] = ZONE_BASE_SAT;
    sb[1] = ZONE_BASE_BRI;
    return sb;
  }

  public int zoneColorForHue(float hue) {
    float[] sb = zoneBaseSatBri();
    return hsb01ToARGB(hue, sb[0], sb[1], 1.0f);
  }

  public float hueDistance01(float a, float b) {
    float d = abs(a - b);
    return min(d, 1.0f - d);
  }

  // Pick a hue on the circle that maximizes the minimum distance to all existing hues.
  public float pickMaxGapHue() {
    if (zones == null || zones.isEmpty()) return 0.0f;
    ArrayList<Float> hs = new ArrayList<Float>();
    for (MapZone z : zones) {
      if (z == null) continue;
      float h = z.hue01 % 1.0f;
      if (h < 0) h += 1.0f;
      hs.add(h);
    }
    if (hs.isEmpty()) return 0.0f;

    // Sample the circle; 720 samples gives ~0.5 degree resolution.
    int samples = 720;
    float bestHue = 0.0f;
    float bestScore = -1.0f;
    for (int i = 0; i < samples; i++) {
      float h = i / (float)samples;
      float minD = 1.0f;
      for (float hz : hs) {
        minD = min(minD, hueDistance01(h, hz));
        if (minD < bestScore) break; // early exit if already worse
      }
      if (minD > bestScore) {
        bestScore = minD;
        bestHue = h;
      }
    }
    return bestHue;
  }

  // Van der Corput sequence in base 2 to spread hues: 0, 0.5, 0.25, 0.75, 0.125, ...
  public float distributedHueForIndex(int idx) {
    int n = max(0, idx);
    float v = 0;
    float denom = 2.0f;
    while (n > 0) {
      v += (n & 1) * (1.0f / denom);
      denom *= 2.0f;
      n >>= 1;
    }
    return v;
  }

  // ---------- Drawing ----------

  public void drawDebugWorldBounds(PApplet app) {
    renderer.drawDebugWorldBounds(app);
  }

  public void drawSites(PApplet app) {
    renderer.drawSites(app);
  }

  public void drawCells(PApplet app) {
    // Rendering methods take an explicit PApplet so we can target the main canvas or export buffers.
    renderer.drawCells(app);
  }

  public void drawCells(PApplet app, boolean showBorders) {
    renderer.drawCells(app, showBorders);
  }

  // Rendering-mode cell draw: keep underwater cells plain blue (no biome tint)
  public void drawCellsRender(PApplet app, boolean showBorders) {
    renderer.drawCellsRender(app, showBorders);
  }

  public void drawCellsRender(PApplet app, boolean showBorders, boolean desaturate) {
    renderer.drawCellsRender(app, showBorders, desaturate);
  }

  public void drawStructures(PApplet app) {
    renderer.drawStructures(app);
  }

  public void drawLabels(PApplet app) {
    renderer.drawLabels(app);
  }

  public void drawLabelsRender(PApplet app, RenderSettings s) {
    renderer.drawLabelsRender(app, s);
  }

  public void drawZoneLabelsRender(PApplet app, RenderSettings s) {
    renderer.drawZoneLabelsRender(app, s);
  }

  public void drawPathLabelsRender(PApplet app, RenderSettings s) {
    renderer.drawPathLabelsRender(app, s);
  }

  public void drawStructureLabelsRender(PApplet app, RenderSettings s) {
    renderer.drawStructureLabelsRender(app, s);
  }

  public void drawZoneOutlinesRender(PApplet app, RenderSettings s) {
    renderer.drawZoneOutlinesRender(app, s);
  }

  public void drawStructuresRender(PApplet app, RenderSettings s) {
    renderer.drawStructuresRender(app, s);
  }

  public void drawRenderAdvanced(PApplet app, RenderSettings settings, float seaLevel) {
    renderer.drawRenderAdvanced(app, settings, seaLevel);
  }

  public void drawZoneOutlines(PApplet app) {
    renderer.drawZoneOutlines(app);
  }

  public void drawCoastContourLines(PApplet app, float seaLevel, int lines, float spacingFactor) {
    if (cells == null || cells.isEmpty()) return;
    ensureCellNeighborsComputed();

    float worldW = maxX - minX;
    float worldH = maxY - minY;
    float desiredSpacing = max(1e-5f, min(worldW, worldH) * max(0.0f, spacingFactor));

    int cols = max(80, min(200, (int)(sqrt(max(1, cells.size())) * 1.0f)));
    int rows = cols;

    ContourGrid g = getCoastDistanceGrid(cols, rows, seaLevel);
    ArrayList<PVector[]> coastSegs = (cachedCoastIndex != null) ? cachedCoastIndex.segments : null;
    if (g == null) return;

    float maxWaterDist = g.max;
    if (maxWaterDist <= 1e-5f) {
      app.pushStyle();
      app.stroke(0);
      if (coastSegs != null) {
        for (PVector[] seg : coastSegs) app.line(seg[0].x, seg[0].y, seg[1].x, seg[1].y);
      }
      app.popStyle();
      return;
    }
    float spacing = min(desiredSpacing, maxWaterDist * 0.9f);
    spacing = max(spacing, maxWaterDist * 0.2f);

    app.pushStyle();
    app.stroke(0);
    app.noFill();
    float strokeW = 1.5f / max(1e-6f, viewport.zoom);
    app.strokeWeight(strokeW);

    if (coastSegs != null) {
      for (PVector[] seg : coastSegs) {
        app.line(seg[0].x, seg[0].y, seg[1].x, seg[1].y);
      }
    }

    if (lines > 1 && spacing > 1e-6f) {
      drawSignedContourSet(app, g, spacing, spacing, spacing, app.color(0), 1.5f);
    }
    app.popStyle();
  }

  public void drawStructureSnapGuides(PApplet app) {
    boolean useWater = snapWaterEnabled;
    boolean useBiomes = snapBiomesEnabled;
    boolean useUnderwater = snapUnderwaterBiomesEnabled;
    boolean useZones = snapZonesEnabled;
    boolean usePaths = snapPathsEnabled;
    boolean useStructures = snapStructuresEnabled;
    boolean useElevation = snapElevationEnabled && snapElevationDivisions > 0;
    if (!useWater && !useBiomes && !useUnderwater && !useZones && !usePaths && !useStructures && !useElevation) return;

    int[] zoneMembership = useZones ? buildZoneMembershipForSnapping() : null;
    int[] elevBuckets = useElevation ? buildElevationBucketsForSnapping(snapElevationDivisions) : null;
    renderer.drawStructureSnapGuides(app, useWater, useBiomes, useUnderwater, useZones,
                                     usePaths, useStructures, useElevation, zoneMembership, elevBuckets);
  }

  public float distSq(PVector a, PVector b) {
    float dx = a.x - b.x;
    float dy = a.y - b.y;
    return dx * dx + dy * dy;
  }

  public int[] buildZoneMembershipForSnapping() {
    if (cells == null || cells.isEmpty() || zones == null || zones.isEmpty()) return null;
    int n = cells.size();
    int[] membership = new int[n];
    Arrays.fill(membership, -1);
    for (int zi = 0; zi < zones.size(); zi++) {
      MapZone z = zones.get(zi);
      if (z == null || z.cells == null) continue;
      for (int ci : z.cells) {
        if (ci >= 0 && ci < n) {
          membership[ci] = zi;
        }
      }
    }
    return membership;
  }

  public int[] buildElevationBucketsForSnapping(int divisions) {
    if (cells == null || cells.isEmpty()) return null;
    int div = max(1, divisions);
    int n = cells.size();
    int[] buckets = new int[n];
    for (int i = 0; i < n; i++) {
      Cell c = cells.get(i);
      float t = (c != null) ? (c.elevation + 1.0f) * 0.5f : 0.5f;
      t = constrain(t, 0, 1);
      int bucket = min(div - 1, max(0, (int)floor(t * div)));
      buckets[i] = bucket;
    }
    return buckets;
  }

  public boolean boundaryActiveForSnapping(Cell a, Cell b, int idxA, int idxB,
                                    int[] zoneMembership, int[] elevBuckets,
                                    boolean useWater, boolean useBiomes, boolean useUnderwaterBiomes,
                                    boolean useZones, boolean useElevation) {
    if (a == null || b == null) return false;
    boolean aWater = (a.elevation < seaLevel);
    boolean bWater = (b.elevation < seaLevel);
    if (useWater && aWater != bWater) return true;
    if (useBiomes && !aWater && !bWater && a.biomeId != b.biomeId) return true;
    if (useUnderwaterBiomes && aWater && bWater && a.biomeId != b.biomeId) return true;
    if (useZones && zoneMembership != null &&
        idxA >= 0 && idxA < zoneMembership.length &&
        idxB >= 0 && idxB < zoneMembership.length &&
        zoneMembership[idxA] >= 0 && zoneMembership[idxB] >= 0 &&
        zoneMembership[idxA] != zoneMembership[idxB]) {
      return true;
    }
    if (useElevation && elevBuckets != null &&
        idxA >= 0 && idxA < elevBuckets.length &&
        idxB >= 0 && idxB < elevBuckets.length &&
        elevBuckets[idxA] != elevBuckets[idxB]) {
      return true;
    }
    return false;
  }

  class SegmentHit {
    PVector a;
    PVector b;
    PVector p;
    int pathIndex = -1;
    int routeIndex = -1;
    int segmentIndex = -1;
    int cellA = -1;
    int cellB = -1;
  }

  public Structure computeSnappedStructure(float wx, float wy, StructureAttributes attrs) {
    StructureAttributes at = (attrs != null) ? attrs : new StructureAttributes();
    Structure s = new Structure(wx, wy);
    at.applyTo(s);
    if (s.name == null || s.name.length() == 0) {
      s.name = useDefaultStructureNames ? "Struct " + (structures.size() + 1) : "";
    }
    if (s.snapBinding == null) s.snapBinding = new StructureSnapBinding();
    s.snapBinding.clear();
    // Keep magnetism roughly constant in screen space: smaller in world units when zoomed in.
    float snapRangePx = 20.0f;
    float snapRange = max(0.01f, snapRangePx / max(1e-3f, viewport.zoom));

    StructureSnapMode align = at.alignment;
    float angleAbs = at.angleRad;

    if (align == StructureSnapMode.NONE) {
      s.snapBinding.type = StructureSnapTargetType.NONE;
      s.snapBinding.snapAngleRad = lastStructureSnapAngle;
      s.angle = angleAbs;
      return s;
    }

    boolean usePaths = snapPathsEnabled;
    boolean useFrontiers = snapWaterEnabled || snapBiomesEnabled || snapUnderwaterBiomesEnabled || snapZonesEnabled || (snapElevationEnabled && snapElevationDivisions > 0);
    boolean useStructures = snapStructuresEnabled;
    int[] zoneMembership = useFrontiers && snapZonesEnabled ? buildZoneMembershipForSnapping() : null;
    int[] elevBuckets = (useFrontiers && snapElevationEnabled && snapElevationDivisions > 0)
                        ? buildElevationBucketsForSnapping(snapElevationDivisions)
                        : null;

    // Snap priority: paths > frontier guides (biome/water) > other structures
    SegmentHit seg = (usePaths) ? nearestPathSegmentHit(wx, wy, snapRange) : null;
    if (seg != null) {
      PVector a = seg.a;
      PVector b = seg.b;
      PVector p = seg.p;
      float dx = b.x - a.x;
      float dy = b.y - a.y;
      float ang = atan2(dy, dx);
      if (align == StructureSnapMode.ON_PATH) {
        s.x = p.x;
        s.y = p.y;
      } else {
        float nx = -sin(ang);
        float ny = cos(ang);
        float offset = s.size * 0.6f;
        // Flip side based on cursor side of the segment
        float side = (wx - p.x) * nx + (wy - p.y) * ny;
        if (side < 0) offset = -offset;
        s.x = p.x + nx * offset;
        s.y = p.y + ny * offset;
      }
      lastStructureSnapAngle = ang;
      s.angle = ang;
      s.snapBinding.type = StructureSnapTargetType.PATH;
      s.snapBinding.pathIndex = seg.pathIndex;
      s.snapBinding.routeIndex = seg.routeIndex;
      s.snapBinding.segmentIndex = seg.segmentIndex;
      s.snapBinding.segA = a.copy();
      s.snapBinding.segB = b.copy();
      s.snapBinding.snapPoint = p.copy();
      s.snapBinding.snapAngleRad = ang;
      return s;
    }

    SegmentHit guide = (useFrontiers)
      ? nearestFrontierSegmentHit(wx, wy, snapRange,
                                  snapWaterEnabled, snapBiomesEnabled, snapUnderwaterBiomesEnabled,
                                  snapZonesEnabled, snapElevationEnabled && elevBuckets != null,
                                  zoneMembership, elevBuckets)
      : null;
    if (guide != null) {
      PVector a = guide.a;
      PVector b = guide.b;
      PVector p = guide.p;
      float dx = b.x - a.x;
      float dy = b.y - a.y;
      float ang = atan2(dy, dx);
      if (align == StructureSnapMode.ON_PATH) {
        s.x = p.x;
        s.y = p.y;
      } else {
        float nx = -sin(ang);
        float ny = cos(ang);
        float offset = s.size * 0.6f;
        float side = (wx - p.x) * nx + (wy - p.y) * ny;
        if (side < 0) offset = -offset;
        s.x = p.x + nx * offset;
        s.y = p.y + ny * offset;
      }
      lastStructureSnapAngle = ang;
      s.angle = ang;
      s.snapBinding.type = StructureSnapTargetType.FRONTIER;
      s.snapBinding.cellA = guide.cellA;
      s.snapBinding.cellB = guide.cellB;
      s.snapBinding.segA = a.copy();
      s.snapBinding.segB = b.copy();
      s.snapBinding.snapPoint = p.copy();
      s.snapBinding.snapAngleRad = ang;
      return s;
    }

    // Next: snap to other structures (edge-to-edge)
    if (useStructures) {
      Structure closest = null;
      float bestD2 = snapRange * snapRange;
      for (Structure o : structures) {
        float dx = o.x - wx;
        float dy = o.y - wy;
        float d2 = dx * dx + dy * dy;
        if (d2 < bestD2) {
          bestD2 = d2;
          closest = o;
        }
      }
      if (closest != null) {
        // Snap edge-to-edge with a small margin so shapes don't overlap visually.
        float ang = atan2(wy - closest.y, wx - closest.x);
        float halfA = closest.size * 0.5f;
        float halfB = s.size * 0.5f;
        float margin = max(0.003f, min(halfA, halfB) * 0.12f);
        float targetDist = halfA + halfB + margin;
        s.x = closest.x + cos(ang) * targetDist;
        s.y = closest.y + sin(ang) * targetDist;
        lastStructureSnapAngle = ang;
        s.angle = ang;
        s.snapBinding.type = StructureSnapTargetType.STRUCTURE;
        s.snapBinding.structureIndex = structures.indexOf(closest);
        s.snapBinding.snapAngleRad = ang;
        s.snapBinding.snapPoint = new PVector(closest.x, closest.y);
        return s;
      }
    }

    s.snapBinding.type = StructureSnapTargetType.NONE;
    s.snapBinding.snapAngleRad = lastStructureSnapAngle;
    s.angle = angleAbs;
    return s;
  }

  public Structure computeSnappedStructure(float wx, float wy, float size) {
    StructureAttributes attrs = new StructureAttributes();
    attrs.size = size;
    attrs.angleRad = structureAngleOffsetRad;
    attrs.shape = structureShape;
    attrs.alignment = structureSnapMode;
    attrs.aspectRatio = structureAspectRatio;
    attrs.hue01 = structureHue01;
    attrs.sat01 = structureSat01;
    attrs.alpha01 = structureAlpha01;
    attrs.strokeWeightPx = structureStrokePx;
    attrs.name = structureNameDraft;
    return computeSnappedStructure(wx, wy, attrs);
  }

  public void drawElevationOverlay(PApplet app, float seaLevel, boolean showElevationContours, boolean drawWater, boolean drawElevation,
                            boolean showWaterContours, int quantSteps) {
    // Default: no lighting, just grayscale
    drawElevationOverlay(app, seaLevel, showElevationContours, drawWater, drawElevation, showWaterContours,
                         false, 135.0f, 45.0f, quantSteps);
  }

  public void drawElevationOverlay(PApplet app, float seaLevel, boolean showElevationContours, boolean drawWater, boolean drawElevation,
                            boolean showWaterContours, boolean useLighting, float lightAzimuthDeg, float lightAltitudeDeg, int quantSteps) {
    if (useNewElevationShading) {
      ElevationRenderer.drawOverlay(this, app, seaLevel, showElevationContours, drawWater, drawElevation,
                                    showWaterContours, useLighting, lightAzimuthDeg, lightAltitudeDeg, quantSteps);
    } else {
      drawElevationOverlayLegacy(app, seaLevel, showElevationContours, drawWater, drawElevation, showWaterContours,
                                 useLighting, lightAzimuthDeg, lightAltitudeDeg, quantSteps);
    }
  }

  public void drawElevationOverlayLegacy(PApplet app, float seaLevel, boolean showElevationContours, boolean drawWater, boolean drawElevation,
                                  boolean showWaterContours, boolean useLighting, float lightAzimuthDeg, float lightAltitudeDeg, int quantSteps) {
    if (cells == null) return;
    app.pushStyle();
    app.noStroke();

    PVector lightDir = null;
    if (useLighting) {
      float az = radians(lightAzimuthDeg);
      float alt = radians(lightAltitudeDeg);
      lightDir = new PVector(cos(alt) * cos(az), cos(alt) * sin(az), sin(alt));
      lightDir.normalize();
    }

    int cellCount = cells.size();
    for (int ci = 0; ci < cellCount; ci++) {
      Cell c = cells.get(ci);
      if (c.vertices == null || c.vertices.size() < 3) continue;
      float h = c.elevation;
      if (drawElevation) {
        float shade = constrain((h + 0.5f), 0, 1); // center on 0
        float light = 1.0f;
        if (useLighting && lightDir != null) {
          light = ElevationRenderer.computeLightForCell(this, ci, lightDir);
        }
        float litShade = constrain(shade * light, 0, 1);
        if (quantSteps > 1) {
          float levels = quantSteps - 1;
          litShade = round(litShade * levels) / levels;
        }
        int col = app.color(litShade * 255);
        app.fill(col, 140);
        app.beginShape();
        for (PVector v : c.vertices) app.vertex(v.x, v.y);
        app.endShape(CLOSE);
      }

      if (drawWater && h < seaLevel) {
        float depth = seaLevel - h;
        float depthNorm = constrain(depth / 1.0f, 0, 1);
        float shade = drawElevation ? lerp(0.25f, 0.65f, 1.0f - depthNorm) : 0.55f;
        if (quantSteps > 1) {
          float levels = quantSteps - 1;
          shade = round(shade * levels) / levels;
        }
        float baseR = 30;
        float baseG = 70;
        float baseB = 120;
        int water;
        water = app.color(baseR * shade, baseG * shade, baseB * shade, 255);
        app.fill(water);
        app.beginShape();
        for (PVector v : c.vertices) app.vertex(v.x, v.y);
        app.endShape(CLOSE);
      }
    }

    if (showElevationContours || showWaterContours) {
      int cols = 90;
      int rows = 90;
      ContourGrid grid = sampleElevationGrid(cols, rows, seaLevel);
      float minElev = grid.min;
      float maxElev = grid.max;

      if (showElevationContours) {
        float range = max(1e-4f, maxElev - seaLevel);
        float step = max(0.02f, range / 10.0f);
        float start = ceil(seaLevel / step) * step;
        int strokeCol = app.color(50, 50, 50, 180);
        drawContourSet(app, grid, start, maxElev, step, strokeCol);
      }

      if (showWaterContours && drawWater) {
        float minWater = minElev;
        if (minWater < seaLevel - 1e-4f) {
          float depthRange = seaLevel - minWater;
          float step = max(0.02f, depthRange / 5.0f);
          float start = seaLevel - step;
          int strokeCol = app.color(30, 70, 140, 170);
          drawContourSet(app, grid, start, minWater, -step, strokeCol);
        }
      }
    }
    app.popStyle();
  }

  class ContourGrid {
    float[][] v;
    int cols;
    int rows;
    float dx;
    float dy;
    float ox;
    float oy;
    float min;
    float max;
  }

  class ContourJob {
    ContourJobType type;
    ContourGrid grid;
    CoastSpatialIndex coastIndex;
    float seaLevel;
    int cols;
    int rows;
    int nextRow = 0;
    int cellCountSnapshot = 0;
    boolean done = false;
    boolean failed = false;

    ContourJob(ContourJobType type, int cols, int rows, float seaLevel) {
      this.type = type;
      this.cols = max(2, cols);
      this.rows = max(2, rows);
      this.seaLevel = seaLevel;
      this.cellCountSnapshot = (cells != null) ? cells.size() : 0;

      grid = new ContourGrid();
      grid.cols = this.cols;
      grid.rows = this.rows;
      grid.v = new float[grid.rows][grid.cols];
      grid.ox = minX;
      grid.oy = minY;
      grid.dx = (maxX - minX) / (grid.cols - 1);
      grid.dy = (maxY - minY) / (grid.rows - 1);
      grid.min = Float.MAX_VALUE;
      grid.max = -Float.MAX_VALUE;

      if (type == ContourJobType.COAST_DISTANCE) {
        ensureCellNeighborsComputed();
        ArrayList<PVector[]> segs = collectCoastSegments(seaLevel);
        if (segs == null || segs.isEmpty()) {
          failed = true;
          done = true;
          return;
        }
        coastIndex = new CoastSpatialIndex(minX, minY, maxX, maxY, segs, 80);
      }
    }

    public boolean matches(ContourJobType t, int c, int r, float sl) {
      return type == t && cols == max(2, c) && rows == max(2, r) && abs(sl - seaLevel) < 1e-6f;
    }

    public float progress() {
      if (grid == null || grid.rows <= 0) return 0;
      return constrain(nextRow / max(1.0f, (float)grid.rows), 0, 1);
    }

    public void step(int maxMillis) {
      if (done || grid == null) return;
      long deadline = System.nanoTime() + max(1, maxMillis) * 1_000_000L;
      while (nextRow < grid.rows && System.nanoTime() < deadline) {
        float y = grid.oy + nextRow * grid.dy;
        if (type == ContourJobType.COAST_DISTANCE) {
          if (coastIndex == null) { failed = true; done = true; break; }
          for (int i = 0; i < grid.cols; i++) {
            float x = grid.ox + i * grid.dx;
            boolean water = sampleElevationAt(x, y, seaLevel) < seaLevel;
            float d = coastIndex.nearestDist(x, y);
            float val = water ? d : -d;
            grid.v[nextRow][i] = val;
            grid.min = min(grid.min, val);
            grid.max = max(grid.max, val);
          }
        } else {
          for (int i = 0; i < grid.cols; i++) {
            float x = grid.ox + i * grid.dx;
            float val = sampleElevationAt(x, y, seaLevel);
            grid.v[nextRow][i] = val;
            grid.min = min(grid.min, val);
            grid.max = max(grid.max, val);
          }
        }
        nextRow++;
      }
      if (nextRow >= grid.rows) {
        done = true;
      }
    }
  }

  public ContourGrid sampleElevationGrid(int cols, int rows, float fallback) {
    return renderer.sampleElevationGrid(cols, rows, fallback);
  }

  public void drawContourSet(PApplet app, ContourGrid g, float start, float end, float step, int strokeCol) {
    renderer.drawContourSet(app, g, start, end, step, strokeCol);
  }

  public void drawIsoLine(PApplet app, ContourGrid g, float iso) {
    renderer.drawIsoLine(app, g, iso);
  }

  public void drawSeg(PApplet app, PVector a, PVector b) {
    renderer.drawSeg(app, a, b);
  }

  public PVector interpIso(float x0, float y0, float v0, float x1, float y1, float v1, float iso) {
    return renderer.interpIso(x0, y0, v0, x1, y1, v1, iso);
  }

  public HashMap<String, PVector[]> edgeMapForCell(Cell c) {
    HashMap<String, PVector[]> map = new HashMap<String, PVector[]>();
    if (c == null || c.vertices == null) return map;
    int vc = c.vertices.size();
    for (int i = 0; i < vc; i++) {
      PVector a = c.vertices.get(i);
      PVector b = c.vertices.get((i + 1) % vc);
      map.put(undirectedEdgeKey(a, b), new PVector[] { a, b });
    }
    return map;
  }

  public String undirectedEdgeKey(PVector a, PVector b) {
    int scale = 100000;
    int ax = round(a.x * scale);
    int ay = round(a.y * scale);
    int bx = round(b.x * scale);
    int by = round(b.y * scale);
    if (ax < bx || (ax == bx && ay <= by)) {
      return ax + "," + ay + "-" + bx + "," + by;
    } else {
      return bx + "," + by + "-" + ax + "," + ay;
    }
  }

  public PVector[] sharedEdgeBetweenCells(Cell a, Cell b) {
    if (a == null || b == null || a.vertices == null || b.vertices == null) return null;
    int va = a.vertices.size();
    int vb = b.vertices.size();
    for (int i = 0; i < va; i++) {
      PVector a0 = a.vertices.get(i);
      PVector a1 = a.vertices.get((i + 1) % va);
      for (int j = 0; j < vb; j++) {
        PVector b0 = b.vertices.get(j);
        PVector b1 = b.vertices.get((j + 1) % vb);
        boolean match = (distSq(a0, b0) < 1e-10f && distSq(a1, b1) < 1e-10f) ||
                        (distSq(a0, b1) < 1e-10f && distSq(a1, b0) < 1e-10f);
        if (match) return new PVector[] { a0, a1 };
      }
    }
    return null;
  }

  public float cross2d(PVector a, PVector b, PVector c) {
    return (b.x - a.x) * (c.y - a.y) - (b.y - a.y) * (c.x - a.x);
  }

  public boolean onSegment(PVector a, PVector b, PVector p, float eps) {
    float minx = min(a.x, b.x) - eps;
    float maxx = max(a.x, b.x) + eps;
    float miny = min(a.y, b.y) - eps;
    float maxy = max(a.y, b.y) + eps;
    return abs(cross2d(a, b, p)) <= eps && p.x >= minx && p.x <= maxx && p.y >= miny && p.y <= maxy;
  }

  public boolean segmentsIntersect(PVector a1, PVector a2, PVector b1, PVector b2, float eps) {
    float o1 = cross2d(a1, a2, b1);
    float o2 = cross2d(a1, a2, b2);
    float o3 = cross2d(b1, b2, a1);
    float o4 = cross2d(b1, b2, a2);

    if ((o1 > 0 && o2 < 0 || o1 < 0 && o2 > 0) && (o3 > 0 && o4 < 0 || o3 < 0 && o4 > 0)) {
      return true;
    }

    if (abs(o1) <= eps && onSegment(a1, a2, b1, eps)) return true;
    if (abs(o2) <= eps && onSegment(a1, a2, b2, eps)) return true;
    if (abs(o3) <= eps && onSegment(b1, b2, a1, eps)) return true;
    if (abs(o4) <= eps && onSegment(b1, b2, a2, eps)) return true;

    return false;
  }

  public ArrayList<PVector[]> collectCoastSegments(float seaLevel) {
    ArrayList<PVector[]> segs = new ArrayList<PVector[]>();
    if (cells == null || cells.isEmpty()) return segs;
    int n = cells.size();
    for (int ci = 0; ci < n; ci++) {
      Cell a = cells.get(ci);
      if (a == null || a.vertices == null) continue;
      boolean waterA = a.elevation < seaLevel;
      ArrayList<Integer> nbs = (ci < cellNeighbors.size()) ? cellNeighbors.get(ci) : null;
      if (nbs == null) continue;
      HashSet<String> seen = new HashSet<String>();
      for (int nb : nbs) {
        if (nb < 0 || nb >= n || nb <= ci) continue;
        Cell b = cells.get(nb);
        if (b == null || b.vertices == null) continue;
        boolean waterB = b.elevation < seaLevel;
        if (waterA == waterB) continue;

        // find shared edges
        int va = a.vertices.size();
        for (int i = 0; i < va; i++) {
          PVector p0 = a.vertices.get(i);
          PVector p1 = a.vertices.get((i + 1) % va);
          String key = undirectedEdgeKey(p0, p1);
          if (seen.contains(key)) continue;
          int vb = b.vertices.size();
          for (int j = 0; j < vb; j++) {
            PVector q0 = b.vertices.get(j);
            PVector q1 = b.vertices.get((j + 1) % vb);
            if (distSq(p0, q0) < 1e-10f && distSq(p1, q1) < 1e-10f ||
                distSq(p0, q1) < 1e-10f && distSq(p1, q0) < 1e-10f) {
              segs.add(new PVector[] { p0.copy(), p1.copy() });
              seen.add(key);
              break;
            }
          }
        }
      }
    }
    return segs;
  }

  public ContourGrid sampleCoastDistanceGrid(int cols, int rows, float seaLevel, CoastSpatialIndex idx) {
    if (idx == null) return null;
    ContourGrid g = new ContourGrid();
    g.cols = max(2, cols);
    g.rows = max(2, rows);
    g.v = new float[g.rows][g.cols];
    g.ox = minX;
    g.oy = minY;
    g.dx = (maxX - minX) / (g.cols - 1);
    g.dy = (maxY - minY) / (g.rows - 1);
    g.min = Float.MAX_VALUE;
    g.max = -Float.MAX_VALUE;

    for (int j = 0; j < g.rows; j++) {
      float y = g.oy + j * g.dy;
      for (int i = 0; i < g.cols; i++) {
        float x = g.ox + i * g.dx;
        boolean water = sampleElevationAt(x, y, seaLevel) < seaLevel;
        float d = idx.nearestDist(x, y);
        float val = water ? d : -d;
        g.v[j][i] = val;
        g.min = min(g.min, val);
        g.max = max(g.max, val);
      }
    }
    return g;
  }

  public ContourGrid getCoastDistanceGrid(int cols, int rows, float seaLevel) {
    if (cells == null || cells.isEmpty()) return null;
    if (coastCacheValid &&
        cachedCoastSeaLevel == seaLevel &&
        cachedCoastCols == cols &&
        cachedCoastRows == rows &&
        cachedCoastCellCount == cells.size()) {
      return cachedCoastGrid;
    }
    if (coastJob != null && coastJob.matches(ContourJobType.COAST_DISTANCE, cols, rows, seaLevel)) {
      return null;
    }
    coastJob = new ContourJob(ContourJobType.COAST_DISTANCE, cols, rows, seaLevel);
    return null;
  }

  public ContourGrid getElevationGridForRender(int cols, int rows, float seaLevel) {
    if (cells == null || cells.isEmpty()) return null;
    if (elevationCacheValid &&
        cachedElevationSeaLevel == seaLevel &&
        cachedElevationCols == cols &&
        cachedElevationRows == rows &&
        cachedElevationCellCount == cells.size()) {
      return cachedElevationGrid;
    }
    if (elevationJob != null && elevationJob.matches(ContourJobType.ELEVATION_SAMPLE, cols, rows, seaLevel)) {
      return null;
    }
    elevationJob = new ContourJob(ContourJobType.ELEVATION_SAMPLE, cols, rows, seaLevel);
    return null;
  }

  public void stepContourJobs(int maxMillis) {
    int budget = max(1, maxMillis);
    if (coastJob != null) {
      coastJob.step(budget);
      if (coastJob.done) finalizeCoastJob();
    }
    if (elevationJob != null) {
      elevationJob.step(budget);
      if (elevationJob.done) finalizeElevationJob();
    }
  }

  public boolean isContourJobRunning() {
    return (coastJob != null && !coastJob.done) || (elevationJob != null && !elevationJob.done);
  }

  public float getContourJobProgress() {
    float p = 1.0f;
    if (coastJob != null && !coastJob.done) p = min(p, coastJob.progress());
    if (elevationJob != null && !elevationJob.done) p = min(p, elevationJob.progress());
    return p;
  }

  private void finalizeCoastJob() {
    if (coastJob == null) return;
    if (coastJob.failed || coastJob.grid == null || coastJob.cellCountSnapshot != ((cells != null) ? cells.size() : 0)) {
      cachedCoastGrid = null;
      cachedCoastIndex = null;
      coastCacheValid = true;
      cachedCoastSeaLevel = coastJob.seaLevel;
      cachedCoastCols = coastJob.cols;
      cachedCoastRows = coastJob.rows;
      cachedCoastCellCount = coastJob.cellCountSnapshot;
    } else {
      cachedCoastGrid = coastJob.grid;
      cachedCoastIndex = coastJob.coastIndex;
      cachedCoastSeaLevel = coastJob.seaLevel;
      cachedCoastCols = coastJob.cols;
      cachedCoastRows = coastJob.rows;
      cachedCoastCellCount = coastJob.cellCountSnapshot;
      coastCacheValid = true;
    }
    coastJob = null;
  }

  private void finalizeElevationJob() {
    if (elevationJob == null) return;
    if (elevationJob.failed || elevationJob.grid == null || elevationJob.cellCountSnapshot != ((cells != null) ? cells.size() : 0)) {
      cachedElevationGrid = null;
      elevationCacheValid = true;
      cachedElevationSeaLevel = elevationJob.seaLevel;
      cachedElevationCols = elevationJob.cols;
      cachedElevationRows = elevationJob.rows;
      cachedElevationCellCount = elevationJob.cellCountSnapshot;
    } else {
      cachedElevationGrid = elevationJob.grid;
      cachedElevationSeaLevel = elevationJob.seaLevel;
      cachedElevationCols = elevationJob.cols;
      cachedElevationRows = elevationJob.rows;
      cachedElevationCellCount = elevationJob.cellCountSnapshot;
      elevationCacheValid = true;
    }
    elevationJob = null;
  }

  public void drawSignedContourSet(PApplet app, ContourGrid g, float start, float end, float step, int strokeCol, float strokePx) {
    if (step == 0) return;
    if ((step > 0 && start > end) || (step < 0 && start < end)) return;
    app.pushStyle();
    app.noFill();
    app.stroke(strokeCol);
    app.strokeWeight(strokePx / max(1e-6f, viewport.zoom));
    if (step > 0) {
      for (float iso = start; iso <= end + 1e-6f; iso += step) {
        renderer.drawIsoLine(app, g, iso);
      }
    } else {
      for (float iso = start; iso >= end - 1e-6f; iso += step) {
        renderer.drawIsoLine(app, g, iso);
      }
    }
    app.popStyle();
  }

  class CoastSpatialIndex {
    float ox, oy, dx, dy;
    int cols, rows;
    ArrayList<ArrayList<PVector[]>> bins;
    ArrayList<PVector[]> segments;

    CoastSpatialIndex(float minX, float minY, float maxX, float maxY, ArrayList<PVector[]> segs, int targetBins) {
      ox = minX;
      oy = minY;
      float w = maxX - minX;
      float h = maxY - minY;
      float cellsPerDim = max(4, targetBins);
      cols = max(4, (int)cellsPerDim);
      rows = cols;
      dx = w / cols;
      dy = h / rows;
      bins = new ArrayList<ArrayList<PVector[]>>(cols * rows);
      for (int i = 0; i < cols * rows; i++) bins.add(new ArrayList<PVector[]>());
      segments = segs;
      indexSegments();
    }

    public void indexSegments() {
      for (PVector[] seg : segments) {
        PVector a = seg[0];
        PVector b = seg[1];
        float minX = min(a.x, b.x);
        float maxX = max(a.x, b.x);
        float minY = min(a.y, b.y);
        float maxY = max(a.y, b.y);
        int ix0 = clampBin(floor((minX - ox) / dx), cols);
        int ix1 = clampBin(floor((maxX - ox) / dx), cols);
        int iy0 = clampBin(floor((minY - oy) / dy), rows);
        int iy1 = clampBin(floor((maxY - oy) / dy), rows);
        for (int iy = iy0; iy <= iy1; iy++) {
          for (int ix = ix0; ix <= ix1; ix++) {
            bin(ix, iy).add(seg);
          }
        }
      }
    }

    public int clampBin(int v, int maxVal) {
      return constrain(v, 0, maxVal - 1);
    }

    public ArrayList<PVector[]> bin(int x, int y) {
      return bins.get(y * cols + x);
    }

    public float nearestDist(float x, float y) {
      int ix = clampBin(floor((x - ox) / dx), cols);
      int iy = clampBin(floor((y - oy) / dy), rows);
      float best = Float.MAX_VALUE;
      int maxRing = max(cols, rows);
      for (int ring = 0; ring < maxRing; ring++) {
        int x0 = max(0, ix - ring);
        int x1 = min(cols - 1, ix + ring);
        int y0 = max(0, iy - ring);
        int y1 = min(rows - 1, iy + ring);
        boolean found = false;
        for (int yy = y0; yy <= y1; yy++) {
          for (int xx = x0; xx <= x1; xx++) {
            ArrayList<PVector[]> bucket = bin(xx, yy);
            for (PVector[] seg : bucket) {
              float d = pointSegDist(x, y, seg[0], seg[1]);
              if (d < best) {
                best = d;
                found = true;
              }
            }
          }
        }
        if (found && best < max(dx, dy) * ring) break;
      }
      // Fallback if no bins
      if (best == Float.MAX_VALUE) {
        for (PVector[] seg : segments) {
          best = min(best, pointSegDist(x, y, seg[0], seg[1]));
        }
      }
      return best;
    }

    public float pointSegDist(float px, float py, PVector a, PVector b) {
      float vx = b.x - a.x;
      float vy = b.y - a.y;
      float wx = px - a.x;
      float wy = py - a.y;
      float c1 = vx * wx + vy * wy;
      if (c1 <= 0) return sqrt(wx * wx + wy * wy);
      float c2 = vx * vx + vy * vy;
      if (c2 <= c1) {
        float dx = px - b.x;
        float dy = py - b.y;
        return sqrt(dx * dx + dy * dy);
      }
      float t = c1 / c2;
      float projX = a.x + t * vx;
      float projY = a.y + t * vy;
      float dx = px - projX;
      float dy = py - projY;
      return sqrt(dx * dx + dy * dy);
    }
  }

  // ---------- Snapping graph ----------

  public ArrayList<PVector> getSnapPoints() {
    ensureSnapGraph();
    ArrayList<PVector> result = new ArrayList<PVector>();
    if (snapNodes.isEmpty()) return result;

    // Only keep points near the current viewport and dedupe points that are closer
    // than a small screen-space threshold to reduce overload when there are many sites.
    float marginPx = 20.0f;
    float tolPx = 4.0f;
    float tolWorld = tolPx / viewport.zoom;
    float halfW = (width * 0.5f) / viewport.zoom + marginPx / viewport.zoom;
    float halfH = (height * 0.5f) / viewport.zoom + marginPx / viewport.zoom;
    float minX = viewport.centerX - halfW;
    float maxX = viewport.centerX + halfW;
    float minY = viewport.centerY - halfH;
    float maxY = viewport.centerY + halfH;

    HashMap<String, PVector> dedup = new HashMap<String, PVector>();
    for (PVector p : snapNodes.values()) {
      if (p.x < minX || p.x > maxX || p.y < minY || p.y > maxY) continue;
      int gx = floor(p.x / tolWorld);
      int gy = floor(p.y / tolWorld);
      String key = gx + "_" + gy;
      if (!dedup.containsKey(key)) {
        dedup.put(key, p);
      }
    }
    result.addAll(dedup.values());
    return result;
  }

  public ArrayList<PVector> findSnapPath(PVector from, PVector toP) {
    return findSnapPathWeighted(from, toP, false);
  }

  public ArrayList<PVector> findSnapPathFlattest(PVector from, PVector toP) {
    return findSnapPathWeighted(from, toP, true);
  }

  public ArrayList<PVector> findSnapPathWeighted(PVector from, PVector toP, boolean favorFlat) {
    int tStart = millis();
    ensureSnapGraph();
    String kFrom = keyFor(from.x, from.y);
    String kTo = keyFor(toP.x, toP.y);
    ArrayList<PVector> result = null;
    if (!snapNodes.containsKey(kFrom) || !snapNodes.containsKey(kTo)) {
      lastPathfindMs = millis() - tStart;
      lastPathfindExpanded = 0;
      lastPathfindLength = 0;
      lastPathfindHit = false;
      return null;
    }
    if (kFrom.equals(kTo)) {
      result = new ArrayList<PVector>();
      PVector p = snapNodes.get(kFrom);
      result.add(p);
      result.add(p.copy()); // ensure at least two points so segments can be added
      lastPathfindMs = millis() - tStart;
      lastPathfindExpanded = 0;
      lastPathfindLength = result.size();
      lastPathfindHit = (result.size() > 1);
      return result;
    }

    if (PATH_BIDIRECTIONAL) {
      result = findSnapPathBidirectional(kFrom, kTo, favorFlat, snapNodes, snapAdj);
      lastPathfindMs = millis() - tStart;
      lastPathfindHit = (result != null && result.size() > 1);
      lastPathfindLength = (result != null) ? result.size() : 0;
      return result;
    }

    HashMap<String, Float> dist = new HashMap<String, Float>();
    HashMap<String, String> prev = new HashMap<String, String>();
    PriorityQueue<NodeDist> pq = new PriorityQueue<NodeDist>();
    dist.put(kFrom, 0.0f);
    // A* priority = g + h
    PVector target = snapNodes.get(kTo);
    float hStart = (target != null) ? distSq(snapNodes.get(kFrom), target) : 0;
    pq.add(new NodeDist(kFrom, 0.0f, hStart));

    // Spatial cull to a loose bounding box around endpoints
    float minx = min(from.x, toP.x);
    float maxx = max(from.x, toP.x);
    float miny = min(from.y, toP.y);
    float maxy = max(from.y, toP.y);
    float margin = max(dist2D(from, toP) * 0.6f, 0.05f);
    minx -= margin; maxx += margin; miny -= margin; maxy += margin;

    int maxExpanded = PATH_MAX_EXPANSIONS;
    int expanded = 0;
    String closest = kFrom;
    float bestH = (target != null) ? dist2D(snapNodes.get(kFrom), target) : Float.MAX_VALUE;
    HashMap<String, Float> elevCache = new HashMap<String, Float>();

    while (!pq.isEmpty()) {
      NodeDist nd = pq.poll();
      Float bestD = dist.get(nd.k);
      if (bestD != null && nd.g > bestD + 1e-6f) continue;
      if (nd.k.equals(kTo)) break;
      if (expanded++ > maxExpanded) break;
      ArrayList<String> neighbors = snapAdj.get(nd.k);
      if (neighbors == null) continue;
      PVector p = snapNodes.get(nd.k);
      if (p == null) continue;
      float hCur = (target != null) ? distSq(p, target) : Float.MAX_VALUE;
      if (hCur < bestH) {
        bestH = hCur;
        closest = nd.k;
      }
      for (String nb : neighbors) {
        PVector np = snapNodes.get(nb);
        if (np == null) continue;
        if (np.x < minx || np.x > maxx || np.y < miny || np.y > maxy) continue;
        float w = dist2D(p, np);
        float elevA = elevCache.containsKey(nd.k) ? elevCache.get(nd.k) : sampleElevationAt(p.x, p.y, seaLevel);
        float elevB = elevCache.containsKey(nb) ? elevCache.get(nb) : sampleElevationAt(np.x, np.y, seaLevel);
        elevCache.put(nd.k, elevA);
        elevCache.put(nb, elevB);
        if (pathAvoidWater) {
          boolean aw = elevA < seaLevel;
          boolean bw = elevB < seaLevel;
          if (aw || bw) {
            // Make water extremely undesirable; only used if no land path exists
            w *= 1e6f;
          }
        }
        if (favorFlat) {
          float dh = abs(elevB - elevA);
          // Penalize steep changes; keep distance as base
          w *= (1.0f + dh * flattestSlopeBias);
        }
        float ndist = nd.g + w;
        Float curD = dist.get(nb);
        if (curD == null || ndist < curD - 1e-6f) {
          dist.put(nb, ndist);
          prev.put(nb, nd.k);
          float h = (target != null) ? distSq(np, target) : 0;
          pq.add(new NodeDist(nb, ndist, ndist + h * 0.5f)); // squared heuristic, lighter weight
        }
      }
    }

    if (!prev.containsKey(kTo) && !kFrom.equals(kTo)) {
      if (closest != null) {
        if (closest.equals(kFrom)) {
          result = new ArrayList<PVector>();
          result.add(snapNodes.get(kFrom));
        } else if (prev.containsKey(closest)) {
          result = reconstructPath(prev, kFrom, closest);
        }
      }
    } else {
      result = reconstructPath(prev, kFrom, kTo);
    }

    lastPathfindMs = millis() - tStart;
    lastPathfindExpanded = expanded;
    lastPathfindLength = (result != null) ? result.size() : 0;
    lastPathfindHit = (result != null && result.size() > 1);
    return result;
  }

  public void ensureSnapGraph() {
    if (!snapDirty) return;
    recomputeSnappingGraph();
    snapDirty = false;
  }

  public void recomputeSnappingGraph() {
    int tStart = millis();
    snapNodes.clear();
    snapAdj.clear();
    if (sites == null || cells == null) return;

    String[] centerKeys = new String[sites.size()];

    // Add centers
    for (int i = 0; i < sites.size(); i++) {
      Site s = sites.get(i);
      centerKeys[i] = ensureNode(s.x, s.y);
    }

    // Connect centers to vertices and polygon edges
    for (Cell c : cells) {
      if (c.vertices == null || c.vertices.size() == 0) continue;
      String centerKey = (c.siteIndex >= 0 && c.siteIndex < centerKeys.length)
        ? centerKeys[c.siteIndex]
        : ensureNode(c.vertices.get(0).x, c.vertices.get(0).y);
      int n = c.vertices.size();
      if (n < 2) continue;
      for (int i = 0; i < n; i++) {
        PVector v = c.vertices.get(i);
        PVector vn = c.vertices.get((i + 1) % n);

        String vk = ensureNode(v.x, v.y);
        String vnk = ensureNode(vn.x, vn.y);

        connectNodes(centerKey, vk);
        connectNodes(vk, vnk);
      }
    }

    // Connect neighboring centers (cells sharing edge) using the precomputed neighbor list
    ensureCellNeighborsComputed();
    int cCount = cells.size();
    for (int i = 0; i < cCount; i++) {
      ArrayList<Integer> nbs = (i < cellNeighbors.size()) ? cellNeighbors.get(i) : null;
      if (nbs == null) continue;
      Cell a = cells.get(i);
      for (int nb : nbs) {
        if (nb <= i) continue;
        Cell b = cells.get(nb);
        if (a != null && b != null &&
            a.siteIndex >= 0 && a.siteIndex < centerKeys.length &&
            b.siteIndex >= 0 && b.siteIndex < centerKeys.length) {
          connectNodes(centerKeys[a.siteIndex], centerKeys[b.siteIndex]);
        }
      }
    }

    pruneUniformFrontierSnapNodes();

    lastSnapNodeCount = snapNodes.size();
    int edgeSum = 0;
    for (ArrayList<String> adj : snapAdj.values()) {
      if (adj != null) edgeSum += adj.size();
    }
    lastSnapEdgeCount = edgeSum / 2; // undirected graph stored twice
    lastSnapBuildMs = millis() - tStart;
  }

  public String ensureNode(float x, float y) {
    String k = keyFor(x, y);
    if (!snapNodes.containsKey(k)) {
      snapNodes.put(k, new PVector(x, y));
      snapAdj.put(k, new ArrayList<String>());
    }
    return k;
  }

  public void connectNodes(String a, String b) {
    if (a == null || b == null) return;
    if (a.equals(b)) return;
    ArrayList<String> la = snapAdj.get(a);
    ArrayList<String> lb = snapAdj.get(b);
    if (la == null || lb == null) return;
    if (!la.contains(b)) la.add(b);
    if (!lb.contains(a)) lb.add(a);
  }

  public void pruneUniformFrontierSnapNodes() {
    if (cells == null || cells.isEmpty()) return;
    ensureCellNeighborsComputed();

    // Collect which cells touch each snap node
    HashMap<String, ArrayList<Integer>> nodeCells = new HashMap<String, ArrayList<Integer>>();
    for (int ci = 0; ci < cells.size(); ci++) {
      Cell c = cells.get(ci);
      if (c.vertices == null) continue;
      for (PVector v : c.vertices) {
        String k = keyFor(v.x, v.y);
        ArrayList<Integer> list = nodeCells.get(k);
        if (list == null) {
          list = new ArrayList<Integer>();
          nodeCells.put(k, list);
        }
        if (!list.contains(ci)) list.add(ci);
      }
    }

    HashSet<String> toRemove = new HashSet<String>();
    for (String k : snapNodes.keySet()) {
      ArrayList<Integer> incident = nodeCells.get(k);
      if (incident == null || incident.isEmpty()) continue;

      int firstIdx = incident.get(0);
      Cell first = cells.get(firstIdx);
      int biome = first.biomeId;
      boolean water = first.elevation < seaLevel;
      boolean allSame = true;
      for (int i = 1; i < incident.size(); i++) {
        Cell c = cells.get(incident.get(i));
        if (c.biomeId != biome || (c.elevation < seaLevel) != water) {
          allSame = false;
          break;
        }
      }
      if (allSame) {
        toRemove.add(k);
      }
    }

    if (toRemove.isEmpty()) return;

    for (String k : toRemove) {
      snapNodes.remove(k);
      snapAdj.remove(k);
    }
    for (ArrayList<String> adj : snapAdj.values()) {
      adj.removeAll(toRemove);
    }
  }

  public ArrayList<PVector> reconstructPath(HashMap<String, String> prev, String start, String goal) {
    ArrayList<PVector> out = new ArrayList<PVector>();
    String cur = goal;
    while (cur != null) {
      PVector p = snapNodes.get(cur);
      if (p != null) out.add(0, p);
      if (cur.equals(start)) break;
      cur = prev.get(cur);
    }
    return out;
  }

  public String keyFor(float x, float y) {
    int xi = round(x * 10000.0f);
    int yi = round(y * 10000.0f);
    return xi + ":" + yi;
  }

  public PVector parseKey(String k) {
    if (k == null) return null;
    String[] parts = split(k, ':');
    if (parts == null || parts.length != 2) return null;
    try {
      float x = Integer.parseInt(parts[0]) / 10000.0f;
      float y = Integer.parseInt(parts[1]) / 10000.0f;
      return new PVector(x, y);
    } catch (Exception e) {
      return null;
    }
  }

  public float sampleElevationAt(float x, float y, float fallback) {
    Cell c = findCellContaining(x, y);
    if (c != null) return c.elevation;
    return fallback;
  }

  public float dist2D(PVector a, PVector b) {
    float dx = a.x - b.x;
    float dy = a.y - b.y;
    return sqrt(dx * dx + dy * dy);
  }

  class NodeDist implements Comparable<NodeDist> {
    String k;
    float g;
    float f;
    NodeDist(String k, float g, float f) { this.k = k; this.g = g; this.f = f; }
    public int compareTo(NodeDist other) {
      return Float.compare(this.f, other.f);
    }
  }

  public void drawPaths(PApplet app, int strokeCol, boolean highlightSelected, boolean showNodes) {
    if (paths.isEmpty()) return;

    app.pushStyle();
    app.strokeCap(PConstants.ROUND);
    app.strokeJoin(PConstants.ROUND);
    app.noFill();
    HashMap<Integer, HashMap<String, Float>> taperCache = new HashMap<Integer, HashMap<String, Float>>();

    for (int i = 0; i < paths.size(); i++) {
      Path p = paths.get(i);
      if (p.routes.isEmpty()) continue;
      PathType pt = getPathType(p.typeId);
      int col = (pt != null) ? pt.col : strokeCol;
      float w = (pt != null) ? pt.weightPx : 2.0f;
      app.stroke(col);
      boolean taperOn = (pt != null && pt.taperOn);
      HashMap<String, Float> taperW = null;
      if (taperOn) {
        taperW = taperCache.get(p.typeId);
        if (taperW == null) {
          float minW = (pt != null) ? pt.minWeightPx : max(1.0f, w * 0.4f);
          taperW = computeTaperWeightsForType(p.typeId, w, minW);
          taperCache.put(p.typeId, taperW);
        }
      }
      p.draw(app, w, taperOn, taperW, i, showNodes, 1);

      // Debug: draw small dots on all route vertices
      if (showNodes) {
        app.pushStyle();
        app.noStroke();
        app.fill(255, 120, 0, 200);
        float r = 3.0f / viewport.zoom;
        for (ArrayList<PVector> rts : p.routes) {
          if (rts == null) continue;
          for (PVector v : rts) {
            app.ellipse(v.x, v.y, r, r);
          }
        }
        app.popStyle();
      }
    }

    // Selected path highlight
    if (highlightSelected && selectedPathIndex >= 0 && selectedPathIndex < paths.size()) {
      Path sel = paths.get(selectedPathIndex);
      if (sel.routes.isEmpty()) {
        app.popStyle();
        return;
      }
      PathType pt = getPathType(sel.typeId);
      int hi = app.color(255, 230, 80, 180);
      float w = (pt != null) ? pt.weightPx : 2.0f;
      float hw = 5.0f / viewport.zoom; // constant ~5px
      app.stroke(hi);
      app.strokeWeight(hw);
      boolean taperOn = (pt != null && pt.taperOn);
      HashMap<String, Float> taperW = null;
      if (taperOn) {
        taperW = taperCache.get(sel.typeId);
        if (taperW == null) {
          float minW = (pt != null) ? pt.minWeightPx : max(1.0f, w * 0.4f);
          taperW = computeTaperWeightsForType(sel.typeId, w, minW);
          taperCache.put(sel.typeId, taperW);
        }
      }
      sel.draw(app, w, taperOn, taperW, selectedPathIndex, showNodes, 1);
    }

    app.popStyle();
  }

  public void drawPathsRender(PApplet app, RenderSettings s) {
    if (paths.isEmpty() || s == null) return;
    app.pushStyle();
    app.strokeCap(PConstants.ROUND);
    app.strokeJoin(PConstants.ROUND);
    app.noFill();
    HashMap<Integer, HashMap<String, Float>> taperCache = new HashMap<Integer, HashMap<String, Float>>();
    float[] hsbScratch = new float[3];

    for (int i = 0; i < paths.size(); i++) {
      Path p = paths.get(i);
      if (p.routes.isEmpty()) continue;
      PathType pt = getPathType(p.typeId);
      int baseCol = (pt != null) ? pt.col : app.color(80);
      rgbToHSB01(baseCol, hsbScratch);
      float satScale = constrain(s.pathSatScale01, 0, 1);
      hsbScratch[1] = constrain(hsbScratch[1] * satScale, 0, 1);
      float briScale = constrain(s.pathBriScale01, 0, 1);
      hsbScratch[2] = constrain(hsbScratch[2] * briScale, 0, 1);
      int rgb = hsb01ToARGB(hsbScratch[0], hsbScratch[1], hsbScratch[2], 1.0f);
      int baseA = (baseCol >> 24) & 0xFF;
      if (baseA == 0) baseA = 255;
      int col = app.color((rgb >> 16) & 0xFF, (rgb >> 8) & 0xFF, rgb & 0xFF, baseA);
      float w = (pt != null) ? pt.weightPx : 2.0f;
      if (s.pathScaleWithZoom) {
        float ref = (s.pathScaleRefZoom > 1e-6f) ? s.pathScaleRefZoom : DEFAULT_VIEW_ZOOM;
        w *= max(1e-6f, viewport.zoom) / ref;
      }
      w = constrain(w, 0.1f, 256.0f);
      if (w <= 0.01f) continue;
      app.stroke(col);
      boolean taperOn = (pt != null && pt.taperOn);
      HashMap<String, Float> taperW = null;
      if (taperOn) {
        taperW = taperCache.get(p.typeId);
        if (taperW == null) {
          float minW = (pt != null) ? pt.minWeightPx : max(1.0f, w * 0.4f);
          taperW = computeTaperWeightsForType(p.typeId, w, minW);
          taperCache.put(p.typeId, taperW);
        }
      }
      p.draw(app, w, taperOn, taperW, i, false, 1.0f);
    }
    app.popStyle();
  }

  // ---------- Path generation ----------

  // Collect segments for a specific path type
  public ArrayList<PVector[]> collectPathSegmentsByType(int typeId) {
    ArrayList<PVector[]> segs = new ArrayList<PVector[]>();
    if (paths == null || paths.isEmpty()) return segs;
    for (Path p : paths) {
      if (p == null || p.routes == null || p.typeId != typeId) continue;
      for (ArrayList<PVector> r : p.routes) {
        if (r == null || r.size() < 2) continue;
        segs.addAll(segmentsFromPoints(r));
      }
    }
    return segs;
  }

  // Intersection helper returning the intersection point if segments overlap properly
  public PVector segmentIntersectionPoint(PVector a1, PVector a2, PVector b1, PVector b2) {
    float den = (a1.x - a2.x) * (b1.y - b2.y) - (a1.y - a2.y) * (b1.x - b2.x);
    if (abs(den) < 1e-9f) return null; // parallel or nearly
    float t = ((a1.x - b1.x) * (b1.y - b2.y) - (a1.y - b1.y) * (b1.x - b2.x)) / den;
    float u = -((a1.x - a2.x) * (a1.y - b1.y) - (a1.y - a2.y) * (a1.x - b1.x)) / den;
    if (t < 0 || t > 1 || u < 0 || u > 1) return null;
    return new PVector(a1.x + t * (a2.x - a1.x), a1.y + t * (a2.y - a1.y));
  }

  // Trim a route at the first intersection with an existing segment set (same type)
  public ArrayList<PVector> truncateRouteAtFirstIntersection(ArrayList<PVector> route, ArrayList<PVector[]> existing) {
    if (route == null || route.size() < 2 || existing == null || existing.isEmpty()) return route;
    int hitIdx = -1;
    PVector hitPt = null;
    for (int i = 0; i < route.size() - 1; i++) {
      PVector a = route.get(i);
      PVector b = route.get(i + 1);
      for (PVector[] ex : existing) {
        if (ex == null || ex.length < 2) continue;
        PVector p = segmentIntersectionPoint(a, b, ex[0], ex[1]);
        if (p != null) {
          hitIdx = i;
          // store the earliest along the route; approximate by i order
          hitPt = p;
          break;
        }
      }
      if (hitIdx >= 0) break;
    }
    if (hitIdx < 0 || hitPt == null) return route;
    ArrayList<PVector> trimmed = new ArrayList<PVector>();
    for (int i = 0; i <= hitIdx; i++) trimmed.add(route.get(i));
    trimmed.add(hitPt);
    return trimmed;
  }

  public void generatePathsAuto(float seaLevel) {
    ensureCellNeighborsComputed();
    if (structures != null) {
      for (int i = structures.size() - 1; i >= 0; i--) {
        Structure st = structures.get(i);
        if (st != null && "IP".equals(st.name)) structures.remove(i);
      }
    }
    int roadType = ensurePathTypeByName("Road");
    int riverType = ensurePathTypeByName("River");
    int bridgeType = ensurePathTypeByName("Bridge");
    float worldW = maxX - minX;
    float worldH = maxY - minY;
    float stepLen = max(1e-4f, min(worldW, worldH) * 0.02f);

    // Collect coastline midpoints (land/water boundary)
    ArrayList<PVector> coastPts = new ArrayList<PVector>();
    ArrayList<PVector> coastNrm = new ArrayList<PVector>(); // normal pointing from land to water
    int n = cells.size();
    for (int ci = 0; ci < n; ci++) {
      Cell c = cells.get(ci);
      if (c == null || c.vertices == null || c.vertices.size() < 3) continue;
      boolean aWater = c.elevation < seaLevel;
      ArrayList<Integer> nbs = (ci < cellNeighbors.size()) ? cellNeighbors.get(ci) : null;
        if (nbs == null) continue;
        int vc = c.vertices.size();
        for (int nbIdx : nbs) {
          if (nbIdx < 0 || nbIdx >= n) continue;
          if (nbIdx < ci) continue; // avoid dup
          Cell nb = cells.get(nbIdx);
          if (nb == null || nb.vertices == null || nb.vertices.size() < 3) continue;
          boolean bWater = nb.elevation < seaLevel;
          if (aWater == bWater) continue;
          PVector cenA = cellCentroid(c);
          PVector cenB = cellCentroid(nb);
          // find shared edge
          for (int e = 0; e < vc; e++) {
            PVector a = c.vertices.get(e);
            PVector b = c.vertices.get((e + 1) % vc);
            for (int je = 0; je < nb.vertices.size(); je++) {
              PVector na = nb.vertices.get(je);
              PVector nbp = nb.vertices.get((je + 1) % nb.vertices.size());
              boolean match = distSq(a, na) < 1e-6f && distSq(b, nbp) < 1e-6f;
              boolean matchRev = distSq(a, nbp) < 1e-6f && distSq(b, na) < 1e-6f;
              if (match || matchRev) {
                PVector va = a.copy();
                PVector vb = b.copy();
                coastPts.add(va);
                coastPts.add(vb);
                PVector nrm = new PVector(0, 1);
                if (cenA != null && cenB != null) {
                  PVector land = aWater ? cenB : cenA;
                  PVector water = aWater ? cenA : cenB;
                  nrm = PVector.sub(water, land);
                  if (nrm.magSq() > 1e-12f) nrm.normalize(); else nrm = new PVector(0, 1);
                }
                coastNrm.add(nrm);
                coastNrm.add(nrm.copy());
                break;
              }
            }
          }
        }
    }

    // Precompute mesh vertices for snapping
    ensureSnapGraph();
    ArrayList<PVector[]> existingSegs = collectAllPathSegments();
    ArrayList<PVector[]> existingRoadSegs = collectPathSegmentsByType(roadType);

    // Rivers
    for (int i = 0; i < 5; i++) {
      if (coastPts.isEmpty()) break;
      PVector start = coastPts.get((int)random(coastPts.size()));
      ArrayList<PVector> route = growRiver(start, seaLevel, stepLen, existingSegs);
      if (route == null || route.size() < 2) continue;
      route = snapRouteToGraph(route);
      if (route.size() < 2) continue;
      addPathFromPoints(riverType, useDefaultPathNames ? "River " + (paths.size() + 1) : "", route);
      existingSegs = collectAllPathSegments();
    }
    // Interest points (snap to nearest cell vertex)
    ArrayList<PVector> interest = new ArrayList<PVector>();
    // biggest structures
    if (structures != null && !structures.isEmpty()) {
      ArrayList<Structure> sorted = new ArrayList<Structure>(structures);
      Collections.sort(sorted, new Comparator<Structure>() {
        public int compare(Structure a, Structure b) { return Float.compare(b.size, a.size); }
      });
      int take = min(5, sorted.size());
      for (int i = 0; i < take; i++) {
        Structure s = sorted.get(i);
        Cell c = findCellContaining(s.x, s.y);
        if (c != null && c.elevation > seaLevel) {
        interest.add(snapToNearestSnapNode(cellCentroid(c)));
      } else {
        PVector p = new PVector(s.x, s.y);
        interest.add(snapToNearestSnapNode(p));
      }
    }
    }
    // border points (limit)
    float margin = min(worldW, worldH) * 0.05f;
    boolean borderTop = false, borderBottom = false, borderLeft = false, borderRight = false;
    for (Cell c : cells) {
      if (borderTop && borderBottom && borderLeft && borderRight) break;
      if (c == null || c.vertices == null || c.vertices.isEmpty()) continue;
      if (c.elevation <= seaLevel) continue;
      PVector cen = cellCentroid(c);
      if (cen == null) continue;
      if (abs(cen.x - minX) < margin && !borderLeft) { interest.add(snapToNearestSnapNode(cen)); borderLeft = true; }
      else if (abs(cen.x - maxX) < margin && !borderRight) { interest.add(snapToNearestSnapNode(cen)); borderRight = true; }
      else if (abs(cen.y - minY) < margin && !borderBottom) { interest.add(snapToNearestSnapNode(cen)); borderBottom = true; }
      else if (abs(cen.y - maxY) < margin && !borderTop) { interest.add(snapToNearestSnapNode(cen)); borderTop = true; }
    }
    // zones centers
    for (MapZone z : zones) {
      if (z == null || z.cells == null || z.cells.isEmpty()) continue;
      float sx = 0, sy = 0; int cnt = 0;
      for (int ci : z.cells) {
        if (ci < 0 || ci >= cells.size()) continue;
        Cell c = cells.get(ci);
        if (c == null) continue;
        PVector cen = cellCentroid(c);
        if (cen == null) continue;
        if (c.elevation <= seaLevel) continue;
        sx += cen.x; sy += cen.y; cnt++;
      }
      if (cnt > 0) interest.add(snapToNearestSnapNode(new PVector(sx / cnt, sy / cnt)));
    }
    // farthest from sea: pick highest elevation land cell
    float bestElev = -Float.MAX_VALUE;
    PVector bestP = null;
    for (Cell c : cells) {
      if (c == null || c.vertices == null || c.vertices.isEmpty()) continue;
      if (c.elevation <= seaLevel) continue;
      if (c.elevation > bestElev) {
        bestElev = c.elevation;
        bestP = cellCentroid(c);
      }
    }
    if (bestP != null) interest.add(snapToNearestSnapNode(bestP));

    // Build a tiny set of road seeds
    ArrayList<PVector> roadSeeds = new ArrayList<PVector>();
    HashSet<String> seedSeen = new HashSet<String>();
    float seedMargin = min(worldW, worldH) * 0.05f;
    ensureSnapGraph();

    // Helper to add snapped seed if valid and unique
    java.util.function.Consumer<PVector> addSeed = (p) -> {
      if (p == null) return;
      PVector snapped = snapToNearestSnapNode(p);
      if (snapped == null) return;
      String k = keyFor(snapped.x, snapped.y);
      if (seedSeen.contains(k)) return;
      seedSeen.add(k);
      roadSeeds.add(snapped);
    };

    // Border point
    for (Cell c : cells) {
      if (c == null || c.vertices == null || c.vertices.isEmpty()) continue;
      if (c.elevation <= seaLevel) continue;
      PVector cen = cellCentroid(c);
      if (cen == null) continue;
      if (abs(cen.x - minX) < seedMargin || abs(cen.x - maxX) < seedMargin || abs(cen.y - minY) < seedMargin || abs(cen.y - maxY) < seedMargin) {
        addSeed.accept(cen);
        break;
      }
    }

    // Zone center
    for (MapZone z : zones) {
      if (z == null || z.cells == null || z.cells.isEmpty()) continue;
      float sx = 0, sy = 0; int cnt = 0;
      for (int ci : z.cells) {
        if (ci < 0 || ci >= cells.size()) continue;
        Cell c = cells.get(ci);
        if (c == null || c.vertices == null || c.vertices.isEmpty()) continue;
        if (c.elevation <= seaLevel) continue;
        PVector cen = cellCentroid(c);
        if (cen == null) continue;
        sx += cen.x; sy += cen.y; cnt++;
      }
      if (cnt > 0) { addSeed.accept(new PVector(sx / cnt, sy / cnt)); break; }
    }

    // Biggest structure
    if (structures != null && !structures.isEmpty()) {
      Structure biggest = null;
      for (Structure s : structures) {
        if (s == null) continue;
        if (biggest == null || s.size > biggest.size) biggest = s;
      }
      if (biggest != null) addSeed.accept(new PVector(biggest.x, biggest.y));
    }

    // Fill up to at least 3 seeds with random emerged cells
    int safety = 0;
    while (roadSeeds.size() < 3 && safety++ < 30) {
      int idx = (int)random(cells.size());
      Cell c = cells.get(idx);
      if (c == null || c.vertices == null || c.vertices.isEmpty()) continue;
      if (c.elevation <= seaLevel) continue;
      PVector cen = cellCentroid(c);
      addSeed.accept(cen);
    }

    // Connect seeds pairwise (small set) with road paths
    int maxRoadLinks = 5;
    int roadLinks = 0;
    for (int i = 0; i < roadSeeds.size() && roadLinks < maxRoadLinks; i++) {
      for (int j = i + 1; j < roadSeeds.size() && roadLinks < maxRoadLinks; j++) {
        PVector pa = roadSeeds.get(i);
        PVector pb = roadSeeds.get(j);
        ArrayList<PVector> pathPts = findSnapPathFlattest(pa, pb);
        if (pathPts == null || pathPts.size() < 2) continue;
        boolean overWater = false;
        for (PVector p : pathPts) {
          if (p == null) continue;
          if (sampleElevationAt(p.x, p.y, seaLevel) < seaLevel) { overWater = true; break; }
        }
        if (overWater) continue;
        pathPts = truncateRouteAtFirstIntersection(pathPts, existingRoadSegs);
        if (pathPts == null || pathPts.size() < 2) continue;
        addPathFromPoints(roadType, useDefaultPathNames ? "Road " + (paths.size() + 1) : "", pathPts);
        existingRoadSegs.addAll(segmentsFromPoints(pathPts));
        roadLinks++;
      }
    }

    // Bridges: try three times
    // Bridge generation: coastline cells with >=3 consecutive water edges
    ArrayList<Integer> coastCells = new ArrayList<Integer>();
    ArrayList<Integer> coastStartEdge = new ArrayList<Integer>();
    ArrayList<Integer> coastLenEdge = new ArrayList<Integer>();
    for (int ci = 0; ci < cells.size() && coastCells.size() < 10; ci++) {
      Cell c = cells.get(ci);
      if (c == null || c.vertices == null) continue;
      if (c.elevation < seaLevel) continue;
      int vc = c.vertices.size();
      if (vc < 3) continue;
      boolean[] waterEdge = new boolean[vc];
      ArrayList<Integer> nbs = (ci < cellNeighbors.size()) ? cellNeighbors.get(ci) : null;
      if (nbs == null) continue;
      for (int e = 0; e < vc; e++) {
        PVector a = c.vertices.get(e);
        PVector b = c.vertices.get((e + 1) % vc);
        boolean edgeWater = false;
        for (int nbIdx : nbs) {
          if (nbIdx < 0 || nbIdx >= cells.size()) continue;
          Cell nb = cells.get(nbIdx);
          if (nb == null || nb.vertices == null || nb.vertices.size() < 3) continue;
          if (nb.elevation >= seaLevel) continue;
          int nvc = nb.vertices.size();
          for (int je = 0; je < nvc; je++) {
            PVector na = nb.vertices.get(je);
            PVector nbp = nb.vertices.get((je + 1) % nvc);
            boolean match = distSq(a, na) < 1e-6f && distSq(b, nbp) < 1e-6f;
            boolean matchRev = distSq(a, nbp) < 1e-6f && distSq(b, na) < 1e-6f;
            if (match || matchRev) { edgeWater = true; break; }
          }
          if (edgeWater) break;
        }
        waterEdge[e] = edgeWater;
      }
      int bestLen = 0, bestStart = -1, curLen = 0, curStart = 0;
      for (int i = 0; i < vc * 2; i++) { // handle wrap-around by looping twice
        int idx = i % vc;
        if (waterEdge[idx]) {
          if (curLen == 0) curStart = idx;
          curLen++;
          if (curLen > bestLen) { bestLen = curLen; bestStart = curStart; }
        } else {
          curLen = 0;
        }
      }
      if (bestLen >= 3) {
        if (bestLen > vc) bestLen = vc;
        coastCells.add(ci);
        coastStartEdge.add(bestStart);
        coastLenEdge.add(bestLen);
      }
    }

    class BridgeCandidate {
      PVector a, b;
      float len;
      BridgeCandidate(PVector a, PVector b, float len) { this.a = a; this.b = b; this.len = len; }
    }
    ArrayList<BridgeCandidate> bridgeCand = new ArrayList<BridgeCandidate>();
    for (int idx = 0; idx < coastCells.size(); idx++) {
      int ci = coastCells.get(idx);
      Cell c = cells.get(ci);
      if (c == null || c.vertices == null) continue;
      PVector cen = cellCentroid(c);
      if (cen == null) continue;
      int vc = c.vertices.size();
      int start = coastStartEdge.get(idx);
      int lenEdge = coastLenEdge.get(idx);
      int midEdge = (lenEdge % 2 == 1) ? (start + lenEdge / 2) % vc : -1;
      int midVertex = (lenEdge % 2 == 0) ? (start + lenEdge / 2) % vc : -1;
      PVector target;
      if (midEdge >= 0) {
        PVector a = c.vertices.get(midEdge);
        PVector b = c.vertices.get((midEdge + 1) % vc);
        target = PVector.add(a, b).mult(0.5f);
      } else {
        target = c.vertices.get(midVertex).copy();
      }
      PVector dir = PVector.sub(target, cen);
      if (dir.magSq() < 1e-8f) continue;
      dir.normalize();
      float travelMax = min(worldW, worldH) * 0.6f;
      float step = stepLen;
      PVector probe = cen.copy();
      PVector endPoint = null;
      for (int s = 0; s < 800 && s * step < travelMax; s++) {
        probe.add(PVector.mult(dir, step));
        Cell pc = findCellContaining(probe.x, probe.y);
        if (pc == null) continue;
        if (pc == c) continue;
        if (pc.elevation < seaLevel) continue;
        // check if pc touches water
        boolean touchesWater = false;
        int pcIdx = indexOfCell(pc);
        if (pcIdx >= 0 && pc.vertices != null && pc.vertices.size() >= 3) {
          int pvc = pc.vertices.size();
          ArrayList<Integer> nbs = (pcIdx < cellNeighbors.size()) ? cellNeighbors.get(pcIdx) : null;
          if (nbs != null) {
            for (int e = 0; e < pvc && !touchesWater; e++) {
              PVector a = pc.vertices.get(e);
              PVector b = pc.vertices.get((e + 1) % pvc);
              for (int nbIdx : nbs) {
                if (nbIdx < 0 || nbIdx >= cells.size()) continue;
                Cell nb = cells.get(nbIdx);
                if (nb == null || nb.elevation >= seaLevel || nb.vertices == null) continue;
                int nvc = nb.vertices.size();
                for (int je = 0; je < nvc; je++) {
                  PVector na = nb.vertices.get(je);
                  PVector nbp = nb.vertices.get((je + 1) % nvc);
                  boolean match = distSq(a, na) < 1e-6f && distSq(b, nbp) < 1e-6f;
                  boolean matchRev = distSq(a, nbp) < 1e-6f && distSq(b, na) < 1e-6f;
                  if (match || matchRev) { touchesWater = true; break; }
                }
                if (touchesWater) break;
              }
            }
          }
        }
        if (touchesWater) {
          PVector tgt = cellCentroid(pc);
          if (tgt != null) { endPoint = tgt; break; }
        }
      }
      if (endPoint == null) continue;
      float bridgeLen = dist2D(cen, endPoint);
      ArrayList<PVector> road = findSnapPath(cen, endPoint);
      float roadLen = 0;
      if (road != null) {
        for (int i = 0; i < road.size() - 1; i++) roadLen += dist2D(road.get(i), road.get(i + 1));
      }
      if (road == null || roadLen >= bridgeLen * 2f) {
        bridgeCand.add(new BridgeCandidate(cen.copy(), endPoint.copy(), bridgeLen));
      }
    }
    Collections.sort(bridgeCand, new Comparator<BridgeCandidate>() {
      public int compare(BridgeCandidate a, BridgeCandidate b) { return Float.compare(a.len, b.len); }
    });
    int bridges = 0;
    for (BridgeCandidate bc : bridgeCand) {
      if (bridges >= 3) break;
      ArrayList<PVector> bridgePts = new ArrayList<PVector>();
      bridgePts.add(bc.a.copy());
      bridgePts.add(bc.b.copy());
      ArrayList<PVector[]> segs = segmentsFromPoints(bridgePts);
      if (segmentsCross(segs, existingSegs)) continue;
      addPathFromPoints(bridgeType, useDefaultPathNames ? "Bridge " + (paths.size() + 1) : "", bridgePts);
      existingSegs.addAll(segs);
      bridges++;
    }
  }


  public int ensurePathTypeByName(String name) {
    if (pathTypes != null) {
      for (int i = 0; i < pathTypes.size(); i++) {
        PathType pt = pathTypes.get(i);
        if (pt != null && pt.name != null && pt.name.equalsIgnoreCase(name)) return i;
      }
    }
    int presetIdx = -1;
    for (int i = 0; i < PATH_TYPE_PRESETS.length; i++) {
      PathTypePreset p = PATH_TYPE_PRESETS[i];
      if (p != null && p.name != null && p.name.equalsIgnoreCase(name)) {
        presetIdx = i;
        break;
      }
    }
    PathType created = (presetIdx >= 0) ? makePathTypeFromPreset(presetIdx) : new PathType(name, color(60), 2.0f, 1.0f, PathRouteMode.PATHFIND, 0.0f, true, false);
    addPathType(created);
    return pathTypes.size() - 1;
  }

  public ArrayList<PVector> growRiver(PVector start, float seaLevel, float stepLen, ArrayList<PVector[]> avoid) {
    if (start == null) return null;
    ArrayList<PVector> pts = new ArrayList<PVector>();
    pts.add(start.copy());
    PVector dir = new PVector(0, 1);
    float lastElev = sampleElevationAt(start.x, start.y, seaLevel);
    int maxSeg = 60;
    for (int i = 0; i < maxSeg; i++) {
      PVector cur = pts.get(pts.size() - 1);
      ArrayList<PVector> candidates = new ArrayList<PVector>();
      for (int k = 0; k < 5; k++) {
        float ang = radians(random(-30, 30));
        PVector d = dir.copy();
        d.rotate(ang);
        if (d.y < 0) d.y = abs(d.y); // push upward
        d.normalize();
        d.mult(stepLen);
        PVector np = PVector.add(cur, d);
        candidates.add(np);
      }
      PVector best = null;
      float bestElev = -Float.MAX_VALUE;
      for (PVector c : candidates) {
        float elev = sampleElevationAt(c.x, c.y, seaLevel);
        if (elev <= seaLevel) continue;
        if (elev < lastElev - 0.02f) continue; // allow small dips but mostly uphill
        if (segmentTouches(c, pts, stepLen * 0.5f)) continue;
        if (segmentsCross(segmentsFromPoints(Arrays.asList(cur, c)), avoid)) continue;
        if (elev > bestElev) { bestElev = elev; best = c; }
      }
      if (best == null) break;
      pts.add(best);
      lastElev = max(lastElev, bestElev);
      dir = PVector.sub(best, cur);
      if (pts.size() > 80) break;
    }
    if (pts.size() < 2) return pts;
    if (pts.size() > 31) {
      int mid = pts.size() / 2;
      ArrayList<PVector> branch = growBranch(pts.get(mid), pts, seaLevel, stepLen * 0.8f, avoid);
      if (branch != null && branch.size() > 1) {
        ArrayList<PVector> snappedBranch = snapRouteToGraph(branch);
        if (snappedBranch.size() > 1) {
          addPathFromPoints(ensurePathTypeByName("River"), "River Branch " + (paths.size() + 1), snappedBranch);
          avoid.addAll(segmentsFromPoints(snappedBranch));
        }
      }
    }
    ArrayList<PVector> snapped = snapRouteToGraph(pts);
    avoid.addAll(segmentsFromPoints(snapped));
    return snapped;
  }

  public ArrayList<PVector> growBranch(PVector start, ArrayList<PVector> main, float seaLevel, float stepLen, ArrayList<PVector[]> avoid) {
    ArrayList<PVector> pts = new ArrayList<PVector>();
    pts.add(start.copy());
    PVector dir = new PVector(0, 1);
    for (int i = 0; i < 40; i++) {
      PVector cur = pts.get(pts.size() - 1);
      PVector best = null;
      float bestElev = -Float.MAX_VALUE;
      for (int k = 0; k < 4; k++) {
        float ang = radians(random(-40, 40));
        PVector d = dir.copy();
        d.rotate(ang);
        d.y = abs(d.y);
        d.normalize();
        d.mult(stepLen);
        PVector np = PVector.add(cur, d);
        float elev = sampleElevationAt(np.x, np.y, seaLevel);
        if (elev <= seaLevel) continue;
        if (segmentTouches(np, main, stepLen * 0.5f)) continue;
        ArrayList<PVector[]> segs = segmentsFromPoints(Arrays.asList(cur, np));
        if (segmentsCross(segs, avoid)) continue;
        if (elev > bestElev) { bestElev = elev; best = np; }
      }
      if (best == null) break;
      pts.add(best);
      dir = PVector.sub(best, cur);
    }
    return (pts.size() < 3) ? null : pts;
  }

  public boolean segmentTouches(PVector p, ArrayList<PVector> poly, float minDist) {
    float md2 = minDist * minDist;
    for (int i = 0; i < poly.size(); i++) {
      if (distSq(p, poly.get(i)) < md2) return true;
      if (i < poly.size() - 1) {
        if (pointToSegmentSq(p, poly.get(i), poly.get(i + 1)) < md2) return true;
      }
    }
    return false;
  }

  public ArrayList<PVector[]> segmentsFromPoints(List<PVector> pts) {
    ArrayList<PVector[]> out = new ArrayList<PVector[]>();
    if (pts == null) return out;
    for (int i = 0; i < pts.size() - 1; i++) {
      out.add(new PVector[] { pts.get(i), pts.get(i + 1) });
    }
    return out;
  }

  public boolean segmentsCross(ArrayList<PVector[]> a, ArrayList<PVector[]> b) {
    if (a == null || b == null) return false;
    for (PVector[] sa : a) {
      for (PVector[] sb : b) {
        if (segmentsIntersect(sa[0], sa[1], sb[0], sb[1])) return true;
      }
    }
    return false;
  }

  public ArrayList<PVector> trimAtFirstIntersection(ArrayList<PVector> pts, ArrayList<PVector[]> existing) {
    if (pts == null || pts.size() < 2) return null;
    ArrayList<PVector> out = new ArrayList<PVector>();
    out.add(pts.get(0));
    for (int i = 0; i < pts.size() - 1; i++) {
      PVector a = pts.get(i);
      PVector b = pts.get(i + 1);
      PVector hit = null;
      for (PVector[] ex : existing) {
        if (segmentsIntersect(a, b, ex[0], ex[1])) {
          hit = segmentIntersection(a, b, ex[0], ex[1]);
          break;
        }
      }
      if (hit != null) {
        out.add(hit);
        break;
      } else {
        out.add(b);
      }
    }
    return (out.size() < 2) ? null : out;
  }

  public void addPathFromPoints(int typeId, String name, ArrayList<PVector> pts) {
    if (pts == null || pts.size() < 2) return;
    Path p = new Path();
    p.typeId = constrain(typeId, 0, max(0, pathTypes.size() - 1));
    p.name = name;
    p.addRoute(pts);
    paths.add(p);
    snapDirty = true;
  }

  public boolean segmentsIntersect(PVector a1, PVector a2, PVector b1, PVector b2) {
    float d = (a2.x - a1.x) * (b2.y - b1.y) - (a2.y - a1.y) * (b2.x - b1.x);
    if (abs(d) < 1e-6f) return false;
    float ua = ((b1.x - a1.x) * (b2.y - b1.y) - (b1.y - a1.y) * (b2.x - b1.x)) / d;
    float ub = ((b1.x - a1.x) * (a2.y - a1.y) - (b1.y - a1.y) * (a2.x - a1.x)) / d;
    return ua >= 0 && ua <= 1 && ub >= 0 && ub <= 1;
  }

  public PVector segmentIntersection(PVector a1, PVector a2, PVector b1, PVector b2) {
    float d = (a2.x - a1.x) * (b2.y - b1.y) - (a2.y - a1.y) * (b2.x - b1.x);
    if (abs(d) < 1e-6f) return null;
    float ua = ((b1.x - a1.x) * (b2.y - b1.y) - (b1.y - a1.y) * (b2.x - b1.x)) / d;
    return new PVector(a1.x + ua * (a2.x - a1.x), a1.y + ua * (a2.y - a1.y));
  }

  public PVector snapToVertices(PVector p, ArrayList<PVector> meshVerts) {
    if (p == null) return null;
    if (meshVerts == null || meshVerts.isEmpty()) return p;
    float bestD = Float.MAX_VALUE;
    PVector best = p;
    for (PVector v : meshVerts) {
      float d2 = distSq(p, v);
      if (d2 < bestD) {
        bestD = d2;
        best = v;
      }
    }
    return best.copy();
  }

  public PVector snapToNearestSnapNode(PVector p) {
    if (p == null) return null;
    ensureSnapGraph();
    if (snapNodes == null || snapNodes.isEmpty()) return p.copy();
    PVector best = null;
    float bestD = Float.MAX_VALUE;
    for (PVector v : snapNodes.values()) {
      if (v == null) continue;
      float d2 = distSq(p, v);
      if (d2 < bestD) {
        bestD = d2;
        best = v;
      }
    }
    return (best != null) ? best.copy() : p.copy();
  }

  public ArrayList<PVector> snapRouteToGraph(ArrayList<PVector> pts) {
    ArrayList<PVector> out = new ArrayList<PVector>();
    if (pts == null || pts.isEmpty()) return out;
    ensureSnapGraph();
    for (PVector p : pts) {
      PVector snapped = snapToNearestSnapNode(p);
      if (snapped == null) continue;
      if (!out.isEmpty()) {
        PVector last = out.get(out.size() - 1);
        if (distSq(last, snapped) < 1e-12f) continue;
      }
      out.add(snapped);
    }
    if (out.size() == 1) out.add(out.get(0).copy());
    return out;
  }

  public float pointToSegmentSq(PVector p, PVector a, PVector b) {
    float dx = b.x - a.x;
    float dy = b.y - a.y;
    if (abs(dx) < 1e-6f && abs(dy) < 1e-6f) return distSq(p, a);
    float t = ((p.x - a.x) * dx + (p.y - a.y) * dy) / (dx * dx + dy * dy);
    t = constrain(t, 0, 1);
    float px = a.x + t * dx;
    float py = a.y + t * dy;
    float ddx = p.x - px;
    float ddy = p.y - py;
    return ddx * ddx + ddy * ddy;
  }

  // ---------- Paths management ----------

  public String defaultPathNameForType(int typeId) {
    String base = useDefaultPathNames ? "Path" : "";
    if (pathTypes != null && typeId >= 0 && typeId < pathTypes.size()) {
      PathType pt = pathTypes.get(typeId);
      if (pt != null && pt.name != null && pt.name.trim().length() > 0) {
        base = pt.name.trim();
      }
    }
    if (base.length() == 0) base = useDefaultPathNames ? "Path" : "";
    String baseLower = base.toLowerCase();
    int maxIdx = 0;
    if (paths != null) {
      for (Path p : paths) {
        if (p == null || p.name == null) continue;
        String nm = p.name.trim();
        String nmLower = nm.toLowerCase();
        if (nmLower.startsWith(baseLower)) {
          String tail = nm.substring(base.length()).trim();
          try {
            int idx = Integer.parseInt(tail);
            if (idx > maxIdx) maxIdx = idx;
          } catch (Exception e) {
            // ignore non-numeric suffix
          }
          if (tail.length() == 0 && maxIdx < 1) maxIdx = 1;
        }
      }
    }
    int next = (maxIdx <= 0) ? 1 : maxIdx + 1;
    return base + " " + next;
  }

  public void addFinishedPath(Path p) {
    if (p == null) return;
    if (p.routes.isEmpty()) return; // ignore degenerate paths
    if (p.name == null || p.name.length() == 0) {
      p.name = defaultPathNameForType(p.typeId);
    }
    if (p.typeId < 0 || p.typeId >= pathTypes.size()) {
      p.typeId = 0;
    }
    paths.add(p);
  }

  public void clearAllPaths() {
    paths.clear();
  }

  public void appendRouteToPath(Path p, ArrayList<PVector> pts) {
    if (p == null || pts == null || pts.size() < 2) return;

    // Skip segments that already exist in this path to avoid double-stacking identical edges.
    ArrayList<PVector> cleaned = removeDuplicateSegments(p, pts);
    if (cleaned == null || cleaned.size() < 2) return;

    p.addRoute(cleaned);
    snapDirty = true;
  }

  public ArrayList<PVector> removeDuplicateSegments(Path p, ArrayList<PVector> pts) {
    if (pts == null || pts.size() < 2) return null;
    HashSet<String> existing = collectSegmentKeys(p);

    ArrayList<PVector> out = new ArrayList<PVector>();
    out.add(pts.get(0).copy());
    for (int i = 0; i < pts.size() - 1; i++) {
      PVector a = out.get(out.size() - 1);
      PVector b = pts.get(i + 1);
      String key = segmentKey(a, b);
      if (existing.contains(key)) {
        continue;
      }
      existing.add(key);
      out.add(b.copy());
    }
    if (out.size() < 2) return null;
    return out;
  }

  public HashSet<String> collectSegmentKeys(Path p) {
    HashSet<String> keys = new HashSet<String>();
    if (p == null || p.routes == null) return keys;
    for (ArrayList<PVector> seg : p.routes) {
      if (seg == null || seg.size() < 2) continue;
      for (int i = 0; i < seg.size() - 1; i++) {
        PVector a = seg.get(i);
        PVector b = seg.get(i + 1);
        keys.add(segmentKey(a, b));
      }
    }
    return keys;
  }

  public String segmentKey(PVector a, PVector b) {
    // Undirected key with quantization to reduce floating noise.
    int ax = round(a.x * 10000);
    int ay = round(a.y * 10000);
    int bx = round(b.x * 10000);
    int by = round(b.y * 10000);
    if (ax < bx || (ax == bx && ay <= by)) {
      return ax + "," + ay + "-" + bx + "," + by;
    } else {
      return bx + "," + by + "-" + ax + "," + ay;
    }
  }

  public ArrayList<PVector[]> collectAllPathSegments() {
    ArrayList<PVector[]> segs = new ArrayList<PVector[]>();
    if (paths == null || paths.isEmpty()) return segs;
    for (Path p : paths) {
      if (p == null || p.routes == null) continue;
      for (ArrayList<PVector> r : p.routes) {
        if (r == null || r.size() < 2) continue;
        for (int i = 0; i < r.size() - 1; i++) {
          PVector a = r.get(i);
          PVector b = r.get(i + 1);
          segs.add(new PVector[] { a, b });
        }
      }
    }
    return segs;
  }

  public boolean edgeCrossesAnyPath(PVector[] edge, ArrayList<PVector[]> pathSegs) {
    if (edge == null || pathSegs == null || pathSegs.isEmpty()) return false;
    PVector e0 = edge[0];
    PVector e1 = edge[1];
    float minEx = min(e0.x, e1.x);
    float maxEx = max(e0.x, e1.x);
    float minEy = min(e0.y, e1.y);
    float maxEy = max(e0.y, e1.y);
    float eps = 1e-6f;
    for (PVector[] seg : pathSegs) {
      if (seg == null) continue;
      PVector p0 = seg[0];
      PVector p1 = seg[1];
      float minPx = min(p0.x, p1.x);
      float maxPx = max(p0.x, p1.x);
      float minPy = min(p0.y, p1.y);
      float maxPy = max(p0.y, p1.y);
      if (maxEx + eps < minPx || minEx - eps > maxPx || maxEy + eps < minPy || minEy - eps > maxPy) {
        continue; // quick reject via AABB
      }
      if (segmentsIntersect(e0, e1, p0, p1, eps)) return true;
    }
    return false;
  }

  public void removePathsNear(float wx, float wy, float radius) {
    if (paths == null) return;
    float r2 = radius * radius;
    for (int i = paths.size() - 1; i >= 0; i--) {
      Path p = paths.get(i);
      boolean hit = false;
      for (ArrayList<PVector> seg : p.routes) {
        if (seg == null) continue;
        for (PVector v : seg) {
          float dx = v.x - wx;
          float dy = v.y - wy;
          if (dx * dx + dy * dy <= r2) {
            hit = true;
            break;
          }
        }
        if (hit) break;
      }
      if (hit) {
        paths.remove(i);
      }
    }
  }

  public void erasePathSegments(float wx, float wy, float radius) {
    if (paths == null || paths.isEmpty()) return;
    float r2 = radius * radius;
    for (int pi = paths.size() - 1; pi >= 0; pi--) {
      Path p = paths.get(pi);
      if (p == null || p.routes == null) continue;
      ArrayList<ArrayList<PVector>> newRoutes = new ArrayList<ArrayList<PVector>>();
      boolean modified = false;
      for (ArrayList<PVector> seg : p.routes) {
        if (seg == null || seg.size() < 2) continue;
        ArrayList<PVector> cur = new ArrayList<PVector>();
        cur.add(seg.get(0).copy());
        for (int i = 0; i < seg.size() - 1; i++) {
          PVector a = seg.get(i);
          PVector b = seg.get(i + 1);
          PVector proj = closestPointOnSegment(wx, wy, a, b);
          float dx = proj.x - wx;
          float dy = proj.y - wy;
          float d2 = dx * dx + dy * dy;
          boolean hit = d2 <= r2;
          // Also treat endpoints inside radius as hits to fully remove adjacent segments
          float dxA = a.x - wx;
          float dyA = a.y - wy;
          float dxB = b.x - wx;
          float dyB = b.y - wy;
          if (dxA * dxA + dyA * dyA <= r2 || dxB * dxB + dyB * dyB <= r2) {
            hit = true;
          }
          if (hit) {
            // Cut here: close current route before this segment, start a new one after.
            if (cur.size() >= 2) newRoutes.add(cur);
            cur = new ArrayList<PVector>();
            cur.add(b.copy());
            modified = true;
          } else {
            cur.add(b.copy());
          }
        }
        if (cur.size() >= 2) newRoutes.add(cur);
      }
      if (modified) {
        p.routes = newRoutes;
        if (p.routes.isEmpty()) {
          paths.remove(pi);
        }
        snapDirty = true;
      }
    }
  }

  public SegmentHit nearestPathSegmentHit(float wx, float wy, float maxDist) {
    if (paths == null || paths.isEmpty()) return null;
    float best = maxDist;
    SegmentHit bestHit = null;
    for (int pi = 0; pi < paths.size(); pi++) {
      Path p = paths.get(pi);
      if (p == null || p.routes == null) continue;
      for (int ri = 0; ri < p.routes.size(); ri++) {
        ArrayList<PVector> seg = p.routes.get(ri);
        if (seg == null) continue;
        for (int si = 0; si < seg.size() - 1; si++) {
          PVector a = seg.get(si);
          PVector b = seg.get(si + 1);
          PVector proj = closestPointOnSegment(wx, wy, a, b);
          float d = dist(wx, wy, proj.x, proj.y);
          if (d < best) {
            best = d;
            bestHit = new SegmentHit();
            bestHit.a = a;
            bestHit.b = b;
            bestHit.p = proj;
            bestHit.pathIndex = pi;
            bestHit.routeIndex = ri;
            bestHit.segmentIndex = si;
          }
        }
      }
    }
    return bestHit;
  }

  public PVector closestPointOnSegment(float px, float py, PVector a, PVector b) {
    float ax = a.x, ay = a.y;
    float bx = b.x, by = b.y;
    float abx = bx - ax;
    float aby = by - ay;
    float t = ((px - ax) * abx + (py - ay) * aby) / (abx * abx + aby * aby + 1e-9f);
    t = constrain(t, 0, 1);
    return new PVector(ax + abx * t, ay + aby * t);
  }

  public SegmentHit nearestFrontierSegmentHit(float wx, float wy, float maxDist,
                                       boolean useWater, boolean useBiomes, boolean useUnderwaterBiomes,
                                       boolean useZones, boolean useElevation,
                                       int[] zoneMembership, int[] elevBuckets) {
    if (cells == null || cells.isEmpty()) return null;
    if (!useWater && !useBiomes && !useUnderwaterBiomes && !useZones && !useElevation) return null;
    ensureCellNeighborsComputed();
    float eps = 1e-4f;
    float eps2 = eps * eps;

    float best = maxDist;
    SegmentHit bestHit = null;

    int n = cells.size();
    for (int i = 0; i < n; i++) {
      Cell a = cells.get(i);
      ArrayList<Integer> nbs = cellNeighbors.get(i);
      if (nbs == null) continue;
      for (int nb : nbs) {
        if (nb <= i) continue;
        Cell b = cells.get(nb);
        if (b == null) continue;

        if (!boundaryActiveForSnapping(a, b, i, nb, zoneMembership, elevBuckets,
                                       useWater, useBiomes, useUnderwaterBiomes, useZones, useElevation)) {
          continue;
        }

        ArrayList<PVector> va = a.vertices;
        ArrayList<PVector> vb = b.vertices;
        if (va == null || vb == null || va.size() < 2 || vb.size() < 2) continue;
        int ac = va.size();
        for (int ai = 0; ai < ac; ai++) {
          PVector a0 = va.get(ai);
          PVector a1 = va.get((ai + 1) % ac);
          for (int bi = 0; bi < vb.size(); bi++) {
            PVector b0 = vb.get(bi);
            PVector b1 = vb.get((bi + 1) % vb.size());
            boolean matchForward = distSq(a0, b0) < eps2 && distSq(a1, b1) < eps2;
            boolean matchBackward = distSq(a0, b1) < eps2 && distSq(a1, b0) < eps2;
            if (!matchForward && !matchBackward) continue;

            PVector proj = closestPointOnSegment(wx, wy, a0, a1);
            float d = dist(wx, wy, proj.x, proj.y);
            if (d < best) {
              best = d;
              bestHit = new SegmentHit();
              bestHit.a = a0;
              bestHit.b = a1;
              bestHit.p = proj;
              bestHit.cellA = i;
              bestHit.cellB = nb;
            }
            break;
          }
        }
      }
    }
    return bestHit;
  }

  // ---------- Sites management ----------

  public Site addSite(float x, float y) {
    Site s = new Site(x, y);
    sites.add(s);
    markVoronoiDirty();
    return s;
  }

  public void deleteSelectedSites() {
    boolean changed = false;
    for (int i = sites.size() - 1; i >= 0; i--) {
      if (sites.get(i).selected) {
        sites.remove(i);
        changed = true;
      }
    }
    if (changed) {
      markVoronoiDirty();
    }
  }

  public void clearSiteSelection() {
    for (Site s : sites) {
      s.selected = false;
    }
  }

  public void selectSite(Site s) {
    if (s != null) {
      s.selected = true;
    }
  }

  public Site findSiteNear(float wx, float wy, float maxDistWorld) {
    Site best = null;
    float bestSq = maxDistWorld * maxDistWorld;
    for (Site s : sites) {
      float dx = s.x - wx;
      float dy = s.y - wy;
      float d2 = dx * dx + dy * dy;
      if (d2 <= bestSq) {
        bestSq = d2;
        best = s;
      }
    }
    return best;
  }

  // ---------- Voronoi management ----------

  public void markVoronoiDirty() {
    voronoiDirty = true;
    snapDirty = true;
    voronoiJob = null; // cancel in-flight job
    invalidateContourCaches();
    renderer.invalidateBiomeOutlineCache();
  }

  public void invalidateContourCaches() {
    coastCacheValid = false;
    cachedCoastGrid = null;
    cachedCoastIndex = null;
    cachedCoastSeaLevel = Float.MAX_VALUE;
    cachedCoastCols = 0;
    cachedCoastRows = 0;
    cachedCoastCellCount = -1;
    coastJob = null;

    elevationCacheValid = false;
    cachedElevationGrid = null;
    cachedElevationSeaLevel = Float.MAX_VALUE;
    cachedElevationCols = 0;
    cachedElevationRows = 0;
    cachedElevationCellCount = -1;
    elevationJob = null;
  }

  public void ensureVoronoiComputed() {
    // Kick off incremental job if needed
    if (voronoiDirty && voronoiJob == null) {
      startVoronoiJob();
    }

    // Advance current job in small batches
    if (voronoiJob != null) {
      stepVoronoiJob(VORONOI_BATCH, 10);
    }
  }

  public void startVoronoiJob() {
    if (sites == null || sites.isEmpty()) {
      cells.clear();
      cellNeighbors.clear();
      preservedCells = null;
      voronoiDirty = false;
      voronoiJob = null;
      voronoiProgress = 0;
      return;
    }
    ArrayList<Cell> oldCells = (preservedCells != null) ? preservedCells : new ArrayList<Cell>();
    voronoiJob = new VoronoiJob(this, sites, oldCells, defaultElevation, preservedCells != null);
    voronoiProgress = 0;
  }

  public void stepVoronoiJob(int maxSites, int maxMillis) {
    if (voronoiJob == null) return;
    voronoiJob.step(maxSites, maxMillis);
    voronoiProgress = voronoiJob.progress();
    if (voronoiJob.isDone()) {
      // Swap in the freshly built data
      cells = voronoiJob.outCells;
      preservedCells = null;
      voronoiDirty = false;
      voronoiJob = null;
      voronoiProgress = 1.0f;
      rebuildCellNeighbors();
      snapDirty = true;
    }
  }

  public boolean isVoronoiBuilding() {
    return voronoiJob != null;
  }

  public float getVoronoiProgress() {
    if (voronoiJob != null) return voronoiJob.progress();
    return voronoiDirty ? 0.0f : 1.0f;
  }

  // Keep the half-plane of points closer to si than sj
  public ArrayList<PVector> clipPolygonWithHalfPlane(ArrayList<PVector> poly, Site si, Site sj) {
    ArrayList<PVector> out = new ArrayList<PVector>();
    if (poly.isEmpty()) return out;

    float ax = sj.x - si.x;
    float ay = sj.y - si.y;
    float c = 0.5f * (sj.x * sj.x + sj.y * sj.y - si.x * si.x - si.y * si.y);

    int count = poly.size();
    for (int k = 0; k < count; k++) {
      PVector current = poly.get(k);
      PVector next = poly.get((k + 1) % count);

      float fCurrent = ax * current.x + ay * current.y - c;
      float fNext = ax * next.x + ay * next.y - c;

      boolean insideCurrent = fCurrent <= 0;
      boolean insideNext = fNext <= 0;

      if (insideCurrent && insideNext) {
        out.add(next.copy());
      } else if (insideCurrent && !insideNext) {
        PVector inter = intersectSegmentWithLine(current, next, fCurrent, fNext);
        if (inter != null) out.add(inter);
      } else if (!insideCurrent && insideNext) {
        PVector inter = intersectSegmentWithLine(current, next, fCurrent, fNext);
        if (inter != null) out.add(inter);
        out.add(next.copy());
      } else {
        // both outside
      }
    }

    return out;
  }

  public PVector intersectSegmentWithLine(PVector p1, PVector p2, float f1, float f2) {
    float denom = f1 - f2;
    if (abs(denom) < 1e-6f) {
      return null;
    }
    float t = f1 / (f1 - f2);
    t = constrain(t, 0.0f, 1.0f);
    float x = lerp(p1.x, p2.x, t);
    float y = lerp(p1.y, p2.y, t);
    return new PVector(x, y);
  }

  // Sample biome from old cells at (x,y); fallback if none found
  public int sampleBiomeFromOldCells(ArrayList<Cell> oldCells, float x, float y, int fallbackBiome) {
    for (Cell c : oldCells) {
      if (pointInPolygon(x, y, c.vertices)) {
        return c.biomeId;
      }
    }
    return fallbackBiome;
  }

  public int sampleZoneFromOldCells(int fallbackZone) {
    return fallbackZone;
  }

  public float sampleElevationFromOldCells(ArrayList<Cell> oldCells, float x, float y, float fallback) {
    for (Cell c : oldCells) {
      if (pointInPolygon(x, y, c.vertices)) {
        return c.elevation;
      }
    }
    return fallback;
  }

  public void makePlateaus(float seaLevel) {
    if (cells == null || cells.isEmpty()) return;
    ensureCellNeighborsComputed();
    int nCells = cells.size();
    int targetCount = max(1, nCells / 100);
    int iterations = max(1, nCells / 1000);
    for (int iter = 0; iter < iterations; iter++) {
      int startIdx = (int)random(nCells);
      Cell start = cells.get(startIdx);
      if (start == null || start.vertices == null || start.vertices.isEmpty()) continue;
      HashSet<Integer> visited = new HashSet<Integer>();
      visited.add(startIdx);
      float sum = start.elevation;
      int count = 1;

      while (count < targetCount) {
        float avg = sum / max(1, count);
        float bestDiff = Float.MAX_VALUE;
        int bestIdx = -1;
        for (int idx : visited) {
          ArrayList<Integer> nbs = cellNeighbors.get(idx);
          if (nbs == null) continue;
          for (int nb : nbs) {
            if (nb < 0 || nb >= nCells) continue;
            if (visited.contains(nb)) continue;
            Cell nc = cells.get(nb);
            if (nc == null) continue;
            float diff = abs(nc.elevation - avg);
            if (diff < bestDiff) {
              bestDiff = diff;
              bestIdx = nb;
            }
          }
        }
        if (bestIdx < 0) break;
        visited.add(bestIdx);
        Cell added = cells.get(bestIdx);
        if (added != null) {
          sum += added.elevation;
          count++;
        }
      }

      float avg = sum / max(1, count);
      for (int idx : visited) {
        Cell c = cells.get(idx);
        if (c == null) continue;
        c.elevation = lerp(c.elevation, avg, 0.8f);
      }
    }
    normalizeElevationsIfOutOfBounds(seaLevel);
    invalidateContourCaches();
  }

  // Incremental Voronoi builder to keep UI responsive during generation.
  class VoronoiJob {
    MapModel model;
    ArrayList<Site> sites;
    ArrayList<Cell> oldCells;
    ArrayList<Cell> outCells = new ArrayList<Cell>();
    int idx = 0;
    int n;
    float defaultElev;
    int defaultBiome = 0;
    boolean preserveData;
    HashMap<Long, ArrayList<Integer>> bins = new HashMap<Long, ArrayList<Integer>>();
    float binSize;
    float invBin;

    VoronoiJob(MapModel model, ArrayList<Site> sites, ArrayList<Cell> oldCells, float defaultElev, boolean preserveData) {
      this.model = model;
      this.sites = new ArrayList<Site>(sites);
      this.oldCells = (oldCells != null) ? oldCells : new ArrayList<Cell>();
      this.n = this.sites.size();
      this.defaultElev = defaultElev;
      this.preserveData = preserveData;
      float area = (model.maxX - model.minX) * (model.maxY - model.minY);
      float avgSpacing = sqrt(max(1e-6f, area / max(1, n)));
      binSize = max(1e-3f, avgSpacing * 1.5f);
      invBin = 1.0f / binSize;
      buildBins();
    }

    public void step(int maxSites, int maxMillis) {
      if (idx >= n) return;
      int processed = 0;
      long end = millis() + max(0, maxMillis);
      while (idx < n && processed < maxSites) {
        if (maxMillis > 0 && millis() > end) break;
        buildCell(idx);
        idx++;
        processed++;
      }
    }

    public void buildCell(int i) {
      Site si = sites.get(i);
      ArrayList<PVector> poly = new ArrayList<PVector>();
      poly.add(new PVector(minX, minY));
      poly.add(new PVector(maxX, minY));
      poly.add(new PVector(maxX, maxY));
      poly.add(new PVector(minX, maxY));

      ArrayList<Integer> candidates = gatherCandidates(i);
      if (candidates == null || candidates.isEmpty()) {
        candidates = new ArrayList<Integer>();
        for (int j = 0; j < n; j++) if (j != i) candidates.add(j);
      }

      HashSet<Integer> seen = new HashSet<Integer>();
      for (int idxCandidate : candidates) {
        if (idxCandidate == i) continue;
        if (seen.contains(idxCandidate)) continue;
        seen.add(idxCandidate);
        Site sj = sites.get(idxCandidate);
        poly = model.clipPolygonWithHalfPlane(poly, si, sj);
        if (poly.size() < 3) {
          break;
        }
      }

      // Safety pass: clip with any neighbor within the cell's current radius to avoid overlaps.
      float maxDist = 0;
      for (PVector v : poly) {
        float dx = v.x - si.x;
        float dy = v.y - si.y;
        maxDist = max(maxDist, sqrt(dx * dx + dy * dy));
      }
      int extraRing = ceil(maxDist * invBin) + 2;
      ArrayList<Integer> extra = gatherNeighborsWithinRings(i, extraRing);
      for (int idxCandidate : extra) {
        if (idxCandidate == i || seen.contains(idxCandidate)) continue;
        seen.add(idxCandidate);
        Site sj = sites.get(idxCandidate);
        poly = model.clipPolygonWithHalfPlane(poly, si, sj);
        if (poly.size() < 3) break;
      }

      if (poly.size() < 3) return;

      float cx = 0;
      float cy = 0;
      int nv = poly.size();
      for (int k = 0; k < nv; k++) {
        PVector v = poly.get(k);
        cx += v.x;
        cy += v.y;
      }
      cx /= nv;
      cy /= nv;

      int biomeId = (preserveData && !oldCells.isEmpty())
        ? model.sampleBiomeFromOldCells(oldCells, cx, cy, defaultBiome)
        : defaultBiome;
      float elev = (preserveData && !oldCells.isEmpty())
        ? model.sampleElevationFromOldCells(oldCells, cx, cy, defaultElev)
        : defaultElev;

      Cell newCell = new Cell(i, poly, biomeId);
      newCell.elevation = elev;
      outCells.add(newCell);
    }

    public boolean isDone() {
      return idx >= n;
    }

    public float progress() {
      if (n <= 0) return 1.0f;
      return constrain(idx / (float)n, 0, 1);
    }

    public void buildBins() {
      bins.clear();
      for (int i = 0; i < n; i++) {
        Site s = sites.get(i);
        int gx = floor((s.x - minX) * invBin);
        int gy = floor((s.y - minY) * invBin);
        long key = (((long)gx) << 32) ^ (gy & 0xffffffffL);
        ArrayList<Integer> bucket = bins.get(key);
        if (bucket == null) {
          bucket = new ArrayList<Integer>();
          bins.put(key, bucket);
        }
        bucket.add(i);
      }
    }

    public ArrayList<Integer> gatherCandidates(int i) {
      ArrayList<Integer> out = new ArrayList<Integer>();
      Site s = sites.get(i);
      int gx = floor((s.x - minX) * invBin);
      int gy = floor((s.y - minY) * invBin);

      // Expand rings until we have a reasonable set of neighbors or reach cap
      int needed = 48;
      int maxRing = 8;
      for (int ring = 0; ring <= maxRing && out.size() < needed; ring++) {
        for (int dx = -ring; dx <= ring; dx++) {
          for (int dy = -ring; dy <= ring; dy++) {
            if (abs(dx) != ring && abs(dy) != ring) continue; // only border of ring
            long key = (((long)(gx + dx)) << 32) ^ ((gy + dy) & 0xffffffffL);
            ArrayList<Integer> bucket = bins.get(key);
            if (bucket == null) continue;
            for (int idxSite : bucket) {
              if (idxSite == i) continue;
              out.add(idxSite);
              if (out.size() >= needed) break;
            }
            if (out.size() >= needed) break;
          }
          if (out.size() >= needed) break;
        }
      }
      return out;
    }

    public ArrayList<Integer> gatherNeighborsWithinRings(int i, int ringRadius) {
      ArrayList<Integer> out = new ArrayList<Integer>();
      Site s = sites.get(i);
      int gx = floor((s.x - minX) * invBin);
      int gy = floor((s.y - minY) * invBin);
      int rMax = max(0, min(ringRadius, 20)); // cap to keep work bounded
      for (int ring = 0; ring <= rMax; ring++) {
        for (int dx = -ring; dx <= ring; dx++) {
          for (int dy = -ring; dy <= ring; dy++) {
            if (abs(dx) != ring && abs(dy) != ring) continue;
            long key = (((long)(gx + dx)) << 32) ^ ((gy + dy) & 0xffffffffL);
            ArrayList<Integer> bucket = bins.get(key);
            if (bucket == null) continue;
            for (int idxSite : bucket) {
              if (idxSite == i) continue;
              out.add(idxSite);
            }
          }
        }
      }
      return out;
    }
  }

  // ---------- Zones / cells picking ----------

public Cell findCellContaining(float wx, float wy) {
  for (Cell c : cells) {
    if (pointInPolygon(wx, wy, c.vertices)) return c;
  }
  return null;
}

public Cell nearestCell(float wx, float wy) {
  if (cells == null || cells.isEmpty()) return null;
  Cell best = null;
  float bestD2 = Float.MAX_VALUE;
  for (Cell c : cells) {
    if (c == null || c.vertices == null || c.vertices.size() < 3) continue;
    PVector cen = cellCentroid(c);
    float dx = cen.x - wx;
    float dy = cen.y - wy;
    float d2 = dx * dx + dy * dy;
    if (d2 < bestD2) {
      bestD2 = d2;
      best = c;
    }
  }
  return best;
}

public int findCellIndexContaining(float wx, float wy) {
  if (cells == null) return -1;
  for (int i = 0; i < cells.size(); i++) {
    Cell c = cells.get(i);
    if (c == null) continue;
    if (pointInPolygon(wx, wy, c.vertices)) return i;
  }
  return -1;
}

public boolean pointTouchesWater(float wx, float wy, float sea) {
  int ci = findCellIndexContaining(wx, wy);
  if (ci < 0 || ci >= cells.size()) return false;
  Cell c = cells.get(ci);
  if (c == null) return false;
  if (c.elevation <= sea) return true;
  ensureCellNeighborsComputed();
  ArrayList<Integer> nbs = (ci < cellNeighbors.size()) ? cellNeighbors.get(ci) : null;
  if (nbs != null) {
    for (int nb : nbs) {
      if (nb < 0 || nb >= cells.size()) continue;
      Cell nc = cells.get(nb);
      if (nc == null) continue;
      if (nc.elevation <= sea) return true;
    }
  }
  return false;
}

public float structureRadius(float size, float aspect) {
  return size * 0.5f * max(1.0f, aspect);
}

public boolean structuresOverlap(ArrayList<Structure> list, float x, float y, float size, float aspect, float slack) {
  float r = structureRadius(size, aspect);
  for (Structure s : list) {
    if (s == null) continue;
    float ra = structureRadius(s.size, s.aspect);
    float dx = s.x - x;
    float dy = s.y - y;
    float d2 = dx * dx + dy * dy;
    float rr = r + ra;
    if (d2 < rr * rr * slack) return true;
  }
  return false;
}

  public boolean pointInPolygon(float x, float y, ArrayList<PVector> poly) {
    if (poly == null || poly.size() < 3) return false;

    boolean inside = false;
    int n = poly.size();
    for (int i = 0, j = n - 1; i < n; j = i++) {
      PVector pi = poly.get(i);
      PVector pj = poly.get(j);

      boolean intersect = ((pi.y > y) != (pj.y > y)) &&
                          (x < (pj.x - pi.x) * (y - pi.y) / (pj.y - pi.y + 1e-9f) + pi.x);
      if (intersect) inside = !inside;
    }
    return inside;
  }

  public int indexOfCell(Cell c) {
    for (int i = 0; i < cells.size(); i++) {
      if (cells.get(i) == c) return i;
    }
    return -1;
  }

  // Flood-fill contiguous region of same biome as start cell
  public void floodFillBiomeFromCell(Cell start, int newBiomeId) {
    if (start == null) return;
    int startIndex = indexOfCell(start);
    if (startIndex < 0) return;

    int oldBiome = start.biomeId;
    if (oldBiome == newBiomeId) return;

    int n = cells.size();
    if (n == 0) return;

    boolean[] visited = new boolean[n];
    int[] stack = new int[n];
    int stackSize = 0;
    float eps = 1e-4f;

    stack[stackSize++] = startIndex;
    visited[startIndex] = true;

    while (stackSize > 0) {
      int idx = stack[--stackSize];
      Cell c = cells.get(idx);

      if (c.biomeId != oldBiome) continue;
      c.biomeId = newBiomeId;

      for (int j = 0; j < n; j++) {
        if (visited[j]) continue;
        Cell other = cells.get(j);

        if (!cellsAreNeighbors(c, other, eps)) continue;

        visited[j] = true;
        stack[stackSize++] = j;
      }
    }
    renderer.invalidateBiomeOutlineCache();
  }

  public void addCellToZone(int cellIdx, int zoneIdx) {
    if (zones == null || zoneIdx < 0 || zoneIdx >= zones.size()) return;
    if (cellIdx < 0 || cellIdx >= cells.size()) return;
    MapZone az = zones.get(zoneIdx);
    if (az == null) return;
    if (!az.cells.contains(cellIdx)) {
      az.cells.add(cellIdx);
    }
  }

  public void removeCellFromAllZones(int cellIdx) {
    if (zones == null || cellIdx < 0 || cells == null || cellIdx >= cells.size()) return;
    for (MapZone az : zones) {
      if (az == null || az.cells == null) continue;
      az.cells.remove((Integer)cellIdx);
    }
  }

  public ArrayList<ArrayList<Integer>> mapCellsToZones() {
    int n = (cells != null) ? cells.size() : 0;
    ArrayList<ArrayList<Integer>> result = new ArrayList<ArrayList<Integer>>();
    for (int i = 0; i < n; i++) {
      result.add(new ArrayList<Integer>());
    }
    if (zones == null || zones.isEmpty() || n == 0) return result;
    for (int zi = 0; zi < zones.size(); zi++) {
      MapZone z = zones.get(zi);
      if (z == null || z.cells == null) continue;
      for (int ci : z.cells) {
        if (ci >= 0 && ci < n) {
          result.get(ci).add(zi);
        }
      }
    }
    return result;
  }

  public void pruneZoneUnderwater(MapZone zone, float sea) {
    if (zone == null || zone.cells == null || cells == null) return;
    ArrayList<Integer> kept = new ArrayList<Integer>();
    for (int ci : zone.cells) {
      if (ci < 0 || ci >= cells.size()) continue;
      Cell c = cells.get(ci);
      if (c == null || c.elevation < sea) continue;
      kept.add(ci);
    }
    zone.cells.clear();
    zone.cells.addAll(kept);
  }

  public void removeUnderwaterCellsFromZone(int zoneIdx, float sea) {
    if (zones == null || zones.isEmpty()) return;
    if (zoneIdx >= 0 && zoneIdx < zones.size()) {
      pruneZoneUnderwater(zones.get(zoneIdx), sea);
    } else {
      for (int zi = 0; zi < zones.size(); zi++) {
        pruneZoneUnderwater(zones.get(zi), sea);
      }
    }
    renderer.invalidateBiomeOutlineCache();
    snapDirty = true;
  }

  public void enforceZoneExclusivity(int zoneIdx) {
    if (zones == null || zones.isEmpty()) return;
    if (zoneIdx >= 0 && zoneIdx < zones.size()) {
      MapZone target = zones.get(zoneIdx);
      HashSet<Integer> reserved = new HashSet<Integer>();
      if (target != null && target.cells != null) {
        reserved.addAll(target.cells);
      }
      for (int zi = 0; zi < zones.size(); zi++) {
        if (zi == zoneIdx) continue;
        MapZone other = zones.get(zi);
        if (other == null || other.cells == null) continue;
        ArrayList<Integer> filtered = new ArrayList<Integer>();
        for (int ci : other.cells) {
          if (!reserved.contains(ci)) filtered.add(ci);
        }
        other.cells.clear();
        other.cells.addAll(filtered);
      }
    } else {
      ArrayList<ArrayList<Integer>> cellZones = mapCellsToZones();
      int zoneCount = zones.size();
      if (cellZones.isEmpty() || zoneCount == 0) return;
      int[] counts = new int[zoneCount];
      ArrayList<ArrayList<Integer>> newZoneCells = new ArrayList<ArrayList<Integer>>();
      for (int zi = 0; zi < zoneCount; zi++) {
        newZoneCells.add(new ArrayList<Integer>());
      }
      for (int ci = 0; ci < cellZones.size(); ci++) {
        ArrayList<Integer> owners = cellZones.get(ci);
        if (owners == null || owners.isEmpty()) continue;
        int assign = -1;
        for (int owner : owners) {
          if (owner < 0 || owner >= zoneCount) continue;
          if (assign < 0 || counts[owner] < counts[assign]) {
            assign = owner;
          }
        }
        if (assign < 0) continue;
        newZoneCells.get(assign).add(ci);
        counts[assign]++;
      }
      for (int zi = 0; zi < zoneCount; zi++) {
        MapZone z = zones.get(zi);
        if (z == null) continue;
        z.cells.clear();
        z.cells.addAll(newZoneCells.get(zi));
      }
    }
    renderer.invalidateBiomeOutlineCache();
    snapDirty = true;
  }

  public void recolorZonesWithFourColors() {
    if (zones == null || zones.isEmpty()) return;
    ensureCellNeighborsComputed();
    int zoneCount = zones.size();
    int[] palette = {
      color(200, 65, 65),
      color(75, 160, 90),
      color(85, 95, 190),
      color(215, 180, 80)
    };
    ArrayList<ArrayList<Integer>> cellZones = mapCellsToZones();
    final ArrayList<HashSet<Integer>> adjacency = new ArrayList<HashSet<Integer>>();
    for (int zi = 0; zi < zoneCount; zi++) {
      adjacency.add(new HashSet<Integer>());
    }
    int n = cellZones.size();
    for (int ci = 0; ci < n; ci++) {
      ArrayList<Integer> owners = cellZones.get(ci);
      if (owners == null || owners.isEmpty()) continue;
      int ownerCount = owners.size();
      for (int aIdx = 0; aIdx < ownerCount; aIdx++) {
        int a = owners.get(aIdx);
        if (a < 0 || a >= zoneCount) continue;
        for (int bIdx = aIdx + 1; bIdx < ownerCount; bIdx++) {
          int b = owners.get(bIdx);
          if (b < 0 || b >= zoneCount) continue;
          adjacency.get(a).add(b);
          adjacency.get(b).add(a);
        }
      }
      ArrayList<Integer> neighbors = (ci < cellNeighbors.size()) ? cellNeighbors.get(ci) : null;
      if (neighbors == null) continue;
      for (int nb : neighbors) {
        if (nb < 0 || nb >= cellZones.size()) continue;
        ArrayList<Integer> nbOwners = cellZones.get(nb);
        if (nbOwners == null || nbOwners.isEmpty()) continue;
        for (int a : owners) {
          if (a < 0 || a >= zoneCount) continue;
          for (int b : nbOwners) {
            if (b < 0 || b >= zoneCount || b == a) continue;
            adjacency.get(a).add(b);
            adjacency.get(b).add(a);
          }
        }
      }
    }
    int[] assignment = new int[zoneCount];
    Arrays.fill(assignment, -1);
    ArrayList<Integer> order = new ArrayList<Integer>();
    for (int zi = 0; zi < zoneCount; zi++) order.add(zi);
    Collections.sort(order, new Comparator<Integer>() {
      public int compare(Integer a, Integer b) {
        return Integer.compare(adjacency.get(b).size(), adjacency.get(a).size());
      }
    });
    for (int idx : order) {
      boolean[] used = new boolean[palette.length];
      for (int neighbor : adjacency.get(idx)) {
        if (neighbor >= 0 && neighbor < zoneCount && assignment[neighbor] >= 0) {
          int usedIdx = assignment[neighbor];
          if (usedIdx >= 0 && usedIdx < palette.length) {
            used[usedIdx] = true;
          }
        }
      }
      int pick = 0;
      for (int c = 0; c < palette.length; c++) {
        if (!used[c]) {
          pick = c;
          break;
        }
      }
      assignment[idx] = pick;
      MapZone z = zones.get(idx);
      if (z == null) continue;
      int col = palette[pick];
      float[] hsb = rgbToHSB(col);
      z.hue01 = hsb[0];
      z.sat01 = hsb[1];
      z.bri01 = hsb[2];
      z.col = col;
    }
    renderer.invalidateBiomeOutlineCache();
    snapDirty = true;
  }

  public boolean cellInZone(int cellIdx, int zoneIdx) {
    if (zones == null || zoneIdx < 0 || zoneIdx >= zones.size()) return false;
    MapZone az = zones.get(zoneIdx);
    if (az == null) return false;
    return az.cells.contains(cellIdx);
  }

  public void floodFillZone(Cell start, int zoneIdx) {
    if (start == null) return;
    int startIndex = indexOfCell(start);
    if (startIndex < 0) return;
    int n = cells.size();
    if (n == 0) return;
    ensureCellNeighborsComputed();
    boolean[] visited = new boolean[n];
    int[] stack = new int[n];
    int stackSize = 0;
    stack[stackSize++] = startIndex;
    visited[startIndex] = true;
    while (stackSize > 0) {
      int idx = stack[--stackSize];
      addCellToZone(idx, zoneIdx);
      ArrayList<Integer> nbs = (idx < cellNeighbors.size()) ? cellNeighbors.get(idx) : null;
      if (nbs == null) continue;
      for (int nb : nbs) {
        if (nb < 0 || nb >= n) continue;
        if (visited[nb]) continue;
        visited[nb] = true;
        stack[stackSize++] = nb;
      }
    }
  }

  public boolean cellsAreNeighbors(Cell a, Cell b, float eps) {
    if (a.vertices == null || b.vertices == null) return false;
    int shared = 0;

    for (int i = 0; i < a.vertices.size(); i++) {
      PVector va = a.vertices.get(i);
      for (int j = 0; j < b.vertices.size(); j++) {
        PVector vb = b.vertices.get(j);
        float dx = va.x - vb.x;
        float dy = va.y - vb.y;
        if (dx * dx + dy * dy <= eps * eps) {
          shared++;
          if (shared >= 2) return true;
        }
      }
    }
    return false;
  }

  public void rebuildCellNeighbors() {
    cellNeighbors.clear();
    int n = cells.size();
    for (int i = 0; i < n; i++) {
      cellNeighbors.add(new ArrayList<Integer>());
    }

    if (n == 0) return;

    // Spatial binning to avoid O(n^2) all-pairs comparisons when many sites are present.
    float worldW = maxX - minX;
    float worldH = maxY - minY;
    float avgCellSize = sqrt((worldW * worldH) / max(1, n));
    float binSize = max(avgCellSize, 1e-3f);
    float invBin = 1.0f / binSize;
    float eps = 1e-4f;
    float[] minXs = new float[n];
    float[] minYs = new float[n];
    float[] maxXs = new float[n];
    float[] maxYs = new float[n];

    HashMap<Long, ArrayList<Integer>> bins = new HashMap<Long, ArrayList<Integer>>();

    for (int i = 0; i < n; i++) {
      Cell c = cells.get(i);
      if (c == null || c.vertices == null || c.vertices.size() < 2) continue;
      float minx = Float.MAX_VALUE;
      float miny = Float.MAX_VALUE;
      float maxx = -Float.MAX_VALUE;
      float maxy = -Float.MAX_VALUE;
      for (PVector v : c.vertices) {
        minx = min(minx, v.x);
        miny = min(miny, v.y);
        maxx = max(maxx, v.x);
        maxy = max(maxy, v.y);
      }
      minXs[i] = minx;
      minYs[i] = miny;
      maxXs[i] = maxx;
      maxYs[i] = maxy;

      int gx0 = (int)floor((minx - minX) * invBin);
      int gx1 = (int)floor((maxx - minX) * invBin);
      int gy0 = (int)floor((miny - minY) * invBin);
      int gy1 = (int)floor((maxy - minY) * invBin);
      for (int gx = gx0; gx <= gx1; gx++) {
        for (int gy = gy0; gy <= gy1; gy++) {
          long key = (((long)gx) << 32) ^ (gy & 0xffffffffL);
          ArrayList<Integer> bucket = bins.get(key);
          if (bucket == null) {
            bucket = new ArrayList<Integer>();
            bins.put(key, bucket);
          }
          bucket.add(i);
        }
      }
    }

    int[] seen = new int[n];
    int stamp = 1;

    for (int i = 0; i < n; i++) {
      Cell a = cells.get(i);
      if (a == null || a.vertices == null || a.vertices.size() < 2) continue;

      int gx0 = (int)floor((minXs[i] - minX) * invBin) - 1;
      int gx1 = (int)floor((maxXs[i] - minX) * invBin) + 1;
      int gy0 = (int)floor((minYs[i] - minY) * invBin) - 1;
      int gy1 = (int)floor((maxYs[i] - minY) * invBin) + 1;

      for (int gx = gx0; gx <= gx1; gx++) {
        for (int gy = gy0; gy <= gy1; gy++) {
          long key = (((long)gx) << 32) ^ (gy & 0xffffffffL);
          ArrayList<Integer> bucket = bins.get(key);
          if (bucket == null) continue;
          for (int idx : bucket) {
            if (idx <= i) continue;
            if (seen[idx] == stamp) continue;
            seen[idx] = stamp;
            // Quick AABB rejection before the expensive vertex test
            if (maxXs[i] + eps < minXs[idx] || minXs[i] - eps > maxXs[idx] ||
                maxYs[i] + eps < minYs[idx] || minYs[i] - eps > maxYs[idx]) {
              continue;
            }
            Cell b = cells.get(idx);
            if (b == null) continue;
            if (cellsAreNeighbors(a, b, eps)) {
              cellNeighbors.get(i).add(idx);
              cellNeighbors.get(idx).add(i);
            }
          }
        }
      }
      stamp++;
    }
  }


  // ---------- Sites generation ----------

  public void generateSites(PlacementMode mode, int targetCount) {
    generateSites(mode, targetCount, false);
  }

  public void generateSites(PlacementMode mode, int targetCount, boolean preserveCellData) {
    int clampedCount = constrain(targetCount, 0, MAX_SITE_COUNT);
    preservedCells = preserveCellData ? new ArrayList<Cell>(cells) : null;
    sites.clear();
    if (!preserveCellData && zones != null) {
      for (MapZone az : zones) {
        if (az != null) az.cells.clear();
      }
    }

    if (clampedCount <= 0) {
      markVoronoiDirty();
      snapDirty = true;
      return;
    }

    if (mode == PlacementMode.GRID) {
      generateGridSites(clampedCount);
    } else if (mode == PlacementMode.HEX) {
      generateHexSites(clampedCount);
    } else if (mode == PlacementMode.POISSON) {
      generatePoissonSites(clampedCount);
    }

    applyFuzz(siteFuzz);

    clearSiteSelection();
    if (!sites.isEmpty()) {
      sites.get(0).selected = true;
    }

    markVoronoiDirty();
    snapDirty = true;
  }

  public void applyElevationBrush(float cx, float cy, float radius, float delta, float seaLevel) {
    if (cells == null || cells.isEmpty()) return;
    float preMin = Float.MAX_VALUE;
    float preMax = -Float.MAX_VALUE;
    for (Cell c : cells) {
      preMin = min(preMin, c.elevation);
      preMax = max(preMax, c.elevation);
    }
    float r2 = radius * radius;
    for (Cell c : cells) {
      PVector cen = cellCentroid(c);
      float dx = cen.x - cx;
      float dy = cen.y - cy;
      float d2 = dx * dx + dy * dy;
      if (d2 > r2) continue;
      float t = 1.0f - sqrt(d2 / r2);
      c.elevation = c.elevation + delta * t;
    }
    normalizeElevationsIfOutOfBounds(seaLevel);
    invalidateContourCaches();
  }

  public PathType getPathType(int idx) {
    if (pathTypes == null) return null;
    if (idx < 0 || idx >= pathTypes.size()) return null;
    return pathTypes.get(idx);
  }

  public PathType makePathTypeFromPreset(int presetIndex) {
    if (presetIndex < 0) return null;
    int idx = min(presetIndex, PATH_TYPE_PRESETS.length - 1);
    PathTypePreset p = PATH_TYPE_PRESETS[idx];
    return new PathType(p.name, p.col, p.weightPx, p.minWeightPx, p.routeMode, p.slopeBias, p.avoidWater, p.taperOn);
  }

  public void generateElevationNoise(float scale, float amplitude, float seaLevel) {
    if (cells == null) return;
    float preMin = Float.MAX_VALUE;
    float preMax = -Float.MAX_VALUE;
    for (Cell c : cells) {
      preMin = min(preMin, c.elevation);
      preMax = max(preMax, c.elevation);
    }
    for (Cell c : cells) {
      PVector cen = cellCentroid(c);
      float n = noise(cen.x * scale, cen.y * scale);
      c.elevation = (n - 0.5f) * 2.0f * amplitude;
    }
    normalizeElevationsIfOutOfBounds(seaLevel);
    invalidateContourCaches();
  }

  public void addElevationVariation(float scale, float amplitude, float seaLevel) {
    if (cells == null) return;
    float preMin = Float.MAX_VALUE;
    float preMax = -Float.MAX_VALUE;
    for (Cell c : cells) {
      preMin = min(preMin, c.elevation);
      preMax = max(preMax, c.elevation);
    }
    for (Cell c : cells) {
      PVector cen = cellCentroid(c);
      float n = noise(cen.x * scale, cen.y * scale);
      float delta = (n - 0.5f) * 2.0f * amplitude;
      c.elevation = c.elevation + delta;
    }
    normalizeElevationsIfOutOfBounds(seaLevel);
    invalidateContourCaches();
  }

  public PVector cellCentroid(Cell c) {
    if (c.vertices == null || c.vertices.isEmpty()) {
      return new PVector(0, 0);
    }
    float cx = 0;
    float cy = 0;
    for (PVector v : c.vertices) {
      cx += v.x;
      cy += v.y;
    }
    cx /= c.vertices.size();
    cy /= c.vertices.size();
    return new PVector(cx, cy);
  }

  public void normalizeElevationsIfOutOfBounds(float seaLevel) {
    float newMin = Float.MAX_VALUE;
    float newMax = -Float.MAX_VALUE;
    for (Cell c : cells) {
      newMin = min(newMin, c.elevation);
      newMax = max(newMax, c.elevation);
    }
    // Keep elevations within [-1, 1] by re-scaling only the side that exceeds,
    // leaving the opposite side untouched relative to sea level.
    float maxLimit = 1.0f;
    float minLimit = -1.0f;

    if (newMax > maxLimit) {
      float fromRange = newMax - seaLevel;
      float toRange = maxLimit - seaLevel;
      if (fromRange > 1e-6f && toRange > 1e-6f) {
        float scale = toRange / fromRange;
        for (Cell c : cells) {
          if (c.elevation > seaLevel) {
            c.elevation = seaLevel + (c.elevation - seaLevel) * scale;
          }
        }
      }
    }
    if (newMin < minLimit) {
      float fromRange = seaLevel - newMin;
      float toRange = seaLevel - minLimit;
      if (fromRange > 1e-6f && toRange > 1e-6f) {
        float scale = toRange / fromRange;
        for (Cell c : cells) {
          if (c.elevation < seaLevel) {
            c.elevation = seaLevel - (seaLevel - c.elevation) * scale;
          }
        }
      }
    }
  }

  // Fill all "None" zones by seeding random types and expanding through neighbors.
  // Existing non-None assignments remain and act as seeds for their own type.
  public void generateZonesFromSeeds() {
    generateZonesFromSeeds(-1);
  }

  public void generateZonesFromSeeds(int seedCountOverride) {
    if (cells == null || cells.isEmpty()) return;
    int typeCount = biomeTypes.size() - 1; // exclude "None"
    if (typeCount <= 0) return;

    ensureCellNeighborsComputed();

    int n = cells.size();
    int[] zoneMembership = null;
    if (zones != null && !zones.isEmpty()) {
      zoneMembership = new int[n];
      Arrays.fill(zoneMembership, -1);
      for (int zi = 0; zi < zones.size(); zi++) {
        MapZone z = zones.get(zi);
        if (z == null || z.cells == null) continue;
        for (int ci : z.cells) {
          if (ci >= 0 && ci < n) {
            zoneMembership[ci] = zi;
          }
        }
      }
    }

    ArrayList<PVector[]> pathSegs = collectAllPathSegments();

    int[] biomeForCell = new int[n];
    float[] biomeCost = new float[n];
    Arrays.fill(biomeForCell, -1);
    Arrays.fill(biomeCost, Float.MAX_VALUE);

    PriorityQueue<Integer> frontier = new PriorityQueue<Integer>(n, new Comparator<Integer>() {
      public int compare(Integer a, Integer b) {
        return Float.compare(biomeCost[a], biomeCost[b]);
      }
    });

    ArrayList<Integer> noneIndices = new ArrayList<Integer>();

    // Existing zones become seeds for their own type
    for (int i = 0; i < n; i++) {
      Cell c = cells.get(i);
      if (c.biomeId > 0) {
        biomeForCell[i] = c.biomeId;
        biomeCost[i] = 0.0f;
        frontier.add(i);
      } else {
        noneIndices.add(i);
      }
    }

    if (noneIndices.isEmpty()) return;

    // Add random seeds inside "None" cells to diversify coverage
    Collections.shuffle(noneIndices);
    int seedCount;
    if (seedCountOverride > 0) {
      seedCount = min(seedCountOverride, noneIndices.size());
    } else {
      float avgBiomeSubzoneSize = random(10.0f,200.0f);
      seedCount = floor(noneIndices.size()/avgBiomeSubzoneSize);
    }
    seedCount = max(1, min(seedCount, noneIndices.size()));
    for (int i = 0; i < seedCount; i++) {
      int idx = noneIndices.get(i);
      Cell c = cells.get(idx);
      int biomeId = 1 + (int)random(typeCount);
      c.biomeId = biomeId;
      biomeForCell[idx] = biomeId;
      biomeCost[idx] = 0.0f;
      frontier.add(idx);
    }

    // Multi-source weighted expansion to propagate seeds into remaining None cells
    float elevationPenaltyScale = 60.0f;
    float waterPenalty = 20.0f;
    float zoneBoundaryPenalty = 6.0f;
    float pathCrossPenalty = 10.0f;

    while (!frontier.isEmpty()) {
      int idx = frontier.poll();
      if (idx < 0 || idx >= n) continue;
      int biomeId = biomeForCell[idx];
      if (biomeId <= 0) continue;
      float baseCost = biomeCost[idx];
      ArrayList<Integer> nbs = (idx < cellNeighbors.size()) ? cellNeighbors.get(idx) : null;
      if (nbs == null) continue;
      Cell c = cells.get(idx);
      for (int nb : nbs) {
        if (nb < 0 || nb >= n) continue;
        Cell nc = cells.get(nb);
        float step = 1.0f;
        if (c != null && nc != null) {
          float elevDiff = abs(c.elevation - nc.elevation);
          step += elevDiff * elevationPenaltyScale;
          boolean waterChange = (c.elevation < seaLevel) != (nc.elevation < seaLevel);
          if (waterChange) step += waterPenalty;
          if (zoneMembership != null) {
            int za = zoneMembership[idx];
            int zb = zoneMembership[nb];
            if (za >= 0 && zb >= 0 && za != zb) {
              step += zoneBoundaryPenalty;
            }
          }
          if (pathSegs != null && !pathSegs.isEmpty()) {
            PVector[] edge = sharedEdgeBetweenCells(c, nc);
            if (edge != null && edgeCrossesAnyPath(edge, pathSegs)) {
              step += pathCrossPenalty;
            }
          }
        }

        float newCost = baseCost + step;
        if (newCost < biomeCost[nb]) {
          biomeCost[nb] = newCost;
          biomeForCell[nb] = biomeId;
          frontier.add(nb);
        }
      }
    }

    // Write back propagated biomes
    for (int i = 0; i < n; i++) {
      int biomeId = biomeForCell[i];
      if (biomeId > 0) {
        cells.get(i).biomeId = biomeId;
      }
    }
  }

  public void resetAllBiomesToNone() {
    if (cells == null || cells.isEmpty()) return;
    for (Cell c : cells) {
      c.biomeId = 0;
    }
    renderer.invalidateBiomeOutlineCache();
    snapDirty = true;
  }

  public void setAllBiomesTo(int biomeId) {
    if (cells == null || cells.isEmpty()) return;
    int bid = max(0, min(biomeId, biomeTypes.size() - 1));
    for (Cell c : cells) {
      c.biomeId = bid;
    }
    renderer.invalidateBiomeOutlineCache();
    snapDirty = true;
  }

  public void setUnderwaterToBiome(int biomeId, float sea) {
    if (cells == null || cells.isEmpty()) return;
    for (Cell c : cells) {
      if (c.elevation < sea) {
        c.biomeId = biomeId;
      }
    }
    snapDirty = true;
  }

  public void fillUnderThreshold(int biomeId, float threshold) {
    if (cells == null || cells.isEmpty()) return;
    for (Cell c : cells) {
      if (c.elevation < threshold) c.biomeId = biomeId;
    }
    renderer.invalidateBiomeOutlineCache();
    snapDirty = true;
  }

  public void fillAboveThreshold(int biomeId, float threshold) {
    if (cells == null || cells.isEmpty()) return;
    for (Cell c : cells) {
      if (c.elevation > threshold) c.biomeId = biomeId;
    }
    renderer.invalidateBiomeOutlineCache();
    snapDirty = true;
  }

  public void fillGapsFromExistingBiomes() {
    if (cells == null || cells.isEmpty()) return;
    ensureCellNeighborsComputed();
    int n = cells.size();
    int[] biomeForCell = new int[n];
    Arrays.fill(biomeForCell, -1);
    ArrayDeque<Integer> q = new ArrayDeque<Integer>();
    int seeds = 0;
    for (int i = 0; i < n; i++) {
      Cell c = cells.get(i);
      if (c.biomeId > 0) {
        biomeForCell[i] = c.biomeId;
        q.add(i);
        seeds++;
      }
    }
    if (seeds == 0) {
      generateZonesFromSeeds();
      return;
    }
    while (!q.isEmpty()) {
      int idx = q.poll();
      int bid = biomeForCell[idx];
      ArrayList<Integer> nbs = (idx < cellNeighbors.size()) ? cellNeighbors.get(idx) : null;
      if (nbs == null) continue;
      for (int nb : nbs) {
        if (nb < 0 || nb >= n) continue;
        if (biomeForCell[nb] == -1) {
          biomeForCell[nb] = bid;
          q.add(nb);
        }
      }
    }
    for (int i = 0; i < n; i++) {
      if (biomeForCell[i] > 0) cells.get(i).biomeId = biomeForCell[i];
    }
    renderer.invalidateBiomeOutlineCache();
    snapDirty = true;
  }

  public void fillGapsWithNewBiomes(float avgSize) {
    fillGapsWithNewBiomesInternal(-1, avgSize);
  }

  public void fillGapsWithNewBiomesByCount(int seedCount) {
    fillGapsWithNewBiomesInternal(max(1, seedCount), -1);
  }

  public void fillGapsWithNewBiomesInternal(int desiredSeedCount, float avgSize) {
    if (cells == null || cells.isEmpty()) return;
    ensureCellNeighborsComputed();
    int n = cells.size();
    int typeCount = biomeTypes.size() - 1; // exclude None
    if (typeCount <= 0) return;

    ArrayList<Integer> gaps = new ArrayList<Integer>();
    for (int i = 0; i < n; i++) {
      Cell c = cells.get(i);
      if (c != null && c.biomeId == 0) {
        gaps.add(i);
      }
    }
    if (gaps.isEmpty()) return;

    Collections.shuffle(gaps);
    int[] assign = new int[n];
    Arrays.fill(assign, -1);
    ArrayDeque<Integer> q = new ArrayDeque<Integer>();

    int seedCount;
    if (desiredSeedCount > 0) {
      seedCount = min(desiredSeedCount, gaps.size());
    } else {
      seedCount = max(1, min(gaps.size(), round(gaps.size() / avgSize)));
    }
    for (int i = 0; i < seedCount; i++) {
      int idx = gaps.get(i);
      int bid = 1 + (int)random(typeCount);
      assign[idx] = bid;
      q.add(idx);
    }

    while (!q.isEmpty()) {
      int idx = q.poll();
      ArrayList<Integer> nbs = (idx < cellNeighbors.size()) ? cellNeighbors.get(idx) : null;
      if (nbs == null) continue;
      for (int nb : nbs) {
        if (nb < 0 || nb >= n) continue;
        if (assign[nb] != -1) continue;
        Cell nc = cells.get(nb);
        if (nc == null || nc.biomeId != 0) continue; // only fill previous gaps
        assign[nb] = assign[idx];
        q.add(nb);
      }
    }

    for (int i = 0; i < n; i++) {
      if (assign[i] >= 0) {
        cells.get(i).biomeId = assign[i];
      }
    }
    renderer.invalidateBiomeOutlineCache();
    snapDirty = true;
  }

  public void extendBiomeOnce(int biomeId) {
    if (cells == null || cells.isEmpty()) return;
    ensureCellNeighborsComputed();
    int bid = max(0, min(biomeId, biomeTypes.size() - 1));
    HashSet<Integer> toPaint = new HashSet<Integer>();
    int n = cells.size();
    for (int i = 0; i < n; i++) {
      Cell c = cells.get(i);
      if (c == null || c.biomeId != bid) continue;
      ArrayList<Integer> nbs = cellNeighbors.get(i);
      if (nbs == null) continue;
      for (int nb : nbs) {
        if (nb < 0 || nb >= n) continue;
        Cell nc = cells.get(nb);
        if (nc == null) continue;
        if (nc.biomeId != bid) toPaint.add(nb);
      }
    }
    for (int idx : toPaint) {
      cells.get(idx).biomeId = bid;
    }
    renderer.invalidateBiomeOutlineCache();
    snapDirty = true;
  }

  public void shrinkBiomeOnce(int biomeId) {
    if (cells == null || cells.isEmpty()) return;
    ensureCellNeighborsComputed();
    int bid = max(0, min(biomeId, biomeTypes.size() - 1));
    int n = cells.size();
    int[] newBiome = new int[n];
    for (int i = 0; i < n; i++) newBiome[i] = cells.get(i).biomeId;
    for (int i = 0; i < n; i++) {
      Cell c = cells.get(i);
      if (c == null || c.biomeId != bid) continue;
      ArrayList<Integer> nbs = cellNeighbors.get(i);
      if (nbs == null) continue;
      int boundary = 0;
      for (int nb : nbs) {
        if (nb < 0 || nb >= n) continue;
        Cell nc = cells.get(nb);
        if (nc == null) continue;
        if (nc.biomeId != bid) boundary++;
      }
      if (boundary > 0) {
        int bestBiome = 0;
        float bestDiff = Float.MAX_VALUE;
        for (int nb : nbs) {
          if (nb < 0 || nb >= n) continue;
          Cell nc = cells.get(nb);
          if (nc == null || nc.biomeId == bid) continue;
          float diff = abs(nc.elevation - c.elevation);
          if (diff < bestDiff) {
            bestDiff = diff;
            bestBiome = nc.biomeId;
          }
        }
        if (bestBiome != bid && bestBiome >= 0) {
          newBiome[i] = bestBiome;
        }
      }
    }
    for (int i = 0; i < n; i++) cells.get(i).biomeId = newBiome[i];
    renderer.invalidateBiomeOutlineCache();
    snapDirty = true;
  }

  public boolean placeBiomeSpotOnce(int biomeId, float value01) {
    if (cells == null || cells.isEmpty()) return false;
    ensureCellNeighborsComputed();
    int n = cells.size();
    boolean[] visited = new boolean[n];
    float total = 0;
    int regions = 0;
    for (int i = 0; i < n; i++) {
      if (visited[i]) continue;
      Cell c = cells.get(i);
      if (c == null || c.biomeId <= 0) continue;
      int size = floodCountBiome(i, visited);
      if (size > 0) {
        total += size;
        regions++;
      }
    }
    float avg = (regions > 0) ? (total / regions) : 1.0f;
    int targetSize = max(1, round(avg * value01 * 2.0f));
    int startIdx = (int)random(n);
    int tries = 0;
    while (tries < 200 && (startIdx < 0 || startIdx >= n || cells.get(startIdx) == null || cells.get(startIdx).biomeId == biomeId)) {
      startIdx = (int)random(n);
      tries++;
    }
    if (startIdx < 0 || startIdx >= n) return false;
    ArrayDeque<Integer> q = new ArrayDeque<Integer>();
    HashSet<Integer> claimed = new HashSet<Integer>();
    q.add(startIdx);
    claimed.add(startIdx);
    while (!q.isEmpty() && claimed.size() < targetSize) {
      int idx = q.poll();
      ArrayList<Integer> nbs = (idx < cellNeighbors.size()) ? cellNeighbors.get(idx) : null;
      if (nbs == null) continue;
      Collections.shuffle(nbs);
      for (int nb : nbs) {
        if (nb < 0 || nb >= n) continue;
        if (claimed.contains(nb)) continue;
        claimed.add(nb);
        q.add(nb);
        if (claimed.size() >= targetSize) break;
      }
    }
    boolean changed = false;
    for (int idx : claimed) {
      Cell c = cells.get(idx);
      if (c != null && c.biomeId != biomeId) {
        c.biomeId = biomeId;
        changed = true;
      }
    }
    return changed;
  }

  public void placeBiomeSpots(int biomeId, float value01) {
    boolean changed = placeBiomeSpotOnce(biomeId, value01);
    if (changed) {
      renderer.invalidateBiomeOutlineCache();
      snapDirty = true;
    }
  }

  public void placeBiomeSpots(int biomeId, int spotCount, float size01) {
    int count = max(1, spotCount);
    boolean changedAny = false;
    for (int i = 0; i < count; i++) {
      if (placeBiomeSpotOnce(biomeId, size01)) changedAny = true;
    }
    if (changedAny) {
      renderer.invalidateBiomeOutlineCache();
      snapDirty = true;
    }
  }

  public int floodCountBiome(int startIdx, boolean[] visited) {
    int n = cells.size();
    if (startIdx < 0 || startIdx >= n) return 0;
    int bid = cells.get(startIdx).biomeId;
    ArrayDeque<Integer> q = new ArrayDeque<Integer>();
    q.add(startIdx);
    visited[startIdx] = true;
    int count = 0;
    while (!q.isEmpty()) {
      int idx = q.poll();
      Cell c = cells.get(idx);
      if (c == null || c.biomeId != bid) continue;
      count++;
      ArrayList<Integer> nbs = cellNeighbors.get(idx);
      if (nbs == null) continue;
      for (int nb : nbs) {
        if (nb < 0 || nb >= n) continue;
        if (visited[nb]) continue;
        if (cells.get(nb) == null || cells.get(nb).biomeId != bid) continue;
        visited[nb] = true;
        q.add(nb);
      }
    }
    return count;
  }

  public void varyBiomesOnce() {
    if (cells == null || cells.isEmpty()) return;
    ensureCellNeighborsComputed();
    int n = cells.size();
    int[] newBiome = new int[n];
    for (int i = 0; i < n; i++) newBiome[i] = cells.get(i).biomeId;
    for (int i = 0; i < n; i++) {
      if (random(1.0f) < 0.1f) continue; // leave some cells unchanged to break oscillations
      ArrayList<Integer> nbs = cellNeighbors.get(i);
      if (nbs == null || nbs.isEmpty()) continue;
      int[] counts = new int[biomeTypes.size()];
      for (int nb : nbs) {
        if (nb < 0 || nb >= n) continue;
        Cell nc = cells.get(nb);
        if (nc == null) continue;
        int bid = max(0, min(nc.biomeId, biomeTypes.size() - 1));
        counts[bid]++;
      }
      // Pick the most common neighbor, break ties randomly, add slight jitter to avoid cycles
      float bestScore = -1;
      int best = cells.get(i).biomeId;
      for (int b = 0; b < counts.length; b++) {
        float score = counts[b] + random(0.0f, 0.25f);
        if (score > bestScore) {
          bestScore = score;
          best = b;
        }
      }
      // Occasionally pick a random neighbor biome to keep variation alive
      if (!nbs.isEmpty() && random(1.0f) < 0.2f) {
        int nb = nbs.get((int)random(nbs.size()));
        if (nb >= 0 && nb < n && cells.get(nb) != null) {
          best = max(0, min(cells.get(nb).biomeId, biomeTypes.size() - 1));
        }
      }
      newBiome[i] = best;
    }
    for (int i = 0; i < n; i++) cells.get(i).biomeId = newBiome[i];
    renderer.invalidateBiomeOutlineCache();
    snapDirty = true;
  }

  public void placeSliceSpot(int biomeId, float sizeParam, float level) {
    if (cells == null || cells.isEmpty()) return;
    ensureCellNeighborsComputed();
    int n = cells.size();
    int seedIdx = -1;
    int fallbackIdx = -1;
    float bestDiff = Float.MAX_VALUE;
    float bestAnyDiff = Float.MAX_VALUE;
    for (int i = 0; i < n; i++) {
      Cell c = cells.get(i);
      if (c == null) continue;
      float diff = abs(c.elevation - level);
      if (c.biomeId != biomeId) {
        if (diff < bestDiff) {
          bestDiff = diff;
          seedIdx = i;
        }
      }
      if (diff < bestAnyDiff) {
        bestAnyDiff = diff;
        fallbackIdx = i;
      }
    }
    if (seedIdx < 0) seedIdx = fallbackIdx;
    if (seedIdx < 0) return;

    // Map slider (0..1) to 1..100 target cells
    int targetCount = max(1, min(100, 1 + round(sizeParam * 99.0f)));
    HashSet<Integer> claimed = new HashSet<Integer>();
    PriorityQueue<Integer> frontier = new PriorityQueue<Integer>(new Comparator<Integer>() {
      public int compare(Integer a, Integer b) {
        float da = abs(cells.get(a).elevation - level);
        float db = abs(cells.get(b).elevation - level);
        return Float.compare(da, db);
      }
    });

    claimed.add(seedIdx);
    frontier.add(seedIdx);

    while (!frontier.isEmpty() && claimed.size() < targetCount) {
      int idx = frontier.poll();
      ArrayList<Integer> nbs = (idx < cellNeighbors.size()) ? cellNeighbors.get(idx) : null;
      if (nbs == null) continue;
      for (int nb : nbs) {
        if (nb < 0 || nb >= n) continue;
        if (claimed.contains(nb)) continue;
        Cell nc = cells.get(nb);
        if (nc == null) continue;
        claimed.add(nb);
        frontier.add(nb);
        if (claimed.size() >= targetCount) break;
      }
    }

    for (int idx : claimed) {
      Cell c = cells.get(idx);
      if (c != null) c.biomeId = biomeId;
    }
    renderer.invalidateBiomeOutlineCache();
    snapDirty = true;
  }

  public float sampleGridDistance(ContourGrid g, float x, float y) {
    if (g == null || g.cols < 2 || g.rows < 2) return Float.MAX_VALUE;
    float fx = constrain((x - g.ox) / max(1e-6f, g.dx), 0, g.cols - 1.0001f);
    float fy = constrain((y - g.oy) / max(1e-6f, g.dy), 0, g.rows - 1.0001f);
    int ix = floor(fx);
    int iy = floor(fy);
    float tx = fx - ix;
    float ty = fy - iy;
    float v00 = g.v[iy][ix];
    float v10 = g.v[iy][ix + 1];
    float v01 = g.v[iy + 1][ix];
    float v11 = g.v[iy + 1][ix + 1];
    float v0 = lerp(v00, v10, tx);
    float v1 = lerp(v01, v11, tx);
    float v = lerp(v0, v1, ty);
    return abs(v);
  }

  public boolean hasAnyNoneBiome() {
    if (cells == null || cells.isEmpty()) return false;
    for (Cell c : cells) {
      if (c.biomeId == 0) return true;
    }
    return false;
  }

  public void resetAllZonesToNone() {
    if (zones != null) zones.clear();
  }

  public void regenerateRandomZones(int targetZones) {
    if (cells == null || cells.isEmpty()) return;
    int n = cells.size();
    int zoneCount = max(1, targetZones);
    zones.clear();

    // Create zones with random hues (shared saturation/brightness)
    for (int i = 0; i < zoneCount; i++) {
      float h = pickMaxGapHue();
      int col = zoneColorForHue(h);
      MapZone z = new MapZone(randomLabelName(), col);
      z.hue01 = h;
      z.updateColorFromHSB();
      zones.add(z);
    }

    ensureCellNeighborsComputed();

    // Seed assignment (random cells become seeds)
    ArrayList<Integer> indices = new ArrayList<Integer>();
    for (int i = 0; i < n; i++) indices.add(i);
    Collections.shuffle(indices);

    int[] zoneForCell = new int[n];
    float[] zoneCost = new float[n];
    Arrays.fill(zoneForCell, -1);
    Arrays.fill(zoneCost, Float.MAX_VALUE);

    PriorityQueue<Integer> frontier = new PriorityQueue<Integer>(n, new Comparator<Integer>() {
      public int compare(Integer a, Integer b) {
        return Float.compare(zoneCost[a], zoneCost[b]);
      }
    });

    int idx = 0;
    for (int z = 0; z < zoneCount && idx < indices.size(); z++) {
      int ci = indices.get(idx++);
      zoneForCell[ci] = z;
      zoneCost[ci] = 0.0f;
      frontier.add(ci);
    }

    // Weighted expansion: discourage big elevation jumps and biome changes.
    float biomePenalty = 6.0f;
    float elevationPenaltyScale = 60.0f;
    float waterPenalty = 70.0f;

    while (!frontier.isEmpty()) {
      int ci = frontier.poll();
      float baseCost = zoneCost[ci];
      ArrayList<Integer> nbs = (ci < cellNeighbors.size()) ? cellNeighbors.get(ci) : null;
      if (nbs == null) continue;
      for (int nb : nbs) {
        if (nb < 0 || nb >= n) continue;
        float step = 1.0f;
        Cell ca = cells.get(ci);
        Cell cb = cells.get(nb);
        if (ca != null && cb != null) {
          if (ca.biomeId != cb.biomeId) step += biomePenalty;
          float elevDiff = abs(ca.elevation - cb.elevation);
          step += elevDiff * elevationPenaltyScale;
          boolean waterChange = (ca.elevation < seaLevel) != (cb.elevation < seaLevel);
          if (waterChange) step += waterPenalty;
        }

        float newCost = baseCost + step;
        if (newCost < zoneCost[nb]) {
          zoneCost[nb] = newCost;
          zoneForCell[nb] = zoneForCell[ci];
          frontier.add(nb);
        }
      }
    }

    // Write back memberships
    for (MapZone az : zones) {
      if (az != null) az.cells.clear();
    }
    for (int ci = 0; ci < n; ci++) {
      int z = zoneForCell[ci];
      if (z >= 0 && z < zones.size()) {
        zones.get(z).cells.add(ci);
      }
    }
  }

  public boolean hasAnyNoneZone() {
    if (zones == null || zones.isEmpty()) return true;
    for (MapZone az : zones) {
      if (az != null && az.cells.isEmpty()) return true;
    }
    return false;
  }

  public void ensureCellNeighborsComputed() {
    if (cellNeighbors == null || cellNeighbors.size() != cells.size()) {
      rebuildCellNeighbors();
    }
  }

  public void applyFuzz(float fuzz) {
    if (fuzz <= 0) return;
    if (sites.isEmpty()) return;

    float w = maxX - minX;
    float h = maxY - minY;
    float d = min(w, h);

    float maxOffset = fuzz * d / 10.0f;

    for (Site s : sites) {
      float dx = random(-maxOffset, maxOffset);
      float dy = random(-maxOffset, maxOffset);
      s.x = constrain(s.x + dx, minX, maxX);
      s.y = constrain(s.y + dy, minY, maxY);
    }
  }

  public void generateGridSites(int targetCount) {
    if (targetCount <= 0) return;
    int res = max(1, (int)ceil(sqrt(max(1, targetCount))));

    int cols = res;
    int rows = res;

    float w = maxX - minX;
    float h = maxY - minY;

    float dx = w / cols;
    float dy = h / rows;

    for (int j = 0; j < rows; j++) {
      for (int i = 0; i < cols; i++) {
        float x = minX + (i + 0.5f) * dx;
        float y = minY + (j + 0.5f) * dy;
        sites.add(new Site(x, y));
      }
    }
  }

  public void generateHexSites(int targetCount) {
    if (targetCount <= 0) return;
    int res = max(1, (int)ceil(sqrt(max(1, targetCount))));

    float w = maxX - minX;
    float h = maxY - minY;

    int cols = res;
    float dx = (cols > 1) ? w / (cols - 1) : w;

    float dy = dx * sqrt(3) / 2.0f;
    int rows = max(1, (int)ceil(h / dy) + 1);

    for (int j = 0; j < rows; j++) {
      float offset = (j % 2 == 0) ? 0.0f : dx * 0.5f;
      for (int i = -1; i <= cols; i++) {
        float x = minX + i * dx + offset;
        if (x < minX || x > maxX) continue;
        float y = minY + j * dy;
        if (y < minY || y > maxY) continue;
        sites.add(new Site(x, y));
      }
    }
  }

  public void generatePoissonSites(int targetCount) {
    if (targetCount <= 0) return;
    float w = maxX - minX;
    float h = maxY - minY;
    float area = max(1e-6f, w * h);

    // Radius tuned to aim for targetCount with comfortable spacing
    float r = sqrt(area / max(1, targetCount)) * 0.85f;

    float cellSize = r / sqrt(2);
    int gridW = (int)ceil(w / cellSize);
    int gridH = (int)ceil(h / cellSize);
    int[] grid = new int[gridW * gridH];
    for (int i = 0; i < grid.length; i++) grid[i] = -1;

    ArrayList<PVector> points = new ArrayList<PVector>();
    ArrayList<Integer> active = new ArrayList<Integer>();

    float x0 = random(minX, maxX);
    float y0 = random(minY, maxY);
      points.add(new PVector(x0, y0));
      active.add(0);

      int gx = (int)((x0 - minX) / cellSize);
      int gy = (int)((y0 - minY) / cellSize);
    if (gx >= 0 && gx < gridW && gy >= 0 && gy < gridH) {
      grid[gy * gridW + gx] = 0;
    }

    int k = 30;
    int maxPoints = max(1, min(targetCount, MAX_SITE_COUNT));

    while (!active.isEmpty() && points.size() < maxPoints) {
      int idx = active.get((int)random(active.size()));
      PVector p = points.get(idx);
      boolean found = false;

      for (int attempt = 0; attempt < k; attempt++) {
        float angle = random(TWO_PI);
        float radius = r * (1 + random(1));
        float nx = p.x + cos(angle) * radius;
        float ny = p.y + sin(angle) * radius;

        if (nx < minX || nx > maxX || ny < minY || ny > maxY) continue;

        int ngx2 = (int)((nx - minX) / cellSize);
        int ngy2 = (int)((ny - minY) / cellSize);

        boolean ok = true;
        for (int yy = max(0, ngy2 - 2); yy <= min(gridH - 1, ngy2 + 2) && ok; yy++) {
          for (int xx = max(0, ngx2 - 2); xx <= min(gridW - 1, ngx2 + 2) && ok; xx++) {
            int pi = grid[yy * gridW + xx];
            if (pi != -1) {
              PVector op = points.get(pi);
              float dx = op.x - nx;
              float dy = op.y - ny;
              if (dx * dx + dy * dy < r * r) {
                ok = false;
              }
            }
          }
        }

        if (ok) {
          int newIndex = points.size();
          points.add(new PVector(nx, ny));
          active.add(newIndex);
          grid[ngy2 * gridW + ngx2] = newIndex;
          found = true;
          break;
        }
      }

      if (!found) {
        active.remove((Integer)idx);
      }
    }

    // If generation collapses (too few points), fall back to a jittered grid to avoid empty maps.
    if (points.isEmpty()) {
      generateGridSites(targetCount);
      return;
    }

    for (int i = 0; i < points.size(); i++) {
      PVector p = points.get(i);
      sites.add(new Site(p.x, p.y));
    }
  }

  // ---------- Biome type management ----------

  public int defaultPatternIndexForBiome(int biomeIdx) {
    if (biomePatternCount <= 0) return 0;
    return ((biomeIdx % biomePatternCount) + biomePatternCount) % biomePatternCount;
  }

  public void setBiomePatternFiles(ArrayList<String> files) {
    biomePatternFiles = (files != null) ? new ArrayList<String>(files) : new ArrayList<String>();
    biomePatternCount = max(1, biomePatternFiles.size());
    syncBiomePatternAssignments();
  }

  public void syncBiomePatternAssignments() {
    if (biomeTypes == null) return;
    for (int i = 0; i < biomeTypes.size(); i++) {
      ZoneType z = biomeTypes.get(i);
      if (z == null) continue;
      if (z.patternIndex < 0 || z.patternIndex >= biomePatternCount) {
        z.patternIndex = defaultPatternIndexForBiome(i);
      }
    }
  }

  public String biomePatternNameForIndex(int patternIdx, String fallback) {
    if (biomePatternFiles == null || biomePatternFiles.isEmpty() || biomePatternCount <= 0) return fallback;
    int idx = ((patternIdx % biomePatternFiles.size()) + biomePatternFiles.size()) % biomePatternFiles.size();
    idx = min(idx, biomePatternFiles.size() - 1);
    String name = biomePatternFiles.get(idx);
    if (name == null || name.length() == 0) return fallback;
    return name;
  }

  public boolean biomeNameExists(String name) {
    if (name == null || biomeTypes == null) return false;
    for (ZoneType zt : biomeTypes) {
      if (zt != null && zt.name != null && zt.name.equalsIgnoreCase(name)) return true;
    }
    return false;
  }

  public void addBiomeType() {
    int nonNoneCount = max(0, biomeTypes.size() - 1);
    ZonePreset preset = null;
    for (int pi = nonNoneCount; pi < ZONE_PRESETS.length; pi++) {
      ZonePreset cand = ZONE_PRESETS[pi];
      if (cand != null && cand.name != null && !biomeNameExists(cand.name)) {
        preset = cand;
        break;
      }
    }

    if (preset != null) {
      ZoneType z = new ZoneType(preset.name, preset.col);
      z.patternIndex = defaultPatternIndexForBiome(biomeTypes.size());
      biomeTypes.add(z);
    } else {
      // Fallback: rotate hue from last type
      int n = biomeTypes.size();
      float baseHue = 0.33f;
      float baseSat = 0.4f;
      float baseBri = 1.0f;
      if (n > 1) {
        ZoneType last = biomeTypes.get(n - 1);
        baseHue = (last.hue01 + 0.15f) % 1.0f;
        baseSat = last.sat01;
        baseBri = last.bri01;
      }
      int newIndex = n;
      String name = "Type " + newIndex;
      int col = hsb01ToARGB(baseHue, baseSat, baseBri, 1.0f);
      ZoneType z = new ZoneType(name, col);
      z.patternIndex = defaultPatternIndexForBiome(biomeTypes.size());
      biomeTypes.add(z);
    }
  }

  public void addZone() {
    float baseHue = (zones.isEmpty()) ? distributedHueForIndex(0) : pickMaxGapHue();
    int col = zoneColorForHue(baseHue);
    MapZone z = new MapZone(randomLabelName(), col);
    z.hue01 = baseHue;
    z.updateColorFromHSB();
    zones.add(z);
  }

  public void addPathType(PathType pt) {
    if (pt == null) return;
    pathTypes.add(pt);
  }

  public void removePathType(int idx) {
    if (idx <= 0) return; // keep first as default
    if (idx < 0 || idx >= pathTypes.size()) return;
    pathTypes.remove(idx);
    for (Path p : paths) {
      if (p.typeId == idx) p.typeId = 0;
      else if (p.typeId > idx) p.typeId -= 1;
    }
  }

  public void removeBiomeType(int index) {
    if (index <= 0) return; // don't remove "None"
    if (index >= biomeTypes.size()) return;

    biomeTypes.remove(index);

    // Fix biome indices in cells: shift down
    for (Cell c : cells) {
      if (c.biomeId == index) {
        c.biomeId = 0; // reset to None
      } else if (c.biomeId > index) {
        c.biomeId -= 1;
      }
    }
    renderer.invalidateBiomeOutlineCache();
  }

  public void removeZone(int index) {
    if (index < 0 || index >= zones.size()) return;
    zones.remove(index);
    renderer.invalidateBiomeOutlineCache();
  }

  public void markRenderCacheDirty() {
    renderer.invalidateBiomeOutlineCache();
    invalidateContourCaches();
  }

  public ArrayList<PVector> findSnapPathBidirectional(String kFrom, String kTo, boolean favorFlat,
                                               HashMap<String, PVector> snapNodes,
                                               HashMap<String, ArrayList<String>> snapAdj) {
    ArrayList<PVector> result = null;
    PVector target = snapNodes.get(kTo);
    PVector startP = snapNodes.get(kFrom);
    if (startP == null || target == null) return null;

    HashMap<String, Float> distF = new HashMap<String, Float>();
    HashMap<String, Float> distB = new HashMap<String, Float>();
    HashMap<String, String> prevF = new HashMap<String, String>();
    HashMap<String, String> prevB = new HashMap<String, String>();
    HashSet<String> closedF = new HashSet<String>();
    HashSet<String> closedB = new HashSet<String>();
    PriorityQueue<NodeDist> pqF = new PriorityQueue<NodeDist>();
    PriorityQueue<NodeDist> pqB = new PriorityQueue<NodeDist>();

    distF.put(kFrom, 0.0f);
    distB.put(kTo, 0.0f);
    pqF.add(new NodeDist(kFrom, 0.0f, distSq(startP, target)));
    pqB.add(new NodeDist(kTo, 0.0f, distSq(target, startP)));

    float bestCost = Float.MAX_VALUE;
    String bestMeet = null;
    int expanded = 0;
    HashMap<String, Float> elevCache = new HashMap<String, Float>();

    while (!pqF.isEmpty() || !pqB.isEmpty()) {
      float fFront = pqF.isEmpty() ? Float.MAX_VALUE : pqF.peek().f;
      float fBack = pqB.isEmpty() ? Float.MAX_VALUE : pqB.peek().f;
      boolean expandFront = fFront <= fBack;
      PriorityQueue<NodeDist> pq = expandFront ? pqF : pqB;
      HashMap<String, Float> dist = expandFront ? distF : distB;
      HashMap<String, Float> distOther = expandFront ? distB : distF;
      HashMap<String, String> prev = expandFront ? prevF : prevB;
      HashSet<String> closed = expandFront ? closedF : closedB;

      if (pq.isEmpty()) break;
      NodeDist nd = pq.poll();
      Float bestD = dist.get(nd.k);
      if (bestD != null && nd.g > bestD + 1e-6f) continue;
      if (expanded++ > PATH_MAX_EXPANSIONS) break;
      closed.add(nd.k);

      Float otherCost = distOther.get(nd.k);
      if (otherCost != null) {
        float total = nd.g + otherCost;
        if (total < bestCost) {
          bestCost = total;
          bestMeet = nd.k;
        }
      }

      if (nd.f >= bestCost) continue;

      ArrayList<String> neighbors = snapAdj.get(nd.k);
      if (neighbors == null) continue;
      PVector p = snapNodes.get(nd.k);
      if (p == null) continue;

      for (String nb : neighbors) {
        if (closed.contains(nb)) continue;
        PVector np = snapNodes.get(nb);
        if (np == null) continue;

        float elevA = elevCache.containsKey(nd.k) ? elevCache.get(nd.k) : sampleElevationAt(p.x, p.y, seaLevel);
        float elevB = elevCache.containsKey(nb) ? elevCache.get(nb) : sampleElevationAt(np.x, np.y, seaLevel);
        elevCache.put(nd.k, elevA);
        elevCache.put(nb, elevB);

        float w = distSq(p, np);
        if (pathAvoidWater) {
          boolean aw = elevA < seaLevel;
          boolean bw = elevB < seaLevel;
          if (aw || bw) w *= 1e6f;
        }
        if (favorFlat) {
          float dh = abs(elevB - elevA);
          w *= (1.0f + dh * flattestSlopeBias);
        }

        float ng = nd.g + w;
        Float curD = dist.get(nb);
        if (curD == null || ng < curD - 1e-6f) {
          dist.put(nb, ng);
          prev.put(nb, nd.k);
          float h = expandFront ? distSq(np, target) : distSq(np, startP);
          pq.add(new NodeDist(nb, ng, ng + h * 0.5f));
        }
      }
    }

    if (bestMeet != null) {
      ArrayList<PVector> forward = reconstructPath(prevF, kFrom, bestMeet);
      ArrayList<PVector> backward = reconstructPath(prevB, kTo, bestMeet);
      if (forward != null && backward != null) {
        Collections.reverse(backward);
        if (!backward.isEmpty()) backward.remove(0); // drop duplicate meet
        forward.addAll(backward);
        result = forward;
      }
    } else {
      // fallback: try one-sided best effort
      result = reconstructPath(prevF, kFrom, kTo);
    }

    lastPathfindExpanded = expanded;
    return result;
  }

  // ---------- Structure auto-generation ----------
  public void generateStructuresAuto(int townCount, float buildingDensity, float sea) {
    if (townCount < 0) townCount = 0;
    buildingDensity = constrain(buildingDensity, 0, 1);
    if (structures == null) structures = new ArrayList<Structure>();

    // Base size heuristic from existing structures
    float baseSize = 0.02f;
    if (!structures.isEmpty()) {
      ArrayList<Float> sizes = new ArrayList<Float>();
      for (Structure s : structures) if (s != null && s.size > 1e-6f) sizes.add(s.size);
    if (!sizes.isEmpty()) {
      Collections.sort(sizes);
      baseSize = sizes.get(sizes.size() / 2);
    }
  }
  float townSize = baseSize * 2.5f;
  float buildingSize = baseSize * (0.4f + 0.5f * (1 - buildingDensity));

    // Collect candidate points for towns
    class Cand {
      PVector p;
      float score;
      Cand(PVector p, float s) { this.p = p; this.score = s; }
    }
    ArrayList<Cand> cands = new ArrayList<Cand>();

    // Zone centroids
    if (zones != null && !zones.isEmpty()) {
      for (MapZone z : zones) {
        if (z == null || z.cells == null || z.cells.isEmpty()) continue;
        float cx = 0, cy = 0; int count = 0;
        for (int ci : z.cells) {
          if (ci < 0 || ci >= cells.size()) continue;
          Cell c = cells.get(ci);
          if (c == null || c.vertices == null || c.vertices.size() < 3) continue;
          PVector cen = cellCentroid(c);
          cx += cen.x; cy += cen.y; count++;
        }
        if (count > 0) {
          cx /= count; cy /= count;
          Cell nearest = nearestCell(cx, cy);
          if (nearest == null || nearest.elevation >= sea) {
            cands.add(new Cand(new PVector(cx, cy), 1.0f));
          }
        }
      }
    }

    // Path junctions (degree >= 3)
    if (paths != null) {
      HashMap<String, Integer> deg = new HashMap<String, Integer>();
      for (Path p : paths) {
        if (p == null || p.routes == null) continue;
        for (ArrayList<PVector> seg : p.routes) {
          if (seg == null || seg.size() < 2) continue;
          for (int i = 0; i < seg.size(); i++) {
            PVector v = seg.get(i);
            String key = keyFor(v.x, v.y);
            deg.put(key, deg.getOrDefault(key, 0) + 1);
          }
        }
      }
      for (Map.Entry<String, Integer> e : deg.entrySet()) {
        if (e.getValue() < 3) continue;
        PVector v = parseKey(e.getKey());
        if (v != null) {
          Cell nearest = nearestCell(v.x, v.y);
          if (nearest == null || nearest.elevation >= sea) {
            cands.add(new Cand(v, 0.8f));
          }
        }
      }
    }

    // Coastline-adjacent land cells
    if (cells != null) {
      ensureCellNeighborsComputed();
      for (int ci = 0; ci < cells.size(); ci++) {
        Cell a = cells.get(ci);
        if (a == null || a.vertices == null) continue;
        if (a.elevation < sea) continue;
        ArrayList<Integer> nbs = (ci < cellNeighbors.size()) ? cellNeighbors.get(ci) : null;
        if (nbs == null) continue;
        boolean coastal = false;
        for (int nb : nbs) {
          if (nb < 0 || nb >= cells.size()) continue;
          Cell b = cells.get(nb);
          if (b != null && b.elevation < sea) { coastal = true; break; }
        }
        if (coastal) {
          PVector cen = cellCentroid(a);
          cands.add(new Cand(cen, 0.6f));
        }
      }
    }

    // Fallback when no interesting spots are found
    if (cands.isEmpty()) {
      if (cells != null && !cells.isEmpty()) {
        for (int i = 0; i < min(8, cells.size()); i++) {
          Cell c = cells.get((i * 997) % cells.size());
          if (c == null || c.vertices == null || c.vertices.isEmpty()) continue;
          PVector cen = cellCentroid(c);
          if (cen == null) continue;
          float score = 0.4f;
          if (c.elevation >= sea) score = 0.8f;
          cands.add(new Cand(cen, score));
        }
      } else {
        cands.add(new Cand(new PVector(0, 0), 0.5f));
      }
    }

    // Prefer low/mid elevation (penalize high)
    float elevMin = sea;
    float elevMax = sea + 0.5f;
    for (Cand c : cands) {
      float e = elevMin;
      Cell nearest = nearestCell(c.p.x, c.p.y);
      if (nearest != null) e = nearest.elevation;
      float elevScore = 1.0f - constrain(map(e, elevMin, elevMax, 0, 1), 0, 1);
      c.score *= 0.4f + 0.6f * elevScore;
    }

    // Sort by score
    Collections.sort(cands, new Comparator<Cand>() {
      public int compare(Cand a, Cand b) { return Float.compare(b.score, a.score); }
    });

    // Place towns
    int placedTowns = 0;
    ArrayList<Structure> newStructs = new ArrayList<Structure>();
    ArrayList<PVector> townCenters = new ArrayList<PVector>();
    for (Cand c : cands) {
      if (placedTowns >= townCount) break;
      if (structuresOverlap(structures, c.p.x, c.p.y, townSize, 1.0f, 1.2f)) continue;
      if (structuresOverlap(newStructs, c.p.x, c.p.y, townSize, 1.0f, 1.2f)) continue;
      // Main circle
      Structure main = new Structure(c.p.x, c.p.y);
      main.shape = StructureShape.CIRCLE;
      main.aspect = 1.0f;
      main.size = townSize;
      main.setColor(color(255), 1.0f);
      main.strokeWeightPx = 1.5f;
      main.alpha01 = 1.0f;
      main.name = "";
      if (useDefaultStructureNames) main.name = "Town " + (placedTowns + 1);
      newStructs.add(main);
      townCenters.add(new PVector(c.p.x, c.p.y));

      int satellites = (int)random(1, 6);
      for (int i = 0; i < satellites; i++) {
        float ang = random(TWO_PI);
        float dist = townSize * random(0.8f, 1.6f);
        float sx = c.p.x + cos(ang) * dist;
        float sy = c.p.y + sin(ang) * dist;
        if (structuresOverlap(structures, sx, sy, townSize * 0.8f, 1.0f, 1.0f)) continue;
        if (structuresOverlap(newStructs, sx, sy, townSize * 0.8f, 1.0f, 1.0f)) continue;
        Structure sat = new Structure(sx, sy);
        sat.shape = StructureShape.CIRCLE;
        sat.aspect = 1.0f;
        sat.size = townSize * random(0.5f, 0.9f);
        sat.setColor(color(255), 1.0f);
        sat.strokeWeightPx = 1.5f;
        sat.alpha01 = 1.0f;
        sat.name = main.name;
        newStructs.add(sat);
      }
      placedTowns++;
    }

    // Buildings along paths
    if (paths != null && buildingDensity > 1e-4f) {
      float spacing = buildingSize * map(1 - buildingDensity, 0, 1, 3.5f, 8.0f);
      for (int pi = 0; pi < paths.size(); pi++) {
        Path p = paths.get(pi);
        if (p == null || p.routes == null) continue;
        for (ArrayList<PVector> route : p.routes) {
          if (route == null || route.size() < 2) continue;
          for (int i = 0; i < route.size() - 1; i++) {
            PVector a = route.get(i);
            PVector b = route.get(i + 1);
            float dx = b.x - a.x;
            float dy = b.y - a.y;
            float segLen = max(1e-6f, sqrt(dx * dx + dy * dy));
            int steps = max(1, (int)floor(segLen / spacing));
            float nx = -dy / segLen;
            float ny = dx / segLen;
            for (int s = 0; s < steps; s++) {
              float t = (s + 0.5f) / steps;
              float px = lerp(a.x, b.x, t);
              float py = lerp(a.y, b.y, t);
              // Require proximity to a town to cluster buildings
              boolean nearTown = townCenters.isEmpty(); // allow some placement if no towns exist
              for (PVector tc : townCenters) {
                float dxt = tc.x - px;
                float dyt = tc.y - py;
                float d2 = dxt * dxt + dyt * dyt;
                if (d2 < sq(townSize * 4.0f)) { nearTown = true; break; }
              }
              if (!nearTown) continue;
              Cell segCell = nearestCell(px, py);
              if (segCell != null && segCell.elevation < sea) continue;
              float offset = buildingSize * random(0.6f, 1.2f);
              float sx = px + nx * offset;
              float sy = py + ny * offset;
              float asp = random(0.8f, 1.4f);
              Cell offCell = nearestCell(sx, sy);
              if (offCell != null && offCell.elevation < sea) continue;
              if (structuresOverlap(structures, sx, sy, buildingSize, asp, 0.9f)) continue;
              if (structuresOverlap(newStructs, sx, sy, buildingSize, asp, 0.9f)) continue;

              StructureAttributes at = new StructureAttributes();
              at.name = "";
              at.size = buildingSize;
              at.shape = StructureShape.RECTANGLE;
              at.aspectRatio = asp;
              at.alignment = StructureSnapMode.NEXT_TO_PATH;
              at.hue01 = 0;
              at.sat01 = 0;
              at.alpha01 = 1.0f;
              at.strokeWeightPx = 1.2f;
              Structure st = computeSnappedStructure(sx, sy, at);
              st.setColor(color(255), 1.0f);
              st.strokeWeightPx = 1.2f;
              st.alpha01 = 1.0f;
              st.aspect = asp;
              st.name = "";
              newStructs.add(st);
            }
          }
        }
      }
    }

    structures.addAll(newStructs);
  }

  // ---------- Arbitrary label auto-generation ----------
  public void generateArbitraryLabels(float sea) {
    if (labels == null) labels = new ArrayList<MapLabel>();
    int target = (int)random(1, 11); // 1..10 labels
    float baseSize = labelSizeDefault();
    float worldW = maxX - minX;
    float worldH = maxY - minY;
    float spacing = max(worldW, worldH) * 0.01f;

    class LabelCand {
      PVector p;
      float score;
      boolean land;
      LabelCand(PVector p, float s, boolean land) { this.p = p; this.score = s; this.land = land; }
    }

    ArrayList<LabelCand> cands = new ArrayList<LabelCand>();
    boolean hasLand = false;
    if (cells != null && !cells.isEmpty()) {
      for (Cell c : cells) {
        if (c == null || c.vertices == null || c.vertices.size() < 3) continue;
        PVector cen = cellCentroid(c);
        if (cen == null) continue;
        boolean land = c.elevation >= sea;
        if (land) hasLand = true;
        float elevScore = land ? 1.0f : 0.4f;
        cands.add(new LabelCand(cen, elevScore, land));
      }
    }

    // Fallback candidates if no cells
    if (cands.isEmpty()) {
      cands.add(new LabelCand(new PVector((minX + maxX) * 0.5f, (minY + maxY) * 0.5f), 1.0f, true));
      cands.add(new LabelCand(new PVector(minX + worldW * 0.25f, minY + worldH * 0.25f), 0.6f, true));
      cands.add(new LabelCand(new PVector(minX + worldW * 0.75f, minY + worldH * 0.75f), 0.6f, true));
    }

    Collections.shuffle(cands);
    Collections.sort(cands, new Comparator<LabelCand>() {
      public int compare(LabelCand a, LabelCand b) { return Float.compare(b.score, a.score); }
    });

    ArrayList<MapLabel> newLabels = new ArrayList<MapLabel>();

    for (LabelCand cand : cands) {
      if (newLabels.size() >= target) break;
      if (hasLand && !cand.land) continue; // prefer land when available

      String name = randomLabelName();
      float rad = estimateLabelRadius(name, baseSize) + spacing;
      if (!labelSpotFree(cand.p.x, cand.p.y, rad, labels)) continue;
      if (!labelSpotFree(cand.p.x, cand.p.y, rad, newLabels)) continue;

      MapLabel lbl = new MapLabel(cand.p.x, cand.p.y, name);
      lbl.size = baseSize;
      newLabels.add(lbl);
    }

    // If still nothing, drop a couple in the center area
    int fallbackAttempts = 0;
    while (newLabels.size() < target && newLabels.size() < 3 && fallbackAttempts < 200) {
      fallbackAttempts++;
      float px = random(minX + worldW * 0.25f, maxX - worldW * 0.25f);
      float py = random(minY + worldH * 0.25f, maxY - worldH * 0.25f);
      String name = randomLabelName();
      float rad = estimateLabelRadius(name, baseSize) + spacing;
      if (!labelSpotFree(px, py, rad, labels)) continue;
      if (!labelSpotFree(px, py, rad, newLabels)) continue;
      MapLabel lbl = new MapLabel(px, py, name);
      lbl.size = baseSize;
      newLabels.add(lbl);
    }

    labels.addAll(newLabels);
  }

  public String randomLabelName() {
    String[] syll = {
      "an","bar","bel","cal","dun","el","fal","gal","hal","ir","jor","kel","lor","mor","nar","or","per","quil","ran","sar","tor","ur","val","wen","yor","zan","ther","lin","mon","ros","ith","del","mir","tash","glen","fen","sta","ver","dul","kri","sha"
    };
    int parts = 2 + (int)random(0, 2); // 2-3 parts
    StringBuilder sb = new StringBuilder();
    for (int i = 0; i < parts; i++) {
      sb.append(syll[(int)random(syll.length)]);
    }
    String raw = sb.toString();
    if (raw.length() == 0) return "Label";
    return raw.substring(0, 1).toUpperCase() + raw.substring(1).toLowerCase();
  }

  public float estimateLabelRadius(String txt, float size) {
    if (txt == null || txt.length() == 0) return size;
    float len = txt.length();
    return max(size * 0.6f, size * 0.32f * len);
  }

  public boolean labelSpotFree(float x, float y, float radius, ArrayList<MapLabel> list) {
    if (list == null) return true;
    for (MapLabel l : list) {
      if (l == null || l.text == null) continue;
      float otherR = estimateLabelRadius(l.text, l.size);
      float dx = l.x - x;
      float dy = l.y - y;
      float minDist = radius + otherR;
      if (dx * dx + dy * dy < minDist * minDist) return false;
    }
    return true;
  }
}





class MapRenderer {
  private final MapModel model;
  private final LabelRenderer labelRenderer;
  // Shared helpers for line caps and zone segments
  private class CapInfo {
    SegInfo seg;
    boolean atStart;
    float r;
    int col;
    CapInfo(SegInfo seg, boolean atStart, float r, int col) {
      this.seg = seg;
      this.atStart = atStart;
      this.r = r;
      this.col = col;
    }
  }
  private class SegInfo {
    PVector a, b;
    PVector origA, origB;
    float w;
    int col;
    int zoneId;
    SegInfo(PVector a, PVector b, PVector origA, PVector origB, float w, int col, int zoneId) {
      this.a = a;
      this.b = b;
      this.origA = origA;
      this.origB = origB;
      this.w = w;
      this.col = col;
      this.zoneId = zoneId;
    }
  }

  // Cached biome outline edges
  private ArrayList<PVector[]> cachedBiomeOutlineEdges = new ArrayList<PVector[]>();
  private ArrayList<Integer> cachedBiomeOutlineBiomes = new ArrayList<Integer>();
  private ArrayList<Boolean> cachedBiomeOutlineUnderwater = new ArrayList<Boolean>();
  private int cachedBiomeOutlineCellCount = -1;
  private int cachedBiomeOutlineChecksum = 0;
  private float cachedBiomeOutlineSeaLevel = Float.MAX_VALUE;
  private boolean drawRoundCaps = true;
  private PGraphics coastLayer;
  private int coastLayerHash = 0;
  private float coastLayerZoom = -1;
  private float coastLayerCenterX = Float.MAX_VALUE;
  private float coastLayerCenterY = Float.MAX_VALUE;
  private int coastLayerW = -1;
  private int coastLayerH = -1;
  private float coastLayerSeaLevel = Float.MAX_VALUE;
  private int coastLayerCellCount = -1;
  private PGraphics zoneLayer;
  private int zoneLayerHash = 0;
  private float zoneLayerZoom = -1;
  private float zoneLayerCenterX = Float.MAX_VALUE;
  private float zoneLayerCenterY = Float.MAX_VALUE;
  private int zoneLayerW = -1;
  private int zoneLayerH = -1;
  private int zoneLayerCellCount = -1;
  private int zoneLayerZoneCount = -1;
  private PGraphics biomeLandLayer;
  private PGraphics biomeWaterLayer;
  private int biomeLayerHash = 0;
  private float biomeLayerZoom = -1;
  private float biomeLayerCenterX = Float.MAX_VALUE;
  private float biomeLayerCenterY = Float.MAX_VALUE;
  private int biomeLayerW = -1;
  private int biomeLayerH = -1;
  private int biomeLayerCellCount = -1;
  private int biomeLayerBiomeCount = -1;
  private PGraphics biomeOutlineLayerLand;
  private PGraphics biomeOutlineLayerWater;
  private int biomeOutlineHash = 0;
  private float biomeOutlineZoom = -1;
  private float biomeOutlineCenterX = Float.MAX_VALUE;
  private float biomeOutlineCenterY = Float.MAX_VALUE;
  private int biomeOutlineW = -1;
  private int biomeOutlineH = -1;
  private int biomeOutlineCellCount = -1;
  private float biomeOutlineSeaLevel = Float.MAX_VALUE;
  private PGraphics cellBorderLayer;
  private int cellBorderHash = 0;
  private float cellBorderZoom = -1;
  private float cellBorderCenterX = Float.MAX_VALUE;
  private float cellBorderCenterY = Float.MAX_VALUE;
  private int cellBorderW = -1;
  private int cellBorderH = -1;
  private int cellBorderCellCount = -1;
  private PGraphics elevationLightLayer;
  private int elevationLightHashVal = 0;
  private float elevationLightZoom = -1;
  private float elevationLightCenterX = Float.MAX_VALUE;
  private float elevationLightCenterY = Float.MAX_VALUE;
  private int elevationLightW = -1;
  private int elevationLightH = -1;
  private float elevationLightSeaLevel = Float.MAX_VALUE;
  private int elevationLightCellCount = -1;
  private PGraphics elevationLineLayer;
  private int elevationLineHash = 0;
  private float elevationLineZoom = -1;
  private float elevationLineCenterX = Float.MAX_VALUE;
  private float elevationLineCenterY = Float.MAX_VALUE;
  private int elevationLineW = -1;
  private int elevationLineH = -1;
  private float elevationLineSeaLevel = Float.MAX_VALUE;
  private int elevationLineCellCount = -1;
  private PGraphics waterDetailLayer;
  private int waterDetailLayerHash = 0;
  private float waterDetailLayerZoom = -1;
  private float waterDetailLayerCenterX = Float.MAX_VALUE;
  private float waterDetailLayerCenterY = Float.MAX_VALUE;
  private int waterDetailLayerW = -1;
  private int waterDetailLayerH = -1;
  private float waterDetailLayerSeaLevel = Float.MAX_VALUE;
  private int waterDetailLayerCellCount = -1;
  private PImage noiseTex;
  private final int NOISE_TEX_SIZE = 1024;
  // Render prep staging (to spread heavy layer builds across frames)
  private final float[] hsbScratch = new float[3];
  // Layer dirty flags
  boolean coastDirty = true;
  boolean biomeDirty = true;
  boolean zoneDirty = true;
  boolean lightDirty = true;
  boolean biomeOutlineDirty = true;
  boolean waterDetailDirty = true;
  boolean cellBorderDirty = true;
  boolean elevationLineDirty = true;
  boolean fontPrepNeeded = true;
  private int renderPrepCompleted = 0;
  private int renderPrepTotal = 0;

  // Stroke helper: base size in screen px; returns world-space stroke that yields the desired on-screen width.
  public float strokeWorldPx(float basePx, boolean scaleWithZoom, float refZoom) {
    float b = max(0.01f, basePx);
    if (scaleWithZoom) {
      float ref = max(1e-6f, refZoom);
      b *= (viewport.zoom / ref);
    }
    return b / max(1e-6f, viewport.zoom);
  }

// Line intersection helper; returns null if nearly parallel.
  private PVector lineIntersection(PVector p1, PVector p2, PVector p3, PVector p4) {
    float x1 = p1.x, y1 = p1.y;
    float x2 = p2.x, y2 = p2.y;
    float x3 = p3.x, y3 = p3.y;
    float x4 = p4.x, y4 = p4.y;
    float denom = (y4 - y3) * (x2 - x1) - (x4 - x3) * (y2 - y1);
    if (abs(denom) < 1e-6f) return null;
    float ua = ((x4 - x3) * (y1 - y3) - (y4 - y3) * (x1 - x3)) / denom;
    float ix = x1 + ua * (x2 - x1);
    float iy = y1 + ua * (y2 - y1);
    return new PVector(ix, iy);
  }

  public void invalidateCoastCache() { coastDirty = true; waterDetailDirty = true; }
  public void invalidateWaterDetailLayer() { waterDetailDirty = true; }
  public void invalidateBiomeCache() { biomeDirty = true; biomeOutlineDirty = true; }
  public void invalidateBiomeOutlineLayer() { biomeOutlineDirty = true; }
  public void invalidateZoneCache() { zoneDirty = true; }
  public void invalidateLightCache() { lightDirty = true; }
  public void invalidateCellBorderLayer() { cellBorderDirty = true; }
  public void invalidateElevationLineLayer() { elevationLineDirty = true; }

  MapRenderer(MapModel model) {
    this.model = model;
    this.labelRenderer = new LabelRenderer(model);
  }

  public PGraphics getCoastLayer() { return coastLayer; }

  public void drawDebugWorldBounds(PApplet app) {
    app.pushStyle();
    app.noFill();
    app.stroke(0);
    // app.strokeCap(PConstants.ROUND);
    // app.strokeJoin(PConstants.ROUND);
    app.strokeWeight(1.5f / viewport.zoom);
    app.rect(model.minX, model.minY, model.maxX - model.minX, model.maxY - model.minY);
    app.popStyle();
  }

  public void drawSites(PApplet app) {
    if (model.sites == null) return;
    for (Site s : model.sites) {
      s.draw(app);
    }
  }

  public void drawCells(PApplet app) {
    drawCells(app, true);
  }

  public void drawCells(PApplet app, boolean showBorders) {
    if (model.cells == null) return;
    for (Cell c : model.cells) {
      c.draw(app, showBorders);
    }
  }

  public void drawCellsRender(PApplet app, boolean showBorders) {
    drawCellsRender(app, showBorders, false);
  }

  public void drawCellsRender(PApplet app, boolean showBorders, boolean desaturate) {
    if (model.cells == null) return;
    app.pushStyle();
    // app.strokeCap(PConstants.ROUND);
    // app.strokeJoin(PConstants.ROUND);
    float biomeAlphaScale = (currentTool == Tool.EDIT_ELEVATION) ? 0.8f : 1.0f;
    float[][] biomeHSB = null;
    if (desaturate && model.biomeTypes != null && !model.biomeTypes.isEmpty()) {
      int nb = model.biomeTypes.size();
      biomeHSB = new float[nb][3];
      for (int i = 0; i < nb; i++) {
        ZoneType zt = model.biomeTypes.get(i);
        if (zt == null) continue;
        rgbToHSB01(zt.col, biomeHSB[i]);
      }
    }
    for (Cell c : model.cells) {
      if (c.vertices == null || c.vertices.size() < 3) continue;
      int col = color(230);
      if (model.biomeTypes != null && c.biomeId >= 0 && c.biomeId < model.biomeTypes.size()) {
        ZoneType zt = model.biomeTypes.get(c.biomeId);
        col = zt.col;
      }
      if (c.elevation < seaLevel) {
        // Lightly tint underwater cells darker to acknowledge seaLevel
        col = lerpColor(col, color(30, 70, 120), 0.15f);
      }
      if (desaturate) {
      float[] hsb;
      if (biomeHSB != null && c.biomeId >= 0 && c.biomeId < biomeHSB.length && biomeHSB[c.biomeId] != null) {
        hsb = biomeHSB[c.biomeId];
      } else {
        hsb = hsbScratch;
        rgbToHSB01(col, hsb);
      }
      float sat = constrain(hsb[1] * 0.82f, 0, 1);
      float bri = constrain(hsb[2] * 1.05f, 0, 1);
      col = hsb01ToARGB(hsb[0], sat, bri, 1.0f);
      }

      app.fill(col, 255 * biomeAlphaScale);
      if (showBorders) {
        app.stroke(180);
        app.strokeWeight(1.0f / viewport.zoom);
      } else {
        // Use a thin stroke matching the fill to hide tiny AA gaps between adjacent polygons.
        app.stroke(col);
        app.strokeWeight(0.35f / viewport.zoom);
        // app.strokeJoin(PConstants.MITER);
        // app.strokeCap(PConstants.PROJECT);
      }

      app.beginShape();
      for (PVector v : c.vertices) {
        app.vertex(v.x, v.y);
      }
      app.endShape(CLOSE);
    }
    app.popStyle();
  }

  public void drawStructures(PApplet app) {
    if (model.structures == null) return;
    app.pushStyle();
    for (int i = 0; i < model.structures.size(); i++) {
      Structure s = model.structures.get(i);
      s.draw(app);
      if (isStructureSelected(i)) {
        app.pushStyle();
        app.noFill();
        app.stroke(255, 180, 0, 200);
        app.strokeWeight(3.0f / viewport.zoom);
        app.rectMode(CENTER);
        float pad = s.size * 0.15f;
        app.pushMatrix();
        app.translate(s.x, s.y);
        app.rotate(s.angle);
        float w = s.size;
        float h = (s.shape == StructureShape.RECTANGLE && s.aspect != 0) ? (s.size / max(0.1f, s.aspect)) : s.size;
        switch (s.shape) {
          case RECTANGLE:
            app.rect(0, 0, w + pad * 2, h + pad * 2);
            break;
          case CIRCLE: {
            float eh = s.size / max(0.1f, s.aspect);
            app.ellipse(0, 0, w + pad * 2, eh + pad * 2);
            break;
          }
          case TRIANGLE:
          case HEXAGON:
            app.scale(1.05f); // small inflate
            s.draw(app);
            break;
          default:
            app.rect(0, 0, w + pad * 2, w + pad * 2);
            break;
        }
        app.popMatrix();
        app.popStyle();
      }
    }
    app.popStyle();
  }

  public void drawStructuresRender(PApplet app, RenderSettings s) {
    if (model.structures == null || s == null) return;
    app.pushStyle();
    float az = radians(s.elevationLightAzimuthDeg);
    float altRad = radians(s.elevationLightAltitudeDeg);
    PVector shadowDir = new PVector(-cos(az), -sin(az));
    float tanAlt = max(0.1f, tan(altRad));
    float shadowLenFactor = constrain(0.1f / tanAlt, 0.01f, 0.5f);
    for (int i = 0; i < model.structures.size(); i++) {
      Structure st = model.structures.get(i);
      if (st == null) continue;
      float baseAlpha = st.alpha01 * s.structureAlphaScale01;
      if (baseAlpha <= 1e-4f) continue;
      rgbToHSB01(st.fillCol, hsbScratch);
      float sat = constrain(hsbScratch[1] * s.structureSatScale01, 0, 1);
      int col = hsb01ToARGB(hsbScratch[0], sat, hsbScratch[2], 1.0f);

      float shadowAlpha = baseAlpha * s.structureShadowAlpha01;
      float shadowLen = st.size * shadowLenFactor;
      if (s.structureStrokeScaleWithZoom) {
        float ref = (s.structureStrokeRefZoom > 1e-6f) ? s.structureStrokeRefZoom : DEFAULT_VIEW_ZOOM;
        shadowLen *= max(1e-6f, viewport.zoom) / ref;
      }
      if (shadowAlpha > 1e-4f && shadowLen > 1e-6f) {
        PVector off = PVector.mult(shadowDir, shadowLen);
        app.pushMatrix();
        app.translate(st.x + off.x, st.y + off.y);
        app.rotate(st.angle);
        app.noStroke();
        app.fill(0, 0, 0, shadowAlpha * 255);
        drawStructureShape(app, st);
        app.popMatrix();
      }

      app.pushMatrix();
      app.translate(st.x, st.y);
      app.rotate(st.angle);
      app.stroke(0, 0, 0, baseAlpha * 255);
      float stW = strokeWorldPx(max(0.1f, st.strokeWeightPx), s.structureStrokeScaleWithZoom, s.structureStrokeRefZoom);
      app.strokeWeight(stW);
      app.fill(col, baseAlpha * 255);
      drawStructureShape(app, st);
      app.popMatrix();
    }
    app.popStyle();
  }

  private void drawStructureShape(PApplet app, Structure st) {
    if (st == null) return;
    float r = st.size;
    float aspect = max(0.1f, st.aspect);
    switch (st.shape) {
      case RECTANGLE: {
        float w = r;
        float h = r / aspect;
        app.rectMode(CENTER);
        app.rect(0, 0, w, h);
        break;
      }
      case CIRCLE: {
        float w = r;
        float h = r / aspect;
        app.ellipse(0, 0, w, h);
        break;
      }
      case TRIANGLE: {
        float h = (r / max(1e-3f, sqrt(aspect))) * 0.866f; // keep triangle area reasonable when highly squashed
        app.beginShape();
        app.vertex(-r * 0.5f, h * 0.333f);
        app.vertex(r * 0.5f, h * 0.333f);
        app.vertex(0, -h * 0.666f);
        app.endShape(CLOSE);
        break;
      }
      case HEXAGON: {
        float rad = r * 0.5f;
        float sx = 1.0f;
        float sy = 1.0f / max(1e-3f, sqrt(aspect)); // soften distortion
        app.beginShape();
        for (int v = 0; v < 6; v++) {
          float a = radians(60 * v);
          app.vertex(cos(a) * rad * sx, sin(a) * rad * sy);
        }
        app.endShape(CLOSE);
        break;
      }
      default: {
        float sHalf = r * 0.5f;
        app.rectMode(CENTER);
        app.rect(0, 0, sHalf * 2, sHalf * 2 / aspect);
        break;
      }
    }
  }

  public void drawLabels(PApplet app) {
    labelRenderer.drawLabels(app);
  }

  public void drawLabelsRender(PApplet app, RenderSettings s) {
    labelRenderer.drawLabelsRender(app, s);
  }

  public void drawZoneLabelsRender(PApplet app, RenderSettings s) {
    labelRenderer.drawZoneLabelsRender(app, s);
  }

  public void drawPathLabelsRender(PApplet app, RenderSettings s) {
    labelRenderer.drawPathLabelsRender(app, s);
  }

  public void drawStructureLabelsRender(PApplet app, RenderSettings s) {
    labelRenderer.drawStructureLabelsRender(app, s);
  }

  // Build an offscreen label layer (JAVA2D preferred) and draw all render labels into it.
  public PGraphics buildLabelLayer(PApplet app, RenderSettings s) {
    return labelRenderer.buildLabelLayer(app, s);
  }

  public void warmLabelFonts(PApplet app, RenderSettings s) {
    labelRenderer.warmLabelFonts(app, s);
  }


  public void drawZoneOutlines(PApplet app) {
    if (model.cells == null || model.zones == null) return;
    model.ensureCellNeighborsComputed();
    int n = model.cells.size();
    if (n == 0 || model.zones.isEmpty()) return;

    // Zone memberships per cell (allow multiple zones); empty list = no zone.
    ArrayList<ArrayList<Integer>> zoneForCell = new ArrayList<ArrayList<Integer>>(n);
    for (int i = 0; i < n; i++) zoneForCell.add(new ArrayList<Integer>());
    for (int zi = 0; zi < model.zones.size(); zi++) {
      MapModel.MapZone z = model.zones.get(zi);
      if (z == null || z.cells == null) continue;
      for (int ci : z.cells) {
        if (ci < 0 || ci >= n) continue;
        ArrayList<Integer> list = zoneForCell.get(ci);
        if (!list.contains(zi)) list.add(zi);
      }
    }

    float eps2 = 1e-6f; // lenient match to avoid missing shared edges
    float baseW = 2.0f / viewport.zoom; // base stroke for zone outlines (editing view)
    float laneGap = baseW * 0.6f;       // gap between parallel lanes
    HashSet<String> drawn = new HashSet<String>();

    app.pushStyle();
    // app.strokeCap(PConstants.ROUND);
    // app.strokeJoin(PConstants.ROUND);
    app.noFill();

    for (int ci = 0; ci < n; ci++) {
      Cell c = model.cells.get(ci);
      if (c == null || c.vertices == null || c.vertices.size() < 3) continue;
      ArrayList<Integer> zonesA = zoneForCell.get(ci);
      if (zonesA == null || zonesA.isEmpty()) continue; // No zone -> no outline
      int vc = c.vertices.size();
      for (int e = 0; e < vc; e++) {
        PVector a = c.vertices.get(e);
        PVector b = c.vertices.get((e + 1) % vc);
        String key = undirectedEdgeKey(a, b);
        if (drawn.contains(key)) continue;

        ArrayList<Integer> zonesB = null;
        ArrayList<Integer> nbs = (ci < model.cellNeighbors.size()) ? model.cellNeighbors.get(ci) : null;
        if (nbs != null) {
          for (int nbIdx : nbs) {
            if (nbIdx < 0 || nbIdx >= n) continue;
            Cell nb = model.cells.get(nbIdx);
            if (nb == null || nb.vertices == null) continue;
            int nv = nb.vertices.size();
            boolean matched = false;
            for (int j = 0; j < nv; j++) {
              PVector na = nb.vertices.get(j);
              PVector nbp = nb.vertices.get((j + 1) % nv);
              boolean match = model.distSq(a, na) < eps2 && model.distSq(b, nbp) < eps2;
              boolean matchRev = model.distSq(a, nbp) < eps2 && model.distSq(b, na) < eps2;
              if (match || matchRev) {
                zonesB = zoneForCell.get(nbIdx);
                matched = true;
                break;
              }
            }
            if (matched) break;
          }
        }

        HashSet<Integer> setA = new HashSet<Integer>(zonesA);
        HashSet<Integer> setB = (zonesB != null) ? new HashSet<Integer>(zonesB) : new HashSet<Integer>();
        HashSet<Integer> uniqueA = new HashSet<Integer>(setA);
        uniqueA.removeAll(setB);
        HashSet<Integer> uniqueB = new HashSet<Integer>(setB);
        uniqueB.removeAll(setA);

        // Skip pure interior edges where memberships are identical
        if (uniqueA.isEmpty() && uniqueB.isEmpty()) {
          drawn.add(key);
          continue;
        }

        PVector cenA = model.cellCentroid(c);
        PVector mid = new PVector((a.x + b.x) * 0.5f, (a.y + b.y) * 0.5f);
        PVector edgeDir = new PVector(b.x - a.x, b.y - a.y);
        PVector nrm = new PVector(-edgeDir.y, edgeDir.x);
        float nLen = max(1e-6f, sqrt(nrm.x * nrm.x + nrm.y * nrm.y));
        nrm.mult(1.0f / nLen);
        // Orient normal toward cell A
        if (cenA != null) {
          PVector toCenter = PVector.sub(cenA, mid);
          if (toCenter.dot(nrm) < 0) nrm.mult(-1);
        }

        // Draw all differing zones with small per-zone offsets so they do not overlap.
        ArrayList<Integer> listA = new ArrayList<Integer>(uniqueA);
        ArrayList<Integer> listB = new ArrayList<Integer>(uniqueB);
        Collections.sort(listA);
        Collections.sort(listB);

        float offsetA = 0;
        for (int zId : listA) {
          if (zId < 0 || zId >= model.zones.size()) continue;
          float w = baseW;
          float lane = offsetA + w * 0.5f;
          app.stroke(model.zones.get(zId).col, 255);
          app.strokeWeight(w);
          app.line(a.x + nrm.x * lane, a.y + nrm.y * lane, b.x + nrm.x * lane, b.y + nrm.y * lane);
          offsetA += w + laneGap;
        }

        float offsetB = 0;
        for (int zId : listB) {
          if (zId < 0 || zId >= model.zones.size()) continue;
          float w = baseW;
          float lane = offsetB + w * 0.5f;
          app.stroke(model.zones.get(zId).col, 255);
          app.strokeWeight(w);
          app.line(a.x - nrm.x * lane, a.y - nrm.y * lane, b.x - nrm.x * lane, b.y - nrm.y * lane);
          offsetB += w + laneGap;
        }

        drawn.add(key);
      }
    }

    app.popStyle();
  }

  public void drawStructureSnapGuides(PApplet app,
                               boolean useWater, boolean useBiomes, boolean useUnderwaterBiomes, boolean useZones,
                               boolean usePaths, boolean useStructures, boolean useElevation,
                               int[] zoneMembership, int[] elevBuckets) {
    if (model.cells == null || model.cells.isEmpty()) return;
    model.ensureCellNeighborsComputed();

    app.pushStyle();
    int strokeCol = app.color(60, 120, 220, 190);
    app.stroke(strokeCol);
    app.strokeWeight(2.0f / viewport.zoom);
    app.noFill();

    if (useWater || useBiomes || useUnderwaterBiomes || useZones || useElevation) {
      int n = model.cells.size();
      for (int i = 0; i < n; i++) {
        Cell a = model.cells.get(i);
        ArrayList<Integer> nbs = model.cellNeighbors.get(i);
        if (nbs == null) continue;
        for (int nb : nbs) {
          if (nb <= i) continue;
          Cell b = model.cells.get(nb);
          if (!model.boundaryActiveForSnapping(a, b, i, nb, zoneMembership, elevBuckets,
                                               useWater, useBiomes, useUnderwaterBiomes, useZones, useElevation)) {
            continue;
          }

          ArrayList<PVector> va = a.vertices;
          ArrayList<PVector> vb = b.vertices;
          if (va == null || vb == null || va.size() < 2 || vb.size() < 2) continue;

          HashSet<String> edgesA = new HashSet<String>();
          int ac = va.size();
          for (int ai = 0; ai < ac; ai++) {
            PVector a0 = va.get(ai);
            PVector a1 = va.get((ai + 1) % ac);
            edgesA.add(undirectedEdgeKey(a0, a1));
          }
          int bc = vb.size();
          for (int bi = 0; bi < bc; bi++) {
            PVector b0 = vb.get(bi);
            PVector b1 = vb.get((bi + 1) % bc);
            String key = undirectedEdgeKey(b0, b1);
            if (edgesA.contains(key)) {
              app.line(b0.x, b0.y, b1.x, b1.y);
              edgesA.remove(key);
            }
          }
        }
      }
    }

    if (usePaths && model.paths != null) {
      app.stroke(strokeCol);
      app.strokeWeight(1.0f / viewport.zoom);
      for (Path p : model.paths) {
        if (p == null || p.routes == null) continue;
        for (ArrayList<PVector> seg : p.routes) {
          if (seg == null || seg.size() < 2) continue;
          for (int i = 0; i < seg.size() - 1; i++) {
            PVector a = seg.get(i);
            PVector b = seg.get(i + 1);
            app.line(a.x, a.y, b.x, b.y);
          }
        }
      }
    }

    if (useStructures && model.structures != null && !model.structures.isEmpty()) {
      app.stroke(strokeCol);
      app.strokeWeight(1.1f / viewport.zoom);
      app.noFill();
      for (Structure s : model.structures) {
        app.pushMatrix();
        app.translate(s.x, s.y);
        app.rotate(s.angle);
        float r = s.size;
        switch (s.shape) {
          case RECTANGLE: {
            float w = r;
            float h = (s.aspect != 0) ? (r / max(0.1f, s.aspect)) : r;
            app.rectMode(CENTER);
            app.rect(0, 0, w, h);
            break;
          }
          case CIRCLE: {
            app.ellipse(0, 0, r, r);
            break;
          }
          case TRIANGLE: {
            float h = r * 0.866f;
            app.beginShape();
            app.vertex(-r * 0.5f, h * 0.333f);
            app.vertex(r * 0.5f, h * 0.333f);
            app.vertex(0, -h * 0.666f);
            app.endShape(CLOSE);
            break;
          }
          case HEXAGON: {
            float rad = r * 0.5f;
            app.beginShape();
            for (int i = 0; i < 6; i++) {
              float a = radians(60 * i);
              app.vertex(cos(a) * rad, sin(a) * rad);
            }
            app.endShape(CLOSE);
            break;
          }
          default: {
            float sHalf = r * 0.5f;
            app.rectMode(CENTER);
            app.rect(0, 0, sHalf * 2, sHalf * 2);
            break;
          }
        }
        app.popMatrix();
      }
    }

    app.popStyle();
  }

  // New render view pipeline driven by RenderSettings
  public void drawRenderAdvanced(PApplet app, RenderSettings s, float seaLevel) {
    if (model == null || model.cells == null) return;
    app.pushStyle();
    if (s.antialiasing) app.smooth();

    int landBase = hsbColor(s.landHue01, s.landSat01, s.landBri01, 1.0f);
    int waterBase = hsbColor(s.waterHue01, s.waterSat01, s.waterBri01, 1.0f);
    int[] biomeScaledCols = buildBiomeScaledColors(s);
    HashMap<String, PImage> framePatternCache = new HashMap<String, PImage>();

    // Base fills: lay a solid water backdrop first, then paint emerged land only.
    app.noStroke();
    app.fill(waterBase);
    app.rect(model.minX, model.minY, model.maxX - model.minX, model.maxY - model.minY);
    for (Cell c : model.cells) {
      if (c == null || c.vertices == null || c.vertices.size() < 3) continue;
      if (c.elevation < seaLevel) continue;
      app.fill(landBase);
      drawPoly(app, c.vertices);
    }

    // Background noise overlay (monochrome, tiled texture cached once)
    if (s.backgroundNoiseAlpha01 > 1e-4f) {
      PImage ntex = getNoiseTexture(app);
      if (ntex != null) {
        float a = s.backgroundNoiseAlpha01;
        app.pushStyle();
        app.textureMode(PConstants.NORMAL);
        app.textureWrap(PConstants.REPEAT);
        // Land
        for (Cell c : model.cells) {
          if (c == null || c.vertices == null || c.vertices.size() < 3) continue;
          if (c.elevation < seaLevel) continue;
          drawPatternPoly(app, c.vertices, ntex, landBase, a);
        }
        // Water
        for (Cell c : model.cells) {
          if (c == null || c.vertices == null || c.vertices.size() < 3) continue;
          if (c.elevation >= seaLevel) continue;
          drawPatternPoly(app, c.vertices, ntex, waterBase, a);
        }
        app.popStyle();
      }
    }

    // Biome fills
    if (s.biomeFillAlpha01 > 1e-4f || s.biomeUnderwaterAlpha01 > 1e-4f) {
      app.noStroke();
      boolean usePattern = (s.biomeFillType == RenderFillType.RENDER_FILL_PATTERN || s.biomeFillType == RenderFillType.RENDER_FILL_PATTERN_BG);
      // Precompute biome patterns once per frame to avoid per-cell lookups.
      String fallbackPatternName = "";
      PImage fallbackPattern = null;
      PImage[] biomePatterns = null;
      if (usePattern) {
        fallbackPatternName = (s.biomePatternName != null && s.biomePatternName.length() > 0) ? s.biomePatternName : "";
        if (fallbackPatternName.length() == 0 && model.biomePatternFiles != null && !model.biomePatternFiles.isEmpty()) {
          fallbackPatternName = model.biomePatternFiles.get(0);
        }
        if (fallbackPatternName.length() > 0) {
          fallbackPattern = cachedPattern(framePatternCache, app, fallbackPatternName);
        }
        if (model.biomeTypes != null && !model.biomeTypes.isEmpty()) {
          int typeCount = model.biomeTypes.size();
          biomePatterns = new PImage[typeCount];
          for (int bi = 0; bi < typeCount; bi++) {
            ZoneType zt = model.biomeTypes.get(bi);
            String patName = (zt != null) ? model.biomePatternNameForIndex(zt.patternIndex, fallbackPatternName) : fallbackPatternName;
            biomePatterns[bi] = cachedPattern(framePatternCache, app, patName);
          }
        }
      }

      for (Cell c : model.cells) {
        if (c == null || c.vertices == null || c.vertices.size() < 3) continue;
        boolean isWater = c.elevation < seaLevel;
        if (isWater && s.biomeUnderwaterAlpha01 <= 1e-4f) continue;
        if (!isWater && s.biomeFillAlpha01 <= 1e-4f) continue;
        int col = landBase;
        if (biomeScaledCols != null && c.biomeId >= 0 && c.biomeId < biomeScaledCols.length) {
          col = biomeScaledCols[c.biomeId];
        }
        float a = isWater ? s.biomeUnderwaterAlpha01 : s.biomeFillAlpha01;
        PImage pattern = fallbackPattern;
        if (usePattern && biomePatterns != null && c.biomeId >= 0 && c.biomeId < biomePatterns.length) {
          pattern = biomePatterns[c.biomeId];
        }
        boolean canPattern = usePattern && pattern != null;
        if (usePattern && canPattern && s.biomeFillType == RenderFillType.RENDER_FILL_PATTERN) {
          drawPatternPoly(app, c.vertices, pattern, col, a);
        } else {
          app.fill(col, a * 255);
          drawPoly(app, c.vertices);
          if (usePattern && canPattern && s.biomeFillType == RenderFillType.RENDER_FILL_PATTERN_BG) {
            // Overlay black pattern on top of color
            drawPatternPoly(app, c.vertices, pattern, color(0, 0, 0), a);
          }
        }
      }
    }

    // Cell borders (layered to avoid alpha stacking)
    if (s.cellBorderAlpha01 > 1e-4f && s.cellBorderSizePx > 1e-4f) {
      ensureCellBorderLayer(app, s);
      if (cellBorderLayer != null) {
        app.pushMatrix();
        app.resetMatrix();
        app.tint(255, constrain(s.cellBorderAlpha01, 0, 1) * 255);
        app.image(cellBorderLayer, 0, 0);
        app.popMatrix();
      }
    } else {
      cellBorderLayer = null;
    }

    // Water depth shading
    if (s.waterDepthAlpha01 > 1e-4f) {
      app.noStroke();
      for (Cell c : model.cells) {
        if (c == null || c.vertices == null || c.vertices.size() < 3) continue;
        if (c.elevation < seaLevel) {
          float depth = seaLevel - c.elevation;
          float t = constrain(depth, 0, 1);
          float a = s.waterDepthAlpha01 * t;
          app.fill(0, 0, 0, a * 200);
          drawPoly(app, c.vertices);
        }
      }
    }

  // Elevation shading (land only) cached to a layer
  if (s.elevationLightAlpha01 > 1e-4f) {
    ensureElevationLightLayer(app, s, seaLevel);
    if (elevationLightLayer != null) {
      app.pushStyle();
      app.pushMatrix();
      app.resetMatrix();
      app.blendMode(PConstants.MULTIPLY);
      app.image(elevationLightLayer, 0, 0);
      app.blendMode(PConstants.BLEND);
      app.popMatrix();
      app.popStyle();
    }
  } else {
    elevationLightLayer = null;
    }

  // Coast outline (draw into cached layer to avoid alpha stacking at caps)
  boolean wantCoast = s.waterContourSizePx > 1e-4f && s.waterCoastAlpha01 > 1e-4f;
  if (wantCoast) {
    ensureCoastLayer(app, s, seaLevel);
    if (!s.waterCoastAboveZones && coastLayer != null) {
      app.pushStyle();
      app.pushMatrix();
      app.resetMatrix(); // draw in screen space to avoid double-transform
      app.tint(255, constrain(s.waterCoastAlpha01, 0, 1) * 255);
      app.image(coastLayer, 0, 0);
      app.popMatrix();
      app.popStyle();
    }
  } else {
    coastLayer = null;
  }

    // Water ripples + hatching (cached layer)
    boolean drawRipples = s.waterRippleCount > 0 &&
                          s.waterRippleDistancePx > 1e-4f &&
                          (s.waterRippleAlphaStart01 > 1e-4f || s.waterRippleAlphaEnd01 > 1e-4f);
    boolean drawHatching = s.waterHatchAlpha01 > 1e-4f &&
                           s.waterHatchLengthPx > 1e-4f &&
                           s.waterHatchSpacingPx > 1e-4f;
    if (drawRipples || drawHatching) {
      ensureWaterDetailLayer(app, s, seaLevel, drawRipples, drawHatching);
      if (waterDetailLayer != null) {
        app.pushMatrix();
        app.resetMatrix();
        app.tint(255);
        app.image(waterDetailLayer, 0, 0);
        app.popMatrix();
      }
    } else {
      waterDetailLayer = null;
    }

  // Elevation contour lines (land only)
  if (s.elevationLinesCount > 0 && s.elevationLinesAlpha01 > 1e-4f) {
      ensureElevationLineLayer(app, s, seaLevel);
      if (elevationLineLayer != null) {
        app.pushMatrix();
        app.resetMatrix();
        app.tint(255, constrain(s.elevationLinesAlpha01, 0, 1) * 255);
        app.image(elevationLineLayer, 0, 0);
        app.popMatrix();
      }
    } else {
      elevationLineLayer = null;
      elevationLineDirty = true;
    }

    // Biome outlines layer (composited to avoid alpha stacking)
    if (s.biomeOutlineSizePx > 1e-4f && (s.biomeOutlineAlpha01 > 1e-4f || s.biomeUnderwaterAlpha01 > 1e-4f)) {
      ensureBiomeOutlineLayer(app, s, seaLevel, landBase, biomeScaledCols);
      if (biomeOutlineLayerLand != null) {
        app.pushMatrix();
        app.resetMatrix();
        app.tint(255, constrain(s.biomeOutlineAlpha01, 0, 1) * 255);
        app.image(biomeOutlineLayerLand, 0, 0);
        app.popMatrix();
      }
      if (biomeOutlineLayerWater != null) {
        app.pushMatrix();
        app.resetMatrix();
        app.tint(255, constrain(s.biomeUnderwaterAlpha01, 0, 1) * 255);
        app.image(biomeOutlineLayerWater, 0, 0);
        app.popMatrix();
      }
    } else {
      biomeOutlineLayerLand = null;
      biomeOutlineLayerWater = null;
    }

    app.popStyle();
  }

  private void drawPoly(PApplet app, ArrayList<PVector> verts) {
    drawPoly(app, verts, false);
  }

  private void drawPoly(PApplet app, ArrayList<PVector> verts, boolean outlineOnly) {
    if (verts == null || verts.size() < 3) return;
    if (outlineOnly) {
      int n = verts.size();
      for (int i = 0; i < n; i++) {
        PVector a = verts.get(i);
        PVector b = verts.get((i + 1) % n);
        app.line(a.x, a.y, b.x, b.y);
      }
      return;
    }
    app.beginShape();
    for (PVector v : verts) app.vertex(v.x, v.y);
    app.endShape(CLOSE);
  }

  // PGraphics overload for cached layer drawing.
  private void drawPoly(PGraphics g, ArrayList<PVector> verts, boolean outlineOnly) {
    if (verts == null || verts.size() < 3 || g == null) return;
    if (outlineOnly) {
      int n = verts.size();
      for (int i = 0; i < n; i++) {
        PVector a = verts.get(i);
        PVector b = verts.get((i + 1) % n);
        g.line(a.x, a.y, b.x, b.y);
      }
      return;
    }
    g.beginShape();
    for (PVector v : verts) g.vertex(v.x, v.y);
    g.endShape(CLOSE);
  }

  private int hsbColor(float h, float s, float b, float a) {
    return hsb01ToARGB(h, s, b, a);
  }

  private void drawPatternPoly(PApplet app, ArrayList<PVector> verts, PImage pattern, int tintCol, float alpha01) {
    if (verts == null || verts.size() < 3 || pattern == null) return;
    if (pattern.width <= 0 || pattern.height <= 0) return;
    app.pushStyle();
    app.noStroke();
    app.textureMode(PConstants.NORMAL);
    app.textureWrap(PConstants.REPEAT);
    app.tint(tintCol, constrain(alpha01, 0, 1) * 255);
    app.beginShape();
    app.texture(pattern);
    // Keep 1:1 pixel density regardless of zoom; map using screen-space coords
    float pw = max(1, pattern.width);
    float ph = max(1, pattern.height);
    float canvasW = (app.g != null) ? app.g.width : app.width;
    float canvasH = (app.g != null) ? app.g.height : app.height;
    for (PVector v : verts) {
      PVector s = viewport.worldToScreen(v.x, v.y, canvasW, canvasH);
      float u = s.x / pw;
      float vv = s.y / ph;
      app.vertex(v.x, v.y, u, vv);
    }
    app.endShape(PConstants.CLOSE);
    app.popStyle();
  }

  // ------- Pattern cache -------
  private HashMap<String, PImage> patternCache = new HashMap<String, PImage>();
  private int[] cachedBiomeScaledColors = null;
  private int[] cachedBiomeSrcCols = null;
  private float cachedBiomeSatScale = -1;
  private float cachedBiomeBriScale = -1;
  private int[] cachedZoneStrokeColors = null;
  private int[] cachedZoneSrcCols = null;
  private float cachedZoneSatScale = -1;
  private float cachedZoneBriScale = -1;
  private PImage cachedPattern(HashMap<String, PImage> cache, PApplet app, String name) {
    if (cache == null || app == null || name == null || name.length() == 0) return null;
    if (cache.containsKey(name)) return cache.get(name);
    PImage pattern = getPattern(app, name);
    cache.put(name, pattern);
    return pattern;
  }
  private PImage getNoiseTexture(PApplet app) {
    if (noiseTex != null && noiseTex.width == NOISE_TEX_SIZE && noiseTex.height == NOISE_TEX_SIZE) return noiseTex;
    noiseTex = app.createImage(NOISE_TEX_SIZE, NOISE_TEX_SIZE, PConstants.ARGB);
    noiseTex.loadPixels();
    for (int i = 0; i < noiseTex.pixels.length; i++) {
      int gray = (int)app.random(0, 256);
      noiseTex.pixels[i] = app.color(gray, gray, gray, 255);
    }
    noiseTex.updatePixels();
    return noiseTex;
  }

  public PImage getPattern(PApplet app, String name) {
    if (name == null || name.length() == 0) return null;
    if (patternCache.containsKey(name)) return patternCache.get(name);
    String path = "patterns/" + name;
    PImage img = app.loadImage(path);
    if (img == null || img.width <= 0 || img.height <= 0) {
      String abs = app.sketchPath(path);
      if (abs != null) {
        img = app.loadImage(abs);
      }
    }
    if ((img == null || img.width <= 0 || img.height <= 0) && app.dataPath("") != null) {
      String dataPath = app.dataPath(path);
      img = app.loadImage(dataPath);
    }
    if (img == null || img.width <= 0 || img.height <= 0) {
      patternCache.put(name, null);
      return null;
    }
    // Convert to alpha mask: black = opaque, white = transparent; keep tint-driven color.
    img.format = PConstants.ARGB;
    img.loadPixels();
    for (int i = 0; i < img.pixels.length; i++) {
      int c = img.pixels[i];
      int r = (c >> 16) & 0xFF;
      int g = (c >> 8) & 0xFF;
      int b = c & 0xFF;
      int a = (c >> 24) & 0xFF;
      int gray = (r + g + b) / 3;
      // Black -> alpha 255, white -> alpha 0
      int alpha = 255 - gray;
      alpha = (int)constrain(alpha * (a / 255.0f), 0, 255);
      img.pixels[i] = app.color(255, 255, 255, alpha);
    }
    img.updatePixels();
    patternCache.put(name, img);
    return img;
  }

  private void ensureBiomeOutlineCache(float seaLevel) {
    if (model == null || model.cells == null) return;
    model.ensureCellNeighborsComputed();
    int cellCount = model.cells.size();
    int checksum = biomeChecksum();
    if (cellCount == cachedBiomeOutlineCellCount &&
        checksum == cachedBiomeOutlineChecksum &&
        abs(cachedBiomeOutlineSeaLevel - seaLevel) < 1e-6f) {
      return;
    }

    cachedBiomeOutlineEdges.clear();
    cachedBiomeOutlineBiomes.clear();
    cachedBiomeOutlineUnderwater.clear();
    HashMap<String, Integer> edgeToIndex = new HashMap<String, Integer>();
    float eps2 = 1e-6f;

    for (int ci = 0; ci < model.cells.size(); ci++) {
      Cell c = model.cells.get(ci);
      if (c == null || c.vertices == null || c.vertices.size() < 3) continue;
      int biomeId = c.biomeId;
      boolean cellUnderwater = c.elevation < seaLevel;
      int vc = c.vertices.size();
      for (int e = 0; e < vc; e++) {
        PVector a = c.vertices.get(e);
        PVector b = c.vertices.get((e + 1) % vc);
        String key = undirectedEdgeKey(a, b);
        int nbBiome = biomeId;
        boolean nbUnderwater = cellUnderwater;
        boolean boundary = true;
        ArrayList<Integer> nbs = (ci < model.cellNeighbors.size()) ? model.cellNeighbors.get(ci) : null;
        if (nbs != null) {
          for (int nbIdx : nbs) {
            if (nbIdx < 0 || nbIdx >= model.cells.size()) continue;
            Cell nb = model.cells.get(nbIdx);
            if (nb == null || nb.vertices == null) continue;
            int nv = nb.vertices.size();
            boolean match = false;
            for (int j = 0; j < nv; j++) {
              PVector na = nb.vertices.get(j);
              PVector nbp = nb.vertices.get((j + 1) % nv);
              if ((model.distSq(a, na) < eps2 && model.distSq(b, nbp) < eps2) ||
                  (model.distSq(a, nbp) < eps2 && model.distSq(b, na) < eps2)) {
                nbBiome = nb.biomeId;
                nbUnderwater = nb.elevation < seaLevel;
                match = true;
                break;
              }
            }
            if (match) {
              if (nbBiome == biomeId) boundary = false;
              break;
            }
          }
        }

        if (boundary) {
          int chosenBiome = max(biomeId, nbBiome); // priority to later/ higher-index biome types
          boolean underwater = cellUnderwater || nbUnderwater;
          Integer existingIdx = edgeToIndex.get(key);
          if (existingIdx != null) {
            int currentBiome = (existingIdx < cachedBiomeOutlineBiomes.size()) ? cachedBiomeOutlineBiomes.get(existingIdx) : chosenBiome;
            if (chosenBiome > currentBiome) {
              cachedBiomeOutlineBiomes.set(existingIdx, chosenBiome);
              cachedBiomeOutlineUnderwater.set(existingIdx, underwater);
            }
          } else {
            edgeToIndex.put(key, cachedBiomeOutlineEdges.size());
            cachedBiomeOutlineEdges.add(new PVector[] { a.copy(), b.copy() });
            cachedBiomeOutlineBiomes.add(chosenBiome);
            cachedBiomeOutlineUnderwater.add(underwater);
          }
        }
      }
    }

    cachedBiomeOutlineCellCount = cellCount;
    cachedBiomeOutlineChecksum = checksum;
    cachedBiomeOutlineSeaLevel = seaLevel;
  }

  private int biomeChecksum() {
    if (model == null || model.cells == null) return 0;
    int sum = 0;
    for (int i = 0; i < model.cells.size(); i++) {
      Cell c = model.cells.get(i);
      sum = 31 * sum + ((c != null) ? c.biomeId : -1);
    }
    return sum;
  }

  public void invalidateBiomeOutlineCache() {
    cachedBiomeOutlineEdges.clear();
    cachedBiomeOutlineBiomes.clear();
    cachedBiomeOutlineUnderwater.clear();
    cachedBiomeOutlineCellCount = -1;
    cachedBiomeOutlineChecksum = 0;
    cachedBiomeOutlineSeaLevel = Float.MAX_VALUE;
  }


  public MapModel.ContourGrid sampleElevationGrid(int cols, int rows, float fallback) {
    MapModel.ContourGrid g = model.new ContourGrid();
    g.cols = max(2, cols);
    g.rows = max(2, rows);
    g.v = new float[g.rows][g.cols];
    g.ox = model.minX;
    g.oy = model.minY;
    g.dx = (model.maxX - model.minX) / (g.cols - 1);
    g.dy = (model.maxY - model.minY) / (g.rows - 1);
    g.min = Float.MAX_VALUE;
    g.max = -Float.MAX_VALUE;
    for (int j = 0; j < g.rows; j++) {
      float y = g.oy + j * g.dy;
      for (int i = 0; i < g.cols; i++) {
        float x = g.ox + i * g.dx;
        float val = model.sampleElevationAt(x, y, fallback);
        g.v[j][i] = val;
        g.min = min(g.min, val);
        g.max = max(g.max, val);
      }
    }
    return g;
  }

  public void drawContourSet(PApplet app, MapModel.ContourGrid g, float start, float end, float step, int strokeCol) {
    if (step == 0) return;
    if ((step > 0 && start > end) || (step < 0 && start < end)) return;
    app.pushStyle();
    app.noFill();
    app.stroke(strokeCol);
    float elevW = strokeWorldPx(max(0.1f, renderSettings.elevationLinesSizePx), renderSettings.elevationLinesScaleWithZoom, renderSettings.elevationLinesRefZoom);
    app.strokeWeight(elevW);
    app.strokeCap(PConstants.ROUND);
    app.strokeJoin(PConstants.ROUND);
    HashSet<String> caps = drawRoundCaps ? new HashSet<String>() : null;
    float capR = elevW * 0.5f;

    if (step > 0) {
      for (float iso = start; iso <= end + 1e-6f; iso += step) {
        drawIsoLine(app, g, iso, drawRoundCaps, capR, strokeCol, caps);
      }
    } else {
      for (float iso = start; iso >= end - 1e-6f; iso += step) {
        drawIsoLine(app, g, iso, drawRoundCaps, capR, strokeCol, caps);
      }
    }
    app.popStyle();
  }

  // Overload for drawing into cached layers.
  public void drawContourSet(PApplet appCtx, PGraphics g, MapModel.ContourGrid grid, float start, float end, float step, int strokeCol) {
    if (grid == null || g == null || appCtx == null) return;
    if (step == 0) return;
    if ((step > 0 && start > end) || (step < 0 && start < end)) return;
    g.pushStyle();
    g.noFill();
    g.stroke(strokeCol);
    float elevW = strokeWorldPx(max(0.1f, renderSettings.elevationLinesSizePx), renderSettings.elevationLinesScaleWithZoom, renderSettings.elevationLinesRefZoom);
    g.strokeWeight(elevW);
    g.strokeCap(PConstants.ROUND);
    g.strokeJoin(PConstants.ROUND);
    HashSet<String> caps = drawRoundCaps ? new HashSet<String>() : null;
    float capR = elevW * 0.5f;

    if (step > 0) {
      for (float iso = start; iso <= end + 1e-6f; iso += step) {
        drawIsoLine(g, grid, iso, drawRoundCaps, capR, strokeCol, caps);
      }
    } else {
      for (float iso = start; iso >= end - 1e-6f; iso += step) {
        drawIsoLine(g, grid, iso, drawRoundCaps, capR, strokeCol, caps);
      }
    }
    g.popStyle();
  }

  private float sampleGrid(MapModel.ContourGrid g, float x, float y) {
    if (g == null || g.v == null || g.cols < 2 || g.rows < 2) return 0;
    float fx = constrain((x - g.ox) / max(1e-6f, g.dx), 0, g.cols - 1.0001f);
    float fy = constrain((y - g.oy) / max(1e-6f, g.dy), 0, g.rows - 1.0001f);
    int ix = floor(fx);
    int iy = floor(fy);
    float tx = fx - ix;
    float ty = fy - iy;
    float v00 = g.v[iy][ix];
    float v10 = g.v[iy][ix + 1];
    float v01 = g.v[iy + 1][ix];
    float v11 = g.v[iy + 1][ix + 1];
    float a = lerp(v00, v10, tx);
    float b = lerp(v01, v11, tx);
    return lerp(a, b, ty);
  }

  public void drawWaterRipples(PApplet app, RenderSettings s, float seaLevel) {
    if (s == null) return;
    if (s.waterRippleCount <= 0) return;
    if (s.waterRippleDistancePx <= 1e-4f) return;
    if (s.waterRippleAlphaStart01 <= 1e-4f && s.waterRippleAlphaEnd01 <= 1e-4f) return;
    int cols = max(80, min(200, (int)(sqrt(max(1, model.cells.size())) * 1.0f)));
    int rows = cols;
    MapModel.ContourGrid g = model.getCoastDistanceGrid(cols, rows, seaLevel);
    if (g == null) return;

    float spacingFactor = (s.waterContourScaleWithZoom) ? (max(1e-6f, viewport.zoom) / max(1e-6f, s.waterContourRefZoom)) : 1.0f;
    float spacingWorld = (s.waterRippleDistancePx * spacingFactor) / max(1e-6f, viewport.zoom);
    if (spacingWorld <= 1e-6f) return;

    float maxIso = spacingWorld * s.waterRippleCount;
    float strokePx = strokeWorldPx(max(0.8f, s.waterContourSizePx), s.waterContourScaleWithZoom, s.waterContourRefZoom);
    app.pushStyle();
    app.noFill();
    // app.strokeCap(PConstants.ROUND);
    // app.strokeJoin(PConstants.ROUND);
    app.strokeWeight(strokePx);
    for (float iso = spacingWorld; iso <= maxIso + 1e-6f; iso += spacingWorld) {
      float t = (maxIso <= spacingWorld + 1e-6f) ? 0.0f : constrain((iso - spacingWorld) / max(1e-6f, maxIso - spacingWorld), 0, 1);
      float a = constrain(lerp(s.waterRippleAlphaStart01, s.waterRippleAlphaEnd01, t), 0, 1);
      if (a <= 1e-4f) continue;
      int strokeCol = hsbColor(s.waterContourHue01, s.waterContourSat01, s.waterContourBri01, a);
      app.stroke(strokeCol);
      HashSet<String> rippleCaps = drawRoundCaps ? new HashSet<String>() : null;
      drawIsoLine(app, g, iso, drawRoundCaps, strokePx * 0.5f, strokeCol, rippleCaps);
    }
    app.popStyle();
  }

  public void drawWaterHatching(PApplet app, RenderSettings s, float seaLevel) {
    if (s == null) return;
    if (s.waterHatchAlpha01 <= 1e-4f) return;
    if (s.waterHatchLengthPx <= 1e-4f) return;
    if (s.waterHatchSpacingPx <= 1e-4f) return;
    int cols = max(80, min(200, (int)(sqrt(max(1, model.cells.size())) * 1.0f)));
    MapModel.ContourGrid g = model.getCoastDistanceGrid(cols, cols, seaLevel);
    if (g == null) return;

    float angleRad = radians(s.waterHatchAngleDeg);
    PVector d = new PVector(cos(angleRad), sin(angleRad));
    PVector n = new PVector(-d.y, d.x);
    float spacingFactor = (s.waterContourScaleWithZoom) ? (max(1e-6f, viewport.zoom) / max(1e-6f, s.waterContourRefZoom)) : 1.0f;
    float spacing = (s.waterHatchSpacingPx * spacingFactor) / max(1e-6f, viewport.zoom);
    float maxLen = (s.waterHatchLengthPx * spacingFactor) / max(1e-6f, viewport.zoom);
    if (spacing <= 1e-6f || maxLen <= 1e-6f) return;

    float minX = model.minX;
    float minY = model.minY;
    float maxX = model.maxX;
    float maxY = model.maxY;

    // Projections of map corners onto normal
    float[] projs = new float[] {
      (minX * n.x + minY * n.y),
      (minX * n.x + maxY * n.y),
      (maxX * n.x + minY * n.y),
      (maxX * n.x + maxY * n.y)
    };
    float minProj = min(min(projs[0], projs[1]), min(projs[2], projs[3]));
    float maxProj = max(max(projs[0], projs[1]), max(projs[2], projs[3]));

    float originProj = minX * n.x + minY * n.y;
    float mapDiag = dist(minX, minY, maxX, maxY) + maxLen * 2;
    float stepT = min(spacing * 0.2f, maxLen * 0.2f);
    stepT = max(stepT, maxLen * 0.05f);

    app.pushStyle();
    int strokeCol = hsbColor(s.waterContourHue01, s.waterContourSat01, s.waterContourBri01, s.waterHatchAlpha01);
    app.stroke(strokeCol);
    float hatchStroke = strokeWorldPx(max(0.6f, s.waterContourSizePx * 0.8f), s.waterContourScaleWithZoom, s.waterContourRefZoom);
    app.strokeWeight(hatchStroke);
    // app.strokeCap(PConstants.SQUARE);
    app.noFill();

    float startOff = floor((minProj - originProj) / spacing) * spacing + originProj;
    for (float off = startOff; off <= maxProj + spacing * 0.5f; off += spacing) {
      PVector base = new PVector(minX, minY);
      base.add(PVector.mult(n, off - originProj));
      PVector start = PVector.sub(base, PVector.mult(d, mapDiag));
      int segState = 0; // 0=out,1=in
      PVector segStart = null;
      PVector lastIn = null;
      for (float t = 0; t <= mapDiag * 2; t += stepT) {
        PVector p = PVector.add(start, PVector.mult(d, t));
        if (p.x < minX || p.x > maxX || p.y < minY || p.y > maxY) {
          if (segState == 1 && segStart != null && lastIn != null) {
            app.line(segStart.x, segStart.y, lastIn.x, lastIn.y);
          }
          segState = 0;
          segStart = null;
          lastIn = null;
          continue;
        }
        float distVal = sampleGrid(g, p.x, p.y);
        boolean inside = distVal > 0 && distVal <= maxLen;
        if (inside && segState == 0) {
          segState = 1;
          segStart = p.copy();
          lastIn = p.copy();
        } else if (inside && segState == 1) {
          lastIn = p.copy();
        } else if (!inside && segState == 1) {
          segState = 0;
          if (segStart != null && lastIn != null) app.line(segStart.x, segStart.y, lastIn.x, lastIn.y);
          segStart = null;
          lastIn = null;
        }
      }
      if (segState == 1 && segStart != null) {
        PVector end = (lastIn != null) ? lastIn : PVector.add(start, PVector.mult(d, mapDiag * 2));
        app.line(segStart.x, segStart.y, end.x, end.y);
      }
    }
    app.popStyle();
  }

  public void drawIsoLine(PApplet app, MapModel.ContourGrid g, float iso) {
    drawIsoLine(app, g, iso, false, 0, 0, null);
  }

  public void drawIsoLine(PApplet app, MapModel.ContourGrid g, float iso, boolean caps, float capRadius, int capCol, HashSet<String> capsDrawn) {
    for (int j = 0; j < g.rows - 1; j++) {
      float y0 = g.oy + j * g.dy;
      float y1 = y0 + g.dy;
      for (int i = 0; i < g.cols - 1; i++) {
        float x0 = g.ox + i * g.dx;
        float x1 = x0 + g.dx;
        float v00 = g.v[j][i];
        float v10 = g.v[j][i + 1];
        float v11 = g.v[j + 1][i + 1];
        float v01 = g.v[j + 1][i];

        int caseId = 0;
        if (v00 > iso) caseId |= 1;
        if (v10 > iso) caseId |= 2;
        if (v11 > iso) caseId |= 4;
        if (v01 > iso) caseId |= 8;

        if (caseId == 0 || caseId == 15) continue;

        PVector eTop = interpIso(x0, y0, v00, x1, y0, v10, iso);
        PVector eRight = interpIso(x1, y0, v10, x1, y1, v11, iso);
        PVector eBottom = interpIso(x0, y1, v01, x1, y1, v11, iso);
        PVector eLeft = interpIso(x0, y0, v00, x0, y1, v01, iso);

        switch (caseId) {
          case 1:  drawSeg(app, eLeft, eTop, caps, capRadius, capCol, capsDrawn); break;
          case 2:  drawSeg(app, eTop, eRight, caps, capRadius, capCol, capsDrawn); break;
          case 3:  drawSeg(app, eLeft, eRight, caps, capRadius, capCol, capsDrawn); break;
          case 4:  drawSeg(app, eRight, eBottom, caps, capRadius, capCol, capsDrawn); break;
          case 5:  drawSeg(app, eTop, eRight, caps, capRadius, capCol, capsDrawn); drawSeg(app, eLeft, eBottom, caps, capRadius, capCol, capsDrawn); break;
          case 6:  drawSeg(app, eTop, eBottom, caps, capRadius, capCol, capsDrawn); break;
          case 7:  drawSeg(app, eLeft, eBottom, caps, capRadius, capCol, capsDrawn); break;
          case 8:  drawSeg(app, eBottom, eLeft, caps, capRadius, capCol, capsDrawn); break;
          case 9:  drawSeg(app, eTop, eBottom, caps, capRadius, capCol, capsDrawn); break;
          case 10: drawSeg(app, eTop, eLeft, caps, capRadius, capCol, capsDrawn); drawSeg(app, eRight, eBottom, caps, capRadius, capCol, capsDrawn); break;
          case 11: drawSeg(app, eRight, eBottom, caps, capRadius, capCol, capsDrawn); break;
          case 12: drawSeg(app, eRight, eLeft, caps, capRadius, capCol, capsDrawn); break;
          case 13: drawSeg(app, eRight, eTop, caps, capRadius, capCol, capsDrawn); break;
          case 14: drawSeg(app, eTop, eLeft, caps, capRadius, capCol, capsDrawn); break;
        }
      }
    }
  }

  public void drawZoneOutlinesRender(PApplet app, RenderSettings s) {
    if (s == null) return;
    boolean drawZones = s.zoneStrokeAlpha01 > 1e-4f && model.zones != null;
    if (!drawZones) {
      zoneLayer = null;
      return;
    }
    // Biome fills/lines are already rendered in drawRenderAdvanced; avoid re-blending above contours.
    ensureZoneLayer(app, s);
    if (zoneLayer != null) {
      app.pushStyle();
      app.pushMatrix();
      app.resetMatrix();
      app.tint(255, constrain(s.zoneStrokeAlpha01, 0, 1) * 255);
      app.image(zoneLayer, 0, 0);
      app.popMatrix();
      app.popStyle();
    }
  }

  public void drawSeg(PApplet app, PVector a, PVector b) {
    if (a == null || b == null) return;
    app.line(a.x, a.y, b.x, b.y);
  }

  public void drawSeg(PApplet app, PVector a, PVector b, boolean caps, float capRadius, int capCol, HashSet<String> capsDrawn) {
    if (a == null || b == null) return;
    app.line(a.x, a.y, b.x, b.y);
    if (!caps || capRadius <= 1e-6f) return;
    app.pushStyle();
    app.noStroke();
    app.fill(capCol);
    if (capsDrawn != null) {
      String ka = capKey(a);
      if (!capsDrawn.contains(ka)) {
        capsDrawn.add(ka);
        app.ellipse(a.x, a.y, capRadius * 2, capRadius * 2);
      }
      String kb = capKey(b);
      if (!capsDrawn.contains(kb)) {
        capsDrawn.add(kb);
        app.ellipse(b.x, b.y, capRadius * 2, capRadius * 2);
      }
    } else {
      app.ellipse(a.x, a.y, capRadius * 2, capRadius * 2);
      app.ellipse(b.x, b.y, capRadius * 2, capRadius * 2);
    }
    app.popStyle();
  }

  public void drawSeg(PGraphics g, PVector a, PVector b, boolean caps, float capRadius, int capCol, HashSet<String> capsDrawn) {
    if (a == null || b == null || g == null) return;
    g.line(a.x, a.y, b.x, b.y);
    if (!caps || capRadius <= 1e-6f) return;
    g.pushStyle();
    g.noStroke();
    g.fill(capCol);
    if (capsDrawn != null) {
      String ka = capKey(a);
      if (!capsDrawn.contains(ka)) {
        capsDrawn.add(ka);
        g.ellipse(a.x, a.y, capRadius * 2, capRadius * 2);
      }
      String kb = capKey(b);
      if (!capsDrawn.contains(kb)) {
        capsDrawn.add(kb);
        g.ellipse(b.x, b.y, capRadius * 2, capRadius * 2);
      }
    } else {
      g.ellipse(a.x, a.y, capRadius * 2, capRadius * 2);
      g.ellipse(b.x, b.y, capRadius * 2, capRadius * 2);
    }
    g.popStyle();
  }

  public PVector interpIso(float x0, float y0, float v0, float x1, float y1, float v1, float iso) {
    float denom = (v1 - v0);
    if (abs(denom) < 1e-6f) return new PVector((x0 + x1) * 0.5f, (y0 + y1) * 0.5f);
    float t = (iso - v0) / denom;
    t = constrain(t, 0, 1);
    return new PVector(lerp(x0, x1, t), lerp(y0, y1, t));
  }

  private String undirectedEdgeKey(PVector a, PVector b) {
    int ax = round(a.x * 10000);
    int ay = round(a.y * 10000);
    int bx = round(b.x * 10000);
    int by = round(b.y * 10000);
    if (ax < bx || (ax == bx && ay <= by)) {
      return ax + "," + ay + "-" + bx + "," + by;
    } else {
      return bx + "," + by + "-" + ax + "," + ay;
    }
  }

  private String capKey(PVector p) {
    if (p == null) return "";
    int px = round(p.x * 10000);
    int py = round(p.y * 10000);
    return px + ":" + py;
  }

  private int hashArray(int[] arr) {
    if (arr == null) return 0;
    int h = 1;
    for (int v : arr) h = 31 * h + v;
    return h;
  }

  private int elevationLineSettingsHash(RenderSettings s) {
    int h = 13;
    h = 31 * h + round(s.elevationLinesCount);
    h = 31 * h + round(s.elevationLinesSizePx * 1000.0f);
    h = 31 * h + round(s.elevationLinesScaleWithZoom ? 1 : 0);
    h = 31 * h + round(s.elevationLinesRefZoom * 1000.0f);
    h = 31 * h + round(s.elevationLinesAlpha01 * 1000.0f);
    h = 31 * h + (drawRoundCaps ? 1 : 0);
    h = 31 * h + (renderSettings != null && renderSettings.antialiasing ? 1 : 0);
    h = 31 * h + ((model != null && model.cells != null) ? model.cells.size() : 0);
    return h;
  }

  private int coastSettingsHash(RenderSettings s) {
    int h = 17;
    h = 31 * h + round(s.waterCoastSizePx * 1000.0f);
    h = 31 * h + round(s.waterContourHue01 * 1000.0f);
    h = 31 * h + round(s.waterContourSat01 * 1000.0f);
    h = 31 * h + round(s.waterContourBri01 * 1000.0f);
    h = 31 * h + round(s.waterCoastAlpha01 * 1000.0f);
    h = 31 * h + (s.waterCoastScaleWithZoom ? 1 : 0);
    h = 31 * h + (s.antialiasing ? 1 : 0);
    h = 31 * h + (drawRoundCaps ? 1 : 0);
    h = 31 * h + ((model != null && model.cells != null) ? model.cells.size() : 0);
    return h;
  }

  private int waterDetailSettingsHash(RenderSettings s) {
    int h = 29;
    h = 31 * h + round(s.waterRippleCount);
    h = 31 * h + round(s.waterRippleDistancePx * 1000.0f);
    h = 31 * h + round(s.waterRippleAlphaStart01 * 1000.0f);
    h = 31 * h + round(s.waterRippleAlphaEnd01 * 1000.0f);
    h = 31 * h + round(s.waterContourHue01 * 1000.0f);
    h = 31 * h + round(s.waterContourSat01 * 1000.0f);
    h = 31 * h + round(s.waterContourBri01 * 1000.0f);
    h = 31 * h + round(s.waterContourSizePx * 1000.0f);
    h = 31 * h + (s.waterContourScaleWithZoom ? 1 : 0);
    h = 31 * h + round(s.waterContourRefZoom * 1000.0f);
    h = 31 * h + round(s.waterHatchAngleDeg * 10.0f);
    h = 31 * h + round(s.waterHatchLengthPx * 1000.0f);
    h = 31 * h + round(s.waterHatchSpacingPx * 1000.0f);
    h = 31 * h + round(s.waterHatchAlpha01 * 1000.0f);
    h = 31 * h + (drawRoundCaps ? 1 : 0);
    h = 31 * h + ((model != null && model.cells != null) ? model.cells.size() : 0);
    return h;
  }

  private int biomeOutlineHash(RenderSettings s) {
    int h = 23;
    h = 31 * h + round(s.biomeOutlineSizePx * 1000.0f);
    h = 31 * h + round(s.biomeOutlineAlpha01 * 1000.0f);
    h = 31 * h + round(s.biomeUnderwaterAlpha01 * 1000.0f);
    h = 31 * h + round(s.biomeOutlineScaleWithZoom ? 1 : 0);
    h = 31 * h + round(s.biomeOutlineRefZoom * 1000.0f);
    h = 31 * h + ((model != null && model.biomeTypes != null) ? model.biomeTypes.size() : 0);
    h = 31 * h + ((model != null && model.cells != null) ? model.cells.size() : 0);
    return h;
  }

  private void ensureBiomeOutlineLayer(PApplet app, RenderSettings s, float seaLevel, int landBase, int[] biomeScaledCols) {
    if (model == null || model.cells == null || model.cells.isEmpty()) {
      biomeOutlineLayerLand = null;
      biomeOutlineLayerWater = null;
      return;
    }
    int targetW = (app.g != null) ? app.g.width : app.width;
    int targetH = (app.g != null) ? app.g.height : app.height;
    int hash = biomeOutlineHash(s);
    boolean sizeChanged = biomeOutlineLayerLand == null || biomeOutlineW != targetW || biomeOutlineH != targetH;
    boolean viewChanged = biomeOutlineLayerLand == null ||
                          abs(biomeOutlineZoom - viewport.zoom) > 1e-4f ||
                          abs(biomeOutlineCenterX - viewport.centerX) > 1e-4f ||
                          abs(biomeOutlineCenterY - viewport.centerY) > 1e-4f;
    boolean settingsChanged = biomeOutlineLayerLand == null ||
                              biomeOutlineHash != hash ||
                              biomeOutlineCellCount != model.cells.size() ||
                              abs(biomeOutlineSeaLevel - seaLevel) > 1e-6f;
    boolean needLand = s.biomeOutlineAlpha01 > 1e-4f;
    boolean needWater = s.biomeUnderwaterAlpha01 > 1e-4f;

    if (sizeChanged || biomeOutlineLayerLand == null) {
      biomeOutlineLayerLand = needLand ? app.createGraphics(targetW, targetH, JAVA2D) : null;
      biomeOutlineLayerWater = needWater ? app.createGraphics(targetW, targetH, JAVA2D) : null;
      biomeOutlineW = targetW;
      biomeOutlineH = targetH;
    }
    if (!needLand) biomeOutlineLayerLand = null;
    if (!needWater) biomeOutlineLayerWater = null;

    if (!biomeOutlineDirty && !sizeChanged && !viewChanged && !settingsChanged) return;

    ensureBiomeOutlineCache(seaLevel);
    float boW = strokeWorldPx(max(0.1f, s.biomeOutlineSizePx), s.biomeOutlineScaleWithZoom, s.biomeOutlineRefZoom);

    if (biomeOutlineLayerLand != null) {
      if (s.antialiasing) biomeOutlineLayerLand.smooth(8); else biomeOutlineLayerLand.noSmooth();
      biomeOutlineLayerLand.beginDraw();
      biomeOutlineLayerLand.clear();
      biomeOutlineLayerLand.pushMatrix();
      biomeOutlineLayerLand.pushStyle();
      viewport.applyTransform(biomeOutlineLayerLand, targetW, targetH);
      biomeOutlineLayerLand.strokeWeight(boW);
      // biomeOutlineLayerLand.strokeCap(PConstants.ROUND);
      HashSet<String> caps = new HashSet<String>();
      for (int i = 0; i < cachedBiomeOutlineEdges.size(); i++) {
        if (i < cachedBiomeOutlineUnderwater.size() && cachedBiomeOutlineUnderwater.get(i)) continue;
        PVector[] seg = cachedBiomeOutlineEdges.get(i);
        int biomeId = (i < cachedBiomeOutlineBiomes.size()) ? cachedBiomeOutlineBiomes.get(i) : -1;
        int col = landBase;
        if (model.biomeTypes != null && biomeId >= 0 && biomeId < model.biomeTypes.size() && biomeScaledCols != null) {
          col = biomeScaledCols[biomeId];
        }
        biomeOutlineLayerLand.stroke(col, 255);
        biomeOutlineLayerLand.line(seg[0].x, seg[0].y, seg[1].x, seg[1].y);
        String k0 = undirectedEdgeKey(seg[0], seg[0]);
        String k1 = undirectedEdgeKey(seg[1], seg[1]);
        if (drawRoundCaps) {
          float d = boW;
          biomeOutlineLayerLand.noStroke();
          biomeOutlineLayerLand.fill(col, 255);
          if (!caps.contains(k0)) { caps.add(k0); biomeOutlineLayerLand.ellipse(seg[0].x, seg[0].y, d, d); }
          if (!caps.contains(k1)) { caps.add(k1); biomeOutlineLayerLand.ellipse(seg[1].x, seg[1].y, d, d); }
          biomeOutlineLayerLand.stroke(col, 255);
        }
      }
      biomeOutlineLayerLand.popStyle();
      biomeOutlineLayerLand.popMatrix();
      biomeOutlineLayerLand.endDraw();
    }

    if (biomeOutlineLayerWater != null) {
      if (s.antialiasing) biomeOutlineLayerWater.smooth(8); else biomeOutlineLayerWater.noSmooth();
      biomeOutlineLayerWater.beginDraw();
      biomeOutlineLayerWater.clear();
      biomeOutlineLayerWater.pushMatrix();
      biomeOutlineLayerWater.pushStyle();
      viewport.applyTransform(biomeOutlineLayerWater, targetW, targetH);
      biomeOutlineLayerWater.strokeWeight(boW);
      // biomeOutlineLayerWater.strokeCap(PConstants.ROUND);
      HashSet<String> caps = new HashSet<String>();
      for (int i = 0; i < cachedBiomeOutlineEdges.size(); i++) {
        boolean underwater = (i < cachedBiomeOutlineUnderwater.size()) ? cachedBiomeOutlineUnderwater.get(i) : false;
        if (!underwater) continue;
        PVector[] seg = cachedBiomeOutlineEdges.get(i);
        int biomeId = (i < cachedBiomeOutlineBiomes.size()) ? cachedBiomeOutlineBiomes.get(i) : -1;
        int col = landBase;
        if (model.biomeTypes != null && biomeId >= 0 && biomeId < model.biomeTypes.size() && biomeScaledCols != null) {
          col = biomeScaledCols[biomeId];
        }
        biomeOutlineLayerWater.stroke(col, 255);
        biomeOutlineLayerWater.line(seg[0].x, seg[0].y, seg[1].x, seg[1].y);
        if (drawRoundCaps) {
          float d = boW;
          String k0 = undirectedEdgeKey(seg[0], seg[0]);
          String k1 = undirectedEdgeKey(seg[1], seg[1]);
          biomeOutlineLayerWater.noStroke();
          biomeOutlineLayerWater.fill(col, 255);
          if (!caps.contains(k0)) { caps.add(k0); biomeOutlineLayerWater.ellipse(seg[0].x, seg[0].y, d, d); }
          if (!caps.contains(k1)) { caps.add(k1); biomeOutlineLayerWater.ellipse(seg[1].x, seg[1].y, d, d); }
          biomeOutlineLayerWater.stroke(col, 255);
        }
      }
      biomeOutlineLayerWater.popStyle();
      biomeOutlineLayerWater.popMatrix();
      biomeOutlineLayerWater.endDraw();
    }

    biomeOutlineHash = hash;
    biomeOutlineZoom = viewport.zoom;
    biomeOutlineCenterX = viewport.centerX;
    biomeOutlineCenterY = viewport.centerY;
    biomeOutlineCellCount = model.cells.size();
    biomeOutlineSeaLevel = seaLevel;
    biomeOutlineDirty = false;
  }

  private int cellBorderSettingsHash(RenderSettings s) {
    int h = 29;
    h = 31 * h + round(s.cellBorderSizePx * 1000.0f);
    h = 31 * h + (s.cellBorderScaleWithZoom ? 1 : 0);
    h = 31 * h + round(s.cellBorderRefZoom * 1000.0f);
    h = 31 * h + ((model != null && model.cells != null) ? model.cells.size() : 0);
    return h;
  }

  private void ensureCellBorderLayer(PApplet app, RenderSettings s) {
    if (model == null || model.cells == null || model.cells.isEmpty()) {
      cellBorderLayer = null;
      return;
    }
    if (s.cellBorderSizePx <= 1e-4f || s.cellBorderAlpha01 <= 1e-4f) {
      cellBorderLayer = null;
      return;
    }
    int targetW = (app.g != null) ? app.g.width : app.width;
    int targetH = (app.g != null) ? app.g.height : app.height;
    int hash = cellBorderSettingsHash(s);
    boolean sizeChanged = cellBorderLayer == null || cellBorderW != targetW || cellBorderH != targetH;
    boolean viewChanged = cellBorderLayer == null ||
                          abs(cellBorderZoom - viewport.zoom) > 1e-4f ||
                          abs(cellBorderCenterX - viewport.centerX) > 1e-4f ||
                          abs(cellBorderCenterY - viewport.centerY) > 1e-4f;
    boolean settingsChanged = cellBorderLayer == null ||
                              cellBorderHash != hash ||
                              cellBorderCellCount != model.cells.size();
    if (!cellBorderDirty && !(sizeChanged || viewChanged || settingsChanged)) return;

    try {
      cellBorderLayer = app.createGraphics(targetW, targetH, JAVA2D);
      if (cellBorderLayer != null) {
        cellBorderLayer.beginDraw();
        if (s.antialiasing) cellBorderLayer.smooth(8); else cellBorderLayer.noSmooth();
        cellBorderLayer.clear();
        cellBorderLayer.pushMatrix();
        cellBorderLayer.pushStyle();
        viewport.applyTransform(cellBorderLayer, targetW, targetH);
        cellBorderLayer.stroke(0, 0, 0, 255);
        float cbW = strokeWorldPx(max(0.1f, s.cellBorderSizePx), s.cellBorderScaleWithZoom, s.cellBorderRefZoom);
        cellBorderLayer.strokeWeight(cbW);
        // cellBorderLayer.strokeCap(PConstants.ROUND);
        // cellBorderLayer.strokeJoin(PConstants.ROUND);
        cellBorderLayer.noFill();
        for (Cell c : model.cells) {
          if (c == null || c.vertices == null || c.vertices.size() < 3) continue;
          drawPoly(cellBorderLayer, c.vertices, true);
        }
        cellBorderLayer.popStyle();
        cellBorderLayer.popMatrix();
        cellBorderLayer.endDraw();
      }
    } catch (Exception ex) {
      println("Cell border layer build failed: " + ex);
      cellBorderLayer = null;
    }

    cellBorderHash = hash;
    cellBorderZoom = viewport.zoom;
    cellBorderCenterX = viewport.centerX;
    cellBorderCenterY = viewport.centerY;
    cellBorderW = targetW;
    cellBorderH = targetH;
    cellBorderCellCount = model.cells.size();
    cellBorderDirty = false;
  }

  public void ensureCoastLayer(PApplet app, RenderSettings s, float seaLevel) {
    if (model == null || model.cells == null || model.cells.isEmpty()) {
      coastLayer = null;
      return;
    }
    if (app == null) return;
    int targetW = (app.g != null) ? app.g.width : app.width;
    int targetH = (app.g != null) ? app.g.height : app.height;
    if (targetW <= 0 || targetH <= 0) {
      coastLayer = null;
      return;
    }
    int hash = coastSettingsHash(s);
    boolean sizeChanged = coastLayer == null || coastLayerW != targetW || coastLayerH != targetH;
    boolean viewChanged = coastLayer == null ||
                          abs(coastLayerZoom - viewport.zoom) > 1e-4f ||
                          abs(coastLayerCenterX - viewport.centerX) > 1e-4f ||
                          abs(coastLayerCenterY - viewport.centerY) > 1e-4f;
    boolean settingsChanged = coastLayer == null ||
                              coastLayerHash != hash ||
                              abs(coastLayerSeaLevel - seaLevel) > 1e-6f ||
                              coastLayerCellCount != model.cells.size();

    if (sizeChanged) {
      try {
        coastLayer = app.createGraphics(targetW, targetH, JAVA2D);
      } catch (Exception ex) {
        println("Coast layer alloc failed: " + ex);
        coastLayer = null;
      }
      coastLayerW = targetW;
      coastLayerH = targetH;
      if (coastLayer != null) {
        if (s.antialiasing) coastLayer.smooth(8); else coastLayer.noSmooth();
      }
    } else {
      if (coastLayer != null) {
        if (s.antialiasing) coastLayer.smooth(8); else coastLayer.noSmooth();
      }
    }
    if (coastLayer == null) return;
    if (!coastDirty && !(sizeChanged || viewChanged || settingsChanged)) return;

    try {
      coastLayer.beginDraw();
      coastLayer.clear();
      coastLayer.pushMatrix();
      coastLayer.pushStyle();
      viewport.applyTransform(coastLayer, coastLayer.width, coastLayer.height);
      drawCoastLayer(coastLayer, s, seaLevel);
      coastLayer.popStyle();
      coastLayer.popMatrix();
      coastLayer.endDraw();
    } catch (Exception ex) {
      println("Coast layer build failed: " + ex);
      coastLayer = null;
      return;
    }

    coastLayerHash = hash;
    coastLayerZoom = viewport.zoom;
    coastLayerCenterX = viewport.centerX;
    coastLayerCenterY = viewport.centerY;
    coastLayerSeaLevel = seaLevel;
    coastLayerCellCount = model.cells.size();
    coastDirty = false;
  }

  private void ensureElevationLineLayer(PApplet app, RenderSettings s, float seaLevel) {
    if (model == null || model.cells == null || model.cells.isEmpty()) {
      elevationLineLayer = null;
      return;
    }
    if (app == null) return;
    int targetW = (app.g != null) ? app.g.width : app.width;
    int targetH = (app.g != null) ? app.g.height : app.height;
    if (targetW <= 0 || targetH <= 0) {
      elevationLineLayer = null;
      return;
    }
    int hash = elevationLineSettingsHash(s);
    boolean sizeChanged = elevationLineLayer == null || elevationLineW != targetW || elevationLineH != targetH;
    boolean viewChanged = elevationLineLayer == null ||
                          abs(elevationLineZoom - viewport.zoom) > 1e-4f ||
                          abs(elevationLineCenterX - viewport.centerX) > 1e-4f ||
                          abs(elevationLineCenterY - viewport.centerY) > 1e-4f;
    boolean settingsChanged = elevationLineLayer == null ||
                              elevationLineHash != hash ||
                              abs(elevationLineSeaLevel - seaLevel) > 1e-6f ||
                              elevationLineCellCount != model.cells.size();

    if (sizeChanged) {
      try {
        elevationLineLayer = app.createGraphics(targetW, targetH, JAVA2D);
      } catch (Exception ex) {
        println("Elevation line layer alloc failed: " + ex);
        elevationLineLayer = null;
      }
      elevationLineW = targetW;
      elevationLineH = targetH;
      if (elevationLineLayer != null) {
        if (s.antialiasing) elevationLineLayer.smooth(8); else elevationLineLayer.noSmooth();
      }
    } else {
      if (elevationLineLayer != null) {
        if (s.antialiasing) elevationLineLayer.smooth(8); else elevationLineLayer.noSmooth();
      }
    }
    if (elevationLineLayer == null) return;
    if (!elevationLineDirty && !(sizeChanged || viewChanged || settingsChanged)) return;

    int cols = 90;
    int rows = 90;
    MapModel.ContourGrid grid = model.getElevationGridForRender(cols, rows, seaLevel);
    if (grid == null) {
      elevationLineLayer = null;
      return;
    }

    float range = max(1e-4f, grid.max - seaLevel);
    float step = range / max(1, s.elevationLinesCount);
    float start = seaLevel + step;
    int strokeCol = app.color(0, 0, 0, 255);

    try {
      elevationLineLayer.beginDraw();
      elevationLineLayer.clear();
      elevationLineLayer.pushMatrix();
      elevationLineLayer.pushStyle();
      viewport.applyTransform(elevationLineLayer, elevationLineLayer.width, elevationLineLayer.height);
      drawContourSet(app, elevationLineLayer, grid, start, grid.max, step, strokeCol);
      elevationLineLayer.popStyle();
      elevationLineLayer.popMatrix();
      elevationLineLayer.endDraw();
    } catch (Exception ex) {
      println("Elevation line layer build failed: " + ex);
      elevationLineLayer = null;
      return;
    }

    elevationLineHash = hash;
    elevationLineZoom = viewport.zoom;
    elevationLineCenterX = viewport.centerX;
    elevationLineCenterY = viewport.centerY;
    elevationLineSeaLevel = seaLevel;
    elevationLineCellCount = model.cells.size();
    elevationLineDirty = false;
  }

  private void ensureWaterDetailLayer(PApplet app, RenderSettings s, float seaLevel, boolean wantRipples, boolean wantHatching) {
    if (model == null || model.cells == null || model.cells.isEmpty()) {
      waterDetailLayer = null;
      return;
    }
    if (app == null) return;
    int targetW = (app.g != null) ? app.g.width : app.width;
    int targetH = (app.g != null) ? app.g.height : app.height;
    if (targetW <= 0 || targetH <= 0) {
      waterDetailLayer = null;
      return;
    }
    int hash = waterDetailSettingsHash(s);
    boolean sizeChanged = waterDetailLayer == null || waterDetailLayerW != targetW || waterDetailLayerH != targetH;
    boolean viewChanged = waterDetailLayer == null ||
                          abs(waterDetailLayerZoom - viewport.zoom) > 1e-4f ||
                          abs(waterDetailLayerCenterX - viewport.centerX) > 1e-4f ||
                          abs(waterDetailLayerCenterY - viewport.centerY) > 1e-4f;
    boolean settingsChanged = waterDetailLayer == null ||
                              waterDetailLayerHash != hash ||
                              abs(waterDetailLayerSeaLevel - seaLevel) > 1e-6f ||
                              waterDetailLayerCellCount != model.cells.size();

    if (sizeChanged) {
      try {
        waterDetailLayer = app.createGraphics(targetW, targetH, JAVA2D);
      } catch (Exception ex) {
        println("Water detail layer alloc failed: " + ex);
        waterDetailLayer = null;
      }
      waterDetailLayerW = targetW;
      waterDetailLayerH = targetH;
      if (waterDetailLayer != null) {
        if (s.antialiasing) waterDetailLayer.smooth(8); else waterDetailLayer.noSmooth();
      }
    } else {
      if (waterDetailLayer != null) {
        if (s.antialiasing) waterDetailLayer.smooth(8); else waterDetailLayer.noSmooth();
      }
    }
    if (waterDetailLayer == null) return;
    if (!waterDetailDirty && !(sizeChanged || viewChanged || settingsChanged)) return;

    try {
      waterDetailLayer.beginDraw();
      waterDetailLayer.clear();
      PGraphics prev = app.g;
      app.g = waterDetailLayer;
      waterDetailLayer.pushMatrix();
      waterDetailLayer.pushStyle();
      viewport.applyTransform(waterDetailLayer, waterDetailLayer.width, waterDetailLayer.height);
      if (wantRipples) drawWaterRipples(app, s, seaLevel);
      if (wantHatching) drawWaterHatching(app, s, seaLevel);
      waterDetailLayer.popStyle();
      waterDetailLayer.popMatrix();
      app.g = prev;
      waterDetailLayer.endDraw();
    } catch (Exception ex) {
      println("Water detail layer build failed: " + ex);
      waterDetailLayer = null;
    }

    waterDetailLayerHash = hash;
    waterDetailLayerZoom = viewport.zoom;
    waterDetailLayerCenterX = viewport.centerX;
    waterDetailLayerCenterY = viewport.centerY;
    waterDetailLayerSeaLevel = seaLevel;
    waterDetailLayerCellCount = model.cells.size();
    waterDetailDirty = false;
  }

  private void drawCoastLayer(PGraphics g, RenderSettings s, float seaLevel) {
    HashSet<String> drawn = new HashSet<String>();
    HashSet<String> capsDrawn = new HashSet<String>();
    int strokeCol = hsbColor(s.waterContourHue01, s.waterContourSat01, s.waterContourBri01, 1.0f);
    float strokeW = strokeWorldPx(max(0.1f, s.waterCoastSizePx), s.waterCoastScaleWithZoom, s.waterContourRefZoom);
    float thisHalfWeight = strokeW * 0.5f;
    g.strokeWeight(strokeW);
    g.stroke(strokeCol);
    // g.strokeCap(drawRoundCaps ? PConstants.ROUND : PConstants.SQUARE);
    g.noFill();
    model.ensureCellNeighborsComputed();
    for (int ci = 0; ci < model.cells.size(); ci++) {
      Cell c = model.cells.get(ci);
      if (c == null || c.vertices == null || c.vertices.size() < 3) continue;
      boolean isWater = c.elevation < seaLevel;
      int vc = c.vertices.size();
      for (int e = 0; e < vc; e++) {
        PVector a = c.vertices.get(e);
        PVector b = c.vertices.get((e + 1) % vc);
        String key = undirectedEdgeKey(a, b);
        if (drawn.contains(key)) continue;
        boolean boundary = false;
        boolean nbIsWater = false;
        ArrayList<Integer> nbs = (ci < model.cellNeighbors.size()) ? model.cellNeighbors.get(ci) : null;
        if (nbs != null) {
          for (int nbIdx : nbs) {
            if (nbIdx < 0 || nbIdx >= model.cells.size()) continue;
            Cell nb = model.cells.get(nbIdx);
            if (nb == null || nb.vertices == null) continue;
            int nv = nb.vertices.size();
            boolean match = false;
            for (int j = 0; j < nv; j++) {
              PVector na = nb.vertices.get(j);
              PVector nbp = nb.vertices.get((j + 1) % nv);
              if ((model.distSq(a, na) < 1e-6f && model.distSq(b, nbp) < 1e-6f) ||
                  (model.distSq(a, nbp) < 1e-6f && model.distSq(b, na) < 1e-6f)) {
                nbIsWater = nb.elevation < seaLevel;
                boundary = isWater != nbIsWater;
                match = true;
                break;
              }
            }
            if (match) break;
          }
        }
        if (!boundary) continue;
        drawn.add(key);
        if (isWater || nbIsWater) {
          g.line(a.x, a.y, b.x, b.y);
          if (drawRoundCaps) {
            String ka = undirectedEdgeKey(a, a);
            String kb = undirectedEdgeKey(b, b);
            g.noStroke();
            g.fill(strokeCol);
            if (!capsDrawn.contains(ka)) {
              capsDrawn.add(ka);
              g.ellipse(a.x, a.y, thisHalfWeight * 2, thisHalfWeight * 2);
            }
            if (!capsDrawn.contains(kb)) {
              capsDrawn.add(kb);
              g.ellipse(b.x, b.y, thisHalfWeight * 2, thisHalfWeight * 2);
            }
            g.stroke(strokeCol);
          }
        }
      }
    }
  }

  private int zoneSettingsHash(RenderSettings s, int[] zoneCols) {
    int h = 19;
    h = 31 * h + round(s.zoneStrokeSatScale01 * 1000.0f);
    h = 31 * h + round(s.zoneStrokeBriScale01 * 1000.0f);
    h = 31 * h + round(s.zoneStrokeSizePx * 1000.0f);
    h = 31 * h + hashArray(zoneCols);
    h = 31 * h + (drawRoundCaps ? 1 : 0);
    h = 31 * h + ((model != null && model.cells != null) ? model.cells.size() : 0);
    h = 31 * h + ((model != null && model.zones != null) ? model.zones.size() : 0);
    return h;
  }

  private void ensureZoneLayer(PApplet app, RenderSettings s) {
    if (model == null || model.cells == null || model.cells.isEmpty() || model.zones == null) {
      zoneLayer = null;
      return;
    }
    if (app == null) return;
    int[] zoneStrokeCols = buildZoneStrokeColors(s);
    int targetW = (app.g != null) ? app.g.width : app.width;
    int targetH = (app.g != null) ? app.g.height : app.height;
    int hash = zoneSettingsHash(s, zoneStrokeCols);
    boolean sizeChanged = zoneLayer == null || zoneLayerW != targetW || zoneLayerH != targetH;
    boolean viewChanged = zoneLayer == null ||
                          abs(zoneLayerZoom - viewport.zoom) > 1e-4f ||
                          abs(zoneLayerCenterX - viewport.centerX) > 1e-4f ||
                          abs(zoneLayerCenterY - viewport.centerY) > 1e-4f;
    boolean settingsChanged = zoneLayer == null ||
                              zoneLayerHash != hash ||
                              zoneLayerCellCount != model.cells.size() ||
                              zoneLayerZoneCount != model.zones.size();

    if (sizeChanged) {
      try {
        zoneLayer = app.createGraphics(targetW, targetH, JAVA2D);
      } catch (Exception ex) {
        println("Zone layer alloc failed: " + ex);
        zoneLayer = null;
      }
      zoneLayerW = targetW;
      zoneLayerH = targetH;
      if (zoneLayer != null) {
        if (s.antialiasing) zoneLayer.smooth(8); else zoneLayer.noSmooth();
      }
    } else {
      if (zoneLayer != null) {
        if (s.antialiasing) zoneLayer.smooth(8); else zoneLayer.noSmooth();
      }
    }
    if (zoneLayer == null) return;
    if (!zoneDirty && !(sizeChanged || viewChanged || settingsChanged)) return;

    try {
      zoneLayer.beginDraw();
      zoneLayer.clear();
      zoneLayer.pushMatrix();
      zoneLayer.pushStyle();
      viewport.applyTransform(zoneLayer, zoneLayer.width, zoneLayer.height);
      float zoneW = strokeWorldPx(max(0.1f, s.zoneStrokeSizePx), s.zoneStrokeScaleWithZoom, s.zoneStrokeRefZoom);
      drawZoneLayer(zoneLayer, zoneStrokeCols, zoneW, s);
      zoneLayer.popStyle();
      zoneLayer.popMatrix();
      zoneLayer.endDraw();
    } catch (Exception ex) {
      println("Zone layer build failed: " + ex);
      zoneLayer = null;
      return;
    }

    zoneLayerHash = hash;
    zoneLayerZoom = viewport.zoom;
    zoneLayerCenterX = viewport.centerX;
    zoneLayerCenterY = viewport.centerY;
    zoneLayerCellCount = model.cells.size();
    zoneLayerZoneCount = model.zones.size();
    zoneDirty = false;
  }

  private void drawZoneLayer(PGraphics g, int[] zoneStrokeCols, float zoneW, RenderSettings s) {
    if (s == null || model.cells == null || model.cells.isEmpty()) return;
    model.ensureCellNeighborsComputed();
    int n = model.cells.size();

    // zone membership per cell
    ArrayList<ArrayList<Integer>> zoneForCell = new ArrayList<ArrayList<Integer>>(n);
    for (int i = 0; i < n; i++) zoneForCell.add(new ArrayList<Integer>());
    if (model.zones != null) {
      for (int zi = 0; zi < model.zones.size(); zi++) {
        MapModel.MapZone z = model.zones.get(zi);
        if (z == null || z.cells == null) continue;
        for (int ci : z.cells) {
          if (ci < 0 || ci >= n) continue;
          ArrayList<Integer> list = zoneForCell.get(ci);
          if (!list.contains(zi)) list.add(zi);
        }
      }
    }

    float eps2 = 1e-6f;
    float laneGap = max(0.2f / viewport.zoom, zoneW * 0.4f);
    HashSet<String> drawn = new HashSet<String>();
    ArrayList<Integer> listA = new ArrayList<Integer>();
    ArrayList<Integer> listB = new ArrayList<Integer>();
    ArrayList<SegInfo> allSegs = new ArrayList<SegInfo>();
    HashMap<String, CapInfo> capMap = new HashMap<String, CapInfo>();

    class Lane {
      float width;
      int col;
      int zoneId;
      Lane(float w, int ccol, int zid) { width = w; col = ccol; zoneId = zid; }
    }

    for (int ci = 0; ci < n; ci++) {
      Cell c = model.cells.get(ci);
      if (c == null || c.vertices == null || c.vertices.size() < 3) continue;
      ArrayList<Integer> zonesA = zoneForCell.get(ci);
      int vc = c.vertices.size();
      for (int e = 0; e < vc; e++) {
        PVector a = c.vertices.get(e);
        PVector b = c.vertices.get((e + 1) % vc);
        String key = undirectedEdgeKey(a, b);
        if (drawn.contains(key)) continue;

        ArrayList<Integer> zonesB = null;
        ArrayList<Integer> nbs = (ci < model.cellNeighbors.size()) ? model.cellNeighbors.get(ci) : null;
        if (nbs != null) {
          for (int nbIdx : nbs) {
            if (nbIdx < 0 || nbIdx >= n) continue;
            Cell nb = model.cells.get(nbIdx);
            if (nb == null || nb.vertices == null) continue;
            int nv = nb.vertices.size();
            boolean matched = false;
            for (int j = 0; j < nv; j++) {
              PVector na = nb.vertices.get(j);
              PVector nbp = nb.vertices.get((j + 1) % nv);
              boolean match = model.distSq(a, na) < eps2 && model.distSq(b, nbp) < eps2;
              boolean matchRev = model.distSq(a, nbp) < eps2 && model.distSq(b, na) < eps2;
              if (match || matchRev) {
                zonesB = zoneForCell.get(nbIdx);
                matched = true;
                break;
              }
            }
            if (matched) break;
          }
        }

        HashSet<Integer> setA = (zonesA != null) ? new HashSet<Integer>(zonesA) : new HashSet<Integer>();
        HashSet<Integer> setB = (zonesB != null) ? new HashSet<Integer>(zonesB) : new HashSet<Integer>();
        HashSet<Integer> uniqueA = new HashSet<Integer>(setA);
        uniqueA.removeAll(setB);
        HashSet<Integer> uniqueB = new HashSet<Integer>(setB);
        uniqueB.removeAll(setA);

        boolean hasDiff = !uniqueA.isEmpty() || !uniqueB.isEmpty();
        if (!hasDiff) { drawn.add(key); continue; }

        PVector cenA = model.cellCentroid(c);
        PVector mid = new PVector((a.x + b.x) * 0.5f, (a.y + b.y) * 0.5f);
        PVector edgeDir = new PVector(b.x - a.x, b.y - a.y);
        PVector nrm = new PVector(-edgeDir.y, edgeDir.x);
        float nLen = max(1e-6f, sqrt(nrm.x * nrm.x + nrm.y * nrm.y));
        nrm.mult(1.0f / nLen);
        if (cenA != null) {
          PVector toCenter = PVector.sub(cenA, mid);
          if (toCenter.dot(nrm) < 0) nrm.mult(-1);
        }

        ArrayList<Lane> lanesPos = new ArrayList<Lane>();
        ArrayList<Lane> lanesNeg = new ArrayList<Lane>();

        listA.clear(); listA.addAll(uniqueA); Collections.sort(listA);
        listB.clear(); listB.addAll(uniqueB); Collections.sort(listB);
        for (int zId : listA) {
          if (zId < 0 || zId >= model.zones.size()) continue;
          int colZ = (zoneStrokeCols != null && zId < zoneStrokeCols.length) ? zoneStrokeCols[zId] : -1;
          if (colZ != -1) lanesPos.add(new Lane(zoneW, colZ, zId));
        }
        for (int zId : listB) {
          if (zId < 0 || zId >= model.zones.size()) continue;
          int colZ = (zoneStrokeCols != null && zId < zoneStrokeCols.length) ? zoneStrokeCols[zId] : -1;
          if (colZ != -1) lanesNeg.add(new Lane(zoneW, colZ, zId));
        }

        Comparator<Lane> cmp = new Comparator<Lane>() {
          public int compare(Lane aL, Lane bL) { return Float.compare(bL.width, aL.width); }
        };
        Collections.sort(lanesPos, cmp);
        Collections.sort(lanesNeg, cmp);

        float offsetPos = 0;
        for (Lane l : lanesPos) {
          if (l.width <= 1e-4f) continue;
          float laneOff = offsetPos + l.width * 0.5f;
          float ax = a.x + nrm.x * laneOff;
          float ay = a.y + nrm.y * laneOff;
          float bx = b.x + nrm.x * laneOff;
          float by = b.y + nrm.y * laneOff;
          SegInfo si = new SegInfo(new PVector(ax, ay), new PVector(bx, by), a, b, l.width, l.col, l.zoneId);
          allSegs.add(si);
          capMap.putIfAbsent(undirectedEdgeKey(a, a) + "#" + l.zoneId, new CapInfo(si, true, l.width * 0.5f, l.col));
          capMap.putIfAbsent(undirectedEdgeKey(b, b) + "#" + l.zoneId, new CapInfo(si, false, l.width * 0.5f, l.col));
          offsetPos += l.width + laneGap;
        }
        float offsetNeg = 0;
        for (Lane l : lanesNeg) {
          if (l.width <= 1e-4f) continue;
          float laneOff = offsetNeg + l.width * 0.5f;
          float ax = a.x - nrm.x * laneOff;
          float ay = a.y - nrm.y * laneOff;
          float bx = b.x - nrm.x * laneOff;
          float by = b.y - nrm.y * laneOff;
          SegInfo si = new SegInfo(new PVector(ax, ay), new PVector(bx, by), a, b, l.width, l.col, l.zoneId);
          allSegs.add(si);
          capMap.putIfAbsent(undirectedEdgeKey(a, a) + "#" + l.zoneId, new CapInfo(si, true, l.width * 0.5f, l.col));
          capMap.putIfAbsent(undirectedEdgeKey(b, b) + "#" + l.zoneId, new CapInfo(si, false, l.width * 0.5f, l.col));
          offsetNeg += l.width + laneGap;
        }
        drawn.add(key);
      }
    }

    adjustZoneSegmentIntersections(allSegs);

    g.strokeWeight(1);
    for (SegInfo si : allSegs) {
      g.stroke(si.col);
      g.strokeWeight(si.w);
      g.line(si.a.x, si.a.y, si.b.x, si.b.y);
    }

    if (drawRoundCaps) {
      g.noStroke();
      for (CapInfo ci : capMap.values()) {
        PVector p = ci.atStart ? ci.seg.a : ci.seg.b;
        g.fill(ci.col);
        float d = ci.r * 2;
        g.ellipse(p.x, p.y, d, d);
      }
    }
  }

  public void drawIsoLine(PGraphics g, MapModel.ContourGrid grid, float iso, boolean caps, float capRadius, int capCol, HashSet<String> capsDrawn) {
    if (grid == null || g == null) return;
    for (int j = 0; j < grid.rows - 1; j++) {
      float y0 = grid.oy + j * grid.dy;
      float y1 = y0 + grid.dy;
      for (int i = 0; i < grid.cols - 1; i++) {
        float x0 = grid.ox + i * grid.dx;
        float x1 = x0 + grid.dx;
        float v00 = grid.v[j][i];
        float v10 = grid.v[j][i + 1];
        float v11 = grid.v[j + 1][i + 1];
        float v01 = grid.v[j + 1][i];

        int caseId = 0;
        if (v00 > iso) caseId |= 1;
        if (v10 > iso) caseId |= 2;
        if (v11 > iso) caseId |= 4;
        if (v01 > iso) caseId |= 8;

        if (caseId == 0 || caseId == 15) continue;

        PVector eTop = interpIso(x0, y0, v00, x1, y0, v10, iso);
        PVector eRight = interpIso(x1, y0, v10, x1, y1, v11, iso);
        PVector eBottom = interpIso(x0, y1, v01, x1, y1, v11, iso);
        PVector eLeft = interpIso(x0, y0, v00, x0, y1, v01, iso);

        switch (caseId) {
          case 1:  drawSeg(g, eLeft, eTop, caps, capRadius, capCol, capsDrawn); break;
          case 2:  drawSeg(g, eTop, eRight, caps, capRadius, capCol, capsDrawn); break;
          case 3:  drawSeg(g, eLeft, eRight, caps, capRadius, capCol, capsDrawn); break;
          case 4:  drawSeg(g, eRight, eBottom, caps, capRadius, capCol, capsDrawn); break;
          case 5:  drawSeg(g, eTop, eRight, caps, capRadius, capCol, capsDrawn); drawSeg(g, eLeft, eBottom, caps, capRadius, capCol, capsDrawn); break;
          case 6:  drawSeg(g, eTop, eBottom, caps, capRadius, capCol, capsDrawn); break;
          case 7:  drawSeg(g, eLeft, eBottom, caps, capRadius, capCol, capsDrawn); break;
          case 8:  drawSeg(g, eBottom, eLeft, caps, capRadius, capCol, capsDrawn); break;
          case 9:  drawSeg(g, eTop, eBottom, caps, capRadius, capCol, capsDrawn); break;
          case 10: drawSeg(g, eTop, eLeft, caps, capRadius, capCol, capsDrawn); drawSeg(g, eRight, eBottom, caps, capRadius, capCol, capsDrawn); break;
          case 11: drawSeg(g, eRight, eBottom, caps, capRadius, capCol, capsDrawn); break;
          case 12: drawSeg(g, eRight, eLeft, caps, capRadius, capCol, capsDrawn); break;
          case 13: drawSeg(g, eRight, eTop, caps, capRadius, capCol, capsDrawn); break;
          case 14: drawSeg(g, eTop, eLeft, caps, capRadius, capCol, capsDrawn); break;
        }
      }
    }
  }

  private void adjustZoneSegmentIntersections(ArrayList<SegInfo> segs) {
    if (segs == null || segs.isEmpty()) return;

    class SegEndpoint {
      SegInfo s;
      boolean isStart;
      int zoneId;
      float ang;
      SegEndpoint(SegInfo s, boolean isStart, int zoneId, float ang) {
        this.s = s; this.isStart = isStart; this.zoneId = zoneId; this.ang = ang;
      }
    }

    HashMap<String, ArrayList<SegEndpoint>> byVertex = new HashMap<String, ArrayList<SegEndpoint>>();
    for (SegInfo s : segs) {
      if (s == null) continue;
      PVector dirA = PVector.sub(s.b, s.a);
      PVector dirB = PVector.sub(s.a, s.b);
      String ka = undirectedEdgeKey(s.origA, s.origA) + "#" + s.zoneId;
      String kb = undirectedEdgeKey(s.origB, s.origB) + "#" + s.zoneId;
      float angA = atan2(dirA.y, dirA.x);
      float angB = atan2(dirB.y, dirB.x);
      byVertex.computeIfAbsent(ka, k -> new ArrayList<SegEndpoint>()).add(new SegEndpoint(s, true, s.zoneId, angA));
      byVertex.computeIfAbsent(kb, k -> new ArrayList<SegEndpoint>()).add(new SegEndpoint(s, false, s.zoneId, angB));
    }

    for (ArrayList<SegEndpoint> list : byVertex.values()) {
      if (list == null || list.size() < 2) continue;
      Collections.sort(list, new Comparator<SegEndpoint>() {
        public int compare(SegEndpoint a, SegEndpoint b) { return Float.compare(a.ang, b.ang); }
      });

      int m = list.size();
      for (int i = 0; i < m; i += 2) {
        SegEndpoint e0 = list.get(i);
        SegEndpoint e1 = list.get((i + 1) % m);
        if (e0.zoneId != e1.zoneId) continue;
        PVector p0a = e0.isStart ? e0.s.a : e0.s.b;
        PVector p0b = e0.isStart ? e0.s.b : e0.s.a;
        PVector p1a = e1.isStart ? e1.s.a : e1.s.b;
        PVector p1b = e1.isStart ? e1.s.b : e1.s.a;
        PVector inter = lineIntersection(p0a, p0b, p1a, p1b);
        if (inter == null) continue;
        if (e0.isStart) e0.s.a = inter.copy(); else e0.s.b = inter.copy();
        if (e1.isStart) e1.s.a = inter.copy(); else e1.s.b = inter.copy();
      }
    }
  }

  private int biomeSettingsHash(RenderSettings s, int[] biomeCols) {
    int h = 23;
    h = 31 * h + round(s.biomeOutlineSizePx * 1000.0f);
    h = 31 * h + round(s.biomeSatScale01 * 1000.0f);
    h = 31 * h + round(s.biomeBriScale01 * 1000.0f);
    h = 31 * h + (s.biomeFillType != null ? s.biomeFillType.ordinal() : -1);
    h = 31 * h + ((model != null && model.biomeTypes != null) ? model.biomeTypes.size() : 0);
    h = 31 * h + hashArray(biomeCols);
    h = 31 * h + (drawRoundCaps ? 1 : 0);
    h = 31 * h + ((model != null && model.cells != null) ? model.cells.size() : 0);
    return h;
  }

  private int elevationLightSettingsHash(RenderSettings s) {
    int h = 29;
    h = 31 * h + round(s.elevationLightAzimuthDeg * 100.0f);
    h = 31 * h + round(s.elevationLightAltitudeDeg * 100.0f);
    h = 31 * h + round(s.elevationLightAlpha01 * 1000.0f);
    h = 31 * h + round(s.elevationLightDitherPx * 1000.0f);
    h = 31 * h + (s.elevationLightDitherScaleWithZoom ? 1 : 0);
    h = 31 * h + (s.antialiasing ? 1 : 0);
    h = 31 * h + ((model != null && model.cells != null) ? model.cells.size() : 0);
    return h;
  }

  private boolean allocBiomeLayers(PApplet app, RenderSettings s, int targetW, int targetH, boolean preferP2D) {
    if (app == null) return false;
    PGraphics land = null;
    PGraphics water = null;
    Exception allocErr = null;
    if (preferP2D) {
      try {
        land = app.createGraphics(targetW, targetH, P2D);
        water = app.createGraphics(targetW, targetH, P2D);
      } catch (Exception ex) {
        allocErr = ex;
      }
    }
    if (land == null || water == null) {
      try {
        land = app.createGraphics(targetW, targetH, JAVA2D);
        water = app.createGraphics(targetW, targetH, JAVA2D);
      } catch (Exception ex) {
        allocErr = ex;
      }
    }
    biomeLandLayer = land;
    biomeWaterLayer = water;
    if (allocErr != null && (land == null || water == null)) {
      println("Biome layer alloc failed: " + allocErr);
    }
    if (biomeLandLayer != null) {
      if (s.antialiasing) biomeLandLayer.smooth(8); else biomeLandLayer.noSmooth();
    }
    if (biomeWaterLayer != null) {
      if (s.antialiasing) biomeWaterLayer.smooth(8); else biomeWaterLayer.noSmooth();
    }
    return biomeLandLayer != null && biomeWaterLayer != null;
  }

  private void ensureBiomeLayer(PApplet app, RenderSettings s) {
    if (model == null || model.cells == null || model.cells.isEmpty() || model.biomeTypes == null) {
      biomeLandLayer = null;
      biomeWaterLayer = null;
      return;
    }
    if (app == null) return;
    int[] biomeScaledCols = buildBiomeScaledColors(s);
    int targetW = (app.g != null) ? app.g.width : app.width;
    int targetH = (app.g != null) ? app.g.height : app.height;
    int hash = biomeSettingsHash(s, biomeScaledCols);
    boolean sizeChanged = biomeLandLayer == null || biomeWaterLayer == null || biomeLayerW != targetW || biomeLayerH != targetH;
    boolean viewChanged = biomeLandLayer == null ||
                          abs(biomeLayerZoom - viewport.zoom) > 1e-4f ||
                          abs(biomeLayerCenterX - viewport.centerX) > 1e-4f ||
                          abs(biomeLayerCenterY - viewport.centerY) > 1e-4f;
    boolean settingsChanged = biomeLandLayer == null ||
                              biomeLayerHash != hash ||
                              biomeLayerCellCount != model.cells.size() ||
                              biomeLayerBiomeCount != model.biomeTypes.size();

    if (sizeChanged) {
      boolean ok = allocBiomeLayers(app, s, targetW, targetH, true);
      biomeLayerW = targetW;
      biomeLayerH = targetH;
      if (!ok) return;
    } else {
      if (biomeLandLayer != null) {
        if (s.antialiasing) biomeLandLayer.smooth(8); else biomeLandLayer.noSmooth();
      }
      if (biomeWaterLayer != null) {
        if (s.antialiasing) biomeWaterLayer.smooth(8); else biomeWaterLayer.noSmooth();
      }
    }
    if (biomeLandLayer == null || biomeWaterLayer == null) return;
    if (!(sizeChanged || viewChanged || settingsChanged)) return;

    boolean built = false;
    boolean triedFallback = false;
    for (int attempt = 0; attempt < 2 && !built; attempt++) {
      try {
        biomeLandLayer.beginDraw();
        biomeLandLayer.clear();
        biomeLandLayer.pushMatrix();
        biomeLandLayer.pushStyle();
        viewport.applyTransform(biomeLandLayer, biomeLandLayer.width, biomeLandLayer.height);

        biomeWaterLayer.beginDraw();
        biomeWaterLayer.clear();
        biomeWaterLayer.pushMatrix();
        biomeWaterLayer.pushStyle();
        viewport.applyTransform(biomeWaterLayer, biomeWaterLayer.width, biomeWaterLayer.height);

        drawBiomeLayer(biomeLandLayer, biomeWaterLayer, biomeScaledCols);

        biomeLandLayer.popStyle();
        biomeLandLayer.popMatrix();
        biomeLandLayer.endDraw();
        biomeWaterLayer.popStyle();
        biomeWaterLayer.popMatrix();
        biomeWaterLayer.endDraw();
        built = true;
      } catch (Exception ex) {
        println("Biome layer build failed: " + ex);
        biomeLandLayer = null;
        biomeWaterLayer = null;
        if (!triedFallback) {
          triedFallback = true;
          if (!allocBiomeLayers(app, s, targetW, targetH, false)) {
            break;
          }
        }
      }
    }
    if (!built) return;

    biomeLayerHash = hash;
    biomeLayerZoom = viewport.zoom;
    biomeLayerCenterX = viewport.centerX;
    biomeLayerCenterY = viewport.centerY;
    biomeLayerCellCount = model.cells.size();
    biomeLayerBiomeCount = model.biomeTypes.size();
    biomeDirty = false;
  }

  private void drawBiomeLayer(PGraphics landG, PGraphics waterG, int[] biomeScaledCols) {
    if (model.cells == null || model.cells.isEmpty()) return;
    model.ensureCellNeighborsComputed();
    int n = model.cells.size();
    landG.noStroke();
    waterG.noStroke();
    for (int ci = 0; ci < n; ci++) {
      Cell c = model.cells.get(ci);
      if (c == null || c.vertices == null || c.vertices.size() < 3) continue;
      int biomeIdx = c.biomeId;
      if (biomeIdx < 0 || biomeIdx >= biomeScaledCols.length) continue;
      int col = biomeScaledCols[biomeIdx];
      if (col == 0) continue;
      boolean underwater = c.elevation < seaLevel;
      PGraphics tgt = underwater ? waterG : landG;
      tgt.fill(col, 255);
      tgt.beginShape();
      for (PVector v : c.vertices) tgt.vertex(v.x, v.y);
      tgt.endShape(CLOSE);
    }
  }

  private void ensureElevationLightLayer(PApplet app, RenderSettings s, float seaLevel) {
    if (model == null || model.cells == null || model.cells.isEmpty()) {
      elevationLightLayer = null;
      return;
    }
    if (app == null) return;
    int targetW = (app.g != null) ? app.g.width : app.width;
    int targetH = (app.g != null) ? app.g.height : app.height;
    int hash = elevationLightSettingsHash(s);
    boolean sizeChanged = elevationLightLayer == null || elevationLightW != targetW || elevationLightH != targetH;
    boolean viewChanged = elevationLightLayer == null ||
                          abs(elevationLightZoom - viewport.zoom) > 1e-4f ||
                          abs(elevationLightCenterX - viewport.centerX) > 1e-4f ||
                          abs(elevationLightCenterY - viewport.centerY) > 1e-4f;
    boolean settingsChanged = elevationLightLayer == null ||
                              elevationLightHashVal != hash ||
                              abs(elevationLightSeaLevel - seaLevel) > 1e-6f ||
                              elevationLightCellCount != model.cells.size() ||
                              currentTool == Tool.EDIT_ELEVATION;

    if (sizeChanged) {
      try {
        elevationLightLayer = app.createGraphics(targetW, targetH, JAVA2D);
      } catch (Exception ex) {
        println("Elevation light layer alloc failed: " + ex);
        elevationLightLayer = null;
      }
      elevationLightW = targetW;
      elevationLightH = targetH;
      if (elevationLightLayer != null) {
        if (s.antialiasing) elevationLightLayer.smooth(8); else elevationLightLayer.noSmooth();
      }
    } else {
      if (elevationLightLayer != null) {
        if (s.antialiasing) elevationLightLayer.smooth(8); else elevationLightLayer.noSmooth();
      }
    }
    if (elevationLightLayer == null) return;
    if (!lightDirty && !(sizeChanged || viewChanged || settingsChanged)) return;

    try {
      elevationLightLayer.beginDraw();
      elevationLightLayer.clear();
      elevationLightLayer.background(255);
      elevationLightLayer.pushMatrix();
      elevationLightLayer.pushStyle();
      viewport.applyTransform(elevationLightLayer, elevationLightLayer.width, elevationLightLayer.height);
      drawElevationLightLayer(elevationLightLayer, s, seaLevel);
      elevationLightLayer.popStyle();
      elevationLightLayer.popMatrix();
      elevationLightLayer.endDraw();
    } catch (Exception ex) {
      println("Elevation light layer build failed: " + ex);
      elevationLightLayer = null;
      return;
    }

    float dither = max(0, s.elevationLightDitherPx);
    if (dither > 1e-3f) {
      if (s.elevationLightDitherScaleWithZoom) {
        float ref = (s.elevationLightDitherRefZoom > 1e-6f) ? s.elevationLightDitherRefZoom : DEFAULT_VIEW_ZOOM;
        dither *= max(1e-6f, viewport.zoom) / ref;
      }
      applyLightDither(elevationLightLayer, dither);
    }

    elevationLightHashVal = hash;
    elevationLightZoom = viewport.zoom;
    elevationLightCenterX = viewport.centerX;
    elevationLightCenterY = viewport.centerY;
    elevationLightSeaLevel = seaLevel;
    elevationLightCellCount = model.cells.size();
    lightDirty = false;
  }

  private void drawElevationLightLayer(PGraphics g, RenderSettings s, float seaLevel) {
    float az = radians(s.elevationLightAzimuthDeg);
    float alt = radians(s.elevationLightAltitudeDeg);
    PVector lightDir = new PVector(cos(alt) * cos(az), cos(alt) * sin(az), sin(alt));
    lightDir.normalize();
    // Draw with a matching stroke to hide seams between polygons
    // g.strokeJoin(PConstants.MITER);
    // g.strokeCap(PConstants.PROJECT);
    float seamW = 1.0f / max(0.1f, viewport.zoom);
    g.strokeWeight(seamW);
    for (int ci = 0; ci < model.cells.size(); ci++) {
      Cell c = model.cells.get(ci);
      if (c == null || c.vertices == null || c.vertices.size() < 3) continue;
      if (c.elevation < seaLevel) continue;
      float light = ElevationRenderer.computeLightForCell(model, ci, lightDir);
      float a = s.elevationLightAlpha01 * (1.0f - light);
      if (a <= 1e-4f) continue;
      float shade = constrain(255.0f - a * 255.0f, 0, 255); // 255=no change in multiply, darker when lower
      g.stroke(shade);
      g.fill(shade);
      // Stroke then fill to ensure overlap
      g.beginShape();
      for (PVector v : c.vertices) g.vertex(v.x, v.y);
      g.endShape(PConstants.CLOSE);
    }
  }

  private void applyLightDither(PGraphics g, float radius) {
    if (g == null || radius <= 1e-4f) return;
    g.loadPixels();
    int w = g.width;
    int h = g.height;
    int total = w * h;
    if (total <= 0) return;
    int swaps = total / 2;
    for (int i = 0; i < swaps; i++) {
      int idx = (int)random(total);
      int x = idx % w;
      int y = idx / w;
      int dx = round(random(-radius, radius));
      int dy = round(random(-radius, radius));
      int x2 = constrain(x + dx, 0, w - 1);
      int y2 = constrain(y + dy, 0, h - 1);
      int idx2 = y2 * w + x2;
      int tmp = g.pixels[idx];
      g.pixels[idx] = g.pixels[idx2];
      g.pixels[idx2] = tmp;
    }
    g.updatePixels();
  }

  public PImage generateNoiseTexture() {
    PImage im = new PImage(1000, 1000);
    im.loadPixels();
    for (int x = 0; x < im.width; x++) {
      for (int y = 0; y < im.height; y++) {
        im.pixels[y * im.width + x] = color(random(0x100));
      }
    }
    im.updatePixels();
    return im;
  }

  // Reset staged render prep (call when entering heavy modes or after invalidation)
  public void resetRenderPrep(boolean forceAllDirty) {
    renderPrepCompleted = 0;
    renderPrepTotal = 0;
    // Only rebuild fonts on explicit full dirties; otherwise leave as-is.
    if (forceAllDirty) {
      fontPrepNeeded = true;
      coastDirty = biomeDirty = zoneDirty = lightDirty = true;
    }
  }

  public boolean hasAnyRenderCache() {
    return coastLayer != null || biomeLandLayer != null || biomeWaterLayer != null || zoneLayer != null || elevationLightLayer != null;
  }

  public boolean isRenderWorkNeeded() {
    return fontPrepNeeded || coastDirty || biomeDirty || zoneDirty || lightDirty || !hasAnyRenderCache();
  }

  // Rebuild non-heavy layers immediately (biomes, zones, light). Returns true if any work was done.
  public boolean rebuildCheapLayersImmediate(PApplet app, RenderSettings s, float seaLevel) {
    if (app == null || s == null) return false;
    boolean did = false;
    if (biomeDirty) {
      ensureBiomeLayer(app, s);
      biomeDirty = false;
      did = true;
    }
    if (zoneDirty) {
      ensureZoneLayer(app, s);
      zoneDirty = false;
      did = true;
    }
    if (lightDirty) {
      ensureElevationLightLayer(app, s, seaLevel);
      lightDirty = false;
      did = true;
    }
    return did;
  }

  public int getRenderPrepStage() {
    return renderPrepCompleted;
  }

  public int getRenderPrepStageCount() {
    return max(renderPrepTotal, renderPrepCompleted + pendingStageCount());
  }

  public String getRenderPrepStageLabel() {
    int st = nextPendingStage();
    switch (st) {
      case STAGE_FONTS: return "fonts";
      case STAGE_COAST: return "coastlines";
      case STAGE_BIOMES: return "biomes";
      case STAGE_ZONES: return "zones";
      case STAGE_LIGHT: return "elevation light";
      default: return "";
    }
  }

  private static final int STAGE_FONTS = 0;
  private static final int STAGE_COAST = 1;
  private static final int STAGE_BIOMES = 2;
  private static final int STAGE_ZONES = 3;
  private static final int STAGE_LIGHT = 4;

  private int pendingStageCount() {
    int c = 0;
    if (fontPrepNeeded) c++;
    if (coastDirty) c++;
    if (biomeDirty) c++;
    if (zoneDirty) c++;
    if (lightDirty) c++;
    return c;
  }

  private int nextPendingStage() {
    if (fontPrepNeeded) return STAGE_FONTS;
    if (coastDirty) return STAGE_COAST;
    if (biomeDirty) return STAGE_BIOMES;
    if (zoneDirty) return STAGE_ZONES;
    if (lightDirty) return STAGE_LIGHT;
    return -1;
  }

  // Incrementally build render layers; returns true when all stages done
  public boolean stepRenderPrep(PApplet app, RenderSettings s, float seaLevel) {
    if (!isRenderWorkNeeded()) {
      renderPrepCompleted = renderPrepTotal = 0;
      return true;
    }

    // Refresh total if it drifted
    renderPrepTotal = max(renderPrepTotal, renderPrepCompleted + pendingStageCount());

    int stage = nextPendingStage();
    if (stage == -1) {
      renderPrepCompleted = renderPrepTotal;
      return true;
    }

    switch (stage) {
      case STAGE_FONTS:
        warmLabelFonts(app, s);
        fontPrepNeeded = false;
        renderPrepCompleted++;
        break;
      case STAGE_COAST:
        ensureCoastLayer(app, s, seaLevel);
        coastDirty = false;
        renderPrepCompleted++;
        break;
      case STAGE_BIOMES:
        ensureBiomeLayer(app, s);
        biomeDirty = false;
        renderPrepCompleted++;
        break;
      case STAGE_ZONES:
        ensureZoneLayer(app, s);
        zoneDirty = false;
        renderPrepCompleted++;
        break;
      case STAGE_LIGHT:
        ensureElevationLightLayer(app, s, seaLevel);
        lightDirty = false;
        renderPrepCompleted++;
        break;
    }
    return pendingStageCount() == 0;
  }

  public float renderPrepProgress() {
    int total = max(renderPrepTotal, renderPrepCompleted + pendingStageCount());
    if (total <= 0) return 1.0f;
    return constrain(renderPrepCompleted / (float)total, 0, 1);
  }

  private int[] buildBiomeScaledColors(RenderSettings s) {
    if (model == null || model.biomeTypes == null || model.biomeTypes.isEmpty()) return null;
    int n = model.biomeTypes.size();
    float satScale = (s != null) ? s.biomeSatScale01 : 1.0f;
    float briScale = (s != null) ? s.biomeBriScale01 : 1.0f;
    boolean needRebuild = false;
    if (cachedBiomeScaledColors == null || cachedBiomeScaledColors.length != n) needRebuild = true;
    if (cachedBiomeSrcCols == null || cachedBiomeSrcCols.length != n) needRebuild = true;
    if (!needRebuild && (abs(cachedBiomeSatScale - satScale) > 1e-6f || abs(cachedBiomeBriScale - briScale) > 1e-6f)) needRebuild = true;
    if (!needRebuild) {
      for (int i = 0; i < n; i++) {
        ZoneType zt = model.biomeTypes.get(i);
        int src = (zt != null) ? zt.col : -1;
        if (cachedBiomeSrcCols[i] != src) { needRebuild = true; break; }
      }
    }
    if (!needRebuild) return cachedBiomeScaledColors;

    cachedBiomeScaledColors = new int[n];
    cachedBiomeSrcCols = new int[n];
    cachedBiomeSatScale = satScale;
    cachedBiomeBriScale = briScale;
    for (int i = 0; i < n; i++) {
      ZoneType zt = model.biomeTypes.get(i);
      if (zt == null) {
        cachedBiomeScaledColors[i] = -1;
        cachedBiomeSrcCols[i] = -1;
        continue;
      }
      cachedBiomeSrcCols[i] = zt.col;
      rgbToHSB01(zt.col, hsbScratch);
      float sat = constrain(hsbScratch[1] * satScale, 0, 1);
      float bri = constrain(hsbScratch[2] * briScale, 0, 1);
      cachedBiomeScaledColors[i] = hsb01ToARGB(hsbScratch[0], sat, bri, 1.0f);
    }
    return cachedBiomeScaledColors;
  }

  private int[] buildZoneStrokeColors(RenderSettings s) {
    if (model == null || model.zones == null || model.zones.isEmpty() || s == null) return null;
    int n = model.zones.size();
    float satScale = s.zoneStrokeSatScale01;
    float briScale = s.zoneStrokeBriScale01;
    boolean needRebuild = false;
    if (cachedZoneStrokeColors == null || cachedZoneStrokeColors.length != n) needRebuild = true;
    if (cachedZoneSrcCols == null || cachedZoneSrcCols.length != n) needRebuild = true;
    if (!needRebuild && (abs(cachedZoneSatScale - satScale) > 1e-6f || abs(cachedZoneBriScale - briScale) > 1e-6f)) needRebuild = true;
    if (!needRebuild) {
      for (int i = 0; i < n; i++) {
        MapModel.MapZone z = model.zones.get(i);
        int src = (z != null) ? z.col : -1;
        if (cachedZoneSrcCols[i] != src) { needRebuild = true; break; }
      }
    }
    if (!needRebuild) return cachedZoneStrokeColors;

    cachedZoneStrokeColors = new int[n];
    cachedZoneSrcCols = new int[n];
    cachedZoneSatScale = satScale;
    cachedZoneBriScale = briScale;
    for (int i = 0; i < n; i++) {
      MapModel.MapZone z = model.zones.get(i);
      if (z == null) {
        cachedZoneStrokeColors[i] = -1;
        cachedZoneSrcCols[i] = -1;
        continue;
      }
      cachedZoneSrcCols[i] = z.col;
      rgbToHSB01(z.col, hsbScratch);
      float sat = constrain(hsbScratch[1] * satScale, 0, 1);
      float bri = constrain(hsbScratch[2] * briScale, 0, 1);
      cachedZoneStrokeColors[i] = hsb01ToARGB(hsbScratch[0], sat, bri, 1.0f);
    }
    return cachedZoneStrokeColors;
  }

}
// Label rendering helpers split from MapRenderer.pde

class LabelRenderer {
  private final MapModel model;
  private final HashMap<String, PFont> labelFontCache = new HashMap<String, PFont>();
  private String labelFontName = (LABEL_FONT_OPTIONS != null && LABEL_FONT_OPTIONS.length > 0) ? LABEL_FONT_OPTIONS[0] : "SansSerif";
  private PGraphics labelLayer = null;
  private int labelLayerW = 0;
  private int labelLayerH = 0;

  LabelRenderer(MapModel model) {
    this.model = model;
  }

  public void drawLabels(PApplet app) {
    if (model.labels == null) return;
    app.pushStyle();
    app.textAlign(CENTER, CENTER);
    for (MapLabel l : model.labels) {
      if (l == null || l.text == null) continue;
      float ts = l.size;
      // Use a tiny default outline in edit mode (alpha 0.2) to keep consistent look
      drawTextWithOutline(app, renderSettings, l.text, l.x, l.y, ts, 0.2f, 1.0f, 0.0f, false, resolveLabelFontName(renderSettings));
    }
    app.popStyle();
  }

  public void drawLabelsRender(PApplet app, RenderSettings s) {
    if (model.labels == null || s == null) return;
    if (!s.showLabelsArbitrary) return;
    app.pushStyle();
    app.textAlign(CENTER, CENTER);
    String fontName = resolveLabelFontName(s);
    boolean snap = !(currentTool == Tool.EDIT_EXPORT);
    for (MapLabel l : model.labels) {
      if (l == null) continue;
      float ts = (s.labelSizeArbPx > 0) ? s.labelSizeArbPx : l.size;
      drawTextWithOutline(app, s, l.text, l.x, l.y, ts, s.labelOutlineAlpha01, s.labelOutlineSizePx, 0.0f, snap, fontName);
    }
    app.popStyle();
  }

  public void drawZoneLabelsRender(PApplet app, RenderSettings s) {
    if (model == null || model.zones == null || s == null) return;
    if (!s.showLabelsZones) return;
    app.pushStyle();
    app.fill(0);
    app.textAlign(CENTER, CENTER);
    float baseSize = (s.labelSizeZonePx > 0) ? s.labelSizeZonePx : labelSizeDefault();
    String fontName = resolveLabelFontName(s);
    for (MapModel.MapZone z : model.zones) {
      if (z == null || z.cells == null || z.cells.isEmpty()) continue;
      float cx = 0;
      float cy = 0;
      int count = 0;
      for (int ci : z.cells) {
        if (ci < 0 || ci >= model.cells.size()) continue;
        Cell c = model.cells.get(ci);
        if (c == null || c.vertices == null || c.vertices.size() < 3) continue;
        PVector cen = model.cellCentroid(c);
        cx += cen.x;
        cy += cen.y;
        count++;
      }
      if (count <= 0) continue;
      cx /= count;
      cy /= count;
      float ts = baseSize;
      boolean snap = !(currentTool == Tool.EDIT_EXPORT);
      drawTextWithOutline(app, s, (z.name != null) ? z.name : "Zone", cx, cy, ts, s.labelOutlineAlpha01, s.labelOutlineSizePx, 0.0f, snap, fontName);
    }
    app.popStyle();
  }

  public void drawPathLabelsRender(PApplet app, RenderSettings s) {
    if (model == null || model.paths == null || s == null) return;
    if (!s.showLabelsPaths) return;
    app.pushStyle();
    app.fill(0);
    app.textAlign(CENTER, CENTER);
    float baseSize = (s.labelSizePathPx > 0) ? s.labelSizePathPx : labelSizeDefault();
    String fontName = resolveLabelFontName(s);
    for (Path p : model.paths) {
      if (p == null || p.routes == null || p.routes.isEmpty()) continue;
      String txt = (p.name != null && p.name.length() > 0) ? p.name : "";
      PVector bestA = null, bestB = null;
      float bestLenSq = -1;
      for (ArrayList<PVector> route : p.routes) {
        if (route == null || route.size() < 2) continue;
        for (int i = 0; i < route.size() - 1; i++) {
          PVector a = route.get(i);
          PVector b = route.get(i + 1);
          float dx = b.x - a.x;
          float dy = b.y - a.y;
          float lenSq = dx * dx + dy * dy;
          if (lenSq > bestLenSq) {
            bestLenSq = lenSq;
            bestA = a;
            bestB = b;
          }
        }
      }
      if (bestA == null || bestB == null || bestLenSq <= 1e-8f) continue;
      float ts = baseSize;
      float angle = atan2(bestB.y - bestA.y, bestB.x - bestA.x);
      if (angle > HALF_PI || angle < -HALF_PI) angle += PI; // keep text upright
      float mx = (bestA.x + bestB.x) * 0.5f;
      float my = (bestA.y + bestB.y) * 0.5f;
      boolean snap = !(currentTool == Tool.EDIT_EXPORT);
      drawTextWithOutline(app, s, txt, mx, my, ts, s.labelOutlineAlpha01, s.labelOutlineSizePx, angle, snap, fontName);
    }
    app.popStyle();
  }

  public void drawStructureLabelsRender(PApplet app, RenderSettings s) {
    if (model == null || model.structures == null || s == null) return;
    if (!s.showLabelsStructures) return;
    app.pushStyle();
    app.fill(0);
    app.textAlign(CENTER, CENTER);
    float baseSize = (s.labelSizeStructPx > 0) ? s.labelSizeStructPx : labelSizeDefault();
    String fontName = resolveLabelFontName(s);
    boolean snap = !(currentTool == Tool.EDIT_EXPORT);
    for (Structure st : model.structures) {
      if (st == null) continue;
      String txt = (st.name != null && st.name.length() > 0) ? st.name : "";
      float ts = baseSize;
      drawTextWithOutline(app, s, txt, st.x, st.y, ts, s.labelOutlineAlpha01, s.labelOutlineSizePx, 0.0f, snap, fontName);
    }
    app.popStyle();
  }

  // Build an offscreen label layer (JAVA2D preferred) and draw all render labels into it.
  public PGraphics buildLabelLayer(PApplet app, RenderSettings s) {
    PGraphics lg = ensureLabelLayer(app);
    if (lg == null) return null;
    try {
      if (s != null && s.antialiasing) lg.smooth(); else lg.noSmooth();
      lg.beginDraw();
      lg.clear();
      PGraphics prev = app.g;
      app.g = lg;
      if (s != null) {
        if (s.showLabelsZones) drawZoneLabelsRender(app, s);
        if (s.showLabelsPaths) drawPathLabelsRender(app, s);
        if (s.showLabelsStructures) drawStructureLabelsRender(app, s);
        if (s.showLabelsArbitrary) drawLabelsRender(app, s);
      }
      app.g = prev;
      lg.endDraw();
    } catch (Exception ex) {
      println("Label layer build failed: " + ex);
      lg = null;
    }
    return lg;
  }

  // Pre-load likely label fonts/sizes so entering render/labels modes does not stutter.
  public void warmLabelFonts(PApplet app, RenderSettings s) {
    if (app == null) return;
    String fontName = resolveLabelFontName(s);
    HashSet<Integer> sizes = new HashSet<Integer>();
    sizes.add(max(1, round(labelSizeDefault())));
    if (s != null) {
      sizes.add(max(1, round((s.labelSizeArbPx > 0) ? s.labelSizeArbPx : labelSizeDefault())));
      sizes.add(max(1, round((s.labelSizeZonePx > 0) ? s.labelSizeZonePx : labelSizeDefault())));
      sizes.add(max(1, round((s.labelSizePathPx > 0) ? s.labelSizePathPx : labelSizeDefault())));
      sizes.add(max(1, round((s.labelSizeStructPx > 0) ? s.labelSizeStructPx : labelSizeDefault())));
    }
    for (int sz : sizes) {
      labelFont(app, sz, fontName);
    }
  }

  private String resolveLabelFontName(RenderSettings s) {
    if (LABEL_FONT_OPTIONS != null && LABEL_FONT_OPTIONS.length > 0) {
      int idx = 0;
      if (s != null) idx = constrain(s.labelFontIndex, 0, LABEL_FONT_OPTIONS.length - 1);
      return LABEL_FONT_OPTIONS[idx];
    }
    return "SansSerif";
  }

  private PFont labelFont(PApplet app, int sizePx, String desiredFont) {
    int key = max(1, sizePx);
    String fontKey = (desiredFont != null && desiredFont.length() > 0) ? desiredFont : labelFontName;
    String cacheKey = fontKey + "|" + key;
    PFont f = labelFontCache.get(cacheKey);
    if (f == null) {
      String chosen = fontKey;
      try {
        f = app.createFont(chosen, key, true);
      } catch (Exception ignored) {
      }
      if (f == null) {
        String[] fonts = PFont.list();
        if (fonts != null && fonts.length > 0) {
          chosen = fonts[0];
          try {
            f = app.createFont(chosen, key, true);
          } catch (Exception ignored) {
          }
        }
      }
      if (f == null) {
        f = app.createFont("SansSerif", key, true);
      }
      labelFontCache.put(cacheKey, f);
      labelFontName = chosen;
    }
    return f;
  }

  public void drawTextWithOutline(PApplet app, RenderSettings rs, String txt, float x, float y, float ts, float outlineAlpha01, float outlineSizePx, float angleRad, boolean snapToPixel, String fontName) {
    if (app == null || txt == null) return;
    try {
      RenderSettings s = (rs != null) ? rs : renderSettings;
      ensureFontMapReady(app.g);
      float finalSize = ts;
      float outlineSize = outlineSizePx;
      float canvasW = (app.g != null) ? app.g.width : app.width;
      float canvasH = (app.g != null) ? app.g.height : app.height;
      float resolutionScale = 1.0f;
      if (renderingForExport) {
        float baseW = max(1, width);
        float baseH = max(1, height);
        resolutionScale = max(canvasW / baseW, canvasH / baseH);
      }
      if (s != null && s.labelScaleWithZoom) {
        float ref = (s.labelScaleRefZoom > 1e-6f) ? s.labelScaleRefZoom : DEFAULT_VIEW_ZOOM;
        finalSize = ts * (max(1e-6f, viewport.zoom) / ref) * resolutionScale;
      }
      if (s != null && s.labelOutlineScaleWithZoom) {
        float ref = (s.labelScaleRefZoom > 1e-6f) ? s.labelScaleRefZoom : DEFAULT_VIEW_ZOOM;
        outlineSize = outlineSizePx * (max(1e-6f, viewport.zoom) / ref) * resolutionScale;
      }
      // Prevent runaway font allocations for huge zoom/export scales.
      finalSize = constrain(finalSize, 4.0f, 128.0f);
      outlineSize = constrain(outlineSize, 0, 64.0f);
      PVector screen = viewport.worldToScreen(x, y, canvasW, canvasH);
      if (snapToPixel && !renderingForExport) {
        screen.x = round(screen.x);
        screen.y = round(screen.y);
      }
      app.pushMatrix();
      app.resetMatrix();
      app.translate(screen.x, screen.y);
      app.rotate(angleRad);
      int fontSize = max(1, round(finalSize));
      PFont font = labelFont(app, fontSize, fontName);
      if (font != null) {
        app.textFont(font);
        app.textSize(fontSize);
      } else {
        app.textSize(fontSize);
      }
      float oa = constrain(outlineAlpha01, 0, 1);
      int radius = max(0, round(outlineSize));
      if (oa > 1e-4f) {
        app.fill(255, oa * 255);
        for (int dx = -radius; dx <= radius; dx++) {
          for (int dy = -radius; dy <= radius; dy++) {
            if (dx == 0 && dy == 0) continue;
            app.text(txt, dx, dy);
          }
        }
      }
      app.fill(0);
      app.text(txt, 0, 0);
      app.popMatrix();
    } catch (Exception ex) {
      println("Label draw skipped due to error: " + ex);
    }
  }

  // Some Processing builds leave fontMap null on offscreen P2D buffers; seed it so text works in exports.
  private void ensureFontMapReady(PGraphics pg) {
    if (pg == null) return;
    try {
      if (pg instanceof processing.opengl.PGraphicsOpenGL) {
        processing.opengl.PGraphicsOpenGL ogl = (processing.opengl.PGraphicsOpenGL)pg;
        Field fontField = findFontMapField(ogl.getClass());
        if (fontField == null) return;
        fontField.setAccessible(true);
        Object map = fontField.get(ogl);

        Object primary = null;
        Field primaryFontField = null;
        try {
          Method primaryMeth = ogl.getClass().getMethod("getPrimaryPG");
          primary = primaryMeth.invoke(ogl);
          if (primary != null) {
            primaryFontField = findFontMapField(primary.getClass());
            if (primaryFontField != null) primaryFontField.setAccessible(true);
          }
        } catch (Exception ignored) {}

        if (primary != null && primaryFontField != null) {
          Object pMap = primaryFontField.get(primary);
          if (pMap == null) {
            pMap = (map != null) ? map : new java.util.WeakHashMap();
            primaryFontField.set(primary, pMap);
          }
          if (map == null) {
            map = pMap;
            fontField.set(ogl, map);
          }
        }

        if (map == null) {
          map = new java.util.WeakHashMap();
          fontField.set(ogl, map);
          if (primary != null && primaryFontField != null && primaryFontField.get(primary) == null) {
            primaryFontField.set(primary, map);
          }
        }
      }
    } catch (Exception ex) {
      println("Font map init skipped: " + ex);
    }
  }

  // Locate the fontMap field up the class hierarchy.
  private Field findFontMapField(Class<?> cls) {
    Class<?> cur = cls;
    while (cur != null) {
      try {
        return cur.getDeclaredField("fontMap");
      } catch (NoSuchFieldException ignored) {
      }
      cur = cur.getSuperclass();
    }
    return null;
  }

  private PGraphics ensureLabelLayer(PApplet app) {
    if (app == null) return null;
    int targetW = (app.g != null) ? app.g.width : app.width;
    int targetH = (app.g != null) ? app.g.height : app.height;
    boolean sizeChanged = (labelLayer == null) || labelLayerW != targetW || labelLayerH != targetH;
    if (sizeChanged) {
      labelLayerW = targetW;
      labelLayerH = targetH;
      labelLayer = null;
      try {
        labelLayer = app.createGraphics(targetW, targetH, JAVA2D);
      } catch (Exception ignored) {}
      if (labelLayer == null) {
        try {
          labelLayer = app.createGraphics(targetW, targetH, P2D);
        } catch (Exception ignored) {}
      }
    }
    return labelLayer;
  }
}
class Path {
  // Each route is an ordered list of points; consecutive pairs form straight segments.
  ArrayList<ArrayList<PVector>> routes = new ArrayList<ArrayList<PVector>>();
  int typeId = 0;
  String name = "";
  String comment = "";

  public void addRoute(ArrayList<PVector> pts) {
    if (pts == null || pts.size() < 2) return;
    ArrayList<PVector> copy = new ArrayList<PVector>();
    for (PVector v : pts) copy.add(v.copy());
    routes.add(copy);
  }

  public void draw(PApplet app, float baseWeight, boolean taper, HashMap<String, Float> segWeights, int pathIndex, boolean showNodes, float sat) {
    if (routes.isEmpty()) return;
    float baseAlpha = app.alpha(app.g.strokeColor) / 255.0f;
    float alphaScale = sat;

    for (int ri = 0; ri < routes.size(); ri++) {
      ArrayList<PVector> seg = routes.get(ri);
      if (seg == null || seg.isEmpty()) continue;
      if (seg.size() == 1) {
        if (!showNodes) continue;
        float r = 3.0f / viewport.zoom;
        app.pushStyle();
        app.fill(app.g.strokeColor);
        PVector a = seg.get(0);
        app.ellipse(a.x, a.y, r, r);
        app.popStyle();
        continue;
      }

      for (int i = 0; i < seg.size() - 1; i++) {
        PVector a = seg.get(i);
        PVector b = seg.get(i + 1);
        String key = pathIndex + ":" + ri + ":" + i;
        float w = baseWeight;
        if (taper && segWeights != null && segWeights.containsKey(key)) {
          w = segWeights.get(key);
        }
        app.pushStyle();
        int rgb = app.g.strokeColor;
        float alpha = constrain(baseAlpha * alphaScale, 0, 1);
        int col = app.color((rgb >> 16) & 0xFF, (rgb >> 8) & 0xFF, rgb & 0xFF, alpha * 255);
        app.stroke(col);
        app.strokeCap(PConstants.ROUND);
        app.strokeJoin(PConstants.ROUND);
        float sw = max(1.5f, w) / viewport.zoom;
        app.strokeWeight(sw);
        app.line(a.x, a.y, b.x, b.y);
        // Manual caps to ensure consistent appearance across renderers
        float rad = sw * 0.5f;
        app.noStroke();
        app.fill(col);
        app.ellipse(a.x, a.y, rad * 2, rad * 2);
        app.ellipse(b.x, b.y, rad * 2, rad * 2);
        app.popStyle();
      }

      // Tiny endpoint dots to keep short segments visible
      if (showNodes) {
        float r = 2.0f / viewport.zoom;
        app.pushStyle();
        app.noStroke();
        app.fill(app.g.strokeColor);
        PVector a = seg.get(0);
        PVector b = seg.get(seg.size() - 1);
        app.ellipse(a.x, a.y, r, r);
        app.ellipse(b.x, b.y, r, r);
        app.popStyle();
      }
    }
  }

  // Used to preview a segment being drawn (can have different styling if needed)
  public void drawPreview(PApplet app, ArrayList<PVector> seg, int strokeCol, float weightPx) {
    if (seg == null || seg.isEmpty()) return;
    if (seg.size() == 1) {
      float r = 3.0f / viewport.zoom;
      app.pushStyle();
      app.noStroke();
      app.fill(strokeCol);
      PVector a = seg.get(0);
      app.ellipse(a.x, a.y, r, r);
      app.popStyle();
      return;
    }

    app.pushStyle();
    app.noFill();
    app.stroke(strokeCol);
    app.strokeCap(PConstants.ROUND);
    app.strokeJoin(PConstants.ROUND);
    app.strokeWeight(max(2.0f, weightPx) / viewport.zoom); // keep preview visible

    for (int i = 0; i < seg.size() - 1; i++) {
      PVector a = seg.get(i);
      PVector b = seg.get(i + 1);
      app.line(a.x, a.y, b.x, b.y);
    }

    // endpoint dots for clarity
    app.pushStyle();
    app.noStroke();
    app.fill(strokeCol);
    float r = 3.0f / viewport.zoom;
    PVector start = seg.get(0);
    PVector end = seg.get(seg.size() - 1);
    app.ellipse(start.x, start.y, r, r);
    app.ellipse(end.x, end.y, r, r);
    app.popStyle();

    app.popStyle();
  }

  public int routeCount() {
    return routes.size();
  }

  public int segmentCount() {
    int count = 0;
    for (ArrayList<PVector> r : routes) {
      if (r == null) continue;
      count += max(0, r.size() - 1);
    }
    return count;
  }

  public float totalLength() {
    float len = 0;
    for (ArrayList<PVector> seg : routes) {
      if (seg == null) continue;
      for (int i = 0; i < seg.size() - 1; i++) {
        PVector a = seg.get(i);
        PVector b = seg.get(i + 1);
        float dx = b.x - a.x;
        float dy = b.y - a.y;
        len += sqrt(dx * dx + dy * dy);
      }
    }
    return len;
  }
}
// Default render presets (all fields explicitly assigned for review)
public RenderPreset[] buildDefaultRenderPresets() {
  ArrayList<RenderPreset> list = new ArrayList<RenderPreset>();

  // Default
  {
    RenderSettings s = new RenderSettings();
    // Base
    s.landHue01 = 0.0f;
    s.landSat01 = 0.0f;
    s.landBri01 = 0.85f;
    s.waterHue01 = 0.55f;
    s.waterSat01 = 0.55f;
    s.waterBri01 = 0.55f;
    s.cellBorderAlpha01 = 0.0f;
    s.cellBorderSizePx = 1.0f;
    s.cellBorderScaleWithZoom = true;
    s.cellBorderRefZoom = DEFAULT_VIEW_ZOOM;
    s.backgroundNoiseAlpha01 = 0.1f;
    // Biomes
    s.biomeFillAlpha01 = 0.5f;
    s.biomeSatScale01 = 1.0f;
    s.biomeBriScale01 = 1.0f;
    s.biomeFillType = RenderFillType.RENDER_FILL_COLOR;
    s.biomeOutlineSizePx = 1.0f;
    s.biomeOutlineAlpha01 = 0.5f;
    s.biomeOutlineScaleWithZoom = true;
    s.biomeOutlineRefZoom = DEFAULT_VIEW_ZOOM;
    s.biomeUnderwaterAlpha01 = 0.1f;
    // Shading
    s.waterDepthAlpha01 = 0.75f;
    s.elevationLightAlpha01 = 0.75f;
    s.elevationLightAzimuthDeg = 220.0f;
    s.elevationLightAltitudeDeg = 45.0f;
    s.elevationLightDitherPx = 3.0f;
    s.elevationLightDitherScaleWithZoom = true;
    s.elevationLightDitherRefZoom = DEFAULT_VIEW_ZOOM;
    // Contours
    s.waterContourSizePx = 2.0f;
    s.waterRippleCount = 0;
    s.waterRippleDistancePx = 5.0f;
    s.waterContourHue01 = 0.6f;
    s.waterContourSat01 = 0.0f;
    s.waterContourBri01 = 0.0f;
    s.waterContourAlpha01 = 1.0f;
    s.waterCoastAlpha01 = 1.0f;
    s.waterCoastSizePx = 2.0f;
    s.waterCoastScaleWithZoom = true;
    s.waterCoastAboveZones = true;
    s.waterContourScaleWithZoom = true;
    s.waterContourRefZoom = DEFAULT_VIEW_ZOOM;
    s.waterRippleAlphaStart01 = 1.0f;
    s.waterRippleAlphaEnd01 = 0.3f;
    s.waterHatchAngleDeg = 0.0f;
    s.waterHatchLengthPx = 5.0f;
    s.waterHatchSpacingPx = 4.0f;
    s.waterHatchAlpha01 = 0.0f;
    s.elevationLinesCount = 0;
    s.elevationLinesStyle = ElevationLinesStyle.ELEV_LINES_BASIC;
    s.elevationLinesAlpha01 = 0.3f;
    s.elevationLinesSizePx = 1.0f;
    s.elevationLinesScaleWithZoom = true;
    s.elevationLinesRefZoom = DEFAULT_VIEW_ZOOM;
    // Paths
    s.pathSatScale01 = 1.0f;
    s.pathBriScale01 = 1.0f;
    s.showPaths = true;
    s.pathScaleWithZoom = true;
    s.pathScaleRefZoom = DEFAULT_VIEW_ZOOM;
    // Zones
    s.zoneStrokeAlpha01 = 0.75f;
    s.zoneStrokeSizePx = 2.0f;
    s.zoneStrokeSatScale01 = 0.75f;
    s.zoneStrokeBriScale01 = 1.0f;
    s.zoneStrokeScaleWithZoom = true;
    s.zoneStrokeRefZoom = DEFAULT_VIEW_ZOOM;
    // Structures
    s.showStructures = true;
    s.mergeStructures = true;
    s.structureSatScale01 = 1.0f;
    s.structureAlphaScale01 = 1.0f;
    s.structureShadowAlpha01 = 0.2f;
    s.structureStrokeScaleWithZoom = true;
    s.structureStrokeRefZoom = DEFAULT_VIEW_ZOOM;
    // Labels
    s.showLabelsArbitrary = true;
    s.showLabelsZones = true;
    s.showLabelsPaths = true;
    s.showLabelsStructures = true;
    s.labelOutlineAlpha01 = 1.0f;
    s.labelOutlineSizePx = 2.0f;
    s.labelSizeArbPx = 19.0f;
    s.labelSizeZonePx = 17.0f;
    s.labelSizePathPx = 12.0f;
    s.labelSizeStructPx = 14.0f;
    s.labelScaleWithZoom = true;
    s.labelScaleRefZoom = DEFAULT_VIEW_ZOOM;
    s.labelOutlineScaleWithZoom = true;
    s.labelFontIndex = 4;
    // General
    s.exportPaddingPct = 0.015f;
    s.antialiasing = true;
    s.activePresetIndex = 0;
    list.add(new RenderPreset("Default", s));
  }

  // Satellite
  {
    RenderSettings s = new RenderSettings();
    // Base
    s.landHue01 = 0.2f;
    s.landSat01 = 0.1f;
    s.landBri01 = 0.9f;
    s.waterHue01 = 0.6f;
    s.waterSat01 = 0.2f;
    s.waterBri01 = 0.4f;
    s.cellBorderAlpha01 = 0.0f;
    s.cellBorderSizePx = 1.0f;
    s.cellBorderScaleWithZoom = true;
    s.cellBorderRefZoom = DEFAULT_VIEW_ZOOM;
    s.backgroundNoiseAlpha01 = 0.0f;
    // Biomes
    s.biomeFillAlpha01 = 0.8f;
    s.biomeSatScale01 = 0.4f;
    s.biomeBriScale01 = 1.0f;
    s.biomeFillType = RenderFillType.RENDER_FILL_COLOR;
    s.biomeOutlineSizePx = 0.0f;
    s.biomeOutlineAlpha01 = 0.0f;
    s.biomeOutlineScaleWithZoom = true;
    s.biomeOutlineRefZoom = DEFAULT_VIEW_ZOOM;
    s.biomeUnderwaterAlpha01 = 0.0f;
    // Shading
    s.waterDepthAlpha01 = 0.8f;
    s.elevationLightAlpha01 = 0.6f;
    s.elevationLightAzimuthDeg = 200.0f;
    s.elevationLightAltitudeDeg = 60.0f;
    s.elevationLightDitherPx = 3.0f;
    s.elevationLightDitherScaleWithZoom = true;
    s.elevationLightDitherRefZoom = DEFAULT_VIEW_ZOOM;
    // Contours
    s.waterContourSizePx = 5.0f;
    s.waterRippleCount = 0;
    s.waterRippleDistancePx = 0.0f;
    s.waterContourHue01 = 0.6f;
    s.waterContourSat01 = 0.3f;
    s.waterContourBri01 = 0.6f;
    s.waterContourAlpha01 = 0.3f;
    s.waterCoastAlpha01 = 0.3f;
    s.waterCoastSizePx = 2.0f;
    s.waterCoastScaleWithZoom = true;
    s.waterCoastAboveZones = false;
    s.waterContourScaleWithZoom = true;
    s.waterContourRefZoom = DEFAULT_VIEW_ZOOM;
    s.waterRippleAlphaStart01 = 0.25f;
    s.waterRippleAlphaEnd01 = 0.08f;
    s.waterHatchAngleDeg = 0.0f;
    s.waterHatchLengthPx = 0.0f;
    s.waterHatchSpacingPx = 12.0f;
    s.waterHatchAlpha01 = 0.0f;
    s.elevationLinesCount = 0;
    s.elevationLinesStyle = ElevationLinesStyle.ELEV_LINES_BASIC;
    s.elevationLinesAlpha01 = 0.0f;
    s.elevationLinesSizePx = 1.0f;
    s.elevationLinesScaleWithZoom = true;
    s.elevationLinesRefZoom = DEFAULT_VIEW_ZOOM;
    // Paths
    s.pathSatScale01 = 0.7f;
    s.pathBriScale01 = 1.0f;
    s.showPaths = true;
    s.pathScaleWithZoom = true;
    s.pathScaleRefZoom = DEFAULT_VIEW_ZOOM;
    // Zones
    s.zoneStrokeAlpha01 = 0.0f;
    s.zoneStrokeSizePx = 2.0f;
    s.zoneStrokeSatScale01 = 0.0f;
    s.zoneStrokeBriScale01 = 0.0f;
    s.zoneStrokeScaleWithZoom = true;
    s.zoneStrokeRefZoom = DEFAULT_VIEW_ZOOM;
    // Structures
    s.showStructures = true;
    s.mergeStructures = false;
    s.structureSatScale01 = 1.0f;
    s.structureAlphaScale01 = 1.0f;
    s.structureShadowAlpha01 = 0.2f;
    s.structureStrokeScaleWithZoom = true;
    s.structureStrokeRefZoom = DEFAULT_VIEW_ZOOM;
    // Labels
    s.showLabelsArbitrary = false;
    s.showLabelsZones = false;
    s.showLabelsPaths = false;
    s.showLabelsStructures = false;
    s.labelOutlineAlpha01 = 0.0f;
    s.labelOutlineSizePx = 1.0f;
    s.labelSizeArbPx = 12.0f;
    s.labelSizeZonePx = 14.0f;
    s.labelSizePathPx = 12.0f;
    s.labelSizeStructPx = 12.0f;
    s.labelScaleWithZoom = true;
    s.labelScaleRefZoom = DEFAULT_VIEW_ZOOM;
    s.labelOutlineScaleWithZoom = true;
    s.labelFontIndex = 0;
    // General
    s.exportPaddingPct = 0.01f;
    s.antialiasing = true;
    s.activePresetIndex = 0;
    list.add(new RenderPreset("Satellite", s));
  }

  // Geographic
  {
    RenderSettings s = new RenderSettings();
    // Base
    s.landHue01 = 0.2f;
    s.landSat01 = 0.0f;
    s.landBri01 = 1.0f;
    s.waterHue01 = 0.6f;
    s.waterSat01 = 0.7f;
    s.waterBri01 = 0.6f;
    s.cellBorderAlpha01 = 0.0f;
    s.cellBorderSizePx = 1.0f;
    s.cellBorderScaleWithZoom = true;
    s.cellBorderRefZoom = DEFAULT_VIEW_ZOOM;
    s.backgroundNoiseAlpha01 = 0.0f;
    // Biomes
    s.biomeFillAlpha01 = 1.0f;
    s.biomeSatScale01 = 0.75f;
    s.biomeBriScale01 = 1.0f;
    s.biomeFillType = RenderFillType.RENDER_FILL_COLOR;
    s.biomeOutlineSizePx = 1.0f;
    s.biomeOutlineAlpha01 = 0.0f;
    s.biomeOutlineScaleWithZoom = true;
    s.biomeOutlineRefZoom = DEFAULT_VIEW_ZOOM;
    s.biomeUnderwaterAlpha01 = 0.0f;
    // Shading
    s.waterDepthAlpha01 = 0.3f;
    s.elevationLightAlpha01 = 0.3f;
    s.elevationLightAzimuthDeg = 280.0f;
    s.elevationLightAltitudeDeg = 15.0f;
    s.elevationLightDitherPx = 0.0f;
    // Contours
    s.waterContourSizePx = 2.5f;
    s.waterRippleCount = 0;
    s.waterRippleDistancePx = 0.0f;
    s.waterContourHue01 = 0.6f;
    s.waterContourSat01 = 0.25f;
    s.waterContourBri01 = 0.0f;
    s.waterContourAlpha01 = 1.0f;
    s.waterCoastAlpha01 = 1.0f;
    s.waterCoastSizePx = 2.0f;
    s.waterCoastScaleWithZoom = true;
    s.waterCoastAboveZones = false;
    s.waterContourScaleWithZoom = true;
    s.waterContourRefZoom = DEFAULT_VIEW_ZOOM;
    s.waterRippleAlphaStart01 = 0.9f;
    s.waterRippleAlphaEnd01 = 0.25f;
    s.waterHatchAngleDeg = 0.0f;
    s.waterHatchLengthPx = 0.0f;
    s.waterHatchSpacingPx = 12.0f;
    s.waterHatchAlpha01 = 0.0f;
    s.elevationLinesCount = 10;
    s.elevationLinesStyle = ElevationLinesStyle.ELEV_LINES_BASIC;
    s.elevationLinesAlpha01 = 0.6f;
    s.elevationLinesSizePx = 1.0f;
    s.elevationLinesScaleWithZoom = true;
    s.elevationLinesRefZoom = DEFAULT_VIEW_ZOOM;
    // Paths
    s.pathSatScale01 = 1.0f;
    s.pathBriScale01 = 1.0f;
    s.showPaths = true;
    s.pathScaleWithZoom = true;
    s.pathScaleRefZoom = DEFAULT_VIEW_ZOOM;
    // Zones
    s.zoneStrokeAlpha01 = 0.0f;
    s.zoneStrokeSizePx = 2.0f;
    s.zoneStrokeSatScale01 = 0.0f;
    s.zoneStrokeBriScale01 = 0.0f;
    s.zoneStrokeScaleWithZoom = true;
    s.zoneStrokeRefZoom = DEFAULT_VIEW_ZOOM;
    // Structures
    s.showStructures = false;
    s.mergeStructures = false;
    s.structureSatScale01 = 1.0f;
    s.structureAlphaScale01 = 1.0f;
    s.structureShadowAlpha01 = 0.2f;
    s.structureStrokeScaleWithZoom = true;
    s.structureStrokeRefZoom = DEFAULT_VIEW_ZOOM;
    // Labels
    s.showLabelsArbitrary = true;
    s.showLabelsZones = true;
    s.showLabelsPaths = true;
    s.showLabelsStructures = false;
    s.labelOutlineAlpha01 = 1.0f;
    s.labelOutlineSizePx = 2.0f;
    s.labelSizeArbPx = 16.0f;
    s.labelSizeZonePx = 17.0f;
    s.labelSizePathPx = 15.0f;
    s.labelSizeStructPx = 14.0f;
    s.labelScaleWithZoom = true;
    s.labelScaleRefZoom = DEFAULT_VIEW_ZOOM;
    s.labelOutlineScaleWithZoom = true;
    s.labelFontIndex = 2;
    // General
    s.exportPaddingPct = 0.02f;
    s.antialiasing = true;
    s.activePresetIndex = 0;
    list.add(new RenderPreset("Geographic", s));
  }

  // Grey
  {
    RenderSettings s = new RenderSettings();
    // Base
    s.landHue01 = 0.1f;
    s.landSat01 = 0.0f;
    s.landBri01 = 1.0f;
    s.waterHue01 = 0.0f;
    s.waterSat01 = 0.0f;
    s.waterBri01 = 0.25f;
    s.cellBorderAlpha01 = 0.0f;
    s.cellBorderSizePx = 1.0f;
    s.cellBorderScaleWithZoom = true;
    s.cellBorderRefZoom = DEFAULT_VIEW_ZOOM;
    s.backgroundNoiseAlpha01 = 0.0f;
    // Biomes
    s.biomeFillAlpha01 = 1.0f;
    s.biomeSatScale01 = 0.0f;
    s.biomeBriScale01 = 1.0f;
    s.biomeFillType = RenderFillType.RENDER_FILL_COLOR;
    s.biomeOutlineSizePx = 1.0f;
    s.biomeOutlineAlpha01 = 0.0f;
    s.biomeOutlineScaleWithZoom = true;
    s.biomeOutlineRefZoom = DEFAULT_VIEW_ZOOM;
    s.biomeUnderwaterAlpha01 = 0.0f;
    // Shading
    s.waterDepthAlpha01 = 0.5f;
    s.elevationLightAlpha01 = 0.25f;
    s.elevationLightAzimuthDeg = 220.0f;
    s.elevationLightAltitudeDeg = 25.0f;
    s.elevationLightDitherPx = 0.0f;
    // Contours
    s.waterContourSizePx = 3.0f;
    s.waterRippleCount = 0;
    s.waterRippleDistancePx = 0.0f;
    s.waterContourHue01 = 0.0f;
    s.waterContourSat01 = 0.0f;
    s.waterContourBri01 = 0.0f;
    s.waterContourAlpha01 = 1.0f;
    s.waterCoastAlpha01 = 1.0f;
    s.waterCoastSizePx = 2.0f;
    s.waterCoastScaleWithZoom = true;
    s.waterCoastAboveZones = false;
    s.waterContourScaleWithZoom = true;
    s.waterContourRefZoom = DEFAULT_VIEW_ZOOM;
    s.waterRippleAlphaStart01 = 0.8f;
    s.waterRippleAlphaEnd01 = 0.25f;
    s.waterHatchAngleDeg = 0.0f;
    s.waterHatchLengthPx = 0.0f;
    s.waterHatchSpacingPx = 12.0f;
    s.waterHatchAlpha01 = 0.0f;
    s.elevationLinesCount = 4;
    s.elevationLinesStyle = ElevationLinesStyle.ELEV_LINES_BASIC;
    s.elevationLinesAlpha01 = 0.25f;
    s.elevationLinesSizePx = 1.0f;
    s.elevationLinesScaleWithZoom = true;
    s.elevationLinesRefZoom = DEFAULT_VIEW_ZOOM;
    // Paths
    s.pathSatScale01 = 0.0f;
    s.pathBriScale01 = 1.0f;
    s.showPaths = true;
    s.pathScaleWithZoom = true;
    s.pathScaleRefZoom = DEFAULT_VIEW_ZOOM;
    // Zones
    s.zoneStrokeAlpha01 = 0.7f;
    s.zoneStrokeSizePx = 2.0f;
    s.zoneStrokeSatScale01 = 0.0f;
    s.zoneStrokeBriScale01 = 0.0f;
    s.zoneStrokeScaleWithZoom = true;
    s.zoneStrokeRefZoom = DEFAULT_VIEW_ZOOM;
    // Structures
    s.showStructures = true;
    s.mergeStructures = false;
    s.structureSatScale01 = 0.0f;
    s.structureAlphaScale01 = 1.0f;
    s.structureShadowAlpha01 = 0.25f;
    s.structureStrokeScaleWithZoom = true;
    s.structureStrokeRefZoom = DEFAULT_VIEW_ZOOM;
    // Labels
    s.showLabelsArbitrary = true;
    s.showLabelsZones = true;
    s.showLabelsPaths = true;
    s.showLabelsStructures = true;
    s.labelOutlineAlpha01 = 0.8f;
    s.labelOutlineSizePx = 1.0f;
    s.labelSizeArbPx = 12.0f;
    s.labelSizeZonePx = 14.0f;
    s.labelSizePathPx = 12.0f;
    s.labelSizeStructPx = 12.0f;
    s.labelScaleWithZoom = true;
    s.labelScaleRefZoom = DEFAULT_VIEW_ZOOM;
    s.labelOutlineScaleWithZoom = true;
    s.labelFontIndex = 0;
    // General
    s.exportPaddingPct = 0.015f;
    s.antialiasing = true;
    s.activePresetIndex = 0;
    list.add(new RenderPreset("Grey", s));
  }

  // Bitmap
  {
    RenderSettings s = new RenderSettings();
    // Base
    s.landHue01 = 0.1f;
    s.landSat01 = 0.0f;
    s.landBri01 = 1.0f;
    s.waterHue01 = 0.0f;
    s.waterSat01 = 0.0f;
    s.waterBri01 = 1.0f;
    s.cellBorderAlpha01 = 0.0f;
    s.cellBorderSizePx = 1.0f;
    s.cellBorderScaleWithZoom = true;
    s.cellBorderRefZoom = DEFAULT_VIEW_ZOOM;
    s.backgroundNoiseAlpha01 = 0.0f;
    // Biomes
    s.biomeFillAlpha01 = 1.0f;
    s.biomeSatScale01 = 0.0f;
    s.biomeBriScale01 = 0.0f;
    s.biomeFillType = RenderFillType.RENDER_FILL_PATTERN;
    s.biomeOutlineSizePx = 1.0f;
    s.biomeOutlineAlpha01 = 0.0f;
    s.biomeOutlineScaleWithZoom = true;
    s.biomeOutlineRefZoom = DEFAULT_VIEW_ZOOM;
    s.biomeUnderwaterAlpha01 = 0.0f;
    // Shading
    s.waterDepthAlpha01 = 0.0f;
    s.elevationLightAlpha01 = 0.0f;
    s.elevationLightAzimuthDeg = 220.0f;
    s.elevationLightAltitudeDeg = 45.0f;
    s.elevationLightDitherPx = 0.0f;
    // Contours
    s.waterContourSizePx = 2.0f;
    s.waterRippleCount = 0;
    s.waterRippleDistancePx = 4.0f;
    s.waterContourHue01 = 0.0f;
    s.waterContourSat01 = 0.0f;
    s.waterContourBri01 = 0.0f;
    s.waterContourAlpha01 = 1.0f;
    s.waterCoastAlpha01 = 1.0f;
    s.waterCoastSizePx = 2.0f;
    s.waterCoastScaleWithZoom = true;
    s.waterCoastAboveZones = false;
    s.waterContourScaleWithZoom = true;
    s.waterContourRefZoom = DEFAULT_VIEW_ZOOM;
    s.waterRippleAlphaStart01 = 0.8f;
    s.waterRippleAlphaEnd01 = 0.25f;
    s.waterHatchAngleDeg = -40.0f;
    s.waterHatchLengthPx = 8.0f;
    s.waterHatchSpacingPx = 4.0f;
    s.waterHatchAlpha01 = 1.0f;
    s.elevationLinesCount = 2;
    s.elevationLinesStyle = ElevationLinesStyle.ELEV_LINES_BASIC;
    s.elevationLinesAlpha01 = 1.0f;
    s.elevationLinesSizePx = 1.0f;
    s.elevationLinesScaleWithZoom = true;
    s.elevationLinesRefZoom = DEFAULT_VIEW_ZOOM;
    // Paths
    s.pathSatScale01 = 0.0f;
    s.pathBriScale01 = 1.0f;
    s.showPaths = true;
    s.pathScaleWithZoom = true;
    s.pathScaleRefZoom = DEFAULT_VIEW_ZOOM;
    // Zones
    s.zoneStrokeAlpha01 = 1.0f;
    s.zoneStrokeSizePx = 2.0f;
    s.zoneStrokeSatScale01 = 0.0f;
    s.zoneStrokeBriScale01 = 0.0f;
    s.zoneStrokeScaleWithZoom = true;
    s.zoneStrokeRefZoom = DEFAULT_VIEW_ZOOM;
    // Structures
    s.showStructures = true;
    s.mergeStructures = false;
    s.structureSatScale01 = 0.0f;
    s.structureAlphaScale01 = 1.0f;
    s.structureShadowAlpha01 = 1.0f;
    s.structureStrokeScaleWithZoom = true;
    s.structureStrokeRefZoom = DEFAULT_VIEW_ZOOM;
    // Labels
    s.showLabelsArbitrary = true;
    s.showLabelsZones = true;
    s.showLabelsPaths = true;
    s.showLabelsStructures = true;
    s.labelOutlineAlpha01 = 1.0f;
    s.labelOutlineSizePx = 1.0f;
    s.labelSizeArbPx = 12.0f;
    s.labelSizeZonePx = 14.0f;
    s.labelSizePathPx = 12.0f;
    s.labelSizeStructPx = 12.0f;
    s.labelScaleWithZoom = true;
    s.labelScaleRefZoom = DEFAULT_VIEW_ZOOM;
    s.labelOutlineScaleWithZoom = true;
    s.labelFontIndex = 0;
    // General
    s.exportPaddingPct = 0.015f;
    s.antialiasing = false;
    s.activePresetIndex = 0;
    list.add(new RenderPreset("Bitmap", s));
  }

  // Much
  {
    RenderSettings s = new RenderSettings();
    // Base
    s.landHue01 = 0.1f;
    s.landSat01 = 0.1f;
    s.landBri01 = 0.8f;
    s.waterHue01 = 0.6f;
    s.waterSat01 = 0.7f;
    s.waterBri01 = 0.2f;
    s.cellBorderAlpha01 = 0.05f;
    s.cellBorderSizePx = 1.0f;
    s.cellBorderScaleWithZoom = true;
    s.cellBorderRefZoom = DEFAULT_VIEW_ZOOM;
    s.backgroundNoiseAlpha01 = 0.0f;
    // Biomes
    s.biomeFillAlpha01 = 0.3f;
    s.biomeSatScale01 = 0.9f;
    s.biomeBriScale01 = 1.0f;
    s.biomeFillType = RenderFillType.RENDER_FILL_PATTERN;
    s.biomeOutlineSizePx = 2.0f;
    s.biomeOutlineAlpha01 = 0.9f;
    s.biomeOutlineScaleWithZoom = true;
    s.biomeOutlineRefZoom = DEFAULT_VIEW_ZOOM;
    s.biomeUnderwaterAlpha01 = 1.0f;
    // Shading
    s.waterDepthAlpha01 = 1.0f;
    s.elevationLightAlpha01 = 0.4f;
    s.elevationLightAzimuthDeg = 250.0f;
    s.elevationLightAltitudeDeg = 10.0f;
    s.elevationLightDitherPx = 0.0f;
    // Contours
    s.waterContourSizePx = 2.0f;
    s.waterRippleCount = 4;
    s.waterRippleDistancePx = 6.0f;
    s.waterContourHue01 = 0.6f;
    s.waterContourSat01 = 1.0f;
    s.waterContourBri01 = 0.3f;
    s.waterContourAlpha01 = 1.0f;
    s.waterCoastAlpha01 = 1.0f;
    s.waterCoastSizePx = 2.0f;
    s.waterCoastScaleWithZoom = true;
    s.waterCoastAboveZones = false;
    s.waterContourScaleWithZoom = true;
    s.waterContourRefZoom = DEFAULT_VIEW_ZOOM;
    s.waterRippleAlphaStart01 = 0.8f;
    s.waterRippleAlphaEnd01 = 0.25f;
    s.waterHatchAngleDeg = 0.0f;
    s.waterHatchLengthPx = 0.0f;
    s.waterHatchSpacingPx = 12.0f;
    s.waterHatchAlpha01 = 0.0f;
    s.elevationLinesCount = 16;
    s.elevationLinesStyle = ElevationLinesStyle.ELEV_LINES_BASIC;
    s.elevationLinesAlpha01 = 0.3f;
    s.elevationLinesSizePx = 1.0f;
    s.elevationLinesScaleWithZoom = false;
    s.elevationLinesRefZoom = DEFAULT_VIEW_ZOOM;
    // Paths
    s.pathSatScale01 = 1.0f;
    s.pathBriScale01 = 1.0f;
    s.showPaths = true;
    s.pathScaleWithZoom = true;
    s.pathScaleRefZoom = DEFAULT_VIEW_ZOOM;
    // Zones
    s.zoneStrokeAlpha01 = 0.5f;
    s.zoneStrokeSizePx = 2.0f;
    s.zoneStrokeSatScale01 = 0.8f;
    s.zoneStrokeBriScale01 = 0.2f;
    s.zoneStrokeScaleWithZoom = true;
    s.zoneStrokeRefZoom = DEFAULT_VIEW_ZOOM;
    // Structures
    s.showStructures = true;
    s.mergeStructures = true;
    s.structureSatScale01 = 1.0f;
    s.structureAlphaScale01 = 1.0f;
    s.structureShadowAlpha01 = 0.4f;
    s.structureStrokeScaleWithZoom = true;
    s.structureStrokeRefZoom = DEFAULT_VIEW_ZOOM;
    // Labels
    s.showLabelsArbitrary = true;
    s.showLabelsZones = true;
    s.showLabelsPaths = true;
    s.showLabelsStructures = true;
    s.labelOutlineAlpha01 = 0.9f;
    s.labelOutlineSizePx = 1.0f;
    s.labelSizeArbPx = 12.0f;
    s.labelSizeZonePx = 14.0f;
    s.labelSizePathPx = 12.0f;
    s.labelSizeStructPx = 12.0f;
    s.labelScaleWithZoom = true;
    s.labelScaleRefZoom = DEFAULT_VIEW_ZOOM;
    s.labelOutlineScaleWithZoom = true;
    s.labelFontIndex = 0;
    // General
    s.exportPaddingPct = 0.02f;
    s.antialiasing = true;
    s.activePresetIndex = 0;
    list.add(new RenderPreset("Much", s));
  }

  // Administrative
  {
    RenderSettings s = new RenderSettings();
    // Base
    s.landHue01 = 0.2f;
    s.landSat01 = 0.0f;
    s.landBri01 = 1.0f;
    s.waterHue01 = 0.6f;
    s.waterSat01 = 0.7f;
    s.waterBri01 = 0.5f;
    s.cellBorderAlpha01 = 0.0f;
    s.cellBorderSizePx = 1.0f;
    s.cellBorderScaleWithZoom = true;
    s.cellBorderRefZoom = DEFAULT_VIEW_ZOOM;
    s.backgroundNoiseAlpha01 = 0.0f;
    // Biomes
    s.biomeFillAlpha01 = 0.3f;
    s.biomeSatScale01 = 0.3f;
    s.biomeBriScale01 = 1.0f;
    s.biomeFillType = RenderFillType.RENDER_FILL_COLOR;
    s.biomeOutlineSizePx = 1.0f;
    s.biomeOutlineAlpha01 = 0.0f;
    s.biomeOutlineScaleWithZoom = true;
    s.biomeOutlineRefZoom = DEFAULT_VIEW_ZOOM;
    s.biomeUnderwaterAlpha01 = 1.0f;
    // Shading
    s.waterDepthAlpha01 = 0.0f;
    s.elevationLightAlpha01 = 0.0f;
    s.elevationLightAzimuthDeg = 0.0f;
    s.elevationLightAltitudeDeg = 10.0f;
    s.elevationLightDitherPx = 0.0f;
    // Contours
    s.waterContourSizePx = 2.0f;
    s.waterRippleCount = 0;
    s.waterRippleDistancePx = 0.0f;
    s.waterContourHue01 = 0.5f;
    s.waterContourSat01 = 0.25f;
    s.waterContourBri01 = 0.0f;
    s.waterContourAlpha01 = 0.5f;
    s.waterCoastAlpha01 = 0.5f;
    s.waterCoastSizePx = 2.0f;
    s.waterCoastScaleWithZoom = true;
    s.waterCoastAboveZones = false;
    s.waterContourScaleWithZoom = true;
    s.waterContourRefZoom = DEFAULT_VIEW_ZOOM;
    s.waterRippleAlphaStart01 = 0.35f;
    s.waterRippleAlphaEnd01 = 0.15f;
    s.waterHatchAngleDeg = 0.0f;
    s.waterHatchLengthPx = 0.0f;
    s.waterHatchSpacingPx = 12.0f;
    s.waterHatchAlpha01 = 0.0f;
    s.elevationLinesCount = 0;
    s.elevationLinesStyle = ElevationLinesStyle.ELEV_LINES_BASIC;
    s.elevationLinesAlpha01 = 0.1f;
    s.elevationLinesSizePx = 1.0f;
    s.elevationLinesScaleWithZoom = true;
    s.elevationLinesRefZoom = DEFAULT_VIEW_ZOOM;
    // Paths
    s.pathSatScale01 = 0.8f;
    s.pathBriScale01 = 1.0f;
    s.showPaths = true;
    s.pathScaleWithZoom = true;
    s.pathScaleRefZoom = DEFAULT_VIEW_ZOOM;
    // Zones
    s.zoneStrokeAlpha01 = 1.0f;
    s.zoneStrokeSizePx = 2.0f;
    s.zoneStrokeSatScale01 = 1.0f;
    s.zoneStrokeBriScale01 = 1.0f;
    s.zoneStrokeScaleWithZoom = true;
    s.zoneStrokeRefZoom = DEFAULT_VIEW_ZOOM;
    // Structures
    s.showStructures = true;
    s.mergeStructures = true;
    s.structureSatScale01 = 1.0f;
    s.structureAlphaScale01 = 1.0f;
    s.structureShadowAlpha01 = 0.2f;
    s.structureStrokeScaleWithZoom = true;
    s.structureStrokeRefZoom = DEFAULT_VIEW_ZOOM;
    // Labels
    s.showLabelsArbitrary = true;
    s.showLabelsZones = true;
    s.showLabelsPaths = true;
    s.showLabelsStructures = true;
    s.labelOutlineAlpha01 = 1.0f;
    s.labelOutlineSizePx = 1.0f;
    s.labelSizeArbPx = 12.0f;
    s.labelSizeZonePx = 14.0f;
    s.labelSizePathPx = 12.0f;
    s.labelSizeStructPx = 12.0f;
    s.labelScaleWithZoom = true;
    s.labelScaleRefZoom = DEFAULT_VIEW_ZOOM;
    s.labelOutlineScaleWithZoom = true;
    s.labelFontIndex = 0;
    // General
    s.exportPaddingPct = 0.015f;
    s.antialiasing = true;
    s.activePresetIndex = 0;
    list.add(new RenderPreset("Administrative", s));
  }

  // Simple
  {
    RenderSettings s = new RenderSettings();
    // Base
    s.landHue01 = 0.1f;
    s.landSat01 = 0.1f;
    s.landBri01 = 1.0f;
    s.waterHue01 = 0.6f;
    s.waterSat01 = 0.7f;
    s.waterBri01 = 0.5f;
    s.cellBorderAlpha01 = 0.0f;
    s.cellBorderSizePx = 1.0f;
    s.cellBorderScaleWithZoom = true;
    s.cellBorderRefZoom = DEFAULT_VIEW_ZOOM;
    s.backgroundNoiseAlpha01 = 0.0f;
    // Biomes
    s.biomeFillAlpha01 = 1.0f;
    s.biomeSatScale01 = 1.0f;
    s.biomeBriScale01 = 1.0f;
    s.biomeFillType = RenderFillType.RENDER_FILL_COLOR;
    s.biomeOutlineSizePx = 1.0f;
    s.biomeOutlineAlpha01 = 0.0f;
    s.biomeOutlineScaleWithZoom = true;
    s.biomeOutlineRefZoom = DEFAULT_VIEW_ZOOM;
    s.biomeUnderwaterAlpha01 = 0.0f;
    // Shading
    s.waterDepthAlpha01 = 0.0f;
    s.elevationLightAlpha01 = 0.0f;
    s.elevationLightAzimuthDeg = 0.0f;
    s.elevationLightAltitudeDeg = 10.0f;
    s.elevationLightDitherPx = 0.0f;
    // Contours
    s.waterContourSizePx = 3.0f;
    s.waterRippleCount = 0;
    s.waterRippleDistancePx = 0.0f;
    s.waterContourHue01 = 0.5f;
    s.waterContourSat01 = 0.25f;
    s.waterContourBri01 = 0.0f;
    s.waterContourAlpha01 = 1.0f;
    s.waterCoastAlpha01 = 1.0f;
    s.waterCoastSizePx = 2.0f;
    s.waterCoastScaleWithZoom = true;
    s.waterCoastAboveZones = false;
    s.waterContourScaleWithZoom = true;
    s.waterContourRefZoom = DEFAULT_VIEW_ZOOM;
    s.waterRippleAlphaStart01 = 0.8f;
    s.waterRippleAlphaEnd01 = 0.25f;
    s.waterHatchAngleDeg = 0.0f;
    s.waterHatchLengthPx = 0.0f;
    s.waterHatchSpacingPx = 12.0f;
    s.waterHatchAlpha01 = 0.0f;
    s.elevationLinesCount = 0;
    s.elevationLinesStyle = ElevationLinesStyle.ELEV_LINES_BASIC;
    s.elevationLinesAlpha01 = 1.0f;
    s.elevationLinesSizePx = 1.0f;
    s.elevationLinesScaleWithZoom = true;
    s.elevationLinesRefZoom = DEFAULT_VIEW_ZOOM;
    // Paths
    s.pathSatScale01 = 0.8f;
    s.pathBriScale01 = 1.0f;
    s.showPaths = false;
    s.pathScaleWithZoom = true;
    s.pathScaleRefZoom = DEFAULT_VIEW_ZOOM;
    // Zones
    s.zoneStrokeAlpha01 = 1.0f;
    s.zoneStrokeSizePx = 2.0f;
    s.zoneStrokeSatScale01 = 1.0f;
    s.zoneStrokeBriScale01 = 1.0f;
    s.zoneStrokeScaleWithZoom = true;
    s.zoneStrokeRefZoom = DEFAULT_VIEW_ZOOM;
    // Structures
    s.showStructures = false;
    s.mergeStructures = true;
    s.structureSatScale01 = 1.0f;
    s.structureAlphaScale01 = 1.0f;
    s.structureShadowAlpha01 = 0.2f;
    s.structureStrokeScaleWithZoom = true;
    s.structureStrokeRefZoom = DEFAULT_VIEW_ZOOM;
    // Labels
    s.showLabelsArbitrary = false;
    s.showLabelsZones = false;
    s.showLabelsPaths = false;
    s.showLabelsStructures = false;
    s.labelOutlineAlpha01 = 1.0f;
    s.labelOutlineSizePx = 1.0f;
    s.labelSizeArbPx = 12.0f;
    s.labelSizeZonePx = 14.0f;
    s.labelSizePathPx = 12.0f;
    s.labelSizeStructPx = 12.0f;
    s.labelScaleWithZoom = true;
    s.labelScaleRefZoom = DEFAULT_VIEW_ZOOM;
    s.labelOutlineScaleWithZoom = true;
    s.labelFontIndex = 0;
    // General
    s.exportPaddingPct = 0.015f;
    s.antialiasing = true;
    s.activePresetIndex = 0;
    list.add(new RenderPreset("Simple", s));
  }

  // Rocky
  {
    RenderSettings s = new RenderSettings();
    // Base
    s.landHue01 = 0.7f;
    s.landSat01 = 1.0f;
    s.landBri01 = 0.4f;
    s.waterHue01 = 0.1f;
    s.waterSat01 = 1.0f;
    s.waterBri01 = 1.0f;
    s.cellBorderAlpha01 = 0.8f;
    s.cellBorderSizePx = 1.0f;
    s.cellBorderScaleWithZoom = false;
    s.cellBorderRefZoom = DEFAULT_VIEW_ZOOM;
    s.backgroundNoiseAlpha01 = 0.0f;
    // Biomes
    s.biomeFillAlpha01 = 0.7f;
    s.biomeSatScale01 = 1.0f;
    s.biomeBriScale01 = 1.0f;
    s.biomeFillType = RenderFillType.RENDER_FILL_PATTERN;
    s.biomeOutlineSizePx = 4.0f;
    s.biomeOutlineAlpha01 = 0.3f;
    s.biomeOutlineScaleWithZoom = true;
    s.biomeOutlineRefZoom = DEFAULT_VIEW_ZOOM;
    s.biomeUnderwaterAlpha01 = 0.0f;
    // Shading
    s.waterDepthAlpha01 = 0.6f;
    s.elevationLightAlpha01 = 1.0f;
    s.elevationLightAzimuthDeg = 300.0f;
    s.elevationLightAltitudeDeg = 70.0f;
    s.elevationLightDitherPx = 0.0f;
    // Contours
    s.waterContourSizePx = 4.0f;
    s.waterRippleCount = 5;
    s.waterRippleDistancePx = 20.0f;
    s.waterContourHue01 = 0.1f;
    s.waterContourSat01 = 1.0f;
    s.waterContourBri01 = 1.0f;
    s.waterContourAlpha01 = 1.0f;
    s.waterCoastAlpha01 = 1.0f;
    s.waterCoastSizePx = 2.0f;
    s.waterCoastScaleWithZoom = true;
    s.waterCoastAboveZones = false;
    s.waterContourScaleWithZoom = true;
    s.waterContourRefZoom = DEFAULT_VIEW_ZOOM;
    s.waterRippleAlphaStart01 = 0.8f;
    s.waterRippleAlphaEnd01 = 0.25f;
    s.waterHatchAngleDeg = 0.0f;
    s.waterHatchLengthPx = 0.0f;
    s.waterHatchSpacingPx = 12.0f;
    s.waterHatchAlpha01 = 0.0f;
    s.elevationLinesCount = 24;
    s.elevationLinesStyle = ElevationLinesStyle.ELEV_LINES_BASIC;
    s.elevationLinesAlpha01 = 1.0f;
    s.elevationLinesSizePx = 1.0f;
    s.elevationLinesScaleWithZoom = true;
    s.elevationLinesRefZoom = DEFAULT_VIEW_ZOOM;
    // Paths
    s.pathSatScale01 = 0.3f;
    s.pathBriScale01 = 1.0f;
    s.showPaths = false;
    s.pathScaleWithZoom = false;
    s.pathScaleRefZoom = DEFAULT_VIEW_ZOOM;
    // Zones
    s.zoneStrokeAlpha01 = 1.0f;
    s.zoneStrokeSizePx = 2.0f;
    s.zoneStrokeSatScale01 = 0.3f;
    s.zoneStrokeBriScale01 = 0.5f;
    s.zoneStrokeScaleWithZoom = false;
    s.zoneStrokeRefZoom = DEFAULT_VIEW_ZOOM;
    // Structures
    s.showStructures = false;
    s.mergeStructures = true;
    s.structureSatScale01 = 1.0f;
    s.structureAlphaScale01 = 1.0f;
    s.structureShadowAlpha01 = 0.25f;
    s.structureStrokeScaleWithZoom = false;
    s.structureStrokeRefZoom = DEFAULT_VIEW_ZOOM;
    // Labels
    s.showLabelsArbitrary = false;
    s.showLabelsZones = false;
    s.showLabelsPaths = false;
    s.showLabelsStructures = false;
    s.labelOutlineAlpha01 = 0.3f;
    s.labelOutlineSizePx = 1.0f;
    s.labelSizeArbPx = 12.0f;
    s.labelSizeZonePx = 14.0f;
    s.labelSizePathPx = 12.0f;
    s.labelSizeStructPx = 12.0f;
    s.labelScaleWithZoom = true;
    s.labelScaleRefZoom = DEFAULT_VIEW_ZOOM;
    s.labelOutlineScaleWithZoom = true;
    s.labelFontIndex = 0;
    // General
    s.exportPaddingPct = 0.0f;
    s.antialiasing = true;
    s.activePresetIndex = 0;
    list.add(new RenderPreset("Rocky", s));
  }

  RenderPreset[] arr = new RenderPreset[list.size()];
  list.toArray(arr);
  return arr;
}
// Rendering configuration and presets

enum RenderFillType {
  RENDER_FILL_COLOR,
  RENDER_FILL_PATTERN,
  RENDER_FILL_PATTERN_BG
}

enum ElevationLinesStyle {
  ELEV_LINES_BASIC
}

class RenderPreset {
  String name;
  RenderSettings values;

  RenderPreset(String name, RenderSettings values) {
    this.name = name;
    this.values = values;
  }
}

class RenderSettings {
  // Base colors (HSB 0..1) and overlays
  float landHue01 = 0.0f;
  float landSat01 = 0.0f;
  float landBri01 = 0.85f;
  float waterHue01 = 0.58f;
  float waterSat01 = 0.28f;
  float waterBri01 = 0.35f;
  float cellBorderAlpha01 = 0.0f;
  float cellBorderSizePx = 1.0f;
  boolean cellBorderScaleWithZoom = false;
  float cellBorderRefZoom = DEFAULT_VIEW_ZOOM;
  float backgroundNoiseAlpha01 = 0.0f;

  // Biomes
  float biomeFillAlpha01 = 0.5f;
  float biomeSatScale01 = 1.0f;
  float biomeBriScale01 = 1.0f;
  RenderFillType biomeFillType = RenderFillType.RENDER_FILL_COLOR;
  String biomePatternName = "";
  float biomeOutlineSizePx = 0.0f;
  float biomeOutlineAlpha01 = 1.0f;
  boolean biomeOutlineScaleWithZoom = false;
  float biomeOutlineRefZoom = DEFAULT_VIEW_ZOOM;
  float biomeUnderwaterAlpha01 = 0.0f;

  // Shading
  float waterDepthAlpha01 = 0.5f;
  float elevationLightAlpha01 = 0.5f;
  float elevationLightAzimuthDeg = 220.0f;
  float elevationLightAltitudeDeg = 45.0f;
  float elevationLightDitherPx = 0.0f;
  boolean elevationLightDitherScaleWithZoom = false;
  float elevationLightDitherRefZoom = DEFAULT_VIEW_ZOOM;

  // Contours
  float waterContourSizePx = 2.0f;
  int waterRippleCount = 0;
  float waterRippleDistancePx = 5.0f;
  float waterContourHue01 = 0.0f;
  float waterContourSat01 = 0.0f;
  float waterContourBri01 = 0.0f;
  float waterContourAlpha01 = 1.0f; // legacy: keep for backward compat
  float waterCoastAlpha01 = 1.0f;
  float waterCoastSizePx = 2.0f;
  boolean waterCoastScaleWithZoom = false;
  boolean waterCoastAboveZones = false;
  boolean waterContourScaleWithZoom = false;
  float waterContourRefZoom = DEFAULT_VIEW_ZOOM;
  float waterRippleAlphaStart01 = 1.0f;
  float waterRippleAlphaEnd01 = 0.3f;
  float waterHatchAngleDeg = 0.0f;     // 0 = horizontal lines
  float waterHatchLengthPx = 0.0f;     // world length = px/zoom
  float waterHatchSpacingPx = 12.0f;   // spacing in screen px
  float waterHatchAlpha01 = 0.0f;
  int elevationLinesCount = 0;
  ElevationLinesStyle elevationLinesStyle = ElevationLinesStyle.ELEV_LINES_BASIC;
  float elevationLinesAlpha01 = 0.3f;
  float elevationLinesSizePx = 1.0f;
  boolean elevationLinesScaleWithZoom = false;
  float elevationLinesRefZoom = DEFAULT_VIEW_ZOOM;

  // Paths
  float pathSatScale01 = 1.0f;
  float pathBriScale01 = 1.0f;
  boolean showPaths = true;
  boolean pathScaleWithZoom = false;
  float pathScaleRefZoom = DEFAULT_VIEW_ZOOM;

  // Zones (strokes only)
  float zoneStrokeAlpha01 = 0.5f;
  float zoneStrokeSizePx = 2.0f;
  float zoneStrokeSatScale01 = 0.5f;
  float zoneStrokeBriScale01 = 1.0f;
  boolean zoneStrokeScaleWithZoom = false;
  float zoneStrokeRefZoom = DEFAULT_VIEW_ZOOM;

  // Structures
  boolean showStructures = true;
  boolean mergeStructures = false; // placeholder
  float structureSatScale01 = 1.0f;
  float structureAlphaScale01 = 1.0f;
  float structureShadowAlpha01 = 0.0f;
  boolean structureStrokeScaleWithZoom = false;
  float structureStrokeRefZoom = DEFAULT_VIEW_ZOOM;

  // Labels
  boolean showLabelsArbitrary = true;
  boolean showLabelsZones = true;
  boolean showLabelsPaths = true;
  boolean showLabelsStructures = true;
  float labelOutlineAlpha01 = 0.0f;
  float labelOutlineSizePx = 1.0f;
  float labelSizeArbPx = 12.0f;
  float labelSizeZonePx = 14.0f;
  float labelSizePathPx = 12.0f;
  float labelSizeStructPx = 12.0f;
  boolean labelScaleWithZoom = false;
  float labelScaleRefZoom = 1.0f;
  boolean labelOutlineScaleWithZoom = false;
  int labelFontIndex = 0;

  // General
  float exportPaddingPct = 0.015f;
  boolean antialiasing = true;
  int activePresetIndex = 0;

  public RenderSettings copy() {
    RenderSettings c = new RenderSettings();
    // Base
    c.landHue01 = landHue01;
    c.landSat01 = landSat01;
    c.landBri01 = landBri01;
    c.waterHue01 = waterHue01;
    c.waterSat01 = waterSat01;
    c.waterBri01 = waterBri01;
    c.cellBorderAlpha01 = cellBorderAlpha01;
    c.cellBorderSizePx = cellBorderSizePx;
    c.cellBorderScaleWithZoom = cellBorderScaleWithZoom;
    c.cellBorderRefZoom = cellBorderRefZoom;
    c.backgroundNoiseAlpha01 = backgroundNoiseAlpha01;
    // Biomes
    c.biomeFillAlpha01 = biomeFillAlpha01;
    c.biomeSatScale01 = biomeSatScale01;
    c.biomeBriScale01 = biomeBriScale01;
    c.biomeFillType = biomeFillType;
    c.biomePatternName = biomePatternName;
    c.biomeOutlineSizePx = biomeOutlineSizePx;
    c.biomeOutlineAlpha01 = biomeOutlineAlpha01;
    c.biomeOutlineScaleWithZoom = biomeOutlineScaleWithZoom;
    c.biomeOutlineRefZoom = biomeOutlineRefZoom;
    c.biomeUnderwaterAlpha01 = biomeUnderwaterAlpha01;
    // Shading
    c.waterDepthAlpha01 = waterDepthAlpha01;
    c.elevationLightAlpha01 = elevationLightAlpha01;
    c.elevationLightAzimuthDeg = elevationLightAzimuthDeg;
    c.elevationLightAltitudeDeg = elevationLightAltitudeDeg;
    c.elevationLightDitherPx = elevationLightDitherPx;
    c.elevationLightDitherScaleWithZoom = elevationLightDitherScaleWithZoom;
    c.elevationLightDitherRefZoom = elevationLightDitherRefZoom;
    // Contours
    c.waterContourSizePx = waterContourSizePx;
    c.waterRippleCount = waterRippleCount;
    c.waterRippleDistancePx = waterRippleDistancePx;
    c.waterContourHue01 = waterContourHue01;
    c.waterContourSat01 = waterContourSat01;
    c.waterContourBri01 = waterContourBri01;
    c.waterContourAlpha01 = waterContourAlpha01;
    c.waterCoastAlpha01 = waterCoastAlpha01;
    c.waterCoastSizePx = waterCoastSizePx;
    c.waterCoastScaleWithZoom = waterCoastScaleWithZoom;
    c.waterCoastAboveZones = waterCoastAboveZones;
    c.waterContourScaleWithZoom = waterContourScaleWithZoom;
    c.waterContourRefZoom = waterContourRefZoom;
    c.waterRippleAlphaStart01 = waterRippleAlphaStart01;
    c.waterRippleAlphaEnd01 = waterRippleAlphaEnd01;
    c.waterHatchAngleDeg = waterHatchAngleDeg;
    c.waterHatchLengthPx = waterHatchLengthPx;
    c.waterHatchSpacingPx = waterHatchSpacingPx;
    c.waterHatchAlpha01 = waterHatchAlpha01;
    c.elevationLinesCount = elevationLinesCount;
    c.elevationLinesStyle = elevationLinesStyle;
    c.elevationLinesAlpha01 = elevationLinesAlpha01;
    c.elevationLinesSizePx = elevationLinesSizePx;
    c.elevationLinesScaleWithZoom = elevationLinesScaleWithZoom;
    c.elevationLinesRefZoom = elevationLinesRefZoom;
    // Paths
    c.pathSatScale01 = pathSatScale01;
    c.pathBriScale01 = pathBriScale01;
    c.showPaths = showPaths;
    c.pathScaleWithZoom = pathScaleWithZoom;
    c.pathScaleRefZoom = pathScaleRefZoom;
    // Zones
    c.zoneStrokeAlpha01 = zoneStrokeAlpha01;
    c.zoneStrokeSizePx = zoneStrokeSizePx;
    c.zoneStrokeSatScale01 = zoneStrokeSatScale01;
    c.zoneStrokeBriScale01 = zoneStrokeBriScale01;
    c.zoneStrokeScaleWithZoom = zoneStrokeScaleWithZoom;
    c.zoneStrokeRefZoom = zoneStrokeRefZoom;
    // Structures
    c.showStructures = showStructures;
    c.mergeStructures = mergeStructures;
    c.structureSatScale01 = structureSatScale01;
    c.structureAlphaScale01 = structureAlphaScale01;
    c.structureShadowAlpha01 = structureShadowAlpha01;
    c.structureStrokeScaleWithZoom = structureStrokeScaleWithZoom;
    c.structureStrokeRefZoom = structureStrokeRefZoom;
    // Labels
    c.showLabelsArbitrary = showLabelsArbitrary;
    c.showLabelsZones = showLabelsZones;
    c.showLabelsPaths = showLabelsPaths;
    c.showLabelsStructures = showLabelsStructures;
    c.labelOutlineAlpha01 = labelOutlineAlpha01;
    c.labelOutlineSizePx = labelOutlineSizePx;
    c.labelSizeArbPx = labelSizeArbPx;
    c.labelSizeZonePx = labelSizeZonePx;
    c.labelSizePathPx = labelSizePathPx;
    c.labelSizeStructPx = labelSizeStructPx;
    c.labelScaleWithZoom = labelScaleWithZoom;
    c.labelScaleRefZoom = labelScaleRefZoom;
    c.labelOutlineScaleWithZoom = labelOutlineScaleWithZoom;
    c.labelFontIndex = labelFontIndex;
    // General
    c.exportPaddingPct = exportPaddingPct;
    c.antialiasing = antialiasing;
    c.activePresetIndex = activePresetIndex;
    return c;
  }

  public void applyFrom(RenderSettings other) {
    if (other == null) return;
    RenderSettings o = other;
    // Base
    landHue01 = o.landHue01;
    landSat01 = o.landSat01;
    landBri01 = o.landBri01;
    waterHue01 = o.waterHue01;
    waterSat01 = o.waterSat01;
    waterBri01 = o.waterBri01;
    cellBorderAlpha01 = o.cellBorderAlpha01;
    cellBorderSizePx = o.cellBorderSizePx;
    cellBorderScaleWithZoom = o.cellBorderScaleWithZoom;
    cellBorderRefZoom = o.cellBorderRefZoom;
    backgroundNoiseAlpha01 = o.backgroundNoiseAlpha01;
    // Biomes
    biomeFillAlpha01 = o.biomeFillAlpha01;
    biomeSatScale01 = o.biomeSatScale01;
    biomeBriScale01 = o.biomeBriScale01;
    biomeFillType = o.biomeFillType;
    biomePatternName = o.biomePatternName;
    biomeOutlineSizePx = o.biomeOutlineSizePx;
    biomeOutlineAlpha01 = o.biomeOutlineAlpha01;
    biomeOutlineScaleWithZoom = o.biomeOutlineScaleWithZoom;
    biomeOutlineRefZoom = o.biomeOutlineRefZoom;
    biomeUnderwaterAlpha01 = o.biomeUnderwaterAlpha01;
    // Shading
    waterDepthAlpha01 = o.waterDepthAlpha01;
    elevationLightAlpha01 = o.elevationLightAlpha01;
    elevationLightAzimuthDeg = o.elevationLightAzimuthDeg;
    elevationLightAltitudeDeg = o.elevationLightAltitudeDeg;
    elevationLightDitherPx = o.elevationLightDitherPx;
    elevationLightDitherScaleWithZoom = o.elevationLightDitherScaleWithZoom;
    elevationLightDitherRefZoom = o.elevationLightDitherRefZoom;
    // Contours
    waterContourSizePx = o.waterContourSizePx;
    waterRippleCount = o.waterRippleCount;
    waterRippleDistancePx = o.waterRippleDistancePx;
    waterContourHue01 = o.waterContourHue01;
    waterContourSat01 = o.waterContourSat01;
    waterContourBri01 = o.waterContourBri01;
    waterContourAlpha01 = o.waterContourAlpha01;
    waterCoastAlpha01 = o.waterCoastAlpha01;
    waterCoastSizePx = o.waterCoastSizePx;
    waterCoastScaleWithZoom = o.waterCoastScaleWithZoom;
    waterCoastAboveZones = o.waterCoastAboveZones;
    waterContourScaleWithZoom = o.waterContourScaleWithZoom;
    waterContourRefZoom = o.waterContourRefZoom;
    waterRippleAlphaStart01 = o.waterRippleAlphaStart01;
    waterRippleAlphaEnd01 = o.waterRippleAlphaEnd01;
    waterHatchAngleDeg = o.waterHatchAngleDeg;
    waterHatchLengthPx = o.waterHatchLengthPx;
    waterHatchSpacingPx = o.waterHatchSpacingPx;
    waterHatchAlpha01 = o.waterHatchAlpha01;
    elevationLinesCount = o.elevationLinesCount;
    elevationLinesStyle = o.elevationLinesStyle;
    elevationLinesAlpha01 = o.elevationLinesAlpha01;
    elevationLinesSizePx = o.elevationLinesSizePx;
    elevationLinesScaleWithZoom = o.elevationLinesScaleWithZoom;
    elevationLinesRefZoom = o.elevationLinesRefZoom;
    // Paths
    pathSatScale01 = o.pathSatScale01;
    pathBriScale01 = o.pathBriScale01;
    showPaths = o.showPaths;
    pathScaleWithZoom = o.pathScaleWithZoom;
    pathScaleRefZoom = o.pathScaleRefZoom;
    // Zones
    zoneStrokeAlpha01 = o.zoneStrokeAlpha01;
    zoneStrokeSizePx = o.zoneStrokeSizePx;
    zoneStrokeSatScale01 = o.zoneStrokeSatScale01;
    zoneStrokeBriScale01 = o.zoneStrokeBriScale01;
    zoneStrokeScaleWithZoom = o.zoneStrokeScaleWithZoom;
    zoneStrokeRefZoom = o.zoneStrokeRefZoom;
    // Structures
    showStructures = o.showStructures;
    mergeStructures = o.mergeStructures;
    structureSatScale01 = o.structureSatScale01;
    structureAlphaScale01 = o.structureAlphaScale01;
    structureShadowAlpha01 = o.structureShadowAlpha01;
    structureStrokeScaleWithZoom = o.structureStrokeScaleWithZoom;
    structureStrokeRefZoom = o.structureStrokeRefZoom;
    // Labels
    showLabelsArbitrary = o.showLabelsArbitrary;
    showLabelsZones = o.showLabelsZones;
    showLabelsPaths = o.showLabelsPaths;
    showLabelsStructures = o.showLabelsStructures;
    labelOutlineAlpha01 = o.labelOutlineAlpha01;
    labelOutlineSizePx = o.labelOutlineSizePx;
    labelSizeArbPx = o.labelSizeArbPx;
    labelSizeZonePx = o.labelSizeZonePx;
    labelSizePathPx = o.labelSizePathPx;
    labelSizeStructPx = o.labelSizeStructPx;
    labelScaleWithZoom = o.labelScaleWithZoom;
    labelScaleRefZoom = o.labelScaleRefZoom;
    labelOutlineScaleWithZoom = o.labelOutlineScaleWithZoom;
    labelFontIndex = o.labelFontIndex;
    if (LABEL_FONT_OPTIONS != null && LABEL_FONT_OPTIONS.length > 0) {
      labelFontIndex = constrain(labelFontIndex, 0, LABEL_FONT_OPTIONS.length - 1);
    } else {
      labelFontIndex = 0;
    }
    // General
    exportPaddingPct = o.exportPaddingPct;
    antialiasing = o.antialiasing;
    activePresetIndex = o.activePresetIndex;
  }
}
class Site {
  float x;
  float y;
  boolean selected;

  Site(float x, float y) {
    this.x = x;
    this.y = y;
    this.selected = false;
  }

  public void draw(PApplet app) {
    app.pushStyle();

    // Selected site: larger
    if (selected) {
      float rPixels = 6.0f;
      float rWorld = rPixels / viewport.zoom;

      app.stroke(0);
      app.strokeWeight(1.0f / viewport.zoom);
      app.fill(240, 80, 80);
      app.ellipse(x, y, rWorld, rWorld);
    } else {
      // Non-selected: tiny, ~1 px dot
      float rPixels = 1.0f;
      float rWorld = max(1.0f / viewport.zoom, rPixels / viewport.zoom);

      app.noStroke();
      app.fill(40);
      app.ellipse(x, y, rWorld, rWorld);
    }

    app.popStyle();
  }
}
enum Tool {
  EDIT_SITES,
  EDIT_ELEVATION,
  EDIT_BIOMES,
  EDIT_ZONES,
  EDIT_PATHS,
  EDIT_STRUCTURES,
  EDIT_LABELS,
  EDIT_RENDER,
  EDIT_EXPORT
}

enum PlacementMode {
  GRID,
  POISSON,
  HEX
}

enum ZonePaintMode {
  ZONE_PAINT,
  ZONE_FILL
}

enum PathRouteMode {
  ENDS,
  PATHFIND
}

enum StructureSnapMode {
  NONE,
  NEXT_TO_PATH,
  ON_PATH
}

enum StructureShape {
  RECTANGLE,
  CIRCLE,
  TRIANGLE,
  HEXAGON
}

enum StructureSnapTargetType {
  NONE,
  PATH,
  FRONTIER,
  STRUCTURE
}

enum LabelTarget {
  FREE,
  BIOME,
  ZONE,
  PATH,
  STRUCTURE
}


HashMap<String, String> TOOLTIP_TEXTS = new HashMap<String, String>();

public void initTooltipTexts() {
  TOOLTIP_TEXTS.clear();

  // top modes bar
  TOOLTIP_TEXTS.put("tool_cells", "Work on cells placement.");
  TOOLTIP_TEXTS.put("tool_elevation", "Work on topography.");
  TOOLTIP_TEXTS.put("tool_biomes", "Work on natural regions.");
  TOOLTIP_TEXTS.put("tool_zones", "Work on arbitrary administrative regions.");
  TOOLTIP_TEXTS.put("tool_paths", "Work on routes and rivers.");
  TOOLTIP_TEXTS.put("tool_structures", "Work on constructed elements.");
  TOOLTIP_TEXTS.put("tool_labels", "Work on additional texts.");
  TOOLTIP_TEXTS.put("tool_render", "Work on colors, style, display rules.");
  TOOLTIP_TEXTS.put("tool_export", "Export as a file.");

  // cells mode
  TOOLTIP_TEXTS.put("site_density", "Number of cells to place to seed the world space.");
  TOOLTIP_TEXTS.put("site_fuzz", "Add random jitter to the placement.");
  TOOLTIP_TEXTS.put("site_mode", "Choose the placement algorithm:\n- grid: simple squares\n- poisson-disc: evenly spaced but organic\n- hexagonal: honeycomb layout.");
  TOOLTIP_TEXTS.put("sites_generate", "Rebuild all site seeds using the chosen parameters.");
  TOOLTIP_TEXTS.put("sites_keep", "Keep properties preserves properties such as biome assignement while regenerating cells.");
  TOOLTIP_TEXTS.put("sites_reset_all", "Clear all data: cells, zones, biomes, paths, structures, labels.");

  // elevation mode
  TOOLTIP_TEXTS.put("elevation_water_level", "Sets sea level.");
  TOOLTIP_TEXTS.put("elevation_brush_radius", "Brush radius.");
  TOOLTIP_TEXTS.put("elevation_brush_strength", "Brush strength.");
  TOOLTIP_TEXTS.put("elevation_raise", "Brush adds altitude. \nWill normalize emerged lands if maximum is exeeded.");
  TOOLTIP_TEXTS.put("elevation_lower", "Brush lowers altitude.  \nWill normalize submerged lands if minimum is exeeded.");
  TOOLTIP_TEXTS.put("elevation_noise", "Change frequency of Perlin noise when using Generate or Vary. \nHigh values = more details.");
  TOOLTIP_TEXTS.put("elevation_generate_perlin", "Generate terrain from Perlin noise.");
  TOOLTIP_TEXTS.put("elevation_vary", "Apply subtle random offsets to the current elevation.");
  TOOLTIP_TEXTS.put("elevation_plateau", "Create random flatter areas on the current elevation set.");

  // biomes mode
  TOOLTIP_TEXTS.put("biome_gen_mode", "Choose generation modes: \n- Propagation: expand seeds from every biome using a set of rules \n- Reset: fills entire map with selected biome \n- Fill gaps: replaces regions set to None by extending nearby regions \n- Replace gaps: replaces None reginos by new biomes \n- Fill under: sets cells under value threshold to selected biome \n- Fill above: sets cells above value threshold to selected biome \n- Extend: increases selected biome sizes \n- Shrink: decreases selected biome sizes \n- Spots: adds a spot of selected biome somewhere \n- Vary: move some cells around \n- Beaches : set selected biome region somewhere near coastlines \n- Full : arbitrary multiphase generation process");
  TOOLTIP_TEXTS.put("biome_gen_apply", "Execute the selected generation method using the chosen value.");
  TOOLTIP_TEXTS.put("biome_value_water", "Sync the value slider with the current sea level.");
  TOOLTIP_TEXTS.put("biome_paint", "Paint selected biome while dragging with the brush.");
  TOOLTIP_TEXTS.put("biome_fill", "Fill the clicked region with the selected biome type.");
  TOOLTIP_TEXTS.put("biome_add", "Add a new biome type.");
  TOOLTIP_TEXTS.put("biome_remove", "Remove the selected biome type.");
  TOOLTIP_TEXTS.put("biome_name", "Edit biome name.");
  TOOLTIP_TEXTS.put("biome_hue", "Adjust hue for selected biome type.");
  TOOLTIP_TEXTS.put("biome_brush", "Brush radius.");
  TOOLTIP_TEXTS.put("biome_palette", "Select this biome type.");

  // zones mode
  TOOLTIP_TEXTS.put("zones_reset", "Remove all zones.");
  TOOLTIP_TEXTS.put("zones_regenerate", "Generated a new arrangement of zones.");
  TOOLTIP_TEXTS.put("zones_brush", "Brush radius.");
  TOOLTIP_TEXTS.put("zones_exclude_water", "Exclude water from the selected zone. \nExclude from all zones if no zone selected.");
  TOOLTIP_TEXTS.put("zones_exclusive", "Prevent any zone to overlap selected one. \nKeep each cell assigned to a single zone if no zone selected.");
  TOOLTIP_TEXTS.put("zones_four_color", "Attempt to recolor the graph so touching zones use four distinct colors. \nMight not succeed in overlapping scenarios.");
  TOOLTIP_TEXTS.put("zones_list_new", "Create a new zone entry.");
  TOOLTIP_TEXTS.put("zones_list_deselect", "Deselect any active zone.");

  // paths mode
  TOOLTIP_TEXTS.put("paths_route_mode", "Route mode: \n- Ends : straight lines \n- Pathfind : terrain-aware routes");
  TOOLTIP_TEXTS.put("paths_flattest", "Set how much to prefer flat routes over slopes when pathfinding.");
  TOOLTIP_TEXTS.put("paths_avoid_water", "Avoid going through seas when pathfinding.");
  TOOLTIP_TEXTS.put("paths_eraser", "Remove segments by dragging the brush.");
  TOOLTIP_TEXTS.put("paths_list_new", "Create a new path using selected path type.");
  TOOLTIP_TEXTS.put("paths_list_deselect", "Deselect any path.");
  TOOLTIP_TEXTS.put("render_paths_bri", "Scale path brightness for rendering/export.");
  TOOLTIP_TEXTS.put("render_paths_sat", "Scale path saturation for rendering/export.");
  TOOLTIP_TEXTS.put("render_paths_show", "Toggle rendering/export of all paths.");
  TOOLTIP_TEXTS.put("render_light_dither", "Add slight dithering to elevation light to break banding.");
  TOOLTIP_TEXTS.put("render_land_h", "Adjust land hue (HSB).");
  TOOLTIP_TEXTS.put("render_land_s", "Adjust land saturation (HSB).");
  TOOLTIP_TEXTS.put("render_land_b", "Adjust land brightness (HSB).");
  TOOLTIP_TEXTS.put("render_water_h", "Adjust water hue (HSB).");
  TOOLTIP_TEXTS.put("render_water_s", "Adjust water saturation (HSB).");
  TOOLTIP_TEXTS.put("render_water_b", "Adjust water brightness (HSB).");
  TOOLTIP_TEXTS.put("render_cell_borders", "Alpha for cell borders in rendering/export.");
  TOOLTIP_TEXTS.put("render_noise_alpha", "Alpha of background noise texture.");
  TOOLTIP_TEXTS.put("render_biome_fill_alpha", "Opacity of biome fills on land.");
  TOOLTIP_TEXTS.put("render_biome_underwater_alpha", "Opacity of underwater biome fills.");
  TOOLTIP_TEXTS.put("render_biome_sat", "Scale biome saturation.");
  TOOLTIP_TEXTS.put("render_biome_bri", "Scale biome brightness.");
  TOOLTIP_TEXTS.put("render_biome_fill_type", "Choose biome fill: flat color, pattern, or pattern over color.");
  TOOLTIP_TEXTS.put("render_biome_outline_size", "Stroke width for biome outlines.");
  TOOLTIP_TEXTS.put("render_biome_outline_alpha", "Alpha for biome outlines.");
  TOOLTIP_TEXTS.put("render_water_depth_alpha", "Alpha for water depth shading.");
  TOOLTIP_TEXTS.put("render_light_alpha", "Alpha for elevation light overlay.");
  TOOLTIP_TEXTS.put("render_light_azimuth", "Azimuth (0-360 deg) of elevation light.");
  TOOLTIP_TEXTS.put("render_light_altitude", "Altitude (5-80 deg) of elevation light.");
  TOOLTIP_TEXTS.put("render_water_contour_size", "Stroke width for coastline outline.");
  TOOLTIP_TEXTS.put("render_water_ripple_count", "Number of water ripples.");
  TOOLTIP_TEXTS.put("render_water_ripple_dist", "Spacing between water ripples (px).");
  TOOLTIP_TEXTS.put("render_water_contour_h", "Water contour hue.");
  TOOLTIP_TEXTS.put("render_water_contour_s", "Water contour saturation.");
  TOOLTIP_TEXTS.put("render_water_contour_b", "Water contour brightness.");
  TOOLTIP_TEXTS.put("render_water_coast_alpha", "Alpha for immediate coastline stroke.");
  TOOLTIP_TEXTS.put("render_water_hatch_angle", "Angle for water hatching lines.");
  TOOLTIP_TEXTS.put("render_water_hatch_length", "Length of water hatching lines.");
  TOOLTIP_TEXTS.put("render_water_hatch_spacing", "Spacing of water hatching lines.");
  TOOLTIP_TEXTS.put("render_water_hatch_alpha", "Alpha of water hatching lines.");
  TOOLTIP_TEXTS.put("render_water_ripple_alpha_start", "Alpha near shore ripple.");
  TOOLTIP_TEXTS.put("render_water_ripple_alpha_end", "Alpha for farthest ripple.");
  TOOLTIP_TEXTS.put("render_elev_lines_count", "Number of elevation contour lines.");
  TOOLTIP_TEXTS.put("render_elev_lines_alpha", "Alpha of elevation contour lines.");
  TOOLTIP_TEXTS.put("render_zone_alpha", "Alpha of zone outlines.");
  TOOLTIP_TEXTS.put("render_zone_size", "Stroke width of zone outlines.");
  TOOLTIP_TEXTS.put("render_zone_sat", "Zone outline saturation scale.");
  TOOLTIP_TEXTS.put("render_zone_bri", "Zone outline brightness scale.");
  TOOLTIP_TEXTS.put("render_struct_show", "Toggle rendering/export of structures.");
  TOOLTIP_TEXTS.put("render_struct_merge", "Merge structures (if supported).");
  TOOLTIP_TEXTS.put("render_struct_shadow", "Alpha of structure shadows.");
  TOOLTIP_TEXTS.put("render_labels_arbitrary", "Toggle arbitrary labels in rendering/export.");
  TOOLTIP_TEXTS.put("render_labels_zones", "Toggle zone labels in rendering/export.");
  TOOLTIP_TEXTS.put("render_labels_paths", "Toggle path labels in rendering/export.");
  TOOLTIP_TEXTS.put("render_labels_structures", "Toggle structure labels in rendering/export.");
  TOOLTIP_TEXTS.put("render_labels_size_arbitrary", "Pixel size for arbitrary labels in rendering/export.");
  TOOLTIP_TEXTS.put("render_labels_size_zone", "Pixel size for zone labels in rendering/export.");
  TOOLTIP_TEXTS.put("render_labels_size_path", "Pixel size for path labels in rendering/export.");
  TOOLTIP_TEXTS.put("render_labels_size_struct", "Pixel size for structure labels in rendering/export.");
  TOOLTIP_TEXTS.put("render_labels_font", "Font used for all labels in rendering/export.");
  TOOLTIP_TEXTS.put("render_labels_outline", "Alpha of label outlines.");
  TOOLTIP_TEXTS.put("render_labels_outline_size", "Pixel size of label outlines.");
  TOOLTIP_TEXTS.put("render_export_padding", "Padding ratio used for render/export crops.");
  TOOLTIP_TEXTS.put("render_antialias", "Toggle antialiasing for rendering/export.");
  TOOLTIP_TEXTS.put("render_preset_apply", "Apply the selected render preset.");
  TOOLTIP_TEXTS.put("paths_type_add", "Add another path type palette entry.");
  TOOLTIP_TEXTS.put("paths_type_remove", "Remove the selected path type. \nExisting paths keep their parameters.");
  TOOLTIP_TEXTS.put("paths_palette", "Select a path type preset.");
  TOOLTIP_TEXTS.put("paths_type_name", "Edit name of active path type.");
  TOOLTIP_TEXTS.put("paths_type_hue", "Set hue for the active path type.");
  TOOLTIP_TEXTS.put("paths_type_weight", "Set stroke width for active path type.");
  TOOLTIP_TEXTS.put("paths_min_weight", "Clamp how thin the tapered path can become.");
  TOOLTIP_TEXTS.put("paths_taper", "End of path touching the sea will appear with a bigger stroke width than the other end.");
  TOOLTIP_TEXTS.put("paths_generate", "Auto-generate rivers, roads, and bridges.");

  // structures mode
  TOOLTIP_TEXTS.put("snap_water", "Snap to sea when placing new structures.");
  TOOLTIP_TEXTS.put("snap_biomes", "Snap to frontiers bewteen biomes when placing new structures.");
  TOOLTIP_TEXTS.put("snap_underwater_biomes", "Snap to underwater biomes when placing new structures.");
  TOOLTIP_TEXTS.put("snap_zones", "Snap to zone lines when placing new structures.");
  TOOLTIP_TEXTS.put("snap_paths", "Snap to paths when placing new structures.");
  TOOLTIP_TEXTS.put("snap_structures", "Snap to other structures when placing new structures.");
  TOOLTIP_TEXTS.put("snap_elevation", "Snap to the elevation contours defined by the divisions slider.");
  TOOLTIP_TEXTS.put("snap_elevation_divisions", "Number of elevation grid lines for snapping.");
  TOOLTIP_TEXTS.put("structures_size", "Structure size of upcoming structures.");
  TOOLTIP_TEXTS.put("structures_angle", "Angle offset for placed structure.");
  TOOLTIP_TEXTS.put("structures_ratio", "Ratio bewteen vertical and horizontal dimensions, when applicable.");
  TOOLTIP_TEXTS.put("structures_shape", "Shape of upcoming structures.");
  TOOLTIP_TEXTS.put("structures_snap_mode", "Define how structures are snapped: \n- none : no snapping \n- next : like houses next to a road \n- center : right in the middle of snapping guide");
  TOOLTIP_TEXTS.put("structures_deselect", "Deselect any selected structure.");
  TOOLTIP_TEXTS.put("structures_detail_name", "Click to rename selected structure.");
  TOOLTIP_TEXTS.put("structures_detail_size", "Selected structure's size.");
  TOOLTIP_TEXTS.put("structures_detail_angle", "Selected structure's angle.");
  TOOLTIP_TEXTS.put("structures_detail_hue", "Selected structure hue.");
  TOOLTIP_TEXTS.put("structures_detail_alpha", "Selected structure transparency.");
  TOOLTIP_TEXTS.put("structures_detail_sat", "Selected structure saturation.");
  TOOLTIP_TEXTS.put("structures_detail_stroke", "Selected structure's outlines width.");

  // labels mode
  TOOLTIP_TEXTS.put("labels_deselect", "Deselect currently edited label.");
  TOOLTIP_TEXTS.put("labels_size", "Text height.");

  // rendering mode
  TOOLTIP_TEXTS.put("render_preset", "Drag the slider to pick a preset and hit Apply to swap render.");

  // export mode
  TOOLTIP_TEXTS.put("export_png", "Export the current view as a PNG.");
  TOOLTIP_TEXTS.put("export_scale", "Multiply the output raster size.");
  TOOLTIP_TEXTS.put("export_map_json", "Export full map data to JSON (exports/map_latest.json).");
  TOOLTIP_TEXTS.put("import_map_json", "Import map data from exports/map_latest.json.");
  TOOLTIP_TEXTS.put("export_svg", "Export a simplified layered SVG (background, borders, paths, structures, labels, legend).");
  TOOLTIP_TEXTS.put("export_geojson", "Export map features (zones, paths, structures, labels) as GeoJSON FeatureCollection.");
  
}

public String tooltipFor(String key) {
  if (key == null) return null;
  if (key.equals("biome_gen_value")) return tooltipForBiomeValue();
  return TOOLTIP_TEXTS.get(key);
}

public String tooltipForBiomeValue() {
  int idx = constrain(biomeGenerateModeIndex, 0, biomeGenerateModes.length - 1);
  switch (idx) {
    case 0: return "Propagation: number of starting seeds (from few to many).";
    case 1: return "Reset: (no use).";
    case 2: return "Fill gaps: (no use).";
    case 3: return "Replace gaps: number of seeds scaled to empty area.";
    case 4: return "Fill under: sets elevation threshold.";
    case 5: return "Fill above: sets elevation threshold.";
    case 6: return "Extend: how many outward growth passes.";
    case 7: return "Shrink: how many erosion passes.";
    case 8: return "Spots: number of spots to paint.";
    case 9: return "Vary: strength/iterations of variation.";
    case 10: return "Slice spot: thickness around the chosen elevation (value slider).";
    case 11: return "Full: (no use).";
  }
  return "Value slider meaning depends on chosen generation mode.";
}
// ---------- ZoneType ----------

class ZoneType {
  String name;
  int col;
  float hue01;
  float sat01;
  float bri01;
  int patternIndex = 0;

  ZoneType(String name, int col) {
    this.name = name;
    setFromColor(col);
  }

  public void setFromColor(int c) {
    col = c;
    float[] hsb = new float[3];
    rgbToHSB01(c, hsb);
    hue01 = hsb[0];
    sat01 = hsb[1];
    bri01 = hsb[2];
  }

  public void updateColorFromHSB() {
    col = hsb01ToARGB(hue01, sat01, bri01, 1.0f);
  }
}

class ZonePreset {
  String name;
  int col;
  ZonePreset(String name, int col) {
    this.name = name;
    this.col = col;
  }
}

ZonePreset[] ZONE_PRESETS = new ZonePreset[] {
  new ZonePreset("Dirt",        color(210, 180, 140)),
  new ZonePreset("Rock",        color(150, 150, 150)),
  new ZonePreset("Grassland",   color(186, 206, 140)),
  new ZonePreset("Forest",      color(110, 150, 95)),
  new ZonePreset("Sand",        color(230, 214, 160)),
  new ZonePreset("Snow",        color(235, 240, 245)),
  new ZonePreset("Wetland",     color(165, 190, 155)),
  new ZonePreset("Magma",       color(190, 70, 40)),
  new ZonePreset("Wet",         color(80, 80, 150)),
  new ZonePreset("Shrubland",   color(195, 205, 170)),
  new ZonePreset("Clay Flats",  color(198, 176, 156)),
  new ZonePreset("Savannah",    color(215, 196, 128)),
  new ZonePreset("Tundra",      color(190, 200, 205)),
  new ZonePreset("Jungle",      color(80, 130, 85)),
  new ZonePreset("Volcanic",    color(105, 95, 90)),
  new ZonePreset("Heath",       color(180, 160, 145)),
  new ZonePreset("Steppe",      color(190, 185, 140)),
  new ZonePreset("Delta",       color(170, 200, 175)),
  new ZonePreset("Glacier",     color(220, 230, 240)),
  new ZonePreset("Mesa",        color(205, 165, 120)),
  new ZonePreset("Moor",        color(165, 155, 145)),
  new ZonePreset("Scrub",       color(185, 175, 150))
};

// ---------- Path types ----------
class PathType {
  String name;
  int col;
  float hue01;
  float sat01;
  float bri01;
  float weightPx;
  float minWeightPx;
  boolean taperOn = false;
  PathRouteMode routeMode = PathRouteMode.PATHFIND;
  float slopeBias = 0.0f;
  boolean avoidWater = true;

  PathType(String name, int col, float weightPx, float minWeightPx, PathRouteMode routeMode, float slopeBias, boolean avoidWater, boolean taperOn) {
    this.name = name;
    this.weightPx = weightPx;
    this.minWeightPx = max(0.5f, minWeightPx);
    this.routeMode = (routeMode != null) ? routeMode : PathRouteMode.PATHFIND;
    this.slopeBias = slopeBias;
    this.avoidWater = avoidWater;
    this.taperOn = taperOn;
    setFromColor(col);
  }

  public void setFromColor(int c) {
    col = c;
    float[] hsb = new float[3];
    rgbToHSB01(c, hsb);
    hue01 = hsb[0];
    sat01 = hsb[1];
    bri01 = hsb[2];
  }

  public void updateColorFromHSB() {
    col = hsb01ToARGB(hue01, sat01, bri01, 1.0f);
  }
}

class PathTypePreset {
  String name;
  int col;
  float weightPx;
  float minWeightPx;
  PathRouteMode routeMode;
  float slopeBias;
  boolean avoidWater;
  boolean taperOn;
  PathTypePreset(String name, int col, float weightPx, float minWeightPx, PathRouteMode routeMode, float slopeBias, boolean avoidWater, boolean taperOn) {
    this.name = name;
    this.col = col;
    this.weightPx = weightPx;
    this.minWeightPx = minWeightPx;
    this.routeMode = routeMode;
    this.slopeBias = slopeBias;
    this.avoidWater = avoidWater;
    this.taperOn = taperOn;
  }
}

PathTypePreset[] PATH_TYPE_PRESETS = new PathTypePreset[] {
  new PathTypePreset("Road",    color(80, 80, 80),    3.0f, 1.2f, PathRouteMode.PATHFIND, 500.0f,  true,  false),
  new PathTypePreset("River",   color(60, 90, 180),   8.0f, 2.0f, PathRouteMode.PATHFIND, 0.0f,    false, true),
  new PathTypePreset("Bridge",  color(130, 130, 160), 2.5f, 1.0f, PathRouteMode.ENDS,     0.0f,    false, false),
  new PathTypePreset("Trail",   color(140, 100, 70),  1.6f, 0.6f, PathRouteMode.PATHFIND, 0.0f,    true,  false),
  new PathTypePreset("Wall",    color(90, 70, 50),    2.5f, 1.0f, PathRouteMode.ENDS,     0.0f,    true,  false),
  new PathTypePreset("Street",  color(110, 110, 110), 2.2f, 0.8f, PathRouteMode.ENDS,     0.0f,    false, false),
  new PathTypePreset("Highway", color(130, 130, 130), 2.5f, 1.0f, PathRouteMode.ENDS,     0.0f,    false, false),
  new PathTypePreset("Canal",   color(70, 110, 190),  2.4f, 1.0f, PathRouteMode.PATHFIND, 700.0f,  false, true),
  new PathTypePreset("Rail",    color(70, 70, 70),    2.8f, 1.2f, PathRouteMode.PATHFIND, 700.0f,  true,  false),
  new PathTypePreset("Pipeline",color(120, 120, 120), 2.0f, 0.8f, PathRouteMode.ENDS,     0.0f,    true,  false),
  new PathTypePreset("Path",    color(0, 0, 0),       2.0f, 0.8f, PathRouteMode.ENDS,     0.0f,    false, false),
};

// ---------- Color helpers for HSB<->RGB in [0..1] ----------
// The "01" suffix means values are normalized [0..1] instead of Processing's default 0..255.

public void rgbToHSB01(int c, float[] outHSB) {
  int r = (c >> 16) & 0xFF;
  int g = (c >> 8) & 0xFF;
  int b = c & 0xFF;
  float rf = r / 255.0f;
  float gf = g / 255.0f;
  float bf = b / 255.0f;
  float maxc = max(rf, max(gf, bf));
  float minc = min(rf, min(gf, bf));
  float delta = maxc - minc;
  float h;
  if (delta < 1e-6f) {
    h = 0.0f;
  } else if (maxc == rf) {
    h = ((gf - bf) / delta) % 6.0f;
  } else if (maxc == gf) {
    h = ((bf - rf) / delta) + 2.0f;
  } else {
    h = ((rf - gf) / delta) + 4.0f;
  }
  h /= 6.0f;
  if (h < 0) h += 1.0f;
  float s = (maxc <= 0.0f) ? 0.0f : (delta / maxc);
  float v = maxc;

  outHSB[0] = constrain(h, 0, 1);
  outHSB[1] = constrain(s, 0, 1);
  outHSB[2] = constrain(v, 0, 1);
}

public int hsb01ToARGB(float h, float s, float b, float a) {
  h = constrain(h, 0, 1);
  s = constrain(s, 0, 1);
  b = constrain(b, 0, 1);
  a = constrain(a, 0, 1);

  float hh = (h * 6.0f) % 6.0f;
  int sector = floor(hh);
  float f = hh - sector;
  float p = b * (1 - s);
  float q = b * (1 - s * f);
  float t = b * (1 - s * (1 - f));
  float rf = 0, gf = 0, bf = 0;
  switch (sector) {
    case 0: rf = b; gf = t; bf = p; break;
    case 1: rf = q; gf = b; bf = p; break;
    case 2: rf = p; gf = b; bf = t; break;
    case 3: rf = p; gf = q; bf = b; break;
    case 4: rf = t; gf = p; bf = b; break;
    case 5: default: rf = b; gf = p; bf = q; break;
  }

  int ri = constrain(round(rf * 255.0f), 0, 255);
  int gi = constrain(round(gf * 255.0f), 0, 255);
  int bi = constrain(round(bf * 255.0f), 0, 255);
  int ai = constrain(round(a * 255.0f), 0, 255);
  return (ai << 24) | (ri << 16) | (gi << 8) | bi;
}

// Backward compatibility for callers still using RGB helper
public int hsb01ToRGB(float h, float s, float b) {
  return hsb01ToARGB(h, s, b, 1.0f);
}

// ---------- Structures ----------

class StructureAttributes {
  String name = "";
  String comment = "";
  float size = 0.02f;
  float angleRad = 0.0f;
  StructureShape shape = StructureShape.RECTANGLE;
  StructureSnapMode alignment = StructureSnapMode.NEXT_TO_PATH;
  float aspectRatio = 1.0f;
  float hue01 = 0.0f;
  float sat01 = 0.0f;
  float alpha01 = 1.0f;
  float strokeWeightPx = 1.4f;

  public StructureAttributes copy() {
    StructureAttributes c = new StructureAttributes();
    c.name = name;
    c.comment = comment;
    c.size = size;
    c.angleRad = angleRad;
    c.shape = shape;
    c.alignment = alignment;
    c.aspectRatio = aspectRatio;
    c.hue01 = hue01;
    c.sat01 = sat01;
    c.alpha01 = alpha01;
    c.strokeWeightPx = strokeWeightPx;
    return c;
  }

  public void applyTo(Structure s) {
    if (s == null) return;
    s.name = (name != null) ? name : "";
    s.comment = (comment != null) ? comment : "";
    s.size = size;
    s.angle = angleRad;
    s.shape = shape;
    s.aspect = aspectRatio;
    s.alignment = alignment;
    s.setHue(hue01);
    s.setSaturation(sat01);
    s.setAlpha(alpha01);
    s.strokeWeightPx = strokeWeightPx;
  }
}

class StructureSnapBinding {
  StructureSnapTargetType type = StructureSnapTargetType.NONE;
  int pathIndex = -1;
  int routeIndex = -1;
  int segmentIndex = -1;
  int structureIndex = -1;
  int cellA = -1;
  int cellB = -1;
  float snapAngleRad = 0.0f;
  PVector segA = null;
  PVector segB = null;
  PVector snapPoint = null;

  public void clear() {
    type = StructureSnapTargetType.NONE;
    pathIndex = -1;
    routeIndex = -1;
    segmentIndex = -1;
    structureIndex = -1;
    cellA = -1;
    cellB = -1;
    snapAngleRad = 0.0f;
    segA = null;
    segB = null;
    snapPoint = null;
  }
}

class Structure {
  float x;
  float y;
  int typeId = 0;
  float angle = 0;
  float size = 0.02f; // world units square side
  StructureShape shape = StructureShape.RECTANGLE;
  float aspect = 1.0f; // width / height for rectangle
  StructureSnapMode alignment = StructureSnapMode.NEXT_TO_PATH;
  String name = "";
  float hue01 = 0.0f;
  float sat01 = 0.0f;
  float bri01 = 0.9f;
  float alpha01 = 0.7f;
  float strokeWeightPx = 1.4f;
  int fillCol = color(245, 245, 235, 180);
  StructureSnapBinding snapBinding = new StructureSnapBinding();
  String comment = "";

  Structure(float x, float y) {
    this.x = x;
    this.y = y;
    setColor(color(245, 245, 235), 180.0f / 255.0f);
  }

  public void setColor(int c, float alpha) {
    float[] hsb = new float[3];
    rgbToHSB01(c, hsb);
    hue01 = hsb[0];
    sat01 = hsb[1];
    bri01 = hsb[2];
    alpha01 = constrain(alpha, 0, 1);
    updateFillColor();
  }

  public void setHue(float h) {
    hue01 = constrain(h, 0, 1);
    updateFillColor();
  }

  public void setSaturation(float s) {
    sat01 = constrain(s, 0, 1);
    updateFillColor();
  }

  public void setAlpha(float a) {
    alpha01 = constrain(a, 0, 1);
    updateFillColor();
  }

  public void updateFillColor() {
    int argb = hsb01ToARGB(hue01, sat01, bri01, alpha01);
    fillCol = argb;
  }

  public void draw(PApplet app) {
    app.pushMatrix();
    app.translate(x, y);
    app.rotate(angle);
    app.stroke(0);
    app.strokeWeight(strokeWeightPx / viewport.zoom);
    app.fill(fillCol);

    float r = size;
    float asp = max(0.1f, aspect);
    switch (shape) {
      case RECTANGLE: {
        float w = r;
        float h = r / asp;
        app.rectMode(CENTER);
        app.rect(0, 0, w, h);
        break;
      }
      case CIRCLE: {
        float w = r;
        float h = r / asp;
        app.ellipse(0, 0, w, h);
        break;
      }
      case TRIANGLE: {
        float h = (r / asp) * 0.866f; // scaled by aspect
        app.beginShape();
        app.vertex(-r * 0.5f, h * 0.333f);
        app.vertex(r * 0.5f, h * 0.333f);
        app.vertex(0, -h * 0.666f);
        app.endShape(CLOSE);
        break;
      }
      case HEXAGON: {
        float rad = r * 0.5f;
        app.beginShape();
        for (int i = 0; i < 6; i++) {
          float a = radians(60 * i);
          app.vertex(cos(a) * rad, sin(a) * rad / asp);
        }
        app.endShape(CLOSE);
        break;
      }
      default: {
        app.rectMode(CENTER);
        app.rect(0, 0, r, r / asp);
        break;
      }
    }
    app.popMatrix();
  }
}

public StructureAttributes structureAttributesFromStructure(Structure s) {
  StructureAttributes a = new StructureAttributes();
  if (s == null) return a;
  a.name = s.name;
  a.comment = s.comment;
  a.size = s.size;
  a.angleRad = s.angle;
  a.shape = s.shape;
  a.alignment = s.alignment;
  a.aspectRatio = s.aspect;
  a.hue01 = s.hue01;
  a.sat01 = s.sat01;
  a.alpha01 = s.alpha01;
  a.strokeWeightPx = s.strokeWeightPx;
  return a;
}

// ---------- Labels ----------

class MapLabel {
  float x;
  float y;
  String text;
  LabelTarget target = LabelTarget.FREE;
  float size = labelSizeDefault();
  String comment = "";

  MapLabel(float x, float y, String text) {
    this.x = x;
    this.y = y;
    this.text = text;
  }

  MapLabel(float x, float y, String text, LabelTarget target) {
    this(x, y, text);
    this.target = target;
  }

  public void draw(PApplet app) {
    if (app == null || text == null || text.length() == 0) return;
    float ts = size / max(1e-6f, viewport.zoom);
    app.pushStyle();
    app.fill(0);
    app.textAlign(CENTER, CENTER);
    app.textSize(ts);
    app.text(text, x, y);
    app.popStyle();
  }
}
// ---------- UI DRAWING ----------

public int panelTop() {
  // Base panel top (top bar + tool bar).
  return snapPanelTop();
}

public int snapPanelTop() {
  return TOP_BAR_TOTAL + TOOL_BAR_HEIGHT;
}

public int snapSettingsPanelHeight() {
  // Title + section gap
  int h = PANEL_PADDING + PANEL_TITLE_H + PANEL_SECTION_GAP;
  // Seven checkbox rows
  int rows = 7;
  h += rows * (PANEL_CHECK_SIZE + PANEL_ROW_GAP);
  // Elevation divisions slider label + slider + padding
  h += PANEL_LABEL_H + PANEL_SLIDER_H + PANEL_PADDING;
  // Bottom padding
  h += PANEL_PADDING;
  return h;
}

public void drawPanelBackground(IntRect frame) {
  rectMode(CORNER);
  ellipseMode(CENTER);
  noStroke();
  fill(232);
  rect(frame.x, frame.y, frame.w, frame.h);

  // Bevel
  stroke(255);
  line(frame.x, frame.y, frame.x + frame.w, frame.y);
  line(frame.x, frame.y, frame.x, frame.y + frame.h);
  stroke(120);
  line(frame.x, frame.y + frame.h - 1, frame.x + frame.w, frame.y + frame.h - 1);
  line(frame.x + frame.w - 1, frame.y, frame.x + frame.w - 1, frame.y + frame.h);
}

// Shared small rect helper
class IntRect {
  int x, y, w, h;
  IntRect() {}
  IntRect(int x, int y, int w, int h) { this.x = x; this.y = y; this.w = w; this.h = h; }
  public boolean contains(int px, int py) { return px >= x && px <= x + w && py >= y && py <= y + h; }
}

IntRect pressedButtonRect = null;
Runnable pendingButtonAction = null;

public boolean rectEquals(IntRect a, IntRect b) {
  return a != null && b != null && a.x == b.x && a.y == b.y && a.w == b.w && a.h == b.h;
}

public boolean queueButtonAction(IntRect rect, Runnable action) {
  if (rect == null || action == null) return false;
  if (!rect.contains(mouseX, mouseY)) return false;
  pressedButtonRect = new IntRect(rect.x, rect.y, rect.w, rect.h);
  pendingButtonAction = action;
  return true;
}

public boolean isButtonHeld(IntRect rect) {
  if (rect == null || pressedButtonRect == null) return false;
  if (!rectEquals(rect, pressedButtonRect)) return false;
  return pressedButtonRect.contains(mouseX, mouseY);
}

public void runPendingButtonAction(int mx, int my) {
  if (pendingButtonAction != null && pressedButtonRect != null && pressedButtonRect.contains(mx, my)) {
    pendingButtonAction.run();
  }
  pressedButtonRect = null;
  pendingButtonAction = null;
}

public float clampScroll(float scroll, float contentH, float viewH) {
  float maxScroll = max(0, contentH - viewH);
  return constrain(scroll, 0, maxScroll);
}

public void drawScrollbar(IntRect track, float contentH, float scroll) {
  if (track == null || track.h <= 0) return;
  boolean active = contentH > track.h;

  // Track
  noStroke();
  fill(active ? 214 : 200);
  rect(track.x, track.y, track.w, track.h);
  stroke(255);
  line(track.x, track.y, track.x + track.w, track.y);
  line(track.x, track.y, track.x, track.y + track.h);
  stroke(96);
  line(track.x, track.y + track.h - 1, track.x + track.w, track.y + track.h - 1);
  line(track.x + track.w - 1, track.y, track.x + track.w - 1, track.y + track.h);

  if (!active) return;

  int inset = 2;
  int thumbH = max(SCROLLBAR_THUMB_MIN, round(track.h * track.h / contentH));
  thumbH = min(thumbH, track.h - inset * 2);
  float travel = track.h - inset * 2 - thumbH;
  float maxScroll = max(1e-3f, contentH - track.h);
  int thumbY = track.y + inset + round((scroll / maxScroll) * travel);
  IntRect thumb = new IntRect(track.x + inset, thumbY, track.w - inset * 2, thumbH);

  // Thumb with Win95-ish bevel
  noStroke();
  fill(205);
  rect(thumb.x, thumb.y, thumb.w, thumb.h);
  stroke(255);
  line(thumb.x, thumb.y, thumb.x + thumb.w, thumb.y);
  line(thumb.x, thumb.y, thumb.x, thumb.y + thumb.h);
  stroke(96);
  line(thumb.x, thumb.y + thumb.h - 1, thumb.x + thumb.w, thumb.y + thumb.h - 1);
  line(thumb.x + thumb.w - 1, thumb.y, thumb.x + thumb.w - 1, thumb.y + thumb.h);
}

public void drawTopBar() {
  int topBarH = TOP_BAR_TOTAL;
  // Background
  noStroke();
  fill(202);
  rect(0, 0, width, topBarH);

  // Bevel edges (Win95-ish)
  stroke(255);
  line(0, 0, width, 0);
  line(0, 0, 0, topBarH);
  stroke(96);
  line(0, topBarH - 1, width, topBarH - 1);
  line(width - 1, 0, width - 1, topBarH);

  // Text
  fill(10);
  textAlign(LEFT, CENTER);
  String info1 = "Tool: " + currentTool +
                 "   Zoom: " + nf(viewport.zoom, 1, 2) +
                 "   Center: (" + nf(viewport.centerX, 1, 3) + ", " +
                                nf(viewport.centerY, 1, 3) + ")";

  int siteCount = (mapModel != null && mapModel.sites != null) ? mapModel.sites.size() : 0;
  int cellCount = (mapModel != null && mapModel.cells != null) ? mapModel.cells.size() : 0;
  int pathCount = (mapModel != null && mapModel.paths != null) ? mapModel.paths.size() : 0;
  int pathSegs = 0;
  if (mapModel != null && mapModel.paths != null) {
    for (Path p : mapModel.paths) {
      if (p != null) pathSegs += p.segmentCount();
    }
  }
  String info2 = "FPS: " + nf(frameRate, 1, 1) +
                 "   Sites: " + siteCount +
                 "   Cells: " + cellCount +
                 "   Paths: " + pathCount + " (" + pathSegs + " segs)";
  if (mapModel != null) {
    info2 += "   Snap: " + mapModel.lastSnapNodeCount + "n/" + mapModel.lastSnapEdgeCount +
             "e (" + nf(mapModel.lastSnapBuildMs, 1, 1) + "ms)";
    info2 += "   Pathfind: " + nf(mapModel.lastPathfindMs, 1, 1) + "ms " +
             "[" + mapModel.lastPathfindExpanded + " expanded, len " + mapModel.lastPathfindLength +
             (mapModel.lastPathfindHit ? "" : ", miss") + "]";
  }
  text(info1, 10, topBarH / 2.0f - 7);
  text(info2, 10, topBarH / 2.0f + 7);

  // Notice/status (right side, above loading bar). Prefer ongoing ops over transient notices.
  // Loading bar & status (top-right, small)
  boolean showLoad = progressActive || isLoading;
  if (uiNoticeFrames > 0 && uiNotice != null && uiNotice.length() > 0) {
    setProgressStatus(uiNotice);
    uiNoticeFrames--;
  } else if (uiNoticeFrames == 0 && uiNotice != null && uiNotice.length() > 0) {
    if (!showLoad && progressStatusMsg != null && progressStatusMsg.equals(uiNotice)) {
      setProgressStatus("");
    }
    uiNotice = "";
  }
  if (showLoad || (progressStatusMsg != null && progressStatusMsg.length() > 0)) {
    if (showLoad) loadingPhase += 0.02f;
    float barW = 120;
    float barH = 10;
    float x = width - barW - 12;
    float y = (topBarH - barH) / 2.0f;
    stroke(80);
    fill(235);
    rect(x, y, barW, barH, 3);
    noStroke();
    float pct = progressActive ? constrain(progressPct, 0, 1) : loadingPct;
    if (showLoad) {
      pct = max(pct, (sin(loadingPhase) * 0.05f + 0.05f)); // tiny pulse
    }
    float w = barW * pct;
    fill(60, 140, 220);
    rect(x + 1, y + 1, w - 2, barH - 2, 2);

    String detail = null;
    if (progressActive && progressDetail != null && progressDetail.length() > 0) detail = progressDetail;
    else if (progressStatusMsg != null && progressStatusMsg.length() > 0) detail = progressStatusMsg;
    if (detail != null && detail.length() > 0) {
      fill(20);
      textAlign(RIGHT, CENTER);
      text(detail, x - 8, y + barH * 0.5f);
    }
  }
}

public void drawToolButtons() {
  int barY = TOP_BAR_TOTAL;
  int barH = TOOL_BAR_HEIGHT;
  int margin = 10;
  int buttonW = 90;

  // Background for tool bar
  noStroke();
  fill(245);
  rect(0, barY, width, barH);

  // Bevel borders (no bottom line to blend with content)
  stroke(255);
  line(0, barY, width, barY);
  line(0, barY, 0, barY + barH);
  stroke(100);
  line(width - 1, barY, width - 1, barY + barH);

  String[] labels = { "Cells", "Elevation", "Biomes", "Zones", "Paths", "Structures", "Labels", "Rendering", "Export" };
  Tool[] tools = {
    Tool.EDIT_SITES,
    Tool.EDIT_ELEVATION,
    Tool.EDIT_BIOMES,
    Tool.EDIT_ZONES,
    Tool.EDIT_PATHS,
    Tool.EDIT_STRUCTURES,
    Tool.EDIT_LABELS,
    Tool.EDIT_RENDER,
    Tool.EDIT_EXPORT
  };

  for (int i = 0; i < labels.length; i++) {
    int x = margin + i * (buttonW + 5);
    int y = barY + 2;
    IntRect rect = new IntRect(x, y, buttonW, barH - 4);

    boolean active = (currentTool == tools[i]);
    drawTabButton(rect, active);

    fill(20);
    textAlign(CENTER, CENTER);
    text(labels[i], x + buttonW / 2, y + (barH - 4) / 2);

    String key = "tool_" + labels[i].toLowerCase();
    registerUiTooltip(rect, tooltipFor(key));
  }
}
final int PANEL_HINT_H = PANEL_SECTION_GAP + (PANEL_LABEL_H + 2) * 2 + 6;

public int hintHeight(int lines) {
  if (lines <= 0) return 0;
  return PANEL_SECTION_GAP + (PANEL_LABEL_H + 2) * lines + 6;
}

// ----- SNAP SETTINGS (top of left menu) -----
class SnapSettingsLayout {
  IntRect panel;
  ArrayList<IntRect> checks = new ArrayList<IntRect>();
  IntRect elevationSlider;
}

public SnapSettingsLayout buildSnapSettingsLayout() {
  SnapSettingsLayout l = new SnapSettingsLayout();
  l.panel = new IntRect(PANEL_X, snapPanelTop(), PANEL_W, snapSettingsPanelHeight());
  int innerX = l.panel.x + PANEL_PADDING;
  int curY = l.panel.y + PANEL_PADDING;
  String[] labels = {
    "Water",
    "Biomes",
    "Underwater biomes",
    "Zones",
    "Paths",
    "Other structures",
    "Elevation"
  };
  curY += PANEL_TITLE_H + PANEL_SECTION_GAP;
  for (int i = 0; i < labels.length; i++) {
    l.checks.add(new IntRect(innerX, curY, PANEL_CHECK_SIZE, PANEL_CHECK_SIZE));
    curY += PANEL_CHECK_SIZE + PANEL_ROW_GAP;
  }
  l.elevationSlider = new IntRect(innerX + PANEL_CHECK_SIZE + 8, curY + PANEL_LABEL_H, 160, PANEL_SLIDER_H);
  return l;
}

public void drawSnapSettingsPanel() {
  SnapSettingsLayout l = buildSnapSettingsLayout();
  drawPanelBackground(l.panel);

  int labelX = l.panel.x + PANEL_PADDING;
  fill(0);
  textAlign(LEFT, TOP);
  text("Snap targets", labelX, l.panel.y + PANEL_PADDING);

  String[] labels = {
    "Water",
    "Biomes",
    "Underwater biomes",
    "Zones",
    "Paths",
    "Other structures",
    "Elevation"
  };
  String[] snapKeys = {
    "snap_water",
    "snap_biomes",
    "snap_underwater_biomes",
    "snap_zones",
    "snap_paths",
    "snap_structures",
    "snap_elevation"
  };
  boolean[] values = {
    snapWaterEnabled,
    snapBiomesEnabled,
    snapUnderwaterBiomesEnabled,
    snapZonesEnabled,
    snapPathsEnabled,
    snapStructuresEnabled,
    snapElevationEnabled
  };

  for (int i = 0; i < labels.length; i++) {
    IntRect b = l.checks.get(i);
    drawCheckbox(b.x, b.y, b.w, values[i], labels[i]);
    if (i < snapKeys.length) {
      int hintW = l.panel.w - 2 * PANEL_PADDING;
      registerUiTooltip(new IntRect(b.x, b.y, hintW, b.h), tooltipFor(snapKeys[i]));
    }
  }

  // Elevation divisions slider
  IntRect es = l.elevationSlider;
  int divMin = 2;
  int divMax = 24;
  float t = constrain((snapElevationDivisions - divMin) / (float)(divMax - divMin), 0, 1);
  drawSlider(es, t, "Elevation divisions: " + snapElevationDivisions);
  registerUiTooltip(es, tooltipFor("snap_elevation_divisions"));
}

public boolean isInSnapSettingsPanel(int mx, int my) {
  SnapSettingsLayout l = buildSnapSettingsLayout();
  return l.panel.contains(mx, my);
}

// ----- SITES PANEL -----

class SitesLayout {
  IntRect panel;
  int titleY;
  IntRect densitySlider;
  IntRect fuzzSlider;
  IntRect modeSlider;
  IntRect resetBtn;
  IntRect generateBtn;
  IntRect fullGenerateBtn;
  IntRect keepCheckbox;
}

public SitesLayout buildSitesLayout() {
  SitesLayout l = new SitesLayout();
  l.panel = new IntRect(PANEL_X, panelTop(), PANEL_W, 0);
  int innerX = l.panel.x + PANEL_PADDING;
  int curY = l.panel.y + PANEL_PADDING;
  l.titleY = curY;
  curY += PANEL_TITLE_H + PANEL_SECTION_GAP;

  // Reset all
  l.resetBtn = new IntRect(innerX, curY, 110, PANEL_BUTTON_H);
  curY += PANEL_BUTTON_H + PANEL_ROW_GAP;

  // Generate controls up top
  l.generateBtn = new IntRect(innerX, curY, 110, PANEL_BUTTON_H);
  l.keepCheckbox = new IntRect(l.generateBtn.x + l.generateBtn.w + 12,
                               curY + (PANEL_BUTTON_H - PANEL_CHECK_SIZE) / 2,
                               PANEL_CHECK_SIZE, PANEL_CHECK_SIZE);
  curY += PANEL_BUTTON_H + PANEL_ROW_GAP;

  l.fullGenerateBtn = new IntRect(innerX, curY, 180, PANEL_BUTTON_H);
  curY += PANEL_BUTTON_H + PANEL_SECTION_GAP;

  int sliderW = 200;
  l.densitySlider = new IntRect(innerX, curY + PANEL_LABEL_H, sliderW, PANEL_SLIDER_H);
  curY += PANEL_LABEL_H + PANEL_SLIDER_H + PANEL_ROW_GAP;

  l.fuzzSlider = new IntRect(innerX, curY + PANEL_LABEL_H, sliderW, PANEL_SLIDER_H);
  curY += PANEL_LABEL_H + PANEL_SLIDER_H + PANEL_ROW_GAP;

  l.modeSlider = new IntRect(innerX, curY + PANEL_LABEL_H, sliderW, PANEL_SLIDER_H);
  curY += PANEL_LABEL_H + PANEL_SLIDER_H + PANEL_SECTION_GAP;

  curY += PANEL_PADDING + hintHeight(4);
  l.panel.h = curY - l.panel.y;
  return l;
}

public void drawSitesPanel() {
  SitesLayout layout = buildSitesLayout();
  drawPanelBackground(layout.panel);

  int labelX = layout.panel.x + PANEL_PADDING;
  fill(0);
  textAlign(LEFT, TOP);
  text("Cells generation", labelX, layout.titleY);

  // ---------- Reset button ----------
  IntRect r = layout.resetBtn;
  drawBevelButton(r.x, r.y, r.w, r.h, false);
  fill(10);
  textAlign(CENTER, CENTER);
  text("Reset all", r.x + r.w / 2, r.y + r.h / 2);
  registerUiTooltip(r, tooltipFor("sites_reset_all"));

  // ---------- Density slider ----------
  IntRect d = layout.densitySlider;
  float density01 = constrain(siteTargetCount / (float)MAX_SITE_COUNT, 0, 1);
  drawSlider(d, density01, "Density: " + siteTargetCount + " cells");
  registerUiTooltip(d, tooltipFor("site_density"));

  // ---------- Fuzz slider (0..0.3) ----------
  IntRect f = layout.fuzzSlider;
  float fuzzNorm = (siteFuzz <= 0) ? 0 : constrain(siteFuzz / 0.3f, 0, 1);
  drawSlider(f, fuzzNorm, "Fuzz: " + nf(siteFuzz, 1, 2) + " (0 = none, 0.3 = strong jitter)");
  registerUiTooltip(f, tooltipFor("site_fuzz"));

  // ---------- Placement mode slider (DISCRETE) ----------
  IntRect m = layout.modeSlider;
  int modeCount = placementModes.length;
  if (modeCount < 1) modeCount = 1;
  String modeName = placementModeLabel(currentPlacementMode());
  float tMode = constrain(placementModeIndex / max(1.0f, modeCount - 1.0f), 0, 1);
  drawSelectorSlider(m, tMode, "Placement: " + modeName, modeCount);
  registerUiTooltip(m, tooltipFor("site_mode"));

  // ---------- Generate button ----------
  IntRect g = layout.generateBtn;
  drawBevelButton(g.x, g.y, g.w, g.h, false);
  fill(10);
  textAlign(CENTER, CENTER);
  text("Generate", g.x + g.w / 2, g.y + g.h / 2);
  registerUiTooltip(g, tooltipFor("sites_generate"));

  // ---------- Full generate button ----------
  IntRect fg = layout.fullGenerateBtn;
  drawBevelButton(fg.x, fg.y, fg.w, fg.h, false);
  fill(10);
  textAlign(CENTER, CENTER);
  text("Generate everything from there", fg.x + fg.w / 2, fg.y + fg.h / 2);
  registerUiTooltip(fg, "Run a full pipeline: elevation, plateaux, biomes, zones, paths, structures, labels.");

  // Keep properties toggle
  IntRect c = layout.keepCheckbox;
  stroke(80);
  fill(keepPropertiesOnGenerate ? 200 : 240);
  rect(c.x, c.y, c.w, c.h);
  if (keepPropertiesOnGenerate) {
    line(c.x + 3, c.y + c.h / 2, c.x + c.w / 2, c.y + c.h - 3);
    line(c.x + c.w / 2, c.y + c.h - 3, c.x + c.w - 3, c.y + 3);
  }
  fill(0);
  textAlign(LEFT, CENTER);
  text("Keep properties", c.x + c.w + 6, g.y + g.h / 2);
  registerUiTooltip(new IntRect(c.x, c.y, c.w + 120, c.h), tooltipFor("sites_keep"));

  drawControlsHint(layout.panel,
                   "right-click: pan",
                   "wheel: zoom",
                   "drag: drag",
                   "DEL: remove selected");
}

// ----- Biomes PANEL -----

class BiomesLayout {
  IntRect panel;
  int titleY;
  IntRect paintBtn;
  IntRect fillBtn;
  IntRect genModeSelector;
  IntRect genApplyBtn;
  IntRect genValueSlider;
  IntRect genValueWaterBtn;
  IntRect addBtn;
  IntRect removeBtn;
  ArrayList<IntRect> swatches = new ArrayList<IntRect>();
  IntRect nameField;
  IntRect hueSlider;
  IntRect satSlider;
  IntRect briSlider;
  IntRect patternSlider;
  IntRect brushSlider;
}

public BiomesLayout buildBiomesLayout() {
  BiomesLayout l = new BiomesLayout();
  l.panel = new IntRect(PANEL_X, panelTop(), PANEL_W, 0);
  int innerX = l.panel.x + PANEL_PADDING;
  int curY = l.panel.y + PANEL_PADDING;
  l.titleY = curY;
  curY += PANEL_TITLE_H + PANEL_SECTION_GAP;

  int selectorW = 200;
  l.genModeSelector = new IntRect(innerX, curY + PANEL_LABEL_H, selectorW, PANEL_SLIDER_H);
  l.genApplyBtn = new IntRect(l.genModeSelector.x + l.genModeSelector.w + 10, curY + PANEL_LABEL_H - 2, 90, PANEL_BUTTON_H);
  curY += PANEL_LABEL_H + PANEL_SLIDER_H + PANEL_ROW_GAP;
  l.genValueSlider = new IntRect(innerX, curY + PANEL_LABEL_H, selectorW, PANEL_SLIDER_H);
  l.genValueWaterBtn = new IntRect(l.genValueSlider.x + l.genValueSlider.w + 10, curY + PANEL_LABEL_H - 2, 80, PANEL_BUTTON_H);
  curY += PANEL_LABEL_H + PANEL_SLIDER_H + PANEL_SECTION_GAP;

  l.paintBtn = new IntRect(innerX, curY, 70, PANEL_BUTTON_H);
  l.fillBtn = new IntRect(l.paintBtn.x + l.paintBtn.w + 8, curY, 70, PANEL_BUTTON_H);
  curY += PANEL_BUTTON_H + PANEL_SECTION_GAP;

  l.addBtn = new IntRect(innerX, curY, 24, PANEL_BUTTON_H);
  l.removeBtn = new IntRect(l.addBtn.x + l.addBtn.w + 6, curY, 24, PANEL_BUTTON_H);
  curY += PANEL_BUTTON_H + PANEL_SECTION_GAP;

  // Palette
  int swatchW = 70;
  int swatchH = 22;
  int gapX = 8;
  int maxPerRow = max(1, (PANEL_W - 2 * PANEL_PADDING + gapX) / (swatchW + gapX));
  int rowY = curY;
  int col = 0;
  int paletteBottom = rowY;
  if (mapModel != null && mapModel.biomeTypes != null) {
    for (int i = 0; i < mapModel.biomeTypes.size(); i++) {
      int x = innerX + col * (swatchW + gapX);
      l.swatches.add(new IntRect(x, rowY, swatchW, swatchH));
      paletteBottom = max(paletteBottom, rowY + swatchH);
      col++;
      if (col >= maxPerRow) {
        col = 0;
        rowY += swatchH + PANEL_ROW_GAP;
      }
    }
  }
  curY = paletteBottom + PANEL_ROW_GAP;

  l.nameField = new IntRect(innerX, curY + PANEL_LABEL_H, 200, PANEL_BUTTON_H);
  curY += PANEL_LABEL_H + PANEL_BUTTON_H + PANEL_SECTION_GAP;

  l.hueSlider = new IntRect(innerX, curY + PANEL_LABEL_H, 200, PANEL_SLIDER_H);
  curY += PANEL_LABEL_H + PANEL_SLIDER_H + PANEL_ROW_GAP;

  l.satSlider = new IntRect(innerX, curY + PANEL_LABEL_H, 200, PANEL_SLIDER_H);
  curY += PANEL_LABEL_H + PANEL_SLIDER_H + PANEL_ROW_GAP;

  l.briSlider = new IntRect(innerX, curY + PANEL_LABEL_H, 200, PANEL_SLIDER_H);
  curY += PANEL_LABEL_H + PANEL_SLIDER_H + PANEL_SECTION_GAP;

  l.patternSlider = new IntRect(innerX, curY + PANEL_LABEL_H, 200, PANEL_SLIDER_H);
  curY += PANEL_LABEL_H + PANEL_SLIDER_H + PANEL_SECTION_GAP;

  l.brushSlider = new IntRect(innerX, curY + PANEL_LABEL_H, 180, PANEL_SLIDER_H);
  curY += PANEL_LABEL_H + PANEL_SLIDER_H + PANEL_PADDING;

  curY += hintHeight(3);
  l.panel.h = curY - l.panel.y;
  return l;
}

public void drawBiomesPanel() {
  BiomesLayout layout = buildBiomesLayout();
  drawPanelBackground(layout.panel);

  int labelX = layout.panel.x + PANEL_PADDING;
  fill(0);
  textAlign(LEFT, TOP);
  text("Biomes", labelX, layout.titleY);

  // Generation mode selector + apply
  IntRect gsel = layout.genModeSelector;
  int modeCount = biomeGenerateModes.length;
  int maxIdx = max(1, modeCount - 1);
  float tMode = constrain(biomeGenerateModeIndex / (float)maxIdx, 0, 1);
  String modeName = biomeGenerateModes[constrain(biomeGenerateModeIndex, 0, modeCount - 1)];
  drawSelectorSlider(gsel, tMode, "Generation mode: " + modeName, modeCount);
  registerUiTooltip(gsel, tooltipFor("biome_gen_mode"));

  if (layout.genApplyBtn != null) {
    drawBevelButton(layout.genApplyBtn.x, layout.genApplyBtn.y, layout.genApplyBtn.w, layout.genApplyBtn.h, false);
    fill(10);
    textAlign(CENTER, CENTER);
    text("Generate", layout.genApplyBtn.x + layout.genApplyBtn.w / 2, layout.genApplyBtn.y + layout.genApplyBtn.h / 2);
    registerUiTooltip(layout.genApplyBtn, tooltipFor("biome_gen_apply"));
  }

  // Generation value slider (0..1 displayed)
  IntRect gv = layout.genValueSlider;
  drawSlider(gv, constrain(biomeGenerateValue01, 0, 1), "Value (" + nf(biomeGenerateValue01, 1, 2) + ")");
  registerUiTooltip(gv, tooltipFor("biome_gen_value"));

  // "Set to water level" helper
  if (layout.genValueWaterBtn != null) {
    drawBevelButton(layout.genValueWaterBtn.x, layout.genValueWaterBtn.y, layout.genValueWaterBtn.w, layout.genValueWaterBtn.h, false);
    fill(10);
    textAlign(CENTER, CENTER);
    text("Set to water", layout.genValueWaterBtn.x + layout.genValueWaterBtn.w / 2, layout.genValueWaterBtn.y + layout.genValueWaterBtn.h / 2);
    registerUiTooltip(layout.genValueWaterBtn, tooltipFor("biome_value_water"));
  }

  // Paint button
  drawBevelButton(layout.paintBtn.x, layout.paintBtn.y, layout.paintBtn.w, layout.paintBtn.h,
                  currentBiomePaintMode == ZonePaintMode.ZONE_PAINT);
  fill(10);
  textAlign(CENTER, CENTER);
  text("Paint", layout.paintBtn.x + layout.paintBtn.w * 0.5f, layout.paintBtn.y + layout.paintBtn.h * 0.5f);
  registerUiTooltip(layout.paintBtn, tooltipFor("biome_paint"));

  // Fill button
  drawBevelButton(layout.fillBtn.x, layout.fillBtn.y, layout.fillBtn.w, layout.fillBtn.h,
                  currentBiomePaintMode == ZonePaintMode.ZONE_FILL);
  fill(10);
  textAlign(CENTER, CENTER);
  text("Fill", layout.fillBtn.x + layout.fillBtn.w * 0.5f, layout.fillBtn.y + layout.fillBtn.h * 0.5f);
  registerUiTooltip(layout.fillBtn, tooltipFor("biome_fill"));

  // Add / Remove biome type buttons
  // "+" button
  drawBevelButton(layout.addBtn.x, layout.addBtn.y, layout.addBtn.w, layout.addBtn.h, false);
  fill(10);
  textAlign(CENTER, CENTER);
  text("+", layout.addBtn.x + layout.addBtn.w * 0.5f, layout.addBtn.y + layout.addBtn.h * 0.5f);
  registerUiTooltip(layout.addBtn, tooltipFor("biome_add"));

  // "-" button (disabled if index 0 or only one type)
  boolean canRemove = (mapModel.biomeTypes != null &&
                       mapModel.biomeTypes.size() > 1 &&
                       activeBiomeIndex > 0);

  drawBevelButton(layout.removeBtn.x, layout.removeBtn.y, layout.removeBtn.w, layout.removeBtn.h, !canRemove);
  fill(10);
  textAlign(CENTER, CENTER);
  text("-", layout.removeBtn.x + layout.removeBtn.w * 0.5f, layout.removeBtn.y + layout.removeBtn.h * 0.5f);
  registerUiTooltip(layout.removeBtn, tooltipFor("biome_remove"));

  // Palette
  if (mapModel == null || mapModel.biomeTypes == null) return;
  int n = mapModel.biomeTypes.size();
  if (n == 0) return;

  for (int i = 0; i < n; i++) {
    pushStyle();
    ZoneType zt = mapModel.biomeTypes.get(i);
    IntRect sw = layout.swatches.get(i);
    stroke(i == activeBiomeIndex ? 0 : 120);
    strokeWeight(i == activeBiomeIndex ? 2 : 1);
    fill(zt.col);
    rect(sw.x, sw.y, sw.w, sw.h, 4);

    // Overlay label text
    fill(20);
    textAlign(CENTER, CENTER);
    text(zt.name, sw.x + sw.w * 0.5f, sw.y + sw.h * 0.5f);
    registerUiTooltip(sw, tooltipFor("biome_palette"));
    popStyle();
  }

  // Editable name field for selected biome
  if (activeBiomeIndex >= 0 && activeBiomeIndex < n) {
    IntRect nf = layout.nameField;
    ZoneType active = mapModel.biomeTypes.get(activeBiomeIndex);
    boolean editing = (editingBiomeNameIndex == activeBiomeIndex);
    fill(0);
    textAlign(LEFT, BOTTOM);
    text("Name", nf.x, nf.y - 4);
    stroke(80);
    fill(255);
    rect(nf.x, nf.y, nf.w, nf.h);
    fill(0);
    textAlign(LEFT, CENTER);
    String shown = editing ? biomeNameDraft : active.name;
    text(shown, nf.x + 6, nf.y + nf.h / 2);
    if (editing) {
      float caretX = nf.x + 6 + textWidth(biomeNameDraft);
      stroke(0);
      line(caretX, nf.y + 4, caretX, nf.y + nf.h - 4);
    }
    registerUiTooltip(nf, tooltipFor("biome_name"));
  }

  // Hue slider for currently selected biome
  if (activeBiomeIndex >= 0 && activeBiomeIndex < n) {
    ZoneType active = mapModel.biomeTypes.get(activeBiomeIndex);

    IntRect hue = layout.hueSlider;
    float hNorm = constrain(active.hue01, 0, 1);
    drawSlider(hue, hNorm, "Hue for \"" + active.name + "\": " + nf(active.hue01, 1, 2));
    registerUiTooltip(hue, tooltipFor("biome_hue"));

    if (layout.satSlider != null) {
      float sNorm = constrain(active.sat01, 0, 1);
      drawSlider(layout.satSlider, sNorm, "Saturation for \"" + active.name + "\"");
    }

    if (layout.briSlider != null) {
      float bNorm = constrain(active.bri01, 0, 1);
      drawSlider(layout.briSlider, bNorm, "Brightness for \"" + active.name + "\"");
    }

    // Pattern selector
    if (layout.patternSlider != null && mapModel != null) {
      int patCount = max(1, mapModel.biomePatternCount);
      int clamped = ((active.patternIndex % patCount) + patCount) % patCount;
      String fallbackPat = renderSettings.biomePatternName;
      if ((fallbackPat == null || fallbackPat.length() == 0) && mapModel.biomePatternFiles != null && !mapModel.biomePatternFiles.isEmpty()) {
        fallbackPat = mapModel.biomePatternFiles.get(0);
      }
      String patName = mapModel.biomePatternNameForIndex(clamped, fallbackPat);
      float pNorm = (patCount > 1) ? clamped / (float)(patCount - 1) : 0;
      drawSelectorSlider(layout.patternSlider, pNorm, "Pattern: " + patName, patCount);
    }
  }

  // Brush radius slider
  IntRect brush = layout.brushSlider;
  float bNorm = constrain(map(zoneBrushRadius, 0.01f, 0.15f, 0, 1), 0, 1);
  drawSlider(brush, bNorm, "Brush radius");

  drawControlsHint(layout.panel,
                   "left-click: paint/fill",
                   "right-click: pan",
                   "wheel: zoom.");
}

// ----- ZONES PANEL -----
class ZonesLayout {
  IntRect panel;
  int titleY;
  IntRect resetBtn;
  IntRect regenerateBtn;
  IntRect brushSlider;
  IntRect excludeWaterBtn;
  IntRect exclusiveBtn;
  IntRect fourColorBtn;
  IntRect listPanel;
  IntRect commentField;
}

class ZoneRowLayout {
  int index;
  IntRect selectRect;
  IntRect nameRect;
  IntRect hueSlider;
  IntRect colorRect;
}

class ZonesListLayout {
  IntRect panel;
  int titleY;
  IntRect deselectBtn;
  IntRect newBtn;
  ArrayList<ZoneRowLayout> rows = new ArrayList<ZoneRowLayout>();
  int rowsStartY;
  int rowsViewH;
  float contentH;
  IntRect scrollbar;
}

public ZonesListLayout buildZonesListLayout() {
  ZonesListLayout l = new ZonesListLayout();
  int w = RIGHT_PANEL_W;
  int x = width - w - PANEL_PADDING;
  int y = panelTop();
  l.panel = new IntRect(x, y, w, height - y - PANEL_PADDING);
  l.titleY = y + PANEL_PADDING;
  int btnY = l.titleY + PANEL_TITLE_H + PANEL_SECTION_GAP;
  l.deselectBtn = new IntRect(x + PANEL_PADDING, btnY, 90, PANEL_BUTTON_H);
  l.newBtn = new IntRect(l.deselectBtn.x + l.deselectBtn.w + 8, btnY, 90, PANEL_BUTTON_H);
  return l;
}

public void populateZonesRows(ZonesListLayout layout) {
  layout.rows.clear();
  if (mapModel == null || mapModel.zones == null) return;
  int labelX = layout.panel.x + PANEL_PADDING;
  int startY = layout.newBtn.y + layout.newBtn.h + PANEL_SECTION_GAP;
  int maxY = layout.panel.y + layout.panel.h - PANEL_SECTION_GAP;
  int viewH = max(0, maxY - startY);
  int rowH = 28;
  int rowGap = 6;
  int hueW = 90;
  int totalRows = mapModel.zones.size();
  int contentH = (totalRows > 0) ? totalRows * (rowH + rowGap) - rowGap : 0;
  layout.rowsStartY = startY;
  layout.rowsViewH = viewH;
  layout.contentH = contentH;
  layout.scrollbar = new IntRect(layout.panel.x + layout.panel.w - SCROLLBAR_W, startY, SCROLLBAR_W, viewH);
  zonesListScroll = clampScroll(zonesListScroll, contentH, viewH);
  int curY = startY - round(zonesListScroll);

  for (int i = 0; i < totalRows; i++) {
    if (curY > maxY) break;
    if (curY + rowH < startY) {
      curY += rowH + rowGap;
      continue;
    }
    ZoneRowLayout row = new ZoneRowLayout();
    row.index = i;
    int selectW = 18;
    row.selectRect = new IntRect(labelX, curY, selectW, rowH);
    row.nameRect = new IntRect(labelX + selectW + 6, curY, layout.panel.w - 2 * PANEL_PADDING - SCROLLBAR_W - selectW - 6 - hueW - 8, rowH);
    int colorH = 6;
    row.colorRect = new IntRect(row.nameRect.x, row.nameRect.y + row.nameRect.h - colorH - 2, row.nameRect.w, colorH);
    row.hueSlider = new IntRect(row.nameRect.x + row.nameRect.w + 6, curY + (rowH - PANEL_SLIDER_H) / 2, hueW, PANEL_SLIDER_H);
    layout.rows.add(row);
    curY += rowH + rowGap;
  }
}

public void drawZonesListPanel() {
  ZonesListLayout layout = buildZonesListLayout();
  populateZonesRows(layout);
  drawPanelBackground(layout.panel);

  int labelX = layout.panel.x + PANEL_PADDING;
  int curY = layout.titleY;
  fill(0);
  textAlign(LEFT, TOP);
  text("Zones", labelX, curY);

  drawBevelButton(layout.newBtn.x, layout.newBtn.y, layout.newBtn.w, layout.newBtn.h, false);
  fill(10);
  textAlign(CENTER, CENTER);
  text("New zone", layout.newBtn.x + layout.newBtn.w / 2, layout.newBtn.y + layout.newBtn.h / 2);
  registerUiTooltip(layout.newBtn, tooltipFor("zones_list_new"));

  drawBevelButton(layout.deselectBtn.x, layout.deselectBtn.y, layout.deselectBtn.w, layout.deselectBtn.h, false);
  fill(10);
  textAlign(CENTER, CENTER);
  text("Deselect", layout.deselectBtn.x + layout.deselectBtn.w / 2, layout.deselectBtn.y + layout.deselectBtn.h / 2);
  registerUiTooltip(layout.deselectBtn, tooltipFor("structures_deselect"));
  registerUiTooltip(layout.deselectBtn, tooltipFor("zones_list_deselect"));

  if (mapModel == null || mapModel.zones == null) return;

  for (int i = 0; i < layout.rows.size(); i++) {
    ZoneRowLayout row = layout.rows.get(i);
    if (row.index < 0 || row.index >= mapModel.zones.size()) continue;
    MapModel.MapZone az = mapModel.zones.get(row.index);
    boolean selected = (activeZoneIndex == row.index);

    drawRadioButton(row.selectRect, selected);

    boolean editing = (editingZoneNameIndex == row.index);
    if (editing) {
      stroke(60);
      fill(255);
      rect(row.nameRect.x, row.nameRect.y, row.nameRect.w, row.nameRect.h);
      fill(0);
      textAlign(LEFT, CENTER);
      text(zoneNameDraft, row.nameRect.x + 6, row.nameRect.y + row.nameRect.h / 2);
      float caretX = row.nameRect.x + 6 + textWidth(zoneNameDraft);
      stroke(0);
      line(caretX, row.nameRect.y + 4, caretX, row.nameRect.y + row.nameRect.h - 4);
    } else {
      stroke(80);
      fill(az.col);
      rect(row.nameRect.x, row.nameRect.y, row.nameRect.w, row.nameRect.h, 4);
      float br = brightness(az.col);
      int txtCol = (br > 60) ? color(15) : color(245);
      fill(txtCol);
      textAlign(LEFT, CENTER);
      text(az.name, row.nameRect.x + 6, row.nameRect.y + row.nameRect.h / 2);
    }

    float hNorm = constrain(az.hue01, 0, 1);
    drawSlider(row.hueSlider, hNorm, "");
  }

  drawScrollbar(layout.scrollbar, layout.contentH, zonesListScroll);
}

public ZonesLayout buildZonesLayout() {
  ZonesLayout l = new ZonesLayout();
  l.panel = new IntRect(PANEL_X, panelTop(), PANEL_W, 0);
  int innerX = l.panel.x + PANEL_PADDING;
  int curY = l.panel.y + PANEL_PADDING;
  l.titleY = curY;
  curY += PANEL_TITLE_H + PANEL_SECTION_GAP;

  l.resetBtn = new IntRect(innerX, curY, 90, PANEL_BUTTON_H);
  l.regenerateBtn = new IntRect(l.resetBtn.x + l.resetBtn.w + 8, curY, 110, PANEL_BUTTON_H);
  curY += PANEL_BUTTON_H + PANEL_ROW_GAP;

  l.brushSlider = new IntRect(innerX, curY + PANEL_LABEL_H, 180, PANEL_SLIDER_H);
  curY += PANEL_LABEL_H + PANEL_SLIDER_H + PANEL_PADDING;

  l.excludeWaterBtn = new IntRect(innerX, curY, 110, PANEL_BUTTON_H);
  l.exclusiveBtn = new IntRect(l.excludeWaterBtn.x + l.excludeWaterBtn.w + 8, curY, 140, PANEL_BUTTON_H);
  curY += PANEL_BUTTON_H + PANEL_ROW_GAP;
  l.fourColorBtn = new IntRect(innerX, curY, 150, PANEL_BUTTON_H);
  curY += PANEL_BUTTON_H + PANEL_SECTION_GAP;

  l.commentField = new IntRect(innerX, curY + PANEL_LABEL_H, 200, PANEL_BUTTON_H);
  curY += PANEL_LABEL_H + PANEL_BUTTON_H + PANEL_SECTION_GAP;

  // Right-side list panel reserved space
  l.listPanel = new IntRect(width - RIGHT_PANEL_W - PANEL_PADDING, panelTop(), RIGHT_PANEL_W, height - panelTop() - PANEL_PADDING);

  curY += hintHeight(3);
  l.panel.h = curY - l.panel.y;
  return l;
}

public void drawZonesPanel() {
  ZonesLayout layout = buildZonesLayout();
  drawPanelBackground(layout.panel);

  int labelX = layout.panel.x + PANEL_PADDING;
  fill(0);
  textAlign(LEFT, TOP);
  text("Zones", labelX, layout.titleY);

  // Comment field (selected zone, single-line)
  {
    IntRect cf = layout.commentField;
    fill(0);
    textAlign(LEFT, BOTTOM);
    text("Comment", cf.x, cf.y - 4);
    stroke(80);
    fill(255);
    rect(cf.x, cf.y, cf.w, cf.h);
    fill(0);
    textAlign(LEFT, CENTER);
    String shown = "";
    if (activeZoneIndex >= 0 && activeZoneIndex < mapModel.zones.size()) {
      MapModel.MapZone z = mapModel.zones.get(activeZoneIndex);
      if (z != null && z.comment != null && !editingZoneComment) shown = z.comment;
      if (editingZoneComment) shown = zoneCommentDraft;
    }
    text(shown, cf.x + 6, cf.y + cf.h / 2);
    if (editingZoneComment) {
      float caretX = cf.x + 6 + textWidth(zoneCommentDraft);
      stroke(0);
      line(caretX, cf.y + 4, caretX, cf.y + cf.h - 4);
    }
  }

  // Reset and regenerate
  // Use explicit rectMode(CORNER) to avoid bleed from world draw state
  rectMode(CORNER);
  drawBevelButton(layout.resetBtn.x, layout.resetBtn.y, layout.resetBtn.w, layout.resetBtn.h, false);
  drawBevelButton(layout.regenerateBtn.x, layout.regenerateBtn.y, layout.regenerateBtn.w, layout.regenerateBtn.h, false);
  fill(10);
  textAlign(CENTER, CENTER);
  text("Reset", layout.resetBtn.x + layout.resetBtn.w * 0.5f, layout.resetBtn.y + layout.resetBtn.h * 0.5f);
  text("Regenerate", layout.regenerateBtn.x + layout.regenerateBtn.w * 0.5f, layout.regenerateBtn.y + layout.regenerateBtn.h * 0.5f);
  registerUiTooltip(layout.resetBtn, tooltipFor("zones_reset"));
  registerUiTooltip(layout.regenerateBtn, tooltipFor("zones_regenerate"));

  // Brush radius slider
  IntRect brush = layout.brushSlider;
  float bNorm = constrain(map(zoneBrushRadius, 0.01f, 0.15f, 0, 1), 0, 1);
  drawSlider(brush, bNorm, "Brush radius");
  registerUiTooltip(brush, tooltipFor("zones_brush"));

  drawControlsHint(layout.panel,
                   "left-click: paint or erase",
                   "right-click pan",
                   "wheel: zoom");

  // Zone helper buttons
  if (layout.excludeWaterBtn != null) {
    drawBevelButton(layout.excludeWaterBtn.x, layout.excludeWaterBtn.y, layout.excludeWaterBtn.w, layout.excludeWaterBtn.h, false);
    fill(10);
    textAlign(CENTER, CENTER);
    text("Exclude water", layout.excludeWaterBtn.x + layout.excludeWaterBtn.w / 2, layout.excludeWaterBtn.y + layout.excludeWaterBtn.h / 2);
    registerUiTooltip(layout.excludeWaterBtn, tooltipFor("zones_exclude_water"));
  }
  if (layout.exclusiveBtn != null) {
    drawBevelButton(layout.exclusiveBtn.x, layout.exclusiveBtn.y, layout.exclusiveBtn.w, layout.exclusiveBtn.h, false);
    fill(10);
    textAlign(CENTER, CENTER);
    text("Make exclusive", layout.exclusiveBtn.x + layout.exclusiveBtn.w / 2, layout.exclusiveBtn.y + layout.exclusiveBtn.h / 2);
    registerUiTooltip(layout.exclusiveBtn, tooltipFor("zones_exclusive"));
  }
  if (layout.fourColorBtn != null) {
    drawBevelButton(layout.fourColorBtn.x, layout.fourColorBtn.y, layout.fourColorBtn.w, layout.fourColorBtn.h, false);
    fill(10);
    textAlign(CENTER, CENTER);
    text("Four-color map", layout.fourColorBtn.x + layout.fourColorBtn.w / 2, layout.fourColorBtn.y + layout.fourColorBtn.h / 2);
    registerUiTooltip(layout.fourColorBtn, tooltipFor("zones_four_color"));
  }
}

// ----- PATHS PANEL -----

class PathsLayout {
  IntRect panel;
  int titleY;
  IntRect generateBtn;
  IntRect typeAddBtn;
  IntRect typeRemoveBtn;
  IntRect routeSlider;
  IntRect flattestSlider;
  IntRect avoidWaterCheck;
  IntRect eraserBtn;
  IntRect taperCheck;
  IntRect typeMinWeightSlider;
  ArrayList<IntRect> typeSwatches = new ArrayList<IntRect>();
  IntRect nameField;
  IntRect commentField;
  IntRect typeHueSlider;
  IntRect typeSatSlider;
  IntRect typeBriSlider;
  IntRect typeWeightSlider;
}

class PathsListLayout {
  IntRect panel;
  int titleY;
  IntRect newBtn;
  IntRect deselectBtn;
  ArrayList<PathRowLayout> rows = new ArrayList<PathRowLayout>();
  int rowsStartY;
  int rowsViewH;
  float contentH;
  IntRect scrollbar;
}

class PathRowLayout {
  int index;
  IntRect selectRect;
  IntRect nameRect;
  IntRect delRect;
  IntRect typeRect;
  int statsY;
  int statsH;
}

public PathsLayout buildPathsLayout() {
  PathsLayout l = new PathsLayout();
  l.panel = new IntRect(PANEL_X, panelTop(), PANEL_W, 0);
  int innerX = l.panel.x + PANEL_PADDING;
  int curY = l.panel.y + PANEL_PADDING;
  l.titleY = curY;
  curY += PANEL_TITLE_H + PANEL_SECTION_GAP;

  l.generateBtn = new IntRect(innerX, curY, 120, PANEL_BUTTON_H);
  curY += PANEL_BUTTON_H + PANEL_SECTION_GAP;

  // Path types controls
  l.typeAddBtn = new IntRect(innerX, curY, 24, PANEL_BUTTON_H);
  l.typeRemoveBtn = new IntRect(l.typeAddBtn.x + l.typeAddBtn.w + 6, curY, 24, PANEL_BUTTON_H);
  curY += PANEL_BUTTON_H + PANEL_ROW_GAP;

  int swatchW = 60;
  int swatchH = 18;
  int gapX = 8;
  int maxPerRow = max(1, (PANEL_W - 2 * PANEL_PADDING + gapX) / (swatchW + gapX));
  int rowY = curY;
  int col = 0;
  int paletteBottom = rowY;
  if (mapModel != null && mapModel.pathTypes != null) {
    for (int i = 0; i < mapModel.pathTypes.size(); i++) {
      int x = innerX + col * (swatchW + gapX);
      l.typeSwatches.add(new IntRect(x, rowY, swatchW, swatchH));
      paletteBottom = max(paletteBottom, rowY + swatchH);
      col++;
      if (col >= maxPerRow) {
        col = 0;
        rowY += swatchH + PANEL_ROW_GAP;
      }
    }
  }
  curY = paletteBottom + PANEL_ROW_GAP;

  l.nameField = new IntRect(innerX, curY + PANEL_LABEL_H, 200, PANEL_BUTTON_H);
  curY += PANEL_LABEL_H + PANEL_BUTTON_H + PANEL_SECTION_GAP;

  l.commentField = new IntRect(innerX, curY + PANEL_LABEL_H, 200, PANEL_BUTTON_H);
  curY += PANEL_LABEL_H + PANEL_BUTTON_H + PANEL_SECTION_GAP;

  l.typeHueSlider = new IntRect(innerX, curY + PANEL_LABEL_H, 200, PANEL_SLIDER_H);
  curY += PANEL_LABEL_H + PANEL_SLIDER_H + PANEL_SECTION_GAP;

  l.typeSatSlider = new IntRect(innerX, curY + PANEL_LABEL_H, 200, PANEL_SLIDER_H);
  curY += PANEL_LABEL_H + PANEL_SLIDER_H + PANEL_SECTION_GAP;

  l.typeBriSlider = new IntRect(innerX, curY + PANEL_LABEL_H, 200, PANEL_SLIDER_H);
  curY += PANEL_LABEL_H + PANEL_SLIDER_H + PANEL_SECTION_GAP;

  l.typeWeightSlider = new IntRect(innerX, curY + PANEL_LABEL_H, 180, PANEL_SLIDER_H);
  curY += PANEL_LABEL_H + PANEL_SLIDER_H + PANEL_ROW_GAP;

  l.typeMinWeightSlider = new IntRect(innerX, curY + PANEL_LABEL_H, 180, PANEL_SLIDER_H);
  curY += PANEL_LABEL_H + PANEL_SLIDER_H + PANEL_ROW_GAP;

  l.taperCheck = new IntRect(innerX, curY, PANEL_CHECK_SIZE, PANEL_CHECK_SIZE);
  curY += PANEL_CHECK_SIZE + PANEL_PADDING;

  int sliderW = 200;
  l.routeSlider = new IntRect(innerX, curY + PANEL_LABEL_H, sliderW, PANEL_SLIDER_H);
  curY += PANEL_LABEL_H + PANEL_SLIDER_H + PANEL_SECTION_GAP;

  l.flattestSlider = new IntRect(innerX, curY + PANEL_LABEL_H, sliderW, PANEL_SLIDER_H);
  curY += PANEL_LABEL_H + PANEL_SLIDER_H + PANEL_SECTION_GAP;

  l.avoidWaterCheck = new IntRect(innerX, curY, PANEL_CHECK_SIZE, PANEL_CHECK_SIZE);
  curY += PANEL_CHECK_SIZE + PANEL_ROW_GAP;

  l.eraserBtn = new IntRect(innerX, curY, 90, PANEL_BUTTON_H);
  curY += PANEL_BUTTON_H + PANEL_SECTION_GAP;

  curY += hintHeight(5);
  l.panel.h = curY - l.panel.y;
  return l;
}

public PathsListLayout buildPathsListLayout() {
  PathsListLayout l = new PathsListLayout();
  int w = RIGHT_PANEL_W;
  int x = width - w - PANEL_PADDING;
  int y = panelTop();
  l.panel = new IntRect(x, y, w, height - y - PANEL_PADDING);
  l.titleY = y + PANEL_PADDING;
  int newBtnY = l.titleY + PANEL_TITLE_H + PANEL_SECTION_GAP;
  l.newBtn = new IntRect(x + PANEL_PADDING, newBtnY, 90, PANEL_BUTTON_H);
  l.deselectBtn = new IntRect(l.newBtn.x + l.newBtn.w + 8, newBtnY, 90, PANEL_BUTTON_H);
  return l;
}

public void populatePathsListRows(PathsListLayout layout) {
  layout.rows.clear();
  int labelX = layout.panel.x + PANEL_PADDING;
  int startY = layout.newBtn.y + layout.newBtn.h + PANEL_SECTION_GAP;
  int maxY = layout.panel.y + layout.panel.h - PANEL_SECTION_GAP;
  int viewH = max(0, maxY - startY);

  int textH = ceil(textAscent() + textDescent());
  int nameH = max(PANEL_LABEL_H + 6, textH + 8);
  int typeH = max(PANEL_LABEL_H + 2, textH + 6);
  int statsH = max(PANEL_LABEL_H, textH);
  int rowGap = 10;
  int rowTotal = nameH + 6 + typeH + 4 + statsH + rowGap;
  int totalRows = (mapModel != null && mapModel.paths != null) ? mapModel.paths.size() : 0;
  int contentH = (totalRows > 0) ? totalRows * rowTotal : 0;

  layout.rowsStartY = startY;
  layout.rowsViewH = viewH;
  layout.contentH = contentH;
  layout.scrollbar = new IntRect(layout.panel.x + layout.panel.w - SCROLLBAR_W, startY, SCROLLBAR_W, viewH);
  pathsListScroll = clampScroll(pathsListScroll, contentH, viewH);

  int curY = startY - round(pathsListScroll);

  for (int i = 0; i < totalRows; i++) {
    if (curY > maxY) break;
    if (curY + rowTotal < startY) {
      curY += rowTotal;
      continue;
    }

    int selectSize = max(16, nameH - 2);
    PathRowLayout row = new PathRowLayout();
    row.index = i;
    row.selectRect = new IntRect(labelX, curY, selectSize, selectSize);
    row.nameRect = new IntRect(row.selectRect.x + row.selectRect.w + 6, curY,
                               layout.panel.w - 2 * PANEL_PADDING - SCROLLBAR_W - row.selectRect.w - 6 - 40,
                               nameH);
    row.delRect = new IntRect(row.nameRect.x + row.nameRect.w + 6, curY, 30, nameH);

    curY += nameH + 6;

    row.typeRect = new IntRect(labelX + selectSize + 6, curY, 160, typeH);
    curY += typeH + 4;

    row.statsY = curY;
    row.statsH = statsH;
    curY += statsH + rowGap;

    layout.rows.add(row);
  }
}

public void drawPathsPanel() {
  PathsLayout layout = buildPathsLayout();
  drawPanelBackground(layout.panel);

  int labelX = layout.panel.x + PANEL_PADDING;
  fill(0);
  textAlign(LEFT, TOP);
  text("Paths", labelX, layout.titleY);

  // Comment for selected path (single-line for now)
  {
    IntRect cf = layout.commentField;
    fill(0);
    textAlign(LEFT, BOTTOM);
    text("Comment", cf.x, cf.y - 4);
    stroke(80);
    fill(255);
    rect(cf.x, cf.y, cf.w, cf.h);
    fill(0);
    textAlign(LEFT, CENTER);
    String shown = "";
    if (selectedPathIndex >= 0 && selectedPathIndex < mapModel.paths.size()) {
      Path p = mapModel.paths.get(selectedPathIndex);
      if (p != null && p.comment != null && editingPathCommentIndex != selectedPathIndex) shown = p.comment;
      if (editingPathCommentIndex == selectedPathIndex) shown = pathCommentDraft;
    }
    text(shown, cf.x + 6, cf.y + cf.h / 2);
    if (editingPathCommentIndex == selectedPathIndex) {
      float caretX = cf.x + 6 + textWidth(pathCommentDraft);
      stroke(0);
      line(caretX, cf.y + 4, caretX, cf.y + cf.h - 4);
    }
  }

  // Route mode slider (discrete)
  IntRect rs = layout.routeSlider;
  String[] modes = { "Ends", "Pathfind" };
  int modeCount = modes.length;
  float tRoute = constrain(pathRouteModeIndex / max(1.0f, modeCount - 1.0f), 0, 1);
  drawSelectorSlider(rs, tRoute, "Route mode: " + modes[pathRouteModeIndex], modeCount);
  registerUiTooltip(rs, tooltipFor("paths_route_mode"));

  // Flattest bias slider (only relevant for Flattest mode)
  IntRect fs = layout.flattestSlider;
  float fNorm = constrain(map(flattestSlopeBias, FLATTEST_BIAS_MIN, FLATTEST_BIAS_MAX, 0, 1), 0, 1);
  drawSlider(fs, fNorm, "Flattest slope bias (" + nf(flattestSlopeBias, 1, 2) + ")");
  registerUiTooltip(fs, tooltipFor("paths_flattest"));

  // Avoid water checkbox
  drawCheckbox(layout.avoidWaterCheck.x, layout.avoidWaterCheck.y,
               layout.avoidWaterCheck.w, pathAvoidWater, "Avoid water");
  registerUiTooltip(layout.avoidWaterCheck, tooltipFor("paths_avoid_water"));
  drawBevelButton(layout.eraserBtn.x, layout.eraserBtn.y, layout.eraserBtn.w, layout.eraserBtn.h, pathEraserMode);
  fill(10);
  textAlign(CENTER, CENTER);
  text("Eraser", layout.eraserBtn.x + layout.eraserBtn.w / 2, layout.eraserBtn.y + layout.eraserBtn.h / 2);
  registerUiTooltip(layout.eraserBtn, tooltipFor("paths_eraser"));

  // Generate button
  drawBevelButton(layout.generateBtn.x, layout.generateBtn.y, layout.generateBtn.w, layout.generateBtn.h, false);
  fill(10);
  textAlign(CENTER, CENTER);
  text("Generate", layout.generateBtn.x + layout.generateBtn.w / 2, layout.generateBtn.y + layout.generateBtn.h / 2);
  registerUiTooltip(layout.generateBtn, tooltipFor("paths_generate"));

  // Generate button
  drawBevelButton(layout.generateBtn.x, layout.generateBtn.y, layout.generateBtn.w, layout.generateBtn.h, false);
  fill(10);
  textAlign(CENTER, CENTER);
  text("Generate", layout.generateBtn.x + layout.generateBtn.w / 2, layout.generateBtn.y + layout.generateBtn.h / 2);
  registerUiTooltip(layout.generateBtn, tooltipFor("paths_generate"));

  // Only type management on this panel

  // Path types add/remove
  drawBevelButton(layout.typeAddBtn.x, layout.typeAddBtn.y, layout.typeAddBtn.w, layout.typeAddBtn.h, false);
  drawBevelButton(layout.typeRemoveBtn.x, layout.typeRemoveBtn.y, layout.typeRemoveBtn.w, layout.typeRemoveBtn.h, false);
  fill(10);
  textAlign(CENTER, CENTER);
  text("+", layout.typeAddBtn.x + layout.typeAddBtn.w / 2, layout.typeAddBtn.y + layout.typeAddBtn.h / 2);
  text("-", layout.typeRemoveBtn.x + layout.typeRemoveBtn.w / 2, layout.typeRemoveBtn.y + layout.typeRemoveBtn.h / 2);
  registerUiTooltip(layout.typeAddBtn, tooltipFor("paths_type_add"));
  registerUiTooltip(layout.typeRemoveBtn, tooltipFor("paths_type_remove"));

  // Path type palette
  if (mapModel == null || mapModel.pathTypes == null) return;
  int n = mapModel.pathTypes.size();
  if (n == 0) return;

  for (int i = 0; i < n; i++) {
    pushStyle();
    PathType pt = mapModel.pathTypes.get(i);
    IntRect sw = layout.typeSwatches.get(i);
    stroke(i == activePathTypeIndex ? 0 : 120);
    strokeWeight(i == activePathTypeIndex ? 2 : 1);
    fill(pt.col);
    rect(sw.x, sw.y, sw.w, sw.h, 4);

    fill(20);
    textAlign(CENTER, CENTER);
    text(pt.name, sw.x + sw.w * 0.5f, sw.y + sw.h * 0.5f);
    registerUiTooltip(sw, tooltipFor("paths_palette"));
    popStyle();
  }

  // Color (hue) slider for active path type
  if (activePathTypeIndex >= 0 && activePathTypeIndex < n) {
    PathType active = mapModel.pathTypes.get(activePathTypeIndex);
    // Editable name field
    IntRect nf = layout.nameField;
    boolean editing = (editingPathTypeNameIndex == activePathTypeIndex);
    fill(0);
    textAlign(LEFT, BOTTOM);
    text("Name", nf.x, nf.y - 4);
    stroke(80);
    fill(255);
    rect(nf.x, nf.y, nf.w, nf.h);
    fill(0);
    textAlign(LEFT, CENTER);
    String shown = editing ? pathTypeNameDraft : active.name;
    text(shown, nf.x + 6, nf.y + nf.h / 2);
    if (editing) {
      float caretX = nf.x + 6 + textWidth(pathTypeNameDraft);
      stroke(0);
      line(caretX, nf.y + 4, caretX, nf.y + nf.h - 4);
    }
    registerUiTooltip(nf, tooltipFor("paths_type_name"));

    IntRect hue = layout.typeHueSlider;
    float hNorm = constrain(active.hue01, 0, 1);
    drawSlider(hue, hNorm, "Hue for \"" + active.name + "\": " + nf(active.hue01, 1, 2));

    IntRect sat = layout.typeSatSlider;
    float sNorm = constrain(active.sat01, 0, 1);
    drawSlider(sat, sNorm, "Saturation for \"" + active.name + "\"");

    IntRect bri = layout.typeBriSlider;
    float bNorm = constrain(active.bri01, 0, 1);
    drawSlider(bri, bNorm, "Brightness for \"" + active.name + "\"");

    // Weight slider per type
    IntRect weight = layout.typeWeightSlider;
    float wNorm = constrain(map(active.weightPx, 0.5f, 8.0f, 0, 1), 0, 1);
    drawSlider(weight, wNorm, "Weight for \"" + active.name + "\" (px)");
    registerUiTooltip(weight, tooltipFor("paths_type_weight"));

  // Min weight slider per type
  IntRect minw = layout.typeMinWeightSlider;
    float minNorm;
    if (abs(active.weightPx - 0.5f) < 1e-6f) {
      minNorm = 0; // avoid map() divide-by-zero when range collapses
    } else {
      minNorm = constrain(map(active.minWeightPx, 0.5f, active.weightPx, 0, 1), 0, 1);
    }
    drawSlider(minw, minNorm, "Min weight (px)");
    registerUiTooltip(minw, tooltipFor("paths_min_weight"));

  // Taper toggle per type
  drawCheckbox(layout.taperCheck.x, layout.taperCheck.y,
               layout.taperCheck.w, active.taperOn, "Taper water");
  registerUiTooltip(layout.taperCheck, tooltipFor("paths_taper"));
  }

  drawControlsHint(layout.panel,
                   "left-click: start/end",
                   "DEL: cancels",
                   "right-click: pan",
                   "wheel: zoom",
                   "C: clear");
}

public void drawPathsListPanel() {
  PathsListLayout layout = buildPathsListLayout();
  populatePathsListRows(layout);
  drawPanelBackground(layout.panel);

  int labelX = layout.panel.x + PANEL_PADDING;
  int curY = layout.titleY;
  fill(0);
  textAlign(LEFT, TOP);
  text("Paths list", labelX, curY);
  curY += PANEL_TITLE_H + PANEL_SECTION_GAP;

  if (mapModel.paths.isEmpty()) {
    fill(80);
    textAlign(LEFT, TOP);
    text("No paths yet.", labelX, curY);
  } else {
  for (int i = 0; i < layout.rows.size(); i++) {
    PathRowLayout row = layout.rows.get(i);
    if (row.index < 0 || row.index >= mapModel.paths.size()) continue;
    Path p = mapModel.paths.get(row.index);

    boolean selected = (selectedPathIndex == row.index);
    drawRadioButton(row.selectRect, selected);

      boolean editing = (editingPathNameIndex == row.index);
      if (editing) {
        stroke(60);
        fill(255);
        rect(row.nameRect.x, row.nameRect.y, row.nameRect.w, row.nameRect.h);
        fill(0);
        textAlign(LEFT, CENTER);
        String shown = pathNameDraft;
        text(shown, row.nameRect.x + 6, row.nameRect.y + row.nameRect.h / 2);
        float caretX = row.nameRect.x + 6 + textWidth(shown);
        stroke(0);
        line(caretX, row.nameRect.y + 4, caretX, row.nameRect.y + row.nameRect.h - 4);
      } else {
        drawBevelButton(row.nameRect.x, row.nameRect.y, row.nameRect.w, row.nameRect.h, selected);
        fill(10);
        textAlign(LEFT, CENTER);
        String title = (p.name != null && p.name.length() > 0 ? p.name : "Path");
        text("#" + (row.index + 1) + " " + title, row.nameRect.x + 6, row.nameRect.y + row.nameRect.h / 2);
      }

      drawBevelButton(row.delRect.x, row.delRect.y, row.delRect.w, row.delRect.h, false);
      fill(10);
      textAlign(CENTER, CENTER);
      text("X", row.delRect.x + row.delRect.w / 2, row.delRect.y + row.delRect.h / 2);

      PathType pt = mapModel.getPathType(p.typeId);
      String typLabel = (pt != null ? pt.name : "Type");
      int typeCol = (pt != null) ? pt.col : color(180);
      stroke(80);
      fill(typeCol);
      rect(row.typeRect.x, row.typeRect.y, row.typeRect.w, row.typeRect.h, 4);
      fill(255);
      textAlign(CENTER, CENTER);
      text(typLabel, row.typeRect.x + row.typeRect.w * 0.5f, row.typeRect.y + row.typeRect.h * 0.5f);

      int segs = p.segmentCount();
      float len = p.totalLength();
      fill(40);
      textAlign(LEFT, CENTER);
      text("Segments: " + segs + "   Len: " + nf(len, 1, 3),
           labelX + row.selectRect.w + 6, row.statsY + row.statsH / 2);
    }
  }

  drawScrollbar(layout.scrollbar, layout.contentH, pathsListScroll);

  drawBevelButton(layout.newBtn.x, layout.newBtn.y, layout.newBtn.w, layout.newBtn.h, false);
  drawBevelButton(layout.deselectBtn.x, layout.deselectBtn.y, layout.deselectBtn.w, layout.deselectBtn.h, false);
  fill(10);
  textAlign(CENTER, CENTER);
  text("New Path", layout.newBtn.x + layout.newBtn.w / 2, layout.newBtn.y + layout.newBtn.h / 2);
  text("Deselect", layout.deselectBtn.x + layout.deselectBtn.w / 2, layout.deselectBtn.y + layout.deselectBtn.h / 2);
  registerUiTooltip(layout.newBtn, tooltipFor("paths_list_new"));
  registerUiTooltip(layout.deselectBtn, tooltipFor("paths_list_deselect"));
}

// ----- ELEVATION PANEL -----

class ElevationLayout {
  IntRect panel;
  int titleY;
  IntRect seaSlider;
  IntRect radiusSlider;
  IntRect strengthSlider;
  IntRect raiseBtn;
  IntRect lowerBtn;
  IntRect noiseSlider;
  IntRect perlinBtn;
  IntRect varyBtn;
  IntRect plateauBtn;
}

public ElevationLayout buildElevationLayout() {
  ElevationLayout l = new ElevationLayout();
  l.panel = new IntRect(PANEL_X, panelTop(), PANEL_W, 0);
  int innerX = l.panel.x + PANEL_PADDING;
  int curY = l.panel.y + PANEL_PADDING;
  l.titleY = curY;
  curY += PANEL_TITLE_H + PANEL_SECTION_GAP;

  int genW = 120;
  l.perlinBtn = new IntRect(innerX, curY, genW, PANEL_BUTTON_H);
  l.varyBtn = new IntRect(l.perlinBtn.x + genW + 8, curY, genW, PANEL_BUTTON_H);
  curY += PANEL_BUTTON_H + PANEL_ROW_GAP;
  l.plateauBtn = new IntRect(innerX, curY, genW, PANEL_BUTTON_H);
  curY += PANEL_BUTTON_H + PANEL_SECTION_GAP;

  int sliderW = 200;
  l.seaSlider = new IntRect(innerX, curY + PANEL_LABEL_H, sliderW, PANEL_SLIDER_H);
  curY += PANEL_LABEL_H + PANEL_SLIDER_H + PANEL_ROW_GAP;

  l.radiusSlider = new IntRect(innerX, curY + PANEL_LABEL_H, sliderW, PANEL_SLIDER_H);
  curY += PANEL_LABEL_H + PANEL_SLIDER_H + PANEL_ROW_GAP;

  l.strengthSlider = new IntRect(innerX, curY + PANEL_LABEL_H, sliderW, PANEL_SLIDER_H);
  curY += PANEL_LABEL_H + PANEL_SLIDER_H + PANEL_ROW_GAP;

  l.raiseBtn = new IntRect(innerX, curY, 80, PANEL_BUTTON_H);
  l.lowerBtn = new IntRect(l.raiseBtn.x + l.raiseBtn.w + 8, curY, 80, PANEL_BUTTON_H);
  curY += PANEL_BUTTON_H + PANEL_SECTION_GAP;

  l.noiseSlider = new IntRect(innerX, curY + PANEL_LABEL_H, sliderW, PANEL_SLIDER_H);
  curY += PANEL_LABEL_H + PANEL_SLIDER_H + PANEL_PADDING;

  curY += hintHeight(3);
  l.panel.h = curY - l.panel.y;
  return l;
}

public void drawElevationPanel() {
  ElevationLayout layout = buildElevationLayout();
  drawPanelBackground(layout.panel);

  int labelX = layout.panel.x + PANEL_PADDING;
  fill(0);
  textAlign(LEFT, TOP);
  text("Elevation", labelX, layout.titleY);

  // Sea level slider (-0.5 .. 0.5)
  IntRect sea = layout.seaSlider;
  float seaNorm = constrain(map(seaLevel, -1.2f, 1.2f, 0, 1), 0, 1);
  drawSlider(sea, seaNorm, "Water level: " + nf(seaLevel, 1, 2), true);
  registerUiTooltip(sea, tooltipFor("elevation_water_level"));

  // Brush radius slider (0.01..0.2)
  IntRect rad = layout.radiusSlider;
  float rNorm = constrain(map(elevationBrushRadius, 0.01f, 0.2f, 0, 1), 0, 1);
  drawSlider(rad, rNorm, "Brush radius");
  registerUiTooltip(rad, tooltipFor("elevation_brush_radius"));

  // Brush strength slider (0.005..0.2)
  IntRect str = layout.strengthSlider;
  float sNorm = constrain(map(elevationBrushStrength, 0.005f, 0.2f, 0, 1), 0, 1);
  drawSlider(str, sNorm, "Brush strength");
  registerUiTooltip(str, tooltipFor("elevation_brush_strength"));

  // Raise / Lower buttons
  drawBevelButton(layout.raiseBtn.x, layout.raiseBtn.y, layout.raiseBtn.w, layout.raiseBtn.h, elevationBrushRaise);
  drawBevelButton(layout.lowerBtn.x, layout.lowerBtn.y, layout.lowerBtn.w, layout.lowerBtn.h, !elevationBrushRaise);
  fill(10);
  textAlign(CENTER, CENTER);
  text("Raise", layout.raiseBtn.x + layout.raiseBtn.w / 2, layout.raiseBtn.y + layout.raiseBtn.h / 2);
  text("Lower", layout.lowerBtn.x + layout.lowerBtn.w / 2, layout.lowerBtn.y + layout.lowerBtn.h / 2);
  registerUiTooltip(layout.raiseBtn, tooltipFor("elevation_raise"));
  registerUiTooltip(layout.lowerBtn, tooltipFor("elevation_lower"));

  // Noise controls stacked
  IntRect noise = layout.noiseSlider;
  float nNorm = constrain(map(elevationNoiseScale, 1.0f, 12.0f, 0, 1), 0, 1);
  drawSlider(noise, nNorm, "Noise scale");
  registerUiTooltip(noise, tooltipFor("elevation_noise"));

  drawBevelButton(layout.perlinBtn.x, layout.perlinBtn.y, layout.perlinBtn.w, layout.perlinBtn.h, false);
  drawBevelButton(layout.varyBtn.x, layout.varyBtn.y, layout.varyBtn.w, layout.varyBtn.h, false);
  drawBevelButton(layout.plateauBtn.x, layout.plateauBtn.y, layout.plateauBtn.w, layout.plateauBtn.h, false);
  fill(10);
  textAlign(CENTER, CENTER);
  text("Generate", layout.perlinBtn.x + layout.perlinBtn.w / 2, layout.perlinBtn.y + layout.perlinBtn.h / 2);
  text("Vary", layout.varyBtn.x + layout.varyBtn.w / 2, layout.varyBtn.y + layout.varyBtn.h / 2);
  text("Make plateaux", layout.plateauBtn.x + layout.plateauBtn.w / 2, layout.plateauBtn.y + layout.plateauBtn.h / 2);
  registerUiTooltip(layout.perlinBtn, tooltipFor("elevation_generate_perlin"));
  registerUiTooltip(layout.varyBtn, tooltipFor("elevation_vary"));
  registerUiTooltip(layout.plateauBtn, tooltipFor("elevation_plateau"));

  drawControlsHint(layout.panel,
                   "left-click: raise/lower",
                   "right-click: pan",
                   "wheel: zoom");
}


public String structureShapeLabel(StructureShape sh) {
  switch (sh) {
    case RECTANGLE: return "Rect";
    case CIRCLE: return "Circle";
    case TRIANGLE: return "Triangle";
    case HEXAGON: return "Hex";
    default: return "Rect";
  }
}

public String structureAlignmentLabel(StructureSnapMode mode) {
  switch (mode) {
    case NONE: return "None";
    case ON_PATH: return "Center";
    default: return "Next";
  }
}

// ----- STRUCTURES PANEL -----
class StructuresLayout {
  IntRect panel;
  int titleY;
  IntRect headerGen;
  IntRect headerSnap;
  IntRect headerAttr;
  ArrayList<IntRect> snapChecks = new ArrayList<IntRect>();
  IntRect snapElevationSlider;
  IntRect nameField;
  IntRect commentField;
  IntRect sizeSlider;
  IntRect angleSlider;
  IntRect ratioSlider;
  IntRect shapeSelector;
  IntRect alignmentSelector;
  IntRect hueSlider;
  IntRect alphaSlider;
  IntRect satSlider;
  IntRect strokeSlider;
  IntRect genTownSlider;
  IntRect genBuildingSlider;
  IntRect genButton;
}

public StructuresLayout buildStructuresLayout() {
  StructuresLayout l = new StructuresLayout();
  l.panel = new IntRect(PANEL_X, panelTop(), PANEL_W, 0);
  int innerX = l.panel.x + PANEL_PADDING;
  int curY = l.panel.y + PANEL_PADDING;
  int fullW = l.panel.w - 2 * PANEL_PADDING;
  l.titleY = curY;
  curY += PANEL_TITLE_H + PANEL_SECTION_GAP;

  // Generate section
  l.headerGen = new IntRect(innerX, curY, fullW, PANEL_TITLE_H);
  curY += PANEL_TITLE_H + PANEL_ROW_GAP;
  if (structSectionGenOpen) {
    l.genButton = new IntRect(innerX, curY, 140, PANEL_BUTTON_H);
    curY += PANEL_BUTTON_H + PANEL_ROW_GAP;
    l.genTownSlider = new IntRect(innerX, curY + PANEL_LABEL_H, fullW, PANEL_SLIDER_H);
    curY += PANEL_LABEL_H + PANEL_SLIDER_H + PANEL_ROW_GAP;
    l.genBuildingSlider = new IntRect(innerX, curY + PANEL_LABEL_H, fullW, PANEL_SLIDER_H);
    curY += PANEL_LABEL_H + PANEL_SLIDER_H + PANEL_SECTION_GAP;
  }

  // Snap section
  l.headerSnap = new IntRect(innerX, curY, fullW, PANEL_TITLE_H);
  curY += PANEL_TITLE_H + PANEL_ROW_GAP;
  if (structSectionSnapOpen) {
    String[] snapLabels = {
      "Water",
      "Biomes",
      "Underwater biomes",
      "Zones",
      "Paths",
      "Other structures",
      "Elevation"
    };
    for (int i = 0; i < snapLabels.length; i++) {
      l.snapChecks.add(new IntRect(innerX, curY, PANEL_CHECK_SIZE, PANEL_CHECK_SIZE));
      curY += PANEL_CHECK_SIZE + PANEL_ROW_GAP;
    }
    l.snapElevationSlider = new IntRect(innerX + PANEL_CHECK_SIZE + 8, curY + PANEL_LABEL_H, 160, PANEL_SLIDER_H);
    curY += PANEL_LABEL_H + PANEL_SLIDER_H + PANEL_SECTION_GAP;
  }

  // Attributes section
  l.headerAttr = new IntRect(innerX, curY, fullW, PANEL_TITLE_H);
  curY += PANEL_TITLE_H + PANEL_ROW_GAP;
  if (structSectionAttrOpen) {
    l.nameField = new IntRect(innerX, curY + PANEL_LABEL_H, fullW, PANEL_BUTTON_H);
    curY += PANEL_LABEL_H + PANEL_BUTTON_H + PANEL_ROW_GAP;

    l.commentField = new IntRect(innerX, curY + PANEL_LABEL_H, fullW, PANEL_BUTTON_H);
    curY += PANEL_LABEL_H + PANEL_BUTTON_H + PANEL_ROW_GAP;

    l.sizeSlider = new IntRect(innerX, curY + PANEL_LABEL_H, fullW, PANEL_SLIDER_H);
    curY += PANEL_LABEL_H + PANEL_SLIDER_H + PANEL_ROW_GAP;

    l.angleSlider = new IntRect(innerX, curY + PANEL_LABEL_H, fullW, PANEL_SLIDER_H);
    curY += PANEL_LABEL_H + PANEL_SLIDER_H + PANEL_ROW_GAP;

    l.ratioSlider = new IntRect(innerX, curY + PANEL_LABEL_H, fullW, PANEL_SLIDER_H);
    curY += PANEL_LABEL_H + PANEL_SLIDER_H + PANEL_SECTION_GAP;

    l.shapeSelector = new IntRect(innerX, curY + PANEL_LABEL_H, fullW, PANEL_SLIDER_H);
    curY += PANEL_LABEL_H + PANEL_SLIDER_H + PANEL_ROW_GAP;

    l.alignmentSelector = new IntRect(innerX, curY + PANEL_LABEL_H, fullW, PANEL_SLIDER_H);
    curY += PANEL_LABEL_H + PANEL_SLIDER_H + PANEL_SECTION_GAP;

    l.hueSlider = new IntRect(innerX, curY + PANEL_LABEL_H, fullW, PANEL_SLIDER_H);
    curY += PANEL_LABEL_H + PANEL_SLIDER_H + PANEL_ROW_GAP;

    l.satSlider = new IntRect(innerX, curY + PANEL_LABEL_H, fullW, PANEL_SLIDER_H);
    curY += PANEL_LABEL_H + PANEL_SLIDER_H + PANEL_ROW_GAP;

    l.alphaSlider = new IntRect(innerX, curY + PANEL_LABEL_H, fullW, PANEL_SLIDER_H);
    curY += PANEL_LABEL_H + PANEL_SLIDER_H + PANEL_ROW_GAP;

    l.strokeSlider = new IntRect(innerX, curY + PANEL_LABEL_H, fullW, PANEL_SLIDER_H);
    curY += PANEL_LABEL_H + PANEL_SLIDER_H + PANEL_SECTION_GAP;
  }

  curY += hintHeight(3);
  l.panel.h = curY - l.panel.y;
  return l;
}

public void drawStructuresPanelUI() {
  StructuresLayout layout = buildStructuresLayout();
  drawPanelBackground(layout.panel);

  int labelX = layout.panel.x + PANEL_PADDING;
  StructureSelectionInfo info = gatherStructureSelectionInfo();
  fill(0);
  textAlign(LEFT, TOP);
  text("Structures", labelX, layout.titleY);

  // Generate section
  drawSectionHeader(layout.headerGen, "Generate", structSectionGenOpen);
  if (structSectionGenOpen) {
    {
      IntRect gb = layout.genButton;
      drawBevelButton(gb.x, gb.y, gb.w, gb.h, false);
      fill(10);
      textAlign(CENTER, CENTER);
      text("Generate", gb.x + gb.w / 2, gb.y + gb.h / 2);
    }
    IntRect ts = layout.genTownSlider;
    float tNorm = constrain(structGenTownCount / 8.0f, 0, 1);
    drawSlider(ts, tNorm, "Circle count (" + structGenTownCount + ")");
    IntRect bs = layout.genBuildingSlider;
    drawSlider(bs, structGenBuildingDensity, "Rectangle density (" + nf(structGenBuildingDensity * 100, 1, 0) + "%)");
  }

  // Snapping guides
  drawSectionHeader(layout.headerSnap, "Snapping guides", structSectionSnapOpen);
  if (structSectionSnapOpen) {
    String[] labels = {
      "Water",
      "Biomes",
      "Underwater biomes",
      "Zones",
      "Paths",
      "Other structures",
      "Elevation"
    };
    String[] snapKeys = {
      "snap_water",
      "snap_biomes",
      "snap_underwater_biomes",
      "snap_zones",
      "snap_paths",
      "snap_structures",
      "snap_elevation"
    };
    boolean[] values = {
      snapWaterEnabled,
      snapBiomesEnabled,
      snapUnderwaterBiomesEnabled,
      snapZonesEnabled,
      snapPathsEnabled,
      snapStructuresEnabled,
      snapElevationEnabled
    };
    for (int i = 0; i < labels.length && i < layout.snapChecks.size(); i++) {
      IntRect b = layout.snapChecks.get(i);
      drawCheckbox(b.x, b.y, b.w, values[i], labels[i]);
      if (i < snapKeys.length) {
        int hintW = layout.panel.w - 2 * PANEL_PADDING;
        registerUiTooltip(new IntRect(b.x, b.y, hintW, b.h), tooltipFor(snapKeys[i]));
      }
    }

    IntRect es = layout.snapElevationSlider;
    int divMin = 2;
    int divMax = 24;
    float t = constrain((snapElevationDivisions - divMin) / (float)(divMax - divMin), 0, 1);
    drawSlider(es, t, "Elevation divisions: " + snapElevationDivisions);
    registerUiTooltip(es, tooltipFor("snap_elevation_divisions"));
  }

  // Attributes section
  drawSectionHeader(layout.headerAttr, "Attributes", structSectionAttrOpen);
  if (!structSectionAttrOpen) return;
  // Name field
  {
    IntRect nf = layout.nameField;
    fill(0);
    textAlign(LEFT, BOTTOM);
    text("Name", nf.x, nf.y - 4);
    stroke(80);
    fill(255);
    rect(nf.x, nf.y, nf.w, nf.h);
    fill(0);
    textAlign(LEFT, CENTER);
    String shownName = (info.nameMixed && !editingStructureName) ? "" : structureNameDraft;
    if (!info.hasSelection && !editingStructureName) shownName = structureNameDraft;
    if (info.hasSelection && !info.nameMixed && !editingStructureName) shownName = info.sharedName;
    text(shownName, nf.x + 6, nf.y + nf.h / 2);
    if (editingStructureName) {
      float caretX = nf.x + 6 + textWidth(structureNameDraft);
      stroke(0);
      line(caretX, nf.y + 4, caretX, nf.y + nf.h - 4);
    }
    registerUiTooltip(nf, tooltipFor("structures_detail_name"));
  }

  // Comment field (single-line for now)
  {
    IntRect cf = layout.commentField;
    fill(0);
    textAlign(LEFT, BOTTOM);
    text("Comment", cf.x, cf.y - 4);
    stroke(80);
    fill(255);
    rect(cf.x, cf.y, cf.w, cf.h);
    fill(0);
    textAlign(LEFT, CENTER);
    String shown = "";
    if (info.hasSelection && !info.commentMixed && !editingStructureComment) {
      shown = info.sharedComment;
    } else if (editingStructureComment) {
      shown = structureCommentDraft;
    }
    text(shown, cf.x + 6, cf.y + cf.h / 2);
    if (editingStructureComment) {
      float caretX = cf.x + 6 + textWidth(structureCommentDraft);
      stroke(0);
      line(caretX, cf.y + 4, caretX, cf.y + cf.h - 4);
    }
  }

  // Size slider
  IntRect sz = layout.sizeSlider;
  float sNorm = constrain(map(info.sharedSize, 0.01f, 0.2f, 0, 1), 0, 1);
  String sizeLabel = info.sizeMixed ? "Size" : "Size (" + nf(info.sharedSize, 1, 3) + ")";
  drawSlider(sz, sNorm, sizeLabel, false, !info.sizeMixed);
  registerUiTooltip(sz, tooltipFor("structures_size"));

  // Angle slider (-180..180 deg)
  IntRect ang = layout.angleSlider;
  float angDeg = degrees(info.sharedAngleRad);
  float aNorm = constrain(map(angDeg, -180.0f, 180.0f, 0, 1), 0, 1);
  String angLabel = info.angleMixed ? "Angle" : "Angle (" + nf(angDeg, 1, 1) + " deg)";
  drawSlider(ang, aNorm, angLabel, true, !info.angleMixed);
  registerUiTooltip(ang, tooltipFor("structures_angle"));

  // Rectangle ratio slider (width/height)
  IntRect ratio = layout.ratioSlider;
  float rNorm = constrain(map(info.sharedRatio, 0.3f, 3.0f, 0, 1), 0, 1);
  String ratioLabel = info.ratioMixed ? "Aspect ratio (W/H)" : "Aspect ratio (W/H): " + nf(info.sharedRatio, 1, 2);
  drawSlider(ratio, rNorm, ratioLabel, false, !info.ratioMixed);
  registerUiTooltip(ratio, tooltipFor("structures_ratio"));

  // Shape selector
  IntRect shSel = layout.shapeSelector;
  StructureShape[] shapes = StructureShape.values();
  int shapeIdx = max(0, min(shapes.length - 1, info.sharedShape.ordinal()));
  float shNorm = (shapes.length > 1) ? shapeIdx / (float)(shapes.length - 1) : 0;
  String shapeLabel = info.shapeMixed ? "Shape" : "Shape: " + structureShapeLabel(info.sharedShape);
  drawSelectorSlider(shSel, shNorm, shapeLabel, shapes.length, !info.shapeMixed);
  registerUiTooltip(shSel, tooltipFor("structures_shape"));

  // Alignment selector
  IntRect snapSel = layout.alignmentSelector;
  StructureSnapMode[] snaps = StructureSnapMode.values();
  int snapIdx = max(0, min(snaps.length - 1, info.sharedAlignment.ordinal()));
  float snapNorm = (snaps.length > 1) ? snapIdx / (float)(snaps.length - 1) : 0;
  String snapLabel = info.alignmentMixed ? "Alignment" : "Alignment: " + structureAlignmentLabel(info.sharedAlignment);
  drawSelectorSlider(snapSel, snapNorm, snapLabel, snaps.length, !info.alignmentMixed);
  registerUiTooltip(snapSel, tooltipFor("structures_snap_mode"));

  // Hue slider
  IntRect hue = layout.hueSlider;
  float hNorm = constrain(info.sharedHue, 0, 1);
  drawSlider(hue, hNorm, "Hue", false, !info.hueMixed);
  registerUiTooltip(hue, tooltipFor("structures_detail_hue"));

  // Saturation slider
  IntRect sat = layout.satSlider;
  float satNorm = constrain(info.sharedSat, 0, 1);
  drawSlider(sat, satNorm, "Saturation", false, !info.satMixed);
  registerUiTooltip(sat, tooltipFor("structures_detail_sat"));

  // Alpha slider (fill only)
  IntRect alp = layout.alphaSlider;
  float aNorm2 = constrain(info.sharedAlpha, 0, 1);
  String alphaLabel = info.alphaMixed ? "Alpha" : "Alpha (" + nf(info.sharedAlpha * 100.0f, 1, 0) + "%)";
  drawSlider(alp, aNorm2, alphaLabel, false, !info.alphaMixed);
  registerUiTooltip(alp, tooltipFor("structures_detail_alpha"));

  // Stroke weight slider
  IntRect st = layout.strokeSlider;
  float stNorm = constrain(map(info.sharedStroke, 0.5f, 4.0f, 0, 1), 0, 1);
  String strokeLabel = info.strokeMixed ? "Stroke weight (px)" : "Stroke weight (" + nf(info.sharedStroke, 1, 2) + " px)";
  drawSlider(st, stNorm, strokeLabel, false, !info.strokeMixed);
  registerUiTooltip(st, tooltipFor("structures_detail_stroke"));

  drawControlsHint(layout.panel,
                   "left-click: place/move",
                   "right-click: pan",
                   "wheel: zoom");
}

// ----- STRUCTURES LIST (right panel) -----
class StructuresListLayout {
  IntRect panel;
  int titleY;
  IntRect deselectBtn;
  ArrayList<StructureRowLayout> rows = new ArrayList<StructureRowLayout>();
  int rowsStartY;
  int rowsViewH;
  float contentH;
  IntRect scrollbar;
}

class StructureRowLayout {
  int index;
  IntRect selectRect;
  IntRect nameRect;
  IntRect delRect;
}

public StructuresListLayout buildStructuresListLayout() {
  StructuresListLayout l = new StructuresListLayout();
  int w = RIGHT_PANEL_W;
  int x = width - w - PANEL_PADDING;
  int y = snapPanelTop(); // keep right panel pinned to the top
  l.panel = new IntRect(x, y, w, height - y - PANEL_PADDING);
  l.titleY = y + PANEL_PADDING;
  int btnY = l.titleY + PANEL_TITLE_H + PANEL_SECTION_GAP;
  l.deselectBtn = new IntRect(x + PANEL_PADDING, btnY, 90, PANEL_BUTTON_H);
  return l;
}

public int layoutStructureDetails(StructuresListLayout layout) {
  return layout.deselectBtn.y + layout.deselectBtn.h + PANEL_SECTION_GAP;
}

public void populateStructuresListRows(StructuresListLayout layout, int startY) {
  layout.rows.clear();
  int labelX = layout.panel.x + PANEL_PADDING;
  int maxY = layout.panel.y + layout.panel.h - PANEL_SECTION_GAP;
  int viewH = max(0, maxY - startY);
  int curY = startY - round(structuresListScroll);
  int rowH = 24;
  int rowGap = 6;
  int totalRows = (mapModel != null && mapModel.structures != null) ? mapModel.structures.size() : 0;
  int contentH = (totalRows > 0) ? totalRows * (rowH + rowGap) - rowGap : 0;
  layout.rowsStartY = startY;
  layout.rowsViewH = viewH;
  layout.contentH = contentH;
  layout.scrollbar = new IntRect(layout.panel.x + layout.panel.w - SCROLLBAR_W, startY, SCROLLBAR_W, viewH);
  structuresListScroll = clampScroll(structuresListScroll, contentH, viewH);
  curY = startY - round(structuresListScroll);

  for (int i = 0; i < totalRows; i++) {
    if (curY > maxY) break;
    if (curY + rowH < startY) {
      curY += rowH + rowGap;
      continue;
    }
    StructureRowLayout row = new StructureRowLayout();
    row.index = i;
    int selectW = 18;
    row.selectRect = new IntRect(labelX, curY, selectW, rowH);
    row.nameRect = new IntRect(labelX + selectW + 6, curY, layout.panel.w - 2 * PANEL_PADDING - SCROLLBAR_W - selectW - 6 - 30, rowH);
    row.delRect = new IntRect(row.nameRect.x + row.nameRect.w + 6, curY, 24, rowH);
    layout.rows.add(row);
    curY += rowH + rowGap;
  }
}

public void drawStructuresListPanel() {
  StructuresListLayout layout = buildStructuresListLayout();
  int listStartY = layoutStructureDetails(layout);
  populateStructuresListRows(layout, listStartY);
  drawPanelBackground(layout.panel);

  int labelX = layout.panel.x + PANEL_PADDING;
  int curY = layout.titleY;
  fill(0);
  textAlign(LEFT, TOP);
  text("Structures", labelX, curY);
  curY += PANEL_TITLE_H + PANEL_SECTION_GAP;

  drawBevelButton(layout.deselectBtn.x, layout.deselectBtn.y, layout.deselectBtn.w, layout.deselectBtn.h, false);
  fill(10);
  textAlign(CENTER, CENTER);
  text("Deselect", layout.deselectBtn.x + layout.deselectBtn.w / 2, layout.deselectBtn.y + layout.deselectBtn.h / 2);

  for (int i = 0; i < layout.rows.size(); i++) {
    StructureRowLayout row = layout.rows.get(i);
    Structure s = (row.index >= 0 && row.index < mapModel.structures.size()) ? mapModel.structures.get(row.index) : null;
    if (s == null) continue;
    boolean selected = isStructureSelected(row.index);
    drawRadioButton(row.selectRect, selected);

    drawBevelButton(row.nameRect.x, row.nameRect.y, row.nameRect.w, row.nameRect.h, selected);
    fill(10);
    textAlign(LEFT, CENTER);
    String base = (s.name != null && s.name.length() > 0) ? s.name : "Struct " + (row.index + 1);
    text(base + " - " + structureShapeLabel(s.shape), row.nameRect.x + 6, row.nameRect.y + row.nameRect.h / 2);

    drawBevelButton(row.delRect.x, row.delRect.y, row.delRect.w, row.delRect.h, false);
    fill(10);
    textAlign(CENTER, CENTER);
    text("X", row.delRect.x + row.delRect.w / 2, row.delRect.y + row.delRect.h / 2);
  }

  drawScrollbar(layout.scrollbar, layout.contentH, structuresListScroll);
}

// ----- RENDER PANEL -----
class RenderLayout {
  IntRect panel;
  int titleY;
  IntRect headerBase;
  IntRect headerBiomes;
  IntRect headerShading;
  IntRect headerCoastlines;
  IntRect headerElevation;
  IntRect headerPaths;
  IntRect headerZones;
  IntRect headerStructures;
  IntRect headerLabels;
  IntRect headerGeneral;

  IntRect[] landHSB = new IntRect[3];
  IntRect[] waterHSB = new IntRect[3];
  IntRect cellBordersAlphaSlider;
  IntRect cellBordersSizeSlider;
  IntRect cellBordersScaleCheckbox;
  IntRect backgroundNoiseSlider;

  IntRect biomeFillAlphaSlider;
  IntRect biomeSatSlider;
  IntRect biomeBriSlider;
  ArrayList<IntRect> biomeFillTypeButtons = new ArrayList<IntRect>();
  IntRect biomeOutlineSizeSlider;
  IntRect biomeOutlineAlphaSlider;
  IntRect biomeUnderwaterAlphaSlider;
  IntRect biomeOutlineScaleCheckbox;

  IntRect waterDepthAlphaSlider;
  IntRect lightAlphaSlider;
  IntRect lightAzimuthSlider;
  IntRect lightAltitudeSlider;
  IntRect lightDitherSlider;
  IntRect lightDitherScaleCheckbox;

  IntRect waterContourSizeSlider;
  IntRect waterRippleCountSlider;
  IntRect waterRippleDistanceSlider;
  IntRect[] waterContourHSB = new IntRect[3];
  IntRect waterContourCoastAlphaSlider;
  IntRect waterCoastSizeSlider;
  IntRect waterCoastScaleCheckbox;
  IntRect waterCoastAboveZonesCheckbox;
  IntRect waterHatchAngleSlider;
  IntRect waterHatchLengthSlider;
  IntRect waterHatchSpacingSlider;
  IntRect waterHatchAlphaSlider;
  IntRect waterContourScaleCheckbox;
  IntRect waterRippleAlphaStartSlider;
  IntRect waterRippleAlphaEndSlider;
  IntRect elevationLinesCountSlider;
  IntRect elevationLinesAlphaSlider;
  IntRect elevationLinesSizeSlider;
  IntRect elevationLinesScaleCheckbox;

  IntRect pathsShowCheckbox;
  IntRect pathsScaleWithZoomCheckbox;
  IntRect pathSatSlider;
  IntRect pathBriSlider;

  IntRect zoneAlphaSlider;
  IntRect zoneSizeSlider;
  IntRect zoneSatSlider;
  IntRect zoneBriSlider;
  IntRect zoneScaleWithZoomCheckbox;

  IntRect structuresShowCheckbox;
  IntRect structuresMergeCheckbox;
  IntRect structuresShadowAlphaSlider;
  IntRect structuresScaleWithZoomCheckbox;

  IntRect labelsArbitraryCheckbox;
  IntRect labelsZonesCheckbox;
  IntRect labelsPathsCheckbox;
  IntRect labelsStructuresCheckbox;
  IntRect labelsOutlineAlphaSlider;
  IntRect labelsOutlineSizeSlider;
  IntRect labelsArbSizeSlider;
  IntRect labelsZoneSizeSlider;
  IntRect labelsPathSizeSlider;
  IntRect labelsStructSizeSlider;
  IntRect labelsFontSelector;
  IntRect labelsScaleWithZoomCheckbox;
  IntRect labelsOutlineScaleWithZoomCheckbox;

  IntRect exportPaddingSlider;
  IntRect antialiasCheckbox;
  IntRect presetSelector;
  IntRect presetApplyBtn;
}

public RenderLayout buildRenderLayout() {
  RenderLayout l = new RenderLayout();
  l.panel = new IntRect(PANEL_X, panelTop(), PANEL_W, 0);
  int innerX = l.panel.x + PANEL_PADDING;
  int curY = l.panel.y + PANEL_PADDING;
  l.titleY = curY;
  curY += PANEL_TITLE_H + PANEL_SECTION_GAP;

  int headerW = PANEL_W - 2 * PANEL_PADDING;
  int shortSliderW = 90;
  int longSliderW = 200;
  int hsbGap = 8;

  // ----- Base -----
  l.headerBase = new IntRect(innerX, curY, headerW, PANEL_TITLE_H);
  curY += PANEL_TITLE_H + PANEL_ROW_GAP;
  if (renderSectionBaseOpen) {
    int yHue = curY + PANEL_LABEL_H;
    l.landHSB[0] = new IntRect(innerX, yHue + PANEL_LABEL_H, shortSliderW, PANEL_SLIDER_H);
    l.landHSB[1] = new IntRect(innerX + (shortSliderW + hsbGap), yHue + PANEL_LABEL_H, shortSliderW, PANEL_SLIDER_H);
    l.landHSB[2] = new IntRect(innerX + 2 * (shortSliderW + hsbGap), yHue + PANEL_LABEL_H, shortSliderW, PANEL_SLIDER_H);
    curY += PANEL_LABEL_H*2 + PANEL_SLIDER_H + PANEL_ROW_GAP;

    curY += PANEL_LABEL_H;
    int yWater = curY;
    l.waterHSB[0] = new IntRect(innerX, yWater + PANEL_LABEL_H, shortSliderW, PANEL_SLIDER_H);
    l.waterHSB[1] = new IntRect(innerX + (shortSliderW + hsbGap), yWater + PANEL_LABEL_H, shortSliderW, PANEL_SLIDER_H);
    l.waterHSB[2] = new IntRect(innerX + 2 * (shortSliderW + hsbGap), yWater + PANEL_LABEL_H, shortSliderW, PANEL_SLIDER_H);
    curY += PANEL_LABEL_H*2 + PANEL_SLIDER_H + PANEL_ROW_GAP;

    l.cellBordersAlphaSlider = new IntRect(innerX, curY + PANEL_LABEL_H, longSliderW, PANEL_SLIDER_H);
    curY += PANEL_LABEL_H + PANEL_SLIDER_H + PANEL_ROW_GAP;
    l.cellBordersSizeSlider = new IntRect(innerX, curY + PANEL_LABEL_H, longSliderW, PANEL_SLIDER_H);
    curY += PANEL_LABEL_H + PANEL_SLIDER_H + PANEL_ROW_GAP;
    l.cellBordersScaleCheckbox = new IntRect(innerX, curY, PANEL_CHECK_SIZE, PANEL_CHECK_SIZE);
    curY += PANEL_CHECK_SIZE + PANEL_ROW_GAP;

    l.backgroundNoiseSlider = new IntRect(innerX, curY + PANEL_LABEL_H, longSliderW, PANEL_SLIDER_H);
    curY += PANEL_LABEL_H + PANEL_SLIDER_H + PANEL_SECTION_GAP;
  }

  // ----- Biomes -----
  l.headerBiomes = new IntRect(innerX, curY, headerW, PANEL_TITLE_H);
  curY += PANEL_TITLE_H + PANEL_ROW_GAP;
  if (renderSectionBiomesOpen) {
    l.biomeFillAlphaSlider = new IntRect(innerX, curY + PANEL_LABEL_H, longSliderW, PANEL_SLIDER_H);
    curY += PANEL_LABEL_H + PANEL_SLIDER_H + PANEL_ROW_GAP;

    l.biomeUnderwaterAlphaSlider = new IntRect(innerX, curY + PANEL_LABEL_H, longSliderW, PANEL_SLIDER_H);
    curY += PANEL_LABEL_H + PANEL_SLIDER_H + PANEL_ROW_GAP;

    l.biomeSatSlider = new IntRect(innerX, curY + PANEL_LABEL_H, longSliderW, PANEL_SLIDER_H);
    curY += PANEL_LABEL_H + PANEL_SLIDER_H + PANEL_ROW_GAP;

    l.biomeBriSlider = new IntRect(innerX, curY + PANEL_LABEL_H, longSliderW, PANEL_SLIDER_H);
    curY += PANEL_LABEL_H + PANEL_SLIDER_H + PANEL_ROW_GAP;

    int btnW = 90;
    for (int i = 0; i < 3; i++) {
      l.biomeFillTypeButtons.add(new IntRect(innerX + i * (btnW + 8), curY, btnW, PANEL_BUTTON_H));
    }
    curY += PANEL_BUTTON_H + PANEL_ROW_GAP;

    l.biomeOutlineSizeSlider = new IntRect(innerX, curY + PANEL_LABEL_H, longSliderW, PANEL_SLIDER_H);
    curY += PANEL_LABEL_H + PANEL_SLIDER_H + PANEL_ROW_GAP;

    l.biomeOutlineAlphaSlider = new IntRect(innerX, curY + PANEL_LABEL_H, longSliderW, PANEL_SLIDER_H);
    curY += PANEL_LABEL_H + PANEL_SLIDER_H + PANEL_ROW_GAP;

    l.biomeOutlineScaleCheckbox = new IntRect(innerX, curY, PANEL_CHECK_SIZE, PANEL_CHECK_SIZE);
    curY += PANEL_CHECK_SIZE + PANEL_SECTION_GAP;
  }

  // ----- Shading -----
  l.headerShading = new IntRect(innerX, curY, headerW, PANEL_TITLE_H);
  curY += PANEL_TITLE_H + PANEL_ROW_GAP;
  if (renderSectionShadingOpen) {
    l.waterDepthAlphaSlider = new IntRect(innerX, curY + PANEL_LABEL_H, longSliderW, PANEL_SLIDER_H);
    curY += PANEL_LABEL_H + PANEL_SLIDER_H + PANEL_ROW_GAP;

    l.lightAlphaSlider = new IntRect(innerX, curY + PANEL_LABEL_H, longSliderW, PANEL_SLIDER_H);
    curY += PANEL_LABEL_H + PANEL_SLIDER_H + PANEL_ROW_GAP;

    l.lightAzimuthSlider = new IntRect(innerX, curY + PANEL_LABEL_H, longSliderW, PANEL_SLIDER_H);
    curY += PANEL_LABEL_H + PANEL_SLIDER_H + PANEL_ROW_GAP;

    l.lightAltitudeSlider = new IntRect(innerX, curY + PANEL_LABEL_H, longSliderW, PANEL_SLIDER_H);
    curY += PANEL_LABEL_H + PANEL_SLIDER_H + PANEL_ROW_GAP;

    l.lightDitherSlider = new IntRect(innerX, curY + PANEL_LABEL_H, longSliderW, PANEL_SLIDER_H);
    curY += PANEL_LABEL_H + PANEL_SLIDER_H + PANEL_SECTION_GAP;
    l.lightDitherScaleCheckbox = new IntRect(innerX, curY, PANEL_CHECK_SIZE, PANEL_CHECK_SIZE);
    curY += PANEL_CHECK_SIZE + PANEL_SECTION_GAP;
  }

  // ----- Contours -----
  l.headerCoastlines = new IntRect(innerX, curY, headerW, PANEL_TITLE_H);
  curY += PANEL_TITLE_H + PANEL_ROW_GAP;
  if (renderSectionCoastlinesOpen) {
    l.waterCoastSizeSlider = new IntRect(innerX, curY + PANEL_LABEL_H, longSliderW, PANEL_SLIDER_H);
    curY += PANEL_LABEL_H + PANEL_SLIDER_H + PANEL_ROW_GAP;
    l.waterCoastScaleCheckbox = new IntRect(innerX, curY, PANEL_CHECK_SIZE, PANEL_CHECK_SIZE);
    curY += PANEL_CHECK_SIZE + PANEL_ROW_GAP;
    l.waterCoastAboveZonesCheckbox = new IntRect(innerX, curY, PANEL_CHECK_SIZE, PANEL_CHECK_SIZE);
    curY += PANEL_CHECK_SIZE + PANEL_ROW_GAP;

    l.waterContourCoastAlphaSlider = new IntRect(innerX, curY + PANEL_LABEL_H, longSliderW, PANEL_SLIDER_H);
    curY += PANEL_LABEL_H + PANEL_SLIDER_H + PANEL_ROW_GAP;

    l.waterContourSizeSlider = new IntRect(innerX, curY + PANEL_LABEL_H, longSliderW, PANEL_SLIDER_H);
    curY += PANEL_LABEL_H + PANEL_SLIDER_H + PANEL_ROW_GAP;

    l.waterContourScaleCheckbox = new IntRect(innerX, curY, PANEL_CHECK_SIZE, PANEL_CHECK_SIZE);
    curY += PANEL_CHECK_SIZE + PANEL_ROW_GAP;

    int yColor = curY + PANEL_LABEL_H;
    l.waterContourHSB[0] = new IntRect(innerX, yColor + PANEL_LABEL_H, shortSliderW, PANEL_SLIDER_H);
    l.waterContourHSB[1] = new IntRect(innerX + (shortSliderW + hsbGap), yColor + PANEL_LABEL_H, shortSliderW, PANEL_SLIDER_H);
    l.waterContourHSB[2] = new IntRect(innerX + 2 * (shortSliderW + hsbGap), yColor + PANEL_LABEL_H, shortSliderW, PANEL_SLIDER_H);
    curY += PANEL_LABEL_H * 2 + PANEL_SLIDER_H + PANEL_ROW_GAP;

    l.waterRippleCountSlider = new IntRect(innerX, curY + PANEL_LABEL_H, longSliderW, PANEL_SLIDER_H);
    curY += PANEL_LABEL_H + PANEL_SLIDER_H + PANEL_ROW_GAP;

    l.waterRippleDistanceSlider = new IntRect(innerX, curY + PANEL_LABEL_H, longSliderW, PANEL_SLIDER_H);
    curY += PANEL_LABEL_H + PANEL_SLIDER_H + PANEL_ROW_GAP;

    l.waterRippleAlphaStartSlider = new IntRect(innerX, curY + PANEL_LABEL_H, longSliderW, PANEL_SLIDER_H);
    curY += PANEL_LABEL_H + PANEL_SLIDER_H + PANEL_ROW_GAP;

    l.waterRippleAlphaEndSlider = new IntRect(innerX, curY + PANEL_LABEL_H, longSliderW, PANEL_SLIDER_H);
    curY += PANEL_LABEL_H + PANEL_SLIDER_H + PANEL_ROW_GAP;

    l.waterHatchAngleSlider = new IntRect(innerX, curY + PANEL_LABEL_H, longSliderW, PANEL_SLIDER_H);
    curY += PANEL_LABEL_H + PANEL_SLIDER_H + PANEL_ROW_GAP;

    l.waterHatchLengthSlider = new IntRect(innerX, curY + PANEL_LABEL_H, longSliderW, PANEL_SLIDER_H);
    curY += PANEL_LABEL_H + PANEL_SLIDER_H + PANEL_ROW_GAP;

    l.waterHatchSpacingSlider = new IntRect(innerX, curY + PANEL_LABEL_H, longSliderW, PANEL_SLIDER_H);
    curY += PANEL_LABEL_H + PANEL_SLIDER_H + PANEL_ROW_GAP;

    l.waterHatchAlphaSlider = new IntRect(innerX, curY + PANEL_LABEL_H, longSliderW, PANEL_SLIDER_H);
    curY += PANEL_LABEL_H + PANEL_SLIDER_H + PANEL_SECTION_GAP;
  }

  l.headerElevation = new IntRect(innerX, curY, headerW, PANEL_TITLE_H);
  curY += PANEL_TITLE_H + PANEL_ROW_GAP;
  if (renderSectionElevationOpen) {
    l.elevationLinesCountSlider = new IntRect(innerX, curY + PANEL_LABEL_H, longSliderW, PANEL_SLIDER_H);
    curY += PANEL_LABEL_H + PANEL_SLIDER_H + PANEL_ROW_GAP;

    l.elevationLinesAlphaSlider = new IntRect(innerX, curY + PANEL_LABEL_H, longSliderW, PANEL_SLIDER_H);
    curY += PANEL_LABEL_H + PANEL_SLIDER_H + PANEL_ROW_GAP;

    l.elevationLinesSizeSlider = new IntRect(innerX, curY + PANEL_LABEL_H, longSliderW, PANEL_SLIDER_H);
    curY += PANEL_LABEL_H + PANEL_SLIDER_H + PANEL_ROW_GAP;

    l.elevationLinesScaleCheckbox = new IntRect(innerX, curY, PANEL_CHECK_SIZE, PANEL_CHECK_SIZE);
    curY += PANEL_CHECK_SIZE + PANEL_SECTION_GAP;
  }

  // ----- Paths -----
  l.headerPaths = new IntRect(innerX, curY, headerW, PANEL_TITLE_H);
  curY += PANEL_TITLE_H + PANEL_ROW_GAP;
  if (renderSectionPathsOpen) {
    l.pathsShowCheckbox = new IntRect(innerX, curY, PANEL_CHECK_SIZE, PANEL_CHECK_SIZE);
    curY += PANEL_CHECK_SIZE + PANEL_ROW_GAP;
    l.pathsScaleWithZoomCheckbox = new IntRect(innerX, curY, PANEL_CHECK_SIZE, PANEL_CHECK_SIZE);
    curY += PANEL_CHECK_SIZE + PANEL_ROW_GAP;
    l.pathSatSlider = new IntRect(innerX, curY + PANEL_LABEL_H, longSliderW, PANEL_SLIDER_H);
    curY += PANEL_LABEL_H + PANEL_SLIDER_H + PANEL_ROW_GAP;
    l.pathBriSlider = new IntRect(innerX, curY + PANEL_LABEL_H, longSliderW, PANEL_SLIDER_H);
    curY += PANEL_LABEL_H + PANEL_SLIDER_H + PANEL_SECTION_GAP;
  }

  // ----- Zones -----
  l.headerZones = new IntRect(innerX, curY, headerW, PANEL_TITLE_H);
  curY += PANEL_TITLE_H + PANEL_ROW_GAP;
  if (renderSectionZonesOpen) {
    l.zoneAlphaSlider = new IntRect(innerX, curY + PANEL_LABEL_H, longSliderW, PANEL_SLIDER_H);
    curY += PANEL_LABEL_H + PANEL_SLIDER_H + PANEL_ROW_GAP;
    l.zoneSizeSlider = new IntRect(innerX, curY + PANEL_LABEL_H, longSliderW, PANEL_SLIDER_H);
    curY += PANEL_LABEL_H + PANEL_SLIDER_H + PANEL_ROW_GAP;
    l.zoneScaleWithZoomCheckbox = new IntRect(innerX, curY, PANEL_CHECK_SIZE, PANEL_CHECK_SIZE);
    curY += PANEL_CHECK_SIZE + PANEL_ROW_GAP;
    l.zoneSatSlider = new IntRect(innerX, curY + PANEL_LABEL_H, longSliderW, PANEL_SLIDER_H);
    curY += PANEL_LABEL_H + PANEL_SLIDER_H + PANEL_ROW_GAP;
    l.zoneBriSlider = new IntRect(innerX, curY + PANEL_LABEL_H, longSliderW, PANEL_SLIDER_H);
    curY += PANEL_LABEL_H + PANEL_SLIDER_H + PANEL_SECTION_GAP;
  }

  // ----- Structures -----
  l.headerStructures = new IntRect(innerX, curY, headerW, PANEL_TITLE_H);
  curY += PANEL_TITLE_H + PANEL_ROW_GAP;
  if (renderSectionStructuresOpen) {
    l.structuresShowCheckbox = new IntRect(innerX, curY, PANEL_CHECK_SIZE, PANEL_CHECK_SIZE);
    curY += PANEL_CHECK_SIZE + PANEL_ROW_GAP;
    l.structuresMergeCheckbox = new IntRect(innerX, curY, PANEL_CHECK_SIZE, PANEL_CHECK_SIZE);
    curY += PANEL_CHECK_SIZE + PANEL_ROW_GAP;
    l.structuresScaleWithZoomCheckbox = new IntRect(innerX, curY, PANEL_CHECK_SIZE, PANEL_CHECK_SIZE);
    curY += PANEL_CHECK_SIZE + PANEL_SECTION_GAP;
    l.structuresShadowAlphaSlider = new IntRect(innerX, curY + PANEL_LABEL_H, longSliderW, PANEL_SLIDER_H);
    curY += PANEL_LABEL_H + PANEL_SLIDER_H + PANEL_SECTION_GAP;
  }

  // ----- Labels -----
  l.headerLabels = new IntRect(innerX, curY, headerW, PANEL_TITLE_H);
  curY += PANEL_TITLE_H + PANEL_ROW_GAP;
  if (renderSectionLabelsOpen) {
    l.labelsArbitraryCheckbox = new IntRect(innerX, curY, PANEL_CHECK_SIZE, PANEL_CHECK_SIZE);
    curY += PANEL_CHECK_SIZE + PANEL_ROW_GAP;
    l.labelsArbSizeSlider = new IntRect(innerX, curY + PANEL_LABEL_H, longSliderW, PANEL_SLIDER_H);
    curY += PANEL_LABEL_H + PANEL_SLIDER_H + PANEL_ROW_GAP;
    l.labelsZonesCheckbox = new IntRect(innerX, curY, PANEL_CHECK_SIZE, PANEL_CHECK_SIZE);
    curY += PANEL_CHECK_SIZE + PANEL_ROW_GAP;
    l.labelsZoneSizeSlider = new IntRect(innerX, curY + PANEL_LABEL_H, longSliderW, PANEL_SLIDER_H);
    curY += PANEL_LABEL_H + PANEL_SLIDER_H + PANEL_ROW_GAP;
    l.labelsPathsCheckbox = new IntRect(innerX, curY, PANEL_CHECK_SIZE, PANEL_CHECK_SIZE);
    curY += PANEL_CHECK_SIZE + PANEL_ROW_GAP;
    l.labelsPathSizeSlider = new IntRect(innerX, curY + PANEL_LABEL_H, longSliderW, PANEL_SLIDER_H);
    curY += PANEL_LABEL_H + PANEL_SLIDER_H + PANEL_ROW_GAP;
    l.labelsStructuresCheckbox = new IntRect(innerX, curY, PANEL_CHECK_SIZE, PANEL_CHECK_SIZE);
    curY += PANEL_CHECK_SIZE + PANEL_ROW_GAP;
    l.labelsStructSizeSlider = new IntRect(innerX, curY + PANEL_LABEL_H, longSliderW, PANEL_SLIDER_H);
    curY += PANEL_LABEL_H + PANEL_SLIDER_H + PANEL_ROW_GAP;
    l.labelsOutlineAlphaSlider = new IntRect(innerX, curY + PANEL_LABEL_H, longSliderW, PANEL_SLIDER_H);
    curY += PANEL_LABEL_H + PANEL_SLIDER_H + PANEL_ROW_GAP;
    l.labelsOutlineSizeSlider = new IntRect(innerX, curY + PANEL_LABEL_H, longSliderW, PANEL_SLIDER_H);
    curY += PANEL_LABEL_H + PANEL_SLIDER_H + PANEL_ROW_GAP;
    l.labelsScaleWithZoomCheckbox = new IntRect(innerX, curY, PANEL_CHECK_SIZE, PANEL_CHECK_SIZE);
    // Extra gap to leave space for the reference zoom text under the checkbox.
    curY += PANEL_CHECK_SIZE + PANEL_ROW_GAP + PANEL_LABEL_H + PANEL_ROW_GAP;
    l.labelsOutlineScaleWithZoomCheckbox = new IntRect(innerX, curY, PANEL_CHECK_SIZE, PANEL_CHECK_SIZE);
    curY += PANEL_CHECK_SIZE + PANEL_ROW_GAP;
    l.labelsFontSelector = new IntRect(innerX, curY + PANEL_LABEL_H, longSliderW, PANEL_SLIDER_H);
    curY += PANEL_LABEL_H + PANEL_SLIDER_H + PANEL_SECTION_GAP;
  }

  // ----- General -----
  l.headerGeneral = new IntRect(innerX, curY, headerW, PANEL_TITLE_H);
  curY += PANEL_TITLE_H + PANEL_ROW_GAP;
  if (renderSectionGeneralOpen) {
    l.exportPaddingSlider = new IntRect(innerX, curY + PANEL_LABEL_H, longSliderW, PANEL_SLIDER_H);
    curY += PANEL_LABEL_H + PANEL_SLIDER_H + PANEL_ROW_GAP;
    l.antialiasCheckbox = new IntRect(innerX, curY, PANEL_CHECK_SIZE, PANEL_CHECK_SIZE);
    curY += PANEL_CHECK_SIZE + PANEL_ROW_GAP;
    l.presetSelector = new IntRect(innerX, curY + PANEL_LABEL_H, longSliderW, PANEL_SLIDER_H);
    curY += PANEL_LABEL_H + PANEL_SLIDER_H + PANEL_ROW_GAP;
    l.presetApplyBtn = new IntRect(innerX, curY, 110, PANEL_BUTTON_H);
    curY += PANEL_BUTTON_H + PANEL_SECTION_GAP;
  }

  curY += PANEL_PADDING + hintHeight(2);
  l.panel.h = curY - l.panel.y;
  return l;
}

public void drawRenderPanel() {
  RenderLayout layout = buildRenderLayout();
  drawPanelBackground(layout.panel);

  int labelX = layout.panel.x + PANEL_PADDING;
  fill(0);
  textAlign(LEFT, TOP);
  text("Rendering", labelX, layout.titleY);
  textAlign(LEFT, CENTER);
  drawControlsHint(layout.panel, "right-click: pan", "wheel: zoom");

  drawSectionHeader(layout.headerBase, "Base", renderSectionBaseOpen);
  if (renderSectionBaseOpen) {
    drawHSBRow(layout.landHSB, "Land base", renderSettings.landHue01, renderSettings.landSat01, renderSettings.landBri01);
    registerUiTooltip(layout.landHSB[0], tooltipFor("render_land_h"));
    registerUiTooltip(layout.landHSB[1], tooltipFor("render_land_s"));
    registerUiTooltip(layout.landHSB[2], tooltipFor("render_land_b"));
    drawHSBRow(layout.waterHSB, "Water base", renderSettings.waterHue01, renderSettings.waterSat01, renderSettings.waterBri01);
    registerUiTooltip(layout.waterHSB[0], tooltipFor("render_water_h"));
    registerUiTooltip(layout.waterHSB[1], tooltipFor("render_water_s"));
    registerUiTooltip(layout.waterHSB[2], tooltipFor("render_water_b"));
    drawSlider(layout.cellBordersAlphaSlider, renderSettings.cellBorderAlpha01, "Cell borders alpha (" + nf(renderSettings.cellBorderAlpha01 * 100, 1, 0) + "%)");
    registerUiTooltip(layout.cellBordersAlphaSlider, tooltipFor("render_cell_borders"));
    drawSlider(layout.cellBordersSizeSlider, constrain(renderSettings.cellBorderSizePx / 5.0f, 0, 1), "Cell borders size (" + nf(renderSettings.cellBorderSizePx, 1, 1) + " px)");
    if (layout.cellBordersScaleCheckbox != null) {
      drawCheckbox(layout.cellBordersScaleCheckbox.x, layout.cellBordersScaleCheckbox.y, layout.cellBordersScaleCheckbox.w, renderSettings.cellBorderScaleWithZoom, "Scale cell borders with zoom");
    }
    drawSlider(layout.backgroundNoiseSlider, renderSettings.backgroundNoiseAlpha01, "Background noise (" + nf(renderSettings.backgroundNoiseAlpha01 * 100, 1, 0) + "%)");
    registerUiTooltip(layout.backgroundNoiseSlider, tooltipFor("render_noise_alpha"));
  }

  drawSectionHeader(layout.headerBiomes, "Biomes", renderSectionBiomesOpen);
  if (renderSectionBiomesOpen) {
    drawSlider(layout.biomeFillAlphaSlider, renderSettings.biomeFillAlpha01, "Emerged biomes alpha (" + nf(renderSettings.biomeFillAlpha01 * 100, 1, 0) + "%)");
    registerUiTooltip(layout.biomeFillAlphaSlider, tooltipFor("render_biome_fill_alpha"));
    drawSlider(layout.biomeUnderwaterAlphaSlider, renderSettings.biomeUnderwaterAlpha01, "Underwater biomes alpha (" + nf(renderSettings.biomeUnderwaterAlpha01 * 100, 1, 0) + "%)");
    registerUiTooltip(layout.biomeUnderwaterAlphaSlider, tooltipFor("render_biome_underwater_alpha"));
    drawSlider(layout.biomeSatSlider, renderSettings.biomeSatScale01, "Biomes saturation (" + nf(renderSettings.biomeSatScale01 * 100, 1, 0) + "%)");
    registerUiTooltip(layout.biomeSatSlider, tooltipFor("render_biome_sat"));
    drawSlider(layout.biomeBriSlider, renderSettings.biomeBriScale01, "Biomes brightness (" + nf(renderSettings.biomeBriScale01 * 100, 1, 0) + "%)");
    registerUiTooltip(layout.biomeBriSlider, tooltipFor("render_biome_bri"));
    String[] fillLabels = { "Color", "Pattern", "P-Background" };
    for (int i = 0; i < layout.biomeFillTypeButtons.size(); i++) {
      IntRect b = layout.biomeFillTypeButtons.get(i);
      RenderFillType mode = RenderFillType.RENDER_FILL_COLOR;
      if (i == 1) mode = RenderFillType.RENDER_FILL_PATTERN;
      else if (i == 2) mode = RenderFillType.RENDER_FILL_PATTERN_BG;
      boolean active = (renderSettings.biomeFillType == mode);
      drawBevelButton(b.x, b.y, b.w, b.h, active);
      fill(10);
      textAlign(CENTER, CENTER);
      text(fillLabels[i], b.x + b.w / 2, b.y + b.h / 2);
      registerUiTooltip(b, tooltipFor("render_biome_fill_type"));
    }
    drawSlider(layout.biomeOutlineSizeSlider, constrain(renderSettings.biomeOutlineSizePx / 5.0f, 0, 1), "Biomes outlines size (" + nf(renderSettings.biomeOutlineSizePx, 1, 1) + " px)");
    registerUiTooltip(layout.biomeOutlineSizeSlider, tooltipFor("render_biome_outline_size"));
    drawSlider(layout.biomeOutlineAlphaSlider, renderSettings.biomeOutlineAlpha01, "Biomes outlines alpha (" + nf(renderSettings.biomeOutlineAlpha01 * 100, 1, 0) + "%)");
    registerUiTooltip(layout.biomeOutlineAlphaSlider, tooltipFor("render_biome_outline_alpha"));
    if (layout.biomeOutlineScaleCheckbox != null) {
      drawCheckbox(layout.biomeOutlineScaleCheckbox.x, layout.biomeOutlineScaleCheckbox.y, layout.biomeOutlineScaleCheckbox.w, renderSettings.biomeOutlineScaleWithZoom, "Scale biome outlines with zoom");
    }
  }

  drawSectionHeader(layout.headerShading, "Shading", renderSectionShadingOpen);
  if (renderSectionShadingOpen) {
    drawSlider(layout.waterDepthAlphaSlider, renderSettings.waterDepthAlpha01, "Water depth alpha (" + nf(renderSettings.waterDepthAlpha01 * 100, 1, 0) + "%)");
    registerUiTooltip(layout.waterDepthAlphaSlider, tooltipFor("render_water_depth_alpha"));
    drawSlider(layout.lightAlphaSlider, renderSettings.elevationLightAlpha01, "Elevation light alpha (" + nf(renderSettings.elevationLightAlpha01 * 100, 1, 0) + "%)");
    registerUiTooltip(layout.lightAlphaSlider, tooltipFor("render_light_alpha"));
    float tAz = constrain(renderSettings.elevationLightAzimuthDeg / 360.0f, 0, 1);
    drawSlider(layout.lightAzimuthSlider, tAz, "Light azimuth (" + nf(renderSettings.elevationLightAzimuthDeg, 1, 0) + " deg)");
    registerUiTooltip(layout.lightAzimuthSlider, tooltipFor("render_light_azimuth"));
    float tAlt = constrain(map(renderSettings.elevationLightAltitudeDeg, 5.0f, 80.0f, 0, 1), 0, 1);
    drawSlider(layout.lightAltitudeSlider, tAlt, "Light altitude (" + nf(renderSettings.elevationLightAltitudeDeg, 1, 0) + " deg)");
    registerUiTooltip(layout.lightAltitudeSlider, tooltipFor("render_light_altitude"));
    drawSlider(layout.lightDitherSlider, constrain(renderSettings.elevationLightDitherPx / 10.0f, 0, 1), "Light dither (" + nf(renderSettings.elevationLightDitherPx, 1, 1) + ")");
    registerUiTooltip(layout.lightDitherSlider, tooltipFor("render_light_dither"));
    if (layout.lightDitherScaleCheckbox != null) {
      drawCheckbox(layout.lightDitherScaleCheckbox.x, layout.lightDitherScaleCheckbox.y, layout.lightDitherScaleCheckbox.w, renderSettings.elevationLightDitherScaleWithZoom, "Scale dither with zoom");
    }
  }

  drawSectionHeader(layout.headerCoastlines, "Coastlines", renderSectionCoastlinesOpen);
  if (renderSectionCoastlinesOpen) {
    drawSlider(layout.waterCoastSizeSlider, constrain(renderSettings.waterCoastSizePx / 5.0f, 0, 1), "Coastline size (" + nf(renderSettings.waterCoastSizePx, 1, 1) + " px)");
    if (layout.waterCoastScaleCheckbox != null) {
      drawCheckbox(layout.waterCoastScaleCheckbox.x, layout.waterCoastScaleCheckbox.y, layout.waterCoastScaleCheckbox.w, renderSettings.waterCoastScaleWithZoom, "Scale coastline with zoom");
    }
    if (layout.waterCoastAboveZonesCheckbox != null) {
      drawCheckbox(layout.waterCoastAboveZonesCheckbox.x, layout.waterCoastAboveZonesCheckbox.y, layout.waterCoastAboveZonesCheckbox.w, renderSettings.waterCoastAboveZones, "Draw coastlines above zones");
    }
    drawSlider(layout.waterContourCoastAlphaSlider, renderSettings.waterCoastAlpha01, "Coastline alpha (" + nf(renderSettings.waterCoastAlpha01 * 100, 1, 0) + "%)");
    registerUiTooltip(layout.waterContourCoastAlphaSlider, tooltipFor("render_water_coast_alpha"));

    drawSlider(layout.waterContourSizeSlider, constrain(renderSettings.waterContourSizePx / 5.0f, 0, 1), "Water contour size (" + nf(renderSettings.waterContourSizePx, 1, 1) + " px)");
    registerUiTooltip(layout.waterContourSizeSlider, tooltipFor("render_water_contour_size"));
    if (layout.waterContourScaleCheckbox != null) {
      drawCheckbox(layout.waterContourScaleCheckbox.x, layout.waterContourScaleCheckbox.y, layout.waterContourScaleCheckbox.w, renderSettings.waterContourScaleWithZoom, "Scale water strokes with zoom");
    }
    drawHSBRow(layout.waterContourHSB, "Water contours", renderSettings.waterContourHue01, renderSettings.waterContourSat01, renderSettings.waterContourBri01);
    registerUiTooltip(layout.waterContourHSB[0], tooltipFor("render_water_contour_h"));
    registerUiTooltip(layout.waterContourHSB[1], tooltipFor("render_water_contour_s"));
    registerUiTooltip(layout.waterContourHSB[2], tooltipFor("render_water_contour_b"));

    drawSlider(layout.waterRippleCountSlider, constrain(renderSettings.waterRippleCount / 5.0f, 0, 1), "Number of ripples (" + renderSettings.waterRippleCount + ")");
    registerUiTooltip(layout.waterRippleCountSlider, tooltipFor("render_water_ripple_count"));
    drawSlider(layout.waterRippleDistanceSlider, constrain(renderSettings.waterRippleDistancePx / 40.0f, 0, 1), "Ripple distance (" + nf(renderSettings.waterRippleDistancePx, 1, 1) + " px)");
    registerUiTooltip(layout.waterRippleDistanceSlider, tooltipFor("render_water_ripple_dist"));
    drawSlider(layout.waterRippleAlphaStartSlider, renderSettings.waterRippleAlphaStart01, "Ripple near shore alpha (" + nf(renderSettings.waterRippleAlphaStart01 * 100, 1, 0) + "%)");
    registerUiTooltip(layout.waterRippleAlphaStartSlider, tooltipFor("render_water_ripple_alpha_start"));
    drawSlider(layout.waterRippleAlphaEndSlider, renderSettings.waterRippleAlphaEnd01, "Ripple far alpha (" + nf(renderSettings.waterRippleAlphaEnd01 * 100, 1, 0) + "%)");
    registerUiTooltip(layout.waterRippleAlphaEndSlider, tooltipFor("render_water_ripple_alpha_end"));

    drawSlider(layout.waterHatchAngleSlider, constrain((renderSettings.waterHatchAngleDeg + 90.0f) / 180.0f, 0, 1), "Hatching angle (" + nf(renderSettings.waterHatchAngleDeg, 1, 1) + " deg)");
    registerUiTooltip(layout.waterHatchAngleSlider, tooltipFor("render_water_hatch_angle"));
    drawSlider(layout.waterHatchLengthSlider, constrain(renderSettings.waterHatchLengthPx / 400.0f, 0, 1), "Hatching length (" + nf(renderSettings.waterHatchLengthPx, 1, 1) + " px)");
    registerUiTooltip(layout.waterHatchLengthSlider, tooltipFor("render_water_hatch_length"));
    float spacingNorm = constrain(renderSettings.waterHatchSpacingPx / 120.0f, 0, 1);
    drawSlider(layout.waterHatchSpacingSlider, spacingNorm, "Hatching spacing (" + nf(renderSettings.waterHatchSpacingPx, 1, 1) + " px)");
    registerUiTooltip(layout.waterHatchSpacingSlider, tooltipFor("render_water_hatch_spacing"));
    drawSlider(layout.waterHatchAlphaSlider, renderSettings.waterHatchAlpha01, "Hatching alpha (" + nf(renderSettings.waterHatchAlpha01 * 100, 1, 0) + "%)");
    registerUiTooltip(layout.waterHatchAlphaSlider, tooltipFor("render_water_hatch_alpha"));
  }

  drawSectionHeader(layout.headerElevation, "Elevation", renderSectionElevationOpen);
  if (renderSectionElevationOpen) {
    float elevCountNorm = constrain(renderSettings.elevationLinesCount / 24.0f, 0, 1);
    drawSlider(layout.elevationLinesCountSlider, elevCountNorm, "Elevation lines (" + renderSettings.elevationLinesCount + ")");
    registerUiTooltip(layout.elevationLinesCountSlider, tooltipFor("render_elev_lines_count"));
    drawSlider(layout.elevationLinesAlphaSlider, renderSettings.elevationLinesAlpha01, "Elevation lines alpha (" + nf(renderSettings.elevationLinesAlpha01 * 100, 1, 0) + "%)");
    registerUiTooltip(layout.elevationLinesAlphaSlider, tooltipFor("render_elev_lines_alpha"));
    drawSlider(layout.elevationLinesSizeSlider, constrain(renderSettings.elevationLinesSizePx / 5.0f, 0, 1), "Elevation lines size (" + nf(renderSettings.elevationLinesSizePx, 1, 1) + " px)");
    if (layout.elevationLinesScaleCheckbox != null) {
      drawCheckbox(layout.elevationLinesScaleCheckbox.x, layout.elevationLinesScaleCheckbox.y, layout.elevationLinesScaleCheckbox.w, renderSettings.elevationLinesScaleWithZoom, "Scale elevation lines with zoom");
    }
  }

  drawSectionHeader(layout.headerPaths, "Paths", renderSectionPathsOpen);
  if (renderSectionPathsOpen) {
    drawCheckbox(layout.pathsShowCheckbox.x, layout.pathsShowCheckbox.y, layout.pathsShowCheckbox.w, renderSettings.showPaths, "Show paths");
    registerUiTooltip(layout.pathsShowCheckbox, tooltipFor("render_paths_show"));
    drawCheckbox(layout.pathsScaleWithZoomCheckbox.x, layout.pathsScaleWithZoomCheckbox.y, layout.pathsScaleWithZoomCheckbox.w, renderSettings.pathScaleWithZoom, "Scale stroke with zoom");
    drawSlider(layout.pathSatSlider, renderSettings.pathSatScale01, "Paths saturation (" + nf(renderSettings.pathSatScale01 * 100, 1, 0) + "%)");
    registerUiTooltip(layout.pathSatSlider, tooltipFor("render_paths_sat"));
    drawSlider(layout.pathBriSlider, renderSettings.pathBriScale01, "Paths brightness (" + nf(renderSettings.pathBriScale01 * 100, 1, 0) + "%)");
    registerUiTooltip(layout.pathBriSlider, tooltipFor("render_paths_bri"));
  }

  drawSectionHeader(layout.headerZones, "Zones", renderSectionZonesOpen);
  if (renderSectionZonesOpen) {
    drawSlider(layout.zoneAlphaSlider, renderSettings.zoneStrokeAlpha01, "Zone lines alpha (" + nf(renderSettings.zoneStrokeAlpha01 * 100, 1, 0) + "%)"); 
    registerUiTooltip(layout.zoneAlphaSlider, tooltipFor("render_zone_alpha"));
    drawSlider(layout.zoneSizeSlider, constrain(renderSettings.zoneStrokeSizePx / 5.0f, 0, 1), "Zone line width (" + nf(renderSettings.zoneStrokeSizePx, 1, 1) + " px)");
    registerUiTooltip(layout.zoneSizeSlider, tooltipFor("render_zone_size"));
    if (layout.zoneScaleWithZoomCheckbox != null) {
      drawCheckbox(layout.zoneScaleWithZoomCheckbox.x, layout.zoneScaleWithZoomCheckbox.y, layout.zoneScaleWithZoomCheckbox.w, renderSettings.zoneStrokeScaleWithZoom, "Scale zone lines with zoom");
    }
    drawSlider(layout.zoneSatSlider, renderSettings.zoneStrokeSatScale01, "Zone lines saturation (" + nf(renderSettings.zoneStrokeSatScale01 * 100, 1, 0) + "%)");
    registerUiTooltip(layout.zoneSatSlider, tooltipFor("render_zone_sat"));
    drawSlider(layout.zoneBriSlider, renderSettings.zoneStrokeBriScale01, "Zone lines brightness (" + nf(renderSettings.zoneStrokeBriScale01 * 100, 1, 0) + "%)");
    registerUiTooltip(layout.zoneBriSlider, tooltipFor("render_zone_bri"));
  }

  drawSectionHeader(layout.headerStructures, "Structures", renderSectionStructuresOpen);
  if (renderSectionStructuresOpen) {
    drawCheckbox(layout.structuresShowCheckbox.x, layout.structuresShowCheckbox.y, layout.structuresShowCheckbox.w, renderSettings.showStructures, "Show structures");
    drawCheckbox(layout.structuresMergeCheckbox.x, layout.structuresMergeCheckbox.y, layout.structuresMergeCheckbox.w, renderSettings.mergeStructures, "Merge structures");
    if (layout.structuresScaleWithZoomCheckbox != null) {
      drawCheckbox(layout.structuresScaleWithZoomCheckbox.x, layout.structuresScaleWithZoomCheckbox.y, layout.structuresScaleWithZoomCheckbox.w, renderSettings.structureStrokeScaleWithZoom, "Scale structure strokes with zoom");
    }
    drawSlider(layout.structuresShadowAlphaSlider, renderSettings.structureShadowAlpha01, "Shadow alpha (" + nf(renderSettings.structureShadowAlpha01 * 100, 1, 0) + "%)");
    registerUiTooltip(layout.structuresShowCheckbox, tooltipFor("render_struct_show"));
    registerUiTooltip(layout.structuresMergeCheckbox, tooltipFor("render_struct_merge"));
    registerUiTooltip(layout.structuresShadowAlphaSlider, tooltipFor("render_struct_shadow"));
  }

  drawSectionHeader(layout.headerLabels, "Labels", renderSectionLabelsOpen);
  if (renderSectionLabelsOpen) {
    drawCheckbox(layout.labelsArbitraryCheckbox.x, layout.labelsArbitraryCheckbox.y, layout.labelsArbitraryCheckbox.w, renderSettings.showLabelsArbitrary, "Show arbitrary");
    float arbSizeNorm = constrain((renderSettings.labelSizeArbPx - 8.0f) / (40.0f - 8.0f), 0, 1);
    drawSlider(layout.labelsArbSizeSlider, arbSizeNorm, "Arbitrary size (" + nf(renderSettings.labelSizeArbPx, 1, 0) + " px)");
    drawCheckbox(layout.labelsZonesCheckbox.x, layout.labelsZonesCheckbox.y, layout.labelsZonesCheckbox.w, renderSettings.showLabelsZones, "Show zones");
    float zoneSizeNorm = constrain((renderSettings.labelSizeZonePx - 8.0f) / (40.0f - 8.0f), 0, 1);
    drawSlider(layout.labelsZoneSizeSlider, zoneSizeNorm, "Zones size (" + nf(renderSettings.labelSizeZonePx, 1, 0) + " px)");
    drawCheckbox(layout.labelsPathsCheckbox.x, layout.labelsPathsCheckbox.y, layout.labelsPathsCheckbox.w, renderSettings.showLabelsPaths, "Show paths");
    float pathSizeNorm = constrain((renderSettings.labelSizePathPx - 8.0f) / (40.0f - 8.0f), 0, 1);
    drawSlider(layout.labelsPathSizeSlider, pathSizeNorm, "Paths size (" + nf(renderSettings.labelSizePathPx, 1, 0) + " px)");
    drawCheckbox(layout.labelsStructuresCheckbox.x, layout.labelsStructuresCheckbox.y, layout.labelsStructuresCheckbox.w, renderSettings.showLabelsStructures, "Show structures");
    float structSizeNorm = constrain((renderSettings.labelSizeStructPx - 8.0f) / (40.0f - 8.0f), 0, 1);
    drawSlider(layout.labelsStructSizeSlider, structSizeNorm, "Structures size (" + nf(renderSettings.labelSizeStructPx, 1, 0) + " px)");
    drawSlider(layout.labelsOutlineAlphaSlider, renderSettings.labelOutlineAlpha01, "Label outline alpha (" + nf(renderSettings.labelOutlineAlpha01 * 100, 1, 0) + "%)");
    drawSlider(layout.labelsOutlineSizeSlider, constrain(renderSettings.labelOutlineSizePx / 16.0f, 0, 1), "Label outline size (" + nf(renderSettings.labelOutlineSizePx, 1, 0) + " px)");
    drawCheckbox(layout.labelsScaleWithZoomCheckbox.x, layout.labelsScaleWithZoomCheckbox.y, layout.labelsScaleWithZoomCheckbox.w, renderSettings.labelScaleWithZoom, "Scale with zoom");
    fill(60);
    textAlign(LEFT, CENTER);
    text("Ref zoom: " + nf(renderSettings.labelScaleRefZoom, 1, 2),
         layout.labelsScaleWithZoomCheckbox.x,
         layout.labelsScaleWithZoomCheckbox.y + PANEL_CHECK_SIZE + PANEL_ROW_GAP);
    if (layout.labelsOutlineScaleWithZoomCheckbox != null) {
      drawCheckbox(layout.labelsOutlineScaleWithZoomCheckbox.x, layout.labelsOutlineScaleWithZoomCheckbox.y, layout.labelsOutlineScaleWithZoomCheckbox.w, renderSettings.labelOutlineScaleWithZoom, "Scale outline with zoom");
    }
    if (LABEL_FONT_OPTIONS != null && LABEL_FONT_OPTIONS.length > 0 && layout.labelsFontSelector != null) {
      int idx = constrain(renderSettings.labelFontIndex, 0, LABEL_FONT_OPTIONS.length - 1);
      float tFont = (LABEL_FONT_OPTIONS.length > 1) ? constrain(idx / (float)(LABEL_FONT_OPTIONS.length - 1), 0, 1) : 0;
      drawSelectorSlider(layout.labelsFontSelector, tFont, "Font: " + LABEL_FONT_OPTIONS[idx], LABEL_FONT_OPTIONS.length);
    }
    registerUiTooltip(layout.labelsArbitraryCheckbox, tooltipFor("render_labels_arbitrary"));
    registerUiTooltip(layout.labelsZonesCheckbox, tooltipFor("render_labels_zones"));
    registerUiTooltip(layout.labelsPathsCheckbox, tooltipFor("render_labels_paths"));
    registerUiTooltip(layout.labelsStructuresCheckbox, tooltipFor("render_labels_structures"));
    registerUiTooltip(layout.labelsArbSizeSlider, tooltipFor("render_labels_size_arbitrary"));
    registerUiTooltip(layout.labelsZoneSizeSlider, tooltipFor("render_labels_size_zone"));
    registerUiTooltip(layout.labelsPathSizeSlider, tooltipFor("render_labels_size_path"));
    registerUiTooltip(layout.labelsStructSizeSlider, tooltipFor("render_labels_size_struct"));
    registerUiTooltip(layout.labelsOutlineAlphaSlider, tooltipFor("render_labels_outline"));
    registerUiTooltip(layout.labelsOutlineSizeSlider, tooltipFor("render_labels_outline_size"));
    if (layout.labelsFontSelector != null) registerUiTooltip(layout.labelsFontSelector, tooltipFor("render_labels_font"));
  }

  drawSectionHeader(layout.headerGeneral, "General", renderSectionGeneralOpen);
  if (renderSectionGeneralOpen) {
    drawSlider(layout.exportPaddingSlider, constrain(renderSettings.exportPaddingPct / 0.10f, 0, 1), "Export padding (" + nf(renderSettings.exportPaddingPct * 100.0f, 1, 1) + "%)");
    drawCheckbox(layout.antialiasCheckbox.x, layout.antialiasCheckbox.y, layout.antialiasCheckbox.w, renderSettings.antialiasing, "Antialiasing");
    registerUiTooltip(layout.exportPaddingSlider, tooltipFor("render_export_padding"));
    registerUiTooltip(layout.antialiasCheckbox, tooltipFor("render_antialias"));

    // Preset selector
    if (renderPresets != null && renderPresets.length > 0) {
      IntRect ps = layout.presetSelector;
      int n = renderPresets.length;
      int maxIdx = max(1, n - 1);
      float t = constrain(renderSettings.activePresetIndex / (float)maxIdx, 0, 1);
      String presetName = renderPresets[renderSettings.activePresetIndex].name;
      drawSelectorSlider(ps, t, "Preset: " + presetName, n);
      registerUiTooltip(ps, tooltipFor("render_preset"));
    }

    if (layout.presetApplyBtn != null) {
      drawBevelButton(layout.presetApplyBtn.x, layout.presetApplyBtn.y, layout.presetApplyBtn.w, layout.presetApplyBtn.h, false);
      fill(10);
      textAlign(CENTER, CENTER);
      text("Apply preset", layout.presetApplyBtn.x + layout.presetApplyBtn.w / 2, layout.presetApplyBtn.y + layout.presetApplyBtn.h / 2);
      registerUiTooltip(layout.presetApplyBtn, tooltipFor("render_preset_apply"));
    }
  }
}

public void drawSectionHeader(IntRect header, String label, boolean isOpen) {
  if (header == null) return;
  drawBevelButton(header.x, header.y, header.w, header.h, false);
  fill(10);
  textAlign(LEFT, CENTER);
  String caret = isOpen ? "-" : "+";
  text(caret + " " + label, header.x + 8, header.y + header.h / 2);
}

public void drawSlider(IntRect r, float tNorm, String label) {
  drawSlider(r, tNorm, label, false, true);
}

public void drawSlider(IntRect r, float tNorm, String label, boolean zeroTick) {
  drawSlider(r, tNorm, label, zeroTick, true);
}

public void drawSlider(IntRect r, float tNorm, String label, boolean zeroTick, boolean showCursor) {
  if (r == null) return;
  float t = constrain(tNorm, 0, 1);
  int trackY = r.y + r.h / 2;
  int padding = max(4, r.h / 2);
  int startX = r.x + padding;
  int endX = r.x + r.w - padding;

  // Track
  stroke(120);
  line(startX, trackY, endX, trackY);
  if (zeroTick) {
    int zx = startX + (endX - startX) / 2;
    stroke(80);
    line(zx, trackY - r.h / 2, zx, trackY - r.h / 2 + 6);
  }

  if (showCursor) {
    // Cursor with pointy tip
    int cursorX = round(lerp(startX, endX, t));
    int cursorW = max(8, round(r.h * 0.55f));
    int cursorH = round(r.h * 0.8f);
    int cursorY = r.y + (r.h - cursorH) / 2;
    noStroke();
    fill(236);
    rect(cursorX - cursorW / 2, cursorY, cursorW, cursorH);
    stroke(255);
    line(cursorX - cursorW / 2, cursorY, cursorX + cursorW / 2, cursorY);
    line(cursorX - cursorW / 2, cursorY, cursorX - cursorW / 2, cursorY + cursorH);
    stroke(96);
    line(cursorX - cursorW / 2, cursorY + cursorH, cursorX + cursorW / 2, cursorY + cursorH);
    line(cursorX + cursorW / 2, cursorY, cursorX + cursorW / 2, cursorY + cursorH);
  }

  fill(0);
  textAlign(LEFT, BOTTOM);
  text(label, r.x, r.y - 4);
}

public void drawSelectorSlider(IntRect r, float tNorm, String label, int divisions) {
  drawSelectorSlider(r, tNorm, label, divisions, true);
}

public void drawSelectorSlider(IntRect r, float tNorm, String label, int divisions, boolean showCursor) {
  if (r == null) return;
  int steps = max(2, divisions);
  float t = constrain(tNorm, 0, 1);
  int trackY = r.y + r.h / 2;
  int padding = max(4, r.h / 2);
  int startX = r.x + padding;
  int endX = r.x + r.w - padding;

  stroke(120);
  line(startX, trackY, endX, trackY);

  stroke(60);
  for (int i = 0; i < steps; i++) {
    float tt = (float)i / (float)(steps - 1);
    int tx = round(lerp(startX, endX, tt));
    line(tx, trackY - r.h / 2, tx, trackY - r.h / 2 + 6);
  }

  if (showCursor) {
    // Same pointer as sliders
    int cursorX = round(lerp(startX, endX, t));
    int cursorW = max(8, round(r.h * 0.55f));
    int cursorH = round(r.h * 0.8f);
    int cursorY = r.y + (r.h - cursorH) / 2;
    noStroke();
    fill(236);
    rect(cursorX - cursorW / 2, cursorY, cursorW, cursorH);
    stroke(255);
    line(cursorX - cursorW / 2, cursorY, cursorX + cursorW / 2, cursorY);
    line(cursorX - cursorW / 2, cursorY, cursorX - cursorW / 2, cursorY + cursorH);
    stroke(96);
    line(cursorX - cursorW / 2, cursorY + cursorH, cursorX + cursorW / 2, cursorY + cursorH);
    line(cursorX + cursorW / 2, cursorY, cursorX + cursorW / 2, cursorY + cursorH);
  }

  fill(0);
  textAlign(LEFT, BOTTOM);
  text(label, r.x, r.y - 4);
}

public void drawHSBRow(IntRect[] sliders, String label, float h, float s, float b) {
  if (sliders == null || sliders.length < 3) return;
  fill(0);
  textAlign(LEFT, BOTTOM);
  text(label, sliders[0].x, sliders[0].y - 16);
  String[] names = { "hue", "saturation", "brightness" };
  float[] vals = { h, s, b };
  for (int i = 0; i < 3; i++) {
    IntRect r = sliders[i];
    if (r == null) continue;
    drawSlider(r, vals[i], names[i]);
  }
}

// ---------- UI helpers ----------

public String placementModeLabel(PlacementMode m) {
  switch (m) {
    case GRID:    return "Grid";
    case POISSON: return "Poisson-disc";
    case HEX:     return "Hexagonal";
  }
  return "Unknown";
}

public PlacementMode currentPlacementMode() {
  int idx = constrain(placementModeIndex, 0, placementModes.length - 1);
  return placementModes[idx];
}

public PathRouteMode currentPathRouteMode() {
  PathRouteMode fromType = null;
  if (mapModel != null && mapModel.pathTypes != null && activePathTypeIndex >= 0 && activePathTypeIndex < mapModel.pathTypes.size()) {
    PathType pt = mapModel.pathTypes.get(activePathTypeIndex);
    if (pt != null) fromType = pt.routeMode;
  }
  if (fromType != null) return fromType;
  int idx = constrain(pathRouteModeIndex, 0, 1);
  if (idx == 0) return PathRouteMode.ENDS;
  return PathRouteMode.PATHFIND;
}

public void drawTabButton(IntRect r, boolean active) {
  if (r == null) return;
  rectMode(CORNER);
  boolean held = isButtonHeld(r);
  int baseBg = color(245);
  int face = active ? baseBg : color(216);
  if (held) face = color(200);
  noStroke();
  fill(face);
  rect(r.x, r.y, r.w, r.h);
  stroke(255);
  line(r.x, r.y, r.x + r.w - 1, r.y);
  line(r.x, r.y, r.x, r.y + r.h - 1);
  stroke(active ? baseBg : color(160));
  // Skip bottom line so tab blends into panel
  stroke(96);
  line(r.x + r.w - 1, r.y, r.x + r.w - 1, r.y + r.h - 1);
}

public void drawBevelButton(int x, int y, int w, int h, boolean pressed) {
  // Guard against world draw state leaking (e.g., rectMode(CENTER))
  rectMode(CORNER);
  IntRect r = new IntRect(x, y, w, h);
  boolean held = isButtonHeld(r);
  boolean pressState = pressed || held;
  int face = pressState ? color(192) : color(224);
  int hl = color(255);
  int sh = color(96);

  noStroke();
  fill(face);
  rect(x, y, w, h);

  if (!pressState) {
    stroke(hl);
    line(x, y, x + w - 1, y);
    line(x, y, x, y + h - 1);
    stroke(sh);
    line(x, y + h - 1, x + w - 1, y + h - 1);
    line(x + w - 1, y, x + w - 1, y + h - 1);
  } else {
    stroke(sh);
    line(x, y, x + w - 1, y);
    line(x, y, x, y + h - 1);
    stroke(hl);
    line(x, y + h - 1, x + w - 1, y + h - 1);
    line(x + w - 1, y, x + w - 1, y + h - 1);
  }
}

public void drawRadioButton(IntRect r, boolean selected) {
  // Checkbox-like bevel
  drawBevelButton(r.x, r.y, r.w, r.h, false);
  // Radio dot
  float cx = r.x + r.w * 0.5f;
  float cy = r.y + r.h * 0.5f;
  float inner = min(r.w, r.h) * 0.4f;
  if (selected) {
    noStroke();
    fill(0);
    ellipse(cx, cy, inner, inner);
  }
}

public void drawCheckbox(int x, int y, int size, boolean on, String label) {
  stroke(80);
  fill(on ? 200 : 245);
  rect(x, y, size, size);
  if (on) {
    line(x + 3, y + size / 2, x + size / 2, y + size - 3);
    line(x + size / 2, y + size - 3, x + size - 3, y + 3);
  }
  fill(0);
  textAlign(LEFT, CENTER);
  text(label, x + size + 6, y + size / 2);
}

public void drawControlsHint(IntRect panel, String... linesArr) {
  if (panel == null || linesArr == null) return;
  ArrayList<String> lines = new ArrayList<String>();
  for (String s : linesArr) {
    if (s != null && s.length() > 0) lines.add(s);
  }
  if (lines.isEmpty()) return;

  float totalH = lines.size() * (PANEL_LABEL_H + 2);
  float yTop = panel.y + panel.h - PANEL_PADDING - totalH;
  float sepY = yTop - 4;

  // Separator to visually isolate hints from controls above
  stroke(140);
  line(panel.x + PANEL_PADDING, sepY, panel.x + panel.w - PANEL_PADDING, sepY);

  fill(40);
  textAlign(LEFT, TOP);
  float y = yTop;
  for (String s : lines) {
    text(s, panel.x + PANEL_PADDING, y);
    y += PANEL_LABEL_H + 2;
  }
}

public IntRect getActivePanelRect() {
  switch (currentTool) {
    case EDIT_SITES: {
      SitesLayout l = buildSitesLayout();
      return l.panel;
    }
    case EDIT_ELEVATION: {
      ElevationLayout l = buildElevationLayout();
      return l.panel;
    }
    case EDIT_BIOMES: {
      BiomesLayout l = buildBiomesLayout();
      return l.panel;
    }
    case EDIT_ZONES: { ZonesLayout l = buildZonesLayout(); return l.panel; }
    case EDIT_STRUCTURES: {
      StructuresLayout l = buildStructuresLayout();
      return l.panel;
    }
    case EDIT_PATHS: {
      PathsLayout l = buildPathsLayout();
      return l.panel;
    }
    case EDIT_LABELS: {
      LabelsLayout l = buildLabelsLayout();
      return l.panel;
    }
    case EDIT_RENDER: {
      RenderLayout l = buildRenderLayout();
      return l.panel;
    }
    case EDIT_EXPORT: {
      ExportLayout l = buildExportLayout();
      return l.panel;
    }
  }
  return null;
}
// Split from UI_Panels.pde: labels panel and list rendering.

// ----- LABELS PANEL -----
class LabelsLayout {
  IntRect panel;
  int titleY;
  IntRect genButton;
  IntRect commentField;
}

class LabelsListLayout {
  IntRect panel;
  int titleY;
  IntRect deselectBtn;
  ArrayList<LabelRowLayout> rows = new ArrayList<LabelRowLayout>();
  int rowsStartY;
  int rowsViewH;
  float contentH;
  IntRect scrollbar;
}

class LabelRowLayout {
  int index;
  IntRect selectRect;
  IntRect nameRect;
  IntRect delRect;
}

public LabelsLayout buildLabelsLayout() {
  LabelsLayout l = new LabelsLayout();
  l.panel = new IntRect(PANEL_X, panelTop(), PANEL_W, 0);
  int curY = l.panel.y + PANEL_PADDING;
  l.titleY = curY;
  curY += PANEL_TITLE_H + PANEL_SECTION_GAP;
  l.genButton = new IntRect(l.panel.x + PANEL_PADDING, curY, 140, PANEL_BUTTON_H);
  curY += PANEL_BUTTON_H + PANEL_ROW_GAP;
  l.commentField = new IntRect(l.panel.x + PANEL_PADDING, curY + PANEL_LABEL_H, PANEL_W - 2 * PANEL_PADDING, PANEL_BUTTON_H);
  curY += PANEL_LABEL_H + PANEL_BUTTON_H + PANEL_ROW_GAP;
  curY += hintHeight(3);
  l.panel.h = curY - l.panel.y;
  return l;
}

public void drawLabelsPanel() {
  LabelsLayout layout = buildLabelsLayout();
  drawPanelBackground(layout.panel);

  int labelX = layout.panel.x + PANEL_PADDING;
  fill(0);
  textAlign(LEFT, TOP);
  text("Labels", labelX, layout.titleY);

  // Generate button
  {
    IntRect gb = layout.genButton;
    drawBevelButton(gb.x, gb.y, gb.w, gb.h, false);
    fill(10);
    textAlign(CENTER, CENTER);
    text("Generate labels", gb.x + gb.w / 2, gb.y + gb.h / 2);
  }

  // Comment field (selected label)
  {
    IntRect cf = layout.commentField;
    fill(0);
    textAlign(LEFT, BOTTOM);
    text("Comment", cf.x, cf.y - 4);
    stroke(80);
    fill(255);
    rect(cf.x, cf.y, cf.w, cf.h);
    fill(0);
    textAlign(LEFT, CENTER);
    String shown = "";
    if (selectedLabelIndex >= 0 && selectedLabelIndex < mapModel.labels.size()) {
      MapLabel l = mapModel.labels.get(selectedLabelIndex);
      if (l != null && l.comment != null && editingLabelCommentIndex != selectedLabelIndex) shown = l.comment;
      if (editingLabelCommentIndex == selectedLabelIndex) shown = labelCommentDraft;
    }
    text(shown, cf.x + 6, cf.y + cf.h / 2);
    if (editingLabelCommentIndex == selectedLabelIndex) {
      float caretX = cf.x + 6 + textWidth(labelCommentDraft);
      stroke(0);
      line(caretX, cf.y + 4, caretX, cf.y + cf.h - 4);
    }
  }

  drawControlsHint(layout.panel,
                   "left-click: place",
                   "right-click pan",
                   "wheel: zoom");
}

public LabelsListLayout buildLabelsListLayout() {
  LabelsListLayout l = new LabelsListLayout();
  int w = RIGHT_PANEL_W;
  int x = width - w - PANEL_PADDING;
  int y = panelTop();
  l.panel = new IntRect(x, y, w, height - y - PANEL_PADDING);
  l.titleY = y + PANEL_PADDING;
  int btnY = l.titleY + PANEL_TITLE_H + PANEL_SECTION_GAP;
  l.deselectBtn = new IntRect(x + PANEL_PADDING, btnY, 90, PANEL_BUTTON_H);
  return l;
}

public void populateLabelsListRows(LabelsListLayout layout) {
  layout.rows.clear();
  int labelX = layout.panel.x + PANEL_PADDING;
  int startY = layout.deselectBtn.y + layout.deselectBtn.h + PANEL_SECTION_GAP;
  int maxY = layout.panel.y + layout.panel.h - PANEL_SECTION_GAP;
  int viewH = max(0, maxY - startY);
  int rowH = 24;
  int rowGap = 6;
  int totalRows = (mapModel != null && mapModel.labels != null) ? mapModel.labels.size() : 0;
  int contentH = (totalRows > 0) ? totalRows * (rowH + rowGap) - rowGap : 0;
  layout.rowsStartY = startY;
  layout.rowsViewH = viewH;
  layout.contentH = contentH;
  layout.scrollbar = new IntRect(layout.panel.x + layout.panel.w - SCROLLBAR_W, startY, SCROLLBAR_W, viewH);
  labelsListScroll = clampScroll(labelsListScroll, contentH, viewH);
  int curY = startY - round(labelsListScroll);

  for (int i = 0; i < totalRows; i++) {
    if (curY > maxY) break;
    if (curY + rowH < startY) {
      curY += rowH + rowGap;
      continue;
    }
    LabelRowLayout row = new LabelRowLayout();
    row.index = i;
    int selectW = 18;
    row.selectRect = new IntRect(labelX, curY, selectW, rowH);
    row.nameRect = new IntRect(labelX + selectW + 6, curY, layout.panel.w - 2 * PANEL_PADDING - SCROLLBAR_W - selectW - 6 - 30, rowH);
    row.delRect = new IntRect(row.nameRect.x + row.nameRect.w + 4, curY, 24, rowH);
    layout.rows.add(row);
    curY += rowH + rowGap;
  }
}

public void drawLabelsListPanel() {
  LabelsListLayout layout = buildLabelsListLayout();
  populateLabelsListRows(layout);
  drawPanelBackground(layout.panel);

  int labelX = layout.panel.x + PANEL_PADDING;
  int curY = layout.titleY;
  fill(0);
  textAlign(LEFT, TOP);
  text("Labels", labelX, curY);
  curY += PANEL_TITLE_H + PANEL_SECTION_GAP;

  drawBevelButton(layout.deselectBtn.x, layout.deselectBtn.y, layout.deselectBtn.w, layout.deselectBtn.h, false);
  fill(10);
  textAlign(CENTER, CENTER);
  text("Deselect", layout.deselectBtn.x + layout.deselectBtn.w / 2, layout.deselectBtn.y + layout.deselectBtn.h / 2);
  registerUiTooltip(layout.deselectBtn, tooltipFor("labels_deselect"));
  curY = layout.deselectBtn.y + layout.deselectBtn.h + PANEL_SECTION_GAP;

  for (int i = 0; i < layout.rows.size(); i++) {
    LabelRowLayout row = layout.rows.get(i);
    if (row.index < 0 || row.index >= mapModel.labels.size()) continue;
    MapLabel lbl = mapModel.labels.get(row.index);
    boolean selected = (selectedLabelIndex == row.index);
    drawRadioButton(row.selectRect, selected);

    boolean editing = (editingLabelIndex == row.index);
    if (editing) {
      stroke(60);
      fill(255);
      rect(row.nameRect.x, row.nameRect.y, row.nameRect.w, row.nameRect.h);
      fill(0);
      textAlign(LEFT, CENTER);
      text(labelDraft, row.nameRect.x + 6, row.nameRect.y + row.nameRect.h / 2);
      float caretX = row.nameRect.x + 6 + textWidth(labelDraft);
      stroke(0);
      line(caretX, row.nameRect.y + 4, caretX, row.nameRect.y + row.nameRect.h - 4);
    } else {
      drawBevelButton(row.nameRect.x, row.nameRect.y, row.nameRect.w, row.nameRect.h, selected);
      fill(10);
      textAlign(LEFT, CENTER);
      text(lbl.text, row.nameRect.x + 6, row.nameRect.y + row.nameRect.h / 2);
    }

    drawBevelButton(row.delRect.x, row.delRect.y, row.delRect.w, row.delRect.h, false);
    fill(10);
    textAlign(CENTER, CENTER);
    text("X", row.delRect.x + row.delRect.w / 2, row.delRect.y + row.delRect.h / 2);
  }

  drawScrollbar(layout.scrollbar, layout.contentH, labelsListScroll);
}

public String labelTargetShort(LabelTarget lt) {
  switch (lt) {
    case BIOME: return "B";
    case ZONE: return "Z";
    case STRUCTURE: return "S";
    default: return "F";
  }
}
class UITooltipArea {
  IntRect rect;
  String text;
  UITooltipArea(IntRect rect, String text) {
    this.rect = rect;
    this.text = text;
  }
}

ArrayList<UITooltipArea> uiTooltipAreas = new ArrayList<UITooltipArea>();
String currentUiTooltip = "";

final int TOOLTIP_PANEL_WIDTH = 480;
final int TOOLTIP_PANEL_BASE_LINES = 3;

public void resetUiTooltips() {
  uiTooltipAreas.clear();
  currentUiTooltip = "";
}

public void registerUiTooltip(IntRect rect, String text) {
  if (rect == null || text == null || text.length() == 0) return;
  uiTooltipAreas.add(new UITooltipArea(rect, text));
  if (currentUiTooltip == null || currentUiTooltip.length() == 0) {
    if (rect.contains(mouseX, mouseY)) {
      currentUiTooltip = text;
    }
  }
}

public void refreshUiTooltip(int mx, int my) {
  currentUiTooltip = "";
  for (int i = uiTooltipAreas.size() - 1; i >= 0; i--) {
    UITooltipArea entry = uiTooltipAreas.get(i);
    if (entry != null && entry.rect != null && entry.rect.contains(mx, my)) {
      currentUiTooltip = entry.text;
      return;
    }
  }
}

public void drawUiTooltipPanel() {
  if (currentUiTooltip == null || currentUiTooltip.length() == 0) return;

  int panelW = min(TOOLTIP_PANEL_WIDTH, width - PANEL_PADDING * 2);
  if (panelW < 100) return;

  String[] lines = currentUiTooltip.split("\\n");
  int lineCount = lines.length;

  float lineHeight = PANEL_LABEL_H + 2;
  int effectiveLines = max(TOOLTIP_PANEL_BASE_LINES, lineCount);
  float panelH = effectiveLines * lineHeight + PANEL_PADDING * 2;
  int x = PANEL_PADDING;
  int y = height - PANEL_PADDING - round(panelH);

  noStroke();
  fill(255, 255, 255, 230);
  rect(x, y, panelW, panelH, 6);

  fill(20);
  textAlign(LEFT, TOP);
  float ty = y + PANEL_PADDING;
  for (String line : lines) {
    text(line, x + PANEL_PADDING, ty);
    ty += lineHeight;
  }
}

class Viewport {
  float centerX;
  float centerY;
  float zoom;

  Viewport() {
    centerX = 0.5f;
    centerY = 0.5f;
    zoom = 600.0f;  // 1x1 world fills a good part of the screen
  }

  public void applyTransform(PGraphics g) {
    applyTransform(g, g.width, g.height);
  }

  public void applyTransform(PGraphics g, float canvasWidth, float canvasHeight) {
    g.translate(canvasWidth * 0.5f, canvasHeight * 0.5f);
    g.scale(zoom);
    g.translate(-centerX, -centerY);
  }

  public void panScreen(float dxPixels, float dyPixels) {
    centerX -= dxPixels / zoom;
    centerY -= dyPixels / zoom;
  }

  public void zoomAt(float factor, float screenX, float screenY) {
    float wxBefore = (screenX - width * 0.5f) / zoom + centerX;
    float wyBefore = (screenY - height * 0.5f) / zoom + centerY;

    zoom *= factor;
    zoom = constrain(zoom, 50.0f, 5000.0f);

    float wxAfter = (screenX - width * 0.5f) / zoom + centerX;
    float wyAfter = (screenY - height * 0.5f) / zoom + centerY;

    centerX += wxBefore - wxAfter;
    centerY += wyBefore - wyAfter;
  }

  public PVector screenToWorld(float sx, float sy) {
    float wx = (sx - width * 0.5f) / zoom + centerX;
    float wy = (sy - height * 0.5f) / zoom + centerY;
    return new PVector(wx, wy);
  }

  public PVector worldToScreen(float wx, float wy) {
    return worldToScreen(wx, wy, width, height);
  }

  public PVector worldToScreen(float wx, float wy, float canvasW, float canvasH) {
    float sx = (wx - centerX) * zoom + canvasW * 0.5f;
    float sy = (wy - centerY) * zoom + canvasH * 0.5f;
    return new PVector(sx, sy);
  }
}


  static public void main(String[] passedArgs) {
    String[] appletArgs = new String[] { "Main" };
    if (passedArgs != null) {
      PApplet.main(concat(appletArgs, passedArgs));
    } else {
      PApplet.main(appletArgs);
    }
  }
}
