/*
 * Decompiled with CFR 0.152.
 */
import java.io.File;
import java.io.PrintWriter;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.PriorityQueue;
import java.util.WeakHashMap;
import java.util.function.Consumer;
import java.util.function.Function;
import processing.core.PApplet;
import processing.core.PFont;
import processing.core.PGraphics;
import processing.core.PImage;
import processing.core.PVector;
import processing.data.JSONArray;
import processing.data.JSONObject;
import processing.event.MouseEvent;
import processing.opengl.PGraphicsOpenGL;

public class Main
extends PApplet {
    Viewport viewport;
    MapModel mapModel;
    Tool currentTool = Tool.EDIT_SITES;
    boolean isPanning = false;
    int lastMouseX;
    int lastMouseY;
    Site draggingSite = null;
    boolean isDraggingSite = false;
    int selectedPathIndex = -1;
    PVector pendingPathStart = null;
    float structureSize = 0.02f;
    float structureAngleOffsetRad = 0.0f;
    float lastStructureSnapAngle = 0.0f;
    StructureSnapMode structureSnapMode = StructureSnapMode.NEXT_TO_PATH;
    StructureShape structureShape = StructureShape.RECTANGLE;
    float structureAspectRatio = 1.0f;
    float structureHue01 = 0.0f;
    float structureSat01 = 0.0f;
    float structureAlpha01 = 1.0f;
    float structureStrokePx = 1.4f;
    float zonesListScroll = 0.0f;
    float pathsListScroll = 0.0f;
    float structuresListScroll = 0.0f;
    float labelsListScroll = 0.0f;
    boolean useDefaultStructureNames = false;
    boolean useDefaultPathNames = false;
    boolean structSectionGenOpen = true;
    boolean structSectionSnapOpen = true;
    boolean structSectionAttrOpen = true;
    RenderSettings renderSettings = new RenderSettings();
    RenderPreset[] renderPresets = this.buildDefaultRenderPresets();
    boolean renderSectionBaseOpen = false;
    boolean renderSectionBiomesOpen = false;
    boolean renderSectionShadingOpen = false;
    boolean renderSectionCoastlinesOpen = false;
    boolean renderSectionElevationOpen = false;
    boolean renderSectionPathsOpen = false;
    boolean renderSectionZonesOpen = false;
    boolean renderSectionStructuresOpen = false;
    boolean renderSectionLabelsOpen = false;
    boolean renderSectionGeneralOpen = false;
    boolean snapWaterEnabled = true;
    boolean snapBiomesEnabled = false;
    boolean snapUnderwaterBiomesEnabled = false;
    boolean snapZonesEnabled = true;
    boolean snapPathsEnabled = true;
    boolean snapStructuresEnabled = true;
    boolean snapElevationEnabled = false;
    int snapElevationDivisions = 8;
    final int TOP_BAR_HEIGHT = 30;
    final int TOP_BAR_EXTRA_PAD = 4;
    final int TOP_BAR_TOTAL = 34;
    final int TOOL_BAR_HEIGHT = 26;
    final int PANEL_X = 0;
    final int PANEL_W = 320;
    final int PANEL_PADDING = 10;
    final int PANEL_ROW_GAP = 8;
    final int PANEL_SECTION_GAP = 12;
    final int PANEL_SLIDER_H = 16;
    final int PANEL_LABEL_H = 14;
    final int PANEL_BUTTON_H = 22;
    final int PANEL_CHECK_SIZE = 16;
    final int PANEL_TITLE_H = 18;
    final int RIGHT_PANEL_W = 260;
    final int SCROLLBAR_W = 14;
    final int SCROLLBAR_THUMB_MIN = 24;
    final int SCROLL_STEP_PX = 24;
    final float FLATTEST_BIAS_MIN = 0.0f;
    final float FLATTEST_BIAS_MAX = 1000.0f;
    final String[] LABEL_FONT_OPTIONS = new String[]{"SansSerif", "Serif", "Monospaced", "Arial", "Georgia"};
    PlacementMode[] placementModes = new PlacementMode[]{PlacementMode.GRID, PlacementMode.POISSON, PlacementMode.HEX};
    int placementModeIndex = 1;
    final int MAX_SITE_COUNT = 50000;
    final int DEFAULT_SITE_COUNT = 10000;
    int siteTargetCount = 10000;
    float siteFuzz = 0.0f;
    boolean keepPropertiesOnGenerate = false;
    int activeBiomeIndex = 1;
    int activeZoneIndex = 1;
    ZonePaintMode currentZonePaintMode = ZonePaintMode.ZONE_PAINT;
    ZonePaintMode currentBiomePaintMode = ZonePaintMode.ZONE_PAINT;
    int activePathTypeIndex = 0;
    int pathRouteModeIndex = 1;
    float zoneBrushRadius = 0.04f;
    float seaLevel = -0.2f;
    float elevationBrushRadius = 0.08f;
    float elevationBrushStrength = 0.05f;
    boolean elevationBrushRaise = true;
    float elevationNoiseScale = 8.0f;
    float defaultElevation = 0.05f;
    float renderLightAzimuthDeg = 220.0f;
    float renderLightAltitudeDeg = 45.0f;
    boolean useNewElevationShading = false;
    float flattestSlopeBias = 0.0f;
    boolean pathAvoidWater = false;
    boolean pathTaperRivers = false;
    boolean pathEraserMode = false;
    float pathEraserRadius = 0.04f;
    int PATH_MAX_EXPANSIONS = 4000;
    boolean PATH_BIDIRECTIONAL = true;
    int ELEV_STEPS_PATHS = 6;
    boolean siteDirtyDuringDrag = false;
    float renderPaddingPct = 0.01f;
    float exportScale = 1.0f;
    final float DEFAULT_VIEW_ZOOM = 600.0f;
    boolean fullGenRunning = false;
    int fullGenStep = 0;
    boolean fullGenPrimed = false;
    Tool prevTool = Tool.EDIT_SITES;
    boolean renderPrepRunning = false;
    boolean renderPrepDone = false;
    boolean renderPrepPrimed = false;
    String lastExportStatus = "";
    boolean renderContoursDirty = true;
    boolean renderForceDirtyAll = false;
    boolean renderingForExport = false;
    PGraphics exportPreview = null;
    boolean exportPreviewDirty = true;
    float[] exportPreviewRect = new float[4];
    int editingBiomeNameIndex = -1;
    String biomeNameDraft = "";
    int editingZoneNameIndex = -1;
    String zoneNameDraft = "";
    boolean editingZoneComment = false;
    String zoneCommentDraft = "";
    String[] biomeGenerateModes = new String[]{"Propagation", "Reset", "Fill gaps", "Replace gaps", "Fill under", "Fill above", "Extend", "Shrink", "Spots", "Vary", "Slice spot", "Full"};
    int biomeGenerateModeIndex = 0;
    float biomeGenerateValue01 = 0.75f;
    int editingLabelIndex = -1;
    int selectedLabelIndex = -1;
    String labelDraft = "label";
    LabelTarget labelTargetMode = LabelTarget.FREE;
    float labelSizeDefaultVal = 12.0f;
    int editingLabelCommentIndex = -1;
    String labelCommentDraft = "";
    int editingPathTypeNameIndex = -1;
    String pathTypeNameDraft = "";
    int editingPathNameIndex = -1;
    String pathNameDraft = "";
    int editingPathCommentIndex = -1;
    String pathCommentDraft = "";
    HashSet<Integer> selectedStructureIndices = new HashSet();
    int primaryStructureIndex = -1;
    boolean editingStructureName = false;
    int editingStructureNameIndex = -1;
    String structureNameDraft = "";
    boolean editingStructureComment = false;
    String structureCommentDraft = "";
    int structGenTownCount = 3;
    float structGenBuildingDensity = 0.5f;
    boolean isLoading = false;
    float loadingPhase = 0.0f;
    int loadingHoldFrames = 0;
    float loadingPct = 0.0f;
    String uiNotice = "";
    int uiNoticeFrames = 0;
    final int NOTICE_DURATION_FRAMES = 150;
    String loadingDetail = "";
    boolean progressActive = false;
    float progressPct = 0.0f;
    String progressDetail = "";
    String progressStatusMsg = "";
    final int SLIDER_NONE = 0;
    final int SLIDER_SITES_DENSITY = 1;
    final int SLIDER_SITES_FUZZ = 2;
    final int SLIDER_SITES_MODE = 3;
    final int SLIDER_BIOME_HUE = 4;
    final int SLIDER_BIOME_BRUSH = 5;
    final int SLIDER_ELEV_SEA = 6;
    final int SLIDER_ELEV_RADIUS = 7;
    final int SLIDER_ELEV_STRENGTH = 8;
    final int SLIDER_ELEV_NOISE = 9;
    final int SLIDER_PATH_TYPE_HUE = 10;
    final int SLIDER_PATH_TYPE_SAT = 11;
    final int SLIDER_PATH_TYPE_BRI = 12;
    final int SLIDER_PATH_TYPE_WEIGHT = 13;
    final int SLIDER_FLATTEST_BIAS = 14;
    final int SLIDER_RENDER_LIGHT_AZIMUTH = 15;
    final int SLIDER_RENDER_LIGHT_ALTITUDE = 16;
    final int SLIDER_STRUCT_SIZE = 17;
    final int SLIDER_ZONES_HUE = 18;
    final int SLIDER_ZONES_BRUSH = 19;
    final int SLIDER_STRUCT_ANGLE = 20;
    final int SLIDER_PATH_TYPE_MIN_WEIGHT = 21;
    final int SLIDER_STRUCT_RATIO = 22;
    final int SLIDER_ZONES_ROW_HUE = 23;
    final int SLIDER_STRUCT_SELECTED_SIZE = 24;
    final int SLIDER_STRUCT_SELECTED_ANGLE = 25;
    final int SLIDER_STRUCT_SELECTED_HUE = 26;
    final int SLIDER_STRUCT_SELECTED_ALPHA = 27;
    final int SLIDER_STRUCT_SELECTED_SAT = 28;
    final int SLIDER_STRUCT_SELECTED_STROKE = 29;
    final int SLIDER_RENDER_PADDING = 30;
    final int SLIDER_RENDER_LAND_H = 32;
    final int SLIDER_RENDER_LAND_S = 33;
    final int SLIDER_RENDER_LAND_B = 34;
    final int SLIDER_RENDER_WATER_H = 35;
    final int SLIDER_RENDER_WATER_S = 36;
    final int SLIDER_RENDER_WATER_B = 37;
    final int SLIDER_RENDER_CELL_BORDER_ALPHA = 38;
    final int SLIDER_RENDER_BIOME_FILL_ALPHA = 39;
    final int SLIDER_RENDER_BIOME_SAT = 40;
    final int SLIDER_RENDER_BIOME_OUTLINE_SIZE = 41;
    final int SLIDER_RENDER_BIOME_OUTLINE_ALPHA = 42;
    final int SLIDER_RENDER_WATER_DEPTH_ALPHA = 43;
    final int SLIDER_RENDER_LIGHT_ALPHA = 44;
    final int SLIDER_RENDER_WATER_CONTOUR_SIZE = 45;
    final int SLIDER_RENDER_WATER_RIPPLE_COUNT = 46;
    final int SLIDER_RENDER_WATER_RIPPLE_DIST = 47;
    final int SLIDER_RENDER_WATER_CONTOUR_H = 48;
    final int SLIDER_RENDER_WATER_CONTOUR_S = 49;
    final int SLIDER_RENDER_WATER_CONTOUR_B = 50;
    final int SLIDER_RENDER_WATER_CONTOUR_ALPHA = 51;
    final int SLIDER_RENDER_WATER_RIPPLE_ALPHA_START = 52;
    final int SLIDER_RENDER_WATER_RIPPLE_ALPHA_END = 53;
    final int SLIDER_RENDER_ELEV_LINES_COUNT = 54;
    final int SLIDER_RENDER_ELEV_LINES_ALPHA = 55;
    final int SLIDER_RENDER_PATH_SAT = 56;
    final int SLIDER_RENDER_ZONE_ALPHA = 57;
    final int SLIDER_RENDER_ZONE_SIZE = 58;
    final int SLIDER_RENDER_ZONE_SAT = 59;
    final int SLIDER_RENDER_LABEL_OUTLINE_ALPHA = 60;
    final int SLIDER_RENDER_BIOME_BRI = 62;
    final int SLIDER_RENDER_ZONE_BRI = 63;
    final int SLIDER_RENDER_PRESET_SELECT = 64;
    final int SLIDER_RENDER_PATH_BRI = 90;
    final int SLIDER_RENDER_LABEL_OUTLINE_SIZE = 91;
    final int SLIDER_RENDER_LABEL_SIZE_ARBITRARY = 92;
    final int SLIDER_RENDER_LABEL_SIZE_ZONES = 93;
    final int SLIDER_RENDER_LABEL_SIZE_PATHS = 94;
    final int SLIDER_RENDER_LABEL_SIZE_STRUCTS = 95;
    final int SLIDER_RENDER_LABEL_FONT = 96;
    final int SLIDER_BIOME_GEN_MODE = 65;
    final int SLIDER_BIOME_GEN_VALUE = 66;
    final int SLIDER_RENDER_BIOME_UNDERWATER_ALPHA = 67;
    final int SLIDER_RENDER_STRUCT_SHADOW_ALPHA = 68;
    final int SLIDER_BIOME_SAT = 69;
    final int SLIDER_BIOME_BRI = 70;
    final int SLIDER_RENDER_BACKGROUND_NOISE = 71;
    final int SLIDER_RENDER_WATER_HATCH_ANGLE = 72;
    final int SLIDER_RENDER_WATER_HATCH_LENGTH = 73;
    final int SLIDER_RENDER_WATER_HATCH_SPACING = 74;
    final int SLIDER_RENDER_WATER_HATCH_ALPHA = 75;
    final int SLIDER_RENDER_LIGHT_DITHER = 76;
    final int SLIDER_BIOME_PATTERN = 97;
    final int SLIDER_PATH_ROUTE_MODE = 98;
    final int SLIDER_STRUCT_GEN_TOWN = 99;
    final int SLIDER_STRUCT_GEN_BUILDING = 100;
    final int SLIDER_STRUCT_SNAP_DIV = 101;
    final int SLIDER_STRUCT_SHAPE = 102;
    final int SLIDER_STRUCT_ALIGNMENT = 103;
    final int SLIDER_RENDER_CELL_BORDER_SIZE = 104;
    final int SLIDER_RENDER_ELEV_LINES_SIZE = 105;
    final int SLIDER_RENDER_WATER_COAST_SIZE = 106;
    int activeSlider = 0;
    HashMap<String, String> TOOLTIP_TEXTS = new HashMap();
    ZonePreset[] ZONE_PRESETS = new ZonePreset[]{new ZonePreset("Dirt", this.color(210, 180, 140)), new ZonePreset("Rock", this.color(150, 150, 150)), new ZonePreset("Grassland", this.color(186, 206, 140)), new ZonePreset("Forest", this.color(110, 150, 95)), new ZonePreset("Sand", this.color(230, 214, 160)), new ZonePreset("Snow", this.color(235, 240, 245)), new ZonePreset("Wetland", this.color(165, 190, 155)), new ZonePreset("Magma", this.color(190, 70, 40)), new ZonePreset("Wet", this.color(80, 80, 150)), new ZonePreset("Shrubland", this.color(195, 205, 170)), new ZonePreset("Clay Flats", this.color(198, 176, 156)), new ZonePreset("Savannah", this.color(215, 196, 128)), new ZonePreset("Tundra", this.color(190, 200, 205)), new ZonePreset("Jungle", this.color(80, 130, 85)), new ZonePreset("Volcanic", this.color(105, 95, 90)), new ZonePreset("Heath", this.color(180, 160, 145)), new ZonePreset("Steppe", this.color(190, 185, 140)), new ZonePreset("Delta", this.color(170, 200, 175)), new ZonePreset("Glacier", this.color(220, 230, 240)), new ZonePreset("Mesa", this.color(205, 165, 120)), new ZonePreset("Moor", this.color(165, 155, 145)), new ZonePreset("Scrub", this.color(185, 175, 150))};
    PathTypePreset[] PATH_TYPE_PRESETS = new PathTypePreset[]{new PathTypePreset("Road", this.color(80, 80, 80), 3.0f, 1.2f, PathRouteMode.PATHFIND, 500.0f, true, false), new PathTypePreset("River", this.color(60, 90, 180), 8.0f, 2.0f, PathRouteMode.PATHFIND, 0.0f, false, true), new PathTypePreset("Bridge", this.color(130, 130, 160), 2.5f, 1.0f, PathRouteMode.ENDS, 0.0f, false, false), new PathTypePreset("Trail", this.color(140, 100, 70), 1.6f, 0.6f, PathRouteMode.PATHFIND, 0.0f, true, false), new PathTypePreset("Wall", this.color(90, 70, 50), 2.5f, 1.0f, PathRouteMode.ENDS, 0.0f, true, false), new PathTypePreset("Street", this.color(110, 110, 110), 2.2f, 0.8f, PathRouteMode.ENDS, 0.0f, false, false), new PathTypePreset("Highway", this.color(130, 130, 130), 2.5f, 1.0f, PathRouteMode.ENDS, 0.0f, false, false), new PathTypePreset("Canal", this.color(70, 110, 190), 2.4f, 1.0f, PathRouteMode.PATHFIND, 700.0f, false, true), new PathTypePreset("Rail", this.color(70, 70, 70), 2.8f, 1.2f, PathRouteMode.PATHFIND, 700.0f, true, false), new PathTypePreset("Pipeline", this.color(120, 120, 120), 2.0f, 0.8f, PathRouteMode.ENDS, 0.0f, true, false), new PathTypePreset("Path", this.color(0, 0, 0), 2.0f, 0.8f, PathRouteMode.ENDS, 0.0f, false, false)};
    IntRect pressedButtonRect = null;
    Runnable pendingButtonAction = null;
    final int PANEL_HINT_H = 50;
    ArrayList<UITooltipArea> uiTooltipAreas = new ArrayList();
    String currentUiTooltip = "";
    final int TOOLTIP_PANEL_WIDTH = 480;
    final int TOOLTIP_PANEL_BASE_LINES = 3;

    public float sliderNorm(IntRect r, int mx) {
        float startX;
        if (r == null) {
            return 0.0f;
        }
        int padding = Main.max((int)4, (int)(r.h / 2));
        float endX = r.x + r.w - padding;
        if (endX <= (startX = (float)(r.x + padding))) {
            return 0.0f;
        }
        return Main.constrain((float)(((float)mx - startX) / (endX - startX)), (float)0.0f, (float)1.0f);
    }

    public void markRenderDirty() {
        this.renderContoursDirty = true;
        this.renderPrepDone = false;
        this.renderForceDirtyAll = true;
        this.exportPreviewDirty = true;
        if (this.mapModel != null && this.mapModel.renderer != null) {
            this.mapModel.renderer.invalidateCoastCache();
            this.mapModel.renderer.invalidateBiomeCache();
            this.mapModel.renderer.invalidateBiomeOutlineLayer();
            this.mapModel.renderer.invalidateZoneCache();
            this.mapModel.renderer.invalidateLightCache();
            this.mapModel.renderer.invalidateCellBorderLayer();
            this.mapModel.renderer.invalidateElevationLineLayer();
            this.mapModel.renderer.invalidateWaterDetailLayer();
        }
    }

    public void markRenderVisualChange() {
        this.renderPrepDone = false;
        this.exportPreviewDirty = true;
    }

    public void markExportPreviewDirty() {
        this.exportPreviewDirty = true;
    }

    public void syncLegacyWaterContourAlpha(RenderSettings target) {
        if (target == null) {
            return;
        }
        target.waterContourAlpha01 = target.waterCoastAlpha01;
    }

    public float labelSizeDefault() {
        return this.labelSizeDefaultVal;
    }

    public void setLabelSizeDefault(float v) {
        this.labelSizeDefaultVal = Main.constrain((float)v, (float)4.0f, (float)72.0f);
    }

    public StructureSelectionInfo gatherStructureSelectionInfo() {
        StructureSelectionInfo info = new StructureSelectionInfo();
        info.sharedName = this.structureNameDraft;
        info.sharedComment = this.structureCommentDraft;
        info.sharedSize = this.structureSize;
        info.sharedAngleRad = this.structureAngleOffsetRad;
        info.sharedRatio = this.structureAspectRatio;
        info.sharedShape = this.structureShape;
        info.sharedAlignment = this.structureSnapMode;
        info.sharedHue = this.structureHue01;
        info.sharedSat = this.structureSat01;
        info.sharedAlpha = this.structureAlpha01;
        info.sharedStroke = this.structureStrokePx;
        if (this.mapModel == null || this.mapModel.structures == null || this.selectedStructureIndices == null || this.selectedStructureIndices.isEmpty()) {
            return info;
        }
        ArrayList<Integer> invalid = new ArrayList<Integer>();
        boolean first = true;
        for (int idx : this.selectedStructureIndices) {
            if (idx < 0 || idx >= this.mapModel.structures.size()) {
                invalid.add(idx);
                continue;
            }
            Structure s = this.mapModel.structures.get(idx);
            if (s == null) {
                invalid.add(idx);
                continue;
            }
            if (first) {
                info.sharedName = s.name != null ? s.name : "";
                info.sharedComment = s.comment != null ? s.comment : "";
                info.sharedSize = s.size;
                info.sharedAngleRad = s.angle;
                info.sharedRatio = s.aspect;
                info.sharedShape = s.shape;
                info.sharedAlignment = s.alignment;
                info.sharedHue = s.hue01;
                info.sharedSat = s.sat01;
                info.sharedAlpha = s.alpha01;
                info.sharedStroke = s.strokeWeightPx;
                first = false;
                continue;
            }
            if (!info.nameMixed) {
                String nm = s.name != null ? s.name : "";
                boolean bl = info.nameMixed = !nm.equals(info.sharedName);
            }
            if (!info.commentMixed) {
                String cm = s.comment != null ? s.comment : "";
                boolean bl = info.commentMixed = !cm.equals(info.sharedComment);
            }
            if (!info.sizeMixed && Main.abs((float)(info.sharedSize - s.size)) > 1.0E-6f) {
                info.sizeMixed = true;
            }
            if (!info.angleMixed && Main.abs((float)(info.sharedAngleRad - s.angle)) > 1.0E-6f) {
                info.angleMixed = true;
            }
            if (!info.ratioMixed && Main.abs((float)(info.sharedRatio - s.aspect)) > 1.0E-6f) {
                info.ratioMixed = true;
            }
            if (!info.shapeMixed && info.sharedShape != s.shape) {
                info.shapeMixed = true;
            }
            if (!info.alignmentMixed && info.sharedAlignment != s.alignment) {
                info.alignmentMixed = true;
            }
            if (!info.hueMixed && Main.abs((float)(info.sharedHue - s.hue01)) > 1.0E-6f) {
                info.hueMixed = true;
            }
            if (!info.satMixed && Main.abs((float)(info.sharedSat - s.sat01)) > 1.0E-6f) {
                info.satMixed = true;
            }
            if (!info.alphaMixed && Main.abs((float)(info.sharedAlpha - s.alpha01)) > 1.0E-6f) {
                info.alphaMixed = true;
            }
            if (info.strokeMixed || !(Main.abs((float)(info.sharedStroke - s.strokeWeightPx)) > 1.0E-6f)) continue;
            info.strokeMixed = true;
        }
        for (int idx : invalid) {
            this.selectedStructureIndices.remove(idx);
        }
        if (first) {
            return info;
        }
        info.hasSelection = true;
        if (!info.nameMixed) {
            this.structureNameDraft = info.sharedName;
        }
        if (!info.commentMixed) {
            this.structureCommentDraft = info.sharedComment;
        }
        if (!info.sizeMixed) {
            this.structureSize = info.sharedSize;
        }
        if (!info.angleMixed) {
            this.structureAngleOffsetRad = info.sharedAngleRad;
        }
        if (!info.ratioMixed) {
            this.structureAspectRatio = info.sharedRatio;
        }
        if (!info.shapeMixed) {
            this.structureShape = info.sharedShape;
        }
        if (!info.alignmentMixed) {
            this.structureSnapMode = info.sharedAlignment;
        }
        if (!info.hueMixed) {
            this.structureHue01 = info.sharedHue;
        }
        if (!info.satMixed) {
            this.structureSat01 = info.sharedSat;
        }
        if (!info.alphaMixed) {
            this.structureAlpha01 = info.sharedAlpha;
        }
        if (!info.strokeMixed) {
            this.structureStrokePx = info.sharedStroke;
        }
        return info;
    }

    public boolean isStructureSelected(int idx) {
        return this.selectedStructureIndices != null && this.selectedStructureIndices.contains(idx);
    }

    public void clearStructureSelection() {
        if (this.selectedStructureIndices != null) {
            this.selectedStructureIndices.clear();
        }
        this.primaryStructureIndex = -1;
        this.editingStructureName = false;
        this.editingStructureNameIndex = -1;
        this.editingStructureComment = false;
    }

    public void toggleStructureSelection(int idx) {
        if (this.selectedStructureIndices == null) {
            this.selectedStructureIndices = new HashSet();
        }
        if (this.selectedStructureIndices.contains(idx)) {
            this.selectedStructureIndices.remove(idx);
            if (this.primaryStructureIndex == idx) {
                this.primaryStructureIndex = this.selectedStructureIndices.isEmpty() ? -1 : this.selectedStructureIndices.iterator().next();
            }
        } else {
            this.selectedStructureIndices.add(idx);
            this.primaryStructureIndex = idx;
        }
        if (this.selectedStructureIndices.isEmpty()) {
            this.editingStructureName = false;
            this.editingStructureNameIndex = -1;
        }
    }

    public void selectStructureExclusive(int idx) {
        this.clearStructureSelection();
        if (this.selectedStructureIndices == null) {
            this.selectedStructureIndices = new HashSet();
        }
        if (idx >= 0) {
            this.selectedStructureIndices.add(idx);
            this.primaryStructureIndex = idx;
        }
    }

    public void shiftStructureSelectionAfterRemoval(int removedIdx) {
        if (this.selectedStructureIndices == null || this.selectedStructureIndices.isEmpty()) {
            return;
        }
        HashSet<Integer> updated = new HashSet<Integer>();
        for (int idx : this.selectedStructureIndices) {
            int adjusted;
            if (idx == removedIdx) continue;
            int n = adjusted = idx > removedIdx ? idx - 1 : idx;
            if (adjusted < 0) continue;
            updated.add(adjusted);
        }
        this.selectedStructureIndices = updated;
        if (!this.selectedStructureIndices.contains(this.primaryStructureIndex)) {
            int n = this.primaryStructureIndex = this.selectedStructureIndices.isEmpty() ? -1 : this.selectedStructureIndices.iterator().next();
        }
        if (this.selectedStructureIndices.isEmpty()) {
            this.editingStructureName = false;
            this.editingStructureNameIndex = -1;
        }
    }

    public void setProgressStatus(String msg) {
        if (msg == null) {
            msg = "";
        }
        if (!msg.equals(this.progressStatusMsg)) {
            this.progressStatusMsg = msg;
        }
    }

    public void applyRenderPreset(int idx) {
        if (this.renderPresets == null || this.renderPresets.length == 0) {
            return;
        }
        int clamped = Main.constrain((int)idx, (int)0, (int)(this.renderPresets.length - 1));
        RenderPreset p = this.renderPresets[clamped];
        if (p == null || p.values == null) {
            return;
        }
        this.renderSettings.applyFrom(p.values);
        this.renderSettings.activePresetIndex = clamped;
        this.syncLegacyWaterContourAlpha(this.renderSettings);
        this.renderPaddingPct = this.renderSettings.exportPaddingPct;
        this.markRenderDirty();
    }

    public void applyBiomeGeneration() {
        if (this.mapModel == null || this.mapModel.cells == null) {
            return;
        }
        int mode = Main.constrain((int)this.biomeGenerateModeIndex, (int)0, (int)(this.biomeGenerateModes.length - 1));
        int targetBiome = Main.constrain((int)this.activeBiomeIndex, (int)0, (int)(this.mapModel.biomeTypes.size() - 1));
        float val01 = Main.constrain((float)this.biomeGenerateValue01, (float)0.0f, (float)1.0f);
        float threshold = Main.lerp((float)-1.0f, (float)1.0f, (float)val01);
        switch (mode) {
            case 0: {
                this.mapModel.resetAllBiomesToNone();
                if (this.mapModel.cells == null || this.mapModel.cells.isEmpty()) break;
                int cellCount = this.mapModel.cells.size();
                int minSeeds = Main.max((int)1, (int)Main.round((float)((float)cellCount / 200.0f)));
                int maxSeeds = Main.max((int)1, (int)Main.round((float)((float)cellCount / 10.0f)));
                int seedCount = Main.constrain((int)Main.round((float)Main.lerp((float)minSeeds, (float)maxSeeds, (float)val01)), (int)1, (int)cellCount);
                this.mapModel.generateZonesFromSeeds(seedCount);
                break;
            }
            case 1: {
                this.mapModel.setAllBiomesTo(targetBiome);
                break;
            }
            case 2: {
                this.mapModel.fillGapsFromExistingBiomes();
                break;
            }
            case 3: {
                if (this.mapModel.cells == null || this.mapModel.cells.isEmpty()) break;
                int gapCount = 0;
                for (Cell c : this.mapModel.cells) {
                    if (c == null || c.biomeId != 0) continue;
                    ++gapCount;
                }
                if (gapCount <= 0) break;
                int minSeeds = Main.max((int)1, (int)Main.round((float)((float)gapCount / 200.0f)));
                int maxSeeds = Main.max((int)1, (int)Main.round((float)((float)gapCount / 10.0f)));
                int seedCount = Main.constrain((int)Main.round((float)Main.lerp((float)minSeeds, (float)maxSeeds, (float)val01)), (int)1, (int)gapCount);
                this.mapModel.fillGapsWithNewBiomesByCount(seedCount);
                break;
            }
            case 4: {
                this.mapModel.fillUnderThreshold(targetBiome, threshold);
                break;
            }
            case 5: {
                this.mapModel.fillAboveThreshold(targetBiome, threshold);
                break;
            }
            case 6: {
                int steps = Main.max((int)1, (int)Main.round((float)Main.lerp((float)1.0f, (float)30.0f, (float)val01)));
                int i = 0;
                while (i < steps) {
                    this.mapModel.extendBiomeOnce(targetBiome);
                    ++i;
                }
                break;
            }
            case 7: {
                int steps = Main.max((int)1, (int)Main.round((float)Main.lerp((float)1.0f, (float)30.0f, (float)val01)));
                int i = 0;
                while (i < steps) {
                    this.mapModel.shrinkBiomeOnce(targetBiome);
                    ++i;
                }
                break;
            }
            case 8: {
                if (this.mapModel.cells == null || this.mapModel.cells.isEmpty()) break;
                int n = this.mapModel.cells.size();
                int maxSpots = Main.max((int)1, (int)Main.min((int)30, (int)Main.round((float)((float)n / 200.0f))));
                int spotCount = Main.constrain((int)Main.round((float)Main.lerp((float)1.0f, (float)maxSpots, (float)val01)), (int)1, (int)maxSpots);
                this.mapModel.placeBiomeSpots(targetBiome, spotCount, 0.6f);
                break;
            }
            case 9: {
                int steps = Main.max((int)1, (int)Main.round((float)Main.lerp((float)1.0f, (float)20.0f, (float)val01)));
                int i = 0;
                while (i < steps) {
                    this.mapModel.varyBiomesOnce();
                    ++i;
                }
                break;
            }
            case 10: {
                this.mapModel.placeSliceSpot(targetBiome, val01, threshold);
                break;
            }
            default: {
                int forestIdx = this.ensureBiomeType("Forest");
                int wetIdx = this.ensureBiomeType("Wet");
                int sandIdx = this.ensureBiomeType("Sand");
                int rockIdx = this.ensureBiomeType("Rock");
                int snowIdx = this.ensureBiomeType("Snow");
                int magmaIdx = this.ensureBiomeType("Magma");
                int grassIdx = this.ensureBiomeType("Grassland");
                boolean hasNoneCell = false;
                int cellCount = this.mapModel.cells.size();
                int i = 0;
                while (i < cellCount && !hasNoneCell) {
                    if (this.mapModel.cells.get(i) != null) {
                        hasNoneCell = true;
                    }
                    ++i;
                }
                if (hasNoneCell) {
                    this.mapModel.resetAllBiomesToNone();
                }
                this.mapModel.fillGapsWithNewBiomes(150.0f);
                if (magmaIdx >= 0) {
                    i = 0;
                    while (i < 8) {
                        this.mapModel.shrinkBiomeOnce(magmaIdx);
                        ++i;
                    }
                }
                if (wetIdx >= 0) {
                    i = 0;
                    while (i < 8) {
                        this.mapModel.shrinkBiomeOnce(wetIdx);
                        ++i;
                    }
                }
                if (forestIdx >= 0) {
                    i = 0;
                    while (i < 5) {
                        this.mapModel.placeBiomeSpots(forestIdx, 0.5f);
                        ++i;
                    }
                }
                if (forestIdx >= 0) {
                    this.mapModel.placeSliceSpot(forestIdx, 0.8f, 0.24f);
                }
                if (rockIdx >= 0) {
                    this.mapModel.placeSliceSpot(rockIdx, 0.8f, 0.36f);
                }
                if (snowIdx >= 0) {
                    this.mapModel.fillAboveThreshold(snowIdx, 0.48f);
                }
                if (magmaIdx >= 0) {
                    this.mapModel.fillAboveThreshold(magmaIdx, 0.6f);
                }
                if (grassIdx >= 0) {
                    this.mapModel.extendBiomeOnce(grassIdx);
                }
                if (forestIdx >= 0) {
                    this.mapModel.shrinkBiomeOnce(forestIdx);
                }
                if (wetIdx >= 0) {
                    this.mapModel.fillUnderThreshold(wetIdx, this.seaLevel);
                }
                if (sandIdx >= 0) {
                    i = 0;
                    while (i < 7) {
                        this.mapModel.placeSliceSpot(sandIdx, 0.8f, this.seaLevel);
                        ++i;
                    }
                }
                this.mapModel.varyBiomesOnce();
            }
        }
        this.mapModel.renderer.invalidateBiomeOutlineCache();
        this.mapModel.snapDirty = true;
    }

    public void startFullGenerateFromCells() {
        if (this.mapModel == null) {
            return;
        }
        if (this.fullGenRunning) {
            return;
        }
        this.fullGenRunning = true;
        this.fullGenStep = 0;
        this.fullGenPrimed = false;
        this.loadingPct = 0.0f;
        this.startLoading();
    }

    public void resetAllMapData() {
        this.startLoading();
        try {
            this.mapModel = new MapModel();
            this.loadBiomePatternList();
            this.initBiomeTypes();
            this.initZones();
            this.initPathTypes();
            this.selectedPathIndex = -1;
            this.pendingPathStart = null;
            this.clearStructureSelection();
            this.selectedLabelIndex = -1;
            this.editingLabelIndex = -1;
            this.editingLabelCommentIndex = -1;
            this.labelDraft = "label";
            this.labelCommentDraft = "";
            this.editingPathNameIndex = -1;
            this.editingPathCommentIndex = -1;
            this.editingPathTypeNameIndex = -1;
            this.activeBiomeIndex = 1;
            this.activeZoneIndex = 1;
            this.labelsListScroll = 0.0f;
            this.structuresListScroll = 0.0f;
            this.pathsListScroll = 0.0f;
            this.zonesListScroll = 0.0f;
            this.mapModel.snapDirty = true;
            this.markRenderDirty();
        }
        finally {
            this.stopLoading();
            this.progressActive = false;
            this.progressDetail = "";
            this.progressPct = 0.0f;
        }
    }

    public void requestRenderPrep() {
        if (this.mapModel == null || this.mapModel.renderer == null) {
            return;
        }
        this.mapModel.renderer.resetRenderPrep(this.renderForceDirtyAll);
        this.renderForceDirtyAll = false;
        this.renderPrepRunning = false;
        this.renderPrepDone = true;
        this.renderPrepPrimed = false;
        this.exportPreviewDirty = true;
    }

    public void triggerRenderPrerequisites() {
        if (this.mapModel == null || this.renderSettings == null) {
            return;
        }
        if (this.renderSettings.waterRippleCount > 0 && this.renderSettings.waterRippleDistancePx > 1.0E-4f && (this.renderSettings.waterRippleAlphaStart01 > 1.0E-4f || this.renderSettings.waterRippleAlphaEnd01 > 1.0E-4f)) {
            int cols;
            int rows = cols = Main.max((int)80, (int)Main.min((int)200, (int)((int)Main.sqrt((float)Main.max((int)1, (int)this.mapModel.cells.size())))));
            this.mapModel.getCoastDistanceGrid(cols, rows, this.seaLevel);
        }
        if (this.renderSettings.elevationLinesCount > 0 && this.renderSettings.elevationLinesAlpha01 > 1.0E-4f) {
            this.mapModel.getElevationGridForRender(90, 90, this.seaLevel);
        }
    }

    public void triggerRenderPrerequisitesIfDirty() {
        if (this.mapModel == null || this.renderSettings == null) {
            return;
        }
        if (!this.renderContoursDirty) {
            return;
        }
        if (this.mapModel.isContourJobRunning()) {
            return;
        }
        this.renderContoursDirty = false;
        this.triggerRenderPrerequisites();
        if (this.currentTool == Tool.EDIT_RENDER || this.currentTool == Tool.EDIT_LABELS) {
            this.requestRenderPrep();
        }
    }

    public int ensureBiomeType(String name) {
        if (this.mapModel == null || this.mapModel.biomeTypes == null || name == null) {
            return -1;
        }
        int i = 0;
        while (i < this.mapModel.biomeTypes.size()) {
            ZoneType zt = this.mapModel.biomeTypes.get(i);
            if (zt != null && zt.name != null && zt.name.equalsIgnoreCase(name)) {
                return i;
            }
            ++i;
        }
        int col = this.color(200);
        ZonePreset[] zonePresetArray = this.ZONE_PRESETS;
        int n = this.ZONE_PRESETS.length;
        int n2 = 0;
        while (n2 < n) {
            ZonePreset zp = zonePresetArray[n2];
            if (zp != null && zp.name != null && zp.name.equalsIgnoreCase(name)) {
                col = zp.col;
                break;
            }
            ++n2;
        }
        ZoneType z = new ZoneType(name, col);
        z.patternIndex = this.mapModel.defaultPatternIndexForBiome(this.mapModel.biomeTypes.size());
        this.mapModel.biomeTypes.add(z);
        return this.mapModel.biomeTypes.size() - 1;
    }

    public float sliderFromElevation(float elev) {
        return Main.constrain((float)Main.map((float)elev, (float)-1.0f, (float)1.0f, (float)0.0f, (float)1.0f), (float)0.0f, (float)1.0f);
    }

    public int hsb01ToColor(float h, float s, float b) {
        this.colorMode(3, 1.0f);
        int c = this.color(Main.constrain((float)h, (float)0.0f, (float)1.0f), Main.constrain((float)s, (float)0.0f, (float)1.0f), Main.constrain((float)b, (float)0.0f, (float)1.0f));
        this.colorMode(1, 255.0f);
        return c;
    }

    public void settings() {
        this.size(1300, 800, "processing.opengl.PGraphics2D");
    }

    public void setup() {
        this.surface.setTitle("map designing tool");
        this.viewport = new Viewport();
        this.mapModel = new MapModel();
        this.applyRenderPreset(0);
        this.loadBiomePatternList();
        this.initBiomeTypes();
        this.initZones();
        this.initPathTypes();
        if (this.mapModel != null && this.mapModel.renderer != null) {
            this.mapModel.renderer.warmLabelFonts(this, this.renderSettings);
        }
        this.mapModel.generateSites(this.currentPlacementMode(), this.siteTargetCount);
        this.mapModel.ensureVoronoiComputed();
        this.seedDefaultZones();
        this.initTooltipTexts();
    }

    public void initBiomeTypes() {
        this.mapModel.biomeTypes.clear();
        ZoneType none = new ZoneType("None", this.color(235));
        none.patternIndex = this.mapModel.defaultPatternIndexForBiome(this.mapModel.biomeTypes.size());
        this.mapModel.biomeTypes.add(none);
        int initialCount = 5;
        int i = 0;
        while (i < initialCount && i < this.ZONE_PRESETS.length) {
            ZonePreset zp = this.ZONE_PRESETS[i];
            ZoneType z = new ZoneType(zp.name, zp.col);
            z.patternIndex = this.mapModel.defaultPatternIndexForBiome(this.mapModel.biomeTypes.size());
            this.mapModel.biomeTypes.add(z);
            ++i;
        }
        this.mapModel.syncBiomePatternAssignments();
    }

    public void initZones() {
        this.mapModel.zones.clear();
        this.activeZoneIndex = -1;
    }

    public void initPathTypes() {
        this.mapModel.pathTypes.clear();
        int initialCount = Main.min((int)4, (int)this.PATH_TYPE_PRESETS.length);
        int i = 0;
        while (i < initialCount) {
            PathType pt = this.mapModel.makePathTypeFromPreset(i);
            if (pt != null) {
                this.mapModel.pathTypes.add(pt);
            }
            ++i;
        }
        if (this.mapModel.pathTypes.isEmpty()) {
            this.mapModel.pathTypes.add(new PathType("Path", this.color(80), 2.0f, 1.0f, PathRouteMode.PATHFIND, 0.0f, true, false));
        }
        this.activePathTypeIndex = 0;
        this.syncActivePathTypeGlobals();
    }

    public void syncActivePathTypeGlobals() {
        if (this.mapModel == null || this.mapModel.pathTypes == null || this.mapModel.pathTypes.isEmpty()) {
            return;
        }
        this.activePathTypeIndex = Main.constrain((int)this.activePathTypeIndex, (int)0, (int)(this.mapModel.pathTypes.size() - 1));
        PathType pt = this.mapModel.pathTypes.get(this.activePathTypeIndex);
        if (pt == null) {
            return;
        }
        this.pathRouteModeIndex = pt.routeMode == PathRouteMode.ENDS ? 0 : 1;
        this.flattestSlopeBias = pt.slopeBias;
        this.pathAvoidWater = pt.avoidWater;
    }

    public void drawExportPaddingOverlay() {
        if (this.mapModel == null) {
            return;
        }
        float worldW = this.mapModel.maxX - this.mapModel.minX;
        float worldH = this.mapModel.maxY - this.mapModel.minY;
        float padX = Main.max((float)0.0f, (float)this.renderPaddingPct) * worldW;
        float padY = Main.max((float)0.0f, (float)this.renderPaddingPct) * worldH;
        float innerWX = this.mapModel.minX + padX;
        float innerWY = this.mapModel.minY + padY;
        float innerWW = Main.max((float)0.0f, (float)(worldW - padX * 2.0f));
        float innerWH = Main.max((float)0.0f, (float)(worldH - padY * 2.0f));
        if (innerWW <= 0.0f || innerWH <= 0.0f) {
            return;
        }
        PVector tl = this.viewport.worldToScreen(innerWX, innerWY);
        PVector br = this.viewport.worldToScreen(innerWX + innerWW, innerWY + innerWH);
        float innerX = Main.min((float)tl.x, (float)br.x);
        float innerY = Main.min((float)tl.y, (float)br.y);
        float innerW = Main.abs((float)(br.x - tl.x));
        float innerH = Main.abs((float)(br.y - tl.y));
        this.noStroke();
        this.fill(80.0f, 80.0f, 80.0f, 70.0f);
        this.rect(0.0f, 0.0f, this.width, innerY);
        this.rect(0.0f, innerY, innerX, innerH);
        this.rect(innerX + innerW, innerY, (float)this.width - (innerX + innerW), innerH);
        this.rect(0.0f, innerY + innerH, this.width, (float)this.height - (innerY + innerH));
        this.noFill();
        this.stroke(40.0f, 40.0f, 40.0f, 180.0f);
        this.strokeWeight(1.0f);
        this.rect(innerX, innerY, innerW, innerH);
    }

    public void draw() {
        boolean renderView;
        float combinedPct;
        this.background(245);
        this.loadingDetail = "";
        if (this.currentTool != this.prevTool) {
            if (this.currentTool == Tool.EDIT_EXPORT) {
                this.exportPreviewDirty = true;
            }
            this.prevTool = this.currentTool;
        }
        if (this.fullGenRunning) {
            if (!this.isLoading) {
                this.startLoading();
            }
            this.stepFullGenerateFromCells();
            if (this.fullGenStep > 5) {
                this.fullGenRunning = false;
                this.stopLoading();
                this.loadingDetail = "";
                this.loadingPct = 1.0f;
            }
        }
        this.mapModel.ensureVoronoiComputed();
        this.mapModel.stepContourJobs(6);
        boolean buildingVoronoi = this.mapModel.isVoronoiBuilding();
        boolean buildingContours = this.mapModel.isContourJobRunning();
        boolean building = buildingVoronoi || buildingContours;
        float pctVoronoi = this.mapModel.getVoronoiProgress();
        float pctContours = this.mapModel.getContourJobProgress();
        float f = combinedPct = buildingContours ? Main.min((float)pctVoronoi, (float)pctContours) : pctVoronoi;
        if (!this.fullGenRunning) {
            if (building) {
                if (buildingVoronoi) {
                    this.setProgressStatus("Generating cells...");
                } else if (buildingContours) {
                    this.setProgressStatus("Generating contours...");
                }
                if (!this.isLoading) {
                    this.startLoading();
                }
                this.loadingPct = combinedPct;
            } else {
                if (this.isLoading) {
                    this.stopLoading();
                }
                this.setProgressStatus("");
                if (this.uiNotice != null && this.uiNotice.equals("Generation in progress...")) {
                    this.uiNotice = "";
                    this.uiNoticeFrames = 0;
                }
                this.loadingPct = 1.0f;
            }
        } else if (!building && this.fullGenStep > 5) {
            this.fullGenRunning = false;
            this.stopLoading();
            this.loadingPct = 1.0f;
            this.loadingDetail = "";
            this.setProgressStatus("");
            this.progressActive = false;
            this.progressPct = 0.0f;
            if (this.uiNotice != null && this.uiNotice.equals("Generation in progress...")) {
                this.uiNotice = "";
                this.uiNoticeFrames = 0;
            }
        }
        if (this.fullGenRunning) {
            this.setProgressStatus(this.loadingDetail != null && this.loadingDetail.length() > 0 ? this.loadingDetail : "Generation in progress...");
        }
        boolean bl = renderView = this.currentTool == Tool.EDIT_RENDER || this.currentTool == Tool.EDIT_EXPORT;
        if (renderView && this.mapModel != null && this.mapModel.renderer != null) {
            if (this.mapModel.renderer.isRenderWorkNeeded()) {
                this.renderPrepRunning = true;
                this.progressActive = true;
                this.progressPct = Main.max((float)this.progressPct, (float)this.mapModel.renderer.renderPrepProgress());
                this.progressDetail = "Rendering " + this.mapModel.renderer.getRenderPrepStageLabel();
                if (!this.fullGenRunning) {
                    this.setProgressStatus("Rendering...");
                }
                boolean donePrep = this.mapModel.renderer.stepRenderPrep(this, this.renderSettings, this.seaLevel);
                this.progressPct = Main.max((float)this.progressPct, (float)this.mapModel.renderer.renderPrepProgress());
                if (donePrep || !this.mapModel.renderer.isRenderWorkNeeded()) {
                    this.renderPrepRunning = false;
                    this.progressActive = false;
                    this.progressDetail = "";
                    this.progressPct = 1.0f;
                    if (!this.fullGenRunning) {
                        this.setProgressStatus("");
                    }
                }
            } else {
                this.renderPrepRunning = false;
                this.progressActive = false;
                this.progressDetail = "";
                this.progressPct = 1.0f;
                if (!this.fullGenRunning) {
                    this.setProgressStatus("");
                }
            }
        } else {
            this.renderPrepRunning = false;
        }
        this.pushMatrix();
        this.viewport.applyTransform(this.g);
        boolean skipWorld = false;
        if (this.renderPrepRunning && (this.currentTool == Tool.EDIT_RENDER || this.currentTool == Tool.EDIT_LABELS || this.currentTool == Tool.EDIT_EXPORT)) {
            skipWorld = true;
        }
        if (renderView && !skipWorld) {
            this.triggerRenderPrerequisitesIfDirty();
            if (this.mapModel != null && this.mapModel.renderer != null) {
                if (this.mapModel.renderer.isRenderWorkNeeded()) {
                    this.renderPrepRunning = true;
                    this.progressActive = true;
                    this.progressPct = Main.max((float)this.progressPct, (float)this.mapModel.renderer.renderPrepProgress());
                    this.progressDetail = "Rendering " + this.mapModel.renderer.getRenderPrepStageLabel();
                    if (!this.fullGenRunning) {
                        this.setProgressStatus("Rendering...");
                    }
                    boolean donePrep = this.mapModel.renderer.stepRenderPrep(this, this.renderSettings, this.seaLevel);
                    this.progressPct = Main.max((float)this.progressPct, (float)this.mapModel.renderer.renderPrepProgress());
                    if (donePrep || !this.mapModel.renderer.isRenderWorkNeeded()) {
                        this.renderPrepRunning = false;
                        this.progressActive = false;
                        this.progressDetail = "";
                        this.progressPct = 1.0f;
                        if (!this.fullGenRunning) {
                            this.setProgressStatus("");
                        }
                    }
                } else {
                    this.renderPrepRunning = false;
                    this.progressActive = false;
                    this.progressDetail = "";
                    this.progressPct = 0.0f;
                    if (!this.fullGenRunning) {
                        this.setProgressStatus("");
                    }
                }
            }
            if (this.currentTool == Tool.EDIT_EXPORT) {
                this.drawExportPreviewView();
            } else {
                this.drawRenderView(this);
            }
        } else if (!skipWorld) {
            boolean allowLabels = this.renderSettings != null ? this.renderSettings.showLabelsArbitrary : true;
            switch (this.currentTool) {
                case EDIT_SITES: {
                    this.mapModel.drawCells(this, true);
                    this.mapModel.drawPaths(this, this.color(60, 60, 200), false, true);
                    this.mapModel.drawStructures(this);
                    if (allowLabels) {
                        this.mapModel.drawLabels(this);
                    }
                    this.mapModel.drawSites(this);
                    break;
                }
                case EDIT_ELEVATION: {
                    this.mapModel.drawCellsRender(this, false, true);
                    this.mapModel.drawElevationOverlay(this, this.seaLevel, false, true, true, false, 128);
                    this.mapModel.drawPaths(this, this.color(120), false, true);
                    this.mapModel.drawStructures(this);
                    if (allowLabels) {
                        this.mapModel.drawLabels(this);
                    }
                    this.drawElevationBrushPreview();
                    break;
                }
                case EDIT_BIOMES: {
                    this.mapModel.drawCells(this, true);
                    this.mapModel.drawPaths(this, this.color(60, 60, 200), false, true);
                    this.mapModel.drawStructures(this);
                    if (allowLabels) {
                        this.mapModel.drawLabels(this);
                    }
                    if (this.currentBiomePaintMode != ZonePaintMode.ZONE_PAINT) break;
                    this.drawZoneBrushPreview();
                    break;
                }
                case EDIT_ZONES: {
                    this.mapModel.drawCellsRender(this, false, true);
                    this.mapModel.drawElevationOverlay(this, this.seaLevel, false, true, true, false, this.ELEV_STEPS_PATHS);
                    this.mapModel.drawZoneOutlines(this);
                    this.mapModel.drawPaths(this, this.color(60, 60, 200), false, true);
                    this.mapModel.drawStructures(this);
                    if (allowLabels) {
                        this.mapModel.drawLabels(this);
                    }
                    if (this.currentZonePaintMode != ZonePaintMode.ZONE_PAINT) break;
                    this.drawZoneBrushPreview();
                    break;
                }
                case EDIT_PATHS: {
                    this.mapModel.drawCellsRender(this, false, true);
                    this.mapModel.drawElevationOverlay(this, this.seaLevel, false, true, true, false, this.ELEV_STEPS_PATHS);
                    this.mapModel.drawPaths(this, this.color(60, 60, 200), true, true);
                    this.mapModel.drawStructures(this);
                    if (allowLabels) {
                        this.mapModel.drawLabels(this);
                    }
                    this.drawPathSnappingPoints();
                    if (this.pathEraserMode) {
                        this.drawPathEraserPreview();
                    }
                    if (this.pendingPathStart == null) break;
                    PVector worldPos = this.viewport.screenToWorld(this.mouseX, this.mouseY);
                    worldPos.x = Main.constrain((float)worldPos.x, (float)this.mapModel.minX, (float)this.mapModel.maxX);
                    worldPos.y = Main.constrain((float)worldPos.y, (float)this.mapModel.minY, (float)this.mapModel.maxY);
                    PVector snapped = this.findNearestSnappingPoint(worldPos.x, worldPos.y, Float.MAX_VALUE);
                    PVector target = snapped != null ? snapped : this.pendingPathStart;
                    ArrayList<Object> route = null;
                    PathRouteMode mode = this.currentPathRouteMode();
                    if (mode == PathRouteMode.ENDS) {
                        route = new ArrayList<PVector>();
                        route.add(this.pendingPathStart);
                        route.add(target);
                    } else if (mode == PathRouteMode.PATHFIND && snapped != null) {
                        route = this.mapModel.findSnapPathFlattest(this.pendingPathStart, target);
                    }
                    if (route == null || route.size() < 2) {
                        route = new ArrayList();
                        route.add(this.pendingPathStart);
                        route.add(target);
                    }
                    PathType pt = null;
                    if (this.selectedPathIndex >= 0 && this.selectedPathIndex < this.mapModel.paths.size()) {
                        Path p = this.mapModel.paths.get(this.selectedPathIndex);
                        pt = this.mapModel.getPathType(p.typeId);
                    } else {
                        pt = this.mapModel.getPathType(this.activePathTypeIndex);
                    }
                    int col = pt != null ? pt.col : this.color(30, 30, 160);
                    float w = pt != null ? pt.weightPx : 2.0f;
                    Path tmp = new Path();
                    tmp.routes.add(route);
                    tmp.drawPreview(this, route, col, w);
                    this.pushStyle();
                    this.noStroke();
                    this.fill(255.0f, 180.0f, 0.0f, 200.0f);
                    float sr = 5.0f / this.viewport.zoom;
                    this.ellipse(this.pendingPathStart.x, this.pendingPathStart.y, sr, sr);
                    if (!route.isEmpty()) {
                        PVector end = (PVector)route.get(route.size() - 1);
                        float tr = 4.0f / this.viewport.zoom;
                        this.fill(80.0f, 120.0f, 240.0f, 160.0f);
                        this.ellipse(end.x, end.y, tr, tr);
                    }
                    this.popStyle();
                    break;
                }
                case EDIT_STRUCTURES: {
                    this.mapModel.drawCellsRender(this, false, true);
                    this.mapModel.drawElevationOverlay(this, this.seaLevel, false, true, true, false, this.ELEV_STEPS_PATHS);
                    this.mapModel.drawPaths(this, this.color(60, 60, 200), false, true);
                    this.mapModel.drawStructureSnapGuides(this);
                    this.mapModel.drawStructures(this);
                    if (allowLabels) {
                        this.mapModel.drawLabels(this);
                    }
                    this.drawStructurePreview();
                    break;
                }
                case EDIT_LABELS: {
                    this.mapModel.drawCellsRender(this, false, true);
                    this.mapModel.drawElevationOverlay(this, this.seaLevel, false, true, true, false, this.ELEV_STEPS_PATHS);
                    this.mapModel.drawPaths(this, this.color(60, 60, 200), false, true);
                    this.mapModel.drawStructures(this);
                    if (!allowLabels) break;
                    RenderSettings rs = new RenderSettings();
                    rs.showLabelsZones = true;
                    rs.showLabelsPaths = true;
                    rs.showLabelsStructures = true;
                    rs.showLabelsArbitrary = true;
                    rs.labelOutlineAlpha01 = 1.0f;
                    rs.labelOutlineSizePx = 2.0f;
                    this.mapModel.drawZoneLabelsRender(this, rs);
                    this.mapModel.drawPathLabelsRender(this, rs);
                    this.mapModel.drawStructureLabelsRender(this, rs);
                    this.mapModel.drawLabelsRender(this, rs);
                    break;
                }
                default: {
                    this.mapModel.drawCells(this, true);
                    this.mapModel.drawPaths(this, this.color(60, 60, 200), false, true);
                    this.mapModel.drawStructures(this);
                    if (allowLabels) {
                        this.mapModel.drawLabels(this);
                    }
                    this.mapModel.drawDebugWorldBounds(this);
                }
            }
        }
        this.popMatrix();
        if (renderView) {
            this.pushStyle();
            this.noFill();
            this.stroke(0);
            this.strokeWeight(2.0f);
            this.rect(1.0f, 1.0f, this.width - 2, this.height - 2);
            this.popStyle();
        }
        this.rectMode(0);
        this.ellipseMode(3);
        this.resetUiTooltips();
        if (renderView) {
            this.drawExportPaddingOverlay();
        }
        this.drawTopBar();
        this.drawToolButtons();
        if (this.currentTool == Tool.EDIT_SITES) {
            this.drawSitesPanel();
        } else if (this.currentTool == Tool.EDIT_ELEVATION) {
            this.drawElevationPanel();
        } else if (this.currentTool == Tool.EDIT_BIOMES) {
            this.drawBiomesPanel();
        } else if (this.currentTool == Tool.EDIT_ZONES) {
            this.drawZonesPanel();
            this.drawZonesListPanel();
        } else if (this.currentTool == Tool.EDIT_STRUCTURES) {
            this.drawStructuresPanelUI();
            this.drawStructuresListPanel();
        } else if (this.currentTool == Tool.EDIT_PATHS) {
            this.drawPathsPanel();
            this.drawPathsListPanel();
        } else if (this.currentTool == Tool.EDIT_LABELS) {
            this.drawLabelsPanel();
            this.drawLabelsListPanel();
        } else if (this.currentTool == Tool.EDIT_RENDER) {
            this.drawRenderPanel();
        } else if (this.currentTool == Tool.EDIT_EXPORT) {
            this.drawExportPanel();
        }
        this.refreshUiTooltip(this.mouseX, this.mouseY);
        this.drawUiTooltipPanel();
    }

    public void drawRenderView(PApplet app) {
        this.mapModel.drawRenderAdvanced(app, this.renderSettings, this.seaLevel);
        if (this.renderSettings.zoneStrokeAlpha01 > 1.0E-4f) {
            this.mapModel.drawZoneOutlinesRender(app, this.renderSettings);
        }
        if (this.renderSettings.waterCoastAboveZones && this.renderSettings.waterCoastAlpha01 > 1.0E-4f) {
            if (this.mapModel.renderer != null && this.mapModel.renderer.getCoastLayer() != null) {
                this.pushStyle();
                this.pushMatrix();
                this.resetMatrix();
                this.tint(255, Main.constrain((float)this.renderSettings.waterCoastAlpha01, (float)0.0f, (float)1.0f) * 255.0f);
                this.image((PImage)this.mapModel.renderer.getCoastLayer(), 0.0f, 0.0f);
                this.popMatrix();
                this.popStyle();
            } else if (this.mapModel.renderer != null) {
                this.mapModel.renderer.ensureCoastLayer(app, this.renderSettings, this.seaLevel);
            }
        }
        if (this.renderSettings.showPaths) {
            this.mapModel.drawPathsRender(app, this.renderSettings);
        }
        if (this.renderSettings.showStructures) {
            this.mapModel.drawStructuresRender(app, this.renderSettings);
        }
        if (this.renderingForExport && this.mapModel != null && this.mapModel.renderer != null) {
            PGraphics labels = this.mapModel.renderer.buildLabelLayer(this, this.renderSettings);
            if (labels != null) {
                this.pushMatrix();
                this.resetMatrix();
                this.image((PImage)labels, 0.0f, 0.0f);
                this.popMatrix();
            }
        } else {
            if (this.renderSettings.showLabelsZones) {
                this.mapModel.drawZoneLabelsRender(app, this.renderSettings);
            }
            if (this.renderSettings.showLabelsPaths) {
                this.mapModel.drawPathLabelsRender(app, this.renderSettings);
            }
            if (this.renderSettings.showLabelsStructures) {
                this.mapModel.drawStructureLabelsRender(app, this.renderSettings);
            }
            if (this.renderSettings.showLabelsArbitrary) {
                this.mapModel.drawLabelsRender(app, this.renderSettings);
            }
        }
    }

    public ArrayList<PVector> structureOutline(final Structure s) {
        final ArrayList<PVector> pts = new ArrayList<PVector>();
        if (s == null) {
            return pts;
        }
        final float r = s.size;
        final float asp = Main.max((float)0.1f, (float)s.aspect);
        final float cosA = Main.cos((float)s.angle);
        final float sinA = Main.sin((float)s.angle);
        Runnable addRectangle = new Runnable(){

            @Override
            public void run() {
                float[][] corners;
                float w = r;
                float h = r / asp;
                float[][] fArrayArray = corners = new float[][]{{-w * 0.5f, -h * 0.5f}, {w * 0.5f, -h * 0.5f}, {w * 0.5f, h * 0.5f}, {-w * 0.5f, h * 0.5f}};
                int n = corners.length;
                int n2 = 0;
                while (n2 < n) {
                    float[] c = fArrayArray[n2];
                    float rx = c[0] * cosA - c[1] * sinA;
                    float ry = c[0] * sinA + c[1] * cosA;
                    pts.add(new PVector(s.x + rx, s.y + ry));
                    ++n2;
                }
            }
        };
        switch (s.shape) {
            case RECTANGLE: {
                addRectangle.run();
                break;
            }
            case CIRCLE: {
                int segments = 24;
                float rx = r * 0.5f;
                float ry = r / asp * 0.5f;
                int i = 0;
                while (i < segments) {
                    float a = (float)Math.PI * 2 * (float)i / (float)segments;
                    float cx = Main.cos((float)a) * rx;
                    float cy = Main.sin((float)a) * ry;
                    float rxp = cx * cosA - cy * sinA;
                    float ryp = cx * sinA + cy * cosA;
                    pts.add(new PVector(s.x + rxp, s.y + ryp));
                    ++i;
                }
                break;
            }
            case TRIANGLE: {
                float[][] corners;
                float h = r / asp * 0.866f;
                float[][] cx = corners = new float[][]{{-r * 0.5f, h * 0.333f}, {r * 0.5f, h * 0.333f}, {0.0f, -h * 0.666f}};
                int a = corners.length;
                int i = 0;
                while (i < a) {
                    float[] c = cx[i];
                    float rx = c[0] * cosA - c[1] * sinA;
                    float ry = c[0] * sinA + c[1] * cosA;
                    pts.add(new PVector(s.x + rx, s.y + ry));
                    ++i;
                }
                break;
            }
            case HEXAGON: {
                float rad = r * 0.5f;
                int i = 0;
                while (i < 6) {
                    float a = Main.radians((float)(60 * i));
                    float cx = Main.cos((float)a) * rad;
                    float cy = Main.sin((float)a) * rad / asp;
                    float rx = cx * cosA - cy * sinA;
                    float ry = cx * sinA + cy * cosA;
                    pts.add(new PVector(s.x + rx, s.y + ry));
                    ++i;
                }
                break;
            }
            default: {
                addRectangle.run();
            }
        }
        return pts;
    }

    public float elevationAtPoint(float x, float y) {
        if (this.mapModel == null) {
            return 0.0f;
        }
        return this.mapModel.sampleElevationAt(x, y, this.seaLevel);
    }

    public JSONArray ringFromVertices(ArrayList<PVector> verts) {
        return this.ringFromVertices(verts, false);
    }

    public JSONArray ringFromVertices(ArrayList<PVector> verts, boolean includeZ) {
        JSONArray p;
        JSONArray ring = new JSONArray();
        if (verts == null || verts.size() < 3) {
            return ring;
        }
        for (PVector v : verts) {
            p = new JSONArray();
            p.append(v.x);
            p.append(v.y);
            if (includeZ) {
                p.append(this.elevationAtPoint(v.x, v.y));
            }
            ring.append(p);
        }
        PVector first = verts.get(0);
        PVector last = verts.get(verts.size() - 1);
        if (Main.abs((float)(first.x - last.x)) > 1.0E-6f || Main.abs((float)(first.y - last.y)) > 1.0E-6f) {
            p = new JSONArray();
            p.append(first.x);
            p.append(first.y);
            if (includeZ) {
                p.append(this.elevationAtPoint(first.x, first.y));
            }
            ring.append(p);
        }
        return ring;
    }

    public boolean samePoint(PVector a, PVector b) {
        if (this.mapModel == null) {
            return false;
        }
        return this.mapModel.keyFor(a.x, a.y).equals(this.mapModel.keyFor(b.x, b.y));
    }

    public ArrayList<ArrayList<PVector>> mergedPolygonsFromCells(ArrayList<Integer> cellIdxs) {
        ArrayList<ArrayList<PVector>> rings = new ArrayList<ArrayList<PVector>>();
        if (this.mapModel == null || this.mapModel.cells == null || cellIdxs == null) {
            return rings;
        }
        class Edge {
            PVector a;
            PVector b;

            Edge(PVector a, PVector b) {
                this.a = a;
                this.b = b;
            }
        }
        HashMap<String, Edge> boundary = new HashMap<String, Edge>();
        for (int ci : cellIdxs) {
            Cell c;
            if (ci < 0 || ci >= this.mapModel.cells.size() || (c = this.mapModel.cells.get(ci)) == null || c.vertices == null || c.vertices.size() < 2) continue;
            int vn = c.vertices.size();
            int i = 0;
            while (i < vn) {
                String kb;
                String key;
                PVector a = c.vertices.get(i);
                PVector b = c.vertices.get((i + 1) % vn);
                String ka = this.mapModel.keyFor(a.x, a.y);
                String string = key = ka.compareTo(kb = this.mapModel.keyFor(b.x, b.y)) <= 0 ? String.valueOf(ka) + "|" + kb : String.valueOf(kb) + "|" + ka;
                if (boundary.containsKey(key)) {
                    boundary.remove(key);
                } else {
                    boundary.put(key, new Edge(a, b));
                }
                ++i;
            }
        }
        ArrayList edges = new ArrayList(boundary.values());
        boolean[] used = new boolean[edges.size()];
        int ei = 0;
        while (ei < edges.size()) {
            if (!used[ei]) {
                Edge e = (Edge)edges.get(ei);
                ArrayList<PVector> ring = new ArrayList<PVector>();
                ring.add(e.a);
                ring.add(e.b);
                used[ei] = true;
                PVector start = e.a;
                PVector cur = e.b;
                boolean closed = false;
                while (!closed) {
                    PVector nxt;
                    int nextIdx = -1;
                    boolean reverse = false;
                    int j = 0;
                    while (j < edges.size()) {
                        if (!used[j]) {
                            Edge cand = (Edge)edges.get(j);
                            if (this.samePoint(cand.a, cur)) {
                                nextIdx = j;
                                reverse = false;
                                break;
                            }
                            if (this.samePoint(cand.b, cur)) {
                                nextIdx = j;
                                reverse = true;
                                break;
                            }
                        }
                        ++j;
                    }
                    if (nextIdx == -1) break;
                    Edge ne = (Edge)edges.get(nextIdx);
                    used[nextIdx] = true;
                    PVector pVector = nxt = reverse ? ne.a : ne.b;
                    if (reverse) {
                        PVector tmp = ne.a;
                        ne.a = ne.b;
                        ne.b = tmp;
                    }
                    if (this.samePoint(nxt, start)) {
                        closed = true;
                    }
                    ring.add(nxt);
                    cur = nxt;
                    if (ring.size() > 100000) break;
                }
                if (ring.size() >= 4) {
                    rings.add(ring);
                }
            }
            ++ei;
        }
        return rings;
    }

    public float[] elevationStatsForCells(ArrayList<Integer> cellIdxs) {
        if (cellIdxs == null || this.mapModel == null || this.mapModel.cells == null) {
            return null;
        }
        float minV = Float.MAX_VALUE;
        float maxV = -3.4028235E38f;
        float sum = 0.0f;
        int count = 0;
        for (int ci : cellIdxs) {
            Cell c;
            if (ci < 0 || ci >= this.mapModel.cells.size() || (c = this.mapModel.cells.get(ci)) == null) continue;
            float ev = c.elevation;
            minV = Main.min((float)minV, (float)ev);
            maxV = Main.max((float)maxV, (float)ev);
            sum += ev;
            ++count;
        }
        if (count == 0) {
            return null;
        }
        return new float[]{minV, maxV, sum / (float)count};
    }

    public float[] elevationStatsForPoints(ArrayList<PVector> pts) {
        if (pts == null || this.mapModel == null) {
            return null;
        }
        float minV = Float.MAX_VALUE;
        float maxV = -3.4028235E38f;
        float sum = 0.0f;
        int count = 0;
        for (PVector p : pts) {
            if (p == null) continue;
            float ev = this.elevationAtPoint(p.x, p.y);
            minV = Main.min((float)minV, (float)ev);
            maxV = Main.max((float)maxV, (float)ev);
            sum += ev;
            ++count;
        }
        if (count == 0) {
            return null;
        }
        return new float[]{minV, maxV, sum / (float)count};
    }

    public String exportGeoJson() {
        try {
            JSONObject props;
            JSONObject geom;
            JSONObject root = new JSONObject();
            root.setString("type", "FeatureCollection");
            JSONArray features = new JSONArray();
            if (this.mapModel != null && this.mapModel.zones != null && this.mapModel.cells != null) {
                int zi = 0;
                while (zi < this.mapModel.zones.size()) {
                    ArrayList<ArrayList<PVector>> rings;
                    MapModel.MapZone z = this.mapModel.zones.get(zi);
                    if (z != null && z.cells != null && !z.cells.isEmpty() && (rings = this.mergedPolygonsFromCells(z.cells)) != null && !rings.isEmpty()) {
                        JSONArray polys = new JSONArray();
                        for (ArrayList<PVector> r : rings) {
                            JSONArray ring = this.ringFromVertices(r, true);
                            if (ring.size() == 0) continue;
                            JSONArray poly = new JSONArray();
                            poly.append(ring);
                            polys.append(poly);
                        }
                        if (polys.size() != 0) {
                            float[] stats = this.elevationStatsForCells(z.cells);
                            geom = new JSONObject();
                            geom.setString("type", "MultiPolygon");
                            geom.setJSONArray("coordinates", polys);
                            props = new JSONObject();
                            props.setString("category", "zone");
                            props.setInt("zoneIndex", zi);
                            props.setString("name", z.name != null ? z.name : "");
                            props.setString("comment", z.comment != null ? z.comment : "");
                            if (stats != null) {
                                props.setFloat("elevMin", stats[0]);
                                props.setFloat("elevMax", stats[1]);
                                props.setFloat("elevMean", stats[2]);
                            }
                            JSONObject feat = new JSONObject();
                            feat.setString("type", "Feature");
                            feat.setJSONObject("geometry", geom);
                            feat.setJSONObject("properties", props);
                            features.append(feat);
                        }
                    }
                    ++zi;
                }
            }
            if (this.mapModel != null && this.mapModel.cells != null && this.mapModel.biomeTypes != null && !this.mapModel.biomeTypes.isEmpty()) {
                int biomeCount = this.mapModel.biomeTypes.size();
                int bid = 1;
                while (bid < biomeCount) {
                    ArrayList<ArrayList<PVector>> rings;
                    ArrayList<Integer> cellIdxs = new ArrayList<Integer>();
                    int ci = 0;
                    while (ci < this.mapModel.cells.size()) {
                        Cell c = this.mapModel.cells.get(ci);
                        if (c != null && c.biomeId == bid) {
                            cellIdxs.add(ci);
                        }
                        ++ci;
                    }
                    if (!cellIdxs.isEmpty() && (rings = this.mergedPolygonsFromCells(cellIdxs)) != null && !rings.isEmpty()) {
                        JSONArray polys = new JSONArray();
                        for (ArrayList<PVector> r : rings) {
                            JSONArray ring = this.ringFromVertices(r, true);
                            if (ring.size() == 0) continue;
                            JSONArray poly = new JSONArray();
                            poly.append(ring);
                            polys.append(poly);
                        }
                        if (polys.size() != 0) {
                            float[] stats = this.elevationStatsForCells(cellIdxs);
                            JSONObject geom2 = new JSONObject();
                            geom2.setString("type", "MultiPolygon");
                            geom2.setJSONArray("coordinates", polys);
                            JSONObject props2 = new JSONObject();
                            props2.setString("category", "biome");
                            props2.setInt("biomeIndex", bid);
                            ZoneType zt = this.mapModel.biomeTypes.get(bid);
                            props2.setString("name", zt != null && zt.name != null ? zt.name : "");
                            props2.setString("comment", "");
                            if (stats != null) {
                                props2.setFloat("elevMin", stats[0]);
                                props2.setFloat("elevMax", stats[1]);
                                props2.setFloat("elevMean", stats[2]);
                            }
                            JSONObject feat = new JSONObject();
                            feat.setString("type", "Feature");
                            feat.setJSONObject("geometry", geom2);
                            feat.setJSONObject("properties", props2);
                            features.append(feat);
                        }
                    }
                    ++bid;
                }
            }
            if (this.mapModel != null && this.mapModel.paths != null) {
                int pi = 0;
                while (pi < this.mapModel.paths.size()) {
                    Path p = this.mapModel.paths.get(pi);
                    if (p != null && p.routes != null) {
                        int ri = 0;
                        while (ri < p.routes.size()) {
                            ArrayList<PVector> seg = p.routes.get(ri);
                            if (seg != null && seg.size() >= 2) {
                                JSONArray coords = new JSONArray();
                                for (PVector v : seg) {
                                    if (v == null) continue;
                                    JSONArray pt = new JSONArray();
                                    pt.append(v.x);
                                    pt.append(v.y);
                                    pt.append(this.elevationAtPoint(v.x, v.y));
                                    coords.append(pt);
                                }
                                geom = new JSONObject();
                                geom.setString("type", "LineString");
                                geom.setJSONArray("coordinates", coords);
                                props = new JSONObject();
                                props.setString("category", "path");
                                props.setInt("pathIndex", pi);
                                props.setInt("routeIndex", ri);
                                props.setInt("pathTypeId", p.typeId);
                                props.setString("name", p.name != null ? p.name : "");
                                props.setString("comment", p.comment != null ? p.comment : "");
                                float[] stats = this.elevationStatsForPoints(seg);
                                if (stats != null) {
                                    props.setFloat("elevMin", stats[0]);
                                    props.setFloat("elevMax", stats[1]);
                                    props.setFloat("elevMean", stats[2]);
                                }
                                JSONObject feat = new JSONObject();
                                feat.setString("type", "Feature");
                                feat.setJSONObject("geometry", geom);
                                feat.setJSONObject("properties", props);
                                features.append(feat);
                            }
                            ++ri;
                        }
                    }
                    ++pi;
                }
            }
            if (this.mapModel != null && this.mapModel.structures != null) {
                int si = 0;
                while (si < this.mapModel.structures.size()) {
                    Structure s = this.mapModel.structures.get(si);
                    if (s != null) {
                        ArrayList<PVector> outline = this.structureOutline(s);
                        JSONArray ring = this.ringFromVertices(outline, true);
                        JSONObject geom3 = new JSONObject();
                        if (ring.size() >= 4) {
                            JSONArray poly = new JSONArray();
                            poly.append(ring);
                            geom3.setString("type", "Polygon");
                            geom3.setJSONArray("coordinates", poly);
                        } else {
                            JSONArray pt = new JSONArray();
                            pt.append(s.x);
                            pt.append(s.y);
                            geom3.setString("type", "Point");
                            geom3.setJSONArray("coordinates", pt);
                        }
                        JSONObject props3 = new JSONObject();
                        props3.setString("category", "structure");
                        props3.setInt("structureIndex", si);
                        props3.setInt("typeId", s.typeId);
                        props3.setString("name", s.name != null ? s.name : "");
                        props3.setString("comment", s.comment != null ? s.comment : "");
                        props3.setString("shape", s.shape != null ? s.shape.name() : "RECTANGLE");
                        props3.setFloat("size", s.size);
                        props3.setFloat("aspect", s.aspect);
                        props3.setFloat("angleRad", s.angle);
                        props3.setFloat("elev", this.elevationAtPoint(s.x, s.y));
                        JSONObject feat = new JSONObject();
                        feat.setString("type", "Feature");
                        feat.setJSONObject("geometry", geom3);
                        feat.setJSONObject("properties", props3);
                        features.append(feat);
                    }
                    ++si;
                }
            }
            if (this.mapModel != null && this.mapModel.labels != null) {
                int li = 0;
                while (li < this.mapModel.labels.size()) {
                    MapLabel lbl = this.mapModel.labels.get(li);
                    if (lbl != null && lbl.text != null) {
                        JSONArray pt = new JSONArray();
                        pt.append(lbl.x);
                        pt.append(lbl.y);
                        pt.append(this.elevationAtPoint(lbl.x, lbl.y));
                        JSONObject geom4 = new JSONObject();
                        geom4.setString("type", "Point");
                        geom4.setJSONArray("coordinates", pt);
                        JSONObject props4 = new JSONObject();
                        props4.setString("category", "label");
                        props4.setInt("labelIndex", li);
                        props4.setString("text", lbl.text);
                        props4.setString("comment", lbl.comment != null ? lbl.comment : "");
                        props4.setString("target", lbl.target != null ? lbl.target.name() : "FREE");
                        props4.setFloat("size", lbl.size);
                        props4.setFloat("elev", this.elevationAtPoint(lbl.x, lbl.y));
                        JSONObject feat = new JSONObject();
                        feat.setString("type", "Feature");
                        feat.setJSONObject("geometry", geom4);
                        feat.setJSONObject("properties", props4);
                        features.append(feat);
                    }
                    ++li;
                }
            }
            root.setJSONArray("features", features);
            File dir = new File(this.sketchPath("exports"));
            if (!dir.exists()) {
                dir.mkdirs();
            }
            String ts = String.valueOf(Main.nf((float)Main.year(), (int)4, (int)0)) + Main.nf((float)Main.month(), (int)2, (int)0) + Main.nf((float)Main.day(), (int)2, (int)0) + "_" + Main.nf((float)Main.hour(), (int)2, (int)0) + Main.nf((float)Main.minute(), (int)2, (int)0) + Main.nf((float)Main.second(), (int)2, (int)0);
            File target = new File(dir, "map_" + ts + ".geojson");
            File latest = new File(dir, "map_latest.geojson");
            this.saveJSONObject(root, target.getAbsolutePath());
            this.saveJSONObject(root, latest.getAbsolutePath());
            return target.getAbsolutePath();
        }
        catch (Exception e) {
            e.printStackTrace();
            return "Failed: " + e.getMessage();
        }
    }

    public String importMapJson() {
        JSONObject settings;
        JSONObject root;
        File latest;
        block14: {
            block13: {
                try {
                    latest = new File(this.sketchPath("exports"), "map_latest.json");
                    if (latest.exists()) break block13;
                    return "Failed: exports/map_latest.json not found";
                }
                catch (Exception e) {
                    e.printStackTrace();
                    return "Failed: " + e.getMessage();
                }
            }
            root = this.loadJSONObject(latest.getAbsolutePath());
            if (root != null) break block14;
            return "Failed: invalid JSON";
        }
        if (root.hasKey("types")) {
            JSONObject types = root.getJSONObject("types");
            this.mapModel.pathTypes = this.deserializePathTypes(types.getJSONArray("pathTypes"));
            this.mapModel.biomeTypes = this.deserializeZoneTypes(types.getJSONArray("biomeTypes"));
            this.mapModel.syncBiomePatternAssignments();
        }
        if (root.hasKey("sites")) {
            this.mapModel.sites = this.deserializeSites(root.getJSONArray("sites"));
        }
        if (root.hasKey("cells")) {
            this.mapModel.cells = this.deserializeCells(root.getJSONArray("cells"));
        }
        if (root.hasKey("zones")) {
            this.mapModel.zones = this.deserializeZones(root.getJSONArray("zones"));
        }
        if (root.hasKey("paths")) {
            this.mapModel.paths = this.deserializePaths(root.getJSONArray("paths"));
        }
        if (root.hasKey("structures")) {
            this.mapModel.structures = this.deserializeStructures(root.getJSONArray("structures"));
        }
        if (root.hasKey("labels")) {
            this.mapModel.labels = this.deserializeLabels(root.getJSONArray("labels"));
        }
        this.mapModel.cellNeighbors = new ArrayList();
        this.mapModel.snapNodes = new HashMap();
        this.mapModel.snapAdj = new HashMap();
        if (root.hasKey("settings") && (settings = root.getJSONObject("settings")).hasKey("render")) {
            this.applyRenderSettingsFromJson(settings.getJSONObject("render"), this.renderSettings);
        }
        if (root.hasKey("view")) {
            JSONObject view = root.getJSONObject("view");
            this.viewport.centerX = view.getFloat("centerX", this.viewport.centerX);
            this.viewport.centerY = view.getFloat("centerY", this.viewport.centerY);
            this.viewport.zoom = view.getFloat("zoom", this.viewport.zoom);
        }
        this.recomputeWorldBoundsFromData();
        this.mapModel.snapDirty = true;
        this.mapModel.voronoiDirty = false;
        this.selectedPathIndex = -1;
        return latest.getAbsolutePath();
    }

    public JSONObject serializeRenderSettings(RenderSettings s) {
        JSONObject r = new JSONObject();
        r.setFloat("landHue01", s.landHue01);
        r.setFloat("landSat01", s.landSat01);
        r.setFloat("landBri01", s.landBri01);
        r.setFloat("waterHue01", s.waterHue01);
        r.setFloat("waterSat01", s.waterSat01);
        r.setFloat("waterBri01", s.waterBri01);
        r.setFloat("cellBorderAlpha01", s.cellBorderAlpha01);
        r.setFloat("cellBorderSizePx", s.cellBorderSizePx);
        r.setBoolean("cellBorderScaleWithZoom", s.cellBorderScaleWithZoom);
        r.setFloat("cellBorderRefZoom", s.cellBorderRefZoom);
        r.setFloat("backgroundNoiseAlpha01", s.backgroundNoiseAlpha01);
        JSONObject biomes = new JSONObject();
        biomes.setFloat("fillAlpha01", s.biomeFillAlpha01);
        biomes.setFloat("satScale01", s.biomeSatScale01);
        biomes.setFloat("briScale01", s.biomeBriScale01);
        String fillType = "color";
        if (s.biomeFillType == RenderFillType.RENDER_FILL_PATTERN) {
            fillType = "pattern";
        } else if (s.biomeFillType == RenderFillType.RENDER_FILL_PATTERN_BG) {
            fillType = "pattern_bg";
        }
        biomes.setString("fillType", fillType);
        biomes.setString("patternName", s.biomePatternName);
        biomes.setFloat("outlineSizePx", s.biomeOutlineSizePx);
        biomes.setFloat("outlineAlpha01", s.biomeOutlineAlpha01);
        biomes.setBoolean("outlineScaleWithZoom", s.biomeOutlineScaleWithZoom);
        biomes.setFloat("outlineRefZoom", s.biomeOutlineRefZoom);
        biomes.setFloat("underwaterAlpha01", s.biomeUnderwaterAlpha01);
        r.setJSONObject("biomes", biomes);
        JSONObject shading = new JSONObject();
        shading.setFloat("waterDepthAlpha01", s.waterDepthAlpha01);
        shading.setFloat("elevationLightAlpha01", s.elevationLightAlpha01);
        shading.setFloat("elevationLightAzimuthDeg", s.elevationLightAzimuthDeg);
        shading.setFloat("elevationLightAltitudeDeg", s.elevationLightAltitudeDeg);
        shading.setFloat("elevationLightDitherPx", s.elevationLightDitherPx);
        shading.setBoolean("elevationLightDitherScaleWithZoom", s.elevationLightDitherScaleWithZoom);
        shading.setFloat("elevationLightDitherRefZoom", s.elevationLightDitherRefZoom);
        r.setJSONObject("shading", shading);
        JSONObject contours = new JSONObject();
        contours.setFloat("waterContourSizePx", s.waterContourSizePx);
        contours.setInt("waterRippleCount", s.waterRippleCount);
        contours.setFloat("waterRippleDistancePx", s.waterRippleDistancePx);
        contours.setFloat("waterContourHue01", s.waterContourHue01);
        contours.setFloat("waterContourSat01", s.waterContourSat01);
        contours.setFloat("waterContourBri01", s.waterContourBri01);
        contours.setFloat("waterContourAlpha01", s.waterCoastAlpha01);
        contours.setFloat("waterCoastAlpha01", s.waterCoastAlpha01);
        contours.setFloat("waterCoastSizePx", s.waterCoastSizePx);
        contours.setBoolean("waterCoastScaleWithZoom", s.waterCoastScaleWithZoom);
        contours.setBoolean("waterContourScaleWithZoom", s.waterContourScaleWithZoom);
        contours.setFloat("waterContourRefZoom", s.waterContourRefZoom);
        contours.setFloat("waterRippleAlphaStart01", s.waterRippleAlphaStart01);
        contours.setFloat("waterRippleAlphaEnd01", s.waterRippleAlphaEnd01);
        contours.setFloat("waterHatchAngleDeg", s.waterHatchAngleDeg);
        contours.setFloat("waterHatchLengthPx", s.waterHatchLengthPx);
        contours.setFloat("waterHatchSpacingPx", s.waterHatchSpacingPx);
        contours.setFloat("waterHatchAlpha01", s.waterHatchAlpha01);
        contours.setInt("elevationLinesCount", s.elevationLinesCount);
        contours.setString("elevationLinesStyle", s.elevationLinesStyle.name());
        contours.setFloat("elevationLinesAlpha01", s.elevationLinesAlpha01);
        contours.setFloat("elevationLinesSizePx", s.elevationLinesSizePx);
        contours.setBoolean("elevationLinesScaleWithZoom", s.elevationLinesScaleWithZoom);
        contours.setFloat("elevationLinesRefZoom", s.elevationLinesRefZoom);
        r.setJSONObject("contours", contours);
        JSONObject paths = new JSONObject();
        paths.setFloat("pathSatScale01", s.pathSatScale01);
        paths.setFloat("pathBriScale01", s.pathBriScale01);
        paths.setBoolean("showPaths", s.showPaths);
        paths.setBoolean("pathScaleWithZoom", s.pathScaleWithZoom);
        paths.setFloat("pathScaleRefZoom", s.pathScaleRefZoom);
        r.setJSONObject("paths", paths);
        JSONObject zones = new JSONObject();
        zones.setFloat("zoneStrokeAlpha01", s.zoneStrokeAlpha01);
        zones.setFloat("zoneStrokeSizePx", s.zoneStrokeSizePx);
        zones.setFloat("zoneStrokeSatScale01", s.zoneStrokeSatScale01);
        zones.setFloat("zoneStrokeBriScale01", s.zoneStrokeBriScale01);
        zones.setBoolean("zoneStrokeScaleWithZoom", s.zoneStrokeScaleWithZoom);
        zones.setFloat("zoneStrokeRefZoom", s.zoneStrokeRefZoom);
        r.setJSONObject("zones", zones);
        JSONObject structures = new JSONObject();
        structures.setBoolean("showStructures", s.showStructures);
        structures.setBoolean("mergeStructures", s.mergeStructures);
        structures.setFloat("structureSatScale01", s.structureSatScale01);
        structures.setFloat("structureAlphaScale01", s.structureAlphaScale01);
        structures.setFloat("structureShadowAlpha01", s.structureShadowAlpha01);
        structures.setBoolean("structureStrokeScaleWithZoom", s.structureStrokeScaleWithZoom);
        structures.setFloat("structureStrokeRefZoom", s.structureStrokeRefZoom);
        r.setJSONObject("structures", structures);
        JSONObject labels = new JSONObject();
        labels.setBoolean("showLabelsArbitrary", s.showLabelsArbitrary);
        labels.setBoolean("showLabelsZones", s.showLabelsZones);
        labels.setBoolean("showLabelsPaths", s.showLabelsPaths);
        labels.setBoolean("showLabelsStructures", s.showLabelsStructures);
        labels.setFloat("labelOutlineAlpha01", s.labelOutlineAlpha01);
        labels.setFloat("labelOutlineSizePx", s.labelOutlineSizePx);
        labels.setFloat("labelSizeArbPx", s.labelSizeArbPx);
        labels.setFloat("labelSizeZonePx", s.labelSizeZonePx);
        labels.setFloat("labelSizePathPx", s.labelSizePathPx);
        labels.setFloat("labelSizeStructPx", s.labelSizeStructPx);
        labels.setBoolean("labelOutlineScaleWithZoom", s.labelOutlineScaleWithZoom);
        labels.setInt("labelFontIndex", s.labelFontIndex);
        r.setJSONObject("labels", labels);
        JSONObject general = new JSONObject();
        general.setFloat("exportPaddingPct", s.exportPaddingPct);
        general.setBoolean("antialiasing", s.antialiasing);
        general.setInt("activePresetIndex", s.activePresetIndex);
        r.setJSONObject("general", general);
        return r;
    }

    public void applyRenderSettingsFromJson(JSONObject r, RenderSettings target) {
        JSONObject b;
        if (r == null || target == null) {
            return;
        }
        target.landHue01 = r.getFloat("landHue01", target.landHue01);
        target.landSat01 = r.getFloat("landSat01", target.landSat01);
        target.landBri01 = r.getFloat("landBri01", target.landBri01);
        target.waterHue01 = r.getFloat("waterHue01", target.waterHue01);
        target.waterSat01 = r.getFloat("waterSat01", target.waterSat01);
        target.waterBri01 = r.getFloat("waterBri01", target.waterBri01);
        target.cellBorderAlpha01 = r.getFloat("cellBorderAlpha01", target.cellBorderAlpha01);
        target.cellBorderSizePx = r.getFloat("cellBorderSizePx", target.cellBorderSizePx);
        target.cellBorderScaleWithZoom = r.getBoolean("cellBorderScaleWithZoom", target.cellBorderScaleWithZoom);
        target.cellBorderRefZoom = r.getFloat("cellBorderRefZoom", target.cellBorderRefZoom);
        target.backgroundNoiseAlpha01 = r.getFloat("backgroundNoiseAlpha01", target.backgroundNoiseAlpha01);
        if (r.hasKey("biomes")) {
            b = r.getJSONObject("biomes");
            target.biomeFillAlpha01 = b.getFloat("fillAlpha01", target.biomeFillAlpha01);
            target.biomeSatScale01 = b.getFloat("satScale01", target.biomeSatScale01);
            target.biomeBriScale01 = b.getFloat("briScale01", target.biomeBriScale01);
            String ft = b.getString("fillType", "color");
            target.biomeFillType = "pattern".equals(ft) ? RenderFillType.RENDER_FILL_PATTERN : ("pattern_bg".equals(ft) ? RenderFillType.RENDER_FILL_PATTERN_BG : RenderFillType.RENDER_FILL_COLOR);
            target.biomePatternName = b.getString("patternName", target.biomePatternName);
            target.biomeOutlineSizePx = b.getFloat("outlineSizePx", target.biomeOutlineSizePx);
            target.biomeOutlineAlpha01 = b.getFloat("outlineAlpha01", target.biomeOutlineAlpha01);
            target.biomeOutlineScaleWithZoom = b.getBoolean("outlineScaleWithZoom", target.biomeOutlineScaleWithZoom);
            target.biomeOutlineRefZoom = b.getFloat("outlineRefZoom", target.biomeOutlineRefZoom);
            target.biomeUnderwaterAlpha01 = b.getFloat("underwaterAlpha01", target.biomeUnderwaterAlpha01);
        }
        if (r.hasKey("shading")) {
            b = r.getJSONObject("shading");
            target.waterDepthAlpha01 = b.getFloat("waterDepthAlpha01", target.waterDepthAlpha01);
            target.elevationLightAlpha01 = b.getFloat("elevationLightAlpha01", target.elevationLightAlpha01);
            target.elevationLightAzimuthDeg = b.getFloat("elevationLightAzimuthDeg", target.elevationLightAzimuthDeg);
            target.elevationLightAltitudeDeg = b.getFloat("elevationLightAltitudeDeg", target.elevationLightAltitudeDeg);
            target.elevationLightDitherPx = b.getFloat("elevationLightDitherPx", target.elevationLightDitherPx);
            target.elevationLightDitherScaleWithZoom = b.getBoolean("elevationLightDitherScaleWithZoom", target.elevationLightDitherScaleWithZoom);
            target.elevationLightDitherRefZoom = b.getFloat("elevationLightDitherRefZoom", target.elevationLightDitherRefZoom);
        }
        if (r.hasKey("contours")) {
            b = r.getJSONObject("contours");
            target.waterContourSizePx = b.getFloat("waterContourSizePx", target.waterContourSizePx);
            target.waterRippleCount = b.getInt("waterRippleCount", target.waterRippleCount);
            target.waterRippleDistancePx = b.getFloat("waterRippleDistancePx", target.waterRippleDistancePx);
            target.waterContourHue01 = b.getFloat("waterContourHue01", target.waterContourHue01);
            target.waterContourSat01 = b.getFloat("waterContourSat01", target.waterContourSat01);
            target.waterContourBri01 = b.getFloat("waterContourBri01", target.waterContourBri01);
            target.waterContourAlpha01 = b.getFloat("waterContourAlpha01", target.waterContourAlpha01);
            target.waterCoastAlpha01 = b.getFloat("waterCoastAlpha01", target.waterContourAlpha01);
            target.waterCoastSizePx = b.getFloat("waterCoastSizePx", target.waterCoastSizePx);
            target.waterCoastScaleWithZoom = b.getBoolean("waterCoastScaleWithZoom", target.waterCoastScaleWithZoom);
            target.waterContourScaleWithZoom = b.getBoolean("waterContourScaleWithZoom", target.waterContourScaleWithZoom);
            target.waterContourRefZoom = b.getFloat("waterContourRefZoom", target.waterContourRefZoom);
            target.waterRippleAlphaStart01 = b.getFloat("waterRippleAlphaStart01", target.waterContourAlpha01);
            target.waterRippleAlphaEnd01 = b.getFloat("waterRippleAlphaEnd01", target.waterRippleAlphaStart01);
            target.waterHatchAngleDeg = b.getFloat("waterHatchAngleDeg", target.waterHatchAngleDeg);
            target.waterHatchLengthPx = b.getFloat("waterHatchLengthPx", target.waterHatchLengthPx);
            target.waterHatchSpacingPx = b.getFloat("waterHatchSpacingPx", target.waterHatchSpacingPx);
            target.waterHatchAlpha01 = b.getFloat("waterHatchAlpha01", target.waterHatchAlpha01);
            this.syncLegacyWaterContourAlpha(target);
            target.elevationLinesCount = b.getInt("elevationLinesCount", target.elevationLinesCount);
            String style = b.getString("elevationLinesStyle", target.elevationLinesStyle.name());
            target.elevationLinesStyle = "ELEV_LINES_BASIC".equals(style) ? ElevationLinesStyle.ELEV_LINES_BASIC : target.elevationLinesStyle;
            target.elevationLinesAlpha01 = b.getFloat("elevationLinesAlpha01", target.elevationLinesAlpha01);
            target.elevationLinesSizePx = b.getFloat("elevationLinesSizePx", target.elevationLinesSizePx);
            target.elevationLinesScaleWithZoom = b.getBoolean("elevationLinesScaleWithZoom", target.elevationLinesScaleWithZoom);
            target.elevationLinesRefZoom = b.getFloat("elevationLinesRefZoom", target.elevationLinesRefZoom);
        }
        if (r.hasKey("paths")) {
            b = r.getJSONObject("paths");
            target.pathSatScale01 = b.getFloat("pathSatScale01", target.pathSatScale01);
            target.pathBriScale01 = b.getFloat("pathBriScale01", target.pathBriScale01);
            target.showPaths = b.getBoolean("showPaths", target.showPaths);
            target.pathScaleWithZoom = b.getBoolean("pathScaleWithZoom", target.pathScaleWithZoom);
            target.pathScaleRefZoom = b.getFloat("pathScaleRefZoom", target.pathScaleRefZoom);
        }
        if (r.hasKey("zones")) {
            b = r.getJSONObject("zones");
            target.zoneStrokeAlpha01 = b.getFloat("zoneStrokeAlpha01", target.zoneStrokeAlpha01);
            target.zoneStrokeSizePx = b.getFloat("zoneStrokeSizePx", target.zoneStrokeSizePx);
            target.zoneStrokeSatScale01 = b.getFloat("zoneStrokeSatScale01", target.zoneStrokeSatScale01);
            target.zoneStrokeBriScale01 = b.getFloat("zoneStrokeBriScale01", target.zoneStrokeBriScale01);
            target.zoneStrokeScaleWithZoom = b.getBoolean("zoneStrokeScaleWithZoom", target.zoneStrokeScaleWithZoom);
            target.zoneStrokeRefZoom = b.getFloat("zoneStrokeRefZoom", target.zoneStrokeRefZoom);
        }
        if (r.hasKey("structures")) {
            b = r.getJSONObject("structures");
            target.showStructures = b.getBoolean("showStructures", target.showStructures);
            target.mergeStructures = b.getBoolean("mergeStructures", target.mergeStructures);
            target.structureSatScale01 = b.getFloat("structureSatScale01", target.structureSatScale01);
            target.structureAlphaScale01 = b.getFloat("structureAlphaScale01", target.structureAlphaScale01);
            target.structureShadowAlpha01 = b.getFloat("structureShadowAlpha01", target.structureShadowAlpha01);
            target.structureStrokeScaleWithZoom = b.getBoolean("structureStrokeScaleWithZoom", target.structureStrokeScaleWithZoom);
            target.structureStrokeRefZoom = b.getFloat("structureStrokeRefZoom", target.structureStrokeRefZoom);
        }
        if (r.hasKey("labels")) {
            b = r.getJSONObject("labels");
            target.showLabelsArbitrary = b.getBoolean("showLabelsArbitrary", target.showLabelsArbitrary);
            target.showLabelsZones = b.getBoolean("showLabelsZones", target.showLabelsZones);
            target.showLabelsPaths = b.getBoolean("showLabelsPaths", target.showLabelsPaths);
            target.showLabelsStructures = b.getBoolean("showLabelsStructures", target.showLabelsStructures);
            target.labelOutlineAlpha01 = b.getFloat("labelOutlineAlpha01", target.labelOutlineAlpha01);
            target.labelOutlineSizePx = b.getFloat("labelOutlineSizePx", target.labelOutlineSizePx);
            target.labelSizeArbPx = b.getFloat("labelSizeArbPx", target.labelSizeArbPx);
            target.labelSizeZonePx = b.getFloat("labelSizeZonePx", target.labelSizeZonePx);
            target.labelSizePathPx = b.getFloat("labelSizePathPx", target.labelSizePathPx);
            target.labelSizeStructPx = b.getFloat("labelSizeStructPx", target.labelSizeStructPx);
            target.labelOutlineScaleWithZoom = b.getBoolean("labelOutlineScaleWithZoom", target.labelOutlineScaleWithZoom);
            target.labelFontIndex = b.getInt("labelFontIndex", target.labelFontIndex);
            target.labelFontIndex = this.LABEL_FONT_OPTIONS != null && this.LABEL_FONT_OPTIONS.length > 0 ? Main.constrain((int)target.labelFontIndex, (int)0, (int)(this.LABEL_FONT_OPTIONS.length - 1)) : 0;
        }
        if (r.hasKey("general")) {
            b = r.getJSONObject("general");
            target.exportPaddingPct = b.getFloat("exportPaddingPct", target.exportPaddingPct);
            target.antialiasing = b.getBoolean("antialiasing", target.antialiasing);
            target.activePresetIndex = b.getInt("activePresetIndex", target.activePresetIndex);
            this.renderPaddingPct = target.exportPaddingPct;
        }
    }

    public JSONArray serializePathTypes(ArrayList<PathType> list) {
        JSONArray arr = new JSONArray();
        if (list == null) {
            return arr;
        }
        int i = 0;
        while (i < list.size()) {
            PathType t = list.get(i);
            if (t != null) {
                JSONObject o = new JSONObject();
                o.setInt("id", i);
                o.setString("name", t.name);
                o.setInt("col", t.col);
                o.setFloat("hue01", t.hue01);
                o.setFloat("sat01", t.sat01);
                o.setFloat("bri01", t.bri01);
                o.setFloat("weightPx", t.weightPx);
                o.setFloat("minWeightPx", t.minWeightPx);
                o.setString("routeMode", t.routeMode.name());
                o.setFloat("slopeBias", t.slopeBias);
                o.setBoolean("avoidWater", t.avoidWater);
                o.setBoolean("taperOn", t.taperOn);
                arr.append(o);
            }
            ++i;
        }
        return arr;
    }

    public JSONArray serializeZoneTypes(ArrayList<ZoneType> list) {
        JSONArray arr = new JSONArray();
        if (list == null) {
            return arr;
        }
        int i = 0;
        while (i < list.size()) {
            ZoneType z = list.get(i);
            if (z != null) {
                JSONObject o = new JSONObject();
                o.setInt("id", i);
                o.setString("name", z.name);
                o.setInt("col", z.col);
                o.setFloat("hue01", z.hue01);
                o.setFloat("sat01", z.sat01);
                o.setFloat("bri01", z.bri01);
                o.setInt("patternIndex", z.patternIndex);
                arr.append(o);
            }
            ++i;
        }
        return arr;
    }

    public JSONArray serializeSites(ArrayList<Site> list) {
        JSONArray arr = new JSONArray();
        if (list == null) {
            return arr;
        }
        int i = 0;
        while (i < list.size()) {
            Site s = list.get(i);
            if (s != null) {
                JSONObject o = new JSONObject();
                o.setInt("id", i);
                o.setFloat("x", s.x);
                o.setFloat("y", s.y);
                o.setBoolean("selected", s.selected);
                arr.append(o);
            }
            ++i;
        }
        return arr;
    }

    public JSONArray serializeCells(ArrayList<Cell> list) {
        JSONArray arr = new JSONArray();
        if (list == null) {
            return arr;
        }
        int i = 0;
        while (i < list.size()) {
            Cell c = list.get(i);
            if (c != null) {
                JSONObject o = new JSONObject();
                o.setInt("id", i);
                o.setInt("siteIndex", c.siteIndex);
                o.setInt("biomeId", c.biomeId);
                o.setFloat("elevation", c.elevation);
                JSONArray verts = new JSONArray();
                if (c.vertices != null) {
                    for (PVector v : c.vertices) {
                        JSONObject pv = new JSONObject();
                        pv.setFloat("x", v.x);
                        pv.setFloat("y", v.y);
                        verts.append(pv);
                    }
                }
                o.setJSONArray("vertices", verts);
                arr.append(o);
            }
            ++i;
        }
        return arr;
    }

    public JSONArray serializeZones(ArrayList<MapModel.MapZone> list) {
        JSONArray arr = new JSONArray();
        if (list == null) {
            return arr;
        }
        int i = 0;
        while (i < list.size()) {
            MapModel.MapZone z = list.get(i);
            if (z != null) {
                JSONObject o = new JSONObject();
                o.setInt("id", i);
                o.setString("name", z.name);
                o.setString("comment", z.comment != null ? z.comment : "");
                o.setInt("col", z.col);
                o.setFloat("hue01", z.hue01);
                o.setFloat("sat01", z.sat01);
                o.setFloat("bri01", z.bri01);
                JSONArray cellsArr = new JSONArray();
                if (z.cells != null) {
                    for (Integer ci : z.cells) {
                        cellsArr.append(ci.intValue());
                    }
                }
                o.setJSONArray("cells", cellsArr);
                arr.append(o);
            }
            ++i;
        }
        return arr;
    }

    public JSONArray serializePaths(ArrayList<Path> list) {
        JSONArray arr = new JSONArray();
        if (list == null) {
            return arr;
        }
        int i = 0;
        while (i < list.size()) {
            Path p = list.get(i);
            if (p != null) {
                JSONObject o = new JSONObject();
                o.setInt("id", i);
                o.setInt("typeId", p.typeId);
                o.setString("name", p.name);
                o.setString("comment", p.comment != null ? p.comment : "");
                JSONArray routes = new JSONArray();
                if (p.routes != null) {
                    for (ArrayList<PVector> seg : p.routes) {
                        JSONArray pts = new JSONArray();
                        if (seg != null) {
                            for (PVector v : seg) {
                                JSONObject pv = new JSONObject();
                                pv.setFloat("x", v.x);
                                pv.setFloat("y", v.y);
                                pts.append(pv);
                            }
                        }
                        routes.append(pts);
                    }
                }
                o.setJSONArray("routes", routes);
                arr.append(o);
            }
            ++i;
        }
        return arr;
    }

    public JSONArray serializeStructures(ArrayList<Structure> list) {
        JSONArray arr = new JSONArray();
        if (list == null) {
            return arr;
        }
        int i = 0;
        while (i < list.size()) {
            Structure s = list.get(i);
            if (s != null) {
                JSONObject o = new JSONObject();
                o.setInt("id", i);
                o.setInt("typeId", s.typeId);
                o.setString("name", s.name);
                o.setString("comment", s.comment != null ? s.comment : "");
                o.setFloat("x", s.x);
                o.setFloat("y", s.y);
                o.setFloat("angle", s.angle);
                o.setFloat("size", s.size);
                o.setString("shape", s.shape.name());
                o.setString("alignment", s.alignment.name());
                o.setFloat("aspect", s.aspect);
                o.setFloat("hue01", s.hue01);
                o.setFloat("sat01", s.sat01);
                o.setFloat("bri01", s.bri01);
                o.setFloat("alpha01", s.alpha01);
                o.setFloat("strokeWeightPx", s.strokeWeightPx);
                o.setInt("fillCol", s.fillCol);
                if (s.snapBinding != null) {
                    o.setString("snapTargetType", s.snapBinding.type.name());
                    o.setInt("snapPathIndex", s.snapBinding.pathIndex);
                    o.setInt("snapRouteIndex", s.snapBinding.routeIndex);
                    o.setInt("snapSegmentIndex", s.snapBinding.segmentIndex);
                    o.setInt("snapStructureIndex", s.snapBinding.structureIndex);
                    o.setInt("snapCellA", s.snapBinding.cellA);
                    o.setInt("snapCellB", s.snapBinding.cellB);
                    o.setFloat("snapAngleRad", s.snapBinding.snapAngleRad);
                    if (s.snapBinding.snapPoint != null) {
                        o.setFloat("snapPointX", s.snapBinding.snapPoint.x);
                        o.setFloat("snapPointY", s.snapBinding.snapPoint.y);
                    }
                    if (s.snapBinding.segA != null) {
                        o.setFloat("snapSegAx", s.snapBinding.segA.x);
                        o.setFloat("snapSegAy", s.snapBinding.segA.y);
                    }
                    if (s.snapBinding.segB != null) {
                        o.setFloat("snapSegBx", s.snapBinding.segB.x);
                        o.setFloat("snapSegBy", s.snapBinding.segB.y);
                    }
                }
                arr.append(o);
            }
            ++i;
        }
        return arr;
    }

    public JSONArray serializeLabels(ArrayList<MapLabel> list) {
        JSONArray arr = new JSONArray();
        if (list == null) {
            return arr;
        }
        int i = 0;
        while (i < list.size()) {
            MapLabel l = list.get(i);
            if (l != null) {
                JSONObject o = new JSONObject();
                o.setInt("id", i);
                o.setFloat("x", l.x);
                o.setFloat("y", l.y);
                o.setString("text", l.text != null ? l.text : "");
                o.setString("target", l.target.name());
                o.setFloat("size", l.size);
                o.setString("comment", l.comment != null ? l.comment : "");
                arr.append(o);
            }
            ++i;
        }
        return arr;
    }

    public ArrayList<PathType> deserializePathTypes(JSONArray arr) {
        ArrayList<PathType> list = new ArrayList<PathType>();
        if (arr == null) {
            return list;
        }
        int i = 0;
        while (i < arr.size()) {
            JSONObject o = arr.getJSONObject(i);
            if (o != null) {
                String name = o.getString("name", "Path");
                int col = o.getInt("col", this.color(80));
                float weight = o.getFloat("weightPx", 2.0f);
                float minWeight = o.getFloat("minWeightPx", weight * 0.6f);
                String mode = o.getString("routeMode", PathRouteMode.PATHFIND.name());
                PathRouteMode rm = mode.equals(PathRouteMode.ENDS.name()) ? PathRouteMode.ENDS : PathRouteMode.PATHFIND;
                float slope = o.getFloat("slopeBias", 0.0f);
                boolean avoidWater = o.getBoolean("avoidWater", true);
                boolean taper = o.getBoolean("taperOn", false);
                PathType pt = new PathType(name, col, weight, minWeight, rm, slope, avoidWater, taper);
                list.add(pt);
            }
            ++i;
        }
        return list;
    }

    public ArrayList<ZoneType> deserializeZoneTypes(JSONArray arr) {
        ArrayList<ZoneType> list = new ArrayList<ZoneType>();
        if (arr == null) {
            return list;
        }
        int i = 0;
        while (i < arr.size()) {
            JSONObject o = arr.getJSONObject(i);
            if (o != null) {
                String name = o.getString("name", "Zone");
                int col = o.getInt("col", this.color(200));
                ZoneType z = new ZoneType(name, col);
                z.hue01 = o.getFloat("hue01", z.hue01);
                z.sat01 = o.getFloat("sat01", z.sat01);
                z.bri01 = o.getFloat("bri01", z.bri01);
                z.updateColorFromHSB();
                int defPat = this.mapModel != null ? this.mapModel.defaultPatternIndexForBiome(i) : 0;
                z.patternIndex = o.getInt("patternIndex", defPat);
                list.add(z);
            }
            ++i;
        }
        return list;
    }

    public void loadBiomePatternList() {
        String[] roots;
        ArrayList<String> names = new ArrayList<String>();
        HashSet<String> seen = new HashSet<String>();
        String[] stringArray = roots = new String[]{this.dataPath("patterns"), this.sketchPath("patterns")};
        int n = roots.length;
        int n2 = 0;
        while (n2 < n) {
            String root = stringArray[n2];
            try {
                File[] files;
                File dir;
                if (root != null && (dir = new File(root)).exists() && dir.isDirectory() && (files = dir.listFiles()) != null) {
                    File[] fileArray = files;
                    int n3 = files.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        String low;
                        String name;
                        File f = fileArray[n4];
                        if (f != null && f.isFile() && !f.isHidden() && (name = f.getName()) != null && (low = name.toLowerCase()).endsWith(".png") && !seen.contains(name)) {
                            seen.add(name);
                            names.add(name);
                        }
                        ++n4;
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            ++n2;
        }
        Collections.sort(names);
        if (!names.isEmpty()) {
            if (this.renderSettings != null) {
                boolean keep;
                String curPat = this.renderSettings.biomePatternName;
                boolean bl = keep = curPat != null && names.contains(curPat);
                if (!keep) {
                    this.renderSettings.biomePatternName = names.get(0);
                }
            }
        } else {
            Main.println((String)"No biome patterns found under data/sketch patterns directories.");
        }
        if (this.mapModel != null) {
            this.mapModel.setBiomePatternFiles(names);
        }
    }

    public ArrayList<Site> deserializeSites(JSONArray arr) {
        ArrayList<Site> list = new ArrayList<Site>();
        if (arr == null) {
            return list;
        }
        int i = 0;
        while (i < arr.size()) {
            JSONObject o = arr.getJSONObject(i);
            if (o != null) {
                float x = o.getFloat("x", 0.0f);
                float y = o.getFloat("y", 0.0f);
                Site s = new Site(x, y);
                s.selected = o.getBoolean("selected", false);
                list.add(s);
            }
            ++i;
        }
        return list;
    }

    public ArrayList<Cell> deserializeCells(JSONArray arr) {
        ArrayList<Cell> list = new ArrayList<Cell>();
        if (arr == null) {
            return list;
        }
        int i = 0;
        while (i < arr.size()) {
            JSONObject o = arr.getJSONObject(i);
            if (o != null) {
                int siteIdx = o.getInt("siteIndex", -1);
                int biomeId = o.getInt("biomeId", 0);
                JSONArray vertsArr = o.getJSONArray("vertices");
                ArrayList<PVector> verts = new ArrayList<PVector>();
                if (vertsArr != null) {
                    int vi = 0;
                    while (vi < vertsArr.size()) {
                        JSONObject pv = vertsArr.getJSONObject(vi);
                        if (pv != null) {
                            verts.add(new PVector(pv.getFloat("x", 0.0f), pv.getFloat("y", 0.0f)));
                        }
                        ++vi;
                    }
                }
                Cell c = new Cell(siteIdx, verts, biomeId);
                c.elevation = o.getFloat("elevation", 0.0f);
                list.add(c);
            }
            ++i;
        }
        return list;
    }

    public ArrayList<MapModel.MapZone> deserializeZones(JSONArray arr) {
        ArrayList<MapModel.MapZone> list = new ArrayList<MapModel.MapZone>();
        if (arr == null) {
            return list;
        }
        int i = 0;
        while (i < arr.size()) {
            JSONObject o = arr.getJSONObject(i);
            if (o != null) {
                String name = o.getString("name", "Zone");
                int col = o.getInt("col", this.color(200));
                MapModel mapModel = this.mapModel;
                mapModel.getClass();
                MapModel.MapZone z = mapModel.new MapModel.MapZone(name, col);
                z.hue01 = o.getFloat("hue01", z.hue01);
                z.sat01 = o.getFloat("sat01", z.sat01);
                z.bri01 = o.getFloat("bri01", z.bri01);
                z.col = this.hsb01ToARGB(z.hue01, z.sat01, z.bri01, 1.0f);
                z.cells.clear();
                JSONArray cellsArr = o.getJSONArray("cells");
                if (cellsArr != null) {
                    int ci = 0;
                    while (ci < cellsArr.size()) {
                        z.cells.add(cellsArr.getInt(ci));
                        ++ci;
                    }
                }
                list.add(z);
            }
            ++i;
        }
        return list;
    }

    public ArrayList<Path> deserializePaths(JSONArray arr) {
        ArrayList<Path> list = new ArrayList<Path>();
        if (arr == null) {
            return list;
        }
        int i = 0;
        while (i < arr.size()) {
            JSONObject o = arr.getJSONObject(i);
            if (o != null) {
                Path p = new Path();
                p.typeId = o.getInt("typeId", 0);
                p.name = o.getString("name", "Path");
                p.comment = o.getString("comment", "");
                JSONArray routesArr = o.getJSONArray("routes");
                if (routesArr != null) {
                    int ri = 0;
                    while (ri < routesArr.size()) {
                        JSONArray ptsArr = routesArr.getJSONArray(ri);
                        ArrayList<PVector> seg = new ArrayList<PVector>();
                        if (ptsArr != null) {
                            int pi = 0;
                            while (pi < ptsArr.size()) {
                                JSONObject pv = ptsArr.getJSONObject(pi);
                                if (pv != null) {
                                    seg.add(new PVector(pv.getFloat("x", 0.0f), pv.getFloat("y", 0.0f)));
                                }
                                ++pi;
                            }
                        }
                        p.routes.add(seg);
                        ++ri;
                    }
                }
                list.add(p);
            }
            ++i;
        }
        return list;
    }

    public ArrayList<Structure> deserializeStructures(JSONArray arr) {
        ArrayList<Structure> list = new ArrayList<Structure>();
        if (arr == null) {
            return list;
        }
        int i = 0;
        while (i < arr.size()) {
            JSONObject o = arr.getJSONObject(i);
            if (o != null) {
                float x = o.getFloat("x", 0.0f);
                float y = o.getFloat("y", 0.0f);
                Structure s = new Structure(x, y);
                s.typeId = o.getInt("typeId", 0);
                s.name = o.getString("name", "");
                s.comment = o.getString("comment", "");
                s.angle = o.getFloat("angle", 0.0f);
                s.size = o.getFloat("size", s.size);
                try {
                    String sh = o.getString("shape", s.shape.name());
                    if ("SQUARE".equals(sh)) {
                        sh = StructureShape.RECTANGLE.name();
                    }
                    s.shape = StructureShape.valueOf(sh);
                }
                catch (Exception exception) {}
                try {
                    s.alignment = StructureSnapMode.valueOf(o.getString("alignment", s.alignment.name()));
                }
                catch (Exception exception) {}
                s.aspect = o.getFloat("aspect", s.aspect);
                s.hue01 = o.getFloat("hue01", s.hue01);
                s.sat01 = o.getFloat("sat01", s.sat01);
                s.bri01 = o.getFloat("bri01", s.bri01);
                s.alpha01 = o.getFloat("alpha01", s.alpha01);
                s.strokeWeightPx = o.getFloat("strokeWeightPx", s.strokeWeightPx);
                s.fillCol = o.getInt("fillCol", s.fillCol);
                s.updateFillColor();
                if (s.snapBinding == null) {
                    s.snapBinding = new StructureSnapBinding();
                }
                s.snapBinding.clear();
                try {
                    s.snapBinding.type = StructureSnapTargetType.valueOf(o.getString("snapTargetType", s.snapBinding.type.name()));
                }
                catch (Exception exception) {}
                s.snapBinding.pathIndex = o.getInt("snapPathIndex", s.snapBinding.pathIndex);
                s.snapBinding.routeIndex = o.getInt("snapRouteIndex", s.snapBinding.routeIndex);
                s.snapBinding.segmentIndex = o.getInt("snapSegmentIndex", s.snapBinding.segmentIndex);
                s.snapBinding.structureIndex = o.getInt("snapStructureIndex", s.snapBinding.structureIndex);
                s.snapBinding.cellA = o.getInt("snapCellA", s.snapBinding.cellA);
                s.snapBinding.cellB = o.getInt("snapCellB", s.snapBinding.cellB);
                s.snapBinding.snapAngleRad = o.getFloat("snapAngleRad", s.snapBinding.snapAngleRad);
                if (o.hasKey("snapPointX") && o.hasKey("snapPointY")) {
                    s.snapBinding.snapPoint = new PVector(o.getFloat("snapPointX", 0.0f), o.getFloat("snapPointY", 0.0f));
                }
                if (o.hasKey("snapSegAx") && o.hasKey("snapSegAy")) {
                    s.snapBinding.segA = new PVector(o.getFloat("snapSegAx", 0.0f), o.getFloat("snapSegAy", 0.0f));
                }
                if (o.hasKey("snapSegBx") && o.hasKey("snapSegBy")) {
                    s.snapBinding.segB = new PVector(o.getFloat("snapSegBx", 0.0f), o.getFloat("snapSegBy", 0.0f));
                }
                list.add(s);
            }
            ++i;
        }
        return list;
    }

    public ArrayList<MapLabel> deserializeLabels(JSONArray arr) {
        ArrayList<MapLabel> list = new ArrayList<MapLabel>();
        if (arr == null) {
            return list;
        }
        int i = 0;
        while (i < arr.size()) {
            JSONObject o = arr.getJSONObject(i);
            if (o != null) {
                float x = o.getFloat("x", 0.0f);
                float y = o.getFloat("y", 0.0f);
                String text = o.getString("text", "");
                String targetStr = o.getString("target", LabelTarget.FREE.name());
                LabelTarget target = LabelTarget.FREE;
                try {
                    target = LabelTarget.valueOf(targetStr);
                }
                catch (Exception exception) {}
                MapLabel l = new MapLabel(x, y, text, target);
                l.size = o.getFloat("size", l.size);
                l.comment = o.getString("comment", "");
                list.add(l);
            }
            ++i;
        }
        return list;
    }

    public void recomputeWorldBoundsFromData() {
        float minXLocal = Float.MAX_VALUE;
        float minYLocal = Float.MAX_VALUE;
        float maxXLocal = -3.4028235E38f;
        float maxYLocal = -3.4028235E38f;
        if (this.mapModel.cells != null) {
            for (Cell c : this.mapModel.cells) {
                if (c == null || c.vertices == null) continue;
                for (PVector v : c.vertices) {
                    if (v == null) continue;
                    minXLocal = Main.min((float)minXLocal, (float)v.x);
                    minYLocal = Main.min((float)minYLocal, (float)v.y);
                    maxXLocal = Main.max((float)maxXLocal, (float)v.x);
                    maxYLocal = Main.max((float)maxYLocal, (float)v.y);
                }
            }
        }
        if (this.mapModel.sites != null) {
            for (Site s : this.mapModel.sites) {
                if (s == null) continue;
                minXLocal = Main.min((float)minXLocal, (float)s.x);
                minYLocal = Main.min((float)minYLocal, (float)s.y);
                maxXLocal = Main.max((float)maxXLocal, (float)s.x);
                maxYLocal = Main.max((float)maxYLocal, (float)s.y);
            }
        }
        if (minXLocal == Float.MAX_VALUE || maxXLocal == -3.4028235E38f) {
            this.mapModel.minX = 0.0f;
            this.mapModel.maxX = 1.0f;
            this.mapModel.minY = 0.0f;
            this.mapModel.maxY = 1.0f;
        } else {
            this.mapModel.minX = minXLocal;
            this.mapModel.maxX = maxXLocal;
            this.mapModel.minY = minYLocal;
            this.mapModel.maxY = maxYLocal;
        }
    }

    public void drawPathSnappingPoints() {
        if (this.pathEraserMode) {
            return;
        }
        ArrayList<PVector> snaps = this.mapModel.getSnapPoints();
        if (snaps == null || snaps.isEmpty()) {
            return;
        }
        float nearestScreenSq = Float.MAX_VALUE;
        PVector nearest = null;
        float px = this.mouseX;
        float py = this.mouseY;
        for (PVector p : snaps) {
            PVector s = this.viewport.worldToScreen(p.x, p.y);
            float dx = s.x - px;
            float dy = s.y - py;
            float d2 = dx * dx + dy * dy;
            if (!(d2 < nearestScreenSq)) continue;
            nearestScreenSq = d2;
            nearest = p;
        }
        float baseR = 2.0f / this.viewport.zoom;
        this.pushStyle();
        this.noStroke();
        this.fill(30.0f, 30.0f, 30.0f, 90.0f);
        for (PVector p : snaps) {
            this.ellipse(p.x, p.y, baseR, baseR);
        }
        if (nearest != null) {
            float hr = 5.0f / this.viewport.zoom;
            this.stroke(0);
            this.strokeWeight(1.0f / this.viewport.zoom);
            this.fill(255.0f, 255.0f, 0.0f, 180.0f);
            this.ellipse(nearest.x, nearest.y, hr, hr);
        }
        this.popStyle();
    }

    public PVector findNearestSnappingPoint(float wx, float wy, float maxScreenDist) {
        ArrayList<PVector> snaps = this.mapModel.getSnapPoints();
        if (snaps.isEmpty()) {
            return null;
        }
        float bestSq = maxScreenDist * maxScreenDist;
        PVector best = null;
        PVector cursorScreen = this.viewport.worldToScreen(wx, wy);
        for (PVector p : snaps) {
            PVector s = this.viewport.worldToScreen(p.x, p.y);
            float dx = s.x - cursorScreen.x;
            float dy = s.y - cursorScreen.y;
            float d2 = dx * dx + dy * dy;
            if (!(d2 < bestSq)) continue;
            bestSq = d2;
            best = p;
        }
        return best;
    }

    public void seedDefaultZones() {
        if (this.mapModel.cells == null || this.mapModel.cells.isEmpty()) {
            return;
        }
        for (Cell c : this.mapModel.cells) {
            c.biomeId = 0;
            c.elevation = this.defaultElevation;
        }
    }

    public void startLoading() {
        this.isLoading = true;
        this.loadingPhase = 0.0f;
        this.loadingHoldFrames = 0;
        this.loadingPct = 0.0f;
    }

    public void stopLoading() {
        this.isLoading = false;
        this.loadingHoldFrames = 0;
        this.loadingPct = 1.0f;
    }

    public void showNotice(String msg) {
        this.uiNotice = msg;
        this.uiNoticeFrames = 150;
    }

    public void drawZoneBrushPreview() {
        IntRect panel = this.getActivePanelRect();
        if (panel != null && panel.contains(this.mouseX, this.mouseY)) {
            return;
        }
        if (this.mouseY < 60) {
            return;
        }
        PVector w = this.viewport.screenToWorld(this.mouseX, this.mouseY);
        this.pushStyle();
        this.noFill();
        this.stroke(40, 120.0f);
        this.strokeWeight(1.0f / this.viewport.zoom);
        float r = this.zoneBrushRadius;
        this.ellipse(w.x, w.y, r * 2.0f, r * 2.0f);
        this.popStyle();
    }

    public void drawPathEraserPreview() {
        IntRect panel = this.getActivePanelRect();
        if (panel != null && panel.contains(this.mouseX, this.mouseY)) {
            return;
        }
        if (this.mouseY < 60) {
            return;
        }
        PVector w = this.viewport.screenToWorld(this.mouseX, this.mouseY);
        this.pushStyle();
        this.noFill();
        this.stroke(200.0f, 40.0f, 40.0f, 160.0f);
        this.strokeWeight(1.0f / this.viewport.zoom);
        this.ellipse(w.x, w.y, this.pathEraserRadius * 2.0f, this.pathEraserRadius * 2.0f);
        this.popStyle();
    }

    public void drawElevationBrushPreview() {
        IntRect panel = this.getActivePanelRect();
        if (panel != null && panel.contains(this.mouseX, this.mouseY)) {
            return;
        }
        PVector w = this.viewport.screenToWorld(this.mouseX, this.mouseY);
        this.pushStyle();
        this.noFill();
        this.stroke(40, 120.0f);
        this.strokeWeight(1.0f / this.viewport.zoom);
        float r = this.elevationBrushRadius;
        this.ellipse(w.x, w.y, r * 2.0f, r * 2.0f);
        this.popStyle();
    }

    public void drawStructurePreview() {
        int uiBottom = 60;
        if (this.mouseY < uiBottom) {
            return;
        }
        if (this.selectedStructureIndices != null && !this.selectedStructureIndices.isEmpty()) {
            return;
        }
        PVector w = this.viewport.screenToWorld(this.mouseX, this.mouseY);
        Structure tmp = this.mapModel.computeSnappedStructure(w.x, w.y, this.structureSize);
        if (tmp == null) {
            return;
        }
        this.pushStyle();
        this.stroke(80, 140.0f);
        this.strokeWeight(1.0f / this.viewport.zoom);
        this.fill(200.0f, 200.0f, 180.0f, 120.0f);
        tmp.draw(this);
        this.popStyle();
    }

    public void stepFullGenerateFromCells() {
        if (!this.fullGenRunning || this.mapModel == null) {
            return;
        }
        String stageLabel = "";
        switch (this.fullGenStep) {
            case 0: {
                stageLabel = "Full gen: elevation + plateaus";
                break;
            }
            case 1: {
                stageLabel = "Full gen: biomes";
                break;
            }
            case 2: {
                stageLabel = "Full gen: zones";
                break;
            }
            case 3: {
                stageLabel = "Full gen: paths";
                break;
            }
            case 4: {
                stageLabel = "Full gen: structures";
                break;
            }
            case 5: {
                stageLabel = "Full gen: labels";
                break;
            }
            default: {
                stageLabel = "";
            }
        }
        if (!this.fullGenPrimed) {
            this.loadingDetail = stageLabel;
            this.fullGenPrimed = true;
            return;
        }
        switch (this.fullGenStep) {
            case 0: {
                this.loadingDetail = stageLabel;
                this.loadingPct = 0.05f;
                this.noiseSeed((int)this.random(2.1474836E9f));
                this.mapModel.generateElevationNoise(this.elevationNoiseScale, 1.0f, this.seaLevel);
                int i = 0;
                while (i < 15) {
                    this.mapModel.makePlateaus(this.seaLevel);
                    ++i;
                }
                this.loadingPct = 0.2f;
                this.fullGenPrimed = false;
                ++this.fullGenStep;
                break;
            }
            case 1: {
                this.loadingDetail = stageLabel;
                this.biomeGenerateModeIndex = Main.max((int)0, (int)(this.biomeGenerateModes.length - 1));
                this.applyBiomeGeneration();
                this.loadingPct = 0.35f;
                this.fullGenPrimed = false;
                ++this.fullGenStep;
                break;
            }
            case 2: {
                this.loadingDetail = stageLabel;
                int targetZones = this.mapModel.zones == null || this.mapModel.zones.isEmpty() ? 5 : this.mapModel.zones.size();
                this.mapModel.regenerateRandomZones(targetZones);
                this.activeZoneIndex = -1;
                this.editingZoneNameIndex = -1;
                this.editingZoneComment = false;
                this.mapModel.removeUnderwaterCellsFromZone(-1, this.seaLevel);
                this.loadingPct = 0.45f;
                this.fullGenPrimed = false;
                ++this.fullGenStep;
                break;
            }
            case 3: {
                this.loadingDetail = stageLabel;
                this.selectedPathIndex = -1;
                this.pendingPathStart = null;
                this.mapModel.generatePathsAuto(this.seaLevel);
                this.loadingPct = 0.7f;
                this.fullGenPrimed = false;
                ++this.fullGenStep;
                break;
            }
            case 4: {
                this.loadingDetail = stageLabel;
                this.mapModel.generateStructuresAuto(this.structGenTownCount, this.structGenBuildingDensity, this.seaLevel);
                this.clearStructureSelection();
                this.loadingPct = 0.85f;
                this.fullGenPrimed = false;
                ++this.fullGenStep;
                break;
            }
            case 5: {
                this.loadingDetail = stageLabel;
                this.mapModel.generateArbitraryLabels(this.seaLevel);
                this.selectedLabelIndex = -1;
                this.editingLabelIndex = -1;
                this.editingLabelCommentIndex = -1;
                this.loadingPct = 1.0f;
                this.markRenderDirty();
                this.fullGenPrimed = false;
                ++this.fullGenStep;
                break;
            }
            default: {
                this.fullGenRunning = false;
                this.stopLoading();
                this.loadingDetail = "";
                this.loadingPct = 1.0f;
                this.fullGenPrimed = false;
            }
        }
    }

    public float[] exportInnerRect() {
        float worldW = this.mapModel.maxX - this.mapModel.minX;
        float worldH = this.mapModel.maxY - this.mapModel.minY;
        float safePad = Main.constrain((float)this.renderPaddingPct, (float)0.0f, (float)0.49f);
        float padX = Main.max((float)0.0f, (float)safePad) * worldW;
        float padY = Main.max((float)0.0f, (float)safePad) * worldH;
        float innerWX = this.mapModel.minX + padX;
        float innerWY = this.mapModel.minY + padY;
        float innerWW = worldW - padX * 2.0f;
        float innerWH = worldH - padY * 2.0f;
        return new float[]{innerWX, innerWY, innerWW, innerWH};
    }

    public float[] exportSquareRect() {
        float worldW = this.mapModel.maxX - this.mapModel.minX;
        float worldH = this.mapModel.maxY - this.mapModel.minY;
        float side = Main.max((float)worldW, (float)worldH);
        float cx = (this.mapModel.minX + this.mapModel.maxX) * 0.5f;
        float cy = (this.mapModel.minY + this.mapModel.maxY) * 0.5f;
        return new float[]{cx - side * 0.5f, cy - side * 0.5f, side, side};
    }

    public boolean ensureExportPreview() {
        boolean needsAlloc;
        if (this.mapModel == null || this.mapModel.renderer == null) {
            return false;
        }
        if (!this.exportPreviewDirty && this.exportPreview != null) {
            return true;
        }
        float[] rect = this.exportSquareRect();
        float innerWX = rect[0];
        float innerWY = rect[1];
        float innerWW = rect[2];
        float innerWH = rect[3];
        if (innerWW <= 1.0E-6f || innerWH <= 1.0E-6f) {
            return false;
        }
        float pixelsPerWorld = Main.max((float)0.1f, (float)this.exportScale) * 600.0f;
        int pxSide = Main.max((int)1, (int)Main.round((float)(innerWW * pixelsPerWorld)));
        pxSide = Main.constrain((int)pxSide, (int)1, (int)16384);
        boolean bl = needsAlloc = this.exportPreview == null || this.exportPreview.width != pxSide || this.exportPreview.height != pxSide;
        if (needsAlloc) {
            PGraphics g = null;
            try {
                g = this.createGraphics(pxSide, pxSide, "processing.opengl.PGraphics2D");
            }
            catch (Exception exception) {}
            if (g == null) {
                try {
                    g = this.createGraphics(pxSide, pxSide, "processing.awt.PGraphicsJava2D");
                }
                catch (Exception exception) {}
            }
            if (g == null) {
                return false;
            }
            this.exportPreview = g;
        }
        float prevCenterX = this.viewport.centerX;
        float prevCenterY = this.viewport.centerY;
        float prevZoom = this.viewport.zoom;
        this.viewport.zoom = pixelsPerWorld;
        this.viewport.centerX = innerWX + innerWW * 0.5f;
        this.viewport.centerY = innerWY + innerWH * 0.5f;
        this.triggerRenderPrerequisites();
        this.renderingForExport = true;
        this.progressActive = true;
        this.progressDetail = "Export render";
        this.setProgressStatus("Exporting...");
        try {
            this.exportPreview.beginDraw();
            this.exportPreview.background(245);
            PGraphics prev = this.g;
            this.g = this.exportPreview;
            this.pushMatrix();
            this.viewport.applyTransform(this.exportPreview, this.exportPreview.width, this.exportPreview.height);
            this.drawRenderView(this);
            this.popMatrix();
            this.g = prev;
            this.exportPreview.endDraw();
            this.progressPct = 0.65f;
            if (this.mapModel.isContourJobRunning()) {
                int safety = 0;
                while (this.mapModel.isContourJobRunning() && safety < 80) {
                    this.mapModel.stepContourJobs(16);
                    ++safety;
                }
                this.exportPreview.beginDraw();
                this.exportPreview.background(245);
                PGraphics prev2 = this.g;
                this.g = this.exportPreview;
                this.pushMatrix();
                this.viewport.applyTransform(this.exportPreview, this.exportPreview.width, this.exportPreview.height);
                this.drawRenderView(this);
                this.popMatrix();
                this.g = prev2;
                this.exportPreview.endDraw();
                this.progressPct = 0.9f;
            }
        }
        finally {
            this.viewport.centerX = prevCenterX;
            this.viewport.centerY = prevCenterY;
            this.viewport.zoom = prevZoom;
            this.renderingForExport = false;
            this.progressActive = false;
            this.progressDetail = "";
            this.setProgressStatus("Export done");
            this.progressPct = 1.0f;
        }
        this.exportPreviewRect = rect;
        this.exportPreviewDirty = false;
        return true;
    }

    public void drawExportPreviewView() {
        if (!this.ensureExportPreview()) {
            this.drawRenderView(this);
            return;
        }
        float wx = this.exportPreviewRect[0];
        float wy = this.exportPreviewRect[1];
        float ww = this.exportPreviewRect[2];
        float wh = this.exportPreviewRect[3];
        PVector tl = this.viewport.worldToScreen(wx, wy);
        PVector br = this.viewport.worldToScreen(wx + ww, wy + wh);
        float sx = Main.min((float)tl.x, (float)br.x);
        float sy = Main.min((float)tl.y, (float)br.y);
        float sw = Main.abs((float)(br.x - tl.x));
        float sh = Main.abs((float)(br.y - tl.y));
        this.pushStyle();
        this.pushMatrix();
        this.resetMatrix();
        this.imageMode(0);
        this.image((PImage)this.exportPreview, sx, sy, sw, sh);
        this.popMatrix();
        this.popStyle();
    }

    public void syncExportScaleToZoom() {
        this.exportScale = Main.max((float)0.1f, (float)(this.viewport.zoom / 600.0f));
    }

    public ExportLayout buildExportLayout() {
        int curY;
        ExportLayout l = new ExportLayout();
        l.panel = new IntRect(0, this.panelTop(), 320, 0);
        l.titleY = curY = l.panel.y + 10;
        l.pngBtn = new IntRect(l.panel.x + 10, curY += 30, 140, 22);
        l.svgBtn = new IntRect(l.pngBtn.x + l.pngBtn.w + 8, curY, 140, 22);
        l.geoJsonBtn = new IntRect(l.panel.x + 10, curY += 30, 140, 22);
        l.exportScaleLabelY = curY += 30;
        l.setResolutionBtn = new IntRect(l.panel.x + 10, curY += 22, 220, 22);
        l.bodyY = curY += 34;
        l.mapSectionY = curY += 40;
        l.mapExportBtn = new IntRect(l.panel.x + 10, curY += 22, 120, 22);
        l.mapImportBtn = new IntRect(l.mapExportBtn.x + l.mapExportBtn.w + 8, curY, 120, 22);
        l.statusY = curY += 34;
        l.panel.h = (curY += 26) - l.panel.y;
        return l;
    }

    public void drawExportPanel() {
        ExportLayout layout = this.buildExportLayout();
        this.drawPanelBackground(layout.panel);
        int labelX = layout.panel.x + 10;
        this.fill(0);
        this.textAlign(37, 101);
        this.text("Export", labelX, layout.titleY);
        this.drawBevelButton(layout.pngBtn.x, layout.pngBtn.y, layout.pngBtn.w, layout.pngBtn.h, false);
        this.fill(10);
        this.textAlign(3, 3);
        this.text("Export PNG", layout.pngBtn.x + layout.pngBtn.w / 2, layout.pngBtn.y + layout.pngBtn.h / 2);
        this.registerUiTooltip(layout.pngBtn, this.tooltipFor("export_png"));
        this.drawBevelButton(layout.svgBtn.x, layout.svgBtn.y, layout.svgBtn.w, layout.svgBtn.h, false);
        this.fill(10);
        this.textAlign(3, 3);
        this.text("Export SVG", layout.svgBtn.x + layout.svgBtn.w / 2, layout.svgBtn.y + layout.svgBtn.h / 2);
        this.registerUiTooltip(layout.svgBtn, this.tooltipFor("export_svg"));
        this.drawBevelButton(layout.geoJsonBtn.x, layout.geoJsonBtn.y, layout.geoJsonBtn.w, layout.geoJsonBtn.h, false);
        this.fill(10);
        this.textAlign(3, 3);
        this.text("Export GeoJSON", layout.geoJsonBtn.x + layout.geoJsonBtn.w / 2, layout.geoJsonBtn.y + layout.geoJsonBtn.h / 2);
        this.registerUiTooltip(layout.geoJsonBtn, this.tooltipFor("export_geojson"));
        this.drawBevelButton(layout.setResolutionBtn.x, layout.setResolutionBtn.y, layout.setResolutionBtn.w, layout.setResolutionBtn.h, false);
        this.fill(10);
        this.textAlign(3, 3);
        this.text("Set resolution from zoom", layout.setResolutionBtn.x + layout.setResolutionBtn.w / 2, layout.setResolutionBtn.y + layout.setResolutionBtn.h / 2);
        this.registerUiTooltip(layout.setResolutionBtn, this.tooltipFor("export_scale"));
        this.fill(0);
        this.textAlign(37, 101);
        this.text("Current export scale: x" + Main.nf((float)this.exportScale, (int)1, (int)2), labelX, layout.exportScaleLabelY);
        this.fill(60);
        this.textAlign(37, 101);
        this.text("Uses Rendering tab toggles (biomes, zones, paths, etc.)\nand current viewport + padding.", labelX, layout.bodyY);
        this.fill(0);
        this.textAlign(37, 101);
        this.text("Map data (JSON)", labelX, layout.mapSectionY);
        this.drawBevelButton(layout.mapExportBtn.x, layout.mapExportBtn.y, layout.mapExportBtn.w, layout.mapExportBtn.h, false);
        this.drawBevelButton(layout.mapImportBtn.x, layout.mapImportBtn.y, layout.mapImportBtn.w, layout.mapImportBtn.h, false);
        this.fill(10);
        this.textAlign(3, 3);
        this.text("Export map", layout.mapExportBtn.x + layout.mapExportBtn.w / 2, layout.mapExportBtn.y + layout.mapExportBtn.h / 2);
        this.text("Import map", layout.mapImportBtn.x + layout.mapImportBtn.w / 2, layout.mapImportBtn.y + layout.mapImportBtn.h / 2);
        this.registerUiTooltip(layout.mapExportBtn, this.tooltipFor("export_map_json"));
        this.registerUiTooltip(layout.mapImportBtn, this.tooltipFor("import_map_json"));
        this.fill(30);
        this.textAlign(37, 101);
        String status = this.lastExportStatus != null && this.lastExportStatus.length() > 0 ? "Last export: " + this.lastExportStatus : "No export yet.";
        this.text(status, labelX, layout.statusY);
    }

    public String exportPng() {
        long tExportStart = this.millis();
        if (!this.ensureExportPreview()) {
            return "Export failed: preview unavailable";
        }
        if (this.exportPreview == null) {
            return "Export failed: no buffer";
        }
        String dir = "exports";
        File folder = new File(dir);
        folder.mkdirs();
        String ts = String.valueOf(Main.nf((float)Main.year(), (int)4, (int)0)) + Main.nf((float)Main.month(), (int)2, (int)0) + Main.nf((float)Main.day(), (int)2, (int)0) + "_" + Main.nf((float)Main.hour(), (int)2, (int)0) + Main.nf((float)Main.minute(), (int)2, (int)0) + Main.nf((float)Main.second(), (int)2, (int)0);
        String path = String.valueOf(dir) + File.separator + "map_" + ts + ".png";
        this.exportPreview.save(path);
        long tExportEnd = this.millis();
        Main.println((String)("Export timing ms: total=" + (tExportEnd - tExportStart)));
        return path;
    }

    public String exportSvg() {
        float arbLabelSize;
        StringBuilder pts;
        Object zt;
        boolean drawBiomes;
        float worldW = this.mapModel.maxX - this.mapModel.minX;
        float worldH = this.mapModel.maxY - this.mapModel.minY;
        if (worldW <= 0.0f || worldH <= 0.0f) {
            return "Failed: invalid world bounds";
        }
        float safePad = Main.constrain((float)this.renderPaddingPct, (float)0.0f, (float)0.49f);
        float padX = Main.max((float)0.0f, (float)safePad) * worldW;
        float padY = Main.max((float)0.0f, (float)safePad) * worldH;
        float innerWX = this.mapModel.minX + padX;
        float innerWY = this.mapModel.minY + padY;
        float innerWW = worldW - padX * 2.0f;
        float innerWH = worldH - padY * 2.0f;
        if (innerWW <= 1.0E-6f || innerWH <= 1.0E-6f) {
            return "Failed: export padding too large";
        }
        float innerAspect = innerWW / innerWH;
        float safeScale = Main.max((float)0.1f, (float)this.exportScale);
        int pxH = Main.max((int)1, (int)Main.round((float)((float)Main.max((int)1, (int)this.height) * safeScale)));
        int pxW = Main.max((int)1, (int)Main.round((float)((float)pxH * innerAspect)));
        if (pxW <= 0 || pxH <= 0) {
            return "Failed: export size collapsed";
        }
        float scaleX = (float)pxW / innerWW;
        float scaleY = (float)pxH / innerWH;
        DecimalFormat df = new DecimalFormat("0.###");
        Function<Float, String> fmt = v -> df.format(v);
        Function<String, String> esc = v -> {
            if (v == null) {
                return "";
            }
            return v.replace("&", "&amp;").replace("<", "&lt;").replace("\"", "&quot;");
        };
        Function<Integer, String> toHex = rgb -> {
            int r = rgb >> 16 & 0xFF;
            int g = rgb >> 8 & 0xFF;
            int b = rgb & 0xFF;
            return String.format("#%02X%02X%02X", r, g, b);
        };
        Function<PVector, PVector> worldToSvg = w -> new PVector((w.x - innerWX) * scaleX, (w.y - innerWY) * scaleY);
        float[] hsbScratch = new float[3];
        RenderSettings s = this.renderSettings;
        int landRgb = this.hsb01ToARGB(s.landHue01, s.landSat01, s.landBri01, 1.0f);
        int waterRgb = this.hsb01ToARGB(s.waterHue01, s.waterSat01, s.waterBri01, 1.0f);
        String landHex = toHex.apply(landRgb);
        String waterHex = toHex.apply(waterRgb);
        StringBuilder sb = new StringBuilder();
        sb.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n");
        sb.append("<svg xmlns=\"http://www.w3.org/2000/svg\" width=\"").append(pxW).append("\" height=\"").append(pxH).append("\" viewBox=\"0 0 ").append(pxW).append(" ").append(pxH).append("\">\n");
        sb.append("  <style>text{font-family:sans-serif;fill:#000;} .water{fill:").append(waterHex).append(";}</style>\n");
        sb.append("  <g id=\"background\">\n");
        sb.append("    <rect width=\"").append(pxW).append("\" height=\"").append(pxH).append("\" fill=\"").append(landHex).append("\" />\n");
        sb.append("  </g>\n");
        sb.append("  <g id=\"water\">\n");
        if (this.mapModel.cells != null) {
            int ci = 0;
            while (ci < this.mapModel.cells.size()) {
                Cell c = this.mapModel.cells.get(ci);
                if (c != null && c.vertices != null && c.vertices.size() >= 3 && !(c.elevation >= this.seaLevel)) {
                    StringBuilder path = new StringBuilder();
                    int i = 0;
                    while (i < c.vertices.size()) {
                        PVector v2 = worldToSvg.apply(c.vertices.get(i));
                        path.append(i == 0 ? "M " : " L ");
                        path.append(fmt.apply(Float.valueOf(v2.x))).append(" ").append(fmt.apply(Float.valueOf(v2.y)));
                        ++i;
                    }
                    path.append(" Z");
                    sb.append("    <path d=\"").append(path.toString()).append("\" fill=\"").append(waterHex).append("\" stroke=\"none\" class=\"water\" data-cell-id=\"").append(ci).append("\"/>\n");
                }
                ++ci;
            }
        }
        sb.append("  </g>\n");
        sb.append("  <g id=\"biomes\">\n");
        boolean bl = drawBiomes = this.mapModel.cells != null && this.mapModel.biomeTypes != null && this.mapModel.biomeTypes.size() > 0 && (s.biomeFillAlpha01 > 1.0E-4f || s.biomeUnderwaterAlpha01 > 1.0E-4f);
        if (drawBiomes) {
            int ci = 0;
            while (ci < this.mapModel.cells.size()) {
                Cell c = this.mapModel.cells.get(ci);
                if (c != null && c.vertices != null && c.vertices.size() >= 3) {
                    float alpha;
                    boolean isWater = c.elevation < this.seaLevel;
                    float f = alpha = isWater ? s.biomeUnderwaterAlpha01 : s.biomeFillAlpha01;
                    if (!(alpha <= 1.0E-4f) && c.biomeId >= 0 && c.biomeId < this.mapModel.biomeTypes.size() && (zt = this.mapModel.biomeTypes.get(c.biomeId)) != null) {
                        this.rgbToHSB01(((ZoneType)zt).col, hsbScratch);
                        hsbScratch[1] = Main.constrain((float)(hsbScratch[1] * s.biomeSatScale01), (float)0.0f, (float)1.0f);
                        hsbScratch[2] = Main.constrain((float)(hsbScratch[2] * s.biomeBriScale01), (float)0.0f, (float)1.0f);
                        int rgb2 = this.hsb01ToARGB(hsbScratch[0], hsbScratch[1], hsbScratch[2], 1.0f);
                        String fill = toHex.apply(rgb2);
                        StringBuilder path = new StringBuilder();
                        int i = 0;
                        while (i < c.vertices.size()) {
                            PVector v3 = worldToSvg.apply(c.vertices.get(i));
                            path.append(i == 0 ? "M " : " L ");
                            path.append(fmt.apply(Float.valueOf(v3.x))).append(" ").append(fmt.apply(Float.valueOf(v3.y)));
                            ++i;
                        }
                        path.append(" Z");
                        sb.append("    <path d=\"").append(path.toString()).append("\" fill=\"").append(fill).append("\" fill-opacity=\"").append(fmt.apply(Float.valueOf(alpha))).append("\" stroke=\"none\" class=\"biome biome-").append(c.biomeId).append("\" data-biome-id=\"").append(c.biomeId).append("\" data-cell-id=\"").append(ci).append("\"/>\n");
                    }
                }
                ++ci;
            }
        }
        sb.append("  </g>\n");
        sb.append("  <g id=\"borders\">\n");
        sb.append("    <rect x=\"0\" y=\"0\" width=\"").append(pxW).append("\" height=\"").append(pxH).append("\" fill=\"none\" stroke=\"#000\" stroke-width=\"1\"/>\n");
        sb.append("  </g>\n");
        sb.append("  <g id=\"zones\">\n");
        if (s.zoneStrokeAlpha01 > 1.0E-4f && this.mapModel.zones != null && this.mapModel.cells != null) {
            int zi = 0;
            while (zi < this.mapModel.zones.size()) {
                MapModel.MapZone z = this.mapModel.zones.get(zi);
                if (z != null && z.cells != null) {
                    this.rgbToHSB01(z.col, hsbScratch);
                    hsbScratch[1] = Main.constrain((float)(hsbScratch[1] * s.zoneStrokeSatScale01), (float)0.0f, (float)1.0f);
                    hsbScratch[2] = Main.constrain((float)(hsbScratch[2] * s.zoneStrokeBriScale01), (float)0.0f, (float)1.0f);
                    String stroke = toHex.apply(this.hsb01ToARGB(hsbScratch[0], hsbScratch[1], hsbScratch[2], 1.0f));
                    zt = z.cells.iterator();
                    while (zt.hasNext()) {
                        Cell c;
                        int ci = (Integer)zt.next();
                        if (ci < 0 || ci >= this.mapModel.cells.size() || (c = this.mapModel.cells.get(ci)) == null || c.vertices == null || c.vertices.size() < 3) continue;
                        StringBuilder path = new StringBuilder();
                        int i = 0;
                        while (i < c.vertices.size()) {
                            PVector v4 = worldToSvg.apply(c.vertices.get(i));
                            path.append(i == 0 ? "M " : " L ");
                            path.append(fmt.apply(Float.valueOf(v4.x))).append(" ").append(fmt.apply(Float.valueOf(v4.y)));
                            ++i;
                        }
                        path.append(" Z");
                        sb.append("    <path d=\"").append(path.toString()).append("\" fill=\"none\" stroke=\"").append(stroke).append("\" stroke-width=\"1\" stroke-linejoin=\"round\" stroke-linecap=\"round\" stroke-opacity=\"").append(fmt.apply(Float.valueOf(s.zoneStrokeAlpha01))).append("\" class=\"zone zone-").append(zi).append("\" data-zone-id=\"").append(zi).append("\" data-comment=\"").append(esc.apply(z.comment != null ? z.comment : "")).append("\"/>\n");
                    }
                }
                ++zi;
            }
        }
        sb.append("  </g>\n");
        sb.append("  <g id=\"coast\">\n");
        ArrayList<PVector[]> coastSegs = this.mapModel.collectCoastSegments(this.seaLevel);
        for (PVector[] seg : coastSegs) {
            if (seg == null || seg.length != 2) continue;
            PVector a = worldToSvg.apply(seg[0]);
            PVector b = worldToSvg.apply(seg[1]);
            sb.append("    <line x1=\"").append(fmt.apply(Float.valueOf(a.x))).append("\" y1=\"").append(fmt.apply(Float.valueOf(a.y))).append("\" x2=\"").append(fmt.apply(Float.valueOf(b.x))).append("\" y2=\"").append(fmt.apply(Float.valueOf(b.y))).append("\" stroke=\"").append(waterHex).append("\" stroke-width=\"1\" stroke-linecap=\"round\" class=\"coast\"/>\n");
        }
        sb.append("  </g>\n");
        sb.append("  <g id=\"paths\">\n");
        if (s.showPaths && this.mapModel.paths != null) {
            int pi = 0;
            while (pi < this.mapModel.paths.size()) {
                Path p = this.mapModel.paths.get(pi);
                if (p != null && p.routes != null && !p.routes.isEmpty()) {
                    int typeCount = this.mapModel.pathTypes != null ? this.mapModel.pathTypes.size() : 0;
                    int typeId = Main.constrain((int)p.typeId, (int)0, (int)Main.max((int)0, (int)(typeCount - 1)));
                    int col = this.mapModel.pathTypes != null && typeId >= 0 && typeId < typeCount ? this.mapModel.pathTypes.get((int)typeId).col : this.color(80);
                    float wPx = this.mapModel.pathTypes != null && typeId >= 0 && typeId < typeCount ? this.mapModel.pathTypes.get((int)typeId).weightPx : 2.0f;
                    String stroke = toHex.apply(col);
                    String name = p.name != null && p.name.length() > 0 ? p.name : "Path";
                    int ri = 0;
                    while (ri < p.routes.size()) {
                        ArrayList<PVector> route = p.routes.get(ri);
                        if (route != null && route.size() >= 2) {
                            pts = new StringBuilder();
                            for (PVector v5 : route) {
                                PVector spt = worldToSvg.apply(v5);
                                if (pts.length() > 0) {
                                    pts.append(" ");
                                }
                                pts.append(fmt.apply(Float.valueOf(spt.x))).append(",").append(fmt.apply(Float.valueOf(spt.y)));
                            }
                            sb.append("    <polyline points=\"").append(pts.toString()).append("\" fill=\"none\" stroke=\"").append(stroke).append("\" stroke-width=\"").append(fmt.apply(Float.valueOf(wPx))).append("\" stroke-linecap=\"round\" stroke-linejoin=\"round\" class=\"path type-").append(typeId).append("\" data-type-id=\"").append(typeId).append("\" data-path-id=\"").append(pi).append("\" data-name=\"").append(esc.apply(name)).append("\" data-comment=\"").append(esc.apply(p.comment != null ? p.comment : "")).append("\"/>\n");
                        }
                        ++ri;
                    }
                }
                ++pi;
            }
        }
        sb.append("  </g>\n");
        sb.append("  <g id=\"structures\">\n");
        if (s.showStructures && this.mapModel.structures != null) {
            int si = 0;
            while (si < this.mapModel.structures.size()) {
                Structure st = this.mapModel.structures.get(si);
                if (st != null) {
                    PVector sp = worldToSvg.apply(new PVector(st.x, st.y));
                    float sizePx = st.size * scaleX;
                    float strokePx = st.strokeWeightPx;
                    int rgb3 = st.fillCol;
                    String fill = toHex.apply(rgb3);
                    String name = st.name != null && st.name.length() > 0 ? st.name : "Structure";
                    float angleDeg = Main.degrees((float)st.angle);
                    sb.append("    <g transform=\"translate(").append(fmt.apply(Float.valueOf(sp.x))).append(",").append(fmt.apply(Float.valueOf(sp.y))).append(") rotate(").append(fmt.apply(Float.valueOf(angleDeg))).append(")\" class=\"structure type-").append(st.typeId).append("\" data-type-id=\"").append(st.typeId).append("\" data-structure-id=\"").append(si).append("\" data-name=\"").append(esc.apply(name)).append("\" data-comment=\"").append(esc.apply(st.comment != null ? st.comment : "")).append("\">");
                    switch (st.shape) {
                        case RECTANGLE: {
                            float w2 = sizePx;
                            float h = st.aspect != 0.0f ? sizePx / Main.max((float)0.1f, (float)st.aspect) : sizePx;
                            sb.append("<rect x=\"").append(fmt.apply(Float.valueOf(-w2 * 0.5f))).append("\" y=\"").append(fmt.apply(Float.valueOf(-h * 0.5f))).append("\" width=\"").append(fmt.apply(Float.valueOf(w2))).append("\" height=\"").append(fmt.apply(Float.valueOf(h))).append("\" fill=\"").append(fill).append("\" fill-opacity=\"").append(fmt.apply(Float.valueOf(st.alpha01))).append("\" stroke=\"#000\" stroke-width=\"").append(fmt.apply(Float.valueOf(strokePx))).append("\"/>");
                            break;
                        }
                        case CIRCLE: {
                            sb.append("<circle cx=\"0\" cy=\"0\" r=\"").append(fmt.apply(Float.valueOf(sizePx * 0.5f))).append("\" fill=\"").append(fill).append("\" fill-opacity=\"").append(fmt.apply(Float.valueOf(st.alpha01))).append("\" stroke=\"#000\" stroke-width=\"").append(fmt.apply(Float.valueOf(strokePx))).append("\"/>");
                            break;
                        }
                        case TRIANGLE: {
                            float r = sizePx;
                            float h = r * 0.866f;
                            sb.append("<polygon points=\"").append(fmt.apply(Float.valueOf(-r * 0.5f))).append(",").append(fmt.apply(Float.valueOf(h * 0.333f))).append(" ").append(fmt.apply(Float.valueOf(r * 0.5f))).append(",").append(fmt.apply(Float.valueOf(h * 0.333f))).append(" ").append(fmt.apply(Float.valueOf(0.0f))).append(",").append(fmt.apply(Float.valueOf(-h * 0.666f))).append("\" fill=\"").append(fill).append("\" fill-opacity=\"").append(fmt.apply(Float.valueOf(st.alpha01))).append("\" stroke=\"#000\" stroke-width=\"").append(fmt.apply(Float.valueOf(strokePx))).append("\"/>");
                            break;
                        }
                        case HEXAGON: {
                            float rad = sizePx * 0.5f;
                            pts = new StringBuilder();
                            int v6 = 0;
                            while (v6 < 6) {
                                float a = Main.radians((float)(60 * v6));
                                float vx = Main.cos((float)a) * rad;
                                float vy = Main.sin((float)a) * rad;
                                if (pts.length() > 0) {
                                    pts.append(" ");
                                }
                                pts.append(fmt.apply(Float.valueOf(vx))).append(",").append(fmt.apply(Float.valueOf(vy)));
                                ++v6;
                            }
                            sb.append("<polygon points=\"").append(pts.toString()).append("\" fill=\"").append(fill).append("\" fill-opacity=\"").append(fmt.apply(Float.valueOf(st.alpha01))).append("\" stroke=\"#000\" stroke-width=\"").append(fmt.apply(Float.valueOf(strokePx))).append("\"/>");
                            break;
                        }
                        default: {
                            float w3 = sizePx;
                            float h = sizePx;
                            sb.append("<rect x=\"").append(fmt.apply(Float.valueOf(-w3 * 0.5f))).append("\" y=\"").append(fmt.apply(Float.valueOf(-h * 0.5f))).append("\" width=\"").append(fmt.apply(Float.valueOf(w3))).append("\" height=\"").append(fmt.apply(Float.valueOf(h))).append("\" fill=\"").append(fill).append("\" fill-opacity=\"").append(fmt.apply(Float.valueOf(st.alpha01))).append("\" stroke=\"#000\" stroke-width=\"").append(fmt.apply(Float.valueOf(strokePx))).append("\"/>");
                        }
                    }
                    sb.append("</g>\n");
                }
                ++si;
            }
        }
        sb.append("  </g>\n");
        sb.append("  <g id=\"labels\">\n");
        float baseLabelSize = this.renderSettings != null && this.renderSettings.labelSizeZonePx > 0.0f ? this.renderSettings.labelSizeZonePx : this.labelSizeDefault();
        float pathLabelSize = this.renderSettings != null && this.renderSettings.labelSizePathPx > 0.0f ? this.renderSettings.labelSizePathPx : baseLabelSize;
        float structLabelSize = this.renderSettings != null && this.renderSettings.labelSizeStructPx > 0.0f ? this.renderSettings.labelSizeStructPx : baseLabelSize;
        float f = arbLabelSize = this.renderSettings != null && this.renderSettings.labelSizeArbPx > 0.0f ? this.renderSettings.labelSizeArbPx : this.labelSizeDefault();
        if (s.showLabelsZones && this.mapModel.zones != null) {
            for (MapModel.MapZone z : this.mapModel.zones) {
                if (z == null || z.cells == null || z.cells.isEmpty()) continue;
                float cx = 0.0f;
                float cy = 0.0f;
                int count = 0;
                for (int ci : z.cells) {
                    Cell c;
                    if (ci < 0 || ci >= this.mapModel.cells.size() || (c = this.mapModel.cells.get(ci)) == null || c.vertices == null || c.vertices.size() < 3) continue;
                    PVector cen = this.mapModel.cellCentroid(c);
                    cx += cen.x;
                    cy += cen.y;
                    ++count;
                }
                if (count <= 0) continue;
                PVector sp = worldToSvg.apply(new PVector(cx /= (float)count, cy /= (float)count));
                String name = z.name != null && z.name.length() > 0 ? z.name : "Zone";
                sb.append("    <text x=\"").append(fmt.apply(Float.valueOf(sp.x))).append("\" y=\"").append(fmt.apply(Float.valueOf(sp.y))).append("\" text-anchor=\"middle\" dominant-baseline=\"middle\" font-size=\"").append(fmt.apply(Float.valueOf(baseLabelSize))).append("\" class=\"label zone\" data-name=\"").append(esc.apply(name)).append("\" data-comment=\"").append(esc.apply(z.comment != null ? z.comment : "")).append("\">").append(esc.apply(name)).append("</text>\n");
            }
        }
        if (s.showLabelsPaths && this.mapModel.paths != null) {
            int pi = 0;
            while (pi < this.mapModel.paths.size()) {
                Path p = this.mapModel.paths.get(pi);
                if (p != null && p.routes != null && !p.routes.isEmpty()) {
                    String txt = p.name != null && p.name.length() > 0 ? p.name : "Path";
                    PVector bestA = null;
                    PVector bestB = null;
                    float bestLenSq = -1.0f;
                    for (ArrayList<PVector> route : p.routes) {
                        if (route == null || route.size() < 2) continue;
                        int i = 0;
                        while (i < route.size() - 1) {
                            PVector a = route.get(i);
                            PVector b = route.get(i + 1);
                            float dx = b.x - a.x;
                            float dy = b.y - a.y;
                            float lenSq = dx * dx + dy * dy;
                            if (lenSq > bestLenSq) {
                                bestLenSq = lenSq;
                                bestA = a;
                                bestB = b;
                            }
                            ++i;
                        }
                    }
                    if (bestA != null && bestB != null && !(bestLenSq <= 1.0E-8f)) {
                        float angle = Main.degrees((float)Main.atan2((float)(bestB.y - bestA.y), (float)(bestB.x - bestA.x)));
                        if (angle > 90.0f || angle < -90.0f) {
                            angle += 180.0f;
                        }
                        float mx = (bestA.x + bestB.x) * 0.5f;
                        float my = (bestA.y + bestB.y) * 0.5f;
                        PVector sp = worldToSvg.apply(new PVector(mx, my));
                        sb.append("    <text x=\"").append(fmt.apply(Float.valueOf(sp.x))).append("\" y=\"").append(fmt.apply(Float.valueOf(sp.y))).append("\" text-anchor=\"middle\" dominant-baseline=\"middle\" font-size=\"").append(fmt.apply(Float.valueOf(pathLabelSize))).append("\" transform=\"rotate(").append(fmt.apply(Float.valueOf(angle))).append(" ").append(fmt.apply(Float.valueOf(sp.x))).append(" ").append(fmt.apply(Float.valueOf(sp.y))).append(")\" class=\"label path\" data-path-id=\"").append(pi).append("\" data-name=\"").append(esc.apply(txt)).append("\" data-comment=\"").append(esc.apply(p.comment != null ? p.comment : "")).append("\">").append(esc.apply(txt)).append("</text>\n");
                    }
                }
                ++pi;
            }
        }
        if (s.showLabelsStructures && this.mapModel.structures != null) {
            int si = 0;
            while (si < this.mapModel.structures.size()) {
                Structure st = this.mapModel.structures.get(si);
                if (st != null) {
                    String txt = st.name != null && st.name.length() > 0 ? st.name : "Structure";
                    PVector sp = worldToSvg.apply(new PVector(st.x, st.y));
                    sb.append("    <text x=\"").append(fmt.apply(Float.valueOf(sp.x))).append("\" y=\"").append(fmt.apply(Float.valueOf(sp.y))).append("\" text-anchor=\"middle\" dominant-baseline=\"middle\" font-size=\"").append(fmt.apply(Float.valueOf(structLabelSize))).append("\" class=\"label structure\" data-structure-id=\"").append(si).append("\" data-name=\"").append(esc.apply(txt)).append("\" data-comment=\"").append(esc.apply(st.comment != null ? st.comment : "")).append("\">").append(esc.apply(txt)).append("</text>\n");
                }
                ++si;
            }
        }
        if (s.showLabelsArbitrary && this.mapModel.labels != null) {
            int li = 0;
            while (li < this.mapModel.labels.size()) {
                MapLabel l = this.mapModel.labels.get(li);
                if (l != null && l.text != null && l.text.length() != 0) {
                    PVector sp = worldToSvg.apply(new PVector(l.x, l.y));
                    sb.append("    <text x=\"").append(fmt.apply(Float.valueOf(sp.x))).append("\" y=\"").append(fmt.apply(Float.valueOf(sp.y))).append("\" text-anchor=\"middle\" dominant-baseline=\"middle\" font-size=\"").append(fmt.apply(Float.valueOf(arbLabelSize))).append("\" class=\"label arbitrary\" data-label-id=\"").append(li).append("\" data-comment=\"").append(esc.apply(l.comment != null ? l.comment : "")).append("\">").append(esc.apply(l.text)).append("</text>\n");
                }
                ++li;
            }
        }
        sb.append("  </g>\n");
        sb.append("  <g id=\"legend\">\n");
        float legendX = 12.0f;
        float legendY = 18.0f;
        sb.append("    <text x=\"").append(fmt.apply(Float.valueOf(legendX))).append("\" y=\"").append(fmt.apply(Float.valueOf(legendY))).append("\" font-size=\"12\" text-anchor=\"start\" dominant-baseline=\"hanging\">Legend</text>\n");
        legendY += 16.0f;
        if (this.mapModel.pathTypes != null) {
            int i = 0;
            while (i < this.mapModel.pathTypes.size()) {
                PathType pt = this.mapModel.pathTypes.get(i);
                if (pt != null) {
                    sb.append("    <text x=\"").append(fmt.apply(Float.valueOf(legendX))).append("\" y=\"").append(fmt.apply(Float.valueOf(legendY))).append("\" font-size=\"11\" text-anchor=\"start\" dominant-baseline=\"hanging\" class=\"legend-path type-").append(i).append("\" data-type-id=\"").append(i).append("\">Path type ").append(i).append(": ").append(esc.apply(pt.name != null ? pt.name : "")).append("</text>\n");
                    legendY += 14.0f;
                }
                ++i;
            }
        }
        if (this.mapModel.structures != null && !this.mapModel.structures.isEmpty()) {
            sb.append("    <text x=\"").append(fmt.apply(Float.valueOf(legendX))).append("\" y=\"").append(fmt.apply(Float.valueOf(legendY))).append("\" font-size=\"12\" text-anchor=\"start\" dominant-baseline=\"hanging\">Structures</text>\n");
            legendY += 14.0f;
            int i = 0;
            while (i < this.mapModel.structures.size()) {
                Structure st = this.mapModel.structures.get(i);
                if (st != null) {
                    sb.append("    <text x=\"").append(fmt.apply(Float.valueOf(legendX))).append("\" y=\"").append(fmt.apply(Float.valueOf(legendY))).append("\" font-size=\"11\" text-anchor=\"start\" dominant-baseline=\"hanging\" class=\"legend-structure type-").append(st.typeId).append("\" data-type-id=\"").append(st.typeId).append("\" data-structure-id=\"").append(i).append("\">").append(esc.apply(st.name != null ? st.name : "Structure")).append("</text>\n");
                    legendY += 14.0f;
                }
                ++i;
            }
        }
        sb.append("  </g>\n");
        sb.append("</svg>\n");
        String dir = "exports";
        File folder = new File(dir);
        folder.mkdirs();
        String ts = String.valueOf(Main.nf((float)Main.year(), (int)4, (int)0)) + Main.nf((float)Main.month(), (int)2, (int)0) + Main.nf((float)Main.day(), (int)2, (int)0) + "_" + Main.nf((float)Main.hour(), (int)2, (int)0) + Main.nf((float)Main.minute(), (int)2, (int)0) + Main.nf((float)Main.second(), (int)2, (int)0);
        String path = String.valueOf(dir) + File.separator + "map_" + ts + ".svg";
        PrintWriter writer = this.createWriter(path);
        writer.print(sb.toString());
        writer.flush();
        writer.close();
        return path;
    }

    public String exportMapJson() {
        try {
            JSONObject root = new JSONObject();
            JSONObject meta = new JSONObject();
            meta.setInt("schemaVersion", 1);
            meta.setString("savedAt", new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'").format(new Date()));
            root.setJSONObject("meta", meta);
            JSONObject view = new JSONObject();
            view.setFloat("centerX", this.viewport.centerX);
            view.setFloat("centerY", this.viewport.centerY);
            view.setFloat("zoom", this.viewport.zoom);
            root.setJSONObject("view", view);
            JSONObject settings = new JSONObject();
            settings.setJSONObject("render", this.serializeRenderSettings(this.renderSettings));
            root.setJSONObject("settings", settings);
            JSONObject types = new JSONObject();
            types.setJSONArray("pathTypes", this.serializePathTypes(this.mapModel.pathTypes));
            types.setJSONArray("biomeTypes", this.serializeZoneTypes(this.mapModel.biomeTypes));
            root.setJSONObject("types", types);
            root.setJSONArray("sites", this.serializeSites(this.mapModel.sites));
            root.setJSONArray("cells", this.serializeCells(this.mapModel.cells));
            root.setJSONArray("zones", this.serializeZones(this.mapModel.zones));
            root.setJSONArray("paths", this.serializePaths(this.mapModel.paths));
            root.setJSONArray("structures", this.serializeStructures(this.mapModel.structures));
            root.setJSONArray("labels", this.serializeLabels(this.mapModel.labels));
            File dir = new File(this.sketchPath("exports"));
            if (!dir.exists()) {
                dir.mkdirs();
            }
            String ts = String.valueOf(Main.nf((float)Main.year(), (int)4, (int)0)) + Main.nf((float)Main.month(), (int)2, (int)0) + Main.nf((float)Main.day(), (int)2, (int)0) + "_" + Main.nf((float)Main.hour(), (int)2, (int)0) + Main.nf((float)Main.minute(), (int)2, (int)0) + Main.nf((float)Main.second(), (int)2, (int)0);
            File target = new File(dir, "map_" + ts + ".json");
            File latest = new File(dir, "map_latest.json");
            this.saveJSONObject(root, target.getAbsolutePath());
            this.saveJSONObject(root, latest.getAbsolutePath());
            return target.getAbsolutePath();
        }
        catch (Exception e) {
            e.printStackTrace();
            return "Failed: " + e.getMessage();
        }
    }

    public void handlePathsMousePressed(float wx, float wy) {
        PVector snapped;
        if (this.mapModel.paths.isEmpty()) {
            Path np = new Path();
            np.typeId = this.activePathTypeIndex;
            np.name = this.mapModel.defaultPathNameForType(np.typeId);
            this.mapModel.paths.add(np);
            this.selectedPathIndex = 0;
        }
        if ((snapped = this.findNearestSnappingPoint(wx = Main.constrain((float)wx, (float)this.mapModel.minX, (float)this.mapModel.maxX), wy = Main.constrain((float)wy, (float)this.mapModel.minY, (float)this.mapModel.maxY), Float.MAX_VALUE)) == null) {
            return;
        }
        PVector target = snapped;
        if (this.pendingPathStart == null) {
            this.pendingPathStart = target;
            return;
        }
        if (Main.dist((float)this.pendingPathStart.x, (float)this.pendingPathStart.y, (float)target.x, (float)target.y) < 1.0E-6f) {
            this.pendingPathStart = null;
            return;
        }
        Path targetPath = this.selectedPathIndex >= 0 && this.selectedPathIndex < this.mapModel.paths.size() ? this.mapModel.paths.get(this.selectedPathIndex) : null;
        ArrayList<Object> route = new ArrayList<PVector>();
        if (this.pendingPathStart != null) {
            ArrayList<PVector> rp;
            PathRouteMode mode = this.currentPathRouteMode();
            if (mode == PathRouteMode.ENDS) {
                route.add(this.pendingPathStart.copy());
                route.add(target.copy());
            } else if (mode == PathRouteMode.PATHFIND && (rp = this.mapModel.findSnapPathFlattest(this.pendingPathStart, target)) != null && rp.size() > 1) {
                route = rp;
            }
            if (route.isEmpty()) {
                route = new ArrayList();
                route.add(this.pendingPathStart.copy());
                route.add(target.copy());
            }
        }
        if (targetPath == null) {
            Path np = new Path();
            np.typeId = this.activePathTypeIndex;
            np.name = this.mapModel.defaultPathNameForType(np.typeId);
            this.mapModel.paths.add(np);
            this.selectedPathIndex = this.mapModel.paths.size() - 1;
            targetPath = np;
        }
        if (targetPath.routes.isEmpty()) {
            targetPath.typeId = this.activePathTypeIndex;
        }
        this.mapModel.appendRouteToPath(targetPath, route);
        this.pendingPathStart = null;
    }

    public void mouseDragged() {
        boolean inPanel;
        IntRect panel;
        Object layout;
        if (this.isPanning) {
            int dx = this.mouseX - this.lastMouseX;
            int dy = this.mouseY - this.lastMouseY;
            this.viewport.panScreen(dx, dy);
            this.lastMouseX = this.mouseX;
            this.lastMouseY = this.mouseY;
            return;
        }
        if (this.mouseButton == 37 && this.activeSlider != 0) {
            this.updateActiveSlider(this.mouseX, this.mouseY);
            return;
        }
        if (this.mouseButton == 37 && this.currentTool == Tool.EDIT_SITES && this.isInSitesPanel(this.mouseX, this.mouseY)) {
            SitesLayout layout2 = this.buildSitesLayout();
            if (layout2.densitySlider.contains(this.mouseX, this.mouseY)) {
                float t = (float)(this.mouseX - layout2.densitySlider.x) / (float)layout2.densitySlider.w;
                int newCount = Main.round((float)(t * 50000.0f));
                this.siteTargetCount = Main.constrain((int)newCount, (int)0, (int)50000);
                return;
            }
            if (layout2.fuzzSlider.contains(this.mouseX, this.mouseY)) {
                float t = (float)(this.mouseX - layout2.fuzzSlider.x) / (float)layout2.fuzzSlider.w;
                t = Main.constrain((float)t, (float)0.0f, (float)1.0f);
                this.siteFuzz = t * 0.3f;
                return;
            }
            if (layout2.modeSlider.contains(this.mouseX, this.mouseY)) {
                int modeCount = this.placementModes.length;
                if (modeCount < 1) {
                    modeCount = 1;
                }
                float t = (float)(this.mouseX - layout2.modeSlider.x) / (float)layout2.modeSlider.w;
                t = Main.constrain((float)t, (float)0.0f, (float)1.0f);
                int idx = Main.round((float)(t * (float)(modeCount - 1)));
                this.placementModeIndex = Main.constrain((int)idx, (int)0, (int)(this.placementModes.length - 1));
                return;
            }
            return;
        }
        if (this.mouseButton == 37 && this.currentTool == Tool.EDIT_ELEVATION && this.isInElevationPanel(this.mouseX, this.mouseY)) {
            layout = this.buildElevationLayout();
            if (((ElevationLayout)layout).seaSlider.contains(this.mouseX, this.mouseY)) {
                float t = this.sliderNorm(((ElevationLayout)layout).seaSlider, this.mouseX);
                this.seaLevel = t * 1.0f - 0.5f;
                return;
            }
            if (((ElevationLayout)layout).radiusSlider.contains(this.mouseX, this.mouseY)) {
                float t = this.sliderNorm(((ElevationLayout)layout).radiusSlider, this.mouseX);
                this.elevationBrushRadius = Main.constrain((float)(0.01f + t * 0.19f), (float)0.01f, (float)0.2f);
                return;
            }
            if (((ElevationLayout)layout).strengthSlider.contains(this.mouseX, this.mouseY)) {
                float t = this.sliderNorm(((ElevationLayout)layout).strengthSlider, this.mouseX);
                this.elevationBrushStrength = Main.constrain((float)(0.005f + t * 0.19500001f), (float)0.005f, (float)0.2f);
                return;
            }
            if (((ElevationLayout)layout).noiseSlider.contains(this.mouseX, this.mouseY)) {
                float t = this.sliderNorm(((ElevationLayout)layout).noiseSlider, this.mouseX);
                this.elevationNoiseScale = Main.constrain((float)(1.0f + t * 11.0f), (float)1.0f, (float)12.0f);
                return;
            }
        }
        if (this.mouseButton == 37 && this.currentTool == Tool.EDIT_BIOMES && this.isInBiomesPanel(this.mouseX, this.mouseY)) {
            int n;
            layout = this.buildBiomesLayout();
            int n2 = n = this.mapModel.biomeTypes == null ? 0 : this.mapModel.biomeTypes.size();
            if (n > 0 && this.activeBiomeIndex >= 0 && this.activeBiomeIndex < n) {
                if (((BiomesLayout)layout).hueSlider.contains(this.mouseX, this.mouseY)) {
                    float t = (float)(this.mouseX - ((BiomesLayout)layout).hueSlider.x) / (float)((BiomesLayout)layout).hueSlider.w;
                    t = Main.constrain((float)t, (float)0.0f, (float)1.0f);
                    ZoneType active = this.mapModel.biomeTypes.get(this.activeBiomeIndex);
                    active.hue01 = t;
                    active.updateColorFromHSB();
                    this.activeSlider = 4;
                    return;
                }
                if (((BiomesLayout)layout).satSlider != null && ((BiomesLayout)layout).satSlider.contains(this.mouseX, this.mouseY)) {
                    float t = (float)(this.mouseX - ((BiomesLayout)layout).satSlider.x) / (float)((BiomesLayout)layout).satSlider.w;
                    t = Main.constrain((float)t, (float)0.0f, (float)1.0f);
                    ZoneType active = this.mapModel.biomeTypes.get(this.activeBiomeIndex);
                    active.sat01 = t;
                    active.updateColorFromHSB();
                    this.activeSlider = 69;
                    return;
                }
                if (((BiomesLayout)layout).briSlider != null && ((BiomesLayout)layout).briSlider.contains(this.mouseX, this.mouseY)) {
                    float t = (float)(this.mouseX - ((BiomesLayout)layout).briSlider.x) / (float)((BiomesLayout)layout).briSlider.w;
                    t = Main.constrain((float)t, (float)0.0f, (float)1.0f);
                    ZoneType active = this.mapModel.biomeTypes.get(this.activeBiomeIndex);
                    active.bri01 = t;
                    active.updateColorFromHSB();
                    this.activeSlider = 70;
                    return;
                }
            }
            if (((BiomesLayout)layout).brushSlider.contains(this.mouseX, this.mouseY)) {
                float t = this.sliderNorm(((BiomesLayout)layout).brushSlider, this.mouseX);
                this.zoneBrushRadius = Main.constrain((float)(0.01f + t * 0.14f), (float)0.01f, (float)0.15f);
                this.activeSlider = 5;
                return;
            }
        }
        if (this.mouseButton == 37 && this.currentTool == Tool.EDIT_BIOMES) {
            panel = this.getActivePanelRect();
            boolean bl = inPanel = panel != null && panel.contains(this.mouseX, this.mouseY);
            if (!inPanel) {
                PVector w = this.viewport.screenToWorld(this.mouseX, this.mouseY);
                if (this.currentBiomePaintMode == ZonePaintMode.ZONE_PAINT) {
                    this.paintBiomeBrush(w.x, w.y);
                }
            }
            return;
        }
        if (this.mouseButton == 37 && this.currentTool == Tool.EDIT_ZONES && this.isInZonesPanel(this.mouseX, this.mouseY)) {
            layout = this.buildZonesLayout();
            if (((ZonesLayout)layout).brushSlider.contains(this.mouseX, this.mouseY)) {
                float t = this.sliderNorm(((ZonesLayout)layout).brushSlider, this.mouseX);
                this.zoneBrushRadius = Main.constrain((float)(0.01f + t * 0.14f), (float)0.01f, (float)0.15f);
                this.activeSlider = 19;
                return;
            }
        }
        if (this.mouseButton == 37 && this.currentTool == Tool.EDIT_ZONES) {
            panel = this.getActivePanelRect();
            boolean bl = inPanel = panel != null && panel.contains(this.mouseX, this.mouseY);
            if (!inPanel) {
                PVector w = this.viewport.screenToWorld(this.mouseX, this.mouseY);
                if (this.currentZonePaintMode == ZonePaintMode.ZONE_PAINT) {
                    this.paintZoneBrush(w.x, w.y);
                }
            }
            return;
        }
        if (this.mouseButton == 37 && this.currentTool == Tool.EDIT_PATHS && this.pathEraserMode) {
            panel = this.getActivePanelRect();
            boolean bl = inPanel = panel != null && panel.contains(this.mouseX, this.mouseY);
            if (!inPanel && !this.isInPathsListPanel(this.mouseX, this.mouseY)) {
                PVector w = this.viewport.screenToWorld(this.mouseX, this.mouseY);
                this.mapModel.erasePathSegments(w.x, w.y, this.pathEraserRadius);
            }
            return;
        }
        if (this.isInActivePanel(this.mouseX, this.mouseY)) {
            return;
        }
        if (this.mouseButton == 37 && this.currentTool == Tool.EDIT_SITES && this.isDraggingSite && this.draggingSite != null) {
            PVector worldPos = this.viewport.screenToWorld(this.mouseX, this.mouseY);
            this.draggingSite.x = Main.constrain((float)worldPos.x, (float)this.mapModel.minX, (float)this.mapModel.maxX);
            this.draggingSite.y = Main.constrain((float)worldPos.y, (float)this.mapModel.minY, (float)this.mapModel.maxY);
            this.siteDirtyDuringDrag = true;
        } else if (this.mouseButton == 37 && this.currentTool == Tool.EDIT_ELEVATION) {
            PVector w = this.viewport.screenToWorld(this.mouseX, this.mouseY);
            float dir = this.elevationBrushRaise ? 1 : -1;
            this.mapModel.applyElevationBrush(w.x, w.y, this.elevationBrushRadius, this.elevationBrushStrength * dir, this.seaLevel);
            this.markRenderDirty();
        }
    }

    public void mouseReleased() {
        this.isPanning = false;
        if (this.mouseButton == 37) {
            this.runPendingButtonAction(this.mouseX, this.mouseY);
            this.isDraggingSite = false;
            this.draggingSite = null;
            if (this.siteDirtyDuringDrag) {
                this.mapModel.markVoronoiDirty();
                this.markRenderDirty();
                this.siteDirtyDuringDrag = false;
            }
            this.activeSlider = 0;
        }
    }

    public void updateActiveSlider(int mx, int my) {
        if (my < -99999) {
            return;
        }
        switch (this.activeSlider) {
            case 1: {
                SitesLayout l = this.buildSitesLayout();
                float t = this.sliderNorm(l.densitySlider, mx);
                int newCount = Main.round((float)(t * 50000.0f));
                this.siteTargetCount = Main.constrain((int)newCount, (int)0, (int)50000);
                break;
            }
            case 2: {
                SitesLayout l = this.buildSitesLayout();
                float t = this.sliderNorm(l.fuzzSlider, mx);
                t = Main.constrain((float)t, (float)0.0f, (float)1.0f);
                this.siteFuzz = t * 0.3f;
                break;
            }
            case 3: {
                SitesLayout l = this.buildSitesLayout();
                int modeCount = this.placementModes.length;
                float t = this.sliderNorm(l.modeSlider, mx);
                t = Main.constrain((float)t, (float)0.0f, (float)1.0f);
                int idx = Main.round((float)(t * (float)Main.max((int)1, (int)(modeCount - 1))));
                this.placementModeIndex = Main.constrain((int)idx, (int)0, (int)(this.placementModes.length - 1));
                break;
            }
            case 4: {
                BiomesLayout l = this.buildBiomesLayout();
                float t = this.sliderNorm(l.hueSlider, mx);
                t = Main.constrain((float)t, (float)0.0f, (float)1.0f);
                if (this.mapModel.biomeTypes == null || this.activeBiomeIndex < 0 || this.activeBiomeIndex >= this.mapModel.biomeTypes.size()) break;
                ZoneType active = this.mapModel.biomeTypes.get(this.activeBiomeIndex);
                active.hue01 = t;
                active.updateColorFromHSB();
                break;
            }
            case 69: {
                BiomesLayout l = this.buildBiomesLayout();
                float t = this.sliderNorm(l.satSlider, mx);
                t = Main.constrain((float)t, (float)0.0f, (float)1.0f);
                if (this.mapModel.biomeTypes == null || this.activeBiomeIndex < 0 || this.activeBiomeIndex >= this.mapModel.biomeTypes.size()) break;
                ZoneType active = this.mapModel.biomeTypes.get(this.activeBiomeIndex);
                active.sat01 = t;
                active.updateColorFromHSB();
                break;
            }
            case 70: {
                BiomesLayout l = this.buildBiomesLayout();
                float t = this.sliderNorm(l.briSlider, mx);
                t = Main.constrain((float)t, (float)0.0f, (float)1.0f);
                if (this.mapModel.biomeTypes == null || this.activeBiomeIndex < 0 || this.activeBiomeIndex >= this.mapModel.biomeTypes.size()) break;
                ZoneType active = this.mapModel.biomeTypes.get(this.activeBiomeIndex);
                active.bri01 = t;
                active.updateColorFromHSB();
                break;
            }
            case 5: {
                BiomesLayout l = this.buildBiomesLayout();
                float t = this.sliderNorm(l.brushSlider, mx);
                t = Main.constrain((float)t, (float)0.0f, (float)1.0f);
                this.zoneBrushRadius = Main.constrain((float)(0.01f + t * 0.14f), (float)0.01f, (float)0.15f);
                break;
            }
            case 65: {
                BiomesLayout l = this.buildBiomesLayout();
                int modeCount = this.biomeGenerateModes.length;
                float t = this.sliderNorm(l.genModeSelector, mx);
                t = Main.constrain((float)t, (float)0.0f, (float)1.0f);
                int idx = Main.round((float)(t * (float)Main.max((int)1, (int)(modeCount - 1))));
                this.biomeGenerateModeIndex = Main.constrain((int)idx, (int)0, (int)(modeCount - 1));
                break;
            }
            case 66: {
                BiomesLayout l = this.buildBiomesLayout();
                float t = this.sliderNorm(l.genValueSlider, mx);
                this.biomeGenerateValue01 = t = Main.constrain((float)t, (float)0.0f, (float)1.0f);
                break;
            }
            case 97: {
                BiomesLayout l = this.buildBiomesLayout();
                if (this.mapModel.biomeTypes == null || this.activeBiomeIndex < 0 || this.activeBiomeIndex >= this.mapModel.biomeTypes.size()) break;
                int patCount = Main.max((int)1, (int)this.mapModel.biomePatternCount);
                float t = this.sliderNorm(l.patternSlider, mx);
                int idx = patCount > 1 ? Main.round((float)(t * (float)(patCount - 1))) : 0;
                this.mapModel.biomeTypes.get((int)this.activeBiomeIndex).patternIndex = idx = Main.constrain((int)idx, (int)0, (int)(patCount - 1));
                break;
            }
            case 6: {
                ElevationLayout l = this.buildElevationLayout();
                float t = this.sliderNorm(l.seaSlider, mx);
                t = Main.constrain((float)t, (float)0.0f, (float)1.0f);
                float newSea = Main.lerp((float)-1.2f, (float)1.2f, (float)t);
                if (!(Main.abs((float)(newSea - this.seaLevel)) > 1.0E-6f)) break;
                this.seaLevel = newSea;
                this.markRenderDirty();
                break;
            }
            case 7: {
                ElevationLayout l = this.buildElevationLayout();
                float t = this.sliderNorm(l.radiusSlider, mx);
                t = Main.constrain((float)t, (float)0.0f, (float)1.0f);
                this.elevationBrushRadius = Main.constrain((float)(0.01f + t * 0.19f), (float)0.01f, (float)0.2f);
                break;
            }
            case 8: {
                ElevationLayout l = this.buildElevationLayout();
                float t = this.sliderNorm(l.strengthSlider, mx);
                t = Main.constrain((float)t, (float)0.0f, (float)1.0f);
                this.elevationBrushStrength = Main.constrain((float)(0.005f + t * 0.19500001f), (float)0.005f, (float)0.2f);
                break;
            }
            case 9: {
                ElevationLayout l = this.buildElevationLayout();
                float t = this.sliderNorm(l.noiseSlider, mx);
                t = Main.constrain((float)t, (float)0.0f, (float)1.0f);
                this.elevationNoiseScale = Main.constrain((float)(1.0f + t * 11.0f), (float)1.0f, (float)12.0f);
                break;
            }
            case 10: {
                PathsLayout l = this.buildPathsLayout();
                float t = this.sliderNorm(l.typeHueSlider, mx);
                t = Main.constrain((float)t, (float)0.0f, (float)1.0f);
                if (this.activePathTypeIndex < 0 || this.activePathTypeIndex >= this.mapModel.pathTypes.size()) break;
                PathType pt = this.mapModel.pathTypes.get(this.activePathTypeIndex);
                pt.hue01 = t;
                pt.updateColorFromHSB();
                break;
            }
            case 11: {
                PathsLayout l = this.buildPathsLayout();
                float t = this.sliderNorm(l.typeSatSlider, mx);
                t = Main.constrain((float)t, (float)0.0f, (float)1.0f);
                if (this.activePathTypeIndex < 0 || this.activePathTypeIndex >= this.mapModel.pathTypes.size()) break;
                PathType pt = this.mapModel.pathTypes.get(this.activePathTypeIndex);
                pt.sat01 = t;
                pt.updateColorFromHSB();
                break;
            }
            case 12: {
                PathsLayout l = this.buildPathsLayout();
                float t = this.sliderNorm(l.typeBriSlider, mx);
                t = Main.constrain((float)t, (float)0.0f, (float)1.0f);
                if (this.activePathTypeIndex < 0 || this.activePathTypeIndex >= this.mapModel.pathTypes.size()) break;
                PathType pt = this.mapModel.pathTypes.get(this.activePathTypeIndex);
                pt.bri01 = t;
                pt.updateColorFromHSB();
                break;
            }
            case 13: {
                PathsLayout l = this.buildPathsLayout();
                float t = this.sliderNorm(l.typeWeightSlider, mx);
                t = Main.constrain((float)t, (float)0.0f, (float)1.0f);
                if (this.activePathTypeIndex < 0 || this.activePathTypeIndex >= this.mapModel.pathTypes.size()) break;
                PathType pt = this.mapModel.pathTypes.get(this.activePathTypeIndex);
                pt.weightPx = Main.constrain((float)(0.5f + t * 7.5f), (float)0.5f, (float)8.0f);
                break;
            }
            case 21: {
                float minW;
                PathsLayout l = this.buildPathsLayout();
                float t = this.sliderNorm(l.typeMinWeightSlider, mx);
                t = Main.constrain((float)t, (float)0.0f, (float)1.0f);
                if (this.activePathTypeIndex < 0 || this.activePathTypeIndex >= this.mapModel.pathTypes.size()) break;
                PathType pt = this.mapModel.pathTypes.get(this.activePathTypeIndex);
                pt.minWeightPx = minW = Main.constrain((float)(0.5f + t * (pt.weightPx - 0.5f)), (float)0.5f, (float)pt.weightPx);
                break;
            }
            case 98: {
                PathsLayout l = this.buildPathsLayout();
                String[] modes = new String[]{"Ends", "Pathfind"};
                int modeCount = modes.length;
                float t = this.sliderNorm(l.routeSlider, mx);
                int idx = Main.round((float)(t * (float)Main.max((int)1, (int)(modeCount - 1))));
                this.pathRouteModeIndex = Main.constrain((int)idx, (int)0, (int)(modeCount - 1));
                if (this.activePathTypeIndex < 0 || this.activePathTypeIndex >= this.mapModel.pathTypes.size()) break;
                PathType pt = this.mapModel.pathTypes.get(this.activePathTypeIndex);
                pt.routeMode = PathRouteMode.values()[this.pathRouteModeIndex];
                break;
            }
            case 18: {
                break;
            }
            case 19: {
                ZonesLayout l = this.buildZonesLayout();
                float t = this.sliderNorm(l.brushSlider, mx);
                this.zoneBrushRadius = Main.constrain((float)(0.01f + t * 0.14f), (float)0.01f, (float)0.15f);
                break;
            }
            case 23: {
                ZonesListLayout l = this.buildZonesListLayout();
                this.populateZonesRows(l);
                if (this.activeZoneIndex < 0 || this.activeZoneIndex >= l.rows.size()) break;
                ZoneRowLayout row = l.rows.get(this.activeZoneIndex);
                float t = this.sliderNorm(row.hueSlider, mx);
                MapModel.MapZone az = this.mapModel.zones.get(this.activeZoneIndex);
                az.hue01 = t;
                az.updateColorFromHSB();
                break;
            }
            case 14: {
                PathsLayout l = this.buildPathsLayout();
                float t = this.sliderNorm(l.flattestSlider, mx);
                t = Main.constrain((float)t, (float)0.0f, (float)1.0f);
                this.flattestSlopeBias = Main.constrain((float)(0.0f + t * 1000.0f), (float)0.0f, (float)1000.0f);
                break;
            }
            case 17: 
            case 24: {
                float newSize;
                StructuresLayout l = this.buildStructuresLayout();
                float t = this.sliderNorm(l.sizeSlider, mx);
                t = Main.constrain((float)t, (float)0.0f, (float)1.0f);
                this.structureSize = newSize = Main.constrain((float)(0.01f + t * 0.19f), (float)0.01f, (float)0.2f);
                if (this.selectedStructureIndices == null || this.selectedStructureIndices.isEmpty()) break;
                for (int idx : this.selectedStructureIndices) {
                    if (idx < 0 || idx >= this.mapModel.structures.size()) continue;
                    this.mapModel.structures.get((int)idx).size = newSize;
                }
                break;
            }
            case 20: 
            case 25: {
                float angRad;
                StructuresLayout l = this.buildStructuresLayout();
                float t = this.sliderNorm(l.angleSlider, mx);
                t = Main.constrain((float)t, (float)0.0f, (float)1.0f);
                float angDeg = -180.0f + t * 360.0f;
                this.structureAngleOffsetRad = angRad = Main.radians((float)angDeg);
                if (this.selectedStructureIndices == null || this.selectedStructureIndices.isEmpty()) break;
                for (int idx : this.selectedStructureIndices) {
                    if (idx < 0 || idx >= this.mapModel.structures.size()) continue;
                    this.mapModel.structures.get((int)idx).angle = angRad;
                }
                break;
            }
            case 22: {
                float newRatio;
                StructuresLayout l = this.buildStructuresLayout();
                float t = this.sliderNorm(l.ratioSlider, mx);
                this.structureAspectRatio = newRatio = Main.constrain((float)(0.3f + t * 2.7f), (float)0.3f, (float)3.0f);
                if (this.selectedStructureIndices == null || this.selectedStructureIndices.isEmpty()) break;
                for (int idx : this.selectedStructureIndices) {
                    if (idx < 0 || idx >= this.mapModel.structures.size()) continue;
                    this.mapModel.structures.get((int)idx).aspect = newRatio;
                }
                break;
            }
            case 99: {
                StructuresLayout l = this.buildStructuresLayout();
                float t = this.sliderNorm(l.genTownSlider, mx);
                this.structGenTownCount = Main.constrain((int)Main.round((float)(t * 8.0f)), (int)0, (int)8);
                break;
            }
            case 100: {
                StructuresLayout l = this.buildStructuresLayout();
                float t = this.sliderNorm(l.genBuildingSlider, mx);
                this.structGenBuildingDensity = Main.constrain((float)t, (float)0.0f, (float)1.0f);
                break;
            }
            case 101: {
                StructuresLayout l = this.buildStructuresLayout();
                int divMin = 2;
                int divMax = 24;
                float t = this.sliderNorm(l.snapElevationSlider, mx);
                this.snapElevationDivisions = Main.round((float)Main.lerp((float)divMin, (float)divMax, (float)t));
                break;
            }
            case 102: {
                StructuresLayout l = this.buildStructuresLayout();
                StructureShape[] shapes = StructureShape.values();
                float t = this.sliderNorm(l.shapeSelector, mx);
                int idx = Main.round((float)(t * (float)Main.max((int)0, (int)(shapes.length - 1))));
                idx = Main.constrain((int)idx, (int)0, (int)(shapes.length - 1));
                this.structureShape = shapes[idx];
                if (this.selectedStructureIndices == null || this.selectedStructureIndices.isEmpty()) break;
                for (int si : this.selectedStructureIndices) {
                    if (si < 0 || si >= this.mapModel.structures.size()) continue;
                    this.mapModel.structures.get((int)si).shape = this.structureShape;
                }
                break;
            }
            case 103: {
                StructuresLayout l = this.buildStructuresLayout();
                StructureSnapMode[] snaps = StructureSnapMode.values();
                float t = this.sliderNorm(l.alignmentSelector, mx);
                int idx = Main.round((float)(t * (float)Main.max((int)0, (int)(snaps.length - 1))));
                idx = Main.constrain((int)idx, (int)0, (int)(snaps.length - 1));
                this.structureSnapMode = snaps[idx];
                if (this.selectedStructureIndices == null || this.selectedStructureIndices.isEmpty()) break;
                for (int si : this.selectedStructureIndices) {
                    if (si < 0 || si >= this.mapModel.structures.size()) continue;
                    this.mapModel.structures.get((int)si).alignment = this.structureSnapMode;
                }
                break;
            }
            case 26: {
                float t;
                StructuresLayout l = this.buildStructuresLayout();
                this.structureHue01 = t = this.sliderNorm(l.hueSlider, mx);
                if (this.selectedStructureIndices == null || this.selectedStructureIndices.isEmpty()) break;
                for (int idx : this.selectedStructureIndices) {
                    if (idx < 0 || idx >= this.mapModel.structures.size()) continue;
                    this.mapModel.structures.get(idx).setHue(t);
                }
                break;
            }
            case 27: {
                float t;
                StructuresLayout l = this.buildStructuresLayout();
                this.structureAlpha01 = t = this.sliderNorm(l.alphaSlider, mx);
                if (this.selectedStructureIndices == null || this.selectedStructureIndices.isEmpty()) break;
                for (int idx : this.selectedStructureIndices) {
                    if (idx < 0 || idx >= this.mapModel.structures.size()) continue;
                    this.mapModel.structures.get(idx).setAlpha(t);
                }
                break;
            }
            case 28: {
                float t;
                StructuresLayout l = this.buildStructuresLayout();
                this.structureSat01 = t = this.sliderNorm(l.satSlider, mx);
                if (this.selectedStructureIndices == null || this.selectedStructureIndices.isEmpty()) break;
                for (int idx : this.selectedStructureIndices) {
                    if (idx < 0 || idx >= this.mapModel.structures.size()) continue;
                    this.mapModel.structures.get(idx).setSaturation(t);
                }
                break;
            }
            case 29: {
                float w;
                StructuresLayout l = this.buildStructuresLayout();
                float t = this.sliderNorm(l.strokeSlider, mx);
                this.structureStrokePx = w = Main.constrain((float)(0.5f + t * 3.5f), (float)0.5f, (float)4.0f);
                if (this.selectedStructureIndices == null || this.selectedStructureIndices.isEmpty()) break;
                for (int idx : this.selectedStructureIndices) {
                    if (idx < 0 || idx >= this.mapModel.structures.size()) continue;
                    this.mapModel.structures.get((int)idx).strokeWeightPx = w;
                }
                break;
            }
            case 32: {
                RenderLayout l = this.buildRenderLayout();
                this.renderSettings.landHue01 = this.sliderNorm(l.landHSB[0], mx);
                break;
            }
            case 33: {
                RenderLayout l = this.buildRenderLayout();
                this.renderSettings.landSat01 = this.sliderNorm(l.landHSB[1], mx);
                break;
            }
            case 34: {
                RenderLayout l = this.buildRenderLayout();
                this.renderSettings.landBri01 = this.sliderNorm(l.landHSB[2], mx);
                break;
            }
            case 35: {
                RenderLayout l = this.buildRenderLayout();
                this.renderSettings.waterHue01 = this.sliderNorm(l.waterHSB[0], mx);
                break;
            }
            case 36: {
                RenderLayout l = this.buildRenderLayout();
                this.renderSettings.waterSat01 = this.sliderNorm(l.waterHSB[1], mx);
                break;
            }
            case 37: {
                RenderLayout l = this.buildRenderLayout();
                this.renderSettings.waterBri01 = this.sliderNorm(l.waterHSB[2], mx);
                break;
            }
            case 38: {
                float t;
                RenderLayout l = this.buildRenderLayout();
                this.renderSettings.cellBorderAlpha01 = t = this.sliderNorm(l.cellBordersAlphaSlider, mx);
                break;
            }
            case 39: {
                float t;
                RenderLayout l = this.buildRenderLayout();
                this.renderSettings.biomeFillAlpha01 = t = this.sliderNorm(l.biomeFillAlphaSlider, mx);
                break;
            }
            case 40: {
                float t;
                RenderLayout l = this.buildRenderLayout();
                this.renderSettings.biomeSatScale01 = t = this.sliderNorm(l.biomeSatSlider, mx);
                break;
            }
            case 62: {
                float t;
                RenderLayout l = this.buildRenderLayout();
                this.renderSettings.biomeBriScale01 = t = this.sliderNorm(l.biomeBriSlider, mx);
                break;
            }
            case 41: {
                RenderLayout l = this.buildRenderLayout();
                float t = this.sliderNorm(l.biomeOutlineSizeSlider, mx);
                this.renderSettings.biomeOutlineSizePx = Main.constrain((float)(t * 5.0f), (float)0.0f, (float)5.0f);
                break;
            }
            case 42: {
                float t;
                RenderLayout l = this.buildRenderLayout();
                this.renderSettings.biomeOutlineAlpha01 = t = this.sliderNorm(l.biomeOutlineAlphaSlider, mx);
                break;
            }
            case 67: {
                float t;
                RenderLayout l = this.buildRenderLayout();
                this.renderSettings.biomeUnderwaterAlpha01 = t = this.sliderNorm(l.biomeUnderwaterAlphaSlider, mx);
                break;
            }
            case 43: {
                float t;
                RenderLayout l = this.buildRenderLayout();
                this.renderSettings.waterDepthAlpha01 = t = this.sliderNorm(l.waterDepthAlphaSlider, mx);
                break;
            }
            case 44: {
                float t;
                RenderLayout l = this.buildRenderLayout();
                this.renderSettings.elevationLightAlpha01 = t = this.sliderNorm(l.lightAlphaSlider, mx);
                if (this.mapModel != null && this.mapModel.renderer != null) {
                    this.mapModel.renderer.invalidateLightCache();
                }
                this.markRenderVisualChange();
                break;
            }
            case 15: {
                RenderLayout l = this.buildRenderLayout();
                float t = this.sliderNorm(l.lightAzimuthSlider, mx);
                this.renderSettings.elevationLightAzimuthDeg = Main.constrain((float)(t * 360.0f), (float)0.0f, (float)360.0f);
                if (this.mapModel != null && this.mapModel.renderer != null) {
                    this.mapModel.renderer.invalidateLightCache();
                }
                this.markRenderVisualChange();
                break;
            }
            case 16: {
                RenderLayout l = this.buildRenderLayout();
                float t = this.sliderNorm(l.lightAltitudeSlider, mx);
                this.renderSettings.elevationLightAltitudeDeg = Main.constrain((float)(5.0f + t * 75.0f), (float)5.0f, (float)80.0f);
                if (this.mapModel != null && this.mapModel.renderer != null) {
                    this.mapModel.renderer.invalidateLightCache();
                }
                this.markRenderVisualChange();
                break;
            }
            case 45: {
                RenderLayout l = this.buildRenderLayout();
                float t = this.sliderNorm(l.waterContourSizeSlider, mx);
                this.renderSettings.waterContourSizePx = Main.constrain((float)(t * 5.0f), (float)0.0f, (float)5.0f);
                if (this.mapModel != null && this.mapModel.renderer != null) {
                    this.mapModel.renderer.invalidateCoastCache();
                }
                this.markRenderVisualChange();
                break;
            }
            case 106: {
                RenderLayout l = this.buildRenderLayout();
                float t = this.sliderNorm(l.waterCoastSizeSlider, mx);
                this.renderSettings.waterCoastSizePx = Main.constrain((float)(t * 5.0f), (float)0.0f, (float)5.0f);
                if (this.mapModel != null && this.mapModel.renderer != null) {
                    this.mapModel.renderer.invalidateCoastCache();
                }
                this.markRenderVisualChange();
                break;
            }
            case 46: {
                RenderLayout l = this.buildRenderLayout();
                float t = this.sliderNorm(l.waterRippleCountSlider, mx);
                this.renderSettings.waterRippleCount = Main.constrain((int)Main.round((float)(t * 5.0f)), (int)0, (int)5);
                if (this.mapModel != null && this.mapModel.renderer != null) {
                    this.mapModel.renderer.invalidateCoastCache();
                }
                this.markRenderVisualChange();
                break;
            }
            case 47: {
                RenderLayout l = this.buildRenderLayout();
                float t = this.sliderNorm(l.waterRippleDistanceSlider, mx);
                this.renderSettings.waterRippleDistancePx = Main.constrain((float)(t * 40.0f), (float)0.0f, (float)40.0f);
                if (this.mapModel != null && this.mapModel.renderer != null) {
                    this.mapModel.renderer.invalidateCoastCache();
                }
                this.markRenderVisualChange();
                break;
            }
            case 48: {
                RenderLayout l = this.buildRenderLayout();
                this.renderSettings.waterContourHue01 = this.sliderNorm(l.waterContourHSB[0], mx);
                if (this.mapModel != null && this.mapModel.renderer != null) {
                    this.mapModel.renderer.invalidateCoastCache();
                }
                this.markRenderVisualChange();
                break;
            }
            case 49: {
                RenderLayout l = this.buildRenderLayout();
                this.renderSettings.waterContourSat01 = this.sliderNorm(l.waterContourHSB[1], mx);
                if (this.mapModel != null && this.mapModel.renderer != null) {
                    this.mapModel.renderer.invalidateCoastCache();
                }
                this.markRenderVisualChange();
                break;
            }
            case 50: {
                RenderLayout l = this.buildRenderLayout();
                this.renderSettings.waterContourBri01 = this.sliderNorm(l.waterContourHSB[2], mx);
                if (this.mapModel != null && this.mapModel.renderer != null) {
                    this.mapModel.renderer.invalidateCoastCache();
                }
                this.markRenderVisualChange();
                break;
            }
            case 51: {
                float t;
                RenderLayout l = this.buildRenderLayout();
                this.renderSettings.waterCoastAlpha01 = t = this.sliderNorm(l.waterContourCoastAlphaSlider, mx);
                this.syncLegacyWaterContourAlpha(this.renderSettings);
                if (this.mapModel != null && this.mapModel.renderer != null) {
                    this.mapModel.renderer.invalidateCoastCache();
                }
                this.markRenderVisualChange();
                break;
            }
            case 72: {
                RenderLayout l = this.buildRenderLayout();
                float t = this.sliderNorm(l.waterHatchAngleSlider, mx);
                this.renderSettings.waterHatchAngleDeg = Main.constrain((float)(-90.0f + t * 180.0f), (float)-90.0f, (float)90.0f);
                if (this.mapModel != null && this.mapModel.renderer != null) {
                    this.mapModel.renderer.invalidateCoastCache();
                }
                this.markRenderVisualChange();
                break;
            }
            case 73: {
                RenderLayout l = this.buildRenderLayout();
                float t = this.sliderNorm(l.waterHatchLengthSlider, mx);
                this.renderSettings.waterHatchLengthPx = Main.constrain((float)(t * 400.0f), (float)0.0f, (float)400.0f);
                if (this.mapModel != null && this.mapModel.renderer != null) {
                    this.mapModel.renderer.invalidateCoastCache();
                }
                this.markRenderVisualChange();
                break;
            }
            case 74: {
                RenderLayout l = this.buildRenderLayout();
                float t = this.sliderNorm(l.waterHatchSpacingSlider, mx);
                this.renderSettings.waterHatchSpacingPx = Main.constrain((float)(t * 120.0f), (float)0.0f, (float)120.0f);
                if (this.mapModel != null && this.mapModel.renderer != null) {
                    this.mapModel.renderer.invalidateCoastCache();
                }
                this.markRenderVisualChange();
                break;
            }
            case 75: {
                float t;
                RenderLayout l = this.buildRenderLayout();
                this.renderSettings.waterHatchAlpha01 = t = this.sliderNorm(l.waterHatchAlphaSlider, mx);
                if (this.mapModel != null && this.mapModel.renderer != null) {
                    this.mapModel.renderer.invalidateCoastCache();
                }
                this.markRenderVisualChange();
                break;
            }
            case 52: {
                float t;
                RenderLayout l = this.buildRenderLayout();
                this.renderSettings.waterRippleAlphaStart01 = t = this.sliderNorm(l.waterRippleAlphaStartSlider, mx);
                if (this.mapModel != null && this.mapModel.renderer != null) {
                    this.mapModel.renderer.invalidateCoastCache();
                }
                this.markRenderVisualChange();
                break;
            }
            case 53: {
                float t;
                RenderLayout l = this.buildRenderLayout();
                this.renderSettings.waterRippleAlphaEnd01 = t = this.sliderNorm(l.waterRippleAlphaEndSlider, mx);
                if (this.mapModel != null && this.mapModel.renderer != null) {
                    this.mapModel.renderer.invalidateCoastCache();
                }
                this.markRenderVisualChange();
                break;
            }
            case 104: {
                RenderLayout l = this.buildRenderLayout();
                float t = this.sliderNorm(l.cellBordersSizeSlider, mx);
                this.renderSettings.cellBorderSizePx = Main.constrain((float)(t * 5.0f), (float)0.0f, (float)5.0f);
                this.markRenderVisualChange();
                break;
            }
            case 54: {
                RenderLayout l = this.buildRenderLayout();
                float t = this.sliderNorm(l.elevationLinesCountSlider, mx);
                this.renderSettings.elevationLinesCount = Main.constrain((int)Main.round((float)(t * 24.0f)), (int)0, (int)24);
                this.markRenderVisualChange();
                break;
            }
            case 55: {
                float t;
                RenderLayout l = this.buildRenderLayout();
                this.renderSettings.elevationLinesAlpha01 = t = this.sliderNorm(l.elevationLinesAlphaSlider, mx);
                this.markRenderVisualChange();
                break;
            }
            case 105: {
                RenderLayout l = this.buildRenderLayout();
                float t = this.sliderNorm(l.elevationLinesSizeSlider, mx);
                this.renderSettings.elevationLinesSizePx = Main.constrain((float)(t * 5.0f), (float)0.0f, (float)5.0f);
                this.markRenderVisualChange();
                break;
            }
            case 56: {
                float t;
                RenderLayout l = this.buildRenderLayout();
                this.renderSettings.pathSatScale01 = t = this.sliderNorm(l.pathSatSlider, mx);
                break;
            }
            case 90: {
                float t;
                RenderLayout l = this.buildRenderLayout();
                this.renderSettings.pathBriScale01 = t = this.sliderNorm(l.pathBriSlider, mx);
                break;
            }
            case 57: {
                float t;
                RenderLayout l = this.buildRenderLayout();
                this.renderSettings.zoneStrokeAlpha01 = t = this.sliderNorm(l.zoneAlphaSlider, mx);
                if (this.mapModel != null && this.mapModel.renderer != null) {
                    this.mapModel.renderer.invalidateZoneCache();
                }
                this.markRenderVisualChange();
                break;
            }
            case 58: {
                RenderLayout l = this.buildRenderLayout();
                float t = this.sliderNorm(l.zoneSizeSlider, mx);
                this.renderSettings.zoneStrokeSizePx = Main.constrain((float)(t * 5.0f), (float)0.0f, (float)5.0f);
                if (this.mapModel != null && this.mapModel.renderer != null) {
                    this.mapModel.renderer.invalidateZoneCache();
                }
                this.markRenderVisualChange();
                break;
            }
            case 59: {
                float t;
                RenderLayout l = this.buildRenderLayout();
                this.renderSettings.zoneStrokeSatScale01 = t = this.sliderNorm(l.zoneSatSlider, mx);
                if (this.mapModel != null && this.mapModel.renderer != null) {
                    this.mapModel.renderer.invalidateZoneCache();
                }
                this.markRenderVisualChange();
                break;
            }
            case 63: {
                float t;
                RenderLayout l = this.buildRenderLayout();
                this.renderSettings.zoneStrokeBriScale01 = t = this.sliderNorm(l.zoneBriSlider, mx);
                if (this.mapModel != null && this.mapModel.renderer != null) {
                    this.mapModel.renderer.invalidateZoneCache();
                }
                this.markRenderVisualChange();
                break;
            }
            case 76: {
                RenderLayout l = this.buildRenderLayout();
                float t = this.sliderNorm(l.lightDitherSlider, mx);
                this.renderSettings.elevationLightDitherPx = Main.constrain((float)(t * 10.0f), (float)0.0f, (float)10.0f);
                if (this.mapModel != null && this.mapModel.renderer != null) {
                    this.mapModel.renderer.invalidateLightCache();
                }
                this.markRenderVisualChange();
                break;
            }
            case 60: {
                float t;
                RenderLayout l = this.buildRenderLayout();
                this.renderSettings.labelOutlineAlpha01 = t = this.sliderNorm(l.labelsOutlineAlphaSlider, mx);
                break;
            }
            case 91: {
                RenderLayout l = this.buildRenderLayout();
                float t = this.sliderNorm(l.labelsOutlineSizeSlider, mx);
                this.renderSettings.labelOutlineSizePx = Main.round((float)Main.constrain((float)(t * 16.0f), (float)0.0f, (float)16.0f));
                break;
            }
            case 92: {
                RenderLayout l = this.buildRenderLayout();
                float t = this.sliderNorm(l.labelsArbSizeSlider, mx);
                this.renderSettings.labelSizeArbPx = Main.round((float)Main.constrain((float)(8.0f + t * 32.0f), (float)4.0f, (float)80.0f));
                break;
            }
            case 93: {
                RenderLayout l = this.buildRenderLayout();
                float t = this.sliderNorm(l.labelsZoneSizeSlider, mx);
                this.renderSettings.labelSizeZonePx = Main.round((float)Main.constrain((float)(8.0f + t * 32.0f), (float)4.0f, (float)80.0f));
                break;
            }
            case 94: {
                RenderLayout l = this.buildRenderLayout();
                float t = this.sliderNorm(l.labelsPathSizeSlider, mx);
                this.renderSettings.labelSizePathPx = Main.round((float)Main.constrain((float)(8.0f + t * 32.0f), (float)4.0f, (float)80.0f));
                break;
            }
            case 95: {
                RenderLayout l = this.buildRenderLayout();
                float t = this.sliderNorm(l.labelsStructSizeSlider, mx);
                this.renderSettings.labelSizeStructPx = Main.round((float)Main.constrain((float)(8.0f + t * 32.0f), (float)4.0f, (float)80.0f));
                break;
            }
            case 96: {
                int idx;
                int options;
                RenderLayout l = this.buildRenderLayout();
                int n = options = this.LABEL_FONT_OPTIONS != null ? this.LABEL_FONT_OPTIONS.length : 0;
                if (options < 1) break;
                float t = this.sliderNorm(l.labelsFontSelector, mx);
                this.renderSettings.labelFontIndex = idx = Main.constrain((int)Main.round((float)(t * (float)Main.max((int)1, (int)(options - 1)))), (int)0, (int)(options - 1));
                break;
            }
            case 71: {
                float t;
                RenderLayout l = this.buildRenderLayout();
                this.renderSettings.backgroundNoiseAlpha01 = t = this.sliderNorm(l.backgroundNoiseSlider, mx);
                break;
            }
            case 68: {
                float t;
                RenderLayout l = this.buildRenderLayout();
                this.renderSettings.structureShadowAlpha01 = t = this.sliderNorm(l.structuresShadowAlphaSlider, mx);
                break;
            }
            case 30: {
                RenderLayout l = this.buildRenderLayout();
                float t = this.sliderNorm(l.exportPaddingSlider, mx);
                t = Main.constrain((float)t, (float)0.0f, (float)1.0f);
                this.renderPaddingPct = this.renderSettings.exportPaddingPct = Main.constrain((float)(t * 0.1f), (float)0.0f, (float)0.1f);
                break;
            }
            case 64: {
                int idx;
                RenderLayout l = this.buildRenderLayout();
                if (this.renderPresets == null || this.renderPresets.length <= 0) break;
                int n = Main.max((int)1, (int)(this.renderPresets.length - 1));
                float t = this.sliderNorm(l.presetSelector, mx);
                this.renderSettings.activePresetIndex = idx = Main.constrain((int)Main.round((float)(t * (float)n)), (int)0, (int)(this.renderPresets.length - 1));
                break;
            }
        }
    }

    public boolean scrollListIfHovered(float wheelCount) {
        int contentH;
        int total;
        int rowGap;
        int rowH;
        int viewH;
        int startY;
        Object l;
        int deltaPx = Main.round((float)(wheelCount * 24.0f));
        if (deltaPx == 0) {
            return false;
        }
        if (this.currentTool == Tool.EDIT_ZONES && this.isInZonesListPanel(this.mouseX, this.mouseY)) {
            l = this.buildZonesListLayout();
            startY = ((ZonesListLayout)l).newBtn.y + ((ZonesListLayout)l).newBtn.h + 12;
            viewH = Main.max((int)0, (int)(((ZonesListLayout)l).panel.y + ((ZonesListLayout)l).panel.h - 12 - startY));
            rowH = 28;
            rowGap = 6;
            total = this.mapModel != null && this.mapModel.zones != null ? this.mapModel.zones.size() : 0;
            int n = contentH = total > 0 ? total * (rowH + rowGap) - rowGap : 0;
            if (contentH > viewH && viewH > 0) {
                this.zonesListScroll = this.clampScroll(this.zonesListScroll + (float)deltaPx, contentH, viewH);
                return true;
            }
        }
        if (this.currentTool == Tool.EDIT_PATHS && this.isInPathsListPanel(this.mouseX, this.mouseY)) {
            int contentH2;
            l = this.buildPathsListLayout();
            startY = ((PathsListLayout)l).newBtn.y + ((PathsListLayout)l).newBtn.h + 12;
            viewH = Main.max((int)0, (int)(((PathsListLayout)l).panel.y + ((PathsListLayout)l).panel.h - 12 - startY));
            int textH = Main.ceil((float)(this.textAscent() + this.textDescent()));
            int nameH = Main.max((int)20, (int)(textH + 8));
            int typeH = Main.max((int)16, (int)(textH + 6));
            int statsH = Main.max((int)14, (int)textH);
            int rowGap2 = 10;
            int rowTotal = nameH + 6 + typeH + 4 + statsH + rowGap2;
            int total2 = this.mapModel != null && this.mapModel.paths != null ? this.mapModel.paths.size() : 0;
            int n = contentH2 = total2 > 0 ? total2 * rowTotal : 0;
            if (contentH2 > viewH && viewH > 0) {
                this.pathsListScroll = this.clampScroll(this.pathsListScroll + (float)deltaPx, contentH2, viewH);
                return true;
            }
        }
        if (this.currentTool == Tool.EDIT_STRUCTURES && this.isInStructuresListPanel(this.mouseX, this.mouseY)) {
            l = this.buildStructuresListLayout();
            startY = this.layoutStructureDetails((StructuresListLayout)l);
            viewH = Main.max((int)0, (int)(((StructuresListLayout)l).panel.y + ((StructuresListLayout)l).panel.h - 12 - startY));
            rowH = 24;
            rowGap = 6;
            total = this.mapModel != null && this.mapModel.structures != null ? this.mapModel.structures.size() : 0;
            int n = contentH = total > 0 ? total * (rowH + rowGap) - rowGap : 0;
            if (contentH > viewH && viewH > 0) {
                this.structuresListScroll = this.clampScroll(this.structuresListScroll + (float)deltaPx, contentH, viewH);
                return true;
            }
        }
        if (this.currentTool == Tool.EDIT_LABELS && this.isInLabelsListPanel(this.mouseX, this.mouseY)) {
            l = this.buildLabelsListLayout();
            startY = ((LabelsListLayout)l).deselectBtn.y + ((LabelsListLayout)l).deselectBtn.h + 12 + 6;
            viewH = Main.max((int)0, (int)(((LabelsListLayout)l).panel.y + ((LabelsListLayout)l).panel.h - 12 - startY));
            rowH = 24;
            rowGap = 6;
            total = this.mapModel != null && this.mapModel.labels != null ? this.mapModel.labels.size() : 0;
            int n = contentH = total > 0 ? total * (rowH + rowGap) - rowGap : 0;
            if (contentH > viewH && viewH > 0) {
                this.labelsListScroll = this.clampScroll(this.labelsListScroll + (float)deltaPx, contentH, viewH);
                return true;
            }
        }
        return false;
    }

    public void mouseWheel(MouseEvent event) {
        float count = event.getCount();
        if (this.scrollListIfHovered(count)) {
            return;
        }
        float factor = Main.pow((float)1.1f, (float)(-count));
        this.viewport.zoomAt(factor, this.mouseX, this.mouseY);
    }

    public void keyPressed() {
        if (this.editingBiomeNameIndex >= 0) {
            if (this.key == '\n' || this.key == '\r') {
                if (this.editingBiomeNameIndex < this.mapModel.biomeTypes.size()) {
                    this.mapModel.biomeTypes.get((int)this.editingBiomeNameIndex).name = this.biomeNameDraft;
                }
                this.editingBiomeNameIndex = -1;
                return;
            }
            if (this.key == '\b' || this.key == '\u007f') {
                if (this.biomeNameDraft.length() > 0) {
                    this.biomeNameDraft = this.biomeNameDraft.substring(0, this.biomeNameDraft.length() - 1);
                }
                return;
            }
            if (this.key >= ' ') {
                this.biomeNameDraft = String.valueOf(this.biomeNameDraft) + this.key;
                return;
            }
        }
        if (this.editingZoneNameIndex >= 0) {
            if (this.key == '\n' || this.key == '\r') {
                if (this.editingZoneNameIndex < this.mapModel.zones.size()) {
                    this.mapModel.zones.get((int)this.editingZoneNameIndex).name = this.zoneNameDraft;
                }
                this.editingZoneNameIndex = -1;
                return;
            }
            if (this.key == '\b' || this.key == '\u007f') {
                if (this.zoneNameDraft.length() > 0) {
                    this.zoneNameDraft = this.zoneNameDraft.substring(0, this.zoneNameDraft.length() - 1);
                }
                return;
            }
            if (this.key >= ' ') {
                this.zoneNameDraft = String.valueOf(this.zoneNameDraft) + this.key;
                return;
            }
        }
        if (this.editingZoneComment) {
            if (this.key == '\n' || this.key == '\r') {
                if (this.activeZoneIndex >= 0 && this.activeZoneIndex < this.mapModel.zones.size()) {
                    this.mapModel.zones.get((int)this.activeZoneIndex).comment = this.zoneCommentDraft;
                }
                this.editingZoneComment = false;
                return;
            }
            if (this.key == '\b' || this.key == '\u007f') {
                if (this.zoneCommentDraft.length() > 0) {
                    this.zoneCommentDraft = this.zoneCommentDraft.substring(0, this.zoneCommentDraft.length() - 1);
                }
                if (this.activeZoneIndex >= 0 && this.activeZoneIndex < this.mapModel.zones.size()) {
                    this.mapModel.zones.get((int)this.activeZoneIndex).comment = this.zoneCommentDraft;
                }
                return;
            }
            if (this.key >= ' ') {
                this.zoneCommentDraft = String.valueOf(this.zoneCommentDraft) + this.key;
                if (this.activeZoneIndex >= 0 && this.activeZoneIndex < this.mapModel.zones.size()) {
                    this.mapModel.zones.get((int)this.activeZoneIndex).comment = this.zoneCommentDraft;
                }
                return;
            }
        }
        if (this.editingLabelIndex >= 0) {
            if (this.key == '\n' || this.key == '\r') {
                if (this.editingLabelIndex < this.mapModel.labels.size()) {
                    this.mapModel.labels.get((int)this.editingLabelIndex).text = this.labelDraft;
                }
                this.editingLabelIndex = -1;
                return;
            }
            if (this.key == '\b' || this.key == '\u007f') {
                if (this.labelDraft.length() > 0) {
                    this.labelDraft = this.labelDraft.substring(0, this.labelDraft.length() - 1);
                }
                if (this.editingLabelIndex < this.mapModel.labels.size()) {
                    this.mapModel.labels.get((int)this.editingLabelIndex).text = this.labelDraft;
                }
                return;
            }
            if (this.key >= ' ') {
                this.labelDraft = String.valueOf(this.labelDraft) + this.key;
                if (this.editingLabelIndex < this.mapModel.labels.size()) {
                    this.mapModel.labels.get((int)this.editingLabelIndex).text = this.labelDraft;
                }
                return;
            }
        }
        if (this.editingLabelCommentIndex >= 0) {
            if (this.key == '\n' || this.key == '\r') {
                if (this.editingLabelCommentIndex < this.mapModel.labels.size()) {
                    this.mapModel.labels.get((int)this.editingLabelCommentIndex).comment = this.labelCommentDraft;
                }
                this.editingLabelCommentIndex = -1;
                return;
            }
            if (this.key == '\b' || this.key == '\u007f') {
                if (this.labelCommentDraft.length() > 0) {
                    this.labelCommentDraft = this.labelCommentDraft.substring(0, this.labelCommentDraft.length() - 1);
                }
                if (this.editingLabelCommentIndex < this.mapModel.labels.size() && this.editingLabelCommentIndex >= 0) {
                    this.mapModel.labels.get((int)this.editingLabelCommentIndex).comment = this.labelCommentDraft;
                }
                return;
            }
            if (this.key >= ' ') {
                this.labelCommentDraft = String.valueOf(this.labelCommentDraft) + this.key;
                if (this.editingLabelCommentIndex < this.mapModel.labels.size() && this.editingLabelCommentIndex >= 0) {
                    this.mapModel.labels.get((int)this.editingLabelCommentIndex).comment = this.labelCommentDraft;
                }
                return;
            }
        }
        if (this.editingStructureName) {
            if (this.key == '\n' || this.key == '\r') {
                if (this.selectedStructureIndices != null && !this.selectedStructureIndices.isEmpty()) {
                    for (int idx : this.selectedStructureIndices) {
                        if (idx < 0 || idx >= this.mapModel.structures.size()) continue;
                        this.mapModel.structures.get((int)idx).name = this.structureNameDraft;
                    }
                }
                this.editingStructureName = false;
                this.editingStructureNameIndex = -1;
                return;
            }
            if (this.key == '\b' || this.key == '\u007f') {
                if (this.structureNameDraft.length() > 0) {
                    this.structureNameDraft = this.structureNameDraft.substring(0, this.structureNameDraft.length() - 1);
                }
                if (this.selectedStructureIndices != null && !this.selectedStructureIndices.isEmpty()) {
                    for (int idx : this.selectedStructureIndices) {
                        if (idx < 0 || idx >= this.mapModel.structures.size()) continue;
                        this.mapModel.structures.get((int)idx).name = this.structureNameDraft;
                    }
                }
                return;
            }
            if (this.key >= ' ') {
                this.structureNameDraft = String.valueOf(this.structureNameDraft) + this.key;
                if (this.selectedStructureIndices != null && !this.selectedStructureIndices.isEmpty()) {
                    for (int idx : this.selectedStructureIndices) {
                        if (idx < 0 || idx >= this.mapModel.structures.size()) continue;
                        this.mapModel.structures.get((int)idx).name = this.structureNameDraft;
                    }
                }
                return;
            }
        }
        if (this.editingStructureComment) {
            if (this.key == '\n' || this.key == '\r') {
                if (this.selectedStructureIndices != null && !this.selectedStructureIndices.isEmpty()) {
                    for (int idx : this.selectedStructureIndices) {
                        if (idx < 0 || idx >= this.mapModel.structures.size()) continue;
                        this.mapModel.structures.get((int)idx).comment = this.structureCommentDraft;
                    }
                }
                this.editingStructureComment = false;
                return;
            }
            if (this.key == '\b' || this.key == '\u007f') {
                if (this.structureCommentDraft.length() > 0) {
                    this.structureCommentDraft = this.structureCommentDraft.substring(0, this.structureCommentDraft.length() - 1);
                }
                if (this.selectedStructureIndices != null && !this.selectedStructureIndices.isEmpty()) {
                    for (int idx : this.selectedStructureIndices) {
                        if (idx < 0 || idx >= this.mapModel.structures.size()) continue;
                        this.mapModel.structures.get((int)idx).comment = this.structureCommentDraft;
                    }
                }
                return;
            }
            if (this.key >= ' ') {
                this.structureCommentDraft = String.valueOf(this.structureCommentDraft) + this.key;
                if (this.selectedStructureIndices != null && !this.selectedStructureIndices.isEmpty()) {
                    for (int idx : this.selectedStructureIndices) {
                        if (idx < 0 || idx >= this.mapModel.structures.size()) continue;
                        this.mapModel.structures.get((int)idx).comment = this.structureCommentDraft;
                    }
                }
                return;
            }
        }
        if (this.mouseButton == 37 && this.currentTool == Tool.EDIT_STRUCTURES && this.isInStructuresPanel(this.mouseX, this.mouseY)) {
            StructuresLayout layout = this.buildStructuresLayout();
            if (layout.sizeSlider.contains(this.mouseX, this.mouseY)) {
                float t = this.sliderNorm(layout.sizeSlider, this.mouseX);
                this.structureSize = Main.constrain((float)(0.01f + t * 0.19f), (float)0.01f, (float)0.2f);
                return;
            }
        }
        if (this.editingPathTypeNameIndex >= 0) {
            if (this.key == '\n' || this.key == '\r') {
                if (this.editingPathTypeNameIndex < this.mapModel.pathTypes.size()) {
                    this.mapModel.pathTypes.get((int)this.editingPathTypeNameIndex).name = this.pathTypeNameDraft;
                }
                this.editingPathTypeNameIndex = -1;
                return;
            }
            if (this.key == '\b' || this.key == '\u007f') {
                if (this.pathTypeNameDraft.length() > 0) {
                    this.pathTypeNameDraft = this.pathTypeNameDraft.substring(0, this.pathTypeNameDraft.length() - 1);
                }
                return;
            }
            if (this.key >= ' ') {
                this.pathTypeNameDraft = String.valueOf(this.pathTypeNameDraft) + this.key;
                return;
            }
        }
        if (this.editingPathNameIndex >= 0) {
            if (this.key == '\n' || this.key == '\r') {
                if (this.editingPathNameIndex < this.mapModel.paths.size()) {
                    this.mapModel.paths.get((int)this.editingPathNameIndex).name = this.pathNameDraft;
                }
                this.editingPathNameIndex = -1;
                return;
            }
            if (this.key == '\b' || this.key == '\u007f') {
                if (this.pathNameDraft.length() > 0) {
                    this.pathNameDraft = this.pathNameDraft.substring(0, this.pathNameDraft.length() - 1);
                }
                return;
            }
            if (this.key >= ' ') {
                this.pathNameDraft = String.valueOf(this.pathNameDraft) + this.key;
                return;
            }
        }
        if (this.editingPathCommentIndex >= 0) {
            if (this.key == '\n' || this.key == '\r') {
                if (this.editingPathCommentIndex < this.mapModel.paths.size()) {
                    this.mapModel.paths.get((int)this.editingPathCommentIndex).comment = this.pathCommentDraft;
                }
                this.editingPathCommentIndex = -1;
                return;
            }
            if (this.key == '\b' || this.key == '\u007f') {
                if (this.pathCommentDraft.length() > 0) {
                    this.pathCommentDraft = this.pathCommentDraft.substring(0, this.pathCommentDraft.length() - 1);
                }
                if (this.editingPathCommentIndex < this.mapModel.paths.size() && this.editingPathCommentIndex >= 0) {
                    this.mapModel.paths.get((int)this.editingPathCommentIndex).comment = this.pathCommentDraft;
                }
                return;
            }
            if (this.key >= ' ') {
                this.pathCommentDraft = String.valueOf(this.pathCommentDraft) + this.key;
                if (this.editingPathCommentIndex < this.mapModel.paths.size() && this.editingPathCommentIndex >= 0) {
                    this.mapModel.paths.get((int)this.editingPathCommentIndex).comment = this.pathCommentDraft;
                }
                return;
            }
        }
        if (this.key == '\u007f' || this.key == '\b') {
            if (this.currentTool == Tool.EDIT_SITES) {
                this.mapModel.deleteSelectedSites();
                return;
            }
            if (this.currentTool == Tool.EDIT_PATHS && this.pendingPathStart != null) {
                this.pendingPathStart = null;
                return;
            }
        }
        if (this.currentTool == Tool.EDIT_PATHS && (this.key == 'c' || this.key == 'C')) {
            this.mapModel.clearAllPaths();
            this.selectedPathIndex = -1;
            this.pendingPathStart = null;
            return;
        }
    }

    public boolean isInSitesPanel(int mx, int my) {
        if (this.currentTool != Tool.EDIT_SITES) {
            return false;
        }
        SitesLayout layout = this.buildSitesLayout();
        return layout.panel.contains(mx, my);
    }

    public boolean isInBiomesPanel(int mx, int my) {
        if (this.currentTool != Tool.EDIT_BIOMES) {
            return false;
        }
        BiomesLayout layout = this.buildBiomesLayout();
        return layout.panel.contains(mx, my);
    }

    public boolean isInZonesPanel(int mx, int my) {
        if (this.currentTool != Tool.EDIT_ZONES) {
            return false;
        }
        ZonesLayout layout = this.buildZonesLayout();
        return layout.panel.contains(mx, my);
    }

    public boolean isInZonesListPanel(int mx, int my) {
        if (this.currentTool != Tool.EDIT_ZONES) {
            return false;
        }
        ZonesListLayout layout = this.buildZonesListLayout();
        return layout.panel.contains(mx, my);
    }

    public boolean isInElevationPanel(int mx, int my) {
        if (this.currentTool != Tool.EDIT_ELEVATION) {
            return false;
        }
        ElevationLayout layout = this.buildElevationLayout();
        return layout.panel.contains(mx, my);
    }

    public boolean isInPathsPanel(int mx, int my) {
        if (this.currentTool != Tool.EDIT_PATHS) {
            return false;
        }
        PathsLayout layout = this.buildPathsLayout();
        return layout.panel.contains(mx, my);
    }

    public boolean isInPathsListPanel(int mx, int my) {
        if (this.currentTool != Tool.EDIT_PATHS) {
            return false;
        }
        PathsListLayout layout = this.buildPathsListLayout();
        return layout.panel.contains(mx, my);
    }

    public boolean isInStructuresPanel(int mx, int my) {
        if (this.currentTool != Tool.EDIT_STRUCTURES) {
            return false;
        }
        StructuresLayout layout = this.buildStructuresLayout();
        return layout.panel.contains(mx, my);
    }

    public boolean isInStructuresListPanel(int mx, int my) {
        if (this.currentTool != Tool.EDIT_STRUCTURES) {
            return false;
        }
        StructuresListLayout layout = this.buildStructuresListLayout();
        return layout.panel.contains(mx, my);
    }

    public boolean isInLabelsPanel(int mx, int my) {
        if (this.currentTool != Tool.EDIT_LABELS) {
            return false;
        }
        LabelsLayout layout = this.buildLabelsLayout();
        return layout.panel.contains(mx, my);
    }

    public boolean isInLabelsListPanel(int mx, int my) {
        if (this.currentTool != Tool.EDIT_LABELS) {
            return false;
        }
        LabelsListLayout layout = this.buildLabelsListLayout();
        return layout.panel.contains(mx, my);
    }

    public boolean isInRenderPanel(int mx, int my) {
        if (this.currentTool != Tool.EDIT_RENDER) {
            return false;
        }
        RenderLayout layout = this.buildRenderLayout();
        return layout.panel.contains(mx, my);
    }

    public boolean isInExportPanel(int mx, int my) {
        if (this.currentTool != Tool.EDIT_EXPORT) {
            return false;
        }
        ExportLayout layout = this.buildExportLayout();
        return layout.panel.contains(mx, my);
    }

    public boolean isInActivePanel(int mx, int my) {
        IntRect panel = this.getActivePanelRect();
        return panel != null && panel.contains(mx, my);
    }

    public boolean handleToolButtonClick(int my) {
        int barY = 34;
        int barH = 26;
        if (this.mapModel.isVoronoiBuilding()) {
            this.showNotice("Please wait for generation to finish...");
            return true;
        }
        if (my < barY || my > barY + barH) {
            return false;
        }
        int margin = 10;
        int buttonW = 90;
        String[] labels = new String[]{"Cells", "Elevation", "Biomes", "Zones", "Paths", "Structures", "Labels", "Rendering", "Export"};
        final Tool[] tools = new Tool[]{Tool.EDIT_SITES, Tool.EDIT_ELEVATION, Tool.EDIT_BIOMES, Tool.EDIT_ZONES, Tool.EDIT_PATHS, Tool.EDIT_STRUCTURES, Tool.EDIT_LABELS, Tool.EDIT_RENDER, Tool.EDIT_EXPORT};
        int i = 0;
        while (i < labels.length) {
            int x = margin + i * (buttonW + 5);
            int y = barY + 2;
            IntRect rect = new IntRect(x, y, buttonW, barH - 4);
            final int idx = i;
            if (this.queueButtonAction(rect, new Runnable(){

                @Override
                public void run() {
                    Main.this.selectedPathIndex = -1;
                    Main.this.pendingPathStart = null;
                    Main.this.clearStructureSelection();
                    Main.this.currentTool = tools[idx];
                }
            })) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public boolean handleSitesPanelClick(int mx, int my) {
        if (!this.isInSitesPanel(mx, my)) {
            return false;
        }
        SitesLayout layout = this.buildSitesLayout();
        if (layout.densitySlider.contains(mx, my)) {
            float t = (float)(mx - layout.densitySlider.x) / (float)layout.densitySlider.w;
            int newCount = Main.round((float)(t * 50000.0f));
            this.siteTargetCount = Main.constrain((int)newCount, (int)0, (int)50000);
            this.activeSlider = 1;
            return true;
        }
        if (layout.fuzzSlider.contains(mx, my)) {
            float t = (float)(mx - layout.fuzzSlider.x) / (float)layout.fuzzSlider.w;
            t = Main.constrain((float)t, (float)0.0f, (float)1.0f);
            this.siteFuzz = t * 0.3f;
            this.activeSlider = 2;
            return true;
        }
        if (layout.modeSlider.contains(mx, my)) {
            int modeCount = this.placementModes.length;
            if (modeCount < 1) {
                modeCount = 1;
            }
            float t = (float)(mx - layout.modeSlider.x) / (float)layout.modeSlider.w;
            t = Main.constrain((float)t, (float)0.0f, (float)1.0f);
            int idx = Main.round((float)(t * (float)(modeCount - 1)));
            this.placementModeIndex = Main.constrain((int)idx, (int)0, (int)(this.placementModes.length - 1));
            this.activeSlider = 3;
            return true;
        }
        if (this.queueButtonAction(layout.resetBtn, new Runnable(){

            @Override
            public void run() {
                Main.this.resetAllMapData();
            }
        })) {
            return true;
        }
        if (this.queueButtonAction(layout.generateBtn, new Runnable(){

            @Override
            public void run() {
                Main.this.mapModel.generateSites(Main.this.currentPlacementMode(), Main.this.siteTargetCount, Main.this.keepPropertiesOnGenerate);
            }
        })) {
            return true;
        }
        if (this.queueButtonAction(layout.fullGenerateBtn, new Runnable(){

            @Override
            public void run() {
                Main.this.startFullGenerateFromCells();
            }
        })) {
            return true;
        }
        if (layout.keepCheckbox.contains(mx, my)) {
            this.keepPropertiesOnGenerate = !this.keepPropertiesOnGenerate;
            return true;
        }
        return false;
    }

    public boolean handleBiomesPanelClick(int mx, int my) {
        boolean canRemove;
        if (!this.isInBiomesPanel(mx, my)) {
            return false;
        }
        if (this.mapModel == null || this.mapModel.biomeTypes == null) {
            return false;
        }
        BiomesLayout layout = this.buildBiomesLayout();
        if (this.queueButtonAction(layout.paintBtn, new Runnable(){

            @Override
            public void run() {
                Main.this.currentBiomePaintMode = ZonePaintMode.ZONE_PAINT;
            }
        })) {
            return true;
        }
        if (this.queueButtonAction(layout.fillBtn, new Runnable(){

            @Override
            public void run() {
                Main.this.currentBiomePaintMode = ZonePaintMode.ZONE_FILL;
            }
        })) {
            return true;
        }
        if (layout.genModeSelector.contains(mx, my)) {
            int idx;
            int modeCount = this.biomeGenerateModes.length;
            int maxIdx = Main.max((int)1, (int)(modeCount - 1));
            float t = this.sliderNorm(layout.genModeSelector, mx);
            this.biomeGenerateModeIndex = idx = Main.constrain((int)Main.round((float)(t * (float)maxIdx)), (int)0, (int)(modeCount - 1));
            this.activeSlider = 65;
            return true;
        }
        if (this.queueButtonAction(layout.genApplyBtn, new Runnable(){

            @Override
            public void run() {
                Main.this.applyBiomeGeneration();
            }
        })) {
            return true;
        }
        if (this.queueButtonAction(layout.genValueWaterBtn, new Runnable(){

            @Override
            public void run() {
                float clampedSea = Main.constrain((float)Main.this.seaLevel, (float)-1.0f, (float)1.0f);
                Main.this.biomeGenerateValue01 = Main.map((float)clampedSea, (float)-1.0f, (float)1.0f, (float)0.0f, (float)1.0f);
                Main.this.activeSlider = 66;
            }
        })) {
            return true;
        }
        int nTypes = this.mapModel.biomeTypes.size();
        if (this.queueButtonAction(layout.addBtn, new Runnable(){

            @Override
            public void run() {
                Main.this.mapModel.addBiomeType();
                Main.this.activeBiomeIndex = Main.this.mapModel.biomeTypes.size() - 1;
            }
        })) {
            return true;
        }
        boolean bl = canRemove = nTypes > 1 && this.activeBiomeIndex > 0;
        if (canRemove && this.queueButtonAction(layout.removeBtn, new Runnable(){

            @Override
            public void run() {
                int removeIndex = Main.this.activeBiomeIndex;
                Main.this.mapModel.removeBiomeType(removeIndex);
                int newCount = Main.this.mapModel.biomeTypes.size();
                if (newCount == 0) {
                    Main.this.activeBiomeIndex = 0;
                } else {
                    Main.this.activeBiomeIndex = Main.min((int)(removeIndex - 1), (int)(newCount - 1));
                    if (Main.this.activeBiomeIndex < 0) {
                        Main.this.activeBiomeIndex = 0;
                    }
                }
            }
        })) {
            return true;
        }
        int n = this.mapModel.biomeTypes.size();
        if (n == 0) {
            return false;
        }
        int i = 0;
        while (i < n) {
            IntRect sw = layout.swatches.get(i);
            if (sw.contains(mx, my)) {
                this.activeBiomeIndex = i;
                return true;
            }
            ++i;
        }
        if (layout.nameField.contains(mx, my) && this.activeBiomeIndex >= 0 && this.activeBiomeIndex < n) {
            this.editingBiomeNameIndex = this.activeBiomeIndex;
            this.biomeNameDraft = this.mapModel.biomeTypes.get((int)this.activeBiomeIndex).name;
            return true;
        }
        if (this.activeBiomeIndex >= 0 && this.activeBiomeIndex < n && layout.hueSlider.contains(mx, my)) {
            float t = (float)(mx - layout.hueSlider.x) / (float)layout.hueSlider.w;
            t = Main.constrain((float)t, (float)0.0f, (float)1.0f);
            ZoneType active = this.mapModel.biomeTypes.get(this.activeBiomeIndex);
            active.hue01 = t;
            active.updateColorFromHSB();
            this.activeSlider = 4;
            return true;
        }
        if (this.activeBiomeIndex >= 0 && this.activeBiomeIndex < n && layout.patternSlider.contains(mx, my)) {
            int patCount = Main.max((int)1, (int)this.mapModel.biomePatternCount);
            float t = this.sliderNorm(layout.patternSlider, mx);
            int idx = patCount > 1 ? Main.round((float)(t * (float)(patCount - 1))) : 0;
            idx = Main.constrain((int)idx, (int)0, (int)(patCount - 1));
            ZoneType active = this.mapModel.biomeTypes.get(this.activeBiomeIndex);
            active.patternIndex = idx;
            this.activeSlider = 97;
            return true;
        }
        if (layout.brushSlider.contains(mx, my)) {
            float t = this.sliderNorm(layout.brushSlider, mx);
            this.zoneBrushRadius = Main.constrain((float)(0.01f + t * 0.14f), (float)0.01f, (float)0.15f);
            this.activeSlider = 5;
            return true;
        }
        if (layout.genValueSlider.contains(mx, my)) {
            float t;
            this.biomeGenerateValue01 = t = this.sliderNorm(layout.genValueSlider, mx);
            this.activeSlider = 66;
            return true;
        }
        return false;
    }

    public boolean handleZonesPanelClick(int mx, int my) {
        if (!this.isInZonesPanel(mx, my)) {
            return false;
        }
        if (this.mapModel == null || this.mapModel.zones == null) {
            return false;
        }
        ZonesLayout layout = this.buildZonesLayout();
        if (layout.brushSlider.contains(mx, my)) {
            float t = this.sliderNorm(layout.brushSlider, mx);
            this.zoneBrushRadius = Main.constrain((float)(0.01f + t * 0.14f), (float)0.01f, (float)0.15f);
            this.activeSlider = 19;
            return true;
        }
        if (this.queueButtonAction(layout.excludeWaterBtn, new Runnable(){

            @Override
            public void run() {
                if (Main.this.activeZoneIndex >= 0) {
                    Main.this.mapModel.removeUnderwaterCellsFromZone(Main.this.activeZoneIndex, Main.this.seaLevel);
                } else {
                    Main.this.mapModel.removeUnderwaterCellsFromZone(-1, Main.this.seaLevel);
                }
            }
        })) {
            return true;
        }
        if (this.queueButtonAction(layout.exclusiveBtn, new Runnable(){

            @Override
            public void run() {
                Main.this.mapModel.enforceZoneExclusivity(Main.this.activeZoneIndex);
            }
        })) {
            return true;
        }
        if (this.queueButtonAction(layout.fourColorBtn, new Runnable(){

            @Override
            public void run() {
                Main.this.mapModel.recolorZonesWithFourColors();
            }
        })) {
            return true;
        }
        if (this.queueButtonAction(layout.resetBtn, new Runnable(){

            @Override
            public void run() {
                Main.this.mapModel.resetAllZonesToNone();
                Main.this.activeZoneIndex = -1;
                Main.this.editingZoneNameIndex = -1;
                Main.this.editingZoneComment = false;
            }
        })) {
            return true;
        }
        if (this.queueButtonAction(layout.regenerateBtn, new Runnable(){

            @Override
            public void run() {
                int target = Main.this.mapModel.zones.isEmpty() ? 5 : Main.this.mapModel.zones.size();
                Main.this.mapModel.regenerateRandomZones(target);
                Main.this.activeZoneIndex = -1;
                Main.this.editingZoneNameIndex = -1;
                Main.this.editingZoneComment = false;
            }
        })) {
            return true;
        }
        if (layout.commentField.contains(mx, my)) {
            if (this.activeZoneIndex >= 0 && this.activeZoneIndex < this.mapModel.zones.size()) {
                MapModel.MapZone z = this.mapModel.zones.get(this.activeZoneIndex);
                this.zoneCommentDraft = z != null && z.comment != null ? z.comment : "";
                this.editingZoneComment = true;
            } else {
                this.zoneCommentDraft = "";
                this.editingZoneComment = false;
            }
            return true;
        }
        this.editingZoneComment = false;
        return false;
    }

    public boolean handleZonesListPanelClick(int mx, int my) {
        if (!this.isInZonesListPanel(mx, my)) {
            return false;
        }
        ZonesListLayout layout = this.buildZonesListLayout();
        this.populateZonesRows(layout);
        if (this.queueButtonAction(layout.deselectBtn, new Runnable(){

            @Override
            public void run() {
                Main.this.activeZoneIndex = -1;
                Main.this.editingZoneNameIndex = -1;
                Main.this.editingZoneComment = false;
            }
        })) {
            return true;
        }
        if (this.queueButtonAction(layout.newBtn, new Runnable(){

            @Override
            public void run() {
                Main.this.mapModel.addZone();
                Main.this.activeZoneIndex = Main.this.mapModel.zones.size() - 1;
            }
        })) {
            return true;
        }
        int i = 0;
        while (i < layout.rows.size()) {
            final ZoneRowLayout row = layout.rows.get(i);
            if (row.index >= 0 && row.index < this.mapModel.zones.size()) {
                final MapModel.MapZone az = this.mapModel.zones.get(row.index);
                if (this.queueButtonAction(row.selectRect, new Runnable(){

                    @Override
                    public void run() {
                        Main.this.activeZoneIndex = row.index;
                        Main.this.editingZoneNameIndex = -1;
                        Main.this.editingZoneComment = false;
                    }
                })) {
                    return true;
                }
                if (this.queueButtonAction(row.nameRect, new Runnable(){

                    @Override
                    public void run() {
                        Main.this.activeZoneIndex = row.index;
                        Main.this.editingZoneNameIndex = row.index;
                        Main.this.zoneNameDraft = az.name;
                        Main.this.editingZoneComment = false;
                    }
                })) {
                    return true;
                }
                if (row.hueSlider.contains(mx, my)) {
                    float t;
                    this.activeZoneIndex = row.index;
                    az.hue01 = t = this.sliderNorm(row.hueSlider, mx);
                    az.updateColorFromHSB();
                    this.activeSlider = 23;
                    return true;
                }
            }
            ++i;
        }
        return false;
    }

    public void paintBiomeAt(float wx, float wy) {
        Cell c = this.mapModel.findCellContaining(wx, wy);
        if (c != null) {
            c.biomeId = this.activeBiomeIndex;
        }
    }

    public void fillBiomeAt(float wx, float wy) {
        Cell c = this.mapModel.findCellContaining(wx, wy);
        if (c != null) {
            this.mapModel.floodFillBiomeFromCell(c, this.activeBiomeIndex);
            this.mapModel.renderer.invalidateBiomeOutlineCache();
        }
    }

    public void paintBiomeBrush(float wx, float wy) {
        if (this.mapModel.cells == null) {
            return;
        }
        float r2 = this.zoneBrushRadius * this.zoneBrushRadius;
        for (Cell c : this.mapModel.cells) {
            PVector cen = this.mapModel.cellCentroid(c);
            float dx = cen.x - wx;
            float dy = cen.y - wy;
            float d2 = dx * dx + dy * dy;
            if (!(d2 <= r2)) continue;
            c.biomeId = this.activeBiomeIndex;
        }
        this.mapModel.renderer.invalidateBiomeOutlineCache();
    }

    public void paintZoneAt(float wx, float wy) {
        if (this.mapModel.zones == null || this.activeZoneIndex < 0 || this.activeZoneIndex >= this.mapModel.zones.size()) {
            return;
        }
        Cell c = this.mapModel.findCellContaining(wx, wy);
        if (c != null) {
            int idx = this.mapModel.indexOfCell(c);
            this.mapModel.addCellToZone(idx, this.activeZoneIndex);
        }
    }

    public void fillZoneAt(float wx, float wy) {
        if (this.mapModel.zones == null) {
            return;
        }
        Cell c = this.mapModel.findCellContaining(wx, wy);
        if (c == null) {
            return;
        }
        if (this.activeZoneIndex < 0 || this.activeZoneIndex >= this.mapModel.zones.size()) {
            this.mapModel.removeCellFromAllZones(this.mapModel.indexOfCell(c));
        } else {
            this.mapModel.floodFillZone(c, this.activeZoneIndex);
        }
    }

    public void paintZoneBrush(float wx, float wy) {
        if (this.mapModel.zones == null || this.mapModel.cells == null) {
            return;
        }
        boolean erasing = this.activeZoneIndex < 0 || this.activeZoneIndex >= this.mapModel.zones.size();
        float r2 = this.zoneBrushRadius * this.zoneBrushRadius;
        int ci = 0;
        while (ci < this.mapModel.cells.size()) {
            Cell c = this.mapModel.cells.get(ci);
            PVector cen = this.mapModel.cellCentroid(c);
            float dx = cen.x - wx;
            float dy = cen.y - wy;
            float d2 = dx * dx + dy * dy;
            if (d2 <= r2) {
                if (erasing) {
                    this.mapModel.removeCellFromAllZones(ci);
                } else {
                    this.mapModel.addCellToZone(ci, this.activeZoneIndex);
                }
            }
            ++ci;
        }
    }

    public boolean handleSnapSettingsClick(int mx, int my) {
        SnapSettingsLayout layout = this.buildSnapSettingsLayout();
        if (!layout.panel.contains(mx, my)) {
            return false;
        }
        int i = 0;
        while (i < layout.checks.size()) {
            IntRect b = layout.checks.get(i);
            if (b.contains(mx, my)) {
                switch (i) {
                    case 0: {
                        this.snapWaterEnabled = !this.snapWaterEnabled;
                        break;
                    }
                    case 1: {
                        this.snapBiomesEnabled = !this.snapBiomesEnabled;
                        break;
                    }
                    case 2: {
                        this.snapUnderwaterBiomesEnabled = !this.snapUnderwaterBiomesEnabled;
                        break;
                    }
                    case 3: {
                        this.snapZonesEnabled = !this.snapZonesEnabled;
                        break;
                    }
                    case 4: {
                        this.snapPathsEnabled = !this.snapPathsEnabled;
                        break;
                    }
                    case 5: {
                        this.snapStructuresEnabled = !this.snapStructuresEnabled;
                        break;
                    }
                    case 6: {
                        this.snapElevationEnabled = !this.snapElevationEnabled;
                    }
                }
                return true;
            }
            ++i;
        }
        if (layout.elevationSlider.contains(mx, my)) {
            int divMin = 2;
            int divMax = 24;
            float t = this.sliderNorm(layout.elevationSlider, mx);
            this.snapElevationDivisions = Main.round((float)Main.lerp((float)divMin, (float)divMax, (float)t));
            return true;
        }
        return false;
    }

    public void mousePressed() {
        if (this.mouseButton == 37) {
            this.pendingButtonAction = null;
            this.pressedButtonRect = null;
        }
        if ((this.mapModel.isVoronoiBuilding() || this.fullGenRunning) && this.mouseButton == 37) {
            this.showNotice("Generation in progress...");
            return;
        }
        if (this.mouseButton == 37 && this.handleToolButtonClick(this.mouseY)) {
            return;
        }
        if (this.mouseButton == 37 && this.currentTool == Tool.EDIT_SITES && this.handleSitesPanelClick(this.mouseX, this.mouseY)) {
            return;
        }
        if (this.mouseButton == 37 && this.currentTool == Tool.EDIT_BIOMES && this.handleBiomesPanelClick(this.mouseX, this.mouseY)) {
            return;
        }
        if (this.mouseButton == 37 && this.currentTool == Tool.EDIT_ZONES) {
            if (this.handleZonesPanelClick(this.mouseX, this.mouseY)) {
                return;
            }
            if (this.handleZonesListPanelClick(this.mouseX, this.mouseY)) {
                return;
            }
            if (this.isInZonesListPanel(this.mouseX, this.mouseY)) {
                return;
            }
        }
        if (this.mouseButton == 37 && this.currentTool == Tool.EDIT_ELEVATION && this.handleElevationPanelClick(this.mouseX, this.mouseY)) {
            return;
        }
        if (this.mouseButton == 37 && this.currentTool == Tool.EDIT_PATHS) {
            if (this.handlePathsPanelClick(this.mouseX, this.mouseY)) {
                return;
            }
            if (this.handlePathsListPanelClick(this.mouseX, this.mouseY)) {
                return;
            }
            if (this.isInPathsListPanel(this.mouseX, this.mouseY)) {
                return;
            }
        }
        if (this.mouseButton == 37 && this.currentTool == Tool.EDIT_STRUCTURES) {
            if (this.handleStructuresPanelClick(this.mouseX, this.mouseY)) {
                return;
            }
            if (this.handleStructuresListPanelClick(this.mouseX, this.mouseY)) {
                return;
            }
            if (this.isInStructuresListPanel(this.mouseX, this.mouseY)) {
                return;
            }
        }
        if (this.mouseButton == 37 && this.currentTool == Tool.EDIT_LABELS) {
            if (this.handleLabelsPanelClick(this.mouseX, this.mouseY)) {
                return;
            }
            if (this.handleLabelsListPanelClick(this.mouseX, this.mouseY)) {
                return;
            }
            if (this.isInLabelsListPanel(this.mouseX, this.mouseY)) {
                return;
            }
        }
        if (this.mouseButton == 37 && this.currentTool == Tool.EDIT_RENDER && this.handleRenderPanelClick(this.mouseX, this.mouseY)) {
            return;
        }
        if (this.mouseButton == 37 && this.currentTool == Tool.EDIT_EXPORT && this.handleExportPanelClick(this.mouseX, this.mouseY)) {
            return;
        }
        if (this.mouseY < 60) {
            return;
        }
        if (this.isInActivePanel(this.mouseX, this.mouseY)) {
            return;
        }
        if (this.currentTool == Tool.EDIT_ZONES && this.isInZonesListPanel(this.mouseX, this.mouseY)) {
            return;
        }
        if (this.currentTool == Tool.EDIT_PATHS && this.isInPathsListPanel(this.mouseX, this.mouseY)) {
            return;
        }
        if (this.currentTool == Tool.EDIT_STRUCTURES && this.isInStructuresListPanel(this.mouseX, this.mouseY)) {
            return;
        }
        if (this.currentTool == Tool.EDIT_LABELS && this.isInLabelsListPanel(this.mouseX, this.mouseY)) {
            return;
        }
        if (this.mouseButton == 39) {
            this.isPanning = true;
            this.lastMouseX = this.mouseX;
            this.lastMouseY = this.mouseY;
            return;
        }
        if (this.mouseButton == 37) {
            PVector worldPos = this.viewport.screenToWorld(this.mouseX, this.mouseY);
            if (this.currentTool == Tool.EDIT_SITES) {
                this.handleSitesMousePressed(worldPos.x, worldPos.y);
            } else if (this.currentTool == Tool.EDIT_BIOMES) {
                if (this.currentBiomePaintMode == ZonePaintMode.ZONE_PAINT) {
                    this.paintBiomeBrush(worldPos.x, worldPos.y);
                } else {
                    this.fillBiomeAt(worldPos.x, worldPos.y);
                }
            } else if (this.currentTool == Tool.EDIT_ZONES) {
                if (this.currentZonePaintMode == ZonePaintMode.ZONE_PAINT) {
                    this.paintZoneBrush(worldPos.x, worldPos.y);
                } else {
                    this.fillZoneAt(worldPos.x, worldPos.y);
                }
            } else if (this.currentTool == Tool.EDIT_ELEVATION) {
                float dir = this.elevationBrushRaise ? 1 : -1;
                this.mapModel.applyElevationBrush(worldPos.x, worldPos.y, this.elevationBrushRadius, this.elevationBrushStrength * dir, this.seaLevel);
                this.markRenderDirty();
                this.markExportPreviewDirty();
            } else if (this.currentTool == Tool.EDIT_PATHS) {
                if (this.pathEraserMode) {
                    this.mapModel.erasePathSegments(worldPos.x, worldPos.y, this.pathEraserRadius);
                } else {
                    this.handlePathsMousePressed(worldPos.x, worldPos.y);
                }
            } else if (this.currentTool == Tool.EDIT_STRUCTURES) {
                if (this.selectedStructureIndices != null && !this.selectedStructureIndices.isEmpty()) {
                    float cx = 0.0f;
                    float cy = 0.0f;
                    int count = 0;
                    for (int idx : this.selectedStructureIndices) {
                        if (idx < 0 || idx >= this.mapModel.structures.size()) continue;
                        Structure s = this.mapModel.structures.get(idx);
                        cx += s.x;
                        cy += s.y;
                        ++count;
                    }
                    if (count > 0) {
                        float dx = worldPos.x - (cx /= (float)count);
                        float dy = worldPos.y - (cy /= (float)count);
                        for (int idx : this.selectedStructureIndices) {
                            if (idx < 0 || idx >= this.mapModel.structures.size()) continue;
                            Structure s = this.mapModel.structures.get(idx);
                            s.x += dx;
                            s.y += dy;
                            if (s.snapBinding == null) continue;
                            s.snapBinding.clear();
                        }
                    }
                } else {
                    Structure s = this.mapModel.computeSnappedStructure(worldPos.x, worldPos.y, this.structureSize);
                    this.mapModel.structures.add(s);
                    this.clearStructureSelection();
                    this.editingStructureName = false;
                    this.editingStructureNameIndex = -1;
                }
            } else if (this.currentTool == Tool.EDIT_LABELS) {
                MapLabel sel;
                String baseText = "label";
                if (this.selectedLabelIndex >= 0 && this.selectedLabelIndex < this.mapModel.labels.size() && (sel = this.mapModel.labels.get(this.selectedLabelIndex)) != null && sel.text != null && sel.text.length() > 0) {
                    baseText = sel.text;
                }
                MapLabel lbl = new MapLabel(worldPos.x, worldPos.y, baseText, this.labelTargetMode);
                lbl.size = this.labelSizeDefault();
                this.mapModel.labels.add(lbl);
                this.editingLabelIndex = this.selectedLabelIndex = this.mapModel.labels.size() - 1;
                this.labelDraft = lbl.text;
            }
        }
    }

    public void handleSitesMousePressed(float wx, float wy) {
        float maxDistWorld;
        Site s = this.mapModel.findSiteNear(wx = Main.constrain((float)wx, (float)this.mapModel.minX, (float)this.mapModel.maxX), wy = Main.constrain((float)wy, (float)this.mapModel.minY, (float)this.mapModel.maxY), maxDistWorld = 10.0f / this.viewport.zoom);
        if (s != null) {
            this.mapModel.clearSiteSelection();
            this.mapModel.selectSite(s);
            this.draggingSite = s;
            this.isDraggingSite = true;
        } else {
            Site ns = this.mapModel.addSite(wx, wy);
            this.mapModel.clearSiteSelection();
            this.mapModel.selectSite(ns);
            this.draggingSite = ns;
            this.isDraggingSite = true;
        }
    }

    public boolean handlePathsPanelClick(int mx, int my) {
        boolean canRemove;
        if (!this.isInPathsPanel(mx, my)) {
            return false;
        }
        PathsLayout layout = this.buildPathsLayout();
        if (layout.routeSlider.contains(mx, my)) {
            String[] modes = new String[]{"Ends", "Pathfind"};
            int modeCount = modes.length;
            float t = this.sliderNorm(layout.routeSlider, mx);
            int idx = Main.round((float)(t * (float)(modeCount - 1)));
            this.pathRouteModeIndex = Main.constrain((int)idx, (int)0, (int)(modeCount - 1));
            if (this.activePathTypeIndex >= 0 && this.activePathTypeIndex < this.mapModel.pathTypes.size()) {
                PathType pt = this.mapModel.pathTypes.get(this.activePathTypeIndex);
                pt.routeMode = PathRouteMode.values()[this.pathRouteModeIndex];
            }
            this.activeSlider = 98;
            return true;
        }
        if (layout.flattestSlider.contains(mx, my)) {
            float t = this.sliderNorm(layout.flattestSlider, mx);
            this.flattestSlopeBias = Main.constrain((float)(0.0f + t * 1000.0f), (float)0.0f, (float)1000.0f);
            if (this.activePathTypeIndex >= 0 && this.activePathTypeIndex < this.mapModel.pathTypes.size()) {
                PathType pt = this.mapModel.pathTypes.get(this.activePathTypeIndex);
                pt.slopeBias = this.flattestSlopeBias;
            }
            this.activeSlider = 14;
            return true;
        }
        if (layout.avoidWaterCheck.contains(mx, my)) {
            boolean bl = this.pathAvoidWater = !this.pathAvoidWater;
            if (this.activePathTypeIndex >= 0 && this.activePathTypeIndex < this.mapModel.pathTypes.size()) {
                PathType pt = this.mapModel.pathTypes.get(this.activePathTypeIndex);
                pt.avoidWater = this.pathAvoidWater;
            }
            return true;
        }
        if (this.queueButtonAction(layout.eraserBtn, new Runnable(){

            @Override
            public void run() {
                Main.this.pathEraserMode = !Main.this.pathEraserMode;
                Main.this.pendingPathStart = null;
            }
        })) {
            return true;
        }
        if (layout.commentField.contains(mx, my)) {
            if (this.selectedPathIndex >= 0 && this.selectedPathIndex < this.mapModel.paths.size()) {
                Path p = this.mapModel.paths.get(this.selectedPathIndex);
                this.pathCommentDraft = p != null && p.comment != null ? p.comment : "";
                this.editingPathCommentIndex = this.selectedPathIndex;
            } else {
                this.pathCommentDraft = "";
                this.editingPathCommentIndex = -1;
            }
            return true;
        }
        this.editingPathCommentIndex = -1;
        if (this.queueButtonAction(layout.generateBtn, new Runnable(){

            @Override
            public void run() {
                Main.this.startLoading();
                Main.this.loadingPct = 0.0f;
                try {
                    Main.this.mapModel.generatePathsAuto(Main.this.seaLevel);
                    Main.this.loadingPct = 1.0f;
                }
                finally {
                    Main.this.stopLoading();
                }
                Main.this.markRenderDirty();
            }
        })) {
            return true;
        }
        if (layout.taperCheck.contains(mx, my)) {
            if (this.activePathTypeIndex >= 0 && this.activePathTypeIndex < this.mapModel.pathTypes.size()) {
                PathType pt = this.mapModel.pathTypes.get(this.activePathTypeIndex);
                pt.taperOn = !pt.taperOn;
            }
            return true;
        }
        if (this.queueButtonAction(layout.typeAddBtn, new Runnable(){

            @Override
            public void run() {
                int n = Main.this.mapModel.pathTypes.size();
                int presetIdx = Main.min((int)n, (int)(Main.this.PATH_TYPE_PRESETS.length - 1));
                PathType pt = Main.this.mapModel.makePathTypeFromPreset(presetIdx);
                if (pt != null) {
                    Main.this.mapModel.addPathType(pt);
                    Main.this.activePathTypeIndex = Main.this.mapModel.pathTypes.size() - 1;
                    Main.this.syncActivePathTypeGlobals();
                    Main.this.selectedPathIndex = -1;
                    Main.this.pendingPathStart = null;
                    Main.this.editingPathNameIndex = -1;
                }
            }
        })) {
            return true;
        }
        boolean bl = canRemove = this.mapModel.pathTypes.size() > 1 && this.activePathTypeIndex > 0;
        if (canRemove && this.queueButtonAction(layout.typeRemoveBtn, new Runnable(){

            @Override
            public void run() {
                Main.this.mapModel.removePathType(Main.this.activePathTypeIndex);
                Main.this.activePathTypeIndex = Main.min((int)Main.this.activePathTypeIndex, (int)(Main.this.mapModel.pathTypes.size() - 1));
                if (Main.this.activePathTypeIndex < 0) {
                    Main.this.activePathTypeIndex = 0;
                }
                Main.this.editingPathTypeNameIndex = -1;
                Main.this.syncActivePathTypeGlobals();
                Main.this.selectedPathIndex = -1;
                Main.this.pendingPathStart = null;
                Main.this.editingPathNameIndex = -1;
            }
        })) {
            return true;
        }
        int nTypes = this.mapModel.pathTypes.size();
        int i = 0;
        while (i < nTypes) {
            IntRect sw = layout.typeSwatches.get(i);
            if (sw.contains(mx, my)) {
                this.activePathTypeIndex = i;
                this.syncActivePathTypeGlobals();
                this.selectedPathIndex = -1;
                this.pendingPathStart = null;
                this.editingPathNameIndex = -1;
                return true;
            }
            ++i;
        }
        if (layout.nameField.contains(mx, my) && this.activePathTypeIndex >= 0 && this.activePathTypeIndex < nTypes) {
            this.editingPathTypeNameIndex = this.activePathTypeIndex;
            this.pathTypeNameDraft = this.mapModel.pathTypes.get((int)this.activePathTypeIndex).name;
            return true;
        }
        if (this.activePathTypeIndex >= 0 && this.activePathTypeIndex < nTypes) {
            PathType pt;
            if (layout.typeHueSlider.contains(mx, my)) {
                float t = (float)(mx - layout.typeHueSlider.x) / (float)layout.typeHueSlider.w;
                t = Main.constrain((float)t, (float)0.0f, (float)1.0f);
                pt = this.mapModel.pathTypes.get(this.activePathTypeIndex);
                pt.hue01 = t;
                pt.updateColorFromHSB();
                this.activeSlider = 10;
                return true;
            }
            if (layout.typeSatSlider.contains(mx, my)) {
                float t = this.sliderNorm(layout.typeSatSlider, mx);
                pt = this.mapModel.pathTypes.get(this.activePathTypeIndex);
                pt.sat01 = t;
                pt.updateColorFromHSB();
                this.activeSlider = 11;
                return true;
            }
            if (layout.typeBriSlider.contains(mx, my)) {
                float t = this.sliderNorm(layout.typeBriSlider, mx);
                pt = this.mapModel.pathTypes.get(this.activePathTypeIndex);
                pt.bri01 = t;
                pt.updateColorFromHSB();
                this.activeSlider = 12;
                return true;
            }
            if (layout.typeWeightSlider.contains(mx, my)) {
                float t = this.sliderNorm(layout.typeWeightSlider, mx);
                pt = this.mapModel.pathTypes.get(this.activePathTypeIndex);
                pt.weightPx = Main.constrain((float)(0.5f + t * 7.5f), (float)0.5f, (float)8.0f);
                this.activeSlider = 13;
                return true;
            }
            if (layout.typeMinWeightSlider.contains(mx, my)) {
                float t = this.sliderNorm(layout.typeMinWeightSlider, mx);
                pt = this.mapModel.pathTypes.get(this.activePathTypeIndex);
                pt.minWeightPx = Main.constrain((float)(0.5f + t * (pt.weightPx - 0.5f)), (float)0.5f, (float)pt.weightPx);
                this.activeSlider = 21;
                return true;
            }
            if (layout.taperCheck.contains(mx, my)) {
                PathType pt2 = this.mapModel.pathTypes.get(this.activePathTypeIndex);
                pt2.taperOn = !pt2.taperOn;
                return true;
            }
        }
        return false;
    }

    public boolean handleLabelsPanelClick(int mx, int my) {
        if (!this.isInLabelsPanel(mx, my)) {
            return false;
        }
        LabelsLayout layout = this.buildLabelsLayout();
        if (this.queueButtonAction(layout.genButton, new Runnable(){

            @Override
            public void run() {
                if (Main.this.mapModel != null) {
                    Main.this.mapModel.generateArbitraryLabels(Main.this.seaLevel);
                }
            }
        })) {
            return true;
        }
        if (layout.commentField.contains(mx, my)) {
            if (this.selectedLabelIndex >= 0 && this.selectedLabelIndex < this.mapModel.labels.size()) {
                MapLabel l = this.mapModel.labels.get(this.selectedLabelIndex);
                this.labelCommentDraft = l != null && l.comment != null ? l.comment : "";
                this.editingLabelCommentIndex = this.selectedLabelIndex;
            } else {
                this.labelCommentDraft = "";
                this.editingLabelCommentIndex = -1;
            }
            return true;
        }
        this.editingLabelCommentIndex = -1;
        return false;
    }

    public boolean handleLabelsListPanelClick(int mx, int my) {
        if (!this.isInLabelsListPanel(mx, my)) {
            return false;
        }
        LabelsListLayout layout = this.buildLabelsListLayout();
        this.populateLabelsListRows(layout);
        if (this.queueButtonAction(layout.deselectBtn, new Runnable(){

            @Override
            public void run() {
                Main.this.selectedLabelIndex = -1;
                Main.this.editingLabelIndex = -1;
                Main.this.editingLabelCommentIndex = -1;
                Main.this.labelDraft = "label";
            }
        })) {
            return true;
        }
        int i = 0;
        while (i < layout.rows.size()) {
            final LabelRowLayout row = layout.rows.get(i);
            if (row.index >= 0 && row.index < this.mapModel.labels.size()) {
                final MapLabel lbl = this.mapModel.labels.get(row.index);
                if (this.queueButtonAction(row.selectRect, new Runnable(){

                    @Override
                    public void run() {
                        Main.this.selectedLabelIndex = row.index;
                        Main.this.editingLabelIndex = -1;
                        Main.this.editingLabelCommentIndex = -1;
                        Main.this.labelDraft = lbl.text;
                    }
                })) {
                    return true;
                }
                if (this.queueButtonAction(row.nameRect, new Runnable(){

                    @Override
                    public void run() {
                        Main.this.selectedLabelIndex = row.index;
                        Main.this.editingLabelIndex = row.index;
                        Main.this.editingLabelCommentIndex = -1;
                        Main.this.labelDraft = lbl.text;
                    }
                })) {
                    return true;
                }
                if (this.queueButtonAction(row.delRect, new Runnable(){

                    @Override
                    public void run() {
                        Main.this.mapModel.labels.remove(row.index);
                        if (Main.this.selectedLabelIndex == row.index) {
                            Main.this.selectedLabelIndex = -1;
                        }
                        if (Main.this.editingLabelIndex == row.index) {
                            Main.this.editingLabelIndex = -1;
                        }
                        Main.this.labelDraft = "label";
                    }
                })) {
                    return true;
                }
            }
            ++i;
        }
        return false;
    }

    public LabelTarget nextLabelTarget(LabelTarget lt) {
        switch (lt) {
            case FREE: {
                return LabelTarget.BIOME;
            }
            case BIOME: {
                return LabelTarget.ZONE;
            }
            case ZONE: {
                return LabelTarget.STRUCTURE;
            }
        }
        return LabelTarget.FREE;
    }

    public boolean handlePathsListPanelClick(int mx, int my) {
        if (!this.isInPathsListPanel(mx, my)) {
            return false;
        }
        PathsListLayout layout = this.buildPathsListLayout();
        this.populatePathsListRows(layout);
        if (this.queueButtonAction(layout.deselectBtn, new Runnable(){

            @Override
            public void run() {
                Main.this.selectedPathIndex = -1;
                Main.this.pendingPathStart = null;
                Main.this.editingPathNameIndex = -1;
            }
        })) {
            return true;
        }
        if (this.queueButtonAction(layout.newBtn, new Runnable(){

            @Override
            public void run() {
                Path np = new Path();
                np.typeId = Main.this.activePathTypeIndex;
                np.name = Main.this.mapModel.defaultPathNameForType(np.typeId);
                Main.this.mapModel.paths.add(np);
                Main.this.selectedPathIndex = Main.this.mapModel.paths.size() - 1;
                Main.this.activePathTypeIndex = np.typeId >= 0 && np.typeId < Main.this.mapModel.pathTypes.size() ? np.typeId : Main.this.activePathTypeIndex;
                Main.this.syncActivePathTypeGlobals();
                Main.this.editingPathNameIndex = Main.this.selectedPathIndex;
                Main.this.pathNameDraft = np.name;
                Main.this.pendingPathStart = null;
            }
        })) {
            return true;
        }
        int i = 0;
        while (i < layout.rows.size()) {
            Path p;
            final PathRowLayout row = layout.rows.get(i);
            if (row.index >= 0 && row.index < this.mapModel.paths.size() && (p = this.mapModel.paths.get(row.index)) != null) {
                if (this.queueButtonAction(row.selectRect, new Runnable(){

                    @Override
                    public void run() {
                        Main.this.selectedPathIndex = row.index;
                        if (p.typeId >= 0 && p.typeId < Main.this.mapModel.pathTypes.size()) {
                            Main.this.activePathTypeIndex = p.typeId;
                            Main.this.syncActivePathTypeGlobals();
                        }
                        Main.this.editingPathNameIndex = -1;
                        Main.this.editingPathCommentIndex = -1;
                        Main.this.pendingPathStart = null;
                    }
                })) {
                    return true;
                }
                if (this.queueButtonAction(row.nameRect, new Runnable(){

                    @Override
                    public void run() {
                        Main.this.selectedPathIndex = row.index;
                        if (p.typeId >= 0 && p.typeId < Main.this.mapModel.pathTypes.size()) {
                            Main.this.activePathTypeIndex = p.typeId;
                            Main.this.syncActivePathTypeGlobals();
                        }
                        Main.this.editingPathNameIndex = row.index;
                        Main.this.pathNameDraft = p.name != null ? p.name : "";
                        Main.this.editingPathCommentIndex = -1;
                    }
                })) {
                    return true;
                }
                if (this.queueButtonAction(row.delRect, new Runnable(){

                    @Override
                    public void run() {
                        Main.this.mapModel.paths.remove(row.index);
                        if (Main.this.selectedPathIndex == row.index) {
                            Main.this.selectedPathIndex = -1;
                            Main.this.pendingPathStart = null;
                        } else if (Main.this.selectedPathIndex > row.index) {
                            --Main.this.selectedPathIndex;
                        }
                        if (Main.this.editingPathNameIndex == row.index) {
                            Main.this.editingPathNameIndex = -1;
                        }
                    }
                })) {
                    return true;
                }
                if (this.queueButtonAction(row.typeRect, new Runnable(){

                    @Override
                    public void run() {
                        if (!Main.this.mapModel.pathTypes.isEmpty()) {
                            Main.this.activePathTypeIndex = p.typeId = (p.typeId + 1) % Main.this.mapModel.pathTypes.size();
                            Main.this.syncActivePathTypeGlobals();
                        }
                    }
                })) {
                    return true;
                }
            }
            ++i;
        }
        return false;
    }

    public boolean handleStructuresPanelClick(int mx, int my) {
        if (!this.isInStructuresPanel(mx, my)) {
            return false;
        }
        StructuresLayout layout = this.buildStructuresLayout();
        StructureSelectionInfo info = this.gatherStructureSelectionInfo();
        boolean hasSelection = info.hasSelection;
        if (this.queueButtonAction(layout.headerGen, new Runnable(){

            @Override
            public void run() {
                Main.this.structSectionGenOpen = !Main.this.structSectionGenOpen;
            }
        })) {
            return true;
        }
        if (this.queueButtonAction(layout.headerSnap, new Runnable(){

            @Override
            public void run() {
                Main.this.structSectionSnapOpen = !Main.this.structSectionSnapOpen;
            }
        })) {
            return true;
        }
        if (this.queueButtonAction(layout.headerAttr, new Runnable(){

            @Override
            public void run() {
                Main.this.structSectionAttrOpen = !Main.this.structSectionAttrOpen;
            }
        })) {
            return true;
        }
        if (this.structSectionGenOpen) {
            if (layout.genTownSlider.contains(mx, my)) {
                float t = this.sliderNorm(layout.genTownSlider, mx);
                this.structGenTownCount = Main.constrain((int)Main.round((float)(t * 8.0f)), (int)0, (int)8);
                this.activeSlider = 99;
                return true;
            }
            if (layout.genBuildingSlider.contains(mx, my)) {
                float t = this.sliderNorm(layout.genBuildingSlider, mx);
                this.structGenBuildingDensity = Main.constrain((float)t, (float)0.0f, (float)1.0f);
                this.activeSlider = 100;
                return true;
            }
            if (this.queueButtonAction(layout.genButton, new Runnable(){

                @Override
                public void run() {
                    Main.this.mapModel.generateStructuresAuto(Main.this.structGenTownCount, Main.this.structGenBuildingDensity, Main.this.seaLevel);
                    Main.this.clearStructureSelection();
                }
            })) {
                return true;
            }
        }
        if (this.structSectionSnapOpen) {
            int i = 0;
            while (i < layout.snapChecks.size()) {
                IntRect b = layout.snapChecks.get(i);
                if (b.contains(mx, my)) {
                    switch (i) {
                        case 0: {
                            this.snapWaterEnabled = !this.snapWaterEnabled;
                            break;
                        }
                        case 1: {
                            this.snapBiomesEnabled = !this.snapBiomesEnabled;
                            break;
                        }
                        case 2: {
                            this.snapUnderwaterBiomesEnabled = !this.snapUnderwaterBiomesEnabled;
                            break;
                        }
                        case 3: {
                            this.snapZonesEnabled = !this.snapZonesEnabled;
                            break;
                        }
                        case 4: {
                            this.snapPathsEnabled = !this.snapPathsEnabled;
                            break;
                        }
                        case 5: {
                            this.snapStructuresEnabled = !this.snapStructuresEnabled;
                            break;
                        }
                        case 6: {
                            this.snapElevationEnabled = !this.snapElevationEnabled;
                        }
                    }
                    return true;
                }
                ++i;
            }
            if (layout.snapElevationSlider != null && layout.snapElevationSlider.contains(mx, my)) {
                int divMin = 2;
                int divMax = 24;
                float t = this.sliderNorm(layout.snapElevationSlider, mx);
                this.snapElevationDivisions = Main.round((float)Main.lerp((float)divMin, (float)divMax, (float)t));
                this.activeSlider = 101;
                return true;
            }
        }
        if (!this.structSectionAttrOpen) {
            return false;
        }
        if (!layout.nameField.contains(mx, my)) {
            this.editingStructureName = false;
            this.editingStructureNameIndex = -1;
        }
        if (layout.nameField.contains(mx, my)) {
            this.editingStructureName = true;
            this.editingStructureNameIndex = -1;
            if (hasSelection && !info.nameMixed) {
                this.structureNameDraft = info.sharedName;
            } else if (hasSelection && info.nameMixed) {
                this.structureNameDraft = "";
            }
            return true;
        }
        if (layout.commentField.contains(mx, my)) {
            this.editingStructureComment = true;
            this.structureCommentDraft = hasSelection && !info.commentMixed ? info.sharedComment : "";
            return true;
        }
        this.editingStructureComment = false;
        if (layout.sizeSlider.contains(mx, my)) {
            float newSize;
            float t = this.sliderNorm(layout.sizeSlider, mx);
            this.structureSize = newSize = Main.constrain((float)(0.01f + t * 0.19f), (float)0.01f, (float)0.2f);
            if (hasSelection) {
                for (int idx : this.selectedStructureIndices) {
                    if (idx < 0 || idx >= this.mapModel.structures.size()) continue;
                    this.mapModel.structures.get((int)idx).size = newSize;
                }
                this.activeSlider = 24;
            } else {
                this.activeSlider = 17;
            }
            return true;
        }
        if (layout.angleSlider.contains(mx, my)) {
            float angRad;
            float t = this.sliderNorm(layout.angleSlider, mx);
            float angDeg = -180.0f + t * 360.0f;
            this.structureAngleOffsetRad = angRad = Main.radians((float)angDeg);
            if (hasSelection) {
                for (int idx : this.selectedStructureIndices) {
                    if (idx < 0 || idx >= this.mapModel.structures.size()) continue;
                    this.mapModel.structures.get((int)idx).angle = angRad;
                }
                this.activeSlider = 25;
            } else {
                this.activeSlider = 20;
            }
            return true;
        }
        if (layout.ratioSlider.contains(mx, my)) {
            float newRatio;
            float t = this.sliderNorm(layout.ratioSlider, mx);
            this.structureAspectRatio = newRatio = Main.constrain((float)(0.3f + t * 2.7f), (float)0.3f, (float)3.0f);
            if (hasSelection) {
                for (int idx : this.selectedStructureIndices) {
                    if (idx < 0 || idx >= this.mapModel.structures.size()) continue;
                    this.mapModel.structures.get((int)idx).aspect = newRatio;
                }
                this.activeSlider = 22;
            } else {
                this.activeSlider = 22;
            }
            return true;
        }
        if (layout.shapeSelector.contains(mx, my)) {
            StructureShape[] shapes = StructureShape.values();
            float t = this.sliderNorm(layout.shapeSelector, mx);
            int idx = Main.round((float)(t * (float)Main.max((int)0, (int)(shapes.length - 1))));
            idx = Main.constrain((int)idx, (int)0, (int)(shapes.length - 1));
            this.structureShape = shapes[idx];
            if (hasSelection) {
                for (int si : this.selectedStructureIndices) {
                    if (si < 0 || si >= this.mapModel.structures.size()) continue;
                    this.mapModel.structures.get((int)si).shape = this.structureShape;
                }
            }
            this.activeSlider = 102;
            return true;
        }
        if (layout.alignmentSelector.contains(mx, my)) {
            StructureSnapMode[] snaps = StructureSnapMode.values();
            float t = this.sliderNorm(layout.alignmentSelector, mx);
            int idx = Main.round((float)(t * (float)Main.max((int)0, (int)(snaps.length - 1))));
            idx = Main.constrain((int)idx, (int)0, (int)(snaps.length - 1));
            this.structureSnapMode = snaps[idx];
            if (hasSelection) {
                for (int si : this.selectedStructureIndices) {
                    if (si < 0 || si >= this.mapModel.structures.size()) continue;
                    this.mapModel.structures.get((int)si).alignment = this.structureSnapMode;
                }
            }
            this.activeSlider = 103;
            return true;
        }
        if (layout.hueSlider.contains(mx, my)) {
            float t;
            this.structureHue01 = t = this.sliderNorm(layout.hueSlider, mx);
            if (hasSelection) {
                for (int idx : this.selectedStructureIndices) {
                    if (idx < 0 || idx >= this.mapModel.structures.size()) continue;
                    this.mapModel.structures.get(idx).setHue(t);
                }
                this.activeSlider = 26;
            } else {
                this.activeSlider = 26;
            }
            return true;
        }
        if (layout.satSlider.contains(mx, my)) {
            float t;
            this.structureSat01 = t = this.sliderNorm(layout.satSlider, mx);
            if (hasSelection) {
                for (int idx : this.selectedStructureIndices) {
                    if (idx < 0 || idx >= this.mapModel.structures.size()) continue;
                    this.mapModel.structures.get(idx).setSaturation(t);
                }
                this.activeSlider = 28;
            } else {
                this.activeSlider = 28;
            }
            return true;
        }
        if (layout.alphaSlider.contains(mx, my)) {
            float t;
            this.structureAlpha01 = t = this.sliderNorm(layout.alphaSlider, mx);
            if (hasSelection) {
                for (int idx : this.selectedStructureIndices) {
                    if (idx < 0 || idx >= this.mapModel.structures.size()) continue;
                    this.mapModel.structures.get(idx).setAlpha(t);
                }
                this.activeSlider = 27;
            } else {
                this.activeSlider = 27;
            }
            return true;
        }
        if (layout.strokeSlider.contains(mx, my)) {
            float w;
            float t = this.sliderNorm(layout.strokeSlider, mx);
            this.structureStrokePx = w = Main.constrain((float)(0.5f + t * 3.5f), (float)0.5f, (float)4.0f);
            if (hasSelection) {
                for (int idx : this.selectedStructureIndices) {
                    if (idx < 0 || idx >= this.mapModel.structures.size()) continue;
                    this.mapModel.structures.get((int)idx).strokeWeightPx = w;
                }
                this.activeSlider = 29;
            } else {
                this.activeSlider = 29;
            }
            return true;
        }
        return false;
    }

    public boolean handleStructuresListPanelClick(int mx, int my) {
        if (!this.isInStructuresListPanel(mx, my)) {
            return false;
        }
        StructuresListLayout layout = this.buildStructuresListLayout();
        int listStartY = this.layoutStructureDetails(layout);
        this.populateStructuresListRows(layout, listStartY);
        if (this.queueButtonAction(layout.deselectBtn, new Runnable(){

            @Override
            public void run() {
                Main.this.clearStructureSelection();
            }
        })) {
            return true;
        }
        int i = 0;
        while (i < layout.rows.size()) {
            final StructureRowLayout row = layout.rows.get(i);
            if (row.index >= 0 && row.index < this.mapModel.structures.size()) {
                if (this.queueButtonAction(row.selectRect, new Runnable(){

                    @Override
                    public void run() {
                        Main.this.toggleStructureSelection(row.index);
                        Main.this.editingStructureName = false;
                        Main.this.editingStructureNameIndex = -1;
                    }
                })) {
                    return true;
                }
                if (this.queueButtonAction(row.nameRect, new Runnable(){

                    @Override
                    public void run() {
                        Main.this.selectStructureExclusive(row.index);
                        Main.this.editingStructureName = true;
                        Main.this.editingStructureNameIndex = row.index;
                        Structure target = Main.this.mapModel.structures.get(row.index);
                        Main.this.structureNameDraft = target != null && target.name != null ? target.name : "";
                    }
                })) {
                    return true;
                }
                if (this.queueButtonAction(row.delRect, new Runnable(){

                    @Override
                    public void run() {
                        Main.this.mapModel.structures.remove(row.index);
                        Main.this.shiftStructureSelectionAfterRemoval(row.index);
                        if (Main.this.editingStructureNameIndex == row.index) {
                            Main.this.editingStructureNameIndex = -1;
                        } else if (Main.this.editingStructureNameIndex > row.index) {
                            --Main.this.editingStructureNameIndex;
                        }
                        if (Main.this.selectedStructureIndices.isEmpty()) {
                            Main.this.editingStructureName = false;
                        }
                    }
                })) {
                    return true;
                }
            }
            ++i;
        }
        return false;
    }

    public boolean handleRenderPanelClick(int mx, int my) {
        int n;
        if (!this.isInRenderPanel(mx, my)) {
            return false;
        }
        RenderLayout layout = this.buildRenderLayout();
        if (this.queueButtonAction(layout.headerBase, new Runnable(){

            @Override
            public void run() {
                Main.this.renderSectionBaseOpen = !Main.this.renderSectionBaseOpen;
            }
        })) {
            return true;
        }
        if (this.queueButtonAction(layout.headerBiomes, new Runnable(){

            @Override
            public void run() {
                Main.this.renderSectionBiomesOpen = !Main.this.renderSectionBiomesOpen;
            }
        })) {
            return true;
        }
        if (this.queueButtonAction(layout.headerShading, new Runnable(){

            @Override
            public void run() {
                Main.this.renderSectionShadingOpen = !Main.this.renderSectionShadingOpen;
            }
        })) {
            return true;
        }
        if (this.queueButtonAction(layout.headerCoastlines, new Runnable(){

            @Override
            public void run() {
                Main.this.renderSectionCoastlinesOpen = !Main.this.renderSectionCoastlinesOpen;
            }
        })) {
            return true;
        }
        if (this.queueButtonAction(layout.headerElevation, new Runnable(){

            @Override
            public void run() {
                Main.this.renderSectionElevationOpen = !Main.this.renderSectionElevationOpen;
            }
        })) {
            return true;
        }
        if (this.queueButtonAction(layout.headerPaths, new Runnable(){

            @Override
            public void run() {
                Main.this.renderSectionPathsOpen = !Main.this.renderSectionPathsOpen;
            }
        })) {
            return true;
        }
        if (this.queueButtonAction(layout.headerZones, new Runnable(){

            @Override
            public void run() {
                Main.this.renderSectionZonesOpen = !Main.this.renderSectionZonesOpen;
            }
        })) {
            return true;
        }
        if (this.queueButtonAction(layout.headerStructures, new Runnable(){

            @Override
            public void run() {
                Main.this.renderSectionStructuresOpen = !Main.this.renderSectionStructuresOpen;
            }
        })) {
            return true;
        }
        if (this.queueButtonAction(layout.headerLabels, new Runnable(){

            @Override
            public void run() {
                Main.this.renderSectionLabelsOpen = !Main.this.renderSectionLabelsOpen;
            }
        })) {
            return true;
        }
        if (this.queueButtonAction(layout.headerGeneral, new Runnable(){

            @Override
            public void run() {
                Main.this.renderSectionGeneralOpen = !Main.this.renderSectionGeneralOpen;
            }
        })) {
            return true;
        }
        if (this.renderSectionBaseOpen) {
            if (layout.landHSB[0].contains(mx, my)) {
                this.renderSettings.landHue01 = this.sliderNorm(layout.landHSB[0], mx);
                this.activeSlider = 32;
                return true;
            }
            if (layout.landHSB[1].contains(mx, my)) {
                this.renderSettings.landSat01 = this.sliderNorm(layout.landHSB[1], mx);
                this.activeSlider = 33;
                return true;
            }
            if (layout.landHSB[2].contains(mx, my)) {
                this.renderSettings.landBri01 = this.sliderNorm(layout.landHSB[2], mx);
                this.activeSlider = 34;
                return true;
            }
            if (layout.waterHSB[0].contains(mx, my)) {
                this.renderSettings.waterHue01 = this.sliderNorm(layout.waterHSB[0], mx);
                this.activeSlider = 35;
                return true;
            }
            if (layout.waterHSB[1].contains(mx, my)) {
                this.renderSettings.waterSat01 = this.sliderNorm(layout.waterHSB[1], mx);
                this.activeSlider = 36;
                return true;
            }
            if (layout.waterHSB[2].contains(mx, my)) {
                this.renderSettings.waterBri01 = this.sliderNorm(layout.waterHSB[2], mx);
                this.activeSlider = 37;
                return true;
            }
            if (layout.cellBordersAlphaSlider.contains(mx, my)) {
                float t;
                this.renderSettings.cellBorderAlpha01 = t = this.sliderNorm(layout.cellBordersAlphaSlider, mx);
                this.activeSlider = 38;
                return true;
            }
            if (layout.cellBordersSizeSlider != null && layout.cellBordersSizeSlider.contains(mx, my)) {
                float t = this.sliderNorm(layout.cellBordersSizeSlider, mx);
                this.renderSettings.cellBorderSizePx = Main.constrain((float)(t * 5.0f), (float)0.0f, (float)5.0f);
                this.activeSlider = 104;
                this.markRenderVisualChange();
                return true;
            }
            if (layout.cellBordersScaleCheckbox != null && layout.cellBordersScaleCheckbox.contains(mx, my)) {
                boolean bl = this.renderSettings.cellBorderScaleWithZoom = !this.renderSettings.cellBorderScaleWithZoom;
                if (this.renderSettings.cellBorderScaleWithZoom) {
                    this.renderSettings.cellBorderRefZoom = 600.0f;
                }
                this.markRenderVisualChange();
                this.markExportPreviewDirty();
                return true;
            }
            if (layout.backgroundNoiseSlider.contains(mx, my)) {
                float t;
                this.renderSettings.backgroundNoiseAlpha01 = t = this.sliderNorm(layout.backgroundNoiseSlider, mx);
                this.activeSlider = 71;
                return true;
            }
        }
        if (this.renderSectionBiomesOpen) {
            if (layout.biomeFillAlphaSlider.contains(mx, my)) {
                float t;
                this.renderSettings.biomeFillAlpha01 = t = this.sliderNorm(layout.biomeFillAlphaSlider, mx);
                this.activeSlider = 39;
                return true;
            }
            if (layout.biomeSatSlider.contains(mx, my)) {
                float t;
                this.renderSettings.biomeSatScale01 = t = this.sliderNorm(layout.biomeSatSlider, mx);
                this.activeSlider = 40;
                if (this.mapModel != null && this.mapModel.renderer != null) {
                    this.mapModel.renderer.invalidateBiomeCache();
                }
                this.markRenderVisualChange();
                return true;
            }
            if (layout.biomeBriSlider != null && layout.biomeBriSlider.contains(mx, my)) {
                float t;
                this.renderSettings.biomeBriScale01 = t = this.sliderNorm(layout.biomeBriSlider, mx);
                this.activeSlider = 62;
                if (this.mapModel != null && this.mapModel.renderer != null) {
                    this.mapModel.renderer.invalidateBiomeCache();
                }
                this.markRenderVisualChange();
                return true;
            }
            int i = 0;
            while (i < layout.biomeFillTypeButtons.size()) {
                IntRect b = layout.biomeFillTypeButtons.get(i);
                if (b.contains(mx, my)) {
                    this.renderSettings.biomeFillType = i == 0 ? RenderFillType.RENDER_FILL_COLOR : (i == 1 ? RenderFillType.RENDER_FILL_PATTERN : RenderFillType.RENDER_FILL_PATTERN_BG);
                    if (this.mapModel != null && this.mapModel.renderer != null) {
                        this.mapModel.renderer.invalidateBiomeCache();
                    }
                    this.markRenderVisualChange();
                    return true;
                }
                ++i;
            }
            if (layout.biomeOutlineSizeSlider.contains(mx, my)) {
                float t = this.sliderNorm(layout.biomeOutlineSizeSlider, mx);
                this.renderSettings.biomeOutlineSizePx = Main.constrain((float)(t * 5.0f), (float)0.0f, (float)5.0f);
                this.activeSlider = 41;
                if (this.mapModel != null && this.mapModel.renderer != null) {
                    this.mapModel.renderer.invalidateBiomeCache();
                }
                this.markRenderVisualChange();
                return true;
            }
            if (layout.biomeOutlineAlphaSlider.contains(mx, my)) {
                float t;
                this.renderSettings.biomeOutlineAlpha01 = t = this.sliderNorm(layout.biomeOutlineAlphaSlider, mx);
                this.activeSlider = 42;
                return true;
            }
            if (layout.biomeOutlineScaleCheckbox != null && layout.biomeOutlineScaleCheckbox.contains(mx, my)) {
                boolean bl = this.renderSettings.biomeOutlineScaleWithZoom = !this.renderSettings.biomeOutlineScaleWithZoom;
                if (this.renderSettings.biomeOutlineScaleWithZoom) {
                    this.renderSettings.biomeOutlineRefZoom = 600.0f;
                }
                if (this.mapModel != null && this.mapModel.renderer != null) {
                    this.mapModel.renderer.invalidateBiomeCache();
                }
                this.markRenderVisualChange();
                this.markExportPreviewDirty();
                return true;
            }
            if (layout.biomeUnderwaterAlphaSlider != null && layout.biomeUnderwaterAlphaSlider.contains(mx, my)) {
                float t;
                this.renderSettings.biomeUnderwaterAlpha01 = t = this.sliderNorm(layout.biomeUnderwaterAlphaSlider, mx);
                this.activeSlider = 67;
                return true;
            }
        }
        if (this.renderSectionShadingOpen) {
            if (layout.waterDepthAlphaSlider.contains(mx, my)) {
                float t;
                this.renderSettings.waterDepthAlpha01 = t = this.sliderNorm(layout.waterDepthAlphaSlider, mx);
                this.activeSlider = 43;
                return true;
            }
            if (layout.lightAlphaSlider.contains(mx, my)) {
                float t;
                this.renderSettings.elevationLightAlpha01 = t = this.sliderNorm(layout.lightAlphaSlider, mx);
                this.activeSlider = 44;
                if (this.mapModel != null && this.mapModel.renderer != null) {
                    this.mapModel.renderer.invalidateLightCache();
                }
                this.markRenderVisualChange();
                return true;
            }
            if (layout.lightAzimuthSlider.contains(mx, my)) {
                float t = this.sliderNorm(layout.lightAzimuthSlider, mx);
                this.renderSettings.elevationLightAzimuthDeg = Main.constrain((float)(t * 360.0f), (float)0.0f, (float)360.0f);
                this.activeSlider = 15;
                if (this.mapModel != null && this.mapModel.renderer != null) {
                    this.mapModel.renderer.invalidateLightCache();
                }
                this.markRenderVisualChange();
                return true;
            }
            if (layout.lightAltitudeSlider.contains(mx, my)) {
                float t = this.sliderNorm(layout.lightAltitudeSlider, mx);
                this.renderSettings.elevationLightAltitudeDeg = Main.constrain((float)(5.0f + t * 75.0f), (float)5.0f, (float)80.0f);
                this.activeSlider = 16;
                if (this.mapModel != null && this.mapModel.renderer != null) {
                    this.mapModel.renderer.invalidateLightCache();
                }
                this.markRenderVisualChange();
                return true;
            }
            if (layout.lightDitherSlider != null && layout.lightDitherSlider.contains(mx, my)) {
                float t = this.sliderNorm(layout.lightDitherSlider, mx);
                this.renderSettings.elevationLightDitherPx = Main.constrain((float)(t * 10.0f), (float)0.0f, (float)10.0f);
                this.activeSlider = 76;
                if (this.mapModel != null && this.mapModel.renderer != null) {
                    this.mapModel.renderer.invalidateLightCache();
                }
                this.markRenderVisualChange();
                return true;
            }
            if (layout.lightDitherScaleCheckbox != null && layout.lightDitherScaleCheckbox.contains(mx, my)) {
                boolean bl = this.renderSettings.elevationLightDitherScaleWithZoom = !this.renderSettings.elevationLightDitherScaleWithZoom;
                if (this.renderSettings.elevationLightDitherScaleWithZoom) {
                    this.renderSettings.elevationLightDitherRefZoom = 600.0f;
                }
                if (this.mapModel != null && this.mapModel.renderer != null) {
                    this.mapModel.renderer.invalidateLightCache();
                }
                this.markRenderVisualChange();
                this.markExportPreviewDirty();
                return true;
            }
        }
        if (this.renderSectionCoastlinesOpen) {
            if (layout.waterCoastSizeSlider != null && layout.waterCoastSizeSlider.contains(mx, my)) {
                float t = this.sliderNorm(layout.waterCoastSizeSlider, mx);
                this.renderSettings.waterCoastSizePx = Main.constrain((float)(t * 5.0f), (float)0.0f, (float)5.0f);
                this.activeSlider = 106;
                if (this.mapModel != null && this.mapModel.renderer != null) {
                    this.mapModel.renderer.invalidateCoastCache();
                }
                this.markRenderVisualChange();
                return true;
            }
            if (layout.waterCoastScaleCheckbox != null && layout.waterCoastScaleCheckbox.contains(mx, my)) {
                boolean bl = this.renderSettings.waterCoastScaleWithZoom = !this.renderSettings.waterCoastScaleWithZoom;
                if (this.renderSettings.waterCoastScaleWithZoom) {
                    this.renderSettings.waterContourRefZoom = 600.0f;
                }
                this.markRenderVisualChange();
                if (this.mapModel != null && this.mapModel.renderer != null) {
                    this.mapModel.renderer.invalidateCoastCache();
                }
                this.markExportPreviewDirty();
                return true;
            }
            if (layout.waterCoastAboveZonesCheckbox != null && layout.waterCoastAboveZonesCheckbox.contains(mx, my)) {
                this.renderSettings.waterCoastAboveZones = !this.renderSettings.waterCoastAboveZones;
                this.markRenderVisualChange();
                if (this.mapModel != null && this.mapModel.renderer != null) {
                    this.mapModel.renderer.invalidateCoastCache();
                }
                this.markExportPreviewDirty();
                return true;
            }
            if (layout.waterContourCoastAlphaSlider.contains(mx, my)) {
                float t;
                this.renderSettings.waterCoastAlpha01 = t = this.sliderNorm(layout.waterContourCoastAlphaSlider, mx);
                this.syncLegacyWaterContourAlpha(this.renderSettings);
                this.activeSlider = 51;
                if (this.mapModel != null && this.mapModel.renderer != null) {
                    this.mapModel.renderer.invalidateCoastCache();
                }
                this.markRenderVisualChange();
                return true;
            }
            if (layout.waterContourSizeSlider.contains(mx, my)) {
                float t = this.sliderNorm(layout.waterContourSizeSlider, mx);
                this.renderSettings.waterContourSizePx = Main.constrain((float)(t * 5.0f), (float)0.0f, (float)5.0f);
                this.activeSlider = 45;
                if (this.mapModel != null && this.mapModel.renderer != null) {
                    this.mapModel.renderer.invalidateCoastCache();
                }
                this.markRenderVisualChange();
                return true;
            }
            if (layout.waterContourScaleCheckbox != null && layout.waterContourScaleCheckbox.contains(mx, my)) {
                boolean bl = this.renderSettings.waterContourScaleWithZoom = !this.renderSettings.waterContourScaleWithZoom;
                if (this.renderSettings.waterContourScaleWithZoom) {
                    this.renderSettings.waterContourRefZoom = 600.0f;
                }
                if (this.mapModel != null && this.mapModel.renderer != null) {
                    this.mapModel.renderer.invalidateCoastCache();
                }
                this.markRenderVisualChange();
                this.markExportPreviewDirty();
                return true;
            }
            if (layout.waterContourHSB[0].contains(mx, my)) {
                this.renderSettings.waterContourHue01 = this.sliderNorm(layout.waterContourHSB[0], mx);
                this.activeSlider = 48;
                if (this.mapModel != null && this.mapModel.renderer != null) {
                    this.mapModel.renderer.invalidateCoastCache();
                }
                this.markRenderVisualChange();
                return true;
            }
            if (layout.waterContourHSB[1].contains(mx, my)) {
                this.renderSettings.waterContourSat01 = this.sliderNorm(layout.waterContourHSB[1], mx);
                this.activeSlider = 49;
                if (this.mapModel != null && this.mapModel.renderer != null) {
                    this.mapModel.renderer.invalidateCoastCache();
                }
                this.markRenderVisualChange();
                return true;
            }
            if (layout.waterContourHSB[2].contains(mx, my)) {
                this.renderSettings.waterContourBri01 = this.sliderNorm(layout.waterContourHSB[2], mx);
                this.activeSlider = 50;
                if (this.mapModel != null && this.mapModel.renderer != null) {
                    this.mapModel.renderer.invalidateCoastCache();
                }
                this.markRenderVisualChange();
                return true;
            }
            if (layout.waterRippleCountSlider.contains(mx, my)) {
                float t = this.sliderNorm(layout.waterRippleCountSlider, mx);
                this.renderSettings.waterRippleCount = Main.constrain((int)Main.round((float)(t * 5.0f)), (int)0, (int)5);
                this.activeSlider = 46;
                if (this.mapModel != null && this.mapModel.renderer != null) {
                    this.mapModel.renderer.invalidateCoastCache();
                }
                this.markRenderVisualChange();
                return true;
            }
            if (layout.waterRippleDistanceSlider.contains(mx, my)) {
                float t = this.sliderNorm(layout.waterRippleDistanceSlider, mx);
                this.renderSettings.waterRippleDistancePx = Main.constrain((float)(t * 40.0f), (float)0.0f, (float)40.0f);
                this.activeSlider = 47;
                if (this.mapModel != null && this.mapModel.renderer != null) {
                    this.mapModel.renderer.invalidateCoastCache();
                }
                this.markRenderVisualChange();
                return true;
            }
            if (layout.waterRippleAlphaStartSlider.contains(mx, my)) {
                float t;
                this.renderSettings.waterRippleAlphaStart01 = t = this.sliderNorm(layout.waterRippleAlphaStartSlider, mx);
                this.activeSlider = 52;
                if (this.mapModel != null && this.mapModel.renderer != null) {
                    this.mapModel.renderer.invalidateCoastCache();
                }
                this.markRenderVisualChange();
                return true;
            }
            if (layout.waterRippleAlphaEndSlider.contains(mx, my)) {
                float t;
                this.renderSettings.waterRippleAlphaEnd01 = t = this.sliderNorm(layout.waterRippleAlphaEndSlider, mx);
                this.activeSlider = 53;
                if (this.mapModel != null && this.mapModel.renderer != null) {
                    this.mapModel.renderer.invalidateCoastCache();
                }
                this.markRenderVisualChange();
                return true;
            }
            if (layout.waterHatchAngleSlider.contains(mx, my)) {
                float t = this.sliderNorm(layout.waterHatchAngleSlider, mx);
                this.renderSettings.waterHatchAngleDeg = Main.constrain((float)(-90.0f + t * 180.0f), (float)-90.0f, (float)90.0f);
                this.activeSlider = 72;
                if (this.mapModel != null && this.mapModel.renderer != null) {
                    this.mapModel.renderer.invalidateCoastCache();
                }
                this.markRenderVisualChange();
                return true;
            }
            if (layout.waterHatchLengthSlider.contains(mx, my)) {
                float t = this.sliderNorm(layout.waterHatchLengthSlider, mx);
                this.renderSettings.waterHatchLengthPx = Main.constrain((float)(t * 400.0f), (float)0.0f, (float)400.0f);
                this.activeSlider = 73;
                if (this.mapModel != null && this.mapModel.renderer != null) {
                    this.mapModel.renderer.invalidateCoastCache();
                }
                this.markRenderVisualChange();
                return true;
            }
            if (layout.waterHatchSpacingSlider.contains(mx, my)) {
                float t = this.sliderNorm(layout.waterHatchSpacingSlider, mx);
                this.renderSettings.waterHatchSpacingPx = Main.constrain((float)(t * 120.0f), (float)0.0f, (float)120.0f);
                this.activeSlider = 74;
                if (this.mapModel != null && this.mapModel.renderer != null) {
                    this.mapModel.renderer.invalidateCoastCache();
                }
                this.markRenderVisualChange();
                return true;
            }
            if (layout.waterHatchAlphaSlider.contains(mx, my)) {
                float t;
                this.renderSettings.waterHatchAlpha01 = t = this.sliderNorm(layout.waterHatchAlphaSlider, mx);
                this.activeSlider = 75;
                if (this.mapModel != null && this.mapModel.renderer != null) {
                    this.mapModel.renderer.invalidateCoastCache();
                }
                this.markRenderVisualChange();
                return true;
            }
        }
        if (this.renderSectionElevationOpen) {
            if (layout.elevationLinesCountSlider.contains(mx, my)) {
                float t = this.sliderNorm(layout.elevationLinesCountSlider, mx);
                this.renderSettings.elevationLinesCount = Main.constrain((int)Main.round((float)(t * 24.0f)), (int)0, (int)24);
                this.activeSlider = 54;
                this.markRenderVisualChange();
                return true;
            }
            if (layout.elevationLinesAlphaSlider.contains(mx, my)) {
                float t;
                this.renderSettings.elevationLinesAlpha01 = t = this.sliderNorm(layout.elevationLinesAlphaSlider, mx);
                this.activeSlider = 55;
                return true;
            }
            if (layout.elevationLinesSizeSlider != null && layout.elevationLinesSizeSlider.contains(mx, my)) {
                float t = this.sliderNorm(layout.elevationLinesSizeSlider, mx);
                this.renderSettings.elevationLinesSizePx = Main.constrain((float)(t * 5.0f), (float)0.0f, (float)5.0f);
                this.activeSlider = 105;
                this.markRenderVisualChange();
                return true;
            }
            if (layout.elevationLinesScaleCheckbox != null && layout.elevationLinesScaleCheckbox.contains(mx, my)) {
                boolean bl = this.renderSettings.elevationLinesScaleWithZoom = !this.renderSettings.elevationLinesScaleWithZoom;
                if (this.renderSettings.elevationLinesScaleWithZoom) {
                    this.renderSettings.elevationLinesRefZoom = 600.0f;
                }
                this.markRenderVisualChange();
                this.markExportPreviewDirty();
                return true;
            }
        }
        if (this.renderSectionPathsOpen) {
            if (layout.pathsShowCheckbox.contains(mx, my)) {
                this.renderSettings.showPaths = !this.renderSettings.showPaths;
                return true;
            }
            if (layout.pathsScaleWithZoomCheckbox != null && layout.pathsScaleWithZoomCheckbox.contains(mx, my)) {
                boolean bl = this.renderSettings.pathScaleWithZoom = !this.renderSettings.pathScaleWithZoom;
                if (this.renderSettings.pathScaleWithZoom) {
                    this.renderSettings.pathScaleRefZoom = 600.0f;
                }
                this.markRenderVisualChange();
                this.markExportPreviewDirty();
                return true;
            }
            if (layout.pathSatSlider.contains(mx, my)) {
                float t;
                this.renderSettings.pathSatScale01 = t = this.sliderNorm(layout.pathSatSlider, mx);
                this.activeSlider = 56;
                return true;
            }
            if (layout.pathBriSlider.contains(mx, my)) {
                float t;
                this.renderSettings.pathBriScale01 = t = this.sliderNorm(layout.pathBriSlider, mx);
                this.activeSlider = 90;
                return true;
            }
        }
        if (this.renderSectionZonesOpen) {
            if (layout.zoneAlphaSlider.contains(mx, my)) {
                float t;
                this.renderSettings.zoneStrokeAlpha01 = t = this.sliderNorm(layout.zoneAlphaSlider, mx);
                this.activeSlider = 57;
                if (this.mapModel != null && this.mapModel.renderer != null) {
                    this.mapModel.renderer.invalidateZoneCache();
                }
                this.markRenderVisualChange();
                return true;
            }
            if (layout.zoneSizeSlider != null && layout.zoneSizeSlider.contains(mx, my)) {
                float t = this.sliderNorm(layout.zoneSizeSlider, mx);
                this.renderSettings.zoneStrokeSizePx = Main.constrain((float)(t * 5.0f), (float)0.0f, (float)5.0f);
                this.activeSlider = 58;
                if (this.mapModel != null && this.mapModel.renderer != null) {
                    this.mapModel.renderer.invalidateZoneCache();
                }
                this.markRenderVisualChange();
                return true;
            }
            if (layout.zoneScaleWithZoomCheckbox != null && layout.zoneScaleWithZoomCheckbox.contains(mx, my)) {
                boolean bl = this.renderSettings.zoneStrokeScaleWithZoom = !this.renderSettings.zoneStrokeScaleWithZoom;
                if (this.renderSettings.zoneStrokeScaleWithZoom) {
                    this.renderSettings.zoneStrokeRefZoom = 600.0f;
                }
                if (this.mapModel != null && this.mapModel.renderer != null) {
                    this.mapModel.renderer.invalidateZoneCache();
                }
                this.markRenderVisualChange();
                this.markExportPreviewDirty();
                return true;
            }
            if (layout.zoneSatSlider.contains(mx, my)) {
                float t;
                this.renderSettings.zoneStrokeSatScale01 = t = this.sliderNorm(layout.zoneSatSlider, mx);
                this.activeSlider = 59;
                if (this.mapModel != null && this.mapModel.renderer != null) {
                    this.mapModel.renderer.invalidateZoneCache();
                }
                this.markRenderVisualChange();
                return true;
            }
            if (layout.zoneBriSlider.contains(mx, my)) {
                float t;
                this.renderSettings.zoneStrokeBriScale01 = t = this.sliderNorm(layout.zoneBriSlider, mx);
                this.activeSlider = 63;
                if (this.mapModel != null && this.mapModel.renderer != null) {
                    this.mapModel.renderer.invalidateZoneCache();
                }
                this.markRenderVisualChange();
                return true;
            }
        }
        if (this.renderSectionStructuresOpen) {
            if (layout.structuresShowCheckbox.contains(mx, my)) {
                this.renderSettings.showStructures = !this.renderSettings.showStructures;
                return true;
            }
            if (layout.structuresMergeCheckbox.contains(mx, my)) {
                this.renderSettings.mergeStructures = !this.renderSettings.mergeStructures;
                return true;
            }
            if (layout.structuresScaleWithZoomCheckbox != null && layout.structuresScaleWithZoomCheckbox.contains(mx, my)) {
                boolean bl = this.renderSettings.structureStrokeScaleWithZoom = !this.renderSettings.structureStrokeScaleWithZoom;
                if (this.renderSettings.structureStrokeScaleWithZoom) {
                    this.renderSettings.structureStrokeRefZoom = 600.0f;
                }
                this.markRenderVisualChange();
                this.markExportPreviewDirty();
                return true;
            }
            if (layout.structuresShadowAlphaSlider.contains(mx, my)) {
                float t;
                this.renderSettings.structureShadowAlpha01 = t = this.sliderNorm(layout.structuresShadowAlphaSlider, mx);
                this.activeSlider = 68;
                return true;
            }
        }
        if (this.renderSectionLabelsOpen) {
            if (layout.labelsArbitraryCheckbox.contains(mx, my)) {
                this.renderSettings.showLabelsArbitrary = !this.renderSettings.showLabelsArbitrary;
                return true;
            }
            if (layout.labelsArbSizeSlider.contains(mx, my)) {
                float t = this.sliderNorm(layout.labelsArbSizeSlider, mx);
                this.renderSettings.labelSizeArbPx = Main.round((float)Main.constrain((float)(8.0f + t * 32.0f), (float)4.0f, (float)80.0f));
                this.activeSlider = 92;
                return true;
            }
            if (layout.labelsZonesCheckbox.contains(mx, my)) {
                this.renderSettings.showLabelsZones = !this.renderSettings.showLabelsZones;
                return true;
            }
            if (layout.labelsZoneSizeSlider.contains(mx, my)) {
                float t = this.sliderNorm(layout.labelsZoneSizeSlider, mx);
                this.renderSettings.labelSizeZonePx = Main.round((float)Main.constrain((float)(8.0f + t * 32.0f), (float)4.0f, (float)80.0f));
                this.activeSlider = 93;
                return true;
            }
            if (layout.labelsPathsCheckbox.contains(mx, my)) {
                this.renderSettings.showLabelsPaths = !this.renderSettings.showLabelsPaths;
                return true;
            }
            if (layout.labelsPathSizeSlider.contains(mx, my)) {
                float t = this.sliderNorm(layout.labelsPathSizeSlider, mx);
                this.renderSettings.labelSizePathPx = Main.round((float)Main.constrain((float)(8.0f + t * 32.0f), (float)4.0f, (float)80.0f));
                this.activeSlider = 94;
                return true;
            }
            if (layout.labelsStructuresCheckbox.contains(mx, my)) {
                this.renderSettings.showLabelsStructures = !this.renderSettings.showLabelsStructures;
                return true;
            }
            if (layout.labelsScaleWithZoomCheckbox != null && layout.labelsScaleWithZoomCheckbox.contains(mx, my)) {
                boolean bl = this.renderSettings.labelScaleWithZoom = !this.renderSettings.labelScaleWithZoom;
                if (this.renderSettings.labelScaleWithZoom) {
                    this.renderSettings.labelScaleRefZoom = 600.0f;
                }
                this.markExportPreviewDirty();
                return true;
            }
            if (layout.labelsOutlineScaleWithZoomCheckbox != null && layout.labelsOutlineScaleWithZoomCheckbox.contains(mx, my)) {
                this.renderSettings.labelOutlineScaleWithZoom = !this.renderSettings.labelOutlineScaleWithZoom;
                this.markExportPreviewDirty();
                return true;
            }
            if (layout.labelsScaleWithZoomCheckbox != null && mx >= layout.labelsScaleWithZoomCheckbox.x + layout.labelsScaleWithZoomCheckbox.w + 8 && mx <= layout.labelsScaleWithZoomCheckbox.x + layout.labelsScaleWithZoomCheckbox.w + 8 + 80 && my >= layout.labelsScaleWithZoomCheckbox.y && my <= layout.labelsScaleWithZoomCheckbox.y + 14) {
                this.renderSettings.labelScaleRefZoom = this.renderSettings.labelScaleRefZoom != 1.0f ? 1.0f : Main.max((float)0.1f, (float)this.viewport.zoom);
                this.markExportPreviewDirty();
                return true;
            }
            if (layout.labelsStructSizeSlider.contains(mx, my)) {
                float t = this.sliderNorm(layout.labelsStructSizeSlider, mx);
                this.renderSettings.labelSizeStructPx = Main.round((float)Main.constrain((float)(8.0f + t * 32.0f), (float)4.0f, (float)80.0f));
                this.activeSlider = 95;
                return true;
            }
            if (layout.labelsOutlineAlphaSlider.contains(mx, my)) {
                float t;
                this.renderSettings.labelOutlineAlpha01 = t = this.sliderNorm(layout.labelsOutlineAlphaSlider, mx);
                this.activeSlider = 60;
                return true;
            }
            if (layout.labelsOutlineSizeSlider.contains(mx, my)) {
                float t = this.sliderNorm(layout.labelsOutlineSizeSlider, mx);
                this.renderSettings.labelOutlineSizePx = Main.round((float)Main.constrain((float)(t * 16.0f), (float)0.0f, (float)16.0f));
                this.activeSlider = 91;
                return true;
            }
            if (layout.labelsFontSelector != null && layout.labelsFontSelector.contains(mx, my) && this.LABEL_FONT_OPTIONS != null && this.LABEL_FONT_OPTIONS.length > 0) {
                int idx;
                n = Main.max((int)1, (int)(this.LABEL_FONT_OPTIONS.length - 1));
                float t = this.sliderNorm(layout.labelsFontSelector, mx);
                this.renderSettings.labelFontIndex = idx = Main.constrain((int)Main.round((float)(t * (float)n)), (int)0, (int)(this.LABEL_FONT_OPTIONS.length - 1));
                this.activeSlider = 96;
                if (this.mapModel != null && this.mapModel.renderer != null) {
                    this.mapModel.renderer.fontPrepNeeded = true;
                }
                return true;
            }
        }
        if (this.renderSectionGeneralOpen) {
            if (layout.exportPaddingSlider.contains(mx, my)) {
                float t = this.sliderNorm(layout.exportPaddingSlider, mx);
                this.renderPaddingPct = this.renderSettings.exportPaddingPct = Main.constrain((float)(t * 0.1f), (float)0.0f, (float)0.1f);
                this.activeSlider = 30;
                this.markExportPreviewDirty();
                return true;
            }
            if (layout.antialiasCheckbox.contains(mx, my)) {
                boolean bl = this.renderSettings.antialiasing = !this.renderSettings.antialiasing;
                if (this.mapModel != null && this.mapModel.renderer != null) {
                    this.mapModel.renderer.invalidateCoastCache();
                    this.mapModel.renderer.invalidateBiomeCache();
                    this.mapModel.renderer.invalidateZoneCache();
                    this.mapModel.renderer.invalidateLightCache();
                }
                this.markRenderDirty();
                return true;
            }
            if (layout.presetSelector.contains(mx, my) && this.renderPresets != null && this.renderPresets.length > 0) {
                int idx;
                n = Main.max((int)1, (int)(this.renderPresets.length - 1));
                float t = this.sliderNorm(layout.presetSelector, mx);
                this.renderSettings.activePresetIndex = idx = Main.constrain((int)Main.round((float)(t * (float)n)), (int)0, (int)(this.renderPresets.length - 1));
                this.activeSlider = 64;
                return true;
            }
            if (this.queueButtonAction(layout.presetApplyBtn, new Runnable(){

                @Override
                public void run() {
                    Main.this.applyRenderPreset(Main.this.renderSettings.activePresetIndex);
                }
            })) {
                return true;
            }
        }
        return false;
    }

    public boolean handleExportPanelClick(int mx, int my) {
        if (!this.isInExportPanel(mx, my)) {
            return false;
        }
        ExportLayout layout = this.buildExportLayout();
        if (this.queueButtonAction(layout.pngBtn, new Runnable(){

            @Override
            public void run() {
                String path = Main.this.exportPng();
                if (path != null && path.length() > 0 && !path.startsWith("Failed")) {
                    Main.this.lastExportStatus = path;
                    Main.this.showNotice("Saved PNG: " + path);
                } else {
                    Main.this.lastExportStatus = path != null ? path : "Export failed";
                    Main.this.showNotice("Export failed");
                }
            }
        })) {
            return true;
        }
        if (this.queueButtonAction(layout.svgBtn, new Runnable(){

            @Override
            public void run() {
                String path = Main.this.exportSvg();
                if (path != null && path.length() > 0 && !path.startsWith("Failed")) {
                    Main.this.lastExportStatus = path;
                    Main.this.showNotice("Saved SVG: " + path);
                } else {
                    Main.this.lastExportStatus = path != null ? path : "Export failed";
                    Main.this.showNotice("Export failed");
                }
            }
        })) {
            return true;
        }
        if (this.queueButtonAction(layout.geoJsonBtn, new Runnable(){

            @Override
            public void run() {
                String path = Main.this.exportGeoJson();
                if (path != null && path.length() > 0 && !path.startsWith("Failed")) {
                    Main.this.lastExportStatus = path;
                    Main.this.showNotice("Saved GeoJSON: " + path);
                } else {
                    Main.this.lastExportStatus = path != null ? path : "Export failed";
                    Main.this.showNotice("Export failed");
                }
            }
        })) {
            return true;
        }
        if (layout.setResolutionBtn != null && this.queueButtonAction(layout.setResolutionBtn, new Runnable(){

            @Override
            public void run() {
                Main.this.exportScale = Main.max((float)0.1f, (float)(Main.this.viewport.zoom / 600.0f));
                Main.this.markExportPreviewDirty();
            }
        })) {
            return true;
        }
        if (this.queueButtonAction(layout.mapExportBtn, new Runnable(){

            @Override
            public void run() {
                String path = Main.this.exportMapJson();
                if (path != null && path.length() > 0 && !path.startsWith("Failed")) {
                    Main.this.lastExportStatus = path;
                    Main.this.showNotice("Saved map JSON: " + path);
                } else {
                    Main.this.lastExportStatus = path != null ? path : "Export failed";
                    Main.this.showNotice("Export failed");
                }
            }
        })) {
            return true;
        }
        return this.queueButtonAction(layout.mapImportBtn, new Runnable(){

            @Override
            public void run() {
                String res = Main.this.importMapJson();
                if (res != null && res.startsWith("Failed")) {
                    Main.this.lastExportStatus = res;
                    Main.this.showNotice("Import failed");
                } else {
                    Main.this.lastExportStatus = res != null ? res : "Imported";
                    Main.this.showNotice("Map imported");
                }
            }
        });
    }

    public boolean handleElevationPanelClick(int mx, int my) {
        if (!this.isInElevationPanel(mx, my)) {
            return false;
        }
        ElevationLayout layout = this.buildElevationLayout();
        if (layout.seaSlider.contains(mx, my)) {
            float t = this.sliderNorm(layout.seaSlider, mx);
            float newSea = Main.lerp((float)-1.2f, (float)1.2f, (float)t);
            if (Main.abs((float)(newSea - this.seaLevel)) > 1.0E-6f) {
                this.seaLevel = newSea;
                this.markRenderDirty();
            }
            this.activeSlider = 6;
            return true;
        }
        if (layout.radiusSlider.contains(mx, my)) {
            float t = this.sliderNorm(layout.radiusSlider, mx);
            this.elevationBrushRadius = Main.constrain((float)(0.01f + t * 0.19f), (float)0.01f, (float)0.2f);
            this.activeSlider = 7;
            return true;
        }
        if (layout.strengthSlider.contains(mx, my)) {
            float t = this.sliderNorm(layout.strengthSlider, mx);
            this.elevationBrushStrength = Main.constrain((float)(0.005f + t * 0.19500001f), (float)0.005f, (float)0.2f);
            this.activeSlider = 8;
            return true;
        }
        if (this.queueButtonAction(layout.raiseBtn, new Runnable(){

            @Override
            public void run() {
                Main.this.elevationBrushRaise = true;
            }
        })) {
            return true;
        }
        if (this.queueButtonAction(layout.lowerBtn, new Runnable(){

            @Override
            public void run() {
                Main.this.elevationBrushRaise = false;
            }
        })) {
            return true;
        }
        if (layout.noiseSlider.contains(mx, my)) {
            float t = this.sliderNorm(layout.noiseSlider, mx);
            this.elevationNoiseScale = Main.constrain((float)(1.0f + t * 11.0f), (float)1.0f, (float)12.0f);
            this.activeSlider = 9;
            return true;
        }
        if (this.queueButtonAction(layout.perlinBtn, new Runnable(){

            @Override
            public void run() {
                Main.this.noiseSeed((int)Main.this.random(2.1474836E9f));
                Main.this.mapModel.generateElevationNoise(Main.this.elevationNoiseScale, 1.0f, Main.this.seaLevel);
            }
        })) {
            return true;
        }
        if (this.queueButtonAction(layout.varyBtn, new Runnable(){

            @Override
            public void run() {
                Main.this.noiseSeed((int)Main.this.random(2.1474836E9f));
                Main.this.mapModel.addElevationVariation(Main.this.elevationNoiseScale, 0.2f, Main.this.seaLevel);
            }
        })) {
            return true;
        }
        return this.queueButtonAction(layout.plateauBtn, new Runnable(){

            @Override
            public void run() {
                Main.this.mapModel.makePlateaus(Main.this.seaLevel);
            }
        });
    }

    public RenderPreset[] buildDefaultRenderPresets() {
        ArrayList<RenderPreset> list = new ArrayList<RenderPreset>();
        RenderSettings s = new RenderSettings();
        s.landHue01 = 0.0f;
        s.landSat01 = 0.0f;
        s.landBri01 = 0.85f;
        s.waterHue01 = 0.55f;
        s.waterSat01 = 0.55f;
        s.waterBri01 = 0.55f;
        s.cellBorderAlpha01 = 0.0f;
        s.cellBorderSizePx = 1.0f;
        s.cellBorderScaleWithZoom = true;
        s.cellBorderRefZoom = 600.0f;
        s.backgroundNoiseAlpha01 = 0.1f;
        s.biomeFillAlpha01 = 0.5f;
        s.biomeSatScale01 = 1.0f;
        s.biomeBriScale01 = 1.0f;
        s.biomeFillType = RenderFillType.RENDER_FILL_COLOR;
        s.biomeOutlineSizePx = 1.0f;
        s.biomeOutlineAlpha01 = 0.5f;
        s.biomeOutlineScaleWithZoom = true;
        s.biomeOutlineRefZoom = 600.0f;
        s.biomeUnderwaterAlpha01 = 0.1f;
        s.waterDepthAlpha01 = 0.75f;
        s.elevationLightAlpha01 = 0.75f;
        s.elevationLightAzimuthDeg = 220.0f;
        s.elevationLightAltitudeDeg = 45.0f;
        s.elevationLightDitherPx = 3.0f;
        s.elevationLightDitherScaleWithZoom = true;
        s.elevationLightDitherRefZoom = 600.0f;
        s.waterContourSizePx = 2.0f;
        s.waterRippleCount = 0;
        s.waterRippleDistancePx = 5.0f;
        s.waterContourHue01 = 0.6f;
        s.waterContourSat01 = 0.0f;
        s.waterContourBri01 = 0.0f;
        s.waterContourAlpha01 = 1.0f;
        s.waterCoastAlpha01 = 1.0f;
        s.waterCoastSizePx = 2.0f;
        s.waterCoastScaleWithZoom = true;
        s.waterCoastAboveZones = true;
        s.waterContourScaleWithZoom = true;
        s.waterContourRefZoom = 600.0f;
        s.waterRippleAlphaStart01 = 1.0f;
        s.waterRippleAlphaEnd01 = 0.3f;
        s.waterHatchAngleDeg = 0.0f;
        s.waterHatchLengthPx = 5.0f;
        s.waterHatchSpacingPx = 4.0f;
        s.waterHatchAlpha01 = 0.0f;
        s.elevationLinesCount = 0;
        s.elevationLinesStyle = ElevationLinesStyle.ELEV_LINES_BASIC;
        s.elevationLinesAlpha01 = 0.3f;
        s.elevationLinesSizePx = 1.0f;
        s.elevationLinesScaleWithZoom = true;
        s.elevationLinesRefZoom = 600.0f;
        s.pathSatScale01 = 1.0f;
        s.pathBriScale01 = 1.0f;
        s.showPaths = true;
        s.pathScaleWithZoom = true;
        s.pathScaleRefZoom = 600.0f;
        s.zoneStrokeAlpha01 = 0.75f;
        s.zoneStrokeSizePx = 2.0f;
        s.zoneStrokeSatScale01 = 0.75f;
        s.zoneStrokeBriScale01 = 1.0f;
        s.zoneStrokeScaleWithZoom = true;
        s.zoneStrokeRefZoom = 600.0f;
        s.showStructures = true;
        s.mergeStructures = true;
        s.structureSatScale01 = 1.0f;
        s.structureAlphaScale01 = 1.0f;
        s.structureShadowAlpha01 = 0.2f;
        s.structureStrokeScaleWithZoom = true;
        s.structureStrokeRefZoom = 600.0f;
        s.showLabelsArbitrary = true;
        s.showLabelsZones = true;
        s.showLabelsPaths = true;
        s.showLabelsStructures = true;
        s.labelOutlineAlpha01 = 1.0f;
        s.labelOutlineSizePx = 2.0f;
        s.labelSizeArbPx = 19.0f;
        s.labelSizeZonePx = 17.0f;
        s.labelSizePathPx = 12.0f;
        s.labelSizeStructPx = 14.0f;
        s.labelScaleWithZoom = true;
        s.labelScaleRefZoom = 600.0f;
        s.labelOutlineScaleWithZoom = true;
        s.labelFontIndex = 4;
        s.exportPaddingPct = 0.015f;
        s.antialiasing = true;
        s.activePresetIndex = 0;
        list.add(new RenderPreset("Default", s));
        s = new RenderSettings();
        s.landHue01 = 0.2f;
        s.landSat01 = 0.1f;
        s.landBri01 = 0.9f;
        s.waterHue01 = 0.6f;
        s.waterSat01 = 0.2f;
        s.waterBri01 = 0.4f;
        s.cellBorderAlpha01 = 0.0f;
        s.cellBorderSizePx = 1.0f;
        s.cellBorderScaleWithZoom = true;
        s.cellBorderRefZoom = 600.0f;
        s.backgroundNoiseAlpha01 = 0.0f;
        s.biomeFillAlpha01 = 0.8f;
        s.biomeSatScale01 = 0.4f;
        s.biomeBriScale01 = 1.0f;
        s.biomeFillType = RenderFillType.RENDER_FILL_COLOR;
        s.biomeOutlineSizePx = 0.0f;
        s.biomeOutlineAlpha01 = 0.0f;
        s.biomeOutlineScaleWithZoom = true;
        s.biomeOutlineRefZoom = 600.0f;
        s.biomeUnderwaterAlpha01 = 0.0f;
        s.waterDepthAlpha01 = 0.8f;
        s.elevationLightAlpha01 = 0.6f;
        s.elevationLightAzimuthDeg = 200.0f;
        s.elevationLightAltitudeDeg = 60.0f;
        s.elevationLightDitherPx = 3.0f;
        s.elevationLightDitherScaleWithZoom = true;
        s.elevationLightDitherRefZoom = 600.0f;
        s.waterContourSizePx = 5.0f;
        s.waterRippleCount = 0;
        s.waterRippleDistancePx = 0.0f;
        s.waterContourHue01 = 0.6f;
        s.waterContourSat01 = 0.3f;
        s.waterContourBri01 = 0.6f;
        s.waterContourAlpha01 = 0.3f;
        s.waterCoastAlpha01 = 0.3f;
        s.waterCoastSizePx = 2.0f;
        s.waterCoastScaleWithZoom = true;
        s.waterCoastAboveZones = false;
        s.waterContourScaleWithZoom = true;
        s.waterContourRefZoom = 600.0f;
        s.waterRippleAlphaStart01 = 0.25f;
        s.waterRippleAlphaEnd01 = 0.08f;
        s.waterHatchAngleDeg = 0.0f;
        s.waterHatchLengthPx = 0.0f;
        s.waterHatchSpacingPx = 12.0f;
        s.waterHatchAlpha01 = 0.0f;
        s.elevationLinesCount = 0;
        s.elevationLinesStyle = ElevationLinesStyle.ELEV_LINES_BASIC;
        s.elevationLinesAlpha01 = 0.0f;
        s.elevationLinesSizePx = 1.0f;
        s.elevationLinesScaleWithZoom = true;
        s.elevationLinesRefZoom = 600.0f;
        s.pathSatScale01 = 0.7f;
        s.pathBriScale01 = 1.0f;
        s.showPaths = true;
        s.pathScaleWithZoom = true;
        s.pathScaleRefZoom = 600.0f;
        s.zoneStrokeAlpha01 = 0.0f;
        s.zoneStrokeSizePx = 2.0f;
        s.zoneStrokeSatScale01 = 0.0f;
        s.zoneStrokeBriScale01 = 0.0f;
        s.zoneStrokeScaleWithZoom = true;
        s.zoneStrokeRefZoom = 600.0f;
        s.showStructures = true;
        s.mergeStructures = false;
        s.structureSatScale01 = 1.0f;
        s.structureAlphaScale01 = 1.0f;
        s.structureShadowAlpha01 = 0.2f;
        s.structureStrokeScaleWithZoom = true;
        s.structureStrokeRefZoom = 600.0f;
        s.showLabelsArbitrary = false;
        s.showLabelsZones = false;
        s.showLabelsPaths = false;
        s.showLabelsStructures = false;
        s.labelOutlineAlpha01 = 0.0f;
        s.labelOutlineSizePx = 1.0f;
        s.labelSizeArbPx = 12.0f;
        s.labelSizeZonePx = 14.0f;
        s.labelSizePathPx = 12.0f;
        s.labelSizeStructPx = 12.0f;
        s.labelScaleWithZoom = true;
        s.labelScaleRefZoom = 600.0f;
        s.labelOutlineScaleWithZoom = true;
        s.labelFontIndex = 0;
        s.exportPaddingPct = 0.01f;
        s.antialiasing = true;
        s.activePresetIndex = 0;
        list.add(new RenderPreset("Satellite", s));
        s = new RenderSettings();
        s.landHue01 = 0.2f;
        s.landSat01 = 0.0f;
        s.landBri01 = 1.0f;
        s.waterHue01 = 0.6f;
        s.waterSat01 = 0.7f;
        s.waterBri01 = 0.6f;
        s.cellBorderAlpha01 = 0.0f;
        s.cellBorderSizePx = 1.0f;
        s.cellBorderScaleWithZoom = true;
        s.cellBorderRefZoom = 600.0f;
        s.backgroundNoiseAlpha01 = 0.0f;
        s.biomeFillAlpha01 = 1.0f;
        s.biomeSatScale01 = 0.75f;
        s.biomeBriScale01 = 1.0f;
        s.biomeFillType = RenderFillType.RENDER_FILL_COLOR;
        s.biomeOutlineSizePx = 1.0f;
        s.biomeOutlineAlpha01 = 0.0f;
        s.biomeOutlineScaleWithZoom = true;
        s.biomeOutlineRefZoom = 600.0f;
        s.biomeUnderwaterAlpha01 = 0.0f;
        s.waterDepthAlpha01 = 0.3f;
        s.elevationLightAlpha01 = 0.3f;
        s.elevationLightAzimuthDeg = 280.0f;
        s.elevationLightAltitudeDeg = 15.0f;
        s.elevationLightDitherPx = 0.0f;
        s.waterContourSizePx = 2.5f;
        s.waterRippleCount = 0;
        s.waterRippleDistancePx = 0.0f;
        s.waterContourHue01 = 0.6f;
        s.waterContourSat01 = 0.25f;
        s.waterContourBri01 = 0.0f;
        s.waterContourAlpha01 = 1.0f;
        s.waterCoastAlpha01 = 1.0f;
        s.waterCoastSizePx = 2.0f;
        s.waterCoastScaleWithZoom = true;
        s.waterCoastAboveZones = false;
        s.waterContourScaleWithZoom = true;
        s.waterContourRefZoom = 600.0f;
        s.waterRippleAlphaStart01 = 0.9f;
        s.waterRippleAlphaEnd01 = 0.25f;
        s.waterHatchAngleDeg = 0.0f;
        s.waterHatchLengthPx = 0.0f;
        s.waterHatchSpacingPx = 12.0f;
        s.waterHatchAlpha01 = 0.0f;
        s.elevationLinesCount = 10;
        s.elevationLinesStyle = ElevationLinesStyle.ELEV_LINES_BASIC;
        s.elevationLinesAlpha01 = 0.6f;
        s.elevationLinesSizePx = 1.0f;
        s.elevationLinesScaleWithZoom = true;
        s.elevationLinesRefZoom = 600.0f;
        s.pathSatScale01 = 1.0f;
        s.pathBriScale01 = 1.0f;
        s.showPaths = true;
        s.pathScaleWithZoom = true;
        s.pathScaleRefZoom = 600.0f;
        s.zoneStrokeAlpha01 = 0.0f;
        s.zoneStrokeSizePx = 2.0f;
        s.zoneStrokeSatScale01 = 0.0f;
        s.zoneStrokeBriScale01 = 0.0f;
        s.zoneStrokeScaleWithZoom = true;
        s.zoneStrokeRefZoom = 600.0f;
        s.showStructures = false;
        s.mergeStructures = false;
        s.structureSatScale01 = 1.0f;
        s.structureAlphaScale01 = 1.0f;
        s.structureShadowAlpha01 = 0.2f;
        s.structureStrokeScaleWithZoom = true;
        s.structureStrokeRefZoom = 600.0f;
        s.showLabelsArbitrary = true;
        s.showLabelsZones = true;
        s.showLabelsPaths = true;
        s.showLabelsStructures = false;
        s.labelOutlineAlpha01 = 1.0f;
        s.labelOutlineSizePx = 2.0f;
        s.labelSizeArbPx = 16.0f;
        s.labelSizeZonePx = 17.0f;
        s.labelSizePathPx = 15.0f;
        s.labelSizeStructPx = 14.0f;
        s.labelScaleWithZoom = true;
        s.labelScaleRefZoom = 600.0f;
        s.labelOutlineScaleWithZoom = true;
        s.labelFontIndex = 2;
        s.exportPaddingPct = 0.02f;
        s.antialiasing = true;
        s.activePresetIndex = 0;
        list.add(new RenderPreset("Geographic", s));
        s = new RenderSettings();
        s.landHue01 = 0.1f;
        s.landSat01 = 0.0f;
        s.landBri01 = 1.0f;
        s.waterHue01 = 0.0f;
        s.waterSat01 = 0.0f;
        s.waterBri01 = 0.25f;
        s.cellBorderAlpha01 = 0.0f;
        s.cellBorderSizePx = 1.0f;
        s.cellBorderScaleWithZoom = true;
        s.cellBorderRefZoom = 600.0f;
        s.backgroundNoiseAlpha01 = 0.0f;
        s.biomeFillAlpha01 = 1.0f;
        s.biomeSatScale01 = 0.0f;
        s.biomeBriScale01 = 1.0f;
        s.biomeFillType = RenderFillType.RENDER_FILL_COLOR;
        s.biomeOutlineSizePx = 1.0f;
        s.biomeOutlineAlpha01 = 0.0f;
        s.biomeOutlineScaleWithZoom = true;
        s.biomeOutlineRefZoom = 600.0f;
        s.biomeUnderwaterAlpha01 = 0.0f;
        s.waterDepthAlpha01 = 0.5f;
        s.elevationLightAlpha01 = 0.25f;
        s.elevationLightAzimuthDeg = 220.0f;
        s.elevationLightAltitudeDeg = 25.0f;
        s.elevationLightDitherPx = 0.0f;
        s.waterContourSizePx = 3.0f;
        s.waterRippleCount = 0;
        s.waterRippleDistancePx = 0.0f;
        s.waterContourHue01 = 0.0f;
        s.waterContourSat01 = 0.0f;
        s.waterContourBri01 = 0.0f;
        s.waterContourAlpha01 = 1.0f;
        s.waterCoastAlpha01 = 1.0f;
        s.waterCoastSizePx = 2.0f;
        s.waterCoastScaleWithZoom = true;
        s.waterCoastAboveZones = false;
        s.waterContourScaleWithZoom = true;
        s.waterContourRefZoom = 600.0f;
        s.waterRippleAlphaStart01 = 0.8f;
        s.waterRippleAlphaEnd01 = 0.25f;
        s.waterHatchAngleDeg = 0.0f;
        s.waterHatchLengthPx = 0.0f;
        s.waterHatchSpacingPx = 12.0f;
        s.waterHatchAlpha01 = 0.0f;
        s.elevationLinesCount = 4;
        s.elevationLinesStyle = ElevationLinesStyle.ELEV_LINES_BASIC;
        s.elevationLinesAlpha01 = 0.25f;
        s.elevationLinesSizePx = 1.0f;
        s.elevationLinesScaleWithZoom = true;
        s.elevationLinesRefZoom = 600.0f;
        s.pathSatScale01 = 0.0f;
        s.pathBriScale01 = 1.0f;
        s.showPaths = true;
        s.pathScaleWithZoom = true;
        s.pathScaleRefZoom = 600.0f;
        s.zoneStrokeAlpha01 = 0.7f;
        s.zoneStrokeSizePx = 2.0f;
        s.zoneStrokeSatScale01 = 0.0f;
        s.zoneStrokeBriScale01 = 0.0f;
        s.zoneStrokeScaleWithZoom = true;
        s.zoneStrokeRefZoom = 600.0f;
        s.showStructures = true;
        s.mergeStructures = false;
        s.structureSatScale01 = 0.0f;
        s.structureAlphaScale01 = 1.0f;
        s.structureShadowAlpha01 = 0.25f;
        s.structureStrokeScaleWithZoom = true;
        s.structureStrokeRefZoom = 600.0f;
        s.showLabelsArbitrary = true;
        s.showLabelsZones = true;
        s.showLabelsPaths = true;
        s.showLabelsStructures = true;
        s.labelOutlineAlpha01 = 0.8f;
        s.labelOutlineSizePx = 1.0f;
        s.labelSizeArbPx = 12.0f;
        s.labelSizeZonePx = 14.0f;
        s.labelSizePathPx = 12.0f;
        s.labelSizeStructPx = 12.0f;
        s.labelScaleWithZoom = true;
        s.labelScaleRefZoom = 600.0f;
        s.labelOutlineScaleWithZoom = true;
        s.labelFontIndex = 0;
        s.exportPaddingPct = 0.015f;
        s.antialiasing = true;
        s.activePresetIndex = 0;
        list.add(new RenderPreset("Grey", s));
        s = new RenderSettings();
        s.landHue01 = 0.1f;
        s.landSat01 = 0.0f;
        s.landBri01 = 1.0f;
        s.waterHue01 = 0.0f;
        s.waterSat01 = 0.0f;
        s.waterBri01 = 1.0f;
        s.cellBorderAlpha01 = 0.0f;
        s.cellBorderSizePx = 1.0f;
        s.cellBorderScaleWithZoom = true;
        s.cellBorderRefZoom = 600.0f;
        s.backgroundNoiseAlpha01 = 0.0f;
        s.biomeFillAlpha01 = 1.0f;
        s.biomeSatScale01 = 0.0f;
        s.biomeBriScale01 = 0.0f;
        s.biomeFillType = RenderFillType.RENDER_FILL_PATTERN;
        s.biomeOutlineSizePx = 1.0f;
        s.biomeOutlineAlpha01 = 0.0f;
        s.biomeOutlineScaleWithZoom = true;
        s.biomeOutlineRefZoom = 600.0f;
        s.biomeUnderwaterAlpha01 = 0.0f;
        s.waterDepthAlpha01 = 0.0f;
        s.elevationLightAlpha01 = 0.0f;
        s.elevationLightAzimuthDeg = 220.0f;
        s.elevationLightAltitudeDeg = 45.0f;
        s.elevationLightDitherPx = 0.0f;
        s.waterContourSizePx = 2.0f;
        s.waterRippleCount = 0;
        s.waterRippleDistancePx = 4.0f;
        s.waterContourHue01 = 0.0f;
        s.waterContourSat01 = 0.0f;
        s.waterContourBri01 = 0.0f;
        s.waterContourAlpha01 = 1.0f;
        s.waterCoastAlpha01 = 1.0f;
        s.waterCoastSizePx = 2.0f;
        s.waterCoastScaleWithZoom = true;
        s.waterCoastAboveZones = false;
        s.waterContourScaleWithZoom = true;
        s.waterContourRefZoom = 600.0f;
        s.waterRippleAlphaStart01 = 0.8f;
        s.waterRippleAlphaEnd01 = 0.25f;
        s.waterHatchAngleDeg = -40.0f;
        s.waterHatchLengthPx = 8.0f;
        s.waterHatchSpacingPx = 4.0f;
        s.waterHatchAlpha01 = 1.0f;
        s.elevationLinesCount = 2;
        s.elevationLinesStyle = ElevationLinesStyle.ELEV_LINES_BASIC;
        s.elevationLinesAlpha01 = 1.0f;
        s.elevationLinesSizePx = 1.0f;
        s.elevationLinesScaleWithZoom = true;
        s.elevationLinesRefZoom = 600.0f;
        s.pathSatScale01 = 0.0f;
        s.pathBriScale01 = 1.0f;
        s.showPaths = true;
        s.pathScaleWithZoom = true;
        s.pathScaleRefZoom = 600.0f;
        s.zoneStrokeAlpha01 = 1.0f;
        s.zoneStrokeSizePx = 2.0f;
        s.zoneStrokeSatScale01 = 0.0f;
        s.zoneStrokeBriScale01 = 0.0f;
        s.zoneStrokeScaleWithZoom = true;
        s.zoneStrokeRefZoom = 600.0f;
        s.showStructures = true;
        s.mergeStructures = false;
        s.structureSatScale01 = 0.0f;
        s.structureAlphaScale01 = 1.0f;
        s.structureShadowAlpha01 = 1.0f;
        s.structureStrokeScaleWithZoom = true;
        s.structureStrokeRefZoom = 600.0f;
        s.showLabelsArbitrary = true;
        s.showLabelsZones = true;
        s.showLabelsPaths = true;
        s.showLabelsStructures = true;
        s.labelOutlineAlpha01 = 1.0f;
        s.labelOutlineSizePx = 1.0f;
        s.labelSizeArbPx = 12.0f;
        s.labelSizeZonePx = 14.0f;
        s.labelSizePathPx = 12.0f;
        s.labelSizeStructPx = 12.0f;
        s.labelScaleWithZoom = true;
        s.labelScaleRefZoom = 600.0f;
        s.labelOutlineScaleWithZoom = true;
        s.labelFontIndex = 0;
        s.exportPaddingPct = 0.015f;
        s.antialiasing = false;
        s.activePresetIndex = 0;
        list.add(new RenderPreset("Bitmap", s));
        s = new RenderSettings();
        s.landHue01 = 0.1f;
        s.landSat01 = 0.1f;
        s.landBri01 = 0.8f;
        s.waterHue01 = 0.6f;
        s.waterSat01 = 0.7f;
        s.waterBri01 = 0.2f;
        s.cellBorderAlpha01 = 0.05f;
        s.cellBorderSizePx = 1.0f;
        s.cellBorderScaleWithZoom = true;
        s.cellBorderRefZoom = 600.0f;
        s.backgroundNoiseAlpha01 = 0.0f;
        s.biomeFillAlpha01 = 0.3f;
        s.biomeSatScale01 = 0.9f;
        s.biomeBriScale01 = 1.0f;
        s.biomeFillType = RenderFillType.RENDER_FILL_PATTERN;
        s.biomeOutlineSizePx = 2.0f;
        s.biomeOutlineAlpha01 = 0.9f;
        s.biomeOutlineScaleWithZoom = true;
        s.biomeOutlineRefZoom = 600.0f;
        s.biomeUnderwaterAlpha01 = 1.0f;
        s.waterDepthAlpha01 = 1.0f;
        s.elevationLightAlpha01 = 0.4f;
        s.elevationLightAzimuthDeg = 250.0f;
        s.elevationLightAltitudeDeg = 10.0f;
        s.elevationLightDitherPx = 0.0f;
        s.waterContourSizePx = 2.0f;
        s.waterRippleCount = 4;
        s.waterRippleDistancePx = 6.0f;
        s.waterContourHue01 = 0.6f;
        s.waterContourSat01 = 1.0f;
        s.waterContourBri01 = 0.3f;
        s.waterContourAlpha01 = 1.0f;
        s.waterCoastAlpha01 = 1.0f;
        s.waterCoastSizePx = 2.0f;
        s.waterCoastScaleWithZoom = true;
        s.waterCoastAboveZones = false;
        s.waterContourScaleWithZoom = true;
        s.waterContourRefZoom = 600.0f;
        s.waterRippleAlphaStart01 = 0.8f;
        s.waterRippleAlphaEnd01 = 0.25f;
        s.waterHatchAngleDeg = 0.0f;
        s.waterHatchLengthPx = 0.0f;
        s.waterHatchSpacingPx = 12.0f;
        s.waterHatchAlpha01 = 0.0f;
        s.elevationLinesCount = 16;
        s.elevationLinesStyle = ElevationLinesStyle.ELEV_LINES_BASIC;
        s.elevationLinesAlpha01 = 0.3f;
        s.elevationLinesSizePx = 1.0f;
        s.elevationLinesScaleWithZoom = false;
        s.elevationLinesRefZoom = 600.0f;
        s.pathSatScale01 = 1.0f;
        s.pathBriScale01 = 1.0f;
        s.showPaths = true;
        s.pathScaleWithZoom = true;
        s.pathScaleRefZoom = 600.0f;
        s.zoneStrokeAlpha01 = 0.5f;
        s.zoneStrokeSizePx = 2.0f;
        s.zoneStrokeSatScale01 = 0.8f;
        s.zoneStrokeBriScale01 = 0.2f;
        s.zoneStrokeScaleWithZoom = true;
        s.zoneStrokeRefZoom = 600.0f;
        s.showStructures = true;
        s.mergeStructures = true;
        s.structureSatScale01 = 1.0f;
        s.structureAlphaScale01 = 1.0f;
        s.structureShadowAlpha01 = 0.4f;
        s.structureStrokeScaleWithZoom = true;
        s.structureStrokeRefZoom = 600.0f;
        s.showLabelsArbitrary = true;
        s.showLabelsZones = true;
        s.showLabelsPaths = true;
        s.showLabelsStructures = true;
        s.labelOutlineAlpha01 = 0.9f;
        s.labelOutlineSizePx = 1.0f;
        s.labelSizeArbPx = 12.0f;
        s.labelSizeZonePx = 14.0f;
        s.labelSizePathPx = 12.0f;
        s.labelSizeStructPx = 12.0f;
        s.labelScaleWithZoom = true;
        s.labelScaleRefZoom = 600.0f;
        s.labelOutlineScaleWithZoom = true;
        s.labelFontIndex = 0;
        s.exportPaddingPct = 0.02f;
        s.antialiasing = true;
        s.activePresetIndex = 0;
        list.add(new RenderPreset("Much", s));
        s = new RenderSettings();
        s.landHue01 = 0.2f;
        s.landSat01 = 0.0f;
        s.landBri01 = 1.0f;
        s.waterHue01 = 0.6f;
        s.waterSat01 = 0.7f;
        s.waterBri01 = 0.5f;
        s.cellBorderAlpha01 = 0.0f;
        s.cellBorderSizePx = 1.0f;
        s.cellBorderScaleWithZoom = true;
        s.cellBorderRefZoom = 600.0f;
        s.backgroundNoiseAlpha01 = 0.0f;
        s.biomeFillAlpha01 = 0.3f;
        s.biomeSatScale01 = 0.3f;
        s.biomeBriScale01 = 1.0f;
        s.biomeFillType = RenderFillType.RENDER_FILL_COLOR;
        s.biomeOutlineSizePx = 1.0f;
        s.biomeOutlineAlpha01 = 0.0f;
        s.biomeOutlineScaleWithZoom = true;
        s.biomeOutlineRefZoom = 600.0f;
        s.biomeUnderwaterAlpha01 = 1.0f;
        s.waterDepthAlpha01 = 0.0f;
        s.elevationLightAlpha01 = 0.0f;
        s.elevationLightAzimuthDeg = 0.0f;
        s.elevationLightAltitudeDeg = 10.0f;
        s.elevationLightDitherPx = 0.0f;
        s.waterContourSizePx = 2.0f;
        s.waterRippleCount = 0;
        s.waterRippleDistancePx = 0.0f;
        s.waterContourHue01 = 0.5f;
        s.waterContourSat01 = 0.25f;
        s.waterContourBri01 = 0.0f;
        s.waterContourAlpha01 = 0.5f;
        s.waterCoastAlpha01 = 0.5f;
        s.waterCoastSizePx = 2.0f;
        s.waterCoastScaleWithZoom = true;
        s.waterCoastAboveZones = false;
        s.waterContourScaleWithZoom = true;
        s.waterContourRefZoom = 600.0f;
        s.waterRippleAlphaStart01 = 0.35f;
        s.waterRippleAlphaEnd01 = 0.15f;
        s.waterHatchAngleDeg = 0.0f;
        s.waterHatchLengthPx = 0.0f;
        s.waterHatchSpacingPx = 12.0f;
        s.waterHatchAlpha01 = 0.0f;
        s.elevationLinesCount = 0;
        s.elevationLinesStyle = ElevationLinesStyle.ELEV_LINES_BASIC;
        s.elevationLinesAlpha01 = 0.1f;
        s.elevationLinesSizePx = 1.0f;
        s.elevationLinesScaleWithZoom = true;
        s.elevationLinesRefZoom = 600.0f;
        s.pathSatScale01 = 0.8f;
        s.pathBriScale01 = 1.0f;
        s.showPaths = true;
        s.pathScaleWithZoom = true;
        s.pathScaleRefZoom = 600.0f;
        s.zoneStrokeAlpha01 = 1.0f;
        s.zoneStrokeSizePx = 2.0f;
        s.zoneStrokeSatScale01 = 1.0f;
        s.zoneStrokeBriScale01 = 1.0f;
        s.zoneStrokeScaleWithZoom = true;
        s.zoneStrokeRefZoom = 600.0f;
        s.showStructures = true;
        s.mergeStructures = true;
        s.structureSatScale01 = 1.0f;
        s.structureAlphaScale01 = 1.0f;
        s.structureShadowAlpha01 = 0.2f;
        s.structureStrokeScaleWithZoom = true;
        s.structureStrokeRefZoom = 600.0f;
        s.showLabelsArbitrary = true;
        s.showLabelsZones = true;
        s.showLabelsPaths = true;
        s.showLabelsStructures = true;
        s.labelOutlineAlpha01 = 1.0f;
        s.labelOutlineSizePx = 1.0f;
        s.labelSizeArbPx = 12.0f;
        s.labelSizeZonePx = 14.0f;
        s.labelSizePathPx = 12.0f;
        s.labelSizeStructPx = 12.0f;
        s.labelScaleWithZoom = true;
        s.labelScaleRefZoom = 600.0f;
        s.labelOutlineScaleWithZoom = true;
        s.labelFontIndex = 0;
        s.exportPaddingPct = 0.015f;
        s.antialiasing = true;
        s.activePresetIndex = 0;
        list.add(new RenderPreset("Administrative", s));
        s = new RenderSettings();
        s.landHue01 = 0.1f;
        s.landSat01 = 0.1f;
        s.landBri01 = 1.0f;
        s.waterHue01 = 0.6f;
        s.waterSat01 = 0.7f;
        s.waterBri01 = 0.5f;
        s.cellBorderAlpha01 = 0.0f;
        s.cellBorderSizePx = 1.0f;
        s.cellBorderScaleWithZoom = true;
        s.cellBorderRefZoom = 600.0f;
        s.backgroundNoiseAlpha01 = 0.0f;
        s.biomeFillAlpha01 = 1.0f;
        s.biomeSatScale01 = 1.0f;
        s.biomeBriScale01 = 1.0f;
        s.biomeFillType = RenderFillType.RENDER_FILL_COLOR;
        s.biomeOutlineSizePx = 1.0f;
        s.biomeOutlineAlpha01 = 0.0f;
        s.biomeOutlineScaleWithZoom = true;
        s.biomeOutlineRefZoom = 600.0f;
        s.biomeUnderwaterAlpha01 = 0.0f;
        s.waterDepthAlpha01 = 0.0f;
        s.elevationLightAlpha01 = 0.0f;
        s.elevationLightAzimuthDeg = 0.0f;
        s.elevationLightAltitudeDeg = 10.0f;
        s.elevationLightDitherPx = 0.0f;
        s.waterContourSizePx = 3.0f;
        s.waterRippleCount = 0;
        s.waterRippleDistancePx = 0.0f;
        s.waterContourHue01 = 0.5f;
        s.waterContourSat01 = 0.25f;
        s.waterContourBri01 = 0.0f;
        s.waterContourAlpha01 = 1.0f;
        s.waterCoastAlpha01 = 1.0f;
        s.waterCoastSizePx = 2.0f;
        s.waterCoastScaleWithZoom = true;
        s.waterCoastAboveZones = false;
        s.waterContourScaleWithZoom = true;
        s.waterContourRefZoom = 600.0f;
        s.waterRippleAlphaStart01 = 0.8f;
        s.waterRippleAlphaEnd01 = 0.25f;
        s.waterHatchAngleDeg = 0.0f;
        s.waterHatchLengthPx = 0.0f;
        s.waterHatchSpacingPx = 12.0f;
        s.waterHatchAlpha01 = 0.0f;
        s.elevationLinesCount = 0;
        s.elevationLinesStyle = ElevationLinesStyle.ELEV_LINES_BASIC;
        s.elevationLinesAlpha01 = 1.0f;
        s.elevationLinesSizePx = 1.0f;
        s.elevationLinesScaleWithZoom = true;
        s.elevationLinesRefZoom = 600.0f;
        s.pathSatScale01 = 0.8f;
        s.pathBriScale01 = 1.0f;
        s.showPaths = false;
        s.pathScaleWithZoom = true;
        s.pathScaleRefZoom = 600.0f;
        s.zoneStrokeAlpha01 = 1.0f;
        s.zoneStrokeSizePx = 2.0f;
        s.zoneStrokeSatScale01 = 1.0f;
        s.zoneStrokeBriScale01 = 1.0f;
        s.zoneStrokeScaleWithZoom = true;
        s.zoneStrokeRefZoom = 600.0f;
        s.showStructures = false;
        s.mergeStructures = true;
        s.structureSatScale01 = 1.0f;
        s.structureAlphaScale01 = 1.0f;
        s.structureShadowAlpha01 = 0.2f;
        s.structureStrokeScaleWithZoom = true;
        s.structureStrokeRefZoom = 600.0f;
        s.showLabelsArbitrary = false;
        s.showLabelsZones = false;
        s.showLabelsPaths = false;
        s.showLabelsStructures = false;
        s.labelOutlineAlpha01 = 1.0f;
        s.labelOutlineSizePx = 1.0f;
        s.labelSizeArbPx = 12.0f;
        s.labelSizeZonePx = 14.0f;
        s.labelSizePathPx = 12.0f;
        s.labelSizeStructPx = 12.0f;
        s.labelScaleWithZoom = true;
        s.labelScaleRefZoom = 600.0f;
        s.labelOutlineScaleWithZoom = true;
        s.labelFontIndex = 0;
        s.exportPaddingPct = 0.015f;
        s.antialiasing = true;
        s.activePresetIndex = 0;
        list.add(new RenderPreset("Simple", s));
        s = new RenderSettings();
        s.landHue01 = 0.7f;
        s.landSat01 = 1.0f;
        s.landBri01 = 0.4f;
        s.waterHue01 = 0.1f;
        s.waterSat01 = 1.0f;
        s.waterBri01 = 1.0f;
        s.cellBorderAlpha01 = 0.8f;
        s.cellBorderSizePx = 1.0f;
        s.cellBorderScaleWithZoom = false;
        s.cellBorderRefZoom = 600.0f;
        s.backgroundNoiseAlpha01 = 0.0f;
        s.biomeFillAlpha01 = 0.7f;
        s.biomeSatScale01 = 1.0f;
        s.biomeBriScale01 = 1.0f;
        s.biomeFillType = RenderFillType.RENDER_FILL_PATTERN;
        s.biomeOutlineSizePx = 4.0f;
        s.biomeOutlineAlpha01 = 0.3f;
        s.biomeOutlineScaleWithZoom = true;
        s.biomeOutlineRefZoom = 600.0f;
        s.biomeUnderwaterAlpha01 = 0.0f;
        s.waterDepthAlpha01 = 0.6f;
        s.elevationLightAlpha01 = 1.0f;
        s.elevationLightAzimuthDeg = 300.0f;
        s.elevationLightAltitudeDeg = 70.0f;
        s.elevationLightDitherPx = 0.0f;
        s.waterContourSizePx = 4.0f;
        s.waterRippleCount = 5;
        s.waterRippleDistancePx = 20.0f;
        s.waterContourHue01 = 0.1f;
        s.waterContourSat01 = 1.0f;
        s.waterContourBri01 = 1.0f;
        s.waterContourAlpha01 = 1.0f;
        s.waterCoastAlpha01 = 1.0f;
        s.waterCoastSizePx = 2.0f;
        s.waterCoastScaleWithZoom = true;
        s.waterCoastAboveZones = false;
        s.waterContourScaleWithZoom = true;
        s.waterContourRefZoom = 600.0f;
        s.waterRippleAlphaStart01 = 0.8f;
        s.waterRippleAlphaEnd01 = 0.25f;
        s.waterHatchAngleDeg = 0.0f;
        s.waterHatchLengthPx = 0.0f;
        s.waterHatchSpacingPx = 12.0f;
        s.waterHatchAlpha01 = 0.0f;
        s.elevationLinesCount = 24;
        s.elevationLinesStyle = ElevationLinesStyle.ELEV_LINES_BASIC;
        s.elevationLinesAlpha01 = 1.0f;
        s.elevationLinesSizePx = 1.0f;
        s.elevationLinesScaleWithZoom = true;
        s.elevationLinesRefZoom = 600.0f;
        s.pathSatScale01 = 0.3f;
        s.pathBriScale01 = 1.0f;
        s.showPaths = false;
        s.pathScaleWithZoom = false;
        s.pathScaleRefZoom = 600.0f;
        s.zoneStrokeAlpha01 = 1.0f;
        s.zoneStrokeSizePx = 2.0f;
        s.zoneStrokeSatScale01 = 0.3f;
        s.zoneStrokeBriScale01 = 0.5f;
        s.zoneStrokeScaleWithZoom = false;
        s.zoneStrokeRefZoom = 600.0f;
        s.showStructures = false;
        s.mergeStructures = true;
        s.structureSatScale01 = 1.0f;
        s.structureAlphaScale01 = 1.0f;
        s.structureShadowAlpha01 = 0.25f;
        s.structureStrokeScaleWithZoom = false;
        s.structureStrokeRefZoom = 600.0f;
        s.showLabelsArbitrary = false;
        s.showLabelsZones = false;
        s.showLabelsPaths = false;
        s.showLabelsStructures = false;
        s.labelOutlineAlpha01 = 0.3f;
        s.labelOutlineSizePx = 1.0f;
        s.labelSizeArbPx = 12.0f;
        s.labelSizeZonePx = 14.0f;
        s.labelSizePathPx = 12.0f;
        s.labelSizeStructPx = 12.0f;
        s.labelScaleWithZoom = true;
        s.labelScaleRefZoom = 600.0f;
        s.labelOutlineScaleWithZoom = true;
        s.labelFontIndex = 0;
        s.exportPaddingPct = 0.0f;
        s.antialiasing = true;
        s.activePresetIndex = 0;
        list.add(new RenderPreset("Rocky", s));
        RenderPreset[] arr = new RenderPreset[list.size()];
        list.toArray(arr);
        return arr;
    }

    public void initTooltipTexts() {
        this.TOOLTIP_TEXTS.clear();
        this.TOOLTIP_TEXTS.put("tool_cells", "Work on cells placement.");
        this.TOOLTIP_TEXTS.put("tool_elevation", "Work on topography.");
        this.TOOLTIP_TEXTS.put("tool_biomes", "Work on natural regions.");
        this.TOOLTIP_TEXTS.put("tool_zones", "Work on arbitrary administrative regions.");
        this.TOOLTIP_TEXTS.put("tool_paths", "Work on routes and rivers.");
        this.TOOLTIP_TEXTS.put("tool_structures", "Work on constructed elements.");
        this.TOOLTIP_TEXTS.put("tool_labels", "Work on additional texts.");
        this.TOOLTIP_TEXTS.put("tool_render", "Work on colors, style, display rules.");
        this.TOOLTIP_TEXTS.put("tool_export", "Export as a file.");
        this.TOOLTIP_TEXTS.put("site_density", "Number of cells to place to seed the world space.");
        this.TOOLTIP_TEXTS.put("site_fuzz", "Add random jitter to the placement.");
        this.TOOLTIP_TEXTS.put("site_mode", "Choose the placement algorithm:\n- grid: simple squares\n- poisson-disc: evenly spaced but organic\n- hexagonal: honeycomb layout.");
        this.TOOLTIP_TEXTS.put("sites_generate", "Rebuild all site seeds using the chosen parameters.");
        this.TOOLTIP_TEXTS.put("sites_keep", "Keep properties preserves properties such as biome assignement while regenerating cells.");
        this.TOOLTIP_TEXTS.put("sites_reset_all", "Clear all data: cells, zones, biomes, paths, structures, labels.");
        this.TOOLTIP_TEXTS.put("elevation_water_level", "Sets sea level.");
        this.TOOLTIP_TEXTS.put("elevation_brush_radius", "Brush radius.");
        this.TOOLTIP_TEXTS.put("elevation_brush_strength", "Brush strength.");
        this.TOOLTIP_TEXTS.put("elevation_raise", "Brush adds altitude. \nWill normalize emerged lands if maximum is exeeded.");
        this.TOOLTIP_TEXTS.put("elevation_lower", "Brush lowers altitude.  \nWill normalize submerged lands if minimum is exeeded.");
        this.TOOLTIP_TEXTS.put("elevation_noise", "Change frequency of Perlin noise when using Generate or Vary. \nHigh values = more details.");
        this.TOOLTIP_TEXTS.put("elevation_generate_perlin", "Generate terrain from Perlin noise.");
        this.TOOLTIP_TEXTS.put("elevation_vary", "Apply subtle random offsets to the current elevation.");
        this.TOOLTIP_TEXTS.put("elevation_plateau", "Create random flatter areas on the current elevation set.");
        this.TOOLTIP_TEXTS.put("biome_gen_mode", "Choose generation modes: \n- Propagation: expand seeds from every biome using a set of rules \n- Reset: fills entire map with selected biome \n- Fill gaps: replaces regions set to None by extending nearby regions \n- Replace gaps: replaces None reginos by new biomes \n- Fill under: sets cells under value threshold to selected biome \n- Fill above: sets cells above value threshold to selected biome \n- Extend: increases selected biome sizes \n- Shrink: decreases selected biome sizes \n- Spots: adds a spot of selected biome somewhere \n- Vary: move some cells around \n- Beaches : set selected biome region somewhere near coastlines \n- Full : arbitrary multiphase generation process");
        this.TOOLTIP_TEXTS.put("biome_gen_apply", "Execute the selected generation method using the chosen value.");
        this.TOOLTIP_TEXTS.put("biome_value_water", "Sync the value slider with the current sea level.");
        this.TOOLTIP_TEXTS.put("biome_paint", "Paint selected biome while dragging with the brush.");
        this.TOOLTIP_TEXTS.put("biome_fill", "Fill the clicked region with the selected biome type.");
        this.TOOLTIP_TEXTS.put("biome_add", "Add a new biome type.");
        this.TOOLTIP_TEXTS.put("biome_remove", "Remove the selected biome type.");
        this.TOOLTIP_TEXTS.put("biome_name", "Edit biome name.");
        this.TOOLTIP_TEXTS.put("biome_hue", "Adjust hue for selected biome type.");
        this.TOOLTIP_TEXTS.put("biome_brush", "Brush radius.");
        this.TOOLTIP_TEXTS.put("biome_palette", "Select this biome type.");
        this.TOOLTIP_TEXTS.put("zones_reset", "Remove all zones.");
        this.TOOLTIP_TEXTS.put("zones_regenerate", "Generated a new arrangement of zones.");
        this.TOOLTIP_TEXTS.put("zones_brush", "Brush radius.");
        this.TOOLTIP_TEXTS.put("zones_exclude_water", "Exclude water from the selected zone. \nExclude from all zones if no zone selected.");
        this.TOOLTIP_TEXTS.put("zones_exclusive", "Prevent any zone to overlap selected one. \nKeep each cell assigned to a single zone if no zone selected.");
        this.TOOLTIP_TEXTS.put("zones_four_color", "Attempt to recolor the graph so touching zones use four distinct colors. \nMight not succeed in overlapping scenarios.");
        this.TOOLTIP_TEXTS.put("zones_list_new", "Create a new zone entry.");
        this.TOOLTIP_TEXTS.put("zones_list_deselect", "Deselect any active zone.");
        this.TOOLTIP_TEXTS.put("paths_route_mode", "Route mode: \n- Ends : straight lines \n- Pathfind : terrain-aware routes");
        this.TOOLTIP_TEXTS.put("paths_flattest", "Set how much to prefer flat routes over slopes when pathfinding.");
        this.TOOLTIP_TEXTS.put("paths_avoid_water", "Avoid going through seas when pathfinding.");
        this.TOOLTIP_TEXTS.put("paths_eraser", "Remove segments by dragging the brush.");
        this.TOOLTIP_TEXTS.put("paths_list_new", "Create a new path using selected path type.");
        this.TOOLTIP_TEXTS.put("paths_list_deselect", "Deselect any path.");
        this.TOOLTIP_TEXTS.put("render_paths_bri", "Scale path brightness for rendering/export.");
        this.TOOLTIP_TEXTS.put("render_paths_sat", "Scale path saturation for rendering/export.");
        this.TOOLTIP_TEXTS.put("render_paths_show", "Toggle rendering/export of all paths.");
        this.TOOLTIP_TEXTS.put("render_light_dither", "Add slight dithering to elevation light to break banding.");
        this.TOOLTIP_TEXTS.put("render_land_h", "Adjust land hue (HSB).");
        this.TOOLTIP_TEXTS.put("render_land_s", "Adjust land saturation (HSB).");
        this.TOOLTIP_TEXTS.put("render_land_b", "Adjust land brightness (HSB).");
        this.TOOLTIP_TEXTS.put("render_water_h", "Adjust water hue (HSB).");
        this.TOOLTIP_TEXTS.put("render_water_s", "Adjust water saturation (HSB).");
        this.TOOLTIP_TEXTS.put("render_water_b", "Adjust water brightness (HSB).");
        this.TOOLTIP_TEXTS.put("render_cell_borders", "Alpha for cell borders in rendering/export.");
        this.TOOLTIP_TEXTS.put("render_noise_alpha", "Alpha of background noise texture.");
        this.TOOLTIP_TEXTS.put("render_biome_fill_alpha", "Opacity of biome fills on land.");
        this.TOOLTIP_TEXTS.put("render_biome_underwater_alpha", "Opacity of underwater biome fills.");
        this.TOOLTIP_TEXTS.put("render_biome_sat", "Scale biome saturation.");
        this.TOOLTIP_TEXTS.put("render_biome_bri", "Scale biome brightness.");
        this.TOOLTIP_TEXTS.put("render_biome_fill_type", "Choose biome fill: flat color, pattern, or pattern over color.");
        this.TOOLTIP_TEXTS.put("render_biome_outline_size", "Stroke width for biome outlines.");
        this.TOOLTIP_TEXTS.put("render_biome_outline_alpha", "Alpha for biome outlines.");
        this.TOOLTIP_TEXTS.put("render_water_depth_alpha", "Alpha for water depth shading.");
        this.TOOLTIP_TEXTS.put("render_light_alpha", "Alpha for elevation light overlay.");
        this.TOOLTIP_TEXTS.put("render_light_azimuth", "Azimuth (0-360 deg) of elevation light.");
        this.TOOLTIP_TEXTS.put("render_light_altitude", "Altitude (5-80 deg) of elevation light.");
        this.TOOLTIP_TEXTS.put("render_water_contour_size", "Stroke width for coastline outline.");
        this.TOOLTIP_TEXTS.put("render_water_ripple_count", "Number of water ripples.");
        this.TOOLTIP_TEXTS.put("render_water_ripple_dist", "Spacing between water ripples (px).");
        this.TOOLTIP_TEXTS.put("render_water_contour_h", "Water contour hue.");
        this.TOOLTIP_TEXTS.put("render_water_contour_s", "Water contour saturation.");
        this.TOOLTIP_TEXTS.put("render_water_contour_b", "Water contour brightness.");
        this.TOOLTIP_TEXTS.put("render_water_coast_alpha", "Alpha for immediate coastline stroke.");
        this.TOOLTIP_TEXTS.put("render_water_hatch_angle", "Angle for water hatching lines.");
        this.TOOLTIP_TEXTS.put("render_water_hatch_length", "Length of water hatching lines.");
        this.TOOLTIP_TEXTS.put("render_water_hatch_spacing", "Spacing of water hatching lines.");
        this.TOOLTIP_TEXTS.put("render_water_hatch_alpha", "Alpha of water hatching lines.");
        this.TOOLTIP_TEXTS.put("render_water_ripple_alpha_start", "Alpha near shore ripple.");
        this.TOOLTIP_TEXTS.put("render_water_ripple_alpha_end", "Alpha for farthest ripple.");
        this.TOOLTIP_TEXTS.put("render_elev_lines_count", "Number of elevation contour lines.");
        this.TOOLTIP_TEXTS.put("render_elev_lines_alpha", "Alpha of elevation contour lines.");
        this.TOOLTIP_TEXTS.put("render_zone_alpha", "Alpha of zone outlines.");
        this.TOOLTIP_TEXTS.put("render_zone_size", "Stroke width of zone outlines.");
        this.TOOLTIP_TEXTS.put("render_zone_sat", "Zone outline saturation scale.");
        this.TOOLTIP_TEXTS.put("render_zone_bri", "Zone outline brightness scale.");
        this.TOOLTIP_TEXTS.put("render_struct_show", "Toggle rendering/export of structures.");
        this.TOOLTIP_TEXTS.put("render_struct_merge", "Merge structures (if supported).");
        this.TOOLTIP_TEXTS.put("render_struct_shadow", "Alpha of structure shadows.");
        this.TOOLTIP_TEXTS.put("render_labels_arbitrary", "Toggle arbitrary labels in rendering/export.");
        this.TOOLTIP_TEXTS.put("render_labels_zones", "Toggle zone labels in rendering/export.");
        this.TOOLTIP_TEXTS.put("render_labels_paths", "Toggle path labels in rendering/export.");
        this.TOOLTIP_TEXTS.put("render_labels_structures", "Toggle structure labels in rendering/export.");
        this.TOOLTIP_TEXTS.put("render_labels_size_arbitrary", "Pixel size for arbitrary labels in rendering/export.");
        this.TOOLTIP_TEXTS.put("render_labels_size_zone", "Pixel size for zone labels in rendering/export.");
        this.TOOLTIP_TEXTS.put("render_labels_size_path", "Pixel size for path labels in rendering/export.");
        this.TOOLTIP_TEXTS.put("render_labels_size_struct", "Pixel size for structure labels in rendering/export.");
        this.TOOLTIP_TEXTS.put("render_labels_font", "Font used for all labels in rendering/export.");
        this.TOOLTIP_TEXTS.put("render_labels_outline", "Alpha of label outlines.");
        this.TOOLTIP_TEXTS.put("render_labels_outline_size", "Pixel size of label outlines.");
        this.TOOLTIP_TEXTS.put("render_export_padding", "Padding ratio used for render/export crops.");
        this.TOOLTIP_TEXTS.put("render_antialias", "Toggle antialiasing for rendering/export.");
        this.TOOLTIP_TEXTS.put("render_preset_apply", "Apply the selected render preset.");
        this.TOOLTIP_TEXTS.put("paths_type_add", "Add another path type palette entry.");
        this.TOOLTIP_TEXTS.put("paths_type_remove", "Remove the selected path type. \nExisting paths keep their parameters.");
        this.TOOLTIP_TEXTS.put("paths_palette", "Select a path type preset.");
        this.TOOLTIP_TEXTS.put("paths_type_name", "Edit name of active path type.");
        this.TOOLTIP_TEXTS.put("paths_type_hue", "Set hue for the active path type.");
        this.TOOLTIP_TEXTS.put("paths_type_weight", "Set stroke width for active path type.");
        this.TOOLTIP_TEXTS.put("paths_min_weight", "Clamp how thin the tapered path can become.");
        this.TOOLTIP_TEXTS.put("paths_taper", "End of path touching the sea will appear with a bigger stroke width than the other end.");
        this.TOOLTIP_TEXTS.put("paths_generate", "Auto-generate rivers, roads, and bridges.");
        this.TOOLTIP_TEXTS.put("snap_water", "Snap to sea when placing new structures.");
        this.TOOLTIP_TEXTS.put("snap_biomes", "Snap to frontiers bewteen biomes when placing new structures.");
        this.TOOLTIP_TEXTS.put("snap_underwater_biomes", "Snap to underwater biomes when placing new structures.");
        this.TOOLTIP_TEXTS.put("snap_zones", "Snap to zone lines when placing new structures.");
        this.TOOLTIP_TEXTS.put("snap_paths", "Snap to paths when placing new structures.");
        this.TOOLTIP_TEXTS.put("snap_structures", "Snap to other structures when placing new structures.");
        this.TOOLTIP_TEXTS.put("snap_elevation", "Snap to the elevation contours defined by the divisions slider.");
        this.TOOLTIP_TEXTS.put("snap_elevation_divisions", "Number of elevation grid lines for snapping.");
        this.TOOLTIP_TEXTS.put("structures_size", "Structure size of upcoming structures.");
        this.TOOLTIP_TEXTS.put("structures_angle", "Angle offset for placed structure.");
        this.TOOLTIP_TEXTS.put("structures_ratio", "Ratio bewteen vertical and horizontal dimensions, when applicable.");
        this.TOOLTIP_TEXTS.put("structures_shape", "Shape of upcoming structures.");
        this.TOOLTIP_TEXTS.put("structures_snap_mode", "Define how structures are snapped: \n- none : no snapping \n- next : like houses next to a road \n- center : right in the middle of snapping guide");
        this.TOOLTIP_TEXTS.put("structures_deselect", "Deselect any selected structure.");
        this.TOOLTIP_TEXTS.put("structures_detail_name", "Click to rename selected structure.");
        this.TOOLTIP_TEXTS.put("structures_detail_size", "Selected structure's size.");
        this.TOOLTIP_TEXTS.put("structures_detail_angle", "Selected structure's angle.");
        this.TOOLTIP_TEXTS.put("structures_detail_hue", "Selected structure hue.");
        this.TOOLTIP_TEXTS.put("structures_detail_alpha", "Selected structure transparency.");
        this.TOOLTIP_TEXTS.put("structures_detail_sat", "Selected structure saturation.");
        this.TOOLTIP_TEXTS.put("structures_detail_stroke", "Selected structure's outlines width.");
        this.TOOLTIP_TEXTS.put("labels_deselect", "Deselect currently edited label.");
        this.TOOLTIP_TEXTS.put("labels_size", "Text height.");
        this.TOOLTIP_TEXTS.put("render_preset", "Drag the slider to pick a preset and hit Apply to swap render.");
        this.TOOLTIP_TEXTS.put("export_png", "Export the current view as a PNG.");
        this.TOOLTIP_TEXTS.put("export_scale", "Multiply the output raster size.");
        this.TOOLTIP_TEXTS.put("export_map_json", "Export full map data to JSON (exports/map_latest.json).");
        this.TOOLTIP_TEXTS.put("import_map_json", "Import map data from exports/map_latest.json.");
        this.TOOLTIP_TEXTS.put("export_svg", "Export a simplified layered SVG (background, borders, paths, structures, labels, legend).");
        this.TOOLTIP_TEXTS.put("export_geojson", "Export map features (zones, paths, structures, labels) as GeoJSON FeatureCollection.");
    }

    public String tooltipFor(String key) {
        if (key == null) {
            return null;
        }
        if (key.equals("biome_gen_value")) {
            return this.tooltipForBiomeValue();
        }
        return this.TOOLTIP_TEXTS.get(key);
    }

    public String tooltipForBiomeValue() {
        int idx = Main.constrain((int)this.biomeGenerateModeIndex, (int)0, (int)(this.biomeGenerateModes.length - 1));
        switch (idx) {
            case 0: {
                return "Propagation: number of starting seeds (from few to many).";
            }
            case 1: {
                return "Reset: (no use).";
            }
            case 2: {
                return "Fill gaps: (no use).";
            }
            case 3: {
                return "Replace gaps: number of seeds scaled to empty area.";
            }
            case 4: {
                return "Fill under: sets elevation threshold.";
            }
            case 5: {
                return "Fill above: sets elevation threshold.";
            }
            case 6: {
                return "Extend: how many outward growth passes.";
            }
            case 7: {
                return "Shrink: how many erosion passes.";
            }
            case 8: {
                return "Spots: number of spots to paint.";
            }
            case 9: {
                return "Vary: strength/iterations of variation.";
            }
            case 10: {
                return "Slice spot: thickness around the chosen elevation (value slider).";
            }
            case 11: {
                return "Full: (no use).";
            }
        }
        return "Value slider meaning depends on chosen generation mode.";
    }

    public void rgbToHSB01(int c, float[] outHSB) {
        float minc;
        int r = c >> 16 & 0xFF;
        float rf = (float)r / 255.0f;
        int g = c >> 8 & 0xFF;
        float gf = (float)g / 255.0f;
        int b = c & 0xFF;
        float bf = (float)b / 255.0f;
        float maxc = Main.max((float)rf, (float)Main.max((float)gf, (float)bf));
        float delta = maxc - (minc = Main.min((float)rf, (float)Main.min((float)gf, (float)bf)));
        float h = delta < 1.0E-6f ? 0.0f : (maxc == rf ? (gf - bf) / delta % 6.0f : (maxc == gf ? (bf - rf) / delta + 2.0f : (rf - gf) / delta + 4.0f));
        if ((h /= 6.0f) < 0.0f) {
            h += 1.0f;
        }
        float s = maxc <= 0.0f ? 0.0f : delta / maxc;
        float v = maxc;
        outHSB[0] = Main.constrain((float)h, (float)0.0f, (float)1.0f);
        outHSB[1] = Main.constrain((float)s, (float)0.0f, (float)1.0f);
        outHSB[2] = Main.constrain((float)v, (float)0.0f, (float)1.0f);
    }

    public int hsb01ToARGB(float h, float s, float b, float a) {
        h = Main.constrain((float)h, (float)0.0f, (float)1.0f);
        s = Main.constrain((float)s, (float)0.0f, (float)1.0f);
        b = Main.constrain((float)b, (float)0.0f, (float)1.0f);
        a = Main.constrain((float)a, (float)0.0f, (float)1.0f);
        float hh = h * 6.0f % 6.0f;
        int sector = Main.floor((float)hh);
        float f = hh - (float)sector;
        float p = b * (1.0f - s);
        float q = b * (1.0f - s * f);
        float t = b * (1.0f - s * (1.0f - f));
        float rf = 0.0f;
        float gf = 0.0f;
        float bf = 0.0f;
        switch (sector) {
            case 0: {
                rf = b;
                gf = t;
                bf = p;
                break;
            }
            case 1: {
                rf = q;
                gf = b;
                bf = p;
                break;
            }
            case 2: {
                rf = p;
                gf = b;
                bf = t;
                break;
            }
            case 3: {
                rf = p;
                gf = q;
                bf = b;
                break;
            }
            case 4: {
                rf = t;
                gf = p;
                bf = b;
                break;
            }
            default: {
                rf = b;
                gf = p;
                bf = q;
            }
        }
        int ri = Main.constrain((int)Main.round((float)(rf * 255.0f)), (int)0, (int)255);
        int gi = Main.constrain((int)Main.round((float)(gf * 255.0f)), (int)0, (int)255);
        int bi = Main.constrain((int)Main.round((float)(bf * 255.0f)), (int)0, (int)255);
        int ai = Main.constrain((int)Main.round((float)(a * 255.0f)), (int)0, (int)255);
        return ai << 24 | ri << 16 | gi << 8 | bi;
    }

    public int hsb01ToRGB(float h, float s, float b) {
        return this.hsb01ToARGB(h, s, b, 1.0f);
    }

    public StructureAttributes structureAttributesFromStructure(Structure s) {
        StructureAttributes a = new StructureAttributes();
        if (s == null) {
            return a;
        }
        a.name = s.name;
        a.comment = s.comment;
        a.size = s.size;
        a.angleRad = s.angle;
        a.shape = s.shape;
        a.alignment = s.alignment;
        a.aspectRatio = s.aspect;
        a.hue01 = s.hue01;
        a.sat01 = s.sat01;
        a.alpha01 = s.alpha01;
        a.strokeWeightPx = s.strokeWeightPx;
        return a;
    }

    public int panelTop() {
        return this.snapPanelTop();
    }

    public int snapPanelTop() {
        return 60;
    }

    public int snapSettingsPanelHeight() {
        int h = 40;
        int rows = 7;
        h += rows * 24;
        h += 40;
        return h += 10;
    }

    public void drawPanelBackground(IntRect frame) {
        this.rectMode(0);
        this.ellipseMode(3);
        this.noStroke();
        this.fill(232);
        this.rect(frame.x, frame.y, frame.w, frame.h);
        this.stroke(255);
        this.line(frame.x, frame.y, frame.x + frame.w, frame.y);
        this.line(frame.x, frame.y, frame.x, frame.y + frame.h);
        this.stroke(120);
        this.line(frame.x, frame.y + frame.h - 1, frame.x + frame.w, frame.y + frame.h - 1);
        this.line(frame.x + frame.w - 1, frame.y, frame.x + frame.w - 1, frame.y + frame.h);
    }

    public boolean rectEquals(IntRect a, IntRect b) {
        return a != null && b != null && a.x == b.x && a.y == b.y && a.w == b.w && a.h == b.h;
    }

    public boolean queueButtonAction(IntRect rect, Runnable action) {
        if (rect == null || action == null) {
            return false;
        }
        if (!rect.contains(this.mouseX, this.mouseY)) {
            return false;
        }
        this.pressedButtonRect = new IntRect(rect.x, rect.y, rect.w, rect.h);
        this.pendingButtonAction = action;
        return true;
    }

    public boolean isButtonHeld(IntRect rect) {
        if (rect == null || this.pressedButtonRect == null) {
            return false;
        }
        if (!this.rectEquals(rect, this.pressedButtonRect)) {
            return false;
        }
        return this.pressedButtonRect.contains(this.mouseX, this.mouseY);
    }

    public void runPendingButtonAction(int mx, int my) {
        if (this.pendingButtonAction != null && this.pressedButtonRect != null && this.pressedButtonRect.contains(mx, my)) {
            this.pendingButtonAction.run();
        }
        this.pressedButtonRect = null;
        this.pendingButtonAction = null;
    }

    public float clampScroll(float scroll, float contentH, float viewH) {
        float maxScroll = Main.max((float)0.0f, (float)(contentH - viewH));
        return Main.constrain((float)scroll, (float)0.0f, (float)maxScroll);
    }

    public void drawScrollbar(IntRect track, float contentH, float scroll) {
        if (track == null || track.h <= 0) {
            return;
        }
        boolean active = contentH > (float)track.h;
        this.noStroke();
        this.fill(active ? 214 : 200);
        this.rect(track.x, track.y, track.w, track.h);
        this.stroke(255);
        this.line(track.x, track.y, track.x + track.w, track.y);
        this.line(track.x, track.y, track.x, track.y + track.h);
        this.stroke(96);
        this.line(track.x, track.y + track.h - 1, track.x + track.w, track.y + track.h - 1);
        this.line(track.x + track.w - 1, track.y, track.x + track.w - 1, track.y + track.h);
        if (!active) {
            return;
        }
        int inset = 2;
        int thumbH = Main.max((int)24, (int)Main.round((float)((float)(track.h * track.h) / contentH)));
        thumbH = Main.min((int)thumbH, (int)(track.h - inset * 2));
        float travel = track.h - inset * 2 - thumbH;
        float maxScroll = Main.max((float)0.001f, (float)(contentH - (float)track.h));
        int thumbY = track.y + inset + Main.round((float)(scroll / maxScroll * travel));
        IntRect thumb = new IntRect(track.x + inset, thumbY, track.w - inset * 2, thumbH);
        this.noStroke();
        this.fill(205);
        this.rect(thumb.x, thumb.y, thumb.w, thumb.h);
        this.stroke(255);
        this.line(thumb.x, thumb.y, thumb.x + thumb.w, thumb.y);
        this.line(thumb.x, thumb.y, thumb.x, thumb.y + thumb.h);
        this.stroke(96);
        this.line(thumb.x, thumb.y + thumb.h - 1, thumb.x + thumb.w, thumb.y + thumb.h - 1);
        this.line(thumb.x + thumb.w - 1, thumb.y, thumb.x + thumb.w - 1, thumb.y + thumb.h);
    }

    public void drawTopBar() {
        boolean showLoad;
        int topBarH = 34;
        this.noStroke();
        this.fill(202);
        this.rect(0.0f, 0.0f, this.width, topBarH);
        this.stroke(255);
        this.line(0.0f, 0.0f, this.width, 0.0f);
        this.line(0.0f, 0.0f, 0.0f, topBarH);
        this.stroke(96);
        this.line(0.0f, topBarH - 1, this.width, topBarH - 1);
        this.line(this.width - 1, 0.0f, this.width - 1, topBarH);
        this.fill(10);
        this.textAlign(37, 3);
        String info1 = "Tool: " + (Object)((Object)this.currentTool) + "   Zoom: " + Main.nf((float)this.viewport.zoom, (int)1, (int)2) + "   Center: (" + Main.nf((float)this.viewport.centerX, (int)1, (int)3) + ", " + Main.nf((float)this.viewport.centerY, (int)1, (int)3) + ")";
        int siteCount = this.mapModel != null && this.mapModel.sites != null ? this.mapModel.sites.size() : 0;
        int cellCount = this.mapModel != null && this.mapModel.cells != null ? this.mapModel.cells.size() : 0;
        int pathCount = this.mapModel != null && this.mapModel.paths != null ? this.mapModel.paths.size() : 0;
        int pathSegs = 0;
        if (this.mapModel != null && this.mapModel.paths != null) {
            for (Path p : this.mapModel.paths) {
                if (p == null) continue;
                pathSegs += p.segmentCount();
            }
        }
        String info2 = "FPS: " + Main.nf((float)this.frameRate, (int)1, (int)1) + "   Sites: " + siteCount + "   Cells: " + cellCount + "   Paths: " + pathCount + " (" + pathSegs + " segs)";
        if (this.mapModel != null) {
            info2 = String.valueOf(info2) + "   Snap: " + this.mapModel.lastSnapNodeCount + "n/" + this.mapModel.lastSnapEdgeCount + "e (" + Main.nf((float)this.mapModel.lastSnapBuildMs, (int)1, (int)1) + "ms)";
            info2 = String.valueOf(info2) + "   Pathfind: " + Main.nf((float)this.mapModel.lastPathfindMs, (int)1, (int)1) + "ms " + "[" + this.mapModel.lastPathfindExpanded + " expanded, len " + this.mapModel.lastPathfindLength + (this.mapModel.lastPathfindHit ? "" : ", miss") + "]";
        }
        this.text(info1, 10.0f, (float)topBarH / 2.0f - 7.0f);
        this.text(info2, 10.0f, (float)topBarH / 2.0f + 7.0f);
        boolean bl = showLoad = this.progressActive || this.isLoading;
        if (this.uiNoticeFrames > 0 && this.uiNotice != null && this.uiNotice.length() > 0) {
            this.setProgressStatus(this.uiNotice);
            --this.uiNoticeFrames;
        } else if (this.uiNoticeFrames == 0 && this.uiNotice != null && this.uiNotice.length() > 0) {
            if (!showLoad && this.progressStatusMsg != null && this.progressStatusMsg.equals(this.uiNotice)) {
                this.setProgressStatus("");
            }
            this.uiNotice = "";
        }
        if (showLoad || this.progressStatusMsg != null && this.progressStatusMsg.length() > 0) {
            float pct;
            if (showLoad) {
                this.loadingPhase += 0.02f;
            }
            float barW = 120.0f;
            float barH = 10.0f;
            float x = (float)this.width - barW - 12.0f;
            float y = ((float)topBarH - barH) / 2.0f;
            this.stroke(80);
            this.fill(235);
            this.rect(x, y, barW, barH, 3.0f);
            this.noStroke();
            float f = pct = this.progressActive ? Main.constrain((float)this.progressPct, (float)0.0f, (float)1.0f) : this.loadingPct;
            if (showLoad) {
                pct = Main.max((float)pct, (float)(Main.sin((float)this.loadingPhase) * 0.05f + 0.05f));
            }
            float w = barW * pct;
            this.fill(60.0f, 140.0f, 220.0f);
            this.rect(x + 1.0f, y + 1.0f, w - 2.0f, barH - 2.0f, 2.0f);
            String detail = null;
            if (this.progressActive && this.progressDetail != null && this.progressDetail.length() > 0) {
                detail = this.progressDetail;
            } else if (this.progressStatusMsg != null && this.progressStatusMsg.length() > 0) {
                detail = this.progressStatusMsg;
            }
            if (detail != null && detail.length() > 0) {
                this.fill(20);
                this.textAlign(39, 3);
                this.text(detail, x - 8.0f, y + barH * 0.5f);
            }
        }
    }

    public void drawToolButtons() {
        int barY = 34;
        int barH = 26;
        int margin = 10;
        int buttonW = 90;
        this.noStroke();
        this.fill(245);
        this.rect(0.0f, barY, this.width, barH);
        this.stroke(255);
        this.line(0.0f, barY, this.width, barY);
        this.line(0.0f, barY, 0.0f, barY + barH);
        this.stroke(100);
        this.line(this.width - 1, barY, this.width - 1, barY + barH);
        String[] labels = new String[]{"Cells", "Elevation", "Biomes", "Zones", "Paths", "Structures", "Labels", "Rendering", "Export"};
        Tool[] tools = new Tool[]{Tool.EDIT_SITES, Tool.EDIT_ELEVATION, Tool.EDIT_BIOMES, Tool.EDIT_ZONES, Tool.EDIT_PATHS, Tool.EDIT_STRUCTURES, Tool.EDIT_LABELS, Tool.EDIT_RENDER, Tool.EDIT_EXPORT};
        int i = 0;
        while (i < labels.length) {
            int x = margin + i * (buttonW + 5);
            int y = barY + 2;
            IntRect rect = new IntRect(x, y, buttonW, barH - 4);
            boolean active = this.currentTool == tools[i];
            this.drawTabButton(rect, active);
            this.fill(20);
            this.textAlign(3, 3);
            this.text(labels[i], x + buttonW / 2, y + (barH - 4) / 2);
            String key = "tool_" + labels[i].toLowerCase();
            this.registerUiTooltip(rect, this.tooltipFor(key));
            ++i;
        }
    }

    public int hintHeight(int lines) {
        if (lines <= 0) {
            return 0;
        }
        return 12 + 16 * lines + 6;
    }

    public SnapSettingsLayout buildSnapSettingsLayout() {
        SnapSettingsLayout l = new SnapSettingsLayout();
        l.panel = new IntRect(0, this.snapPanelTop(), 320, this.snapSettingsPanelHeight());
        int innerX = l.panel.x + 10;
        int curY = l.panel.y + 10;
        String[] labels = new String[]{"Water", "Biomes", "Underwater biomes", "Zones", "Paths", "Other structures", "Elevation"};
        curY += 30;
        int i = 0;
        while (i < labels.length) {
            l.checks.add(new IntRect(innerX, curY, 16, 16));
            curY += 24;
            ++i;
        }
        l.elevationSlider = new IntRect(innerX + 16 + 8, curY + 14, 160, 16);
        return l;
    }

    public void drawSnapSettingsPanel() {
        SnapSettingsLayout l = this.buildSnapSettingsLayout();
        this.drawPanelBackground(l.panel);
        int labelX = l.panel.x + 10;
        this.fill(0);
        this.textAlign(37, 101);
        this.text("Snap targets", labelX, l.panel.y + 10);
        String[] labels = new String[]{"Water", "Biomes", "Underwater biomes", "Zones", "Paths", "Other structures", "Elevation"};
        String[] snapKeys = new String[]{"snap_water", "snap_biomes", "snap_underwater_biomes", "snap_zones", "snap_paths", "snap_structures", "snap_elevation"};
        boolean[] values = new boolean[]{this.snapWaterEnabled, this.snapBiomesEnabled, this.snapUnderwaterBiomesEnabled, this.snapZonesEnabled, this.snapPathsEnabled, this.snapStructuresEnabled, this.snapElevationEnabled};
        int i = 0;
        while (i < labels.length) {
            IntRect b = l.checks.get(i);
            this.drawCheckbox(b.x, b.y, b.w, values[i], labels[i]);
            if (i < snapKeys.length) {
                int hintW = l.panel.w - 20;
                this.registerUiTooltip(new IntRect(b.x, b.y, hintW, b.h), this.tooltipFor(snapKeys[i]));
            }
            ++i;
        }
        IntRect es = l.elevationSlider;
        int divMin = 2;
        int divMax = 24;
        float t = Main.constrain((float)((float)(this.snapElevationDivisions - divMin) / (float)(divMax - divMin)), (float)0.0f, (float)1.0f);
        this.drawSlider(es, t, "Elevation divisions: " + this.snapElevationDivisions);
        this.registerUiTooltip(es, this.tooltipFor("snap_elevation_divisions"));
    }

    public boolean isInSnapSettingsPanel(int mx, int my) {
        SnapSettingsLayout l = this.buildSnapSettingsLayout();
        return l.panel.contains(mx, my);
    }

    public SitesLayout buildSitesLayout() {
        int curY;
        SitesLayout l = new SitesLayout();
        l.panel = new IntRect(0, this.panelTop(), 320, 0);
        int innerX = l.panel.x + 10;
        l.titleY = curY = l.panel.y + 10;
        l.resetBtn = new IntRect(innerX, curY += 30, 110, 22);
        l.generateBtn = new IntRect(innerX, curY += 30, 110, 22);
        l.keepCheckbox = new IntRect(l.generateBtn.x + l.generateBtn.w + 12, curY + 3, 16, 16);
        l.fullGenerateBtn = new IntRect(innerX, curY += 30, 180, 22);
        int sliderW = 200;
        l.densitySlider = new IntRect(innerX, (curY += 34) + 14, sliderW, 16);
        l.fuzzSlider = new IntRect(innerX, (curY += 38) + 14, sliderW, 16);
        l.modeSlider = new IntRect(innerX, (curY += 38) + 14, sliderW, 16);
        curY += 42;
        l.panel.h = (curY += 10 + this.hintHeight(4)) - l.panel.y;
        return l;
    }

    public void drawSitesPanel() {
        SitesLayout layout = this.buildSitesLayout();
        this.drawPanelBackground(layout.panel);
        int labelX = layout.panel.x + 10;
        this.fill(0);
        this.textAlign(37, 101);
        this.text("Cells generation", labelX, layout.titleY);
        IntRect r = layout.resetBtn;
        this.drawBevelButton(r.x, r.y, r.w, r.h, false);
        this.fill(10);
        this.textAlign(3, 3);
        this.text("Reset all", r.x + r.w / 2, r.y + r.h / 2);
        this.registerUiTooltip(r, this.tooltipFor("sites_reset_all"));
        IntRect d = layout.densitySlider;
        float density01 = Main.constrain((float)((float)this.siteTargetCount / 50000.0f), (float)0.0f, (float)1.0f);
        this.drawSlider(d, density01, "Density: " + this.siteTargetCount + " cells");
        this.registerUiTooltip(d, this.tooltipFor("site_density"));
        IntRect f = layout.fuzzSlider;
        float fuzzNorm = this.siteFuzz <= 0.0f ? 0.0f : Main.constrain((float)(this.siteFuzz / 0.3f), (float)0.0f, (float)1.0f);
        this.drawSlider(f, fuzzNorm, "Fuzz: " + Main.nf((float)this.siteFuzz, (int)1, (int)2) + " (0 = none, 0.3 = strong jitter)");
        this.registerUiTooltip(f, this.tooltipFor("site_fuzz"));
        IntRect m = layout.modeSlider;
        int modeCount = this.placementModes.length;
        if (modeCount < 1) {
            modeCount = 1;
        }
        String modeName = this.placementModeLabel(this.currentPlacementMode());
        float tMode = Main.constrain((float)((float)this.placementModeIndex / Main.max((float)1.0f, (float)((float)modeCount - 1.0f))), (float)0.0f, (float)1.0f);
        this.drawSelectorSlider(m, tMode, "Placement: " + modeName, modeCount);
        this.registerUiTooltip(m, this.tooltipFor("site_mode"));
        IntRect g = layout.generateBtn;
        this.drawBevelButton(g.x, g.y, g.w, g.h, false);
        this.fill(10);
        this.textAlign(3, 3);
        this.text("Generate", g.x + g.w / 2, g.y + g.h / 2);
        this.registerUiTooltip(g, this.tooltipFor("sites_generate"));
        IntRect fg = layout.fullGenerateBtn;
        this.drawBevelButton(fg.x, fg.y, fg.w, fg.h, false);
        this.fill(10);
        this.textAlign(3, 3);
        this.text("Generate everything from there", fg.x + fg.w / 2, fg.y + fg.h / 2);
        this.registerUiTooltip(fg, "Run a full pipeline: elevation, plateaux, biomes, zones, paths, structures, labels.");
        IntRect c = layout.keepCheckbox;
        this.stroke(80);
        this.fill(this.keepPropertiesOnGenerate ? 200 : 240);
        this.rect(c.x, c.y, c.w, c.h);
        if (this.keepPropertiesOnGenerate) {
            this.line(c.x + 3, c.y + c.h / 2, c.x + c.w / 2, c.y + c.h - 3);
            this.line(c.x + c.w / 2, c.y + c.h - 3, c.x + c.w - 3, c.y + 3);
        }
        this.fill(0);
        this.textAlign(37, 3);
        this.text("Keep properties", c.x + c.w + 6, g.y + g.h / 2);
        this.registerUiTooltip(new IntRect(c.x, c.y, c.w + 120, c.h), this.tooltipFor("sites_keep"));
        this.drawControlsHint(layout.panel, "right-click: pan", "wheel: zoom", "drag: drag", "DEL: remove selected");
    }

    public BiomesLayout buildBiomesLayout() {
        int curY;
        BiomesLayout l = new BiomesLayout();
        l.panel = new IntRect(0, this.panelTop(), 320, 0);
        int innerX = l.panel.x + 10;
        l.titleY = curY = l.panel.y + 10;
        int selectorW = 200;
        l.genModeSelector = new IntRect(innerX, (curY += 30) + 14, selectorW, 16);
        l.genApplyBtn = new IntRect(l.genModeSelector.x + l.genModeSelector.w + 10, curY + 14 - 2, 90, 22);
        l.genValueSlider = new IntRect(innerX, (curY += 38) + 14, selectorW, 16);
        l.genValueWaterBtn = new IntRect(l.genValueSlider.x + l.genValueSlider.w + 10, curY + 14 - 2, 80, 22);
        l.paintBtn = new IntRect(innerX, curY += 42, 70, 22);
        l.fillBtn = new IntRect(l.paintBtn.x + l.paintBtn.w + 8, curY, 70, 22);
        l.addBtn = new IntRect(innerX, curY += 34, 24, 22);
        l.removeBtn = new IntRect(l.addBtn.x + l.addBtn.w + 6, curY, 24, 22);
        int swatchW = 70;
        int swatchH = 22;
        int gapX = 8;
        int maxPerRow = Main.max((int)1, (int)((300 + gapX) / (swatchW + gapX)));
        int rowY = curY += 34;
        int col = 0;
        int paletteBottom = rowY;
        if (this.mapModel != null && this.mapModel.biomeTypes != null) {
            int i = 0;
            while (i < this.mapModel.biomeTypes.size()) {
                int x = innerX + col * (swatchW + gapX);
                l.swatches.add(new IntRect(x, rowY, swatchW, swatchH));
                paletteBottom = Main.max((int)paletteBottom, (int)(rowY + swatchH));
                if (++col >= maxPerRow) {
                    col = 0;
                    rowY += swatchH + 8;
                }
                ++i;
            }
        }
        curY = paletteBottom + 8;
        l.nameField = new IntRect(innerX, curY + 14, 200, 22);
        l.hueSlider = new IntRect(innerX, (curY += 48) + 14, 200, 16);
        l.satSlider = new IntRect(innerX, (curY += 38) + 14, 200, 16);
        l.briSlider = new IntRect(innerX, (curY += 38) + 14, 200, 16);
        l.patternSlider = new IntRect(innerX, (curY += 42) + 14, 200, 16);
        l.brushSlider = new IntRect(innerX, (curY += 42) + 14, 180, 16);
        curY += 40;
        l.panel.h = (curY += this.hintHeight(3)) - l.panel.y;
        return l;
    }

    public void drawBiomesPanel() {
        BiomesLayout layout = this.buildBiomesLayout();
        this.drawPanelBackground(layout.panel);
        int labelX = layout.panel.x + 10;
        this.fill(0);
        this.textAlign(37, 101);
        this.text("Biomes", labelX, layout.titleY);
        IntRect gsel = layout.genModeSelector;
        int modeCount = this.biomeGenerateModes.length;
        int maxIdx = Main.max((int)1, (int)(modeCount - 1));
        float tMode = Main.constrain((float)((float)this.biomeGenerateModeIndex / (float)maxIdx), (float)0.0f, (float)1.0f);
        String modeName = this.biomeGenerateModes[Main.constrain((int)this.biomeGenerateModeIndex, (int)0, (int)(modeCount - 1))];
        this.drawSelectorSlider(gsel, tMode, "Generation mode: " + modeName, modeCount);
        this.registerUiTooltip(gsel, this.tooltipFor("biome_gen_mode"));
        if (layout.genApplyBtn != null) {
            this.drawBevelButton(layout.genApplyBtn.x, layout.genApplyBtn.y, layout.genApplyBtn.w, layout.genApplyBtn.h, false);
            this.fill(10);
            this.textAlign(3, 3);
            this.text("Generate", layout.genApplyBtn.x + layout.genApplyBtn.w / 2, layout.genApplyBtn.y + layout.genApplyBtn.h / 2);
            this.registerUiTooltip(layout.genApplyBtn, this.tooltipFor("biome_gen_apply"));
        }
        IntRect gv = layout.genValueSlider;
        this.drawSlider(gv, Main.constrain((float)this.biomeGenerateValue01, (float)0.0f, (float)1.0f), "Value (" + Main.nf((float)this.biomeGenerateValue01, (int)1, (int)2) + ")");
        this.registerUiTooltip(gv, this.tooltipFor("biome_gen_value"));
        if (layout.genValueWaterBtn != null) {
            this.drawBevelButton(layout.genValueWaterBtn.x, layout.genValueWaterBtn.y, layout.genValueWaterBtn.w, layout.genValueWaterBtn.h, false);
            this.fill(10);
            this.textAlign(3, 3);
            this.text("Set to water", layout.genValueWaterBtn.x + layout.genValueWaterBtn.w / 2, layout.genValueWaterBtn.y + layout.genValueWaterBtn.h / 2);
            this.registerUiTooltip(layout.genValueWaterBtn, this.tooltipFor("biome_value_water"));
        }
        this.drawBevelButton(layout.paintBtn.x, layout.paintBtn.y, layout.paintBtn.w, layout.paintBtn.h, this.currentBiomePaintMode == ZonePaintMode.ZONE_PAINT);
        this.fill(10);
        this.textAlign(3, 3);
        this.text("Paint", (float)layout.paintBtn.x + (float)layout.paintBtn.w * 0.5f, (float)layout.paintBtn.y + (float)layout.paintBtn.h * 0.5f);
        this.registerUiTooltip(layout.paintBtn, this.tooltipFor("biome_paint"));
        this.drawBevelButton(layout.fillBtn.x, layout.fillBtn.y, layout.fillBtn.w, layout.fillBtn.h, this.currentBiomePaintMode == ZonePaintMode.ZONE_FILL);
        this.fill(10);
        this.textAlign(3, 3);
        this.text("Fill", (float)layout.fillBtn.x + (float)layout.fillBtn.w * 0.5f, (float)layout.fillBtn.y + (float)layout.fillBtn.h * 0.5f);
        this.registerUiTooltip(layout.fillBtn, this.tooltipFor("biome_fill"));
        this.drawBevelButton(layout.addBtn.x, layout.addBtn.y, layout.addBtn.w, layout.addBtn.h, false);
        this.fill(10);
        this.textAlign(3, 3);
        this.text("+", (float)layout.addBtn.x + (float)layout.addBtn.w * 0.5f, (float)layout.addBtn.y + (float)layout.addBtn.h * 0.5f);
        this.registerUiTooltip(layout.addBtn, this.tooltipFor("biome_add"));
        boolean canRemove = this.mapModel.biomeTypes != null && this.mapModel.biomeTypes.size() > 1 && this.activeBiomeIndex > 0;
        this.drawBevelButton(layout.removeBtn.x, layout.removeBtn.y, layout.removeBtn.w, layout.removeBtn.h, !canRemove);
        this.fill(10);
        this.textAlign(3, 3);
        this.text("-", (float)layout.removeBtn.x + (float)layout.removeBtn.w * 0.5f, (float)layout.removeBtn.y + (float)layout.removeBtn.h * 0.5f);
        this.registerUiTooltip(layout.removeBtn, this.tooltipFor("biome_remove"));
        if (this.mapModel == null || this.mapModel.biomeTypes == null) {
            return;
        }
        int n = this.mapModel.biomeTypes.size();
        if (n == 0) {
            return;
        }
        int i = 0;
        while (i < n) {
            this.pushStyle();
            ZoneType zt = this.mapModel.biomeTypes.get(i);
            IntRect sw = layout.swatches.get(i);
            this.stroke(i == this.activeBiomeIndex ? 0 : 120);
            this.strokeWeight(i == this.activeBiomeIndex ? 2 : 1);
            this.fill(zt.col);
            this.rect(sw.x, sw.y, sw.w, sw.h, 4.0f);
            this.fill(20);
            this.textAlign(3, 3);
            this.text(zt.name, (float)sw.x + (float)sw.w * 0.5f, (float)sw.y + (float)sw.h * 0.5f);
            this.registerUiTooltip(sw, this.tooltipFor("biome_palette"));
            this.popStyle();
            ++i;
        }
        if (this.activeBiomeIndex >= 0 && this.activeBiomeIndex < n) {
            IntRect nf = layout.nameField;
            ZoneType active = this.mapModel.biomeTypes.get(this.activeBiomeIndex);
            boolean editing = this.editingBiomeNameIndex == this.activeBiomeIndex;
            this.fill(0);
            this.textAlign(37, 102);
            this.text("Name", nf.x, nf.y - 4);
            this.stroke(80);
            this.fill(255);
            this.rect(nf.x, nf.y, nf.w, nf.h);
            this.fill(0);
            this.textAlign(37, 3);
            String shown = editing ? this.biomeNameDraft : active.name;
            this.text(shown, nf.x + 6, nf.y + nf.h / 2);
            if (editing) {
                float caretX = (float)(nf.x + 6) + this.textWidth(this.biomeNameDraft);
                this.stroke(0);
                this.line(caretX, nf.y + 4, caretX, nf.y + nf.h - 4);
            }
            this.registerUiTooltip(nf, this.tooltipFor("biome_name"));
        }
        if (this.activeBiomeIndex >= 0 && this.activeBiomeIndex < n) {
            ZoneType active = this.mapModel.biomeTypes.get(this.activeBiomeIndex);
            IntRect hue = layout.hueSlider;
            float hNorm = Main.constrain((float)active.hue01, (float)0.0f, (float)1.0f);
            this.drawSlider(hue, hNorm, "Hue for \"" + active.name + "\": " + Main.nf((float)active.hue01, (int)1, (int)2));
            this.registerUiTooltip(hue, this.tooltipFor("biome_hue"));
            if (layout.satSlider != null) {
                float sNorm = Main.constrain((float)active.sat01, (float)0.0f, (float)1.0f);
                this.drawSlider(layout.satSlider, sNorm, "Saturation for \"" + active.name + "\"");
            }
            if (layout.briSlider != null) {
                float bNorm = Main.constrain((float)active.bri01, (float)0.0f, (float)1.0f);
                this.drawSlider(layout.briSlider, bNorm, "Brightness for \"" + active.name + "\"");
            }
            if (layout.patternSlider != null && this.mapModel != null) {
                int patCount = Main.max((int)1, (int)this.mapModel.biomePatternCount);
                int clamped = (active.patternIndex % patCount + patCount) % patCount;
                String fallbackPat = this.renderSettings.biomePatternName;
                if (!(fallbackPat != null && fallbackPat.length() != 0 || this.mapModel.biomePatternFiles == null || this.mapModel.biomePatternFiles.isEmpty())) {
                    fallbackPat = this.mapModel.biomePatternFiles.get(0);
                }
                String patName = this.mapModel.biomePatternNameForIndex(clamped, fallbackPat);
                float pNorm = patCount > 1 ? (float)clamped / (float)(patCount - 1) : 0.0f;
                this.drawSelectorSlider(layout.patternSlider, pNorm, "Pattern: " + patName, patCount);
            }
        }
        IntRect brush = layout.brushSlider;
        float bNorm = Main.constrain((float)Main.map((float)this.zoneBrushRadius, (float)0.01f, (float)0.15f, (float)0.0f, (float)1.0f), (float)0.0f, (float)1.0f);
        this.drawSlider(brush, bNorm, "Brush radius");
        this.drawControlsHint(layout.panel, "left-click: paint/fill", "right-click: pan", "wheel: zoom.");
    }

    public ZonesListLayout buildZonesListLayout() {
        ZonesListLayout l = new ZonesListLayout();
        int w = 260;
        int x = this.width - w - 10;
        int y = this.panelTop();
        l.panel = new IntRect(x, y, w, this.height - y - 10);
        l.titleY = y + 10;
        int btnY = l.titleY + 18 + 12;
        l.deselectBtn = new IntRect(x + 10, btnY, 90, 22);
        l.newBtn = new IntRect(l.deselectBtn.x + l.deselectBtn.w + 8, btnY, 90, 22);
        return l;
    }

    public void populateZonesRows(ZonesListLayout layout) {
        layout.rows.clear();
        if (this.mapModel == null || this.mapModel.zones == null) {
            return;
        }
        int labelX = layout.panel.x + 10;
        int startY = layout.newBtn.y + layout.newBtn.h + 12;
        int maxY = layout.panel.y + layout.panel.h - 12;
        int viewH = Main.max((int)0, (int)(maxY - startY));
        int rowH = 28;
        int rowGap = 6;
        int hueW = 90;
        int totalRows = this.mapModel.zones.size();
        int contentH = totalRows > 0 ? totalRows * (rowH + rowGap) - rowGap : 0;
        layout.rowsStartY = startY;
        layout.rowsViewH = viewH;
        layout.contentH = contentH;
        layout.scrollbar = new IntRect(layout.panel.x + layout.panel.w - 14, startY, 14, viewH);
        this.zonesListScroll = this.clampScroll(this.zonesListScroll, contentH, viewH);
        int curY = startY - Main.round((float)this.zonesListScroll);
        int i = 0;
        while (i < totalRows) {
            if (curY > maxY) break;
            if (curY + rowH < startY) {
                curY += rowH + rowGap;
            } else {
                ZoneRowLayout row = new ZoneRowLayout();
                row.index = i;
                int selectW = 18;
                row.selectRect = new IntRect(labelX, curY, selectW, rowH);
                row.nameRect = new IntRect(labelX + selectW + 6, curY, layout.panel.w - 20 - 14 - selectW - 6 - hueW - 8, rowH);
                int colorH = 6;
                row.colorRect = new IntRect(row.nameRect.x, row.nameRect.y + row.nameRect.h - colorH - 2, row.nameRect.w, colorH);
                row.hueSlider = new IntRect(row.nameRect.x + row.nameRect.w + 6, curY + (rowH - 16) / 2, hueW, 16);
                layout.rows.add(row);
                curY += rowH + rowGap;
            }
            ++i;
        }
    }

    public void drawZonesListPanel() {
        ZonesListLayout layout = this.buildZonesListLayout();
        this.populateZonesRows(layout);
        this.drawPanelBackground(layout.panel);
        int labelX = layout.panel.x + 10;
        int curY = layout.titleY;
        this.fill(0);
        this.textAlign(37, 101);
        this.text("Zones", labelX, curY);
        this.drawBevelButton(layout.newBtn.x, layout.newBtn.y, layout.newBtn.w, layout.newBtn.h, false);
        this.fill(10);
        this.textAlign(3, 3);
        this.text("New zone", layout.newBtn.x + layout.newBtn.w / 2, layout.newBtn.y + layout.newBtn.h / 2);
        this.registerUiTooltip(layout.newBtn, this.tooltipFor("zones_list_new"));
        this.drawBevelButton(layout.deselectBtn.x, layout.deselectBtn.y, layout.deselectBtn.w, layout.deselectBtn.h, false);
        this.fill(10);
        this.textAlign(3, 3);
        this.text("Deselect", layout.deselectBtn.x + layout.deselectBtn.w / 2, layout.deselectBtn.y + layout.deselectBtn.h / 2);
        this.registerUiTooltip(layout.deselectBtn, this.tooltipFor("structures_deselect"));
        this.registerUiTooltip(layout.deselectBtn, this.tooltipFor("zones_list_deselect"));
        if (this.mapModel == null || this.mapModel.zones == null) {
            return;
        }
        int i = 0;
        while (i < layout.rows.size()) {
            ZoneRowLayout row = layout.rows.get(i);
            if (row.index >= 0 && row.index < this.mapModel.zones.size()) {
                boolean editing;
                MapModel.MapZone az = this.mapModel.zones.get(row.index);
                boolean selected = this.activeZoneIndex == row.index;
                this.drawRadioButton(row.selectRect, selected);
                boolean bl = editing = this.editingZoneNameIndex == row.index;
                if (editing) {
                    this.stroke(60);
                    this.fill(255);
                    this.rect(row.nameRect.x, row.nameRect.y, row.nameRect.w, row.nameRect.h);
                    this.fill(0);
                    this.textAlign(37, 3);
                    this.text(this.zoneNameDraft, row.nameRect.x + 6, row.nameRect.y + row.nameRect.h / 2);
                    float caretX = (float)(row.nameRect.x + 6) + this.textWidth(this.zoneNameDraft);
                    this.stroke(0);
                    this.line(caretX, row.nameRect.y + 4, caretX, row.nameRect.y + row.nameRect.h - 4);
                } else {
                    this.stroke(80);
                    this.fill(az.col);
                    this.rect(row.nameRect.x, row.nameRect.y, row.nameRect.w, row.nameRect.h, 4.0f);
                    float br = this.brightness(az.col);
                    int txtCol = br > 60.0f ? this.color(15) : this.color(245);
                    this.fill(txtCol);
                    this.textAlign(37, 3);
                    this.text(az.name, row.nameRect.x + 6, row.nameRect.y + row.nameRect.h / 2);
                }
                float hNorm = Main.constrain((float)az.hue01, (float)0.0f, (float)1.0f);
                this.drawSlider(row.hueSlider, hNorm, "");
            }
            ++i;
        }
        this.drawScrollbar(layout.scrollbar, layout.contentH, this.zonesListScroll);
    }

    public ZonesLayout buildZonesLayout() {
        int curY;
        ZonesLayout l = new ZonesLayout();
        l.panel = new IntRect(0, this.panelTop(), 320, 0);
        int innerX = l.panel.x + 10;
        l.titleY = curY = l.panel.y + 10;
        l.resetBtn = new IntRect(innerX, curY += 30, 90, 22);
        l.regenerateBtn = new IntRect(l.resetBtn.x + l.resetBtn.w + 8, curY, 110, 22);
        l.brushSlider = new IntRect(innerX, (curY += 30) + 14, 180, 16);
        l.excludeWaterBtn = new IntRect(innerX, curY += 40, 110, 22);
        l.exclusiveBtn = new IntRect(l.excludeWaterBtn.x + l.excludeWaterBtn.w + 8, curY, 140, 22);
        l.fourColorBtn = new IntRect(innerX, curY += 30, 150, 22);
        l.commentField = new IntRect(innerX, (curY += 34) + 14, 200, 22);
        curY += 48;
        l.listPanel = new IntRect(this.width - 260 - 10, this.panelTop(), 260, this.height - this.panelTop() - 10);
        l.panel.h = (curY += this.hintHeight(3)) - l.panel.y;
        return l;
    }

    public void drawZonesPanel() {
        ZonesLayout layout = this.buildZonesLayout();
        this.drawPanelBackground(layout.panel);
        int labelX = layout.panel.x + 10;
        this.fill(0);
        this.textAlign(37, 101);
        this.text("Zones", labelX, layout.titleY);
        IntRect cf = layout.commentField;
        this.fill(0);
        this.textAlign(37, 102);
        this.text("Comment", cf.x, cf.y - 4);
        this.stroke(80);
        this.fill(255);
        this.rect(cf.x, cf.y, cf.w, cf.h);
        this.fill(0);
        this.textAlign(37, 3);
        String shown = "";
        if (this.activeZoneIndex >= 0 && this.activeZoneIndex < this.mapModel.zones.size()) {
            MapModel.MapZone z = this.mapModel.zones.get(this.activeZoneIndex);
            if (z != null && z.comment != null && !this.editingZoneComment) {
                shown = z.comment;
            }
            if (this.editingZoneComment) {
                shown = this.zoneCommentDraft;
            }
        }
        this.text(shown, cf.x + 6, cf.y + cf.h / 2);
        if (this.editingZoneComment) {
            float caretX = (float)(cf.x + 6) + this.textWidth(this.zoneCommentDraft);
            this.stroke(0);
            this.line(caretX, cf.y + 4, caretX, cf.y + cf.h - 4);
        }
        this.rectMode(0);
        this.drawBevelButton(layout.resetBtn.x, layout.resetBtn.y, layout.resetBtn.w, layout.resetBtn.h, false);
        this.drawBevelButton(layout.regenerateBtn.x, layout.regenerateBtn.y, layout.regenerateBtn.w, layout.regenerateBtn.h, false);
        this.fill(10);
        this.textAlign(3, 3);
        this.text("Reset", (float)layout.resetBtn.x + (float)layout.resetBtn.w * 0.5f, (float)layout.resetBtn.y + (float)layout.resetBtn.h * 0.5f);
        this.text("Regenerate", (float)layout.regenerateBtn.x + (float)layout.regenerateBtn.w * 0.5f, (float)layout.regenerateBtn.y + (float)layout.regenerateBtn.h * 0.5f);
        this.registerUiTooltip(layout.resetBtn, this.tooltipFor("zones_reset"));
        this.registerUiTooltip(layout.regenerateBtn, this.tooltipFor("zones_regenerate"));
        IntRect brush = layout.brushSlider;
        float bNorm = Main.constrain((float)Main.map((float)this.zoneBrushRadius, (float)0.01f, (float)0.15f, (float)0.0f, (float)1.0f), (float)0.0f, (float)1.0f);
        this.drawSlider(brush, bNorm, "Brush radius");
        this.registerUiTooltip(brush, this.tooltipFor("zones_brush"));
        this.drawControlsHint(layout.panel, "left-click: paint or erase", "right-click pan", "wheel: zoom");
        if (layout.excludeWaterBtn != null) {
            this.drawBevelButton(layout.excludeWaterBtn.x, layout.excludeWaterBtn.y, layout.excludeWaterBtn.w, layout.excludeWaterBtn.h, false);
            this.fill(10);
            this.textAlign(3, 3);
            this.text("Exclude water", layout.excludeWaterBtn.x + layout.excludeWaterBtn.w / 2, layout.excludeWaterBtn.y + layout.excludeWaterBtn.h / 2);
            this.registerUiTooltip(layout.excludeWaterBtn, this.tooltipFor("zones_exclude_water"));
        }
        if (layout.exclusiveBtn != null) {
            this.drawBevelButton(layout.exclusiveBtn.x, layout.exclusiveBtn.y, layout.exclusiveBtn.w, layout.exclusiveBtn.h, false);
            this.fill(10);
            this.textAlign(3, 3);
            this.text("Make exclusive", layout.exclusiveBtn.x + layout.exclusiveBtn.w / 2, layout.exclusiveBtn.y + layout.exclusiveBtn.h / 2);
            this.registerUiTooltip(layout.exclusiveBtn, this.tooltipFor("zones_exclusive"));
        }
        if (layout.fourColorBtn != null) {
            this.drawBevelButton(layout.fourColorBtn.x, layout.fourColorBtn.y, layout.fourColorBtn.w, layout.fourColorBtn.h, false);
            this.fill(10);
            this.textAlign(3, 3);
            this.text("Four-color map", layout.fourColorBtn.x + layout.fourColorBtn.w / 2, layout.fourColorBtn.y + layout.fourColorBtn.h / 2);
            this.registerUiTooltip(layout.fourColorBtn, this.tooltipFor("zones_four_color"));
        }
    }

    public PathsLayout buildPathsLayout() {
        int curY;
        PathsLayout l = new PathsLayout();
        l.panel = new IntRect(0, this.panelTop(), 320, 0);
        int innerX = l.panel.x + 10;
        l.titleY = curY = l.panel.y + 10;
        l.generateBtn = new IntRect(innerX, curY += 30, 120, 22);
        l.typeAddBtn = new IntRect(innerX, curY += 34, 24, 22);
        l.typeRemoveBtn = new IntRect(l.typeAddBtn.x + l.typeAddBtn.w + 6, curY, 24, 22);
        int swatchW = 60;
        int swatchH = 18;
        int gapX = 8;
        int maxPerRow = Main.max((int)1, (int)((300 + gapX) / (swatchW + gapX)));
        int rowY = curY += 30;
        int col = 0;
        int paletteBottom = rowY;
        if (this.mapModel != null && this.mapModel.pathTypes != null) {
            int i = 0;
            while (i < this.mapModel.pathTypes.size()) {
                int x = innerX + col * (swatchW + gapX);
                l.typeSwatches.add(new IntRect(x, rowY, swatchW, swatchH));
                paletteBottom = Main.max((int)paletteBottom, (int)(rowY + swatchH));
                if (++col >= maxPerRow) {
                    col = 0;
                    rowY += swatchH + 8;
                }
                ++i;
            }
        }
        curY = paletteBottom + 8;
        l.nameField = new IntRect(innerX, curY + 14, 200, 22);
        l.commentField = new IntRect(innerX, (curY += 48) + 14, 200, 22);
        l.typeHueSlider = new IntRect(innerX, (curY += 48) + 14, 200, 16);
        l.typeSatSlider = new IntRect(innerX, (curY += 42) + 14, 200, 16);
        l.typeBriSlider = new IntRect(innerX, (curY += 42) + 14, 200, 16);
        l.typeWeightSlider = new IntRect(innerX, (curY += 42) + 14, 180, 16);
        l.typeMinWeightSlider = new IntRect(innerX, (curY += 38) + 14, 180, 16);
        l.taperCheck = new IntRect(innerX, curY += 38, 16, 16);
        int sliderW = 200;
        l.routeSlider = new IntRect(innerX, (curY += 26) + 14, sliderW, 16);
        l.flattestSlider = new IntRect(innerX, (curY += 42) + 14, sliderW, 16);
        l.avoidWaterCheck = new IntRect(innerX, curY += 42, 16, 16);
        l.eraserBtn = new IntRect(innerX, curY += 24, 90, 22);
        curY += 34;
        l.panel.h = (curY += this.hintHeight(5)) - l.panel.y;
        return l;
    }

    public PathsListLayout buildPathsListLayout() {
        PathsListLayout l = new PathsListLayout();
        int w = 260;
        int x = this.width - w - 10;
        int y = this.panelTop();
        l.panel = new IntRect(x, y, w, this.height - y - 10);
        l.titleY = y + 10;
        int newBtnY = l.titleY + 18 + 12;
        l.newBtn = new IntRect(x + 10, newBtnY, 90, 22);
        l.deselectBtn = new IntRect(l.newBtn.x + l.newBtn.w + 8, newBtnY, 90, 22);
        return l;
    }

    public void populatePathsListRows(PathsListLayout layout) {
        layout.rows.clear();
        int labelX = layout.panel.x + 10;
        int startY = layout.newBtn.y + layout.newBtn.h + 12;
        int maxY = layout.panel.y + layout.panel.h - 12;
        int viewH = Main.max((int)0, (int)(maxY - startY));
        int textH = Main.ceil((float)(this.textAscent() + this.textDescent()));
        int nameH = Main.max((int)20, (int)(textH + 8));
        int typeH = Main.max((int)16, (int)(textH + 6));
        int statsH = Main.max((int)14, (int)textH);
        int rowGap = 10;
        int rowTotal = nameH + 6 + typeH + 4 + statsH + rowGap;
        int totalRows = this.mapModel != null && this.mapModel.paths != null ? this.mapModel.paths.size() : 0;
        int contentH = totalRows > 0 ? totalRows * rowTotal : 0;
        layout.rowsStartY = startY;
        layout.rowsViewH = viewH;
        layout.contentH = contentH;
        layout.scrollbar = new IntRect(layout.panel.x + layout.panel.w - 14, startY, 14, viewH);
        this.pathsListScroll = this.clampScroll(this.pathsListScroll, contentH, viewH);
        int curY = startY - Main.round((float)this.pathsListScroll);
        int i = 0;
        while (i < totalRows) {
            if (curY > maxY) break;
            if (curY + rowTotal < startY) {
                curY += rowTotal;
            } else {
                int selectSize = Main.max((int)16, (int)(nameH - 2));
                PathRowLayout row = new PathRowLayout();
                row.index = i;
                row.selectRect = new IntRect(labelX, curY, selectSize, selectSize);
                row.nameRect = new IntRect(row.selectRect.x + row.selectRect.w + 6, curY, layout.panel.w - 20 - 14 - row.selectRect.w - 6 - 40, nameH);
                row.delRect = new IntRect(row.nameRect.x + row.nameRect.w + 6, curY, 30, nameH);
                row.typeRect = new IntRect(labelX + selectSize + 6, curY += nameH + 6, 160, typeH);
                row.statsY = curY += typeH + 4;
                row.statsH = statsH;
                curY += statsH + rowGap;
                layout.rows.add(row);
            }
            ++i;
        }
    }

    public void drawPathsPanel() {
        PathsLayout layout = this.buildPathsLayout();
        this.drawPanelBackground(layout.panel);
        int labelX = layout.panel.x + 10;
        this.fill(0);
        this.textAlign(37, 101);
        this.text("Paths", labelX, layout.titleY);
        IntRect cf = layout.commentField;
        this.fill(0);
        this.textAlign(37, 102);
        this.text("Comment", cf.x, cf.y - 4);
        this.stroke(80);
        this.fill(255);
        this.rect(cf.x, cf.y, cf.w, cf.h);
        this.fill(0);
        this.textAlign(37, 3);
        String shown = "";
        if (this.selectedPathIndex >= 0 && this.selectedPathIndex < this.mapModel.paths.size()) {
            Path p = this.mapModel.paths.get(this.selectedPathIndex);
            if (p != null && p.comment != null && this.editingPathCommentIndex != this.selectedPathIndex) {
                shown = p.comment;
            }
            if (this.editingPathCommentIndex == this.selectedPathIndex) {
                shown = this.pathCommentDraft;
            }
        }
        this.text(shown, cf.x + 6, cf.y + cf.h / 2);
        if (this.editingPathCommentIndex == this.selectedPathIndex) {
            float caretX = (float)(cf.x + 6) + this.textWidth(this.pathCommentDraft);
            this.stroke(0);
            this.line(caretX, cf.y + 4, caretX, cf.y + cf.h - 4);
        }
        IntRect rs = layout.routeSlider;
        String[] modes = new String[]{"Ends", "Pathfind"};
        int modeCount = modes.length;
        float tRoute = Main.constrain((float)((float)this.pathRouteModeIndex / Main.max((float)1.0f, (float)((float)modeCount - 1.0f))), (float)0.0f, (float)1.0f);
        this.drawSelectorSlider(rs, tRoute, "Route mode: " + modes[this.pathRouteModeIndex], modeCount);
        this.registerUiTooltip(rs, this.tooltipFor("paths_route_mode"));
        IntRect fs = layout.flattestSlider;
        float fNorm = Main.constrain((float)Main.map((float)this.flattestSlopeBias, (float)0.0f, (float)1000.0f, (float)0.0f, (float)1.0f), (float)0.0f, (float)1.0f);
        this.drawSlider(fs, fNorm, "Flattest slope bias (" + Main.nf((float)this.flattestSlopeBias, (int)1, (int)2) + ")");
        this.registerUiTooltip(fs, this.tooltipFor("paths_flattest"));
        this.drawCheckbox(layout.avoidWaterCheck.x, layout.avoidWaterCheck.y, layout.avoidWaterCheck.w, this.pathAvoidWater, "Avoid water");
        this.registerUiTooltip(layout.avoidWaterCheck, this.tooltipFor("paths_avoid_water"));
        this.drawBevelButton(layout.eraserBtn.x, layout.eraserBtn.y, layout.eraserBtn.w, layout.eraserBtn.h, this.pathEraserMode);
        this.fill(10);
        this.textAlign(3, 3);
        this.text("Eraser", layout.eraserBtn.x + layout.eraserBtn.w / 2, layout.eraserBtn.y + layout.eraserBtn.h / 2);
        this.registerUiTooltip(layout.eraserBtn, this.tooltipFor("paths_eraser"));
        this.drawBevelButton(layout.generateBtn.x, layout.generateBtn.y, layout.generateBtn.w, layout.generateBtn.h, false);
        this.fill(10);
        this.textAlign(3, 3);
        this.text("Generate", layout.generateBtn.x + layout.generateBtn.w / 2, layout.generateBtn.y + layout.generateBtn.h / 2);
        this.registerUiTooltip(layout.generateBtn, this.tooltipFor("paths_generate"));
        this.drawBevelButton(layout.generateBtn.x, layout.generateBtn.y, layout.generateBtn.w, layout.generateBtn.h, false);
        this.fill(10);
        this.textAlign(3, 3);
        this.text("Generate", layout.generateBtn.x + layout.generateBtn.w / 2, layout.generateBtn.y + layout.generateBtn.h / 2);
        this.registerUiTooltip(layout.generateBtn, this.tooltipFor("paths_generate"));
        this.drawBevelButton(layout.typeAddBtn.x, layout.typeAddBtn.y, layout.typeAddBtn.w, layout.typeAddBtn.h, false);
        this.drawBevelButton(layout.typeRemoveBtn.x, layout.typeRemoveBtn.y, layout.typeRemoveBtn.w, layout.typeRemoveBtn.h, false);
        this.fill(10);
        this.textAlign(3, 3);
        this.text("+", layout.typeAddBtn.x + layout.typeAddBtn.w / 2, layout.typeAddBtn.y + layout.typeAddBtn.h / 2);
        this.text("-", layout.typeRemoveBtn.x + layout.typeRemoveBtn.w / 2, layout.typeRemoveBtn.y + layout.typeRemoveBtn.h / 2);
        this.registerUiTooltip(layout.typeAddBtn, this.tooltipFor("paths_type_add"));
        this.registerUiTooltip(layout.typeRemoveBtn, this.tooltipFor("paths_type_remove"));
        if (this.mapModel == null || this.mapModel.pathTypes == null) {
            return;
        }
        int n = this.mapModel.pathTypes.size();
        if (n == 0) {
            return;
        }
        int i = 0;
        while (i < n) {
            this.pushStyle();
            PathType pt = this.mapModel.pathTypes.get(i);
            IntRect sw = layout.typeSwatches.get(i);
            this.stroke(i == this.activePathTypeIndex ? 0 : 120);
            this.strokeWeight(i == this.activePathTypeIndex ? 2 : 1);
            this.fill(pt.col);
            this.rect(sw.x, sw.y, sw.w, sw.h, 4.0f);
            this.fill(20);
            this.textAlign(3, 3);
            this.text(pt.name, (float)sw.x + (float)sw.w * 0.5f, (float)sw.y + (float)sw.h * 0.5f);
            this.registerUiTooltip(sw, this.tooltipFor("paths_palette"));
            this.popStyle();
            ++i;
        }
        if (this.activePathTypeIndex >= 0 && this.activePathTypeIndex < n) {
            PathType active = this.mapModel.pathTypes.get(this.activePathTypeIndex);
            IntRect nf = layout.nameField;
            boolean editing = this.editingPathTypeNameIndex == this.activePathTypeIndex;
            this.fill(0);
            this.textAlign(37, 102);
            this.text("Name", nf.x, nf.y - 4);
            this.stroke(80);
            this.fill(255);
            this.rect(nf.x, nf.y, nf.w, nf.h);
            this.fill(0);
            this.textAlign(37, 3);
            String shown2 = editing ? this.pathTypeNameDraft : active.name;
            this.text(shown2, nf.x + 6, nf.y + nf.h / 2);
            if (editing) {
                float caretX = (float)(nf.x + 6) + this.textWidth(this.pathTypeNameDraft);
                this.stroke(0);
                this.line(caretX, nf.y + 4, caretX, nf.y + nf.h - 4);
            }
            this.registerUiTooltip(nf, this.tooltipFor("paths_type_name"));
            IntRect hue = layout.typeHueSlider;
            float hNorm = Main.constrain((float)active.hue01, (float)0.0f, (float)1.0f);
            this.drawSlider(hue, hNorm, "Hue for \"" + active.name + "\": " + Main.nf((float)active.hue01, (int)1, (int)2));
            IntRect sat = layout.typeSatSlider;
            float sNorm = Main.constrain((float)active.sat01, (float)0.0f, (float)1.0f);
            this.drawSlider(sat, sNorm, "Saturation for \"" + active.name + "\"");
            IntRect bri = layout.typeBriSlider;
            float bNorm = Main.constrain((float)active.bri01, (float)0.0f, (float)1.0f);
            this.drawSlider(bri, bNorm, "Brightness for \"" + active.name + "\"");
            IntRect weight = layout.typeWeightSlider;
            float wNorm = Main.constrain((float)Main.map((float)active.weightPx, (float)0.5f, (float)8.0f, (float)0.0f, (float)1.0f), (float)0.0f, (float)1.0f);
            this.drawSlider(weight, wNorm, "Weight for \"" + active.name + "\" (px)");
            this.registerUiTooltip(weight, this.tooltipFor("paths_type_weight"));
            IntRect minw = layout.typeMinWeightSlider;
            float minNorm = Main.abs((float)(active.weightPx - 0.5f)) < 1.0E-6f ? 0.0f : Main.constrain((float)Main.map((float)active.minWeightPx, (float)0.5f, (float)active.weightPx, (float)0.0f, (float)1.0f), (float)0.0f, (float)1.0f);
            this.drawSlider(minw, minNorm, "Min weight (px)");
            this.registerUiTooltip(minw, this.tooltipFor("paths_min_weight"));
            this.drawCheckbox(layout.taperCheck.x, layout.taperCheck.y, layout.taperCheck.w, active.taperOn, "Taper water");
            this.registerUiTooltip(layout.taperCheck, this.tooltipFor("paths_taper"));
        }
        this.drawControlsHint(layout.panel, "left-click: start/end", "DEL: cancels", "right-click: pan", "wheel: zoom", "C: clear");
    }

    public void drawPathsListPanel() {
        PathsListLayout layout = this.buildPathsListLayout();
        this.populatePathsListRows(layout);
        this.drawPanelBackground(layout.panel);
        int labelX = layout.panel.x + 10;
        int curY = layout.titleY;
        this.fill(0);
        this.textAlign(37, 101);
        this.text("Paths list", labelX, curY);
        curY += 30;
        if (this.mapModel.paths.isEmpty()) {
            this.fill(80);
            this.textAlign(37, 101);
            this.text("No paths yet.", labelX, curY);
        } else {
            int i = 0;
            while (i < layout.rows.size()) {
                PathRowLayout row = layout.rows.get(i);
                if (row.index >= 0 && row.index < this.mapModel.paths.size()) {
                    boolean editing;
                    Path p = this.mapModel.paths.get(row.index);
                    boolean selected = this.selectedPathIndex == row.index;
                    this.drawRadioButton(row.selectRect, selected);
                    boolean bl = editing = this.editingPathNameIndex == row.index;
                    if (editing) {
                        this.stroke(60);
                        this.fill(255);
                        this.rect(row.nameRect.x, row.nameRect.y, row.nameRect.w, row.nameRect.h);
                        this.fill(0);
                        this.textAlign(37, 3);
                        String shown = this.pathNameDraft;
                        this.text(shown, row.nameRect.x + 6, row.nameRect.y + row.nameRect.h / 2);
                        float caretX = (float)(row.nameRect.x + 6) + this.textWidth(shown);
                        this.stroke(0);
                        this.line(caretX, row.nameRect.y + 4, caretX, row.nameRect.y + row.nameRect.h - 4);
                    } else {
                        this.drawBevelButton(row.nameRect.x, row.nameRect.y, row.nameRect.w, row.nameRect.h, selected);
                        this.fill(10);
                        this.textAlign(37, 3);
                        String title = p.name != null && p.name.length() > 0 ? p.name : "Path";
                        this.text("#" + (row.index + 1) + " " + title, row.nameRect.x + 6, row.nameRect.y + row.nameRect.h / 2);
                    }
                    this.drawBevelButton(row.delRect.x, row.delRect.y, row.delRect.w, row.delRect.h, false);
                    this.fill(10);
                    this.textAlign(3, 3);
                    this.text("X", row.delRect.x + row.delRect.w / 2, row.delRect.y + row.delRect.h / 2);
                    PathType pt = this.mapModel.getPathType(p.typeId);
                    String typLabel = pt != null ? pt.name : "Type";
                    int typeCol = pt != null ? pt.col : this.color(180);
                    this.stroke(80);
                    this.fill(typeCol);
                    this.rect(row.typeRect.x, row.typeRect.y, row.typeRect.w, row.typeRect.h, 4.0f);
                    this.fill(255);
                    this.textAlign(3, 3);
                    this.text(typLabel, (float)row.typeRect.x + (float)row.typeRect.w * 0.5f, (float)row.typeRect.y + (float)row.typeRect.h * 0.5f);
                    int segs = p.segmentCount();
                    float len = p.totalLength();
                    this.fill(40);
                    this.textAlign(37, 3);
                    this.text("Segments: " + segs + "   Len: " + Main.nf((float)len, (int)1, (int)3), labelX + row.selectRect.w + 6, row.statsY + row.statsH / 2);
                }
                ++i;
            }
        }
        this.drawScrollbar(layout.scrollbar, layout.contentH, this.pathsListScroll);
        this.drawBevelButton(layout.newBtn.x, layout.newBtn.y, layout.newBtn.w, layout.newBtn.h, false);
        this.drawBevelButton(layout.deselectBtn.x, layout.deselectBtn.y, layout.deselectBtn.w, layout.deselectBtn.h, false);
        this.fill(10);
        this.textAlign(3, 3);
        this.text("New Path", layout.newBtn.x + layout.newBtn.w / 2, layout.newBtn.y + layout.newBtn.h / 2);
        this.text("Deselect", layout.deselectBtn.x + layout.deselectBtn.w / 2, layout.deselectBtn.y + layout.deselectBtn.h / 2);
        this.registerUiTooltip(layout.newBtn, this.tooltipFor("paths_list_new"));
        this.registerUiTooltip(layout.deselectBtn, this.tooltipFor("paths_list_deselect"));
    }

    public ElevationLayout buildElevationLayout() {
        int curY;
        ElevationLayout l = new ElevationLayout();
        l.panel = new IntRect(0, this.panelTop(), 320, 0);
        int innerX = l.panel.x + 10;
        l.titleY = curY = l.panel.y + 10;
        int genW = 120;
        l.perlinBtn = new IntRect(innerX, curY += 30, genW, 22);
        l.varyBtn = new IntRect(l.perlinBtn.x + genW + 8, curY, genW, 22);
        l.plateauBtn = new IntRect(innerX, curY += 30, genW, 22);
        int sliderW = 200;
        l.seaSlider = new IntRect(innerX, (curY += 34) + 14, sliderW, 16);
        l.radiusSlider = new IntRect(innerX, (curY += 38) + 14, sliderW, 16);
        l.strengthSlider = new IntRect(innerX, (curY += 38) + 14, sliderW, 16);
        l.raiseBtn = new IntRect(innerX, curY += 38, 80, 22);
        l.lowerBtn = new IntRect(l.raiseBtn.x + l.raiseBtn.w + 8, curY, 80, 22);
        l.noiseSlider = new IntRect(innerX, (curY += 34) + 14, sliderW, 16);
        curY += 40;
        l.panel.h = (curY += this.hintHeight(3)) - l.panel.y;
        return l;
    }

    public void drawElevationPanel() {
        ElevationLayout layout = this.buildElevationLayout();
        this.drawPanelBackground(layout.panel);
        int labelX = layout.panel.x + 10;
        this.fill(0);
        this.textAlign(37, 101);
        this.text("Elevation", labelX, layout.titleY);
        IntRect sea = layout.seaSlider;
        float seaNorm = Main.constrain((float)Main.map((float)this.seaLevel, (float)-1.2f, (float)1.2f, (float)0.0f, (float)1.0f), (float)0.0f, (float)1.0f);
        this.drawSlider(sea, seaNorm, "Water level: " + Main.nf((float)this.seaLevel, (int)1, (int)2), true);
        this.registerUiTooltip(sea, this.tooltipFor("elevation_water_level"));
        IntRect rad = layout.radiusSlider;
        float rNorm = Main.constrain((float)Main.map((float)this.elevationBrushRadius, (float)0.01f, (float)0.2f, (float)0.0f, (float)1.0f), (float)0.0f, (float)1.0f);
        this.drawSlider(rad, rNorm, "Brush radius");
        this.registerUiTooltip(rad, this.tooltipFor("elevation_brush_radius"));
        IntRect str = layout.strengthSlider;
        float sNorm = Main.constrain((float)Main.map((float)this.elevationBrushStrength, (float)0.005f, (float)0.2f, (float)0.0f, (float)1.0f), (float)0.0f, (float)1.0f);
        this.drawSlider(str, sNorm, "Brush strength");
        this.registerUiTooltip(str, this.tooltipFor("elevation_brush_strength"));
        this.drawBevelButton(layout.raiseBtn.x, layout.raiseBtn.y, layout.raiseBtn.w, layout.raiseBtn.h, this.elevationBrushRaise);
        this.drawBevelButton(layout.lowerBtn.x, layout.lowerBtn.y, layout.lowerBtn.w, layout.lowerBtn.h, !this.elevationBrushRaise);
        this.fill(10);
        this.textAlign(3, 3);
        this.text("Raise", layout.raiseBtn.x + layout.raiseBtn.w / 2, layout.raiseBtn.y + layout.raiseBtn.h / 2);
        this.text("Lower", layout.lowerBtn.x + layout.lowerBtn.w / 2, layout.lowerBtn.y + layout.lowerBtn.h / 2);
        this.registerUiTooltip(layout.raiseBtn, this.tooltipFor("elevation_raise"));
        this.registerUiTooltip(layout.lowerBtn, this.tooltipFor("elevation_lower"));
        IntRect noise = layout.noiseSlider;
        float nNorm = Main.constrain((float)Main.map((float)this.elevationNoiseScale, (float)1.0f, (float)12.0f, (float)0.0f, (float)1.0f), (float)0.0f, (float)1.0f);
        this.drawSlider(noise, nNorm, "Noise scale");
        this.registerUiTooltip(noise, this.tooltipFor("elevation_noise"));
        this.drawBevelButton(layout.perlinBtn.x, layout.perlinBtn.y, layout.perlinBtn.w, layout.perlinBtn.h, false);
        this.drawBevelButton(layout.varyBtn.x, layout.varyBtn.y, layout.varyBtn.w, layout.varyBtn.h, false);
        this.drawBevelButton(layout.plateauBtn.x, layout.plateauBtn.y, layout.plateauBtn.w, layout.plateauBtn.h, false);
        this.fill(10);
        this.textAlign(3, 3);
        this.text("Generate", layout.perlinBtn.x + layout.perlinBtn.w / 2, layout.perlinBtn.y + layout.perlinBtn.h / 2);
        this.text("Vary", layout.varyBtn.x + layout.varyBtn.w / 2, layout.varyBtn.y + layout.varyBtn.h / 2);
        this.text("Make plateaux", layout.plateauBtn.x + layout.plateauBtn.w / 2, layout.plateauBtn.y + layout.plateauBtn.h / 2);
        this.registerUiTooltip(layout.perlinBtn, this.tooltipFor("elevation_generate_perlin"));
        this.registerUiTooltip(layout.varyBtn, this.tooltipFor("elevation_vary"));
        this.registerUiTooltip(layout.plateauBtn, this.tooltipFor("elevation_plateau"));
        this.drawControlsHint(layout.panel, "left-click: raise/lower", "right-click: pan", "wheel: zoom");
    }

    public String structureShapeLabel(StructureShape sh) {
        switch (sh) {
            case RECTANGLE: {
                return "Rect";
            }
            case CIRCLE: {
                return "Circle";
            }
            case TRIANGLE: {
                return "Triangle";
            }
            case HEXAGON: {
                return "Hex";
            }
        }
        return "Rect";
    }

    public String structureAlignmentLabel(StructureSnapMode mode) {
        switch (mode) {
            case NONE: {
                return "None";
            }
            case ON_PATH: {
                return "Center";
            }
        }
        return "Next";
    }

    public StructuresLayout buildStructuresLayout() {
        StructuresLayout l = new StructuresLayout();
        l.panel = new IntRect(0, this.panelTop(), 320, 0);
        int innerX = l.panel.x + 10;
        int curY = l.panel.y + 10;
        int fullW = l.panel.w - 20;
        l.titleY = curY;
        l.headerGen = new IntRect(innerX, curY += 30, fullW, 18);
        curY += 26;
        if (this.structSectionGenOpen) {
            l.genButton = new IntRect(innerX, curY, 140, 22);
            l.genTownSlider = new IntRect(innerX, (curY += 30) + 14, fullW, 16);
            l.genBuildingSlider = new IntRect(innerX, (curY += 38) + 14, fullW, 16);
            curY += 42;
        }
        l.headerSnap = new IntRect(innerX, curY, fullW, 18);
        curY += 26;
        if (this.structSectionSnapOpen) {
            String[] snapLabels = new String[]{"Water", "Biomes", "Underwater biomes", "Zones", "Paths", "Other structures", "Elevation"};
            int i = 0;
            while (i < snapLabels.length) {
                l.snapChecks.add(new IntRect(innerX, curY, 16, 16));
                curY += 24;
                ++i;
            }
            l.snapElevationSlider = new IntRect(innerX + 16 + 8, curY + 14, 160, 16);
            curY += 42;
        }
        l.headerAttr = new IntRect(innerX, curY, fullW, 18);
        curY += 26;
        if (this.structSectionAttrOpen) {
            l.nameField = new IntRect(innerX, curY + 14, fullW, 22);
            l.commentField = new IntRect(innerX, (curY += 44) + 14, fullW, 22);
            l.sizeSlider = new IntRect(innerX, (curY += 44) + 14, fullW, 16);
            l.angleSlider = new IntRect(innerX, (curY += 38) + 14, fullW, 16);
            l.ratioSlider = new IntRect(innerX, (curY += 38) + 14, fullW, 16);
            l.shapeSelector = new IntRect(innerX, (curY += 42) + 14, fullW, 16);
            l.alignmentSelector = new IntRect(innerX, (curY += 38) + 14, fullW, 16);
            l.hueSlider = new IntRect(innerX, (curY += 42) + 14, fullW, 16);
            l.satSlider = new IntRect(innerX, (curY += 38) + 14, fullW, 16);
            l.alphaSlider = new IntRect(innerX, (curY += 38) + 14, fullW, 16);
            l.strokeSlider = new IntRect(innerX, (curY += 38) + 14, fullW, 16);
            curY += 42;
        }
        l.panel.h = (curY += this.hintHeight(3)) - l.panel.y;
        return l;
    }

    public void drawStructuresPanelUI() {
        String shownName;
        StructuresLayout layout = this.buildStructuresLayout();
        this.drawPanelBackground(layout.panel);
        int labelX = layout.panel.x + 10;
        StructureSelectionInfo info = this.gatherStructureSelectionInfo();
        this.fill(0);
        this.textAlign(37, 101);
        this.text("Structures", labelX, layout.titleY);
        this.drawSectionHeader(layout.headerGen, "Generate", this.structSectionGenOpen);
        if (this.structSectionGenOpen) {
            IntRect gb = layout.genButton;
            this.drawBevelButton(gb.x, gb.y, gb.w, gb.h, false);
            this.fill(10);
            this.textAlign(3, 3);
            this.text("Generate", gb.x + gb.w / 2, gb.y + gb.h / 2);
            IntRect ts = layout.genTownSlider;
            float tNorm = Main.constrain((float)((float)this.structGenTownCount / 8.0f), (float)0.0f, (float)1.0f);
            this.drawSlider(ts, tNorm, "Circle count (" + this.structGenTownCount + ")");
            IntRect bs = layout.genBuildingSlider;
            this.drawSlider(bs, this.structGenBuildingDensity, "Rectangle density (" + Main.nf((float)(this.structGenBuildingDensity * 100.0f), (int)1, (int)0) + "%)");
        }
        this.drawSectionHeader(layout.headerSnap, "Snapping guides", this.structSectionSnapOpen);
        if (this.structSectionSnapOpen) {
            String[] labels = new String[]{"Water", "Biomes", "Underwater biomes", "Zones", "Paths", "Other structures", "Elevation"};
            String[] snapKeys = new String[]{"snap_water", "snap_biomes", "snap_underwater_biomes", "snap_zones", "snap_paths", "snap_structures", "snap_elevation"};
            boolean[] values = new boolean[]{this.snapWaterEnabled, this.snapBiomesEnabled, this.snapUnderwaterBiomesEnabled, this.snapZonesEnabled, this.snapPathsEnabled, this.snapStructuresEnabled, this.snapElevationEnabled};
            int i = 0;
            while (i < labels.length && i < layout.snapChecks.size()) {
                IntRect b = layout.snapChecks.get(i);
                this.drawCheckbox(b.x, b.y, b.w, values[i], labels[i]);
                if (i < snapKeys.length) {
                    int hintW = layout.panel.w - 20;
                    this.registerUiTooltip(new IntRect(b.x, b.y, hintW, b.h), this.tooltipFor(snapKeys[i]));
                }
                ++i;
            }
            IntRect es = layout.snapElevationSlider;
            int divMin = 2;
            int divMax = 24;
            float t = Main.constrain((float)((float)(this.snapElevationDivisions - divMin) / (float)(divMax - divMin)), (float)0.0f, (float)1.0f);
            this.drawSlider(es, t, "Elevation divisions: " + this.snapElevationDivisions);
            this.registerUiTooltip(es, this.tooltipFor("snap_elevation_divisions"));
        }
        this.drawSectionHeader(layout.headerAttr, "Attributes", this.structSectionAttrOpen);
        if (!this.structSectionAttrOpen) {
            return;
        }
        IntRect nf = layout.nameField;
        this.fill(0);
        this.textAlign(37, 102);
        this.text("Name", nf.x, nf.y - 4);
        this.stroke(80);
        this.fill(255);
        this.rect(nf.x, nf.y, nf.w, nf.h);
        this.fill(0);
        this.textAlign(37, 3);
        String string = shownName = info.nameMixed && !this.editingStructureName ? "" : this.structureNameDraft;
        if (!info.hasSelection && !this.editingStructureName) {
            shownName = this.structureNameDraft;
        }
        if (info.hasSelection && !info.nameMixed && !this.editingStructureName) {
            shownName = info.sharedName;
        }
        this.text(shownName, nf.x + 6, nf.y + nf.h / 2);
        if (this.editingStructureName) {
            float caretX = (float)(nf.x + 6) + this.textWidth(this.structureNameDraft);
            this.stroke(0);
            this.line(caretX, nf.y + 4, caretX, nf.y + nf.h - 4);
        }
        this.registerUiTooltip(nf, this.tooltipFor("structures_detail_name"));
        IntRect cf = layout.commentField;
        this.fill(0);
        this.textAlign(37, 102);
        this.text("Comment", cf.x, cf.y - 4);
        this.stroke(80);
        this.fill(255);
        this.rect(cf.x, cf.y, cf.w, cf.h);
        this.fill(0);
        this.textAlign(37, 3);
        String shown = "";
        if (info.hasSelection && !info.commentMixed && !this.editingStructureComment) {
            shown = info.sharedComment;
        } else if (this.editingStructureComment) {
            shown = this.structureCommentDraft;
        }
        this.text(shown, cf.x + 6, cf.y + cf.h / 2);
        if (this.editingStructureComment) {
            float caretX = (float)(cf.x + 6) + this.textWidth(this.structureCommentDraft);
            this.stroke(0);
            this.line(caretX, cf.y + 4, caretX, cf.y + cf.h - 4);
        }
        IntRect sz = layout.sizeSlider;
        float sNorm = Main.constrain((float)Main.map((float)info.sharedSize, (float)0.01f, (float)0.2f, (float)0.0f, (float)1.0f), (float)0.0f, (float)1.0f);
        String sizeLabel = info.sizeMixed ? "Size" : "Size (" + Main.nf((float)info.sharedSize, (int)1, (int)3) + ")";
        this.drawSlider(sz, sNorm, sizeLabel, false, !info.sizeMixed);
        this.registerUiTooltip(sz, this.tooltipFor("structures_size"));
        IntRect ang = layout.angleSlider;
        float angDeg = Main.degrees((float)info.sharedAngleRad);
        float aNorm = Main.constrain((float)Main.map((float)angDeg, (float)-180.0f, (float)180.0f, (float)0.0f, (float)1.0f), (float)0.0f, (float)1.0f);
        String angLabel = info.angleMixed ? "Angle" : "Angle (" + Main.nf((float)angDeg, (int)1, (int)1) + " deg)";
        this.drawSlider(ang, aNorm, angLabel, true, !info.angleMixed);
        this.registerUiTooltip(ang, this.tooltipFor("structures_angle"));
        IntRect ratio = layout.ratioSlider;
        float rNorm = Main.constrain((float)Main.map((float)info.sharedRatio, (float)0.3f, (float)3.0f, (float)0.0f, (float)1.0f), (float)0.0f, (float)1.0f);
        String ratioLabel = info.ratioMixed ? "Aspect ratio (W/H)" : "Aspect ratio (W/H): " + Main.nf((float)info.sharedRatio, (int)1, (int)2);
        this.drawSlider(ratio, rNorm, ratioLabel, false, !info.ratioMixed);
        this.registerUiTooltip(ratio, this.tooltipFor("structures_ratio"));
        IntRect shSel = layout.shapeSelector;
        StructureShape[] shapes = StructureShape.values();
        int shapeIdx = Main.max((int)0, (int)Main.min((int)(shapes.length - 1), (int)info.sharedShape.ordinal()));
        float shNorm = shapes.length > 1 ? (float)shapeIdx / (float)(shapes.length - 1) : 0.0f;
        String shapeLabel = info.shapeMixed ? "Shape" : "Shape: " + this.structureShapeLabel(info.sharedShape);
        this.drawSelectorSlider(shSel, shNorm, shapeLabel, shapes.length, !info.shapeMixed);
        this.registerUiTooltip(shSel, this.tooltipFor("structures_shape"));
        IntRect snapSel = layout.alignmentSelector;
        StructureSnapMode[] snaps = StructureSnapMode.values();
        int snapIdx = Main.max((int)0, (int)Main.min((int)(snaps.length - 1), (int)info.sharedAlignment.ordinal()));
        float snapNorm = snaps.length > 1 ? (float)snapIdx / (float)(snaps.length - 1) : 0.0f;
        String snapLabel = info.alignmentMixed ? "Alignment" : "Alignment: " + this.structureAlignmentLabel(info.sharedAlignment);
        this.drawSelectorSlider(snapSel, snapNorm, snapLabel, snaps.length, !info.alignmentMixed);
        this.registerUiTooltip(snapSel, this.tooltipFor("structures_snap_mode"));
        IntRect hue = layout.hueSlider;
        float hNorm = Main.constrain((float)info.sharedHue, (float)0.0f, (float)1.0f);
        this.drawSlider(hue, hNorm, "Hue", false, !info.hueMixed);
        this.registerUiTooltip(hue, this.tooltipFor("structures_detail_hue"));
        IntRect sat = layout.satSlider;
        float satNorm = Main.constrain((float)info.sharedSat, (float)0.0f, (float)1.0f);
        this.drawSlider(sat, satNorm, "Saturation", false, !info.satMixed);
        this.registerUiTooltip(sat, this.tooltipFor("structures_detail_sat"));
        IntRect alp = layout.alphaSlider;
        float aNorm2 = Main.constrain((float)info.sharedAlpha, (float)0.0f, (float)1.0f);
        String alphaLabel = info.alphaMixed ? "Alpha" : "Alpha (" + Main.nf((float)(info.sharedAlpha * 100.0f), (int)1, (int)0) + "%)";
        this.drawSlider(alp, aNorm2, alphaLabel, false, !info.alphaMixed);
        this.registerUiTooltip(alp, this.tooltipFor("structures_detail_alpha"));
        IntRect st = layout.strokeSlider;
        float stNorm = Main.constrain((float)Main.map((float)info.sharedStroke, (float)0.5f, (float)4.0f, (float)0.0f, (float)1.0f), (float)0.0f, (float)1.0f);
        String strokeLabel = info.strokeMixed ? "Stroke weight (px)" : "Stroke weight (" + Main.nf((float)info.sharedStroke, (int)1, (int)2) + " px)";
        this.drawSlider(st, stNorm, strokeLabel, false, !info.strokeMixed);
        this.registerUiTooltip(st, this.tooltipFor("structures_detail_stroke"));
        this.drawControlsHint(layout.panel, "left-click: place/move", "right-click: pan", "wheel: zoom");
    }

    public StructuresListLayout buildStructuresListLayout() {
        StructuresListLayout l = new StructuresListLayout();
        int w = 260;
        int x = this.width - w - 10;
        int y = this.snapPanelTop();
        l.panel = new IntRect(x, y, w, this.height - y - 10);
        l.titleY = y + 10;
        int btnY = l.titleY + 18 + 12;
        l.deselectBtn = new IntRect(x + 10, btnY, 90, 22);
        return l;
    }

    public int layoutStructureDetails(StructuresListLayout layout) {
        return layout.deselectBtn.y + layout.deselectBtn.h + 12;
    }

    public void populateStructuresListRows(StructuresListLayout layout, int startY) {
        layout.rows.clear();
        int labelX = layout.panel.x + 10;
        int maxY = layout.panel.y + layout.panel.h - 12;
        int viewH = Main.max((int)0, (int)(maxY - startY));
        int curY = startY - Main.round((float)this.structuresListScroll);
        int rowH = 24;
        int rowGap = 6;
        int totalRows = this.mapModel != null && this.mapModel.structures != null ? this.mapModel.structures.size() : 0;
        int contentH = totalRows > 0 ? totalRows * (rowH + rowGap) - rowGap : 0;
        layout.rowsStartY = startY;
        layout.rowsViewH = viewH;
        layout.contentH = contentH;
        layout.scrollbar = new IntRect(layout.panel.x + layout.panel.w - 14, startY, 14, viewH);
        this.structuresListScroll = this.clampScroll(this.structuresListScroll, contentH, viewH);
        curY = startY - Main.round((float)this.structuresListScroll);
        int i = 0;
        while (i < totalRows) {
            if (curY > maxY) break;
            if (curY + rowH < startY) {
                curY += rowH + rowGap;
            } else {
                StructureRowLayout row = new StructureRowLayout();
                row.index = i;
                int selectW = 18;
                row.selectRect = new IntRect(labelX, curY, selectW, rowH);
                row.nameRect = new IntRect(labelX + selectW + 6, curY, layout.panel.w - 20 - 14 - selectW - 6 - 30, rowH);
                row.delRect = new IntRect(row.nameRect.x + row.nameRect.w + 6, curY, 24, rowH);
                layout.rows.add(row);
                curY += rowH + rowGap;
            }
            ++i;
        }
    }

    public void drawStructuresListPanel() {
        StructuresListLayout layout = this.buildStructuresListLayout();
        int listStartY = this.layoutStructureDetails(layout);
        this.populateStructuresListRows(layout, listStartY);
        this.drawPanelBackground(layout.panel);
        int labelX = layout.panel.x + 10;
        int curY = layout.titleY;
        this.fill(0);
        this.textAlign(37, 101);
        this.text("Structures", labelX, curY);
        curY += 30;
        this.drawBevelButton(layout.deselectBtn.x, layout.deselectBtn.y, layout.deselectBtn.w, layout.deselectBtn.h, false);
        this.fill(10);
        this.textAlign(3, 3);
        this.text("Deselect", layout.deselectBtn.x + layout.deselectBtn.w / 2, layout.deselectBtn.y + layout.deselectBtn.h / 2);
        int i = 0;
        while (i < layout.rows.size()) {
            Structure s;
            StructureRowLayout row = layout.rows.get(i);
            Structure structure = s = row.index >= 0 && row.index < this.mapModel.structures.size() ? this.mapModel.structures.get(row.index) : null;
            if (s != null) {
                boolean selected = this.isStructureSelected(row.index);
                this.drawRadioButton(row.selectRect, selected);
                this.drawBevelButton(row.nameRect.x, row.nameRect.y, row.nameRect.w, row.nameRect.h, selected);
                this.fill(10);
                this.textAlign(37, 3);
                String base = s.name != null && s.name.length() > 0 ? s.name : "Struct " + (row.index + 1);
                this.text(String.valueOf(base) + " - " + this.structureShapeLabel(s.shape), row.nameRect.x + 6, row.nameRect.y + row.nameRect.h / 2);
                this.drawBevelButton(row.delRect.x, row.delRect.y, row.delRect.w, row.delRect.h, false);
                this.fill(10);
                this.textAlign(3, 3);
                this.text("X", row.delRect.x + row.delRect.w / 2, row.delRect.y + row.delRect.h / 2);
            }
            ++i;
        }
        this.drawScrollbar(layout.scrollbar, layout.contentH, this.structuresListScroll);
    }

    public RenderLayout buildRenderLayout() {
        int curY;
        RenderLayout l = new RenderLayout();
        l.panel = new IntRect(0, this.panelTop(), 320, 0);
        int innerX = l.panel.x + 10;
        l.titleY = curY = l.panel.y + 10;
        int headerW = 300;
        int shortSliderW = 90;
        int longSliderW = 200;
        int hsbGap = 8;
        l.headerBase = new IntRect(innerX, curY += 30, headerW, 18);
        curY += 26;
        if (this.renderSectionBaseOpen) {
            int yHue = curY + 14;
            l.landHSB[0] = new IntRect(innerX, yHue + 14, shortSliderW, 16);
            l.landHSB[1] = new IntRect(innerX + (shortSliderW + hsbGap), yHue + 14, shortSliderW, 16);
            l.landHSB[2] = new IntRect(innerX + 2 * (shortSliderW + hsbGap), yHue + 14, shortSliderW, 16);
            curY += 52;
            int yWater = curY += 14;
            l.waterHSB[0] = new IntRect(innerX, yWater + 14, shortSliderW, 16);
            l.waterHSB[1] = new IntRect(innerX + (shortSliderW + hsbGap), yWater + 14, shortSliderW, 16);
            l.waterHSB[2] = new IntRect(innerX + 2 * (shortSliderW + hsbGap), yWater + 14, shortSliderW, 16);
            l.cellBordersAlphaSlider = new IntRect(innerX, (curY += 52) + 14, longSliderW, 16);
            l.cellBordersSizeSlider = new IntRect(innerX, (curY += 38) + 14, longSliderW, 16);
            l.cellBordersScaleCheckbox = new IntRect(innerX, curY += 38, 16, 16);
            l.backgroundNoiseSlider = new IntRect(innerX, (curY += 24) + 14, longSliderW, 16);
            curY += 42;
        }
        l.headerBiomes = new IntRect(innerX, curY, headerW, 18);
        curY += 26;
        if (this.renderSectionBiomesOpen) {
            l.biomeFillAlphaSlider = new IntRect(innerX, curY + 14, longSliderW, 16);
            l.biomeUnderwaterAlphaSlider = new IntRect(innerX, (curY += 38) + 14, longSliderW, 16);
            l.biomeSatSlider = new IntRect(innerX, (curY += 38) + 14, longSliderW, 16);
            l.biomeBriSlider = new IntRect(innerX, (curY += 38) + 14, longSliderW, 16);
            curY += 38;
            int btnW = 90;
            int i = 0;
            while (i < 3) {
                l.biomeFillTypeButtons.add(new IntRect(innerX + i * (btnW + 8), curY, btnW, 22));
                ++i;
            }
            l.biomeOutlineSizeSlider = new IntRect(innerX, (curY += 30) + 14, longSliderW, 16);
            l.biomeOutlineAlphaSlider = new IntRect(innerX, (curY += 38) + 14, longSliderW, 16);
            l.biomeOutlineScaleCheckbox = new IntRect(innerX, curY += 38, 16, 16);
            curY += 28;
        }
        l.headerShading = new IntRect(innerX, curY, headerW, 18);
        curY += 26;
        if (this.renderSectionShadingOpen) {
            l.waterDepthAlphaSlider = new IntRect(innerX, curY + 14, longSliderW, 16);
            l.lightAlphaSlider = new IntRect(innerX, (curY += 38) + 14, longSliderW, 16);
            l.lightAzimuthSlider = new IntRect(innerX, (curY += 38) + 14, longSliderW, 16);
            l.lightAltitudeSlider = new IntRect(innerX, (curY += 38) + 14, longSliderW, 16);
            l.lightDitherSlider = new IntRect(innerX, (curY += 38) + 14, longSliderW, 16);
            l.lightDitherScaleCheckbox = new IntRect(innerX, curY += 42, 16, 16);
            curY += 28;
        }
        l.headerCoastlines = new IntRect(innerX, curY, headerW, 18);
        curY += 26;
        if (this.renderSectionCoastlinesOpen) {
            l.waterCoastSizeSlider = new IntRect(innerX, curY + 14, longSliderW, 16);
            l.waterCoastScaleCheckbox = new IntRect(innerX, curY += 38, 16, 16);
            l.waterCoastAboveZonesCheckbox = new IntRect(innerX, curY += 24, 16, 16);
            l.waterContourCoastAlphaSlider = new IntRect(innerX, (curY += 24) + 14, longSliderW, 16);
            l.waterContourSizeSlider = new IntRect(innerX, (curY += 38) + 14, longSliderW, 16);
            l.waterContourScaleCheckbox = new IntRect(innerX, curY += 38, 16, 16);
            int yColor = (curY += 24) + 14;
            l.waterContourHSB[0] = new IntRect(innerX, yColor + 14, shortSliderW, 16);
            l.waterContourHSB[1] = new IntRect(innerX + (shortSliderW + hsbGap), yColor + 14, shortSliderW, 16);
            l.waterContourHSB[2] = new IntRect(innerX + 2 * (shortSliderW + hsbGap), yColor + 14, shortSliderW, 16);
            l.waterRippleCountSlider = new IntRect(innerX, (curY += 52) + 14, longSliderW, 16);
            l.waterRippleDistanceSlider = new IntRect(innerX, (curY += 38) + 14, longSliderW, 16);
            l.waterRippleAlphaStartSlider = new IntRect(innerX, (curY += 38) + 14, longSliderW, 16);
            l.waterRippleAlphaEndSlider = new IntRect(innerX, (curY += 38) + 14, longSliderW, 16);
            l.waterHatchAngleSlider = new IntRect(innerX, (curY += 38) + 14, longSliderW, 16);
            l.waterHatchLengthSlider = new IntRect(innerX, (curY += 38) + 14, longSliderW, 16);
            l.waterHatchSpacingSlider = new IntRect(innerX, (curY += 38) + 14, longSliderW, 16);
            l.waterHatchAlphaSlider = new IntRect(innerX, (curY += 38) + 14, longSliderW, 16);
            curY += 42;
        }
        l.headerElevation = new IntRect(innerX, curY, headerW, 18);
        curY += 26;
        if (this.renderSectionElevationOpen) {
            l.elevationLinesCountSlider = new IntRect(innerX, curY + 14, longSliderW, 16);
            l.elevationLinesAlphaSlider = new IntRect(innerX, (curY += 38) + 14, longSliderW, 16);
            l.elevationLinesSizeSlider = new IntRect(innerX, (curY += 38) + 14, longSliderW, 16);
            l.elevationLinesScaleCheckbox = new IntRect(innerX, curY += 38, 16, 16);
            curY += 28;
        }
        l.headerPaths = new IntRect(innerX, curY, headerW, 18);
        curY += 26;
        if (this.renderSectionPathsOpen) {
            l.pathsShowCheckbox = new IntRect(innerX, curY, 16, 16);
            l.pathsScaleWithZoomCheckbox = new IntRect(innerX, curY += 24, 16, 16);
            l.pathSatSlider = new IntRect(innerX, (curY += 24) + 14, longSliderW, 16);
            l.pathBriSlider = new IntRect(innerX, (curY += 38) + 14, longSliderW, 16);
            curY += 42;
        }
        l.headerZones = new IntRect(innerX, curY, headerW, 18);
        curY += 26;
        if (this.renderSectionZonesOpen) {
            l.zoneAlphaSlider = new IntRect(innerX, curY + 14, longSliderW, 16);
            l.zoneSizeSlider = new IntRect(innerX, (curY += 38) + 14, longSliderW, 16);
            l.zoneScaleWithZoomCheckbox = new IntRect(innerX, curY += 38, 16, 16);
            l.zoneSatSlider = new IntRect(innerX, (curY += 24) + 14, longSliderW, 16);
            l.zoneBriSlider = new IntRect(innerX, (curY += 38) + 14, longSliderW, 16);
            curY += 42;
        }
        l.headerStructures = new IntRect(innerX, curY, headerW, 18);
        curY += 26;
        if (this.renderSectionStructuresOpen) {
            l.structuresShowCheckbox = new IntRect(innerX, curY, 16, 16);
            l.structuresMergeCheckbox = new IntRect(innerX, curY += 24, 16, 16);
            l.structuresScaleWithZoomCheckbox = new IntRect(innerX, curY += 24, 16, 16);
            l.structuresShadowAlphaSlider = new IntRect(innerX, (curY += 28) + 14, longSliderW, 16);
            curY += 42;
        }
        l.headerLabels = new IntRect(innerX, curY, headerW, 18);
        curY += 26;
        if (this.renderSectionLabelsOpen) {
            l.labelsArbitraryCheckbox = new IntRect(innerX, curY, 16, 16);
            l.labelsArbSizeSlider = new IntRect(innerX, (curY += 24) + 14, longSliderW, 16);
            l.labelsZonesCheckbox = new IntRect(innerX, curY += 38, 16, 16);
            l.labelsZoneSizeSlider = new IntRect(innerX, (curY += 24) + 14, longSliderW, 16);
            l.labelsPathsCheckbox = new IntRect(innerX, curY += 38, 16, 16);
            l.labelsPathSizeSlider = new IntRect(innerX, (curY += 24) + 14, longSliderW, 16);
            l.labelsStructuresCheckbox = new IntRect(innerX, curY += 38, 16, 16);
            l.labelsStructSizeSlider = new IntRect(innerX, (curY += 24) + 14, longSliderW, 16);
            l.labelsOutlineAlphaSlider = new IntRect(innerX, (curY += 38) + 14, longSliderW, 16);
            l.labelsOutlineSizeSlider = new IntRect(innerX, (curY += 38) + 14, longSliderW, 16);
            l.labelsScaleWithZoomCheckbox = new IntRect(innerX, curY += 38, 16, 16);
            l.labelsOutlineScaleWithZoomCheckbox = new IntRect(innerX, curY += 46, 16, 16);
            l.labelsFontSelector = new IntRect(innerX, (curY += 24) + 14, longSliderW, 16);
            curY += 42;
        }
        l.headerGeneral = new IntRect(innerX, curY, headerW, 18);
        curY += 26;
        if (this.renderSectionGeneralOpen) {
            l.exportPaddingSlider = new IntRect(innerX, curY + 14, longSliderW, 16);
            l.antialiasCheckbox = new IntRect(innerX, curY += 38, 16, 16);
            l.presetSelector = new IntRect(innerX, (curY += 24) + 14, longSliderW, 16);
            l.presetApplyBtn = new IntRect(innerX, curY += 38, 110, 22);
            curY += 34;
        }
        l.panel.h = (curY += 10 + this.hintHeight(2)) - l.panel.y;
        return l;
    }

    public void drawRenderPanel() {
        RenderLayout layout = this.buildRenderLayout();
        this.drawPanelBackground(layout.panel);
        int labelX = layout.panel.x + 10;
        this.fill(0);
        this.textAlign(37, 101);
        this.text("Rendering", labelX, layout.titleY);
        this.textAlign(37, 3);
        this.drawControlsHint(layout.panel, "right-click: pan", "wheel: zoom");
        this.drawSectionHeader(layout.headerBase, "Base", this.renderSectionBaseOpen);
        if (this.renderSectionBaseOpen) {
            this.drawHSBRow(layout.landHSB, "Land base", this.renderSettings.landHue01, this.renderSettings.landSat01, this.renderSettings.landBri01);
            this.registerUiTooltip(layout.landHSB[0], this.tooltipFor("render_land_h"));
            this.registerUiTooltip(layout.landHSB[1], this.tooltipFor("render_land_s"));
            this.registerUiTooltip(layout.landHSB[2], this.tooltipFor("render_land_b"));
            this.drawHSBRow(layout.waterHSB, "Water base", this.renderSettings.waterHue01, this.renderSettings.waterSat01, this.renderSettings.waterBri01);
            this.registerUiTooltip(layout.waterHSB[0], this.tooltipFor("render_water_h"));
            this.registerUiTooltip(layout.waterHSB[1], this.tooltipFor("render_water_s"));
            this.registerUiTooltip(layout.waterHSB[2], this.tooltipFor("render_water_b"));
            this.drawSlider(layout.cellBordersAlphaSlider, this.renderSettings.cellBorderAlpha01, "Cell borders alpha (" + Main.nf((float)(this.renderSettings.cellBorderAlpha01 * 100.0f), (int)1, (int)0) + "%)");
            this.registerUiTooltip(layout.cellBordersAlphaSlider, this.tooltipFor("render_cell_borders"));
            this.drawSlider(layout.cellBordersSizeSlider, Main.constrain((float)(this.renderSettings.cellBorderSizePx / 5.0f), (float)0.0f, (float)1.0f), "Cell borders size (" + Main.nf((float)this.renderSettings.cellBorderSizePx, (int)1, (int)1) + " px)");
            if (layout.cellBordersScaleCheckbox != null) {
                this.drawCheckbox(layout.cellBordersScaleCheckbox.x, layout.cellBordersScaleCheckbox.y, layout.cellBordersScaleCheckbox.w, this.renderSettings.cellBorderScaleWithZoom, "Scale cell borders with zoom");
            }
            this.drawSlider(layout.backgroundNoiseSlider, this.renderSettings.backgroundNoiseAlpha01, "Background noise (" + Main.nf((float)(this.renderSettings.backgroundNoiseAlpha01 * 100.0f), (int)1, (int)0) + "%)");
            this.registerUiTooltip(layout.backgroundNoiseSlider, this.tooltipFor("render_noise_alpha"));
        }
        this.drawSectionHeader(layout.headerBiomes, "Biomes", this.renderSectionBiomesOpen);
        if (this.renderSectionBiomesOpen) {
            this.drawSlider(layout.biomeFillAlphaSlider, this.renderSettings.biomeFillAlpha01, "Emerged biomes alpha (" + Main.nf((float)(this.renderSettings.biomeFillAlpha01 * 100.0f), (int)1, (int)0) + "%)");
            this.registerUiTooltip(layout.biomeFillAlphaSlider, this.tooltipFor("render_biome_fill_alpha"));
            this.drawSlider(layout.biomeUnderwaterAlphaSlider, this.renderSettings.biomeUnderwaterAlpha01, "Underwater biomes alpha (" + Main.nf((float)(this.renderSettings.biomeUnderwaterAlpha01 * 100.0f), (int)1, (int)0) + "%)");
            this.registerUiTooltip(layout.biomeUnderwaterAlphaSlider, this.tooltipFor("render_biome_underwater_alpha"));
            this.drawSlider(layout.biomeSatSlider, this.renderSettings.biomeSatScale01, "Biomes saturation (" + Main.nf((float)(this.renderSettings.biomeSatScale01 * 100.0f), (int)1, (int)0) + "%)");
            this.registerUiTooltip(layout.biomeSatSlider, this.tooltipFor("render_biome_sat"));
            this.drawSlider(layout.biomeBriSlider, this.renderSettings.biomeBriScale01, "Biomes brightness (" + Main.nf((float)(this.renderSettings.biomeBriScale01 * 100.0f), (int)1, (int)0) + "%)");
            this.registerUiTooltip(layout.biomeBriSlider, this.tooltipFor("render_biome_bri"));
            String[] fillLabels = new String[]{"Color", "Pattern", "P-Background"};
            int i = 0;
            while (i < layout.biomeFillTypeButtons.size()) {
                IntRect b = layout.biomeFillTypeButtons.get(i);
                RenderFillType mode = RenderFillType.RENDER_FILL_COLOR;
                if (i == 1) {
                    mode = RenderFillType.RENDER_FILL_PATTERN;
                } else if (i == 2) {
                    mode = RenderFillType.RENDER_FILL_PATTERN_BG;
                }
                boolean active = this.renderSettings.biomeFillType == mode;
                this.drawBevelButton(b.x, b.y, b.w, b.h, active);
                this.fill(10);
                this.textAlign(3, 3);
                this.text(fillLabels[i], b.x + b.w / 2, b.y + b.h / 2);
                this.registerUiTooltip(b, this.tooltipFor("render_biome_fill_type"));
                ++i;
            }
            this.drawSlider(layout.biomeOutlineSizeSlider, Main.constrain((float)(this.renderSettings.biomeOutlineSizePx / 5.0f), (float)0.0f, (float)1.0f), "Biomes outlines size (" + Main.nf((float)this.renderSettings.biomeOutlineSizePx, (int)1, (int)1) + " px)");
            this.registerUiTooltip(layout.biomeOutlineSizeSlider, this.tooltipFor("render_biome_outline_size"));
            this.drawSlider(layout.biomeOutlineAlphaSlider, this.renderSettings.biomeOutlineAlpha01, "Biomes outlines alpha (" + Main.nf((float)(this.renderSettings.biomeOutlineAlpha01 * 100.0f), (int)1, (int)0) + "%)");
            this.registerUiTooltip(layout.biomeOutlineAlphaSlider, this.tooltipFor("render_biome_outline_alpha"));
            if (layout.biomeOutlineScaleCheckbox != null) {
                this.drawCheckbox(layout.biomeOutlineScaleCheckbox.x, layout.biomeOutlineScaleCheckbox.y, layout.biomeOutlineScaleCheckbox.w, this.renderSettings.biomeOutlineScaleWithZoom, "Scale biome outlines with zoom");
            }
        }
        this.drawSectionHeader(layout.headerShading, "Shading", this.renderSectionShadingOpen);
        if (this.renderSectionShadingOpen) {
            this.drawSlider(layout.waterDepthAlphaSlider, this.renderSettings.waterDepthAlpha01, "Water depth alpha (" + Main.nf((float)(this.renderSettings.waterDepthAlpha01 * 100.0f), (int)1, (int)0) + "%)");
            this.registerUiTooltip(layout.waterDepthAlphaSlider, this.tooltipFor("render_water_depth_alpha"));
            this.drawSlider(layout.lightAlphaSlider, this.renderSettings.elevationLightAlpha01, "Elevation light alpha (" + Main.nf((float)(this.renderSettings.elevationLightAlpha01 * 100.0f), (int)1, (int)0) + "%)");
            this.registerUiTooltip(layout.lightAlphaSlider, this.tooltipFor("render_light_alpha"));
            float tAz = Main.constrain((float)(this.renderSettings.elevationLightAzimuthDeg / 360.0f), (float)0.0f, (float)1.0f);
            this.drawSlider(layout.lightAzimuthSlider, tAz, "Light azimuth (" + Main.nf((float)this.renderSettings.elevationLightAzimuthDeg, (int)1, (int)0) + " deg)");
            this.registerUiTooltip(layout.lightAzimuthSlider, this.tooltipFor("render_light_azimuth"));
            float tAlt = Main.constrain((float)Main.map((float)this.renderSettings.elevationLightAltitudeDeg, (float)5.0f, (float)80.0f, (float)0.0f, (float)1.0f), (float)0.0f, (float)1.0f);
            this.drawSlider(layout.lightAltitudeSlider, tAlt, "Light altitude (" + Main.nf((float)this.renderSettings.elevationLightAltitudeDeg, (int)1, (int)0) + " deg)");
            this.registerUiTooltip(layout.lightAltitudeSlider, this.tooltipFor("render_light_altitude"));
            this.drawSlider(layout.lightDitherSlider, Main.constrain((float)(this.renderSettings.elevationLightDitherPx / 10.0f), (float)0.0f, (float)1.0f), "Light dither (" + Main.nf((float)this.renderSettings.elevationLightDitherPx, (int)1, (int)1) + ")");
            this.registerUiTooltip(layout.lightDitherSlider, this.tooltipFor("render_light_dither"));
            if (layout.lightDitherScaleCheckbox != null) {
                this.drawCheckbox(layout.lightDitherScaleCheckbox.x, layout.lightDitherScaleCheckbox.y, layout.lightDitherScaleCheckbox.w, this.renderSettings.elevationLightDitherScaleWithZoom, "Scale dither with zoom");
            }
        }
        this.drawSectionHeader(layout.headerCoastlines, "Coastlines", this.renderSectionCoastlinesOpen);
        if (this.renderSectionCoastlinesOpen) {
            this.drawSlider(layout.waterCoastSizeSlider, Main.constrain((float)(this.renderSettings.waterCoastSizePx / 5.0f), (float)0.0f, (float)1.0f), "Coastline size (" + Main.nf((float)this.renderSettings.waterCoastSizePx, (int)1, (int)1) + " px)");
            if (layout.waterCoastScaleCheckbox != null) {
                this.drawCheckbox(layout.waterCoastScaleCheckbox.x, layout.waterCoastScaleCheckbox.y, layout.waterCoastScaleCheckbox.w, this.renderSettings.waterCoastScaleWithZoom, "Scale coastline with zoom");
            }
            if (layout.waterCoastAboveZonesCheckbox != null) {
                this.drawCheckbox(layout.waterCoastAboveZonesCheckbox.x, layout.waterCoastAboveZonesCheckbox.y, layout.waterCoastAboveZonesCheckbox.w, this.renderSettings.waterCoastAboveZones, "Draw coastlines above zones");
            }
            this.drawSlider(layout.waterContourCoastAlphaSlider, this.renderSettings.waterCoastAlpha01, "Coastline alpha (" + Main.nf((float)(this.renderSettings.waterCoastAlpha01 * 100.0f), (int)1, (int)0) + "%)");
            this.registerUiTooltip(layout.waterContourCoastAlphaSlider, this.tooltipFor("render_water_coast_alpha"));
            this.drawSlider(layout.waterContourSizeSlider, Main.constrain((float)(this.renderSettings.waterContourSizePx / 5.0f), (float)0.0f, (float)1.0f), "Water contour size (" + Main.nf((float)this.renderSettings.waterContourSizePx, (int)1, (int)1) + " px)");
            this.registerUiTooltip(layout.waterContourSizeSlider, this.tooltipFor("render_water_contour_size"));
            if (layout.waterContourScaleCheckbox != null) {
                this.drawCheckbox(layout.waterContourScaleCheckbox.x, layout.waterContourScaleCheckbox.y, layout.waterContourScaleCheckbox.w, this.renderSettings.waterContourScaleWithZoom, "Scale water strokes with zoom");
            }
            this.drawHSBRow(layout.waterContourHSB, "Water contours", this.renderSettings.waterContourHue01, this.renderSettings.waterContourSat01, this.renderSettings.waterContourBri01);
            this.registerUiTooltip(layout.waterContourHSB[0], this.tooltipFor("render_water_contour_h"));
            this.registerUiTooltip(layout.waterContourHSB[1], this.tooltipFor("render_water_contour_s"));
            this.registerUiTooltip(layout.waterContourHSB[2], this.tooltipFor("render_water_contour_b"));
            this.drawSlider(layout.waterRippleCountSlider, Main.constrain((float)((float)this.renderSettings.waterRippleCount / 5.0f), (float)0.0f, (float)1.0f), "Number of ripples (" + this.renderSettings.waterRippleCount + ")");
            this.registerUiTooltip(layout.waterRippleCountSlider, this.tooltipFor("render_water_ripple_count"));
            this.drawSlider(layout.waterRippleDistanceSlider, Main.constrain((float)(this.renderSettings.waterRippleDistancePx / 40.0f), (float)0.0f, (float)1.0f), "Ripple distance (" + Main.nf((float)this.renderSettings.waterRippleDistancePx, (int)1, (int)1) + " px)");
            this.registerUiTooltip(layout.waterRippleDistanceSlider, this.tooltipFor("render_water_ripple_dist"));
            this.drawSlider(layout.waterRippleAlphaStartSlider, this.renderSettings.waterRippleAlphaStart01, "Ripple near shore alpha (" + Main.nf((float)(this.renderSettings.waterRippleAlphaStart01 * 100.0f), (int)1, (int)0) + "%)");
            this.registerUiTooltip(layout.waterRippleAlphaStartSlider, this.tooltipFor("render_water_ripple_alpha_start"));
            this.drawSlider(layout.waterRippleAlphaEndSlider, this.renderSettings.waterRippleAlphaEnd01, "Ripple far alpha (" + Main.nf((float)(this.renderSettings.waterRippleAlphaEnd01 * 100.0f), (int)1, (int)0) + "%)");
            this.registerUiTooltip(layout.waterRippleAlphaEndSlider, this.tooltipFor("render_water_ripple_alpha_end"));
            this.drawSlider(layout.waterHatchAngleSlider, Main.constrain((float)((this.renderSettings.waterHatchAngleDeg + 90.0f) / 180.0f), (float)0.0f, (float)1.0f), "Hatching angle (" + Main.nf((float)this.renderSettings.waterHatchAngleDeg, (int)1, (int)1) + " deg)");
            this.registerUiTooltip(layout.waterHatchAngleSlider, this.tooltipFor("render_water_hatch_angle"));
            this.drawSlider(layout.waterHatchLengthSlider, Main.constrain((float)(this.renderSettings.waterHatchLengthPx / 400.0f), (float)0.0f, (float)1.0f), "Hatching length (" + Main.nf((float)this.renderSettings.waterHatchLengthPx, (int)1, (int)1) + " px)");
            this.registerUiTooltip(layout.waterHatchLengthSlider, this.tooltipFor("render_water_hatch_length"));
            float spacingNorm = Main.constrain((float)(this.renderSettings.waterHatchSpacingPx / 120.0f), (float)0.0f, (float)1.0f);
            this.drawSlider(layout.waterHatchSpacingSlider, spacingNorm, "Hatching spacing (" + Main.nf((float)this.renderSettings.waterHatchSpacingPx, (int)1, (int)1) + " px)");
            this.registerUiTooltip(layout.waterHatchSpacingSlider, this.tooltipFor("render_water_hatch_spacing"));
            this.drawSlider(layout.waterHatchAlphaSlider, this.renderSettings.waterHatchAlpha01, "Hatching alpha (" + Main.nf((float)(this.renderSettings.waterHatchAlpha01 * 100.0f), (int)1, (int)0) + "%)");
            this.registerUiTooltip(layout.waterHatchAlphaSlider, this.tooltipFor("render_water_hatch_alpha"));
        }
        this.drawSectionHeader(layout.headerElevation, "Elevation", this.renderSectionElevationOpen);
        if (this.renderSectionElevationOpen) {
            float elevCountNorm = Main.constrain((float)((float)this.renderSettings.elevationLinesCount / 24.0f), (float)0.0f, (float)1.0f);
            this.drawSlider(layout.elevationLinesCountSlider, elevCountNorm, "Elevation lines (" + this.renderSettings.elevationLinesCount + ")");
            this.registerUiTooltip(layout.elevationLinesCountSlider, this.tooltipFor("render_elev_lines_count"));
            this.drawSlider(layout.elevationLinesAlphaSlider, this.renderSettings.elevationLinesAlpha01, "Elevation lines alpha (" + Main.nf((float)(this.renderSettings.elevationLinesAlpha01 * 100.0f), (int)1, (int)0) + "%)");
            this.registerUiTooltip(layout.elevationLinesAlphaSlider, this.tooltipFor("render_elev_lines_alpha"));
            this.drawSlider(layout.elevationLinesSizeSlider, Main.constrain((float)(this.renderSettings.elevationLinesSizePx / 5.0f), (float)0.0f, (float)1.0f), "Elevation lines size (" + Main.nf((float)this.renderSettings.elevationLinesSizePx, (int)1, (int)1) + " px)");
            if (layout.elevationLinesScaleCheckbox != null) {
                this.drawCheckbox(layout.elevationLinesScaleCheckbox.x, layout.elevationLinesScaleCheckbox.y, layout.elevationLinesScaleCheckbox.w, this.renderSettings.elevationLinesScaleWithZoom, "Scale elevation lines with zoom");
            }
        }
        this.drawSectionHeader(layout.headerPaths, "Paths", this.renderSectionPathsOpen);
        if (this.renderSectionPathsOpen) {
            this.drawCheckbox(layout.pathsShowCheckbox.x, layout.pathsShowCheckbox.y, layout.pathsShowCheckbox.w, this.renderSettings.showPaths, "Show paths");
            this.registerUiTooltip(layout.pathsShowCheckbox, this.tooltipFor("render_paths_show"));
            this.drawCheckbox(layout.pathsScaleWithZoomCheckbox.x, layout.pathsScaleWithZoomCheckbox.y, layout.pathsScaleWithZoomCheckbox.w, this.renderSettings.pathScaleWithZoom, "Scale stroke with zoom");
            this.drawSlider(layout.pathSatSlider, this.renderSettings.pathSatScale01, "Paths saturation (" + Main.nf((float)(this.renderSettings.pathSatScale01 * 100.0f), (int)1, (int)0) + "%)");
            this.registerUiTooltip(layout.pathSatSlider, this.tooltipFor("render_paths_sat"));
            this.drawSlider(layout.pathBriSlider, this.renderSettings.pathBriScale01, "Paths brightness (" + Main.nf((float)(this.renderSettings.pathBriScale01 * 100.0f), (int)1, (int)0) + "%)");
            this.registerUiTooltip(layout.pathBriSlider, this.tooltipFor("render_paths_bri"));
        }
        this.drawSectionHeader(layout.headerZones, "Zones", this.renderSectionZonesOpen);
        if (this.renderSectionZonesOpen) {
            this.drawSlider(layout.zoneAlphaSlider, this.renderSettings.zoneStrokeAlpha01, "Zone lines alpha (" + Main.nf((float)(this.renderSettings.zoneStrokeAlpha01 * 100.0f), (int)1, (int)0) + "%)");
            this.registerUiTooltip(layout.zoneAlphaSlider, this.tooltipFor("render_zone_alpha"));
            this.drawSlider(layout.zoneSizeSlider, Main.constrain((float)(this.renderSettings.zoneStrokeSizePx / 5.0f), (float)0.0f, (float)1.0f), "Zone line width (" + Main.nf((float)this.renderSettings.zoneStrokeSizePx, (int)1, (int)1) + " px)");
            this.registerUiTooltip(layout.zoneSizeSlider, this.tooltipFor("render_zone_size"));
            if (layout.zoneScaleWithZoomCheckbox != null) {
                this.drawCheckbox(layout.zoneScaleWithZoomCheckbox.x, layout.zoneScaleWithZoomCheckbox.y, layout.zoneScaleWithZoomCheckbox.w, this.renderSettings.zoneStrokeScaleWithZoom, "Scale zone lines with zoom");
            }
            this.drawSlider(layout.zoneSatSlider, this.renderSettings.zoneStrokeSatScale01, "Zone lines saturation (" + Main.nf((float)(this.renderSettings.zoneStrokeSatScale01 * 100.0f), (int)1, (int)0) + "%)");
            this.registerUiTooltip(layout.zoneSatSlider, this.tooltipFor("render_zone_sat"));
            this.drawSlider(layout.zoneBriSlider, this.renderSettings.zoneStrokeBriScale01, "Zone lines brightness (" + Main.nf((float)(this.renderSettings.zoneStrokeBriScale01 * 100.0f), (int)1, (int)0) + "%)");
            this.registerUiTooltip(layout.zoneBriSlider, this.tooltipFor("render_zone_bri"));
        }
        this.drawSectionHeader(layout.headerStructures, "Structures", this.renderSectionStructuresOpen);
        if (this.renderSectionStructuresOpen) {
            this.drawCheckbox(layout.structuresShowCheckbox.x, layout.structuresShowCheckbox.y, layout.structuresShowCheckbox.w, this.renderSettings.showStructures, "Show structures");
            this.drawCheckbox(layout.structuresMergeCheckbox.x, layout.structuresMergeCheckbox.y, layout.structuresMergeCheckbox.w, this.renderSettings.mergeStructures, "Merge structures");
            if (layout.structuresScaleWithZoomCheckbox != null) {
                this.drawCheckbox(layout.structuresScaleWithZoomCheckbox.x, layout.structuresScaleWithZoomCheckbox.y, layout.structuresScaleWithZoomCheckbox.w, this.renderSettings.structureStrokeScaleWithZoom, "Scale structure strokes with zoom");
            }
            this.drawSlider(layout.structuresShadowAlphaSlider, this.renderSettings.structureShadowAlpha01, "Shadow alpha (" + Main.nf((float)(this.renderSettings.structureShadowAlpha01 * 100.0f), (int)1, (int)0) + "%)");
            this.registerUiTooltip(layout.structuresShowCheckbox, this.tooltipFor("render_struct_show"));
            this.registerUiTooltip(layout.structuresMergeCheckbox, this.tooltipFor("render_struct_merge"));
            this.registerUiTooltip(layout.structuresShadowAlphaSlider, this.tooltipFor("render_struct_shadow"));
        }
        this.drawSectionHeader(layout.headerLabels, "Labels", this.renderSectionLabelsOpen);
        if (this.renderSectionLabelsOpen) {
            this.drawCheckbox(layout.labelsArbitraryCheckbox.x, layout.labelsArbitraryCheckbox.y, layout.labelsArbitraryCheckbox.w, this.renderSettings.showLabelsArbitrary, "Show arbitrary");
            float arbSizeNorm = Main.constrain((float)((this.renderSettings.labelSizeArbPx - 8.0f) / 32.0f), (float)0.0f, (float)1.0f);
            this.drawSlider(layout.labelsArbSizeSlider, arbSizeNorm, "Arbitrary size (" + Main.nf((float)this.renderSettings.labelSizeArbPx, (int)1, (int)0) + " px)");
            this.drawCheckbox(layout.labelsZonesCheckbox.x, layout.labelsZonesCheckbox.y, layout.labelsZonesCheckbox.w, this.renderSettings.showLabelsZones, "Show zones");
            float zoneSizeNorm = Main.constrain((float)((this.renderSettings.labelSizeZonePx - 8.0f) / 32.0f), (float)0.0f, (float)1.0f);
            this.drawSlider(layout.labelsZoneSizeSlider, zoneSizeNorm, "Zones size (" + Main.nf((float)this.renderSettings.labelSizeZonePx, (int)1, (int)0) + " px)");
            this.drawCheckbox(layout.labelsPathsCheckbox.x, layout.labelsPathsCheckbox.y, layout.labelsPathsCheckbox.w, this.renderSettings.showLabelsPaths, "Show paths");
            float pathSizeNorm = Main.constrain((float)((this.renderSettings.labelSizePathPx - 8.0f) / 32.0f), (float)0.0f, (float)1.0f);
            this.drawSlider(layout.labelsPathSizeSlider, pathSizeNorm, "Paths size (" + Main.nf((float)this.renderSettings.labelSizePathPx, (int)1, (int)0) + " px)");
            this.drawCheckbox(layout.labelsStructuresCheckbox.x, layout.labelsStructuresCheckbox.y, layout.labelsStructuresCheckbox.w, this.renderSettings.showLabelsStructures, "Show structures");
            float structSizeNorm = Main.constrain((float)((this.renderSettings.labelSizeStructPx - 8.0f) / 32.0f), (float)0.0f, (float)1.0f);
            this.drawSlider(layout.labelsStructSizeSlider, structSizeNorm, "Structures size (" + Main.nf((float)this.renderSettings.labelSizeStructPx, (int)1, (int)0) + " px)");
            this.drawSlider(layout.labelsOutlineAlphaSlider, this.renderSettings.labelOutlineAlpha01, "Label outline alpha (" + Main.nf((float)(this.renderSettings.labelOutlineAlpha01 * 100.0f), (int)1, (int)0) + "%)");
            this.drawSlider(layout.labelsOutlineSizeSlider, Main.constrain((float)(this.renderSettings.labelOutlineSizePx / 16.0f), (float)0.0f, (float)1.0f), "Label outline size (" + Main.nf((float)this.renderSettings.labelOutlineSizePx, (int)1, (int)0) + " px)");
            this.drawCheckbox(layout.labelsScaleWithZoomCheckbox.x, layout.labelsScaleWithZoomCheckbox.y, layout.labelsScaleWithZoomCheckbox.w, this.renderSettings.labelScaleWithZoom, "Scale with zoom");
            this.fill(60);
            this.textAlign(37, 3);
            this.text("Ref zoom: " + Main.nf((float)this.renderSettings.labelScaleRefZoom, (int)1, (int)2), layout.labelsScaleWithZoomCheckbox.x, layout.labelsScaleWithZoomCheckbox.y + 16 + 8);
            if (layout.labelsOutlineScaleWithZoomCheckbox != null) {
                this.drawCheckbox(layout.labelsOutlineScaleWithZoomCheckbox.x, layout.labelsOutlineScaleWithZoomCheckbox.y, layout.labelsOutlineScaleWithZoomCheckbox.w, this.renderSettings.labelOutlineScaleWithZoom, "Scale outline with zoom");
            }
            if (this.LABEL_FONT_OPTIONS != null && this.LABEL_FONT_OPTIONS.length > 0 && layout.labelsFontSelector != null) {
                int idx = Main.constrain((int)this.renderSettings.labelFontIndex, (int)0, (int)(this.LABEL_FONT_OPTIONS.length - 1));
                float tFont = this.LABEL_FONT_OPTIONS.length > 1 ? Main.constrain((float)((float)idx / (float)(this.LABEL_FONT_OPTIONS.length - 1)), (float)0.0f, (float)1.0f) : 0.0f;
                this.drawSelectorSlider(layout.labelsFontSelector, tFont, "Font: " + this.LABEL_FONT_OPTIONS[idx], this.LABEL_FONT_OPTIONS.length);
            }
            this.registerUiTooltip(layout.labelsArbitraryCheckbox, this.tooltipFor("render_labels_arbitrary"));
            this.registerUiTooltip(layout.labelsZonesCheckbox, this.tooltipFor("render_labels_zones"));
            this.registerUiTooltip(layout.labelsPathsCheckbox, this.tooltipFor("render_labels_paths"));
            this.registerUiTooltip(layout.labelsStructuresCheckbox, this.tooltipFor("render_labels_structures"));
            this.registerUiTooltip(layout.labelsArbSizeSlider, this.tooltipFor("render_labels_size_arbitrary"));
            this.registerUiTooltip(layout.labelsZoneSizeSlider, this.tooltipFor("render_labels_size_zone"));
            this.registerUiTooltip(layout.labelsPathSizeSlider, this.tooltipFor("render_labels_size_path"));
            this.registerUiTooltip(layout.labelsStructSizeSlider, this.tooltipFor("render_labels_size_struct"));
            this.registerUiTooltip(layout.labelsOutlineAlphaSlider, this.tooltipFor("render_labels_outline"));
            this.registerUiTooltip(layout.labelsOutlineSizeSlider, this.tooltipFor("render_labels_outline_size"));
            if (layout.labelsFontSelector != null) {
                this.registerUiTooltip(layout.labelsFontSelector, this.tooltipFor("render_labels_font"));
            }
        }
        this.drawSectionHeader(layout.headerGeneral, "General", this.renderSectionGeneralOpen);
        if (this.renderSectionGeneralOpen) {
            this.drawSlider(layout.exportPaddingSlider, Main.constrain((float)(this.renderSettings.exportPaddingPct / 0.1f), (float)0.0f, (float)1.0f), "Export padding (" + Main.nf((float)(this.renderSettings.exportPaddingPct * 100.0f), (int)1, (int)1) + "%)");
            this.drawCheckbox(layout.antialiasCheckbox.x, layout.antialiasCheckbox.y, layout.antialiasCheckbox.w, this.renderSettings.antialiasing, "Antialiasing");
            this.registerUiTooltip(layout.exportPaddingSlider, this.tooltipFor("render_export_padding"));
            this.registerUiTooltip(layout.antialiasCheckbox, this.tooltipFor("render_antialias"));
            if (this.renderPresets != null && this.renderPresets.length > 0) {
                IntRect ps = layout.presetSelector;
                int n = this.renderPresets.length;
                int maxIdx = Main.max((int)1, (int)(n - 1));
                float t = Main.constrain((float)((float)this.renderSettings.activePresetIndex / (float)maxIdx), (float)0.0f, (float)1.0f);
                String presetName = this.renderPresets[this.renderSettings.activePresetIndex].name;
                this.drawSelectorSlider(ps, t, "Preset: " + presetName, n);
                this.registerUiTooltip(ps, this.tooltipFor("render_preset"));
            }
            if (layout.presetApplyBtn != null) {
                this.drawBevelButton(layout.presetApplyBtn.x, layout.presetApplyBtn.y, layout.presetApplyBtn.w, layout.presetApplyBtn.h, false);
                this.fill(10);
                this.textAlign(3, 3);
                this.text("Apply preset", layout.presetApplyBtn.x + layout.presetApplyBtn.w / 2, layout.presetApplyBtn.y + layout.presetApplyBtn.h / 2);
                this.registerUiTooltip(layout.presetApplyBtn, this.tooltipFor("render_preset_apply"));
            }
        }
    }

    public void drawSectionHeader(IntRect header, String label, boolean isOpen) {
        if (header == null) {
            return;
        }
        this.drawBevelButton(header.x, header.y, header.w, header.h, false);
        this.fill(10);
        this.textAlign(37, 3);
        String caret = isOpen ? "-" : "+";
        this.text(String.valueOf(caret) + " " + label, header.x + 8, header.y + header.h / 2);
    }

    public void drawSlider(IntRect r, float tNorm, String label) {
        this.drawSlider(r, tNorm, label, false, true);
    }

    public void drawSlider(IntRect r, float tNorm, String label, boolean zeroTick) {
        this.drawSlider(r, tNorm, label, zeroTick, true);
    }

    public void drawSlider(IntRect r, float tNorm, String label, boolean zeroTick, boolean showCursor) {
        if (r == null) {
            return;
        }
        float t = Main.constrain((float)tNorm, (float)0.0f, (float)1.0f);
        int trackY = r.y + r.h / 2;
        int padding = Main.max((int)4, (int)(r.h / 2));
        int startX = r.x + padding;
        int endX = r.x + r.w - padding;
        this.stroke(120);
        this.line(startX, trackY, endX, trackY);
        if (zeroTick) {
            int zx = startX + (endX - startX) / 2;
            this.stroke(80);
            this.line(zx, trackY - r.h / 2, zx, trackY - r.h / 2 + 6);
        }
        if (showCursor) {
            int cursorX = Main.round((float)Main.lerp((float)startX, (float)endX, (float)t));
            int cursorW = Main.max((int)8, (int)Main.round((float)((float)r.h * 0.55f)));
            int cursorH = Main.round((float)((float)r.h * 0.8f));
            int cursorY = r.y + (r.h - cursorH) / 2;
            this.noStroke();
            this.fill(236);
            this.rect(cursorX - cursorW / 2, cursorY, cursorW, cursorH);
            this.stroke(255);
            this.line(cursorX - cursorW / 2, cursorY, cursorX + cursorW / 2, cursorY);
            this.line(cursorX - cursorW / 2, cursorY, cursorX - cursorW / 2, cursorY + cursorH);
            this.stroke(96);
            this.line(cursorX - cursorW / 2, cursorY + cursorH, cursorX + cursorW / 2, cursorY + cursorH);
            this.line(cursorX + cursorW / 2, cursorY, cursorX + cursorW / 2, cursorY + cursorH);
        }
        this.fill(0);
        this.textAlign(37, 102);
        this.text(label, r.x, r.y - 4);
    }

    public void drawSelectorSlider(IntRect r, float tNorm, String label, int divisions) {
        this.drawSelectorSlider(r, tNorm, label, divisions, true);
    }

    public void drawSelectorSlider(IntRect r, float tNorm, String label, int divisions, boolean showCursor) {
        if (r == null) {
            return;
        }
        int steps = Main.max((int)2, (int)divisions);
        float t = Main.constrain((float)tNorm, (float)0.0f, (float)1.0f);
        int trackY = r.y + r.h / 2;
        int padding = Main.max((int)4, (int)(r.h / 2));
        int startX = r.x + padding;
        int endX = r.x + r.w - padding;
        this.stroke(120);
        this.line(startX, trackY, endX, trackY);
        this.stroke(60);
        int i = 0;
        while (i < steps) {
            float tt = (float)i / (float)(steps - 1);
            int tx = Main.round((float)Main.lerp((float)startX, (float)endX, (float)tt));
            this.line(tx, trackY - r.h / 2, tx, trackY - r.h / 2 + 6);
            ++i;
        }
        if (showCursor) {
            int cursorX = Main.round((float)Main.lerp((float)startX, (float)endX, (float)t));
            int cursorW = Main.max((int)8, (int)Main.round((float)((float)r.h * 0.55f)));
            int cursorH = Main.round((float)((float)r.h * 0.8f));
            int cursorY = r.y + (r.h - cursorH) / 2;
            this.noStroke();
            this.fill(236);
            this.rect(cursorX - cursorW / 2, cursorY, cursorW, cursorH);
            this.stroke(255);
            this.line(cursorX - cursorW / 2, cursorY, cursorX + cursorW / 2, cursorY);
            this.line(cursorX - cursorW / 2, cursorY, cursorX - cursorW / 2, cursorY + cursorH);
            this.stroke(96);
            this.line(cursorX - cursorW / 2, cursorY + cursorH, cursorX + cursorW / 2, cursorY + cursorH);
            this.line(cursorX + cursorW / 2, cursorY, cursorX + cursorW / 2, cursorY + cursorH);
        }
        this.fill(0);
        this.textAlign(37, 102);
        this.text(label, r.x, r.y - 4);
    }

    public void drawHSBRow(IntRect[] sliders, String label, float h, float s, float b) {
        if (sliders == null || sliders.length < 3) {
            return;
        }
        this.fill(0);
        this.textAlign(37, 102);
        this.text(label, sliders[0].x, sliders[0].y - 16);
        String[] names = new String[]{"hue", "saturation", "brightness"};
        float[] vals = new float[]{h, s, b};
        int i = 0;
        while (i < 3) {
            IntRect r = sliders[i];
            if (r != null) {
                this.drawSlider(r, vals[i], names[i]);
            }
            ++i;
        }
    }

    public String placementModeLabel(PlacementMode m) {
        switch (m) {
            case GRID: {
                return "Grid";
            }
            case POISSON: {
                return "Poisson-disc";
            }
            case HEX: {
                return "Hexagonal";
            }
        }
        return "Unknown";
    }

    public PlacementMode currentPlacementMode() {
        int idx = Main.constrain((int)this.placementModeIndex, (int)0, (int)(this.placementModes.length - 1));
        return this.placementModes[idx];
    }

    public PathRouteMode currentPathRouteMode() {
        PathType pt;
        PathRouteMode fromType = null;
        if (this.mapModel != null && this.mapModel.pathTypes != null && this.activePathTypeIndex >= 0 && this.activePathTypeIndex < this.mapModel.pathTypes.size() && (pt = this.mapModel.pathTypes.get(this.activePathTypeIndex)) != null) {
            fromType = pt.routeMode;
        }
        if (fromType != null) {
            return fromType;
        }
        int idx = Main.constrain((int)this.pathRouteModeIndex, (int)0, (int)1);
        if (idx == 0) {
            return PathRouteMode.ENDS;
        }
        return PathRouteMode.PATHFIND;
    }

    public void drawTabButton(IntRect r, boolean active) {
        int face;
        if (r == null) {
            return;
        }
        this.rectMode(0);
        boolean held = this.isButtonHeld(r);
        int baseBg = this.color(245);
        int n = face = active ? baseBg : this.color(216);
        if (held) {
            face = this.color(200);
        }
        this.noStroke();
        this.fill(face);
        this.rect(r.x, r.y, r.w, r.h);
        this.stroke(255);
        this.line(r.x, r.y, r.x + r.w - 1, r.y);
        this.line(r.x, r.y, r.x, r.y + r.h - 1);
        this.stroke(active ? baseBg : this.color(160));
        this.stroke(96);
        this.line(r.x + r.w - 1, r.y, r.x + r.w - 1, r.y + r.h - 1);
    }

    public void drawBevelButton(int x, int y, int w, int h, boolean pressed) {
        this.rectMode(0);
        IntRect r = new IntRect(x, y, w, h);
        boolean held = this.isButtonHeld(r);
        boolean pressState = pressed || held;
        int face = pressState ? this.color(192) : this.color(224);
        int hl = this.color(255);
        int sh = this.color(96);
        this.noStroke();
        this.fill(face);
        this.rect(x, y, w, h);
        if (!pressState) {
            this.stroke(hl);
            this.line(x, y, x + w - 1, y);
            this.line(x, y, x, y + h - 1);
            this.stroke(sh);
            this.line(x, y + h - 1, x + w - 1, y + h - 1);
            this.line(x + w - 1, y, x + w - 1, y + h - 1);
        } else {
            this.stroke(sh);
            this.line(x, y, x + w - 1, y);
            this.line(x, y, x, y + h - 1);
            this.stroke(hl);
            this.line(x, y + h - 1, x + w - 1, y + h - 1);
            this.line(x + w - 1, y, x + w - 1, y + h - 1);
        }
    }

    public void drawRadioButton(IntRect r, boolean selected) {
        this.drawBevelButton(r.x, r.y, r.w, r.h, false);
        float cx = (float)r.x + (float)r.w * 0.5f;
        float cy = (float)r.y + (float)r.h * 0.5f;
        float inner = (float)Main.min((int)r.w, (int)r.h) * 0.4f;
        if (selected) {
            this.noStroke();
            this.fill(0);
            this.ellipse(cx, cy, inner, inner);
        }
    }

    public void drawCheckbox(int x, int y, int size, boolean on, String label) {
        this.stroke(80);
        this.fill(on ? 200 : 245);
        this.rect(x, y, size, size);
        if (on) {
            this.line(x + 3, y + size / 2, x + size / 2, y + size - 3);
            this.line(x + size / 2, y + size - 3, x + size - 3, y + 3);
        }
        this.fill(0);
        this.textAlign(37, 3);
        this.text(label, x + size + 6, y + size / 2);
    }

    public void drawControlsHint(IntRect panel, String ... linesArr) {
        if (panel == null || linesArr == null) {
            return;
        }
        ArrayList<String> lines = new ArrayList<String>();
        String[] stringArray = linesArr;
        int n = linesArr.length;
        int n2 = 0;
        while (n2 < n) {
            String s = stringArray[n2];
            if (s != null && s.length() > 0) {
                lines.add(s);
            }
            ++n2;
        }
        if (lines.isEmpty()) {
            return;
        }
        float totalH = lines.size() * 16;
        float yTop = (float)(panel.y + panel.h - 10) - totalH;
        float sepY = yTop - 4.0f;
        this.stroke(140);
        this.line(panel.x + 10, sepY, panel.x + panel.w - 10, sepY);
        this.fill(40);
        this.textAlign(37, 101);
        float y = yTop;
        for (String s : lines) {
            this.text(s, panel.x + 10, y);
            y += 16.0f;
        }
    }

    public IntRect getActivePanelRect() {
        switch (this.currentTool) {
            case EDIT_SITES: {
                SitesLayout l = this.buildSitesLayout();
                return l.panel;
            }
            case EDIT_ELEVATION: {
                ElevationLayout l = this.buildElevationLayout();
                return l.panel;
            }
            case EDIT_BIOMES: {
                BiomesLayout l = this.buildBiomesLayout();
                return l.panel;
            }
            case EDIT_ZONES: {
                ZonesLayout l = this.buildZonesLayout();
                return l.panel;
            }
            case EDIT_STRUCTURES: {
                StructuresLayout l = this.buildStructuresLayout();
                return l.panel;
            }
            case EDIT_PATHS: {
                PathsLayout l = this.buildPathsLayout();
                return l.panel;
            }
            case EDIT_LABELS: {
                LabelsLayout l = this.buildLabelsLayout();
                return l.panel;
            }
            case EDIT_RENDER: {
                RenderLayout l = this.buildRenderLayout();
                return l.panel;
            }
            case EDIT_EXPORT: {
                ExportLayout l = this.buildExportLayout();
                return l.panel;
            }
        }
        return null;
    }

    public LabelsLayout buildLabelsLayout() {
        int curY;
        LabelsLayout l = new LabelsLayout();
        l.panel = new IntRect(0, this.panelTop(), 320, 0);
        l.titleY = curY = l.panel.y + 10;
        l.genButton = new IntRect(l.panel.x + 10, curY += 30, 140, 22);
        l.commentField = new IntRect(l.panel.x + 10, (curY += 30) + 14, 300, 22);
        curY += 44;
        l.panel.h = (curY += this.hintHeight(3)) - l.panel.y;
        return l;
    }

    public void drawLabelsPanel() {
        LabelsLayout layout = this.buildLabelsLayout();
        this.drawPanelBackground(layout.panel);
        int labelX = layout.panel.x + 10;
        this.fill(0);
        this.textAlign(37, 101);
        this.text("Labels", labelX, layout.titleY);
        IntRect gb = layout.genButton;
        this.drawBevelButton(gb.x, gb.y, gb.w, gb.h, false);
        this.fill(10);
        this.textAlign(3, 3);
        this.text("Generate labels", gb.x + gb.w / 2, gb.y + gb.h / 2);
        IntRect cf = layout.commentField;
        this.fill(0);
        this.textAlign(37, 102);
        this.text("Comment", cf.x, cf.y - 4);
        this.stroke(80);
        this.fill(255);
        this.rect(cf.x, cf.y, cf.w, cf.h);
        this.fill(0);
        this.textAlign(37, 3);
        String shown = "";
        if (this.selectedLabelIndex >= 0 && this.selectedLabelIndex < this.mapModel.labels.size()) {
            MapLabel l = this.mapModel.labels.get(this.selectedLabelIndex);
            if (l != null && l.comment != null && this.editingLabelCommentIndex != this.selectedLabelIndex) {
                shown = l.comment;
            }
            if (this.editingLabelCommentIndex == this.selectedLabelIndex) {
                shown = this.labelCommentDraft;
            }
        }
        this.text(shown, cf.x + 6, cf.y + cf.h / 2);
        if (this.editingLabelCommentIndex == this.selectedLabelIndex) {
            float caretX = (float)(cf.x + 6) + this.textWidth(this.labelCommentDraft);
            this.stroke(0);
            this.line(caretX, cf.y + 4, caretX, cf.y + cf.h - 4);
        }
        this.drawControlsHint(layout.panel, "left-click: place", "right-click pan", "wheel: zoom");
    }

    public LabelsListLayout buildLabelsListLayout() {
        LabelsListLayout l = new LabelsListLayout();
        int w = 260;
        int x = this.width - w - 10;
        int y = this.panelTop();
        l.panel = new IntRect(x, y, w, this.height - y - 10);
        l.titleY = y + 10;
        int btnY = l.titleY + 18 + 12;
        l.deselectBtn = new IntRect(x + 10, btnY, 90, 22);
        return l;
    }

    public void populateLabelsListRows(LabelsListLayout layout) {
        layout.rows.clear();
        int labelX = layout.panel.x + 10;
        int startY = layout.deselectBtn.y + layout.deselectBtn.h + 12;
        int maxY = layout.panel.y + layout.panel.h - 12;
        int viewH = Main.max((int)0, (int)(maxY - startY));
        int rowH = 24;
        int rowGap = 6;
        int totalRows = this.mapModel != null && this.mapModel.labels != null ? this.mapModel.labels.size() : 0;
        int contentH = totalRows > 0 ? totalRows * (rowH + rowGap) - rowGap : 0;
        layout.rowsStartY = startY;
        layout.rowsViewH = viewH;
        layout.contentH = contentH;
        layout.scrollbar = new IntRect(layout.panel.x + layout.panel.w - 14, startY, 14, viewH);
        this.labelsListScroll = this.clampScroll(this.labelsListScroll, contentH, viewH);
        int curY = startY - Main.round((float)this.labelsListScroll);
        int i = 0;
        while (i < totalRows) {
            if (curY > maxY) break;
            if (curY + rowH < startY) {
                curY += rowH + rowGap;
            } else {
                LabelRowLayout row = new LabelRowLayout();
                row.index = i;
                int selectW = 18;
                row.selectRect = new IntRect(labelX, curY, selectW, rowH);
                row.nameRect = new IntRect(labelX + selectW + 6, curY, layout.panel.w - 20 - 14 - selectW - 6 - 30, rowH);
                row.delRect = new IntRect(row.nameRect.x + row.nameRect.w + 4, curY, 24, rowH);
                layout.rows.add(row);
                curY += rowH + rowGap;
            }
            ++i;
        }
    }

    public void drawLabelsListPanel() {
        LabelsListLayout layout = this.buildLabelsListLayout();
        this.populateLabelsListRows(layout);
        this.drawPanelBackground(layout.panel);
        int labelX = layout.panel.x + 10;
        int curY = layout.titleY;
        this.fill(0);
        this.textAlign(37, 101);
        this.text("Labels", labelX, curY);
        curY += 30;
        this.drawBevelButton(layout.deselectBtn.x, layout.deselectBtn.y, layout.deselectBtn.w, layout.deselectBtn.h, false);
        this.fill(10);
        this.textAlign(3, 3);
        this.text("Deselect", layout.deselectBtn.x + layout.deselectBtn.w / 2, layout.deselectBtn.y + layout.deselectBtn.h / 2);
        this.registerUiTooltip(layout.deselectBtn, this.tooltipFor("labels_deselect"));
        curY = layout.deselectBtn.y + layout.deselectBtn.h + 12;
        int i = 0;
        while (i < layout.rows.size()) {
            LabelRowLayout row = layout.rows.get(i);
            if (row.index >= 0 && row.index < this.mapModel.labels.size()) {
                boolean editing;
                MapLabel lbl = this.mapModel.labels.get(row.index);
                boolean selected = this.selectedLabelIndex == row.index;
                this.drawRadioButton(row.selectRect, selected);
                boolean bl = editing = this.editingLabelIndex == row.index;
                if (editing) {
                    this.stroke(60);
                    this.fill(255);
                    this.rect(row.nameRect.x, row.nameRect.y, row.nameRect.w, row.nameRect.h);
                    this.fill(0);
                    this.textAlign(37, 3);
                    this.text(this.labelDraft, row.nameRect.x + 6, row.nameRect.y + row.nameRect.h / 2);
                    float caretX = (float)(row.nameRect.x + 6) + this.textWidth(this.labelDraft);
                    this.stroke(0);
                    this.line(caretX, row.nameRect.y + 4, caretX, row.nameRect.y + row.nameRect.h - 4);
                } else {
                    this.drawBevelButton(row.nameRect.x, row.nameRect.y, row.nameRect.w, row.nameRect.h, selected);
                    this.fill(10);
                    this.textAlign(37, 3);
                    this.text(lbl.text, row.nameRect.x + 6, row.nameRect.y + row.nameRect.h / 2);
                }
                this.drawBevelButton(row.delRect.x, row.delRect.y, row.delRect.w, row.delRect.h, false);
                this.fill(10);
                this.textAlign(3, 3);
                this.text("X", row.delRect.x + row.delRect.w / 2, row.delRect.y + row.delRect.h / 2);
            }
            ++i;
        }
        this.drawScrollbar(layout.scrollbar, layout.contentH, this.labelsListScroll);
    }

    public String labelTargetShort(LabelTarget lt) {
        switch (lt) {
            case BIOME: {
                return "B";
            }
            case ZONE: {
                return "Z";
            }
            case STRUCTURE: {
                return "S";
            }
        }
        return "F";
    }

    public void resetUiTooltips() {
        this.uiTooltipAreas.clear();
        this.currentUiTooltip = "";
    }

    public void registerUiTooltip(IntRect rect, String text) {
        if (rect == null || text == null || text.length() == 0) {
            return;
        }
        this.uiTooltipAreas.add(new UITooltipArea(rect, text));
        if ((this.currentUiTooltip == null || this.currentUiTooltip.length() == 0) && rect.contains(this.mouseX, this.mouseY)) {
            this.currentUiTooltip = text;
        }
    }

    public void refreshUiTooltip(int mx, int my) {
        this.currentUiTooltip = "";
        int i = this.uiTooltipAreas.size() - 1;
        while (i >= 0) {
            UITooltipArea entry = this.uiTooltipAreas.get(i);
            if (entry != null && entry.rect != null && entry.rect.contains(mx, my)) {
                this.currentUiTooltip = entry.text;
                return;
            }
            --i;
        }
    }

    public void drawUiTooltipPanel() {
        if (this.currentUiTooltip == null || this.currentUiTooltip.length() == 0) {
            return;
        }
        int panelW = Main.min((int)480, (int)(this.width - 20));
        if (panelW < 100) {
            return;
        }
        String[] lines = this.currentUiTooltip.split("\\n");
        int lineCount = lines.length;
        float lineHeight = 16.0f;
        int effectiveLines = Main.max((int)3, (int)lineCount);
        float panelH = (float)effectiveLines * lineHeight + 20.0f;
        int x = 10;
        int y = this.height - 10 - Main.round((float)panelH);
        this.noStroke();
        this.fill(255.0f, 255.0f, 255.0f, 230.0f);
        this.rect(x, y, panelW, panelH, 6.0f);
        this.fill(20);
        this.textAlign(37, 101);
        float ty = y + 10;
        String[] stringArray = lines;
        int n = lines.length;
        int n2 = 0;
        while (n2 < n) {
            String line = stringArray[n2];
            this.text(line, x + 10, ty);
            ty += lineHeight;
            ++n2;
        }
    }

    public static void main(String[] passedArgs) {
        String[] appletArgs = new String[]{"Main"};
        if (passedArgs != null) {
            PApplet.main((String[])Main.concat((String[])appletArgs, (String[])passedArgs));
        } else {
            PApplet.main((String[])appletArgs);
        }
    }

    class BiomesLayout {
        IntRect panel;
        int titleY;
        IntRect paintBtn;
        IntRect fillBtn;
        IntRect genModeSelector;
        IntRect genApplyBtn;
        IntRect genValueSlider;
        IntRect genValueWaterBtn;
        IntRect addBtn;
        IntRect removeBtn;
        ArrayList<IntRect> swatches = new ArrayList();
        IntRect nameField;
        IntRect hueSlider;
        IntRect satSlider;
        IntRect briSlider;
        IntRect patternSlider;
        IntRect brushSlider;

        BiomesLayout() {
        }
    }

    class Cell {
        int siteIndex;
        ArrayList<PVector> vertices;
        int biomeId;
        float elevation = 0.0f;

        Cell(int siteIndex, ArrayList<PVector> vertices, int biomeId) {
            this.siteIndex = siteIndex;
            this.vertices = vertices;
            this.biomeId = biomeId;
        }

        public void draw(PApplet app, boolean showBorders) {
            if (this.vertices == null || this.vertices.size() < 3) {
                return;
            }
            app.pushStyle();
            int col = Main.this.color(230);
            if (Main.this.mapModel != null && Main.this.mapModel.biomeTypes != null && this.biomeId >= 0 && this.biomeId < Main.this.mapModel.biomeTypes.size()) {
                ZoneType zt = Main.this.mapModel.biomeTypes.get(this.biomeId);
                col = zt.col;
            }
            app.fill(col);
            if (showBorders) {
                app.stroke(180);
                app.strokeWeight(1.0f / Main.this.viewport.zoom);
            } else {
                app.noStroke();
            }
            app.beginShape();
            int i = 0;
            while (i < this.vertices.size()) {
                PVector v = this.vertices.get(i);
                app.vertex(v.x, v.y);
                ++i;
            }
            app.endShape(2);
            app.popStyle();
        }
    }

    static enum ContourJobType {
        COAST_DISTANCE,
        ELEVATION_SAMPLE;

    }

    class ElevationLayout {
        IntRect panel;
        int titleY;
        IntRect seaSlider;
        IntRect radiusSlider;
        IntRect strengthSlider;
        IntRect raiseBtn;
        IntRect lowerBtn;
        IntRect noiseSlider;
        IntRect perlinBtn;
        IntRect varyBtn;
        IntRect plateauBtn;

        ElevationLayout() {
        }
    }

    static enum ElevationLinesStyle {
        ELEV_LINES_BASIC;

    }

    static class ElevationRenderer {
        ElevationRenderer() {
        }

        public static void drawOverlay(MapModel model, PApplet app, float seaLevel, boolean showElevationContours, boolean drawWater, boolean drawElevation, boolean showWaterContours, boolean useLighting, float lightAzimuthDeg, float lightAltitudeDeg, int quantSteps) {
            if (model == null || model.cells == null) {
                return;
            }
            app.pushStyle();
            app.noStroke();
            PVector lightDir = null;
            if (useLighting) {
                float az = Main.radians((float)lightAzimuthDeg);
                float alt = Main.radians((float)lightAltitudeDeg);
                lightDir = new PVector(Main.cos((float)alt) * Main.cos((float)az), Main.cos((float)alt) * Main.sin((float)az), Main.sin((float)alt));
                lightDir.normalize();
            }
            int cellCount = model.cells.size();
            int ci = 0;
            while (ci < cellCount) {
                Cell c = model.cells.get(ci);
                if (c.vertices != null && c.vertices.size() >= 3) {
                    float levels;
                    float h = c.elevation;
                    PVector slope = null;
                    PVector cen = model.cellCentroid(c);
                    float light = 1.0f;
                    if (useLighting && lightDir != null) {
                        slope = ElevationRenderer.estimateCellSlope(model, ci);
                        light = ElevationRenderer.lightFromSlope(slope, lightDir);
                    }
                    if (drawElevation) {
                        float litShade;
                        float shade = Main.constrain((float)(h + 0.5f), (float)0.0f, (float)1.0f);
                        float baseShade = litShade = Main.constrain((float)(shade * light), (float)0.0f, (float)1.0f);
                        if (quantSteps > 1) {
                            levels = quantSteps - 1;
                            baseShade = (float)Main.round((float)(baseShade * levels)) / levels;
                        }
                        app.beginShape();
                        for (PVector v : c.vertices) {
                            float directional = 0.0f;
                            if (slope != null) {
                                float hDelta = slope.x * (v.x - cen.x) + slope.y * (v.y - cen.y);
                                directional = Main.constrain((float)(hDelta * 1.2f), (float)-0.14f, (float)0.14f);
                            }
                            float grain = (app.noise(v.x * 18.0f, v.y * 18.0f) - 0.5f) * 0.06f;
                            float vShade = Main.constrain((float)(baseShade + directional + grain), (float)0.0f, (float)1.0f);
                            int col = app.color(vShade * 255.0f);
                            app.fill(col, 150.0f);
                            app.vertex(v.x, v.y);
                        }
                        app.endShape(2);
                    }
                    if (drawWater && h < seaLevel) {
                        float shade;
                        float depth = seaLevel - h;
                        float depthNorm = Main.constrain((float)(depth / 1.0f), (float)0.0f, (float)1.0f);
                        float f = shade = drawElevation ? Main.lerp((float)0.25f, (float)0.65f, (float)(1.0f - depthNorm)) : 0.55f;
                        if (quantSteps > 1) {
                            levels = quantSteps - 1;
                            shade = (float)Main.round((float)(shade * levels)) / levels;
                        }
                        float baseR = 30.0f;
                        float baseG = 70.0f;
                        float baseB = 120.0f;
                        int water = app.color(baseR * shade, baseG * shade, baseB * shade, 255.0f);
                        app.fill(water);
                        app.beginShape();
                        for (PVector v : c.vertices) {
                            app.vertex(v.x, v.y);
                        }
                        app.endShape(2);
                    }
                }
                ++ci;
            }
            if (showElevationContours || showWaterContours) {
                float minWater;
                int cols = 90;
                int rows = 90;
                MapModel.ContourGrid grid = model.sampleElevationGrid(cols, rows, seaLevel);
                float minElev = grid.min;
                float maxElev = grid.max;
                if (showElevationContours) {
                    float range = Main.max((float)1.0E-4f, (float)(maxElev - seaLevel));
                    float step = Main.max((float)0.02f, (float)(range / 10.0f));
                    float start = (float)Main.ceil((float)(seaLevel / step)) * step;
                    int strokeCol = app.color(50, 50, 50, 180);
                    model.drawContourSet(app, grid, start, maxElev, step, strokeCol);
                }
                if (showWaterContours && drawWater && (minWater = minElev) < seaLevel - 1.0E-4f) {
                    float depthRange = seaLevel - minWater;
                    float step = Main.max((float)0.02f, (float)(depthRange / 5.0f));
                    float start = seaLevel - step;
                    int strokeCol = app.color(30, 70, 140, 170);
                    model.drawContourSet(app, grid, start, minWater, -step, strokeCol);
                }
            }
            app.popStyle();
        }

        private static PVector estimateCellSlope(MapModel model, int idx) {
            ArrayList<Integer> nbs;
            PVector slope = new PVector(0.0f, 0.0f);
            if (model == null || idx < 0 || idx >= model.cells.size()) {
                return slope;
            }
            ArrayList<Integer> arrayList = nbs = idx < model.cellNeighbors.size() ? model.cellNeighbors.get(idx) : null;
            if (nbs == null || nbs.isEmpty()) {
                return slope;
            }
            Cell c = model.cells.get(idx);
            PVector cen = model.cellCentroid(c);
            for (int nbIdx : nbs) {
                if (nbIdx < 0 || nbIdx >= model.cells.size()) continue;
                Cell nb = model.cells.get(nbIdx);
                PVector ncen = model.cellCentroid(nb);
                float dx = ncen.x - cen.x;
                float dy = ncen.y - cen.y;
                float dist = Main.sqrt((float)(dx * dx + dy * dy));
                if (dist < 1.0E-6f) continue;
                float dh = nb.elevation - c.elevation;
                float w = 1.0f / dist;
                slope.x += dh * (dx / dist) * w;
                slope.y += dh * (dy / dist) * w;
            }
            return slope;
        }

        private static float lightFromSlope(PVector slope, PVector lightDir) {
            if (lightDir == null) {
                return 1.0f;
            }
            PVector normal = new PVector(-slope.x, -slope.y, 1.0f);
            if (normal.magSq() < 1.0E-8f) {
                normal.set(0.0f, 0.0f, 1.0f);
            } else {
                normal.normalize();
            }
            float d = Main.max((float)0.0f, (float)(normal.x * lightDir.x + normal.y * lightDir.y + normal.z * lightDir.z));
            float ambient = 0.35f;
            return Main.constrain((float)(ambient + (1.0f - ambient) * d), (float)0.0f, (float)1.0f);
        }

        public static float computeLightForCell(MapModel model, int idx, PVector lightDir) {
            PVector slope = ElevationRenderer.estimateCellSlope(model, idx);
            return ElevationRenderer.lightFromSlope(slope, lightDir);
        }
    }

    class ExportLayout {
        IntRect panel;
        int titleY;
        int bodyY;
        IntRect pngBtn;
        IntRect svgBtn;
        IntRect geoJsonBtn;
        int exportScaleLabelY;
        IntRect setResolutionBtn;
        IntRect mapExportBtn;
        IntRect mapImportBtn;
        int mapSectionY;
        int statusY;

        ExportLayout() {
        }
    }

    class IntRect {
        int x;
        int y;
        int w;
        int h;

        IntRect() {
        }

        IntRect(int x, int y, int w, int h) {
            this.x = x;
            this.y = y;
            this.w = w;
            this.h = h;
        }

        public boolean contains(int px, int py) {
            return px >= this.x && px <= this.x + this.w && py >= this.y && py <= this.y + this.h;
        }
    }

    class LabelRenderer {
        private final MapModel model;
        private final HashMap<String, PFont> labelFontCache = new HashMap();
        private String labelFontName;
        private PGraphics labelLayer;
        private int labelLayerW;
        private int labelLayerH;

        LabelRenderer(MapModel model) {
            this.labelFontName = Main.this.LABEL_FONT_OPTIONS != null && Main.this.LABEL_FONT_OPTIONS.length > 0 ? Main.this.LABEL_FONT_OPTIONS[0] : "SansSerif";
            this.labelLayer = null;
            this.labelLayerW = 0;
            this.labelLayerH = 0;
            this.model = model;
        }

        public void drawLabels(PApplet app) {
            if (this.model.labels == null) {
                return;
            }
            app.pushStyle();
            app.textAlign(3, 3);
            for (MapLabel l : this.model.labels) {
                if (l == null || l.text == null) continue;
                float ts = l.size;
                this.drawTextWithOutline(app, Main.this.renderSettings, l.text, l.x, l.y, ts, 0.2f, 1.0f, 0.0f, false, this.resolveLabelFontName(Main.this.renderSettings));
            }
            app.popStyle();
        }

        public void drawLabelsRender(PApplet app, RenderSettings s) {
            if (this.model.labels == null || s == null) {
                return;
            }
            if (!s.showLabelsArbitrary) {
                return;
            }
            app.pushStyle();
            app.textAlign(3, 3);
            String fontName = this.resolveLabelFontName(s);
            boolean snap = Main.this.currentTool != Tool.EDIT_EXPORT;
            for (MapLabel l : this.model.labels) {
                if (l == null) continue;
                float ts = s.labelSizeArbPx > 0.0f ? s.labelSizeArbPx : l.size;
                this.drawTextWithOutline(app, s, l.text, l.x, l.y, ts, s.labelOutlineAlpha01, s.labelOutlineSizePx, 0.0f, snap, fontName);
            }
            app.popStyle();
        }

        public void drawZoneLabelsRender(PApplet app, RenderSettings s) {
            if (this.model == null || this.model.zones == null || s == null) {
                return;
            }
            if (!s.showLabelsZones) {
                return;
            }
            app.pushStyle();
            app.fill(0);
            app.textAlign(3, 3);
            float baseSize = s.labelSizeZonePx > 0.0f ? s.labelSizeZonePx : Main.this.labelSizeDefault();
            String fontName = this.resolveLabelFontName(s);
            for (MapModel.MapZone z : this.model.zones) {
                if (z == null || z.cells == null || z.cells.isEmpty()) continue;
                float cx = 0.0f;
                float cy = 0.0f;
                int count = 0;
                for (int ci : z.cells) {
                    Cell c;
                    if (ci < 0 || ci >= this.model.cells.size() || (c = this.model.cells.get(ci)) == null || c.vertices == null || c.vertices.size() < 3) continue;
                    PVector cen = this.model.cellCentroid(c);
                    cx += cen.x;
                    cy += cen.y;
                    ++count;
                }
                if (count <= 0) continue;
                float ts = baseSize;
                boolean snap = Main.this.currentTool != Tool.EDIT_EXPORT;
                this.drawTextWithOutline(app, s, z.name != null ? z.name : "Zone", cx /= (float)count, cy /= (float)count, ts, s.labelOutlineAlpha01, s.labelOutlineSizePx, 0.0f, snap, fontName);
            }
            app.popStyle();
        }

        public void drawPathLabelsRender(PApplet app, RenderSettings s) {
            if (this.model == null || this.model.paths == null || s == null) {
                return;
            }
            if (!s.showLabelsPaths) {
                return;
            }
            app.pushStyle();
            app.fill(0);
            app.textAlign(3, 3);
            float baseSize = s.labelSizePathPx > 0.0f ? s.labelSizePathPx : Main.this.labelSizeDefault();
            String fontName = this.resolveLabelFontName(s);
            for (Path p : this.model.paths) {
                if (p == null || p.routes == null || p.routes.isEmpty()) continue;
                String txt = p.name != null && p.name.length() > 0 ? p.name : "";
                PVector bestA = null;
                PVector bestB = null;
                float bestLenSq = -1.0f;
                for (ArrayList<PVector> route : p.routes) {
                    if (route == null || route.size() < 2) continue;
                    int i = 0;
                    while (i < route.size() - 1) {
                        PVector a = route.get(i);
                        PVector b = route.get(i + 1);
                        float dx = b.x - a.x;
                        float dy = b.y - a.y;
                        float lenSq = dx * dx + dy * dy;
                        if (lenSq > bestLenSq) {
                            bestLenSq = lenSq;
                            bestA = a;
                            bestB = b;
                        }
                        ++i;
                    }
                }
                if (bestA == null || bestB == null || bestLenSq <= 1.0E-8f) continue;
                float ts = baseSize;
                float angle = Main.atan2((float)(bestB.y - bestA.y), (float)(bestB.x - bestA.x));
                if (angle > 1.5707964f || angle < -1.5707964f) {
                    angle += (float)Math.PI;
                }
                float mx = (bestA.x + bestB.x) * 0.5f;
                float my = (bestA.y + bestB.y) * 0.5f;
                boolean snap = Main.this.currentTool != Tool.EDIT_EXPORT;
                this.drawTextWithOutline(app, s, txt, mx, my, ts, s.labelOutlineAlpha01, s.labelOutlineSizePx, angle, snap, fontName);
            }
            app.popStyle();
        }

        public void drawStructureLabelsRender(PApplet app, RenderSettings s) {
            if (this.model == null || this.model.structures == null || s == null) {
                return;
            }
            if (!s.showLabelsStructures) {
                return;
            }
            app.pushStyle();
            app.fill(0);
            app.textAlign(3, 3);
            float baseSize = s.labelSizeStructPx > 0.0f ? s.labelSizeStructPx : Main.this.labelSizeDefault();
            String fontName = this.resolveLabelFontName(s);
            boolean snap = Main.this.currentTool != Tool.EDIT_EXPORT;
            for (Structure st : this.model.structures) {
                if (st == null) continue;
                String txt = st.name != null && st.name.length() > 0 ? st.name : "";
                float ts = baseSize;
                this.drawTextWithOutline(app, s, txt, st.x, st.y, ts, s.labelOutlineAlpha01, s.labelOutlineSizePx, 0.0f, snap, fontName);
            }
            app.popStyle();
        }

        public PGraphics buildLabelLayer(PApplet app, RenderSettings s) {
            PGraphics lg = this.ensureLabelLayer(app);
            if (lg == null) {
                return null;
            }
            try {
                if (s != null && s.antialiasing) {
                    lg.smooth();
                } else {
                    lg.noSmooth();
                }
                lg.beginDraw();
                lg.clear();
                PGraphics prev = app.g;
                app.g = lg;
                if (s != null) {
                    if (s.showLabelsZones) {
                        this.drawZoneLabelsRender(app, s);
                    }
                    if (s.showLabelsPaths) {
                        this.drawPathLabelsRender(app, s);
                    }
                    if (s.showLabelsStructures) {
                        this.drawStructureLabelsRender(app, s);
                    }
                    if (s.showLabelsArbitrary) {
                        this.drawLabelsRender(app, s);
                    }
                }
                app.g = prev;
                lg.endDraw();
            }
            catch (Exception ex) {
                Main.println((String)("Label layer build failed: " + ex));
                lg = null;
            }
            return lg;
        }

        public void warmLabelFonts(PApplet app, RenderSettings s) {
            if (app == null) {
                return;
            }
            String fontName = this.resolveLabelFontName(s);
            HashSet<Integer> sizes = new HashSet<Integer>();
            sizes.add(Main.max((int)1, (int)Main.round((float)Main.this.labelSizeDefault())));
            if (s != null) {
                sizes.add(Main.max((int)1, (int)Main.round((float)(s.labelSizeArbPx > 0.0f ? s.labelSizeArbPx : Main.this.labelSizeDefault()))));
                sizes.add(Main.max((int)1, (int)Main.round((float)(s.labelSizeZonePx > 0.0f ? s.labelSizeZonePx : Main.this.labelSizeDefault()))));
                sizes.add(Main.max((int)1, (int)Main.round((float)(s.labelSizePathPx > 0.0f ? s.labelSizePathPx : Main.this.labelSizeDefault()))));
                sizes.add(Main.max((int)1, (int)Main.round((float)(s.labelSizeStructPx > 0.0f ? s.labelSizeStructPx : Main.this.labelSizeDefault()))));
            }
            Iterator iterator = sizes.iterator();
            while (iterator.hasNext()) {
                int sz = (Integer)iterator.next();
                this.labelFont(app, sz, fontName);
            }
        }

        private String resolveLabelFontName(RenderSettings s) {
            if (Main.this.LABEL_FONT_OPTIONS != null && Main.this.LABEL_FONT_OPTIONS.length > 0) {
                int idx = 0;
                if (s != null) {
                    idx = Main.constrain((int)s.labelFontIndex, (int)0, (int)(Main.this.LABEL_FONT_OPTIONS.length - 1));
                }
                return Main.this.LABEL_FONT_OPTIONS[idx];
            }
            return "SansSerif";
        }

        private PFont labelFont(PApplet app, int sizePx, String desiredFont) {
            int key = Main.max((int)1, (int)sizePx);
            String fontKey = desiredFont != null && desiredFont.length() > 0 ? desiredFont : this.labelFontName;
            String cacheKey = String.valueOf(fontKey) + "|" + key;
            PFont f = this.labelFontCache.get(cacheKey);
            if (f == null) {
                String[] fonts;
                String chosen = fontKey;
                try {
                    f = app.createFont(chosen, (float)key, true);
                }
                catch (Exception exception) {}
                if (f == null && (fonts = PFont.list()) != null && fonts.length > 0) {
                    chosen = fonts[0];
                    try {
                        f = app.createFont(chosen, (float)key, true);
                    }
                    catch (Exception exception) {}
                }
                if (f == null) {
                    f = app.createFont("SansSerif", (float)key, true);
                }
                this.labelFontCache.put(cacheKey, f);
                this.labelFontName = chosen;
            }
            return f;
        }

        public void drawTextWithOutline(PApplet app, RenderSettings rs, String txt, float x, float y, float ts, float outlineAlpha01, float outlineSizePx, float angleRad, boolean snapToPixel, String fontName) {
            if (app == null || txt == null) {
                return;
            }
            try {
                float ref;
                RenderSettings s = rs != null ? rs : Main.this.renderSettings;
                this.ensureFontMapReady(app.g);
                float finalSize = ts;
                float outlineSize = outlineSizePx;
                float canvasW = app.g != null ? app.g.width : app.width;
                float canvasH = app.g != null ? app.g.height : app.height;
                float resolutionScale = 1.0f;
                if (Main.this.renderingForExport) {
                    float baseW = Main.max((int)1, (int)Main.this.width);
                    float baseH = Main.max((int)1, (int)Main.this.height);
                    resolutionScale = Main.max((float)(canvasW / baseW), (float)(canvasH / baseH));
                }
                if (s != null && s.labelScaleWithZoom) {
                    ref = s.labelScaleRefZoom > 1.0E-6f ? s.labelScaleRefZoom : 600.0f;
                    finalSize = ts * (Main.max((float)1.0E-6f, (float)Main.this.viewport.zoom) / ref) * resolutionScale;
                }
                if (s != null && s.labelOutlineScaleWithZoom) {
                    ref = s.labelScaleRefZoom > 1.0E-6f ? s.labelScaleRefZoom : 600.0f;
                    outlineSize = outlineSizePx * (Main.max((float)1.0E-6f, (float)Main.this.viewport.zoom) / ref) * resolutionScale;
                }
                finalSize = Main.constrain((float)finalSize, (float)4.0f, (float)128.0f);
                outlineSize = Main.constrain((float)outlineSize, (float)0.0f, (float)64.0f);
                PVector screen = Main.this.viewport.worldToScreen(x, y, canvasW, canvasH);
                if (snapToPixel && !Main.this.renderingForExport) {
                    screen.x = Main.round((float)screen.x);
                    screen.y = Main.round((float)screen.y);
                }
                app.pushMatrix();
                app.resetMatrix();
                app.translate(screen.x, screen.y);
                app.rotate(angleRad);
                int fontSize = Main.max((int)1, (int)Main.round((float)finalSize));
                PFont font = this.labelFont(app, fontSize, fontName);
                if (font != null) {
                    app.textFont(font);
                    app.textSize((float)fontSize);
                } else {
                    app.textSize((float)fontSize);
                }
                float oa = Main.constrain((float)outlineAlpha01, (float)0.0f, (float)1.0f);
                int radius = Main.max((int)0, (int)Main.round((float)outlineSize));
                if (oa > 1.0E-4f) {
                    app.fill(255, oa * 255.0f);
                    int dx = -radius;
                    while (dx <= radius) {
                        int dy = -radius;
                        while (dy <= radius) {
                            if (dx != 0 || dy != 0) {
                                app.text(txt, (float)dx, (float)dy);
                            }
                            ++dy;
                        }
                        ++dx;
                    }
                }
                app.fill(0);
                app.text(txt, 0.0f, 0.0f);
                app.popMatrix();
            }
            catch (Exception ex) {
                Main.println((String)("Label draw skipped due to error: " + ex));
            }
        }

        private void ensureFontMapReady(PGraphics pg) {
            block12: {
                if (pg == null) {
                    return;
                }
                try {
                    if (!(pg instanceof PGraphicsOpenGL)) break block12;
                    PGraphicsOpenGL ogl = (PGraphicsOpenGL)pg;
                    Field fontField = this.findFontMapField(ogl.getClass());
                    if (fontField == null) {
                        return;
                    }
                    fontField.setAccessible(true);
                    Object map = fontField.get(ogl);
                    Object primary = null;
                    Field primaryFontField = null;
                    try {
                        Method primaryMeth = ogl.getClass().getMethod("getPrimaryPG", new Class[0]);
                        primary = primaryMeth.invoke((Object)ogl, new Object[0]);
                        if (primary != null && (primaryFontField = this.findFontMapField(primary.getClass())) != null) {
                            primaryFontField.setAccessible(true);
                        }
                    }
                    catch (Exception exception) {}
                    if (primary != null && primaryFontField != null) {
                        Object pMap = primaryFontField.get(primary);
                        if (pMap == null) {
                            pMap = map != null ? map : new WeakHashMap();
                            primaryFontField.set(primary, pMap);
                        }
                        if (map == null) {
                            map = pMap;
                            fontField.set(ogl, map);
                        }
                    }
                    if (map == null) {
                        map = new WeakHashMap();
                        fontField.set(ogl, map);
                        if (primary != null && primaryFontField != null && primaryFontField.get(primary) == null) {
                            primaryFontField.set(primary, map);
                        }
                    }
                }
                catch (Exception ex) {
                    Main.println((String)("Font map init skipped: " + ex));
                }
            }
        }

        private Field findFontMapField(Class<?> cls) {
            Class<?> cur = cls;
            while (cur != null) {
                try {
                    return cur.getDeclaredField("fontMap");
                }
                catch (NoSuchFieldException noSuchFieldException) {
                    cur = cur.getSuperclass();
                }
            }
            return null;
        }

        private PGraphics ensureLabelLayer(PApplet app) {
            boolean sizeChanged;
            if (app == null) {
                return null;
            }
            int targetW = app.g != null ? app.g.width : app.width;
            int targetH = app.g != null ? app.g.height : app.height;
            boolean bl = sizeChanged = this.labelLayer == null || this.labelLayerW != targetW || this.labelLayerH != targetH;
            if (sizeChanged) {
                this.labelLayerW = targetW;
                this.labelLayerH = targetH;
                this.labelLayer = null;
                try {
                    this.labelLayer = app.createGraphics(targetW, targetH, "processing.awt.PGraphicsJava2D");
                }
                catch (Exception exception) {}
                if (this.labelLayer == null) {
                    try {
                        this.labelLayer = app.createGraphics(targetW, targetH, "processing.opengl.PGraphics2D");
                    }
                    catch (Exception exception) {}
                }
            }
            return this.labelLayer;
        }
    }

    class LabelRowLayout {
        int index;
        IntRect selectRect;
        IntRect nameRect;
        IntRect delRect;

        LabelRowLayout() {
        }
    }

    static enum LabelTarget {
        FREE,
        BIOME,
        ZONE,
        PATH,
        STRUCTURE;

    }

    class LabelsLayout {
        IntRect panel;
        int titleY;
        IntRect genButton;
        IntRect commentField;

        LabelsLayout() {
        }
    }

    class LabelsListLayout {
        IntRect panel;
        int titleY;
        IntRect deselectBtn;
        ArrayList<LabelRowLayout> rows = new ArrayList();
        int rowsStartY;
        int rowsViewH;
        float contentH;
        IntRect scrollbar;

        LabelsListLayout() {
        }
    }

    class MapLabel {
        float x;
        float y;
        String text;
        LabelTarget target = LabelTarget.FREE;
        float size;
        String comment;

        MapLabel(float x, float y, String text) {
            this.size = Main.this.labelSizeDefault();
            this.comment = "";
            this.x = x;
            this.y = y;
            this.text = text;
        }

        MapLabel(float x, float y, String text, LabelTarget target) {
            this(x, y, text);
            this.target = target;
        }

        public void draw(PApplet app) {
            if (app == null || this.text == null || this.text.length() == 0) {
                return;
            }
            float ts = this.size / Main.max((float)1.0E-6f, (float)Main.this.viewport.zoom);
            app.pushStyle();
            app.fill(0);
            app.textAlign(3, 3);
            app.textSize(ts);
            app.text(this.text, this.x, this.y);
            app.popStyle();
        }
    }

    class MapModel {
        final float ZONE_BASE_SAT = 0.78f;
        final float ZONE_BASE_BRI = 0.9f;
        float minX = 0.0f;
        float minY = 0.0f;
        float maxX = 1.0f;
        float maxY = 1.0f;
        ArrayList<Site> sites = new ArrayList();
        ArrayList<Cell> cells = new ArrayList();
        ContourGrid cachedCoastGrid = null;
        CoastSpatialIndex cachedCoastIndex = null;
        float cachedCoastSeaLevel = Float.MAX_VALUE;
        int cachedCoastCols = 0;
        int cachedCoastRows = 0;
        int cachedCoastCellCount = -1;
        boolean coastCacheValid = false;
        ContourGrid cachedElevationGrid = null;
        float cachedElevationSeaLevel = Float.MAX_VALUE;
        int cachedElevationCols = 0;
        int cachedElevationRows = 0;
        int cachedElevationCellCount = -1;
        boolean elevationCacheValid = false;
        ContourJob coastJob = null;
        ContourJob elevationJob = null;
        ArrayList<Path> paths = new ArrayList();
        ArrayList<PathType> pathTypes = new ArrayList();
        ArrayList<ZoneType> biomeTypes = new ArrayList();
        ArrayList<MapZone> zones = new ArrayList();
        ArrayList<String> biomePatternFiles = new ArrayList();
        int biomePatternCount = 1;
        ArrayList<ArrayList<Integer>> cellNeighbors = new ArrayList();
        ArrayList<Structure> structures = new ArrayList();
        ArrayList<MapLabel> labels = new ArrayList();
        float lastPathfindMs = 0.0f;
        int lastPathfindExpanded = 0;
        int lastPathfindLength = 0;
        boolean lastPathfindHit = false;
        float lastSnapBuildMs = 0.0f;
        int lastSnapNodeCount = 0;
        int lastSnapEdgeCount = 0;
        boolean voronoiDirty = true;
        boolean snapDirty = true;
        ArrayList<Cell> preservedCells = null;
        VoronoiJob voronoiJob = null;
        float voronoiProgress = 0.0f;
        final int VORONOI_BATCH = 120;
        HashMap<String, PVector> snapNodes = new HashMap();
        HashMap<String, ArrayList<String>> snapAdj = new HashMap();
        MapRenderer renderer;

        MapModel() {
            this.renderer = new MapRenderer(this);
        }

        public HashMap<String, Float> computeTaperWeightsForType(int typeId, float baseWeight, float minWeight) {
            Object ka;
            HashMap<String, Float> weights = new HashMap<String, Float>();
            if (this.paths == null || this.paths.isEmpty()) {
                return weights;
            }
            PathType t = this.getPathType(typeId);
            if (t == null || !t.taperOn) {
                return weights;
            }
            this.ensureCellNeighborsComputed();
            class SegNode {
                int pIdx;
                int rIdx;
                int sIdx;
                PVector a;
                PVector b;

                SegNode() {
                }
            }
            ArrayList<SegNode> segs = new ArrayList<SegNode>();
            HashMap<String, ArrayList> adj = new HashMap<String, ArrayList>();
            HashSet<Object> waterVerts = new HashSet<Object>();
            int pi = 0;
            while (pi < this.paths.size()) {
                Path p = this.paths.get(pi);
                if (p != null && p.typeId == typeId && p.routes != null) {
                    int ri = 0;
                    while (ri < p.routes.size()) {
                        ArrayList<PVector> route = p.routes.get(ri);
                        if (route != null && route.size() >= 2) {
                            int si = 0;
                            while (si < route.size() - 1) {
                                PVector a = (PVector)route.get(si);
                                PVector b = (PVector)route.get(si + 1);
                                SegNode sn = new SegNode();
                                sn.pIdx = pi;
                                sn.rIdx = ri;
                                sn.sIdx = si;
                                sn.a = a;
                                sn.b = b;
                                segs.add(sn);
                                ka = this.keyFor(a.x, a.y);
                                String kb = this.keyFor(b.x, b.y);
                                if (this.pointTouchesWater(a.x, a.y, Main.this.seaLevel)) {
                                    waterVerts.add(ka);
                                }
                                if (this.pointTouchesWater(b.x, b.y, Main.this.seaLevel)) {
                                    waterVerts.add(kb);
                                }
                                adj.computeIfAbsent((String)ka, k -> new ArrayList()).add(sn);
                                adj.computeIfAbsent(kb, k -> new ArrayList()).add(sn);
                                ++si;
                            }
                        }
                        ++ri;
                    }
                }
                ++pi;
            }
            HashMap<SegNode, Integer> closeness = new HashMap<SegNode, Integer>();
            ArrayDeque<SegNode> dq = new ArrayDeque<SegNode>();
            for (SegNode sn : segs) {
                String ka2 = this.keyFor(sn.a.x, sn.a.y);
                String kb = this.keyFor(sn.b.x, sn.b.y);
                if (!waterVerts.contains(ka2) && !waterVerts.contains(kb)) continue;
                closeness.put(sn, 0);
                dq.add(sn);
            }
            while (!dq.isEmpty()) {
                String[] keys;
                SegNode cur = (SegNode)dq.removeFirst();
                int baseC = (Integer)closeness.get(cur);
                ka = keys = new String[]{this.keyFor(cur.a.x, cur.a.y), this.keyFor(cur.b.x, cur.b.y)};
                int sn = keys.length;
                int b = 0;
                while (b < sn) {
                    String k2 = ka[b];
                    ArrayList list = (ArrayList)adj.get(k2);
                    if (list != null) {
                        for (SegNode nb : list) {
                            if (nb == cur) continue;
                            int nc = baseC + 1;
                            Integer prev = (Integer)closeness.get(nb);
                            if (prev != null && nc >= prev) continue;
                            closeness.put(nb, nc);
                            dq.addLast(nb);
                        }
                    }
                    ++b;
                }
            }
            float longestWaterChain = 0.0f;
            for (Integer c : closeness.values()) {
                longestWaterChain = Main.max((float)longestWaterChain, (float)c.intValue());
            }
            for (SegNode sn : segs) {
                int c = closeness.containsKey(sn) ? (Integer)closeness.get(sn) : 100;
                float tNorm = Main.constrain((float)((float)c / longestWaterChain), (float)0.0f, (float)1.0f);
                float w = Main.lerp((float)baseWeight, (float)minWeight, (float)tNorm);
                String ek = String.valueOf(sn.pIdx) + ":" + sn.rIdx + ":" + sn.sIdx;
                weights.put(ek, Float.valueOf(w));
            }
            return weights;
        }

        public float[] rgbToHSB(int c) {
            float[] hsb = new float[3];
            Main.this.rgbToHSB01(c, hsb);
            return hsb;
        }

        public float[] zoneBaseSatBri() {
            float[] sb = new float[]{0.78f, 0.9f};
            return sb;
        }

        public int zoneColorForHue(float hue) {
            float[] sb = this.zoneBaseSatBri();
            return Main.this.hsb01ToARGB(hue, sb[0], sb[1], 1.0f);
        }

        public float hueDistance01(float a, float b) {
            float d = Main.abs((float)(a - b));
            return Main.min((float)d, (float)(1.0f - d));
        }

        public float pickMaxGapHue() {
            if (this.zones == null || this.zones.isEmpty()) {
                return 0.0f;
            }
            ArrayList<Float> hs = new ArrayList<Float>();
            for (MapZone z : this.zones) {
                if (z == null) continue;
                float h = z.hue01 % 1.0f;
                if (h < 0.0f) {
                    h += 1.0f;
                }
                hs.add(Float.valueOf(h));
            }
            if (hs.isEmpty()) {
                return 0.0f;
            }
            int samples = 720;
            float bestHue = 0.0f;
            float bestScore = -1.0f;
            int i = 0;
            while (i < samples) {
                float h = (float)i / (float)samples;
                float minD = 1.0f;
                Iterator iterator = hs.iterator();
                while (iterator.hasNext()) {
                    float hz = ((Float)iterator.next()).floatValue();
                    if ((minD = Main.min((float)minD, (float)this.hueDistance01(h, hz))) < bestScore) break;
                }
                if (minD > bestScore) {
                    bestScore = minD;
                    bestHue = h;
                }
                ++i;
            }
            return bestHue;
        }

        public float distributedHueForIndex(int idx) {
            int n = Main.max((int)0, (int)idx);
            float v = 0.0f;
            float denom = 2.0f;
            while (n > 0) {
                v += (float)(n & 1) * (1.0f / denom);
                denom *= 2.0f;
                n >>= 1;
            }
            return v;
        }

        public void drawDebugWorldBounds(PApplet app) {
            this.renderer.drawDebugWorldBounds(app);
        }

        public void drawSites(PApplet app) {
            this.renderer.drawSites(app);
        }

        public void drawCells(PApplet app) {
            this.renderer.drawCells(app);
        }

        public void drawCells(PApplet app, boolean showBorders) {
            this.renderer.drawCells(app, showBorders);
        }

        public void drawCellsRender(PApplet app, boolean showBorders) {
            this.renderer.drawCellsRender(app, showBorders);
        }

        public void drawCellsRender(PApplet app, boolean showBorders, boolean desaturate) {
            this.renderer.drawCellsRender(app, showBorders, desaturate);
        }

        public void drawStructures(PApplet app) {
            this.renderer.drawStructures(app);
        }

        public void drawLabels(PApplet app) {
            this.renderer.drawLabels(app);
        }

        public void drawLabelsRender(PApplet app, RenderSettings s) {
            this.renderer.drawLabelsRender(app, s);
        }

        public void drawZoneLabelsRender(PApplet app, RenderSettings s) {
            this.renderer.drawZoneLabelsRender(app, s);
        }

        public void drawPathLabelsRender(PApplet app, RenderSettings s) {
            this.renderer.drawPathLabelsRender(app, s);
        }

        public void drawStructureLabelsRender(PApplet app, RenderSettings s) {
            this.renderer.drawStructureLabelsRender(app, s);
        }

        public void drawZoneOutlinesRender(PApplet app, RenderSettings s) {
            this.renderer.drawZoneOutlinesRender(app, s);
        }

        public void drawStructuresRender(PApplet app, RenderSettings s) {
            this.renderer.drawStructuresRender(app, s);
        }

        public void drawRenderAdvanced(PApplet app, RenderSettings settings, float seaLevel) {
            this.renderer.drawRenderAdvanced(app, settings, seaLevel);
        }

        public void drawZoneOutlines(PApplet app) {
            this.renderer.drawZoneOutlines(app);
        }

        public void drawCoastContourLines(PApplet app, float seaLevel, int lines, float spacingFactor) {
            ArrayList<PVector[]> coastSegs;
            int cols;
            if (this.cells == null || this.cells.isEmpty()) {
                return;
            }
            this.ensureCellNeighborsComputed();
            float worldW = this.maxX - this.minX;
            float worldH = this.maxY - this.minY;
            float desiredSpacing = Main.max((float)1.0E-5f, (float)(Main.min((float)worldW, (float)worldH) * Main.max((float)0.0f, (float)spacingFactor)));
            int rows = cols = Main.max((int)80, (int)Main.min((int)200, (int)((int)(Main.sqrt((float)Main.max((int)1, (int)this.cells.size())) * 1.0f))));
            ContourGrid g = this.getCoastDistanceGrid(cols, rows, seaLevel);
            ArrayList<PVector[]> arrayList = coastSegs = this.cachedCoastIndex != null ? this.cachedCoastIndex.segments : null;
            if (g == null) {
                return;
            }
            float maxWaterDist = g.max;
            if (maxWaterDist <= 1.0E-5f) {
                app.pushStyle();
                app.stroke(0);
                if (coastSegs != null) {
                    for (PVector[] seg : coastSegs) {
                        app.line(seg[0].x, seg[0].y, seg[1].x, seg[1].y);
                    }
                }
                app.popStyle();
                return;
            }
            float spacing = Main.min((float)desiredSpacing, (float)(maxWaterDist * 0.9f));
            spacing = Main.max((float)spacing, (float)(maxWaterDist * 0.2f));
            app.pushStyle();
            app.stroke(0);
            app.noFill();
            float strokeW = 1.5f / Main.max((float)1.0E-6f, (float)Main.this.viewport.zoom);
            app.strokeWeight(strokeW);
            if (coastSegs != null) {
                for (PVector[] seg : coastSegs) {
                    app.line(seg[0].x, seg[0].y, seg[1].x, seg[1].y);
                }
            }
            if (lines > 1 && spacing > 1.0E-6f) {
                this.drawSignedContourSet(app, g, spacing, spacing, spacing, app.color(0), 1.5f);
            }
            app.popStyle();
        }

        public void drawStructureSnapGuides(PApplet app) {
            boolean useElevation;
            boolean useWater = Main.this.snapWaterEnabled;
            boolean useBiomes = Main.this.snapBiomesEnabled;
            boolean useUnderwater = Main.this.snapUnderwaterBiomesEnabled;
            boolean useZones = Main.this.snapZonesEnabled;
            boolean usePaths = Main.this.snapPathsEnabled;
            boolean useStructures = Main.this.snapStructuresEnabled;
            boolean bl = useElevation = Main.this.snapElevationEnabled && Main.this.snapElevationDivisions > 0;
            if (!(useWater || useBiomes || useUnderwater || useZones || usePaths || useStructures || useElevation)) {
                return;
            }
            int[] zoneMembership = useZones ? this.buildZoneMembershipForSnapping() : null;
            int[] elevBuckets = useElevation ? this.buildElevationBucketsForSnapping(Main.this.snapElevationDivisions) : null;
            this.renderer.drawStructureSnapGuides(app, useWater, useBiomes, useUnderwater, useZones, usePaths, useStructures, useElevation, zoneMembership, elevBuckets);
        }

        public float distSq(PVector a, PVector b) {
            float dx = a.x - b.x;
            float dy = a.y - b.y;
            return dx * dx + dy * dy;
        }

        public int[] buildZoneMembershipForSnapping() {
            if (this.cells == null || this.cells.isEmpty() || this.zones == null || this.zones.isEmpty()) {
                return null;
            }
            int n = this.cells.size();
            int[] membership = new int[n];
            Arrays.fill(membership, -1);
            int zi = 0;
            while (zi < this.zones.size()) {
                MapZone z = this.zones.get(zi);
                if (z != null && z.cells != null) {
                    for (int ci : z.cells) {
                        if (ci < 0 || ci >= n) continue;
                        membership[ci] = zi;
                    }
                }
                ++zi;
            }
            return membership;
        }

        public int[] buildElevationBucketsForSnapping(int divisions) {
            if (this.cells == null || this.cells.isEmpty()) {
                return null;
            }
            int div = Main.max((int)1, (int)divisions);
            int n = this.cells.size();
            int[] buckets = new int[n];
            int i = 0;
            while (i < n) {
                int bucket;
                Cell c = this.cells.get(i);
                float t = c != null ? (c.elevation + 1.0f) * 0.5f : 0.5f;
                t = Main.constrain((float)t, (float)0.0f, (float)1.0f);
                buckets[i] = bucket = Main.min((int)(div - 1), (int)Main.max((int)0, (int)Main.floor((float)(t * (float)div))));
                ++i;
            }
            return buckets;
        }

        public boolean boundaryActiveForSnapping(Cell a, Cell b, int idxA, int idxB, int[] zoneMembership, int[] elevBuckets, boolean useWater, boolean useBiomes, boolean useUnderwaterBiomes, boolean useZones, boolean useElevation) {
            boolean bWater;
            if (a == null || b == null) {
                return false;
            }
            boolean aWater = a.elevation < Main.this.seaLevel;
            boolean bl = bWater = b.elevation < Main.this.seaLevel;
            if (useWater && aWater != bWater) {
                return true;
            }
            if (useBiomes && !aWater && !bWater && a.biomeId != b.biomeId) {
                return true;
            }
            if (useUnderwaterBiomes && aWater && bWater && a.biomeId != b.biomeId) {
                return true;
            }
            if (useZones && zoneMembership != null && idxA >= 0 && idxA < zoneMembership.length && idxB >= 0 && idxB < zoneMembership.length && zoneMembership[idxA] >= 0 && zoneMembership[idxB] >= 0 && zoneMembership[idxA] != zoneMembership[idxB]) {
                return true;
            }
            return useElevation && elevBuckets != null && idxA >= 0 && idxA < elevBuckets.length && idxB >= 0 && idxB < elevBuckets.length && elevBuckets[idxA] != elevBuckets[idxB];
        }

        public Structure computeSnappedStructure(float wx, float wy, StructureAttributes attrs) {
            SegmentHit guide;
            SegmentHit seg;
            StructureAttributes at = attrs != null ? attrs : new StructureAttributes();
            Structure s = new Structure(wx, wy);
            at.applyTo(s);
            if (s.name == null || s.name.length() == 0) {
                String string = s.name = Main.this.useDefaultStructureNames ? "Struct " + (this.structures.size() + 1) : "";
            }
            if (s.snapBinding == null) {
                s.snapBinding = new StructureSnapBinding();
            }
            s.snapBinding.clear();
            float snapRangePx = 20.0f;
            float snapRange = Main.max((float)0.01f, (float)(snapRangePx / Main.max((float)0.001f, (float)Main.this.viewport.zoom)));
            StructureSnapMode align = at.alignment;
            float angleAbs = at.angleRad;
            if (align == StructureSnapMode.NONE) {
                s.snapBinding.type = StructureSnapTargetType.NONE;
                s.snapBinding.snapAngleRad = Main.this.lastStructureSnapAngle;
                s.angle = angleAbs;
                return s;
            }
            boolean usePaths = Main.this.snapPathsEnabled;
            boolean useFrontiers = Main.this.snapWaterEnabled || Main.this.snapBiomesEnabled || Main.this.snapUnderwaterBiomesEnabled || Main.this.snapZonesEnabled || Main.this.snapElevationEnabled && Main.this.snapElevationDivisions > 0;
            boolean useStructures = Main.this.snapStructuresEnabled;
            int[] zoneMembership = useFrontiers && Main.this.snapZonesEnabled ? this.buildZoneMembershipForSnapping() : null;
            int[] elevBuckets = useFrontiers && Main.this.snapElevationEnabled && Main.this.snapElevationDivisions > 0 ? this.buildElevationBucketsForSnapping(Main.this.snapElevationDivisions) : null;
            SegmentHit segmentHit = seg = usePaths ? this.nearestPathSegmentHit(wx, wy, snapRange) : null;
            if (seg != null) {
                PVector a = seg.a;
                PVector b = seg.b;
                PVector p = seg.p;
                float dx = b.x - a.x;
                float dy = b.y - a.y;
                float ang = Main.atan2((float)dy, (float)dx);
                if (align == StructureSnapMode.ON_PATH) {
                    s.x = p.x;
                    s.y = p.y;
                } else {
                    float nx = -Main.sin((float)ang);
                    float ny = Main.cos((float)ang);
                    float offset = s.size * 0.6f;
                    float side = (wx - p.x) * nx + (wy - p.y) * ny;
                    if (side < 0.0f) {
                        offset = -offset;
                    }
                    s.x = p.x + nx * offset;
                    s.y = p.y + ny * offset;
                }
                Main.this.lastStructureSnapAngle = ang;
                s.angle = ang;
                s.snapBinding.type = StructureSnapTargetType.PATH;
                s.snapBinding.pathIndex = seg.pathIndex;
                s.snapBinding.routeIndex = seg.routeIndex;
                s.snapBinding.segmentIndex = seg.segmentIndex;
                s.snapBinding.segA = a.copy();
                s.snapBinding.segB = b.copy();
                s.snapBinding.snapPoint = p.copy();
                s.snapBinding.snapAngleRad = ang;
                return s;
            }
            SegmentHit segmentHit2 = useFrontiers ? this.nearestFrontierSegmentHit(wx, wy, snapRange, Main.this.snapWaterEnabled, Main.this.snapBiomesEnabled, Main.this.snapUnderwaterBiomesEnabled, Main.this.snapZonesEnabled, Main.this.snapElevationEnabled && elevBuckets != null, zoneMembership, elevBuckets) : (guide = null);
            if (guide != null) {
                PVector a = guide.a;
                PVector b = guide.b;
                PVector p = guide.p;
                float dx = b.x - a.x;
                float dy = b.y - a.y;
                float ang = Main.atan2((float)dy, (float)dx);
                if (align == StructureSnapMode.ON_PATH) {
                    s.x = p.x;
                    s.y = p.y;
                } else {
                    float nx = -Main.sin((float)ang);
                    float ny = Main.cos((float)ang);
                    float offset = s.size * 0.6f;
                    float side = (wx - p.x) * nx + (wy - p.y) * ny;
                    if (side < 0.0f) {
                        offset = -offset;
                    }
                    s.x = p.x + nx * offset;
                    s.y = p.y + ny * offset;
                }
                Main.this.lastStructureSnapAngle = ang;
                s.angle = ang;
                s.snapBinding.type = StructureSnapTargetType.FRONTIER;
                s.snapBinding.cellA = guide.cellA;
                s.snapBinding.cellB = guide.cellB;
                s.snapBinding.segA = a.copy();
                s.snapBinding.segB = b.copy();
                s.snapBinding.snapPoint = p.copy();
                s.snapBinding.snapAngleRad = ang;
                return s;
            }
            if (useStructures) {
                Structure closest = null;
                float bestD2 = snapRange * snapRange;
                for (Structure o : this.structures) {
                    float dx = o.x - wx;
                    float dy = o.y - wy;
                    float d2 = dx * dx + dy * dy;
                    if (!(d2 < bestD2)) continue;
                    bestD2 = d2;
                    closest = o;
                }
                if (closest != null) {
                    float ang = Main.atan2((float)(wy - closest.y), (float)(wx - closest.x));
                    float halfA = closest.size * 0.5f;
                    float halfB = s.size * 0.5f;
                    float margin = Main.max((float)0.003f, (float)(Main.min((float)halfA, (float)halfB) * 0.12f));
                    float targetDist = halfA + halfB + margin;
                    s.x = closest.x + Main.cos((float)ang) * targetDist;
                    s.y = closest.y + Main.sin((float)ang) * targetDist;
                    Main.this.lastStructureSnapAngle = ang;
                    s.angle = ang;
                    s.snapBinding.type = StructureSnapTargetType.STRUCTURE;
                    s.snapBinding.structureIndex = this.structures.indexOf(closest);
                    s.snapBinding.snapAngleRad = ang;
                    s.snapBinding.snapPoint = new PVector(closest.x, closest.y);
                    return s;
                }
            }
            s.snapBinding.type = StructureSnapTargetType.NONE;
            s.snapBinding.snapAngleRad = Main.this.lastStructureSnapAngle;
            s.angle = angleAbs;
            return s;
        }

        public Structure computeSnappedStructure(float wx, float wy, float size) {
            StructureAttributes attrs = new StructureAttributes();
            attrs.size = size;
            attrs.angleRad = Main.this.structureAngleOffsetRad;
            attrs.shape = Main.this.structureShape;
            attrs.alignment = Main.this.structureSnapMode;
            attrs.aspectRatio = Main.this.structureAspectRatio;
            attrs.hue01 = Main.this.structureHue01;
            attrs.sat01 = Main.this.structureSat01;
            attrs.alpha01 = Main.this.structureAlpha01;
            attrs.strokeWeightPx = Main.this.structureStrokePx;
            attrs.name = Main.this.structureNameDraft;
            return this.computeSnappedStructure(wx, wy, attrs);
        }

        public void drawElevationOverlay(PApplet app, float seaLevel, boolean showElevationContours, boolean drawWater, boolean drawElevation, boolean showWaterContours, int quantSteps) {
            this.drawElevationOverlay(app, seaLevel, showElevationContours, drawWater, drawElevation, showWaterContours, false, 135.0f, 45.0f, quantSteps);
        }

        public void drawElevationOverlay(PApplet app, float seaLevel, boolean showElevationContours, boolean drawWater, boolean drawElevation, boolean showWaterContours, boolean useLighting, float lightAzimuthDeg, float lightAltitudeDeg, int quantSteps) {
            if (Main.this.useNewElevationShading) {
                ElevationRenderer.drawOverlay(this, app, seaLevel, showElevationContours, drawWater, drawElevation, showWaterContours, useLighting, lightAzimuthDeg, lightAltitudeDeg, quantSteps);
            } else {
                this.drawElevationOverlayLegacy(app, seaLevel, showElevationContours, drawWater, drawElevation, showWaterContours, useLighting, lightAzimuthDeg, lightAltitudeDeg, quantSteps);
            }
        }

        public void drawElevationOverlayLegacy(PApplet app, float seaLevel, boolean showElevationContours, boolean drawWater, boolean drawElevation, boolean showWaterContours, boolean useLighting, float lightAzimuthDeg, float lightAltitudeDeg, int quantSteps) {
            if (this.cells == null) {
                return;
            }
            app.pushStyle();
            app.noStroke();
            PVector lightDir = null;
            if (useLighting) {
                float az = Main.radians((float)lightAzimuthDeg);
                float alt = Main.radians((float)lightAltitudeDeg);
                lightDir = new PVector(Main.cos((float)alt) * Main.cos((float)az), Main.cos((float)alt) * Main.sin((float)az), Main.sin((float)alt));
                lightDir.normalize();
            }
            int cellCount = this.cells.size();
            int ci = 0;
            while (ci < cellCount) {
                Cell c = this.cells.get(ci);
                if (c.vertices != null && c.vertices.size() >= 3) {
                    float h = c.elevation;
                    if (drawElevation) {
                        float shade = Main.constrain((float)(h + 0.5f), (float)0.0f, (float)1.0f);
                        float light = 1.0f;
                        if (useLighting && lightDir != null) {
                            light = ElevationRenderer.computeLightForCell(this, ci, lightDir);
                        }
                        float litShade = Main.constrain((float)(shade * light), (float)0.0f, (float)1.0f);
                        if (quantSteps > 1) {
                            float levels = quantSteps - 1;
                            litShade = (float)Main.round((float)(litShade * levels)) / levels;
                        }
                        int col = app.color(litShade * 255.0f);
                        app.fill(col, 140.0f);
                        app.beginShape();
                        for (PVector v : c.vertices) {
                            app.vertex(v.x, v.y);
                        }
                        app.endShape(2);
                    }
                    if (drawWater && h < seaLevel) {
                        float shade;
                        float depth = seaLevel - h;
                        float depthNorm = Main.constrain((float)(depth / 1.0f), (float)0.0f, (float)1.0f);
                        float f = shade = drawElevation ? Main.lerp((float)0.25f, (float)0.65f, (float)(1.0f - depthNorm)) : 0.55f;
                        if (quantSteps > 1) {
                            float levels = quantSteps - 1;
                            shade = (float)Main.round((float)(shade * levels)) / levels;
                        }
                        float baseR = 30.0f;
                        float baseG = 70.0f;
                        float baseB = 120.0f;
                        int water = app.color(baseR * shade, baseG * shade, baseB * shade, 255.0f);
                        app.fill(water);
                        app.beginShape();
                        for (PVector v : c.vertices) {
                            app.vertex(v.x, v.y);
                        }
                        app.endShape(2);
                    }
                }
                ++ci;
            }
            if (showElevationContours || showWaterContours) {
                float minWater;
                int cols = 90;
                int rows = 90;
                ContourGrid grid = this.sampleElevationGrid(cols, rows, seaLevel);
                float minElev = grid.min;
                float maxElev = grid.max;
                if (showElevationContours) {
                    float range = Main.max((float)1.0E-4f, (float)(maxElev - seaLevel));
                    float step = Main.max((float)0.02f, (float)(range / 10.0f));
                    float start = (float)Main.ceil((float)(seaLevel / step)) * step;
                    int strokeCol = app.color(50, 50, 50, 180);
                    this.drawContourSet(app, grid, start, maxElev, step, strokeCol);
                }
                if (showWaterContours && drawWater && (minWater = minElev) < seaLevel - 1.0E-4f) {
                    float depthRange = seaLevel - minWater;
                    float step = Main.max((float)0.02f, (float)(depthRange / 5.0f));
                    float start = seaLevel - step;
                    int strokeCol = app.color(30, 70, 140, 170);
                    this.drawContourSet(app, grid, start, minWater, -step, strokeCol);
                }
            }
            app.popStyle();
        }

        public ContourGrid sampleElevationGrid(int cols, int rows, float fallback) {
            return this.renderer.sampleElevationGrid(cols, rows, fallback);
        }

        public void drawContourSet(PApplet app, ContourGrid g, float start, float end, float step, int strokeCol) {
            this.renderer.drawContourSet(app, g, start, end, step, strokeCol);
        }

        public void drawIsoLine(PApplet app, ContourGrid g, float iso) {
            this.renderer.drawIsoLine(app, g, iso);
        }

        public void drawSeg(PApplet app, PVector a, PVector b) {
            this.renderer.drawSeg(app, a, b);
        }

        public PVector interpIso(float x0, float y0, float v0, float x1, float y1, float v1, float iso) {
            return this.renderer.interpIso(x0, y0, v0, x1, y1, v1, iso);
        }

        public HashMap<String, PVector[]> edgeMapForCell(Cell c) {
            HashMap<String, PVector[]> map = new HashMap<String, PVector[]>();
            if (c == null || c.vertices == null) {
                return map;
            }
            int vc = c.vertices.size();
            int i = 0;
            while (i < vc) {
                PVector a = c.vertices.get(i);
                PVector b = c.vertices.get((i + 1) % vc);
                map.put(this.undirectedEdgeKey(a, b), new PVector[]{a, b});
                ++i;
            }
            return map;
        }

        public String undirectedEdgeKey(PVector a, PVector b) {
            int scale = 100000;
            int ax = Main.round((float)(a.x * (float)scale));
            int ay = Main.round((float)(a.y * (float)scale));
            int bx = Main.round((float)(b.x * (float)scale));
            int by = Main.round((float)(b.y * (float)scale));
            if (ax < bx || ax == bx && ay <= by) {
                return String.valueOf(ax) + "," + ay + "-" + bx + "," + by;
            }
            return String.valueOf(bx) + "," + by + "-" + ax + "," + ay;
        }

        public PVector[] sharedEdgeBetweenCells(Cell a, Cell b) {
            if (a == null || b == null || a.vertices == null || b.vertices == null) {
                return null;
            }
            int va = a.vertices.size();
            int vb = b.vertices.size();
            int i = 0;
            while (i < va) {
                PVector a0 = a.vertices.get(i);
                PVector a1 = a.vertices.get((i + 1) % va);
                int j = 0;
                while (j < vb) {
                    boolean match;
                    PVector b0 = b.vertices.get(j);
                    PVector b1 = b.vertices.get((j + 1) % vb);
                    boolean bl = match = this.distSq(a0, b0) < 1.0E-10f && this.distSq(a1, b1) < 1.0E-10f || this.distSq(a0, b1) < 1.0E-10f && this.distSq(a1, b0) < 1.0E-10f;
                    if (match) {
                        return new PVector[]{a0, a1};
                    }
                    ++j;
                }
                ++i;
            }
            return null;
        }

        public float cross2d(PVector a, PVector b, PVector c) {
            return (b.x - a.x) * (c.y - a.y) - (b.y - a.y) * (c.x - a.x);
        }

        public boolean onSegment(PVector a, PVector b, PVector p, float eps) {
            float minx = Main.min((float)a.x, (float)b.x) - eps;
            float maxx = Main.max((float)a.x, (float)b.x) + eps;
            float miny = Main.min((float)a.y, (float)b.y) - eps;
            float maxy = Main.max((float)a.y, (float)b.y) + eps;
            return Main.abs((float)this.cross2d(a, b, p)) <= eps && p.x >= minx && p.x <= maxx && p.y >= miny && p.y <= maxy;
        }

        public boolean segmentsIntersect(PVector a1, PVector a2, PVector b1, PVector b2, float eps) {
            float o1 = this.cross2d(a1, a2, b1);
            float o2 = this.cross2d(a1, a2, b2);
            float o3 = this.cross2d(b1, b2, a1);
            float o4 = this.cross2d(b1, b2, a2);
            if ((o1 > 0.0f && o2 < 0.0f || o1 < 0.0f && o2 > 0.0f) && (o3 > 0.0f && o4 < 0.0f || o3 < 0.0f && o4 > 0.0f)) {
                return true;
            }
            if (Main.abs((float)o1) <= eps && this.onSegment(a1, a2, b1, eps)) {
                return true;
            }
            if (Main.abs((float)o2) <= eps && this.onSegment(a1, a2, b2, eps)) {
                return true;
            }
            if (Main.abs((float)o3) <= eps && this.onSegment(b1, b2, a1, eps)) {
                return true;
            }
            return Main.abs((float)o4) <= eps && this.onSegment(b1, b2, a2, eps);
        }

        public ArrayList<PVector[]> collectCoastSegments(float seaLevel) {
            ArrayList<PVector[]> segs = new ArrayList<PVector[]>();
            if (this.cells == null || this.cells.isEmpty()) {
                return segs;
            }
            int n = this.cells.size();
            int ci = 0;
            while (ci < n) {
                Cell a = this.cells.get(ci);
                if (a != null && a.vertices != null) {
                    ArrayList<Integer> nbs;
                    boolean waterA = a.elevation < seaLevel;
                    ArrayList<Integer> arrayList = nbs = ci < this.cellNeighbors.size() ? this.cellNeighbors.get(ci) : null;
                    if (nbs != null) {
                        HashSet<String> seen = new HashSet<String>();
                        for (int nb : nbs) {
                            boolean waterB;
                            Cell b;
                            if (nb < 0 || nb >= n || nb <= ci || (b = this.cells.get(nb)) == null || b.vertices == null) continue;
                            boolean bl = waterB = b.elevation < seaLevel;
                            if (waterA == waterB) continue;
                            int va = a.vertices.size();
                            int i = 0;
                            while (i < va) {
                                PVector p1;
                                PVector p0 = a.vertices.get(i);
                                String key = this.undirectedEdgeKey(p0, p1 = a.vertices.get((i + 1) % va));
                                if (!seen.contains(key)) {
                                    int vb = b.vertices.size();
                                    int j = 0;
                                    while (j < vb) {
                                        PVector q0 = b.vertices.get(j);
                                        PVector q1 = b.vertices.get((j + 1) % vb);
                                        if (this.distSq(p0, q0) < 1.0E-10f && this.distSq(p1, q1) < 1.0E-10f || this.distSq(p0, q1) < 1.0E-10f && this.distSq(p1, q0) < 1.0E-10f) {
                                            segs.add(new PVector[]{p0.copy(), p1.copy()});
                                            seen.add(key);
                                            break;
                                        }
                                        ++j;
                                    }
                                }
                                ++i;
                            }
                        }
                    }
                }
                ++ci;
            }
            return segs;
        }

        public ContourGrid sampleCoastDistanceGrid(int cols, int rows, float seaLevel, CoastSpatialIndex idx) {
            if (idx == null) {
                return null;
            }
            ContourGrid g = new ContourGrid();
            g.cols = Main.max((int)2, (int)cols);
            g.rows = Main.max((int)2, (int)rows);
            g.v = new float[g.rows][g.cols];
            g.ox = this.minX;
            g.oy = this.minY;
            g.dx = (this.maxX - this.minX) / (float)(g.cols - 1);
            g.dy = (this.maxY - this.minY) / (float)(g.rows - 1);
            g.min = Float.MAX_VALUE;
            g.max = -3.4028235E38f;
            int j = 0;
            while (j < g.rows) {
                float y = g.oy + (float)j * g.dy;
                int i = 0;
                while (i < g.cols) {
                    float val;
                    float x = g.ox + (float)i * g.dx;
                    boolean water = this.sampleElevationAt(x, y, seaLevel) < seaLevel;
                    float d = idx.nearestDist(x, y);
                    g.v[j][i] = val = water ? d : -d;
                    g.min = Main.min((float)g.min, (float)val);
                    g.max = Main.max((float)g.max, (float)val);
                    ++i;
                }
                ++j;
            }
            return g;
        }

        public ContourGrid getCoastDistanceGrid(int cols, int rows, float seaLevel) {
            if (this.cells == null || this.cells.isEmpty()) {
                return null;
            }
            if (this.coastCacheValid && this.cachedCoastSeaLevel == seaLevel && this.cachedCoastCols == cols && this.cachedCoastRows == rows && this.cachedCoastCellCount == this.cells.size()) {
                return this.cachedCoastGrid;
            }
            if (this.coastJob != null && this.coastJob.matches(ContourJobType.COAST_DISTANCE, cols, rows, seaLevel)) {
                return null;
            }
            this.coastJob = new ContourJob(ContourJobType.COAST_DISTANCE, cols, rows, seaLevel);
            return null;
        }

        public ContourGrid getElevationGridForRender(int cols, int rows, float seaLevel) {
            if (this.cells == null || this.cells.isEmpty()) {
                return null;
            }
            if (this.elevationCacheValid && this.cachedElevationSeaLevel == seaLevel && this.cachedElevationCols == cols && this.cachedElevationRows == rows && this.cachedElevationCellCount == this.cells.size()) {
                return this.cachedElevationGrid;
            }
            if (this.elevationJob != null && this.elevationJob.matches(ContourJobType.ELEVATION_SAMPLE, cols, rows, seaLevel)) {
                return null;
            }
            this.elevationJob = new ContourJob(ContourJobType.ELEVATION_SAMPLE, cols, rows, seaLevel);
            return null;
        }

        public void stepContourJobs(int maxMillis) {
            int budget = Main.max((int)1, (int)maxMillis);
            if (this.coastJob != null) {
                this.coastJob.step(budget);
                if (this.coastJob.done) {
                    this.finalizeCoastJob();
                }
            }
            if (this.elevationJob != null) {
                this.elevationJob.step(budget);
                if (this.elevationJob.done) {
                    this.finalizeElevationJob();
                }
            }
        }

        public boolean isContourJobRunning() {
            return this.coastJob != null && !this.coastJob.done || this.elevationJob != null && !this.elevationJob.done;
        }

        public float getContourJobProgress() {
            float p = 1.0f;
            if (this.coastJob != null && !this.coastJob.done) {
                p = Main.min((float)p, (float)this.coastJob.progress());
            }
            if (this.elevationJob != null && !this.elevationJob.done) {
                p = Main.min((float)p, (float)this.elevationJob.progress());
            }
            return p;
        }

        private void finalizeCoastJob() {
            if (this.coastJob == null) {
                return;
            }
            if (this.coastJob.failed || this.coastJob.grid == null || this.coastJob.cellCountSnapshot != (this.cells != null ? this.cells.size() : 0)) {
                this.cachedCoastGrid = null;
                this.cachedCoastIndex = null;
                this.coastCacheValid = true;
                this.cachedCoastSeaLevel = this.coastJob.seaLevel;
                this.cachedCoastCols = this.coastJob.cols;
                this.cachedCoastRows = this.coastJob.rows;
                this.cachedCoastCellCount = this.coastJob.cellCountSnapshot;
            } else {
                this.cachedCoastGrid = this.coastJob.grid;
                this.cachedCoastIndex = this.coastJob.coastIndex;
                this.cachedCoastSeaLevel = this.coastJob.seaLevel;
                this.cachedCoastCols = this.coastJob.cols;
                this.cachedCoastRows = this.coastJob.rows;
                this.cachedCoastCellCount = this.coastJob.cellCountSnapshot;
                this.coastCacheValid = true;
            }
            this.coastJob = null;
        }

        private void finalizeElevationJob() {
            if (this.elevationJob == null) {
                return;
            }
            if (this.elevationJob.failed || this.elevationJob.grid == null || this.elevationJob.cellCountSnapshot != (this.cells != null ? this.cells.size() : 0)) {
                this.cachedElevationGrid = null;
                this.elevationCacheValid = true;
                this.cachedElevationSeaLevel = this.elevationJob.seaLevel;
                this.cachedElevationCols = this.elevationJob.cols;
                this.cachedElevationRows = this.elevationJob.rows;
                this.cachedElevationCellCount = this.elevationJob.cellCountSnapshot;
            } else {
                this.cachedElevationGrid = this.elevationJob.grid;
                this.cachedElevationSeaLevel = this.elevationJob.seaLevel;
                this.cachedElevationCols = this.elevationJob.cols;
                this.cachedElevationRows = this.elevationJob.rows;
                this.cachedElevationCellCount = this.elevationJob.cellCountSnapshot;
                this.elevationCacheValid = true;
            }
            this.elevationJob = null;
        }

        public void drawSignedContourSet(PApplet app, ContourGrid g, float start, float end, float step, int strokeCol, float strokePx) {
            if (step == 0.0f) {
                return;
            }
            if (step > 0.0f && start > end || step < 0.0f && start < end) {
                return;
            }
            app.pushStyle();
            app.noFill();
            app.stroke(strokeCol);
            app.strokeWeight(strokePx / Main.max((float)1.0E-6f, (float)Main.this.viewport.zoom));
            if (step > 0.0f) {
                float iso = start;
                while (iso <= end + 1.0E-6f) {
                    this.renderer.drawIsoLine(app, g, iso);
                    iso += step;
                }
            } else {
                float iso = start;
                while (iso >= end - 1.0E-6f) {
                    this.renderer.drawIsoLine(app, g, iso);
                    iso += step;
                }
            }
            app.popStyle();
        }

        public ArrayList<PVector> getSnapPoints() {
            this.ensureSnapGraph();
            ArrayList<PVector> result = new ArrayList<PVector>();
            if (this.snapNodes.isEmpty()) {
                return result;
            }
            float marginPx = 20.0f;
            float tolPx = 4.0f;
            float tolWorld = tolPx / Main.this.viewport.zoom;
            float halfW = (float)Main.this.width * 0.5f / Main.this.viewport.zoom + marginPx / Main.this.viewport.zoom;
            float halfH = (float)Main.this.height * 0.5f / Main.this.viewport.zoom + marginPx / Main.this.viewport.zoom;
            float minX = Main.this.viewport.centerX - halfW;
            float maxX = Main.this.viewport.centerX + halfW;
            float minY = Main.this.viewport.centerY - halfH;
            float maxY = Main.this.viewport.centerY + halfH;
            HashMap<String, PVector> dedup = new HashMap<String, PVector>();
            for (PVector p : this.snapNodes.values()) {
                if (p.x < minX || p.x > maxX || p.y < minY || p.y > maxY) continue;
                int gx = Main.floor((float)(p.x / tolWorld));
                int gy = Main.floor((float)(p.y / tolWorld));
                String key = String.valueOf(gx) + "_" + gy;
                if (dedup.containsKey(key)) continue;
                dedup.put(key, p);
            }
            result.addAll(dedup.values());
            return result;
        }

        public ArrayList<PVector> findSnapPath(PVector from, PVector toP) {
            return this.findSnapPathWeighted(from, toP, false);
        }

        public ArrayList<PVector> findSnapPathFlattest(PVector from, PVector toP) {
            return this.findSnapPathWeighted(from, toP, true);
        }

        public ArrayList<PVector> findSnapPathWeighted(PVector from, PVector toP, boolean favorFlat) {
            int tStart = Main.this.millis();
            this.ensureSnapGraph();
            String kFrom = this.keyFor(from.x, from.y);
            String kTo = this.keyFor(toP.x, toP.y);
            ArrayList<Object> result = null;
            if (!this.snapNodes.containsKey(kFrom) || !this.snapNodes.containsKey(kTo)) {
                this.lastPathfindMs = Main.this.millis() - tStart;
                this.lastPathfindExpanded = 0;
                this.lastPathfindLength = 0;
                this.lastPathfindHit = false;
                return null;
            }
            if (kFrom.equals(kTo)) {
                result = new ArrayList<PVector>();
                PVector p = this.snapNodes.get(kFrom);
                result.add(p);
                result.add(p.copy());
                this.lastPathfindMs = Main.this.millis() - tStart;
                this.lastPathfindExpanded = 0;
                this.lastPathfindLength = result.size();
                this.lastPathfindHit = result.size() > 1;
                return result;
            }
            if (Main.this.PATH_BIDIRECTIONAL) {
                result = this.findSnapPathBidirectional(kFrom, kTo, favorFlat, this.snapNodes, this.snapAdj);
                this.lastPathfindMs = Main.this.millis() - tStart;
                this.lastPathfindHit = result != null && result.size() > 1;
                this.lastPathfindLength = result != null ? result.size() : 0;
                return result;
            }
            HashMap<String, Float> dist = new HashMap<String, Float>();
            HashMap<String, String> prev = new HashMap<String, String>();
            PriorityQueue<NodeDist> pq = new PriorityQueue<NodeDist>();
            dist.put(kFrom, Float.valueOf(0.0f));
            PVector target = this.snapNodes.get(kTo);
            float hStart = target != null ? this.distSq(this.snapNodes.get(kFrom), target) : 0.0f;
            pq.add(new NodeDist(kFrom, 0.0f, hStart));
            float minx = Main.min((float)from.x, (float)toP.x);
            float maxx = Main.max((float)from.x, (float)toP.x);
            float miny = Main.min((float)from.y, (float)toP.y);
            float maxy = Main.max((float)from.y, (float)toP.y);
            float margin = Main.max((float)(this.dist2D(from, toP) * 0.6f), (float)0.05f);
            minx -= margin;
            maxx += margin;
            miny -= margin;
            maxy += margin;
            int maxExpanded = Main.this.PATH_MAX_EXPANSIONS;
            int expanded = 0;
            String closest = kFrom;
            float bestH = target != null ? this.dist2D(this.snapNodes.get(kFrom), target) : Float.MAX_VALUE;
            HashMap<String, Float> elevCache = new HashMap<String, Float>();
            while (!pq.isEmpty()) {
                float hCur;
                PVector p;
                NodeDist nd = (NodeDist)pq.poll();
                Float bestD = (Float)dist.get(nd.k);
                if (bestD != null && nd.g > bestD.floatValue() + 1.0E-6f) continue;
                if (nd.k.equals(kTo) || expanded++ > maxExpanded) break;
                ArrayList<String> neighbors = this.snapAdj.get(nd.k);
                if (neighbors == null || (p = this.snapNodes.get(nd.k)) == null) continue;
                float f = hCur = target != null ? this.distSq(p, target) : Float.MAX_VALUE;
                if (hCur < bestH) {
                    bestH = hCur;
                    closest = nd.k;
                }
                for (String nb : neighbors) {
                    PVector np = this.snapNodes.get(nb);
                    if (np == null || np.x < minx || np.x > maxx || np.y < miny || np.y > maxy) continue;
                    float w = this.dist2D(p, np);
                    float elevA = elevCache.containsKey(nd.k) ? ((Float)elevCache.get(nd.k)).floatValue() : this.sampleElevationAt(p.x, p.y, Main.this.seaLevel);
                    float elevB = elevCache.containsKey(nb) ? ((Float)elevCache.get(nb)).floatValue() : this.sampleElevationAt(np.x, np.y, Main.this.seaLevel);
                    elevCache.put(nd.k, Float.valueOf(elevA));
                    elevCache.put(nb, Float.valueOf(elevB));
                    if (Main.this.pathAvoidWater) {
                        boolean bw;
                        boolean aw = elevA < Main.this.seaLevel;
                        boolean bl = bw = elevB < Main.this.seaLevel;
                        if (aw || bw) {
                            w *= 1000000.0f;
                        }
                    }
                    if (favorFlat) {
                        float dh = Main.abs((float)(elevB - elevA));
                        w *= 1.0f + dh * Main.this.flattestSlopeBias;
                    }
                    float ndist = nd.g + w;
                    Float curD = (Float)dist.get(nb);
                    if (curD != null && !(ndist < curD.floatValue() - 1.0E-6f)) continue;
                    dist.put(nb, Float.valueOf(ndist));
                    prev.put(nb, nd.k);
                    float h = target != null ? this.distSq(np, target) : 0.0f;
                    pq.add(new NodeDist(nb, ndist, ndist + h * 0.5f));
                }
            }
            if (!prev.containsKey(kTo) && !kFrom.equals(kTo)) {
                if (closest != null) {
                    if (closest.equals(kFrom)) {
                        result = new ArrayList();
                        result.add(this.snapNodes.get(kFrom));
                    } else if (prev.containsKey(closest)) {
                        result = this.reconstructPath(prev, kFrom, closest);
                    }
                }
            } else {
                result = this.reconstructPath(prev, kFrom, kTo);
            }
            this.lastPathfindMs = Main.this.millis() - tStart;
            this.lastPathfindExpanded = expanded;
            this.lastPathfindLength = result != null ? result.size() : 0;
            this.lastPathfindHit = result != null && result.size() > 1;
            return result;
        }

        public void ensureSnapGraph() {
            if (!this.snapDirty) {
                return;
            }
            this.recomputeSnappingGraph();
            this.snapDirty = false;
        }

        public void recomputeSnappingGraph() {
            int tStart = Main.this.millis();
            this.snapNodes.clear();
            this.snapAdj.clear();
            if (this.sites == null || this.cells == null) {
                return;
            }
            String[] centerKeys = new String[this.sites.size()];
            int i = 0;
            while (i < this.sites.size()) {
                Site s = this.sites.get(i);
                centerKeys[i] = this.ensureNode(s.x, s.y);
                ++i;
            }
            for (Cell c : this.cells) {
                if (c.vertices == null || c.vertices.size() == 0) continue;
                String centerKey = c.siteIndex >= 0 && c.siteIndex < centerKeys.length ? centerKeys[c.siteIndex] : this.ensureNode(c.vertices.get((int)0).x, c.vertices.get((int)0).y);
                int n = c.vertices.size();
                if (n < 2) continue;
                int i2 = 0;
                while (i2 < n) {
                    PVector v = c.vertices.get(i2);
                    PVector vn = c.vertices.get((i2 + 1) % n);
                    String vk = this.ensureNode(v.x, v.y);
                    String vnk = this.ensureNode(vn.x, vn.y);
                    this.connectNodes(centerKey, vk);
                    this.connectNodes(vk, vnk);
                    ++i2;
                }
            }
            this.ensureCellNeighborsComputed();
            int cCount = this.cells.size();
            int i3 = 0;
            while (i3 < cCount) {
                ArrayList<Integer> nbs;
                ArrayList<Integer> arrayList = nbs = i3 < this.cellNeighbors.size() ? this.cellNeighbors.get(i3) : null;
                if (nbs != null) {
                    Cell a = this.cells.get(i3);
                    for (int nb : nbs) {
                        if (nb <= i3) continue;
                        Cell b = this.cells.get(nb);
                        if (a == null || b == null || a.siteIndex < 0 || a.siteIndex >= centerKeys.length || b.siteIndex < 0 || b.siteIndex >= centerKeys.length) continue;
                        this.connectNodes(centerKeys[a.siteIndex], centerKeys[b.siteIndex]);
                    }
                }
                ++i3;
            }
            this.pruneUniformFrontierSnapNodes();
            this.lastSnapNodeCount = this.snapNodes.size();
            int edgeSum = 0;
            for (ArrayList<String> adj : this.snapAdj.values()) {
                if (adj == null) continue;
                edgeSum += adj.size();
            }
            this.lastSnapEdgeCount = edgeSum / 2;
            this.lastSnapBuildMs = Main.this.millis() - tStart;
        }

        public String ensureNode(float x, float y) {
            String k = this.keyFor(x, y);
            if (!this.snapNodes.containsKey(k)) {
                this.snapNodes.put(k, new PVector(x, y));
                this.snapAdj.put(k, new ArrayList());
            }
            return k;
        }

        public void connectNodes(String a, String b) {
            if (a == null || b == null) {
                return;
            }
            if (a.equals(b)) {
                return;
            }
            ArrayList<String> la = this.snapAdj.get(a);
            ArrayList<String> lb = this.snapAdj.get(b);
            if (la == null || lb == null) {
                return;
            }
            if (!la.contains(b)) {
                la.add(b);
            }
            if (!lb.contains(a)) {
                lb.add(a);
            }
        }

        public void pruneUniformFrontierSnapNodes() {
            if (this.cells == null || this.cells.isEmpty()) {
                return;
            }
            this.ensureCellNeighborsComputed();
            HashMap nodeCells = new HashMap();
            int ci = 0;
            while (ci < this.cells.size()) {
                Cell cell = this.cells.get(ci);
                if (cell.vertices != null) {
                    for (PVector v : cell.vertices) {
                        String k = this.keyFor(v.x, v.y);
                        ArrayList<Integer> list = (ArrayList<Integer>)nodeCells.get(k);
                        if (list == null) {
                            list = new ArrayList<Integer>();
                            nodeCells.put(k, list);
                        }
                        if (list.contains(ci)) continue;
                        list.add(ci);
                    }
                }
                ++ci;
            }
            HashSet<String> toRemove = new HashSet<String>();
            for (String string : this.snapNodes.keySet()) {
                ArrayList incident = (ArrayList)nodeCells.get(string);
                if (incident == null || incident.isEmpty()) continue;
                int firstIdx = (Integer)incident.get(0);
                Cell first = this.cells.get(firstIdx);
                int biome = first.biomeId;
                boolean water = first.elevation < Main.this.seaLevel;
                boolean allSame = true;
                int i = 1;
                while (i < incident.size()) {
                    Cell c = this.cells.get((Integer)incident.get(i));
                    if (c.biomeId != biome || c.elevation < Main.this.seaLevel != water) {
                        allSame = false;
                        break;
                    }
                    ++i;
                }
                if (!allSame) continue;
                toRemove.add(string);
            }
            if (toRemove.isEmpty()) {
                return;
            }
            for (String string : toRemove) {
                this.snapNodes.remove(string);
                this.snapAdj.remove(string);
            }
            for (ArrayList arrayList : this.snapAdj.values()) {
                arrayList.removeAll(toRemove);
            }
        }

        public ArrayList<PVector> reconstructPath(HashMap<String, String> prev, String start, String goal) {
            ArrayList<PVector> out = new ArrayList<PVector>();
            String cur = goal;
            while (cur != null) {
                PVector p = this.snapNodes.get(cur);
                if (p != null) {
                    out.add(0, p);
                }
                if (cur.equals(start)) break;
                cur = prev.get(cur);
            }
            return out;
        }

        public String keyFor(float x, float y) {
            int xi = Main.round((float)(x * 10000.0f));
            int yi = Main.round((float)(y * 10000.0f));
            return String.valueOf(xi) + ":" + yi;
        }

        public PVector parseKey(String k) {
            if (k == null) {
                return null;
            }
            String[] parts = Main.split((String)k, (char)':');
            if (parts == null || parts.length != 2) {
                return null;
            }
            try {
                float x = (float)Integer.parseInt(parts[0]) / 10000.0f;
                float y = (float)Integer.parseInt(parts[1]) / 10000.0f;
                return new PVector(x, y);
            }
            catch (Exception exception) {
                return null;
            }
        }

        public float sampleElevationAt(float x, float y, float fallback) {
            Cell c = this.findCellContaining(x, y);
            if (c != null) {
                return c.elevation;
            }
            return fallback;
        }

        public float dist2D(PVector a, PVector b) {
            float dx = a.x - b.x;
            float dy = a.y - b.y;
            return Main.sqrt((float)(dx * dx + dy * dy));
        }

        public void drawPaths(PApplet app, int strokeCol, boolean highlightSelected, boolean showNodes) {
            float minW;
            HashMap<String, Float> taperW;
            boolean taperOn;
            if (this.paths.isEmpty()) {
                return;
            }
            app.pushStyle();
            app.strokeCap(2);
            app.strokeJoin(2);
            app.noFill();
            HashMap<Integer, HashMap<String, Float>> taperCache = new HashMap<Integer, HashMap<String, Float>>();
            int i = 0;
            while (i < this.paths.size()) {
                Path p = this.paths.get(i);
                if (!p.routes.isEmpty()) {
                    PathType pt = this.getPathType(p.typeId);
                    int col = pt != null ? pt.col : strokeCol;
                    float w = pt != null ? pt.weightPx : 2.0f;
                    app.stroke(col);
                    taperOn = pt != null && pt.taperOn;
                    taperW = null;
                    if (taperOn && (taperW = (HashMap<String, Float>)taperCache.get(p.typeId)) == null) {
                        minW = pt != null ? pt.minWeightPx : Main.max((float)1.0f, (float)(w * 0.4f));
                        taperW = this.computeTaperWeightsForType(p.typeId, w, minW);
                        taperCache.put(p.typeId, taperW);
                    }
                    p.draw(app, w, taperOn, taperW, i, showNodes, 1.0f);
                    if (showNodes) {
                        app.pushStyle();
                        app.noStroke();
                        app.fill(255.0f, 120.0f, 0.0f, 200.0f);
                        float r = 3.0f / Main.this.viewport.zoom;
                        for (ArrayList<PVector> rts : p.routes) {
                            if (rts == null) continue;
                            for (PVector v : rts) {
                                app.ellipse(v.x, v.y, r, r);
                            }
                        }
                        app.popStyle();
                    }
                }
                ++i;
            }
            if (highlightSelected && Main.this.selectedPathIndex >= 0 && Main.this.selectedPathIndex < this.paths.size()) {
                Path sel = this.paths.get(Main.this.selectedPathIndex);
                if (sel.routes.isEmpty()) {
                    app.popStyle();
                    return;
                }
                PathType pt = this.getPathType(sel.typeId);
                int hi = app.color(255, 230, 80, 180);
                float w = pt != null ? pt.weightPx : 2.0f;
                float hw = 5.0f / Main.this.viewport.zoom;
                app.stroke(hi);
                app.strokeWeight(hw);
                taperOn = pt != null && pt.taperOn;
                taperW = null;
                if (taperOn && (taperW = (HashMap<String, Float>)taperCache.get(sel.typeId)) == null) {
                    minW = pt != null ? pt.minWeightPx : Main.max((float)1.0f, (float)(w * 0.4f));
                    taperW = this.computeTaperWeightsForType(sel.typeId, w, minW);
                    taperCache.put(sel.typeId, taperW);
                }
                sel.draw(app, w, taperOn, taperW, Main.this.selectedPathIndex, showNodes, 1.0f);
            }
            app.popStyle();
        }

        public void drawPathsRender(PApplet app, RenderSettings s) {
            if (this.paths.isEmpty() || s == null) {
                return;
            }
            app.pushStyle();
            app.strokeCap(2);
            app.strokeJoin(2);
            app.noFill();
            HashMap<Integer, HashMap<String, Float>> taperCache = new HashMap<Integer, HashMap<String, Float>>();
            float[] hsbScratch = new float[3];
            int i = 0;
            while (i < this.paths.size()) {
                Path p = this.paths.get(i);
                if (!p.routes.isEmpty()) {
                    float w;
                    PathType pt = this.getPathType(p.typeId);
                    int baseCol = pt != null ? pt.col : app.color(80);
                    Main.this.rgbToHSB01(baseCol, hsbScratch);
                    float satScale = Main.constrain((float)s.pathSatScale01, (float)0.0f, (float)1.0f);
                    hsbScratch[1] = Main.constrain((float)(hsbScratch[1] * satScale), (float)0.0f, (float)1.0f);
                    float briScale = Main.constrain((float)s.pathBriScale01, (float)0.0f, (float)1.0f);
                    hsbScratch[2] = Main.constrain((float)(hsbScratch[2] * briScale), (float)0.0f, (float)1.0f);
                    int rgb = Main.this.hsb01ToARGB(hsbScratch[0], hsbScratch[1], hsbScratch[2], 1.0f);
                    int baseA = baseCol >> 24 & 0xFF;
                    if (baseA == 0) {
                        baseA = 255;
                    }
                    int col = app.color(rgb >> 16 & 0xFF, rgb >> 8 & 0xFF, rgb & 0xFF, baseA);
                    float f = w = pt != null ? pt.weightPx : 2.0f;
                    if (s.pathScaleWithZoom) {
                        float ref = s.pathScaleRefZoom > 1.0E-6f ? s.pathScaleRefZoom : 600.0f;
                        w *= Main.max((float)1.0E-6f, (float)Main.this.viewport.zoom) / ref;
                    }
                    if (!((w = Main.constrain((float)w, (float)0.1f, (float)256.0f)) <= 0.01f)) {
                        app.stroke(col);
                        boolean taperOn = pt != null && pt.taperOn;
                        HashMap<String, Float> taperW = null;
                        if (taperOn && (taperW = (HashMap<String, Float>)taperCache.get(p.typeId)) == null) {
                            float minW = pt != null ? pt.minWeightPx : Main.max((float)1.0f, (float)(w * 0.4f));
                            taperW = this.computeTaperWeightsForType(p.typeId, w, minW);
                            taperCache.put(p.typeId, taperW);
                        }
                        p.draw(app, w, taperOn, taperW, i, false, 1.0f);
                    }
                }
                ++i;
            }
            app.popStyle();
        }

        public ArrayList<PVector[]> collectPathSegmentsByType(int typeId) {
            ArrayList<PVector[]> segs = new ArrayList<PVector[]>();
            if (this.paths == null || this.paths.isEmpty()) {
                return segs;
            }
            for (Path p : this.paths) {
                if (p == null || p.routes == null || p.typeId != typeId) continue;
                for (ArrayList<PVector> r : p.routes) {
                    if (r == null || r.size() < 2) continue;
                    segs.addAll(this.segmentsFromPoints(r));
                }
            }
            return segs;
        }

        public PVector segmentIntersectionPoint(PVector a1, PVector a2, PVector b1, PVector b2) {
            float den = (a1.x - a2.x) * (b1.y - b2.y) - (a1.y - a2.y) * (b1.x - b2.x);
            if (Main.abs((float)den) < 1.0E-9f) {
                return null;
            }
            float t = ((a1.x - b1.x) * (b1.y - b2.y) - (a1.y - b1.y) * (b1.x - b2.x)) / den;
            float u = -((a1.x - a2.x) * (a1.y - b1.y) - (a1.y - a2.y) * (a1.x - b1.x)) / den;
            if (t < 0.0f || t > 1.0f || u < 0.0f || u > 1.0f) {
                return null;
            }
            return new PVector(a1.x + t * (a2.x - a1.x), a1.y + t * (a2.y - a1.y));
        }

        public ArrayList<PVector> truncateRouteAtFirstIntersection(ArrayList<PVector> route, ArrayList<PVector[]> existing) {
            if (route == null || route.size() < 2 || existing == null || existing.isEmpty()) {
                return route;
            }
            int hitIdx = -1;
            PVector hitPt = null;
            int i = 0;
            while (i < route.size() - 1) {
                PVector a = route.get(i);
                PVector b = route.get(i + 1);
                for (PVector[] ex : existing) {
                    PVector p;
                    if (ex == null || ex.length < 2 || (p = this.segmentIntersectionPoint(a, b, ex[0], ex[1])) == null) continue;
                    hitIdx = i;
                    hitPt = p;
                    break;
                }
                if (hitIdx >= 0) break;
                ++i;
            }
            if (hitIdx < 0 || hitPt == null) {
                return route;
            }
            ArrayList<PVector> trimmed = new ArrayList<PVector>();
            int i2 = 0;
            while (i2 <= hitIdx) {
                trimmed.add(route.get(i2));
                ++i2;
            }
            trimmed.add(hitPt);
            return trimmed;
        }

        public void generatePathsAuto(float seaLevel) {
            Cell c;
            PVector cen;
            PVector vb;
            this.ensureCellNeighborsComputed();
            if (this.structures != null) {
                int i = this.structures.size() - 1;
                while (i >= 0) {
                    Structure st = this.structures.get(i);
                    if (st != null && "IP".equals(st.name)) {
                        this.structures.remove(i);
                    }
                    --i;
                }
            }
            int roadType = this.ensurePathTypeByName("Road");
            int riverType = this.ensurePathTypeByName("River");
            int bridgeType = this.ensurePathTypeByName("Bridge");
            float worldW = this.maxX - this.minX;
            float worldH = this.maxY - this.minY;
            float stepLen = Main.max((float)1.0E-4f, (float)(Main.min((float)worldW, (float)worldH) * 0.02f));
            ArrayList<PVector> coastPts = new ArrayList<PVector>();
            ArrayList<PVector> coastNrm = new ArrayList<PVector>();
            int n = this.cells.size();
            int ci = 0;
            while (ci < n) {
                Cell c2 = this.cells.get(ci);
                if (c2 != null && c2.vertices != null && c2.vertices.size() >= 3) {
                    ArrayList<Integer> nbs;
                    boolean aWater = c2.elevation < seaLevel;
                    ArrayList<Integer> arrayList = nbs = ci < this.cellNeighbors.size() ? this.cellNeighbors.get(ci) : null;
                    if (nbs != null) {
                        int vc = c2.vertices.size();
                        for (int nbIdx : nbs) {
                            boolean bWater;
                            Cell nb;
                            if (nbIdx < 0 || nbIdx >= n || nbIdx < ci || (nb = this.cells.get(nbIdx)) == null || nb.vertices == null || nb.vertices.size() < 3) continue;
                            boolean bl = bWater = nb.elevation < seaLevel;
                            if (aWater == bWater) continue;
                            Iterator<Object> cenA = this.cellCentroid(c2);
                            PVector cenB = this.cellCentroid(nb);
                            int e = 0;
                            while (e < vc) {
                                PVector a = c2.vertices.get(e);
                                PVector b = c2.vertices.get((e + 1) % vc);
                                int je = 0;
                                while (je < nb.vertices.size()) {
                                    boolean matchRev;
                                    PVector na = nb.vertices.get(je);
                                    PVector nbp = nb.vertices.get((je + 1) % nb.vertices.size());
                                    boolean match = this.distSq(a, na) < 1.0E-6f && this.distSq(b, nbp) < 1.0E-6f;
                                    boolean bl2 = matchRev = this.distSq(a, nbp) < 1.0E-6f && this.distSq(b, na) < 1.0E-6f;
                                    if (match || matchRev) {
                                        PVector va = a.copy();
                                        vb = b.copy();
                                        coastPts.add(va);
                                        coastPts.add(vb);
                                        PVector nrm = new PVector(0.0f, 1.0f);
                                        if (cenA != null && cenB != null) {
                                            Object land;
                                            Object water = aWater ? cenA : cenB;
                                            nrm = PVector.sub((PVector)water, (PVector)(land = aWater ? cenB : cenA));
                                            if (nrm.magSq() > 1.0E-12f) {
                                                nrm.normalize();
                                            } else {
                                                nrm = new PVector(0.0f, 1.0f);
                                            }
                                        }
                                        coastNrm.add(nrm);
                                        coastNrm.add(nrm.copy());
                                        break;
                                    }
                                    ++je;
                                }
                                ++e;
                            }
                        }
                    }
                }
                ++ci;
            }
            this.ensureSnapGraph();
            ArrayList<PVector[]> existingSegs = this.collectAllPathSegments();
            ArrayList<PVector[]> existingRoadSegs = this.collectPathSegmentsByType(roadType);
            int i = 0;
            while (i < 5) {
                if (coastPts.isEmpty()) break;
                PVector start = (PVector)coastPts.get((int)Main.this.random(coastPts.size()));
                ArrayList<PVector> route = this.growRiver(start, seaLevel, stepLen, existingSegs);
                if (route != null && route.size() >= 2 && (route = this.snapRouteToGraph(route)).size() >= 2) {
                    this.addPathFromPoints(riverType, Main.this.useDefaultPathNames ? "River " + (this.paths.size() + 1) : "", route);
                    existingSegs = this.collectAllPathSegments();
                }
                ++i;
            }
            ArrayList<PVector> interest = new ArrayList<PVector>();
            if (this.structures != null && !this.structures.isEmpty()) {
                ArrayList<Structure> sorted = new ArrayList<Structure>(this.structures);
                Collections.sort(sorted, new Comparator<Structure>(){

                    @Override
                    public int compare(Structure a, Structure b) {
                        return Float.compare(b.size, a.size);
                    }
                });
                int take = Main.min((int)5, (int)sorted.size());
                int i2 = 0;
                while (i2 < take) {
                    Structure s = sorted.get(i2);
                    Cell c3 = this.findCellContaining(s.x, s.y);
                    if (c3 != null && c3.elevation > seaLevel) {
                        interest.add(this.snapToNearestSnapNode(this.cellCentroid(c3)));
                    } else {
                        PVector p2 = new PVector(s.x, s.y);
                        interest.add(this.snapToNearestSnapNode(p2));
                    }
                    ++i2;
                }
            }
            float margin = Main.min((float)worldW, (float)worldH) * 0.05f;
            boolean borderTop = false;
            boolean borderBottom = false;
            boolean borderLeft = false;
            boolean borderRight = false;
            for (Cell c4 : this.cells) {
                PVector cen2;
                if (borderTop && borderBottom && borderLeft && borderRight) break;
                if (c4 == null || c4.vertices == null || c4.vertices.isEmpty() || c4.elevation <= seaLevel || (cen2 = this.cellCentroid(c4)) == null) continue;
                if (Main.abs((float)(cen2.x - this.minX)) < margin && !borderLeft) {
                    interest.add(this.snapToNearestSnapNode(cen2));
                    borderLeft = true;
                    continue;
                }
                if (Main.abs((float)(cen2.x - this.maxX)) < margin && !borderRight) {
                    interest.add(this.snapToNearestSnapNode(cen2));
                    borderRight = true;
                    continue;
                }
                if (Main.abs((float)(cen2.y - this.minY)) < margin && !borderBottom) {
                    interest.add(this.snapToNearestSnapNode(cen2));
                    borderBottom = true;
                    continue;
                }
                if (!(Main.abs((float)(cen2.y - this.maxY)) < margin) || borderTop) continue;
                interest.add(this.snapToNearestSnapNode(cen2));
                borderTop = true;
            }
            for (MapZone z : this.zones) {
                if (z == null || z.cells == null || z.cells.isEmpty()) continue;
                float sx = 0.0f;
                float sy = 0.0f;
                int cnt = 0;
                for (int ci2 : z.cells) {
                    Iterator<MapZone> c5;
                    if (ci2 < 0 || ci2 >= this.cells.size() || (c5 = this.cells.get(ci2)) == null || (cen = this.cellCentroid((Cell)((Object)c5))) == null || ((Cell)((Object)c5)).elevation <= seaLevel) continue;
                    sx += cen.x;
                    sy += cen.y;
                    ++cnt;
                }
                if (cnt <= 0) continue;
                interest.add(this.snapToNearestSnapNode(new PVector(sx / (float)cnt, sy / (float)cnt)));
            }
            float bestElev = -3.4028235E38f;
            PVector bestP = null;
            for (Cell c6 : this.cells) {
                if (c6 == null || c6.vertices == null || c6.vertices.isEmpty() || c6.elevation <= seaLevel || !(c6.elevation > bestElev)) continue;
                bestElev = c6.elevation;
                bestP = this.cellCentroid(c6);
            }
            if (bestP != null) {
                interest.add(this.snapToNearestSnapNode(bestP));
            }
            ArrayList roadSeeds = new ArrayList();
            HashSet seedSeen = new HashSet();
            float seedMargin = Main.min((float)worldW, (float)worldH) * 0.05f;
            this.ensureSnapGraph();
            Consumer<PVector> addSeed = p -> {
                if (p == null) {
                    return;
                }
                PVector snapped = this.snapToNearestSnapNode((PVector)p);
                if (snapped == null) {
                    return;
                }
                String k = this.keyFor(snapped.x, snapped.y);
                if (seedSeen.contains(k)) {
                    return;
                }
                seedSeen.add(k);
                roadSeeds.add(snapped);
            };
            for (Cell c7 : this.cells) {
                if (c7 == null || c7.vertices == null || c7.vertices.isEmpty() || c7.elevation <= seaLevel || (cen = this.cellCentroid(c7)) == null || !(Main.abs((float)(cen.x - this.minX)) < seedMargin || Main.abs((float)(cen.x - this.maxX)) < seedMargin || Main.abs((float)(cen.y - this.minY)) < seedMargin) && !(Main.abs((float)(cen.y - this.maxY)) < seedMargin)) continue;
                addSeed.accept(cen);
                break;
            }
            for (MapZone z : this.zones) {
                if (z == null || z.cells == null || z.cells.isEmpty()) continue;
                float sx = 0.0f;
                float sy = 0.0f;
                int cnt = 0;
                vb = z.cells.iterator();
                while (vb.hasNext()) {
                    PVector cen3;
                    int ci3 = vb.next();
                    if (ci3 < 0 || ci3 >= this.cells.size() || (c = this.cells.get(ci3)) == null || c.vertices == null || c.vertices.isEmpty() || c.elevation <= seaLevel || (cen3 = this.cellCentroid(c)) == null) continue;
                    sx += cen3.x;
                    sy += cen3.y;
                    ++cnt;
                }
                if (cnt <= 0) continue;
                addSeed.accept(new PVector(sx / (float)cnt, sy / (float)cnt));
                break;
            }
            if (this.structures != null && !this.structures.isEmpty()) {
                Structure biggest = null;
                for (Structure s : this.structures) {
                    if (s == null || biggest != null && !(s.size > biggest.size)) continue;
                    biggest = s;
                }
                if (biggest != null) {
                    addSeed.accept(new PVector(biggest.x, biggest.y));
                }
            }
            int safety = 0;
            while (roadSeeds.size() < 3 && safety++ < 30) {
                int idx = (int)Main.this.random(this.cells.size());
                Cell c8 = this.cells.get(idx);
                if (c8 == null || c8.vertices == null || c8.vertices.isEmpty() || c8.elevation <= seaLevel) continue;
                PVector cen4 = this.cellCentroid(c8);
                addSeed.accept(cen4);
            }
            int maxRoadLinks = 5;
            int roadLinks = 0;
            int i3 = 0;
            while (i3 < roadSeeds.size() && roadLinks < maxRoadLinks) {
                int j = i3 + 1;
                while (j < roadSeeds.size() && roadLinks < maxRoadLinks) {
                    PVector pb;
                    PVector pa = (PVector)roadSeeds.get(i3);
                    ArrayList<PVector> pathPts = this.findSnapPathFlattest(pa, pb = (PVector)roadSeeds.get(j));
                    if (pathPts != null && pathPts.size() >= 2) {
                        boolean overWater = false;
                        for (PVector p3 : pathPts) {
                            if (p3 == null || !(this.sampleElevationAt(p3.x, p3.y, seaLevel) < seaLevel)) continue;
                            overWater = true;
                            break;
                        }
                        if (!overWater && (pathPts = this.truncateRouteAtFirstIntersection(pathPts, existingRoadSegs)) != null && pathPts.size() >= 2) {
                            this.addPathFromPoints(roadType, Main.this.useDefaultPathNames ? "Road " + (this.paths.size() + 1) : "", pathPts);
                            existingRoadSegs.addAll(this.segmentsFromPoints(pathPts));
                            ++roadLinks;
                        }
                    }
                    ++j;
                }
                ++i3;
            }
            ArrayList<Integer> coastCells = new ArrayList<Integer>();
            ArrayList<Integer> coastStartEdge = new ArrayList<Integer>();
            ArrayList<Integer> coastLenEdge = new ArrayList<Integer>();
            int ci4 = 0;
            while (ci4 < this.cells.size() && coastCells.size() < 10) {
                int vc;
                c = this.cells.get(ci4);
                if (c != null && c.vertices != null && !(c.elevation < seaLevel) && (vc = c.vertices.size()) >= 3) {
                    ArrayList<Integer> nbs;
                    boolean[] waterEdge = new boolean[vc];
                    ArrayList<Integer> arrayList = nbs = ci4 < this.cellNeighbors.size() ? this.cellNeighbors.get(ci4) : null;
                    if (nbs != null) {
                        int e = 0;
                        while (e < vc) {
                            PVector a = c.vertices.get(e);
                            PVector b = c.vertices.get((e + 1) % vc);
                            boolean edgeWater = false;
                            for (int nbIdx : nbs) {
                                Cell nb;
                                if (nbIdx < 0 || nbIdx >= this.cells.size() || (nb = this.cells.get(nbIdx)) == null || nb.vertices == null || nb.vertices.size() < 3 || nb.elevation >= seaLevel) continue;
                                int nvc = nb.vertices.size();
                                int je = 0;
                                while (je < nvc) {
                                    boolean matchRev;
                                    PVector na = nb.vertices.get(je);
                                    PVector nbp = nb.vertices.get((je + 1) % nvc);
                                    boolean match = this.distSq(a, na) < 1.0E-6f && this.distSq(b, nbp) < 1.0E-6f;
                                    boolean bl = matchRev = this.distSq(a, nbp) < 1.0E-6f && this.distSq(b, na) < 1.0E-6f;
                                    if (match || matchRev) {
                                        edgeWater = true;
                                        break;
                                    }
                                    ++je;
                                }
                                if (edgeWater) break;
                            }
                            waterEdge[e] = edgeWater;
                            ++e;
                        }
                        int bestLen = 0;
                        int bestStart = -1;
                        int curLen = 0;
                        int curStart = 0;
                        int i4 = 0;
                        while (i4 < vc * 2) {
                            int idx = i4 % vc;
                            if (waterEdge[idx]) {
                                if (curLen == 0) {
                                    curStart = idx;
                                }
                                if (++curLen > bestLen) {
                                    bestLen = curLen;
                                    bestStart = curStart;
                                }
                            } else {
                                curLen = 0;
                            }
                            ++i4;
                        }
                        if (bestLen >= 3) {
                            if (bestLen > vc) {
                                bestLen = vc;
                            }
                            coastCells.add(ci4);
                            coastStartEdge.add(bestStart);
                            coastLenEdge.add(bestLen);
                        }
                    }
                }
                ++ci4;
            }
            class BridgeCandidate {
                PVector a;
                PVector b;
                float len;

                BridgeCandidate(PVector a, PVector b, float len) {
                    this.a = a;
                    this.b = b;
                    this.len = len;
                }
            }
            ArrayList<BridgeCandidate> bridgeCand = new ArrayList<BridgeCandidate>();
            int idx = 0;
            while (idx < coastCells.size()) {
                PVector cen5;
                int ci5 = (Integer)coastCells.get(idx);
                Cell c9 = this.cells.get(ci5);
                if (c9 != null && c9.vertices != null && (cen5 = this.cellCentroid(c9)) != null) {
                    PVector target;
                    int midVertex;
                    int vc = c9.vertices.size();
                    int start = (Integer)coastStartEdge.get(idx);
                    int lenEdge = (Integer)coastLenEdge.get(idx);
                    int midEdge = lenEdge % 2 == 1 ? (start + lenEdge / 2) % vc : -1;
                    int n2 = midVertex = lenEdge % 2 == 0 ? (start + lenEdge / 2) % vc : -1;
                    if (midEdge >= 0) {
                        PVector a = c9.vertices.get(midEdge);
                        PVector b = c9.vertices.get((midEdge + 1) % vc);
                        target = PVector.add((PVector)a, (PVector)b).mult(0.5f);
                    } else {
                        target = c9.vertices.get(midVertex).copy();
                    }
                    PVector dir = PVector.sub((PVector)target, (PVector)cen5);
                    if (!(dir.magSq() < 1.0E-8f)) {
                        dir.normalize();
                        float travelMax = Main.min((float)worldW, (float)worldH) * 0.6f;
                        float step = stepLen;
                        PVector probe = cen5.copy();
                        PVector endPoint = null;
                        int s = 0;
                        while (s < 800 && (float)s * step < travelMax) {
                            probe.add(PVector.mult((PVector)dir, (float)step));
                            Cell pc = this.findCellContaining(probe.x, probe.y);
                            if (pc != null && pc != c9 && !(pc.elevation < seaLevel)) {
                                PVector tgt;
                                boolean touchesWater = false;
                                int pcIdx = this.indexOfCell(pc);
                                if (pcIdx >= 0 && pc.vertices != null && pc.vertices.size() >= 3) {
                                    ArrayList<Integer> nbs;
                                    int pvc = pc.vertices.size();
                                    ArrayList<Integer> arrayList = nbs = pcIdx < this.cellNeighbors.size() ? this.cellNeighbors.get(pcIdx) : null;
                                    if (nbs != null) {
                                        int e = 0;
                                        while (e < pvc && !touchesWater) {
                                            PVector a = pc.vertices.get(e);
                                            PVector b = pc.vertices.get((e + 1) % pvc);
                                            for (int nbIdx : nbs) {
                                                Cell nb;
                                                if (nbIdx < 0 || nbIdx >= this.cells.size() || (nb = this.cells.get(nbIdx)) == null || nb.elevation >= seaLevel || nb.vertices == null) continue;
                                                int nvc = nb.vertices.size();
                                                int je = 0;
                                                while (je < nvc) {
                                                    boolean matchRev;
                                                    PVector na = nb.vertices.get(je);
                                                    PVector nbp = nb.vertices.get((je + 1) % nvc);
                                                    boolean match = this.distSq(a, na) < 1.0E-6f && this.distSq(b, nbp) < 1.0E-6f;
                                                    boolean bl = matchRev = this.distSq(a, nbp) < 1.0E-6f && this.distSq(b, na) < 1.0E-6f;
                                                    if (match || matchRev) {
                                                        touchesWater = true;
                                                        break;
                                                    }
                                                    ++je;
                                                }
                                                if (touchesWater) break;
                                            }
                                            ++e;
                                        }
                                    }
                                }
                                if (touchesWater && (tgt = this.cellCentroid(pc)) != null) {
                                    endPoint = tgt;
                                    break;
                                }
                            }
                            ++s;
                        }
                        if (endPoint != null) {
                            float bridgeLen = this.dist2D(cen5, endPoint);
                            ArrayList<PVector> road = this.findSnapPath(cen5, endPoint);
                            float roadLen = 0.0f;
                            if (road != null) {
                                int i5 = 0;
                                while (i5 < road.size() - 1) {
                                    roadLen += this.dist2D(road.get(i5), road.get(i5 + 1));
                                    ++i5;
                                }
                            }
                            if (road == null || roadLen >= bridgeLen * 2.0f) {
                                bridgeCand.add(new BridgeCandidate(cen5.copy(), endPoint.copy(), bridgeLen));
                            }
                        }
                    }
                }
                ++idx;
            }
            Collections.sort(bridgeCand, new Comparator<BridgeCandidate>(){

                @Override
                public int compare(BridgeCandidate a, BridgeCandidate b) {
                    return Float.compare(a.len, b.len);
                }
            });
            int bridges = 0;
            for (BridgeCandidate bc : bridgeCand) {
                if (bridges >= 3) break;
                ArrayList<PVector> bridgePts = new ArrayList<PVector>();
                bridgePts.add(bc.a.copy());
                bridgePts.add(bc.b.copy());
                ArrayList<PVector[]> segs = this.segmentsFromPoints(bridgePts);
                if (this.segmentsCross(segs, existingSegs)) continue;
                this.addPathFromPoints(bridgeType, Main.this.useDefaultPathNames ? "Bridge " + (this.paths.size() + 1) : "", bridgePts);
                existingSegs.addAll(segs);
                ++bridges;
            }
        }

        public int ensurePathTypeByName(String name) {
            if (this.pathTypes != null) {
                int i = 0;
                while (i < this.pathTypes.size()) {
                    PathType pt = this.pathTypes.get(i);
                    if (pt != null && pt.name != null && pt.name.equalsIgnoreCase(name)) {
                        return i;
                    }
                    ++i;
                }
            }
            int presetIdx = -1;
            int i = 0;
            while (i < Main.this.PATH_TYPE_PRESETS.length) {
                PathTypePreset p = Main.this.PATH_TYPE_PRESETS[i];
                if (p != null && p.name != null && p.name.equalsIgnoreCase(name)) {
                    presetIdx = i;
                    break;
                }
                ++i;
            }
            PathType created = presetIdx >= 0 ? this.makePathTypeFromPreset(presetIdx) : new PathType(name, Main.this.color(60), 2.0f, 1.0f, PathRouteMode.PATHFIND, 0.0f, true, false);
            this.addPathType(created);
            return this.pathTypes.size() - 1;
        }

        public ArrayList<PVector> growRiver(PVector start, float seaLevel, float stepLen, ArrayList<PVector[]> avoid) {
            ArrayList<PVector> snappedBranch;
            int mid;
            ArrayList<PVector> branch;
            if (start == null) {
                return null;
            }
            ArrayList<PVector> pts = new ArrayList<PVector>();
            pts.add(start.copy());
            PVector dir = new PVector(0.0f, 1.0f);
            float lastElev = this.sampleElevationAt(start.x, start.y, seaLevel);
            int maxSeg = 60;
            int i = 0;
            while (i < maxSeg) {
                PVector cur = pts.get(pts.size() - 1);
                ArrayList<PVector> candidates = new ArrayList<PVector>();
                int k = 0;
                while (k < 5) {
                    float ang = Main.radians((float)Main.this.random(-30.0f, 30.0f));
                    PVector d = dir.copy();
                    d.rotate(ang);
                    if (d.y < 0.0f) {
                        d.y = Main.abs((float)d.y);
                    }
                    d.normalize();
                    d.mult(stepLen);
                    PVector np = PVector.add((PVector)cur, (PVector)d);
                    candidates.add(np);
                    ++k;
                }
                PVector best = null;
                float bestElev = -3.4028235E38f;
                for (PVector c : candidates) {
                    float elev = this.sampleElevationAt(c.x, c.y, seaLevel);
                    if (elev <= seaLevel || elev < lastElev - 0.02f || this.segmentTouches(c, pts, stepLen * 0.5f) || this.segmentsCross(this.segmentsFromPoints(Arrays.asList(cur, c)), avoid) || !(elev > bestElev)) continue;
                    bestElev = elev;
                    best = c;
                }
                if (best == null) break;
                pts.add(best);
                lastElev = Main.max((float)lastElev, (float)bestElev);
                dir = PVector.sub(best, (PVector)cur);
                if (pts.size() > 80) break;
                ++i;
            }
            if (pts.size() < 2) {
                return pts;
            }
            if (pts.size() > 31 && (branch = this.growBranch(pts.get(mid = pts.size() / 2), pts, seaLevel, stepLen * 0.8f, avoid)) != null && branch.size() > 1 && (snappedBranch = this.snapRouteToGraph(branch)).size() > 1) {
                this.addPathFromPoints(this.ensurePathTypeByName("River"), "River Branch " + (this.paths.size() + 1), snappedBranch);
                avoid.addAll(this.segmentsFromPoints(snappedBranch));
            }
            ArrayList<PVector> snapped = this.snapRouteToGraph(pts);
            avoid.addAll(this.segmentsFromPoints(snapped));
            return snapped;
        }

        public ArrayList<PVector> growBranch(PVector start, ArrayList<PVector> main, float seaLevel, float stepLen, ArrayList<PVector[]> avoid) {
            ArrayList<PVector> pts = new ArrayList<PVector>();
            pts.add(start.copy());
            PVector dir = new PVector(0.0f, 1.0f);
            int i = 0;
            while (i < 40) {
                PVector cur = pts.get(pts.size() - 1);
                PVector best = null;
                float bestElev = -3.4028235E38f;
                int k = 0;
                while (k < 4) {
                    ArrayList<PVector[]> segs;
                    float ang = Main.radians((float)Main.this.random(-40.0f, 40.0f));
                    PVector d = dir.copy();
                    d.rotate(ang);
                    d.y = Main.abs((float)d.y);
                    d.normalize();
                    d.mult(stepLen);
                    PVector np = PVector.add((PVector)cur, (PVector)d);
                    float elev = this.sampleElevationAt(np.x, np.y, seaLevel);
                    if (!(elev <= seaLevel) && !this.segmentTouches(np, main, stepLen * 0.5f) && !this.segmentsCross(segs = this.segmentsFromPoints(Arrays.asList(cur, np)), avoid) && elev > bestElev) {
                        bestElev = elev;
                        best = np;
                    }
                    ++k;
                }
                if (best == null) break;
                pts.add(best);
                dir = PVector.sub(best, (PVector)cur);
                ++i;
            }
            return pts.size() < 3 ? null : pts;
        }

        public boolean segmentTouches(PVector p, ArrayList<PVector> poly, float minDist) {
            float md2 = minDist * minDist;
            int i = 0;
            while (i < poly.size()) {
                if (this.distSq(p, poly.get(i)) < md2) {
                    return true;
                }
                if (i < poly.size() - 1 && this.pointToSegmentSq(p, poly.get(i), poly.get(i + 1)) < md2) {
                    return true;
                }
                ++i;
            }
            return false;
        }

        public ArrayList<PVector[]> segmentsFromPoints(List<PVector> pts) {
            ArrayList<PVector[]> out = new ArrayList<PVector[]>();
            if (pts == null) {
                return out;
            }
            int i = 0;
            while (i < pts.size() - 1) {
                out.add(new PVector[]{pts.get(i), pts.get(i + 1)});
                ++i;
            }
            return out;
        }

        public boolean segmentsCross(ArrayList<PVector[]> a, ArrayList<PVector[]> b) {
            if (a == null || b == null) {
                return false;
            }
            for (PVector[] sa : a) {
                for (PVector[] sb : b) {
                    if (!this.segmentsIntersect(sa[0], sa[1], sb[0], sb[1])) continue;
                    return true;
                }
            }
            return false;
        }

        public ArrayList<PVector> trimAtFirstIntersection(ArrayList<PVector> pts, ArrayList<PVector[]> existing) {
            if (pts == null || pts.size() < 2) {
                return null;
            }
            ArrayList<PVector> out = new ArrayList<PVector>();
            out.add(pts.get(0));
            int i = 0;
            while (i < pts.size() - 1) {
                PVector a = pts.get(i);
                PVector b = pts.get(i + 1);
                PVector hit = null;
                for (PVector[] ex : existing) {
                    if (!this.segmentsIntersect(a, b, ex[0], ex[1])) continue;
                    hit = this.segmentIntersection(a, b, ex[0], ex[1]);
                    break;
                }
                if (hit != null) {
                    out.add(hit);
                    break;
                }
                out.add(b);
                ++i;
            }
            return out.size() < 2 ? null : out;
        }

        public void addPathFromPoints(int typeId, String name, ArrayList<PVector> pts) {
            if (pts == null || pts.size() < 2) {
                return;
            }
            Path p = new Path();
            p.typeId = Main.constrain((int)typeId, (int)0, (int)Main.max((int)0, (int)(this.pathTypes.size() - 1)));
            p.name = name;
            p.addRoute(pts);
            this.paths.add(p);
            this.snapDirty = true;
        }

        public boolean segmentsIntersect(PVector a1, PVector a2, PVector b1, PVector b2) {
            float d = (a2.x - a1.x) * (b2.y - b1.y) - (a2.y - a1.y) * (b2.x - b1.x);
            if (Main.abs((float)d) < 1.0E-6f) {
                return false;
            }
            float ua = ((b1.x - a1.x) * (b2.y - b1.y) - (b1.y - a1.y) * (b2.x - b1.x)) / d;
            float ub = ((b1.x - a1.x) * (a2.y - a1.y) - (b1.y - a1.y) * (a2.x - a1.x)) / d;
            return ua >= 0.0f && ua <= 1.0f && ub >= 0.0f && ub <= 1.0f;
        }

        public PVector segmentIntersection(PVector a1, PVector a2, PVector b1, PVector b2) {
            float d = (a2.x - a1.x) * (b2.y - b1.y) - (a2.y - a1.y) * (b2.x - b1.x);
            if (Main.abs((float)d) < 1.0E-6f) {
                return null;
            }
            float ua = ((b1.x - a1.x) * (b2.y - b1.y) - (b1.y - a1.y) * (b2.x - b1.x)) / d;
            return new PVector(a1.x + ua * (a2.x - a1.x), a1.y + ua * (a2.y - a1.y));
        }

        public PVector snapToVertices(PVector p, ArrayList<PVector> meshVerts) {
            if (p == null) {
                return null;
            }
            if (meshVerts == null || meshVerts.isEmpty()) {
                return p;
            }
            float bestD = Float.MAX_VALUE;
            PVector best = p;
            for (PVector v : meshVerts) {
                float d2 = this.distSq(p, v);
                if (!(d2 < bestD)) continue;
                bestD = d2;
                best = v;
            }
            return best.copy();
        }

        public PVector snapToNearestSnapNode(PVector p) {
            if (p == null) {
                return null;
            }
            this.ensureSnapGraph();
            if (this.snapNodes == null || this.snapNodes.isEmpty()) {
                return p.copy();
            }
            PVector best = null;
            float bestD = Float.MAX_VALUE;
            for (PVector v : this.snapNodes.values()) {
                float d2;
                if (v == null || !((d2 = this.distSq(p, v)) < bestD)) continue;
                bestD = d2;
                best = v;
            }
            return best != null ? best.copy() : p.copy();
        }

        public ArrayList<PVector> snapRouteToGraph(ArrayList<PVector> pts) {
            ArrayList<PVector> out = new ArrayList<PVector>();
            if (pts == null || pts.isEmpty()) {
                return out;
            }
            this.ensureSnapGraph();
            for (PVector p : pts) {
                PVector last;
                PVector snapped = this.snapToNearestSnapNode(p);
                if (snapped == null || !out.isEmpty() && this.distSq(last = out.get(out.size() - 1), snapped) < 1.0E-12f) continue;
                out.add(snapped);
            }
            if (out.size() == 1) {
                out.add(out.get(0).copy());
            }
            return out;
        }

        public float pointToSegmentSq(PVector p, PVector a, PVector b) {
            float dx = b.x - a.x;
            float dy = b.y - a.y;
            if (Main.abs((float)dx) < 1.0E-6f && Main.abs((float)dy) < 1.0E-6f) {
                return this.distSq(p, a);
            }
            float t = ((p.x - a.x) * dx + (p.y - a.y) * dy) / (dx * dx + dy * dy);
            t = Main.constrain((float)t, (float)0.0f, (float)1.0f);
            float px = a.x + t * dx;
            float py = a.y + t * dy;
            float ddx = p.x - px;
            float ddy = p.y - py;
            return ddx * ddx + ddy * ddy;
        }

        public String defaultPathNameForType(int typeId) {
            PathType pt;
            String base;
            String string = base = Main.this.useDefaultPathNames ? "Path" : "";
            if (this.pathTypes != null && typeId >= 0 && typeId < this.pathTypes.size() && (pt = this.pathTypes.get(typeId)) != null && pt.name != null && pt.name.trim().length() > 0) {
                base = pt.name.trim();
            }
            if (base.length() == 0) {
                base = Main.this.useDefaultPathNames ? "Path" : "";
            }
            String baseLower = base.toLowerCase();
            int maxIdx = 0;
            if (this.paths != null) {
                for (Path p : this.paths) {
                    String nm;
                    String nmLower;
                    if (p == null || p.name == null || !(nmLower = (nm = p.name.trim()).toLowerCase()).startsWith(baseLower)) continue;
                    String tail = nm.substring(base.length()).trim();
                    try {
                        int idx = Integer.parseInt(tail);
                        if (idx > maxIdx) {
                            maxIdx = idx;
                        }
                    }
                    catch (Exception exception) {}
                    if (tail.length() != 0 || maxIdx >= 1) continue;
                    maxIdx = 1;
                }
            }
            int next = maxIdx <= 0 ? 1 : maxIdx + 1;
            return String.valueOf(base) + " " + next;
        }

        public void addFinishedPath(Path p) {
            if (p == null) {
                return;
            }
            if (p.routes.isEmpty()) {
                return;
            }
            if (p.name == null || p.name.length() == 0) {
                p.name = this.defaultPathNameForType(p.typeId);
            }
            if (p.typeId < 0 || p.typeId >= this.pathTypes.size()) {
                p.typeId = 0;
            }
            this.paths.add(p);
        }

        public void clearAllPaths() {
            this.paths.clear();
        }

        public void appendRouteToPath(Path p, ArrayList<PVector> pts) {
            if (p == null || pts == null || pts.size() < 2) {
                return;
            }
            ArrayList<PVector> cleaned = this.removeDuplicateSegments(p, pts);
            if (cleaned == null || cleaned.size() < 2) {
                return;
            }
            p.addRoute(cleaned);
            this.snapDirty = true;
        }

        public ArrayList<PVector> removeDuplicateSegments(Path p, ArrayList<PVector> pts) {
            if (pts == null || pts.size() < 2) {
                return null;
            }
            HashSet<String> existing = this.collectSegmentKeys(p);
            ArrayList<PVector> out = new ArrayList<PVector>();
            out.add(pts.get(0).copy());
            int i = 0;
            while (i < pts.size() - 1) {
                PVector b;
                PVector a = out.get(out.size() - 1);
                String key = this.segmentKey(a, b = pts.get(i + 1));
                if (!existing.contains(key)) {
                    existing.add(key);
                    out.add(b.copy());
                }
                ++i;
            }
            if (out.size() < 2) {
                return null;
            }
            return out;
        }

        public HashSet<String> collectSegmentKeys(Path p) {
            HashSet<String> keys = new HashSet<String>();
            if (p == null || p.routes == null) {
                return keys;
            }
            for (ArrayList<PVector> seg : p.routes) {
                if (seg == null || seg.size() < 2) continue;
                int i = 0;
                while (i < seg.size() - 1) {
                    PVector a = seg.get(i);
                    PVector b = seg.get(i + 1);
                    keys.add(this.segmentKey(a, b));
                    ++i;
                }
            }
            return keys;
        }

        public String segmentKey(PVector a, PVector b) {
            int ax = Main.round((float)(a.x * 10000.0f));
            int ay = Main.round((float)(a.y * 10000.0f));
            int bx = Main.round((float)(b.x * 10000.0f));
            int by = Main.round((float)(b.y * 10000.0f));
            if (ax < bx || ax == bx && ay <= by) {
                return String.valueOf(ax) + "," + ay + "-" + bx + "," + by;
            }
            return String.valueOf(bx) + "," + by + "-" + ax + "," + ay;
        }

        public ArrayList<PVector[]> collectAllPathSegments() {
            ArrayList<PVector[]> segs = new ArrayList<PVector[]>();
            if (this.paths == null || this.paths.isEmpty()) {
                return segs;
            }
            for (Path p : this.paths) {
                if (p == null || p.routes == null) continue;
                for (ArrayList<PVector> r : p.routes) {
                    if (r == null || r.size() < 2) continue;
                    int i = 0;
                    while (i < r.size() - 1) {
                        PVector a = r.get(i);
                        PVector b = r.get(i + 1);
                        segs.add(new PVector[]{a, b});
                        ++i;
                    }
                }
            }
            return segs;
        }

        public boolean edgeCrossesAnyPath(PVector[] edge, ArrayList<PVector[]> pathSegs) {
            if (edge == null || pathSegs == null || pathSegs.isEmpty()) {
                return false;
            }
            PVector e0 = edge[0];
            PVector e1 = edge[1];
            float minEx = Main.min((float)e0.x, (float)e1.x);
            float maxEx = Main.max((float)e0.x, (float)e1.x);
            float minEy = Main.min((float)e0.y, (float)e1.y);
            float maxEy = Main.max((float)e0.y, (float)e1.y);
            float eps = 1.0E-6f;
            for (PVector[] seg : pathSegs) {
                if (seg == null) continue;
                PVector p0 = seg[0];
                PVector p1 = seg[1];
                float minPx = Main.min((float)p0.x, (float)p1.x);
                float maxPx = Main.max((float)p0.x, (float)p1.x);
                float minPy = Main.min((float)p0.y, (float)p1.y);
                float maxPy = Main.max((float)p0.y, (float)p1.y);
                if (maxEx + eps < minPx || minEx - eps > maxPx || maxEy + eps < minPy || minEy - eps > maxPy || !this.segmentsIntersect(e0, e1, p0, p1, eps)) continue;
                return true;
            }
            return false;
        }

        public void removePathsNear(float wx, float wy, float radius) {
            if (this.paths == null) {
                return;
            }
            float r2 = radius * radius;
            int i = this.paths.size() - 1;
            while (i >= 0) {
                Path p = this.paths.get(i);
                boolean hit = false;
                for (ArrayList<PVector> seg : p.routes) {
                    if (seg == null) continue;
                    for (PVector v : seg) {
                        float dx = v.x - wx;
                        float dy = v.y - wy;
                        if (!(dx * dx + dy * dy <= r2)) continue;
                        hit = true;
                        break;
                    }
                    if (hit) break;
                }
                if (hit) {
                    this.paths.remove(i);
                }
                --i;
            }
        }

        public void erasePathSegments(float wx, float wy, float radius) {
            if (this.paths == null || this.paths.isEmpty()) {
                return;
            }
            float r2 = radius * radius;
            int pi = this.paths.size() - 1;
            while (pi >= 0) {
                Path p = this.paths.get(pi);
                if (p != null && p.routes != null) {
                    ArrayList newRoutes = new ArrayList();
                    boolean modified = false;
                    for (ArrayList<PVector> seg : p.routes) {
                        if (seg == null || seg.size() < 2) continue;
                        ArrayList<PVector> cur = new ArrayList<PVector>();
                        cur.add(seg.get(0).copy());
                        int i = 0;
                        while (i < seg.size() - 1) {
                            PVector a = seg.get(i);
                            PVector b = seg.get(i + 1);
                            PVector proj = this.closestPointOnSegment(wx, wy, a, b);
                            float dx = proj.x - wx;
                            float dy = proj.y - wy;
                            float d2 = dx * dx + dy * dy;
                            boolean hit = d2 <= r2;
                            float dxA = a.x - wx;
                            float dyA = a.y - wy;
                            float dxB = b.x - wx;
                            float dyB = b.y - wy;
                            if (dxA * dxA + dyA * dyA <= r2 || dxB * dxB + dyB * dyB <= r2) {
                                hit = true;
                            }
                            if (hit) {
                                if (cur.size() >= 2) {
                                    newRoutes.add(cur);
                                }
                                cur = new ArrayList();
                                cur.add(b.copy());
                                modified = true;
                            } else {
                                cur.add(b.copy());
                            }
                            ++i;
                        }
                        if (cur.size() < 2) continue;
                        newRoutes.add(cur);
                    }
                    if (modified) {
                        p.routes = newRoutes;
                        if (p.routes.isEmpty()) {
                            this.paths.remove(pi);
                        }
                        this.snapDirty = true;
                    }
                }
                --pi;
            }
        }

        public SegmentHit nearestPathSegmentHit(float wx, float wy, float maxDist) {
            if (this.paths == null || this.paths.isEmpty()) {
                return null;
            }
            float best = maxDist;
            SegmentHit bestHit = null;
            int pi = 0;
            while (pi < this.paths.size()) {
                Path p = this.paths.get(pi);
                if (p != null && p.routes != null) {
                    int ri = 0;
                    while (ri < p.routes.size()) {
                        ArrayList<PVector> seg = p.routes.get(ri);
                        if (seg != null) {
                            int si = 0;
                            while (si < seg.size() - 1) {
                                PVector a = seg.get(si);
                                PVector b = seg.get(si + 1);
                                PVector proj = this.closestPointOnSegment(wx, wy, a, b);
                                float d = Main.dist((float)wx, (float)wy, (float)proj.x, (float)proj.y);
                                if (d < best) {
                                    best = d;
                                    bestHit = new SegmentHit();
                                    bestHit.a = a;
                                    bestHit.b = b;
                                    bestHit.p = proj;
                                    bestHit.pathIndex = pi;
                                    bestHit.routeIndex = ri;
                                    bestHit.segmentIndex = si;
                                }
                                ++si;
                            }
                        }
                        ++ri;
                    }
                }
                ++pi;
            }
            return bestHit;
        }

        public PVector closestPointOnSegment(float px, float py, PVector a, PVector b) {
            float ax = a.x;
            float ay = a.y;
            float bx = b.x;
            float by = b.y;
            float abx = bx - ax;
            float aby = by - ay;
            float t = ((px - ax) * abx + (py - ay) * aby) / (abx * abx + aby * aby + 1.0E-9f);
            t = Main.constrain((float)t, (float)0.0f, (float)1.0f);
            return new PVector(ax + abx * t, ay + aby * t);
        }

        public SegmentHit nearestFrontierSegmentHit(float wx, float wy, float maxDist, boolean useWater, boolean useBiomes, boolean useUnderwaterBiomes, boolean useZones, boolean useElevation, int[] zoneMembership, int[] elevBuckets) {
            if (this.cells == null || this.cells.isEmpty()) {
                return null;
            }
            if (!(useWater || useBiomes || useUnderwaterBiomes || useZones || useElevation)) {
                return null;
            }
            this.ensureCellNeighborsComputed();
            float eps = 1.0E-4f;
            float eps2 = eps * eps;
            float best = maxDist;
            SegmentHit bestHit = null;
            int n = this.cells.size();
            int i = 0;
            while (i < n) {
                Cell a = this.cells.get(i);
                ArrayList<Integer> nbs = this.cellNeighbors.get(i);
                if (nbs != null) {
                    for (int nb : nbs) {
                        Cell b;
                        if (nb <= i || (b = this.cells.get(nb)) == null || !this.boundaryActiveForSnapping(a, b, i, nb, zoneMembership, elevBuckets, useWater, useBiomes, useUnderwaterBiomes, useZones, useElevation)) continue;
                        ArrayList<PVector> va = a.vertices;
                        ArrayList<PVector> vb = b.vertices;
                        if (va == null || vb == null || va.size() < 2 || vb.size() < 2) continue;
                        int ac = va.size();
                        int ai = 0;
                        while (ai < ac) {
                            PVector a0 = va.get(ai);
                            PVector a1 = va.get((ai + 1) % ac);
                            int bi = 0;
                            while (bi < vb.size()) {
                                boolean matchBackward;
                                PVector b0 = vb.get(bi);
                                PVector b1 = vb.get((bi + 1) % vb.size());
                                boolean matchForward = this.distSq(a0, b0) < eps2 && this.distSq(a1, b1) < eps2;
                                boolean bl = matchBackward = this.distSq(a0, b1) < eps2 && this.distSq(a1, b0) < eps2;
                                if (matchForward || matchBackward) {
                                    PVector proj = this.closestPointOnSegment(wx, wy, a0, a1);
                                    float d = Main.dist((float)wx, (float)wy, (float)proj.x, (float)proj.y);
                                    if (!(d < best)) break;
                                    best = d;
                                    bestHit = new SegmentHit();
                                    bestHit.a = a0;
                                    bestHit.b = a1;
                                    bestHit.p = proj;
                                    bestHit.cellA = i;
                                    bestHit.cellB = nb;
                                    break;
                                }
                                ++bi;
                            }
                            ++ai;
                        }
                    }
                }
                ++i;
            }
            return bestHit;
        }

        public Site addSite(float x, float y) {
            Site s = new Site(x, y);
            this.sites.add(s);
            this.markVoronoiDirty();
            return s;
        }

        public void deleteSelectedSites() {
            boolean changed = false;
            int i = this.sites.size() - 1;
            while (i >= 0) {
                if (this.sites.get((int)i).selected) {
                    this.sites.remove(i);
                    changed = true;
                }
                --i;
            }
            if (changed) {
                this.markVoronoiDirty();
            }
        }

        public void clearSiteSelection() {
            for (Site s : this.sites) {
                s.selected = false;
            }
        }

        public void selectSite(Site s) {
            if (s != null) {
                s.selected = true;
            }
        }

        public Site findSiteNear(float wx, float wy, float maxDistWorld) {
            Site best = null;
            float bestSq = maxDistWorld * maxDistWorld;
            for (Site s : this.sites) {
                float dx = s.x - wx;
                float dy = s.y - wy;
                float d2 = dx * dx + dy * dy;
                if (!(d2 <= bestSq)) continue;
                bestSq = d2;
                best = s;
            }
            return best;
        }

        public void markVoronoiDirty() {
            this.voronoiDirty = true;
            this.snapDirty = true;
            this.voronoiJob = null;
            this.invalidateContourCaches();
            this.renderer.invalidateBiomeOutlineCache();
        }

        public void invalidateContourCaches() {
            this.coastCacheValid = false;
            this.cachedCoastGrid = null;
            this.cachedCoastIndex = null;
            this.cachedCoastSeaLevel = Float.MAX_VALUE;
            this.cachedCoastCols = 0;
            this.cachedCoastRows = 0;
            this.cachedCoastCellCount = -1;
            this.coastJob = null;
            this.elevationCacheValid = false;
            this.cachedElevationGrid = null;
            this.cachedElevationSeaLevel = Float.MAX_VALUE;
            this.cachedElevationCols = 0;
            this.cachedElevationRows = 0;
            this.cachedElevationCellCount = -1;
            this.elevationJob = null;
        }

        public void ensureVoronoiComputed() {
            if (this.voronoiDirty && this.voronoiJob == null) {
                this.startVoronoiJob();
            }
            if (this.voronoiJob != null) {
                this.stepVoronoiJob(120, 10);
            }
        }

        public void startVoronoiJob() {
            if (this.sites == null || this.sites.isEmpty()) {
                this.cells.clear();
                this.cellNeighbors.clear();
                this.preservedCells = null;
                this.voronoiDirty = false;
                this.voronoiJob = null;
                this.voronoiProgress = 0.0f;
                return;
            }
            ArrayList<Cell> oldCells = this.preservedCells != null ? this.preservedCells : new ArrayList<Cell>();
            this.voronoiJob = new VoronoiJob(this, this.sites, oldCells, Main.this.defaultElevation, this.preservedCells != null);
            this.voronoiProgress = 0.0f;
        }

        public void stepVoronoiJob(int maxSites, int maxMillis) {
            if (this.voronoiJob == null) {
                return;
            }
            this.voronoiJob.step(maxSites, maxMillis);
            this.voronoiProgress = this.voronoiJob.progress();
            if (this.voronoiJob.isDone()) {
                this.cells = this.voronoiJob.outCells;
                this.preservedCells = null;
                this.voronoiDirty = false;
                this.voronoiJob = null;
                this.voronoiProgress = 1.0f;
                this.rebuildCellNeighbors();
                this.snapDirty = true;
            }
        }

        public boolean isVoronoiBuilding() {
            return this.voronoiJob != null;
        }

        public float getVoronoiProgress() {
            if (this.voronoiJob != null) {
                return this.voronoiJob.progress();
            }
            return this.voronoiDirty ? 0.0f : 1.0f;
        }

        public ArrayList<PVector> clipPolygonWithHalfPlane(ArrayList<PVector> poly, Site si, Site sj) {
            ArrayList<PVector> out = new ArrayList<PVector>();
            if (poly.isEmpty()) {
                return out;
            }
            float ax = sj.x - si.x;
            float ay = sj.y - si.y;
            float c = 0.5f * (sj.x * sj.x + sj.y * sj.y - si.x * si.x - si.y * si.y);
            int count = poly.size();
            int k = 0;
            while (k < count) {
                PVector inter;
                boolean insideNext;
                PVector current = poly.get(k);
                PVector next = poly.get((k + 1) % count);
                float fCurrent = ax * current.x + ay * current.y - c;
                float fNext = ax * next.x + ay * next.y - c;
                boolean insideCurrent = fCurrent <= 0.0f;
                boolean bl = insideNext = fNext <= 0.0f;
                if (insideCurrent && insideNext) {
                    out.add(next.copy());
                } else if (insideCurrent && !insideNext) {
                    inter = this.intersectSegmentWithLine(current, next, fCurrent, fNext);
                    if (inter != null) {
                        out.add(inter);
                    }
                } else if (!insideCurrent && insideNext) {
                    inter = this.intersectSegmentWithLine(current, next, fCurrent, fNext);
                    if (inter != null) {
                        out.add(inter);
                    }
                    out.add(next.copy());
                }
                ++k;
            }
            return out;
        }

        public PVector intersectSegmentWithLine(PVector p1, PVector p2, float f1, float f2) {
            float denom = f1 - f2;
            if (Main.abs((float)denom) < 1.0E-6f) {
                return null;
            }
            float t = f1 / (f1 - f2);
            t = Main.constrain((float)t, (float)0.0f, (float)1.0f);
            float x = Main.lerp((float)p1.x, (float)p2.x, (float)t);
            float y = Main.lerp((float)p1.y, (float)p2.y, (float)t);
            return new PVector(x, y);
        }

        public int sampleBiomeFromOldCells(ArrayList<Cell> oldCells, float x, float y, int fallbackBiome) {
            for (Cell c : oldCells) {
                if (!this.pointInPolygon(x, y, c.vertices)) continue;
                return c.biomeId;
            }
            return fallbackBiome;
        }

        public int sampleZoneFromOldCells(int fallbackZone) {
            return fallbackZone;
        }

        public float sampleElevationFromOldCells(ArrayList<Cell> oldCells, float x, float y, float fallback) {
            for (Cell c : oldCells) {
                if (!this.pointInPolygon(x, y, c.vertices)) continue;
                return c.elevation;
            }
            return fallback;
        }

        public void makePlateaus(float seaLevel) {
            if (this.cells == null || this.cells.isEmpty()) {
                return;
            }
            this.ensureCellNeighborsComputed();
            int nCells = this.cells.size();
            int targetCount = Main.max((int)1, (int)(nCells / 100));
            int iterations = Main.max((int)1, (int)(nCells / 1000));
            int iter = 0;
            while (iter < iterations) {
                int startIdx = (int)Main.this.random(nCells);
                Cell start = this.cells.get(startIdx);
                if (start != null && start.vertices != null && !start.vertices.isEmpty()) {
                    float avg;
                    HashSet<Integer> visited = new HashSet<Integer>();
                    visited.add(startIdx);
                    float sum = start.elevation;
                    int count = 1;
                    while (count < targetCount) {
                        avg = sum / (float)Main.max((int)1, (int)count);
                        float bestDiff = Float.MAX_VALUE;
                        int bestIdx = -1;
                        Iterator iterator = visited.iterator();
                        while (iterator.hasNext()) {
                            int idx = (Integer)iterator.next();
                            ArrayList<Integer> nbs = this.cellNeighbors.get(idx);
                            if (nbs == null) continue;
                            for (int nb : nbs) {
                                float diff;
                                Cell nc;
                                if (nb < 0 || nb >= nCells || visited.contains(nb) || (nc = this.cells.get(nb)) == null || !((diff = Main.abs((float)(nc.elevation - avg))) < bestDiff)) continue;
                                bestDiff = diff;
                                bestIdx = nb;
                            }
                        }
                        if (bestIdx < 0) break;
                        visited.add(bestIdx);
                        Cell added = this.cells.get(bestIdx);
                        if (added == null) continue;
                        sum += added.elevation;
                        ++count;
                    }
                    avg = sum / (float)Main.max((int)1, (int)count);
                    Iterator iterator = visited.iterator();
                    while (iterator.hasNext()) {
                        int idx = (Integer)iterator.next();
                        Cell c = this.cells.get(idx);
                        if (c == null) continue;
                        c.elevation = Main.lerp((float)c.elevation, (float)avg, (float)0.8f);
                    }
                }
                ++iter;
            }
            this.normalizeElevationsIfOutOfBounds(seaLevel);
            this.invalidateContourCaches();
        }

        public Cell findCellContaining(float wx, float wy) {
            for (Cell c : this.cells) {
                if (!this.pointInPolygon(wx, wy, c.vertices)) continue;
                return c;
            }
            return null;
        }

        public Cell nearestCell(float wx, float wy) {
            if (this.cells == null || this.cells.isEmpty()) {
                return null;
            }
            Cell best = null;
            float bestD2 = Float.MAX_VALUE;
            for (Cell c : this.cells) {
                if (c == null || c.vertices == null || c.vertices.size() < 3) continue;
                PVector cen = this.cellCentroid(c);
                float dx = cen.x - wx;
                float dy = cen.y - wy;
                float d2 = dx * dx + dy * dy;
                if (!(d2 < bestD2)) continue;
                bestD2 = d2;
                best = c;
            }
            return best;
        }

        public int findCellIndexContaining(float wx, float wy) {
            if (this.cells == null) {
                return -1;
            }
            int i = 0;
            while (i < this.cells.size()) {
                Cell c = this.cells.get(i);
                if (c != null && this.pointInPolygon(wx, wy, c.vertices)) {
                    return i;
                }
                ++i;
            }
            return -1;
        }

        public boolean pointTouchesWater(float wx, float wy, float sea) {
            ArrayList<Integer> nbs;
            int ci = this.findCellIndexContaining(wx, wy);
            if (ci < 0 || ci >= this.cells.size()) {
                return false;
            }
            Cell c = this.cells.get(ci);
            if (c == null) {
                return false;
            }
            if (c.elevation <= sea) {
                return true;
            }
            this.ensureCellNeighborsComputed();
            ArrayList<Integer> arrayList = nbs = ci < this.cellNeighbors.size() ? this.cellNeighbors.get(ci) : null;
            if (nbs != null) {
                for (int nb : nbs) {
                    Cell nc;
                    if (nb < 0 || nb >= this.cells.size() || (nc = this.cells.get(nb)) == null || !(nc.elevation <= sea)) continue;
                    return true;
                }
            }
            return false;
        }

        public float structureRadius(float size, float aspect) {
            return size * 0.5f * Main.max((float)1.0f, (float)aspect);
        }

        public boolean structuresOverlap(ArrayList<Structure> list, float x, float y, float size, float aspect, float slack) {
            float r = this.structureRadius(size, aspect);
            for (Structure s : list) {
                float ra;
                float rr;
                float dy;
                float dx;
                float d2;
                if (s == null || !((d2 = (dx = s.x - x) * dx + (dy = s.y - y) * dy) < (rr = r + (ra = this.structureRadius(s.size, s.aspect))) * rr * slack)) continue;
                return true;
            }
            return false;
        }

        public boolean pointInPolygon(float x, float y, ArrayList<PVector> poly) {
            if (poly == null || poly.size() < 3) {
                return false;
            }
            boolean inside = false;
            int n = poly.size();
            int i = 0;
            int j = n - 1;
            while (i < n) {
                boolean intersect;
                PVector pi = poly.get(i);
                PVector pj = poly.get(j);
                boolean bl = intersect = pi.y > y != pj.y > y && x < (pj.x - pi.x) * (y - pi.y) / (pj.y - pi.y + 1.0E-9f) + pi.x;
                if (intersect) {
                    inside = !inside;
                }
                j = i++;
            }
            return inside;
        }

        public int indexOfCell(Cell c) {
            int i = 0;
            while (i < this.cells.size()) {
                if (this.cells.get(i) == c) {
                    return i;
                }
                ++i;
            }
            return -1;
        }

        public void floodFillBiomeFromCell(Cell start, int newBiomeId) {
            if (start == null) {
                return;
            }
            int startIndex = this.indexOfCell(start);
            if (startIndex < 0) {
                return;
            }
            int oldBiome = start.biomeId;
            if (oldBiome == newBiomeId) {
                return;
            }
            int n = this.cells.size();
            if (n == 0) {
                return;
            }
            boolean[] visited = new boolean[n];
            int[] stack = new int[n];
            int stackSize = 0;
            float eps = 1.0E-4f;
            stack[stackSize++] = startIndex;
            visited[startIndex] = true;
            while (stackSize > 0) {
                int idx = stack[--stackSize];
                Cell c = this.cells.get(idx);
                if (c.biomeId != oldBiome) continue;
                c.biomeId = newBiomeId;
                int j = 0;
                while (j < n) {
                    Cell other;
                    if (!visited[j] && this.cellsAreNeighbors(c, other = this.cells.get(j), eps)) {
                        visited[j] = true;
                        stack[stackSize++] = j;
                    }
                    ++j;
                }
            }
            this.renderer.invalidateBiomeOutlineCache();
        }

        public void addCellToZone(int cellIdx, int zoneIdx) {
            if (this.zones == null || zoneIdx < 0 || zoneIdx >= this.zones.size()) {
                return;
            }
            if (cellIdx < 0 || cellIdx >= this.cells.size()) {
                return;
            }
            MapZone az = this.zones.get(zoneIdx);
            if (az == null) {
                return;
            }
            if (!az.cells.contains(cellIdx)) {
                az.cells.add(cellIdx);
            }
        }

        public void removeCellFromAllZones(int cellIdx) {
            if (this.zones == null || cellIdx < 0 || this.cells == null || cellIdx >= this.cells.size()) {
                return;
            }
            for (MapZone az : this.zones) {
                if (az == null || az.cells == null) continue;
                az.cells.remove((Object)cellIdx);
            }
        }

        public ArrayList<ArrayList<Integer>> mapCellsToZones() {
            int n = this.cells != null ? this.cells.size() : 0;
            ArrayList<ArrayList<Integer>> result = new ArrayList<ArrayList<Integer>>();
            int i = 0;
            while (i < n) {
                result.add(new ArrayList());
                ++i;
            }
            if (this.zones == null || this.zones.isEmpty() || n == 0) {
                return result;
            }
            int zi = 0;
            while (zi < this.zones.size()) {
                MapZone z = this.zones.get(zi);
                if (z != null && z.cells != null) {
                    for (int ci : z.cells) {
                        if (ci < 0 || ci >= n) continue;
                        result.get(ci).add(zi);
                    }
                }
                ++zi;
            }
            return result;
        }

        public void pruneZoneUnderwater(MapZone zone, float sea) {
            if (zone == null || zone.cells == null || this.cells == null) {
                return;
            }
            ArrayList<Integer> kept = new ArrayList<Integer>();
            for (int ci : zone.cells) {
                Cell c;
                if (ci < 0 || ci >= this.cells.size() || (c = this.cells.get(ci)) == null || c.elevation < sea) continue;
                kept.add(ci);
            }
            zone.cells.clear();
            zone.cells.addAll(kept);
        }

        public void removeUnderwaterCellsFromZone(int zoneIdx, float sea) {
            if (this.zones == null || this.zones.isEmpty()) {
                return;
            }
            if (zoneIdx >= 0 && zoneIdx < this.zones.size()) {
                this.pruneZoneUnderwater(this.zones.get(zoneIdx), sea);
            } else {
                int zi = 0;
                while (zi < this.zones.size()) {
                    this.pruneZoneUnderwater(this.zones.get(zi), sea);
                    ++zi;
                }
            }
            this.renderer.invalidateBiomeOutlineCache();
            this.snapDirty = true;
        }

        public void enforceZoneExclusivity(int zoneIdx) {
            if (this.zones == null || this.zones.isEmpty()) {
                return;
            }
            if (zoneIdx >= 0 && zoneIdx < this.zones.size()) {
                MapZone target = this.zones.get(zoneIdx);
                HashSet<Integer> reserved = new HashSet<Integer>();
                if (target != null && target.cells != null) {
                    reserved.addAll(target.cells);
                }
                int zi = 0;
                while (zi < this.zones.size()) {
                    MapZone other;
                    if (zi != zoneIdx && (other = this.zones.get(zi)) != null && other.cells != null) {
                        ArrayList<Integer> filtered = new ArrayList<Integer>();
                        for (int ci : other.cells) {
                            if (reserved.contains(ci)) continue;
                            filtered.add(ci);
                        }
                        other.cells.clear();
                        other.cells.addAll(filtered);
                    }
                    ++zi;
                }
            } else {
                ArrayList<ArrayList<Integer>> cellZones = this.mapCellsToZones();
                int zoneCount = this.zones.size();
                if (cellZones.isEmpty() || zoneCount == 0) {
                    return;
                }
                int[] counts = new int[zoneCount];
                ArrayList newZoneCells = new ArrayList();
                int zi = 0;
                while (zi < zoneCount) {
                    newZoneCells.add(new ArrayList());
                    ++zi;
                }
                int ci = 0;
                while (ci < cellZones.size()) {
                    ArrayList<Integer> owners = cellZones.get(ci);
                    if (owners != null && !owners.isEmpty()) {
                        int assign = -1;
                        for (int owner : owners) {
                            if (owner < 0 || owner >= zoneCount || assign >= 0 && counts[owner] >= counts[assign]) continue;
                            assign = owner;
                        }
                        if (assign >= 0) {
                            ((ArrayList)newZoneCells.get(assign)).add(ci);
                            int n = assign;
                            counts[n] = counts[n] + 1;
                        }
                    }
                    ++ci;
                }
                zi = 0;
                while (zi < zoneCount) {
                    MapZone z = this.zones.get(zi);
                    if (z != null) {
                        z.cells.clear();
                        z.cells.addAll((Collection)newZoneCells.get(zi));
                    }
                    ++zi;
                }
            }
            this.renderer.invalidateBiomeOutlineCache();
            this.snapDirty = true;
        }

        public void recolorZonesWithFourColors() {
            if (this.zones == null || this.zones.isEmpty()) {
                return;
            }
            this.ensureCellNeighborsComputed();
            int zoneCount = this.zones.size();
            int[] palette = new int[]{Main.this.color(200, 65, 65), Main.this.color(75, 160, 90), Main.this.color(85, 95, 190), Main.this.color(215, 180, 80)};
            ArrayList<ArrayList<Integer>> cellZones = this.mapCellsToZones();
            final ArrayList adjacency = new ArrayList();
            int zi = 0;
            while (zi < zoneCount) {
                adjacency.add(new HashSet());
                ++zi;
            }
            int n = cellZones.size();
            int ci = 0;
            while (ci < n) {
                ArrayList<Integer> owners = cellZones.get(ci);
                if (owners != null && !owners.isEmpty()) {
                    ArrayList<Integer> neighbors;
                    int ownerCount = owners.size();
                    int aIdx = 0;
                    while (aIdx < ownerCount) {
                        int a = owners.get(aIdx);
                        if (a >= 0 && a < zoneCount) {
                            int bIdx = aIdx + 1;
                            while (bIdx < ownerCount) {
                                int b = owners.get(bIdx);
                                if (b >= 0 && b < zoneCount) {
                                    ((HashSet)adjacency.get(a)).add(b);
                                    ((HashSet)adjacency.get(b)).add(a);
                                }
                                ++bIdx;
                            }
                        }
                        ++aIdx;
                    }
                    ArrayList<Integer> arrayList = neighbors = ci < this.cellNeighbors.size() ? this.cellNeighbors.get(ci) : null;
                    if (neighbors != null) {
                        for (int nb : neighbors) {
                            ArrayList<Integer> nbOwners;
                            if (nb < 0 || nb >= cellZones.size() || (nbOwners = cellZones.get(nb)) == null || nbOwners.isEmpty()) continue;
                            for (int a : owners) {
                                if (a < 0 || a >= zoneCount) continue;
                                for (int b : nbOwners) {
                                    if (b < 0 || b >= zoneCount || b == a) continue;
                                    ((HashSet)adjacency.get(a)).add(b);
                                    ((HashSet)adjacency.get(b)).add(a);
                                }
                            }
                        }
                    }
                }
                ++ci;
            }
            int[] assignment = new int[zoneCount];
            Arrays.fill(assignment, -1);
            ArrayList<Integer> order = new ArrayList<Integer>();
            int zi2 = 0;
            while (zi2 < zoneCount) {
                order.add(zi2);
                ++zi2;
            }
            Collections.sort(order, new Comparator<Integer>(){

                @Override
                public int compare(Integer a, Integer b) {
                    return Integer.compare(((HashSet)adjacency.get(b)).size(), ((HashSet)adjacency.get(a)).size());
                }
            });
            Iterator iterator = order.iterator();
            while (iterator.hasNext()) {
                int idx = (Integer)iterator.next();
                boolean[] used = new boolean[palette.length];
                Iterator nbOwners = ((HashSet)adjacency.get(idx)).iterator();
                while (nbOwners.hasNext()) {
                    int usedIdx;
                    int neighbor = (Integer)nbOwners.next();
                    if (neighbor < 0 || neighbor >= zoneCount || assignment[neighbor] < 0 || (usedIdx = assignment[neighbor]) < 0 || usedIdx >= palette.length) continue;
                    used[usedIdx] = true;
                }
                int pick = 0;
                int c = 0;
                while (c < palette.length) {
                    if (!used[c]) {
                        pick = c;
                        break;
                    }
                    ++c;
                }
                assignment[idx] = pick;
                MapZone z = this.zones.get(idx);
                if (z == null) continue;
                int col = palette[pick];
                float[] hsb = this.rgbToHSB(col);
                z.hue01 = hsb[0];
                z.sat01 = hsb[1];
                z.bri01 = hsb[2];
                z.col = col;
            }
            this.renderer.invalidateBiomeOutlineCache();
            this.snapDirty = true;
        }

        public boolean cellInZone(int cellIdx, int zoneIdx) {
            if (this.zones == null || zoneIdx < 0 || zoneIdx >= this.zones.size()) {
                return false;
            }
            MapZone az = this.zones.get(zoneIdx);
            if (az == null) {
                return false;
            }
            return az.cells.contains(cellIdx);
        }

        public void floodFillZone(Cell start, int zoneIdx) {
            if (start == null) {
                return;
            }
            int startIndex = this.indexOfCell(start);
            if (startIndex < 0) {
                return;
            }
            int n = this.cells.size();
            if (n == 0) {
                return;
            }
            this.ensureCellNeighborsComputed();
            boolean[] visited = new boolean[n];
            int[] stack = new int[n];
            int stackSize = 0;
            stack[stackSize++] = startIndex;
            visited[startIndex] = true;
            while (stackSize > 0) {
                ArrayList<Integer> nbs;
                int idx = stack[--stackSize];
                this.addCellToZone(idx, zoneIdx);
                ArrayList<Integer> arrayList = nbs = idx < this.cellNeighbors.size() ? this.cellNeighbors.get(idx) : null;
                if (nbs == null) continue;
                for (int nb : nbs) {
                    if (nb < 0 || nb >= n || visited[nb]) continue;
                    visited[nb] = true;
                    stack[stackSize++] = nb;
                }
            }
        }

        public boolean cellsAreNeighbors(Cell a, Cell b, float eps) {
            if (a.vertices == null || b.vertices == null) {
                return false;
            }
            int shared = 0;
            int i = 0;
            while (i < a.vertices.size()) {
                PVector va = a.vertices.get(i);
                int j = 0;
                while (j < b.vertices.size()) {
                    PVector vb = b.vertices.get(j);
                    float dx = va.x - vb.x;
                    float dy = va.y - vb.y;
                    if (dx * dx + dy * dy <= eps * eps && ++shared >= 2) {
                        return true;
                    }
                    ++j;
                }
                ++i;
            }
            return false;
        }

        public void rebuildCellNeighbors() {
            this.cellNeighbors.clear();
            int n = this.cells.size();
            int i = 0;
            while (i < n) {
                this.cellNeighbors.add(new ArrayList());
                ++i;
            }
            if (n == 0) {
                return;
            }
            float worldW = this.maxX - this.minX;
            float worldH = this.maxY - this.minY;
            float avgCellSize = Main.sqrt((float)(worldW * worldH / (float)Main.max((int)1, (int)n)));
            float binSize = Main.max((float)avgCellSize, (float)0.001f);
            float invBin = 1.0f / binSize;
            float eps = 1.0E-4f;
            float[] minXs = new float[n];
            float[] minYs = new float[n];
            float[] maxXs = new float[n];
            float[] maxYs = new float[n];
            HashMap<Long, ArrayList<Integer>> bins = new HashMap<Long, ArrayList<Integer>>();
            int i2 = 0;
            while (i2 < n) {
                Cell c = this.cells.get(i2);
                if (c != null && c.vertices != null && c.vertices.size() >= 2) {
                    float minx = Float.MAX_VALUE;
                    float miny = Float.MAX_VALUE;
                    float maxx = -3.4028235E38f;
                    float maxy = -3.4028235E38f;
                    for (PVector v : c.vertices) {
                        minx = Main.min((float)minx, (float)v.x);
                        miny = Main.min((float)miny, (float)v.y);
                        maxx = Main.max((float)maxx, (float)v.x);
                        maxy = Main.max((float)maxy, (float)v.y);
                    }
                    minXs[i2] = minx;
                    minYs[i2] = miny;
                    maxXs[i2] = maxx;
                    maxYs[i2] = maxy;
                    int gx0 = Main.floor((float)((minx - this.minX) * invBin));
                    int gx1 = Main.floor((float)((maxx - this.minX) * invBin));
                    int gy0 = Main.floor((float)((miny - this.minY) * invBin));
                    int gy1 = Main.floor((float)((maxy - this.minY) * invBin));
                    int gx = gx0;
                    while (gx <= gx1) {
                        int gy = gy0;
                        while (gy <= gy1) {
                            long key = (long)gx << 32 ^ (long)gy & 0xFFFFFFFFL;
                            ArrayList<Integer> bucket = (ArrayList<Integer>)bins.get(key);
                            if (bucket == null) {
                                bucket = new ArrayList<Integer>();
                                bins.put(key, bucket);
                            }
                            bucket.add(i2);
                            ++gy;
                        }
                        ++gx;
                    }
                }
                ++i2;
            }
            int[] seen = new int[n];
            int stamp = 1;
            int i3 = 0;
            while (i3 < n) {
                Cell a = this.cells.get(i3);
                if (a != null && a.vertices != null && a.vertices.size() >= 2) {
                    int gx0 = Main.floor((float)((minXs[i3] - this.minX) * invBin)) - 1;
                    int gx1 = Main.floor((float)((maxXs[i3] - this.minX) * invBin)) + 1;
                    int gy0 = Main.floor((float)((minYs[i3] - this.minY) * invBin)) - 1;
                    int gy1 = Main.floor((float)((maxYs[i3] - this.minY) * invBin)) + 1;
                    int gx = gx0;
                    while (gx <= gx1) {
                        int gy = gy0;
                        while (gy <= gy1) {
                            long key = (long)gx << 32 ^ (long)gy & 0xFFFFFFFFL;
                            ArrayList bucket = (ArrayList)bins.get(key);
                            if (bucket != null) {
                                Iterator iterator = bucket.iterator();
                                while (iterator.hasNext()) {
                                    Cell b;
                                    int idx = (Integer)iterator.next();
                                    if (idx <= i3 || seen[idx] == stamp) continue;
                                    seen[idx] = stamp;
                                    if (maxXs[i3] + eps < minXs[idx] || minXs[i3] - eps > maxXs[idx] || maxYs[i3] + eps < minYs[idx] || minYs[i3] - eps > maxYs[idx] || (b = this.cells.get(idx)) == null || !this.cellsAreNeighbors(a, b, eps)) continue;
                                    this.cellNeighbors.get(i3).add(idx);
                                    this.cellNeighbors.get(idx).add(i3);
                                }
                            }
                            ++gy;
                        }
                        ++gx;
                    }
                    ++stamp;
                }
                ++i3;
            }
        }

        public void generateSites(PlacementMode mode, int targetCount) {
            this.generateSites(mode, targetCount, false);
        }

        public void generateSites(PlacementMode mode, int targetCount, boolean preserveCellData) {
            int clampedCount = Main.constrain((int)targetCount, (int)0, (int)50000);
            this.preservedCells = preserveCellData ? new ArrayList<Cell>(this.cells) : null;
            this.sites.clear();
            if (!preserveCellData && this.zones != null) {
                for (MapZone az : this.zones) {
                    if (az == null) continue;
                    az.cells.clear();
                }
            }
            if (clampedCount <= 0) {
                this.markVoronoiDirty();
                this.snapDirty = true;
                return;
            }
            if (mode == PlacementMode.GRID) {
                this.generateGridSites(clampedCount);
            } else if (mode == PlacementMode.HEX) {
                this.generateHexSites(clampedCount);
            } else if (mode == PlacementMode.POISSON) {
                this.generatePoissonSites(clampedCount);
            }
            this.applyFuzz(Main.this.siteFuzz);
            this.clearSiteSelection();
            if (!this.sites.isEmpty()) {
                this.sites.get((int)0).selected = true;
            }
            this.markVoronoiDirty();
            this.snapDirty = true;
        }

        public void applyElevationBrush(float cx, float cy, float radius, float delta, float seaLevel) {
            if (this.cells == null || this.cells.isEmpty()) {
                return;
            }
            float preMin = Float.MAX_VALUE;
            float preMax = -3.4028235E38f;
            for (Cell c : this.cells) {
                preMin = Main.min((float)preMin, (float)c.elevation);
                preMax = Main.max((float)preMax, (float)c.elevation);
            }
            float r2 = radius * radius;
            for (Cell c : this.cells) {
                PVector cen = this.cellCentroid(c);
                float dx = cen.x - cx;
                float dy = cen.y - cy;
                float d2 = dx * dx + dy * dy;
                if (d2 > r2) continue;
                float t = 1.0f - Main.sqrt((float)(d2 / r2));
                c.elevation += delta * t;
            }
            this.normalizeElevationsIfOutOfBounds(seaLevel);
            this.invalidateContourCaches();
        }

        public PathType getPathType(int idx) {
            if (this.pathTypes == null) {
                return null;
            }
            if (idx < 0 || idx >= this.pathTypes.size()) {
                return null;
            }
            return this.pathTypes.get(idx);
        }

        public PathType makePathTypeFromPreset(int presetIndex) {
            if (presetIndex < 0) {
                return null;
            }
            int idx = Main.min((int)presetIndex, (int)(Main.this.PATH_TYPE_PRESETS.length - 1));
            PathTypePreset p = Main.this.PATH_TYPE_PRESETS[idx];
            return new PathType(p.name, p.col, p.weightPx, p.minWeightPx, p.routeMode, p.slopeBias, p.avoidWater, p.taperOn);
        }

        public void generateElevationNoise(float scale, float amplitude, float seaLevel) {
            if (this.cells == null) {
                return;
            }
            float preMin = Float.MAX_VALUE;
            float preMax = -3.4028235E38f;
            for (Cell c : this.cells) {
                preMin = Main.min((float)preMin, (float)c.elevation);
                preMax = Main.max((float)preMax, (float)c.elevation);
            }
            for (Cell c : this.cells) {
                PVector cen = this.cellCentroid(c);
                float n = Main.this.noise(cen.x * scale, cen.y * scale);
                c.elevation = (n - 0.5f) * 2.0f * amplitude;
            }
            this.normalizeElevationsIfOutOfBounds(seaLevel);
            this.invalidateContourCaches();
        }

        public void addElevationVariation(float scale, float amplitude, float seaLevel) {
            if (this.cells == null) {
                return;
            }
            float preMin = Float.MAX_VALUE;
            float preMax = -3.4028235E38f;
            for (Cell c : this.cells) {
                preMin = Main.min((float)preMin, (float)c.elevation);
                preMax = Main.max((float)preMax, (float)c.elevation);
            }
            for (Cell c : this.cells) {
                PVector cen = this.cellCentroid(c);
                float n = Main.this.noise(cen.x * scale, cen.y * scale);
                float delta = (n - 0.5f) * 2.0f * amplitude;
                c.elevation += delta;
            }
            this.normalizeElevationsIfOutOfBounds(seaLevel);
            this.invalidateContourCaches();
        }

        public PVector cellCentroid(Cell c) {
            if (c.vertices == null || c.vertices.isEmpty()) {
                return new PVector(0.0f, 0.0f);
            }
            float cx = 0.0f;
            float cy = 0.0f;
            for (PVector v : c.vertices) {
                cx += v.x;
                cy += v.y;
            }
            return new PVector(cx /= (float)c.vertices.size(), cy /= (float)c.vertices.size());
        }

        public void normalizeElevationsIfOutOfBounds(float seaLevel) {
            float scale;
            float toRange;
            float fromRange;
            float newMin = Float.MAX_VALUE;
            float newMax = -3.4028235E38f;
            for (Cell c : this.cells) {
                newMin = Main.min((float)newMin, (float)c.elevation);
                newMax = Main.max((float)newMax, (float)c.elevation);
            }
            float maxLimit = 1.0f;
            float minLimit = -1.0f;
            if (newMax > maxLimit) {
                fromRange = newMax - seaLevel;
                toRange = maxLimit - seaLevel;
                if (fromRange > 1.0E-6f && toRange > 1.0E-6f) {
                    scale = toRange / fromRange;
                    for (Cell c : this.cells) {
                        if (!(c.elevation > seaLevel)) continue;
                        c.elevation = seaLevel + (c.elevation - seaLevel) * scale;
                    }
                }
            }
            if (newMin < minLimit) {
                fromRange = seaLevel - newMin;
                toRange = seaLevel - minLimit;
                if (fromRange > 1.0E-6f && toRange > 1.0E-6f) {
                    scale = toRange / fromRange;
                    for (Cell c : this.cells) {
                        if (!(c.elevation < seaLevel)) continue;
                        c.elevation = seaLevel - (seaLevel - c.elevation) * scale;
                    }
                }
            }
        }

        public void generateZonesFromSeeds() {
            this.generateZonesFromSeeds(-1);
        }

        public void generateZonesFromSeeds(int seedCountOverride) {
            int biomeId;
            int seedCount;
            if (this.cells == null || this.cells.isEmpty()) {
                return;
            }
            int typeCount = this.biomeTypes.size() - 1;
            if (typeCount <= 0) {
                return;
            }
            this.ensureCellNeighborsComputed();
            int n = this.cells.size();
            int[] zoneMembership = null;
            if (this.zones != null && !this.zones.isEmpty()) {
                zoneMembership = new int[n];
                Arrays.fill(zoneMembership, -1);
                int zi = 0;
                while (zi < this.zones.size()) {
                    MapZone z = this.zones.get(zi);
                    if (z != null && z.cells != null) {
                        for (int ci : z.cells) {
                            if (ci < 0 || ci >= n) continue;
                            zoneMembership[ci] = zi;
                        }
                    }
                    ++zi;
                }
            }
            ArrayList<PVector[]> pathSegs = this.collectAllPathSegments();
            int[] biomeForCell = new int[n];
            final float[] biomeCost = new float[n];
            Arrays.fill(biomeForCell, -1);
            Arrays.fill(biomeCost, Float.MAX_VALUE);
            PriorityQueue<Integer> frontier = new PriorityQueue<Integer>(n, new Comparator<Integer>(){

                @Override
                public int compare(Integer a, Integer b) {
                    return Float.compare(biomeCost[a], biomeCost[b]);
                }
            });
            ArrayList<Integer> noneIndices = new ArrayList<Integer>();
            int i = 0;
            while (i < n) {
                Cell c = this.cells.get(i);
                if (c.biomeId > 0) {
                    biomeForCell[i] = c.biomeId;
                    biomeCost[i] = 0.0f;
                    frontier.add(i);
                } else {
                    noneIndices.add(i);
                }
                ++i;
            }
            if (noneIndices.isEmpty()) {
                return;
            }
            Collections.shuffle(noneIndices);
            if (seedCountOverride > 0) {
                seedCount = Main.min((int)seedCountOverride, (int)noneIndices.size());
            } else {
                float avgBiomeSubzoneSize = Main.this.random(10.0f, 200.0f);
                seedCount = Main.floor((float)((float)noneIndices.size() / avgBiomeSubzoneSize));
            }
            seedCount = Main.max((int)1, (int)Main.min((int)seedCount, (int)noneIndices.size()));
            int i2 = 0;
            while (i2 < seedCount) {
                int biomeId2;
                int idx = (Integer)noneIndices.get(i2);
                Cell c = this.cells.get(idx);
                c.biomeId = biomeId2 = 1 + (int)Main.this.random(typeCount);
                biomeForCell[idx] = biomeId2;
                biomeCost[idx] = 0.0f;
                frontier.add(idx);
                ++i2;
            }
            float elevationPenaltyScale = 60.0f;
            float waterPenalty = 20.0f;
            float zoneBoundaryPenalty = 6.0f;
            float pathCrossPenalty = 10.0f;
            while (!frontier.isEmpty()) {
                ArrayList<Integer> nbs;
                int idx = frontier.poll();
                if (idx < 0 || idx >= n || (biomeId = biomeForCell[idx]) <= 0) continue;
                float baseCost = biomeCost[idx];
                ArrayList<Integer> arrayList = nbs = idx < this.cellNeighbors.size() ? this.cellNeighbors.get(idx) : null;
                if (nbs == null) continue;
                Cell c = this.cells.get(idx);
                for (int nb : nbs) {
                    float newCost;
                    if (nb < 0 || nb >= n) continue;
                    Cell nc = this.cells.get(nb);
                    float step = 1.0f;
                    if (c != null && nc != null) {
                        PVector[] edge;
                        float elevDiff = Main.abs((float)(c.elevation - nc.elevation));
                        step += elevDiff * elevationPenaltyScale;
                        boolean waterChange = c.elevation < Main.this.seaLevel ^ nc.elevation < Main.this.seaLevel;
                        if (waterChange) {
                            step += waterPenalty;
                        }
                        if (zoneMembership != null) {
                            int za = zoneMembership[idx];
                            int zb = zoneMembership[nb];
                            if (za >= 0 && zb >= 0 && za != zb) {
                                step += zoneBoundaryPenalty;
                            }
                        }
                        if (pathSegs != null && !pathSegs.isEmpty() && (edge = this.sharedEdgeBetweenCells(c, nc)) != null && this.edgeCrossesAnyPath(edge, pathSegs)) {
                            step += pathCrossPenalty;
                        }
                    }
                    if (!((newCost = baseCost + step) < biomeCost[nb])) continue;
                    biomeCost[nb] = newCost;
                    biomeForCell[nb] = biomeId;
                    frontier.add(nb);
                }
            }
            int i3 = 0;
            while (i3 < n) {
                biomeId = biomeForCell[i3];
                if (biomeId > 0) {
                    this.cells.get((int)i3).biomeId = biomeId;
                }
                ++i3;
            }
        }

        public void resetAllBiomesToNone() {
            if (this.cells == null || this.cells.isEmpty()) {
                return;
            }
            for (Cell c : this.cells) {
                c.biomeId = 0;
            }
            this.renderer.invalidateBiomeOutlineCache();
            this.snapDirty = true;
        }

        public void setAllBiomesTo(int biomeId) {
            if (this.cells == null || this.cells.isEmpty()) {
                return;
            }
            int bid = Main.max((int)0, (int)Main.min((int)biomeId, (int)(this.biomeTypes.size() - 1)));
            for (Cell c : this.cells) {
                c.biomeId = bid;
            }
            this.renderer.invalidateBiomeOutlineCache();
            this.snapDirty = true;
        }

        public void setUnderwaterToBiome(int biomeId, float sea) {
            if (this.cells == null || this.cells.isEmpty()) {
                return;
            }
            for (Cell c : this.cells) {
                if (!(c.elevation < sea)) continue;
                c.biomeId = biomeId;
            }
            this.snapDirty = true;
        }

        public void fillUnderThreshold(int biomeId, float threshold) {
            if (this.cells == null || this.cells.isEmpty()) {
                return;
            }
            for (Cell c : this.cells) {
                if (!(c.elevation < threshold)) continue;
                c.biomeId = biomeId;
            }
            this.renderer.invalidateBiomeOutlineCache();
            this.snapDirty = true;
        }

        public void fillAboveThreshold(int biomeId, float threshold) {
            if (this.cells == null || this.cells.isEmpty()) {
                return;
            }
            for (Cell c : this.cells) {
                if (!(c.elevation > threshold)) continue;
                c.biomeId = biomeId;
            }
            this.renderer.invalidateBiomeOutlineCache();
            this.snapDirty = true;
        }

        /*
         * Unable to fully structure code
         */
        public void fillGapsFromExistingBiomes() {
            if (this.cells == null || this.cells.isEmpty()) {
                return;
            }
            this.ensureCellNeighborsComputed();
            n = this.cells.size();
            biomeForCell = new int[n];
            Arrays.fill(biomeForCell, -1);
            q = new ArrayDeque<Integer>();
            seeds = 0;
            i = 0;
            while (i < n) {
                c = this.cells.get(i);
                if (c.biomeId > 0) {
                    biomeForCell[i] = c.biomeId;
                    q.add(i);
                    ++seeds;
                }
                ++i;
            }
            if (seeds != 0) ** GOTO lbl32
            this.generateZonesFromSeeds();
            return;
lbl-1000:
            // 1 sources

            {
                idx = (Integer)q.poll();
                bid = biomeForCell[idx];
                v0 = nbs = idx < this.cellNeighbors.size() ? this.cellNeighbors.get(idx) : null;
                if (nbs == null) continue;
                for (int nb : nbs) {
                    if (nb < 0 || nb >= n || biomeForCell[nb] != -1) continue;
                    biomeForCell[nb] = bid;
                    q.add(nb);
                }
lbl32:
                // 3 sources

                ** while (!q.isEmpty())
            }
lbl33:
            // 1 sources

            i = 0;
            while (i < n) {
                if (biomeForCell[i] > 0) {
                    this.cells.get((int)i).biomeId = biomeForCell[i];
                }
                ++i;
            }
            this.renderer.invalidateBiomeOutlineCache();
            this.snapDirty = true;
        }

        public void fillGapsWithNewBiomes(float avgSize) {
            this.fillGapsWithNewBiomesInternal(-1, avgSize);
        }

        public void fillGapsWithNewBiomesByCount(int seedCount) {
            this.fillGapsWithNewBiomesInternal(Main.max((int)1, (int)seedCount), -1.0f);
        }

        public void fillGapsWithNewBiomesInternal(int desiredSeedCount, float avgSize) {
            if (this.cells == null || this.cells.isEmpty()) {
                return;
            }
            this.ensureCellNeighborsComputed();
            int n = this.cells.size();
            int typeCount = this.biomeTypes.size() - 1;
            if (typeCount <= 0) {
                return;
            }
            ArrayList<Integer> gaps = new ArrayList<Integer>();
            int i = 0;
            while (i < n) {
                Cell c = this.cells.get(i);
                if (c != null && c.biomeId == 0) {
                    gaps.add(i);
                }
                ++i;
            }
            if (gaps.isEmpty()) {
                return;
            }
            Collections.shuffle(gaps);
            int[] assign = new int[n];
            Arrays.fill(assign, -1);
            ArrayDeque<Integer> q = new ArrayDeque<Integer>();
            int seedCount = desiredSeedCount > 0 ? Main.min((int)desiredSeedCount, (int)gaps.size()) : Main.max((int)1, (int)Main.min((int)gaps.size(), (int)Main.round((float)((float)gaps.size() / avgSize))));
            int i2 = 0;
            while (i2 < seedCount) {
                int bid;
                int idx = (Integer)gaps.get(i2);
                assign[idx] = bid = 1 + (int)Main.this.random(typeCount);
                q.add(idx);
                ++i2;
            }
            while (!q.isEmpty()) {
                ArrayList<Integer> nbs;
                int idx = (Integer)q.poll();
                ArrayList<Integer> arrayList = nbs = idx < this.cellNeighbors.size() ? this.cellNeighbors.get(idx) : null;
                if (nbs == null) continue;
                for (int nb : nbs) {
                    Cell nc;
                    if (nb < 0 || nb >= n || assign[nb] != -1 || (nc = this.cells.get(nb)) == null || nc.biomeId != 0) continue;
                    assign[nb] = assign[idx];
                    q.add(nb);
                }
            }
            i2 = 0;
            while (i2 < n) {
                if (assign[i2] >= 0) {
                    this.cells.get((int)i2).biomeId = assign[i2];
                }
                ++i2;
            }
            this.renderer.invalidateBiomeOutlineCache();
            this.snapDirty = true;
        }

        public void extendBiomeOnce(int biomeId) {
            if (this.cells == null || this.cells.isEmpty()) {
                return;
            }
            this.ensureCellNeighborsComputed();
            int bid = Main.max((int)0, (int)Main.min((int)biomeId, (int)(this.biomeTypes.size() - 1)));
            HashSet<Integer> toPaint = new HashSet<Integer>();
            int n = this.cells.size();
            int i = 0;
            while (i < n) {
                ArrayList<Integer> nbs;
                Cell c = this.cells.get(i);
                if (c != null && c.biomeId == bid && (nbs = this.cellNeighbors.get(i)) != null) {
                    for (int nb : nbs) {
                        Cell nc;
                        if (nb < 0 || nb >= n || (nc = this.cells.get(nb)) == null || nc.biomeId == bid) continue;
                        toPaint.add(nb);
                    }
                }
                ++i;
            }
            Iterator iterator = toPaint.iterator();
            while (iterator.hasNext()) {
                int idx = (Integer)iterator.next();
                this.cells.get((int)idx).biomeId = bid;
            }
            this.renderer.invalidateBiomeOutlineCache();
            this.snapDirty = true;
        }

        public void shrinkBiomeOnce(int biomeId) {
            if (this.cells == null || this.cells.isEmpty()) {
                return;
            }
            this.ensureCellNeighborsComputed();
            int bid = Main.max((int)0, (int)Main.min((int)biomeId, (int)(this.biomeTypes.size() - 1)));
            int n = this.cells.size();
            int[] newBiome = new int[n];
            int i = 0;
            while (i < n) {
                newBiome[i] = this.cells.get((int)i).biomeId;
                ++i;
            }
            i = 0;
            while (i < n) {
                ArrayList<Integer> nbs;
                Cell c = this.cells.get(i);
                if (c != null && c.biomeId == bid && (nbs = this.cellNeighbors.get(i)) != null) {
                    int boundary = 0;
                    for (int nb : nbs) {
                        Cell nc;
                        if (nb < 0 || nb >= n || (nc = this.cells.get(nb)) == null || nc.biomeId == bid) continue;
                        ++boundary;
                    }
                    if (boundary > 0) {
                        int bestBiome = 0;
                        float bestDiff = Float.MAX_VALUE;
                        for (int nb : nbs) {
                            float diff;
                            Cell nc;
                            if (nb < 0 || nb >= n || (nc = this.cells.get(nb)) == null || nc.biomeId == bid || !((diff = Main.abs((float)(nc.elevation - c.elevation))) < bestDiff)) continue;
                            bestDiff = diff;
                            bestBiome = nc.biomeId;
                        }
                        if (bestBiome != bid && bestBiome >= 0) {
                            newBiome[i] = bestBiome;
                        }
                    }
                }
                ++i;
            }
            i = 0;
            while (i < n) {
                this.cells.get((int)i).biomeId = newBiome[i];
                ++i;
            }
            this.renderer.invalidateBiomeOutlineCache();
            this.snapDirty = true;
        }

        public boolean placeBiomeSpotOnce(int biomeId, float value01) {
            if (this.cells == null || this.cells.isEmpty()) {
                return false;
            }
            this.ensureCellNeighborsComputed();
            int n = this.cells.size();
            boolean[] visited = new boolean[n];
            float total = 0.0f;
            int regions = 0;
            int i = 0;
            while (i < n) {
                int size;
                Cell c;
                if (!visited[i] && (c = this.cells.get(i)) != null && c.biomeId > 0 && (size = this.floodCountBiome(i, visited)) > 0) {
                    total += (float)size;
                    ++regions;
                }
                ++i;
            }
            float avg = regions > 0 ? total / (float)regions : 1.0f;
            int targetSize = Main.max((int)1, (int)Main.round((float)(avg * value01 * 2.0f)));
            int startIdx = (int)Main.this.random(n);
            int tries = 0;
            while (tries < 200 && (startIdx < 0 || startIdx >= n || this.cells.get(startIdx) == null || this.cells.get((int)startIdx).biomeId == biomeId)) {
                startIdx = (int)Main.this.random(n);
                ++tries;
            }
            if (startIdx < 0 || startIdx >= n) {
                return false;
            }
            ArrayDeque<Integer> q = new ArrayDeque<Integer>();
            HashSet<Integer> claimed = new HashSet<Integer>();
            q.add(startIdx);
            claimed.add(startIdx);
            block2: while (!q.isEmpty() && claimed.size() < targetSize) {
                ArrayList<Integer> nbs;
                int idx = (Integer)q.poll();
                ArrayList<Integer> arrayList = nbs = idx < this.cellNeighbors.size() ? this.cellNeighbors.get(idx) : null;
                if (nbs == null) continue;
                Collections.shuffle(nbs);
                for (int nb : nbs) {
                    if (nb < 0 || nb >= n || claimed.contains(nb)) continue;
                    claimed.add(nb);
                    q.add(nb);
                    if (claimed.size() >= targetSize) continue block2;
                }
            }
            boolean changed = false;
            Iterator iterator = claimed.iterator();
            while (iterator.hasNext()) {
                int idx = (Integer)iterator.next();
                Cell c = this.cells.get(idx);
                if (c == null || c.biomeId == biomeId) continue;
                c.biomeId = biomeId;
                changed = true;
            }
            return changed;
        }

        public void placeBiomeSpots(int biomeId, float value01) {
            boolean changed = this.placeBiomeSpotOnce(biomeId, value01);
            if (changed) {
                this.renderer.invalidateBiomeOutlineCache();
                this.snapDirty = true;
            }
        }

        public void placeBiomeSpots(int biomeId, int spotCount, float size01) {
            int count = Main.max((int)1, (int)spotCount);
            boolean changedAny = false;
            int i = 0;
            while (i < count) {
                if (this.placeBiomeSpotOnce(biomeId, size01)) {
                    changedAny = true;
                }
                ++i;
            }
            if (changedAny) {
                this.renderer.invalidateBiomeOutlineCache();
                this.snapDirty = true;
            }
        }

        public int floodCountBiome(int startIdx, boolean[] visited) {
            int n = this.cells.size();
            if (startIdx < 0 || startIdx >= n) {
                return 0;
            }
            int bid = this.cells.get((int)startIdx).biomeId;
            ArrayDeque<Integer> q = new ArrayDeque<Integer>();
            q.add(startIdx);
            visited[startIdx] = true;
            int count = 0;
            while (!q.isEmpty()) {
                int idx = (Integer)q.poll();
                Cell c = this.cells.get(idx);
                if (c == null || c.biomeId != bid) continue;
                ++count;
                ArrayList<Integer> nbs = this.cellNeighbors.get(idx);
                if (nbs == null) continue;
                for (int nb : nbs) {
                    if (nb < 0 || nb >= n || visited[nb] || this.cells.get(nb) == null || this.cells.get((int)nb).biomeId != bid) continue;
                    visited[nb] = true;
                    q.add(nb);
                }
            }
            return count;
        }

        public void varyBiomesOnce() {
            if (this.cells == null || this.cells.isEmpty()) {
                return;
            }
            this.ensureCellNeighborsComputed();
            int n = this.cells.size();
            int[] newBiome = new int[n];
            int i = 0;
            while (i < n) {
                newBiome[i] = this.cells.get((int)i).biomeId;
                ++i;
            }
            i = 0;
            while (i < n) {
                ArrayList<Integer> nbs;
                if (!(Main.this.random(1.0f) < 0.1f) && (nbs = this.cellNeighbors.get(i)) != null && !nbs.isEmpty()) {
                    int nb;
                    int[] counts = new int[this.biomeTypes.size()];
                    for (int nb2 : nbs) {
                        int bid;
                        Cell nc;
                        if (nb2 < 0 || nb2 >= n || (nc = this.cells.get(nb2)) == null) continue;
                        int n2 = bid = Main.max((int)0, (int)Main.min((int)nc.biomeId, (int)(this.biomeTypes.size() - 1)));
                        counts[n2] = counts[n2] + 1;
                    }
                    float bestScore = -1.0f;
                    int best = this.cells.get((int)i).biomeId;
                    int b = 0;
                    while (b < counts.length) {
                        float score = (float)counts[b] + Main.this.random(0.0f, 0.25f);
                        if (score > bestScore) {
                            bestScore = score;
                            best = b;
                        }
                        ++b;
                    }
                    if (!nbs.isEmpty() && Main.this.random(1.0f) < 0.2f && (nb = nbs.get((int)Main.this.random(nbs.size())).intValue()) >= 0 && nb < n && this.cells.get(nb) != null) {
                        best = Main.max((int)0, (int)Main.min((int)this.cells.get((int)nb).biomeId, (int)(this.biomeTypes.size() - 1)));
                    }
                    newBiome[i] = best;
                }
                ++i;
            }
            i = 0;
            while (i < n) {
                this.cells.get((int)i).biomeId = newBiome[i];
                ++i;
            }
            this.renderer.invalidateBiomeOutlineCache();
            this.snapDirty = true;
        }

        public void placeSliceSpot(int biomeId, float sizeParam, final float level) {
            int idx;
            if (this.cells == null || this.cells.isEmpty()) {
                return;
            }
            this.ensureCellNeighborsComputed();
            int n = this.cells.size();
            int seedIdx = -1;
            int fallbackIdx = -1;
            float bestDiff = Float.MAX_VALUE;
            float bestAnyDiff = Float.MAX_VALUE;
            int i = 0;
            while (i < n) {
                Cell c = this.cells.get(i);
                if (c != null) {
                    float diff = Main.abs((float)(c.elevation - level));
                    if (c.biomeId != biomeId && diff < bestDiff) {
                        bestDiff = diff;
                        seedIdx = i;
                    }
                    if (diff < bestAnyDiff) {
                        bestAnyDiff = diff;
                        fallbackIdx = i;
                    }
                }
                ++i;
            }
            if (seedIdx < 0) {
                seedIdx = fallbackIdx;
            }
            if (seedIdx < 0) {
                return;
            }
            int targetCount = Main.max((int)1, (int)Main.min((int)100, (int)(1 + Main.round((float)(sizeParam * 99.0f)))));
            HashSet<Integer> claimed = new HashSet<Integer>();
            PriorityQueue<Integer> frontier = new PriorityQueue<Integer>(new Comparator<Integer>(){

                @Override
                public int compare(Integer a, Integer b) {
                    float da = Main.abs((float)(MapModel.this.cells.get((int)a.intValue()).elevation - level));
                    float db = Main.abs((float)(MapModel.this.cells.get((int)b.intValue()).elevation - level));
                    return Float.compare(da, db);
                }
            });
            claimed.add(seedIdx);
            frontier.add(seedIdx);
            block1: while (!frontier.isEmpty() && claimed.size() < targetCount) {
                ArrayList<Integer> nbs;
                idx = frontier.poll();
                ArrayList<Integer> arrayList = nbs = idx < this.cellNeighbors.size() ? this.cellNeighbors.get(idx) : null;
                if (nbs == null) continue;
                for (int nb : nbs) {
                    Cell nc;
                    if (nb < 0 || nb >= n || claimed.contains(nb) || (nc = this.cells.get(nb)) == null) continue;
                    claimed.add(nb);
                    frontier.add(nb);
                    if (claimed.size() >= targetCount) continue block1;
                }
            }
            Iterator iterator = claimed.iterator();
            while (iterator.hasNext()) {
                idx = (Integer)iterator.next();
                Cell c = this.cells.get(idx);
                if (c == null) continue;
                c.biomeId = biomeId;
            }
            this.renderer.invalidateBiomeOutlineCache();
            this.snapDirty = true;
        }

        public float sampleGridDistance(ContourGrid g, float x, float y) {
            if (g == null || g.cols < 2 || g.rows < 2) {
                return Float.MAX_VALUE;
            }
            float fx = Main.constrain((float)((x - g.ox) / Main.max((float)1.0E-6f, (float)g.dx)), (float)0.0f, (float)((float)g.cols - 1.0001f));
            float fy = Main.constrain((float)((y - g.oy) / Main.max((float)1.0E-6f, (float)g.dy)), (float)0.0f, (float)((float)g.rows - 1.0001f));
            int ix = Main.floor((float)fx);
            int iy = Main.floor((float)fy);
            float tx = fx - (float)ix;
            float ty = fy - (float)iy;
            float v00 = g.v[iy][ix];
            float v10 = g.v[iy][ix + 1];
            float v01 = g.v[iy + 1][ix];
            float v11 = g.v[iy + 1][ix + 1];
            float v0 = Main.lerp((float)v00, (float)v10, (float)tx);
            float v1 = Main.lerp((float)v01, (float)v11, (float)tx);
            float v = Main.lerp((float)v0, (float)v1, (float)ty);
            return Main.abs((float)v);
        }

        public boolean hasAnyNoneBiome() {
            if (this.cells == null || this.cells.isEmpty()) {
                return false;
            }
            for (Cell c : this.cells) {
                if (c.biomeId != 0) continue;
                return true;
            }
            return false;
        }

        public void resetAllZonesToNone() {
            if (this.zones != null) {
                this.zones.clear();
            }
        }

        public void regenerateRandomZones(int targetZones) {
            int ci;
            if (this.cells == null || this.cells.isEmpty()) {
                return;
            }
            int n = this.cells.size();
            int zoneCount = Main.max((int)1, (int)targetZones);
            this.zones.clear();
            int i = 0;
            while (i < zoneCount) {
                float h = this.pickMaxGapHue();
                int col = this.zoneColorForHue(h);
                MapZone z = new MapZone(this.randomLabelName(), col);
                z.hue01 = h;
                z.updateColorFromHSB();
                this.zones.add(z);
                ++i;
            }
            this.ensureCellNeighborsComputed();
            ArrayList<Integer> indices = new ArrayList<Integer>();
            int i2 = 0;
            while (i2 < n) {
                indices.add(i2);
                ++i2;
            }
            Collections.shuffle(indices);
            int[] zoneForCell = new int[n];
            final float[] zoneCost = new float[n];
            Arrays.fill(zoneForCell, -1);
            Arrays.fill(zoneCost, Float.MAX_VALUE);
            PriorityQueue<Integer> frontier = new PriorityQueue<Integer>(n, new Comparator<Integer>(){

                @Override
                public int compare(Integer a, Integer b) {
                    return Float.compare(zoneCost[a], zoneCost[b]);
                }
            });
            int idx = 0;
            int z = 0;
            while (z < zoneCount && idx < indices.size()) {
                int ci2 = (Integer)indices.get(idx++);
                zoneForCell[ci2] = z++;
                zoneCost[ci2] = 0.0f;
                frontier.add(ci2);
            }
            float biomePenalty = 6.0f;
            float elevationPenaltyScale = 60.0f;
            float waterPenalty = 70.0f;
            while (!frontier.isEmpty()) {
                ArrayList<Integer> nbs;
                ci = frontier.poll();
                float baseCost = zoneCost[ci];
                ArrayList<Integer> arrayList = nbs = ci < this.cellNeighbors.size() ? this.cellNeighbors.get(ci) : null;
                if (nbs == null) continue;
                for (int nb : nbs) {
                    float newCost;
                    if (nb < 0 || nb >= n) continue;
                    float step = 1.0f;
                    Cell ca = this.cells.get(ci);
                    Cell cb = this.cells.get(nb);
                    if (ca != null && cb != null) {
                        if (ca.biomeId != cb.biomeId) {
                            step += biomePenalty;
                        }
                        float elevDiff = Main.abs((float)(ca.elevation - cb.elevation));
                        step += elevDiff * elevationPenaltyScale;
                        boolean waterChange = ca.elevation < Main.this.seaLevel ^ cb.elevation < Main.this.seaLevel;
                        if (waterChange) {
                            step += waterPenalty;
                        }
                    }
                    if (!((newCost = baseCost + step) < zoneCost[nb])) continue;
                    zoneCost[nb] = newCost;
                    zoneForCell[nb] = zoneForCell[ci];
                    frontier.add(nb);
                }
            }
            for (MapZone az : this.zones) {
                if (az == null) continue;
                az.cells.clear();
            }
            ci = 0;
            while (ci < n) {
                int z2 = zoneForCell[ci];
                if (z2 >= 0 && z2 < this.zones.size()) {
                    this.zones.get((int)z2).cells.add(ci);
                }
                ++ci;
            }
        }

        public boolean hasAnyNoneZone() {
            if (this.zones == null || this.zones.isEmpty()) {
                return true;
            }
            for (MapZone az : this.zones) {
                if (az == null || !az.cells.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public void ensureCellNeighborsComputed() {
            if (this.cellNeighbors == null || this.cellNeighbors.size() != this.cells.size()) {
                this.rebuildCellNeighbors();
            }
        }

        public void applyFuzz(float fuzz) {
            if (fuzz <= 0.0f) {
                return;
            }
            if (this.sites.isEmpty()) {
                return;
            }
            float w = this.maxX - this.minX;
            float h = this.maxY - this.minY;
            float d = Main.min((float)w, (float)h);
            float maxOffset = fuzz * d / 10.0f;
            for (Site s : this.sites) {
                float dx = Main.this.random(-maxOffset, maxOffset);
                float dy = Main.this.random(-maxOffset, maxOffset);
                s.x = Main.constrain((float)(s.x + dx), (float)this.minX, (float)this.maxX);
                s.y = Main.constrain((float)(s.y + dy), (float)this.minY, (float)this.maxY);
            }
        }

        public void generateGridSites(int targetCount) {
            int res;
            if (targetCount <= 0) {
                return;
            }
            int cols = res = Main.max((int)1, (int)Main.ceil((float)Main.sqrt((float)Main.max((int)1, (int)targetCount))));
            int rows = res;
            float w = this.maxX - this.minX;
            float h = this.maxY - this.minY;
            float dx = w / (float)cols;
            float dy = h / (float)rows;
            int j = 0;
            while (j < rows) {
                int i = 0;
                while (i < cols) {
                    float x = this.minX + ((float)i + 0.5f) * dx;
                    float y = this.minY + ((float)j + 0.5f) * dy;
                    this.sites.add(new Site(x, y));
                    ++i;
                }
                ++j;
            }
        }

        public void generateHexSites(int targetCount) {
            if (targetCount <= 0) {
                return;
            }
            int res = Main.max((int)1, (int)Main.ceil((float)Main.sqrt((float)Main.max((int)1, (int)targetCount))));
            float w = this.maxX - this.minX;
            float h = this.maxY - this.minY;
            int cols = res;
            float dx = cols > 1 ? w / (float)(cols - 1) : w;
            float dy = dx * Main.sqrt((float)3.0f) / 2.0f;
            int rows = Main.max((int)1, (int)(Main.ceil((float)(h / dy)) + 1));
            int j = 0;
            while (j < rows) {
                float offset = j % 2 == 0 ? 0.0f : dx * 0.5f;
                int i = -1;
                while (i <= cols) {
                    float y;
                    float x = this.minX + (float)i * dx + offset;
                    if (!(x < this.minX || x > this.maxX || (y = this.minY + (float)j * dy) < this.minY || y > this.maxY)) {
                        this.sites.add(new Site(x, y));
                    }
                    ++i;
                }
                ++j;
            }
        }

        public void generatePoissonSites(int targetCount) {
            PVector p;
            if (targetCount <= 0) {
                return;
            }
            float w = this.maxX - this.minX;
            float h = this.maxY - this.minY;
            float area = Main.max((float)1.0E-6f, (float)(w * h));
            float r = Main.sqrt((float)(area / (float)Main.max((int)1, (int)targetCount))) * 0.85f;
            float cellSize = r / Main.sqrt((float)2.0f);
            int gridW = Main.ceil((float)(w / cellSize));
            int gridH = Main.ceil((float)(h / cellSize));
            int[] grid = new int[gridW * gridH];
            int i = 0;
            while (i < grid.length) {
                grid[i] = -1;
                ++i;
            }
            ArrayList<PVector> points = new ArrayList<PVector>();
            ArrayList<Integer> active = new ArrayList<Integer>();
            float x0 = Main.this.random(this.minX, this.maxX);
            float y0 = Main.this.random(this.minY, this.maxY);
            points.add(new PVector(x0, y0));
            active.add(0);
            int gx = (int)((x0 - this.minX) / cellSize);
            int gy = (int)((y0 - this.minY) / cellSize);
            if (gx >= 0 && gx < gridW && gy >= 0 && gy < gridH) {
                grid[gy * gridW + gx] = 0;
            }
            int k = 30;
            int maxPoints = Main.max((int)1, (int)Main.min((int)targetCount, (int)50000));
            while (!active.isEmpty() && points.size() < maxPoints) {
                int idx = (Integer)active.get((int)Main.this.random(active.size()));
                p = (PVector)points.get(idx);
                boolean found = false;
                int attempt = 0;
                while (attempt < k) {
                    float angle = Main.this.random((float)Math.PI * 2);
                    float radius = r * (1.0f + Main.this.random(1.0f));
                    float nx = p.x + Main.cos((float)angle) * radius;
                    float ny = p.y + Main.sin((float)angle) * radius;
                    if (!(nx < this.minX || nx > this.maxX || ny < this.minY || ny > this.maxY)) {
                        int ngx2 = (int)((nx - this.minX) / cellSize);
                        int ngy2 = (int)((ny - this.minY) / cellSize);
                        boolean ok = true;
                        int yy = Main.max((int)0, (int)(ngy2 - 2));
                        while (yy <= Main.min((int)(gridH - 1), (int)(ngy2 + 2)) && ok) {
                            int xx = Main.max((int)0, (int)(ngx2 - 2));
                            while (xx <= Main.min((int)(gridW - 1), (int)(ngx2 + 2)) && ok) {
                                int pi = grid[yy * gridW + xx];
                                if (pi != -1) {
                                    PVector op = (PVector)points.get(pi);
                                    float dx = op.x - nx;
                                    float dy = op.y - ny;
                                    if (dx * dx + dy * dy < r * r) {
                                        ok = false;
                                    }
                                }
                                ++xx;
                            }
                            ++yy;
                        }
                        if (ok) {
                            int newIndex = points.size();
                            points.add(new PVector(nx, ny));
                            active.add(newIndex);
                            grid[ngy2 * gridW + ngx2] = newIndex;
                            found = true;
                            break;
                        }
                    }
                    ++attempt;
                }
                if (found) continue;
                active.remove((Object)idx);
            }
            if (points.isEmpty()) {
                this.generateGridSites(targetCount);
                return;
            }
            int i2 = 0;
            while (i2 < points.size()) {
                p = (PVector)points.get(i2);
                this.sites.add(new Site(p.x, p.y));
                ++i2;
            }
        }

        public int defaultPatternIndexForBiome(int biomeIdx) {
            if (this.biomePatternCount <= 0) {
                return 0;
            }
            return (biomeIdx % this.biomePatternCount + this.biomePatternCount) % this.biomePatternCount;
        }

        public void setBiomePatternFiles(ArrayList<String> files) {
            this.biomePatternFiles = files != null ? new ArrayList<String>(files) : new ArrayList();
            this.biomePatternCount = Main.max((int)1, (int)this.biomePatternFiles.size());
            this.syncBiomePatternAssignments();
        }

        public void syncBiomePatternAssignments() {
            if (this.biomeTypes == null) {
                return;
            }
            int i = 0;
            while (i < this.biomeTypes.size()) {
                ZoneType z = this.biomeTypes.get(i);
                if (z != null && (z.patternIndex < 0 || z.patternIndex >= this.biomePatternCount)) {
                    z.patternIndex = this.defaultPatternIndexForBiome(i);
                }
                ++i;
            }
        }

        public String biomePatternNameForIndex(int patternIdx, String fallback) {
            if (this.biomePatternFiles == null || this.biomePatternFiles.isEmpty() || this.biomePatternCount <= 0) {
                return fallback;
            }
            int idx = (patternIdx % this.biomePatternFiles.size() + this.biomePatternFiles.size()) % this.biomePatternFiles.size();
            String name = this.biomePatternFiles.get(idx = Main.min((int)idx, (int)(this.biomePatternFiles.size() - 1)));
            if (name == null || name.length() == 0) {
                return fallback;
            }
            return name;
        }

        public boolean biomeNameExists(String name) {
            if (name == null || this.biomeTypes == null) {
                return false;
            }
            for (ZoneType zt : this.biomeTypes) {
                if (zt == null || zt.name == null || !zt.name.equalsIgnoreCase(name)) continue;
                return true;
            }
            return false;
        }

        public void addBiomeType() {
            int nonNoneCount = Main.max((int)0, (int)(this.biomeTypes.size() - 1));
            ZonePreset preset = null;
            int pi = nonNoneCount;
            while (pi < Main.this.ZONE_PRESETS.length) {
                ZonePreset cand = Main.this.ZONE_PRESETS[pi];
                if (cand != null && cand.name != null && !this.biomeNameExists(cand.name)) {
                    preset = cand;
                    break;
                }
                ++pi;
            }
            if (preset != null) {
                ZoneType z = new ZoneType(preset.name, preset.col);
                z.patternIndex = this.defaultPatternIndexForBiome(this.biomeTypes.size());
                this.biomeTypes.add(z);
            } else {
                int n = this.biomeTypes.size();
                float baseHue = 0.33f;
                float baseSat = 0.4f;
                float baseBri = 1.0f;
                if (n > 1) {
                    ZoneType last = this.biomeTypes.get(n - 1);
                    baseHue = (last.hue01 + 0.15f) % 1.0f;
                    baseSat = last.sat01;
                    baseBri = last.bri01;
                }
                int newIndex = n;
                String name = "Type " + newIndex;
                int col = Main.this.hsb01ToARGB(baseHue, baseSat, baseBri, 1.0f);
                ZoneType z = new ZoneType(name, col);
                z.patternIndex = this.defaultPatternIndexForBiome(this.biomeTypes.size());
                this.biomeTypes.add(z);
            }
        }

        public void addZone() {
            float baseHue = this.zones.isEmpty() ? this.distributedHueForIndex(0) : this.pickMaxGapHue();
            int col = this.zoneColorForHue(baseHue);
            MapZone z = new MapZone(this.randomLabelName(), col);
            z.hue01 = baseHue;
            z.updateColorFromHSB();
            this.zones.add(z);
        }

        public void addPathType(PathType pt) {
            if (pt == null) {
                return;
            }
            this.pathTypes.add(pt);
        }

        public void removePathType(int idx) {
            if (idx <= 0) {
                return;
            }
            if (idx < 0 || idx >= this.pathTypes.size()) {
                return;
            }
            this.pathTypes.remove(idx);
            for (Path p : this.paths) {
                if (p.typeId == idx) {
                    p.typeId = 0;
                    continue;
                }
                if (p.typeId <= idx) continue;
                --p.typeId;
            }
        }

        public void removeBiomeType(int index) {
            if (index <= 0) {
                return;
            }
            if (index >= this.biomeTypes.size()) {
                return;
            }
            this.biomeTypes.remove(index);
            for (Cell c : this.cells) {
                if (c.biomeId == index) {
                    c.biomeId = 0;
                    continue;
                }
                if (c.biomeId <= index) continue;
                --c.biomeId;
            }
            this.renderer.invalidateBiomeOutlineCache();
        }

        public void removeZone(int index) {
            if (index < 0 || index >= this.zones.size()) {
                return;
            }
            this.zones.remove(index);
            this.renderer.invalidateBiomeOutlineCache();
        }

        public void markRenderCacheDirty() {
            this.renderer.invalidateBiomeOutlineCache();
            this.invalidateContourCaches();
        }

        public ArrayList<PVector> findSnapPathBidirectional(String kFrom, String kTo, boolean favorFlat, HashMap<String, PVector> snapNodes, HashMap<String, ArrayList<String>> snapAdj) {
            ArrayList<PVector> result = null;
            PVector target = snapNodes.get(kTo);
            PVector startP = snapNodes.get(kFrom);
            if (startP == null || target == null) {
                return null;
            }
            HashMap<String, Float> distF = new HashMap<String, Float>();
            HashMap<String, Float> distB = new HashMap<String, Float>();
            HashMap<String, String> prevF = new HashMap<String, String>();
            HashMap<String, String> prevB = new HashMap<String, String>();
            HashSet<String> closedF = new HashSet<String>();
            HashSet closedB = new HashSet();
            PriorityQueue<NodeDist> pqF = new PriorityQueue<NodeDist>();
            PriorityQueue<NodeDist> pqB = new PriorityQueue<NodeDist>();
            distF.put(kFrom, Float.valueOf(0.0f));
            distB.put(kTo, Float.valueOf(0.0f));
            pqF.add(new NodeDist(kFrom, 0.0f, this.distSq(startP, target)));
            pqB.add(new NodeDist(kTo, 0.0f, this.distSq(target, startP)));
            float bestCost = Float.MAX_VALUE;
            String bestMeet = null;
            int expanded = 0;
            HashMap<String, Float> elevCache = new HashMap<String, Float>();
            while (!pqF.isEmpty() || !pqB.isEmpty()) {
                PVector p;
                ArrayList<String> neighbors;
                float total;
                HashSet<String> closed;
                float fFront = pqF.isEmpty() ? Float.MAX_VALUE : ((NodeDist)pqF.peek()).f;
                float fBack = pqB.isEmpty() ? Float.MAX_VALUE : ((NodeDist)pqB.peek()).f;
                boolean expandFront = fFront <= fBack;
                PriorityQueue<NodeDist> pq = expandFront ? pqF : pqB;
                HashMap<String, Float> dist = expandFront ? distF : distB;
                HashMap<String, Float> distOther = expandFront ? distB : distF;
                HashMap<String, String> prev = expandFront ? prevF : prevB;
                HashSet<String> hashSet = closed = expandFront ? closedF : closedB;
                if (pq.isEmpty()) break;
                NodeDist nd = (NodeDist)pq.poll();
                Float bestD = (Float)dist.get(nd.k);
                if (bestD != null && nd.g > bestD.floatValue() + 1.0E-6f) continue;
                if (expanded++ > Main.this.PATH_MAX_EXPANSIONS) break;
                closed.add(nd.k);
                Float otherCost = (Float)distOther.get(nd.k);
                if (otherCost != null && (total = nd.g + otherCost.floatValue()) < bestCost) {
                    bestCost = total;
                    bestMeet = nd.k;
                }
                if (nd.f >= bestCost || (neighbors = snapAdj.get(nd.k)) == null || (p = snapNodes.get(nd.k)) == null) continue;
                for (String nb : neighbors) {
                    PVector np;
                    if (closed.contains(nb) || (np = snapNodes.get(nb)) == null) continue;
                    float elevA = elevCache.containsKey(nd.k) ? ((Float)elevCache.get(nd.k)).floatValue() : this.sampleElevationAt(p.x, p.y, Main.this.seaLevel);
                    float elevB = elevCache.containsKey(nb) ? ((Float)elevCache.get(nb)).floatValue() : this.sampleElevationAt(np.x, np.y, Main.this.seaLevel);
                    elevCache.put(nd.k, Float.valueOf(elevA));
                    elevCache.put(nb, Float.valueOf(elevB));
                    float w = this.distSq(p, np);
                    if (Main.this.pathAvoidWater) {
                        boolean bw;
                        boolean aw = elevA < Main.this.seaLevel;
                        boolean bl = bw = elevB < Main.this.seaLevel;
                        if (aw || bw) {
                            w *= 1000000.0f;
                        }
                    }
                    if (favorFlat) {
                        float dh = Main.abs((float)(elevB - elevA));
                        w *= 1.0f + dh * Main.this.flattestSlopeBias;
                    }
                    float ng = nd.g + w;
                    Float curD = (Float)dist.get(nb);
                    if (curD != null && !(ng < curD.floatValue() - 1.0E-6f)) continue;
                    dist.put(nb, Float.valueOf(ng));
                    prev.put(nb, nd.k);
                    float h = expandFront ? this.distSq(np, target) : this.distSq(np, startP);
                    pq.add(new NodeDist(nb, ng, ng + h * 0.5f));
                }
            }
            if (bestMeet != null) {
                ArrayList<PVector> forward = this.reconstructPath(prevF, kFrom, bestMeet);
                ArrayList<PVector> backward = this.reconstructPath(prevB, kTo, bestMeet);
                if (forward != null && backward != null) {
                    Collections.reverse(backward);
                    if (!backward.isEmpty()) {
                        backward.remove(0);
                    }
                    forward.addAll(backward);
                    result = forward;
                }
            } else {
                result = this.reconstructPath(prevF, kFrom, kTo);
            }
            this.lastPathfindExpanded = expanded;
            return result;
        }

        public void generateStructuresAuto(int townCount, float buildingDensity, float sea) {
            if (townCount < 0) {
                townCount = 0;
            }
            buildingDensity = Main.constrain((float)buildingDensity, (float)0.0f, (float)1.0f);
            if (this.structures == null) {
                this.structures = new ArrayList();
            }
            float baseSize = 0.02f;
            if (!this.structures.isEmpty()) {
                ArrayList<Float> sizes = new ArrayList<Float>();
                for (Structure s : this.structures) {
                    if (s == null || !(s.size > 1.0E-6f)) continue;
                    sizes.add(Float.valueOf(s.size));
                }
                if (!sizes.isEmpty()) {
                    Collections.sort(sizes);
                    baseSize = ((Float)sizes.get(sizes.size() / 2)).floatValue();
                }
            }
            float townSize = baseSize * 2.5f;
            float buildingSize = baseSize * (0.4f + 0.5f * (1.0f - buildingDensity));
            class Cand {
                PVector p;
                float score;

                Cand(PVector p, float s) {
                    this.p = p;
                    this.score = s;
                }
            }
            ArrayList<Cand> cands = new ArrayList<Cand>();
            if (this.zones != null && !this.zones.isEmpty()) {
                for (MapZone z : this.zones) {
                    Cell nearest;
                    if (z == null || z.cells == null || z.cells.isEmpty()) continue;
                    float cx = 0.0f;
                    float cy = 0.0f;
                    int count = 0;
                    for (int ci : z.cells) {
                        Cell c;
                        if (ci < 0 || ci >= this.cells.size() || (c = this.cells.get(ci)) == null || c.vertices == null || c.vertices.size() < 3) continue;
                        PVector cen = this.cellCentroid(c);
                        cx += cen.x;
                        cy += cen.y;
                        ++count;
                    }
                    if (count <= 0 || (nearest = this.nearestCell(cx /= (float)count, cy /= (float)count)) != null && !(nearest.elevation >= sea)) continue;
                    cands.add(new Cand(new PVector(cx, cy), 1.0f));
                }
            }
            if (this.paths != null) {
                HashMap<String, Integer> deg = new HashMap<String, Integer>();
                for (Path path : this.paths) {
                    if (path == null || path.routes == null) continue;
                    for (ArrayList<PVector> seg : path.routes) {
                        if (seg == null || seg.size() < 2) continue;
                        int i = 0;
                        while (i < seg.size()) {
                            PVector v = seg.get(i);
                            String key = this.keyFor(v.x, v.y);
                            deg.put(key, deg.getOrDefault(key, 0) + 1);
                            ++i;
                        }
                    }
                }
                for (Map.Entry entry : deg.entrySet()) {
                    Cell nearest;
                    PVector v;
                    if ((Integer)entry.getValue() < 3 || (v = this.parseKey((String)entry.getKey())) == null || (nearest = this.nearestCell(v.x, v.y)) != null && !(nearest.elevation >= sea)) continue;
                    cands.add(new Cand(v, 0.8f));
                }
            }
            if (this.cells != null) {
                this.ensureCellNeighborsComputed();
                int ci = 0;
                while (ci < this.cells.size()) {
                    Cell cell = this.cells.get(ci);
                    if (cell != null && cell.vertices != null && !(cell.elevation < sea)) {
                        ArrayList<Integer> nbs;
                        ArrayList<Integer> arrayList = nbs = ci < this.cellNeighbors.size() ? this.cellNeighbors.get(ci) : null;
                        if (nbs != null) {
                            boolean coastal = false;
                            for (int nb : nbs) {
                                Cell b;
                                if (nb < 0 || nb >= this.cells.size() || (b = this.cells.get(nb)) == null || !(b.elevation < sea)) continue;
                                coastal = true;
                                break;
                            }
                            if (coastal) {
                                PVector cen = this.cellCentroid(cell);
                                cands.add(new Cand(cen, 0.6f));
                            }
                        }
                    }
                    ++ci;
                }
            }
            if (cands.isEmpty()) {
                if (this.cells != null && !this.cells.isEmpty()) {
                    int i = 0;
                    while (i < Main.min((int)8, (int)this.cells.size())) {
                        PVector cen;
                        Cell cell = this.cells.get(i * 997 % this.cells.size());
                        if (cell != null && cell.vertices != null && !cell.vertices.isEmpty() && (cen = this.cellCentroid(cell)) != null) {
                            float score = 0.4f;
                            if (cell.elevation >= sea) {
                                score = 0.8f;
                            }
                            cands.add(new Cand(cen, score));
                        }
                        ++i;
                    }
                } else {
                    cands.add(new Cand(new PVector(0.0f, 0.0f), 0.5f));
                }
            }
            float elevMin = sea;
            float f = sea + 0.5f;
            for (Cand c : cands) {
                float e = elevMin;
                Cell nearest = this.nearestCell(c.p.x, c.p.y);
                if (nearest != null) {
                    e = nearest.elevation;
                }
                float elevScore = 1.0f - Main.constrain((float)Main.map((float)e, (float)elevMin, (float)f, (float)0.0f, (float)1.0f), (float)0.0f, (float)1.0f);
                c.score *= 0.4f + 0.6f * elevScore;
            }
            Collections.sort(cands, new Comparator<Cand>(){

                @Override
                public int compare(Cand a, Cand b) {
                    return Float.compare(b.score, a.score);
                }
            });
            int placedTowns = 0;
            ArrayList<Structure> newStructs = new ArrayList<Structure>();
            ArrayList<PVector> townCenters = new ArrayList<PVector>();
            for (Cand c : cands) {
                if (placedTowns >= townCount) break;
                if (this.structuresOverlap(this.structures, c.p.x, c.p.y, townSize, 1.0f, 1.2f) || this.structuresOverlap(newStructs, c.p.x, c.p.y, townSize, 1.0f, 1.2f)) continue;
                Structure main = new Structure(c.p.x, c.p.y);
                main.shape = StructureShape.CIRCLE;
                main.aspect = 1.0f;
                main.size = townSize;
                main.setColor(Main.this.color(255), 1.0f);
                main.strokeWeightPx = 1.5f;
                main.alpha01 = 1.0f;
                main.name = "";
                if (Main.this.useDefaultStructureNames) {
                    main.name = "Town " + (placedTowns + 1);
                }
                newStructs.add(main);
                townCenters.add(new PVector(c.p.x, c.p.y));
                int satellites = (int)Main.this.random(1.0f, 6.0f);
                int i = 0;
                while (i < satellites) {
                    float sy;
                    float ang = Main.this.random((float)Math.PI * 2);
                    float dist = townSize * Main.this.random(0.8f, 1.6f);
                    float sx = c.p.x + Main.cos((float)ang) * dist;
                    if (!this.structuresOverlap(this.structures, sx, sy = c.p.y + Main.sin((float)ang) * dist, townSize * 0.8f, 1.0f, 1.0f) && !this.structuresOverlap(newStructs, sx, sy, townSize * 0.8f, 1.0f, 1.0f)) {
                        Structure sat = new Structure(sx, sy);
                        sat.shape = StructureShape.CIRCLE;
                        sat.aspect = 1.0f;
                        sat.size = townSize * Main.this.random(0.5f, 0.9f);
                        sat.setColor(Main.this.color(255), 1.0f);
                        sat.strokeWeightPx = 1.5f;
                        sat.alpha01 = 1.0f;
                        sat.name = main.name;
                        newStructs.add(sat);
                    }
                    ++i;
                }
                ++placedTowns;
            }
            if (this.paths != null && buildingDensity > 1.0E-4f) {
                float spacing = buildingSize * Main.map((float)(1.0f - buildingDensity), (float)0.0f, (float)1.0f, (float)3.5f, (float)8.0f);
                int pi = 0;
                while (pi < this.paths.size()) {
                    Path p = this.paths.get(pi);
                    if (p != null && p.routes != null) {
                        for (ArrayList<PVector> route : p.routes) {
                            if (route == null || route.size() < 2) continue;
                            int i = 0;
                            while (i < route.size() - 1) {
                                PVector a = route.get(i);
                                PVector b = route.get(i + 1);
                                float dx = b.x - a.x;
                                float dy = b.y - a.y;
                                float segLen = Main.max((float)1.0E-6f, (float)Main.sqrt((float)(dx * dx + dy * dy)));
                                int steps = Main.max((int)1, (int)Main.floor((float)(segLen / spacing)));
                                float nx = -dy / segLen;
                                float ny = dx / segLen;
                                int s = 0;
                                while (s < steps) {
                                    Cell segCell;
                                    float t = ((float)s + 0.5f) / (float)steps;
                                    float px = Main.lerp((float)a.x, (float)b.x, (float)t);
                                    float py = Main.lerp((float)a.y, (float)b.y, (float)t);
                                    boolean nearTown = townCenters.isEmpty();
                                    for (PVector tc : townCenters) {
                                        float dxt = tc.x - px;
                                        float dyt = tc.y - py;
                                        float d2 = dxt * dxt + dyt * dyt;
                                        if (!(d2 < Main.sq((float)(townSize * 4.0f)))) continue;
                                        nearTown = true;
                                        break;
                                    }
                                    if (nearTown && ((segCell = this.nearestCell(px, py)) == null || !(segCell.elevation < sea))) {
                                        float offset = buildingSize * Main.this.random(0.6f, 1.2f);
                                        float sx = px + nx * offset;
                                        float sy = py + ny * offset;
                                        float asp = Main.this.random(0.8f, 1.4f);
                                        Cell offCell = this.nearestCell(sx, sy);
                                        if (!(offCell != null && offCell.elevation < sea || this.structuresOverlap(this.structures, sx, sy, buildingSize, asp, 0.9f) || this.structuresOverlap(newStructs, sx, sy, buildingSize, asp, 0.9f))) {
                                            StructureAttributes at = new StructureAttributes();
                                            at.name = "";
                                            at.size = buildingSize;
                                            at.shape = StructureShape.RECTANGLE;
                                            at.aspectRatio = asp;
                                            at.alignment = StructureSnapMode.NEXT_TO_PATH;
                                            at.hue01 = 0.0f;
                                            at.sat01 = 0.0f;
                                            at.alpha01 = 1.0f;
                                            at.strokeWeightPx = 1.2f;
                                            Structure st = this.computeSnappedStructure(sx, sy, at);
                                            st.setColor(Main.this.color(255), 1.0f);
                                            st.strokeWeightPx = 1.2f;
                                            st.alpha01 = 1.0f;
                                            st.aspect = asp;
                                            st.name = "";
                                            newStructs.add(st);
                                        }
                                    }
                                    ++s;
                                }
                                ++i;
                            }
                        }
                    }
                    ++pi;
                }
            }
            this.structures.addAll(newStructs);
        }

        public void generateArbitraryLabels(float sea) {
            if (this.labels == null) {
                this.labels = new ArrayList();
            }
            int target = (int)Main.this.random(1.0f, 11.0f);
            float baseSize = Main.this.labelSizeDefault();
            float worldW = this.maxX - this.minX;
            float worldH = this.maxY - this.minY;
            float spacing = Main.max((float)worldW, (float)worldH) * 0.01f;
            class LabelCand {
                PVector p;
                float score;
                boolean land;

                LabelCand(PVector p, float s, boolean land) {
                    this.p = p;
                    this.score = s;
                    this.land = land;
                }
            }
            ArrayList<LabelCand> cands = new ArrayList<LabelCand>();
            boolean hasLand = false;
            if (this.cells != null && !this.cells.isEmpty()) {
                for (Cell c : this.cells) {
                    boolean land;
                    PVector cen;
                    if (c == null || c.vertices == null || c.vertices.size() < 3 || (cen = this.cellCentroid(c)) == null) continue;
                    boolean bl = land = c.elevation >= sea;
                    if (land) {
                        hasLand = true;
                    }
                    float elevScore = land ? 1.0f : 0.4f;
                    cands.add(new LabelCand(cen, elevScore, land));
                }
            }
            if (cands.isEmpty()) {
                cands.add(new LabelCand(new PVector((this.minX + this.maxX) * 0.5f, (this.minY + this.maxY) * 0.5f), 1.0f, true));
                cands.add(new LabelCand(new PVector(this.minX + worldW * 0.25f, this.minY + worldH * 0.25f), 0.6f, true));
                cands.add(new LabelCand(new PVector(this.minX + worldW * 0.75f, this.minY + worldH * 0.75f), 0.6f, true));
            }
            Collections.shuffle(cands);
            Collections.sort(cands, new Comparator<LabelCand>(){

                @Override
                public int compare(LabelCand a, LabelCand b) {
                    return Float.compare(b.score, a.score);
                }
            });
            ArrayList<MapLabel> newLabels = new ArrayList<MapLabel>();
            for (LabelCand cand : cands) {
                String name;
                float rad;
                if (newLabels.size() >= target) break;
                if (hasLand && !cand.land || !this.labelSpotFree(cand.p.x, cand.p.y, rad = this.estimateLabelRadius(name = this.randomLabelName(), baseSize) + spacing, this.labels) || !this.labelSpotFree(cand.p.x, cand.p.y, rad, newLabels)) continue;
                MapLabel lbl = new MapLabel(cand.p.x, cand.p.y, name);
                lbl.size = baseSize;
                newLabels.add(lbl);
            }
            int fallbackAttempts = 0;
            while (newLabels.size() < target && newLabels.size() < 3 && fallbackAttempts < 200) {
                String name;
                float rad;
                float py;
                ++fallbackAttempts;
                float px = Main.this.random(this.minX + worldW * 0.25f, this.maxX - worldW * 0.25f);
                if (!this.labelSpotFree(px, py = Main.this.random(this.minY + worldH * 0.25f, this.maxY - worldH * 0.25f), rad = this.estimateLabelRadius(name = this.randomLabelName(), baseSize) + spacing, this.labels) || !this.labelSpotFree(px, py, rad, newLabels)) continue;
                MapLabel lbl = new MapLabel(px, py, name);
                lbl.size = baseSize;
                newLabels.add(lbl);
            }
            this.labels.addAll(newLabels);
        }

        public String randomLabelName() {
            String[] syll = new String[]{"an", "bar", "bel", "cal", "dun", "el", "fal", "gal", "hal", "ir", "jor", "kel", "lor", "mor", "nar", "or", "per", "quil", "ran", "sar", "tor", "ur", "val", "wen", "yor", "zan", "ther", "lin", "mon", "ros", "ith", "del", "mir", "tash", "glen", "fen", "sta", "ver", "dul", "kri", "sha"};
            int parts = 2 + (int)Main.this.random(0.0f, 2.0f);
            StringBuilder sb = new StringBuilder();
            int i = 0;
            while (i < parts) {
                sb.append(syll[(int)Main.this.random(syll.length)]);
                ++i;
            }
            String raw = sb.toString();
            if (raw.length() == 0) {
                return "Label";
            }
            return String.valueOf(raw.substring(0, 1).toUpperCase()) + raw.substring(1).toLowerCase();
        }

        public float estimateLabelRadius(String txt, float size) {
            if (txt == null || txt.length() == 0) {
                return size;
            }
            float len = txt.length();
            return Main.max((float)(size * 0.6f), (float)(size * 0.32f * len));
        }

        public boolean labelSpotFree(float x, float y, float radius, ArrayList<MapLabel> list) {
            if (list == null) {
                return true;
            }
            for (MapLabel l : list) {
                float otherR;
                float minDist;
                float dy;
                float dx;
                if (l == null || l.text == null || !((dx = l.x - x) * dx + (dy = l.y - y) * dy < (minDist = radius + (otherR = this.estimateLabelRadius(l.text, l.size))) * minDist)) continue;
                return false;
            }
            return true;
        }

        class CoastSpatialIndex {
            float ox;
            float oy;
            float dx;
            float dy;
            int cols;
            int rows;
            ArrayList<ArrayList<PVector[]>> bins;
            ArrayList<PVector[]> segments;

            CoastSpatialIndex(float minX, float minY, float maxX, float maxY, ArrayList<PVector[]> segs, int targetBins) {
                this.ox = minX;
                this.oy = minY;
                float w = maxX - minX;
                float h = maxY - minY;
                float cellsPerDim = Main.max((int)4, (int)targetBins);
                this.rows = this.cols = Main.max((int)4, (int)((int)cellsPerDim));
                this.dx = w / (float)this.cols;
                this.dy = h / (float)this.rows;
                this.bins = new ArrayList(this.cols * this.rows);
                int i = 0;
                while (i < this.cols * this.rows) {
                    this.bins.add(new ArrayList());
                    ++i;
                }
                this.segments = segs;
                this.indexSegments();
            }

            public void indexSegments() {
                for (PVector[] seg : this.segments) {
                    PVector a = seg[0];
                    PVector b = seg[1];
                    float minX = Main.min((float)a.x, (float)b.x);
                    float maxX = Main.max((float)a.x, (float)b.x);
                    float minY = Main.min((float)a.y, (float)b.y);
                    float maxY = Main.max((float)a.y, (float)b.y);
                    int ix0 = this.clampBin(Main.floor((float)((minX - this.ox) / this.dx)), this.cols);
                    int ix1 = this.clampBin(Main.floor((float)((maxX - this.ox) / this.dx)), this.cols);
                    int iy0 = this.clampBin(Main.floor((float)((minY - this.oy) / this.dy)), this.rows);
                    int iy1 = this.clampBin(Main.floor((float)((maxY - this.oy) / this.dy)), this.rows);
                    int iy = iy0;
                    while (iy <= iy1) {
                        int ix = ix0;
                        while (ix <= ix1) {
                            this.bin(ix, iy).add(seg);
                            ++ix;
                        }
                        ++iy;
                    }
                }
            }

            public int clampBin(int v, int maxVal) {
                return Main.constrain((int)v, (int)0, (int)(maxVal - 1));
            }

            public ArrayList<PVector[]> bin(int x, int y) {
                return this.bins.get(y * this.cols + x);
            }

            public float nearestDist(float x, float y) {
                int ix = this.clampBin(Main.floor((float)((x - this.ox) / this.dx)), this.cols);
                int iy = this.clampBin(Main.floor((float)((y - this.oy) / this.dy)), this.rows);
                float best = Float.MAX_VALUE;
                int maxRing = Main.max((int)this.cols, (int)this.rows);
                int ring = 0;
                while (ring < maxRing) {
                    int x0 = Main.max((int)0, (int)(ix - ring));
                    int x1 = Main.min((int)(this.cols - 1), (int)(ix + ring));
                    int y0 = Main.max((int)0, (int)(iy - ring));
                    int y1 = Main.min((int)(this.rows - 1), (int)(iy + ring));
                    boolean found = false;
                    int yy = y0;
                    while (yy <= y1) {
                        int xx = x0;
                        while (xx <= x1) {
                            ArrayList<PVector[]> bucket = this.bin(xx, yy);
                            for (PVector[] seg : bucket) {
                                float d = this.pointSegDist(x, y, seg[0], seg[1]);
                                if (!(d < best)) continue;
                                best = d;
                                found = true;
                            }
                            ++xx;
                        }
                        ++yy;
                    }
                    if (found && best < Main.max((float)this.dx, (float)this.dy) * (float)ring) break;
                    ++ring;
                }
                if (best == Float.MAX_VALUE) {
                    for (PVector[] seg : this.segments) {
                        best = Main.min((float)best, (float)this.pointSegDist(x, y, seg[0], seg[1]));
                    }
                }
                return best;
            }

            public float pointSegDist(float px, float py, PVector a, PVector b) {
                float vx = b.x - a.x;
                float wx = px - a.x;
                float vy = b.y - a.y;
                float wy = py - a.y;
                float c1 = vx * wx + vy * wy;
                if (c1 <= 0.0f) {
                    return Main.sqrt((float)(wx * wx + wy * wy));
                }
                float c2 = vx * vx + vy * vy;
                if (c2 <= c1) {
                    float dx = px - b.x;
                    float dy = py - b.y;
                    return Main.sqrt((float)(dx * dx + dy * dy));
                }
                float t = c1 / c2;
                float projX = a.x + t * vx;
                float projY = a.y + t * vy;
                float dx = px - projX;
                float dy = py - projY;
                return Main.sqrt((float)(dx * dx + dy * dy));
            }
        }

        class ContourGrid {
            float[][] v;
            int cols;
            int rows;
            float dx;
            float dy;
            float ox;
            float oy;
            float min;
            float max;

            ContourGrid() {
            }
        }

        class ContourJob {
            ContourJobType type;
            ContourGrid grid;
            CoastSpatialIndex coastIndex;
            float seaLevel;
            int cols;
            int rows;
            int nextRow = 0;
            int cellCountSnapshot = 0;
            boolean done = false;
            boolean failed = false;

            ContourJob(ContourJobType type, int cols, int rows, float seaLevel) {
                this.type = type;
                this.cols = Main.max((int)2, (int)cols);
                this.rows = Main.max((int)2, (int)rows);
                this.seaLevel = seaLevel;
                this.cellCountSnapshot = MapModel.this.cells != null ? MapModel.this.cells.size() : 0;
                this.grid = new ContourGrid();
                this.grid.cols = this.cols;
                this.grid.rows = this.rows;
                this.grid.v = new float[this.grid.rows][this.grid.cols];
                this.grid.ox = MapModel.this.minX;
                this.grid.oy = MapModel.this.minY;
                this.grid.dx = (MapModel.this.maxX - MapModel.this.minX) / (float)(this.grid.cols - 1);
                this.grid.dy = (MapModel.this.maxY - MapModel.this.minY) / (float)(this.grid.rows - 1);
                this.grid.min = Float.MAX_VALUE;
                this.grid.max = -3.4028235E38f;
                if (type == ContourJobType.COAST_DISTANCE) {
                    MapModel.this.ensureCellNeighborsComputed();
                    ArrayList<PVector[]> segs = MapModel.this.collectCoastSegments(seaLevel);
                    if (segs == null || segs.isEmpty()) {
                        this.failed = true;
                        this.done = true;
                        return;
                    }
                    this.coastIndex = new CoastSpatialIndex(MapModel.this.minX, MapModel.this.minY, MapModel.this.maxX, MapModel.this.maxY, segs, 80);
                }
            }

            public boolean matches(ContourJobType t, int c, int r, float sl) {
                return this.type == t && this.cols == Main.max((int)2, (int)c) && this.rows == Main.max((int)2, (int)r) && Main.abs((float)(sl - this.seaLevel)) < 1.0E-6f;
            }

            public float progress() {
                if (this.grid == null || this.grid.rows <= 0) {
                    return 0.0f;
                }
                return Main.constrain((float)((float)this.nextRow / Main.max((float)1.0f, (float)this.grid.rows)), (float)0.0f, (float)1.0f);
            }

            public void step(int maxMillis) {
                if (this.done || this.grid == null) {
                    return;
                }
                long deadline = System.nanoTime() + (long)Main.max((int)1, (int)maxMillis) * 1000000L;
                while (this.nextRow < this.grid.rows && System.nanoTime() < deadline) {
                    float x;
                    int i;
                    float y = this.grid.oy + (float)this.nextRow * this.grid.dy;
                    if (this.type == ContourJobType.COAST_DISTANCE) {
                        if (this.coastIndex == null) {
                            this.failed = true;
                            this.done = true;
                            break;
                        }
                        i = 0;
                        while (i < this.grid.cols) {
                            float val;
                            x = this.grid.ox + (float)i * this.grid.dx;
                            boolean water = MapModel.this.sampleElevationAt(x, y, this.seaLevel) < this.seaLevel;
                            float d = this.coastIndex.nearestDist(x, y);
                            this.grid.v[this.nextRow][i] = val = water ? d : -d;
                            this.grid.min = Main.min((float)this.grid.min, (float)val);
                            this.grid.max = Main.max((float)this.grid.max, (float)val);
                            ++i;
                        }
                    } else {
                        i = 0;
                        while (i < this.grid.cols) {
                            float val;
                            x = this.grid.ox + (float)i * this.grid.dx;
                            this.grid.v[this.nextRow][i] = val = MapModel.this.sampleElevationAt(x, y, this.seaLevel);
                            this.grid.min = Main.min((float)this.grid.min, (float)val);
                            this.grid.max = Main.max((float)this.grid.max, (float)val);
                            ++i;
                        }
                    }
                    ++this.nextRow;
                }
                if (this.nextRow >= this.grid.rows) {
                    this.done = true;
                }
            }
        }

        class MapZone {
            String name;
            int col;
            float hue01 = 0.0f;
            float sat01 = 0.5f;
            float bri01 = 0.9f;
            String comment = "";
            ArrayList<Integer> cells = new ArrayList();

            MapZone(String name, int col) {
                this.name = name;
                float[] hsb = MapModel.this.rgbToHSB(col);
                float[] sb = MapModel.this.zoneBaseSatBri();
                this.hue01 = hsb[0];
                this.sat01 = sb[0];
                this.bri01 = sb[1];
                this.col = Main.this.hsb01ToARGB(this.hue01, this.sat01, this.bri01, 1.0f);
            }

            public void updateColorFromHSB() {
                this.col = Main.this.hsb01ToARGB(this.hue01, 0.78f, 0.9f, 1.0f);
                this.sat01 = 0.78f;
                this.bri01 = 0.9f;
            }
        }

        class NodeDist
        implements Comparable<NodeDist> {
            String k;
            float g;
            float f;

            NodeDist(String k, float g, float f) {
                this.k = k;
                this.g = g;
                this.f = f;
            }

            @Override
            public int compareTo(NodeDist other) {
                return Float.compare(this.f, other.f);
            }
        }

        class SegmentHit {
            PVector a;
            PVector b;
            PVector p;
            int pathIndex = -1;
            int routeIndex = -1;
            int segmentIndex = -1;
            int cellA = -1;
            int cellB = -1;

            SegmentHit() {
            }
        }

        class VoronoiJob {
            MapModel model;
            ArrayList<Site> sites;
            ArrayList<Cell> oldCells;
            ArrayList<Cell> outCells = new ArrayList();
            int idx = 0;
            int n;
            float defaultElev;
            int defaultBiome = 0;
            boolean preserveData;
            HashMap<Long, ArrayList<Integer>> bins = new HashMap();
            float binSize;
            float invBin;

            VoronoiJob(MapModel model, ArrayList<Site> sites, ArrayList<Cell> oldCells, float defaultElev, boolean preserveData) {
                this.model = model;
                this.sites = new ArrayList<Site>(sites);
                this.oldCells = oldCells != null ? oldCells : new ArrayList();
                this.n = this.sites.size();
                this.defaultElev = defaultElev;
                this.preserveData = preserveData;
                float area = (model.maxX - model.minX) * (model.maxY - model.minY);
                float avgSpacing = Main.sqrt((float)Main.max((float)1.0E-6f, (float)(area / (float)Main.max((int)1, (int)this.n))));
                this.binSize = Main.max((float)0.001f, (float)(avgSpacing * 1.5f));
                this.invBin = 1.0f / this.binSize;
                this.buildBins();
            }

            public void step(int maxSites, int maxMillis) {
                if (this.idx >= this.n) {
                    return;
                }
                int processed = 0;
                long end = Main.this.millis() + Main.max((int)0, (int)maxMillis);
                while (this.idx < this.n && processed < maxSites) {
                    if (maxMillis > 0 && (long)Main.this.millis() > end) break;
                    this.buildCell(this.idx);
                    ++this.idx;
                    ++processed;
                }
            }

            public void buildCell(int i) {
                Site si = this.sites.get(i);
                ArrayList<PVector> poly = new ArrayList<PVector>();
                poly.add(new PVector(MapModel.this.minX, MapModel.this.minY));
                poly.add(new PVector(MapModel.this.maxX, MapModel.this.minY));
                poly.add(new PVector(MapModel.this.maxX, MapModel.this.maxY));
                poly.add(new PVector(MapModel.this.minX, MapModel.this.maxY));
                ArrayList<Integer> candidates = this.gatherCandidates(i);
                if (candidates == null || candidates.isEmpty()) {
                    candidates = new ArrayList();
                    int j = 0;
                    while (j < this.n) {
                        if (j != i) {
                            candidates.add(j);
                        }
                        ++j;
                    }
                }
                HashSet<Integer> seen = new HashSet<Integer>();
                for (int idxCandidate : candidates) {
                    if (idxCandidate == i || seen.contains(idxCandidate)) continue;
                    seen.add(idxCandidate);
                    Site sj = this.sites.get(idxCandidate);
                    poly = this.model.clipPolygonWithHalfPlane(poly, si, sj);
                    if (poly.size() < 3) break;
                }
                float maxDist = 0.0f;
                for (PVector v : poly) {
                    float dx = v.x - si.x;
                    float dy = v.y - si.y;
                    maxDist = Main.max((float)maxDist, (float)Main.sqrt((float)(dx * dx + dy * dy)));
                }
                int extraRing = Main.ceil((float)(maxDist * this.invBin)) + 2;
                ArrayList<Integer> extra = this.gatherNeighborsWithinRings(i, extraRing);
                for (int idxCandidate : extra) {
                    if (idxCandidate == i || seen.contains(idxCandidate)) continue;
                    seen.add(idxCandidate);
                    Site sj = this.sites.get(idxCandidate);
                    poly = this.model.clipPolygonWithHalfPlane(poly, si, sj);
                    if (poly.size() < 3) break;
                }
                if (poly.size() < 3) {
                    return;
                }
                float cx = 0.0f;
                float cy = 0.0f;
                int nv = poly.size();
                int k = 0;
                while (k < nv) {
                    PVector v = poly.get(k);
                    cx += v.x;
                    cy += v.y;
                    ++k;
                }
                int biomeId = this.preserveData && !this.oldCells.isEmpty() ? this.model.sampleBiomeFromOldCells(this.oldCells, cx /= (float)nv, cy /= (float)nv, this.defaultBiome) : this.defaultBiome;
                float elev = this.preserveData && !this.oldCells.isEmpty() ? this.model.sampleElevationFromOldCells(this.oldCells, cx, cy, this.defaultElev) : this.defaultElev;
                Cell newCell = new Cell(i, poly, biomeId);
                newCell.elevation = elev;
                this.outCells.add(newCell);
            }

            public boolean isDone() {
                return this.idx >= this.n;
            }

            public float progress() {
                if (this.n <= 0) {
                    return 1.0f;
                }
                return Main.constrain((float)((float)this.idx / (float)this.n), (float)0.0f, (float)1.0f);
            }

            public void buildBins() {
                this.bins.clear();
                int i = 0;
                while (i < this.n) {
                    int gy;
                    Site s = this.sites.get(i);
                    int gx = Main.floor((float)((s.x - MapModel.this.minX) * this.invBin));
                    long key = (long)gx << 32 ^ (long)(gy = Main.floor((float)((s.y - MapModel.this.minY) * this.invBin))) & 0xFFFFFFFFL;
                    ArrayList<Integer> bucket = this.bins.get(key);
                    if (bucket == null) {
                        bucket = new ArrayList();
                        this.bins.put(key, bucket);
                    }
                    bucket.add(i);
                    ++i;
                }
            }

            public ArrayList<Integer> gatherCandidates(int i) {
                ArrayList<Integer> out = new ArrayList<Integer>();
                Site s = this.sites.get(i);
                int gx = Main.floor((float)((s.x - MapModel.this.minX) * this.invBin));
                int gy = Main.floor((float)((s.y - MapModel.this.minY) * this.invBin));
                int needed = 48;
                int maxRing = 8;
                int ring = 0;
                while (ring <= maxRing && out.size() < needed) {
                    int dx = -ring;
                    while (dx <= ring) {
                        int dy = -ring;
                        while (dy <= ring) {
                            long key;
                            ArrayList<Integer> bucket;
                            if ((Main.abs((int)dx) == ring || Main.abs((int)dy) == ring) && (bucket = this.bins.get(key = (long)(gx + dx) << 32 ^ (long)(gy + dy) & 0xFFFFFFFFL)) != null) {
                                for (int idxSite : bucket) {
                                    if (idxSite == i) continue;
                                    out.add(idxSite);
                                    if (out.size() >= needed) break;
                                }
                                if (out.size() >= needed) break;
                            }
                            ++dy;
                        }
                        if (out.size() >= needed) break;
                        ++dx;
                    }
                    ++ring;
                }
                return out;
            }

            public ArrayList<Integer> gatherNeighborsWithinRings(int i, int ringRadius) {
                ArrayList<Integer> out = new ArrayList<Integer>();
                Site s = this.sites.get(i);
                int gx = Main.floor((float)((s.x - MapModel.this.minX) * this.invBin));
                int gy = Main.floor((float)((s.y - MapModel.this.minY) * this.invBin));
                int rMax = Main.max((int)0, (int)Main.min((int)ringRadius, (int)20));
                int ring = 0;
                while (ring <= rMax) {
                    int dx = -ring;
                    while (dx <= ring) {
                        int dy = -ring;
                        while (dy <= ring) {
                            long key;
                            ArrayList<Integer> bucket;
                            if ((Main.abs((int)dx) == ring || Main.abs((int)dy) == ring) && (bucket = this.bins.get(key = (long)(gx + dx) << 32 ^ (long)(gy + dy) & 0xFFFFFFFFL)) != null) {
                                for (int idxSite : bucket) {
                                    if (idxSite == i) continue;
                                    out.add(idxSite);
                                }
                            }
                            ++dy;
                        }
                        ++dx;
                    }
                    ++ring;
                }
                return out;
            }
        }
    }

    class MapRenderer {
        private final MapModel model;
        private final LabelRenderer labelRenderer;
        private ArrayList<PVector[]> cachedBiomeOutlineEdges = new ArrayList();
        private ArrayList<Integer> cachedBiomeOutlineBiomes = new ArrayList();
        private ArrayList<Boolean> cachedBiomeOutlineUnderwater = new ArrayList();
        private int cachedBiomeOutlineCellCount = -1;
        private int cachedBiomeOutlineChecksum = 0;
        private float cachedBiomeOutlineSeaLevel = Float.MAX_VALUE;
        private boolean drawRoundCaps = true;
        private PGraphics coastLayer;
        private int coastLayerHash = 0;
        private float coastLayerZoom = -1.0f;
        private float coastLayerCenterX = Float.MAX_VALUE;
        private float coastLayerCenterY = Float.MAX_VALUE;
        private int coastLayerW = -1;
        private int coastLayerH = -1;
        private float coastLayerSeaLevel = Float.MAX_VALUE;
        private int coastLayerCellCount = -1;
        private PGraphics zoneLayer;
        private int zoneLayerHash = 0;
        private float zoneLayerZoom = -1.0f;
        private float zoneLayerCenterX = Float.MAX_VALUE;
        private float zoneLayerCenterY = Float.MAX_VALUE;
        private int zoneLayerW = -1;
        private int zoneLayerH = -1;
        private int zoneLayerCellCount = -1;
        private int zoneLayerZoneCount = -1;
        private PGraphics biomeLandLayer;
        private PGraphics biomeWaterLayer;
        private int biomeLayerHash = 0;
        private float biomeLayerZoom = -1.0f;
        private float biomeLayerCenterX = Float.MAX_VALUE;
        private float biomeLayerCenterY = Float.MAX_VALUE;
        private int biomeLayerW = -1;
        private int biomeLayerH = -1;
        private int biomeLayerCellCount = -1;
        private int biomeLayerBiomeCount = -1;
        private PGraphics biomeOutlineLayerLand;
        private PGraphics biomeOutlineLayerWater;
        private int biomeOutlineHash = 0;
        private float biomeOutlineZoom = -1.0f;
        private float biomeOutlineCenterX = Float.MAX_VALUE;
        private float biomeOutlineCenterY = Float.MAX_VALUE;
        private int biomeOutlineW = -1;
        private int biomeOutlineH = -1;
        private int biomeOutlineCellCount = -1;
        private float biomeOutlineSeaLevel = Float.MAX_VALUE;
        private PGraphics cellBorderLayer;
        private int cellBorderHash = 0;
        private float cellBorderZoom = -1.0f;
        private float cellBorderCenterX = Float.MAX_VALUE;
        private float cellBorderCenterY = Float.MAX_VALUE;
        private int cellBorderW = -1;
        private int cellBorderH = -1;
        private int cellBorderCellCount = -1;
        private PGraphics elevationLightLayer;
        private int elevationLightHashVal = 0;
        private float elevationLightZoom = -1.0f;
        private float elevationLightCenterX = Float.MAX_VALUE;
        private float elevationLightCenterY = Float.MAX_VALUE;
        private int elevationLightW = -1;
        private int elevationLightH = -1;
        private float elevationLightSeaLevel = Float.MAX_VALUE;
        private int elevationLightCellCount = -1;
        private PGraphics elevationLineLayer;
        private int elevationLineHash = 0;
        private float elevationLineZoom = -1.0f;
        private float elevationLineCenterX = Float.MAX_VALUE;
        private float elevationLineCenterY = Float.MAX_VALUE;
        private int elevationLineW = -1;
        private int elevationLineH = -1;
        private float elevationLineSeaLevel = Float.MAX_VALUE;
        private int elevationLineCellCount = -1;
        private PGraphics waterDetailLayer;
        private int waterDetailLayerHash = 0;
        private float waterDetailLayerZoom = -1.0f;
        private float waterDetailLayerCenterX = Float.MAX_VALUE;
        private float waterDetailLayerCenterY = Float.MAX_VALUE;
        private int waterDetailLayerW = -1;
        private int waterDetailLayerH = -1;
        private float waterDetailLayerSeaLevel = Float.MAX_VALUE;
        private int waterDetailLayerCellCount = -1;
        private PImage noiseTex;
        private final int NOISE_TEX_SIZE = 1024;
        private final float[] hsbScratch = new float[3];
        boolean coastDirty = true;
        boolean biomeDirty = true;
        boolean zoneDirty = true;
        boolean lightDirty = true;
        boolean biomeOutlineDirty = true;
        boolean waterDetailDirty = true;
        boolean cellBorderDirty = true;
        boolean elevationLineDirty = true;
        boolean fontPrepNeeded = true;
        private int renderPrepCompleted = 0;
        private int renderPrepTotal = 0;
        private HashMap<String, PImage> patternCache = new HashMap();
        private int[] cachedBiomeScaledColors = null;
        private int[] cachedBiomeSrcCols = null;
        private float cachedBiomeSatScale = -1.0f;
        private float cachedBiomeBriScale = -1.0f;
        private int[] cachedZoneStrokeColors = null;
        private int[] cachedZoneSrcCols = null;
        private float cachedZoneSatScale = -1.0f;
        private float cachedZoneBriScale = -1.0f;
        private static final int STAGE_FONTS = 0;
        private static final int STAGE_COAST = 1;
        private static final int STAGE_BIOMES = 2;
        private static final int STAGE_ZONES = 3;
        private static final int STAGE_LIGHT = 4;

        static {
            $SWITCH_TABLE$Main$StructureShape = MapRenderer.$SWITCH_TABLE$Main$StructureShape();
        }

        public float strokeWorldPx(float basePx, boolean scaleWithZoom, float refZoom) {
            float b = Main.max((float)0.01f, (float)basePx);
            if (scaleWithZoom) {
                float ref = Main.max((float)1.0E-6f, (float)refZoom);
                b *= Main.this.viewport.zoom / ref;
            }
            return b / Main.max((float)1.0E-6f, (float)Main.this.viewport.zoom);
        }

        private PVector lineIntersection(PVector p1, PVector p2, PVector p3, PVector p4) {
            float y4 = p4.y;
            float y3 = p3.y;
            float x2 = p2.x;
            float x1 = p1.x;
            float x4 = p4.x;
            float x3 = p3.x;
            float y2 = p2.y;
            float y1 = p1.y;
            float denom = (y4 - y3) * (x2 - x1) - (x4 - x3) * (y2 - y1);
            if (Main.abs((float)denom) < 1.0E-6f) {
                return null;
            }
            float ua = ((x4 - x3) * (y1 - y3) - (y4 - y3) * (x1 - x3)) / denom;
            float ix = x1 + ua * (x2 - x1);
            float iy = y1 + ua * (y2 - y1);
            return new PVector(ix, iy);
        }

        public void invalidateCoastCache() {
            this.coastDirty = true;
            this.waterDetailDirty = true;
        }

        public void invalidateWaterDetailLayer() {
            this.waterDetailDirty = true;
        }

        public void invalidateBiomeCache() {
            this.biomeDirty = true;
            this.biomeOutlineDirty = true;
        }

        public void invalidateBiomeOutlineLayer() {
            this.biomeOutlineDirty = true;
        }

        public void invalidateZoneCache() {
            this.zoneDirty = true;
        }

        public void invalidateLightCache() {
            this.lightDirty = true;
        }

        public void invalidateCellBorderLayer() {
            this.cellBorderDirty = true;
        }

        public void invalidateElevationLineLayer() {
            this.elevationLineDirty = true;
        }

        MapRenderer(MapModel model) {
            this.model = model;
            this.labelRenderer = new LabelRenderer(model);
        }

        public PGraphics getCoastLayer() {
            return this.coastLayer;
        }

        public void drawDebugWorldBounds(PApplet app) {
            app.pushStyle();
            app.noFill();
            app.stroke(0);
            app.strokeWeight(1.5f / Main.this.viewport.zoom);
            app.rect(this.model.minX, this.model.minY, this.model.maxX - this.model.minX, this.model.maxY - this.model.minY);
            app.popStyle();
        }

        public void drawSites(PApplet app) {
            if (this.model.sites == null) {
                return;
            }
            for (Site s : this.model.sites) {
                s.draw(app);
            }
        }

        public void drawCells(PApplet app) {
            this.drawCells(app, true);
        }

        public void drawCells(PApplet app, boolean showBorders) {
            if (this.model.cells == null) {
                return;
            }
            for (Cell c : this.model.cells) {
                c.draw(app, showBorders);
            }
        }

        public void drawCellsRender(PApplet app, boolean showBorders) {
            this.drawCellsRender(app, showBorders, false);
        }

        public void drawCellsRender(PApplet app, boolean showBorders, boolean desaturate) {
            if (this.model.cells == null) {
                return;
            }
            app.pushStyle();
            float biomeAlphaScale = Main.this.currentTool == Tool.EDIT_ELEVATION ? 0.8f : 1.0f;
            float[][] biomeHSB = null;
            if (desaturate && this.model.biomeTypes != null && !this.model.biomeTypes.isEmpty()) {
                int nb = this.model.biomeTypes.size();
                biomeHSB = new float[nb][3];
                int i = 0;
                while (i < nb) {
                    ZoneType zt = this.model.biomeTypes.get(i);
                    if (zt != null) {
                        Main.this.rgbToHSB01(zt.col, biomeHSB[i]);
                    }
                    ++i;
                }
            }
            for (Cell c : this.model.cells) {
                if (c.vertices == null || c.vertices.size() < 3) continue;
                int col = Main.this.color(230);
                if (this.model.biomeTypes != null && c.biomeId >= 0 && c.biomeId < this.model.biomeTypes.size()) {
                    ZoneType zt = this.model.biomeTypes.get(c.biomeId);
                    col = zt.col;
                }
                if (c.elevation < Main.this.seaLevel) {
                    col = Main.this.lerpColor(col, Main.this.color(30, 70, 120), 0.15f);
                }
                if (desaturate) {
                    float[] hsb;
                    if (biomeHSB != null && c.biomeId >= 0 && c.biomeId < biomeHSB.length && biomeHSB[c.biomeId] != null) {
                        hsb = biomeHSB[c.biomeId];
                    } else {
                        hsb = this.hsbScratch;
                        Main.this.rgbToHSB01(col, hsb);
                    }
                    float sat = Main.constrain((float)(hsb[1] * 0.82f), (float)0.0f, (float)1.0f);
                    float bri = Main.constrain((float)(hsb[2] * 1.05f), (float)0.0f, (float)1.0f);
                    col = Main.this.hsb01ToARGB(hsb[0], sat, bri, 1.0f);
                }
                app.fill(col, 255.0f * biomeAlphaScale);
                if (showBorders) {
                    app.stroke(180);
                    app.strokeWeight(1.0f / Main.this.viewport.zoom);
                } else {
                    app.stroke(col);
                    app.strokeWeight(0.35f / Main.this.viewport.zoom);
                }
                app.beginShape();
                for (PVector v : c.vertices) {
                    app.vertex(v.x, v.y);
                }
                app.endShape(2);
            }
            app.popStyle();
        }

        public void drawStructures(PApplet app) {
            if (this.model.structures == null) {
                return;
            }
            app.pushStyle();
            int i = 0;
            while (i < this.model.structures.size()) {
                Structure s = this.model.structures.get(i);
                s.draw(app);
                if (Main.this.isStructureSelected(i)) {
                    app.pushStyle();
                    app.noFill();
                    app.stroke(255.0f, 180.0f, 0.0f, 200.0f);
                    app.strokeWeight(3.0f / Main.this.viewport.zoom);
                    app.rectMode(3);
                    float pad = s.size * 0.15f;
                    app.pushMatrix();
                    app.translate(s.x, s.y);
                    app.rotate(s.angle);
                    float w = s.size;
                    float h = s.shape == StructureShape.RECTANGLE && s.aspect != 0.0f ? s.size / Main.max((float)0.1f, (float)s.aspect) : s.size;
                    switch (s.shape) {
                        case RECTANGLE: {
                            app.rect(0.0f, 0.0f, w + pad * 2.0f, h + pad * 2.0f);
                            break;
                        }
                        case CIRCLE: {
                            float eh = s.size / Main.max((float)0.1f, (float)s.aspect);
                            app.ellipse(0.0f, 0.0f, w + pad * 2.0f, eh + pad * 2.0f);
                            break;
                        }
                        case TRIANGLE: 
                        case HEXAGON: {
                            app.scale(1.05f);
                            s.draw(app);
                            break;
                        }
                        default: {
                            app.rect(0.0f, 0.0f, w + pad * 2.0f, w + pad * 2.0f);
                        }
                    }
                    app.popMatrix();
                    app.popStyle();
                }
                ++i;
            }
            app.popStyle();
        }

        public void drawStructuresRender(PApplet app, RenderSettings s) {
            if (this.model.structures == null || s == null) {
                return;
            }
            app.pushStyle();
            float az = Main.radians((float)s.elevationLightAzimuthDeg);
            float altRad = Main.radians((float)s.elevationLightAltitudeDeg);
            PVector shadowDir = new PVector(-Main.cos((float)az), -Main.sin((float)az));
            float tanAlt = Main.max((float)0.1f, (float)Main.tan((float)altRad));
            float shadowLenFactor = Main.constrain((float)(0.1f / tanAlt), (float)0.01f, (float)0.5f);
            int i = 0;
            while (i < this.model.structures.size()) {
                float baseAlpha;
                Structure st = this.model.structures.get(i);
                if (st != null && !((baseAlpha = st.alpha01 * s.structureAlphaScale01) <= 1.0E-4f)) {
                    Main.this.rgbToHSB01(st.fillCol, this.hsbScratch);
                    float sat = Main.constrain((float)(this.hsbScratch[1] * s.structureSatScale01), (float)0.0f, (float)1.0f);
                    int col = Main.this.hsb01ToARGB(this.hsbScratch[0], sat, this.hsbScratch[2], 1.0f);
                    float shadowAlpha = baseAlpha * s.structureShadowAlpha01;
                    float shadowLen = st.size * shadowLenFactor;
                    if (s.structureStrokeScaleWithZoom) {
                        float ref = s.structureStrokeRefZoom > 1.0E-6f ? s.structureStrokeRefZoom : 600.0f;
                        shadowLen *= Main.max((float)1.0E-6f, (float)Main.this.viewport.zoom) / ref;
                    }
                    if (shadowAlpha > 1.0E-4f && shadowLen > 1.0E-6f) {
                        PVector off = PVector.mult((PVector)shadowDir, (float)shadowLen);
                        app.pushMatrix();
                        app.translate(st.x + off.x, st.y + off.y);
                        app.rotate(st.angle);
                        app.noStroke();
                        app.fill(0.0f, 0.0f, 0.0f, shadowAlpha * 255.0f);
                        this.drawStructureShape(app, st);
                        app.popMatrix();
                    }
                    app.pushMatrix();
                    app.translate(st.x, st.y);
                    app.rotate(st.angle);
                    app.stroke(0.0f, 0.0f, 0.0f, baseAlpha * 255.0f);
                    float stW = this.strokeWorldPx(Main.max((float)0.1f, (float)st.strokeWeightPx), s.structureStrokeScaleWithZoom, s.structureStrokeRefZoom);
                    app.strokeWeight(stW);
                    app.fill(col, baseAlpha * 255.0f);
                    this.drawStructureShape(app, st);
                    app.popMatrix();
                }
                ++i;
            }
            app.popStyle();
        }

        private void drawStructureShape(PApplet app, Structure st) {
            if (st == null) {
                return;
            }
            float r = st.size;
            float aspect = Main.max((float)0.1f, (float)st.aspect);
            switch (st.shape) {
                case RECTANGLE: {
                    float w = r;
                    float h = r / aspect;
                    app.rectMode(3);
                    app.rect(0.0f, 0.0f, w, h);
                    break;
                }
                case CIRCLE: {
                    float w = r;
                    float h = r / aspect;
                    app.ellipse(0.0f, 0.0f, w, h);
                    break;
                }
                case TRIANGLE: {
                    float h = r / Main.max((float)0.001f, (float)Main.sqrt((float)aspect)) * 0.866f;
                    app.beginShape();
                    app.vertex(-r * 0.5f, h * 0.333f);
                    app.vertex(r * 0.5f, h * 0.333f);
                    app.vertex(0.0f, -h * 0.666f);
                    app.endShape(2);
                    break;
                }
                case HEXAGON: {
                    float rad = r * 0.5f;
                    float sx = 1.0f;
                    float sy = 1.0f / Main.max((float)0.001f, (float)Main.sqrt((float)aspect));
                    app.beginShape();
                    int v = 0;
                    while (v < 6) {
                        float a = Main.radians((float)(60 * v));
                        app.vertex(Main.cos((float)a) * rad * sx, Main.sin((float)a) * rad * sy);
                        ++v;
                    }
                    app.endShape(2);
                    break;
                }
                default: {
                    float sHalf = r * 0.5f;
                    app.rectMode(3);
                    app.rect(0.0f, 0.0f, sHalf * 2.0f, sHalf * 2.0f / aspect);
                }
            }
        }

        public void drawLabels(PApplet app) {
            this.labelRenderer.drawLabels(app);
        }

        public void drawLabelsRender(PApplet app, RenderSettings s) {
            this.labelRenderer.drawLabelsRender(app, s);
        }

        public void drawZoneLabelsRender(PApplet app, RenderSettings s) {
            this.labelRenderer.drawZoneLabelsRender(app, s);
        }

        public void drawPathLabelsRender(PApplet app, RenderSettings s) {
            this.labelRenderer.drawPathLabelsRender(app, s);
        }

        public void drawStructureLabelsRender(PApplet app, RenderSettings s) {
            this.labelRenderer.drawStructureLabelsRender(app, s);
        }

        public PGraphics buildLabelLayer(PApplet app, RenderSettings s) {
            return this.labelRenderer.buildLabelLayer(app, s);
        }

        public void warmLabelFonts(PApplet app, RenderSettings s) {
            this.labelRenderer.warmLabelFonts(app, s);
        }

        public void drawZoneOutlines(PApplet app) {
            if (this.model.cells == null || this.model.zones == null) {
                return;
            }
            this.model.ensureCellNeighborsComputed();
            int n = this.model.cells.size();
            if (n == 0 || this.model.zones.isEmpty()) {
                return;
            }
            ArrayList zoneForCell = new ArrayList(n);
            int i = 0;
            while (i < n) {
                zoneForCell.add(new ArrayList());
                ++i;
            }
            int zi = 0;
            while (zi < this.model.zones.size()) {
                MapModel.MapZone z = this.model.zones.get(zi);
                if (z != null && z.cells != null) {
                    for (int ci : z.cells) {
                        ArrayList list;
                        if (ci < 0 || ci >= n || (list = (ArrayList)zoneForCell.get(ci)).contains(zi)) continue;
                        list.add(zi);
                    }
                }
                ++zi;
            }
            float eps2 = 1.0E-6f;
            float baseW = 2.0f / Main.this.viewport.zoom;
            float laneGap = baseW * 0.6f;
            HashSet<String> drawn = new HashSet<String>();
            app.pushStyle();
            app.noFill();
            int ci = 0;
            while (ci < n) {
                ArrayList zonesA;
                Cell c = this.model.cells.get(ci);
                if (c != null && c.vertices != null && c.vertices.size() >= 3 && (zonesA = (ArrayList)zoneForCell.get(ci)) != null && !zonesA.isEmpty()) {
                    int vc = c.vertices.size();
                    int e = 0;
                    while (e < vc) {
                        PVector b;
                        PVector a = c.vertices.get(e);
                        String key = this.undirectedEdgeKey(a, b = c.vertices.get((e + 1) % vc));
                        if (!drawn.contains(key)) {
                            ArrayList<Integer> nbs;
                            ArrayList zonesB = null;
                            ArrayList<Integer> arrayList = nbs = ci < this.model.cellNeighbors.size() ? this.model.cellNeighbors.get(ci) : null;
                            if (nbs != null) {
                                for (int nbIdx : nbs) {
                                    Cell nb;
                                    if (nbIdx < 0 || nbIdx >= n || (nb = this.model.cells.get(nbIdx)) == null || nb.vertices == null) continue;
                                    int nv = nb.vertices.size();
                                    boolean matched = false;
                                    int j = 0;
                                    while (j < nv) {
                                        boolean matchRev;
                                        PVector na = nb.vertices.get(j);
                                        PVector nbp = nb.vertices.get((j + 1) % nv);
                                        boolean match = this.model.distSq(a, na) < eps2 && this.model.distSq(b, nbp) < eps2;
                                        boolean bl = matchRev = this.model.distSq(a, nbp) < eps2 && this.model.distSq(b, na) < eps2;
                                        if (match || matchRev) {
                                            zonesB = (ArrayList)zoneForCell.get(nbIdx);
                                            matched = true;
                                            break;
                                        }
                                        ++j;
                                    }
                                    if (matched) break;
                                }
                            }
                            HashSet setA = new HashSet(zonesA);
                            HashSet setB = zonesB != null ? new HashSet(zonesB) : new HashSet();
                            HashSet uniqueA = new HashSet(setA);
                            uniqueA.removeAll(setB);
                            HashSet uniqueB = new HashSet(setB);
                            uniqueB.removeAll(setA);
                            if (uniqueA.isEmpty() && uniqueB.isEmpty()) {
                                drawn.add(key);
                            } else {
                                PVector toCenter;
                                PVector cenA = this.model.cellCentroid(c);
                                PVector mid = new PVector((a.x + b.x) * 0.5f, (a.y + b.y) * 0.5f);
                                PVector edgeDir = new PVector(b.x - a.x, b.y - a.y);
                                PVector nrm = new PVector(-edgeDir.y, edgeDir.x);
                                float nLen = Main.max((float)1.0E-6f, (float)Main.sqrt((float)(nrm.x * nrm.x + nrm.y * nrm.y)));
                                nrm.mult(1.0f / nLen);
                                if (cenA != null && (toCenter = PVector.sub((PVector)cenA, (PVector)mid)).dot(nrm) < 0.0f) {
                                    nrm.mult(-1.0f);
                                }
                                ArrayList listA = new ArrayList(uniqueA);
                                ArrayList listB = new ArrayList(uniqueB);
                                Collections.sort(listA);
                                Collections.sort(listB);
                                float offsetA = 0.0f;
                                Iterator iterator = listA.iterator();
                                while (iterator.hasNext()) {
                                    int zId = (Integer)iterator.next();
                                    if (zId < 0 || zId >= this.model.zones.size()) continue;
                                    float w = baseW;
                                    float lane = offsetA + w * 0.5f;
                                    app.stroke(this.model.zones.get((int)zId).col, 255.0f);
                                    app.strokeWeight(w);
                                    app.line(a.x + nrm.x * lane, a.y + nrm.y * lane, b.x + nrm.x * lane, b.y + nrm.y * lane);
                                    offsetA += w + laneGap;
                                }
                                float offsetB = 0.0f;
                                Iterator iterator2 = listB.iterator();
                                while (iterator2.hasNext()) {
                                    int zId = (Integer)iterator2.next();
                                    if (zId < 0 || zId >= this.model.zones.size()) continue;
                                    float w = baseW;
                                    float lane = offsetB + w * 0.5f;
                                    app.stroke(this.model.zones.get((int)zId).col, 255.0f);
                                    app.strokeWeight(w);
                                    app.line(a.x - nrm.x * lane, a.y - nrm.y * lane, b.x - nrm.x * lane, b.y - nrm.y * lane);
                                    offsetB += w + laneGap;
                                }
                                drawn.add(key);
                            }
                        }
                        ++e;
                    }
                }
                ++ci;
            }
            app.popStyle();
        }

        public void drawStructureSnapGuides(PApplet app, boolean useWater, boolean useBiomes, boolean useUnderwaterBiomes, boolean useZones, boolean usePaths, boolean useStructures, boolean useElevation, int[] zoneMembership, int[] elevBuckets) {
            Cell b;
            if (this.model.cells == null || this.model.cells.isEmpty()) {
                return;
            }
            this.model.ensureCellNeighborsComputed();
            app.pushStyle();
            int strokeCol = app.color(60, 120, 220, 190);
            app.stroke(strokeCol);
            app.strokeWeight(2.0f / Main.this.viewport.zoom);
            app.noFill();
            if (useWater || useBiomes || useUnderwaterBiomes || useZones || useElevation) {
                int n = this.model.cells.size();
                int i = 0;
                while (i < n) {
                    Cell cell = this.model.cells.get(i);
                    ArrayList<Integer> nbs = this.model.cellNeighbors.get(i);
                    if (nbs != null) {
                        for (int nb : nbs) {
                            if (nb <= i || !this.model.boundaryActiveForSnapping(cell, b = this.model.cells.get(nb), i, nb, zoneMembership, elevBuckets, useWater, useBiomes, useUnderwaterBiomes, useZones, useElevation)) continue;
                            ArrayList<PVector> va = cell.vertices;
                            ArrayList<PVector> vb = b.vertices;
                            if (va == null || vb == null || va.size() < 2 || vb.size() < 2) continue;
                            HashSet<String> edgesA = new HashSet<String>();
                            int ac = va.size();
                            int ai = 0;
                            while (ai < ac) {
                                PVector a0 = va.get(ai);
                                PVector a1 = va.get((ai + 1) % ac);
                                edgesA.add(this.undirectedEdgeKey(a0, a1));
                                ++ai;
                            }
                            int bc = vb.size();
                            int bi = 0;
                            while (bi < bc) {
                                PVector b1;
                                PVector b0 = vb.get(bi);
                                String key = this.undirectedEdgeKey(b0, b1 = vb.get((bi + 1) % bc));
                                if (edgesA.contains(key)) {
                                    app.line(b0.x, b0.y, b1.x, b1.y);
                                    edgesA.remove(key);
                                }
                                ++bi;
                            }
                        }
                    }
                    ++i;
                }
            }
            if (usePaths && this.model.paths != null) {
                app.stroke(strokeCol);
                app.strokeWeight(1.0f / Main.this.viewport.zoom);
                for (Path p : this.model.paths) {
                    if (p == null || p.routes == null) continue;
                    for (ArrayList arrayList : p.routes) {
                        if (arrayList == null || arrayList.size() < 2) continue;
                        int i = 0;
                        while (i < arrayList.size() - 1) {
                            PVector a = (PVector)arrayList.get(i);
                            b = (PVector)arrayList.get(i + 1);
                            app.line(a.x, a.y, ((PVector)b).x, ((PVector)b).y);
                            ++i;
                        }
                    }
                }
            }
            if (useStructures && this.model.structures != null && !this.model.structures.isEmpty()) {
                app.stroke(strokeCol);
                app.strokeWeight(1.1f / Main.this.viewport.zoom);
                app.noFill();
                for (Structure s : this.model.structures) {
                    app.pushMatrix();
                    app.translate(s.x, s.y);
                    app.rotate(s.angle);
                    float f = s.size;
                    switch (s.shape) {
                        case RECTANGLE: {
                            float w = f;
                            float h = s.aspect != 0.0f ? f / Main.max((float)0.1f, (float)s.aspect) : f;
                            app.rectMode(3);
                            app.rect(0.0f, 0.0f, w, h);
                            break;
                        }
                        case CIRCLE: {
                            app.ellipse(0.0f, 0.0f, f, f);
                            break;
                        }
                        case TRIANGLE: {
                            float h = f * 0.866f;
                            app.beginShape();
                            app.vertex(-f * 0.5f, h * 0.333f);
                            app.vertex(f * 0.5f, h * 0.333f);
                            app.vertex(0.0f, -h * 0.666f);
                            app.endShape(2);
                            break;
                        }
                        case HEXAGON: {
                            float rad = f * 0.5f;
                            app.beginShape();
                            int i = 0;
                            while (i < 6) {
                                float a = Main.radians((float)(60 * i));
                                app.vertex(Main.cos((float)a) * rad, Main.sin((float)a) * rad);
                                ++i;
                            }
                            app.endShape(2);
                            break;
                        }
                        default: {
                            float sHalf = f * 0.5f;
                            app.rectMode(3);
                            app.rect(0.0f, 0.0f, sHalf * 2.0f, sHalf * 2.0f);
                        }
                    }
                    app.popMatrix();
                }
            }
            app.popStyle();
        }

        public void drawRenderAdvanced(PApplet app, RenderSettings s, float seaLevel) {
            boolean drawHatching;
            boolean wantCoast;
            PImage ntex;
            if (this.model == null || this.model.cells == null) {
                return;
            }
            app.pushStyle();
            if (s.antialiasing) {
                app.smooth();
            }
            int landBase = this.hsbColor(s.landHue01, s.landSat01, s.landBri01, 1.0f);
            int waterBase = this.hsbColor(s.waterHue01, s.waterSat01, s.waterBri01, 1.0f);
            int[] biomeScaledCols = this.buildBiomeScaledColors(s);
            HashMap<String, PImage> framePatternCache = new HashMap<String, PImage>();
            app.noStroke();
            app.fill(waterBase);
            app.rect(this.model.minX, this.model.minY, this.model.maxX - this.model.minX, this.model.maxY - this.model.minY);
            for (Cell c : this.model.cells) {
                if (c == null || c.vertices == null || c.vertices.size() < 3 || c.elevation < seaLevel) continue;
                app.fill(landBase);
                this.drawPoly(app, c.vertices);
            }
            if (s.backgroundNoiseAlpha01 > 1.0E-4f && (ntex = this.getNoiseTexture(app)) != null) {
                float a = s.backgroundNoiseAlpha01;
                app.pushStyle();
                app.textureMode(1);
                app.textureWrap(1);
                for (Cell c : this.model.cells) {
                    if (c == null || c.vertices == null || c.vertices.size() < 3 || c.elevation < seaLevel) continue;
                    this.drawPatternPoly(app, c.vertices, ntex, landBase, a);
                }
                for (Cell c : this.model.cells) {
                    if (c == null || c.vertices == null || c.vertices.size() < 3 || c.elevation >= seaLevel) continue;
                    this.drawPatternPoly(app, c.vertices, ntex, waterBase, a);
                }
                app.popStyle();
            }
            if (s.biomeFillAlpha01 > 1.0E-4f || s.biomeUnderwaterAlpha01 > 1.0E-4f) {
                app.noStroke();
                boolean usePattern = s.biomeFillType == RenderFillType.RENDER_FILL_PATTERN || s.biomeFillType == RenderFillType.RENDER_FILL_PATTERN_BG;
                Object fallbackPatternName = "";
                PImage fallbackPattern = null;
                PImage[] biomePatterns = null;
                if (usePattern) {
                    Object object = fallbackPatternName = s.biomePatternName != null && s.biomePatternName.length() > 0 ? s.biomePatternName : "";
                    if (((String)fallbackPatternName).length() == 0 && this.model.biomePatternFiles != null && !this.model.biomePatternFiles.isEmpty()) {
                        fallbackPatternName = this.model.biomePatternFiles.get(0);
                    }
                    if (((String)fallbackPatternName).length() > 0) {
                        fallbackPattern = this.cachedPattern(framePatternCache, app, (String)fallbackPatternName);
                    }
                    if (this.model.biomeTypes != null && !this.model.biomeTypes.isEmpty()) {
                        int typeCount = this.model.biomeTypes.size();
                        biomePatterns = new PImage[typeCount];
                        int bi = 0;
                        while (bi < typeCount) {
                            ZoneType zt = this.model.biomeTypes.get(bi);
                            Object patName = zt != null ? this.model.biomePatternNameForIndex(zt.patternIndex, (String)fallbackPatternName) : fallbackPatternName;
                            biomePatterns[bi] = this.cachedPattern(framePatternCache, app, (String)patName);
                            ++bi;
                        }
                    }
                }
                for (Cell c : this.model.cells) {
                    boolean canPattern;
                    boolean isWater;
                    if (c == null || c.vertices == null || c.vertices.size() < 3) continue;
                    boolean bl = isWater = c.elevation < seaLevel;
                    if (isWater && s.biomeUnderwaterAlpha01 <= 1.0E-4f || !isWater && s.biomeFillAlpha01 <= 1.0E-4f) continue;
                    int col = landBase;
                    if (biomeScaledCols != null && c.biomeId >= 0 && c.biomeId < biomeScaledCols.length) {
                        col = biomeScaledCols[c.biomeId];
                    }
                    float a = isWater ? s.biomeUnderwaterAlpha01 : s.biomeFillAlpha01;
                    PImage pattern = fallbackPattern;
                    if (usePattern && biomePatterns != null && c.biomeId >= 0 && c.biomeId < biomePatterns.length) {
                        pattern = biomePatterns[c.biomeId];
                    }
                    boolean bl2 = canPattern = usePattern && pattern != null;
                    if (usePattern && canPattern && s.biomeFillType == RenderFillType.RENDER_FILL_PATTERN) {
                        this.drawPatternPoly(app, c.vertices, pattern, col, a);
                        continue;
                    }
                    app.fill(col, a * 255.0f);
                    this.drawPoly(app, c.vertices);
                    if (!usePattern || !canPattern || s.biomeFillType != RenderFillType.RENDER_FILL_PATTERN_BG) continue;
                    this.drawPatternPoly(app, c.vertices, pattern, Main.this.color(0, 0, 0), a);
                }
            }
            if (s.cellBorderAlpha01 > 1.0E-4f && s.cellBorderSizePx > 1.0E-4f) {
                this.ensureCellBorderLayer(app, s);
                if (this.cellBorderLayer != null) {
                    app.pushMatrix();
                    app.resetMatrix();
                    app.tint(255, Main.constrain((float)s.cellBorderAlpha01, (float)0.0f, (float)1.0f) * 255.0f);
                    app.image((PImage)this.cellBorderLayer, 0.0f, 0.0f);
                    app.popMatrix();
                }
            } else {
                this.cellBorderLayer = null;
            }
            if (s.waterDepthAlpha01 > 1.0E-4f) {
                app.noStroke();
                for (Cell c : this.model.cells) {
                    if (c == null || c.vertices == null || c.vertices.size() < 3 || !(c.elevation < seaLevel)) continue;
                    float depth = seaLevel - c.elevation;
                    float t = Main.constrain((float)depth, (float)0.0f, (float)1.0f);
                    float a = s.waterDepthAlpha01 * t;
                    app.fill(0.0f, 0.0f, 0.0f, a * 200.0f);
                    this.drawPoly(app, c.vertices);
                }
            }
            if (s.elevationLightAlpha01 > 1.0E-4f) {
                this.ensureElevationLightLayer(app, s, seaLevel);
                if (this.elevationLightLayer != null) {
                    app.pushStyle();
                    app.pushMatrix();
                    app.resetMatrix();
                    app.blendMode(128);
                    app.image((PImage)this.elevationLightLayer, 0.0f, 0.0f);
                    app.blendMode(1);
                    app.popMatrix();
                    app.popStyle();
                }
            } else {
                this.elevationLightLayer = null;
            }
            boolean bl = wantCoast = s.waterContourSizePx > 1.0E-4f && s.waterCoastAlpha01 > 1.0E-4f;
            if (wantCoast) {
                this.ensureCoastLayer(app, s, seaLevel);
                if (!s.waterCoastAboveZones && this.coastLayer != null) {
                    app.pushStyle();
                    app.pushMatrix();
                    app.resetMatrix();
                    app.tint(255, Main.constrain((float)s.waterCoastAlpha01, (float)0.0f, (float)1.0f) * 255.0f);
                    app.image((PImage)this.coastLayer, 0.0f, 0.0f);
                    app.popMatrix();
                    app.popStyle();
                }
            } else {
                this.coastLayer = null;
            }
            boolean drawRipples = s.waterRippleCount > 0 && s.waterRippleDistancePx > 1.0E-4f && (s.waterRippleAlphaStart01 > 1.0E-4f || s.waterRippleAlphaEnd01 > 1.0E-4f);
            boolean bl3 = drawHatching = s.waterHatchAlpha01 > 1.0E-4f && s.waterHatchLengthPx > 1.0E-4f && s.waterHatchSpacingPx > 1.0E-4f;
            if (drawRipples || drawHatching) {
                this.ensureWaterDetailLayer(app, s, seaLevel, drawRipples, drawHatching);
                if (this.waterDetailLayer != null) {
                    app.pushMatrix();
                    app.resetMatrix();
                    app.tint(255);
                    app.image((PImage)this.waterDetailLayer, 0.0f, 0.0f);
                    app.popMatrix();
                }
            } else {
                this.waterDetailLayer = null;
            }
            if (s.elevationLinesCount > 0 && s.elevationLinesAlpha01 > 1.0E-4f) {
                this.ensureElevationLineLayer(app, s, seaLevel);
                if (this.elevationLineLayer != null) {
                    app.pushMatrix();
                    app.resetMatrix();
                    app.tint(255, Main.constrain((float)s.elevationLinesAlpha01, (float)0.0f, (float)1.0f) * 255.0f);
                    app.image((PImage)this.elevationLineLayer, 0.0f, 0.0f);
                    app.popMatrix();
                }
            } else {
                this.elevationLineLayer = null;
                this.elevationLineDirty = true;
            }
            if (s.biomeOutlineSizePx > 1.0E-4f && (s.biomeOutlineAlpha01 > 1.0E-4f || s.biomeUnderwaterAlpha01 > 1.0E-4f)) {
                this.ensureBiomeOutlineLayer(app, s, seaLevel, landBase, biomeScaledCols);
                if (this.biomeOutlineLayerLand != null) {
                    app.pushMatrix();
                    app.resetMatrix();
                    app.tint(255, Main.constrain((float)s.biomeOutlineAlpha01, (float)0.0f, (float)1.0f) * 255.0f);
                    app.image((PImage)this.biomeOutlineLayerLand, 0.0f, 0.0f);
                    app.popMatrix();
                }
                if (this.biomeOutlineLayerWater != null) {
                    app.pushMatrix();
                    app.resetMatrix();
                    app.tint(255, Main.constrain((float)s.biomeUnderwaterAlpha01, (float)0.0f, (float)1.0f) * 255.0f);
                    app.image((PImage)this.biomeOutlineLayerWater, 0.0f, 0.0f);
                    app.popMatrix();
                }
            } else {
                this.biomeOutlineLayerLand = null;
                this.biomeOutlineLayerWater = null;
            }
            app.popStyle();
        }

        private void drawPoly(PApplet app, ArrayList<PVector> verts) {
            this.drawPoly(app, verts, false);
        }

        private void drawPoly(PApplet app, ArrayList<PVector> verts, boolean outlineOnly) {
            if (verts == null || verts.size() < 3) {
                return;
            }
            if (outlineOnly) {
                int n = verts.size();
                int i = 0;
                while (i < n) {
                    PVector a = verts.get(i);
                    PVector b = verts.get((i + 1) % n);
                    app.line(a.x, a.y, b.x, b.y);
                    ++i;
                }
                return;
            }
            app.beginShape();
            for (PVector v : verts) {
                app.vertex(v.x, v.y);
            }
            app.endShape(2);
        }

        private void drawPoly(PGraphics g, ArrayList<PVector> verts, boolean outlineOnly) {
            if (verts == null || verts.size() < 3 || g == null) {
                return;
            }
            if (outlineOnly) {
                int n = verts.size();
                int i = 0;
                while (i < n) {
                    PVector a = verts.get(i);
                    PVector b = verts.get((i + 1) % n);
                    g.line(a.x, a.y, b.x, b.y);
                    ++i;
                }
                return;
            }
            g.beginShape();
            for (PVector v : verts) {
                g.vertex(v.x, v.y);
            }
            g.endShape(2);
        }

        private int hsbColor(float h, float s, float b, float a) {
            return Main.this.hsb01ToARGB(h, s, b, a);
        }

        private void drawPatternPoly(PApplet app, ArrayList<PVector> verts, PImage pattern, int tintCol, float alpha01) {
            if (verts == null || verts.size() < 3 || pattern == null) {
                return;
            }
            if (pattern.width <= 0 || pattern.height <= 0) {
                return;
            }
            app.pushStyle();
            app.noStroke();
            app.textureMode(1);
            app.textureWrap(1);
            app.tint(tintCol, Main.constrain((float)alpha01, (float)0.0f, (float)1.0f) * 255.0f);
            app.beginShape();
            app.texture(pattern);
            float pw = Main.max((int)1, (int)pattern.width);
            float ph = Main.max((int)1, (int)pattern.height);
            float canvasW = app.g != null ? app.g.width : app.width;
            float canvasH = app.g != null ? app.g.height : app.height;
            for (PVector v : verts) {
                PVector s = Main.this.viewport.worldToScreen(v.x, v.y, canvasW, canvasH);
                float u = s.x / pw;
                float vv = s.y / ph;
                app.vertex(v.x, v.y, u, vv);
            }
            app.endShape(2);
            app.popStyle();
        }

        private PImage cachedPattern(HashMap<String, PImage> cache, PApplet app, String name) {
            if (cache == null || app == null || name == null || name.length() == 0) {
                return null;
            }
            if (cache.containsKey(name)) {
                return cache.get(name);
            }
            PImage pattern = this.getPattern(app, name);
            cache.put(name, pattern);
            return pattern;
        }

        private PImage getNoiseTexture(PApplet app) {
            if (this.noiseTex != null && this.noiseTex.width == 1024 && this.noiseTex.height == 1024) {
                return this.noiseTex;
            }
            this.noiseTex = app.createImage(1024, 1024, 2);
            this.noiseTex.loadPixels();
            int i = 0;
            while (i < this.noiseTex.pixels.length) {
                int gray = (int)app.random(0.0f, 256.0f);
                this.noiseTex.pixels[i] = app.color(gray, gray, gray, 255);
                ++i;
            }
            this.noiseTex.updatePixels();
            return this.noiseTex;
        }

        public PImage getPattern(PApplet app, String name) {
            String abs;
            if (name == null || name.length() == 0) {
                return null;
            }
            if (this.patternCache.containsKey(name)) {
                return this.patternCache.get(name);
            }
            String path = "patterns/" + name;
            PImage img = app.loadImage(path);
            if ((img == null || img.width <= 0 || img.height <= 0) && (abs = app.sketchPath(path)) != null) {
                img = app.loadImage(abs);
            }
            if ((img == null || img.width <= 0 || img.height <= 0) && app.dataPath("") != null) {
                String dataPath = app.dataPath(path);
                img = app.loadImage(dataPath);
            }
            if (img == null || img.width <= 0 || img.height <= 0) {
                this.patternCache.put(name, null);
                return null;
            }
            img.format = 2;
            img.loadPixels();
            int i = 0;
            while (i < img.pixels.length) {
                int c = img.pixels[i];
                int r = c >> 16 & 0xFF;
                int g = c >> 8 & 0xFF;
                int b = c & 0xFF;
                int a = c >> 24 & 0xFF;
                int gray = (r + g + b) / 3;
                int alpha = 255 - gray;
                alpha = (int)Main.constrain((float)((float)alpha * ((float)a / 255.0f)), (float)0.0f, (float)255.0f);
                img.pixels[i] = app.color(255, 255, 255, alpha);
                ++i;
            }
            img.updatePixels();
            this.patternCache.put(name, img);
            return img;
        }

        private void ensureBiomeOutlineCache(float seaLevel) {
            if (this.model == null || this.model.cells == null) {
                return;
            }
            this.model.ensureCellNeighborsComputed();
            int cellCount = this.model.cells.size();
            int checksum = this.biomeChecksum();
            if (cellCount == this.cachedBiomeOutlineCellCount && checksum == this.cachedBiomeOutlineChecksum && Main.abs((float)(this.cachedBiomeOutlineSeaLevel - seaLevel)) < 1.0E-6f) {
                return;
            }
            this.cachedBiomeOutlineEdges.clear();
            this.cachedBiomeOutlineBiomes.clear();
            this.cachedBiomeOutlineUnderwater.clear();
            HashMap<String, Integer> edgeToIndex = new HashMap<String, Integer>();
            float eps2 = 1.0E-6f;
            int ci = 0;
            while (ci < this.model.cells.size()) {
                Cell c = this.model.cells.get(ci);
                if (c != null && c.vertices != null && c.vertices.size() >= 3) {
                    int biomeId = c.biomeId;
                    boolean cellUnderwater = c.elevation < seaLevel;
                    int vc = c.vertices.size();
                    int e = 0;
                    while (e < vc) {
                        ArrayList<Integer> nbs;
                        PVector a = c.vertices.get(e);
                        PVector b = c.vertices.get((e + 1) % vc);
                        String key = this.undirectedEdgeKey(a, b);
                        int nbBiome = biomeId;
                        boolean nbUnderwater = cellUnderwater;
                        boolean boundary = true;
                        ArrayList<Integer> arrayList = nbs = ci < this.model.cellNeighbors.size() ? this.model.cellNeighbors.get(ci) : null;
                        if (nbs != null) {
                            for (int nbIdx : nbs) {
                                Cell nb;
                                if (nbIdx < 0 || nbIdx >= this.model.cells.size() || (nb = this.model.cells.get(nbIdx)) == null || nb.vertices == null) continue;
                                int nv = nb.vertices.size();
                                boolean match = false;
                                int j = 0;
                                while (j < nv) {
                                    PVector na = nb.vertices.get(j);
                                    PVector nbp = nb.vertices.get((j + 1) % nv);
                                    if (this.model.distSq(a, na) < eps2 && this.model.distSq(b, nbp) < eps2 || this.model.distSq(a, nbp) < eps2 && this.model.distSq(b, na) < eps2) {
                                        nbBiome = nb.biomeId;
                                        nbUnderwater = nb.elevation < seaLevel;
                                        match = true;
                                        break;
                                    }
                                    ++j;
                                }
                                if (!match) continue;
                                if (nbBiome != biomeId) break;
                                boundary = false;
                                break;
                            }
                        }
                        if (boundary) {
                            int chosenBiome = Main.max((int)biomeId, (int)nbBiome);
                            boolean underwater = cellUnderwater || nbUnderwater;
                            Integer existingIdx = (Integer)edgeToIndex.get(key);
                            if (existingIdx != null) {
                                int currentBiome;
                                int n = currentBiome = existingIdx < this.cachedBiomeOutlineBiomes.size() ? this.cachedBiomeOutlineBiomes.get(existingIdx) : chosenBiome;
                                if (chosenBiome > currentBiome) {
                                    this.cachedBiomeOutlineBiomes.set(existingIdx, chosenBiome);
                                    this.cachedBiomeOutlineUnderwater.set(existingIdx, underwater);
                                }
                            } else {
                                edgeToIndex.put(key, this.cachedBiomeOutlineEdges.size());
                                this.cachedBiomeOutlineEdges.add(new PVector[]{a.copy(), b.copy()});
                                this.cachedBiomeOutlineBiomes.add(chosenBiome);
                                this.cachedBiomeOutlineUnderwater.add(underwater);
                            }
                        }
                        ++e;
                    }
                }
                ++ci;
            }
            this.cachedBiomeOutlineCellCount = cellCount;
            this.cachedBiomeOutlineChecksum = checksum;
            this.cachedBiomeOutlineSeaLevel = seaLevel;
        }

        private int biomeChecksum() {
            if (this.model == null || this.model.cells == null) {
                return 0;
            }
            int sum = 0;
            int i = 0;
            while (i < this.model.cells.size()) {
                Cell c = this.model.cells.get(i);
                sum = 31 * sum + (c != null ? c.biomeId : -1);
                ++i;
            }
            return sum;
        }

        public void invalidateBiomeOutlineCache() {
            this.cachedBiomeOutlineEdges.clear();
            this.cachedBiomeOutlineBiomes.clear();
            this.cachedBiomeOutlineUnderwater.clear();
            this.cachedBiomeOutlineCellCount = -1;
            this.cachedBiomeOutlineChecksum = 0;
            this.cachedBiomeOutlineSeaLevel = Float.MAX_VALUE;
        }

        public MapModel.ContourGrid sampleElevationGrid(int cols, int rows, float fallback) {
            MapModel.ContourGrid g = this.model.new MapModel.ContourGrid();
            g.cols = Main.max((int)2, (int)cols);
            g.rows = Main.max((int)2, (int)rows);
            g.v = new float[g.rows][g.cols];
            g.ox = this.model.minX;
            g.oy = this.model.minY;
            g.dx = (this.model.maxX - this.model.minX) / (float)(g.cols - 1);
            g.dy = (this.model.maxY - this.model.minY) / (float)(g.rows - 1);
            g.min = Float.MAX_VALUE;
            g.max = -3.4028235E38f;
            int j = 0;
            while (j < g.rows) {
                float y = g.oy + (float)j * g.dy;
                int i = 0;
                while (i < g.cols) {
                    float val;
                    float x = g.ox + (float)i * g.dx;
                    g.v[j][i] = val = this.model.sampleElevationAt(x, y, fallback);
                    g.min = Main.min((float)g.min, (float)val);
                    g.max = Main.max((float)g.max, (float)val);
                    ++i;
                }
                ++j;
            }
            return g;
        }

        public void drawContourSet(PApplet app, MapModel.ContourGrid g, float start, float end, float step, int strokeCol) {
            if (step == 0.0f) {
                return;
            }
            if (step > 0.0f && start > end || step < 0.0f && start < end) {
                return;
            }
            app.pushStyle();
            app.noFill();
            app.stroke(strokeCol);
            float elevW = this.strokeWorldPx(Main.max((float)0.1f, (float)Main.this.renderSettings.elevationLinesSizePx), Main.this.renderSettings.elevationLinesScaleWithZoom, Main.this.renderSettings.elevationLinesRefZoom);
            app.strokeWeight(elevW);
            app.strokeCap(2);
            app.strokeJoin(2);
            HashSet<String> caps = this.drawRoundCaps ? new HashSet<String>() : null;
            float capR = elevW * 0.5f;
            if (step > 0.0f) {
                float iso = start;
                while (iso <= end + 1.0E-6f) {
                    this.drawIsoLine(app, g, iso, this.drawRoundCaps, capR, strokeCol, caps);
                    iso += step;
                }
            } else {
                float iso = start;
                while (iso >= end - 1.0E-6f) {
                    this.drawIsoLine(app, g, iso, this.drawRoundCaps, capR, strokeCol, caps);
                    iso += step;
                }
            }
            app.popStyle();
        }

        public void drawContourSet(PApplet appCtx, PGraphics g, MapModel.ContourGrid grid, float start, float end, float step, int strokeCol) {
            if (grid == null || g == null || appCtx == null) {
                return;
            }
            if (step == 0.0f) {
                return;
            }
            if (step > 0.0f && start > end || step < 0.0f && start < end) {
                return;
            }
            g.pushStyle();
            g.noFill();
            g.stroke(strokeCol);
            float elevW = this.strokeWorldPx(Main.max((float)0.1f, (float)Main.this.renderSettings.elevationLinesSizePx), Main.this.renderSettings.elevationLinesScaleWithZoom, Main.this.renderSettings.elevationLinesRefZoom);
            g.strokeWeight(elevW);
            g.strokeCap(2);
            g.strokeJoin(2);
            HashSet<String> caps = this.drawRoundCaps ? new HashSet<String>() : null;
            float capR = elevW * 0.5f;
            if (step > 0.0f) {
                float iso = start;
                while (iso <= end + 1.0E-6f) {
                    this.drawIsoLine(g, grid, iso, this.drawRoundCaps, capR, strokeCol, caps);
                    iso += step;
                }
            } else {
                float iso = start;
                while (iso >= end - 1.0E-6f) {
                    this.drawIsoLine(g, grid, iso, this.drawRoundCaps, capR, strokeCol, caps);
                    iso += step;
                }
            }
            g.popStyle();
        }

        private float sampleGrid(MapModel.ContourGrid g, float x, float y) {
            if (g == null || g.v == null || g.cols < 2 || g.rows < 2) {
                return 0.0f;
            }
            float fx = Main.constrain((float)((x - g.ox) / Main.max((float)1.0E-6f, (float)g.dx)), (float)0.0f, (float)((float)g.cols - 1.0001f));
            float fy = Main.constrain((float)((y - g.oy) / Main.max((float)1.0E-6f, (float)g.dy)), (float)0.0f, (float)((float)g.rows - 1.0001f));
            int ix = Main.floor((float)fx);
            int iy = Main.floor((float)fy);
            float tx = fx - (float)ix;
            float ty = fy - (float)iy;
            float v00 = g.v[iy][ix];
            float v10 = g.v[iy][ix + 1];
            float v01 = g.v[iy + 1][ix];
            float v11 = g.v[iy + 1][ix + 1];
            float a = Main.lerp((float)v00, (float)v10, (float)tx);
            float b = Main.lerp((float)v01, (float)v11, (float)tx);
            return Main.lerp((float)a, (float)b, (float)ty);
        }

        public void drawWaterRipples(PApplet app, RenderSettings s, float seaLevel) {
            int cols;
            if (s == null) {
                return;
            }
            if (s.waterRippleCount <= 0) {
                return;
            }
            if (s.waterRippleDistancePx <= 1.0E-4f) {
                return;
            }
            if (s.waterRippleAlphaStart01 <= 1.0E-4f && s.waterRippleAlphaEnd01 <= 1.0E-4f) {
                return;
            }
            int rows = cols = Main.max((int)80, (int)Main.min((int)200, (int)((int)(Main.sqrt((float)Main.max((int)1, (int)this.model.cells.size())) * 1.0f))));
            MapModel.ContourGrid g = this.model.getCoastDistanceGrid(cols, rows, seaLevel);
            if (g == null) {
                return;
            }
            float spacingFactor = s.waterContourScaleWithZoom ? Main.max((float)1.0E-6f, (float)Main.this.viewport.zoom) / Main.max((float)1.0E-6f, (float)s.waterContourRefZoom) : 1.0f;
            float spacingWorld = s.waterRippleDistancePx * spacingFactor / Main.max((float)1.0E-6f, (float)Main.this.viewport.zoom);
            if (spacingWorld <= 1.0E-6f) {
                return;
            }
            float maxIso = spacingWorld * (float)s.waterRippleCount;
            float strokePx = this.strokeWorldPx(Main.max((float)0.8f, (float)s.waterContourSizePx), s.waterContourScaleWithZoom, s.waterContourRefZoom);
            app.pushStyle();
            app.noFill();
            app.strokeWeight(strokePx);
            float iso = spacingWorld;
            while (iso <= maxIso + 1.0E-6f) {
                float t = maxIso <= spacingWorld + 1.0E-6f ? 0.0f : Main.constrain((float)((iso - spacingWorld) / Main.max((float)1.0E-6f, (float)(maxIso - spacingWorld))), (float)0.0f, (float)1.0f);
                float a = Main.constrain((float)Main.lerp((float)s.waterRippleAlphaStart01, (float)s.waterRippleAlphaEnd01, (float)t), (float)0.0f, (float)1.0f);
                if (!(a <= 1.0E-4f)) {
                    int strokeCol = this.hsbColor(s.waterContourHue01, s.waterContourSat01, s.waterContourBri01, a);
                    app.stroke(strokeCol);
                    HashSet<String> rippleCaps = this.drawRoundCaps ? new HashSet<String>() : null;
                    this.drawIsoLine(app, g, iso, this.drawRoundCaps, strokePx * 0.5f, strokeCol, rippleCaps);
                }
                iso += spacingWorld;
            }
            app.popStyle();
        }

        public void drawWaterHatching(PApplet app, RenderSettings s, float seaLevel) {
            float startOff;
            if (s == null) {
                return;
            }
            if (s.waterHatchAlpha01 <= 1.0E-4f) {
                return;
            }
            if (s.waterHatchLengthPx <= 1.0E-4f) {
                return;
            }
            if (s.waterHatchSpacingPx <= 1.0E-4f) {
                return;
            }
            int cols = Main.max((int)80, (int)Main.min((int)200, (int)((int)(Main.sqrt((float)Main.max((int)1, (int)this.model.cells.size())) * 1.0f))));
            MapModel.ContourGrid g = this.model.getCoastDistanceGrid(cols, cols, seaLevel);
            if (g == null) {
                return;
            }
            float angleRad = Main.radians((float)s.waterHatchAngleDeg);
            PVector d = new PVector(Main.cos((float)angleRad), Main.sin((float)angleRad));
            PVector n = new PVector(-d.y, d.x);
            float spacingFactor = s.waterContourScaleWithZoom ? Main.max((float)1.0E-6f, (float)Main.this.viewport.zoom) / Main.max((float)1.0E-6f, (float)s.waterContourRefZoom) : 1.0f;
            float spacing = s.waterHatchSpacingPx * spacingFactor / Main.max((float)1.0E-6f, (float)Main.this.viewport.zoom);
            float maxLen = s.waterHatchLengthPx * spacingFactor / Main.max((float)1.0E-6f, (float)Main.this.viewport.zoom);
            if (spacing <= 1.0E-6f || maxLen <= 1.0E-6f) {
                return;
            }
            float minX = this.model.minX;
            float minY = this.model.minY;
            float maxX = this.model.maxX;
            float maxY = this.model.maxY;
            float[] projs = new float[]{minX * n.x + minY * n.y, minX * n.x + maxY * n.y, maxX * n.x + minY * n.y, maxX * n.x + maxY * n.y};
            float minProj = Main.min((float)Main.min((float)projs[0], (float)projs[1]), (float)Main.min((float)projs[2], (float)projs[3]));
            float maxProj = Main.max((float)Main.max((float)projs[0], (float)projs[1]), (float)Main.max((float)projs[2], (float)projs[3]));
            float originProj = minX * n.x + minY * n.y;
            float mapDiag = Main.dist((float)minX, (float)minY, (float)maxX, (float)maxY) + maxLen * 2.0f;
            float stepT = Main.min((float)(spacing * 0.2f), (float)(maxLen * 0.2f));
            stepT = Main.max((float)stepT, (float)(maxLen * 0.05f));
            app.pushStyle();
            int strokeCol = this.hsbColor(s.waterContourHue01, s.waterContourSat01, s.waterContourBri01, s.waterHatchAlpha01);
            app.stroke(strokeCol);
            float hatchStroke = this.strokeWorldPx(Main.max((float)0.6f, (float)(s.waterContourSizePx * 0.8f)), s.waterContourScaleWithZoom, s.waterContourRefZoom);
            app.strokeWeight(hatchStroke);
            app.noFill();
            float off = startOff = (float)Main.floor((float)((minProj - originProj) / spacing)) * spacing + originProj;
            while (off <= maxProj + spacing * 0.5f) {
                PVector base = new PVector(minX, minY);
                base.add(PVector.mult((PVector)n, (float)(off - originProj)));
                PVector start = PVector.sub((PVector)base, (PVector)PVector.mult((PVector)d, (float)mapDiag));
                boolean segState = false;
                PVector segStart = null;
                PVector lastIn = null;
                float t = 0.0f;
                while (t <= mapDiag * 2.0f) {
                    PVector p = PVector.add((PVector)start, (PVector)PVector.mult((PVector)d, (float)t));
                    if (p.x < minX || p.x > maxX || p.y < minY || p.y > maxY) {
                        if (segState && segStart != null && lastIn != null) {
                            app.line(segStart.x, segStart.y, lastIn.x, lastIn.y);
                        }
                        segState = false;
                        segStart = null;
                        lastIn = null;
                    } else {
                        boolean inside;
                        float distVal = this.sampleGrid(g, p.x, p.y);
                        boolean bl = inside = distVal > 0.0f && distVal <= maxLen;
                        if (inside && !segState) {
                            segState = true;
                            segStart = p.copy();
                            lastIn = p.copy();
                        } else if (inside && segState) {
                            lastIn = p.copy();
                        } else if (!inside && segState) {
                            segState = false;
                            if (segStart != null && lastIn != null) {
                                app.line(segStart.x, segStart.y, lastIn.x, lastIn.y);
                            }
                            segStart = null;
                            lastIn = null;
                        }
                    }
                    t += stepT;
                }
                if (segState && segStart != null) {
                    PVector end = lastIn != null ? lastIn : PVector.add((PVector)start, (PVector)PVector.mult((PVector)d, (float)(mapDiag * 2.0f)));
                    app.line(segStart.x, segStart.y, end.x, end.y);
                }
                off += spacing;
            }
            app.popStyle();
        }

        public void drawIsoLine(PApplet app, MapModel.ContourGrid g, float iso) {
            this.drawIsoLine(app, g, iso, false, 0.0f, 0, null);
        }

        public void drawIsoLine(PApplet app, MapModel.ContourGrid g, float iso, boolean caps, float capRadius, int capCol, HashSet<String> capsDrawn) {
            int j = 0;
            while (j < g.rows - 1) {
                float y0 = g.oy + (float)j * g.dy;
                float y1 = y0 + g.dy;
                int i = 0;
                while (i < g.cols - 1) {
                    float x0 = g.ox + (float)i * g.dx;
                    float x1 = x0 + g.dx;
                    float v00 = g.v[j][i];
                    float v10 = g.v[j][i + 1];
                    float v11 = g.v[j + 1][i + 1];
                    float v01 = g.v[j + 1][i];
                    int caseId = 0;
                    if (v00 > iso) {
                        caseId |= 1;
                    }
                    if (v10 > iso) {
                        caseId |= 2;
                    }
                    if (v11 > iso) {
                        caseId |= 4;
                    }
                    if (v01 > iso) {
                        caseId |= 8;
                    }
                    if (caseId != 0 && caseId != 15) {
                        PVector eTop = this.interpIso(x0, y0, v00, x1, y0, v10, iso);
                        PVector eRight = this.interpIso(x1, y0, v10, x1, y1, v11, iso);
                        PVector eBottom = this.interpIso(x0, y1, v01, x1, y1, v11, iso);
                        PVector eLeft = this.interpIso(x0, y0, v00, x0, y1, v01, iso);
                        switch (caseId) {
                            case 1: {
                                this.drawSeg(app, eLeft, eTop, caps, capRadius, capCol, capsDrawn);
                                break;
                            }
                            case 2: {
                                this.drawSeg(app, eTop, eRight, caps, capRadius, capCol, capsDrawn);
                                break;
                            }
                            case 3: {
                                this.drawSeg(app, eLeft, eRight, caps, capRadius, capCol, capsDrawn);
                                break;
                            }
                            case 4: {
                                this.drawSeg(app, eRight, eBottom, caps, capRadius, capCol, capsDrawn);
                                break;
                            }
                            case 5: {
                                this.drawSeg(app, eTop, eRight, caps, capRadius, capCol, capsDrawn);
                                this.drawSeg(app, eLeft, eBottom, caps, capRadius, capCol, capsDrawn);
                                break;
                            }
                            case 6: {
                                this.drawSeg(app, eTop, eBottom, caps, capRadius, capCol, capsDrawn);
                                break;
                            }
                            case 7: {
                                this.drawSeg(app, eLeft, eBottom, caps, capRadius, capCol, capsDrawn);
                                break;
                            }
                            case 8: {
                                this.drawSeg(app, eBottom, eLeft, caps, capRadius, capCol, capsDrawn);
                                break;
                            }
                            case 9: {
                                this.drawSeg(app, eTop, eBottom, caps, capRadius, capCol, capsDrawn);
                                break;
                            }
                            case 10: {
                                this.drawSeg(app, eTop, eLeft, caps, capRadius, capCol, capsDrawn);
                                this.drawSeg(app, eRight, eBottom, caps, capRadius, capCol, capsDrawn);
                                break;
                            }
                            case 11: {
                                this.drawSeg(app, eRight, eBottom, caps, capRadius, capCol, capsDrawn);
                                break;
                            }
                            case 12: {
                                this.drawSeg(app, eRight, eLeft, caps, capRadius, capCol, capsDrawn);
                                break;
                            }
                            case 13: {
                                this.drawSeg(app, eRight, eTop, caps, capRadius, capCol, capsDrawn);
                                break;
                            }
                            case 14: {
                                this.drawSeg(app, eTop, eLeft, caps, capRadius, capCol, capsDrawn);
                            }
                        }
                    }
                    ++i;
                }
                ++j;
            }
        }

        public void drawZoneOutlinesRender(PApplet app, RenderSettings s) {
            boolean drawZones;
            if (s == null) {
                return;
            }
            boolean bl = drawZones = s.zoneStrokeAlpha01 > 1.0E-4f && this.model.zones != null;
            if (!drawZones) {
                this.zoneLayer = null;
                return;
            }
            this.ensureZoneLayer(app, s);
            if (this.zoneLayer != null) {
                app.pushStyle();
                app.pushMatrix();
                app.resetMatrix();
                app.tint(255, Main.constrain((float)s.zoneStrokeAlpha01, (float)0.0f, (float)1.0f) * 255.0f);
                app.image((PImage)this.zoneLayer, 0.0f, 0.0f);
                app.popMatrix();
                app.popStyle();
            }
        }

        public void drawSeg(PApplet app, PVector a, PVector b) {
            if (a == null || b == null) {
                return;
            }
            app.line(a.x, a.y, b.x, b.y);
        }

        public void drawSeg(PApplet app, PVector a, PVector b, boolean caps, float capRadius, int capCol, HashSet<String> capsDrawn) {
            if (a == null || b == null) {
                return;
            }
            app.line(a.x, a.y, b.x, b.y);
            if (!caps || capRadius <= 1.0E-6f) {
                return;
            }
            app.pushStyle();
            app.noStroke();
            app.fill(capCol);
            if (capsDrawn != null) {
                String kb;
                String ka = this.capKey(a);
                if (!capsDrawn.contains(ka)) {
                    capsDrawn.add(ka);
                    app.ellipse(a.x, a.y, capRadius * 2.0f, capRadius * 2.0f);
                }
                if (!capsDrawn.contains(kb = this.capKey(b))) {
                    capsDrawn.add(kb);
                    app.ellipse(b.x, b.y, capRadius * 2.0f, capRadius * 2.0f);
                }
            } else {
                app.ellipse(a.x, a.y, capRadius * 2.0f, capRadius * 2.0f);
                app.ellipse(b.x, b.y, capRadius * 2.0f, capRadius * 2.0f);
            }
            app.popStyle();
        }

        public void drawSeg(PGraphics g, PVector a, PVector b, boolean caps, float capRadius, int capCol, HashSet<String> capsDrawn) {
            if (a == null || b == null || g == null) {
                return;
            }
            g.line(a.x, a.y, b.x, b.y);
            if (!caps || capRadius <= 1.0E-6f) {
                return;
            }
            g.pushStyle();
            g.noStroke();
            g.fill(capCol);
            if (capsDrawn != null) {
                String kb;
                String ka = this.capKey(a);
                if (!capsDrawn.contains(ka)) {
                    capsDrawn.add(ka);
                    g.ellipse(a.x, a.y, capRadius * 2.0f, capRadius * 2.0f);
                }
                if (!capsDrawn.contains(kb = this.capKey(b))) {
                    capsDrawn.add(kb);
                    g.ellipse(b.x, b.y, capRadius * 2.0f, capRadius * 2.0f);
                }
            } else {
                g.ellipse(a.x, a.y, capRadius * 2.0f, capRadius * 2.0f);
                g.ellipse(b.x, b.y, capRadius * 2.0f, capRadius * 2.0f);
            }
            g.popStyle();
        }

        public PVector interpIso(float x0, float y0, float v0, float x1, float y1, float v1, float iso) {
            float denom = v1 - v0;
            if (Main.abs((float)denom) < 1.0E-6f) {
                return new PVector((x0 + x1) * 0.5f, (y0 + y1) * 0.5f);
            }
            float t = (iso - v0) / denom;
            t = Main.constrain((float)t, (float)0.0f, (float)1.0f);
            return new PVector(Main.lerp((float)x0, (float)x1, (float)t), Main.lerp((float)y0, (float)y1, (float)t));
        }

        private String undirectedEdgeKey(PVector a, PVector b) {
            int ax = Main.round((float)(a.x * 10000.0f));
            int ay = Main.round((float)(a.y * 10000.0f));
            int bx = Main.round((float)(b.x * 10000.0f));
            int by = Main.round((float)(b.y * 10000.0f));
            if (ax < bx || ax == bx && ay <= by) {
                return String.valueOf(ax) + "," + ay + "-" + bx + "," + by;
            }
            return String.valueOf(bx) + "," + by + "-" + ax + "," + ay;
        }

        private String capKey(PVector p) {
            if (p == null) {
                return "";
            }
            int px = Main.round((float)(p.x * 10000.0f));
            int py = Main.round((float)(p.y * 10000.0f));
            return String.valueOf(px) + ":" + py;
        }

        private int hashArray(int[] arr) {
            if (arr == null) {
                return 0;
            }
            int h = 1;
            int[] nArray = arr;
            int n = arr.length;
            int n2 = 0;
            while (n2 < n) {
                int v = nArray[n2];
                h = 31 * h + v;
                ++n2;
            }
            return h;
        }

        private int elevationLineSettingsHash(RenderSettings s) {
            int h = 13;
            h = 31 * h + Main.round((float)s.elevationLinesCount);
            h = 31 * h + Main.round((float)(s.elevationLinesSizePx * 1000.0f));
            h = 31 * h + Main.round((float)(s.elevationLinesScaleWithZoom ? 1 : 0));
            h = 31 * h + Main.round((float)(s.elevationLinesRefZoom * 1000.0f));
            h = 31 * h + Main.round((float)(s.elevationLinesAlpha01 * 1000.0f));
            h = 31 * h + (this.drawRoundCaps ? 1 : 0);
            h = 31 * h + (Main.this.renderSettings != null && Main.this.renderSettings.antialiasing ? 1 : 0);
            h = 31 * h + (this.model != null && this.model.cells != null ? this.model.cells.size() : 0);
            return h;
        }

        private int coastSettingsHash(RenderSettings s) {
            int h = 17;
            h = 31 * h + Main.round((float)(s.waterCoastSizePx * 1000.0f));
            h = 31 * h + Main.round((float)(s.waterContourHue01 * 1000.0f));
            h = 31 * h + Main.round((float)(s.waterContourSat01 * 1000.0f));
            h = 31 * h + Main.round((float)(s.waterContourBri01 * 1000.0f));
            h = 31 * h + Main.round((float)(s.waterCoastAlpha01 * 1000.0f));
            h = 31 * h + (s.waterCoastScaleWithZoom ? 1 : 0);
            h = 31 * h + (s.antialiasing ? 1 : 0);
            h = 31 * h + (this.drawRoundCaps ? 1 : 0);
            h = 31 * h + (this.model != null && this.model.cells != null ? this.model.cells.size() : 0);
            return h;
        }

        private int waterDetailSettingsHash(RenderSettings s) {
            int h = 29;
            h = 31 * h + Main.round((float)s.waterRippleCount);
            h = 31 * h + Main.round((float)(s.waterRippleDistancePx * 1000.0f));
            h = 31 * h + Main.round((float)(s.waterRippleAlphaStart01 * 1000.0f));
            h = 31 * h + Main.round((float)(s.waterRippleAlphaEnd01 * 1000.0f));
            h = 31 * h + Main.round((float)(s.waterContourHue01 * 1000.0f));
            h = 31 * h + Main.round((float)(s.waterContourSat01 * 1000.0f));
            h = 31 * h + Main.round((float)(s.waterContourBri01 * 1000.0f));
            h = 31 * h + Main.round((float)(s.waterContourSizePx * 1000.0f));
            h = 31 * h + (s.waterContourScaleWithZoom ? 1 : 0);
            h = 31 * h + Main.round((float)(s.waterContourRefZoom * 1000.0f));
            h = 31 * h + Main.round((float)(s.waterHatchAngleDeg * 10.0f));
            h = 31 * h + Main.round((float)(s.waterHatchLengthPx * 1000.0f));
            h = 31 * h + Main.round((float)(s.waterHatchSpacingPx * 1000.0f));
            h = 31 * h + Main.round((float)(s.waterHatchAlpha01 * 1000.0f));
            h = 31 * h + (this.drawRoundCaps ? 1 : 0);
            h = 31 * h + (this.model != null && this.model.cells != null ? this.model.cells.size() : 0);
            return h;
        }

        private int biomeOutlineHash(RenderSettings s) {
            int h = 23;
            h = 31 * h + Main.round((float)(s.biomeOutlineSizePx * 1000.0f));
            h = 31 * h + Main.round((float)(s.biomeOutlineAlpha01 * 1000.0f));
            h = 31 * h + Main.round((float)(s.biomeUnderwaterAlpha01 * 1000.0f));
            h = 31 * h + Main.round((float)(s.biomeOutlineScaleWithZoom ? 1 : 0));
            h = 31 * h + Main.round((float)(s.biomeOutlineRefZoom * 1000.0f));
            h = 31 * h + (this.model != null && this.model.biomeTypes != null ? this.model.biomeTypes.size() : 0);
            h = 31 * h + (this.model != null && this.model.cells != null ? this.model.cells.size() : 0);
            return h;
        }

        private void ensureBiomeOutlineLayer(PApplet app, RenderSettings s, float seaLevel, int landBase, int[] biomeScaledCols) {
            int i;
            HashSet<String> caps;
            boolean needWater;
            if (this.model == null || this.model.cells == null || this.model.cells.isEmpty()) {
                this.biomeOutlineLayerLand = null;
                this.biomeOutlineLayerWater = null;
                return;
            }
            int targetW = app.g != null ? app.g.width : app.width;
            int targetH = app.g != null ? app.g.height : app.height;
            int hash = this.biomeOutlineHash(s);
            boolean sizeChanged = this.biomeOutlineLayerLand == null || this.biomeOutlineW != targetW || this.biomeOutlineH != targetH;
            boolean viewChanged = this.biomeOutlineLayerLand == null || Main.abs((float)(this.biomeOutlineZoom - Main.this.viewport.zoom)) > 1.0E-4f || Main.abs((float)(this.biomeOutlineCenterX - Main.this.viewport.centerX)) > 1.0E-4f || Main.abs((float)(this.biomeOutlineCenterY - Main.this.viewport.centerY)) > 1.0E-4f;
            boolean settingsChanged = this.biomeOutlineLayerLand == null || this.biomeOutlineHash != hash || this.biomeOutlineCellCount != this.model.cells.size() || Main.abs((float)(this.biomeOutlineSeaLevel - seaLevel)) > 1.0E-6f;
            boolean needLand = s.biomeOutlineAlpha01 > 1.0E-4f;
            boolean bl = needWater = s.biomeUnderwaterAlpha01 > 1.0E-4f;
            if (sizeChanged || this.biomeOutlineLayerLand == null) {
                this.biomeOutlineLayerLand = needLand ? app.createGraphics(targetW, targetH, "processing.awt.PGraphicsJava2D") : null;
                this.biomeOutlineLayerWater = needWater ? app.createGraphics(targetW, targetH, "processing.awt.PGraphicsJava2D") : null;
                this.biomeOutlineW = targetW;
                this.biomeOutlineH = targetH;
            }
            if (!needLand) {
                this.biomeOutlineLayerLand = null;
            }
            if (!needWater) {
                this.biomeOutlineLayerWater = null;
            }
            if (!(this.biomeOutlineDirty || sizeChanged || viewChanged || settingsChanged)) {
                return;
            }
            this.ensureBiomeOutlineCache(seaLevel);
            float boW = this.strokeWorldPx(Main.max((float)0.1f, (float)s.biomeOutlineSizePx), s.biomeOutlineScaleWithZoom, s.biomeOutlineRefZoom);
            if (this.biomeOutlineLayerLand != null) {
                if (s.antialiasing) {
                    this.biomeOutlineLayerLand.smooth(8);
                } else {
                    this.biomeOutlineLayerLand.noSmooth();
                }
                this.biomeOutlineLayerLand.beginDraw();
                this.biomeOutlineLayerLand.clear();
                this.biomeOutlineLayerLand.pushMatrix();
                this.biomeOutlineLayerLand.pushStyle();
                Main.this.viewport.applyTransform(this.biomeOutlineLayerLand, targetW, targetH);
                this.biomeOutlineLayerLand.strokeWeight(boW);
                caps = new HashSet<String>();
                i = 0;
                while (i < this.cachedBiomeOutlineEdges.size()) {
                    if (i >= this.cachedBiomeOutlineUnderwater.size() || !this.cachedBiomeOutlineUnderwater.get(i).booleanValue()) {
                        PVector[] seg = this.cachedBiomeOutlineEdges.get(i);
                        int biomeId = i < this.cachedBiomeOutlineBiomes.size() ? this.cachedBiomeOutlineBiomes.get(i) : -1;
                        int col = landBase;
                        if (this.model.biomeTypes != null && biomeId >= 0 && biomeId < this.model.biomeTypes.size() && biomeScaledCols != null) {
                            col = biomeScaledCols[biomeId];
                        }
                        this.biomeOutlineLayerLand.stroke(col, 255.0f);
                        this.biomeOutlineLayerLand.line(seg[0].x, seg[0].y, seg[1].x, seg[1].y);
                        String k0 = this.undirectedEdgeKey(seg[0], seg[0]);
                        String k1 = this.undirectedEdgeKey(seg[1], seg[1]);
                        if (this.drawRoundCaps) {
                            float d = boW;
                            this.biomeOutlineLayerLand.noStroke();
                            this.biomeOutlineLayerLand.fill(col, 255.0f);
                            if (!caps.contains(k0)) {
                                caps.add(k0);
                                this.biomeOutlineLayerLand.ellipse(seg[0].x, seg[0].y, d, d);
                            }
                            if (!caps.contains(k1)) {
                                caps.add(k1);
                                this.biomeOutlineLayerLand.ellipse(seg[1].x, seg[1].y, d, d);
                            }
                            this.biomeOutlineLayerLand.stroke(col, 255.0f);
                        }
                    }
                    ++i;
                }
                this.biomeOutlineLayerLand.popStyle();
                this.biomeOutlineLayerLand.popMatrix();
                this.biomeOutlineLayerLand.endDraw();
            }
            if (this.biomeOutlineLayerWater != null) {
                if (s.antialiasing) {
                    this.biomeOutlineLayerWater.smooth(8);
                } else {
                    this.biomeOutlineLayerWater.noSmooth();
                }
                this.biomeOutlineLayerWater.beginDraw();
                this.biomeOutlineLayerWater.clear();
                this.biomeOutlineLayerWater.pushMatrix();
                this.biomeOutlineLayerWater.pushStyle();
                Main.this.viewport.applyTransform(this.biomeOutlineLayerWater, targetW, targetH);
                this.biomeOutlineLayerWater.strokeWeight(boW);
                caps = new HashSet();
                i = 0;
                while (i < this.cachedBiomeOutlineEdges.size()) {
                    boolean underwater;
                    boolean bl2 = underwater = i < this.cachedBiomeOutlineUnderwater.size() ? this.cachedBiomeOutlineUnderwater.get(i) : false;
                    if (underwater) {
                        PVector[] seg = this.cachedBiomeOutlineEdges.get(i);
                        int biomeId = i < this.cachedBiomeOutlineBiomes.size() ? this.cachedBiomeOutlineBiomes.get(i) : -1;
                        int col = landBase;
                        if (this.model.biomeTypes != null && biomeId >= 0 && biomeId < this.model.biomeTypes.size() && biomeScaledCols != null) {
                            col = biomeScaledCols[biomeId];
                        }
                        this.biomeOutlineLayerWater.stroke(col, 255.0f);
                        this.biomeOutlineLayerWater.line(seg[0].x, seg[0].y, seg[1].x, seg[1].y);
                        if (this.drawRoundCaps) {
                            float d = boW;
                            String k0 = this.undirectedEdgeKey(seg[0], seg[0]);
                            String k1 = this.undirectedEdgeKey(seg[1], seg[1]);
                            this.biomeOutlineLayerWater.noStroke();
                            this.biomeOutlineLayerWater.fill(col, 255.0f);
                            if (!caps.contains(k0)) {
                                caps.add(k0);
                                this.biomeOutlineLayerWater.ellipse(seg[0].x, seg[0].y, d, d);
                            }
                            if (!caps.contains(k1)) {
                                caps.add(k1);
                                this.biomeOutlineLayerWater.ellipse(seg[1].x, seg[1].y, d, d);
                            }
                            this.biomeOutlineLayerWater.stroke(col, 255.0f);
                        }
                    }
                    ++i;
                }
                this.biomeOutlineLayerWater.popStyle();
                this.biomeOutlineLayerWater.popMatrix();
                this.biomeOutlineLayerWater.endDraw();
            }
            this.biomeOutlineHash = hash;
            this.biomeOutlineZoom = Main.this.viewport.zoom;
            this.biomeOutlineCenterX = Main.this.viewport.centerX;
            this.biomeOutlineCenterY = Main.this.viewport.centerY;
            this.biomeOutlineCellCount = this.model.cells.size();
            this.biomeOutlineSeaLevel = seaLevel;
            this.biomeOutlineDirty = false;
        }

        private int cellBorderSettingsHash(RenderSettings s) {
            int h = 29;
            h = 31 * h + Main.round((float)(s.cellBorderSizePx * 1000.0f));
            h = 31 * h + (s.cellBorderScaleWithZoom ? 1 : 0);
            h = 31 * h + Main.round((float)(s.cellBorderRefZoom * 1000.0f));
            h = 31 * h + (this.model != null && this.model.cells != null ? this.model.cells.size() : 0);
            return h;
        }

        private void ensureCellBorderLayer(PApplet app, RenderSettings s) {
            boolean settingsChanged;
            if (this.model == null || this.model.cells == null || this.model.cells.isEmpty()) {
                this.cellBorderLayer = null;
                return;
            }
            if (s.cellBorderSizePx <= 1.0E-4f || s.cellBorderAlpha01 <= 1.0E-4f) {
                this.cellBorderLayer = null;
                return;
            }
            int targetW = app.g != null ? app.g.width : app.width;
            int targetH = app.g != null ? app.g.height : app.height;
            int hash = this.cellBorderSettingsHash(s);
            boolean sizeChanged = this.cellBorderLayer == null || this.cellBorderW != targetW || this.cellBorderH != targetH;
            boolean viewChanged = this.cellBorderLayer == null || Main.abs((float)(this.cellBorderZoom - Main.this.viewport.zoom)) > 1.0E-4f || Main.abs((float)(this.cellBorderCenterX - Main.this.viewport.centerX)) > 1.0E-4f || Main.abs((float)(this.cellBorderCenterY - Main.this.viewport.centerY)) > 1.0E-4f;
            boolean bl = settingsChanged = this.cellBorderLayer == null || this.cellBorderHash != hash || this.cellBorderCellCount != this.model.cells.size();
            if (!(this.cellBorderDirty || sizeChanged || viewChanged || settingsChanged)) {
                return;
            }
            try {
                this.cellBorderLayer = app.createGraphics(targetW, targetH, "processing.awt.PGraphicsJava2D");
                if (this.cellBorderLayer != null) {
                    this.cellBorderLayer.beginDraw();
                    if (s.antialiasing) {
                        this.cellBorderLayer.smooth(8);
                    } else {
                        this.cellBorderLayer.noSmooth();
                    }
                    this.cellBorderLayer.clear();
                    this.cellBorderLayer.pushMatrix();
                    this.cellBorderLayer.pushStyle();
                    Main.this.viewport.applyTransform(this.cellBorderLayer, targetW, targetH);
                    this.cellBorderLayer.stroke(0.0f, 0.0f, 0.0f, 255.0f);
                    float cbW = this.strokeWorldPx(Main.max((float)0.1f, (float)s.cellBorderSizePx), s.cellBorderScaleWithZoom, s.cellBorderRefZoom);
                    this.cellBorderLayer.strokeWeight(cbW);
                    this.cellBorderLayer.noFill();
                    for (Cell c : this.model.cells) {
                        if (c == null || c.vertices == null || c.vertices.size() < 3) continue;
                        this.drawPoly(this.cellBorderLayer, c.vertices, true);
                    }
                    this.cellBorderLayer.popStyle();
                    this.cellBorderLayer.popMatrix();
                    this.cellBorderLayer.endDraw();
                }
            }
            catch (Exception ex) {
                Main.println((String)("Cell border layer build failed: " + ex));
                this.cellBorderLayer = null;
            }
            this.cellBorderHash = hash;
            this.cellBorderZoom = Main.this.viewport.zoom;
            this.cellBorderCenterX = Main.this.viewport.centerX;
            this.cellBorderCenterY = Main.this.viewport.centerY;
            this.cellBorderW = targetW;
            this.cellBorderH = targetH;
            this.cellBorderCellCount = this.model.cells.size();
            this.cellBorderDirty = false;
        }

        public void ensureCoastLayer(PApplet app, RenderSettings s, float seaLevel) {
            boolean settingsChanged;
            int targetH;
            if (this.model == null || this.model.cells == null || this.model.cells.isEmpty()) {
                this.coastLayer = null;
                return;
            }
            if (app == null) {
                return;
            }
            int targetW = app.g != null ? app.g.width : app.width;
            int n = targetH = app.g != null ? app.g.height : app.height;
            if (targetW <= 0 || targetH <= 0) {
                this.coastLayer = null;
                return;
            }
            int hash = this.coastSettingsHash(s);
            boolean sizeChanged = this.coastLayer == null || this.coastLayerW != targetW || this.coastLayerH != targetH;
            boolean viewChanged = this.coastLayer == null || Main.abs((float)(this.coastLayerZoom - Main.this.viewport.zoom)) > 1.0E-4f || Main.abs((float)(this.coastLayerCenterX - Main.this.viewport.centerX)) > 1.0E-4f || Main.abs((float)(this.coastLayerCenterY - Main.this.viewport.centerY)) > 1.0E-4f;
            boolean bl = settingsChanged = this.coastLayer == null || this.coastLayerHash != hash || Main.abs((float)(this.coastLayerSeaLevel - seaLevel)) > 1.0E-6f || this.coastLayerCellCount != this.model.cells.size();
            if (sizeChanged) {
                try {
                    this.coastLayer = app.createGraphics(targetW, targetH, "processing.awt.PGraphicsJava2D");
                }
                catch (Exception ex) {
                    Main.println((String)("Coast layer alloc failed: " + ex));
                    this.coastLayer = null;
                }
                this.coastLayerW = targetW;
                this.coastLayerH = targetH;
                if (this.coastLayer != null) {
                    if (s.antialiasing) {
                        this.coastLayer.smooth(8);
                    } else {
                        this.coastLayer.noSmooth();
                    }
                }
            } else if (this.coastLayer != null) {
                if (s.antialiasing) {
                    this.coastLayer.smooth(8);
                } else {
                    this.coastLayer.noSmooth();
                }
            }
            if (this.coastLayer == null) {
                return;
            }
            if (!(this.coastDirty || sizeChanged || viewChanged || settingsChanged)) {
                return;
            }
            try {
                this.coastLayer.beginDraw();
                this.coastLayer.clear();
                this.coastLayer.pushMatrix();
                this.coastLayer.pushStyle();
                Main.this.viewport.applyTransform(this.coastLayer, this.coastLayer.width, this.coastLayer.height);
                this.drawCoastLayer(this.coastLayer, s, seaLevel);
                this.coastLayer.popStyle();
                this.coastLayer.popMatrix();
                this.coastLayer.endDraw();
            }
            catch (Exception ex) {
                Main.println((String)("Coast layer build failed: " + ex));
                this.coastLayer = null;
                return;
            }
            this.coastLayerHash = hash;
            this.coastLayerZoom = Main.this.viewport.zoom;
            this.coastLayerCenterX = Main.this.viewport.centerX;
            this.coastLayerCenterY = Main.this.viewport.centerY;
            this.coastLayerSeaLevel = seaLevel;
            this.coastLayerCellCount = this.model.cells.size();
            this.coastDirty = false;
        }

        private void ensureElevationLineLayer(PApplet app, RenderSettings s, float seaLevel) {
            boolean settingsChanged;
            int targetH;
            if (this.model == null || this.model.cells == null || this.model.cells.isEmpty()) {
                this.elevationLineLayer = null;
                return;
            }
            if (app == null) {
                return;
            }
            int targetW = app.g != null ? app.g.width : app.width;
            int n = targetH = app.g != null ? app.g.height : app.height;
            if (targetW <= 0 || targetH <= 0) {
                this.elevationLineLayer = null;
                return;
            }
            int hash = this.elevationLineSettingsHash(s);
            boolean sizeChanged = this.elevationLineLayer == null || this.elevationLineW != targetW || this.elevationLineH != targetH;
            boolean viewChanged = this.elevationLineLayer == null || Main.abs((float)(this.elevationLineZoom - Main.this.viewport.zoom)) > 1.0E-4f || Main.abs((float)(this.elevationLineCenterX - Main.this.viewport.centerX)) > 1.0E-4f || Main.abs((float)(this.elevationLineCenterY - Main.this.viewport.centerY)) > 1.0E-4f;
            boolean bl = settingsChanged = this.elevationLineLayer == null || this.elevationLineHash != hash || Main.abs((float)(this.elevationLineSeaLevel - seaLevel)) > 1.0E-6f || this.elevationLineCellCount != this.model.cells.size();
            if (sizeChanged) {
                try {
                    this.elevationLineLayer = app.createGraphics(targetW, targetH, "processing.awt.PGraphicsJava2D");
                }
                catch (Exception ex) {
                    Main.println((String)("Elevation line layer alloc failed: " + ex));
                    this.elevationLineLayer = null;
                }
                this.elevationLineW = targetW;
                this.elevationLineH = targetH;
                if (this.elevationLineLayer != null) {
                    if (s.antialiasing) {
                        this.elevationLineLayer.smooth(8);
                    } else {
                        this.elevationLineLayer.noSmooth();
                    }
                }
            } else if (this.elevationLineLayer != null) {
                if (s.antialiasing) {
                    this.elevationLineLayer.smooth(8);
                } else {
                    this.elevationLineLayer.noSmooth();
                }
            }
            if (this.elevationLineLayer == null) {
                return;
            }
            if (!(this.elevationLineDirty || sizeChanged || viewChanged || settingsChanged)) {
                return;
            }
            int cols = 90;
            int rows = 90;
            MapModel.ContourGrid grid = this.model.getElevationGridForRender(cols, rows, seaLevel);
            if (grid == null) {
                this.elevationLineLayer = null;
                return;
            }
            float range = Main.max((float)1.0E-4f, (float)(grid.max - seaLevel));
            float step = range / (float)Main.max((int)1, (int)s.elevationLinesCount);
            float start = seaLevel + step;
            int strokeCol = app.color(0, 0, 0, 255);
            try {
                this.elevationLineLayer.beginDraw();
                this.elevationLineLayer.clear();
                this.elevationLineLayer.pushMatrix();
                this.elevationLineLayer.pushStyle();
                Main.this.viewport.applyTransform(this.elevationLineLayer, this.elevationLineLayer.width, this.elevationLineLayer.height);
                this.drawContourSet(app, this.elevationLineLayer, grid, start, grid.max, step, strokeCol);
                this.elevationLineLayer.popStyle();
                this.elevationLineLayer.popMatrix();
                this.elevationLineLayer.endDraw();
            }
            catch (Exception ex) {
                Main.println((String)("Elevation line layer build failed: " + ex));
                this.elevationLineLayer = null;
                return;
            }
            this.elevationLineHash = hash;
            this.elevationLineZoom = Main.this.viewport.zoom;
            this.elevationLineCenterX = Main.this.viewport.centerX;
            this.elevationLineCenterY = Main.this.viewport.centerY;
            this.elevationLineSeaLevel = seaLevel;
            this.elevationLineCellCount = this.model.cells.size();
            this.elevationLineDirty = false;
        }

        private void ensureWaterDetailLayer(PApplet app, RenderSettings s, float seaLevel, boolean wantRipples, boolean wantHatching) {
            boolean settingsChanged;
            int targetH;
            if (this.model == null || this.model.cells == null || this.model.cells.isEmpty()) {
                this.waterDetailLayer = null;
                return;
            }
            if (app == null) {
                return;
            }
            int targetW = app.g != null ? app.g.width : app.width;
            int n = targetH = app.g != null ? app.g.height : app.height;
            if (targetW <= 0 || targetH <= 0) {
                this.waterDetailLayer = null;
                return;
            }
            int hash = this.waterDetailSettingsHash(s);
            boolean sizeChanged = this.waterDetailLayer == null || this.waterDetailLayerW != targetW || this.waterDetailLayerH != targetH;
            boolean viewChanged = this.waterDetailLayer == null || Main.abs((float)(this.waterDetailLayerZoom - Main.this.viewport.zoom)) > 1.0E-4f || Main.abs((float)(this.waterDetailLayerCenterX - Main.this.viewport.centerX)) > 1.0E-4f || Main.abs((float)(this.waterDetailLayerCenterY - Main.this.viewport.centerY)) > 1.0E-4f;
            boolean bl = settingsChanged = this.waterDetailLayer == null || this.waterDetailLayerHash != hash || Main.abs((float)(this.waterDetailLayerSeaLevel - seaLevel)) > 1.0E-6f || this.waterDetailLayerCellCount != this.model.cells.size();
            if (sizeChanged) {
                try {
                    this.waterDetailLayer = app.createGraphics(targetW, targetH, "processing.awt.PGraphicsJava2D");
                }
                catch (Exception ex) {
                    Main.println((String)("Water detail layer alloc failed: " + ex));
                    this.waterDetailLayer = null;
                }
                this.waterDetailLayerW = targetW;
                this.waterDetailLayerH = targetH;
                if (this.waterDetailLayer != null) {
                    if (s.antialiasing) {
                        this.waterDetailLayer.smooth(8);
                    } else {
                        this.waterDetailLayer.noSmooth();
                    }
                }
            } else if (this.waterDetailLayer != null) {
                if (s.antialiasing) {
                    this.waterDetailLayer.smooth(8);
                } else {
                    this.waterDetailLayer.noSmooth();
                }
            }
            if (this.waterDetailLayer == null) {
                return;
            }
            if (!(this.waterDetailDirty || sizeChanged || viewChanged || settingsChanged)) {
                return;
            }
            try {
                this.waterDetailLayer.beginDraw();
                this.waterDetailLayer.clear();
                PGraphics prev = app.g;
                app.g = this.waterDetailLayer;
                this.waterDetailLayer.pushMatrix();
                this.waterDetailLayer.pushStyle();
                Main.this.viewport.applyTransform(this.waterDetailLayer, this.waterDetailLayer.width, this.waterDetailLayer.height);
                if (wantRipples) {
                    this.drawWaterRipples(app, s, seaLevel);
                }
                if (wantHatching) {
                    this.drawWaterHatching(app, s, seaLevel);
                }
                this.waterDetailLayer.popStyle();
                this.waterDetailLayer.popMatrix();
                app.g = prev;
                this.waterDetailLayer.endDraw();
            }
            catch (Exception ex) {
                Main.println((String)("Water detail layer build failed: " + ex));
                this.waterDetailLayer = null;
            }
            this.waterDetailLayerHash = hash;
            this.waterDetailLayerZoom = Main.this.viewport.zoom;
            this.waterDetailLayerCenterX = Main.this.viewport.centerX;
            this.waterDetailLayerCenterY = Main.this.viewport.centerY;
            this.waterDetailLayerSeaLevel = seaLevel;
            this.waterDetailLayerCellCount = this.model.cells.size();
            this.waterDetailDirty = false;
        }

        private void drawCoastLayer(PGraphics g, RenderSettings s, float seaLevel) {
            HashSet<String> drawn = new HashSet<String>();
            HashSet<String> capsDrawn = new HashSet<String>();
            int strokeCol = this.hsbColor(s.waterContourHue01, s.waterContourSat01, s.waterContourBri01, 1.0f);
            float strokeW = this.strokeWorldPx(Main.max((float)0.1f, (float)s.waterCoastSizePx), s.waterCoastScaleWithZoom, s.waterContourRefZoom);
            float thisHalfWeight = strokeW * 0.5f;
            g.strokeWeight(strokeW);
            g.stroke(strokeCol);
            g.noFill();
            this.model.ensureCellNeighborsComputed();
            int ci = 0;
            while (ci < this.model.cells.size()) {
                Cell c = this.model.cells.get(ci);
                if (c != null && c.vertices != null && c.vertices.size() >= 3) {
                    boolean isWater = c.elevation < seaLevel;
                    int vc = c.vertices.size();
                    int e = 0;
                    while (e < vc) {
                        PVector b;
                        PVector a = c.vertices.get(e);
                        String key = this.undirectedEdgeKey(a, b = c.vertices.get((e + 1) % vc));
                        if (!drawn.contains(key)) {
                            ArrayList<Integer> nbs;
                            boolean boundary = false;
                            boolean nbIsWater = false;
                            ArrayList<Integer> arrayList = nbs = ci < this.model.cellNeighbors.size() ? this.model.cellNeighbors.get(ci) : null;
                            if (nbs != null) {
                                for (int nbIdx : nbs) {
                                    Cell nb;
                                    if (nbIdx < 0 || nbIdx >= this.model.cells.size() || (nb = this.model.cells.get(nbIdx)) == null || nb.vertices == null) continue;
                                    int nv = nb.vertices.size();
                                    boolean match = false;
                                    int j = 0;
                                    while (j < nv) {
                                        PVector na = nb.vertices.get(j);
                                        PVector nbp = nb.vertices.get((j + 1) % nv);
                                        if (this.model.distSq(a, na) < 1.0E-6f && this.model.distSq(b, nbp) < 1.0E-6f || this.model.distSq(a, nbp) < 1.0E-6f && this.model.distSq(b, na) < 1.0E-6f) {
                                            nbIsWater = nb.elevation < seaLevel;
                                            boundary = isWater ^ nbIsWater;
                                            match = true;
                                            break;
                                        }
                                        ++j;
                                    }
                                    if (match) break;
                                }
                            }
                            if (boundary) {
                                drawn.add(key);
                                if (isWater || nbIsWater) {
                                    g.line(a.x, a.y, b.x, b.y);
                                    if (this.drawRoundCaps) {
                                        String ka = this.undirectedEdgeKey(a, a);
                                        String kb = this.undirectedEdgeKey(b, b);
                                        g.noStroke();
                                        g.fill(strokeCol);
                                        if (!capsDrawn.contains(ka)) {
                                            capsDrawn.add(ka);
                                            g.ellipse(a.x, a.y, thisHalfWeight * 2.0f, thisHalfWeight * 2.0f);
                                        }
                                        if (!capsDrawn.contains(kb)) {
                                            capsDrawn.add(kb);
                                            g.ellipse(b.x, b.y, thisHalfWeight * 2.0f, thisHalfWeight * 2.0f);
                                        }
                                        g.stroke(strokeCol);
                                    }
                                }
                            }
                        }
                        ++e;
                    }
                }
                ++ci;
            }
        }

        private int zoneSettingsHash(RenderSettings s, int[] zoneCols) {
            int h = 19;
            h = 31 * h + Main.round((float)(s.zoneStrokeSatScale01 * 1000.0f));
            h = 31 * h + Main.round((float)(s.zoneStrokeBriScale01 * 1000.0f));
            h = 31 * h + Main.round((float)(s.zoneStrokeSizePx * 1000.0f));
            h = 31 * h + this.hashArray(zoneCols);
            h = 31 * h + (this.drawRoundCaps ? 1 : 0);
            h = 31 * h + (this.model != null && this.model.cells != null ? this.model.cells.size() : 0);
            h = 31 * h + (this.model != null && this.model.zones != null ? this.model.zones.size() : 0);
            return h;
        }

        private void ensureZoneLayer(PApplet app, RenderSettings s) {
            boolean settingsChanged;
            if (this.model == null || this.model.cells == null || this.model.cells.isEmpty() || this.model.zones == null) {
                this.zoneLayer = null;
                return;
            }
            if (app == null) {
                return;
            }
            int[] zoneStrokeCols = this.buildZoneStrokeColors(s);
            int targetW = app.g != null ? app.g.width : app.width;
            int targetH = app.g != null ? app.g.height : app.height;
            int hash = this.zoneSettingsHash(s, zoneStrokeCols);
            boolean sizeChanged = this.zoneLayer == null || this.zoneLayerW != targetW || this.zoneLayerH != targetH;
            boolean viewChanged = this.zoneLayer == null || Main.abs((float)(this.zoneLayerZoom - Main.this.viewport.zoom)) > 1.0E-4f || Main.abs((float)(this.zoneLayerCenterX - Main.this.viewport.centerX)) > 1.0E-4f || Main.abs((float)(this.zoneLayerCenterY - Main.this.viewport.centerY)) > 1.0E-4f;
            boolean bl = settingsChanged = this.zoneLayer == null || this.zoneLayerHash != hash || this.zoneLayerCellCount != this.model.cells.size() || this.zoneLayerZoneCount != this.model.zones.size();
            if (sizeChanged) {
                try {
                    this.zoneLayer = app.createGraphics(targetW, targetH, "processing.awt.PGraphicsJava2D");
                }
                catch (Exception ex) {
                    Main.println((String)("Zone layer alloc failed: " + ex));
                    this.zoneLayer = null;
                }
                this.zoneLayerW = targetW;
                this.zoneLayerH = targetH;
                if (this.zoneLayer != null) {
                    if (s.antialiasing) {
                        this.zoneLayer.smooth(8);
                    } else {
                        this.zoneLayer.noSmooth();
                    }
                }
            } else if (this.zoneLayer != null) {
                if (s.antialiasing) {
                    this.zoneLayer.smooth(8);
                } else {
                    this.zoneLayer.noSmooth();
                }
            }
            if (this.zoneLayer == null) {
                return;
            }
            if (!(this.zoneDirty || sizeChanged || viewChanged || settingsChanged)) {
                return;
            }
            try {
                this.zoneLayer.beginDraw();
                this.zoneLayer.clear();
                this.zoneLayer.pushMatrix();
                this.zoneLayer.pushStyle();
                Main.this.viewport.applyTransform(this.zoneLayer, this.zoneLayer.width, this.zoneLayer.height);
                float zoneW = this.strokeWorldPx(Main.max((float)0.1f, (float)s.zoneStrokeSizePx), s.zoneStrokeScaleWithZoom, s.zoneStrokeRefZoom);
                this.drawZoneLayer(this.zoneLayer, zoneStrokeCols, zoneW, s);
                this.zoneLayer.popStyle();
                this.zoneLayer.popMatrix();
                this.zoneLayer.endDraw();
            }
            catch (Exception ex) {
                Main.println((String)("Zone layer build failed: " + ex));
                this.zoneLayer = null;
                return;
            }
            this.zoneLayerHash = hash;
            this.zoneLayerZoom = Main.this.viewport.zoom;
            this.zoneLayerCenterX = Main.this.viewport.centerX;
            this.zoneLayerCenterY = Main.this.viewport.centerY;
            this.zoneLayerCellCount = this.model.cells.size();
            this.zoneLayerZoneCount = this.model.zones.size();
            this.zoneDirty = false;
        }

        private void drawZoneLayer(PGraphics g, int[] zoneStrokeCols, float zoneW, RenderSettings s) {
            if (s == null || this.model.cells == null || this.model.cells.isEmpty()) {
                return;
            }
            this.model.ensureCellNeighborsComputed();
            int n = this.model.cells.size();
            ArrayList zoneForCell = new ArrayList(n);
            int i = 0;
            while (i < n) {
                zoneForCell.add(new ArrayList());
                ++i;
            }
            if (this.model.zones != null) {
                int zi = 0;
                while (zi < this.model.zones.size()) {
                    MapModel.MapZone z = this.model.zones.get(zi);
                    if (z != null && z.cells != null) {
                        for (int ci : z.cells) {
                            ArrayList list;
                            if (ci < 0 || ci >= n || (list = (ArrayList)zoneForCell.get(ci)).contains(zi)) continue;
                            list.add(zi);
                        }
                    }
                    ++zi;
                }
            }
            float eps2 = 1.0E-6f;
            float laneGap = Main.max((float)(0.2f / Main.this.viewport.zoom), (float)(zoneW * 0.4f));
            HashSet<String> drawn = new HashSet<String>();
            ArrayList listA = new ArrayList();
            ArrayList listB = new ArrayList();
            ArrayList<SegInfo> allSegs = new ArrayList<SegInfo>();
            HashMap<String, CapInfo> capMap = new HashMap<String, CapInfo>();
            int ci = 0;
            while (ci < n) {
                Cell c = this.model.cells.get(ci);
                if (c != null && c.vertices != null && c.vertices.size() >= 3) {
                    ArrayList zonesA = (ArrayList)zoneForCell.get(ci);
                    int vc = c.vertices.size();
                    int e = 0;
                    while (e < vc) {
                        PVector b;
                        PVector a = c.vertices.get(e);
                        String key = this.undirectedEdgeKey(a, b = c.vertices.get((e + 1) % vc));
                        if (!drawn.contains(key)) {
                            boolean hasDiff;
                            ArrayList<Integer> nbs;
                            ArrayList zonesB = null;
                            ArrayList<Integer> arrayList = nbs = ci < this.model.cellNeighbors.size() ? this.model.cellNeighbors.get(ci) : null;
                            if (nbs != null) {
                                for (int nbIdx : nbs) {
                                    Cell nb;
                                    if (nbIdx < 0 || nbIdx >= n || (nb = this.model.cells.get(nbIdx)) == null || nb.vertices == null) continue;
                                    int nv = nb.vertices.size();
                                    boolean matched = false;
                                    int j = 0;
                                    while (j < nv) {
                                        boolean matchRev;
                                        PVector na = nb.vertices.get(j);
                                        PVector nbp = nb.vertices.get((j + 1) % nv);
                                        boolean match = this.model.distSq(a, na) < eps2 && this.model.distSq(b, nbp) < eps2;
                                        boolean bl = matchRev = this.model.distSq(a, nbp) < eps2 && this.model.distSq(b, na) < eps2;
                                        if (match || matchRev) {
                                            zonesB = (ArrayList)zoneForCell.get(nbIdx);
                                            matched = true;
                                            break;
                                        }
                                        ++j;
                                    }
                                    if (matched) break;
                                }
                            }
                            HashSet setA = zonesA != null ? new HashSet(zonesA) : new HashSet();
                            HashSet setB = zonesB != null ? new HashSet(zonesB) : new HashSet();
                            HashSet uniqueA = new HashSet(setA);
                            uniqueA.removeAll(setB);
                            HashSet uniqueB = new HashSet(setB);
                            uniqueB.removeAll(setA);
                            boolean bl = hasDiff = !uniqueA.isEmpty() || !uniqueB.isEmpty();
                            if (!hasDiff) {
                                drawn.add(key);
                            } else {
                                int colZ;
                                int zId;
                                PVector toCenter;
                                PVector cenA = this.model.cellCentroid(c);
                                PVector mid = new PVector((a.x + b.x) * 0.5f, (a.y + b.y) * 0.5f);
                                PVector edgeDir = new PVector(b.x - a.x, b.y - a.y);
                                PVector nrm = new PVector(-edgeDir.y, edgeDir.x);
                                float nLen = Main.max((float)1.0E-6f, (float)Main.sqrt((float)(nrm.x * nrm.x + nrm.y * nrm.y)));
                                nrm.mult(1.0f / nLen);
                                if (cenA != null && (toCenter = PVector.sub((PVector)cenA, (PVector)mid)).dot(nrm) < 0.0f) {
                                    nrm.mult(-1.0f);
                                }
                                class Lane {
                                    float width;
                                    int col;
                                    int zoneId;

                                    Lane(float w, int ccol, int zid) {
                                        this.width = w;
                                        this.col = ccol;
                                        this.zoneId = zid;
                                    }
                                }
                                ArrayList<Lane> lanesPos = new ArrayList<Lane>();
                                ArrayList<Lane> lanesNeg = new ArrayList<Lane>();
                                listA.clear();
                                listA.addAll(uniqueA);
                                Collections.sort(listA);
                                listB.clear();
                                listB.addAll(uniqueB);
                                Collections.sort(listB);
                                Iterator iterator = listA.iterator();
                                while (iterator.hasNext()) {
                                    zId = (Integer)iterator.next();
                                    if (zId < 0 || zId >= this.model.zones.size()) continue;
                                    int n2 = colZ = zoneStrokeCols != null && zId < zoneStrokeCols.length ? zoneStrokeCols[zId] : -1;
                                    if (colZ == -1) continue;
                                    lanesPos.add(new Lane(zoneW, colZ, zId));
                                }
                                iterator = listB.iterator();
                                while (iterator.hasNext()) {
                                    zId = (Integer)iterator.next();
                                    if (zId < 0 || zId >= this.model.zones.size()) continue;
                                    int n3 = colZ = zoneStrokeCols != null && zId < zoneStrokeCols.length ? zoneStrokeCols[zId] : -1;
                                    if (colZ == -1) continue;
                                    lanesNeg.add(new Lane(zoneW, colZ, zId));
                                }
                                Comparator<Lane> cmp = new Comparator<Lane>(){

                                    @Override
                                    public int compare(Lane aL, Lane bL) {
                                        return Float.compare(bL.width, aL.width);
                                    }
                                };
                                Collections.sort(lanesPos, cmp);
                                Collections.sort(lanesNeg, cmp);
                                float offsetPos = 0.0f;
                                for (Lane l : lanesPos) {
                                    if (l.width <= 1.0E-4f) continue;
                                    float laneOff = offsetPos + l.width * 0.5f;
                                    float ax = a.x + nrm.x * laneOff;
                                    float ay = a.y + nrm.y * laneOff;
                                    float bx = b.x + nrm.x * laneOff;
                                    float by = b.y + nrm.y * laneOff;
                                    SegInfo si = new SegInfo(new PVector(ax, ay), new PVector(bx, by), a, b, l.width, l.col, l.zoneId);
                                    allSegs.add(si);
                                    capMap.putIfAbsent(String.valueOf(this.undirectedEdgeKey(a, a)) + "#" + l.zoneId, new CapInfo(si, true, l.width * 0.5f, l.col));
                                    capMap.putIfAbsent(String.valueOf(this.undirectedEdgeKey(b, b)) + "#" + l.zoneId, new CapInfo(si, false, l.width * 0.5f, l.col));
                                    offsetPos += l.width + laneGap;
                                }
                                float offsetNeg = 0.0f;
                                for (Lane l : lanesNeg) {
                                    if (l.width <= 1.0E-4f) continue;
                                    float laneOff = offsetNeg + l.width * 0.5f;
                                    float ax = a.x - nrm.x * laneOff;
                                    float ay = a.y - nrm.y * laneOff;
                                    float bx = b.x - nrm.x * laneOff;
                                    float by = b.y - nrm.y * laneOff;
                                    SegInfo si = new SegInfo(new PVector(ax, ay), new PVector(bx, by), a, b, l.width, l.col, l.zoneId);
                                    allSegs.add(si);
                                    capMap.putIfAbsent(String.valueOf(this.undirectedEdgeKey(a, a)) + "#" + l.zoneId, new CapInfo(si, true, l.width * 0.5f, l.col));
                                    capMap.putIfAbsent(String.valueOf(this.undirectedEdgeKey(b, b)) + "#" + l.zoneId, new CapInfo(si, false, l.width * 0.5f, l.col));
                                    offsetNeg += l.width + laneGap;
                                }
                                drawn.add(key);
                            }
                        }
                        ++e;
                    }
                }
                ++ci;
            }
            this.adjustZoneSegmentIntersections(allSegs);
            g.strokeWeight(1.0f);
            for (SegInfo si : allSegs) {
                g.stroke(si.col);
                g.strokeWeight(si.w);
                g.line(si.a.x, si.a.y, si.b.x, si.b.y);
            }
            if (this.drawRoundCaps) {
                g.noStroke();
                for (CapInfo ci2 : capMap.values()) {
                    PVector p = ci2.atStart ? ci2.seg.a : ci2.seg.b;
                    g.fill(ci2.col);
                    float d = ci2.r * 2.0f;
                    g.ellipse(p.x, p.y, d, d);
                }
            }
        }

        public void drawIsoLine(PGraphics g, MapModel.ContourGrid grid, float iso, boolean caps, float capRadius, int capCol, HashSet<String> capsDrawn) {
            if (grid == null || g == null) {
                return;
            }
            int j = 0;
            while (j < grid.rows - 1) {
                float y0 = grid.oy + (float)j * grid.dy;
                float y1 = y0 + grid.dy;
                int i = 0;
                while (i < grid.cols - 1) {
                    float x0 = grid.ox + (float)i * grid.dx;
                    float x1 = x0 + grid.dx;
                    float v00 = grid.v[j][i];
                    float v10 = grid.v[j][i + 1];
                    float v11 = grid.v[j + 1][i + 1];
                    float v01 = grid.v[j + 1][i];
                    int caseId = 0;
                    if (v00 > iso) {
                        caseId |= 1;
                    }
                    if (v10 > iso) {
                        caseId |= 2;
                    }
                    if (v11 > iso) {
                        caseId |= 4;
                    }
                    if (v01 > iso) {
                        caseId |= 8;
                    }
                    if (caseId != 0 && caseId != 15) {
                        PVector eTop = this.interpIso(x0, y0, v00, x1, y0, v10, iso);
                        PVector eRight = this.interpIso(x1, y0, v10, x1, y1, v11, iso);
                        PVector eBottom = this.interpIso(x0, y1, v01, x1, y1, v11, iso);
                        PVector eLeft = this.interpIso(x0, y0, v00, x0, y1, v01, iso);
                        switch (caseId) {
                            case 1: {
                                this.drawSeg(g, eLeft, eTop, caps, capRadius, capCol, capsDrawn);
                                break;
                            }
                            case 2: {
                                this.drawSeg(g, eTop, eRight, caps, capRadius, capCol, capsDrawn);
                                break;
                            }
                            case 3: {
                                this.drawSeg(g, eLeft, eRight, caps, capRadius, capCol, capsDrawn);
                                break;
                            }
                            case 4: {
                                this.drawSeg(g, eRight, eBottom, caps, capRadius, capCol, capsDrawn);
                                break;
                            }
                            case 5: {
                                this.drawSeg(g, eTop, eRight, caps, capRadius, capCol, capsDrawn);
                                this.drawSeg(g, eLeft, eBottom, caps, capRadius, capCol, capsDrawn);
                                break;
                            }
                            case 6: {
                                this.drawSeg(g, eTop, eBottom, caps, capRadius, capCol, capsDrawn);
                                break;
                            }
                            case 7: {
                                this.drawSeg(g, eLeft, eBottom, caps, capRadius, capCol, capsDrawn);
                                break;
                            }
                            case 8: {
                                this.drawSeg(g, eBottom, eLeft, caps, capRadius, capCol, capsDrawn);
                                break;
                            }
                            case 9: {
                                this.drawSeg(g, eTop, eBottom, caps, capRadius, capCol, capsDrawn);
                                break;
                            }
                            case 10: {
                                this.drawSeg(g, eTop, eLeft, caps, capRadius, capCol, capsDrawn);
                                this.drawSeg(g, eRight, eBottom, caps, capRadius, capCol, capsDrawn);
                                break;
                            }
                            case 11: {
                                this.drawSeg(g, eRight, eBottom, caps, capRadius, capCol, capsDrawn);
                                break;
                            }
                            case 12: {
                                this.drawSeg(g, eRight, eLeft, caps, capRadius, capCol, capsDrawn);
                                break;
                            }
                            case 13: {
                                this.drawSeg(g, eRight, eTop, caps, capRadius, capCol, capsDrawn);
                                break;
                            }
                            case 14: {
                                this.drawSeg(g, eTop, eLeft, caps, capRadius, capCol, capsDrawn);
                            }
                        }
                    }
                    ++i;
                }
                ++j;
            }
        }

        private void adjustZoneSegmentIntersections(ArrayList<SegInfo> segs) {
            class SegEndpoint {
                SegInfo s;
                boolean isStart;
                int zoneId;
                float ang;

                SegEndpoint(SegInfo s, boolean isStart, int zoneId, float ang) {
                    this.s = s;
                    this.isStart = isStart;
                    this.zoneId = zoneId;
                    this.ang = ang;
                }
            }
            if (segs == null || segs.isEmpty()) {
                return;
            }
            HashMap<String, ArrayList> byVertex = new HashMap<String, ArrayList>();
            for (SegInfo s : segs) {
                if (s == null) continue;
                PVector dirA = PVector.sub((PVector)s.b, (PVector)s.a);
                PVector dirB = PVector.sub((PVector)s.a, (PVector)s.b);
                String ka = String.valueOf(this.undirectedEdgeKey(s.origA, s.origA)) + "#" + s.zoneId;
                String kb = String.valueOf(this.undirectedEdgeKey(s.origB, s.origB)) + "#" + s.zoneId;
                float angA = Main.atan2((float)dirA.y, (float)dirA.x);
                float angB = Main.atan2((float)dirB.y, (float)dirB.x);
                byVertex.computeIfAbsent(ka, k -> new ArrayList()).add(new SegEndpoint(s, true, s.zoneId, angA));
                byVertex.computeIfAbsent(kb, k -> new ArrayList()).add(new SegEndpoint(s, false, s.zoneId, angB));
            }
            for (ArrayList list : byVertex.values()) {
                if (list == null || list.size() < 2) continue;
                Collections.sort(list, new Comparator<SegEndpoint>(){

                    @Override
                    public int compare(SegEndpoint a, SegEndpoint b) {
                        return Float.compare(a.ang, b.ang);
                    }
                });
                int m = list.size();
                int i = 0;
                while (i < m) {
                    PVector p1b;
                    PVector p1a;
                    PVector p0b;
                    PVector p0a;
                    PVector inter;
                    SegEndpoint e0 = (SegEndpoint)list.get(i);
                    SegEndpoint e1 = (SegEndpoint)list.get((i + 1) % m);
                    if (e0.zoneId == e1.zoneId && (inter = this.lineIntersection(p0a = e0.isStart ? e0.s.a : e0.s.b, p0b = e0.isStart ? e0.s.b : e0.s.a, p1a = e1.isStart ? e1.s.a : e1.s.b, p1b = e1.isStart ? e1.s.b : e1.s.a)) != null) {
                        if (e0.isStart) {
                            e0.s.a = inter.copy();
                        } else {
                            e0.s.b = inter.copy();
                        }
                        if (e1.isStart) {
                            e1.s.a = inter.copy();
                        } else {
                            e1.s.b = inter.copy();
                        }
                    }
                    i += 2;
                }
            }
        }

        private int biomeSettingsHash(RenderSettings s, int[] biomeCols) {
            int h = 23;
            h = 31 * h + Main.round((float)(s.biomeOutlineSizePx * 1000.0f));
            h = 31 * h + Main.round((float)(s.biomeSatScale01 * 1000.0f));
            h = 31 * h + Main.round((float)(s.biomeBriScale01 * 1000.0f));
            h = 31 * h + (s.biomeFillType != null ? s.biomeFillType.ordinal() : -1);
            h = 31 * h + (this.model != null && this.model.biomeTypes != null ? this.model.biomeTypes.size() : 0);
            h = 31 * h + this.hashArray(biomeCols);
            h = 31 * h + (this.drawRoundCaps ? 1 : 0);
            h = 31 * h + (this.model != null && this.model.cells != null ? this.model.cells.size() : 0);
            return h;
        }

        private int elevationLightSettingsHash(RenderSettings s) {
            int h = 29;
            h = 31 * h + Main.round((float)(s.elevationLightAzimuthDeg * 100.0f));
            h = 31 * h + Main.round((float)(s.elevationLightAltitudeDeg * 100.0f));
            h = 31 * h + Main.round((float)(s.elevationLightAlpha01 * 1000.0f));
            h = 31 * h + Main.round((float)(s.elevationLightDitherPx * 1000.0f));
            h = 31 * h + (s.elevationLightDitherScaleWithZoom ? 1 : 0);
            h = 31 * h + (s.antialiasing ? 1 : 0);
            h = 31 * h + (this.model != null && this.model.cells != null ? this.model.cells.size() : 0);
            return h;
        }

        private boolean allocBiomeLayers(PApplet app, RenderSettings s, int targetW, int targetH, boolean preferP2D) {
            if (app == null) {
                return false;
            }
            PGraphics land = null;
            PGraphics water = null;
            Exception allocErr = null;
            if (preferP2D) {
                try {
                    land = app.createGraphics(targetW, targetH, "processing.opengl.PGraphics2D");
                    water = app.createGraphics(targetW, targetH, "processing.opengl.PGraphics2D");
                }
                catch (Exception ex) {
                    allocErr = ex;
                }
            }
            if (land == null || water == null) {
                try {
                    land = app.createGraphics(targetW, targetH, "processing.awt.PGraphicsJava2D");
                    water = app.createGraphics(targetW, targetH, "processing.awt.PGraphicsJava2D");
                }
                catch (Exception ex) {
                    allocErr = ex;
                }
            }
            this.biomeLandLayer = land;
            this.biomeWaterLayer = water;
            if (allocErr != null && (land == null || water == null)) {
                Main.println((String)("Biome layer alloc failed: " + allocErr));
            }
            if (this.biomeLandLayer != null) {
                if (s.antialiasing) {
                    this.biomeLandLayer.smooth(8);
                } else {
                    this.biomeLandLayer.noSmooth();
                }
            }
            if (this.biomeWaterLayer != null) {
                if (s.antialiasing) {
                    this.biomeWaterLayer.smooth(8);
                } else {
                    this.biomeWaterLayer.noSmooth();
                }
            }
            return this.biomeLandLayer != null && this.biomeWaterLayer != null;
        }

        private void ensureBiomeLayer(PApplet app, RenderSettings s) {
            boolean settingsChanged;
            if (this.model == null || this.model.cells == null || this.model.cells.isEmpty() || this.model.biomeTypes == null) {
                this.biomeLandLayer = null;
                this.biomeWaterLayer = null;
                return;
            }
            if (app == null) {
                return;
            }
            int[] biomeScaledCols = this.buildBiomeScaledColors(s);
            int targetW = app.g != null ? app.g.width : app.width;
            int targetH = app.g != null ? app.g.height : app.height;
            int hash = this.biomeSettingsHash(s, biomeScaledCols);
            boolean sizeChanged = this.biomeLandLayer == null || this.biomeWaterLayer == null || this.biomeLayerW != targetW || this.biomeLayerH != targetH;
            boolean viewChanged = this.biomeLandLayer == null || Main.abs((float)(this.biomeLayerZoom - Main.this.viewport.zoom)) > 1.0E-4f || Main.abs((float)(this.biomeLayerCenterX - Main.this.viewport.centerX)) > 1.0E-4f || Main.abs((float)(this.biomeLayerCenterY - Main.this.viewport.centerY)) > 1.0E-4f;
            boolean bl = settingsChanged = this.biomeLandLayer == null || this.biomeLayerHash != hash || this.biomeLayerCellCount != this.model.cells.size() || this.biomeLayerBiomeCount != this.model.biomeTypes.size();
            if (sizeChanged) {
                boolean ok = this.allocBiomeLayers(app, s, targetW, targetH, true);
                this.biomeLayerW = targetW;
                this.biomeLayerH = targetH;
                if (!ok) {
                    return;
                }
            } else {
                if (this.biomeLandLayer != null) {
                    if (s.antialiasing) {
                        this.biomeLandLayer.smooth(8);
                    } else {
                        this.biomeLandLayer.noSmooth();
                    }
                }
                if (this.biomeWaterLayer != null) {
                    if (s.antialiasing) {
                        this.biomeWaterLayer.smooth(8);
                    } else {
                        this.biomeWaterLayer.noSmooth();
                    }
                }
            }
            if (this.biomeLandLayer == null || this.biomeWaterLayer == null) {
                return;
            }
            if (!(sizeChanged || viewChanged || settingsChanged)) {
                return;
            }
            boolean built = false;
            boolean triedFallback = false;
            int attempt = 0;
            while (attempt < 2 && !built) {
                block17: {
                    try {
                        this.biomeLandLayer.beginDraw();
                        this.biomeLandLayer.clear();
                        this.biomeLandLayer.pushMatrix();
                        this.biomeLandLayer.pushStyle();
                        Main.this.viewport.applyTransform(this.biomeLandLayer, this.biomeLandLayer.width, this.biomeLandLayer.height);
                        this.biomeWaterLayer.beginDraw();
                        this.biomeWaterLayer.clear();
                        this.biomeWaterLayer.pushMatrix();
                        this.biomeWaterLayer.pushStyle();
                        Main.this.viewport.applyTransform(this.biomeWaterLayer, this.biomeWaterLayer.width, this.biomeWaterLayer.height);
                        this.drawBiomeLayer(this.biomeLandLayer, this.biomeWaterLayer, biomeScaledCols);
                        this.biomeLandLayer.popStyle();
                        this.biomeLandLayer.popMatrix();
                        this.biomeLandLayer.endDraw();
                        this.biomeWaterLayer.popStyle();
                        this.biomeWaterLayer.popMatrix();
                        this.biomeWaterLayer.endDraw();
                        built = true;
                    }
                    catch (Exception ex) {
                        Main.println((String)("Biome layer build failed: " + ex));
                        this.biomeLandLayer = null;
                        this.biomeWaterLayer = null;
                        if (triedFallback) break block17;
                        triedFallback = true;
                        if (!this.allocBiomeLayers(app, s, targetW, targetH, false)) break;
                    }
                }
                ++attempt;
            }
            if (!built) {
                return;
            }
            this.biomeLayerHash = hash;
            this.biomeLayerZoom = Main.this.viewport.zoom;
            this.biomeLayerCenterX = Main.this.viewport.centerX;
            this.biomeLayerCenterY = Main.this.viewport.centerY;
            this.biomeLayerCellCount = this.model.cells.size();
            this.biomeLayerBiomeCount = this.model.biomeTypes.size();
            this.biomeDirty = false;
        }

        private void drawBiomeLayer(PGraphics landG, PGraphics waterG, int[] biomeScaledCols) {
            if (this.model.cells == null || this.model.cells.isEmpty()) {
                return;
            }
            this.model.ensureCellNeighborsComputed();
            int n = this.model.cells.size();
            landG.noStroke();
            waterG.noStroke();
            int ci = 0;
            while (ci < n) {
                int col;
                int biomeIdx;
                Cell c = this.model.cells.get(ci);
                if (c != null && c.vertices != null && c.vertices.size() >= 3 && (biomeIdx = c.biomeId) >= 0 && biomeIdx < biomeScaledCols.length && (col = biomeScaledCols[biomeIdx]) != 0) {
                    boolean underwater = c.elevation < Main.this.seaLevel;
                    PGraphics tgt = underwater ? waterG : landG;
                    tgt.fill(col, 255.0f);
                    tgt.beginShape();
                    for (PVector v : c.vertices) {
                        tgt.vertex(v.x, v.y);
                    }
                    tgt.endShape(2);
                }
                ++ci;
            }
        }

        private void ensureElevationLightLayer(PApplet app, RenderSettings s, float seaLevel) {
            boolean settingsChanged;
            if (this.model == null || this.model.cells == null || this.model.cells.isEmpty()) {
                this.elevationLightLayer = null;
                return;
            }
            if (app == null) {
                return;
            }
            int targetW = app.g != null ? app.g.width : app.width;
            int targetH = app.g != null ? app.g.height : app.height;
            int hash = this.elevationLightSettingsHash(s);
            boolean sizeChanged = this.elevationLightLayer == null || this.elevationLightW != targetW || this.elevationLightH != targetH;
            boolean viewChanged = this.elevationLightLayer == null || Main.abs((float)(this.elevationLightZoom - Main.this.viewport.zoom)) > 1.0E-4f || Main.abs((float)(this.elevationLightCenterX - Main.this.viewport.centerX)) > 1.0E-4f || Main.abs((float)(this.elevationLightCenterY - Main.this.viewport.centerY)) > 1.0E-4f;
            boolean bl = settingsChanged = this.elevationLightLayer == null || this.elevationLightHashVal != hash || Main.abs((float)(this.elevationLightSeaLevel - seaLevel)) > 1.0E-6f || this.elevationLightCellCount != this.model.cells.size() || Main.this.currentTool == Tool.EDIT_ELEVATION;
            if (sizeChanged) {
                try {
                    this.elevationLightLayer = app.createGraphics(targetW, targetH, "processing.awt.PGraphicsJava2D");
                }
                catch (Exception ex) {
                    Main.println((String)("Elevation light layer alloc failed: " + ex));
                    this.elevationLightLayer = null;
                }
                this.elevationLightW = targetW;
                this.elevationLightH = targetH;
                if (this.elevationLightLayer != null) {
                    if (s.antialiasing) {
                        this.elevationLightLayer.smooth(8);
                    } else {
                        this.elevationLightLayer.noSmooth();
                    }
                }
            } else if (this.elevationLightLayer != null) {
                if (s.antialiasing) {
                    this.elevationLightLayer.smooth(8);
                } else {
                    this.elevationLightLayer.noSmooth();
                }
            }
            if (this.elevationLightLayer == null) {
                return;
            }
            if (!(this.lightDirty || sizeChanged || viewChanged || settingsChanged)) {
                return;
            }
            try {
                this.elevationLightLayer.beginDraw();
                this.elevationLightLayer.clear();
                this.elevationLightLayer.background(255);
                this.elevationLightLayer.pushMatrix();
                this.elevationLightLayer.pushStyle();
                Main.this.viewport.applyTransform(this.elevationLightLayer, this.elevationLightLayer.width, this.elevationLightLayer.height);
                this.drawElevationLightLayer(this.elevationLightLayer, s, seaLevel);
                this.elevationLightLayer.popStyle();
                this.elevationLightLayer.popMatrix();
                this.elevationLightLayer.endDraw();
            }
            catch (Exception ex) {
                Main.println((String)("Elevation light layer build failed: " + ex));
                this.elevationLightLayer = null;
                return;
            }
            float dither = Main.max((float)0.0f, (float)s.elevationLightDitherPx);
            if (dither > 0.001f) {
                if (s.elevationLightDitherScaleWithZoom) {
                    float ref = s.elevationLightDitherRefZoom > 1.0E-6f ? s.elevationLightDitherRefZoom : 600.0f;
                    dither *= Main.max((float)1.0E-6f, (float)Main.this.viewport.zoom) / ref;
                }
                this.applyLightDither(this.elevationLightLayer, dither);
            }
            this.elevationLightHashVal = hash;
            this.elevationLightZoom = Main.this.viewport.zoom;
            this.elevationLightCenterX = Main.this.viewport.centerX;
            this.elevationLightCenterY = Main.this.viewport.centerY;
            this.elevationLightSeaLevel = seaLevel;
            this.elevationLightCellCount = this.model.cells.size();
            this.lightDirty = false;
        }

        private void drawElevationLightLayer(PGraphics g, RenderSettings s, float seaLevel) {
            float az = Main.radians((float)s.elevationLightAzimuthDeg);
            float alt = Main.radians((float)s.elevationLightAltitudeDeg);
            PVector lightDir = new PVector(Main.cos((float)alt) * Main.cos((float)az), Main.cos((float)alt) * Main.sin((float)az), Main.sin((float)alt));
            lightDir.normalize();
            float seamW = 1.0f / Main.max((float)0.1f, (float)Main.this.viewport.zoom);
            g.strokeWeight(seamW);
            int ci = 0;
            while (ci < this.model.cells.size()) {
                float light;
                float a;
                Cell c = this.model.cells.get(ci);
                if (c != null && c.vertices != null && c.vertices.size() >= 3 && !(c.elevation < seaLevel) && !((a = s.elevationLightAlpha01 * (1.0f - (light = ElevationRenderer.computeLightForCell(this.model, ci, lightDir)))) <= 1.0E-4f)) {
                    float shade = Main.constrain((float)(255.0f - a * 255.0f), (float)0.0f, (float)255.0f);
                    g.stroke(shade);
                    g.fill(shade);
                    g.beginShape();
                    for (PVector v : c.vertices) {
                        g.vertex(v.x, v.y);
                    }
                    g.endShape(2);
                }
                ++ci;
            }
        }

        private void applyLightDither(PGraphics g, float radius) {
            if (g == null || radius <= 1.0E-4f) {
                return;
            }
            g.loadPixels();
            int w = g.width;
            int h = g.height;
            int total = w * h;
            if (total <= 0) {
                return;
            }
            int swaps = total / 2;
            int i = 0;
            while (i < swaps) {
                int idx = (int)Main.this.random(total);
                int x = idx % w;
                int y = idx / w;
                int dx = Main.round((float)Main.this.random(-radius, radius));
                int dy = Main.round((float)Main.this.random(-radius, radius));
                int x2 = Main.constrain((int)(x + dx), (int)0, (int)(w - 1));
                int y2 = Main.constrain((int)(y + dy), (int)0, (int)(h - 1));
                int idx2 = y2 * w + x2;
                int tmp = g.pixels[idx];
                g.pixels[idx] = g.pixels[idx2];
                g.pixels[idx2] = tmp;
                ++i;
            }
            g.updatePixels();
        }

        public PImage generateNoiseTexture() {
            PImage im = new PImage(1000, 1000);
            im.loadPixels();
            int x = 0;
            while (x < im.width) {
                int y = 0;
                while (y < im.height) {
                    im.pixels[y * im.width + x] = Main.this.color(Main.this.random(256.0f));
                    ++y;
                }
                ++x;
            }
            im.updatePixels();
            return im;
        }

        public void resetRenderPrep(boolean forceAllDirty) {
            this.renderPrepCompleted = 0;
            this.renderPrepTotal = 0;
            if (forceAllDirty) {
                this.fontPrepNeeded = true;
                this.lightDirty = true;
                this.zoneDirty = true;
                this.biomeDirty = true;
                this.coastDirty = true;
            }
        }

        public boolean hasAnyRenderCache() {
            return this.coastLayer != null || this.biomeLandLayer != null || this.biomeWaterLayer != null || this.zoneLayer != null || this.elevationLightLayer != null;
        }

        public boolean isRenderWorkNeeded() {
            return this.fontPrepNeeded || this.coastDirty || this.biomeDirty || this.zoneDirty || this.lightDirty || !this.hasAnyRenderCache();
        }

        public boolean rebuildCheapLayersImmediate(PApplet app, RenderSettings s, float seaLevel) {
            if (app == null || s == null) {
                return false;
            }
            boolean did = false;
            if (this.biomeDirty) {
                this.ensureBiomeLayer(app, s);
                this.biomeDirty = false;
                did = true;
            }
            if (this.zoneDirty) {
                this.ensureZoneLayer(app, s);
                this.zoneDirty = false;
                did = true;
            }
            if (this.lightDirty) {
                this.ensureElevationLightLayer(app, s, seaLevel);
                this.lightDirty = false;
                did = true;
            }
            return did;
        }

        public int getRenderPrepStage() {
            return this.renderPrepCompleted;
        }

        public int getRenderPrepStageCount() {
            return Main.max((int)this.renderPrepTotal, (int)(this.renderPrepCompleted + this.pendingStageCount()));
        }

        public String getRenderPrepStageLabel() {
            int st = this.nextPendingStage();
            switch (st) {
                case 0: {
                    return "fonts";
                }
                case 1: {
                    return "coastlines";
                }
                case 2: {
                    return "biomes";
                }
                case 3: {
                    return "zones";
                }
                case 4: {
                    return "elevation light";
                }
            }
            return "";
        }

        private int pendingStageCount() {
            int c = 0;
            if (this.fontPrepNeeded) {
                ++c;
            }
            if (this.coastDirty) {
                ++c;
            }
            if (this.biomeDirty) {
                ++c;
            }
            if (this.zoneDirty) {
                ++c;
            }
            if (this.lightDirty) {
                ++c;
            }
            return c;
        }

        private int nextPendingStage() {
            if (this.fontPrepNeeded) {
                return 0;
            }
            if (this.coastDirty) {
                return 1;
            }
            if (this.biomeDirty) {
                return 2;
            }
            if (this.zoneDirty) {
                return 3;
            }
            if (this.lightDirty) {
                return 4;
            }
            return -1;
        }

        public boolean stepRenderPrep(PApplet app, RenderSettings s, float seaLevel) {
            if (!this.isRenderWorkNeeded()) {
                this.renderPrepTotal = 0;
                this.renderPrepCompleted = 0;
                return true;
            }
            this.renderPrepTotal = Main.max((int)this.renderPrepTotal, (int)(this.renderPrepCompleted + this.pendingStageCount()));
            int stage = this.nextPendingStage();
            if (stage == -1) {
                this.renderPrepCompleted = this.renderPrepTotal;
                return true;
            }
            switch (stage) {
                case 0: {
                    this.warmLabelFonts(app, s);
                    this.fontPrepNeeded = false;
                    ++this.renderPrepCompleted;
                    break;
                }
                case 1: {
                    this.ensureCoastLayer(app, s, seaLevel);
                    this.coastDirty = false;
                    ++this.renderPrepCompleted;
                    break;
                }
                case 2: {
                    this.ensureBiomeLayer(app, s);
                    this.biomeDirty = false;
                    ++this.renderPrepCompleted;
                    break;
                }
                case 3: {
                    this.ensureZoneLayer(app, s);
                    this.zoneDirty = false;
                    ++this.renderPrepCompleted;
                    break;
                }
                case 4: {
                    this.ensureElevationLightLayer(app, s, seaLevel);
                    this.lightDirty = false;
                    ++this.renderPrepCompleted;
                }
            }
            return this.pendingStageCount() == 0;
        }

        public float renderPrepProgress() {
            int total = Main.max((int)this.renderPrepTotal, (int)(this.renderPrepCompleted + this.pendingStageCount()));
            if (total <= 0) {
                return 1.0f;
            }
            return Main.constrain((float)((float)this.renderPrepCompleted / (float)total), (float)0.0f, (float)1.0f);
        }

        private int[] buildBiomeScaledColors(RenderSettings s) {
            ZoneType zt;
            int i;
            if (this.model == null || this.model.biomeTypes == null || this.model.biomeTypes.isEmpty()) {
                return null;
            }
            int n = this.model.biomeTypes.size();
            float satScale = s != null ? s.biomeSatScale01 : 1.0f;
            float briScale = s != null ? s.biomeBriScale01 : 1.0f;
            boolean needRebuild = false;
            if (this.cachedBiomeScaledColors == null || this.cachedBiomeScaledColors.length != n) {
                needRebuild = true;
            }
            if (this.cachedBiomeSrcCols == null || this.cachedBiomeSrcCols.length != n) {
                needRebuild = true;
            }
            if (!needRebuild && (Main.abs((float)(this.cachedBiomeSatScale - satScale)) > 1.0E-6f || Main.abs((float)(this.cachedBiomeBriScale - briScale)) > 1.0E-6f)) {
                needRebuild = true;
            }
            if (!needRebuild) {
                i = 0;
                while (i < n) {
                    int src;
                    zt = this.model.biomeTypes.get(i);
                    int n2 = src = zt != null ? zt.col : -1;
                    if (this.cachedBiomeSrcCols[i] != src) {
                        needRebuild = true;
                        break;
                    }
                    ++i;
                }
            }
            if (!needRebuild) {
                return this.cachedBiomeScaledColors;
            }
            this.cachedBiomeScaledColors = new int[n];
            this.cachedBiomeSrcCols = new int[n];
            this.cachedBiomeSatScale = satScale;
            this.cachedBiomeBriScale = briScale;
            i = 0;
            while (i < n) {
                zt = this.model.biomeTypes.get(i);
                if (zt == null) {
                    this.cachedBiomeScaledColors[i] = -1;
                    this.cachedBiomeSrcCols[i] = -1;
                } else {
                    this.cachedBiomeSrcCols[i] = zt.col;
                    Main.this.rgbToHSB01(zt.col, this.hsbScratch);
                    float sat = Main.constrain((float)(this.hsbScratch[1] * satScale), (float)0.0f, (float)1.0f);
                    float bri = Main.constrain((float)(this.hsbScratch[2] * briScale), (float)0.0f, (float)1.0f);
                    this.cachedBiomeScaledColors[i] = Main.this.hsb01ToARGB(this.hsbScratch[0], sat, bri, 1.0f);
                }
                ++i;
            }
            return this.cachedBiomeScaledColors;
        }

        private int[] buildZoneStrokeColors(RenderSettings s) {
            MapModel.MapZone z;
            int i;
            if (this.model == null || this.model.zones == null || this.model.zones.isEmpty() || s == null) {
                return null;
            }
            int n = this.model.zones.size();
            float satScale = s.zoneStrokeSatScale01;
            float briScale = s.zoneStrokeBriScale01;
            boolean needRebuild = false;
            if (this.cachedZoneStrokeColors == null || this.cachedZoneStrokeColors.length != n) {
                needRebuild = true;
            }
            if (this.cachedZoneSrcCols == null || this.cachedZoneSrcCols.length != n) {
                needRebuild = true;
            }
            if (!needRebuild && (Main.abs((float)(this.cachedZoneSatScale - satScale)) > 1.0E-6f || Main.abs((float)(this.cachedZoneBriScale - briScale)) > 1.0E-6f)) {
                needRebuild = true;
            }
            if (!needRebuild) {
                i = 0;
                while (i < n) {
                    int src;
                    z = this.model.zones.get(i);
                    int n2 = src = z != null ? z.col : -1;
                    if (this.cachedZoneSrcCols[i] != src) {
                        needRebuild = true;
                        break;
                    }
                    ++i;
                }
            }
            if (!needRebuild) {
                return this.cachedZoneStrokeColors;
            }
            this.cachedZoneStrokeColors = new int[n];
            this.cachedZoneSrcCols = new int[n];
            this.cachedZoneSatScale = satScale;
            this.cachedZoneBriScale = briScale;
            i = 0;
            while (i < n) {
                z = this.model.zones.get(i);
                if (z == null) {
                    this.cachedZoneStrokeColors[i] = -1;
                    this.cachedZoneSrcCols[i] = -1;
                } else {
                    this.cachedZoneSrcCols[i] = z.col;
                    Main.this.rgbToHSB01(z.col, this.hsbScratch);
                    float sat = Main.constrain((float)(this.hsbScratch[1] * satScale), (float)0.0f, (float)1.0f);
                    float bri = Main.constrain((float)(this.hsbScratch[2] * briScale), (float)0.0f, (float)1.0f);
                    this.cachedZoneStrokeColors[i] = Main.this.hsb01ToARGB(this.hsbScratch[0], sat, bri, 1.0f);
                }
                ++i;
            }
            return this.cachedZoneStrokeColors;
        }

        private class CapInfo {
            SegInfo seg;
            boolean atStart;
            float r;
            int col;

            CapInfo(SegInfo seg, boolean atStart, float r, int col) {
                this.seg = seg;
                this.atStart = atStart;
                this.r = r;
                this.col = col;
            }
        }

        private class SegInfo {
            PVector a;
            PVector b;
            PVector origA;
            PVector origB;
            float w;
            int col;
            int zoneId;

            SegInfo(PVector a, PVector b, PVector origA, PVector origB, float w, int col, int zoneId) {
                this.a = a;
                this.b = b;
                this.origA = origA;
                this.origB = origB;
                this.w = w;
                this.col = col;
                this.zoneId = zoneId;
            }
        }
    }

    class Path {
        ArrayList<ArrayList<PVector>> routes = new ArrayList();
        int typeId = 0;
        String name = "";
        String comment = "";

        Path() {
        }

        public void addRoute(ArrayList<PVector> pts) {
            if (pts == null || pts.size() < 2) {
                return;
            }
            ArrayList<PVector> copy = new ArrayList<PVector>();
            for (PVector v : pts) {
                copy.add(v.copy());
            }
            this.routes.add(copy);
        }

        public void draw(PApplet app, float baseWeight, boolean taper, HashMap<String, Float> segWeights, int pathIndex, boolean showNodes, float sat) {
            if (this.routes.isEmpty()) {
                return;
            }
            float baseAlpha = app.alpha(app.g.strokeColor) / 255.0f;
            float alphaScale = sat;
            int ri = 0;
            while (ri < this.routes.size()) {
                ArrayList<PVector> seg = this.routes.get(ri);
                if (seg != null && !seg.isEmpty()) {
                    PVector a;
                    if (seg.size() == 1) {
                        if (showNodes) {
                            float r = 3.0f / Main.this.viewport.zoom;
                            app.pushStyle();
                            app.fill(app.g.strokeColor);
                            a = seg.get(0);
                            app.ellipse(a.x, a.y, r, r);
                            app.popStyle();
                        }
                    } else {
                        PVector b;
                        int i = 0;
                        while (i < seg.size() - 1) {
                            a = seg.get(i);
                            b = seg.get(i + 1);
                            String key = String.valueOf(pathIndex) + ":" + ri + ":" + i;
                            float w = baseWeight;
                            if (taper && segWeights != null && segWeights.containsKey(key)) {
                                w = segWeights.get(key).floatValue();
                            }
                            app.pushStyle();
                            int rgb = app.g.strokeColor;
                            float alpha = Main.constrain((float)(baseAlpha * alphaScale), (float)0.0f, (float)1.0f);
                            int col = app.color((float)(rgb >> 16 & 0xFF), (float)(rgb >> 8 & 0xFF), (float)(rgb & 0xFF), alpha * 255.0f);
                            app.stroke(col);
                            app.strokeCap(2);
                            app.strokeJoin(2);
                            float sw = Main.max((float)1.5f, (float)w) / Main.this.viewport.zoom;
                            app.strokeWeight(sw);
                            app.line(a.x, a.y, b.x, b.y);
                            float rad = sw * 0.5f;
                            app.noStroke();
                            app.fill(col);
                            app.ellipse(a.x, a.y, rad * 2.0f, rad * 2.0f);
                            app.ellipse(b.x, b.y, rad * 2.0f, rad * 2.0f);
                            app.popStyle();
                            ++i;
                        }
                        if (showNodes) {
                            float r = 2.0f / Main.this.viewport.zoom;
                            app.pushStyle();
                            app.noStroke();
                            app.fill(app.g.strokeColor);
                            a = seg.get(0);
                            b = seg.get(seg.size() - 1);
                            app.ellipse(a.x, a.y, r, r);
                            app.ellipse(b.x, b.y, r, r);
                            app.popStyle();
                        }
                    }
                }
                ++ri;
            }
        }

        public void drawPreview(PApplet app, ArrayList<PVector> seg, int strokeCol, float weightPx) {
            if (seg == null || seg.isEmpty()) {
                return;
            }
            if (seg.size() == 1) {
                float r = 3.0f / Main.this.viewport.zoom;
                app.pushStyle();
                app.noStroke();
                app.fill(strokeCol);
                PVector a = seg.get(0);
                app.ellipse(a.x, a.y, r, r);
                app.popStyle();
                return;
            }
            app.pushStyle();
            app.noFill();
            app.stroke(strokeCol);
            app.strokeCap(2);
            app.strokeJoin(2);
            app.strokeWeight(Main.max((float)2.0f, (float)weightPx) / Main.this.viewport.zoom);
            int i = 0;
            while (i < seg.size() - 1) {
                PVector a = seg.get(i);
                PVector b = seg.get(i + 1);
                app.line(a.x, a.y, b.x, b.y);
                ++i;
            }
            app.pushStyle();
            app.noStroke();
            app.fill(strokeCol);
            float r = 3.0f / Main.this.viewport.zoom;
            PVector start = seg.get(0);
            PVector end = seg.get(seg.size() - 1);
            app.ellipse(start.x, start.y, r, r);
            app.ellipse(end.x, end.y, r, r);
            app.popStyle();
            app.popStyle();
        }

        public int routeCount() {
            return this.routes.size();
        }

        public int segmentCount() {
            int count = 0;
            for (ArrayList<PVector> r : this.routes) {
                if (r == null) continue;
                count += Main.max((int)0, (int)(r.size() - 1));
            }
            return count;
        }

        public float totalLength() {
            float len = 0.0f;
            for (ArrayList<PVector> seg : this.routes) {
                if (seg == null) continue;
                int i = 0;
                while (i < seg.size() - 1) {
                    PVector a = seg.get(i);
                    PVector b = seg.get(i + 1);
                    float dx = b.x - a.x;
                    float dy = b.y - a.y;
                    len += Main.sqrt((float)(dx * dx + dy * dy));
                    ++i;
                }
            }
            return len;
        }
    }

    static enum PathRouteMode {
        ENDS,
        PATHFIND;

    }

    class PathRowLayout {
        int index;
        IntRect selectRect;
        IntRect nameRect;
        IntRect delRect;
        IntRect typeRect;
        int statsY;
        int statsH;

        PathRowLayout() {
        }
    }

    class PathType {
        String name;
        int col;
        float hue01;
        float sat01;
        float bri01;
        float weightPx;
        float minWeightPx;
        boolean taperOn = false;
        PathRouteMode routeMode = PathRouteMode.PATHFIND;
        float slopeBias = 0.0f;
        boolean avoidWater = true;

        PathType(String name, int col, float weightPx, float minWeightPx, PathRouteMode routeMode, float slopeBias, boolean avoidWater, boolean taperOn) {
            this.name = name;
            this.weightPx = weightPx;
            this.minWeightPx = Main.max((float)0.5f, (float)minWeightPx);
            this.routeMode = routeMode != null ? routeMode : PathRouteMode.PATHFIND;
            this.slopeBias = slopeBias;
            this.avoidWater = avoidWater;
            this.taperOn = taperOn;
            this.setFromColor(col);
        }

        public void setFromColor(int c) {
            this.col = c;
            float[] hsb = new float[3];
            Main.this.rgbToHSB01(c, hsb);
            this.hue01 = hsb[0];
            this.sat01 = hsb[1];
            this.bri01 = hsb[2];
        }

        public void updateColorFromHSB() {
            this.col = Main.this.hsb01ToARGB(this.hue01, this.sat01, this.bri01, 1.0f);
        }
    }

    class PathTypePreset {
        String name;
        int col;
        float weightPx;
        float minWeightPx;
        PathRouteMode routeMode;
        float slopeBias;
        boolean avoidWater;
        boolean taperOn;

        PathTypePreset(String name, int col, float weightPx, float minWeightPx, PathRouteMode routeMode, float slopeBias, boolean avoidWater, boolean taperOn) {
            this.name = name;
            this.col = col;
            this.weightPx = weightPx;
            this.minWeightPx = minWeightPx;
            this.routeMode = routeMode;
            this.slopeBias = slopeBias;
            this.avoidWater = avoidWater;
            this.taperOn = taperOn;
        }
    }

    class PathsLayout {
        IntRect panel;
        int titleY;
        IntRect generateBtn;
        IntRect typeAddBtn;
        IntRect typeRemoveBtn;
        IntRect routeSlider;
        IntRect flattestSlider;
        IntRect avoidWaterCheck;
        IntRect eraserBtn;
        IntRect taperCheck;
        IntRect typeMinWeightSlider;
        ArrayList<IntRect> typeSwatches = new ArrayList();
        IntRect nameField;
        IntRect commentField;
        IntRect typeHueSlider;
        IntRect typeSatSlider;
        IntRect typeBriSlider;
        IntRect typeWeightSlider;

        PathsLayout() {
        }
    }

    class PathsListLayout {
        IntRect panel;
        int titleY;
        IntRect newBtn;
        IntRect deselectBtn;
        ArrayList<PathRowLayout> rows = new ArrayList();
        int rowsStartY;
        int rowsViewH;
        float contentH;
        IntRect scrollbar;

        PathsListLayout() {
        }
    }

    static enum PlacementMode {
        GRID,
        POISSON,
        HEX;

    }

    static enum RenderFillType {
        RENDER_FILL_COLOR,
        RENDER_FILL_PATTERN,
        RENDER_FILL_PATTERN_BG;

    }

    class RenderLayout {
        IntRect panel;
        int titleY;
        IntRect headerBase;
        IntRect headerBiomes;
        IntRect headerShading;
        IntRect headerCoastlines;
        IntRect headerElevation;
        IntRect headerPaths;
        IntRect headerZones;
        IntRect headerStructures;
        IntRect headerLabels;
        IntRect headerGeneral;
        IntRect[] landHSB = new IntRect[3];
        IntRect[] waterHSB = new IntRect[3];
        IntRect cellBordersAlphaSlider;
        IntRect cellBordersSizeSlider;
        IntRect cellBordersScaleCheckbox;
        IntRect backgroundNoiseSlider;
        IntRect biomeFillAlphaSlider;
        IntRect biomeSatSlider;
        IntRect biomeBriSlider;
        ArrayList<IntRect> biomeFillTypeButtons = new ArrayList();
        IntRect biomeOutlineSizeSlider;
        IntRect biomeOutlineAlphaSlider;
        IntRect biomeUnderwaterAlphaSlider;
        IntRect biomeOutlineScaleCheckbox;
        IntRect waterDepthAlphaSlider;
        IntRect lightAlphaSlider;
        IntRect lightAzimuthSlider;
        IntRect lightAltitudeSlider;
        IntRect lightDitherSlider;
        IntRect lightDitherScaleCheckbox;
        IntRect waterContourSizeSlider;
        IntRect waterRippleCountSlider;
        IntRect waterRippleDistanceSlider;
        IntRect[] waterContourHSB = new IntRect[3];
        IntRect waterContourCoastAlphaSlider;
        IntRect waterCoastSizeSlider;
        IntRect waterCoastScaleCheckbox;
        IntRect waterCoastAboveZonesCheckbox;
        IntRect waterHatchAngleSlider;
        IntRect waterHatchLengthSlider;
        IntRect waterHatchSpacingSlider;
        IntRect waterHatchAlphaSlider;
        IntRect waterContourScaleCheckbox;
        IntRect waterRippleAlphaStartSlider;
        IntRect waterRippleAlphaEndSlider;
        IntRect elevationLinesCountSlider;
        IntRect elevationLinesAlphaSlider;
        IntRect elevationLinesSizeSlider;
        IntRect elevationLinesScaleCheckbox;
        IntRect pathsShowCheckbox;
        IntRect pathsScaleWithZoomCheckbox;
        IntRect pathSatSlider;
        IntRect pathBriSlider;
        IntRect zoneAlphaSlider;
        IntRect zoneSizeSlider;
        IntRect zoneSatSlider;
        IntRect zoneBriSlider;
        IntRect zoneScaleWithZoomCheckbox;
        IntRect structuresShowCheckbox;
        IntRect structuresMergeCheckbox;
        IntRect structuresShadowAlphaSlider;
        IntRect structuresScaleWithZoomCheckbox;
        IntRect labelsArbitraryCheckbox;
        IntRect labelsZonesCheckbox;
        IntRect labelsPathsCheckbox;
        IntRect labelsStructuresCheckbox;
        IntRect labelsOutlineAlphaSlider;
        IntRect labelsOutlineSizeSlider;
        IntRect labelsArbSizeSlider;
        IntRect labelsZoneSizeSlider;
        IntRect labelsPathSizeSlider;
        IntRect labelsStructSizeSlider;
        IntRect labelsFontSelector;
        IntRect labelsScaleWithZoomCheckbox;
        IntRect labelsOutlineScaleWithZoomCheckbox;
        IntRect exportPaddingSlider;
        IntRect antialiasCheckbox;
        IntRect presetSelector;
        IntRect presetApplyBtn;

        RenderLayout() {
        }
    }

    class RenderPreset {
        String name;
        RenderSettings values;

        RenderPreset(String name, RenderSettings values) {
            this.name = name;
            this.values = values;
        }
    }

    class RenderSettings {
        float landHue01 = 0.0f;
        float landSat01 = 0.0f;
        float landBri01 = 0.85f;
        float waterHue01 = 0.58f;
        float waterSat01 = 0.28f;
        float waterBri01 = 0.35f;
        float cellBorderAlpha01 = 0.0f;
        float cellBorderSizePx = 1.0f;
        boolean cellBorderScaleWithZoom = false;
        float cellBorderRefZoom = 600.0f;
        float backgroundNoiseAlpha01 = 0.0f;
        float biomeFillAlpha01 = 0.5f;
        float biomeSatScale01 = 1.0f;
        float biomeBriScale01 = 1.0f;
        RenderFillType biomeFillType = RenderFillType.RENDER_FILL_COLOR;
        String biomePatternName = "";
        float biomeOutlineSizePx = 0.0f;
        float biomeOutlineAlpha01 = 1.0f;
        boolean biomeOutlineScaleWithZoom = false;
        float biomeOutlineRefZoom = 600.0f;
        float biomeUnderwaterAlpha01 = 0.0f;
        float waterDepthAlpha01 = 0.5f;
        float elevationLightAlpha01 = 0.5f;
        float elevationLightAzimuthDeg = 220.0f;
        float elevationLightAltitudeDeg = 45.0f;
        float elevationLightDitherPx = 0.0f;
        boolean elevationLightDitherScaleWithZoom = false;
        float elevationLightDitherRefZoom = 600.0f;
        float waterContourSizePx = 2.0f;
        int waterRippleCount = 0;
        float waterRippleDistancePx = 5.0f;
        float waterContourHue01 = 0.0f;
        float waterContourSat01 = 0.0f;
        float waterContourBri01 = 0.0f;
        float waterContourAlpha01 = 1.0f;
        float waterCoastAlpha01 = 1.0f;
        float waterCoastSizePx = 2.0f;
        boolean waterCoastScaleWithZoom = false;
        boolean waterCoastAboveZones = false;
        boolean waterContourScaleWithZoom = false;
        float waterContourRefZoom = 600.0f;
        float waterRippleAlphaStart01 = 1.0f;
        float waterRippleAlphaEnd01 = 0.3f;
        float waterHatchAngleDeg = 0.0f;
        float waterHatchLengthPx = 0.0f;
        float waterHatchSpacingPx = 12.0f;
        float waterHatchAlpha01 = 0.0f;
        int elevationLinesCount = 0;
        ElevationLinesStyle elevationLinesStyle = ElevationLinesStyle.ELEV_LINES_BASIC;
        float elevationLinesAlpha01 = 0.3f;
        float elevationLinesSizePx = 1.0f;
        boolean elevationLinesScaleWithZoom = false;
        float elevationLinesRefZoom = 600.0f;
        float pathSatScale01 = 1.0f;
        float pathBriScale01 = 1.0f;
        boolean showPaths = true;
        boolean pathScaleWithZoom = false;
        float pathScaleRefZoom = 600.0f;
        float zoneStrokeAlpha01 = 0.5f;
        float zoneStrokeSizePx = 2.0f;
        float zoneStrokeSatScale01 = 0.5f;
        float zoneStrokeBriScale01 = 1.0f;
        boolean zoneStrokeScaleWithZoom = false;
        float zoneStrokeRefZoom = 600.0f;
        boolean showStructures = true;
        boolean mergeStructures = false;
        float structureSatScale01 = 1.0f;
        float structureAlphaScale01 = 1.0f;
        float structureShadowAlpha01 = 0.0f;
        boolean structureStrokeScaleWithZoom = false;
        float structureStrokeRefZoom = 600.0f;
        boolean showLabelsArbitrary = true;
        boolean showLabelsZones = true;
        boolean showLabelsPaths = true;
        boolean showLabelsStructures = true;
        float labelOutlineAlpha01 = 0.0f;
        float labelOutlineSizePx = 1.0f;
        float labelSizeArbPx = 12.0f;
        float labelSizeZonePx = 14.0f;
        float labelSizePathPx = 12.0f;
        float labelSizeStructPx = 12.0f;
        boolean labelScaleWithZoom = false;
        float labelScaleRefZoom = 1.0f;
        boolean labelOutlineScaleWithZoom = false;
        int labelFontIndex = 0;
        float exportPaddingPct = 0.015f;
        boolean antialiasing = true;
        int activePresetIndex = 0;

        RenderSettings() {
        }

        public RenderSettings copy() {
            RenderSettings c = new RenderSettings();
            c.landHue01 = this.landHue01;
            c.landSat01 = this.landSat01;
            c.landBri01 = this.landBri01;
            c.waterHue01 = this.waterHue01;
            c.waterSat01 = this.waterSat01;
            c.waterBri01 = this.waterBri01;
            c.cellBorderAlpha01 = this.cellBorderAlpha01;
            c.cellBorderSizePx = this.cellBorderSizePx;
            c.cellBorderScaleWithZoom = this.cellBorderScaleWithZoom;
            c.cellBorderRefZoom = this.cellBorderRefZoom;
            c.backgroundNoiseAlpha01 = this.backgroundNoiseAlpha01;
            c.biomeFillAlpha01 = this.biomeFillAlpha01;
            c.biomeSatScale01 = this.biomeSatScale01;
            c.biomeBriScale01 = this.biomeBriScale01;
            c.biomeFillType = this.biomeFillType;
            c.biomePatternName = this.biomePatternName;
            c.biomeOutlineSizePx = this.biomeOutlineSizePx;
            c.biomeOutlineAlpha01 = this.biomeOutlineAlpha01;
            c.biomeOutlineScaleWithZoom = this.biomeOutlineScaleWithZoom;
            c.biomeOutlineRefZoom = this.biomeOutlineRefZoom;
            c.biomeUnderwaterAlpha01 = this.biomeUnderwaterAlpha01;
            c.waterDepthAlpha01 = this.waterDepthAlpha01;
            c.elevationLightAlpha01 = this.elevationLightAlpha01;
            c.elevationLightAzimuthDeg = this.elevationLightAzimuthDeg;
            c.elevationLightAltitudeDeg = this.ele