/*
 * Decompiled with CFR 0.152.
 */
package beads;

import beads.AudioContext;
import beads.UGen;

public class SignalReporter
extends UGen {
    private long interval = 44100L;
    private long index = 44100L;
    private long count = 0L;
    private long total = 0L;
    private float flInt;
    protected String name = "";

    public SignalReporter(AudioContext context, float reportInterval, String name) {
        super(context, 1, 0);
        this.setInterval(reportInterval);
        this.index = this.interval;
        this.name = name;
        context.out.addDependent(this);
    }

    public SignalReporter(float reportInterval, String name) {
        this(SignalReporter.getDefaultContext(), reportInterval, name);
    }

    public void setInterval(float reportInterval) {
        if (reportInterval <= 0.0f) {
            reportInterval = 1000.0f;
        }
        this.flInt = reportInterval;
        this.interval = (long)this.context.msToSamples(reportInterval);
    }

    public float getInterval() {
        return this.flInt;
    }

    @Override
    public void calculateBuffer() {
        if (this.index >= this.interval) {
            this.notify(this.count, this.bufIn[0][0]);
            ++this.count;
            this.index -= this.interval;
        }
        this.total += (long)this.bufferSize;
        this.index += (long)this.bufferSize;
    }

    public void notify(long count, float value) {
        System.out.println("SignalReporter " + this.name + ", report #" + count + ": " + value);
    }

    public void resetCount() {
        this.count = 0L;
    }
}

