/*
 * Decompiled with CFR 0.152.
 */
package beads;

import beads.AudioContext;
import beads.AudioSegmenter;
import beads.Buffer;
import beads.HanningWindow;
import beads.TimeStamp;

public class ShortFrameSegmenter
extends AudioSegmenter {
    private int chunkSize;
    private int hopSize;
    private float[][] chunks;
    private int cycleLen;
    private int count;
    private TimeStamp lastTimeStamp;
    private TimeStamp beginningTimeStamp;
    private Buffer window;

    public ShortFrameSegmenter(AudioContext context) {
        super(context);
        this.hopSize = this.chunkSize = context.getBufferSize();
        this.window = new HanningWindow().getDefault();
        this.count = 0;
        this.setupBuffers();
    }

    public int getChunkSize() {
        return this.chunkSize;
    }

    public void setChunkSize(int chunkSize) {
        this.chunkSize = chunkSize;
        this.setupBuffers();
    }

    public int getHopSize() {
        return this.hopSize;
    }

    public void setHopSize(int hopSize) {
        this.hopSize = hopSize;
        this.setupBuffers();
    }

    public void setWindow(Buffer window) {
        this.window = window;
    }

    private void setupBuffers() {
        int requiredBuffers = (int)Math.ceil((float)this.chunkSize / (float)this.hopSize);
        this.chunks = new float[requiredBuffers][this.chunkSize];
        this.cycleLen = requiredBuffers * this.hopSize;
    }

    @Override
    public void calculateBuffer() {
        if (this.beginningTimeStamp == null) {
            this.resetTimeStamp();
        }
        for (int i = 0; i < this.bufferSize; ++i) {
            for (int j = 0; j < this.chunks.length; ++j) {
                int pos = this.count - j * this.hopSize;
                if (pos < 0) {
                    pos += this.cycleLen;
                }
                if (pos >= this.chunkSize) continue;
                this.chunks[j][pos] = this.bufIn[0][i] * this.window.getValueFraction((float)pos / (float)(this.chunkSize - 1));
            }
            ++this.count;
            if (this.count % this.hopSize == 0) {
                TimeStamp nextTimeStamp = TimeStamp.add(this.context, this.context.generateTimeStamp(i), this.beginningTimeStamp);
                int chunkIndex = this.count / this.hopSize - 1;
                this.segment(this.lastTimeStamp, nextTimeStamp, this.chunks[chunkIndex]);
                this.lastTimeStamp = nextTimeStamp;
            }
            this.count %= this.cycleLen;
        }
    }

    @Override
    public void resetTimeStamp() {
        this.lastTimeStamp = this.context.generateTimeStamp(0);
        this.beginningTimeStamp = this.context.generateTimeStamp(0);
        this.count = 0;
    }

    @Override
    public void setLastTimeStamp(TimeStamp ts) {
        this.lastTimeStamp = ts;
        this.count = 0;
    }

    @Override
    public void setBeginningTimeStamp(TimeStamp ts) {
        this.beginningTimeStamp = ts;
        this.count = 0;
    }
}

