/*
 * Decompiled with CFR 0.152.
 */
package beads;

import beads.AudioContext;
import beads.AudioUtils;
import beads.Bead;
import beads.Sample;
import beads.Static;
import beads.UGen;

public class SamplePlayer
extends UGen {
    public static final float ADAPTIVE_INTERP_LOW_THRESH = 0.5f;
    public static final float ADAPTIVE_INTERP_HIGH_THRESH = 2.5f;
    protected Sample sample;
    protected double position;
    protected UGen positionEnvelope;
    protected UGen rateEnvelope;
    protected double positionIncrement;
    protected boolean forwards;
    protected EnvelopeType envelopeType;
    protected InterpolationType interpolationType;
    protected UGen loopStartEnvelope;
    protected UGen loopEndEnvelope;
    protected LoopType loopType;
    protected float loopCrossFade;
    protected boolean startLoop;
    protected boolean killOnEnd;
    protected float rate;
    protected float loopStart;
    protected float loopEnd;
    protected float[] frame;
    private Bead endListener;
    private boolean[] isLooping;

    public SamplePlayer(AudioContext context, int outs) {
        super(context, outs);
        this.rateEnvelope = new Static(context, 1.0f);
        this.positionEnvelope = null;
        this.envelopeType = EnvelopeType.FINE;
        this.interpolationType = InterpolationType.ADAPTIVE;
        this.loopType = LoopType.NO_LOOP_FORWARDS;
        this.forwards = true;
        this.killOnEnd = true;
        this.loopStartEnvelope = new Static(context, 0.0f);
        this.loopEndEnvelope = new Static(context, 0.0f);
        this.positionIncrement = context.samplesToMs(1.0);
        this.loopCrossFade = 0.0f;
        this.isLooping = new boolean[this.bufferSize];
    }

    public SamplePlayer(int outs) {
        this(SamplePlayer.getDefaultContext(), outs);
    }

    public SamplePlayer(AudioContext context, Sample buffer) {
        this(context, buffer.getNumChannels());
        this.setSample(buffer);
        this.loopEndEnvelope.setValue((float)buffer.getLength());
    }

    public SamplePlayer(Sample buffer) {
        this(SamplePlayer.getDefaultContext(), buffer);
    }

    public void setSample(Sample sample) {
        this.sample = sample;
        this.frame = new float[sample.getNumChannels()];
    }

    public void setBuffer(Sample s) {
        this.setSample(s);
    }

    public Sample getSample() {
        return this.sample;
    }

    public Sample getBuffer() {
        return this.sample;
    }

    public void setToEnd() {
        this.position = this.sample.getLength();
    }

    public boolean inLoop() {
        return this.position < (double)Math.max(this.loopStart, this.loopEnd) && this.position > (double)Math.min(this.loopStart, this.loopEnd);
    }

    public void setToLoopStart() {
        this.position = Math.min(this.loopStart, this.loopEnd);
        this.forwards = this.rate > 0.0f;
    }

    public void start(float msPosition) {
        this.position = msPosition;
        this.start();
    }

    public void reset() {
        this.position = 0.0;
        this.forwards = true;
    }

    public double getPosition() {
        return this.position;
    }

    public void setPosition(double position) {
        this.position = position;
    }

    @Deprecated
    public UGen getPositionEnvelope() {
        return this.positionEnvelope;
    }

    public UGen getPositionUGen() {
        return this.positionEnvelope;
    }

    @Deprecated
    public void setPositionEnvelope(UGen positionEnvelope) {
        this.positionEnvelope = positionEnvelope;
    }

    public void setPosition(UGen positionUGen) {
        this.positionEnvelope = positionUGen;
    }

    @Deprecated
    public UGen getRateEnvelope() {
        return this.rateEnvelope;
    }

    public UGen getRateUGen() {
        return this.rateEnvelope;
    }

    @Deprecated
    public void setRateEnvelope(UGen rateEnvelope) {
        this.rateEnvelope = rateEnvelope;
    }

    public void setRate(UGen rateUGen) {
        this.rateEnvelope = rateUGen;
    }

    @Deprecated
    public UGen getPitchEnvelope() {
        return this.rateEnvelope;
    }

    public UGen getPitchUGen() {
        return this.rateEnvelope;
    }

    @Deprecated
    public void setPitchEnvelope(UGen rateEnvelope) {
        this.rateEnvelope = rateEnvelope;
    }

    public void setPitch(UGen rateUGen) {
        this.rateEnvelope = rateUGen;
    }

    public EnvelopeType getEnvelopeType() {
        return this.envelopeType;
    }

    public void setEnvelopeType(EnvelopeType et) {
        this.envelopeType = et;
    }

    public InterpolationType getInterpolationType() {
        return this.interpolationType;
    }

    public void setInterpolationType(InterpolationType interpolationType) {
        this.interpolationType = interpolationType;
    }

    public float getLoopCrossFade() {
        return this.loopCrossFade;
    }

    public void setLoopCrossFade(float loopCrossFade) {
        this.loopCrossFade = loopCrossFade;
    }

    @Deprecated
    public UGen getLoopEndEnvelope() {
        return this.loopEndEnvelope;
    }

    public UGen getLoopEndUGen() {
        return this.loopEndEnvelope;
    }

    @Deprecated
    public void setLoopEndEnvelope(UGen loopEndEnvelope) {
        this.loopEndEnvelope = loopEndEnvelope;
    }

    public void setLoopEnd(UGen loopEndUGen) {
        this.loopEndEnvelope = loopEndUGen;
    }

    @Deprecated
    public UGen getLoopStartEnvelope() {
        return this.loopStartEnvelope;
    }

    public UGen getLoopStartUGen() {
        return this.loopStartEnvelope;
    }

    @Deprecated
    public void setLoopStartEnvelope(UGen loopStartEnvelope) {
        this.loopStartEnvelope = loopStartEnvelope;
    }

    public void setLoopStart(UGen loopStartUGen) {
        this.loopStartEnvelope = loopStartUGen;
    }

    public void setLoopPointsFraction(float start, float end) {
        this.loopStartEnvelope = new Static(this.context, start * (float)this.sample.getLength());
        this.loopEndEnvelope = new Static(this.context, end * (float)this.sample.getLength());
    }

    public LoopType getLoopType() {
        return this.loopType;
    }

    public void setLoopType(LoopType loopType) {
        this.loopType = loopType;
        if (loopType != LoopType.LOOP_ALTERNATING) {
            this.forwards = loopType == LoopType.LOOP_FORWARDS || loopType == LoopType.NO_LOOP_FORWARDS;
        }
    }

    public float getSampleRate() {
        return this.sample.getSampleRate();
    }

    @Override
    public void calculateBuffer() {
        block49: {
            block50: {
                block51: {
                    if (this.sample == null) break block49;
                    if (this.positionEnvelope != null) {
                        this.positionEnvelope.update();
                    } else {
                        this.rateEnvelope.update();
                        this.loopStartEnvelope.update();
                        this.loopEndEnvelope.update();
                    }
                    if (this.envelopeType != EnvelopeType.COARSE) break block50;
                    if (this.positionEnvelope == null) break block51;
                    float startPosition = this.positionEnvelope.getValue(0, 0);
                    float endPosition = this.positionEnvelope.getValue(0, this.bufferSize - 1);
                    long startPosInSamples = (long)this.sample.msToSamples(startPosition);
                    long endPosInSamples = (long)this.sample.msToSamples(endPosition);
                    long numSamples = 1L + Math.abs(endPosInSamples - startPosInSamples);
                    if (endPosInSamples >= startPosInSamples) {
                        float[][] samples = new float[this.getOuts()][(int)numSamples];
                        this.sample.getFrames((int)startPosInSamples, samples);
                        AudioUtils.stretchBuffer(samples, this.bufOut);
                    } else {
                        float[][] samples = new float[this.getOuts()][(int)numSamples];
                        this.sample.getFrames((int)endPosInSamples, samples);
                        AudioUtils.reverseBuffer(samples);
                        AudioUtils.stretchBuffer(samples, this.bufOut);
                    }
                    this.position = endPosition;
                    break block49;
                }
                this.rate = this.rateEnvelope.getValue(0, 0);
                switch (this.loopType) {
                    case NO_LOOP_FORWARDS: 
                    case NO_LOOP_BACKWARDS: {
                        boolean isPlayingForwards;
                        double normalisedRate = this.loopType == LoopType.NO_LOOP_FORWARDS ? (double)this.rate : (double)(-this.rate);
                        long numSamples = (long)(Math.abs(this.rate) * (float)this.bufferSize);
                        double numMs = this.sample.samplesToMs(numSamples);
                        if (normalisedRate >= 0.0) {
                            isPlayingForwards = true;
                            if (numMs + this.position > this.sample.getLength()) {
                                numSamples = (long)this.sample.msToSamples(this.sample.getLength() - this.position);
                            }
                        } else {
                            isPlayingForwards = false;
                            if (this.position - numMs < 0.0) {
                                numSamples = (long)this.sample.msToSamples(this.position);
                            }
                        }
                        if (numSamples <= 0L) {
                            return;
                        }
                        float[][] frames = new float[this.outs][(int)numSamples];
                        if (isPlayingForwards) {
                            this.sample.getFrames((int)this.sample.msToSamples(this.position), frames);
                            this.position += numMs;
                        } else {
                            this.sample.getFrames((int)(this.sample.msToSamples(this.position) - (double)numSamples), frames);
                            AudioUtils.reverseBuffer(frames);
                            this.position -= numMs;
                        }
                        AudioUtils.stretchBuffer(frames, this.bufOut);
                        if (this.position > this.sample.getLength() || this.position < 0.0) {
                            this.atEnd();
                            break;
                        }
                        break block49;
                    }
                    default: {
                        System.out.println("COARSE looping is not implemented yet. Killing SamplePlayer...");
                        this.kill();
                        break;
                    }
                }
                break block49;
            }
            for (int i = 0; i < this.bufferSize; ++i) {
                this.calculateNextPosition(i);
                if (this.loopCrossFade / 2.0f > Math.min(this.loopStart, this.loopEnd) || (double)(this.loopCrossFade / 2.0f) > this.sample.getLength() - (double)Math.max(this.loopStart, this.loopEnd)) {
                    this.loopCrossFade = (float)(Math.min((double)Math.min(this.loopStart, this.loopEnd), this.sample.getLength() - (double)Math.max(this.loopStart, this.loopEnd)) * 2.0);
                }
                if (this.loopCrossFade > Math.abs(this.loopEnd - this.loopStart)) {
                    this.loopCrossFade = Math.abs(this.loopEnd - this.loopStart);
                } else if (this.loopCrossFade < 0.0f) {
                    this.loopCrossFade = 0.0f;
                }
                float[] crossfadeFrame = new float[this.sample.getNumChannels()];
                double crossPosition = -1.0;
                double sampleLevel = 1.0;
                if (this.isLooping[i] && this.loopCrossFade > 0.0f && (this.loopType == LoopType.LOOP_FORWARDS || this.loopType == LoopType.LOOP_BACKWARDS)) {
                    if (this.loopStart < this.loopEnd) {
                        if (this.position > (double)(this.loopEnd - this.loopCrossFade / 2.0f)) {
                            crossPosition = (double)this.loopStart - ((double)this.loopEnd - this.position);
                            sampleLevel = 1.0 - Math.max(Math.min((this.position - (double)(this.loopEnd - this.loopCrossFade / 2.0f)) / (double)this.loopCrossFade, 0.5), 0.0);
                        } else if (this.position < (double)(this.loopStart + this.loopCrossFade / 2.0f)) {
                            crossPosition = (double)this.loopEnd + (this.position - (double)this.loopStart);
                            sampleLevel = Math.max(Math.min((this.position - (double)(this.loopStart - this.loopCrossFade / 2.0f)) / (double)this.loopCrossFade, 1.0), 0.5);
                        }
                    } else if (this.position < (double)(this.loopEnd + this.loopCrossFade / 2.0f)) {
                        crossPosition = (double)this.loopStart + (this.position - (double)this.loopEnd);
                        sampleLevel = 1.0 - Math.max(Math.min(((double)(this.loopEnd + this.loopCrossFade / 2.0f) - this.position) / (double)this.loopCrossFade, 0.5), 0.0);
                    } else if (this.position > (double)(this.loopStart - this.loopCrossFade / 2.0f)) {
                        crossPosition = (double)this.loopEnd - ((double)this.loopStart - this.position);
                        sampleLevel = Math.max(Math.min(((double)(this.loopStart + this.loopCrossFade / 2.0f) - this.position) / (double)this.loopCrossFade, 1.0), 0.5);
                    }
                } else if (this.isLooping[i] && this.loopCrossFade > 0.0f && this.loopType == LoopType.LOOP_ALTERNATING) {
                    if (this.position > (double)(this.loopEnd - this.loopCrossFade / 2.0f)) {
                        crossPosition = (double)this.loopEnd + ((double)this.loopEnd - this.position);
                        sampleLevel = 1.0 - Math.max(Math.min((this.position - (double)(this.loopEnd - this.loopCrossFade / 2.0f)) / (double)this.loopCrossFade, 0.5), 0.0);
                    } else if (this.position < (double)(this.loopStart + this.loopCrossFade / 2.0f)) {
                        crossPosition = (double)this.loopStart - (this.position - (double)this.loopStart);
                        sampleLevel = Math.max(Math.min((this.position - (double)(this.loopStart - this.loopCrossFade / 2.0f)) / (double)this.loopCrossFade, 1.0), 0.5);
                    }
                } else if (!this.isLooping[i]) {
                    if (this.loopStart < this.loopEnd && this.position > (double)(this.loopStart + this.loopCrossFade / 2.0f)) {
                        this.isLooping[i] = true;
                    } else if (this.loopEnd < this.loopStart && this.position < (double)(this.loopStart - this.loopCrossFade / 2.0f)) {
                        this.isLooping[i] = true;
                    }
                }
                if (crossPosition < (double)(Math.min(this.loopStart, this.loopEnd) - this.loopCrossFade / 2.0f) || crossPosition > (double)(Math.max(this.loopStart, this.loopEnd) + this.loopCrossFade / 2.0f)) {
                    crossPosition = -1.0;
                }
                switch (this.interpolationType) {
                    case ADAPTIVE: {
                        if (this.rate > 2.5f) {
                            this.sample.getFrameNoInterp(this.position, this.frame);
                            this.sample.getFrameNoInterp(crossPosition, crossfadeFrame);
                            break;
                        }
                        if (this.rate > 0.5f) {
                            this.sample.getFrameLinear(this.position, this.frame);
                            this.sample.getFrameLinear(crossPosition, crossfadeFrame);
                            break;
                        }
                        this.sample.getFrameCubic(this.position, this.frame);
                        this.sample.getFrameCubic(crossPosition, crossfadeFrame);
                        break;
                    }
                    case LINEAR: {
                        this.sample.getFrameLinear(this.position, this.frame);
                        this.sample.getFrameLinear(crossPosition, crossfadeFrame);
                        break;
                    }
                    case CUBIC: {
                        this.sample.getFrameCubic(this.position, this.frame);
                        this.sample.getFrameCubic(crossPosition, crossfadeFrame);
                        break;
                    }
                    case NONE: {
                        this.sample.getFrameNoInterp(this.position, this.frame);
                        this.sample.getFrameNoInterp(crossPosition, crossfadeFrame);
                    }
                }
                for (int j = 0; j < this.outs; ++j) {
                    this.bufOut[j][i] = crossPosition != -1.0 ? (float)sampleLevel * this.frame[j % this.sample.getNumChannels()] + (float)(1.0 - sampleLevel) * crossfadeFrame[j % this.sample.getNumChannels()] : (float)sampleLevel * this.frame[j % this.sample.getNumChannels()];
                }
            }
        }
    }

    public void setKillOnEnd(boolean killOnEnd) {
        this.killOnEnd = killOnEnd;
    }

    public boolean getKillOnEnd() {
        return this.killOnEnd;
    }

    protected void atEnd() {
        if (this.endListener != null) {
            this.endListener.message(this);
        }
        if (this.killOnEnd) {
            this.kill();
        }
    }

    public void setEndListener(Bead endListener) {
        this.endListener = endListener;
    }

    public Bead getEndListener() {
        return this.endListener;
    }

    public void reTrigger() {
        this.reset();
        this.pause(false);
    }

    protected void calculateNextPosition(int i) {
        if (this.positionEnvelope != null) {
            this.position = this.positionEnvelope.getValueDouble(0, i);
        } else {
            this.rate = this.rateEnvelope.getValue(0, i);
            switch (this.loopType) {
                case NO_LOOP_FORWARDS: {
                    this.position += this.positionIncrement * (double)this.rate;
                    if (!(this.position > this.sample.getLength()) && !(this.position < 0.0)) break;
                    this.atEnd();
                    break;
                }
                case NO_LOOP_BACKWARDS: {
                    this.position -= this.positionIncrement * (double)this.rate;
                    if (!(this.position > this.sample.getLength()) && !(this.position < 0.0)) break;
                    this.atEnd();
                    break;
                }
                case LOOP_FORWARDS: {
                    this.loopStart = this.loopStartEnvelope.getValue(0, i);
                    this.loopEnd = this.loopEndEnvelope.getValue(0, i);
                    this.position += this.positionIncrement * (double)this.rate;
                    if (this.rate > 0.0f && this.position > (double)Math.max(this.loopStart, this.loopEnd)) {
                        this.position = Math.min(this.loopStart, this.loopEnd);
                        break;
                    }
                    if (!(this.rate < 0.0f) || !(this.position < (double)Math.min(this.loopStart, this.loopEnd))) break;
                    this.position = Math.max(this.loopStart, this.loopEnd);
                    break;
                }
                case LOOP_BACKWARDS: {
                    this.loopStart = this.loopStartEnvelope.getValue(0, i);
                    this.loopEnd = this.loopEndEnvelope.getValue(0, i);
                    this.position -= this.positionIncrement * (double)this.rate;
                    if (this.rate > 0.0f && this.position < (double)Math.min(this.loopStart, this.loopEnd)) {
                        this.position = Math.max(this.loopStart, this.loopEnd);
                        break;
                    }
                    if (!(this.rate < 0.0f) || !(this.position > (double)Math.max(this.loopStart, this.loopEnd))) break;
                    this.position = Math.min(this.loopStart, this.loopEnd);
                    break;
                }
                case LOOP_ALTERNATING: {
                    this.loopStart = this.loopStartEnvelope.getValue(0, i);
                    this.loopEnd = this.loopEndEnvelope.getValue(0, i);
                    this.position += this.forwards ? this.positionIncrement * (double)this.rate : -this.positionIncrement * (double)this.rate;
                    if (this.forwards ^ this.rate < 0.0f) {
                        if (!(this.position > (double)Math.max(this.loopStart, this.loopEnd))) break;
                        this.forwards = this.rate < 0.0f;
                        this.position = (double)(2.0f * Math.max(this.loopStart, this.loopEnd)) - this.position;
                        break;
                    }
                    if (!(this.position < (double)Math.min(this.loopStart, this.loopEnd))) break;
                    this.forwards = this.rate > 0.0f;
                    this.position = (double)(2.0f * Math.min(this.loopStart, this.loopEnd)) - this.position;
                }
            }
        }
    }

    public static enum EnvelopeType {
        COARSE,
        FINE;

    }

    public static enum LoopType {
        NO_LOOP_FORWARDS,
        NO_LOOP_BACKWARDS,
        LOOP_FORWARDS,
        LOOP_BACKWARDS,
        LOOP_ALTERNATING;

    }

    public static enum InterpolationType {
        NONE,
        LINEAR,
        CUBIC,
        ADAPTIVE;

    }
}

