/*
 * Decompiled with CFR 0.152.
 */
package beads;

import beads.FileFormatException;
import beads.OperationUnsupportedException;
import beads.Sample;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;

public class SampleManager {
    private static final Map<String, Sample> samples = new TreeMap<String, Sample>();
    private static final Map<String, ArrayList<Sample>> groups = new TreeMap<String, ArrayList<Sample>>();
    private static final Map<String, String> groupDirs = new TreeMap<String, String>();
    private static final Set<SampleGroupListener> listeners = new HashSet<SampleGroupListener>();
    private static boolean verbose = true;

    public static Sample sample(String fn) {
        return SampleManager.sample(fn, fn);
    }

    public static void sample(String name, Sample sample) {
        if (samples.get(name) == null) {
            samples.put(name, sample);
            if (sample.getSimpleName() == null) {
                sample.setSimpleName(name);
            }
        }
    }

    public static Sample sample(String ref, String fn) {
        Sample sample = samples.get(ref);
        if (sample == null) {
            try {
                sample = new Sample(fn);
                samples.put(ref, sample);
                if (verbose) {
                    System.out.println("Sample loaded " + fn);
                }
            }
            catch (OperationUnsupportedException e) {
                System.out.println("OperationUnsupportedException: The reading operation failed " + fn);
            }
            catch (FileFormatException e) {
                System.out.println("FileFormatException: Sample format malformed " + fn);
            }
            catch (IOException e) {
                System.out.println("IOException: Sample not found/supported " + fn);
            }
        }
        return sample;
    }

    public static List<Sample> group(String groupName, Sample[] sampleList) {
        ArrayList<Object> group;
        if (!groups.keySet().contains(groupName)) {
            group = new ArrayList();
            groups.put(groupName, group);
        } else {
            group = groups.get(groupName);
        }
        for (int i = 0; i < sampleList.length; ++i) {
            if (group.contains(sampleList[i])) continue;
            group.add(sampleList[i]);
        }
        for (SampleGroupListener l : listeners) {
            l.changed(groupName);
        }
        return group;
    }

    public static List<Sample> group(String groupName, String folderName) {
        return SampleManager.group(groupName, folderName, Integer.MAX_VALUE);
    }

    public static List<Sample> group(String groupName, String folderName, int maxItems) {
        File theDirectory = null;
        try {
            URL url = ClassLoader.getSystemResource(folderName);
            if (url != null) {
                theDirectory = new File(URLDecoder.decode(url.getPath(), "UTF-8"));
            }
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        if (theDirectory == null || !theDirectory.exists()) {
            theDirectory = new File(folderName);
        }
        groupDirs.put(groupName, theDirectory.getAbsolutePath());
        String[] fileNameList = theDirectory.list();
        for (int i = 0; i < fileNameList.length; ++i) {
            String absFileName = theDirectory.getAbsolutePath() + "/" + fileNameList[i];
            if (!new File(absFileName).exists()) continue;
            fileNameList[i] = absFileName;
        }
        return SampleManager.group(groupName, fileNameList, maxItems);
    }

    public static List<Sample> group(String groupName, String[] fileNameList) {
        return SampleManager.group(groupName, fileNameList, Integer.MAX_VALUE);
    }

    public static List<Sample> group(String groupName, String[] fileNameList, int maxItems) {
        ArrayList<Sample> group;
        if (!groups.keySet().contains(groupName)) {
            group = new ArrayList();
            groups.put(groupName, group);
        } else {
            group = groups.get(groupName);
        }
        int count = 0;
        for (int i = 0; i < fileNameList.length; ++i) {
            String simpleName = fileNameList[i];
            try {
                Sample sample = SampleManager.sample(simpleName, fileNameList[i]);
                if (group.contains(simpleName) || sample == null) continue;
                if (count++ >= maxItems) break;
                group.add(sample);
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        for (SampleGroupListener l : listeners) {
            l.changed(groupName);
        }
        return group;
    }

    public static void addToGroup(String group, Sample sample) {
        ArrayList<Object> samples;
        if (!groups.containsKey(group)) {
            samples = new ArrayList();
            groups.put(group, samples);
        } else {
            samples = groups.get(group);
        }
        if (!samples.contains(sample)) {
            samples.add(sample);
        }
        for (SampleGroupListener l : listeners) {
            l.changed(group);
        }
    }

    public static void addToGroup(String group, List<Sample> newSamples) {
        ArrayList<Object> samples;
        if (newSamples == null) {
            return;
        }
        if (!groups.containsKey(group)) {
            samples = new ArrayList();
            groups.put(group, samples);
        } else {
            samples = groups.get(group);
        }
        for (Sample sample : newSamples) {
            if (samples.contains(sample)) continue;
            samples.add(sample);
        }
        for (SampleGroupListener l : listeners) {
            l.changed(group);
        }
    }

    public static Set<String> groups() {
        return groups.keySet();
    }

    public static List<String> groupsAsList() {
        return new ArrayList<String>(groups.keySet());
    }

    public static ArrayList<Sample> getGroup(String groupName) {
        return groups.get(groupName);
    }

    public static String getGroupDir(String groupName) {
        return groupDirs.get(groupName);
    }

    public static Sample randomFromGroup(String groupName) {
        ArrayList<Sample> group = groups.get(groupName);
        return group.get((int)(Math.random() * (double)group.size()));
    }

    public static Sample fromGroup(String groupName, int index) {
        ArrayList<Sample> group = groups.get(groupName);
        if (group == null || group.size() == 0) {
            return null;
        }
        return group.get(index % group.size());
    }

    public static void removeSample(String sampleName) {
        if (samples.containsKey(sampleName)) {
            samples.remove(sampleName);
        }
    }

    public static void removeSample(Sample sample) {
        for (String str : samples.keySet()) {
            if (!samples.get(str).equals(sample)) continue;
            SampleManager.removeSample(str);
            break;
        }
    }

    public static void removeGroup(String groupName) {
        groups.remove(groupName);
        groupDirs.remove(groupName);
        for (SampleGroupListener l : listeners) {
            l.changed(groupName);
        }
    }

    public static void destroyGroup(String groupName) {
        ArrayList<Sample> group = groups.get(groupName);
        for (int i = 0; i < group.size(); ++i) {
            SampleManager.removeSample(group.get(i));
        }
        SampleManager.removeGroup(groupName);
    }

    public static void addGroupListener(SampleGroupListener l) {
        listeners.add(l);
    }

    public static void removeGroupListener(SampleGroupListener l) {
        listeners.remove(l);
    }

    public static void printSampleList() {
        for (String s : samples.keySet()) {
            System.out.println(s + " " + samples.get(s));
        }
    }

    public static List<String> getSampleNameList() {
        return new ArrayList<String>(samples.keySet());
    }

    public static boolean isVerbose() {
        return verbose;
    }

    public static void setVerbose(boolean verbose) {
        SampleManager.verbose = verbose;
    }

    public static void logSamplePaths(String toFile) {
        try {
            File f = new File(toFile);
            PrintWriter out = new PrintWriter(f);
            for (Sample s : samples.values()) {
                if (s.getFileName() == null || s.getFileName().equals("")) continue;
                out.println("\"" + s.getFileName() + "\"");
            }
            out.close();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
    }

    public static void transferSamples(String sourceRootDir, String destRootDir, boolean force) {
        File srd = new File(sourceRootDir);
        if (!srd.exists()) {
            return;
        }
        sourceRootDir = srd.getAbsolutePath();
        File drd = new File(destRootDir);
        if (!drd.exists()) {
            drd.mkdir();
        }
        destRootDir = drd.getAbsolutePath();
        for (Sample s : samples.values()) {
            String absFileName;
            if (s.getFileName() == null || s.getFileName().equals("") || !(absFileName = s.getFileName()).startsWith(sourceRootDir)) continue;
            String destAbsFileName = absFileName.replace(sourceRootDir, destRootDir);
            if (!force && new File(destAbsFileName).exists()) continue;
            try {
                File parent = new File(destAbsFileName).getParentFile();
                if (!parent.exists()) {
                    parent.mkdirs();
                }
                s.write(destAbsFileName);
                System.out.println("Copied file \"" + absFileName + "\" to \"" + destAbsFileName + "\"");
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public static interface SampleGroupListener {
        public void changed(String var1);
    }
}

