/*
 * Decompiled with CFR 0.152.
 */
package beads;

import beads.FeatureExtractor;
import beads.TimeStamp;

public class ReBin
extends FeatureExtractor<float[], float[]> {
    public ReBin(int numFeatures) {
        this.setNumberOfFeatures(numFeatures);
    }

    @Override
    public void setNumberOfFeatures(int nf) {
        super.setNumberOfFeatures(nf);
        this.features = new float[this.numFeatures];
    }

    @Override
    public void process(TimeStamp startTime, TimeStamp endTime, float[] original) {
        if (original != null) {
            int i;
            float scale = (float)original.length / (float)((float[])this.features).length;
            for (i = 0; i < original.length; ++i) {
                float[] fArray = (float[])this.features;
                int n = (int)((float)i / scale);
                fArray[n] = fArray[n] + original[i];
            }
            for (i = 0; i < ((float[])this.features).length; ++i) {
                float[] fArray = (float[])this.features;
                int n = i;
                fArray[n] = fArray[n] / scale;
                if (!Float.isNaN(((float[])this.features)[i])) continue;
                ((float[])this.features)[i] = 0.0f;
            }
        }
        this.forward(startTime, endTime);
    }
}

