/*
 * Decompiled with CFR 0.152.
 */
package beads;

import beads.AudioContext;
import beads.Bead;
import beads.DataBead;
import beads.DataBeadReceiver;
import beads.UGen;

public class RandomPWM
extends UGen
implements DataBeadReceiver {
    public static final Mode ALTERNATING = Mode.ALTERNATING;
    public static final Mode NOISE = Mode.NOISE;
    public static final Mode PULSING = Mode.PULSING;
    public static final Mode SAW = Mode.SAW;
    public static final Mode RAMPED_NOISE = Mode.RAMPED_NOISE;
    public static final Mode NOISE_ENVELOPE = Mode.NOISE_ENVELOPE;
    protected Mode mode = ALTERNATING;
    protected float targetVal = 0.0f;
    protected float baseVal = 0.0f;
    protected float valDiff = 0.0f;
    protected float count = 0.0f;
    protected float pulseLen = 0.0f;
    protected float minLength = 10.0f;
    protected float maxLength = 100.0f;
    protected float lengthExponent = 1.0f;
    protected float lengthDiff = 0.0f;

    public RandomPWM(AudioContext context, Mode mode, float minl, float maxl) {
        this(context, mode, minl, maxl, 1.0f);
    }

    public RandomPWM(Mode mode, float minl, float maxl) {
        this(RandomPWM.getDefaultContext(), mode, minl, maxl);
    }

    public RandomPWM(AudioContext context, Mode mode, float minl, float maxl, float lexp) {
        super(context, 0, 1);
        this.setParams(mode, minl, maxl, lexp);
    }

    public RandomPWM(Mode mode, float minl, float maxl, float lexp) {
        this(RandomPWM.getDefaultContext(), mode, minl, maxl, lexp);
    }

    @Override
    public void calculateBuffer() {
        float[] bo = this.bufOut[0];
        if (this.mode == PULSING) {
            for (int i = 0; i < bo.length; ++i) {
                if (this.count <= 0.0f) {
                    this.calcVals();
                    this.targetVal = this.targetVal > 0.0f ? 0.0f : 1.0f;
                    this.valDiff = this.targetVal - this.baseVal;
                }
                bo[i] = this.targetVal;
                this.count -= 1.0f;
            }
        } else if (this.mode == ALTERNATING) {
            for (int i = 0; i < bo.length; ++i) {
                if (this.count <= 0.0f) {
                    this.calcVals();
                    this.targetVal = this.targetVal > 0.0f ? -1.0f : 1.0f;
                    this.valDiff = this.targetVal - this.baseVal;
                }
                bo[i] = this.targetVal;
                this.count -= 1.0f;
            }
        } else if (this.mode == SAW) {
            for (int i = 0; i < bo.length; ++i) {
                if (this.count <= 0.0f) {
                    this.calcVals();
                    this.targetVal = this.targetVal > 0.0f ? -1.0f : 1.0f;
                    this.valDiff = this.targetVal - this.baseVal;
                }
                bo[i] = this.targetVal - this.count / this.pulseLen * this.valDiff;
                this.count -= 1.0f;
            }
        } else if (this.mode == RAMPED_NOISE) {
            for (int i = 0; i < bo.length; ++i) {
                if (this.count <= 0.0f) {
                    this.calcVals();
                    this.targetVal = (float)(Math.random() * 2.0 - 1.0);
                    this.valDiff = this.targetVal - this.baseVal;
                }
                bo[i] = this.targetVal - this.count / this.pulseLen * this.valDiff;
                this.count -= 1.0f;
            }
        } else if (this.mode == NOISE_ENVELOPE) {
            for (int i = 0; i < bo.length; ++i) {
                if (this.count <= 0.0f) {
                    this.calcVals();
                    this.targetVal = (float)Math.random();
                    this.valDiff = this.targetVal - this.baseVal;
                }
                bo[i] = this.targetVal - this.count / this.pulseLen * this.valDiff;
                this.count -= 1.0f;
            }
        } else {
            for (int i = 0; i < bo.length; ++i) {
                if (this.count <= 0.0f) {
                    this.calcVals();
                    this.targetVal = (float)(Math.random() * 2.0 - 1.0);
                    this.valDiff = this.targetVal - this.baseVal;
                }
                bo[i] = this.targetVal;
                this.count -= 1.0f;
            }
        }
    }

    protected void calcVals() {
        float d = (float)Math.pow(Math.random(), this.lengthExponent) * this.lengthDiff + this.minLength;
        this.count += d;
        this.pulseLen = this.count;
        this.baseVal = this.targetVal;
    }

    public RandomPWM setParams(Mode mode, float minl, float maxl, float lexp) {
        this.setParams(minl, maxl, lexp);
        this.setMode(mode);
        return this;
    }

    public RandomPWM setParams(float minl, float maxl, float lexp) {
        this.setLengthExponent(lexp);
        this.minLength = Math.max(minl, 1.0f);
        this.maxLength = Math.max(this.minLength, maxl);
        this.lengthDiff = this.maxLength - this.minLength;
        return this;
    }

    public RandomPWM setMinLength(float minl) {
        this.setParams(minl, this.maxLength, this.lengthExponent);
        return this;
    }

    public float getMinLength() {
        return this.minLength;
    }

    public RandomPWM setMaxLength(float maxl) {
        this.setParams(this.minLength, maxl, this.lengthExponent);
        return this;
    }

    public float getMaxLength() {
        return this.maxLength;
    }

    public RandomPWM setLengthExponent(float lexp) {
        float f;
        this.lengthExponent = lexp;
        if (f < 0.001f) {
            this.lengthExponent = 0.001f;
        }
        return this;
    }

    public float getLengthExponent() {
        return this.lengthExponent;
    }

    public RandomPWM setMode(Mode mode) {
        this.mode = mode;
        return this;
    }

    public Mode getMode() {
        return this.mode;
    }

    @Override
    public DataBeadReceiver sendData(DataBead db) {
        if (db != null) {
            Object m = db.get("mode");
            Mode mod = this.mode;
            if (m instanceof Mode) {
                mod = (Mode)((Object)m);
            }
            this.setParams(mod, db.getFloat("minLength", this.minLength), db.getFloat("maxLength", this.maxLength), db.getFloat("lengthExponent", this.lengthExponent));
        }
        return this;
    }

    @Override
    public void messageReceived(Bead message) {
        if (message instanceof DataBead) {
            this.sendData((DataBead)message);
        }
    }

    public DataBead getParams() {
        DataBead db = new DataBead();
        db.put("mode", (Object)this.mode);
        db.put("minLength", (Object)Float.valueOf(this.minLength));
        db.put("maxLength", (Object)Float.valueOf(this.maxLength));
        db.put("lengthExponent", (Object)Float.valueOf(this.lengthExponent));
        return db;
    }

    public static enum Mode {
        ALTERNATING,
        NOISE,
        PULSING,
        SAW,
        RAMPED_NOISE,
        NOISE_ENVELOPE;

    }
}

