/*
 * Decompiled with CFR 0.152.
 */
package beads;

import beads.AudioContext;
import beads.UGen;
import java.awt.MouseInfo;
import java.awt.Point;
import java.awt.Toolkit;

public class MouseResponder
extends UGen {
    private Point point;
    private float x;
    private float prevX;
    private float y;
    private float prevY;
    private int width;
    private int height;

    public MouseResponder(AudioContext context) {
        super(context, 2);
        this.width = Toolkit.getDefaultToolkit().getScreenSize().width;
        this.height = Toolkit.getDefaultToolkit().getScreenSize().height;
        this.prevX = 0.0f;
        this.prevY = 0.0f;
    }

    public MouseResponder() {
        this(MouseResponder.getDefaultContext());
    }

    public Point getPoint() {
        return this.point;
    }

    @Override
    public void calculateBuffer() {
        this.point = MouseInfo.getPointerInfo().getLocation();
        this.x = (float)this.point.x / (float)this.width;
        this.y = (float)this.point.y / (float)this.height;
        for (int i = 0; i < this.bufferSize; ++i) {
            float f = (float)i / (float)this.bufferSize;
            this.bufOut[0][i] = f * this.x + (1.0f - f) * this.prevX;
            this.bufOut[1][i] = f * this.y + (1.0f - f) * this.prevY;
        }
        this.prevX = this.x;
        this.prevY = this.y;
    }
}

