/*
 * Decompiled with CFR 0.152.
 */
package beads;

import beads.AudioContext;
import beads.Buffer;
import beads.CosineWindow;
import beads.Sample;
import beads.SamplePlayer;
import beads.Static;
import beads.UGen;
import java.util.Iterator;
import java.util.LinkedList;

public class FastGranularSamplePlayer
extends SamplePlayer {
    private UGen pitchEnvelope;
    private float grainIntervalEnvelope;
    private float grainSizeEnvelope;
    private float randomnessEnvelope;
    private float timeSinceLastGrain;
    private float loopStart;
    private float loopEnd;
    private double msPerSample;
    protected float pitch;
    private LinkedList<Grain> grains = new LinkedList();
    private LinkedList<Grain> freeGrains = new LinkedList();
    private Buffer window;
    private boolean loopInsideGrains;
    private boolean firstGrain = true;

    public FastGranularSamplePlayer(AudioContext context, int outs) {
        super(context, outs);
        this.pitchEnvelope = new Static(context, 1.0f);
        this.setGrainInterval(new Static(context, 70.0f));
        this.setGrainSize(new Static(context, 100.0f));
        this.setRandomness(new Static(context, 0.0f));
        this.setWindow(new CosineWindow().getDefault());
        this.msPerSample = context.samplesToMs(1.0);
        this.loopInsideGrains = false;
    }

    public FastGranularSamplePlayer(int outs) {
        this(FastGranularSamplePlayer.getDefaultContext(), outs);
    }

    public FastGranularSamplePlayer(AudioContext context, Sample buffer) {
        this(context, buffer.getNumChannels());
        this.setSample(buffer);
        this.loopStart = 0.0f;
        this.loopEnd = (float)buffer.getLength();
    }

    public FastGranularSamplePlayer(Sample buffer) {
        this(FastGranularSamplePlayer.getDefaultContext(), buffer);
    }

    @Override
    @Deprecated
    public UGen getRateEnvelope() {
        return new Static(this.rate);
    }

    @Override
    public UGen getRateUGen() {
        return new Static(this.rate);
    }

    @Override
    @Deprecated
    public void setRateEnvelope(UGen rateEnvelope) {
        rateEnvelope.update();
        this.rate = rateEnvelope.getValue();
    }

    @Override
    public void setRate(UGen rateUGen) {
        rateUGen.update();
        this.rate = rateUGen.getValue();
    }

    public void setRate(float rate) {
        this.rate = rate;
    }

    @Override
    @Deprecated
    public UGen getPitchEnvelope() {
        return this.pitchEnvelope;
    }

    @Override
    public UGen getPitchUGen() {
        return this.pitchEnvelope;
    }

    @Override
    @Deprecated
    public void setPitchEnvelope(UGen pitchEnvelope) {
        pitchEnvelope.update();
        this.pitchEnvelope = pitchEnvelope;
    }

    @Override
    public void setPitch(UGen pitchUGen) {
        pitchUGen.update();
        this.pitchEnvelope = pitchUGen;
    }

    @Override
    @Deprecated
    public UGen getLoopEndEnvelope() {
        return new Static(this.loopEnd);
    }

    @Override
    public UGen getLoopEndUGen() {
        return new Static(this.loopEnd);
    }

    @Override
    @Deprecated
    public void setLoopEndEnvelope(UGen loopEndEnvelope) {
        loopEndEnvelope.update();
        this.loopEnd = loopEndEnvelope.getValue();
    }

    @Override
    public void setLoopEnd(UGen loopEndUGen) {
        loopEndUGen.update();
        this.loopEnd = loopEndUGen.getValue();
    }

    public void setLoopEnd(float loopEnd) {
        this.loopEnd = loopEnd;
    }

    @Override
    @Deprecated
    public UGen getLoopStartEnvelope() {
        return new Static(this.loopStart);
    }

    @Override
    public UGen getLoopStartUGen() {
        return new Static(this.loopStart);
    }

    @Override
    @Deprecated
    public void setLoopStartEnvelope(UGen loopStartEnvelope) {
        loopStartEnvelope.update();
        this.loopStart = loopStartEnvelope.getValue();
    }

    @Override
    public void setLoopStart(UGen loopStartUGen) {
        loopStartUGen.update();
        this.loopStart = loopStartUGen.getValue();
    }

    public void setLoopStart(float loopStart) {
        this.loopStart = loopStart;
    }

    @Override
    public void setLoopPointsFraction(float start, float end) {
        this.loopStart = start * (float)this.sample.getLength();
        this.loopEnd = end * (float)this.sample.getLength();
    }

    @Deprecated
    public UGen getGrainIntervalEnvelope() {
        return new Static(this.grainIntervalEnvelope);
    }

    public UGen getGrainInterval() {
        return new Static(this.grainIntervalEnvelope);
    }

    @Deprecated
    public void setGrainIntervalEnvelope(UGen grainIntervalEnvelope) {
        grainIntervalEnvelope.update();
        this.grainIntervalEnvelope = grainIntervalEnvelope.getValue();
    }

    public void setGrainInterval(UGen grainIntervalUGen) {
        grainIntervalUGen.update();
        this.grainIntervalEnvelope = grainIntervalUGen.getValue();
    }

    public void setGrainInterval(float grainInterval) {
        this.grainIntervalEnvelope = grainInterval;
    }

    @Deprecated
    public UGen getGrainSizeEnvelope() {
        return new Static(this.grainSizeEnvelope);
    }

    public UGen getGrainSize() {
        return new Static(this.grainSizeEnvelope);
    }

    @Deprecated
    public void setGrainSizeEnvelope(UGen grainSizeEnvelope) {
        grainSizeEnvelope.update();
        this.grainSizeEnvelope = grainSizeEnvelope.getValue();
    }

    public void setGrainSize(UGen grainSizeUGen) {
        grainSizeUGen.update();
        this.grainSizeEnvelope = grainSizeUGen.getValue();
    }

    public void setGrainSize(float grainSize) {
        this.grainSizeEnvelope = grainSize;
    }

    public Buffer getWindow() {
        return this.window;
    }

    public void setWindow(Buffer window) {
        this.window = window;
    }

    @Deprecated
    public UGen getRandomnessEnvelope() {
        return new Static(this.randomnessEnvelope);
    }

    public UGen getRandomness() {
        return new Static(this.randomnessEnvelope);
    }

    @Deprecated
    public void setRandomnessEnvelope(UGen randomnessEnvelope) {
        randomnessEnvelope.update();
        this.randomnessEnvelope = randomnessEnvelope.getValue();
    }

    public void setRandomness(UGen randomnessUGen) {
        randomnessUGen.update();
        this.randomnessEnvelope = randomnessUGen.getValue();
    }

    public void setRandomness(float randomness) {
        this.randomnessEnvelope = randomness;
    }

    @Override
    @Deprecated
    public synchronized void setBuffer(Sample buffer) {
        super.setSample(buffer);
        this.grains.clear();
        this.timeSinceLastGrain = 0.0f;
    }

    @Override
    public synchronized void setSample(Sample buffer) {
        super.setSample(buffer);
        this.grains.clear();
        this.timeSinceLastGrain = 0.0f;
    }

    @Override
    public void start() {
        super.start();
        this.timeSinceLastGrain = 0.0f;
    }

    private void resetGrain(Grain g, int bufferPointer) {
        g.position = this.position + (double)(this.grainSizeEnvelope * this.randomnessEnvelope) * (Math.random() * 2.0 - 1.0);
        g.age = 0.0;
        g.grainSize = this.grainSizeEnvelope;
        g.bufferPointer = bufferPointer;
    }

    @Override
    public void reset() {
        super.reset();
        this.firstGrain = true;
    }

    private void firstGrain() {
        if (this.firstGrain) {
            Grain g = new Grain();
            g.position = this.position;
            g.age = this.grainSizeEnvelope / 4.0f;
            g.grainSize = this.grainSizeEnvelope;
            this.grains.add(g);
            this.firstGrain = false;
            this.timeSinceLastGrain = this.grainIntervalEnvelope / 2.0f;
            g.bufferPointer = 0;
        }
    }

    @Override
    public synchronized void calculateBuffer() {
        if (this.sample != null) {
            Grain g;
            if (this.positionEnvelope != null) {
                this.positionEnvelope.update();
            }
            this.pitchEnvelope.update();
            this.firstGrain();
            for (int i = 0; i < this.bufferSize; ++i) {
                if (this.timeSinceLastGrain > this.grainIntervalEnvelope) {
                    g = null;
                    g = this.freeGrains.size() > 0 ? this.freeGrains.pollFirst() : new Grain();
                    this.resetGrain(g, i);
                    this.grains.add(g);
                    this.timeSinceLastGrain = 0.0f;
                }
                this.bufOut[0][i] = 0.0f;
                this.calculateNextPosition(i);
                this.timeSinceLastGrain = (float)((double)this.timeSinceLastGrain + this.msPerSample);
            }
            Iterator currentGrain = this.grains.iterator();
            while (currentGrain.hasNext()) {
                g = (Grain)currentGrain.next();
                this.pitch = Math.abs(this.pitchEnvelope.getValue(0, g.bufferPointer));
                while (g.age <= g.grainSize) {
                    float windowScale = this.window.getValueFraction((float)(g.age / g.grainSize));
                    switch (this.interpolationType) {
                        case ADAPTIVE: {
                            if (this.pitch > 2.5f) {
                                this.sample.getFrameNoInterp(g.position, this.frame);
                                break;
                            }
                            if (this.pitch > 0.5f) {
                                this.sample.getFrameLinear(g.position, this.frame);
                                break;
                            }
                            this.sample.getFrameCubic(g.position, this.frame);
                            break;
                        }
                        case LINEAR: {
                            this.sample.getFrameLinear(g.position, this.frame);
                            break;
                        }
                        case CUBIC: {
                            this.sample.getFrameCubic(g.position, this.frame);
                            break;
                        }
                        case NONE: {
                            this.sample.getFrameNoInterp(g.position, this.frame);
                        }
                    }
                    float[] fArray = this.bufOut[0];
                    int n = g.bufferPointer++;
                    fArray[n] = fArray[n] + windowScale * this.frame[0 % this.sample.getNumChannels()];
                    if (g.bufferPointer >= this.bufferSize) {
                        g.bufferPointer = 0;
                        break;
                    }
                    this.pitch = Math.abs(this.pitchEnvelope.getValue(0, g.bufferPointer));
                    this.calculateNextGrainPosition(g);
                }
                if (!(g.age > g.grainSize)) continue;
                this.freeGrains.add(g);
                currentGrain.remove();
            }
        }
    }

    private void calculateNextGrainPosition(Grain g) {
        int direction = this.rate >= 0.0f ? 1 : -1;
        g.age += this.msPerSample;
        if (this.loopInsideGrains) {
            switch (this.loopType) {
                case NO_LOOP_FORWARDS: {
                    g.position += (double)direction * this.positionIncrement * (double)this.pitch;
                    break;
                }
                case NO_LOOP_BACKWARDS: {
                    g.position -= (double)direction * this.positionIncrement * (double)this.pitch;
                    break;
                }
                case LOOP_FORWARDS: {
                    g.position += (double)direction * this.positionIncrement * (double)this.pitch;
                    if (this.rate > 0.0f && g.position > (double)Math.max(this.loopStart, this.loopEnd)) {
                        g.position = Math.min(this.loopStart, this.loopEnd);
                        break;
                    }
                    if (!(this.rate < 0.0f) || !(g.position < (double)Math.min(this.loopStart, this.loopEnd))) break;
                    g.position = Math.max(this.loopStart, this.loopEnd);
                    break;
                }
                case LOOP_BACKWARDS: {
                    g.position -= (double)direction * this.positionIncrement * (double)this.pitch;
                    if (this.rate > 0.0f && g.position < (double)Math.min(this.loopStart, this.loopEnd)) {
                        g.position = Math.max(this.loopStart, this.loopEnd);
                        break;
                    }
                    if (!(this.rate < 0.0f) || !(g.position > (double)Math.max(this.loopStart, this.loopEnd))) break;
                    g.position = Math.min(this.loopStart, this.loopEnd);
                    break;
                }
                case LOOP_ALTERNATING: {
                    g.position = g.position + (double)direction * (this.forwards ? this.positionIncrement * (double)this.pitch : -this.positionIncrement * (double)this.pitch);
                    if (this.forwards ^ this.rate < 0.0f) {
                        if (!(g.position > (double)Math.max(this.loopStart, this.loopEnd))) break;
                        g.position = (double)(2.0f * Math.max(this.loopStart, this.loopEnd)) - g.position;
                        break;
                    }
                    if (!(g.position < (double)Math.min(this.loopStart, this.loopEnd))) break;
                    g.position = (double)(2.0f * Math.min(this.loopStart, this.loopEnd)) - g.position;
                }
            }
        } else {
            g.position += (double)direction * this.positionIncrement * (double)this.pitch;
        }
    }

    @Override
    protected void calculateNextPosition(int i) {
        if (this.positionEnvelope != null) {
            this.position = this.positionEnvelope.getValueDouble(0, i);
        } else {
            switch (this.loopType) {
                case NO_LOOP_FORWARDS: {
                    this.position += this.positionIncrement * (double)this.rate;
                    if (!(this.position > this.sample.getLength()) && !(this.position < 0.0)) break;
                    this.atEnd();
                    break;
                }
                case NO_LOOP_BACKWARDS: {
                    this.position -= this.positionIncrement * (double)this.rate;
                    if (!(this.position > this.sample.getLength()) && !(this.position < 0.0)) break;
                    this.atEnd();
                    break;
                }
                case LOOP_FORWARDS: {
                    this.position += this.positionIncrement * (double)this.rate;
                    if (this.rate > 0.0f && this.position > (double)Math.max(this.loopStart, this.loopEnd)) {
                        this.position = Math.min(this.loopStart, this.loopEnd);
                        break;
                    }
                    if (!(this.rate < 0.0f) || !(this.position < (double)Math.min(this.loopStart, this.loopEnd))) break;
                    this.position = Math.max(this.loopStart, this.loopEnd);
                    break;
                }
                case LOOP_BACKWARDS: {
                    this.position -= this.positionIncrement * (double)this.rate;
                    if (this.rate > 0.0f && this.position < (double)Math.min(this.loopStart, this.loopEnd)) {
                        this.position = Math.max(this.loopStart, this.loopEnd);
                        break;
                    }
                    if (!(this.rate < 0.0f) || !(this.position > (double)Math.max(this.loopStart, this.loopEnd))) break;
                    this.position = Math.min(this.loopStart, this.loopEnd);
                    break;
                }
                case LOOP_ALTERNATING: {
                    this.position += this.forwards ? this.positionIncrement * (double)this.rate : -this.positionIncrement * (double)this.rate;
                    if (this.forwards ^ this.rate < 0.0f) {
                        if (!(this.position > (double)Math.max(this.loopStart, this.loopEnd))) break;
                        this.forwards = this.rate < 0.0f;
                        this.position = (double)(2.0f * Math.max(this.loopStart, this.loopEnd)) - this.position;
                        break;
                    }
                    if (!(this.position < (double)Math.min(this.loopStart, this.loopEnd))) break;
                    this.forwards = this.rate > 0.0f;
                    this.position = (double)(2.0f * Math.min(this.loopStart, this.loopEnd)) - this.position;
                }
            }
        }
    }

    public float getAverageNumberOfGrains() {
        return this.grainSizeEnvelope / this.grainIntervalEnvelope;
    }

    private static class Grain {
        double position;
        double age;
        double grainSize;
        int bufferPointer;

        private Grain() {
        }
    }
}

