/*
 * Decompiled with CFR 0.152.
 */
package beads;

import beads.AudioContext;
import beads.Bead;
import beads.DelayEvent;

public class DelayTrigger
extends DelayEvent {
    private Bead receiver;
    private Bead message;

    public DelayTrigger(AudioContext context, double delay, Bead receiver) {
        super(context, delay);
        this.receiver = receiver;
        this.message = this;
    }

    public DelayTrigger(double delay, Bead receiver) {
        this(DelayTrigger.getDefaultContext(), delay, receiver);
    }

    public DelayTrigger(AudioContext context, double delay, Bead receiver, Bead message) {
        super(context, delay);
        this.receiver = receiver;
        this.message = message;
    }

    public DelayTrigger(double delay, Bead receiver, Bead message) {
        this(DelayTrigger.getDefaultContext(), delay, receiver, message);
    }

    @Override
    public void trigger() {
        if (this.receiver != null) {
            this.receiver.message(this.message);
        }
        this.kill();
    }

    public Bead getReceiver() {
        return this.receiver;
    }

    public DelayTrigger setReceiver(Bead receiver) {
        this.receiver = receiver;
        return this;
    }

    public Bead getMessage() {
        return this.message;
    }

    public DelayTrigger setMessage(Bead message) {
        this.message = message;
        return this;
    }
}

