/*
 * Decompiled with CFR 0.152.
 */
package beads;

import beads.AudioContext;
import beads.Bead;
import beads.DataBead;
import beads.DataBeadReceiver;
import beads.UGen;

public class CrossoverFilter
extends UGen
implements DataBeadReceiver {
    private float a0;
    private float a1;
    private float a2;
    private float lb0;
    private float lb1;
    private float k;
    public static final float SQRT2 = (float)Math.sqrt(2.0);
    private float sr = 41000.0f;
    private float freq = 120.0f;
    private float pi_sr;
    private UGen freqUGen;
    private float x1 = 0.0f;
    private float x2 = 0.0f;
    private float ly0 = 0.0f;
    private float ly1 = 0.0f;
    private float ly2 = 0.0f;
    private float lz1 = 0.0f;
    private float lz2 = 0.0f;
    private float hy0 = 0.0f;
    private float hy1 = 0.0f;
    private float hy2 = 0.0f;
    private float hz1 = 0.0f;
    private float hz2 = 0.0f;
    private float[][] xms;
    private float[][] lyms;
    private float[][] lzms;
    private float[][] hyms;
    private float[][] hzms;
    private int channels;

    public CrossoverFilter(AudioContext context) {
        this(context, 1, 800.0f);
    }

    public CrossoverFilter() {
        this(CrossoverFilter.getDefaultContext());
    }

    public CrossoverFilter(AudioContext context, int channels) {
        this(context, channels, 800.0f);
    }

    public CrossoverFilter(int channels) {
        this(CrossoverFilter.getDefaultContext(), channels);
    }

    public CrossoverFilter(AudioContext context, int channels, float freq) {
        super(context, channels, channels * 2);
        this.channels = channels;
        if (channels > 1) {
            this.xms = new float[channels][3];
            this.lyms = new float[channels][3];
            this.lzms = new float[channels][3];
            this.hyms = new float[channels][3];
            this.hzms = new float[channels][3];
        }
        this.sr = context.getSampleRate();
        this.pi_sr = (float)(Math.PI / (double)this.sr);
        this.setFrequency(freq);
    }

    public CrossoverFilter(int channels, float freq) {
        this(CrossoverFilter.getDefaultContext(), channels, freq);
    }

    @Override
    public void calculateBuffer() {
        if (this.freqUGen != null) {
            this.freqUGen.update();
            this.freq = this.freqUGen.getValue();
            this.calcVals();
        }
        if (this.channels > 1) {
            for (int chan = 0; chan < this.channels; ++chan) {
                float[] bi = this.bufIn[chan];
                float[] lo = this.bufOut[chan * 2];
                float[] hi = this.bufOut[chan * 2 + 1];
                float[] ly = this.lyms[chan];
                float[] lz = this.lzms[chan];
                float[] hy = this.hyms[chan];
                float[] hz = this.hzms[chan];
                float[] x = this.xms[chan];
                for (int i = 0; i < this.bufferSize; ++i) {
                    ly[0] = (this.lb0 * (bi[i] + x[2]) + this.lb1 * x[1] - this.a1 * ly[1] - this.a2 * ly[2]) / this.a0;
                    lo[i] = (this.lb0 * (ly[0] + ly[2]) + this.lb1 * ly[1] - this.a1 * lz[1] - this.a2 * lz[2]) / this.a0;
                    hy[0] = (bi[i] - 2.0f * x[1] + x[2] - this.a1 * hy[1] - this.a2 * hy[2]) / this.a0;
                    hi[i] = (hy[0] - 2.0f * hy[1] + hy[2] - this.a1 * hz[1] - this.a2 * hz[2]) / this.a0;
                    x[2] = x[1];
                    x[1] = bi[i];
                    ly[2] = ly[1];
                    ly[1] = ly[0];
                    lz[2] = lz[1];
                    lz[1] = lo[i];
                    hy[2] = hy[1];
                    hy[1] = hy[0];
                    hz[2] = hz[1];
                    hz[1] = hi[i];
                }
            }
        } else {
            float[] bi = this.bufIn[0];
            float[] lo = this.bufOut[0];
            float[] hi = this.bufOut[1];
            for (int i = 0; i < this.bufferSize; ++i) {
                this.ly0 = (this.lb0 * (bi[i] + this.x2) + this.lb1 * this.x1 - this.a1 * this.ly1 - this.a2 * this.ly2) / this.a0;
                lo[i] = (this.lb0 * (this.ly0 + this.ly2) + this.lb1 * this.ly1 - this.a1 * this.lz1 - this.a2 * this.lz2) / this.a0;
                this.hy0 = (bi[i] - 2.0f * this.x1 + this.x2 - this.a1 * this.hy1 - this.a2 * this.hy2) / this.a0;
                hi[i] = (this.hy0 - 2.0f * this.hy1 + this.hy2 - this.a1 * this.hz1 - this.a2 * this.hz2) / this.a0;
                this.x2 = this.x1;
                this.x1 = bi[i];
                this.ly2 = this.ly1;
                this.ly1 = this.ly0;
                this.lz2 = this.lz1;
                this.lz1 = lo[i];
                this.hy2 = this.hy1;
                this.hy1 = this.hy0;
                this.hz2 = this.hz1;
                this.hz1 = hi[i];
            }
        }
    }

    private final void calcVals() {
        this.k = (float)Math.tan(this.freq * this.pi_sr);
        this.lb0 = this.k * this.k;
        this.lb1 = 2.0f * this.lb0;
        this.a0 = this.lb0 + SQRT2 * this.k + 1.0f;
        this.a1 = 2.0f * (this.lb0 - 1.0f);
        this.a2 = this.lb0 - SQRT2 * this.k + 1.0f;
    }

    public void reset() {
        this.hy1 = 0.0f;
        this.hy2 = 0.0f;
        this.hz1 = 0.0f;
        this.hz2 = 0.0f;
        this.ly1 = 0.0f;
        this.ly2 = 0.0f;
        this.lz1 = 0.0f;
        this.lz2 = 0.0f;
    }

    public float getFrequency() {
        return this.freq;
    }

    public CrossoverFilter setFrequency(float freq) {
        this.freq = freq;
        this.freqUGen = null;
        this.calcVals();
        return this;
    }

    public CrossoverFilter setFrequency(UGen freqUGen) {
        if (freqUGen == null) {
            this.setFrequency(this.freq);
        } else {
            this.freqUGen = freqUGen;
            freqUGen.update();
            this.freq = freqUGen.getValue();
            this.calcVals();
        }
        return this;
    }

    public UGen getFrequencyUGen() {
        return this.freqUGen;
    }

    @Deprecated
    public float getFreq() {
        return this.getFrequency();
    }

    @Deprecated
    public CrossoverFilter setFreq(float freq) {
        return this.setFrequency(freq);
    }

    @Deprecated
    public CrossoverFilter setFreq(UGen freqUGen) {
        return this.setFrequency(freqUGen);
    }

    @Deprecated
    public UGen getFreqUGen() {
        return this.getFrequencyUGen();
    }

    public int getChannels() {
        return this.channels;
    }

    @Override
    public DataBeadReceiver sendData(DataBead db) {
        UGen u = db.getUGen("frequency");
        if (u == null) {
            this.setFrequency(db.getFloat("frequency", this.freq));
        } else {
            this.setFrequency(u);
        }
        return this;
    }

    @Override
    public void messageReceived(Bead message) {
        if (message instanceof DataBead) {
            this.sendData((DataBead)message);
        }
    }

    public CrossoverFilter drawFromLowOutput(UGen target) {
        for (int i = 0; i < target.getIns() && i < this.channels; ++i) {
            target.addInput(i, this, i * 2);
        }
        return this;
    }

    public CrossoverFilter drawFromLowOutput(int channel, UGen target, int targetInputIndex) {
        target.addInput(targetInputIndex, this, channel * 2);
        return this;
    }

    public CrossoverFilter drawFromHighOutput(UGen target) {
        for (int i = 0; i < target.getIns() && i < this.channels; ++i) {
            target.addInput(i, this, i * 2 + 1);
        }
        return this;
    }

    public CrossoverFilter drawFromHighOutput(int channel, UGen target, int targetInputIndex) {
        target.addInput(targetInputIndex, this, channel * 2 + 1);
        return this;
    }
}

