/*
 * Decompiled with CFR 0.152.
 */
package beads;

import beads.AudioContext;
import beads.Bead;
import beads.BeadArray;
import beads.Clicker;
import beads.IntegerBead;
import beads.Static;
import beads.UGen;
import java.util.ArrayList;

public class Clock
extends UGen
implements IntegerBead {
    private UGen intervalEnvelope;
    private double point;
    private long count;
    private int ticksPerBeat;
    private BeadArray listeners;
    private boolean click;
    private float clickStrength;
    private double[] subticks;

    public Clock(AudioContext context) {
        this(context, 1000.0f);
    }

    public Clock() {
        this(Clock.getDefaultContext());
    }

    public Clock(AudioContext context, float interval) {
        this(context, new Static(context, interval));
        this.ticksPerBeat = 16;
    }

    public Clock(float interval) {
        this(Clock.getDefaultContext(), interval);
        if (Clock.getDefaultContext() != null) {
            Clock.getDefaultContext().out.addDependent(this);
        }
    }

    public Clock(AudioContext context, UGen env) {
        super(context, 0, 0);
        this.intervalEnvelope = env;
        this.listeners = new BeadArray();
        this.reset();
        this.ticksPerBeat = 16;
        this.clickStrength = 0.1f;
        this.subticks = new double[context.getBufferSize()];
    }

    public Clock(UGen env) {
        this(Clock.getDefaultContext(), env);
        if (Clock.getDefaultContext() != null) {
            Clock.getDefaultContext().out.addDependent(this);
        }
    }

    public boolean isClicking() {
        return this.click;
    }

    public void setClick(boolean click) {
        this.click = click;
    }

    public void addMessageListener(Bead newListener) {
        this.listeners.add(newListener);
    }

    public void removeMessageListener(Bead newListener) {
        this.listeners.remove(newListener);
    }

    public ArrayList<Bead> getMessageListeners() {
        return (ArrayList)this.listeners.getBeads().clone();
    }

    public void reset() {
        this.point = 0.0;
        this.count = -1L;
    }

    public long getCount() {
        return (int)Math.floor(this.point);
    }

    public void setIntervalEnvelope(UGen intervalEnvelope) {
        this.intervalEnvelope = intervalEnvelope;
    }

    public UGen getIntervalEnvelope() {
        return this.intervalEnvelope;
    }

    public UGen getIntervalUGen() {
        return this.intervalEnvelope;
    }

    public float getTempo() {
        return 60000.0f / Math.abs(this.intervalEnvelope.getValue());
    }

    @Override
    public void calculateBuffer() {
        this.intervalEnvelope.update();
        for (int i = 0; i < this.bufferSize; ++i) {
            boolean backwards;
            this.subticks[i] = this.point;
            double interval = this.intervalEnvelope.getValueDouble(0, i);
            double value = Math.max(1.0, Math.abs(interval) / (double)this.ticksPerBeat);
            boolean bl = backwards = interval < 0.0;
            if (backwards) {
                value *= -1.0;
            }
            this.point += 1.0 / this.context.msToSamples(value);
            while (!backwards && this.point >= (double)(this.count + 1L)) {
                this.tick();
                this.count = (long)((double)this.count + Math.signum(interval));
            }
            while (backwards && this.point <= (double)this.count) {
                this.tick();
                this.count = (long)((double)this.count + Math.signum(interval));
            }
        }
    }

    private void tick() {
        if (this.click && this.isBeat()) {
            this.context.out.addInput(new Clicker(this.context, this.clickStrength));
        }
        this.listeners.message(this);
    }

    @Override
    public int getInt() {
        return (int)this.getCount();
    }

    public int getTicksPerBeat() {
        return this.ticksPerBeat;
    }

    public void setTicksPerBeat(int ticksPerBeat) {
        this.ticksPerBeat = Math.max(1, ticksPerBeat);
    }

    public boolean isBeat() {
        return this.getCount() % (long)this.ticksPerBeat == 0L;
    }

    public boolean isBeat(int mod) {
        return this.isBeat() && this.getBeatCount() % mod == 0;
    }

    public int getBeatCount() {
        return (int)(this.getCount() / (long)this.ticksPerBeat);
    }

    public double getSubTickAtIndex(int i) {
        return this.subticks[i];
    }

    public double getSubTickNow() {
        return this.point;
    }

    public void clearMessageListeners() {
        this.listeners.clear();
    }
}

