/*
 * Decompiled with CFR 0.152.
 */
package org.jaudiolibs.jnajack.util;

import java.nio.FloatBuffer;
import java.util.EnumSet;
import org.jaudiolibs.jnajack.Jack;
import org.jaudiolibs.jnajack.JackClient;
import org.jaudiolibs.jnajack.JackException;
import org.jaudiolibs.jnajack.JackOptions;
import org.jaudiolibs.jnajack.JackPort;
import org.jaudiolibs.jnajack.JackPortFlags;
import org.jaudiolibs.jnajack.JackPortType;
import org.jaudiolibs.jnajack.JackProcessCallback;
import org.jaudiolibs.jnajack.JackShutdownCallback;
import org.jaudiolibs.jnajack.JackStatus;

@Deprecated
public class SimpleAudioClient {
    private JackClient client;
    private Processor processor;
    private Callback callback;
    private ShutDownHook shutDownHook;
    private JackPort[] inputPorts;
    private JackPort[] outputPorts;
    private FloatBuffer[] inputBuffers;
    private FloatBuffer[] outputBuffers;
    private float samplerate;
    private int buffersize;
    private boolean autoconnect;
    private volatile boolean active;

    private SimpleAudioClient(JackClient client, JackPort[] inputPorts, JackPort[] outputPorts, boolean autoconnect, Processor processor) throws JackException {
        this.client = client;
        this.inputPorts = inputPorts;
        this.outputPorts = outputPorts;
        this.inputBuffers = new FloatBuffer[inputPorts.length];
        this.outputBuffers = new FloatBuffer[outputPorts.length];
        this.autoconnect = autoconnect;
        this.processor = processor;
        this.callback = new Callback();
        this.shutDownHook = new ShutDownHook();
        client.onShutdown(this.shutDownHook);
    }

    public void activate() throws JackException {
        try {
            this.samplerate = this.client.getSampleRate();
            System.out.println("Sample rate = " + this.samplerate);
            this.buffersize = this.client.getBufferSize();
            System.out.println("Buffersize = " + this.buffersize);
            this.processor.setup(this.samplerate, this.buffersize);
            this.active = true;
            this.client.setProcessCallback(this.callback);
            this.client.activate();
            if (this.autoconnect) {
                this.doAutoconnect();
            }
        }
        catch (Exception ex) {
            this.active = false;
            throw new JackException("Could not activate Jack client");
        }
    }

    private void doAutoconnect() throws JackException {
        int i;
        Jack jack = Jack.getInstance();
        String[] physical = jack.getPorts(this.client, null, JackPortType.AUDIO, EnumSet.of(JackPortFlags.JackPortIsInput, JackPortFlags.JackPortIsPhysical));
        int count = Math.min(this.outputPorts.length, physical.length);
        for (i = 0; i < count; ++i) {
            jack.connect(this.client, this.outputPorts[i].getName(), physical[i]);
        }
        physical = jack.getPorts(this.client, null, JackPortType.AUDIO, EnumSet.of(JackPortFlags.JackPortIsOutput, JackPortFlags.JackPortIsPhysical));
        count = Math.min(this.inputPorts.length, physical.length);
        for (i = 0; i < count; ++i) {
            jack.connect(this.client, physical[i], this.inputPorts[i].getName());
        }
    }

    public void shutdown() {
        this.active = false;
        this.client.deactivate();
        this.client.close();
    }

    private void processBuffers(int nframes) {
        int i;
        for (i = 0; i < this.inputPorts.length; ++i) {
            this.inputBuffers[i] = this.inputPorts[i].getFloatBuffer();
        }
        for (i = 0; i < this.outputPorts.length; ++i) {
            this.outputBuffers[i] = this.outputPorts[i].getFloatBuffer();
        }
        this.processor.process(this.inputBuffers, this.outputBuffers);
    }

    public static SimpleAudioClient create(String name, String[] inputs, String[] outputs, Processor processor) throws JackException {
        return SimpleAudioClient.create(name, inputs, outputs, false, false, processor);
    }

    public static SimpleAudioClient create(String name, String[] inputs, String[] outputs, boolean autoconnect, boolean startServer, Processor processor) throws JackException {
        JackClient client;
        if (name == null || processor == null) {
            throw new NullPointerException();
        }
        if (inputs == null) {
            inputs = new String[]{};
        }
        if (outputs == null) {
            outputs = new String[]{};
        }
        Jack jack = Jack.getInstance();
        EnumSet<JackOptions> options = startServer ? EnumSet.noneOf(JackOptions.class) : EnumSet.of(JackOptions.JackNoStartServer);
        EnumSet<JackStatus> status = EnumSet.noneOf(JackStatus.class);
        try {
            client = jack.openClient(name, options, status);
        }
        catch (JackException ex) {
            System.out.println("ERROR : Status : " + status);
            throw ex;
        }
        JackPort[] inputPorts = new JackPort[inputs.length];
        EnumSet<JackPortFlags> flags = EnumSet.of(JackPortFlags.JackPortIsInput);
        for (int i = 0; i < inputs.length; ++i) {
            inputPorts[i] = client.registerPort(inputs[i], JackPortType.AUDIO, flags);
        }
        JackPort[] outputPorts = new JackPort[outputs.length];
        flags = EnumSet.of(JackPortFlags.JackPortIsOutput);
        for (int i = 0; i < outputs.length; ++i) {
            outputPorts[i] = client.registerPort(outputs[i], JackPortType.AUDIO, flags);
        }
        return new SimpleAudioClient(client, inputPorts, outputPorts, autoconnect, processor);
    }

    public static interface Processor {
        public void setup(float var1, int var2);

        public void process(FloatBuffer[] var1, FloatBuffer[] var2);

        public void shutdown();
    }

    private class ShutDownHook
    implements JackShutdownCallback {
        private ShutDownHook() {
        }

        @Override
        public void clientShutdown(JackClient client) {
            SimpleAudioClient.this.active = false;
            SimpleAudioClient.this.processor.shutdown();
        }
    }

    private class Callback
    implements JackProcessCallback {
        private Callback() {
        }

        @Override
        public boolean process(JackClient client, int nframes) {
            if (!SimpleAudioClient.this.active) {
                return false;
            }
            try {
                SimpleAudioClient.this.processBuffers(nframes);
                return true;
            }
            catch (Exception ex) {
                System.out.println("ERROR : " + ex);
                SimpleAudioClient.this.active = false;
                return false;
            }
        }
    }
}

