/*
 * Decompiled with CFR 0.152.
 */
package org.jaudiolibs.jnajack;

import com.sun.jna.NativeLong;
import com.sun.jna.Pointer;
import com.sun.jna.ptr.ByteByReference;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jaudiolibs.jnajack.Jack;
import org.jaudiolibs.jnajack.JackBufferSizeCallback;
import org.jaudiolibs.jnajack.JackClientRegistrationCallback;
import org.jaudiolibs.jnajack.JackException;
import org.jaudiolibs.jnajack.JackGraphOrderCallback;
import org.jaudiolibs.jnajack.JackPort;
import org.jaudiolibs.jnajack.JackPortConnectCallback;
import org.jaudiolibs.jnajack.JackPortFlags;
import org.jaudiolibs.jnajack.JackPortRegistrationCallback;
import org.jaudiolibs.jnajack.JackPortType;
import org.jaudiolibs.jnajack.JackPosition;
import org.jaudiolibs.jnajack.JackProcessCallback;
import org.jaudiolibs.jnajack.JackSampleRateCallback;
import org.jaudiolibs.jnajack.JackShutdownCallback;
import org.jaudiolibs.jnajack.JackSyncCallback;
import org.jaudiolibs.jnajack.JackTimebaseCallback;
import org.jaudiolibs.jnajack.JackTransportState;
import org.jaudiolibs.jnajack.JackXrunCallback;
import org.jaudiolibs.jnajack.NativeToJavaTypeConverter;
import org.jaudiolibs.jnajack.lowlevel.JackLibrary;

public class JackClient {
    private static final Logger LOG = Logger.getLogger(JackClient.class.getName());
    private static final String CALL_ERROR_MSG = "Error calling native lib";
    private static final int FRAME_SIZE = 4;
    final Jack jack;
    final JackLibrary jackLib;
    final String name;
    JackLibrary._jack_client clientPtr;
    private ProcessCallbackWrapper processCallback;
    private XRunCallbackWrapper xrunCallback;
    private BufferSizeCallbackWrapper buffersizeCallback;
    private SampleRateCallbackWrapper samplerateCallback;
    private ClientRegistrationCallbackWrapper clientRegistrationCallback;
    private GraphOrderCallbackWrapper graphOrderChangeCallback;
    private PortRegistrationCallbackWrapper portRegistrationCallback;
    private PortConnectCallbackWrapper portConnectCallback;
    private ShutdownCallback shutdownCallback;
    private JackShutdownCallback userShutdownCallback;
    private TimebaseCallbackWrapper timebaseCallback;
    private SyncCallbackWrapper syncCallback;
    private JackPort[] ports;

    JackClient(String name, Jack jack, JackLibrary._jack_client client) {
        this.name = name;
        this.jack = jack;
        this.jackLib = jack.jackLib;
        this.clientPtr = client;
        this.shutdownCallback = new ShutdownCallback();
        try {
            this.jackLib.jack_on_shutdown(client, this.shutdownCallback, null);
        }
        catch (Throwable e) {
            LOG.log(Level.SEVERE, CALL_ERROR_MSG, e);
        }
        this.ports = new JackPort[0];
    }

    public JackPort registerPort(String name, JackPortType type, EnumSet<JackPortFlags> flags) throws JackException {
        int fl = 0;
        for (JackPortFlags flag : flags) {
            fl |= flag.getIntValue();
        }
        String typeString = type.getTypeString();
        NativeLong bufferSize = new NativeLong((long)type.getBufferSize());
        NativeLong nativeFlags = new NativeLong((long)fl);
        JackLibrary._jack_port portPtr = null;
        try {
            portPtr = this.jackLib.jack_port_register(this.clientPtr, name, typeString, nativeFlags, bufferSize);
        }
        catch (Throwable e) {
            LOG.log(Level.SEVERE, CALL_ERROR_MSG, e);
            portPtr = null;
        }
        if (portPtr == null) {
            throw new JackException("Could not register port");
        }
        JackPort port = new JackPort(name, this, type, portPtr);
        this.addToPortArray(port);
        return port;
    }

    public JackPort registerPort(String name, JackPortType type, JackPortFlags flag) throws JackException {
        return this.registerPort(name, type, EnumSet.of(flag));
    }

    private void addToPortArray(JackPort port) {
        JackPort[] pts = this.ports;
        ArrayList<JackPort> portList = new ArrayList<JackPort>(Arrays.asList(pts));
        portList.add(port);
        this.ports = pts = portList.toArray(new JackPort[portList.size()]);
    }

    public int unregisterPort(JackPort port) throws JackException {
        try {
            int ret = this.jackLib.jack_port_unregister(this.clientPtr, port.portPtr);
            this.removePortFromArray(port);
            return ret;
        }
        catch (Throwable e) {
            LOG.log(Level.SEVERE, CALL_ERROR_MSG, e);
            throw new JackException(e);
        }
    }

    private void removePortFromArray(JackPort port) {
        JackPort[] pts = this.ports;
        ArrayList<JackPort> portList = new ArrayList<JackPort>(Arrays.asList(pts));
        portList.remove(port);
        this.ports = pts = portList.toArray(new JackPort[portList.size()]);
    }

    public void setProcessCallback(JackProcessCallback callback) throws JackException {
        if (callback == null) {
            try {
                this.jackLib.jack_set_process_callback(this.clientPtr, null, null);
                this.processCallback = null;
            }
            catch (Throwable e) {
                LOG.log(Level.SEVERE, CALL_ERROR_MSG, e);
                throw new JackException(e);
            }
        }
        ProcessCallbackWrapper wrapper = new ProcessCallbackWrapper(callback);
        int ret = -1;
        try {
            ret = this.jackLib.jack_set_process_callback(this.clientPtr, wrapper, null);
        }
        catch (Throwable e) {
            LOG.log(Level.SEVERE, CALL_ERROR_MSG, e);
            throw new JackException(e);
        }
        if (ret == 0) {
            this.processCallback = wrapper;
        } else {
            throw new JackException();
        }
    }

    public void setXrunCallback(JackXrunCallback callback) throws JackException {
        if (callback == null) {
            try {
                this.jackLib.jack_set_xrun_callback(this.clientPtr, null, null);
                this.xrunCallback = null;
            }
            catch (Throwable e) {
                LOG.log(Level.SEVERE, CALL_ERROR_MSG, e);
                throw new JackException(e);
            }
        }
        XRunCallbackWrapper wrapper = new XRunCallbackWrapper(callback);
        int ret = -1;
        try {
            ret = this.jackLib.jack_set_xrun_callback(this.clientPtr, wrapper, null);
        }
        catch (Throwable e) {
            LOG.log(Level.SEVERE, CALL_ERROR_MSG, e);
            throw new JackException(e);
        }
        if (ret == 0) {
            this.xrunCallback = wrapper;
        } else {
            throw new JackException();
        }
    }

    public void setGraphOrderCallback(JackGraphOrderCallback callback) throws JackException {
        if (callback == null) {
            throw new NullPointerException("Passed callback is null.");
        }
        try {
            this.graphOrderChangeCallback = new GraphOrderCallbackWrapper(callback);
            this.jackLib.jack_set_graph_order_callback(this.clientPtr, this.graphOrderChangeCallback, null);
        }
        catch (Throwable e) {
            LOG.log(Level.SEVERE, CALL_ERROR_MSG, e);
        }
    }

    public void setClientRegistrationCallback(JackClientRegistrationCallback callback) throws JackException {
        if (callback == null) {
            throw new NullPointerException("Passed callback is null.");
        }
        try {
            this.clientRegistrationCallback = new ClientRegistrationCallbackWrapper(callback);
            this.jackLib.jack_set_client_registration_callback(this.clientPtr, this.clientRegistrationCallback, null);
        }
        catch (Throwable e) {
            LOG.log(Level.SEVERE, CALL_ERROR_MSG, e);
        }
    }

    public void setPortConnectCallback(JackPortConnectCallback callback) throws JackException {
        if (callback == null) {
            throw new NullPointerException("Passed callback is null.");
        }
        try {
            this.portConnectCallback = new PortConnectCallbackWrapper(callback);
            this.jackLib.jack_set_port_connect_callback(this.clientPtr, this.portConnectCallback, null);
        }
        catch (Throwable e) {
            LOG.log(Level.SEVERE, CALL_ERROR_MSG, e);
        }
    }

    public void setPortRegistrationCallback(JackPortRegistrationCallback callback) throws JackException {
        if (callback == null) {
            throw new NullPointerException("Passed callback is null.");
        }
        try {
            this.portRegistrationCallback = new PortRegistrationCallbackWrapper(callback);
            this.jackLib.jack_set_port_registration_callback(this.clientPtr, this.portRegistrationCallback, null);
        }
        catch (Throwable e) {
            LOG.log(Level.SEVERE, CALL_ERROR_MSG, e);
        }
    }

    public void setBuffersizeCallback(JackBufferSizeCallback callback) throws JackException {
        if (callback == null) {
            throw new NullPointerException();
        }
        BufferSizeCallbackWrapper wrapper = new BufferSizeCallbackWrapper(callback);
        int ret = -1;
        try {
            ret = this.jackLib.jack_set_buffer_size_callback(this.clientPtr, wrapper, null);
        }
        catch (Throwable e) {
            LOG.log(Level.SEVERE, CALL_ERROR_MSG, e);
            throw new JackException(e);
        }
        if (ret != 0) {
            throw new JackException();
        }
        this.buffersizeCallback = wrapper;
    }

    public void setSampleRateCallback(JackSampleRateCallback callback) throws JackException {
        if (callback == null) {
            throw new NullPointerException();
        }
        SampleRateCallbackWrapper wrapper = new SampleRateCallbackWrapper(callback);
        int ret = -1;
        try {
            ret = this.jackLib.jack_set_sample_rate_callback(this.clientPtr, wrapper, null);
        }
        catch (Throwable e) {
            LOG.log(Level.SEVERE, CALL_ERROR_MSG, e);
            throw new JackException(e);
        }
        if (ret != 0) {
            throw new JackException();
        }
        this.samplerateCallback = wrapper;
    }

    public void setTimebaseCallback(JackTimebaseCallback callback, boolean conditional) throws JackException {
        if (callback == null) {
            throw new NullPointerException();
        }
        TimebaseCallbackWrapper wrapper = new TimebaseCallbackWrapper(callback);
        int ret = -1;
        try {
            ret = this.jackLib.jack_set_timebase_callback(this.clientPtr, conditional ? 1 : 0, wrapper, null);
        }
        catch (Throwable e) {
            LOG.log(Level.SEVERE, CALL_ERROR_MSG, e);
            throw new JackException(e);
        }
        if (ret != 0) {
            throw new JackException();
        }
        this.timebaseCallback = wrapper;
    }

    public void setSyncCallback(JackSyncCallback callback) throws JackException {
        if (callback == null) {
            throw new NullPointerException();
        }
        SyncCallbackWrapper wrapper = new SyncCallbackWrapper(callback);
        int ret = -1;
        try {
            this.jackLib.jack_set_sync_callback(this.clientPtr, wrapper, null);
        }
        catch (Throwable e) {
            LOG.log(Level.SEVERE, CALL_ERROR_MSG, e);
            throw new JackException(e);
        }
        if (ret != 0) {
            throw new JackException();
        }
        this.syncCallback = wrapper;
    }

    public void onShutdown(JackShutdownCallback callback) throws JackException {
        this.userShutdownCallback = callback;
    }

    public void activate() throws JackException {
        int ret = -1;
        try {
            ret = this.jackLib.jack_activate(this.clientPtr);
        }
        catch (Throwable e) {
            LOG.log(Level.SEVERE, CALL_ERROR_MSG, e);
            throw new JackException(e);
        }
        if (ret != 0) {
            throw new JackException();
        }
    }

    public void deactivate() {
        try {
            this.jackLib.jack_deactivate(this.clientPtr);
        }
        catch (Throwable e) {
            LOG.log(Level.SEVERE, CALL_ERROR_MSG, e);
        }
    }

    public synchronized void close() {
        try {
            if (this.clientPtr != null) {
                this.jackLib.jack_client_close(this.clientPtr);
            }
        }
        catch (Throwable e) {
            LOG.log(Level.SEVERE, CALL_ERROR_MSG, e);
        }
        finally {
            this.clientPtr = null;
        }
    }

    public JackTransportState transportQuery(JackPosition position) throws JackException {
        try {
            int state = this.jackLib.jack_transport_query(this.clientPtr, position.getNativePosition());
            return JackTransportState.forVal(state);
        }
        catch (Throwable e) {
            LOG.log(Level.SEVERE, CALL_ERROR_MSG, e);
            throw new JackException(e);
        }
    }

    public boolean transportLocate(int frame) throws JackException {
        try {
            return this.jackLib.jack_transport_locate(this.clientPtr, frame) == 0;
        }
        catch (Throwable e) {
            LOG.log(Level.SEVERE, CALL_ERROR_MSG, e);
            throw new JackException(e);
        }
    }

    public long getCurrentTransportFrame() throws JackException {
        try {
            return NativeToJavaTypeConverter.nuint32ToJlong(this.jackLib.jack_get_current_transport_frame(this.clientPtr));
        }
        catch (Throwable e) {
            LOG.log(Level.SEVERE, CALL_ERROR_MSG, e);
            throw new JackException(e);
        }
    }

    public boolean transportReposition(JackPosition position) throws JackException {
        try {
            return this.jackLib.jack_transport_reposition(this.clientPtr, position.getNativePosition()) == 0;
        }
        catch (Throwable e) {
            LOG.log(Level.SEVERE, CALL_ERROR_MSG, e);
            throw new JackException(e);
        }
    }

    public void transportStart() throws JackException {
        try {
            this.jackLib.jack_transport_start(this.clientPtr);
        }
        catch (Throwable e) {
            LOG.log(Level.SEVERE, CALL_ERROR_MSG, e);
            throw new JackException(e);
        }
    }

    public void transportStop() throws JackException {
        try {
            this.jackLib.jack_transport_stop(this.clientPtr);
        }
        catch (Throwable e) {
            LOG.log(Level.SEVERE, CALL_ERROR_MSG, e);
            throw new JackException(e);
        }
    }

    public boolean setSyncTimeout(long timeout) throws JackException {
        try {
            return this.jackLib.jack_set_sync_timeout(this.clientPtr, timeout) == 0;
        }
        catch (Throwable e) {
            LOG.log(Level.SEVERE, CALL_ERROR_MSG, e);
            throw new JackException(e);
        }
    }

    public void releaseTimebase() {
        try {
            this.jackLib.jack_release_timebase(this.clientPtr);
        }
        catch (Throwable t) {
            LOG.log(Level.SEVERE, CALL_ERROR_MSG, t);
        }
    }

    public String getName() {
        return this.name;
    }

    public int getSampleRate() throws JackException {
        try {
            return this.jackLib.jack_get_sample_rate(this.clientPtr);
        }
        catch (Throwable e) {
            LOG.log(Level.SEVERE, CALL_ERROR_MSG, e);
            throw new JackException(e);
        }
    }

    public int getBufferSize() throws JackException {
        try {
            return this.jackLib.jack_get_buffer_size(this.clientPtr);
        }
        catch (Throwable e) {
            LOG.log(Level.SEVERE, CALL_ERROR_MSG, e);
            throw new JackException(e);
        }
    }

    public long getLastFrameTime() throws JackException {
        try {
            return NativeToJavaTypeConverter.nuint32ToJlong(this.jackLib.jack_last_frame_time(this.clientPtr));
        }
        catch (Throwable e) {
            LOG.log(Level.SEVERE, CALL_ERROR_MSG, e);
            throw new JackException(e);
        }
    }

    public long getFrameTime() throws JackException {
        try {
            return NativeToJavaTypeConverter.nuint32ToJlong(this.jackLib.jack_frame_time(this.clientPtr));
        }
        catch (Throwable e) {
            LOG.log(Level.SEVERE, CALL_ERROR_MSG, e);
            throw new JackException(e);
        }
    }

    private void processShutdown() {
        if (this.userShutdownCallback != null) {
            this.userShutdownCallback.clientShutdown(this);
        }
    }

    private static class EXT_jack_position_t
    extends JackLibrary.jack_position_t {
        private EXT_jack_position_t(Pointer ptr) {
            super(ptr, 0);
            this.setAutoSynch(false);
        }
    }

    private static class LRUCache<K, V>
    extends LinkedHashMap<K, V> {
        private final int maxSize;

        private LRUCache(int maxSize) {
            super(maxSize, 0.75f, true);
            this.maxSize = maxSize;
        }

        @Override
        protected boolean removeEldestEntry(Map.Entry<K, V> eldest) {
            return this.size() >= this.maxSize;
        }
    }

    private class SyncCallbackWrapper
    implements JackLibrary.JackSyncCallback {
        private final JackSyncCallback callback;
        private final JackPosition position;
        private final LRUCache<Pointer, EXT_jack_position_t> structs;

        public SyncCallbackWrapper(JackSyncCallback cb) {
            this.callback = cb;
            this.position = new JackPosition(null);
            this.structs = new LRUCache(4);
            JackClient.this.jack.setupCTI(this);
        }

        @Override
        public int invoke(int state, Pointer pos, Pointer arg) {
            int ret = -1;
            try {
                JackTransportState stateEnum = JackTransportState.forVal(state);
                EXT_jack_position_t nativePos = (EXT_jack_position_t)((Object)this.structs.get(pos));
                if (nativePos == null) {
                    nativePos = new EXT_jack_position_t(pos);
                    this.structs.put(pos, nativePos);
                }
                nativePos.read();
                this.position.setNativePosition(nativePos);
                if (this.callback.syncPosition(JackClient.this, this.position, stateEnum)) {
                    ret = 0;
                }
            }
            catch (Throwable e) {
                LOG.log(Level.SEVERE, "Error in timebase callback", e);
            }
            return ret;
        }
    }

    private class TimebaseCallbackWrapper
    implements JackLibrary.JackTimebaseCallback {
        private final JackTimebaseCallback callback;
        private final JackPosition position;
        private final LRUCache<Pointer, EXT_jack_position_t> structs;

        public TimebaseCallbackWrapper(JackTimebaseCallback cb) {
            this.callback = cb;
            this.position = new JackPosition(null);
            this.structs = new LRUCache(4);
            JackClient.this.jack.setupCTI(this);
        }

        @Override
        public void invoke(int state, int nframes, Pointer pos, int new_pos, Pointer arg) {
            try {
                JackTransportState stateEnum = JackTransportState.forVal(state);
                EXT_jack_position_t nativePos = (EXT_jack_position_t)((Object)this.structs.get(pos));
                if (nativePos == null) {
                    nativePos = new EXT_jack_position_t(pos);
                    this.structs.put(pos, nativePos);
                }
                nativePos.read();
                this.position.setNativePosition(nativePos);
                this.callback.updatePosition(JackClient.this, stateEnum, nframes, this.position, new_pos != 0);
                nativePos.write();
            }
            catch (Throwable e) {
                LOG.log(Level.SEVERE, "Error in timebase callback", e);
            }
        }
    }

    private class SampleRateCallbackWrapper
    implements JackLibrary.JackSampleRateCallback {
        JackSampleRateCallback callback;

        SampleRateCallbackWrapper(JackSampleRateCallback callback) {
            this.callback = callback;
        }

        @Override
        public int invoke(int nframes, Pointer arg) {
            int ret = -1;
            try {
                this.callback.sampleRateChanged(JackClient.this, nframes);
                ret = 0;
            }
            catch (Throwable e) {
                LOG.log(Level.SEVERE, "Error in samplerate callback", e);
                ret = -1;
            }
            return ret;
        }
    }

    private class GraphOrderCallbackWrapper
    implements JackLibrary.JackGraphOrderCallback {
        JackGraphOrderCallback callback;

        GraphOrderCallbackWrapper(JackGraphOrderCallback callback) {
            this.callback = callback;
        }

        @Override
        public int invoke(Pointer arg) {
            this.callback.graphOrderChanged(JackClient.this);
            return 0;
        }
    }

    private class PortRegistrationCallbackWrapper
    implements JackLibrary.JackPortRegistrationCallback {
        JackPortRegistrationCallback callback;

        PortRegistrationCallbackWrapper(JackPortRegistrationCallback callback) {
            this.callback = callback;
        }

        @Override
        public void invoke(int port, int int1, Pointer arg) {
            try {
                JackLibrary._jack_port p = JackClient.this.jackLib.jack_port_by_id(JackClient.this.clientPtr, port);
                String portName = JackClient.this.jackLib.jack_port_name(p);
                if (int1 != 0) {
                    this.callback.portRegistered(JackClient.this, portName);
                } else {
                    this.callback.portUnregistered(JackClient.this, portName);
                }
            }
            catch (Throwable e) {
                LOG.log(Level.SEVERE, "Error in port registration callback", e);
            }
        }
    }

    private class ClientRegistrationCallbackWrapper
    implements JackLibrary.JackClientRegistrationCallback {
        JackClientRegistrationCallback callback;

        ClientRegistrationCallbackWrapper(JackClientRegistrationCallback callback) {
            this.callback = callback;
        }

        @Override
        public void invoke(ByteByReference name, int register, Pointer arg) {
            try {
                String nameString = name.getPointer().getString(0L);
                if (register != 0) {
                    this.callback.clientRegistered(JackClient.this, nameString);
                } else {
                    this.callback.clientUnregistered(JackClient.this, nameString);
                }
            }
            catch (Throwable e) {
                LOG.log(Level.SEVERE, "Error in client registration callback", e);
            }
        }
    }

    private class PortConnectCallbackWrapper
    implements JackLibrary.JackPortConnectCallback {
        JackPortConnectCallback callback;

        PortConnectCallbackWrapper(JackPortConnectCallback callback) {
            this.callback = callback;
        }

        @Override
        public void invoke(int a, int b, int connect, Pointer arg) {
            try {
                JackLibrary._jack_port pA = JackClient.this.jackLib.jack_port_by_id(JackClient.this.clientPtr, a);
                JackLibrary._jack_port pB = JackClient.this.jackLib.jack_port_by_id(JackClient.this.clientPtr, b);
                String portNameA = JackClient.this.jackLib.jack_port_name(pA);
                String portNameB = JackClient.this.jackLib.jack_port_name(pB);
                if (connect != 0) {
                    this.callback.portsConnected(JackClient.this, portNameA, portNameB);
                } else {
                    this.callback.portsDisconnected(JackClient.this, portNameA, portNameB);
                }
            }
            catch (Throwable e) {
                LOG.log(Level.SEVERE, "Error in port connection callback", e);
            }
        }
    }

    private class BufferSizeCallbackWrapper
    implements JackLibrary.JackBufferSizeCallback {
        JackBufferSizeCallback callback;

        BufferSizeCallbackWrapper(JackBufferSizeCallback callback) {
            this.callback = callback;
        }

        @Override
        public int invoke(int nframes, Pointer arg) {
            int ret = -1;
            try {
                this.callback.buffersizeChanged(JackClient.this, nframes);
                ret = 0;
            }
            catch (Throwable e) {
                LOG.log(Level.SEVERE, "Error in buffersize callback", e);
                ret = -1;
            }
            return ret;
        }
    }

    private class ShutdownCallback
    implements JackLibrary.JackShutdownCallback {
        private ShutdownCallback() {
        }

        @Override
        public void invoke(Pointer arg) {
            JackClient.this.processShutdown();
            JackClient.this.jack.forceThreadDetach();
        }
    }

    private class XRunCallbackWrapper
    implements JackLibrary.JackXRunCallback {
        JackXrunCallback callback;

        XRunCallbackWrapper(JackXrunCallback callback) {
            this.callback = callback;
        }

        @Override
        public int invoke(Pointer arg) {
            int ret = -1;
            try {
                this.callback.xrunOccured(JackClient.this);
            }
            catch (Throwable e) {
                LOG.log(Level.SEVERE, "Error in xrun callback", e);
                ret = -1;
            }
            return ret;
        }
    }

    private class ProcessCallbackWrapper
    implements JackLibrary.JackProcessCallback {
        JackProcessCallback callback;

        ProcessCallbackWrapper(JackProcessCallback callback) {
            this.callback = callback;
            JackClient.this.jack.setupCTI(this);
        }

        @Override
        public int invoke(int nframes) {
            int ret = 1;
            try {
                JackPort[] pts;
                for (JackPort port : pts = JackClient.this.ports) {
                    Pointer ptr = JackClient.this.jackLib.jack_port_get_buffer(port.portPtr, nframes);
                    if (!ptr.equals((Object)port.bufferPtr)) {
                        port.bufferPtr = ptr;
                        if (port.type.equals(JackPortType.AUDIO)) {
                            LOG.log(Level.FINEST, "Creating new audio port buffer");
                            int nbyteframes = nframes * 4;
                            port.byteBuffer = ptr.getByteBuffer(0L, (long)nbyteframes);
                            port.floatBuffer = port.byteBuffer.asFloatBuffer();
                            continue;
                        }
                        if (port.type.equals(JackPortType.MIDI)) {
                            LOG.log(Level.FINEST, "Creating new MIDI port buffer");
                            port.byteBuffer = ptr.getByteBuffer(0L, 0L);
                            port.floatBuffer = port.byteBuffer.asFloatBuffer();
                            continue;
                        }
                        LOG.log(Level.FINEST, "Creating new custom port buffer");
                        port.byteBuffer = ptr.getByteBuffer(0L, (long)port.type.getBufferSize());
                        port.floatBuffer = port.byteBuffer.asFloatBuffer();
                        continue;
                    }
                    port.byteBuffer.rewind();
                    port.floatBuffer.rewind();
                }
                if (this.callback.process(JackClient.this, nframes)) {
                    ret = 0;
                }
            }
            catch (Throwable ex) {
                LOG.log(Level.SEVERE, "Error in process callback", ex);
                ret = 1;
            }
            if (ret != 0) {
                JackClient.this.jack.forceThreadDetach();
            }
            return ret;
        }
    }
}

