/*
 * Decompiled with CFR 0.152.
 */
import beads.AudioContext;
import beads.Gain;
import beads.SampleManager;
import beads.SamplePlayer;
import beads.UGen;
import java.util.ArrayList;
import processing.core.PApplet;
import processing.core.PImage;
import processing.core.PVector;

public class routing
extends PApplet {
    AudioContext ac;
    ArrayList<Spot> spots = new ArrayList();
    ArrayList<Route> routes = new ArrayList();
    ArrayList<Popu> popus = new ArrayList();
    float totalDistance = 0.0f;
    float totalTime = 0.0f;
    float totalCarbon = 0.0f;
    float totalCarbonInterp = 0.0f;
    float budget = 1000.0f;
    float totalDiversity = 0.0f;
    float popularity = 4.0f;
    float artistCost = 0.0f;
    float artistCarbonCost = 0.0f;
    Spot lastSpot;
    int phase = 0;
    PImage[] ministresPic = new PImage[4];
    PImage[] artistePic = new PImage[6];
    PImage popu;
    PImage map;
    String[] spotsTxt;
    float jaugeToSizeScale = 0.5f;
    ArrayList<String> coords = new ArrayList();
    boolean exportCoords = false;
    PImage enfer;
    SamplePlayer musicLoop;
    SamplePlayer eventSfx;
    PImage[] choicesM = new PImage[10];
    int currentChoiceM = 0;
    boolean popuHasMoved = false;
    boolean nextRunDefined = false;

    public void setup() {
        this.ministresPic[0] = this.loadImage(this.dataPath("jack.png"));
        this.ministresPic[1] = this.loadImage(this.dataPath("rachida.png"));
        this.ministresPic[2] = this.loadImage(this.dataPath("cyril.png"));
        this.ministresPic[3] = this.loadImage(this.dataPath("brigitte.png"));
        this.artistePic[0] = this.loadImage(this.dataPath("taylor.png"));
        this.artistePic[1] = this.loadImage(this.dataPath("buffalo.png"));
        this.artistePic[2] = this.loadImage(this.dataPath("bulg.png"));
        this.artistePic[3] = this.loadImage(this.dataPath("twende.png"));
        this.artistePic[4] = this.loadImage(this.dataPath("hamraj.png"));
        this.artistePic[5] = this.loadImage(this.dataPath("sababa5.png"));
        int i = 0;
        while (i < this.choicesM.length) {
            this.choicesM[i] = this.loadImage(this.dataPath("event" + routing.nf((int)i, (int)2) + ".png"));
            ++i;
        }
        this.popu = this.loadImage(this.dataPath("popu.png"));
        this.map = this.loadImage(this.dataPath("map01.png"));
        this.enfer = this.loadImage(this.dataPath("enfer01.jpg"));
        this.spotsTxt = this.loadStrings(this.dataPath("spots.txt"));
        this.ac = AudioContext.getDefaultContext();
        this.musicLoop = new SamplePlayer(SampleManager.sample((String)this.dataPath("Brego01.wav")));
        this.eventSfx = new SamplePlayer(SampleManager.sample((String)this.dataPath("pouet.wav")));
        Gain g = new Gain(1, 0.2f);
        this.musicLoop.pause(true);
        this.eventSfx.pause(true);
        this.eventSfx.setKillOnEnd(false);
        g.addInput((UGen)this.eventSfx);
        g.addInput((UGen)this.musicLoop);
        this.ac.out.addInput((UGen)g);
        this.ac.start();
        this.init();
    }

    public void init() {
        this.totalDistance = 0.0f;
        this.totalTime = 0.0f;
        this.totalCarbon = 0.0f;
        this.totalCarbonInterp = 0.0f;
        this.budget = 1000.0f;
        this.totalDiversity = 0.0f;
        this.popularity = 4.0f;
        this.artistCost = 0.0f;
        this.artistCarbonCost = 0.0f;
        this.popuHasMoved = false;
        this.nextRunDefined = false;
        this.spots = new ArrayList();
        this.routes = new ArrayList();
        this.popus = new ArrayList();
        int lineIndex = 12;
        while (lineIndex + 10 < this.spotsTxt.length) {
            Spot s = new Spot(new PVector(Float.parseFloat(this.spotsTxt[lineIndex + 1]), Float.parseFloat(this.spotsTxt[lineIndex + 2])), Float.parseFloat(this.spotsTxt[lineIndex + 4]));
            s.name = this.spotsTxt[lineIndex];
            s.description = this.spotsTxt[lineIndex + 3];
            s.exclu = Integer.parseInt(this.spotsTxt[lineIndex + 5]);
            s.carbon = Float.parseFloat(this.spotsTxt[lineIndex + 6]);
            s.cout = Float.parseFloat(this.spotsTxt[lineIndex + 7]);
            s.recette = Float.parseFloat(this.spotsTxt[lineIndex + 8]);
            s.diversity = Float.parseFloat(this.spotsTxt[lineIndex + 9]);
            this.spots.add(s);
            lineIndex += 11;
        }
        String[] popuCoordinates = this.loadStrings("popuCoordinates.txt");
        lineIndex = 0;
        while (lineIndex + 1 < popuCoordinates.length) {
            this.popus.add(new Popu(new PVector(Float.parseFloat(popuCoordinates[lineIndex]), Float.parseFloat(popuCoordinates[lineIndex + 1]))));
            lineIndex += 2;
        }
    }

    public void draw() {
        if (this.phase == 0) {
            this.background(255);
            this.fill(0);
            this.textSize(50.0f);
            this.text("Ministre...", 50.0f, 100.0f);
            int x = 0;
            while (x < 2) {
                int y = 0;
                while (y < 2) {
                    this.pushMatrix();
                    this.imageMode(3);
                    this.translate((float)(x + 1) * (float)this.width / 3.0f, (float)(y + 1) * (float)this.height / 3.0f);
                    this.scale(3.0f);
                    this.image(this.ministresPic[x + y * 2], 0.0f, 0.0f);
                    this.popMatrix();
                    ++y;
                }
                ++x;
            }
        } else if (this.phase == 1) {
            this.background(255);
            int x = 0;
            while (x < 3) {
                int y = 0;
                while (y < 2) {
                    this.pushMatrix();
                    this.imageMode(3);
                    this.translate((float)(x + 1) * (float)this.width / 4.0f, (float)(y + 1) * (float)this.height / 3.0f);
                    this.scale(2.0f);
                    this.image(this.artistePic[x + y * 3], 0.0f, 0.0f);
                    this.popMatrix();
                    ++y;
                }
                ++x;
            }
            if (this.mouseX < this.width * 1 / 3 && this.mouseX >= this.width * 0 / 3 && this.mouseY < this.height / 2) {
                this.fill(0);
                this.textSize(50.0f);
                this.text("Taylor Swift", 50.0f, 100.0f);
                this.text("grosse artiste", 50.0f, 150.0f);
            }
            if (this.mouseX < this.width * 2 / 3 && this.mouseX >= this.width * 1 / 3 && this.mouseY < this.height / 2) {
                this.fill(0);
                this.textSize(50.0f);
                this.text("Buffalo Bill", 50.0f, 100.0f);
                this.text("travaille avec des artistes locaux, se d\u00e9place \u00e0 cheval", 50.0f, 150.0f);
            }
            if (this.mouseX < this.width * 3 / 3 && this.mouseX >= this.width * 2 / 3 && this.mouseY <= this.height / 2) {
                this.fill(0);
                this.textSize(50.0f);
                this.text("Voix bulgares", 50.0f, 100.0f);
                this.text("se d\u00e9place en tour bus, \u00e9quipe de vingt personnes", 50.0f, 150.0f);
            }
            if (this.mouseX < this.width * 1 / 3 && this.mouseX >= this.width * 0 / 3 && this.mouseY >= this.height / 2) {
                this.fill(0);
                this.textSize(50.0f);
                this.text("Twende Pamoja", 50.0f, 100.0f);
                this.text("quatre personnes dont une en France, les trois autres doivent obtenir un visa", 50.0f, 150.0f);
            }
            if (this.mouseX < this.width * 2 / 3 && this.mouseX >= this.width * 1 / 3 && this.mouseY >= this.height / 2) {
                this.fill(0);
                this.textSize(50.0f);
                this.text("Hamraj", 50.0f, 100.0f);
                this.text("iraniennes mais vivent en Europe, visa ok", 50.0f, 150.0f);
            }
            if (this.mouseX < this.width * 3 / 3 && this.mouseX >= this.width * 2 / 3 && this.mouseY >= this.height / 2) {
                this.fill(0);
                this.textSize(50.0f);
                this.text("Sababa5", 50.0f, 100.0f);
                this.text("vivent en France, diaspora locale", 50.0f, 150.0f);
            }
        } else if (this.phase == 2) {
            this.eventSfx.pause(true);
            this.popuHasMoved = false;
            for (Popu p : this.popus) {
                p.update();
            }
            this.totalCarbonInterp = routing.lerp((float)this.totalCarbonInterp, (float)this.totalCarbon, (float)0.5f);
            this.background(255);
            this.imageMode(0);
            this.image(this.map, 0.0f, 0.0f);
            for (Popu p : this.popus) {
                p.draw();
            }
            for (Spot s : this.spots) {
                s.draw();
            }
            for (Route r : this.routes) {
                r.draw();
            }
            for (Spot s : this.spots) {
                s.drawTooltip();
            }
            this.fill(0);
            this.textSize(20.0f);
            this.text("distance : " + routing.floor((float)this.totalDistance) + " km", 50.0f, 50.0f);
            this.text("temps : " + routing.floor((float)this.totalTime) + " jours", 50.0f, 80.0f);
            this.text("carbone : " + routing.floor((float)this.totalCarbonInterp) + " TeqCO2", 50.0f, 110.0f);
            this.text("budget : " + routing.floor((float)this.budget) + " flouz", 50.0f, 140.0f);
            this.stroke(0);
            this.fill(255);
            this.rect(300.0f, 93.0f, 1000.0f, 20.0f);
            this.noStroke();
            this.fill(0);
            this.rect(300.0f, 93.0f, this.totalCarbonInterp * 1000.0f / 10.0f, 20.0f);
            if (this.totalCarbon * 1000.0f / 10.0f > 1000.0f) {
                this.phase = 4;
                this.musicLoop.pause(true);
            }
            if (!this.popuHasMoved && this.nextRunDefined) {
                this.phase = 3;
                this.musicLoop.pause(true);
                this.eventSfx.reset();
                this.eventSfx.pause(false);
            }
        } else if (this.phase == 3) {
            this.imageMode(3);
            this.image(this.choicesM[this.currentChoiceM], this.width / 2, this.height / 2);
        } else if (this.phase == 4) {
            this.imageMode(3);
            this.image(this.enfer, this.width / 2, this.height / 2, this.enfer.width * 3, this.enfer.height * 3);
        }
    }

    public void mouseReleased() {
        if (this.exportCoords && this.phase == 2) {
            this.coords.add(routing.str((int)this.mouseX));
            this.coords.add(routing.str((int)this.mouseY));
            this.saveStrings("coordinates.txt", this.coords.toArray(new String[0]));
        }
        if (this.phase == 0) {
            this.phase = 1;
        } else if (this.phase == 1) {
            if (this.mouseX < this.width * 1 / 3 && this.mouseX >= this.width * 0 / 3 && this.mouseY < this.height / 2) {
                this.lastSpot = new Spot(new PVector(-2000.0f, 500.0f), 1.0f);
                this.artistCarbonCost = 1.0f;
                this.popularity = 100.0f;
                this.artistCost = 1000.0f;
                this.budget = 2000.0f;
            }
            if (this.mouseX < this.width * 2 / 3 && this.mouseX >= this.width * 1 / 3 && this.mouseY < this.height / 2) {
                this.lastSpot = new Spot(new PVector(-500.0f, 500.0f), 1.0f);
                this.artistCarbonCost = 0.1f;
                this.popularity = 75.0f;
                this.artistCost = 200.0f;
                this.budget = 1000.0f;
            }
            if (this.mouseX < this.width * 3 / 3 && this.mouseX >= this.width * 2 / 3 && this.mouseY <= this.height / 2) {
                this.lastSpot = new Spot(new PVector(1800.0f, 1000.0f), 1.0f);
                this.artistCarbonCost = 0.1f;
                this.popularity = 50.0f;
                this.artistCost = 750.0f;
                this.budget = 900.0f;
            }
            if (this.mouseX < this.width * 1 / 3 && this.mouseX >= this.width * 0 / 3 && this.mouseY >= this.height / 2) {
                this.lastSpot = new Spot(new PVector(500.0f, 2500.0f), 1.0f);
                this.artistCarbonCost = 0.1f;
                this.popularity = 20.0f;
                this.artistCost = 400.0f;
                this.budget = 800.0f;
            }
            if (this.mouseX < this.width * 2 / 3 && this.mouseX >= this.width * 1 / 3 && this.mouseY >= this.height / 2) {
                this.lastSpot = new Spot(new PVector(860.0f, 250.0f), 1.0f);
                this.artistCarbonCost = 0.1f;
                this.popularity = 20.0f;
                this.artistCost = 300.0f;
                this.budget = 700.0f;
            }
            if (this.mouseX < this.width * 3 / 3 && this.mouseX >= this.width * 2 / 3 && this.mouseY >= this.height / 2) {
                this.lastSpot = new Spot(new PVector(650.0f, 510.0f), 1.0f);
                this.artistCarbonCost = 0.01f;
                this.popularity = 40.0f;
                this.artistCost = 300.0f;
                this.budget = 600.0f;
            }
            this.phase = 3;
            this.nextRunDefined = false;
        } else if (this.phase == 2) {
            if (this.nextRunDefined) {
                return;
            }
            boolean dateWasAdded = false;
            for (Spot s : this.spots) {
                if (!(routing.dist((float)this.mouseX, (float)this.mouseY, (float)s.pos.x, (float)s.pos.y) < s.jauge * this.jaugeToSizeScale / 2.0f) || s.forbidden || s.visited) continue;
                Route newRoute = new Route(this.lastSpot, s);
                this.routes.add(newRoute);
                this.lastSpot = s;
                this.lastSpot.visited = true;
                dateWasAdded = true;
                this.totalDistance += newRoute.getDistance();
                this.totalTime += (float)(newRoute.getDistance() > 200.0f ? 2 : 1);
                this.totalCarbon += newRoute.getDistance() / 1000.0f;
                this.totalCarbon += s.carbon / 2.0f;
                this.totalCarbon += this.artistCarbonCost;
                this.budget -= this.artistCost;
                this.budget += s.recette * 20.0f;
                this.budget -= s.cout * 5.0f;
                this.budget -= newRoute.getDistance() / 100.0f;
                this.totalDiversity += s.diversity;
            }
            if (dateWasAdded) {
                for (Spot s : this.spots) {
                    if (s.exclu <= 0 || !(PVector.dist((PVector)this.lastSpot.pos, (PVector)s.pos) < (float)(s.exclu * 50))) continue;
                    s.forbidden = true;
                }
                float actualJauge = routing.min((float)this.popularity, (float)this.lastSpot.jauge);
                int i = 0;
                while ((float)i < actualJauge) {
                    Popu bestPopu = null;
                    for (Popu p : this.popus) {
                        if (p.hasMoved) continue;
                        if (bestPopu == null) {
                            bestPopu = p;
                        }
                        if (!(PVector.dist((PVector)p.pos, (PVector)this.lastSpot.pos) < PVector.dist((PVector)bestPopu.pos, (PVector)this.lastSpot.pos)) || !(this.random(0.5f) < 2.0f / actualJauge)) continue;
                        bestPopu = p;
                    }
                    if (bestPopu != null) {
                        bestPopu.target = this.lastSpot.pos;
                        bestPopu.hasMoved = true;
                    }
                    ++i;
                }
                this.nextRunDefined = true;
            }
        } else if (this.phase == 3) {
            this.musicLoop.pause(false);
            this.phase = 2;
            this.nextRunDefined = false;
            this.currentChoiceM = (this.currentChoiceM + 1) % this.choicesM.length;
        } else if (this.phase == 4) {
            this.init();
            this.phase = 0;
        }
    }

    public void keyPressed() {
        if (this.key == 'm') {
            this.musicLoop.pause(true);
        }
    }

    public void settings() {
        this.fullScreen();
    }

    public static void main(String[] passedArgs) {
        String[] appletArgs = new String[]{"routing"};
        if (passedArgs != null) {
            PApplet.main((String[])routing.concat((String[])appletArgs, (String[])passedArgs));
        } else {
            PApplet.main((String[])appletArgs);
        }
    }

    class Popu {
        PVector pos;
        PVector target;
        boolean hasMoved = false;

        Popu(PVector pos) {
            this.pos = pos;
            this.target = pos;
        }

        public void update() {
            if (PVector.dist((PVector)this.pos, (PVector)this.target) > 1.0f) {
                PVector direction = PVector.sub((PVector)this.target, (PVector)this.pos);
                direction.normalize();
                this.pos.add(direction);
                routing.this.totalCarbon += 1.00000005E-4f;
                routing.this.popuHasMoved = true;
            }
        }

        public void draw() {
            routing.this.imageMode(3);
            routing.this.image(routing.this.popu, this.pos.x, this.pos.y);
        }
    }

    class Route {
        Spot start;
        Spot stop;

        Route(Spot start, Spot stop) {
            this.start = start;
            this.stop = stop;
        }

        public void draw() {
            routing.this.stroke(0);
            routing.this.fill(255);
            float nbDivs = PVector.sub((PVector)this.stop.pos, (PVector)this.start.pos).mag() / 10.0f;
            int i = 0;
            while ((float)(i + 1) < nbDivs) {
                float phaseA = ((float)i + (float)routing.this.frameCount / 100.0f % 1.0f) / nbDivs;
                float phaseB = ((float)i + 0.5f + (float)routing.this.frameCount / 100.0f % 1.0f) / nbDivs;
                routing.this.line(routing.lerp((float)this.start.pos.x, (float)this.stop.pos.x, (float)phaseA), routing.lerp((float)this.start.pos.y, (float)this.stop.pos.y, (float)phaseA), routing.lerp((float)this.start.pos.x, (float)this.stop.pos.x, (float)phaseB), routing.lerp((float)this.start.pos.y, (float)this.stop.pos.y, (float)phaseB));
                ++i;
            }
        }

        public float getDistance() {
            return PVector.sub((PVector)this.stop.pos, (PVector)this.start.pos).mag();
        }
    }

    class Spot {
        PVector pos;
        float jauge;
        float carbon;
        float cout;
        float recette;
        int exclu = 0;
        boolean visited = false;
        boolean forbidden = false;
        String name;
        String description;
        float diversity;

        Spot(PVector pos, float jauge) {
            this.pos = pos.copy();
            this.jauge = jauge;
        }

        public void draw() {
            routing.this.stroke(0);
            routing.this.fill(255.0f, 255.0f, 128.0f);
            if (this.forbidden) {
                routing.this.fill(255.0f, 160.0f, 160.0f);
            }
            if (this.visited) {
                routing.this.fill(160.0f, 160.0f, 255.0f);
            }
            routing.this.ellipse(this.pos.x, this.pos.y, this.jauge * routing.this.jaugeToSizeScale, this.jauge * routing.this.jaugeToSizeScale);
            routing.this.fill(0);
        }

        public void drawTooltip() {
            if (routing.dist((float)routing.this.mouseX, (float)routing.this.mouseY, (float)this.pos.x, (float)this.pos.y) < this.jauge * routing.this.jaugeToSizeScale / 2.0f) {
                routing.this.stroke(0);
                routing.this.fill(255);
                routing.this.rect(this.pos.x + 20.0f, this.pos.y + 20.0f, 500.0f, 220.0f);
                routing.this.fill(0);
                routing.this.text(this.name, this.pos.x + 50.0f, this.pos.y + 50.0f);
                routing.this.text(this.description, this.pos.x + 50.0f, this.pos.y + 90.0f);
                routing.this.text("capacit\u00e9 : " + this.jauge + " personnes", this.pos.x + 50.0f, this.pos.y + 130.0f);
                String recettesStars = "";
                int i = 0;
                while ((float)i < this.recette) {
                    recettesStars = String.valueOf(recettesStars) + "$";
                    ++i;
                }
                routing.this.text("recette : " + recettesStars, this.pos.x + 50.0f, this.pos.y + 170.0f);
                if (this.exclu > 0) {
                    routing.this.text("clause d'exclusivit\u00e9 sur " + this.exclu * 50 + " km", this.pos.x + 50.0f, this.pos.y + 210.0f);
                }
            }
        }
    }
}

