/*
 * Decompiled with CFR 0.152.
 */
package org.jaudiolibs.audioservers.javasound;

import java.nio.FloatBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.LockSupport;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.DataLine;
import javax.sound.sampled.Mixer;
import javax.sound.sampled.SourceDataLine;
import javax.sound.sampled.TargetDataLine;
import org.jaudiolibs.audioservers.AudioClient;
import org.jaudiolibs.audioservers.AudioConfiguration;
import org.jaudiolibs.audioservers.AudioServer;
import org.jaudiolibs.audioservers.javasound.AudioFloatConverter;
import org.jaudiolibs.audioservers.javasound.JSTimingMode;
import org.jaudiolibs.audioservers.javasound.TimeFilter;

public class JSAudioServer
implements AudioServer {
    private static final Logger LOG = Logger.getLogger(JSAudioServer.class.getName());
    private static final int NON_BLOCKING_MIN_BUFFER = 16384;
    private static final int nonBlockingOutputRatio = 16;
    private static final int lineBitSize = 16;
    private static final boolean signed = true;
    private static final boolean bigEndian = false;
    private final AtomicReference<State> state;
    private final AudioConfiguration context;
    private final Mixer inputMixer;
    private final Mixer outputMixer;
    private final AudioClient client;
    private final JSTimingMode mode;
    private TargetDataLine inputLine;
    private SourceDataLine outputLine;
    private byte[] inputByteBuffer;
    private float[] inputFloatBuffer;
    private byte[] outputByteBuffer;
    private float[] outputFloatBuffer;
    private List<FloatBuffer> inputBuffers;
    private List<FloatBuffer> outputBuffers;
    private AudioFloatConverter converter;

    JSAudioServer(Mixer inputMixer, Mixer outputMixer, JSTimingMode mode, AudioConfiguration context, AudioClient client) {
        this.inputMixer = inputMixer;
        this.outputMixer = outputMixer;
        this.context = context;
        this.mode = mode;
        this.client = client;
        this.state = new AtomicReference<State>(State.New);
    }

    public void run() throws Exception {
        if (!this.state.compareAndSet(State.New, State.Initialising)) {
            throw new IllegalStateException();
        }
        try {
            this.initialise();
            this.client.configure(this.context);
        }
        catch (Exception ex) {
            this.state.set(State.Terminated);
            this.closeAll();
            this.client.shutdown();
            throw ex;
        }
        if (this.state.compareAndSet(State.Initialising, State.Active)) {
            this.runImpl();
        }
        this.closeAll();
        this.client.shutdown();
        this.state.set(State.Terminated);
    }

    public AudioConfiguration getAudioContext() {
        return this.context;
    }

    public boolean isActive() {
        State st = this.state.get();
        return st == State.Active || st == State.Closing;
    }

    public void shutdown() {
        State st;
        while ((st = this.state.get()) != State.Terminated && st != State.Closing && !this.state.compareAndSet(st, State.Closing)) {
        }
    }

    private void initialise() throws Exception {
        int byteBufferSize;
        float srate = this.context.getSampleRate();
        int buffersize = this.context.getMaxBufferSize();
        int inputChannels = this.context.getInputChannelCount();
        int outputChannels = this.context.getOutputChannelCount();
        if (inputChannels > 0) {
            AudioFormat inputFormat = new AudioFormat(srate, 16, inputChannels, true, false);
            DataLine.Info inputInfo = new DataLine.Info(TargetDataLine.class, inputFormat);
            this.inputLine = this.inputMixer == null ? (TargetDataLine)AudioSystem.getLine(inputInfo) : (TargetDataLine)this.inputMixer.getLine(inputInfo);
            this.inputFloatBuffer = new float[buffersize * inputChannels];
            byteBufferSize = buffersize * inputFormat.getFrameSize();
            this.inputByteBuffer = new byte[byteBufferSize];
            this.inputLine.open(inputFormat, byteBufferSize *= 16);
        }
        AudioFormat outputFormat = new AudioFormat(srate, 16, outputChannels, true, false);
        DataLine.Info outputInfo = new DataLine.Info(SourceDataLine.class, outputFormat);
        this.outputLine = this.outputMixer == null ? (SourceDataLine)AudioSystem.getLine(outputInfo) : (SourceDataLine)this.outputMixer.getLine(outputInfo);
        this.outputFloatBuffer = new float[buffersize * outputChannels];
        byteBufferSize = buffersize * outputFormat.getFrameSize();
        this.outputByteBuffer = new byte[byteBufferSize];
        if (this.mode != JSTimingMode.Blocking) {
            byteBufferSize *= 16;
            byteBufferSize = Math.min(byteBufferSize, 16384 * outputFormat.getFrameSize());
        }
        this.outputLine.open(outputFormat, byteBufferSize);
        this.converter = AudioFloatConverter.getConverter(outputFormat);
        ArrayList<FloatBuffer> ins = new ArrayList<FloatBuffer>(inputChannels);
        for (int i = 0; i < inputChannels; ++i) {
            ins.add(FloatBuffer.allocate(buffersize));
        }
        this.inputBuffers = Collections.unmodifiableList(ins);
        ArrayList<FloatBuffer> outs = new ArrayList<FloatBuffer>(outputChannels);
        for (int i = 0; i < outputChannels; ++i) {
            outs.add(FloatBuffer.allocate(buffersize));
        }
        this.outputBuffers = Collections.unmodifiableList(outs);
    }

    private void runImpl() {
        long startTime;
        if (this.inputLine != null) {
            this.inputLine.start();
        }
        this.outputLine.start();
        long now = startTime = System.nanoTime();
        double bufferTime = (double)this.context.getMaxBufferSize() / (double)this.context.getSampleRate();
        TimeFilter dll = new TimeFilter(bufferTime, 1.5);
        long bufferCount = 0L;
        int bufferSize = this.context.getMaxBufferSize();
        boolean debug = LOG.isLoggable(Level.FINEST);
        long bufferTimeNS = (long)(bufferTime * 1.0E9);
        long msFrames = (long)(this.context.getSampleRate() / 1000.0f);
        try {
            while (this.state.get() == State.Active) {
                now = System.nanoTime();
                this.readInput();
                if (this.client.process((long)(dll.update((double)now / 1.0E9) * 1.0E9), this.inputBuffers, this.outputBuffers, bufferSize)) {
                    this.writeOutput();
                    switch (this.mode) {
                        case Estimated: {
                            long target = startTime + bufferTimeNS * (bufferCount + 1L);
                            long difference = System.nanoTime() - target;
                            while (difference < -(bufferTimeNS / 16L)) {
                                if (difference < -1000000L) {
                                    try {
                                        LockSupport.parkNanos(500000L);
                                    }
                                    catch (Exception exception) {}
                                } else {
                                    Thread.yield();
                                }
                                difference = System.nanoTime() - target;
                            }
                            break;
                        }
                        case FramePosition: {
                            long target = bufferCount * (long)bufferSize;
                            long difference = this.outputLine.getLongFramePosition() - target;
                            while (difference < (long)(-(bufferSize / 16))) {
                                if (difference < -msFrames) {
                                    try {
                                        LockSupport.parkNanos(500000L);
                                    }
                                    catch (Exception exception) {}
                                } else {
                                    Thread.yield();
                                }
                                difference = this.outputLine.getLongFramePosition() - target;
                            }
                            break;
                        }
                    }
                    ++bufferCount;
                } else {
                    this.shutdown();
                }
                if (!debug) continue;
                this.processDebug(dll);
            }
        }
        catch (Exception ex) {
            LOG.log(Level.SEVERE, "", ex);
        }
    }

    private void processDebug(TimeFilter dll) {
        long x = dll.ncycles - 1L;
        if (x == 0L) {
            LOG.finest("| audiotime drift | filter drift  | systime jitter | filter jitter  |");
        }
        if (x % 1000L == 0L) {
            double device_drift = (dll.device_time - dll.system_time) * 1000.0;
            double filter_drift = (dll.filter_time - dll.system_time) * 1000.0;
            double device_rate_error = device_drift / (double)dll.ncycles;
            double filter_jitter = dll.filter_period_error - device_rate_error;
            double system_jitter = dll.system_period_error - device_rate_error;
            LOG.finest(String.format("| %15.6f | %13.6f | %14.6f | %14.6f |", device_drift, filter_drift, system_jitter, filter_jitter));
        }
    }

    private void readInput() {
        TargetDataLine tdl = this.inputLine;
        if (tdl != null) {
            int bsize = this.inputByteBuffer.length;
            if (tdl.available() < bsize) {
                int fsize = this.inputFloatBuffer.length;
                for (int i = 0; i < fsize; ++i) {
                    this.inputFloatBuffer[i] = 0.0f;
                }
            } else {
                tdl.read(this.inputByteBuffer, 0, bsize);
                this.converter.toFloatArray(this.inputByteBuffer, this.inputFloatBuffer);
            }
            int channels = this.inputBuffers.size();
            for (int channel = 0; channel < channels; ++channel) {
                FloatBuffer inBuf = this.inputBuffers.get(channel);
                float[] input = inBuf.array();
                int x = channel;
                for (int i = 0; i < input.length; ++i) {
                    input[i] = this.inputFloatBuffer[x];
                    x += channels;
                }
                inBuf.rewind();
            }
        }
    }

    private void writeOutput() {
        int channels = this.outputBuffers.size();
        for (int channel = 0; channel < channels; ++channel) {
            FloatBuffer outBuf = this.outputBuffers.get(channel);
            float[] output = outBuf.array();
            int x = channel;
            for (int i = 0; i < output.length; ++i) {
                float out = output[i];
                this.outputFloatBuffer[x] = out = out < -1.0f ? -1.0f : (out > 1.0f ? 1.0f : out);
                x += channels;
            }
            outBuf.rewind();
        }
        this.converter.toByteArray(this.outputFloatBuffer, this.outputByteBuffer);
        this.outputLine.write(this.outputByteBuffer, 0, this.outputByteBuffer.length);
    }

    private void closeAll() {
        TargetDataLine tdl;
        SourceDataLine sdl = this.outputLine;
        if (sdl != null) {
            sdl.close();
        }
        if ((tdl = this.inputLine) != null) {
            tdl.close();
        }
    }

    private static enum State {
        New,
        Initialising,
        Active,
        Closing,
        Terminated;

    }
}

