/*
 * Decompiled with CFR 0.152.
 */
import processing.core.PApplet;
import processing.core.PFont;
import processing.core.PImage;
import processing.sound.SoundFile;

public class gazoline
extends PApplet {
    int sizx = 500;
    int sizy = 500;
    float sol = this.sizy * 7 / 8;
    Settings settings;
    Player player;
    Player[] players;
    int nbDroid;
    Droid[] droid;
    boolean[] pressed = new boolean[128];
    PFont font;
    PImage plS;
    PImage plR1L;
    PImage plR2L;
    PImage plRF1L;
    PImage plRF2L;
    PImage plR1R;
    PImage plR2R;
    PImage plRF1R;
    PImage plRF2R;
    PImage plStL;
    PImage plStR;
    PImage plJ1;
    PImage plJ2;
    PImage plF;
    PImage plL;
    PImage plFL;
    PImage plFR;
    PImage plD;
    PImage dS;
    PImage dD;
    PImage dF;
    PImage dC;
    PImage back01;
    PImage sol01;
    SoundFile playerRespawn;
    SoundFile droidDie;
    SoundFile playerDie;
    SoundFile playerBounce;
    SoundFile playerLand;
    SoundFile playerJump;
    SoundFile playerHang;
    SoundFile playerJet;
    SoundFile droidMove;
    SoundFile droidFire;
    SoundFile playerSlide;
    SoundFile playerStill;
    SoundFile droidLaser;
    SoundFile keyP;
    SoundFile fond1;
    SoundFile fond2;
    SoundFile fond3;
    SoundFile fond4;
    boolean sound = true;

    public void setup() {
        this.frameRate(50.0f);
        this.sizx = this.width;
        this.sizy = this.height;
        this.colorMode(3);
        this.frameRate(60.0f);
        this.noStroke();
        this.settings = new Settings();
        this.player = new Player(0);
        this.font = this.loadFont("VisitorTT1BRK-20.vlw");
        this.textFont(this.font);
        this.loadSound();
        this.loadGraphics();
        this.fond1.loop();
    }

    public void draw() {
        switch (this.settings.mode) {
            case 0: {
                this.menu();
                break;
            }
            case 1: {
                this.game();
                break;
            }
            case 2: {
                this.arcade();
                break;
            }
            case 3: {
                this.twoplayers();
                break;
            }
            case 4: {
                this.options();
                break;
            }
            case 5: {
                this.custom();
                break;
            }
            case 6: {
                this.gameOver();
                break;
            }
            case 7: {
                this.winner();
            }
        }
    }

    public void loadGraphics() {
        this.back01 = this.loadImage(this.dataPath("fond01.png"));
        this.sol01 = this.loadImage(this.dataPath("sol01.png"));
        this.plS = this.loadImage(this.dataPath("playerStill.png"));
        this.plR1L = this.loadImage(this.dataPath("playerRun1Left.png"));
        this.plR2L = this.loadImage(this.dataPath("playerRun2Left.png"));
        this.plRF1L = this.loadImage(this.dataPath("playerRunFast1Left.png"));
        this.plRF2L = this.loadImage(this.dataPath("playerRunFast2Left.png"));
        this.plStL = this.loadImage(this.dataPath("playerStartingLeft.png"));
        this.plR1R = this.loadImage(this.dataPath("playerRun1Right.png"));
        this.plR2R = this.loadImage(this.dataPath("playerRun2Right.png"));
        this.plRF1R = this.loadImage(this.dataPath("playerRunFast1Right.png"));
        this.plRF2R = this.loadImage(this.dataPath("playerRunFast2Right.png"));
        this.plStR = this.loadImage(this.dataPath("playerStartingRight.png"));
        this.plJ1 = this.loadImage(this.dataPath("playerJump1.png"));
        this.plJ2 = this.loadImage(this.dataPath("playerJump2.png"));
        this.plF = this.loadImage(this.dataPath("playerFall.png"));
        this.plL = this.loadImage(this.dataPath("playerLand.png"));
        this.plFL = this.loadImage(this.dataPath("playerFallLeft.png"));
        this.plFR = this.loadImage(this.dataPath("playerFallRight.png"));
        this.plD = this.loadImage(this.dataPath("playerDie.png"));
        this.dS = this.loadImage(this.dataPath("droidStill.png"));
        this.dD = this.loadImage(this.dataPath("droidDie.png"));
        this.dF = this.loadImage(this.dataPath("droidFire.png"));
        this.dC = this.loadImage(this.dataPath("droidClosed.png"));
    }

    public void keyPressed() {
        if (this.key == '\uffff') {
            this.pressed[this.keyCode] = true;
        } else {
            this.pressed[this.key & 0x7F] = true;
        }
        if (this.settings.mode == 0) {
            this.keyP.play();
            if (this.keyCode == 40) {
                this.settings.selection = gazoline.min((int)(this.settings.selection + 1), (int)4);
            }
            if (this.keyCode == 38) {
                this.settings.selection = gazoline.max((int)(this.settings.selection - 1), (int)0);
            }
            if (this.keyCode == 10) {
                this.settings.start = true;
                this.settings.mode = this.settings.selection + 1;
                this.loadMode(this.settings.mode);
            }
        } else if (this.settings.mode == 4) {
            this.keyP.play();
            if (this.keyCode == 40) {
                this.settings.selection = gazoline.min((int)(this.settings.selection + 1), (int)5);
            }
            if (this.keyCode == 38) {
                this.settings.selection = gazoline.max((int)(this.settings.selection - 1), (int)0);
            } else if (this.settings.selection == 0) {
                if (this.keyCode == 39) {
                    this.settings.nbJoueurs = gazoline.min((int)(this.settings.nbJoueurs + 1), (int)this.settings.nbJoueursMax);
                }
                if (this.keyCode == 37) {
                    this.settings.nbJoueurs = gazoline.max((int)(this.settings.nbJoueurs - 1), (int)0);
                }
            } else if (this.settings.selection == 1) {
                if (this.keyCode == 39) {
                    ++this.settings.arcadeLevel;
                }
                if (this.keyCode == 37) {
                    this.settings.arcadeLevel = gazoline.max((int)(this.settings.arcadeLevel - 1), (int)0);
                }
            } else if (this.settings.selection == 2 || this.settings.selection == 3 || this.settings.selection == 4) {
                if (this.keyCode == 10) {
                    this.settings.keyToDefine = 2 - (this.settings.selection - 2);
                } else if (this.keyCode == 38 || this.keyCode == 40) {
                    this.settings.keyToDefine = -1;
                } else if (this.settings.keyToDefine != -1) {
                    this.settings.touchesSet[this.settings.playerToDefine][this.settings.keyToDefine] = this.key;
                    this.settings.playerToDefine = (this.settings.playerToDefine + 1) % this.settings.nbJoueurs;
                }
            } else if (this.settings.selection == 5 && this.keyCode == 10 && !this.settings.start) {
                this.settings.mode = 0;
                this.loadMode(0);
            }
        }
        if (this.settings.mode == 2) {
            if (this.keyCode == 10 && !this.settings.start) {
                this.settings.mode = 0;
                this.loadMode(0);
            }
        } else if (this.settings.mode == 3) {
            if (this.keyCode == 10 && !this.settings.start) {
                this.settings.mode = 0;
                this.loadMode(0);
            }
        } else if (this.settings.mode == 1) {
            if (this.keyCode == 8) {
                this.settings.start = true;
            }
            if (this.keyCode == 10 && !this.settings.start) {
                this.settings.mode = 0;
                this.loadMode(0);
            }
        } else if (this.settings.mode == 5) {
            if (this.keyCode == 8) {
                this.loadMode(5);
            }
        } else if ((this.settings.mode == 6 || this.settings.mode == 7) && this.keyCode == 10) {
            this.settings.mode = 0;
            this.loadMode(0);
        }
    }

    public void keyReleased() {
        if (this.key == '\uffff') {
            this.pressed[this.keyCode] = false;
        } else {
            this.pressed[this.key & 0x7F] = false;
        }
        this.settings.start = false;
    }

    public void menu() {
        this.background(192);
        this.textAlign(3, 3);
        this.noStroke();
        this.fill(0.0f, 255.0f, 127.0f);
        this.text("Gazoline", this.sizx / 2, this.sizy * 1 / 7);
        this.text("Hardcore tutorial", this.sizx / 2, this.sizy * 2 / 7);
        this.text("Arcade", this.sizx / 2, this.sizy * 3 / 7);
        this.text("Multiplayer", this.sizx / 2, this.sizy * 4 / 7);
        this.text("Options", this.sizx / 2, this.sizy * 5 / 7);
        this.text("Custom", this.sizx / 2, this.sizy * 6 / 7);
        this.pushMatrix();
        this.translate(0.0f, (this.settings.selection + 2) * this.sizy / 7);
        this.image(this.dS, this.sizx * 1 / 10 - this.dS.width / 2, -this.dS.height / 2);
        this.image(this.dS, this.sizx * 9 / 10 - this.dS.width / 2, -this.dS.height / 2);
        this.stroke(0.0f, 255.0f, 255.0f);
        this.fill(0, 0.0f);
        this.strokeWeight(2.0f);
        this.line(this.sizx * 1 / 10 + 2, 0.0f, this.sizx * 3 / 10, 0.0f);
        this.line(this.sizx * 9 / 10 - 2, 0.0f, this.sizx * 7 / 10, 0.0f);
        this.rect(this.sizx * 3 / 10, -this.sizy / 20, this.sizx * 4 / 10, this.sizy * 2 / 20);
        this.strokeWeight(1.0f);
        this.popMatrix();
    }

    public void game() {
        if (this.settings.currentLevel == 0) {
            if (this.settings.start) {
                this.settings.start = false;
                this.nbDroid = 2;
                this.droid = new Droid[this.nbDroid];
                this.droid[0] = new DroidGentle(250.0f, 415.0f, 45.0f, 0);
                this.droid[1] = new DroidGentle(350.0f, 415.0f, 90.0f, 0);
                this.player.place(50.0f, 400.0f, true);
                this.settings.labelA = "Use " + PApplet.parseChar((int)this.settings.touchesSet[0][0]) + " and " + PApplet.parseChar((int)this.settings.touchesSet[0][2]) + " to go right and left.";
                this.settings.labelB = "To kill an eye, just touch it.";
                this.settings.labelC = "There are two eyes next to you, kill them.";
            }
            this.standardLevel();
        } else if (this.settings.currentLevel == 1) {
            if (this.settings.start) {
                this.settings.start = false;
                this.nbDroid = 3;
                this.droid = new Droid[this.nbDroid];
                this.droid[0] = new DroidGentle(300.0f, 400.0f, 45.0f, 0);
                this.droid[1] = new DroidGentle(350.0f, 350.0f, 90.0f, 0);
                this.droid[2] = new DroidGentle(400.0f, 340.0f, 135.0f, 0);
                this.player.place(50.0f, 400.0f, true);
                this.settings.labelA = "Press " + PApplet.parseChar((int)this.settings.touchesSet[0][1]) + " to jump.";
                this.settings.labelB = "";
                this.settings.labelC = "";
            }
            this.standardLevel();
        } else if (this.settings.currentLevel == 2) {
            if (this.settings.start) {
                this.settings.start = false;
                this.nbDroid = 1;
                this.droid = new Droid[this.nbDroid];
                this.droid[0] = new DroidGentle(350.0f, 250.0f, 120.0f, 2);
                this.player.place(50.0f, 400.0f, true);
                this.settings.labelA = "Grab the red line by holding down " + PApplet.parseChar((int)this.settings.touchesSet[0][1]) + ".";
                this.settings.labelB = "Release " + PApplet.parseChar((int)this.settings.touchesSet[0][1]) + " to propel yourself.";
                this.settings.labelC = "";
            }
            this.standardLevel();
        } else if (this.settings.currentLevel == 3) {
            if (this.settings.start) {
                this.settings.start = false;
                this.nbDroid = 3;
                this.droid = new Droid[this.nbDroid];
                this.droid[0] = new DroidGentle(200.0f, 200.0f, 60.0f, 2);
                this.droid[1] = new DroidGentle(250.0f, 250.0f, 90.0f, 2);
                this.droid[2] = new DroidGentle(300.0f, 300.0f, 120.0f, 2);
                this.player.place(50.0f, 400.0f, true);
                this.settings.labelA = "Try killing several eyes without landing";
                this.settings.labelB = "to make a combo.";
                this.settings.labelC = "";
            }
            this.standardLevel();
        } else if (this.settings.currentLevel == 4) {
            if (this.settings.start) {
                this.settings.start = false;
                this.nbDroid = 5;
                this.droid = new DroidStill[this.nbDroid];
                this.droid[0] = new DroidStill(200.0f, 200.0f, 100.0f, 1, 0.7f);
                this.droid[1] = new DroidStill(230.0f, 200.0f, 100.0f, 1, 0.6f);
                this.droid[2] = new DroidStill(260.0f, 200.0f, 100.0f, 1, 0.5f);
                this.droid[3] = new DroidStill(290.0f, 200.0f, 100.0f, 1, 0.4f);
                this.droid[4] = new DroidStill(320.0f, 200.0f, 100.0f, 1, 0.3f);
                this.player.place(50.0f, 400.0f, true);
                this.settings.labelA = "These eyes are dangerous.";
                this.settings.labelB = "Try not to be on their line";
                this.settings.labelC = "when it becomes yellow !";
            }
            this.standardLevel();
        } else if (this.settings.currentLevel == 5) {
            if (this.settings.start) {
                this.settings.start = false;
                this.nbDroid = 2;
                this.droid = new Droid[this.nbDroid];
                this.droid[0] = new Droid(this.sizx * 1 / 3, 300.0f);
                this.droid[1] = new Droid(this.sizx * 2 / 3, 300.0f);
                this.player.place(50.0f, 400.0f, true);
                this.settings.labelA = "Some eyes like to move.";
                this.settings.labelB = "";
                this.settings.labelC = "";
            }
            this.standardLevel();
        } else if (this.settings.currentLevel == 6) {
            if (this.settings.start) {
                this.settings.start = false;
                this.nbDroid = 10;
                this.droid = new Droid[this.nbDroid];
                int i = 0;
                while (i < this.nbDroid) {
                    this.droid[i] = new Droid(this.sizx / 2, this.sizy * 1 / 3);
                    ++i;
                }
                this.player.place(50.0f, 400.0f, true);
                this.settings.labelA = "Ok, now the fun part.";
                this.settings.labelB = "";
                this.settings.labelC = "";
            }
            this.standardLevel();
        } else if (this.settings.currentLevel == 7) {
            if (this.settings.start) {
                this.settings.start = false;
                this.nbDroid = 1;
                this.droid = new DroidGater[this.nbDroid];
                this.droid[0] = new DroidGater(320.0f, 350.0f, 90.0f, 3, 0.3f);
                this.player.place(50.0f, 400.0f, true);
                this.settings.labelA = "This one only tries to destroy you.";
                this.settings.labelB = "";
                this.settings.labelC = "";
            }
            this.standardLevel();
        } else if (this.settings.currentLevel == 8) {
            if (this.settings.start) {
                this.settings.start = false;
                this.nbDroid = 2;
                this.droid = new Droid[this.nbDroid];
                this.droid[0] = new DroidGater(320.0f, 200.0f, 100.0f, 3, 0.9f);
                this.droid[1] = new DroidGentle(200.0f, 340.0f, 70.0f, 2);
                this.player.place(50.0f, 400.0f, true);
                this.settings.labelA = "Press backspace to restart a level.";
                this.settings.labelB = "";
                this.settings.labelC = "";
            }
            this.standardLevel();
        } else if (this.settings.currentLevel == 9) {
            if (this.settings.start) {
                this.settings.start = false;
                this.nbDroid = 6;
                this.droid = new Droid[this.nbDroid];
                this.droid[0] = new DroidGater(180.0f, 370.0f, 60.0f, 3, 1.4f);
                this.droid[1] = new DroidGater(220.0f, 360.0f, 120.0f, 3, 1.3f);
                this.droid[2] = new DroidGater(260.0f, 350.0f, 60.0f, 3, 1.2f);
                this.droid[3] = new DroidGater(300.0f, 350.0f, 120.0f, 3, 1.1f);
                this.droid[4] = new DroidGater(340.0f, 360.0f, 60.0f, 3, 1.0f);
                this.droid[5] = new DroidGater(380.0f, 370.0f, 120.0f, 3, 0.9f);
                this.player.place(50.0f, 400.0f, true);
                this.settings.labelA = "";
                this.settings.labelB = "";
                this.settings.labelC = "";
            }
            this.standardLevel();
        } else if (this.settings.currentLevel == 10) {
            if (this.settings.start) {
                this.settings.start = false;
                this.nbDroid = 6;
                this.droid = new Droid[this.nbDroid];
                this.droid[0] = new DroidGater(100.0f, 350.0f, 90.0f, 3, 1.5f);
                this.droid[1] = new DroidGater(200.0f, 350.0f, 90.0f, 3, 2.0f);
                this.droid[2] = new DroidGater(300.0f, 350.0f, 90.0f, 3, 2.0f);
                this.droid[3] = new DroidGater(400.0f, 350.0f, 90.0f, 3, 1.5f);
                this.droid[4] = new DroidStill(150.0f, 200.0f, 90.0f, 2, 0.5f);
                this.droid[5] = new DroidStill(350.0f, 200.0f, 90.0f, 2, 0.5f);
                this.player.place(250.0f, 400.0f, true);
                this.settings.labelA = "";
                this.settings.labelB = "";
                this.settings.labelC = "";
            }
            this.standardLevel();
        } else if (this.settings.currentLevel == 11) {
            if (this.settings.start) {
                this.settings.start = false;
                this.nbDroid = 4;
                this.droid = new Droid[this.nbDroid];
                this.droid[0] = new DroidStill(130.0f, 315.0f, 100.0f, 0, 0.0f);
                this.droid[1] = new DroidGater(200.0f, 270.0f, -110.0f, 3, 5.0f);
                this.droid[2] = new DroidGater(200.0f, 380.0f, 110.0f, 3, 5.0f);
                this.droid[3] = new DroidStill(300.0f, 170.0f, 90.0f, 2, 0.0f);
                this.player.place(400.0f, 400.0f, true);
                this.settings.labelA = "";
                this.settings.labelB = "";
                this.settings.labelC = "";
            }
            this.standardLevel();
        } else if (this.settings.currentLevel == 12) {
            if (this.settings.start) {
                this.settings.start = false;
                this.nbDroid = 10;
                this.droid = new Droid[this.nbDroid + 1];
                int nbPath = this.nbDroid + 1;
                float[] pathX = new float[nbPath];
                float[] pathY = new float[nbPath];
                int i = 0;
                while (i < this.nbDroid + 1) {
                    pathX[i] = (float)(this.sizx / 2) + gazoline.cos((float)((float)Math.PI * 2 * (float)i / (float)nbPath + 1.0f)) * 200.0f;
                    pathY[i] = (float)(this.sizy * 2 / 5) + gazoline.sin((float)((float)Math.PI * 2 * (float)i / (float)nbPath)) * 100.0f;
                    this.droid[i] = new DroidPath(pathX[i], pathY[i], ((float)i + 5.0f) % (float)this.nbDroid / (float)this.nbDroid * 80.0f + 50.0f, gazoline.floor((float)((float)i * 2.0f / (float)this.nbDroid + 2.0f)), 0.7f, pathX, pathY, i, i * 100 / this.nbDroid);
                    ++i;
                }
                this.player.place(380.0f, 400.0f, true);
                this.settings.labelA = "";
                this.settings.labelB = "";
                this.settings.labelC = "";
            }
            this.standardLevel();
        } else if (this.settings.currentLevel == 13) {
            this.settings.mode = 7;
        }
    }

    public void standardLevel() {
        this.image(this.back01, 0.0f, 0.0f);
        this.smooth();
        this.player.keys();
        this.player.deplace();
        this.noSmooth();
        this.player.dessine();
        this.smooth();
        int i = 0;
        while (i < this.nbDroid) {
            this.droid[i].agit();
            this.droid[i].dessine();
            ++i;
        }
        this.image(this.sol01, 0.0f, 0.0f);
        this.fill(0);
        this.textAlign(39);
        this.text(String.valueOf(this.player.getLife()) + " lives left", 450.0f, 30.0f);
        this.fill(0);
        this.textAlign(37);
        this.text(this.settings.labelA, 50.0f, 70.0f);
        this.text(this.settings.labelB, 50.0f, 90.0f);
        this.text(this.settings.labelC, 50.0f, 110.0f);
        if (!this.checkSurvivors()) {
            this.settings.start = true;
            ++this.settings.currentLevel;
        }
        if (this.player.getLife() <= 0) {
            this.settings.mode = 6;
        }
    }

    public void arcade() {
        int i;
        this.background(0);
        this.image(this.back01, 0.0f, 0.0f);
        if (this.settings.start) {
            this.settings.start = false;
            this.nbDroid = this.settings.arcadeLevel;
            this.droid = new Droid[this.nbDroid];
            i = 0;
            while (i < this.nbDroid) {
                this.droid[i] = new Droid(this.random(this.width - 20), this.random(this.height / 2));
                ++i;
            }
            this.player.place(this.sizx / 2, this.sol - 20.0f, true);
            this.player.setLife(3);
        }
        this.smooth();
        this.player.keys();
        this.player.deplace();
        this.noSmooth();
        this.player.dessine();
        this.smooth();
        i = 0;
        while (i < this.nbDroid) {
            this.droid[i].agit();
            this.droid[i].dessine();
            ++i;
        }
        this.image(this.sol01, 0.0f, 0.0f);
        this.fill(0);
        this.textAlign(39);
        this.text(String.valueOf(this.player.getLife()) + " lives left", this.sizx - 50, 30.0f);
        if (!this.checkSurvivors()) {
            this.settings.start = true;
            ++this.settings.arcadeLevel;
        }
        if (this.player.getLife() <= 0) {
            this.settings.mode = 6;
        }
    }

    public boolean checkSurvivors() {
        int i = 0;
        while (i < this.nbDroid) {
            if (this.droid[i].vivant) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public void twoplayers() {
        int i;
        this.background(0);
        this.image(this.back01, 0.0f, 0.0f);
        if (this.settings.start) {
            this.settings.start = false;
            this.players = new Player[2];
            this.players[0] = new Player(0);
            this.players[1] = new Player(1);
            this.players[0].place(100.0f, this.sol - 20.0f, true);
            this.players[1].place(this.sizx - 100, this.sol - 20.0f, true);
            this.players[0].setLife(3);
            this.players[1].setLife(3);
            this.nbDroid = 10;
            this.droid = new Droid[this.nbDroid];
            i = 0;
            while (i < this.nbDroid) {
                this.droid[i] = new Droid(this.random(this.width - 20), this.random(this.height / 2));
                ++i;
            }
        }
        this.smooth();
        i = 0;
        while (i < 2) {
            this.players[i].keys();
            this.players[i].deplace();
            ++i;
        }
        this.noSmooth();
        i = 0;
        while (i < 2) {
            this.players[i].dessine();
            ++i;
        }
        this.smooth();
        i = 0;
        while (i < this.nbDroid) {
            this.droid[i].agit();
            this.droid[i].dessine();
            ++i;
        }
        this.image(this.sol01, 0.0f, 0.0f);
        this.fill(0);
        this.textAlign(37);
        this.text("P1: " + this.players[0].getLife() + " lives", 50.0f, 30.0f);
        this.textAlign(39);
        this.text("P2: " + this.players[1].getLife() + " lives", this.sizx - 50, 30.0f);
        if (this.players[0].getLife() <= 0 && this.players[1].getLife() <= 0) {
            this.settings.mode = 6;
        } else if (!this.checkSurvivors()) {
            this.settings.mode = 7;
        }
    }

    public void options() {
        this.background(50);
        this.fill(255);
        this.textAlign(3, 101);
        this.text("Options", this.sizx / 2, 20.0f);
        String[] labels = new String[]{"Number of players: " + this.settings.nbJoueurs, "Arcade starting level: " + this.settings.arcadeLevel, "Key Left P" + (this.settings.playerToDefine + 1) + " : " + PApplet.parseChar((int)this.settings.touchesSet[this.settings.playerToDefine][2]), "Key Jump: P" + (this.settings.playerToDefine + 1) + " : " + PApplet.parseChar((int)this.settings.touchesSet[this.settings.playerToDefine][1]), "Key Right: P" + (this.settings.playerToDefine + 1) + " : " + PApplet.parseChar((int)this.settings.touchesSet[this.settings.playerToDefine][0]), "Back to menu"};
        int i = 0;
        while (i < labels.length) {
            this.fill(this.settings.selection == i ? this.color(255, 255, 0) : this.color(255));
            this.text(labels[i], this.sizx / 2, 100 + i * 50);
            ++i;
        }
    }

    public void custom() {
        this.standardLevel();
    }

    public void gameOver() {
        this.background(0);
        this.fill(255.0f, 50.0f, 50.0f);
        this.textAlign(3, 3);
        this.textSize(32.0f);
        this.text("GAME OVER", this.sizx / 2, this.sizy / 2 - 20);
        this.textSize(16.0f);
        this.text("Press ENTER to return to menu", this.sizx / 2, this.sizy / 2 + 30);
        if (this.pressed[10]) {
            this.pressed[10] = false;
            this.settings.mode = 0;
            this.settings.start = true;
        }
    }

    public void winner() {
        this.background(0);
        this.fill(50.0f, 255.0f, 50.0f);
        this.textAlign(3, 3);
        this.textSize(32.0f);
        this.text("YOU WIN!", this.sizx / 2, this.sizy / 2 - 20);
        this.textSize(16.0f);
        this.text("Press ENTER to return to menu", this.sizx / 2, this.sizy / 2 + 30);
        if (this.pressed[10]) {
            this.pressed[10] = false;
            this.settings.mode = 0;
            this.settings.start = true;
        }
    }

    public void loadMode(int mode) {
        int i;
        if (mode == 0) {
            this.settings.selection = 0;
            if (this.sound) {
                this.loadSoundBackground(1);
            }
        }
        if (mode == 1) {
            this.player.setLife(5);
            this.settings.currentLevel = 0;
            this.settings.start = true;
            this.loadSoundBackground(2);
        }
        if (mode == 2) {
            this.nbDroid = this.settings.arcadeLevel;
            this.droid = new Droid[this.nbDroid];
            i = 0;
            while (i < this.nbDroid) {
                this.droid[i] = new Droid();
                ++i;
            }
            this.loadSoundBackground(3);
        }
        if (mode == 3) {
            this.players = new Player[this.settings.nbJoueurs];
            i = 0;
            while (i < this.settings.nbJoueurs) {
                this.players[i] = new Player(i);
                this.players[i].place((i + 1) * this.sizx / (this.settings.nbJoueurs + 1), 400.0f, true);
                ++i;
            }
            this.nbDroid = this.settings.arcadeLevel;
            this.droid = new Droid[this.nbDroid];
            i = 0;
            while (i < this.nbDroid) {
                this.droid[i] = new Droid();
                ++i;
            }
            this.loadSoundBackground(3);
        }
        if (mode == 4) {
            this.settings.selection = 0;
            this.loadSoundBackground(4);
        }
        if (mode == 5) {
            String[] cus = this.loadStrings(this.dataPath("customLevel.txt"));
            if (this.settings.start) {
                this.player.setLife(PApplet.parseInt((String)cus[0]));
                this.settings.start = false;
            }
            this.nbDroid = PApplet.parseInt((String)cus[1]);
            this.droid = new Droid[this.nbDroid];
            int cusI = 2;
            int i2 = 0;
            while (i2 < this.nbDroid) {
                if (PApplet.parseInt((String)cus[cusI]) == 0) {
                    this.droid[i2] = new DroidGentle(PApplet.parseFloat((String)cus[cusI + 1]), PApplet.parseFloat((String)cus[cusI + 2]), PApplet.parseFloat((String)cus[cusI + 3]), PApplet.parseInt((String)cus[cusI + 4]));
                    cusI += 5;
                } else if (PApplet.parseInt((String)cus[cusI]) == 1) {
                    this.droid[i2] = new DroidStill(PApplet.parseFloat((String)cus[cusI + 1]), PApplet.parseFloat((String)cus[cusI + 2]), PApplet.parseFloat((String)cus[cusI + 3]), PApplet.parseInt((String)cus[cusI + 4]), PApplet.parseFloat((String)cus[cusI + 5]));
                    cusI += 6;
                } else if (PApplet.parseInt((String)cus[cusI]) == 2) {
                    this.droid[i2] = new DroidGater(PApplet.parseFloat((String)cus[cusI + 1]), PApplet.parseFloat((String)cus[cusI + 2]), PApplet.parseFloat((String)cus[cusI + 3]), PApplet.parseInt((String)cus[cusI + 4]), PApplet.parseFloat((String)cus[cusI + 5]));
                    cusI += 6;
                } else if (PApplet.parseInt((String)cus[cusI]) == 3) {
                    int nbPath = PApplet.parseInt((String)cus[cusI + 1]);
                    cusI += 2;
                    float[] pathX = new float[nbPath];
                    float[] pathY = new float[nbPath];
                    int i22 = 0;
                    while (i22 < nbPath) {
                        pathX[i22] = PApplet.parseFloat((String)cus[cusI + i22]);
                        ++i22;
                    }
                    cusI += nbPath;
                    i22 = 0;
                    while (i22 < nbPath) {
                        pathY[i22] = PApplet.parseFloat((String)cus[cusI + i22]);
                        ++i22;
                    }
                    this.droid[i2] = new DroidPath(PApplet.parseFloat((String)cus[(cusI += nbPath) + 0]), PApplet.parseFloat((String)cus[cusI + 1]), PApplet.parseFloat((String)cus[cusI + 2]), PApplet.parseInt((String)cus[cusI + 3]), PApplet.parseFloat((String)cus[cusI + 4]), pathX, pathY, PApplet.parseInt((String)cus[cusI + 5]), PApplet.parseFloat((String)cus[cusI + 6]));
                    cusI += 7;
                } else if (PApplet.parseInt((String)cus[cusI]) == 4) {
                    this.droid[i2] = new Droid(PApplet.parseFloat((String)cus[cusI + 1]), PApplet.parseFloat((String)cus[cusI + 2]));
                    cusI += 3;
                } else if (PApplet.parseInt((String)cus[cusI]) == 5) {
                    this.droid[i2] = new Droid();
                    ++cusI;
                }
                ++i2;
            }
            this.player.place(PApplet.parseFloat((String)cus[cusI]), PApplet.parseFloat((String)cus[cusI + 1]), PApplet.parseBoolean((String)cus[cusI + 2]));
            cusI += 3;
            this.loadSoundBackground(3);
        }
    }

    public void loadSoundBackground(int i) {
        if (this.sound) {
            this.fond1.stop();
            this.fond2.stop();
            this.fond3.stop();
            this.fond4.stop();
            if (i == 1) {
                this.fond1.loop();
            }
            if (i == 2) {
                this.fond2.loop();
            }
            if (i == 3) {
                this.fond3.loop();
            }
            if (i == 4) {
                this.fond4.loop();
            }
        }
    }

    public float longueur(float x, float y, float x2, float y2) {
        return gazoline.sqrt((float)(gazoline.sq((float)(x2 - x)) + gazoline.sq((float)(y2 - y))));
    }

    public void loadSound() {
        this.playerRespawn = new SoundFile((PApplet)this, this.dataPath("playerRespawn.wav"));
        this.droidDie = new SoundFile((PApplet)this, this.dataPath("droidDie.wav"));
        this.playerDie = new SoundFile((PApplet)this, this.dataPath("playerDie.wav"));
        this.playerBounce = new SoundFile((PApplet)this, this.dataPath("playerBounce.wav"));
        this.playerLand = new SoundFile((PApplet)this, this.dataPath("playerLand.wav"));
        this.playerJump = new SoundFile((PApplet)this, this.dataPath("playerJump.wav"));
        this.playerHang = new SoundFile((PApplet)this, this.dataPath("playerHang.wav"));
        this.playerJet = new SoundFile((PApplet)this, this.dataPath("playerJet.wav"));
        this.droidMove = new SoundFile((PApplet)this, this.dataPath("droidMove.wav"));
        this.droidFire = new SoundFile((PApplet)this, this.dataPath("droidFire.wav"));
        this.playerSlide = new SoundFile((PApplet)this, this.dataPath("playerSlide.wav"));
        this.playerStill = new SoundFile((PApplet)this, this.dataPath("playerStill.wav"));
        this.droidLaser = new SoundFile((PApplet)this, this.dataPath("droidLaser.wav"));
        this.keyP = new SoundFile((PApplet)this, this.dataPath("keyP.wav"));
        this.fond1 = new SoundFile((PApplet)this, this.dataPath("fond01.wav"));
        this.fond2 = new SoundFile((PApplet)this, this.dataPath("fond02.wav"));
        this.fond3 = new SoundFile((PApplet)this, this.dataPath("fond03.wav"));
        this.fond4 = new SoundFile((PApplet)this, this.dataPath("fond04.wav"));
    }

    public void settings() {
        this.size(500, 500, "processing.opengl.PGraphics2D");
        this.noSmooth();
    }

    public static void main(String[] passedArgs) {
        String[] appletArgs = new String[]{"gazoline"};
        if (passedArgs != null) {
            PApplet.main((String[])gazoline.concat((String[])appletArgs, (String[])passedArgs));
        } else {
            PApplet.main((String[])appletArgs);
        }
    }

    class Droid {
        float x;
        float y;
        float xD;
        float yD;
        int phase = 0;
        float t = 0.0f;
        float tirA = 0.0f;
        float siz = 18.0f;
        float freqFonct = 1.0f;
        boolean vivant = true;
        int creve = 10;

        Droid() {
            this.x = gazoline.this.random((float)gazoline.this.width - this.siz);
            this.y = gazoline.this.random(gazoline.this.height * 3 / 7) + (float)(gazoline.this.height / 7);
            this.freqFonct = gazoline.this.random(0.1f, 0.8f);
            this.vivant = true;
        }

        Droid(float x, float y) {
            this.x = x;
            this.y = y;
            this.freqFonct = gazoline.this.random(0.1f, 0.8f);
            this.vivant = true;
        }

        public void agit() {
            if (this.vivant) {
                this.t += this.freqFonct;
                if (this.t > 100.0f) {
                    this.t = 0.0f;
                    this.phase = (this.phase + 1) % 4;
                    if (this.phase == 1) {
                        this.moveSet();
                    }
                    if (this.phase == 2) {
                        this.tirSet();
                        if (gazoline.this.sound) {
                            gazoline.this.droidLaser.play();
                        }
                    }
                    if (this.phase == 3) {
                        this.fireSet();
                    }
                }
                if (this.phase == 1) {
                    this.move();
                }
            }
        }

        public void dessine() {
            if (this.vivant) {
                if (this.phase == 0) {
                    gazoline.this.image(gazoline.this.dC, this.x, this.y);
                }
                if (this.phase == 1) {
                    gazoline.this.image(gazoline.this.dS, this.x, this.y);
                }
                if (this.phase == 2) {
                    gazoline.this.image(gazoline.this.dS, this.x, this.y);
                    gazoline.this.stroke(0.0f, 255.0f - gazoline.max((float)((this.t - 80.0f) * 255.0f / 20.0f), (float)0.0f), 255.0f);
                    gazoline.this.strokeWeight(2.0f);
                    gazoline.this.line(this.x + this.siz / 2.0f, this.y + this.siz / 2.0f, this.x + this.siz / 2.0f + gazoline.cos((float)this.tirA) * 1000.0f, this.y + this.siz / 2.0f + gazoline.sin((float)this.tirA) * 1000.0f);
                    gazoline.this.strokeWeight(1.0f);
                }
                if (this.phase == 3) {
                    gazoline.this.image(gazoline.this.dF, this.x, this.y);
                    gazoline.this.stroke(32.0f, 255.0f, 255.0f);
                    gazoline.this.strokeWeight(5.0f);
                    gazoline.this.line(this.x + this.siz / 2.0f, this.y + this.siz / 2.0f, this.x + this.siz / 2.0f + gazoline.cos((float)this.tirA) * 1000.0f, this.y + this.siz / 2.0f + gazoline.sin((float)this.tirA) * 1000.0f);
                    gazoline.this.strokeWeight(1.0f);
                }
            } else if (this.creve > 0) {
                --this.creve;
                gazoline.this.image(gazoline.this.dD, this.x, this.y);
            }
        }

        public void moveSet() {
            this.xD = gazoline.this.random((float)gazoline.this.width - this.siz);
            this.yD = gazoline.this.random(gazoline.this.height * 3 / 7) + (float)(gazoline.this.height / 7);
            if (gazoline.this.sound) {
                gazoline.this.droidMove.play();
            }
        }

        public void move() {
            this.x = this.x * 4.0f / 5.0f + this.xD * 1.0f / 5.0f;
            this.y = this.y * 4.0f / 5.0f + this.yD * 1.0f / 5.0f;
        }

        public void tirSet() {
            this.tirA = 0.7853982f + gazoline.this.random(1.5707964f) + (this.x * 2.0f / (float)gazoline.this.sizx - 1.0f) * 0.7853982f;
        }

        public void fireSet() {
            this.t = 95.0f;
            if (gazoline.this.sound) {
                gazoline.this.droidFire.play();
            }
        }

        public boolean getVivant() {
            return this.vivant;
        }

        public int getPhase() {
            return this.phase;
        }

        public float getX() {
            return this.x;
        }

        public float getY() {
            return this.y;
        }

        public float getSiz() {
            return this.siz;
        }

        public float getTirA() {
            return this.tirA;
        }
    }

    class DroidGater
    extends Droid {
        DroidGater(float x, float y, float tirA, int phase, float freqFonct) {
            this.x = x;
            this.y = y;
            this.tirA = tirA * (float)Math.PI / 180.0f;
            this.phase = phase;
            this.vivant = true;
            this.freqFonct = freqFonct;
        }

        @Override
        public void tirSet() {
            this.t = 95.0f;
        }

        @Override
        public void fireSet() {
        }

        @Override
        public void moveSet() {
            this.t = 99.0f;
        }

        @Override
        public void move() {
        }
    }

    class DroidGentle
    extends Droid {
        DroidGentle(float x, float y, float tirA, int phase) {
            this.x = x;
            this.y = y;
            this.tirA = tirA * (float)Math.PI / 180.0f;
            this.phase = phase;
            this.vivant = true;
        }

        @Override
        public void agit() {
        }
    }

    class DroidPath
    extends Droid {
        int currentPath;
        float[] pathX;
        float[] pathY;

        DroidPath(float x, float y, float tirA, int phase, float freqFonct, float[] pathX, float[] pathY, int currentPath, float t) {
            this.currentPath = currentPath;
            this.x = x;
            this.y = y;
            this.tirA = tirA * (float)Math.PI / 180.0f;
            this.phase = phase;
            this.vivant = true;
            this.freqFonct = freqFonct;
            this.pathX = pathX;
            this.pathY = pathY;
            this.t = t;
        }

        @Override
        public void moveSet() {
            this.currentPath = (this.currentPath + 1) % this.pathX.length;
            this.xD = this.pathX[this.currentPath];
            this.yD = this.pathY[this.currentPath];
            if (gazoline.this.sound) {
                gazoline.this.droidMove.play();
            }
        }

        @Override
        public void tirSet() {
        }
    }

    class DroidStill
    extends Droid {
        DroidStill(float x, float y, float tirA, int phase, float freqFonct) {
            this.x = x;
            this.y = y;
            this.tirA = tirA * (float)Math.PI / 180.0f;
            this.phase = phase;
            this.vivant = true;
            this.freqFonct = freqFonct;
        }

        @Override
        public void moveSet() {
            this.t = 99.0f;
        }

        @Override
        public void move() {
        }

        @Override
        public void tirSet() {
        }
    }

    class Player {
        int[] touches = new int[3];
        float x;
        float y;
        float vX;
        float vY;
        boolean saut = true;
        boolean sautPret = true;
        int sprite = 0;
        int altSp = 0;
        int sprSpeed = 10;
        float siz = 19.0f;
        int hanged = -1;
        float spiderX = -1.0f;
        float spiderY = -1.0f;
        float longFil = 0.0f;
        float balance;
        float balPos;
        boolean dbJump = false;
        boolean vivant = true;
        int combo = 0;
        int life = 0;

        Player(int j) {
            this.x = gazoline.this.sizx / 2;
            this.y = gazoline.this.sizy * 2 / 3;
            this.touches[0] = gazoline.this.settings.touchesSet[j][0];
            this.touches[1] = gazoline.this.settings.touchesSet[j][1];
            this.touches[2] = gazoline.this.settings.touchesSet[j][2];
        }

        public void keys() {
            ++this.altSp;
            if (this.vivant) {
                float hauteurFric = gazoline.max((float)1.0f, (float)(((float)gazoline.this.sizy - this.y) * 4.0f / (float)gazoline.this.sizy));
                if (gazoline.this.pressed[this.touches[0]]) {
                    if (!this.saut && this.vX >= 0.0f && gazoline.this.sound) {
                        gazoline.this.playerSlide.play();
                    }
                    this.vX = gazoline.min((float)this.vX, (float)-2.0f);
                    this.vX -= 0.2f / hauteurFric;
                    if (!(this.sprite >= 1 && this.sprite <= 5 || this.saut)) {
                        this.altSp = 0;
                        this.sprite = 1;
                    }
                    if (this.altSp > this.sprSpeed * 2 / 3) {
                        this.sprite = this.altSp < this.sprSpeed * 3 ? (this.altSp % this.sprSpeed < this.sprSpeed / 2 ? 2 : 3) : (this.altSp % this.sprSpeed < this.sprSpeed / 2 ? 4 : 5);
                    }
                }
                if (gazoline.this.pressed[this.touches[2]]) {
                    if (!this.saut && this.vX <= 0.0f && gazoline.this.sound) {
                        gazoline.this.playerSlide.play();
                    }
                    this.vX = gazoline.max((float)this.vX, (float)2.0f);
                    this.vX += 0.2f / hauteurFric;
                    if (!(this.sprite >= 6 && this.sprite <= 10 || this.saut)) {
                        this.altSp = 0;
                        this.sprite = 6;
                    }
                    if (this.altSp > this.sprSpeed * 2 / 3) {
                        this.sprite = this.altSp < this.sprSpeed * 3 ? (this.altSp % this.sprSpeed < this.sprSpeed / 2 ? 7 : 8) : (this.altSp % this.sprSpeed < this.sprSpeed / 2 ? 9 : 10);
                    }
                }
                this.vX = gazoline.constrain((float)this.vX, (float)-5.0f, (float)5.0f);
                if (gazoline.this.pressed[this.touches[1]]) {
                    if (this.sautPret) {
                        this.vY -= 7.0f;
                        if (gazoline.this.sound) {
                            gazoline.this.playerJump.play();
                        }
                        this.saut = true;
                        this.sautPret = false;
                    }
                    if (this.vY <= -1.0f) {
                        this.sprite = this.altSp % this.sprSpeed < this.sprSpeed / 2 ? 11 : 12;
                    }
                } else if (!this.dbJump) {
                    this.vY = gazoline.max((float)this.vY, (float)-3.0f);
                }
            }
        }

        public void deplace() {
            if (this.vivant) {
                int i;
                if (this.hanged == -1) {
                    float distance;
                    this.x += this.vX;
                    if (this.x < 0.0f || this.x > (float)gazoline.this.sizx - this.siz) {
                        this.x = gazoline.constrain((float)this.x, (float)0.0f, (float)((float)gazoline.this.sizx - this.siz));
                        this.vX = 0.0f;
                    }
                    if (gazoline.abs((float)this.vX) < 1.0f) {
                        if (gazoline.abs((float)this.vX) > 0.0f) {
                            if (gazoline.this.sound) {
                                gazoline.this.playerStill.play();
                            }
                            this.vX = 0.0f;
                        }
                        if (this.vY > -1.0f && !this.saut && (this.sprite != 14 || this.altSp > this.sprSpeed * 3)) {
                            this.sprite = 0;
                        }
                        if (this.vY > 1.0f) {
                            this.sprite = 13;
                        }
                    }
                    if (this.vY > 2.0f) {
                        if (this.vX <= -2.0f) {
                            this.sprite = 15;
                        }
                        if (this.vX >= 2.0f) {
                            this.sprite = 16;
                        }
                    }
                    this.y += this.vY;
                    this.vY += 0.3f;
                    if (!(gazoline.this.pressed[this.touches[2]] || gazoline.this.pressed[this.touches[0]] || this.dbJump)) {
                        this.vX /= 1.3f;
                    }
                    if (this.y + this.siz > gazoline.this.sol) {
                        this.combo = 0;
                        this.dbJump = false;
                        this.y = gazoline.this.sol - this.siz;
                        this.vY = 0.0f;
                        if (this.saut) {
                            this.sprite = 14;
                            this.saut = false;
                            this.altSp = 0;
                            this.sautPret = false;
                            if (gazoline.this.sound) {
                                gazoline.this.playerLand.play();
                            }
                        } else {
                            ++this.altSp;
                        }
                        if (!gazoline.this.pressed[this.touches[1]]) {
                            this.sautPret = true;
                        }
                    }
                    if (gazoline.this.pressed[this.touches[1]] && this.y < gazoline.this.sol - this.siz * 2.0f) {
                        i = 0;
                        while (i < gazoline.this.nbDroid) {
                            if (gazoline.this.droid[i].getVivant() && gazoline.this.droid[i].getPhase() == 2) {
                                boolean accroche = false;
                                float aParc = gazoline.ceil((float)gazoline.sqrt((float)(gazoline.sq((float)this.vX) + gazoline.sq((float)this.vY))));
                                int i2 = 0;
                                while ((float)i2 < aParc && !accroche) {
                                    float yDep = this.vY * (float)i2 / aParc;
                                    float xDep = this.vX * (float)i2 / aParc;
                                    float aA = gazoline.atan2((float)(this.y + yDep - (gazoline.this.droid[i].getY() + gazoline.this.droid[i].getSiz() / 2.0f)), (float)(this.x + xDep + this.siz / 2.0f - (gazoline.this.droid[i].getX() + gazoline.this.droid[i].getSiz() / 2.0f)));
                                    float aB = gazoline.atan2((float)(this.y + this.siz - (gazoline.this.droid[i].getY() + gazoline.this.droid[i].getSiz() / 2.0f)), (float)(this.x + this.siz * 1.0f / 3.0f - (gazoline.this.droid[i].getX() + gazoline.this.droid[i].getSiz() / 2.0f)));
                                    float aC = gazoline.atan2((float)(this.y + this.siz - (gazoline.this.droid[i].getY() + gazoline.this.droid[i].getSiz() / 2.0f)), (float)(this.x + this.siz * 2.0f / 3.0f - (gazoline.this.droid[i].getX() + gazoline.this.droid[i].getSiz() / 2.0f)));
                                    float aMin = (gazoline.min((float)aA, (float)gazoline.min((float)aB, (float)aC)) + (float)Math.PI * 2) % ((float)Math.PI * 2);
                                    float aMax = (gazoline.max((float)aA, (float)gazoline.max((float)aB, (float)aC)) + (float)Math.PI * 2) % ((float)Math.PI * 2);
                                    distance = gazoline.this.longueur(this.x + xDep + this.siz / 2.0f, this.y + yDep, gazoline.this.droid[i].getX(), gazoline.this.droid[i].getY());
                                    if ((gazoline.this.droid[i].getTirA() + (float)Math.PI * 2) % ((float)Math.PI * 2) <= aMax && (gazoline.this.droid[i].getTirA() + (float)Math.PI * 2) % ((float)Math.PI * 2) >= aMin) {
                                        this.hanged = i;
                                        accroche = true;
                                        this.spiderX = gazoline.this.droid[i].getX() + gazoline.this.droid[i].getSiz() / 2.0f + distance * gazoline.cos((float)gazoline.this.droid[i].getTirA());
                                        this.spiderY = gazoline.this.droid[i].getY() + gazoline.this.droid[i].getSiz() / 2.0f + distance * gazoline.sin((float)gazoline.this.droid[i].getTirA());
                                        this.x = this.spiderX - this.siz / 2.0f;
                                        this.y = this.spiderY;
                                        this.vY = 0.0f;
                                        this.longFil = 1.0f;
                                        this.balPos = 1.5707964f;
                                        this.balance = this.vX / 5.0f * -0.15707964f;
                                        if (gazoline.this.sound) {
                                            gazoline.this.playerHang.play();
                                        }
                                    }
                                    ++i2;
                                }
                            }
                            ++i;
                        }
                    }
                    i = 0;
                    while (i < gazoline.this.nbDroid) {
                        if (gazoline.this.droid[i].getPhase() == 3 && gazoline.this.droid[i].getVivant()) {
                            boolean mort = false;
                            float aA = gazoline.atan2((float)(this.y - (gazoline.this.droid[i].getY() + gazoline.this.droid[i].getSiz() / 2.0f)), (float)(this.x + this.siz / 2.0f - (gazoline.this.droid[i].getX() + gazoline.this.droid[i].getSiz() / 2.0f)));
                            float aB = gazoline.atan2((float)(this.y + this.siz - (gazoline.this.droid[i].getY() + gazoline.this.droid[i].getSiz() / 2.0f)), (float)(this.x - (gazoline.this.droid[i].getX() + gazoline.this.droid[i].getSiz() / 2.0f)));
                            float aC = gazoline.atan2((float)(this.y + this.siz - (gazoline.this.droid[i].getY() + gazoline.this.droid[i].getSiz() / 2.0f)), (float)(this.x + this.siz - (gazoline.this.droid[i].getX() + gazoline.this.droid[i].getSiz() / 2.0f)));
                            float aMin = (gazoline.min((float)aA, (float)gazoline.min((float)aB, (float)aC)) + (float)Math.PI * 2) % ((float)Math.PI * 2);
                            float aMax = (gazoline.max((float)aA, (float)gazoline.max((float)aB, (float)aC)) + (float)Math.PI * 2) % ((float)Math.PI * 2);
                            if ((gazoline.this.droid[i].getTirA() + (float)Math.PI * 2) % ((float)Math.PI * 2) <= aMax && (gazoline.this.droid[i].getTirA() + (float)Math.PI * 2) % ((float)Math.PI * 2) >= aMin) {
                                mort = true;
                                float distance2 = gazoline.this.longueur(this.x + this.siz / 2.0f, this.y, gazoline.this.droid[i].getX(), gazoline.this.droid[i].getY());
                                this.x = gazoline.this.droid[i].getX() + gazoline.this.droid[i].getSiz() / 2.0f + distance2 * gazoline.cos((float)gazoline.this.droid[i].getTirA()) - this.siz / 2.0f;
                                this.y = gazoline.this.droid[i].getY() + gazoline.this.droid[i].getSiz() / 2.0f + distance2 * gazoline.sin((float)gazoline.this.droid[i].getTirA());
                                this.vivant = false;
                                this.hanged = -1;
                                this.vY = -10.0f;
                                this.vX = gazoline.constrain((float)(this.x + this.siz / 2.0f - (gazoline.this.droid[i].getX() + gazoline.this.droid[i].getSiz() / 2.0f)), (float)-10.0f, (float)10.0f);
                                if (gazoline.abs((float)this.vX) < 1.0f) {
                                    this.vX = -2.0f;
                                }
                                --this.life;
                                if (gazoline.this.sound) {
                                    gazoline.this.playerDie.play();
                                }
                            }
                            float aParc = gazoline.ceil((float)gazoline.sqrt((float)(gazoline.sq((float)this.vX) + gazoline.sq((float)this.vY))));
                            int i2 = 0;
                            while ((float)i2 < aParc && !mort) {
                                float yDep = this.vY * (float)i2 / aParc;
                                float xDep = this.vX * (float)i2 / aParc;
                                if (gazoline.abs((float)(gazoline.atan2((float)(this.y + yDep - gazoline.this.droid[i].getY()), (float)(this.x + this.siz / 2.0f + xDep - gazoline.this.droid[i].getX())) - gazoline.this.droid[i].getTirA())) < 0.03141593f) {
                                    mort = true;
                                    distance = gazoline.this.longueur(this.x + this.siz / 2.0f, this.y, gazoline.this.droid[i].getX(), gazoline.this.droid[i].getY());
                                    this.x = gazoline.this.droid[i].getX() + gazoline.this.droid[i].getSiz() / 2.0f + distance * gazoline.cos((float)gazoline.this.droid[i].getTirA()) - this.siz / 2.0f;
                                    this.y = gazoline.this.droid[i].getY() + gazoline.this.droid[i].getSiz() / 2.0f + distance * gazoline.sin((float)gazoline.this.droid[i].getTirA());
                                    this.vivant = false;
                                    this.hanged = -1;
                                    this.vY = -10.0f;
                                    this.vX = gazoline.constrain((float)(this.x + this.siz / 2.0f - (gazoline.this.droid[i].getX() + gazoline.this.droid[i].getSiz() / 2.0f)), (float)-10.0f, (float)10.0f);
                                    if (gazoline.abs((float)this.vX) < 1.0f) {
                                        this.vX = -2.0f;
                                    }
                                    --this.life;
                                    if (gazoline.this.sound) {
                                        gazoline.this.playerDie.play();
                                    }
                                }
                                ++i2;
                            }
                        }
                        ++i;
                    }
                } else {
                    this.sprite = 17;
                    if (this.spiderY + this.longFil + this.siz + 3.0f < gazoline.this.sol) {
                        this.longFil += 2.0f;
                    }
                    this.balance -= (this.balPos - 1.5707964f) / (this.longFil * 4.0f);
                    this.balPos += this.balance;
                    this.y = this.spiderY + this.longFil * gazoline.sin((float)this.balPos);
                    this.x = this.spiderX + this.longFil * gazoline.cos((float)this.balPos) - this.siz / 2.0f;
                    this.x = gazoline.constrain((float)this.x, (float)0.0f, (float)((float)gazoline.this.sizx - this.siz));
                    if (!gazoline.this.pressed[this.touches[1]]) {
                        this.hanged = -1;
                        this.vY = gazoline.sin((float)(this.balPos + (float)Math.PI)) * gazoline.constrain((float)this.longFil, (float)3.0f, (float)gazoline.min((float)15.0f, (float)(this.y / 25.0f)));
                        this.vX = gazoline.cos((float)(this.balPos + (float)Math.PI)) * gazoline.constrain((float)this.longFil, (float)3.0f, (float)gazoline.min((float)15.0f, (float)(this.y / 25.0f)));
                        this.dbJump = true;
                        if (gazoline.this.sound) {
                            gazoline.this.playerJet.play();
                        }
                    } else if (gazoline.this.droid[this.hanged].getPhase() != 2) {
                        this.hanged = -1;
                        this.dbJump = false;
                    }
                }
                i = 0;
                while (i < gazoline.this.nbDroid) {
                    if (gazoline.this.droid[i].getVivant() && this.x + this.siz / 2.0f >= gazoline.this.droid[i].getX() && this.x + this.siz / 2.0f <= gazoline.this.droid[i].getX() + gazoline.this.droid[i].getSiz() && this.y + this.siz / 2.0f >= gazoline.this.droid[i].getY() && this.y + this.siz / 2.0f <= gazoline.this.droid[i].getY() + gazoline.this.droid[i].getSiz()) {
                        gazoline.this.droid[i].vivant = false;
                        gazoline.this.droid[i].creve = 10;
                        if (gazoline.this.sound) {
                            gazoline.this.droidDie.play();
                        }
                        ++this.combo;
                    }
                    ++i;
                }
            } else {
                this.sprite = 18;
                this.vY += 0.5f;
                this.vX *= 0.95f;
                this.y += this.vY;
                this.x += this.vX;
                if (this.x < 0.0f || this.x > (float)gazoline.this.sizx - this.siz) {
                    this.x = gazoline.constrain((float)this.x, (float)0.0f, (float)((float)gazoline.this.sizx - this.siz));
                    this.vX = -this.vX;
                }
                if (this.y + 12.0f >= gazoline.this.sol) {
                    this.y = gazoline.this.sol - 12.0f;
                    this.vY = -this.vY * 2.0f / 3.0f;
                    if (gazoline.abs((float)this.vY) > 2.0f) {
                        if (gazoline.this.sound) {
                            gazoline.this.playerBounce.play();
                        }
                    } else {
                        this.vivant = true;
                        if (gazoline.this.sound) {
                            gazoline.this.playerRespawn.play();
                        }
                    }
                }
            }
        }

        public void dessine() {
            if (this.sprite == 0) {
                gazoline.this.image(gazoline.this.plS, this.x, this.y);
            }
            if (this.sprite == 1) {
                gazoline.this.image(gazoline.this.plStL, this.x, this.y);
            }
            if (this.sprite == 2) {
                gazoline.this.image(gazoline.this.plR1L, this.x, this.y);
            }
            if (this.sprite == 3) {
                gazoline.this.image(gazoline.this.plR2L, this.x, this.y);
            }
            if (this.sprite == 4) {
                gazoline.this.image(gazoline.this.plRF1L, this.x, this.y);
            }
            if (this.sprite == 5) {
                gazoline.this.image(gazoline.this.plRF2L, this.x, this.y);
            }
            if (this.sprite == 6) {
                gazoline.this.image(gazoline.this.plStR, this.x, this.y);
            }
            if (this.sprite == 7) {
                gazoline.this.image(gazoline.this.plR1R, this.x, this.y);
            }
            if (this.sprite == 8) {
                gazoline.this.image(gazoline.this.plR2R, this.x, this.y);
            }
            if (this.sprite == 9) {
                gazoline.this.image(gazoline.this.plRF1R, this.x, this.y);
            }
            if (this.sprite == 10) {
                gazoline.this.image(gazoline.this.plRF2R, this.x, this.y);
            }
            if (this.sprite == 11) {
                gazoline.this.image(gazoline.this.plJ1, this.x, this.y);
            }
            if (this.sprite == 12) {
                gazoline.this.image(gazoline.this.plJ2, this.x, this.y);
            }
            if (this.sprite == 13) {
                gazoline.this.image(gazoline.this.plF, this.x, this.y);
            }
            if (this.sprite == 14) {
                gazoline.this.image(gazoline.this.plL, this.x, this.y);
            }
            if (this.sprite == 15) {
                gazoline.this.image(gazoline.this.plFL, this.x, this.y);
            }
            if (this.sprite == 16) {
                gazoline.this.image(gazoline.this.plFR, this.x, this.y);
            }
            if (this.sprite == 17) {
                gazoline.this.stroke(0);
                gazoline.this.fill(0.0f, 0.0f, 255.0f);
                gazoline.this.ellipse(this.x + this.siz / 2.0f, this.y + 3.0f, 6.0f, 6.0f);
                gazoline.this.point(this.x + this.siz / 2.0f, this.y + 3.0f);
                gazoline.this.line(this.x + this.siz / 2.0f - 2.0f, this.y + 6.0f, this.x + this.siz / 2.0f - 5.0f + this.balance * 50.0f, this.y + 10.0f);
                gazoline.this.line(this.x + this.siz / 2.0f + 2.0f, this.y + 6.0f, this.x + this.siz / 2.0f + 5.0f + this.balance * 50.0f, this.y + 10.0f);
                if (this.hanged != -1) {
                    gazoline.this.line(this.x + this.siz / 2.0f, this.y, this.spiderX, this.spiderY);
                } else {
                    gazoline.this.line(this.x + this.siz / 2.0f, this.y, this.x + this.siz / 2.0f, this.y - 3.0f);
                }
            }
            if (this.sprite == 18) {
                gazoline.this.image(gazoline.this.plD, this.x, this.y);
            }
        }

        public void place(float x, float y, boolean still) {
            if (still) {
                this.vX = 0.0f;
                this.vY = 0.0f;
                this.vivant = true;
                this.dbJump = false;
                this.hanged = -1;
            }
            this.x = x;
            this.y = y;
        }

        public void setLife(int life) {
            this.life = life;
        }

        public int getCombo() {
            return this.combo;
        }

        public int getLife() {
            return this.life;
        }
    }

    class Settings {
        int nbJoueursMax = 5;
        int[][] touchesSet = new int[this.nbJoueursMax][3];
        int mode = 0;
        int selection = 0;
        int currentLevel = 0;
        boolean start = true;
        String labelA = "";
        String labelB = "";
        String labelC = "";
        int comboDec = 0;
        int comboDisp = 0;
        int keyToDefine = -1;
        int nbJoueurs = 2;
        int arcadeLevel = 10;
        int playerToDefine = 0;

        Settings() {
            int i = 0;
            while (i < this.nbJoueursMax) {
                this.touchesSet[i][0] = 115;
                this.touchesSet[i][1] = 100;
                this.touchesSet[i][2] = 102;
                ++i;
            }
        }
    }
}

