
PVector scale = new PVector(0.05, 0.05);

River river;

float[][] relief;

int t=0;

void setup() {
  size(600, 400);
  frameRate(40);
  noStroke();
  colorMode(HSB);
  PImage pic = loadImage("pic.jpg");
  relief = new float[width][height];
  for (int x = 0; x < width; x++) {
    for (int y = 0; y < height; y++) {
      relief[x][y] = (float)brightness(pic.get(floor((float)x/width*pic.width), floor((float)y/height*pic.height)))/0x100;
    }
  }
  for (int x = 0; x < width; x++) {
    for (int y = 0; y < height; y++) {
      stroke(relief[x][y]*0xFF);
      point(x, y);
    }
  }
  river = new River();
}

void draw() {
  for (int i=0; i<5; i++) river.flow();
  river.drawIt();
  t++;
}

class River {
  ArrayList<PVector> points = new ArrayList<PVector>();
  ArrayList<Float> pointsDist = new ArrayList<Float>();
  ArrayList<Integer> pointsT = new ArrayList<Integer>();
  ArrayList<PVector> potentialPoints = new ArrayList<PVector>();
  ArrayList<Float> potentialPointsSlope = new ArrayList<Float>();
  ArrayList<Float> potentialPointsDist = new ArrayList<Float>();
  float currentsForce = 0.2f;
  float upflow = -1.0f;
  int lastD=0;
  float maxDist=0;
  River() {
    PVector highestPoint = new PVector(0, 0);
    for (int x = 0; x < width; x++) {
      for (int y = 0; y < height; y++) {
        if (relief[x][y]>relief[floor(highestPoint.x)][floor(highestPoint.y)]) highestPoint = new PVector(x, y);
      }
    }
    points.add(highestPoint);
    pointsDist.add(0.0f);
    pointsT.add(t);
    flowAround(points.get(0), 1);
  }
  void flow() {
    if (potentialPoints.size()>=width*height) {
      save("result.png");
      println("done");
    } else {
      if (potentialPoints.size()>0) {
        int bestCandidate = 0;
        for (int i=1; i<potentialPoints.size (); i++) {
          if (potentialPointsSlope.get(i)*points.size()-potentialPointsDist.get(i)*currentsForce<potentialPointsSlope.get(bestCandidate)*points.size()-potentialPointsDist.get(bestCandidate)*currentsForce) {
            bestCandidate=i;
          }
        }
        potentialPointsSlope.remove(bestCandidate);
        float thisDist = potentialPointsDist.remove(bestCandidate);
        points.add(potentialPoints.remove(bestCandidate));
        pointsDist.add(thisDist);
        maxDist=max(maxDist, thisDist);
        pointsT.add(t);
        flowAround(points.get(points.size()-1), thisDist);
      } else {
        upflow+=0.01;
        for (int i=0; i<points.size ()&&potentialPoints.size()==0; i++) flowAround(points.get(i), pointsDist.get(i));
      }
    }
  }
  void flowAround(PVector thisPoint, float distance) {
    for (int x=-1; x<2; x++) {
      for (int y=-1; y<2; y++) {
        if (x!=0||y!=0) {
          if (thisPoint.x+x>=0&&thisPoint.x+x<width&&thisPoint.y+y>=0&&thisPoint.y+y<height) {
            boolean found=false;
            for (PVector point : potentialPoints) if (point.x==thisPoint.x+x&&point.y==thisPoint.y+y) found = true;
            if (!found) for (PVector point : points) if (point.x==thisPoint.x+x&&point.y==thisPoint.y+y) found = true;
            if (!found) {
              float slope = relief[floor(thisPoint.x+x)][floor(thisPoint.y+y)]-relief[floor(thisPoint.x)][floor(thisPoint.y)];
              if (slope<=upflow) {
                potentialPoints.add(new PVector(thisPoint.x+x, thisPoint.y+y));
                potentialPointsSlope.add(slope);
                potentialPointsDist.add(distance+1);
              }
            }
          }
        }
      }
    }
  }
  void drawIt() {
    noStroke();
    for (int i=lastD; i<points.size (); i++) {
      PVector point = points.get(i);
      float pointDist = pointsDist.get(i); 
      fill(pointDist%0x100, 0xFF-pointDist*0x100/maxDist, (float)pointsT.get(i)*0x100/(width*height));
      rect(point.x, point.y, 1, 1);
    }
    lastD=points.size ();
  }
}

