import processing.core.*; 
import processing.data.*; 
import processing.event.*; 
import processing.opengl.*; 

import java.util.HashMap; 
import java.util.ArrayList; 
import java.io.File; 
import java.io.BufferedReader; 
import java.io.PrintWriter; 
import java.io.InputStream; 
import java.io.OutputStream; 
import java.io.IOException; 

public class randomPic extends PApplet {


PImage[][] ims;
int nbLayers=0;

public void setup() {
  boolean found=true;
  while (found) {
    File f = new File(dataPath(nf(nbLayers, 2)+"_00.png"));
    found=f.exists();
    if (found) nbLayers++;
  }
  ims = new PImage[nbLayers][];
  for (int i=0; i<nbLayers; i++) {
    int nbAlts=0;
    found=true;
    while (found) {
      File f = new File(dataPath(nf(i, 2)+"_"+nf(nbAlts, 2)+".png"));
      found=f.exists();
      if (found) nbAlts++;
    }
    ims[i] = new PImage[nbAlts];
    for (int j=0; j<nbAlts; j++) {
      ims[i][j] = loadImage(dataPath(nf(i, 2)+"_"+nf(j, 2)+".png"));
    }
  }
  size(ims[0][0].width, ims[0][0].width);
  generate();
  frame.setResizable(true);
}

public void draw() {
}

public void keyPressed() {
  if (keyCode==ENTER) generate();
  if (keyCode==TAB) save("result.png");
}

public void generate() {
  background(0xFF);
  for (int i=0; i<nbLayers; i++) {
    image(ims[i][floor(random(ims[i].length))], 0, 0, width, height);
  }
}

  static public void main(String[] passedArgs) {
    String[] appletArgs = new String[] { "randomPic" };
    if (passedArgs != null) {
      PApplet.main(concat(appletArgs, passedArgs));
    } else {
      PApplet.main(appletArgs);
    }
  }
}
