
int[][] types;

ArrayList<Zone> zones = new ArrayList<Zone>();

int typeIndex=0;

int simultZones=1;

ArrayList<boolean[]> dirModels = new ArrayList<boolean[]>();

int preFullFrames=0;
boolean redistrib=false;

float lerpToScreen = 1.0f;

boolean averagePicColors=true;

int operationRefresh = 100;

boolean allDone=false;
boolean heavyAdapt=false;

// ---

PImage temp;
PImage orig;

int frameNb=0;

String[] allFilesUrl;

Mirror[] mirrors = new Mirror[3];

// ---

int mode = 1;

void keyPressed() {
  if (keyCode==ENTER) initi();
  if (keyCode==TAB) save(dataPath("result/"+nf(getAllFilesFrom(dataPath("result")).length-1, 6)+".png"));
}

void initi() {
  operationRefresh = floor(random(1, 2000));
  lerpToScreen = 1.0f-random(random(random(random(1.0f))));
  preFullFrames=0;
  simultZones= floor(random(1, 3));
  redistrib=false;
  averagePicColors=random(1.0f)<0.5f;
  heavyAdapt=random(1.0f)<0.1f;
  String[] files = getAllFilesFrom(dataPath("pool"));
  try {
    orig = loadImage(files[floor(random(files.length))]);
    orig.resize(width, height);
  } 
  catch(Exception e) {
    orig = createImage(width, height, RGB);
    println(e);
  }
  if (random(1.0f)<0.15f) orig = get();
  // size(orig.width, orig.height);
  // frame.setSize(orig.width, orig.height);
  zones = new ArrayList<Zone>();
  color avgC = color(0);
  float nbAvg=0;
  types = new int[width][height];
  for (int y=0; y<height; y++) {
    for (int x=0; x<width; x++) {
      types[x][y]=-1;
      try {
        avgC = lerpColor(avgC, orig.get(x, y), 1.0f/++nbAvg);
      }
      catch(Exception e) {
        println(e);
        avgC=color(random(0x100));
      }
    }
  }
  setOperation();
  noStroke();
  fill(avgC, random(random(random(0x100))));
  rect(0, 0, width, height);
}

class Zone {
  ArrayList<PVector> points = new ArrayList<PVector>();
  ArrayList<PVector> totalPoints = new ArrayList<PVector>();
  int index;
  color c;
  boolean[] direction = new boolean[8];
  int landingColor;
  boolean active = true;
  boolean[] plainShapeMode = new boolean[8];
  boolean[] activeDir = new boolean[8];
  Zone(int[][] types) {
    this.index=typeIndex++;
    ArrayList<PVector> notDone = new ArrayList<PVector>();
    for (int x=0; x<width; x++) {
      for (int y=0; y<height; y++) {
        if (types[x][y]==-1) notDone.add(new PVector(x, y));
      }
    }
    if (notDone.size()>0) points.add(notDone.get(floor(random(notDone.size()))));
    else {
      int offsetX = floor(random(width));
      int offsetY = floor(random(height));
      boolean good=false;
      for (int x=0; x<width && !good; x++) {
        for (int y=0; y<height && !good; y++) {
          if (types[(x+offsetX+width)%width][(y+offsetY+height)%height]!=types[(x+offsetX+1+width)%width][(y+offsetY+0+height)%height]) good=true;
          if (types[(x+offsetX+width)%width][(y+offsetY+height)%height]!=types[(x+offsetX+0+width)%width][(y+offsetY+1+height)%height]) good=true;
          if (types[(x+offsetX+width)%width][(y+offsetY+height)%height]!=types[(x+offsetX-1+width)%width][(y+offsetY+0+height)%height]) good=true;
          if (types[(x+offsetX+width)%width][(y+offsetY+height)%height]!=types[(x+offsetX+0+width)%width][(y+offsetY-1+height)%height]) good=true;
          if (good) points.add(new PVector(floor((x+offsetX+width)%width), floor((y+offsetY+height)%height)));
        }
      }
      if (!good) points.add(new PVector(floor(random(width)), floor(random(height))));
    }
    landingColor = types[floor(points.get(0).x)][floor(points.get(0).y)];
    this.c = orig.get(floor(points.get(0).x), floor(points.get(0).y));
    int type = floor(random(dirModels.size()));
    direction = dirModels.get(type);
    for (int i=0; i<8; i++) activeDir[i] = true;
    for (int i=0; i<8; i++) plainShapeMode[i] = false;
    for (int i=0; i<2; i++) plainShapeMode[floor(random(8))] = true;
  }
  void expandIn(int[][] types) {
    ArrayList<PVector> newPoints = new ArrayList<PVector>();
    for (PVector point : points) {
      int newX = floor(point.x); 
      int newY = floor(point.y);
      if (types[newX][newY]==landingColor) {
        types[newX][newY] = index;
        totalPoints.add(new PVector(newX, newY));
        c = lerpColor(get(floor(points.get(0).x), floor(points.get(0).y)), c, lerpToScreen);
        if (!allDone&&heavyAdapt) c = lerpColor(c, get(floor(points.get(0).x), floor(points.get(0).y)), 0.5f);
        if (averagePicColors) c = lerpColor(c, orig.get(floor(points.get(0).x), floor(points.get(0).y)), 1.0f/totalPoints.size());
        stroke(c);
        point(floor(newX), floor(newY));
      }
      if (direction[0]&&activeDir[0]) {
        newX = floor(point.x+0);
        newY = floor(point.y-1);
        if (newX>=0 && newY>=0 && newX<width && newY<height) if (types[newX][newY]==landingColor && !alreadyHas(newPoints, new PVector(newX, newY))) newPoints.add(new PVector(newX, newY));
        if (newX>=0 && newY>=0 && newX<width && newY<height) if (types[newX][newY]!=landingColor && types[newX][newY]!=-1 && types[newX][newY]!=index && plainShapeMode[0]) activeDir[0]=false;
      }
      if (direction[1]&&activeDir[1]) {
        newX = floor(point.x+1);
        newY = floor(point.y-1);
        if (newX>=0 && newY>=0 && newX<width && newY<height) if (types[newX][newY]==landingColor && !alreadyHas(newPoints, new PVector(newX, newY))) newPoints.add(new PVector(newX, newY));
        if (newX>=0 && newY>=0 && newX<width && newY<height) if (types[newX][newY]!=landingColor && types[newX][newY]!=-1 && types[newX][newY]!=index && plainShapeMode[1]) activeDir[1]=false;
      }
      if (direction[2]&&activeDir[2]) {
        newX = floor(point.x+1);
        newY = floor(point.y+0);
        if (newX>=0 && newY>=0 && newX<width && newY<height) if (types[newX][newY]==landingColor && !alreadyHas(newPoints, new PVector(newX, newY))) newPoints.add(new PVector(newX, newY));
        if (newX>=0 && newY>=0 && newX<width && newY<height) if (types[newX][newY]!=landingColor && types[newX][newY]!=-1 && types[newX][newY]!=index && plainShapeMode[2]) activeDir[2]=false;
      }
      if (direction[3]&&activeDir[3]) {
        newX = floor(point.x+1);
        newY = floor(point.y+1);
        if (newX>=0 && newY>=0 && newX<width && newY<height) if (types[newX][newY]==landingColor && !alreadyHas(newPoints, new PVector(newX, newY))) newPoints.add(new PVector(newX, newY));
        if (newX>=0 && newY>=0 && newX<width && newY<height) if (types[newX][newY]!=landingColor && types[newX][newY]!=-1 && types[newX][newY]!=index && plainShapeMode[3]) activeDir[3]=false;
      }
      if (direction[4]&&activeDir[4]) {
        newX = floor(point.x+0);
        newY = floor(point.y+1);
        if (newX>=0 && newY>=0 && newX<width && newY<height) if (types[newX][newY]==landingColor && !alreadyHas(newPoints, new PVector(newX, newY))) newPoints.add(new PVector(newX, newY));
        if (newX>=0 && newY>=0 && newX<width && newY<height) if (types[newX][newY]!=landingColor && types[newX][newY]!=-1 && types[newX][newY]!=index && plainShapeMode[4]) activeDir[4]=false;
      }
      if (direction[5]&&activeDir[5]) {
        newX = floor(point.x-1);
        newY = floor(point.y+1);
        if (newX>=0 && newY>=0 && newX<width && newY<height) if (types[newX][newY]==landingColor && !alreadyHas(newPoints, new PVector(newX, newY))) newPoints.add(new PVector(newX, newY));
        if (newX>=0 && newY>=0 && newX<width && newY<height) if (types[newX][newY]!=landingColor && types[newX][newY]!=-1 && types[newX][newY]!=index && plainShapeMode[5]) activeDir[5]=false;
      }
      if (direction[6]&&activeDir[6]) {
        newX = floor(point.x-1);
        newY = floor(point.y+0);
        if (newX>=0 && newY>=0 && newX<width && newY<height) if (types[newX][newY]==landingColor && !alreadyHas(newPoints, new PVector(newX, newY))) newPoints.add(new PVector(newX, newY));
        if (newX>=0 && newY>=0 && newX<width && newY<height) if (types[newX][newY]!=landingColor && types[newX][newY]!=-1 && types[newX][newY]!=index && plainShapeMode[6]) activeDir[6]=false;
      }
      if (direction[7]&&activeDir[7]) {
        newX = floor(point.x-1);
        newY = floor(point.y-1);
        if (newX>=0 && newY>=0 && newX<width && newY<height) if (types[newX][newY]==landingColor && !alreadyHas(newPoints, new PVector(newX, newY))) newPoints.add(new PVector(newX, newY));
        if (newX>=0 && newY>=0 && newX<width && newY<height) if (types[newX][newY]!=landingColor && types[newX][newY]!=-1 && types[newX][newY]!=index && plainShapeMode[7]) activeDir[7]=false;
      }
    }
    points.clear();
    points = newPoints;
  }
  boolean alreadyHas(ArrayList<PVector> as, PVector v) {
    for (PVector a : as) if (a.x==v.x&&a.y==v.y) return true;
    return false;
  }
}

void setOperation() {
  dirModels.clear();
  int maxModels = floor (random (1, 5));
  for (int dm=0; dm<maxModels; dm++) {
    boolean[] direction = new boolean[8];
    for (int i=0; i<direction.length; i++) direction[i]=false;    
    /*
    int dirOffset = floor(floor(random(4))*2+1);
     if (random(1)<0.5f) dirOffset+=1;
     if (random(1)<0.5f && dirOffset%2==0) for (int i=0; i<2; i++) direction[(dirOffset+i*2)%direction.length]=true;
     else for (int i=0; i<3; i++) direction[(dirOffset+i)%direction.length]=true;
     while (random (1)<0.1f) direction[floor(random(direction.length))]=true;
     */
    int dirOffset = floor(floor(random(4))*2)+1;
    direction[dirOffset]=true;
    direction[(dirOffset+1)%direction.length]=true;
    direction[(dirOffset+3)%direction.length]=true;
    dirModels.add(direction);
  }
}

void setup() {
  frame.setBackground( new  java.awt.Color( 0, 0, 0 ));
  frame.setResizable(false);
  size(800, 600);
  colorMode(HSB);
  background(0);
  initi();
  // ---
  allFilesUrl = getAllFilesFrom(dataPath("pool"));
  loadOnePic();
  for (int i=0; i<mirrors.length; i++)  mirrors[i] = new Mirror();
}

void draw() {
  if (mode==0) {
    int activeZones=0;
    for (int i=0; i<zones.size (); i++) {
      if (zones.get(i).active) {
        zones.get(i).expandIn(types);
        if (zones.get(i).points.size()==0) {
          zones.get(i).active=false;
          simultZones++;
        }
        activeZones++;
      }
    }
    if (activeZones<simultZones) {
      zones.add(new Zone(types));
      activeZones++;
    }
    allDone=true;
    for (int x=0; x<width; x++) {
      for (int y=0; y<height; y++) {
        if (types[x][y]==-1) allDone=false;
      }
    }  
    if (frameNb%operationRefresh==0) setOperation();
    if (!allDone) preFullFrames++;
    else {
      if (!redistrib) {
        redistrib=true;
        if (random(1)<0.5f) setOperation();
        preFullFrames = floor(preFullFrames*random(0.0f, 3.0f));
      }
      preFullFrames--;
    }
    if (preFullFrames<=-1) {
      // save(dataPath("result/"+nf(getAllFilesFrom(dataPath("result")).length-1, 6)+".png"));
      initi();
    }
    if (random(1000)<2) loadOnePic();
  }
  // ---
  if (mode==1) {
    PGraphics temp = createGraphics(width, height, JAVA2D);
    temp.beginDraw();
    temp.image(orig, 0, 0, width, height);
    for (int i=0; i<mirrors.length; i++) mirrors[i].process(temp);
    temp.endDraw();
    image(temp, 0, 0, width, height);
    if (random(1000)<2) loadOnePic();
  }
  // ---
  if (random(2500)<2) {
    orig=get();
    mode=(mode+1)%2;
  }
  frameNb++;
}

PImage invert(PImage temp, boolean h, boolean v) {
  if (!h&&!v) return temp;
  PGraphics newIm = createGraphics(width, height, JAVA2D);
  newIm.beginDraw();
  newIm.pushMatrix();
  newIm.scale(h?-1:1, v?-1:1);
  newIm.translate(h?-temp.width:0, v?-temp.height:0);
  newIm.image(temp.get(), 0, 0, temp.width, temp.height);
  newIm.popMatrix();
  newIm.endDraw();
  return newIm.get();
}

void loadOnePic() {
  try {
    orig = loadImage(allFilesUrl[floor(random(allFilesUrl.length))]);
    // if (random(20)<1) orig = loadImage(dataPath("pool/acousmaticoclogo.jpg"));
    orig.resize(width, height);
  } 
  catch (Exception e) {
    orig = createImage(width, height, RGB);
    println(e);
  }
}

class Mirror {
  boolean hSym=false;
  boolean vSym=false;
  float vAxis=0;
  float vAxisD=random(-1, 1);
  float hAxis=0;
  float hAxisD=random(-1, 1);

  void process(PImage temp) {
    //temp=invert(temp, hSym, vSym);
    if (vAxis<width/2) {
      temp.copy(temp.get(), (int)vAxis, 0, width-(int)vAxis, height, (int)vAxis, 0, -width+(int)vAxis, height);
    } else {
      temp.copy(temp.get(), 0, 0, (int)vAxis, height, (int)vAxis*2, 0, -(int)vAxis, height);
    }
    if (hAxis<height/2) {
      temp.copy(temp.get(), 0, (int)hAxis, width, height-(int)hAxis, 0, (int)hAxis, width, -height+(int)hAxis);
    } else {
      temp.copy(temp.get(), 0, 0, width, (int)hAxis, 0, (int)hAxis*2, width, -(int)hAxis);
    }
    float prevVAxis = vAxis;
    vAxis=(vAxis+vAxisD+width)%width;
    if (((prevVAxis<width/2)!=(vAxis<width/2))&&(abs(((float)width/2)-vAxis)<width/2)) hSym=!hSym;
    float prevHAxis = hAxis;
    hAxis=(hAxis+hAxisD+height)%height;
    if (((prevHAxis<height/2)!=(hAxis<height/2))&&(abs(((float)height/2)-hAxis)<height/2)) vSym=!vSym;
    if (random(1000)<1) vAxisD=random(-1, 1);
    if (random(1000)<1) hAxisD=random(-1, 1);
  }
}

