
import krister.Ess.*;
import java.awt.FileDialog; 

AudioChannel orig;
AudioChannel result;
ArrayList bases=new ArrayList();
int maxFiles=5;
int skip=3;
String[] files;
int nextReplacement=0;
int nextFileIndex=0;
int t=0;

void setup() {
  Ess.start(this);
  orig= new AudioChannel();
  result=new AudioChannel();  
  orig.loadSound(getFile());
  size(100,100);
  files=getFiles();
  for (int i=0;i<files.length&&maxFiles>0;i++) {
    if (files[i].toLowerCase().substring(files[i].length()-4).equals(".wav")) {
      println(files[i]);
      maxFiles--;
      nextFileIndex++;
      try {
        AudioChannel base=new AudioChannel();
        base.loadSound(files[i]);
        float[] base2= base.samples;
        base.destroy();        
        bases.add(base2);
      }
      catch (Exception e){
        println(e);
        maxFiles++;
        nextFileIndex--;
      }
    }
  }
}

String getFile() {
  Frame frame = new Frame();
  FileDialog fileDialog = new FileDialog(frame, "open sample",  FileDialog.LOAD);
  fileDialog.setVisible(true);
  if (fileDialog.getFile()!=null) {
    String filePath = fileDialog.getDirectory() + fileDialog.getFile();
    return filePath;  
  }
  return null;
}

String[] getFiles() {
  Frame frame = new Frame();
  FileDialog fileDialog = new FileDialog(frame, "open samples",  FileDialog.LOAD);
  fileDialog.setVisible(true);
  File folder=new File(fileDialog.getDirectory());
  File[] filesPath = folder.listFiles();
  String[] result = new String[filesPath.length];
  for (int i=0;i<filesPath.length;i++) {
    result[i]=filesPath[i].toString();
  }
  return result;
}

AudioChannel generate() {
  AudioChannel result = orig;
  for (int i=0;i<orig.samples.length;i++) {
    float sVise=orig.samples[i];
    float sResult=0;
    float currentDiff=0xFFFF;
    for (int j=0;j<bases.size();j++) {
      float thisSample=((float[])bases.get(j))[i%((float[])bases.get(j)).length];
      float thisDiff=abs(sVise-thisSample);
      if (thisDiff<currentDiff) {
        sResult=thisSample;
        currentDiff=thisDiff;
      }
    }
    result.samples[i]=sResult;
  }
  return result;
}

void nextInChain() {
  boolean fileOk=false;
  while (!fileOk) {
    if (files[nextFileIndex].toLowerCase().substring(files[nextFileIndex].length()-4).equals(".wav")) {
      println(files[nextFileIndex]);
      fileOk=true;
      try {
        AudioChannel base=new AudioChannel();
        base.loadSound(files[nextFileIndex]);
        float[] base2= base.samples;
        base.destroy();        
        bases.set(nextReplacement,base2);
      }
      catch (Exception e){
        println(e);
      }
    }
    nextFileIndex=(nextFileIndex+1)%files.length;
  }
  nextReplacement=(nextReplacement+1)%bases.size();
}

void draw() {
  for (int i=0;i<skip;i++) {
    nextInChain();
  }
  result=generate();
  result.saveSound(dataPath("result"+t+".wav"));
  t++;
}

public void stop() {
  Ess.stop();
  super.stop();
}











