import processing.core.*; 
import processing.xml.*; 

import krister.Ess.*; 
import java.awt.FileDialog; 

import java.applet.*; 
import java.awt.Dimension; 
import java.awt.Frame; 
import java.awt.event.MouseEvent; 
import java.awt.event.KeyEvent; 
import java.awt.event.FocusEvent; 
import java.awt.Image; 
import java.io.*; 
import java.net.*; 
import java.text.*; 
import java.util.*; 
import java.util.zip.*; 
import java.util.regex.*; 

public class samplesRecon extends PApplet {



 

AudioChannel orig;
AudioChannel result;
ArrayList bases=new ArrayList();
int maxFiles=5;
int skip=3;
String[] files;
int nextReplacement=0;
int nextFileIndex=0;
int t=0;

public void setup() {
  Ess.start(this);
  orig= new AudioChannel();
  result=new AudioChannel();  
  orig.loadSound(getFile());
  size(100,100);
  files=getFiles();
  for (int i=0;i<files.length&&maxFiles>0;i++) {
    if (files[i].toLowerCase().substring(files[i].length()-4).equals(".wav")) {
      println(files[i]);
      maxFiles--;
      nextFileIndex++;
      try {
        AudioChannel base=new AudioChannel();
        base.loadSound(files[i]);
        float[] base2= base.samples;
        base.destroy();        
        bases.add(base2);
      }
      catch (Exception e){
        println(e);
        maxFiles++;
        nextFileIndex--;
      }
    }
  }
}

public String getFile() {
  Frame frame = new Frame();
  FileDialog fileDialog = new FileDialog(frame, "open sample",  FileDialog.LOAD);
  fileDialog.setVisible(true);
  if (fileDialog.getFile()!=null) {
    String filePath = fileDialog.getDirectory() + fileDialog.getFile();
    return filePath;  
  }
  return null;
}

public String[] getFiles() {
  Frame frame = new Frame();
  FileDialog fileDialog = new FileDialog(frame, "open samples",  FileDialog.LOAD);
  fileDialog.setVisible(true);
  File folder=new File(fileDialog.getDirectory());
  File[] filesPath = folder.listFiles();
  String[] result = new String[filesPath.length];
  for (int i=0;i<filesPath.length;i++) {
    result[i]=filesPath[i].toString();
  }
  return result;
}

public AudioChannel generate() {
  AudioChannel result = orig;
  for (int i=0;i<orig.samples.length;i++) {
    float sVise=orig.samples[i];
    float sResult=0;
    float currentDiff=0xFFFF;
    for (int j=0;j<bases.size();j++) {
      float thisSample=((float[])bases.get(j))[i%((float[])bases.get(j)).length];
      float thisDiff=abs(sVise-thisSample);
      if (thisDiff<currentDiff) {
        sResult=thisSample;
        currentDiff=thisDiff;
      }
    }
    result.samples[i]=sResult;
  }
  return result;
}

public void nextInChain() {
  boolean fileOk=false;
  while (!fileOk) {
    if (files[nextFileIndex].toLowerCase().substring(files[nextFileIndex].length()-4).equals(".wav")) {
      println(files[nextFileIndex]);
      fileOk=true;
      try {
        AudioChannel base=new AudioChannel();
        base.loadSound(files[nextFileIndex]);
        float[] base2= base.samples;
        base.destroy();        
        bases.set(nextReplacement,base2);
      }
      catch (Exception e){
        println(e);
      }
    }
    nextFileIndex=(nextFileIndex+1)%files.length;
  }
  nextReplacement=(nextReplacement+1)%bases.size();
}

public void draw() {
  for (int i=0;i<skip;i++) {
    nextInChain();
  }
  result=generate();
  result.saveSound(dataPath("result"+t+".wav"));
  t++;
}

public void stop() {
  Ess.stop();
  super.stop();
}











  static public void main(String args[]) {
    PApplet.main(new String[] { "--bgcolor=#D4D0C8", "samplesRecon" });
  }
}
