
import processing.opengl.*;
import com.sun.opengl.cg.*;
import javax.media.opengl.*;
import com.sun.opengl.util.*;
import java.nio.*;

int siz=700;
int spa=30;
int dim=siz/spa;
float threshold = 1.2;

float[][][] inside = new float[spa][spa][spa];
PVector[][][] coordinates = new PVector[spa][spa][spa];

Ball[] balls = new Ball[15];

GLSL glsl;

float pmX=0;
float pmY=0;

void setup() {
  size(siz, siz);
  frameRate(30);

  for (int i=0;i<balls.length;i++) {
    balls[i] = new Ball(floor(random(spa)),floor(random(spa)),floor(random(spa/2)));
  }

  for (int x=0;x<spa;x++) {
    for (int y=0;y<spa;y++) {
      for (int z=0;z<spa;z++) {
        coordinates[x][y][z] = getCoordinates(x,y,z);
      }
    }
  }
}

void draw() {

  if (mousePressed) {
    int petitIndex=-1;
    float petiteTaille=0;
    for (int i=0;i<balls.length;i++) {
      if (balls[i].s<petiteTaille || petitIndex==-1) 
      {
        petiteTaille=balls[i].s; 
        petitIndex=i;
      }
    }
    balls[petitIndex] = new Ball(floor((float)mouseX/dim),floor((float)mouseY/dim),floor((float)spa/2));
    balls[petitIndex].xD = (mouseX-pmX)/(spa*5);
    balls[petitIndex].yD = (mouseY-pmY)/(spa*5);
  }

  pmX=mouseX;
  pmY=mouseY;

  PGraphics rEye = createGraphics(width,height,P3D);
  PGraphics lEye = createGraphics(width,height,P3D);  

  rEye.beginDraw();
  lEye.beginDraw();

  rEye.background(0);
  rEye.noStroke();
  rEye.fill(0x00,0xFF,0xFF);
  rEye.camera(width/2.0 + 70, height/2.0, (height/2.0) / tan(PI*60.0 / 360.0) - 300, width/2.0, height/2.0, -500, 0, 1, 0);
  lEye.background(0);
  lEye.noStroke();
  lEye.fill(0xFF,0x00,0x00);
  lEye.camera(width/2.0 - 70, height/2.0, (height/2.0) / tan(PI*60.0 / 360.0) - 300, width/2.0, height/2.0, -500, 0, 1, 0);

  rEye.pointLight(0xA0,0x00,0x00,0,(float)dim*spa/2,-0);
  rEye.pointLight(0xA0,0xA0,0x00,(float)dim*spa/2,0,-(float)dim*spa/2);
  rEye.pointLight(0xA0,0x00,0xA0,(float)dim*spa,(float)dim*spa,-0);
  rEye.ambientLight(0x10, 0x15, 0x50);
  lEye.pointLight(0xA0,0x00,0x00,0,(float)dim*spa/2,-0);
  lEye.pointLight(0xA0,0xA0,0x00,(float)dim*spa/2,0,-(float)dim*spa/2);
  lEye.pointLight(0xA0,0x00,0xA0,(float)dim*spa,(float)dim*spa,-0);
  lEye.ambientLight(0x10, 0x15, 0x20);

  for (int i=0;i<balls.length;i++) {
    balls[i].act();
  }

  for (int x=0;x<spa;x++) {
    for (int y=0;y<spa;y++) {
      for (int z=0;z<spa;z++) {
        float thisProxi = 0;
        for (int i=0;i<balls.length;i++) {
          thisProxi += balls[i].proxFrom(x,y,z);
        }
        inside[x][y][z] = thisProxi;
      }
    }
  }

  for (int x=0;x<spa-1;x++) {
    for (int y=0;y<spa-1;y++) {
      for (int z=0;z<spa-1;z++) {

        PVector[] p = new PVector[8];
        float[] val = new float[8];
        p[0]   = coordinates[x+0][y+0][z+0];
        val[0] =      inside[x+0][y+0][z+0];
        p[1]   = coordinates[x+1][y+0][z+0];
        val[1] =      inside[x+1][y+0][z+0];
        p[2]   = coordinates[x+1][y+0][z+1];
        val[2] =      inside[x+1][y+0][z+1];
        p[3]   = coordinates[x+0][y+0][z+1];
        val[3] =      inside[x+0][y+0][z+1];
        p[4]   = coordinates[x+0][y+1][z+0];
        val[4] =      inside[x+0][y+1][z+0];
        p[5]   = coordinates[x+1][y+1][z+0];
        val[5] =      inside[x+1][y+1][z+0];
        p[6]   = coordinates[x+1][y+1][z+1];
        val[6] =      inside[x+1][y+1][z+1];
        p[7]   = coordinates[x+0][y+1][z+1];
        val[7] =      inside[x+0][y+1][z+1];

        Gridcell grid = new Gridcell(p, val);
        ArrayList triangles = Polygonise(grid, threshold);
        for (int i2=0;i2<triangles.size();i2++) {

          rEye.beginShape();
          rEye.vertex(((PVector[])triangles.get(i2))[0].x,((PVector[])triangles.get(i2))[0].y,((PVector[])triangles.get(i2))[0].z);
          rEye.vertex(((PVector[])triangles.get(i2))[1].x,((PVector[])triangles.get(i2))[1].y,((PVector[])triangles.get(i2))[1].z);
          rEye.vertex(((PVector[])triangles.get(i2))[2].x,((PVector[])triangles.get(i2))[2].y,((PVector[])triangles.get(i2))[2].z);          
          rEye.endShape();

          lEye.beginShape();
          lEye.vertex(((PVector[])triangles.get(i2))[0].x,((PVector[])triangles.get(i2))[0].y,((PVector[])triangles.get(i2))[0].z);
          lEye.vertex(((PVector[])triangles.get(i2))[1].x,((PVector[])triangles.get(i2))[1].y,((PVector[])triangles.get(i2))[1].z);
          lEye.vertex(((PVector[])triangles.get(i2))[2].x,((PVector[])triangles.get(i2))[2].y,((PVector[])triangles.get(i2))[2].z);          
          lEye.endShape();
        }
      }
    }
  }

  rEye.endDraw();  
  lEye.endDraw();  

  background(0);
  blend(rEye,0,0,width,height,0,0,width,height,ADD);
  blend(lEye,0,0,width,height,0,0,width,height,ADD);
}

PVector getCoordinates(int x, int y, int z) {
  PVector p = new PVector();
  p.x = (float)x*dim;
  p.y = (float)y*dim;
  p.z = (float)z*dim-((float)spa*dim);
  return p;
}

class Ball {

  float x;
  float y;
  float z;

  float xD;
  float yD;
  float yDD;  
  float zD;

  float s;

  Ball(int x, int y, int z) {
    this.x=x;
    this.y=y;
    this.z=z;
    this.xD=0;
    this.yD=0.05;
    this.yDD=0.01;
    this.zD=-0.4;
    this.s=1.0;
  }

  float proxFrom(float x2, float y2, float z2) {
    return s / (sqrt(sq(abs(x2-x)) + sq(abs(y2-y)) + sq(abs(z2-z))));
  }

  void act() {
    x = x*19/20 + ((float)spa/2)*01/20;
    x+=xD;
    y+=yD;
    yD+=yDD;
    yD*=1.05;    
    z+=zD;
    s = s * 199 / 200;
    if (x<0 || x>spa) xD*=-1;
    if (y<0 || y>spa) yD=0;
    if (z<0 ) zD=0;
  }
}

