
import ddf.minim.*;

Minim minim;
AudioSnippet snip;

int loopLength;

int imageIndex = 0;
int pImageIndex = 0;
int nbP = 1812;

PImage[] ims = new PImage[nbP];
int zoom = 70;
float recadreX;
float recadreY;
float frameSpeed=0;
int sc=2;

int loaded=0;

void setup() {
  frameRate(30);
  int recadreX=width/2;
  int recadreY=height/2;
  addMouseWheelListener(
  new java.awt.event.MouseWheelListener() { 
    public void mouseWheelMoved(java.awt.event.MouseWheelEvent evt) { 
      mouseWheel(evt.getWheelRotation());
    }
  }
  );
  ims[0] = loadImage(dataPath("OkBruxelles-"+nf(1, 4)+".jpg"));
  size(ims[0].width*sc, ims[0].height*sc);
  minim = new Minim(this);
  background(0);
}

void mouseWheel(int delta) {
  if (loaded>=nbP-1) {  
    frameSpeed -= delta;
  }
}

void draw() {
  if (loaded<nbP-1) {
    if (loaded==0) {
      snip = minim.loadSnippet(dataPath("OkBruxelles.mp3"));  
      loopLength=floor((float)snip.length()/nbP)*2;
      snip.setLoopPoints(0, 0+loopLength);
      snip.loop();
    }
    loaded++;
    ims[loaded] = loadImage(dataPath("OkBruxelles-"+nf(loaded+1, 4)+".jpg"));
    background(0);
    image(ims[floor(random(loaded))], 0, 0, width, height);
    noStroke();
    fill(0x00);
    rect(0, 0, 200, height);
    rect(width-200, 0, 200, height);
    rect(0, 0, width, 200);
    rect(0, height-200, width, 200);
    rect(200+((float)loaded*(width-400)/nbP), 200, width-400-((float)loaded*(width-400)/nbP), height-400);    
    noFill();
    stroke(0xFF);
    rect(200, 200, ((float)loaded*(width-400)/nbP), height-400);
    if (loaded > nbP-100) {
      fill(0xFF);
      text("Scroll !", 300, 350);
    }
  }
  else {
    int roundedFS = 0;
    if (frameSpeed < 0) roundedFS = ceil(frameSpeed);
    if (frameSpeed > 0) roundedFS = floor(frameSpeed);
    imageIndex += roundedFS;
    imageIndex = constrain(imageIndex, 0, nbP-1);    
    if (imageIndex!= pImageIndex) {
      int thisI=(imageIndex+10);// compensates the audio/video delay
      int loopPos = min(floor((float)thisI*snip.length()/nbP), snip.length()-200);
      snip.cue(loopPos);
      snip.setLoopPoints(loopPos, min(loopPos+loopLength, snip.length()-100));
    }
    frameSpeed /= 1.2;
    recadreX = ((float)(mouseX-width/2)*zoom/(width/2)+recadreX)/2;
    recadreY = ((float)(mouseY-height/2)*zoom/(height/2)+recadreY)/2;
    image(ims[imageIndex], -(recadreX+zoom), -(recadreY+zoom), ims[imageIndex].width*sc+zoom*2, ims[imageIndex].height*sc+zoom*2);
    pImageIndex=imageIndex;
  }
}

void stop() {
  snip.close();
  minim.stop();
  super.stop();
}

