
boolean vertical = false;
boolean horizontal = true;
float spaced = 3;
float benging = 1.5;
float bSize = 1.1;

void setup() {
  smooth();
  colorMode(HSB);
  PImage im = loadImage("unePhoto.jpg");
  size(im.width, im.height);
  int nbX = floor(width/spaced);
  int nbY = floor(height/spaced);
  Boule[][] boules = new Boule[nbX][nbY];
  for (int x=0;x<nbX;x++) {
    for (int y=0;y<nbY;y++) {
      color c = im.get(floor(x*spaced), floor(y*spaced));
      boules[x][y] = new Boule((x+0.5)*spaced, (y+0.5)*spaced, spaced*bSize, c);
    }
  }
  for (int x=0;x<im.width;x+=spaced) {
    println(x+"/"+im.width);
    for (int y=0;y<im.height;y+=spaced) {
      float thisValue=brightness(im.get(x, y))/0xFF;
      for (int x2=0;x2<nbX;x2++) {
        for (int y2=0;y2<nbY;y2++) {
          float dir = 1;
          if ((vertical && y2*spaced<y) || (horizontal && x2*spaced<x)) dir = -1;
          float dista = dist(x, y, x2*spaced, y2*spaced);
          float angle = 0;
          if (vertical && horizontal) {
            angle = atan2(y2-y, x2-x);
            dir=1;
          }          
          boules[x2][y2].pushBy(angle, benging*spaced*dir*thisValue/max(dista*2, 1));
        }
      }
    }
  }
  background(0x20, 0x30, 0xF0);
  for (int x=0;x<nbX;x++) {
    for (int y=0;y<nbY;y++) {
      boules[x][y].draw();
    }
  }
  save("result.png");
}

class Boule {
  float x;
  float y;
  float s;
  color c;
  Boule(float x, float y, float s, color c) {
    this.x=x;
    this.y=y;
    this.s=s;
    this.c=color(hue(c), saturation(c), (float)brightness(c)/3);
  }
  void draw() {
    noStroke();
    fill(c);
    ellipse(x, y, s, s);
  }
  void pushBy(float angle, float dista) {
    if (angle==0) {
      if (vertical)   this.y += dista;
      if (horizontal) this.x += dista;
    }
    else {
      this.x+=cos(angle)*dista;
      this.y+=sin(angle)*dista;
    }
  }
}

