
int nbI=4;
PImage[] ims = new PImage[nbI];
int pX, pY;
int pix=3;
float t=0;
int frame=0;
float emp=10;
float restr=17;
int moveType=3;
float fA=0.1;
float wavesAtt=5;
float movement=0.6;
float smear=2;

void setup() {
  for (int i=0;i<ims.length;i++) {
    ims[i] = loadImage(nf(i, 2)+".png");
  }
  size(ims[0].width, ims[0].height);
  pX=width/pix;
  pY=height/pix;
  colorMode(HSB);
  smooth();
}

void draw() {
  background(0x00);
  noStroke();
  for (int x=0;x<pX;x++) {
    for (int y=0;y<pY;y++) {
      float h=0;
      float s=0;
      float b=0;            
      for (int i=0;i<ims.length;i++) {
        float phase = t;
        if (moveType==0 || moveType==3) phase -= dist(x, y, pX/2, pY/2)/((pX+pY)/4)*smear;
        if (moveType==1 || moveType==3) phase += abs(atan2(pY/2-y, pX/2-x))/4*smear;
        if (moveType==2 || moveType==3) phase += (((float)x/pX)+((float)y/pY))/2*smear;
        while (phase>ims.length || phase<0) phase=(phase+ims.length)%ims.length;
        float thisProxi = constrain(1-abs(vrMax(i, phase%ims.length, ims.length)), 0, 1);
        for (int p=0;p<pix;p++) {
          h += vrMax(h, hue(ims[i].get(x*pix + p, y*pix + p)), 0xFF) * thisProxi;
          s += saturation(ims[i].get(x*pix + p, y*pix + p)) * thisProxi / pix;
          b += brightness(ims[i].get(x*pix + p, y*pix + p)) * thisProxi / pix;
        }
      }
      float siz=max(b*pix*emp/0xFF-restr, 0);
      fill(h, min(s, 0xFF-b/2), 0xFF);
      float mov = pix*sin(t*TWO_PI/ims.length+(x-y)/wavesAtt)*movement;
      ellipse(x*pix+pix/2 + mov, y*pix+pix/2 + mov, siz, siz);
    }
  }
  t+=fA;
  if (t<ims.length) save("result/"+nf(frame, 4)+".png");
  else println("done");
  frame++;
}

public float vrMax(float a, float b, float m) {
  float d1=b-a;
  if (d1>m/2) {
    d1=d1-m;
  }
  if (d1<-m/2) {
    d1=d1+m;
  }
  return d1;
}

