
int nbP=500;
PVector[] ps = new PVector[nbP];
color[] c = new color[nbP];
int t=0;

void setup() {
  size(500, 500);
  colorMode(HSB);
  for (int p=0;p<nbP;p++) {
    float x = random(width);
    float y = random(height);
    ps[p]=new PVector(x, y);
    c[p] = color(((int)x^(int)y)%0x80+0x70, 0xFF, 0xFF);
  }
  background(0);
}

void draw() {
  noStroke();
  fill(0, 0x50);
  rect(0, 0, width, height);
  PVector[] nPs = new PVector[nbP];
  float h  = sin((float)t/100) * 5;
  float r  = sin((float)t/120) * 200 + 300;
  float r2 = sin((float)t/130) * 200 + 300;
  t++;
  for (int p=0;p<nbP;p++) {
    nPs[p] = new PVector(0, 0);
    nPs[p].x = ps[p].x - h * sin((float)ps[p].y/r + tan(3*(float)ps[p].y/r2));
    nPs[p].y = ps[p].y - h * sin((float)ps[p].x/r + tan(3*(float)ps[p].x/r2));
    nPs[p].x = constrain(nPs[p].x, 0, width);
    nPs[p].y = constrain(nPs[p].y, 0, height);
    c[p]=(int)(c[p]+(float)(nPs[p].y+nPs[p].x)/700)%0xFF;
  }
  for (int p=0;p<nbP;p++) {
    pushMatrix();
    translate(width/2, height/2);
    rotate(PI/4);
    translate(-width/2, -height/2);
    stroke(c[p], 0xFF, 0xFF);
    line(ps[p].x, ps[p].y, nPs[p].x, nPs[p].y);
    popMatrix();
    ps[p] = nPs[p];
  }
  // saveFrame("data/#####.png");
}