
float previousSize=0;
float previousMouseX=0;
float previousMouseY=0;
float currentHue;
float xDerivative=0;
float yDerivative=0;

float CENTERX;
float CENTERY;

ArrayList trail = new ArrayList(0);

PGraphics right;
PGraphics left;

void setup() {
  size(500,500);
  right=createGraphics(width,height,JAVA2D);
  left=createGraphics(width,height,JAVA2D);  
  frameRate(50);
  smooth();
  colorMode(HSB);
  CENTERX=width/2;
  CENTERY=height/2;
  right.beginDraw();
  left.beginDraw();
  right.smooth();
  left.smooth();  
  right.endDraw();
  left.endDraw();
}

void draw() {
  background(0x00);
  currentHue=(currentHue+0.5)%0xFF;
  float thisSize = dist(mouseX,mouseY,previousMouseX,previousMouseY)*10;
  thisSize=(thisSize)*1/10+(previousSize)*9/10;
  previousSize=thisSize;
  xDerivative = (xDerivative)*4/5 + (mouseX-previousMouseX)*1/5;
  yDerivative = (yDerivative)*2/3 + (mouseY-previousMouseY)*5/3;
  if (!mousePressed) {
    thisSize=0;
    previousSize=0;
  }  
  if (thisSize>=1) {
    trail.add(new Paintball(mouseX-CENTERX,mouseY-CENTERY,thisSize,color(currentHue,0xF0,min(0x50+thisSize,0xA0)),yDerivative,xDerivative));
  }
  int maxDist=0;
  for (int i=0;i<trail.size();i++) {
    if (((Paintball)trail.get(i)).distance>maxDist) maxDist=((Paintball)trail.get(i)).distance;
  }
  right.beginDraw();
  left.beginDraw();
  right.background(0);
  left.background(0);
  for (int d=maxDist;d>=0;d--) {
    for (int i=0;i<trail.size();i++) {
      if (((Paintball)trail.get(i)).distance==d) ((Paintball)trail.get(i)).display();
    }
  }
  right.endDraw();
  left.endDraw();
  for (int i=0;i<trail.size();i++) {
    ((Paintball)trail.get(i)).act();
    if (((Paintball)trail.get(i)).apparentS()<1 || 
      ((Paintball)trail.get(i)).apparentY()-((Paintball)trail.get(i)).apparentS()>height || 
      ((Paintball)trail.get(i)).apparentX()+((Paintball)trail.get(i)).apparentS()<0 || 
      ((Paintball)trail.get(i)).apparentX()-((Paintball)trail.get(i)).apparentS()>width
      ) trail.remove(i);
  }  
  previousMouseX=mouseX;
  previousMouseY=mouseY;
  blend(left,0,0,width,height,0,0,width,height,ADD);
  blend(right,0,0,width,height,0,0,width,height,ADD);
}

class Paintball {

  float x;
  float y;  
  float s;
  color c;
  float g;
  float xD;
  int distance=0;

  Paintball(float x, float y, float s, color c, float g, float xD) {
    this.x=x;
    this.y=y;
    this.s=s;
    this.c=c;
    this.g=g;
    this.xD=xD;
    this.distance=1;
  }

  void display() {
    left.noStroke();     
    right.noStroke();   
    left.fill(apparentC(2));
    left.ellipse(apparentX(30),apparentY(),apparentS(),apparentS());
    right.fill(apparentC(1));
    right.ellipse(apparentX(-30),apparentY(),apparentS(),apparentS());
  }

  color apparentC(int mode) {
    colorMode(HSB);
    color baseColor = color(hue(c),max(saturation(c)-distance*2,0x50),brightness(c));
    if (mode==1) {
      colorMode(RGB);
      baseColor = color(0,green(baseColor),blue(baseColor));
      colorMode(HSB);
      return baseColor;
    }
    if (mode==2) {
      colorMode(RGB);
      baseColor = color(red(baseColor),0,0);
      colorMode(HSB);
      return baseColor;
    }
    return baseColor;
  }

  float apparentX(float eyePosition) {
    return (x+eyePosition) / softDistance(4) + CENTERX;
  }

  float apparentX() {
    return x / softDistance(4) + CENTERX;
  }

  float apparentY() {
    return y / softDistance(4) + CENTERY;
  }

  float apparentS() {
    return s / softDistance(20) - ((float)distance/10);
  }

  float softDistance(float divider) {
    return ((float)distance-1)/divider+1;
  }

  void act() {
    distance++;
    y+=(g/10);
    g+=2;
    x+=xD;
  }
}

