
Ball[] balls = new Ball[10];

void setup() {
  size(500,500);
  for (int i=0;i<balls.length;i++) {
    balls[i]=new Ball();
  }
  noStroke();
}

void draw() {
  background(0);
  for (int i=0;i<balls.length;i++) {
    balls[i].move();
  }
  background(0);
  for (int y=0;y<height;y+=7) {
    for (int x=0;x<width;x+=7) {
      color value=color(0);
      for (int i=0;i<balls.length;i++) {
        value=blendColor(value,balls[i].getProximity(x,y),ADD);
      }      
      fill(value);
      rect(x,y,8,8);
    }
  }
}

class Ball {
  float x=random(width);
  float y=random(height);
  float angle=random(TWO_PI);
  float speed=random(10);
  float fieldR=random(4000);
  float fieldG=random(2000);
  float fieldB=random(1000);
  boolean direction=boolean(floor(random(2)));
  Ball() {
  }
  void move() {
    x+=cos(angle)*speed;
    y+=sin(angle)*speed;
    angle+=PI/100;
    if (x<0||y<0||x>width||y>height) {
      angle=(angle+PI)%TWO_PI;
    }
    x+=(mouseX-x)/50;
    y+=(mouseY-y)/50;
    if (mousePressed) {
      x+=(mouseX-x)/10;
      y+=(mouseY-y)/10;
      fieldR=random(4000);
      fieldG=random(2000);
      fieldB=random(1000);
    }
  }
  color getProximity(float px, float py) {
    float d;
    if (direction) {
      d=abs(x-px);
    }
    else {
      d=abs(y-py);
    }
    float r=fieldR/d;
    float g=fieldG/d;
    float b=fieldB/d;
    return color(r,g,b);
  }
}

