
Ball[] balls = new Ball[20];

void setup() {
  size(500,500);
  for (int i=0;i<balls.length;i++) {
    balls[i]=new Ball();
  }
  noStroke();
}

void draw() {
  background(0);
  for (int i=0;i<balls.length;i++) {
    balls[i].move();
  }
  background(0);
  for (int y=0;y<height;y+=7) {
    for (int x=0;x<width;x+=7) {
      color value=color(0);
      for (int i=0;i<balls.length;i++) {
        value=blendColor(value,balls[i].getProximity(x,y),ADD);
      }      
      fill(value);
      rect(x,y,8,8);
    }
  }
}

class Ball {
  float x=random(width);
  float y=random(height);
  float angle=random(TWO_PI);
  float speed=random(13);
  float rSpeed=random(PI/100);
  float fieldR=random(4000);
  float fieldG=random(4000);
  float fieldB=random(4000);  
  Ball() {
  }
  void move() {
    if (mousePressed) {
      x+=(mouseX-x)/20;
      y+=(mouseY-y)/20;
    }
    angle+=rSpeed;
    if (x<0||y<0||x>width||y>height) {
      angle=(angle+PI)%TWO_PI;
    }
    x+=cos(angle)*speed;
    y+=sin(angle)*speed;
  }
  color getProximity(float px, float py) {
    float d=dist(x,y,px,py);
    float r=fieldR/d;
    float g=fieldG/d;
    float b=fieldB/d;
    return color(r,g,b);
  }
}

