
import java.io.File;
import java.awt.FileDialog;

void setup() {
  String[] params = loadStrings("params.txt");

  String folderPath = params[1]; // put the file in the sketch folder
  String rE = params[3]; // right end
  String lE = params[5]; // left end

  String[] files = getAllFilesFrom(folderPath);

  for (int i=0;i<files.length;i++) {
    String thisFile = files[i].substring(0, files[i].length()-4);// without extension
    String thisExtension = files[i].substring(files[i].length()-4);// extension
    if (thisFile.length()>=rE.length()) {
      if (thisFile.substring(thisFile.length()-rE.length()).equals(rE)) {
        println(thisFile);
        WavFile rFile = WavFile.readFromFilePath(thisFile+thisExtension);
        WavFile lFile = WavFile.readFromFilePath(thisFile.substring(0, thisFile.length()-rE.length())+lE+thisExtension);
        double[][] rWaveForm = rFile.samplesAsDouble();
        double[][] lWaveForm = lFile.samplesAsDouble();
        double[][] sWaveForm = new double[2][rWaveForm[0].length];
        for (int j=0;j<sWaveForm[0].length;j++) {
          sWaveForm[0][j]=rWaveForm[0][j];
          sWaveForm[1][j]=lWaveForm[0][j];
        }
        rFile.setSamplesFromDouble(sWaveForm);
        rFile.writeToFilePath(thisFile.substring(0, thisFile.length()-rE.length())+"(STEREO)"+thisExtension);
      }
    }
  }
}

void draw() {
}

