
import processing.video.*;
import java.awt.AWTException;
import java.awt.Robot;
import java.awt.event.InputEvent;

Capture myCapture;

PGraphics currentMask;
PImage currentResult;

Monster monster;

int nbPhotos=0;

Robot robot;

boolean backgroundCaptured = false;

PImage lastPicture;

void setup() {
  colorMode(RGB);
  size(500, 500);
  monster = new Monster();
  currentMask = createGraphics(width, height, P2D);
  currentResult = new PImage(width, height);
  lastPicture = new PImage(width, height);
  myCapture = new Capture(this, width, height, Capture.list()[0], 10);
  smooth();
  try { 
    robot = new Robot();
  } 
  catch (AWTException e) {
    e.printStackTrace();
  }
  //robot.mouseMove(width/2, height/2);
}

void captureEvent(Capture myCapture) {
  myCapture.read();
}

void draw() {
  background(0);
  monster.anim();
  monster.display(currentMask);
  image(currentMask, width, 0, -width, height);// commente ça pour enlever la bestiole
  tint(0xFF, 0xFF-monster.phase*0xFF);
  image(lastPicture, 0, 0, width, height);// commente ça pour enlever la dernière image
  tint(0xFF, 0x08);
  image(myCapture, 0, 0, width, height);// commente ça pour enlever la vidéo continue !
  tint(0xFF);
}

void takePhoto() {
  currentResult = addFragment(currentResult);
  lastPicture = addFragment(new PImage(width, height));
  image(currentResult, 0, 0, width, height);
  save("coucou" + nf(nbPhotos, 5) + ".png");
  nbPhotos++;
  //robot.mousePress(InputEvent.BUTTON1_MASK);
  //robot.mouseRelease(InputEvent.BUTTON1_MASK);
}

PImage addFragment(PImage original) {
  for (int x=0;x<original.width;x++) {
    for (int y=0;y<original.height;y++) {    
      original.set(x, y, lerpColor(original.get(x, y), myCapture.get(x, y), (float)brightness(currentMask.get(x, y))/0xFF));
    }
  }
  if (!backgroundCaptured) {
    backgroundCaptured = true;
    for (int x=0;x<currentResult.width;x++) {
      for (int y=0;y<currentResult.height;y++) {
        currentResult.set(x, y, myCapture.get(x, y));
      }
    }
  }  
  return original;
}

PGraphics generateMask() {
  PGraphics result = createGraphics(width, height, P2D);
  result.beginDraw();
  result.noStroke();
  result.smooth();
  for (int i=0;i<3;i++) {
    result.fill(0xFF);
    result.triangle(random(width), random(height), random(width), random(height), random(width), random(height));
  }
  result.endDraw();
  return result;
}

class Monster {
  PVector position = new PVector(width/2, height/2);
  float angle = 0;
  float angleDer = 0;  
  float speed = 0;
  float opacity = 0;
  float phase = 0.5;

  int amibPoints = 70;
  int legsSpace = 10;
  float stepsPhase = 0;

  int oscillos = 10;
  float[] oscAmps = new float[oscillos];
  float[] oscFreq = new float[oscillos];
  float[] oscPhas = new float[oscillos];
  float[] oscSpee = new float[oscillos];

  float siz = 35;
  float legsLength = siz*4;

  float maxOpacity = 0xE0;

  Monster() {
    for (int i=0 ; i<oscillos ; i++) {
      oscAmps[i]=random(1);
      oscFreq[i]=floor(random(10));
      oscPhas[i]=0;
      oscSpee[i]=random(-0.1, 0.1);
    }
  }

  void anim() {
    for (int i=0 ; i<oscillos ; i++) {
      oscPhas[i] += oscSpee[i];
    }
    phase = phase + 0.0007;
    if (phase>=1) {
      takePhoto();
      phase=0;
    }
    speed = (1-abs((phase*2)-1))*3*siz/50;
    angleDer += random(-0.001, 0.001);
    angleDer = constrain(angleDer, -0.01, 0.01);
    angle+=angleDer;
    opacity = pow(max(0, (phase*2)-1), 1.5);
    while (angle<0 || angle>=TWO_PI) angle=(angle+TWO_PI)%TWO_PI;
    if (position.x < -siz*2)      position.x += width  + siz*4;
    if (position.y < -siz*2)      position.y += height + siz*4;    
    if (position.x > width+siz*2) position.x -= width  + siz*4;
    if (position.y > height+siz*2)position.y -= height + siz*4;    
    position.x = position.x + speed * cos(angle);
    position.y = position.y + speed * sin(angle);
    stepsPhase = (stepsPhase + speed/15)%TWO_PI;
  }

  void display(PGraphics gr) {
    gr.beginDraw();
    gr.background(0);    
    gr.noStroke();
    gr.fill(opacity*maxOpacity);
    gr.pushMatrix();
    gr.translate(position.x, position.y);
    gr.beginShape();
    for (int i=0;i<amibPoints;i++) {
      float thisSiz = siz;
      float thisPhase = (float)i*TWO_PI/amibPoints;
      float thisMod = 0;
      for (int j=0;j<oscillos;j++) {
        thisMod += (sin(oscPhas[j]+oscFreq[j]*thisPhase)+1)/2*oscAmps[j];
      }
      thisMod /= oscillos;
      thisSiz *= 1+thisMod;
      float legProx=abs(vrMax(i%legsSpace, 0, legsSpace))/legsSpace;
      float legBend = pow(legProx, 5) * sin(thisPhase + stepsPhase);
      thisSiz += pow(legProx, 3)*legsLength;
      gr.vertex(thisSiz*cos(thisPhase) + legBend*10*siz*cos(angle), thisSiz*sin(thisPhase) + legBend*10*siz*sin(angle));
    }
    gr.endShape();
    gr.fill(0);
    float eyesOpening = max(0, (0.10-abs(sqrt(phase) - 0.90))*10);
    gr.ellipse(siz*4/5*cos(angle+0.7), siz*4/5*sin(angle+0.7), siz*1/5, siz*1/5);
    gr.ellipse(siz*4/5*cos(angle-0.7), siz*4/5*sin(angle-0.7), siz*1/5, siz*1/5);
    gr.fill(opacity*maxOpacity);
    gr.ellipse((siz*4/5-eyesOpening*10)*cos(angle+0.7+eyesOpening/2), (siz*4/5-eyesOpening*10)*sin(angle+0.7+eyesOpening/2), siz*2/5, siz*2/5);
    gr.ellipse((siz*4/5-eyesOpening*10)*cos(angle-0.7-eyesOpening/2), (siz*4/5-eyesOpening*10)*sin(angle-0.7-eyesOpening/2), siz*2/5, siz*2/5);
    gr.popMatrix();
    gr.endDraw();
  }
}

public float vrMax(float a, float b, float m) {
  float d1=b-a;
  if (d1>m/2) {
    d1=d1-m;
  }
  if (d1<-m/2) {
    d1=d1+m;
  }
  return d1;
}

