
float boardWidth = 600;
float boardHeight = 400;
float wireLength = boardHeight + dist(0, 0, boardWidth, boardHeight);
float stepLength = 2;
PVector currentLengths = new PVector(wireLength/2, wireLength/2);
PVector targetLengths = new PVector(wireLength/2, wireLength/2);
PVector targetPosition = new PVector(0, 0);

void setup() {
  size(floor(boardWidth), floor(boardHeight));
}

void draw() {
  moveSteppers();
  displayPreview();
}

void displayPreview() {
  background(0x00);
  noFill();
  stroke(0xFF);
  ellipse(0, 0, currentLengths.x*2, currentLengths.x*2);
  ellipse(boardWidth, 0, currentLengths.y*2, currentLengths.y*2);
  noStroke();
  fill(0xFF, 0x00, 0x00);
  ellipse(targetPosition.x, targetPosition.y, 5, 5);
}

PVector lengthsFor(PVector position) {
  float lengthA = dist(0, 0, position.x, position.y);
  float lengthB = dist(boardWidth, 0, position.x, position.y);
  PVector result = new PVector(lengthA, lengthB);
  return result;
}

void keyPressed() {
  targetPosition.x = random(boardWidth);
  targetPosition.y = random(boardHeight);
  updateTargets();
}

void updateTargets() {
  targetLengths = lengthsFor(targetPosition);
}

void runStepper(int number, int direction) {
  if (number==0) {
    currentLengths.x += direction*stepLength;
    // send a step to arduino
  }
  if (number==1) {
    currentLengths.y += direction*stepLength;
    // send a step to arduino
  }
}

void moveSteppers() {
  if (targetLengths.x > currentLengths.x) runStepper(0, 1);
  if (targetLengths.x < currentLengths.x) runStepper(0, -1);
  if (targetLengths.y > currentLengths.y) runStepper(1, 1);
  if (targetLengths.y < currentLengths.y) runStepper(1, -1);
}

