
Shape[] shapes = new Shape[16];
int maxNbLayers=10;

void setup() {
  size(500,500);
  smooth();
  for (int i=0;i<shapes.length;i++) {
    shapes[i] = new Shape();
  }
}

void draw() {
  background(0);
  for (int i=0;i<10;i++) {
    shapes[i].act();
  }
  for (int i2=0;i2<=maxNbLayers;i2++) {    
    for (int i=0;i<10;i++) {      
      shapes[i].display(i2);
    }
  }
}

class Shape {
  int nbLayers = floor(random(maxNbLayers/2)+(maxNbLayers/2));
  float x=random(500);
  float y=random(500);
  float s=random(200)+maxNbLayers*25;
  float xD=random(-10,10);
  float yD=random(-10,10);
  boolean type;

  Shape() {
    if (random(100)<50) {
      type=true;
    }
    else {
      type=false;
    }
  }

  void vary() {
    nbLayers = constrain(nbLayers+round(random(-1,1)),1,maxNbLayers);
    s+=random(-10,10);
    type^=true;
  }

  void display(int layer) {
    if (layer<nbLayers) {
      noStroke();
      fill(float(layer+1)*0xE0/maxNbLayers,float(layer+1)*0xD0/maxNbLayers,float(layer+1)*0xF0/maxNbLayers);
      rect(x+(layer+1)*8-(float)s/2,y+(layer+1)*8-(float)s/2,max(s-(layer+1)*25,0),max(s-(layer+1)*25,0));
    }
  }
  void act() {
    if (type) {
      x=x+xD;
      xD+=((width/2)-x)/500;
    }
    else {
      y=y+yD;
      yD+=((height/2)-y)/500;
    }
    if (random(100)<1) {
      vary();
    }
  }
}

void mousePressed() {
  for (int i=0;i<shapes.length;i++) {
    shapes[i].vary();
  }
}

