
import krister.Ess.*;

AudioChannel[] chan=new AudioChannel[2];
int longSon=100000;
float[] son=new float[longSon];
float[] env=new float[longSon];//volume
float[] env2=new float[longSon];//FM
float[] env3=new float[longSon];//freq

void setup() {
  size(500,200);
  frameRate(30);
  Ess.start(this);
  fill(100);
  stroke(200);

  for (int i=0;i<2;i++) {
    chan[i]=new AudioChannel();
    chan[i].initChannel(1);
  }
  chan[0].play(-1);
  chan[0].initChannel(son.length);
}

void draw() {
  background(0);
  if (mousePressed==true) {
    env2=modifEnv(env2);
  }
  if (mousePressed==false) {  
    if(keyPressed==true) {  
      env3=modifEnv(env3);
    }
    else {
      env=modifEnv(env);
    }
  } 
  dessineEnv(env,#CC00FF);
  dessineEnv(env2,#00FFCC);
  dessineEnv(env3,#FFCC00);
  dessineIndic();
  rendSon();
}

void dessineIndic() {
}

float[] modifEnv(float[] envX) {
  int dep=floor(constrain(mouseX-50,0,width-1)*longSon/width);
  int arr=floor(constrain(mouseX+50,0,width-1)*longSon/width);
  int eca=arr-dep;
  for (int i=dep;i<arr;i++) {
    float valeur=0;
    float fade1=constrain((((float)eca/2)-(i-(float)dep))/((float)eca/2),0,1);
    float fade2=constrain(((i-(float)dep)-((float)eca/2))/((float)eca/2),0,1);
    float reste=1-fade1-fade2;
    valeur+=envX[i]*(fade1+fade2);
    valeur+=((height-(float)mouseY)/height)*reste;
    envX[i]=valeur;
  }
  return envX;
}

void dessineEnv(float[] envX,color cou) {
  stroke(cou);
  for (int x=0;x<width-1;x++) {
    line(x,height-envX[floor((float)x*longSon/width)]*height,x+1,height-envX[floor((float)(x+1)*longSon/width)]*height);
  }
}

void rendSon() {
  for (int i=0;i<son.length;i++) {
    float sinu=(float)i/((1-env3[i])*100);
    float modu=sin(sinu*env2[i]*20);
    son[i]=sin(sinu+modu/2)*env[i];
  }
}

void audioChannelLoop(AudioChannel ch) {
  ch.samples=son;
}

public void stop() {
  Ess.stop();
  super.stop();
}

