
int nbJ=30;
int nbK=30;
int nbL=90;

int[][][] type = new int[nbJ][nbK][nbL];

int nbBriques=10;
int offX=245;
int offY=500;

int nbBalls=20;
Ball[] balls = new Ball[nbBalls];

PImage[] briques = new PImage[nbBriques];

PImage incrust;

void setup () {
  
  incrust = loadImage("incrust.png");
  
  size(500,800);
  for (int i=0 ; i<nbBriques ; i++) {
    briques[i] = loadImage("brique0"+i+".png");
  }
  for (int i=0;i<nbBalls;i++) {
    balls[i]=new Ball();
  }
  generate();
}

void draw() {
  generate();
  image(incrust,0,0);
  //saveFrame("####.png");
}

void generate() {
  for (int i=0;i<nbBalls;i++) {
    balls[i].move();
  }
  for (int j=0;j<nbJ;j++) {
    for (int k=0;k<nbK;k++) {
      for (int l=0;l<nbL;l++) {
        float thisProx=0;
        for (int i=0;i<nbBalls;i++) {
          thisProx+=balls[i].proxFrom(j,k,l);
        }
        thisProx*=35;
        thisProx=constrain(thisProx,0,2);
        type[j][k][l] = floor(thisProx);
        if (type[j][k][l]==1) type[j][k][l]=0;
      }
    }
  }
  for (int j=0;j<nbJ;j++) {
    for (int k=0;k<nbK;k++) {
      for (int l=0;l<nbL;l++) {
        //        if (l>70 && l<75) {
        //          if (type[max(j-1,0)][k][l]!=0 && type[j][max(k-1,0)][l]!=0) type[j][k][l] = floor(4 + random(nbBriques-4));
        //        }        
        if (type[j][k][l]!=0) {
          if (type[j][k][(l+1)%nbL]==0) type[j][k][l] = 3;
          if (type[j][k][(l-1+nbL)%nbL]==0) type[j][k][l] = 4;
          //          if (l>70 && l<75)type[j][k][l] = floor(4 + random(4));
          //          if (l==nbL-1 && random(100)<5) type[j][k][l] = floor(8 + random(2));
        }
        if (l<50 && type[j][k][l]>0) type[j][k][l]=1;
      }
    }
  }  
  background(0x00,0x34,0x51);
  for (int l=0;l<nbL;l++) {
    for (int j=0;j<nbJ;j++) {
      for (int k=0;k<nbK;k++) {        
        image(briques[type[j][k][l]],offX+j*8-k*8,offY+j*4+k*4-l*4);
      }
    }
  }
}

class Ball {
  float j;
  float k;
  float l;
  float s;
  int jD=1;
  int kD=1;
  int lD=0;
  Ball() {
    j=floor(random(nbJ));
    k=floor(random(nbK));
    l=floor(random(nbL));
    s=random(0.1);
  }
  float proxFrom(int thisJ, int thisK, int thisL) {
    float d=sqrt(sq(dist(j,k,thisJ,thisK))+0.1*sq(l-thisL))+1;
    return (s/d);
  }
  void move() {
    j=j+jD;
    k=k+kD;
    l=l+lD;
    if (j==0 || j==nbJ) jD*=-1;
    if (k==0 || k==nbK) kD*=-1;
    if (l==0 || l==nbL) lD*=-1;
  }
}

