 
/**
* This sketch was used to control a mechanical drawing arm.
* use the mouse to point where the arm should draw.
* 
*/

float aX, aY;

float[] angles = new float[4];
float[] dists = new float[4];
int precision = 50;
float nMouseX, nMouseY;

void setup() {
  size(500, 500);
  angles[0]=0;
  angles[1]=0;
  angles[2]=0;
  angles[3]=0;
  dists[0]=65;
  dists[1]=63;
  dists[2]=45;
  dists[3]=25;
  aX = width/2;
  aY = height/2;
}

void draw() {
  background(0);
  float[] directions = new float[4];
  float[] bestDirections = new float[4];
  float bestDistance = -1;
  for (int a=0;a<3;a++) {
    directions[0]=((float)a-1)/precision;
    for (int b=0;b<3;b++) {
      directions[1]=((float)b-1)/precision;
      for (int c=0;c<3;c++) {
        directions[2]=((float)c-1)/precision;
        for (int d=0;d<3;d++) {
          directions[3]=((float)d-1)/precision;
          PVector unPoint = getFinalPosFor(directions);
          if (bestDistance==-1 || sq(unPoint.x-aX) + sq(unPoint.y-aY)<bestDistance) {
            bestDirections[0]=directions[0];
            bestDirections[1]=directions[1];
            bestDirections[2]=directions[2];
            bestDirections[3]=directions[3];
            bestDistance = sq(unPoint.x-aX) + sq(unPoint.y-aY);
          }
        }
      }
    }
  }
  stroke(0xFF);
  PVector unPoint = getFinalPosFor(bestDirections);
  ellipse(unPoint.x, unPoint.y, 10, 10);
  float cX=width/2;
  float cY=height/2;  
  for (int i=0;i<4;i++) {
    float ncX = cX + dists[i] * cos(angles[i]);
    float ncY = cY + dists[i] * sin(angles[i]);
    stroke(0xFF, 0, 0);
    line(cX, cY, ncX, ncY);
    cX=ncX;
    cY=ncY;
  }
  for (int i=0;i<4;i++) {
    angles[i] += bestDirections[i];
  }
  if (keys[RIGHT]) aX++;
  if (keys[LEFT])  aX--;
  if (keys[UP])    aY--;
  if (keys[DOWN])  aY++;
  if (mouseX!=nMouseX || mouseY!=nMouseY) {
    aX = nMouseX = mouseX;
    aY = nMouseY = mouseY;
  }
}

PVector getFinalPosFor(float[] directions) {
  float cX = width/2;
  float cY = height/2;  
  for (int i=0;i<4;i++) {
    float ncX = cX + dists[i] * cos(angles[i]+directions[i]);
    float ncY = cY + dists[i] * sin(angles[i]+directions[i]);
    cX=ncX;
    cY=ncY;
  }
  PVector result = new PVector(cX, cY);
  return result;
}

boolean[] keys = new boolean[0xFF];

void keyPressed() {
  keys[keyCode]=true;
}

void keyReleased() {
  keys[keyCode]=false;
}


