
Bras[] bras = new Bras[100];

void setup() {
  smooth();
  frameRate(50);
  size(500,500);
  stroke(0xFF,0x05,0x10);
  for (int i=0;i<bras.length;i++) {
    bras[i]=new Bras();
  }
}

void draw() {  
  background(0);
  for (int i=0;i<bras.length;i++) {
    bras[i].act();
  }
}


class Bras {
  float accrocheX;
  float accrocheY;  

  int nbParts = floor(random(15))+5;
  float[] angles = new float[nbParts];
  boolean[] directions = new boolean[nbParts];
  float previousDistance=0;
  float speed=0;

  Bras() {
    if (random(100)<50) {
      if (random(100)<50) {
        accrocheX=-10;
        accrocheY=random(height);
      }
      else {
        accrocheX=width+10;
        accrocheY=random(height);
      }
    }
    else {          
      if (random(100)<50) {
        accrocheX=random(width);
        accrocheY=-10;
      }
      else {
        accrocheX=random(width);
        accrocheY=height+10;
      }
    }
    for (int i=0;i<nbParts;i++) {
      angles[i]=random(TWO_PI);
    }
  }

  void act() {
    float cX=accrocheX;
    float cY=accrocheY;
    for (int part=0;part<nbParts;part++) {
      if (directions[part]) {
        angles[part]+=speed;
      }
      else {
        angles[part]-=speed;
      }    
      float cX2=cX;
      float cY2=cY;    
      for (int i=0;i<nbParts;i++) {
        cX2=cX2+cos(angles[i])*(nbParts-i+3);
        cY2=cY2+sin(angles[i])*(nbParts-i+3);
      }  
      if(dist(mouseX,mouseY,cX2,cY2)>previousDistance) {
        directions[part]=directions[part]^true;
      }
    }

    for (int i=0;i<nbParts;i++) {
      float cX2=cX+cos(angles[i])*(nbParts-i+3);
      float cY2=cY+sin(angles[i])*(nbParts-i+3);
      strokeWeight((nbParts-i+3)/2);
      line(cX,cY,cX2,cY2);
      cX=cX2;
      cY=cY2;
    }

    previousDistance=dist(mouseX,mouseY,cX,cY);
    speed=abs(atan2(cY-accrocheY,cX-accrocheX)-atan2(mouseY-accrocheY,mouseX-accrocheX))/100+previousDistance/10000;
    if (previousDistance<5 || previousDistance>200) speed=0;
  }
}

