
class Member {

  String name;
  ArrayList<Behaviour> behaviours  = new ArrayList<Behaviour>();
  ArrayList<String> tags = new ArrayList<String>();

  PImage pic;

  PApplet parent;

  Member(PApplet parent, String name) {
    this.parent=parent;
    this.name=name;
  }

  void setPic(PImage pic) {
    for (int i=0;i<behaviours.size();i++) behaviours.get(i).setPic(pic);
  }

  void extract(color backColor, float threshold) {
    for (int i=0;i<behaviours.size();i++) behaviours.get(i).extract(backColor, threshold);
  }

  void draw() {
    for (int i=0;i<behaviours.size();i++) behaviours.get(i).draw();
  }

  void move() {
    for (int i=0;i<behaviours.size();i++) behaviours.get(i).move();
  }

  void setPosition(float x, float y, float w, float h) {
    for (int i=0;i<behaviours.size();i++) behaviours.get(i).setPosition(x, y, w, h);
  }

  PVector getPosition() {
    for (int i=0;i<behaviours.size();i++) {
      PVector thisResult = behaviours.get(i).getPosition();
      if (thisResult!=null) return thisResult;
    }
    return null;
  }

  void setAnchor(Member grabbed, int grabbedIndex, int grabberIndex) {
    for (int i=0;i<behaviours.size();i++) behaviours.get(i).setAnchor(grabbed, grabbedIndex, grabberIndex);
  }

  PVector getAnchor(int index) {
    for (int i=0;i<behaviours.size();i++) {
      PVector thisResult = behaviours.get(i).getAnchor(index);
      if (thisResult!=null) return thisResult;
    }
    return null;
  }

  void setInertia(float inertia) {
    for (int i=0;i<behaviours.size();i++) behaviours.get(i).setInertia(inertia);
  }

  void transformPic(int type) {
    for (int i=0;i<behaviours.size();i++) behaviours.get(i).transformPic(type);
  }

  void setRotation(float rot) {
    for (int i=0;i<behaviours.size();i++) behaviours.get(i).setRotation(rot);
  }
  void setBaseRotation(float rot) {
    for (int i=0;i<behaviours.size();i++) behaviours.get(i).setBaseRotation(rot);
  }

  void setRelativeRotation(boolean b) {
    for (int i=0;i<behaviours.size();i++) behaviours.get(i).setRelativeRotation(b);
  }

  void setDirection(PVector dir) {
    for (int i=0;i<behaviours.size();i++) behaviours.get(i).setDirection(dir);
  }

  PVector getDirection() {
    for (int i=0;i<behaviours.size();i++) {
      PVector thisResult = behaviours.get(i).getDirection();
      if (thisResult!=null) return thisResult;
    }
    return null;
  }

  float getRotation() {
    for (int i=0;i<behaviours.size();i++) {
      Float thisResult = behaviours.get(i).getRotation();
      if (thisResult!=null) return thisResult.value;
    }
    return 0;
  }

  PVector[] getAnchors() {
    for (int i=0;i<behaviours.size();i++) {
      PVector[] thisResult = behaviours.get(i).getAnchors();
      if (thisResult!=null) return thisResult;
    }
    return null;
  }

  boolean hasTag(String check) {
    for (int i=0;i<tags.size();i++) if (check.equals(tags.get(i))) return true;
    return false;
  }

  void setParallax(float p) {
    for (int i=0;i<behaviours.size();i++) behaviours.get(i).setParallax(p);
  }

  void commitSize() {
    for (int i=0;i<behaviours.size();i++) behaviours.get(i).commitSize();
  }

  void scalePic(float s) {
    for (int i=0;i<behaviours.size();i++) behaviours.get(i).scalePic(s);
  }

  ArrayList<Member> generateLevelObjects() {
    for (int i=0;i<behaviours.size();i++) {
      ArrayList<Member> thisResult = behaviours.get(i).generateLevelObjects();
      if (thisResult!=null) return thisResult;
    }
    return null;
  }

  boolean hasCollisionMask() {
    for (int i=0;i<behaviours.size();i++) {
      if (behaviours.get(i).hasCollisionMask()) return true;
    }
    return false;
  }

  float getCollisionRadius() {
    for (int i=0;i<behaviours.size();i++) {
      Float thisResult = behaviours.get(i).getCollisionRadius();
      if (thisResult!=null) return thisResult.value;
    }
    return 0;
  }

  void computeRadius() {
    for (int i=0;i<behaviours.size();i++) behaviours.get(i).computeRadius();
  }

  void setCollisionsChecks(boolean a, boolean b) {
    for (int i=0;i<behaviours.size();i++) behaviours.get(i).setCollisionsChecks(a, b);
  }

  void setGravityAmount(float g) {
    for (int i=0;i<behaviours.size();i++) behaviours.get(i).setGravityAmount(g);
  }

  void exportData() {
    for (int i=0;i<behaviours.size();i++) behaviours.get(i).exportData();
  }

  void setAnchors(PVector[] anchor) {
    for (int i=0;i<behaviours.size();i++) behaviours.get(i).setAnchors(anchor);
  }

  void setRadius(float radius) {
    for (int i=0;i<behaviours.size();i++) behaviours.get(i).setRadius(radius);
  }
  
  boolean isCollidingWith(Member m) {
    for (int i=0;i<behaviours.size();i++) {
      if (behaviours.get(i).isCollidingWith(m)) return true;
    }
    return false;
  }
  
}

Member getMemberByName(ArrayList<Member> members, String name) {
  for (int i=0;i<members.size();i++) {
    if (members.get(i).name.equals(name)) return members.get(i);
  }
  return null;
}

