
int wS=100;
int hS=100;
int[][] type;
int state=0;
int cellSize=3;
float densityPercentage=27;

void setup() {
  size(wS*cellSize, hS*cellSize);
  frameRate(30);
  type = new int[wS][hS];
  int currentIndex=0;
  for (int x=0;x<wS;x++) {
    for (int y=0;y<hS;y++) {
      type[x][y] = (random(100)>densityPercentage)?0:currentIndex++%3+1;
    }
  }
  noStroke();
}

void draw() {
  int[][] nextType = new int[wS][hS];
  for (int x=0;x<wS;x++) {
    for (int y=0;y<hS;y++) {
      if (type[x][y]!=0&&type[x][y]!=state+1) nextType[x][y]=type[x][y];
      if (state==0) {
        if (type[x][y]==1) nextType[x][y]=(type[x][(y+2)%hS]==0)?0:1;
        if (type[x][y]==0) nextType[x][y]=(type[x][(y-2+hS)%hS]==1)?1:0;
      }
      if (state==1) {
        if (type[x][y]==2) nextType[x][y]=(type[(x+1)%wS][y]==0)?0:2;
        if (type[x][y]==0) nextType[x][y]=(type[(x-1+wS)%wS][y]==2)?2:0;
      }
      if (state==2) {
        if (type[x][y]==3) nextType[x][y]=(type[(x+1)%wS][(y+1)%hS]==0)?0:3;
        if (type[x][y]==0) nextType[x][y]=(type[(x-1+wS)%wS][(y-1+hS)%hS]==3)?3:0;
      }
    }
  }
  type=nextType;
  state=(state+1)%3;
  background(0xFF);
  for (int t=0;t<3;t++) {
    fill((t==0)?0xFF:0, (t==1)?0xFF:0, (t==2)?0xFF:0);
    for (int x=0;x<wS;x++) {
      for (int y=0;y<hS;y++) {
        if (type[x][y]==t+1) {
          rect(x*cellSize, y*cellSize, cellSize, cellSize);
        }
      }
    }
  }
}


