
ArrayList Polygonise(Gridcell grid, float isolevel)
{
  int i;
  int cubeindex;
  PVector[] vertlist = new PVector[12];
  ArrayList triangles = new ArrayList();

  /*
      Determine the index into the edge table which
   tells us which vertices are inside of the surface
   */
  cubeindex = 0;
  if (grid.val[0] < isolevel) cubeindex |= 1;
  if (grid.val[1] < isolevel) cubeindex |= 2;
  if (grid.val[2] < isolevel) cubeindex |= 4;
  if (grid.val[3] < isolevel) cubeindex |= 8;
  if (grid.val[4] < isolevel) cubeindex |= 16;
  if (grid.val[5] < isolevel) cubeindex |= 32;
  if (grid.val[6] < isolevel) cubeindex |= 64;
  if (grid.val[7] < isolevel) cubeindex |= 128;

  /* Cube is entirely in/out of the surface */
  if (edgeTable[cubeindex] == 0) {
    ArrayList noTriangle = new ArrayList(0);
    return noTriangle;
  }

  /* Find the vertices where the surface intersects the cube */
  if ((edgeTable[cubeindex] & 1)!=0) vertlist[0] = VertexInterp(isolevel,grid.p[0],grid.p[1],grid.val[0],grid.val[1]);
  if ((edgeTable[cubeindex] & 2)!=0) vertlist[1] = VertexInterp(isolevel,grid.p[1],grid.p[2],grid.val[1],grid.val[2]);
  if ((edgeTable[cubeindex] & 4)!=0) vertlist[2] = VertexInterp(isolevel,grid.p[2],grid.p[3],grid.val[2],grid.val[3]);
  if ((edgeTable[cubeindex] & 8)!=0) vertlist[3] = VertexInterp(isolevel,grid.p[3],grid.p[0],grid.val[3],grid.val[0]);
  if ((edgeTable[cubeindex] & 16)!=0) vertlist[4] = VertexInterp(isolevel,grid.p[4],grid.p[5],grid.val[4],grid.val[5]);
  if ((edgeTable[cubeindex] & 32)!=0) vertlist[5] = VertexInterp(isolevel,grid.p[5],grid.p[6],grid.val[5],grid.val[6]);
  if ((edgeTable[cubeindex] & 64)!=0) vertlist[6] = VertexInterp(isolevel,grid.p[6],grid.p[7],grid.val[6],grid.val[7]);
  if ((edgeTable[cubeindex] & 128)!=0) vertlist[7] = VertexInterp(isolevel,grid.p[7],grid.p[4],grid.val[7],grid.val[4]);
  if ((edgeTable[cubeindex] & 256)!=0) vertlist[8] = VertexInterp(isolevel,grid.p[0],grid.p[4],grid.val[0],grid.val[4]);
  if ((edgeTable[cubeindex] & 512)!=0) vertlist[9] = VertexInterp(isolevel,grid.p[1],grid.p[5],grid.val[1],grid.val[5]);
  if ((edgeTable[cubeindex] & 1024)!=0) vertlist[10] = VertexInterp(isolevel,grid.p[2],grid.p[6],grid.val[2],grid.val[6]);
  if ((edgeTable[cubeindex] & 2048)!=0) vertlist[11] = VertexInterp(isolevel,grid.p[3],grid.p[7],grid.val[3],grid.val[7]);

  /* Create the triangle */
  for (i=0;triTable[cubeindex][i]!=-1;i+=3) {
    PVector[] thisTriangle = new PVector[3];
    thisTriangle[0] = vertlist[triTable[cubeindex][i+0]];
    thisTriangle[1] = vertlist[triTable[cubeindex][i+1]];
    thisTriangle[2] = vertlist[triTable[cubeindex][i+2]];
    triangles.add(thisTriangle);
  }

  return triangles;
}

PVector VertexInterp(float isolevel, PVector p1, PVector p2, float valp1, float valp2)
{
  if (abs((float)(isolevel-valp1)) < 0.00001) return(p1);
  if (abs((float)(isolevel-valp2)) < 0.00001) return(p2);
  if (abs((float)(valp1-valp2)) < 0.00001)    return(p1);
  float mu = (isolevel - valp1) / (valp2 - valp1);
  PVector p = new PVector();
  p.x = (float)( p1.x + mu * (p2.x - p1.x));
  p.y = (float)( p1.y + mu * (p2.y - p1.y));
  p.z = (float)( p1.z + mu * (p2.z - p1.z));

  return p;
}

class Gridcell {

  PVector[] p = new PVector[8];
  float[] val = new float[8];

  Gridcell(PVector[] p, float[] val) {
    this.p=p;
    this.val=val;
  }
}

