
import krister.Ess.*;

AudioFile myFile;
AudioChannel chan;

int sizy=200;
int sizx=1000;
int longueur= 100000;
float[] chaine = new float[longueur];

int longEnv=1000;
float[] env1=new float[longEnv];
float[] env2=new float[longEnv];
float[] env3=new float[longEnv];

void setup() {
  size(sizx, sizy);
  Ess.start(this);  
  chan= new AudioChannel();
  chan.initChannel(longueur);  
  myFile=new AudioFile();
  initEnv();
  setCourbe();
}

void draw() {
  background(0);  
  drawEnv();
  affiche();
}

void keyPressed() {
  if (keyCode==ENTER || keyCode==RETURN) {
    setCourbe();
  }
  if (keyCode==TAB) {
    setTheSound();
  }
}

void setCourbe() {
  float change=0;
  float attenu=10000;
  for (int i=1; i<longueur;i++) {
    float freq=env2[floor((float)i/longueur*longEnv)]*10000+1;
    float randTaux=env1[floor((float)i/longueur*longEnv)]+0.0001;
    change+=random(-randTaux,randTaux);
    change-=chaine[i-1]/freq;
    chaine[i]=chaine[i-1]+change;
  }
  //normalize
  float valMax=0;
  for (int i=0; i<longueur;i++) {
    valMax=max(valMax,abs(chaine[i]));
  }
  for (int i=0; i<longueur;i++) {
    chaine[i]/=valMax;
  }
}

void affiche() {
  stroke(255);
  for (int i=0; i<longueur;i++) {
    point((float)i/longueur*sizx,(sizy/2)+(chaine[i]*(sizy/2)));
  }
}

public void stop() {
  Ess.stop();
  super.stop();
}

void setTheSound() {
  for (int i=0;i<longueur;i++) {
    chan.samples[i]=chaine[i];
  }
  myFile.open("sample.wav",44100,Ess.WRITE);
  myFile.write(chan);
  myFile.close();
}

void initEnv() {
  for (int i=0;i<longEnv;i++) {
    env1[i]=env2[i]=0.5;
  }
}

void drawEnv() {
  if (mousePressed==true) {
    if (mouseButton==LEFT) {
      env2=modifEnv(env2);
    }
    else{     
      env1=modifEnv(env1);
    }
  }
  if(keyPressed==true && keyCode==CONTROL) {
    env3=modifEnv(env3);
  }  
  dessineEnv(env1,color(127,0,255));
  dessineEnv(env2,color(0,127,255));
  dessineEnv(env3,color(255,127,0));
}

float[] modifEnv(float[] envX) {
  int dep=floor(constrain(mouseX-50,0,width-1)*longEnv/width);
  int arr=floor(constrain(mouseX+50,0,width-1)*longEnv/width);
  int eca=arr-dep;
  for (int i=dep;i<arr;i++) {
    float valeur=0;
    float fade1=constrain((((float)eca/2)-(i-(float)dep))/((float)eca/2),0,1);
    float fade2=constrain(((i-(float)dep)-((float)eca/2))/((float)eca/2),0,1);
    float reste=1-fade1-fade2;
    valeur+=envX[i]*(fade1+fade2);
    valeur+=((height-(float)mouseY)/height)*reste;
    envX[i]=valeur;
  }
  return envX;
}

void dessineEnv(float[] envX,color cou) {
  stroke(cou);
  for (int x=0;x<width-1;x++) {
    line(x,height-envX[floor((float)x*longEnv/width)]*height,x+1,height-envX[floor((float)(x+1)*longEnv/width)]*height);
  }
}















